/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import RTC.ConnectorProfile;
import RTC.ConnectorProfileHolder;
import RTC.PortInterfacePolarity;
import RTC.ReturnCode_t;
import _SDOPackage.NVListHolder;
import _SDOPackage.NameValue;
import java.util.Iterator;
import java.util.Vector;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.port.CorbaConsumerBase;
import jp.go.aist.rtm.RTC.port.PortBase;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.ORBUtil;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.StringHolder;
import jp.go.aist.rtm.RTC.util.operatorFunc;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.ObjectHelper;
import org.omg.CORBA.TCKind;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class CorbaPort
extends PortBase {
    Vector<CorbaProviderHolder> m_providers = new Vector();
    Vector<CorbaConsumerHolder> m_consumers = new Vector();
    protected Logbuf rtcout;
    protected Properties m_properties = new Properties();

    public CorbaPort(String string) {
        super(string);
        this.addProperty("port.port_type", "CorbaPort", String.class);
        this.rtcout = new Logbuf("CorbaPort");
    }

    public void init(Properties properties) {
        this.rtcout.println(2, "init()");
        this.rtcout.println(0, "given properties:");
        String string = new String();
        string = properties._dump(string, properties, 0);
        this.rtcout.println(3, string);
        this.m_properties.merge(properties);
        this.rtcout.println(0, "updated properties:");
        string = this.m_properties._dump(string, this.m_properties, 0);
        this.rtcout.println(3, string);
        int n = -1;
        String string2 = this.m_properties.getProperty("connection_limit", "-1");
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            this.rtcout.println(6, "invalid connection_limit value: " + string2);
        }
        this.setConnectionLimit(n);
    }

    public boolean registerProvider(String string, String string2, Servant servant) throws ServantAlreadyActive, WrongPolicy, ObjectNotActive {
        this.rtcout.println(2, "registerProvider(instance=" + string + ",type_name=" + string2 + ")");
        try {
            this.m_providers.add(new CorbaProviderHolder(string2, string, servant));
        }
        catch (Exception exception) {
            this.rtcout.println(6, "appending provider interface failed");
            return false;
        }
        return this.appendInterface(string, string2, PortInterfacePolarity.PROVIDED);
    }

    public boolean registerConsumer(String string, String string2, CorbaConsumerBase corbaConsumerBase) {
        this.rtcout.println(2, "registerConsumer()");
        if (!this.appendInterface(string, string2, PortInterfacePolarity.REQUIRED)) {
            return false;
        }
        this.m_consumers.add(new CorbaConsumerHolder(string2, string, corbaConsumerBase));
        return true;
    }

    @Override
    public void activateInterfaces() {
        Iterator<CorbaProviderHolder> iterator = this.m_providers.iterator();
        while (iterator.hasNext()) {
            iterator.next().activate();
        }
    }

    @Override
    public void deactivateInterfaces() {
        Iterator<CorbaProviderHolder> iterator = this.m_providers.iterator();
        while (iterator.hasNext()) {
            iterator.next().deactivate();
        }
    }

    @Override
    protected ReturnCode_t publishInterfaces(ConnectorProfileHolder connectorProfileHolder) {
        CharSequence charSequence;
        this.rtcout.println(2, "publishInterfaces()");
        ReturnCode_t returnCode_t = this._publishInterfaces();
        if (returnCode_t != ReturnCode_t.RTC_OK) {
            return returnCode_t;
        }
        NVListHolder nVListHolder = new NVListHolder();
        for (CorbaProviderHolder object2 : this.m_providers) {
            charSequence = new StringBuffer(this.m_profile.name);
            ((StringBuffer)charSequence).insert(this.m_ownerInstanceName.length(), ".port");
            ((StringBuffer)charSequence).append(".provided." + object2.descriptor());
            String string = ((StringBuffer)charSequence).substring(0);
            CORBA_SeqUtil.push_back(nVListHolder, NVUtil.newNVString(string, object2.ior()));
            String string2 = new String();
            string2 = string2 + "port." + object2.descriptor();
            CORBA_SeqUtil.push_back(nVListHolder, NVUtil.newNVString(string2, object2.ior()));
        }
        NVListHolder nVListHolder2 = new NVListHolder(connectorProfileHolder.value.properties);
        CORBA_SeqUtil.push_back_list(nVListHolder2, nVListHolder);
        connectorProfileHolder.value.properties = nVListHolder2.value;
        charSequence = new String();
        charSequence = NVUtil.toString(nVListHolder);
        this.rtcout.println(3, (String)charSequence);
        return ReturnCode_t.RTC_OK;
    }

    @Override
    protected ReturnCode_t subscribeInterfaces(ConnectorProfileHolder connectorProfileHolder) {
        java.lang.Object object;
        Any any;
        this.rtcout.println(2, "subscribeInterfaces()");
        NVListHolder nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
        ORB oRB = ORBUtil.getOrb();
        boolean bl = false;
        int n = NVUtil.find_index(nVListHolder, "port.connection.strictness");
        if (n >= 0) {
            any = nVListHolder.value[n].value;
            object = null;
            object = any.type().kind() == TCKind.tk_wstring ? any.extract_wstring() : (any.type().kind() == TCKind.tk_string ? any.extract_string() : any.extract_Value().toString());
            if (((String)object).equals("best_effort")) {
                bl = false;
            } else if (((String)object).equals("strict")) {
                bl = true;
            }
            this.rtcout.println(3, "Connetion strictness is: " + (String)object);
        }
        any = this.m_consumers.iterator();
        while (any.hasNext()) {
            object = new StringHolder();
            CorbaConsumerHolder corbaConsumerHolder = (CorbaConsumerHolder)any.next();
            if (this.findProvider(nVListHolder, corbaConsumerHolder, (StringHolder)object)) {
                this.setObject(((StringHolder)object).value, corbaConsumerHolder);
                continue;
            }
            if (this.findProviderOld(nVListHolder, corbaConsumerHolder, (StringHolder)object)) {
                this.setObject(((StringHolder)object).value, corbaConsumerHolder);
                continue;
            }
            if (!bl) continue;
            this.rtcout.println(6, "subscribeInterfaces() failed.");
            return ReturnCode_t.RTC_ERROR;
        }
        this.rtcout.println(2, "subscribeInterfaces() successfully finished.");
        return ReturnCode_t.RTC_OK;
    }

    @Override
    protected void unsubscribeInterfaces(ConnectorProfile connectorProfile) {
        this.rtcout.println(2, "unsubscribeInterfaces()");
        NVListHolder nVListHolder = new NVListHolder(connectorProfile.properties);
        this.rtcout.println(3, NVUtil.toString(nVListHolder));
        Iterator<CorbaConsumerHolder> iterator = this.m_consumers.iterator();
        while (iterator.hasNext()) {
            StringHolder stringHolder = new StringHolder();
            CorbaConsumerHolder corbaConsumerHolder = iterator.next();
            if (this.findProvider(nVListHolder, corbaConsumerHolder, stringHolder)) {
                this.rtcout.println(3, "Correspoinding consumer found.");
                this.releaseObject(stringHolder.value, corbaConsumerHolder);
                continue;
            }
            if (!this.findProviderOld(nVListHolder, corbaConsumerHolder, stringHolder)) continue;
            this.rtcout.println(3, "Correspoinding consumer found.");
            this.releaseObject(stringHolder.value, corbaConsumerHolder);
        }
        CORBA_SeqUtil.for_each(nVListHolder, (operatorFunc)new unsubscribe(this.m_consumers));
        connectorProfile.properties = nVListHolder.value;
    }

    private boolean findProvider(NVListHolder nVListHolder, CorbaConsumerHolder corbaConsumerHolder, StringHolder stringHolder) {
        StringBuffer stringBuffer = new StringBuffer(this.m_profile.name);
        stringBuffer.insert(this.m_ownerInstanceName.length(), ".port");
        stringBuffer.append(".required." + corbaConsumerHolder.descriptor());
        String string = stringBuffer.substring(0);
        int n = NVUtil.find_index(nVListHolder, string);
        if (n < 0) {
            return false;
        }
        String string2 = null;
        string2 = nVListHolder.value[n].value.type().kind() == TCKind.tk_wstring ? nVListHolder.value[n].value.extract_wstring() : (nVListHolder.value[n].value.type().kind() == TCKind.tk_string ? nVListHolder.value[n].value.extract_string() : nVListHolder.value[n].value.extract_Value().toString());
        int n2 = NVUtil.find_index(nVListHolder, string2);
        if (n2 < 0) {
            return false;
        }
        String string3 = null;
        string3 = nVListHolder.value[n2].value.type().kind() == TCKind.tk_wstring ? nVListHolder.value[n2].value.extract_wstring() : (nVListHolder.value[n2].value.type().kind() == TCKind.tk_string ? nVListHolder.value[n2].value.extract_string() : nVListHolder.value[n2].value.extract_Value().toString());
        stringHolder.value = string3;
        this.rtcout.println(2, "interface matched with new descriptor:" + string);
        return true;
    }

    private boolean findProviderOld(NVListHolder nVListHolder, CorbaConsumerHolder corbaConsumerHolder, StringHolder stringHolder) {
        String string = "port.";
        int n = NVUtil.find_index(nVListHolder, string = string + corbaConsumerHolder.descriptor());
        if (n < 0) {
            return false;
        }
        String string2 = null;
        string2 = nVListHolder.value[n].value.type().kind() == TCKind.tk_wstring ? nVListHolder.value[n].value.extract_wstring() : (nVListHolder.value[n].value.type().kind() == TCKind.tk_string ? nVListHolder.value[n].value.extract_string() : nVListHolder.value[n].value.extract_Value().toString());
        stringHolder.value = string2;
        this.rtcout.println(4, "interface matched with old descriptor:" + string);
        return true;
    }

    private boolean setObject(String string, CorbaConsumerHolder corbaConsumerHolder) {
        if (string.equals("null")) {
            return true;
        }
        if (string.equals("nil")) {
            return true;
        }
        if (string.indexOf("IOR:") != 0) {
            return false;
        }
        if (!corbaConsumerHolder.setObject(string)) {
            this.rtcout.println(6, "Cannot narrow reference");
            return false;
        }
        if (!corbaConsumerHolder.setObject(string)) {
            this.rtcout.println(6, "Cannot narrow reference");
            return false;
        }
        this.rtcout.println(2, "setObject() done");
        return true;
    }

    private boolean releaseObject(String string, CorbaConsumerHolder corbaConsumerHolder) {
        if (string == corbaConsumerHolder.getIor()) {
            corbaConsumerHolder.releaseObject();
            this.rtcout.println(3, "Consumer " + corbaConsumerHolder.descriptor() + " released.");
            return true;
        }
        this.rtcout.println(5, "IORs between Consumer and Connector are different.");
        return false;
    }

    private class unsubscribe
    implements operatorFunc {
        public Vector<CorbaConsumerHolder> m_consumers;

        public unsubscribe(Vector<CorbaConsumerHolder> vector) {
            this.m_consumers = vector;
        }

        @Override
        public void operator(java.lang.Object object) {
            this.operator((NameValue)object);
        }

        public void operator(NameValue nameValue) {
            for (CorbaConsumerHolder corbaConsumerHolder : this.m_consumers) {
                String string = nameValue.name;
                if (!corbaConsumerHolder.descriptor().equals(nameValue.name)) continue;
                corbaConsumerHolder.releaseObject();
            }
        }
    }

    private class subscribe
    implements operatorFunc {
        private Vector<Consumer> m_cons;
        private int m_len;

        public subscribe(Vector<Consumer> vector) {
            this.m_cons = new Vector<Consumer>(vector);
            this.m_len = vector.size();
        }

        @Override
        public void operator(java.lang.Object object) {
            this.operator((NameValue)object);
        }

        public void operator(NameValue nameValue) {
            for (int i = 0; i < this.m_len; ++i) {
                if (!this.m_cons.get((int)i).name.equals(nameValue.name)) continue;
                try {
                    Object object = ObjectHelper.extract((Any)nameValue.value);
                    if (object == null) continue;
                    this.m_cons.get((int)i).consumer.setObject(object);
                    continue;
                }
                catch (BAD_OPERATION bAD_OPERATION) {
                    // empty catch block
                }
            }
        }
    }

    private class Consumer {
        public String name;
        public CorbaConsumerBase consumer;

        public Consumer(String string, String string2, CorbaConsumerBase corbaConsumerBase) {
            this.name = "port." + string2 + "." + string;
            this.consumer = corbaConsumerBase;
        }

        public Consumer(Consumer consumer) {
            this.name = consumer.name;
            this.consumer = consumer.consumer;
        }
    }

    private class CorbaConsumerHolder {
        private String m_typeName;
        private String m_instanceName;
        private CorbaConsumerBase m_consumer;
        private String m_ior;

        public CorbaConsumerHolder(String string, String string2, CorbaConsumerBase corbaConsumerBase) {
            this.m_typeName = string;
            this.m_instanceName = string2;
            this.m_consumer = corbaConsumerBase;
            this.m_ior = new String();
        }

        public String instanceName() {
            return this.m_instanceName;
        }

        public String typeName() {
            return this.m_typeName;
        }

        public String descriptor() {
            return this.m_typeName + "." + this.m_instanceName;
        }

        public boolean setObject(String string) {
            this.m_ior = string;
            ORB oRB = ORBUtil.getOrb();
            Object object = oRB.string_to_object(string);
            if (object == null) {
                CorbaPort.this.rtcout.println(6, "Extracted object is nul reference");
                return false;
            }
            return this.m_consumer.setObject(object);
        }

        public void releaseObject() {
            this.m_consumer.releaseObject();
        }

        public final String getIor() {
            return this.m_ior;
        }
    }

    private class CorbaProviderHolder {
        private String m_typeName;
        private String m_instanceName;
        private Servant m_servant;
        private byte[] m_oid;
        private String m_ior;

        public CorbaProviderHolder(String string, String string2, Servant servant) {
            String string3;
            this.m_typeName = string;
            this.m_instanceName = string2;
            this.m_servant = servant;
            this.m_ior = new String();
            try {
                this.m_oid = CorbaPort.this._default_POA().servant_to_id(servant);
            }
            catch (Exception exception) {
                CorbaPort.this.rtcout.println(5, "Exception caught." + exception.toString());
            }
            try {
                CorbaPort.this._default_POA().activate_object_with_id(this.m_oid, servant);
            }
            catch (ServantAlreadyActive servantAlreadyActive) {
            }
            catch (ObjectAlreadyActive objectAlreadyActive) {
            }
            catch (WrongPolicy wrongPolicy) {
                // empty catch block
            }
            Object object = null;
            try {
                object = CorbaPort.this._default_POA().id_to_reference(this.m_oid);
            }
            catch (ObjectNotActive objectNotActive) {
            }
            catch (WrongPolicy wrongPolicy) {
                // empty catch block
            }
            StringBuffer stringBuffer = new StringBuffer("port");
            stringBuffer.append(".").append(string).append(".").append(string2);
            ORB oRB = ORBUtil.getOrb();
            this.m_ior = string3 = oRB.object_to_string(object);
            this.deactivate();
        }

        public String instanceName() {
            return this.m_instanceName;
        }

        public String typeName() {
            return this.m_typeName;
        }

        public String ior() {
            return this.m_ior;
        }

        public String descriptor() {
            return this.m_typeName + "." + this.m_instanceName;
        }

        public void activate() {
            try {
                CorbaPort.this._default_POA().activate_object_with_id(this.m_oid, this.m_servant);
            }
            catch (ServantAlreadyActive servantAlreadyActive) {
            }
            catch (ObjectAlreadyActive objectAlreadyActive) {
            }
            catch (WrongPolicy wrongPolicy) {
                // empty catch block
            }
        }

        public void deactivate() {
            try {
                CorbaPort.this._default_POA().deactivate_object(this.m_oid);
            }
            catch (ObjectNotActive objectNotActive) {
            }
            catch (WrongPolicy wrongPolicy) {
                // empty catch block
            }
        }
    }
}

