/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.hrp.joystick;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "JoystickPlugin";
    private static Activator plugin;
    private static final String LINUX_HOME_DIR;
    private static final String WIN_HOME_DIR;
    private static final String LINUX_TMP_DIR;
    private static final String WIN_TMP_DIR;
    private static final File TMP_DIR;

    static {
        LINUX_HOME_DIR = String.valueOf(System.getenv("HOME")) + File.separator;
        WIN_HOME_DIR = String.valueOf(System.getenv("APPDATA")) + File.separator;
        LINUX_TMP_DIR = String.valueOf(LINUX_HOME_DIR) + ".Joystick_aist" + File.separator;
        WIN_TMP_DIR = String.valueOf(WIN_HOME_DIR) + "Joystick_aist" + File.separator;
        TMP_DIR = Activator.initTempDir();
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static String getPath() {
        URL entry = Activator.getDefault().getBundle().getEntry("/");
        String pluginDirectory = "";
        try {
            pluginDirectory = FileLocator.resolve((URL)entry).getPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return pluginDirectory;
    }

    public File getTempDir() {
        return TMP_DIR;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void resourceToFile(Class<Activator> pluginManager, String srcName, File destFile) throws IOException {
        InputStream in = pluginManager.getResourceAsStream(srcName.toString());
        FileOutputStream out = new FileOutputStream(destFile.toString());
        try {
            try {
                int len;
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                in.close();
                ((OutputStream)out).close();
            }
        }
        finally {
            in.close();
            ((OutputStream)out).close();
        }
    }

    private static File createConfigFile() {
        File rtcFile = new File(Activator.getDefault().getTempDir(), "rtc.conf");
        if (!rtcFile.exists()) {
            try {
                Activator.resourceToFile(Activator.class, "/default_rtc.conf", rtcFile);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return rtcFile;
    }

    public static String getConfigFilePath() {
        String confPath = "";
        File defualtRtcFile = new File(Activator.getDefault().getTempDir() + File.separator + "rtc.conf");
        confPath = defualtRtcFile.isFile() ? defualtRtcFile.getPath() : Activator.createConfigFile().getPath();
        System.out.println("[Joystick] default Config File path=" + confPath);
        return confPath;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    private static File initTempDir() {
        File ret = null;
        ret = System.getProperty("os.name").equals("Linux") || System.getProperty("os.name").equals("Mac OS X") ? new File(LINUX_TMP_DIR) : new File(WIN_TMP_DIR);
        if (!ret.exists()) {
            ret.mkdirs();
        }
        return ret;
    }
}

