/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.log;

import java.util.Date;
import java.util.Formatter;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Logbuf {
    public static final int SILENT = 8;
    public static final int FATAL = 7;
    public static final int ERROR = 6;
    public static final int WARN = 5;
    public static final int INFO = 4;
    public static final int DEBUG = 3;
    public static final int TRACE = 2;
    public static final int VERBOSE = 1;
    public static final int PARANOID = 0;
    public static final String SILENT_H = "SILENT   :";
    public static final String FATAL_H = "FATAL    :";
    public static final String ERROR_H = "ERROR    :";
    public static final String WARN_H = "WARN     :";
    public static final String INFO_H = "INFO     :";
    public static final String DEBUG_H = "DEBUG    :";
    public static final String TRACE_H = "TRACE    :";
    public static final String VERBOSE_H = "VERBOSE  :";
    public static final String PARANOID_H = "PARANOID :";
    private static Level rtm_level = null;
    private boolean m_LogLock = false;
    private Logger m_Logger;
    private String m_dateFormat = "%tb %td %tH:%tM:%tS";
    private String m_Suffix = " ";
    private int m_HandlerCount = 0;
    private static boolean m_Enabled = false;

    public Logbuf(String string) {
        String string2;
        this.m_Suffix = string;
        int n = string.indexOf("Manager.");
        if (string.equals("Manager")) {
            string2 = "OpenRTM-aist.logging." + string;
        } else if (n >= 0) {
            this.m_Suffix = this.getLastName(string);
            string2 = "OpenRTM-aist.logging.Manager." + this.m_Suffix;
        } else {
            string2 = "OpenRTM-aist.logging.Manager." + string;
        }
        this.m_Logger = Logger.getLogger(string2);
        this._constructor();
    }

    public Logbuf(String string, String string2) {
        this.m_Suffix = string;
        String string3 = string2.length() == 0 || string2 == null ? "OpenRTM-aist.logging." + string : "OpenRTM-aist.logging." + string2 + "." + string;
        this.m_Logger = Logger.getLogger(string3);
        this._constructor();
    }

    private void _constructor() {
        if (rtm_level == null) {
            for (int i = 0; i <= 8; ++i) {
                int n = this.RTMLevelToLogLevel(i);
                String string = this.logLevelToStr(i);
                rtm_level = new OpenRTMLevel(string, n);
            }
        }
    }

    public void println(int n, String string) {
        if (!m_Enabled) {
            return;
        }
        boolean bl = this.getPrintFlag();
        if (!bl) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder, Locale.US);
        Date date = new Date();
        String string2 = this.logLevelToStr(n);
        Level level = Level.parse(string2);
        this.m_Logger.log(level, formatter.format(this.m_dateFormat, date, date, date, date, date, date, date, date, date, date) + " " + this.m_Suffix + " " + this.logLevelToStr(n) + " " + string);
    }

    private int RTMLevelToLogLevel(int n) {
        int n2;
        if (8 == n) {
            Level level = Level.OFF;
            n2 = level.intValue();
        } else {
            Level level = Level.INFO;
            n2 = level.intValue();
            n2 += n;
        }
        return n2;
    }

    public static int strToLogLevel(String string) {
        if (string.equals("SILENT")) {
            return 8;
        }
        if (string.equals("FATAL")) {
            return 7;
        }
        if (string.equals("ERROR")) {
            return 6;
        }
        if (string.equals("WARN")) {
            return 5;
        }
        if (string.equals("INFO")) {
            return 4;
        }
        if (string.equals("DEBUG")) {
            return 3;
        }
        if (string.equals("TRACE")) {
            return 2;
        }
        if (string.equals("VERBOSE")) {
            return 1;
        }
        if (string.equals("PARANOID")) {
            return 0;
        }
        return 8;
    }

    public void addStream(Handler handler) {
        this.m_Logger.setUseParentHandlers(false);
        handler.setFormatter(new OpenRTMFormatter());
        this.m_Logger.addHandler(handler);
        Handler[] handlerArray = this.m_Logger.getHandlers();
        this.m_HandlerCount = handlerArray.length;
    }

    public void removeStream(Handler handler) {
        this.m_Logger.removeHandler(handler);
        Handler[] handlerArray = this.m_Logger.getHandlers();
        this.m_HandlerCount = handlerArray.length;
    }

    public int getStreamCount() {
        Handler[] handlerArray = this.m_Logger.getHandlers();
        int n = handlerArray.length;
        return n;
    }

    private boolean getPrintFlag() {
        boolean bl = true;
        boolean bl2 = this.m_Logger.getUseParentHandlers();
        Logger logger = this.m_Logger.getParent();
        String string = logger.getName();
        if (bl2 && this.m_HandlerCount == 0 && string.length() == 0) {
            bl = false;
        }
        return bl;
    }

    private String getLastName(String string) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = string.split("\\.");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].trim().equals("")) continue;
            vector.add(stringArray[i].trim());
        }
        String string2 = n == 0 ? new String("") : new String(((String)vector.get(n - 1)).toString());
        return string2;
    }

    public void setLogLock(boolean bl) {
    }

    private String logLevelToStr(int n) {
        if (n == 8) {
            return SILENT_H;
        }
        if (n == 7) {
            return FATAL_H;
        }
        if (n == 6) {
            return ERROR_H;
        }
        if (n == 5) {
            return WARN_H;
        }
        if (n == 4) {
            return INFO_H;
        }
        if (n == 3) {
            return DEBUG_H;
        }
        if (n == 2) {
            return TRACE_H;
        }
        if (n == 1) {
            return VERBOSE_H;
        }
        if (n == 0) {
            return PARANOID_H;
        }
        return SILENT_H;
    }

    public void setLevel(int n) {
        String string = this.logLevelToStr(n);
        Level level = Level.parse(string);
        this.m_Logger.setLevel(level);
    }

    public void setLevel(String string) {
        int n = Logbuf.strToLogLevel(string);
        String string2 = this.logLevelToStr(n);
        Level level = Level.parse(string2);
        this.m_Logger.setLevel(level);
    }

    public void setDateFormat(String string) {
        this.m_dateFormat = string.replace("%", "%t");
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Date date = new Date();
            Formatter formatter = new Formatter(stringBuilder, Locale.US);
            formatter.format(this.m_dateFormat, date, date, date, date, date, date, date, date, date, date);
        }
        catch (IllegalFormatException illegalFormatException) {
            this.m_dateFormat = "%tb %td %tH:%tM:%tS";
            this.println(6, "The specified format is illegal.");
        }
    }

    public Logbuf level(int n) {
        return this;
    }

    public void setEnabled() {
        m_Enabled = true;
    }

    public void setDisabled() {
        m_Enabled = false;
    }

    private class OpenRTMLevel
    extends Level {
        public OpenRTMLevel(String string, int n) {
            super(string, n);
        }
    }

    private class OpenRTMFormatter
    extends java.util.logging.Formatter {
        private OpenRTMFormatter() {
        }

        @Override
        public String format(LogRecord logRecord) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.formatMessage(logRecord));
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }

        @Override
        public String getHead(Handler handler) {
            return "";
        }

        @Override
        public String getTail(Handler handler) {
            return "";
        }
    }
}

