/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Vector;
import jp.go.aist.rtm.RTC.util.Pair;
import jp.go.aist.rtm.RTC.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties {
    private String name;
    private String value;
    private String default_value;
    private Properties root;
    private Vector<Properties> leaf = new Vector();
    private static final String EMPTY = "";

    public Properties() {
        this(EMPTY, EMPTY);
    }

    public Properties(String key) {
        this(key, EMPTY);
    }

    public Properties(String key, String value) {
        this.name = new String(key);
        this.value = new String(value);
        this.default_value = new String(EMPTY);
        this.root = null;
        this.leaf.clear();
    }

    public Properties(Map<String, String> defaults) {
        this.name = new String(EMPTY);
        this.value = new String(EMPTY);
        this.default_value = new String(EMPTY);
        this.root = null;
        this.leaf.clear();
        for (Map.Entry<String, String> entry : defaults.entrySet()) {
            this.setDefault(entry.getKey(), entry.getValue());
        }
    }

    public Properties(String[] defaults) {
        this.name = new String(EMPTY);
        this.value = new String(EMPTY);
        this.default_value = new String(EMPTY);
        this.root = null;
        this.leaf.clear();
        this.setDefaults(defaults);
    }

    public Properties(Properties prop) {
        this.name = new String(prop.name);
        this.value = new String(prop.value);
        this.default_value = new String(prop.default_value);
        this.root = null;
        Vector<String> keys = prop.propertyNames();
        int i = 0;
        while (i < keys.size()) {
            Properties node = prop.getNode(keys.get(i));
            if (node != null) {
                this.setDefault(keys.get(i), node.default_value);
                this.setProperty(keys.get(i), node.value);
            }
            ++i;
        }
    }

    public void substitute(Properties prop) {
        this.clear();
        this.name = prop.name;
        this.value = prop.value;
        this.default_value = prop.default_value;
        Vector<String> keys = prop.propertyNames();
        int i = 0;
        while (i < keys.size()) {
            Properties node = prop.getNode(keys.get(i));
            if (node != null) {
                this.setDefault(keys.get(i), node.default_value);
                this.setProperty(keys.get(i), node.value);
            }
            ++i;
        }
    }

    public void destruct() {
        this.clear();
        if (this.root != null) {
            this.root.removeNode(this.name);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.destruct();
        }
        finally {
            super.finalize();
        }
    }

    public String getName() {
        return this.name;
    }

    public Vector<Properties> getLeaf() {
        return this.leaf;
    }

    public Properties getRoot() {
        return this.root;
    }

    public String getProperty(String key) {
        Vector<String> keys = new Vector<String>();
        this.split(key, '.', keys);
        Properties node = this._getNode(keys, 0, this);
        if (node != null) {
            return node.value.length() > 0 ? node.value : node.default_value;
        }
        return EMPTY;
    }

    public String getProperty(String key, String alternative) {
        String value = this.getProperty(key);
        return value.length() == 0 ? alternative : value;
    }

    public String getDefault(String key) {
        Vector<String> keys = new Vector<String>();
        this.split(key, '.', keys);
        Properties node = this._getNode(keys, 0, this);
        if (node != null) {
            return node.default_value;
        }
        return EMPTY;
    }

    public String setProperty(String key, String value) {
        Vector<String> keys = new Vector<String>();
        this.split(key, '.', keys);
        Properties curr = this;
        int i = 0;
        while (i < keys.size()) {
            Properties next = curr.hasKey(keys.get(i));
            if (next == null) {
                next = new Properties(keys.get(i));
                next.root = curr;
                curr.leaf.add(next);
            }
            curr = next;
            ++i;
        }
        String oldValue = curr.value.length() > 0 ? curr.value : curr.default_value;
        curr.value = value;
        return oldValue;
    }

    public String setDefault(String key, String defaultValue) {
        Vector<String> keys = new Vector<String>();
        this.split(key, '.', keys);
        Properties curr = this;
        int i = 0;
        while (i < keys.size()) {
            Properties next = curr.hasKey(keys.get(i));
            if (next == null) {
                next = new Properties(keys.get(i));
                next.root = curr;
                curr.leaf.add(next);
            }
            curr = next;
            ++i;
        }
        curr.default_value = defaultValue;
        return defaultValue;
    }

    public void setDefaults(String[] defaults) {
        int i = 0;
        while (i + 1 < defaults.length) {
            String key = defaults[i];
            String value = defaults[i + 1];
            key = key.trim();
            value = value.trim();
            this.setDefault(key, value);
            i += 2;
        }
    }

    public void list(OutputStream out) {
        this._store(out, EMPTY, this);
    }

    public void load(BufferedReader reader) throws IOException {
        String tmp;
        String pline = EMPTY;
        while ((tmp = reader.readLine()) != null) {
            if ((tmp = tmp.trim()).length() == 0 || tmp.charAt(0) == '#' || tmp.charAt(0) == '!') continue;
            if (tmp.charAt(tmp.length() - 1) == '\\' && !StringUtil.isEscaped(tmp, tmp.length() - 1)) {
                tmp = tmp.substring(0, tmp.length() - 1);
                pline = String.valueOf(pline) + tmp;
                continue;
            }
            if ((pline = String.valueOf(pline) + tmp).length() == 0) continue;
            Pair<String, String> pair = this.splitKeyValue(pline);
            String key = pair.getKey();
            String value = pair.getValue();
            key = StringUtil.unescape(key);
            key = key.trim();
            value = StringUtil.unescape(value);
            value = value.trim();
            this.setProperty(key, value);
            pline = EMPTY;
        }
    }

    public void save(OutputStream out, String header) {
        this.store(out, header);
    }

    public void store(OutputStream out, String header) {
        PrintWriter writer = new PrintWriter(out);
        writer.write("# ");
        writer.write(header);
        writer.println();
        writer.flush();
        this._store(out, EMPTY, this);
    }

    public final Vector<String> propertyNames() {
        Vector<String> names = new Vector<String>();
        int i = 0;
        while (i < this.leaf.size()) {
            this._propertyNames(names, this.leaf.get((int)i).name, this.leaf.get(i));
            ++i;
        }
        return names;
    }

    public final int size() {
        return this.propertyNames().size();
    }

    public final Properties getNode(String key) {
        Vector<String> keys = new Vector<String>();
        this.split(key, '.', keys);
        return this._getNode(keys, 0, this);
    }

    public boolean createNode(String key) {
        Properties p = this.getNode(key);
        if (p != null) {
            return false;
        }
        this.setProperty(key, EMPTY);
        return true;
    }

    public Properties removeNode(String name) {
        int i = 0;
        while (i < this.leaf.size()) {
            if (this.leaf.get((int)i).name.equals(name)) {
                Properties prop = this.leaf.get(i);
                this.leaf.remove(i);
                return prop;
            }
            ++i;
        }
        return null;
    }

    public final Properties hasKey(String key) {
        int i = 0;
        while (i < this.leaf.size()) {
            if (this.leaf.get((int)i).name.equals(key)) {
                return this.leaf.get(i);
            }
            ++i;
        }
        return null;
    }

    public void clear() {
        while (this.leaf.size() > 0) {
            Properties tail = this.leaf.get(this.leaf.size() - 1);
            if (tail == null) continue;
            tail.destruct();
        }
    }

    public void merge(Properties prop) {
        for (String key : prop.propertyNames()) {
            String value = prop.getProperty(key);
            this.setProperty(key, value);
        }
    }

    protected Pair<String, String> splitKeyValue(String str) {
        int i = 0;
        while (i < str.length()) {
            if (!(str.charAt(i) != ':' && str.charAt(i) != '=' || StringUtil.isEscaped(str, i))) {
                return new Pair<String, String>(str.substring(0, i), str.substring(i + 1));
            }
            ++i;
        }
        i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == ' ' && StringUtil.isEscaped(str, i)) {
                return new Pair<String, String>(str.substring(0, i), str.substring(i + 1));
            }
            ++i;
        }
        return new Pair<String, String>(str, EMPTY);
    }

    protected boolean split(String str, char delim, Vector<String> values) {
        if (str.length() == 0) {
            return false;
        }
        int begin_idx = 0;
        int end_idx = 0;
        while (end_idx < str.length()) {
            if (str.charAt(end_idx) == delim && !StringUtil.isEscaped(str, end_idx)) {
                values.add(str.substring(begin_idx, end_idx));
                begin_idx = end_idx + 1;
            }
            ++end_idx;
        }
        values.add(str.substring(begin_idx));
        return true;
    }

    protected String indent(int index) {
        StringBuffer spaces = new StringBuffer();
        int i = 0;
        while (i < index - 1) {
            spaces.append("  ");
            ++i;
        }
        return spaces.toString();
    }

    protected Properties _getNode(Vector<String> keys, int index, Properties curr) {
        Properties next = curr.hasKey(keys.get(index));
        if (next == null) {
            return null;
        }
        if (index < keys.size() - 1) {
            return next._getNode(keys, ++index, next);
        }
        return next;
    }

    protected void _propertyNames(Vector<String> names, String curr_name, Properties curr) {
        if (!curr.leaf.isEmpty()) {
            int i = 0;
            while (i < curr.leaf.size()) {
                String next_name = String.valueOf(curr_name) + '.' + curr.leaf.get((int)i).name;
                this._propertyNames(names, next_name, curr.leaf.get(i));
                ++i;
            }
        } else {
            names.add(curr_name);
        }
    }

    protected void _store(OutputStream out, String curr_name, Properties curr) {
        if (!curr.leaf.isEmpty()) {
            int i = 0;
            while (i < curr.leaf.size()) {
                String next_name = curr_name.length() == 0 ? curr.leaf.get((int)i).name : String.valueOf(curr_name) + '.' + curr.leaf.get((int)i).name;
                this._store(out, next_name, curr.leaf.get(i));
                ++i;
            }
        }
        if (curr.root != null && curr.value != null && curr.value.length() > 0) {
            PrintWriter writer = new PrintWriter(out);
            writer.write(curr_name);
            writer.write(" = ");
            writer.write(curr.value);
            writer.println();
            writer.flush();
        }
    }

    protected OutputStream _dump(OutputStream out, Properties curr, int index) {
        PrintWriter writer = new PrintWriter(out);
        if (index != 0) {
            writer.write(this.indent(index));
            writer.write("- ");
            writer.write(curr.name);
        }
        if (curr.leaf.isEmpty()) {
            if (curr.value.length() == 0) {
                writer.write(": ");
                writer.write(curr.default_value);
                writer.println();
            } else {
                writer.write(": ");
                writer.write(curr.value);
                writer.println();
            }
            return out;
        }
        if (index != 0) {
            writer.println();
        }
        int i = 0;
        while (i < curr.leaf.size()) {
            this._dump(out, curr.leaf.get(i), index + 1);
            ++i;
        }
        return out;
    }
}

