#!/usr/bin/env python
# -*- coding: euc-jp -*-


##
#
# @file CorbaConsumer.py
# @brief CORBA Consumer class
# @date $Date: 2007/09/20 $
# @author Noriaki Ando <n-ando@aist.go.jp> and Shinji Kurihara
# 
# Copyright (C) 2006-2008
#     Noriaki Ando
#     Task-intelligence Research Group,
#     Intelligent Systems Research Institute,
#     National Institute of
#         Advanced Industrial Science and Technology (AIST), Japan
#     All rights reserved.


from omniORB import CORBA

##
# @if jp
# @class CorbaConsumerBase
#
# @brief ֥ȥե󥹤ݻץ졼ۥ쥯饹
#
# ̿ʤȤ CORBA 򤷤Υ󥷥塼޼Τδ쥯饹
#
# @since 0.4.0
#
# @else
# @class ConsumerBase
# @brief Placeholder base class to hold remote object reference.
# @endif
class CorbaConsumerBase:
  """
  """



  ##
  # @if jp
  #
  # @brief 󥹥ȥ饯
  # 
  # @param self 
  # @param consumer ԡCorbaConsumerBase֥
  #
  # @else
  #
  # @brief Consructor
  #
  # @param self 
  #
  # @endif
  def __init__(self, consumer=None):
    if consumer:
      self._objref = consumer._objref
    else:
      self._objref = None


  ##
  # @if jp
  # 
  # @brief 黻
  # 
  # @param self 
  # @param consumer 
  # 
  # @return 
  # 
  # @else
  # 
  # @brief Assignment operator
  # 
  # @param self 
  # @param consumer Copy source.
  # 
  # @endif
  def equal(self, consumer):
    self._objref = consumer._objref
    return self


  ##
  # @if jp
  #
  # @brief CORBA֥Ȥ򥻥åȤ
  #
  # Ϳ줿֥ȥե󥹤ϡConsumerBase ֥
  # CORBA::Object_var Ȥݻ롣 
  #
  # @param self
  # @param obj CORBA ֥ȤΥե
  #
  # @return obj  nil ե󥹤ξ false ֤
  #
  # @else
  #
  # @brief Set CORBA Object
  #
  # The given CORBA Object is held as CORBA::Object_var type
  #
  # @param self
  # @param obj Object reference of CORBA object
  #
  # @return If obj is nil reference, it returns false.
  #
  # @endif
  def setObject(self, obj):
    if CORBA.is_nil(obj):
      return False

    self._objref = obj
    return True


  ##
  # @if jp
  #
  # @brief CORBA֥Ȥ
  #
  # ConsumerBase ֥ CORBA::Object_var ȤݻƤ
  # ֥ȥե󥹤롣 
  #
  # @param self
  #
  # @return obj CORBA ֥ȤΥե
  #
  # @else
  #
  # @brief Get CORBA Object
  #
  # @param self
  #
  # @return Object reference of CORBA object
  #
  # @endif
  def getObject(self):
    return self._objref


  ##
  # @if jp
  #
  # @brief CORBA֥Ȥ򥯥ꥢ
  #
  # ꤵƤ CORBA ֥Ȥ򥯥ꥢ롣
  # CORBA֥ȤΤΤФƤϲʤ
  #
  # @param self
  #
  # @else
  #
  # @endif
  def releaseObject(self):
    self._objref = CORBA.Object._nil



##
# @if jp
#
# @class CorbaConsumer
# @brief ֥ȥե󥹤ݻץ졼ۥ饹
# 
# Ϳ줿CORBA֥Ȥݻ롣
# ֥ȤåȤ줿ȤˡͿ줿 narrow Τǡ
# _ptr() Ǽե󥹤ϡnarrow ѤߤΥե󥹤Ǥ롣
#
# @since 0.4.0
#
# @else
#
# @class Consumer.CorbaConsumer
# @brief Placeholder class to hold remote object reference.
#
# This class holds a type of object that given by parameter.
# For internal use, _ptr type and _var type should be given as parameter.
#
# @since 0.4.0
#
# @endif
class CorbaConsumer(CorbaConsumerBase):
  """
  """



  ##
  # @if jp
  #
  # @brief 󥹥ȥ饯
  #
  # @param self
  # @param interfaceType Υۥݻ륪֥Ȥη
  #                      (ǥե;None)
  # @param consumer Υۥݻ륪֥(ǥե;None)
  #
  # @else
  #
  # @brief Consructor
  #
  # @endif
  def __init__(self, interfaceType=None, consumer=None):
    if interfaceType:
      self._interfaceType = interfaceType
    else:
      self._interfaceType = None

    if consumer:
      CorbaConsumerBase.__init__(self, consumer)
      self._var = consumer._var
    else:
      CorbaConsumerBase.__init__(self)
      self._var = None


  ##
  # @if jp
  # 
  # @brief 黻
  # 
  # @param self 
  # @param consumer 
  # 
  # @return 
  # 
  # @else
  # 
  # @brief Assignment operator
  # 
  # @param self 
  # @param consumer Copy source.
  # 
  # @endif
  def equal(self, consumer):
    self._var = consumer._var


  def __del__(self):
    self.releaseObject()


  ##
  # @if jp
  # @brief ֥Ȥ򥻥åȤ
  #
  # ConsumerBase ΥС饤ɡCORBA::Object_var ˥֥Ȥ򥻥å
  # ȤȤˡѥ᡼η narrow ֥Ȥݻ롣
  #
  # @param self
  # @param obj CORBA Objecct
  #
  # @return ֥
  #         оݥ֥Ȥ null ξ false ֤äƤ
  # 
  # @else
  # @brief Set Object
  #
  # Override function of ConsumerBase. This operation set an Object to 
  # CORBA:Object_var in the class, and this object is narrowed to
  # given parameter and stored in.
  #
  # @param self
  # @param obj CORBA Objecct
  #
  # @endif
  def setObject(self, obj):
    if not CorbaConsumerBase.setObject(self, obj):
      self.releaseObject()
      return False

    if self._interfaceType:
      self._var = obj._narrow(self._interfaceType)
    else:
      self._var = self._objref

    if not CORBA.is_nil(self._var):
      return True

    self.releaseObject()
    return False


  ##
  # @if jp
  # @brief ObjectType Υ֥ȤΥե󥹤
  #
  # ObjectType  narrowѤߤΥ֥ȤΥե󥹤롣
  # ֥ȥե󥹤ѤˤϡsetObject() ǥåȺѤߤ
  # ʤФʤʤ
  # ֥ȤåȤƤʤСnil ֥ȥե󥹤
  # ֤롣
  #
  # @param self
  #
  # @return ObjectType  narrow ѤߤΥ֥ȤΥե
  # 
  # @else
  # @brief Get Object reference narrowed as ObjectType
  #
  # This operation returns object reference narrowed as ObjectType.
  # To use the returned object reference, reference have to be set by
  # setObject().
  # If object is not set, this operation returns nil object reference.
  #
  # @return The object reference narrowed as ObjectType
  #
  # @endif
  def _ptr(self):
    return self._var


  ##
  # @if jp
  #
  # @brief CORBA֥Ȥ򥯥ꥢ
  #
  # ꤵƤ CORBA ֥Ȥ򥯥ꥢ롣
  # CORBA֥ȤΤΤФƤϲʤ
  #
  # @param self
  #
  # @else
  #
  # @endif
  def releaseObject(self):
    CorbaConsumerBase.releaseObject(self)
    self._var = CORBA.Object._nil
