#!/usr/bin/env python
# -*- coding: euc-jp -*-

##
# @file NumberingPolicy.py
# @brief Object numbering policy class
# @date $Date: 2007/08/23$
# @author Noriaki Ando <n-ando@aist.go.jp> and Shinji Kurihara
#
# Copyright (C) 2006-2008
#     Task-intelligence Research Group,
#     Intelligent Systems Research Institute,
#     National Institute of
#         Advanced Industrial Science and Technology (AIST), Japan
#     All rights reserved.

import string
import OpenRTM_aist

##
# @if jp
#
# @class NumberingPolicy
# @brief ֥͡ߥ󥰡ݥꥷ(̿̾§)ݥ饹
#
# ֥ȤݤΥ͡ߥ󥰡ݥꥷ(̿̾§)뤿
# ݥ饹
# ݥ饹ϡʲδؿμ󶡤ʤФʤʤ
# - onCreate() : ֥̾κ
# - onDelete() : ֥Ⱥ̾β
#
# @since 0.4.0
#
# @else
#
# @endif
class NumberingPolicy:
  """
  """



  ##
  # @if jp
  # @brief ֥̤ȯ㳰饹(̤)
  # @else
  #
  # @endif
  class ObjectNotFound:
    pass


  ##
  # @if jp
  #
  # @brief ֥̾κ(֥饹)
  #
  # ֥̾Τ뤿δؿ<BR>
  # ֥饹Ǥμ
  # 
  # @param self
  # @param obj ̾оݥ֥
  #
  # @return ֥̾
  #
  # @else
  #
  # @endif
  def onCreate(self, obj):
    pass


  ##
  # @if jp
  #
  # @brief ֥Ⱥ̾β(֥饹)
  #
  # ֥Ⱥ̾Τ뤿δؿ<BR>
  # ֥饹Ǥμ
  # 
  # @param self
  # @param obj ̾βоݥ֥
  #
  # @else
  #
  # @endif
  def onDelete(self, obj):
    pass



##
# @if jp
#
# @class DefaultNumberingPolicy
# @brief ֥͡ߥ󥰡ݥꥷ(̿̾§)ѥ饹
#
# ֥ȤݤΥ͡ߥ󥰡ݥꥷ(̿̾§)뤿
# 饹
#
# @since 0.4.0
#
# @else
#
# @endif
class DefaultNumberingPolicy(NumberingPolicy):
  """
  """

  ##
  # @if jp
  #
  # @brief 󥹥ȥ饯
  # 
  # 󥹥ȥ饯
  # 
  # @param self
  # 
  # @else
  #
  # @brief virtual destractor
  #
  # @endif
  def __init__(self):
    self._num = 0
    self._objects = []


  ##
  # @if jp
  #
  # @brief ֥̾κ
  #
  # ֥̾Τ롣
  # Ѥߥ󥹥󥹤ο˱̾Τ롣
  # 
  # @param self
  # @param obj ̾оݥ֥
  #
  # @return ֥̾
  #
  # @else
  #
  # @endif
  def onCreate(self, obj):
    self._num += 1

    pos = 0
    try:
      pos = self.find(None)
      self._objects[pos] = obj
      return OpenRTM_aist.otos(pos)
    except NumberingPolicy.ObjectNotFound:
      self._objects.append(obj)
      return OpenRTM_aist.otos(int(len(self._objects) - 1))


  ##
  # @if jp
  #
  # @brief ֥Ⱥ̾β
  #
  # ֥Ⱥ̾Τ롣
  # ֥ȺѤߥ󥹥󥹿򸺻롣
  # 
  # @param self
  # @param obj ̾βоݥ֥
  #
  # @else
  #
  # @endif
  def onDelete(self, obj):
    pos = 0
    try:
      pos = self.find(obj)
    except:
      return

    if (pos < len(self._objects)):
      self._objects[pos] = None
    self._num -= 1


  ##
  # @if jp
  #
  # @brief ֥Ȥθ
  #
  # ֥ȥꥹȤꤵ줿֥Ȥ򸡺
  # 륪֥ȤǼƤˤϥǥå֤
  # 
  # @param self
  # @param obj оݥ֥
  #
  # @return ֥ȳǼǥå
  #
  # @else
  #
  # @endif
  def find(self, obj):
    i = 0
    for obj_ in self._objects:
      if obj_ == obj:
        return i
      i += 1
    raise NumberingPolicy.ObjectNotFound()
       

