#!/usr/bin/env python
# -*- coding: euc-jp -*-

##
# @file ObjectManager.py
# @brief Object management class
# @date $Date: $
# @author Noriaki Ando <n-ando@aist.go.jp> and Shinji Kurihara
#
# Copyright (C) 2003-2008
#     Task-intelligence Research Group,
#     Intelligent Systems Research Institute,
#     National Institute of
#         Advanced Industrial Science and Technology (AIST), Japan
#     All rights reserved.


import sys
import string
import threading

import OpenRTM_aist



##
# @if jp
#
# @brief ֥ȴѥ饹
#
# Ƽ索֥Ȥ뤿Υ饹
#
# @since 0.4.0
#
# @else
#
# @endif
class ObjectManager:
  """
  """

  ##
  # @if jp
  #
  # @brief 󥹥ȥ饯
  # 
  # 󥹥ȥ饯
  # 
  # @param self
  # @param predicate ֥ȸѥե󥯥
  # 
  # @else
  #
  # @endif
  def __init__(self, predicate):
    self._objects = self.Objects()
    self._predicate = predicate



  ##
  # @if jp
  # @class Objects
  # @brief ֥ȴ饹
  # @endif
  class Objects:
    def __init__(self):
      self._mutex = threading.RLock()
      self._obj = []


  ##
  # @if jp
  #
  # @brief ꤷ֥ȤϿ
  # 
  # ꤷ֥ȤϿ롣
  # Ʊ쥪֥ȤϿѤߤξϡԤʤ
  #
  # @param self
  # @param obj Ͽоݥ֥
  #
  # @return Ͽ(֥ȤϿtrue)
  # 
  # @else
  #
  # @endif
  def registerObject(self, obj):
    guard = OpenRTM_aist.ScopedLock(self._objects._mutex)
    predi = self._predicate(factory=obj)

    for _obj in self._objects._obj:
      if predi(_obj):
        return False

    self._objects._obj.append(obj)
    return True


  ##
  # @if jp
  #
  # @brief ꤷ֥ȤϿ
  # 
  # ꤷ֥ȤϿ롣
  # ꤷ֥ȤϿƤʤˤNULL֤
  #
  # @param self
  # @param id Ͽоݥ֥ȤID
  #
  # @return Ͽ줿֥
  # 
  # @else
  #
  # @endif
  def unregisterObject(self, id):
    guard = OpenRTM_aist.ScopedLock(self._objects._mutex)
    predi = self._predicate(name=id)
    i = 0
    for _obj in self._objects._obj:
      if predi(_obj):
        ret = _obj
        del self._objects._obj[i]
        return ret
      i+=1
      
    return None


  ##
  # @if jp
  #
  # @brief ֥Ȥ򸡺
  # 
  # ϿƤ륪֥Ȥ椫ꤷ˹פ륪֥Ȥ򸡺
  # Ƽ롣
  # ꤷ˹פ륪֥ȤϿƤʤˤNULL֤
  #
  # @param self
  # @param id оݥ֥ȤID
  #
  # @return ֥Ȥθ
  # 
  # @else
  #
  # @endif
  def find(self, id):
    guard = OpenRTM_aist.ScopedLock(self._objects._mutex)
    if isinstance(id,str):
      predi = self._predicate(name=id)
    else:
      predi = self._predicate(prop=id)

    for _obj in self._objects._obj:
      if predi(_obj):
        return _obj
      
    return None


  ##
  # @if jp
  #
  # @brief ϿƤ륪֥ȤΥꥹȤ
  # 
  # ϿƤ륪֥ȤΥꥹȤ롣
  #
  # @param self
  #
  # @return ϿƤ륪֥ȡꥹ
  # 
  # @else
  #
  # @endif
  def getObjects(self):
    guard = OpenRTM_aist.ScopedLock(self._objects._mutex)
    return self._objects._obj


  ##
  # @if jp
  # @brief ֥Ȥ򸡺
  #
  # ꤵ줿˹פ륪֥Ȥ򸡺롣
  #
  # @param self
  # @param p ֥ȸѥե󥯥
  #
  # @else
  #
  # @endif
  def for_each(self,p):
    guard = OpenRTM_aist.ScopedLock(self._objects._mutex)
    predi = p()

    for _obj in self._objects._obj:
      predi(_obj)

    return predi

