// -*- C++ -*-
/*!
 * @file RTPreemptEC.h
 * @brief RTPreemptEC class
 * @date $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2010
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#ifndef OPENRTM_RTPREEMPTEC_H
#define OPENRTM_RTPREEMPTEC_H

#include <rtm/RTC.h>
#include <rtm/Manager.h>
#include <rtm/PeriodicExecutionContext.h>

namespace OpenRTM
{
  /*!
   * @if jp
   * @class RTPreemptEC
   * @brief RTPreemptEC 饹
   *
   * RT-Preempt kernel Ѥꥢ륿¹ԥƥȥ饹
   * μ¹ԥƥȤϡRT-Preempt Patch ŬѤ Linux kernel
   * ϡ줬Ȥ߹ޤ줿 Linux kernel ˤꥢ륿ॹ塼
   * 󥰵ǽѤ¹ԥƥȤǤ롣
   *
   * μ¹ԥƥȤѤˤϡrtc.conf ˲Τ褦˵Ҥ롣
   * 
   * <pre>
   * exec_cxt.periodic.type: RTPreemptEC
   * exec_cxt.periodic.rate: 1000
   * exec_cxt.priority: 50
   * manager.modules.load_path: <RTPreemptRC.so ؤΥѥ>
   * manager.modules.preload: RTPreemptEC.so
   * </pre>
   *
   * ˡ¹Իˤ root ¤ɬפȤʤΤǡroot Ȥƥݡ
   * ͥȤ¹Ԥɬפ롣
   *
   * ECͭʥץϰʲΤȤǤ롣
   *
   * - exec_cxt.periodic.priority: (default: 49) <br>
   * - exec_cxt.periodic.rtpreempt.priority: (default: 49)<br>
   *      åɤμ¹ͥ 1 ()  99 (ǹ)<br>
   *      Linux sched_setscheduler(2) 򻲾ȤΤȡ<br>
   *
   * - exec_cxt.periodic.rtpreempt.sched_policy:  (default: fifo)<br>
   *      塼󥰤Υݥꥷ<br>
   *      rr: 饦ɥӥ, fifo: FIFO  (default: fifo)<br>
   *      Linux sched_setscheduler(2) 򻲾ȤΤȡ<br>
   *
   * - exec_cxt.periodic.rtpreempt.wait_offset: (default: -10000)<br>
   *      Ȼ֤Υեåȡ[ns] ñ̤ǻꤹ롣 <br>
   *      1 us ٤Ū٤줬ȯ礬Τǡ
   *      ͤĴ뤳ȤǡΤʼǼ¹Ԥ뤳ȤǤ롣
   *
   * ջ: ECŪ® (msʾ) Ǽ¹Ԥϡ
   * ٥ DEBUG Ⲽ (logger.log_level: NORMAL ) ꤷ
   * Ƽ¹Ԥɬפ롣ޤlogger.enable: NO ꤵƤƤ⡢
   * logger.log_level: PARANOID ꤵƤˤϡonExecute()
   * μ¹Ԥ˻֤ꡢǥåɥ饤ʤʤǽΤ
   * դɬפǤ롣
   *
   * @since 1.0.1
   *
   * @else
   * @class RTPreemptEC
   * @brief RTPreemptEC 饹
   *
   * This class is real-time ExecutionContext which utilizes RT-Prempt
   * kernel.  This ExecutionContext is a real-time ExecutionContext
   * which utilizes real-time scheduler functionality of "RT-Preempt"
   * Linux kernel (patched or originally embedded).
   *
   * Give the following configurations in your rtc.conf to use this EC.
   * <pre>
   * exec_cxt.periodic.type: RTPreemptEC
   * exec_cxt.periodic.rate: 1000
   * exec_cxt.priority: 50
   * manager.modules.load_path: <path to RTPreemptRC.so>
   * manager.modules.preload: RTPreemptEC.so
   * </pre>
   *
   * Since this functionality requires root authority, your RTC which
   * uses this EC have to be executed as root.
   *
   * The following RTPreemptEC specific options are available.
   *
   * - exec_cxt.periodic.priority: (default: 49)<br>
   * - exec_cxt.periodic.rtpreempt.priority: (default: 49)<br>
   *      Execution priority of threads from 1 (lowest) to 99 (highest)<br>
   *      See Linux sched_setscheduler(2).
   *
   * - exec_cxt.periodic.rtpreempt.sched_policy:  (default: fifo)<br>
   *      Scheduling policy.<br>
   *      rr: round-robin, fifo: FIFO type scheduling (default: fifo)<br>
   *      See Linux sched_setscheduler(2).
   *
   * - exec_cxt.periodic.rtpreempt.wait_offset: (default: -10000)<br>
   *      Offset time of wait. It can be given [ns] unit. <br> 
   *      Adjusting this value, If dozens micro seconds delay in one
   *      execution cycle constantly, more accurate periodic execution
   *      can be achieved.
   *
   * NOTICE: When performing comparatively quick cycle (tens of ms or
   * more) using this EC, log-level have to be lower than DEBUG
   * (logger.log_level: NORMAL or etc.). Moreover, even if
   * "logger.enable=No" is set, if "logger.log_level=PRANOID" is set,
   * execution of onExecute() takes longer time and it may cause
   * deadline-miss. So caution is needed.
   *
   * @since 1.0.1
   *
   * @endif
   */
  class RTPreemptEC
    : public virtual ::RTC::PeriodicExecutionContext
  {
  public:
    /*!
     * @if jp
     * @brief ǥեȥ󥹥ȥ饯
     *
     * ǥեȥ󥹥ȥ饯
     *
     * @else
     * @brief Default Constructor
     *
     * Default Constructor
     *
     * @endif
     */
    RTPreemptEC();

    /*!
     * @if jp
     * @brief ǥȥ饯
     *
     * ǥȥ饯
     *
     * @else
     * @brief Destructor
     *
     * Destructor
     *
     * @endif
     */
    virtual ~RTPreemptEC();

    /*!
     * @if jp
     * @brief ExecutionContext ѤΥåɼ¹Դؿ
     *
     * ExecutionContext ѤΥåɼ¹Դؿ
     * Ͽ줿ݡͥȤνƤӽФ
     *
     * @return ¹Է
     *
     * @else
     * @brief Thread execution function for ExecutionContext
     *
     * Thread execution function for ExecutionContext.
     * Invoke the registered components operation.
     *
     * @return The execution result
     *
     * @endif
     */ 
    virtual int svc(void);

    /*!
     * @if jp
     * @brief 륭ĥץѥƥ
     *
     * @param ExecutionContext ѤΥåɼ¹Դؿ
     * Ͽ줿ݡͥȤνƤӽФ
     *
     * @return ¹Է
     *
     * @else
     * @brief Thread execution function for ExecutionContext
     *
     * Thread execution function for ExecutionContext.
     * Invoke the registered components operation.
     *
     * @return The execution result
     *
     * @endif
     */ 
    template <class T>
    void getProperty(coil::Properties& prop, const char* key, T& value)
    {
    if (prop.findNode(key) != 0)
      {
        T tmp;
        if (coil::stringTo(tmp, prop[key].c_str()))
          {
            value = tmp;
          }
      }
    }

  private:
    int m_priority;
    int m_policy;
    int m_waitoffset;
  };
};

extern "C"
{
  /*!
   * @if jp
   * @brief ECFactoryؤϿΤνؿ
   * @else
   * @brief Initialization function to register to ECFactory
   * @endif
   */
  void DLL_EXPORT RTPreemptECInit(RTC::Manager* manager);
};

#endif // OPENRTM_RTPREEMPTEC_H

