// -*- C++ -*-
/*!
 * @file DynamicLib_win32.h
 * @brief DynamicLib class
 * @date $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2008 Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#ifndef COIL_DYNAMICLIB_H
#define COIL_DYNAMICLIB_H

#include <windows.h>
#include <iostream>
#include <string>
#include <coil/config_coil.h>

#define COIL_DEFAULT_DYNLIB_MODE LOAD_WITH_ALTERED_SEARCH_PATH

/*!
 * Test for DLL export.
 */
#ifdef TEST_DYNAMIC_LIB
#  define  DynamicLib_EXPORT __declspec(dllexport)
#else
#  define  DynamicLib_EXPORT __declspec(dllimport)
#endif

extern "C"
{
  DynamicLib_EXPORT int ForExternTest(void);
}

namespace coil
{
  /*!
   * @if jp
   *
   * @class DynamicLib
   * @brief DynamicLib NX
   *
   * @else
   *
   * @class DynamicLib
   * @brief DynamicLib class
   *
   * @endif
   */
  class DynamicLib
  {
  public:

    /*!
     * @if jp
     *
     * @brief RXgN^
     *
     * RXgN^B
     *
     * @param close_handle_on_destruction N[YtO
     *
     * @else
     *
     * @brief Constructor
     *
     * Constructor
     *
     * @param close_handle_on_destruction Close flag.
     *
     * @endif
     */
    DynamicLib(int close_handle_on_destruction = 1);

    /*!
     * @if jp
     *
     * @brief RXgN^
     *
     * RXgN^B
     *
     * @param dynlib_name INCu
     * @param open_mode I[v[h
     * @param close_handle_on_destruction N[YtO
     *
     * @else
     *
     * @brief Constructor
     *
     * Constructor
     *
     * @param dynlib_name Dynamic link library name.
     * @param open_mode Open mode.
     * @param close_handle_on_destruction Close flag.
     *
     * @endif
     */
    DynamicLib(const char* dynlib_name,
               int open_mode = COIL_DEFAULT_DYNLIB_MODE,
               int close_handle_on_destruction = 1);

    /*!
     * @if jp
     *
     * @brief fXgN^
     *
     * fXgN^B
     *
     * @else
     *
     * @brief Destructor
     *
     * Destructor
     *
     * @endif
     */
    virtual ~DynamicLib();

    /*!
     * @if jp
     *
     * @brief Rs[RXgN^
     *
     * Rs[RXgN^B
     *
     * @param rhs Rs[INCuIuWFNg
     *
     * @else
     *
     * @brief Copy Constructor
     *
     * Copy Constructor
     *
     * @param rhs Dynamic link library object of copy source.
     *
     * @endif
     */
    DynamicLib(const DynamicLib& rhs);

    /*!
     * @if jp
     *
     * @brief Zq
     *
     * INCuIuWFNgRs[B
     *
     * @param rhs INCuIuWFNg
     *
     * @return 
     *
     * @else
     *
     * @brief Assignment operator
     *
     * Copy a Dynamic link library object.
     *
     * @param rhs Dynamic link library object of assignment source.
     *
     * @return Assignment result.
     *
     * @endif
     */
    DynamicLib& operator=(const DynamicLib& rhs);


    /*!
     * @if jp
     *
     * @brief INCũ[h
     *
     * INCu[hB
     *
     * @param dll_name INCu
     * @param open_mode I[v[h
     * @param close_handle_on_destruction N[YtO
     *
     * @return 0: , -1: s
     *
     * @else
     *
     * @brief Load of the Dynamic link library 
     *
     * Load of the Dynamic link library.
     *
     * @param dll_name Dynamic link library name.
     * @param open_mode Open mode.
     * @param close_handle_on_destruction Close flag.
     *
     * @return 0: successful, -1: failed
     *
     * @endif
     */
    virtual int open(const char* dll_name,
                     int open_mode = COIL_DEFAULT_DYNLIB_MODE,
                     int close_handle_on_destruction = 1);

    /*!
     * @if jp
     *
     * @brief INCũA[h
     *
     * INCuA[hB
     *
     * @return 0: , -1: s
     *
     * @else
     *
     * @brief Unload of the Dynamic link library 
     *
     * Unload of the Dynamic link library.
     *
     * @return 0: successful, -1: failed
     *
     * @endif
     */
    virtual int close(void);

    /*!
     * @if jp
     *
     * @brief V{[hꂽAhXԂ
     *
     * V{[hꂽAhXԂB
     *
     * @param symbol_name V{
     *
     * @return AhX(NULL: s)
     *
     * @else
     *
     * @brief Return an address of the memory where a symbol was loaded
     *
     * Return an address of the memory where a symbol was loaded.
     *
     * @param symbol_name Symbol name.
     *
     * @return Memory address.(NULL: failed)
     *
     * @endif
     */
    void *symbol (const char* symbol_name);

    /*!
     * @if jp
     *
     * @brief G[ɂĂ̐bZ[WԂ
     *
     * G[ɂĂ̐bZ[WԂB
     *
     * @return G[bZ[W(NULL: G[Ȃ)
     *
     * @else
     *
     * @brief Return the explanation message about the error
     *
     * Return the explanation message about the error.
     *
     * @return Error message.(NULL: not an error)
     *
     * @endif
     */
    const char* error(void) const;

    /*!
     * @if jp
     *
     * @brief jbgeXg
     *
     * jbgeXgsB
     *
     * @return 0xdeadbeef
     *
     * @else
     *
     * @brief Unit Test
     *
     * Unit Test.
     *
     * @return 0xdeadbeef
     *
     * @endif
     */
    static int ForExternTest(void) { 
        std::cout<<"ForExternTest"<<std::endl;
        return 0xdeadbeef; 

    }

  private:
    std::string m_name;
    int m_mode;
    int m_closeflag;
    HINSTANCE m_handle;
    int m_error;
  };  // class DynamicLib

};  // namespace coil

#endif // DynamicLib_h
