#!/usr/bin/env python
# -*- coding: utf-8 -*- 
#
#  @file RtmSystemDraw.py
#  @brief rtc-link component block diagram system draw management class
#  @date $Date: 2005-05-27 15:51:31 $
#  @author Tsuyoshi Tanabe, Noriaki Ando <n-ando@aist.go.jp>
# 
#  Copyright (C) 2004-2005
#      Task-intelligence Research Group,
#      Intelligent Systems Research Institute,
#      National Institute of
#          Advanced Industrial Science and Technology (AIST), Japan
#      All rights reserved.
# 
#  $Id: RtmSystemDraw.py 775 2008-07-28 16:14:45Z n-ando $
#
# RtmSystemDraw.py                    Created on: 2004/09/13
#                            Author    : Tsuyoshi Tanabe

"""
    wxPython, OGL Ѥݡͥȿ޷ɽ
"""


import time
import  wx
import wx.lib.colourdb
import  wx.ogl  as  ogl
import RtmLineUtil as lu
import string
import sys,os
import copy
import RtmParser
from RtmDialog import *

import RTM


##wx.Trap()

# ǻѤǥե
# ̾Τϡwx  colourdb ѥåΤΤ
SELECTED_COLOR = "LIGHT BLUE"
UNLOADED_COLOR = "black"
INACTIVE_COLOR = "blue"
ACTIVE_COLOR = "green"
ERROR_COLOR = "red"
TEXT_COLOR = "red"
#BACK_COLOR = "LightYellow"
BACK_COLOR = "WHITE"
MARK_COLOR = "red"
OUTLINE_COLOR = "red"
VIRTUAL_COLOR = "WHITE"

TRUE = 1
FALSE = 0
DUP_CONNECT = -1 # Duplication connection

BOX_WIDTH = 50
POLYGON_SIZE = 12

USE_BUFFERED_DC = 1

# ХåɾǤΥƥȥ˥塼ʸ
strDEL_SELECT = "Delete Selected Item"
strREFRESH    = "Refresh"
strOPEN       = "Open System"
strSAVE       = "Save System"
strSAVE_AS    = "Save System As"
strDEL_SYS    = "Current System is Deleted when OPEN.\nDelete It?"

# ݡͥȾǤΥƥȥ˥塼ʸ
strSTART   = "Start"
strSTOP    = "Stop"
strRESET   = "Reset"
strEXIT    = "Exit"
strKILL    = "Kill"
strDELITEM = "Delete Item"

# ֥ꡦɤ߹߸Υƥȥ˥塼
strASM_CONNECT = "Connect"
strASM_DELETE  = "Delete"

# ³γǧʸ
strASKMESSAGE = "Old Connection Information was found.\nDelete it and reconnect?"
#  Ť³󤬥ݡͥȾ˸ĤޤŤ³Ϻޤ³ޤ

# Save File As Υȥ 
strSAVE_AS_TITLE = "Save file as ..."
# Open FIle Υȥ 
strOPEN_TITLE = "Open a file"

#----------------------------------------------------------------------
class MyTextDropTarget(wx.TextDropTarget):
    """ɥåɥåסݡͥȤΥĥ꡼̤ƥȥǡ륯饹"""
    def __init__(self, parent, log):
        """饹νTextDropTargetκ

        []
        parent -- ƥ饹
        log    -- ѥ饹wx.LogMessageΥåѡ

        []
        void
        """
        wx.TextDropTarget.__init__(self)
        self.parent = parent
        self.log = log

    def OnDropText(self, x, y, text):
        """ɥå׵ǽΥ٥ȥϥɥ
        ̥ɥΥɥåʸ

        []
        x      -- ޥΣɸ
        y      -- ޥΣɸ
        text   -- ɥåפ줿ʸʸϥݡͥ̾

        []
        void
        """
        self.log.WriteText("(%d, %d)\n%s\n" % (x, y, text))
        canvas = self.parent.diagram.GetCanvas()
        dc = wx.ClientDC(self.parent)
        canvas.PrepareDC(dc)
        self.parent.PrepareDC(dc)

        # NameService Treeɥåפ줿̾ΤϿ
        if text not in self.parent.rtc_dict.keys():

#            print "drag text:",text , " kind:",check
            ref = self.parent.frame.myDict.GetObjRefToFullpath(text)
            kind = self.parent.frame.myDict.GetKindToFullpath(text)
            if ref != None and kind == 'rtc':
                self.parent.rtc_dict[text] = GRtc(self.parent, text, x, y)
                self.parent.rtc_list.append(text)
                self.parent.rtc_dict[text].refresh()
                self.parent.remakeLines()
            else:
                print "error: Drag Item does not obj-ref!"

        self.parent.Redraw(dc)

    def OnDragOver(self, x, y, d):
        """ɥåΡ٥ȥϥɥ
        ޥ뤬åȾ褿ƤӽФ

        []
        x      -- ޥΣɸ
        y      -- ޥΣɸ
        d      -- SHIFT or CONTROL Υե饰

        []
        wxDragResult -- ɥåξ֤ʥƥˡΤ
        """
        return wx.DragCopy

#----------------------------------------------------------------------
def getBufferedDC(canvas):
    """DCBufferedDCˤꡢؿ

    []
    canvas      -- Х

    []
    dc         -- BufferedDC
    """
    cdc = wx.ClientDC(canvas)
    canvas.PrepareDC(cdc)
    bufSize = wx.Size(1000, 1000)
    dc = wx.BufferedDC(cdc, bufSize)
    canvas.PrepareDC(dc)
    dc.SetBackground(wx.Brush(canvas.GetBackgroundColour()))
    dc.Clear()
    return dc
#----------------------------------------------------------------------
def setBodyColor(shape, colorFlag):
    """ݡͥȤξ֤ǿ޷οѹؿ

    []
    shape      -- ޷(Shape)֥
    colorFlag  -- ݡͥȤξ֤򼨤ʸ
                  select, unloaded, inactive, active, error, virtual

    []
    void
    """
    if colorFlag == 'select':
        shape.SetBrush(wx.Brush(wx.NamedColor(SELECTED_COLOR)))
    elif colorFlag == 'unloaded':
        shape.SetBrush(wx.Brush(wx.NamedColor(UNLOADED_COLOR)))
    elif colorFlag == 'inactive':
        shape.SetBrush(wx.Brush(wx.NamedColor(INACTIVE_COLOR)))
    elif colorFlag == 'active':
        shape.SetBrush(wx.Brush(wx.NamedColor(ACTIVE_COLOR)))
    elif colorFlag == 'error':
        shape.SetBrush(wx.Brush(wx.NamedColor(ERROR_COLOR)))
    elif colorFlag == 'virtual':
        shape.SetBrush(wx.Brush(wx.NamedColor(VIRTUAL_COLOR)))
    else:
        shape.SetBrush(wx.Brush(colorFlag))

    shape.Flash()

#----------------------------------------------------------------------
class makeCompositeShape(ogl.CompositeShape):
    """CompositeShapeΥåѡ饹"""
    def __init__(self, parent):
        """饹νCompositeShapeκ

        []
        parent -- ƥ饹

        []
        void
        """
        ogl.CompositeShape.__init__(self)
        self.parent = parent

#----------------------------------------------------------------------
class makeLineShape(ogl.LineShape):
    """֤褹åѡ饹"""
    def __init__(self, parent, canvas ):
        """饹νLineShapeκ

        []
        parent -- ƥ饹
        canvas -- ShapeCanvas֥Ȥꡣ

        []
        void
        """
        ogl.LineShape.__init__(self)
        self.parent = parent
        self.SetCanvas(canvas)
        self.SetPen(wx.Pen(wx.BLUE, 1))
        setBodyColor(self, 'inactive')
        self.MakeLineControlPoints(2)
        diagram = canvas.GetDiagram()
        diagram.AddShape(self)

    def setPoints(self, startX,startY, endX, endY):
        """ϡλɸꤷ

        []
        startX -- 賫Ϥɸ
        startY -- 賫Ϥɸ
        endX   -- 轪λɸ
        endY   -- 轪λɸ

        []
        void
        """
        self.SetEnds(startX, startY, endX, endY)

#----------------------------------------------------------------------
class makeRectangle(ogl.RectangleShape):
    """ͳѷ褹åѡ饹"""
    def __init__(self, parent, width, height):
        """饹νRectangle

        []
        parent -- ƥ饹
        width  -- ͳѷ
        height -- ͳѷι⤵

        []
        void
        """
        ogl.RectangleShape.__init__(self,width, height)
        self.parent = parent
        # lastx,lasty ϡ٥ȡʰư˸κɸǼư̤Ψǻ
        self.lastx = 0
        self.lasty = 0

#----------------------------------------------------------------------
class makeInportPolygon(ogl.PolygonShape):
    """ݡȿ޷(polygon)ѥ饹"""
    def __init__(self, parent, points):
        """饹ν(PolygonShapeκ

        []
        parent -- ƥ饹
        points -- ץϢ³(x,)ɸ(wxPointsˤ

        []
        void
        """
        ogl.PolygonShape.__init__(self)
        self.parent = parent

        self.Create(points)
        self.CalculatePolygonCentre()

    def updateInportPolygon(self, points):
        """ݡȿ޷(polygon)κʺɸƻ

        []
        points -- ץϢ³(x,)ɸ(wxPointsˤ

        []
        void
        """
        self.Create(points)
        self.UpdateOriginalPoints()
        self.CalculatePolygonCentre()

#----------------------------------------------------------------------
class makeOutportPolygon(ogl.PolygonShape):
    """ȥݡȿ޷(polygon)ѥ饹"""
    def __init__(self, parent, points):
        """饹ν(PolygonShapeκ

        []
        parent -- ƥ饹
        points -- ץϢ³(x,)ɸ(wxPointsˤ

        []
        void
        """
        ogl.PolygonShape.__init__(self)
        self.parent = parent

        self.Create(points)
        self.CalculatePolygonCentre()

    def updateOutportPolygon(self, points):
        """ȥݡȿ޷(polygon)κʺɸƻ

        []
        points -- ץϢ³(x,)ɸ(wxPointsˤ

        []
        void
        """
        self.Create(points)
        self.UpdateOriginalPoints()
        self.CalculatePolygonCentre()

#----------------------------------------------------------------------
class makeRectOval(ogl.EllipseShape):
    """ʱ߿޷륯饹"""
    def __init__(self, parent, pos_x, pos_y, width, height):
        """饹ν(EllipseShapeκ

        []
        parent -- ƥ饹
        pos_x  -- 褹ɸ
        pos_y  -- 褹ɸ
        width  -- ʱߤ
        height -- ʱߤι⤵

        []
        void
        """
        ogl.EllipseShape.__init__(self, width, height)
        self.parent = parent
        self.pos_x = pos_x
        self.pos_y = pos_y
        self.lastx = pos_x
        self.lasty = pos_y
        self.SetX(pos_x)
        self.SetY(pos_y)
        self.SetPen(wx.Pen(wx.BLACK, 1))
        self.SetBrush(wx.Brush('red'))

#----------------------------------------------------------------------
class makeTextShape(ogl.TextShape):
    """ƥȤ륯饹"""
    def __init__(self, parent, width, height):
        """饹νTextShapeκ

        []
        parent -- ƥ饹ꤹ
        width  -- ƥ襨ꥢ
        height -- ƥ襨ꥢι⤵

        []
        void
        """
        ogl.TextShape.__init__(self,width, height)
        self.parent = parent

#----------------------------------------------------------------------
class makeToolTip(ogl.Shape):
    """ġåסʥХ롼إס˿޷륯饹"""
    def __init__(self,parent,pt,dc):
        """饹νʥġåפκ

        []
        parent -- ƥ饹ꤹ
        pt     -- ġåפɽɸx,yˤΥץǻ
        dc     -- 褹ǥХƥȤ

        []
        void
        """
        self.parent = parent
        self.body = None
        self.x_size = 0
        self.y_size = 0
        self.color = BACK_COLOR

        # ɽʸ
        if parent.tag == 'in':
            string1 = parent.inport['name']
            string2 = parent.inport['port_type']
        else:
            string1 = parent.outport['name']
            string2 = parent.outport['port_type']
        atr = '%s\n%s'%(string1, string2)

        tmp = max(len(string1), len(string2))
        # ȤΥեȥWidthʿͤʤΤ
        charW = dc.GetCharWidth()
        charH = dc.GetCharHeight()
        self.x_size = charW * tmp 
        self.y_size = charH * 2.5
        # RectangleʸɽġåפѤȤ
        self.body = makeRectangle(self, self.x_size, self.y_size)
        self.body.AddText(atr)
#        self.body.SetFormatMode(ogl.FORMAT_NONE,0)
        self.body.FormatText(dc,atr,0)
        self.body.SetDraggable(False, False)
        # ɽ֤ϡͳѷκĺޥΰ֤
        self.body.SetX(pt[0]+self.x_size/2)
        self.body.SetY(pt[1]-self.y_size/2)
        self.body.SetPen(wx.Pen(wx.RED, 1))
        self.body.SetBrush(wx.Brush(wx.NamedColor(BACK_COLOR)))

    def removeWidget(self,dc):
        """ġå׿޷򥭥ХDC夫

        []
        dc     -- 褵ƤǥХƥȤ

        []
        void
        """
        canvas = self.body.GetCanvas()
        self.body.Erase(dc)
        self.body.RemoveFromCanvas(canvas)

#----------------------------------------------------------------------
class GRectOval(ogl.Shape):
    """ΰưѤαߤ륯饹"""
    def __init__(self,parent,tag,pos_x, pos_y):
        """饹νʱߤ

        []
        parent -- ƥ饹ꤹ
        tag    -- ̻ҡϢ,Ȥδطɽե饰ˤ
                  Ϣ֤ϡǼźϢƤ
        pos_x  -- ɽɸ
        pos_y  -- ɽɸ

        []
        void
        """
        self.parent = parent
        self.pos_x = pos_x
        self.pos_y = pos_y
        self.tag = tag
        self.createWidget()

    def createWidget(self):
        """ߤ

        []
        ʤ

        []
        void
        """
        self.body = makeRectOval(self, self.pos_x, self.pos_y, 8, 8)

    def removeWidget(self, dc):
        """ߤ򥭥ХDC夫

        []
        dc     -- 褹ǥХƥȤ

        []
        void
        """
        canvas = self.body.GetCanvas()
        self.body.Erase(dc)
        self.body.RemoveFromCanvas(canvas)

    def dmove(self, dc, d_x, d_y):
        """ߵڤΰư

        []
        dc     -- 褹ǥХƥȤ
        d_x    -- ɸаư (endPoint.x - startPoint.x ͡
        d_y    -- ɸаư (endPoint.y - startPoint.y ͡

        []
        void
        """
        canvas = self.body.GetCanvas()

        line = self.parent
        oval_tag = self.getTag()
        oval_id = oval_tag[0]

        # ưο޷DC夫
        self.body.Erase(dc)

        # ưκɸ
        if oval_tag[1] == 'oval_width_pos':
            self.pos_x = self.body.GetX() + d_x
            self.pos_y = self.body.GetY()
        else:
            self.pos_x = self.body.GetX()
            self.pos_y = self.body.GetY() + d_y

        # ɸκƺ
        line.lines[oval_id].Move(dc, self.pos_x, self.pos_y)
        x1,y1,x2,y2 = line.lines[oval_id].GetEnds()
        line.changeCoordT(oval_id, (x1, y1), (x2, y2) )

        self.body.Move(dc, self.pos_x, self.pos_y)

        # ߤΰưʺɸκƷ׻
        for x in range(1,len(line.oval_dict)+1):
            tag = line.oval_dict[x].getTag()
            if oval_id != tag[0]:
                line_pos_0 = line.coordT[x]
                line_pos_1 = line.coordT[x+1]

                if tag[1] == 'oval_width_pos':
                    hight = line_pos_0[1] - line_pos_1[1]
                    pos_y = line_pos_1[1] + (hight/2)
                    pos_x = line_pos_0[0]
                else:
                    width = line_pos_0[0] - line_pos_1[0]
                    pos_x = line_pos_1[0] + (width/2)
                    pos_y = line_pos_1[1]

                line.oval_dict[x].body.Move(dc, pos_x, pos_y)

    def getTag(self):
        """μ

        []
        ʤ

        []
        tag    -- ̻ҡϢ,Ȥδطɽե饰ˤֵ
                  Ϣ֤ϡǼźϢƤ
        """
        return self.tag

#----------------------------------------------------------------------
class GRtcLine(ogl.Shape):
    """륯饹"""
    def __init__(self, canvas, parent):
        """饹ν

        []
        canvas -- 褹륭Х
        parent -- ƥ饹ꤹ

        []
        void
        """
        self.canvas = canvas
        self.parent = parent
        self.startx = 0
        self.starty = 0
        self.endx = 0
        self.endy = 0
        self.coordT = None
        self.g_inp = None
        self.g_outp = None
        self.idx = 'L' + `canvas.line_idx`
        self.curOvalObj = None    # Value is setup GWorld.leftDown()
        self.oval_dict  = {}
        self.tag = 'line'
        self.lines = []
        self.subscription_type = RTM.OPS_NEW
        self.profile = None

    def refresh(self):
        """եå
        ڤӰưѤαߤ֤ˤ

        []
        ʤ

        []
        void
        """
        canvas = self.body.GetCanvas()
        dc = wx.ClientDC(canvas)
        canvas.PrepareDC(dc)
        self.unselected(dc)

    def remove(self, dc, canvas):
        """ӰưѤαߤ򥭥ХDC夫

        []
        dc     -- 褵ƤǥХƥȤ
        canvas -- 褵Ƥ륭Х

        []
        void
        """
        for x in range(len(self.lines)):
            self.lines[x].Unlink()
            self.lines[x].Erase(dc)
            self.lines[x].DeleteControlPoints()
            self.lines[x].RemoveFromCanvas(canvas)

        for x in range(len(self.oval_dict)):
            self.oval_dict[x+1].removeWidget(dc)

    def removeWidget(self, dc):
        """κ
        ϢInport/Outportξ(unsubscribe)ιƤӽФ

        []
        dc     -- 褹ǥХƥȤ

        []
        void
        """
        if self.g_inp:
            if len(self.g_inp.line_idx) == 1:
                setBodyColor(self.g_inp.body, 'inactive')
        if self.g_outp:
            if len(self.g_outp.line_idx) == 1:
                setBodyColor(self.g_outp.body, 'inactive')
        canvas = self.lines[0].GetCanvas()
        if self.g_outp != None:
            self.g_outp.disconnect(self.idx)
            self.g_outp = None
        if self.g_inp != None:
            self.g_inp.disconnect(self.idx)
            self.g_inp = None
        self.remove(dc, canvas)


    def createWidget(self):
        """

        []
        ʤ

        []
        void
        """
        num = len(self.coordT)
        if num < 2:
            return

        if num == 2: # ֤
            self.lines.append(makeLineShape(self, self.canvas))
            self.lines[0].setPoints(self.startx, self.starty, self.endx, self.endy)
        else:        # ĺİʾ
            for cnt in range(num-1):
            
                self.lines.append(makeLineShape(self, self.canvas))
                self.lines[cnt].setPoints(self.coordT[cnt][0], self.coordT[cnt][1], self.coordT[cnt+1][0], self.coordT[cnt+1][1])


        # ٥ȳ
        for x in range(len(self.lines)):
            setBodyColor(self.lines[x], 'inactive')
            evthandler2 = MyEvtHandlerLine()
            evthandler2.SetShape(self.lines[x])
            evthandler2.SetPreviousHandler(self.lines[x].GetEventHandler())
            self.lines[x].SetEventHandler(evthandler2)

    def setPoints(self, startX,startY, endX, endY):
        """κɸ

        []
        startX -- 賫ϰ֤Σɸ
        startY -- 賫ϰ֤Σɸ
        endtX  -- 轪λ֤Σɸ
        endtY  -- 轪λ֤Σɸ

        []
        void
        """

        lineUtil = lu.LineUtil(self, self.g_inp, self.g_outp, startX, startY, endX, endY)
        self.coordT = lineUtil.drawLine()

        self.startx = startX
        self.starty = startY
        self.endx = endX
        self.endy = endY

        self.createWidget()


    def setStartPoint(self, dc, movex,movey):
        """γʳΰư

        []
        dc     -- 褹ǥХƥȤ
        movex  -- ɸаư
        movey  -- ɸаư

        []
        void
        """
        canvas = self.lines[0].GetCanvas()
        # ޷򥭥ХDC夫
        for x in range(len(self.lines)):
            self.lines[x].Erase(dc)
            self.lines[x].RemoveFromCanvas(canvas)
        for x in range(len(self.oval_dict)):
            self.oval_dict[x+1].removeWidget(dc)

        # ɸꤷ
        self.lines = []
        self.startx = self.startx + movex
        self.starty = self.starty + movey
        self.setPoints(self.startx, self.starty, self.endx, self.endy)
        for x in range(len(self.lines)):
            self.lines[x].Show(True)

    def setEndPoint(self, dc, shape, movex,movey):
        """νλʽλΰư

        []
        dc     -- 褹ǥХƥȤ
        movex  -- λɸаư
        movey  -- λɸаư

        []
        void
        """
        canvas = self.lines[0].GetCanvas()
        # ޷򥭥ХDC夫
        for x in range(len(self.lines)):
            self.lines[x].Erase(dc)
            self.lines[x].RemoveFromCanvas(canvas)
        for x in range(len(self.oval_dict)):
            self.oval_dict[x+1].removeWidget(dc)

        # ɸꤷ
        self.lines = []
        self.endx = self.endx + movex
        self.endy = self.endy + movey
        self.setPoints(self.startx, self.starty, self.endx, self.endy)
        for x in range(len(self.lines)):
            self.lines[x].Show(True)

    def selected(self):
        """ʿѹ

        []
        ʤ

        []
        void
        """
        for x in range(len(self.lines)):
            self.lines[x].SetBrush(wx.Brush(wx.NamedColor(SELECTED_COLOR)))
            self.lines[x].SetPen(wx.Pen(SELECTED_COLOR, 1))
            self.lines[x].Flash()

    def unselected(self,dc):
        """ʿѹưѤαߤ

        []
        ʤ

        []
        void
        """
        for x in range(len(self.lines)):
            self.lines[x].SetPen(wx.Pen(INACTIVE_COLOR, 1))
            self.lines[x].SetBrush(wx.Brush(wx.NamedColor(INACTIVE_COLOR)))
            self.lines[x].Flash()
        for x in range(len(self.oval_dict)):
            self.oval_dict[x+1].removeWidget(dc)

    def dmove(self, dc, movex, movey):
        """ưΥߡ롼

        []
        dc    -- DC
        movex -- ưеΥ
        movey -- ưеΥ

        []
        void
        """
        pass

    def setLine2port(self, canvas, dc ):
        """
        ĤΥݡȤ򤢤餫ꤷܥ᥽åɤƤӽФ
        canvas.lineTo, canvas.lineFrom ˥ݡȤꤷƤ

        []
        canvas -- 褹륭Х
        dc     -- 褹DC

        []
        void
        """
        # ֥ȥե󥹤γǧ
        ref = canvas.lineTo.parent.ns_dict.GetObjRefToFullpath(canvas.lineTo.parent.fullpath)
        if not ref:
            return
        if canvas.lineFrom.parent.tag == 'in':
            self.g_inp = canvas.lineFrom.parent
            self.g_outp = canvas.lineTo.parent
        else:
            self.g_inp = canvas.lineTo.parent
            self.g_outp = canvas.lineFrom.parent
        # ȥ٥Ȥγ
        self.setPoints(self.g_inp.body.GetX(), self.g_inp.body.GetY(), self.g_outp.body.GetX(), self.g_outp.body.GetY())
        for x in range(len(self.lines)):
            evthandler2 = MyEvtHandlerLine()
            evthandler2.SetShape(self.lines[x])
            evthandler2.SetPreviousHandler(self.lines[x].GetEventHandler())
            self.lines[x].SetEventHandler(evthandler2)

        # Хإ饤Ͽڤӥ饤󥫥󥿡Υå
        canvas.line[self.idx] = self
        self.g_inp.connect(self.idx)
        canvas.line_idx = canvas.line_idx + 1
        for x in range(len(self.lines)):
            self.lines[x].Show(True)
        # Inport/Outport οѹ
        self.g_inp.body.Move(dc, self.g_inp.body.GetX(), self.g_inp.body.GetY())
        self.g_outp.body.Move(dc, self.g_outp.body.GetX(), self.g_outp.body.GetY())
        setBodyColor(self.g_inp.body, 'active')
        setBodyColor(self.g_outp.body, 'active')

    def changeCoordT(self, id, new_p1, new_p2):
        """ư˰ưκɸ

        []
        id     -- ɸꤹ볫ϥǥåź
        new_p1 -- ɸx,yˤγ򥿥ץǻ
        new_p2 -- ɸx,yˤνλ򥿥ץǻ

        []
        void
        """
        self.coordT[id] = new_p1
        self.coordT[id+1] = new_p2

        num = len(self.coordT)
        for cnt in range(num-1):
            self.lines[cnt].setPoints(self.coordT[cnt][0], self.coordT[cnt][1], self.coordT[cnt+1][0], self.coordT[cnt+1][1])

    def childMove(self, dc, pos_new):
        """ΰư

        []
        dc      -- 褹ǥХƥȤ
        pos_new -- ưκɸꥹ

        []
        void
        """
#        canvas = self.body.GetCanvas()

        max_num = len(pos_new)
        if max_num <= 2:
            return

        self.coordT = pos_new
        for cnt in range(max_num-1):
            self.lines[cnt].setPoints(self.coordT[cnt][0], self.coordT[cnt][1], self.coordT[cnt+1][0], self.coordT[cnt+1][1])

#----------------------------------------------------------------------
class GRtcIn(ogl.Shape):
    """ݡȿ޷륯饹"""
    def __init__(self, parent, ns_dict, fullpath, inp, pos_x, pos_y):
        """饹νʥݡȿ޷κ

        []
        parent     -- ƥ饹ꤹ
        ns_data -- ݡͥȤΥǥʥ꡼
        inp        -- ݡȤΥǥʥ꡼(in_list[n])
        pos_x      -- ݡȿ޷Σɸ
        pos_y      -- ݡȿ޷Σɸ

        []
        void
        """
        ogl.Shape.__init__(self)
        self.parent = parent
        self.ns_dict = ns_dict
        self.fullpath = fullpath
        self.inport = inp
        self.x = pos_x
        self.y = pos_y
        self.x_size = POLYGON_SIZE
        self.y_size = POLYGON_SIZE
        self.line = []
        self.line_idx = []         # Lxx line index
        self.position = 'Left'     # current position on compornent widget Left/Right/Top/Bottom
        self.textwin = 'non'
        self.tag = 'in'
        self.points = []
        self.createWidget()

    def getConfig(self, name) :
        """x,yɸ⤷position

        []
        name -- ͤΥե饰ꤹ
                ե饰'x', 'y', 'position'

        []
        void
        """
        if name == 'x' :
            return self.x      
        elif name == 'y' :
            return self.y  
        elif name == 'position' :
            return self.position  
        else :    
            return None

    def removeWidget(self, dc, rot=0):
        """ݡȿ޷򥭥ХDC夫

        []
        dc     -- 褹ǥХƥȤ
        rot    -- κݤꤹ롣ʲžǻѡ
                  0:  /  1:ʤ

        []
        void
        """
        canvas = self.body.GetCanvas()
        self.body.Erase(dc)
        self.body.RemoveFromCanvas(canvas)

        # line
        if rot == 0:
            line_list = copy.deepcopy(self.line_idx)
            for idx in line_list:
                canvas.line[idx].removeWidget(dc)
                if idx in canvas.line.keys():
                    del canvas.line[idx]
            self.line_idx = []

    def createWidget(self):
        """ݡȿ޷

        []
        ʤ

        []
        void
        """
        self.color = INACTIVE_COLOR
        # ɸ
        self.dcoords()
        # ޷
        self.body = makeInportPolygon(self, self.points)
        # ٥Ȥ޷γ
        self.parent.parent.MyAddShape(
            self.body, self.x+POLYGON_SIZE/2-1, self.y+POLYGON_SIZE/2-1, wx.Pen(OUTLINE_COLOR, 1), wx.Brush(self.color, wx.SOLID), "" , 1)

    def dmove(self, dc, movex, movey):
        """ݡȿ޷ΰư
        ݡȤ˳դƤƱ˰ư

        []
        dc     -- 褹ǥХƥȤ
        movex  -- ɸаư̤
        movey  -- ɸаư̤

        []
        void
        """
        canvas = self.body.GetCanvas()
        canvas.PrepareDC(dc)

        self.body.Erase(dc)
        self.x = self.body.GetX() + movex
        self.y = self.body.GetY() + movey
        self.body.Move(dc, self.x, self.y)

        # line
        for line_index in self.line_idx:
            canvas.line[line_index].setStartPoint(dc, movex, movey)

    def delLineIdx(self,idx):
        """ݡȤ˳դΥǥå

        []
        idx   -- Υǥå

        []
        void
        """
        if idx in self.line_idx:
            tmp = self.line_idx.index(idx)
            del self.line_idx[tmp]

    def selected(self):
        """ݡȤ֤ˤ

        []
        ʤ

        []
        void
        """
        self.body.SetBrush(wx.Brush(wx.NamedColor(SELECTED_COLOR)))
        self.body.Flash()

    def unselected(self,dc):
        """ݡȤ֤ˤ

        []
        ʤ

        []
        void
        """
        self.body.SetBrush(wx.Brush(wx.NamedColor(self.color)))
        self.body.Flash()

    def updatePolygonSize(self, x, y, ratioW, ratioH):
        """ݡȿ޷Υѹ

        []
        x      -- ѹΣɸ
        y      -- ѹΣɸ
        ratioW -- ѹԤWidthΥΨ
        ratioH -- ѹԤHeightΥΨ

        []
        void
        """
        movex = x - self.body.GetX()
        movey = y - self.body.GetY()
        self.x = x
        self.y = y
        # ޷žwidth,heightؤ
        if self.parent.xy_swap == 1:
            self.y_size, self.x_size = self.body.GetBoundingBoxMin()
            self.parent.py_size, self.parent.px_size = self.parent.px_size, self.parent.py_size
        else:
            self.x_size, self.y_size = self.body.GetBoundingBoxMin()

        # ݥꥴ󥵥κƷ׻
        self.parent.px_size = self.x_size
        self.parent.py_size = self.y_size
        canvas = self.body.GetCanvas()
        dc = wx.ClientDC(canvas)
        canvas.PrepareDC(dc)
        brush = self.body.GetBrush()
        # ޷򥭥ХDC夫
        self.body.Erase(dc)
        self.body.RemoveFromCanvas(canvas)
        # ɸκ
        self.dcoords()
        self.body.updateInportPolygon(self.points)
        # ޷˥٥Ȥ
        self.parent.parent.MyAddShape(
            self.body, self.x , self.y,
            wx.Pen(OUTLINE_COLOR, 1), brush, "" , 1)

        # ʥݡȤΰ֤˹碌ư
        for line_index in self.line_idx:
            canvas.line[line_index].setStartPoint(dc, movex, movey)

    def connect(self, line_idx):
        """ͥȽ(ΥǥåǼ

        []
        line_idx   -- ݡȤ³Υǥå

        []
        ݥե饰 -- 0:顼(֥ȥե̵ / 1:
        """
        ref = self.ns_dict.GetObjRefToFullpath(self.fullpath)
        if not ref:
            return 0
        else:
            self.line_idx.append(line_idx)
            return 1

    def disconnect(self, line_idx):
        """ǥͥȽ(Υǥå

        []
        line_idx   -- ݡȤ³ƤΥǥå

        []
        ݥե饰 -- 0:顼 / 1:
        """
        if line_idx in self.line_idx:
            self.delLineIdx(line_idx)
            return 1
        else:
            return 0

    def dcoords(self):
        """ݡȿ޷κɸ
        ߤposition򸫤ƿ޷θꤹ
        ĺ(x,y)Υץ

        []
        ʤ

        []
        void
        """
        if self.position == 'Left':
            self.points = [ (self.x + self.x_size/2-1, self.y + self.y_size/2),
                            (self.x,  self.y),
                            (self.x + self.x_size ,    self.y),
                            (self.x + self.x_size ,    self.y + self.y_size ),
                            (self.x ,    self.y + self.y_size ),
                            (self.x + self.x_size/2-1,    self.y + self.y_size/2)
                          ]
        elif self.position == 'Right' :
            self.points = [ (self.x+self.x_size/2+1, self.y+self.y_size/2),
                            (self.x+self.x_size, self.y+self.y_size),
                            (self.x, self.y+self.y_size),
                            (self.x, self.y),
                            (self.x+self.x_size, self.y),
                            (self.x+self.x_size/2+1, self.y+self.y_size/2)
                          ]
        elif self.position == 'Top' :
            self.points = [ (self.x+self.x_size/2, self.y+self.y_size/2-1),
                            (self.x+self.x_size, self.y),
                            (self.x+self.x_size, self.y+self.y_size),
                            (self.x, self.y+self.y_size),
                            (self.x, self.y),
                            (self.x+self.x_size/2, self.y+self.y_size/2-1)
                          ]
        elif self.position == 'Bottom' :    
            self.points = [ (self.x+self.x_size/2, self.y+self.y_size/2+1),
                            (self.x, self.y+self.y_size),
                            (self.x, self.y),
                            (self.x+self.x_size, self.y),
                            (self.x+self.x_size, self.y+self.y_size),
                            (self.x+self.x_size/2, self.y+self.y_size/2+1)
                          ]

#----------------------------------------------------------------------
class GRtcOut(ogl.Shape):
    """ȥݡȿ޷륯饹"""
    def __init__(self, parent, ns_dict, fullpath, outp, pos_x, pos_y) :
        """饹νʥȥݡȿ޷κ

        []
        parent     -- ƥ饹ꤹ
        ns_data -- ݡͥȤΥǥʥ꡼
        inp        -- ݡȤΥǥʥ꡼(in_list[n])
        pos_x      -- ݡȿ޷Σɸ
        pos_y      -- ݡȿ޷Σɸ

        []
        void
        """
        ogl.Shape.__init__(self)
        self.parent = parent
        self.ns_dict = ns_dict
        self.fullpath = fullpath
        self.outport = outp
        self.x = pos_x
        self.y = pos_y
        self.x_size = POLYGON_SIZE
        self.y_size = POLYGON_SIZE
        self.line = []
        self.line_idx = []         # Lxx line index
        self.position = 'Right'     # current position on compornent widget Left/Right/Top/Bottom
        self.textwin = 'non'
        self.isInactive = 0
        self.tag = 'out'
        self.uuid = {}
        self.subscription_type = RTM.OPS_NEW
        self.createWidget()

    def refresh(self):
        """եå
        ߤ³InportΥ֥ȥե󥹤¸ߤ뤫ˤ
        å³֤³⤷unsubscribe¹Ԥ

        []
        ʤ

        []
        void
        """
        canvas = self.body.GetCanvas()
        if canvas.viewMode == True:
            return

        dc = wx.ClientDC(canvas)
        canvas.PrepareDC(dc)
        for idx in self.line_idx:
            # for line 
            try:
                # g_inp update
                # state get ??
                for inp in self.parent.in_list :
                    if inp['name'] == canvas.line[idx].g_inp.inport['name']:
                        canvas.line[idx].g_inp.inport = inp
                        break

                ref = canvas.line[idx].g_inp.inport['ref']
                ref = ref._narrow(RTM.InPort)
            except :
                except_mess('inport object-ref failure:%s\n'%inp['name'])
                setBodyColor(canvas.line[idx].g_inp.body, 'inactive')
                try :  
                    ref = self.outport['ref']
                    ref = ref._narrow(RTM.OutPort)
                    rslt = ref.unsubscribe(self.uuid[idx])
                    print "refresh:unsubscribe:",rslt
                    if rslt != 0:
                        print 'unsubscribe failure: rslt=',rslt
                except :
                    except_mess('unsubscribe failure:')

    def getConfig(self, name) :
        """x,yɸ⤷position

        []
        name -- ͤΥե饰ꤹ
                ե饰'x', 'y', 'position'

        []
        void
        """
        if name == 'x' :
            return self.x      
        elif name == 'y' :
            return self.y  
        elif name == 'position' :
            return self.position  
        else :    
            return None

    def removeWidget(self, dc, rot=0):
        """ȥݡȿ޷

        []
        dc     -- 褹ǥХƥȤ
        rot    -- κݤꤹ롣ʲžǻѡ
                  0:  /  1:ʤ

        []
        void
        """
        canvas = self.body.GetCanvas()
        self.body.Erase(dc)
        self.body.RemoveFromCanvas(canvas)

        # line
        if rot == 0:
            line_list = copy.deepcopy(self.line_idx)
            for idx in line_list:
                canvas.line[idx].removeWidget(dc)
                if idx in canvas.line.keys():
                    del canvas.line[idx]
            self.line_idx = []

    def createWidget(self):
        """ȥݡȿ޷

        []
        ʤ

        []
        void
        """
        self.color = INACTIVE_COLOR
        # ɸ
        self.dcoords()
        # ޷
        self.body = makeOutportPolygon(self, self.points)
        # ٥Ȥ޷γ
        self.parent.parent.MyAddShape(
            self.body, self.x+POLYGON_SIZE/2-1, self.y+POLYGON_SIZE/2-1, wx.Pen(OUTLINE_COLOR, 1), wx.Brush(self.color, wx.SOLID), "",1)

    def dmove(self, dc, movex, movey):
        """ȥݡȿ޷ΰư
        ȥݡȤ˳դƤƱ˰ư

        []
        dc     -- 褹ǥХƥȤ
        movex  -- ɸаư̤
        movey  -- ɸаư̤

        []
        void
        """
        canvas = self.body.GetCanvas()
        canvas.PrepareDC(dc)

        self.x = self.body.GetX() + movex
        self.y = self.body.GetY() + movey
        self.body.Erase(dc)
        self.body.Move(dc, self.x, self.y)

        # line
        num = 0
        for line_index in self.line_idx:
            canvas.line[line_index].setEndPoint(dc, self.body,movex, movey)
            num = num+1

    def delLineIdx(self, idx):
        """ȥݡȤ˳դΥǥå

        []
        idx    -- Υǥå

        []
        void
        """
        if idx in self.line_idx:
            tmp = self.line_idx.index(idx)
            del self.line_idx[tmp]

    def selected(self):
        """ȥݡȤ֤ˤ

        []
        ʤ

        []
        void
        """
        self.body.SetBrush(wx.Brush(wx.NamedColor(SELECTED_COLOR)))
        self.body.Flash()

    def unselected(self,dc):
        """ȥݡȤ֤ˤ

        []
        ʤ

        []
        void
        """
        self.body.SetBrush(wx.Brush(wx.NamedColor(self.color)))
        self.body.Flash()

    def updatePolygonSize(self, x, y, ratioW, ratioH):
        """ȥݡȿ޷Υѹ

        []
        x      -- ѹΣɸ
        y      -- ѹΣɸ
        ratioW -- ѹԤWidthΥΨ
        ratioH -- ѹԤHeightΥΨ

        []
        void
        """
        movex =  x - self.body.GetX()
        movey =  y - self.body.GetY()
        self.x = x
        self.y = y
        # ޷žwidth,heightؤ
        if self.parent.xy_swap == 1:
            self.y_size, self.x_size = self.body.GetBoundingBoxMin()
            self.parent.py_size, self.parent.px_size = self.parent.px_size, self.parent.py_size
        else:
            self.x_size, self.y_size = self.body.GetBoundingBoxMin()
        # ݥꥴ󥵥κƷ׻
        self.parent.px_size = self.x_size
        self.parent.py_size = self.y_size
        canvas = self.body.GetCanvas()
        dc = wx.ClientDC(canvas)
        canvas.PrepareDC(dc)
        brush = self.body.GetBrush()
        # ޷򥭥ХDC夫
        self.body.Erase(dc)
        self.body.RemoveFromCanvas(canvas)
        # ɸκ
        self.dcoords()
        self.body.updateOutportPolygon(self.points)
        # ޷˥٥Ȥ
        self.parent.parent.MyAddShape(
            self.body, self.x , self.y,
            wx.Pen(OUTLINE_COLOR, 1), brush, "" , 1)

        # ʥȥݡȤΰ֤˹碌ư
        for line_index in self.line_idx:
            canvas.line[line_index].setEndPoint(dc, self.body,movex, movey)

    def connect2(self, line_idx, subscription_type):
        """ͥȽ(subscribeȯԡ

        []
        line_idx   -- ݡȤ³Υǥå
        subscription_type -- ֥ץ󡦥פʸ̤ѡ

        []
        ݥե饰 -- 0:顼(֥ȥե̵,subscribeԡ / 1:
        """
        canvas = self.body.GetCanvas()

        # get outport-object-ref
        ref = self.outport['ref']
        if ref == None :
            return 0  
        try:
            ref = ref._narrow(RTM.OutPort)
        except:
            except_mess('outport obj-ref failure:')
            return 0

        # get inport-object-ref
        inp_ref = canvas.line[line_idx].g_inp.inport['ref']
        try:
            inp_ref = inp_ref._narrow(RTM.InPort)
        except:
            except_mess('inport obj-ref failure:')
            return 0

        # get subscription-list
        subscription_list = []
        try:
            subscription_list = ref._get_subscriptions()
            if subscription_list == None:
                print "get subscriptions failure: return value is None."
                return 0
        except:
            except_mess('get subscriptions failure:')
            return 0

        connect_num = self.checkConnect(inp_ref, subscription_list)

        if canvas.viewMode == False:
            if connect_num == -1:
                try:
                    canvas.line[line_idx].subscription_type = subscription_type
                    canvas.line[line_idx].profile = RTM.SubscriptionProfile(subscription_type,"",None,None,False,[])
                    canvas.line[line_idx].profile.out_port = ref
                    canvas.line[line_idx].profile.in_port = inp_ref
                    rslt, canvas.line[line_idx].profile = ref.subscribe(canvas.line[line_idx].profile)
                    self.uuid[line_idx] = canvas.line[line_idx].profile.id

                    if rslt != 0:
                        print "subscribe failure!"
                except:
                    except_mess('subscribe failure:')
                print "connect2 subscribe :",self.uuid[line_idx]
            else:
                rslt = 0
                # get uuid
                self.uuid[line_idx] = subscription_list[connect_num].id
        return 1

    def connect(self, line_idx, subscription_type):
        """ͥȽ(ΥǥåǼsubscribeȯԡ

        []
        line_idx   -- ݡȤ³Υǥå
        subscription_type -- ֥ץ󡦥פʸ̤ѡ

        []
        ݥե饰 -- 0:顼(֥ȥե̵,subscribeԡ / 1:
        """
        canvas = self.body.GetCanvas()
        n = 0
        for n in range(2):    # for retry
            try:
                ref = self.outport['ref']
                if ref == None :
                    return 0  
                ref = ref._narrow(RTM.OutPort)
                break
            except:
                except_mess('outport obj-ref failure:')
                self.parent.refresh()
        if n == 2:
            print "error retry"
            return 0


        inp_ref = canvas.line[line_idx].g_inp.inport['ref']
        try:
            inp_ref = inp_ref._narrow(RTM.InPort)
        except:
            except_mess('inport obj-ref failure:')
            return 0

        # get subscription-list
        subscription_list = []
        try:
            subscription_list = ref._get_subscriptions()
            if subscription_list == None:
                print "get subscriptions failure: return value is None."
                return 0
        except:
            except_mess('get subscriptions failure:')
            return 0

        canvas.line[line_idx].subscription_type = subscription_type
        canvas.line[line_idx].profile = RTM.SubscriptionProfile(subscription_type,"",None,None,False,[])


        connect_num = self.checkConnect(inp_ref, subscription_list)
#assembly dummy
#        connect_num = -1
#assembly dummy

        rslt = 0
        if canvas.viewMode == False:
            if connect_num == -1:
                try:
                    canvas.line[line_idx].profile.out_port = ref
                    canvas.line[line_idx].profile.in_port = inp_ref
                    (rslt, canvas.line[line_idx].profile) = ref.subscribe(canvas.line[line_idx].profile)
                    if rslt != 0:
                        print "subscribe failuer! :rslt=",rslt
                    self.uuid[line_idx] = canvas.line[line_idx].profile.id
                    print "connect subscribe :",self.uuid[line_idx]
                except:
                    err_mess =  'subscribe failure! :'
                    except_mess(err_mess)
            else:
                rslt = 0
                # get uuid
                self.uuid[line_idx] = subscription_list[connect_num].id

        if rslt :
            print "subsrcibe-rslt:",rslt
            return 0
        else :
            self.line_idx.append(line_idx)
            self.isInactive = self.isInactive + 1
            return 1

    def disconnect(self, line_idx):
        """ǥͥȽ(Υǥåunsubscribeȯԡ

        []
        line_idx   -- ȥݡȤ³ƤΥǥå

        []
        ݥե饰 -- 0:顼 / 1:
        """
        if self.isInactive == 1 :
            setBodyColor(self.body, 'inactive')

        canvas = self.body.GetCanvas()

        n = 0
        for n in range(2):    # for retry
            ref = self.outport['ref']
            try:
                ref = ref._narrow(RTM.OutPort)

                inp_obj = canvas.line[line_idx].g_inp.inport['ref']

                # get subscription-list
                subscription_list = []
                subscription_list = ref._get_subscriptions()
                if subscription_list == None:
                    print "get subscriptions failure: return value is None."
                    return 0

                connect_num = self.checkConnect(inp_obj, subscription_list)
#assembly dummy
#                connect_num = 0
#assembly dummy
                break
            except:
                err_mess =  'outport disconnect failure:'
                except_mess(err_mess)
                connect_num = -1
                self.parent.refresh()

        if n == 2: # bad connect
            return 0

        if ref != None and canvas.viewMode == False and connect_num != -1:
            try :
                print "unsubscribe :",self.uuid[line_idx]
                rslt = ref.unsubscribe(self.uuid[line_idx])
                if rslt != 0:
                    print 'unsubscribe failure: rslt=',rslt
            except :
                err_mess = 'unsubscribe failure:'
                except_mess(err_mess)

        self.isInactive = self.isInactive - 1

        if line_idx in self.line_idx:
            self.delLineIdx(line_idx)
            return 1
        else :
            return 0

    def remakeLines(self):
        """³
        ֥Ⱦ¸ߤ³(subscribe)򸡺

        []
        ʤ

        []
        void
        """
# assembly dummy process
#        return
# assembly dummy process

        canvas = self.body.GetCanvas()
        dc = wx.ClientDC(canvas)
        canvas.PrepareDC(dc)

        ref = self.outport['ref']
        try:
            ref = ref._narrow(RTM.OutPort)
        except:
            err_mess =  'outport obj-ref failure:'
            except_mess(err_mess)
            return

        # get subscription-list
        subscription_list = []
        subscr_list_tmp = []
        try:
            subscription_list = ref._get_subscriptions()
            subscr_list_tmp = copy.deepcopy(subscription_list)
            if subscription_list == None:
                print "get subscriptions failure: return value is None."
                return
        except:
            except_mess('get subscriptions failure:')
            return

        for line_idx in self.line_idx:
            line = canvas.line[line_idx]
            (ret2,subscr_list_tmp) = self.checkConnect2(line,subscr_list_tmp)

        rtc_list = self.parent.parent.rtc_list
        rtc_dict = self.parent.parent.rtc_dict
        ret_name = []
        ret_obj = []
        ret_ref = []

        for subscr in subscr_list_tmp:
            inp_ref = subscr.in_port
            for fullname in rtc_list:
                in_list = rtc_dict[fullname].in_list
                in_dict = rtc_dict[fullname].in_dict

                for inp in in_list:
                    if inp['name'] in in_dict.keys():
                        ref = in_dict[inp['name']].inport['ref']
                        if inp_ref._is_equivalent(ref):
                            print "_is_equivalent is OK!!!"
                            ret_name.append( inp['name'] )
                            ret_obj.append( in_dict[inp['name']] )
                            ret_ref.append(inp_ref)

        for num in range(len(ret_name)):
            canvas.lineFrom = self.body
            canvas.lineTo = ret_obj[num].body
            line = GRtcLine(canvas,self)
            line.setLine2port(canvas, dc)

            self.line_idx.append(line.idx)
            self.isInactive = self.isInactive + 1
            connect_num = self.checkConnect(ret_ref[num], subscription_list)
            # get uuid
            self.uuid[line.idx] = subscription_list[connect_num].id

        canvas.lineFrom = None
        canvas.lineTo = None
        canvas.Redraw(dc)


    def checkOtherConnect(self):
        """Ť³󤬤뤫å
        ̾ʳ³֥Ⱦˤ뤫å

        []
        ʤ

        []
        ret  ---  True: / False:ʤ
        """
        ret = False
        canvas = self.body.GetCanvas()
        ref = self.outport['ref']
        try:
            ref = ref._narrow(RTM.OutPort)
        except:
            err_mess = 'outport obj-ref failure:'
            except_mess(err_mess)
            return ret

        # get subscription-list
        subscription_list = []
        try:
            subscription_list = ref._get_subscriptions()
            if subscription_list == None:
                print "get subscriptions failure: return value is None."
                return ret
        except:
            except_mess('get subscriptions failure:')
            return ret

        for line_idx in self.line_idx:
            line = canvas.line[line_idx]
            (ret2,subscription_list) = self.checkConnect2(line,subscription_list)
        if len(subscription_list) > 0:
            ret = True
        return ret

    def checkConnect(self, inp_obj, subscr_list):
        """³å
        ꤷ³inportˤΥե󥹤뤫å

        []
        inp_obj  ---  ݡȤΥ֥ȡե
        ref_list ---  ݡȤΥե󥹡ꥹ

        []
        ret_num --- subScription_list ź/ʤ-1
        """
        ret = False
        ret_num = 0
        for subscr in subscr_list:
            ref_inp = subscr.in_port
            if ref_inp._is_equivalent(inp_obj):
                print "checkConnect: _is_equivalent is OK!!!"
                ret = True
                break
            ret_num = ret_num + 1
        if ret == False:
            ret_num = -1
        return ret_num

    def checkConnect2(self, line, subscr_list):
        """³å
        åоݤ³äϡꥹȾ夫ֵѤ
        Ť󤬤뤫Ĵ٤٤˸ƤФ

        []
        line      ---  Υ֥
        ref_list  ---  ³inportˤΥ֥ȥե󥹡ꥹ

        []
        (ret, ref_list) --- ret 0:ʤ / 1: , ref_list: ĤΥե󥹥ꥹ
        """

        inp_obj = line.g_inp.inport['ref']

        cnt = 0
        ret = 0
        for subscr in subscr_list:
            ref_inp = subscr.in_port
            if ref_inp._is_equivalent(inp_obj):
#                print "checkConnect2: _is_equivalent is OK!!!"
                ret = 1
                break
            cnt = cnt + 1
        if ret == 1:
            del subscr_list[cnt]

        return (ret, subscr_list)

    def disconnectToObjref(self,subscr_list):
        """ݡͥȾ³subscribeˤ

        []
        inp_list  ---  ³subscriptionProfileˤΥꥹ

        []
        void
        """
#assembly: for debug:
#        print "disconnectToObjref : it's dummy for debug!"
#        return      # for debug
#for debug:

        canvas = self.body.GetCanvas()
        ref = self.outport['ref']
        ref = ref._narrow(RTM.OutPort)

        for subscr in subscr_list:
            inp = subscr.in_port
#            print "test:",dir(inp)
            #get uuid
            connect_num = self.checkConnect(inp, subscr_list)
            uuid = subscr_list[connect_num].id

            if ref != None and canvas.viewMode == False:
                try :
                    print "unsubscribe2 :",uuid
                    rslt = ref.unsubscribe(uuid)
                    if rslt != 0:
                        print 'unsubscribe2 failure: rslt=',rslt
                except :
                    err_mess = 'unsubscribe failure:'
                    except_mess(err_mess)


    def reConnectLine(self):
        """³

        []
        ʤ

        []
        void
        """
#assembly dummy
#        return
#assembly dummy

        canvas = self.body.GetCanvas()
        ref = self.outport['ref']
        try:
            ref = ref._narrow(RTM.OutPort)
        except:
            err_mess = 'outport obj-ref failure:'
            except_mess(err_mess)
            return

        # get subscription-list
        subscription_list = []
        subscr_list_tmp = []
        try:
            subscription_list = ref._get_subscriptions()
            subscr_list_tmp = copy.deepcopy(subscription_list)
            if subscription_list == None:
                print "get subscriptions failure: return value is None."
                return
        except:
            except_mess('get subscriptions failure:')
            return

        for line_idx in self.line_idx:
            line = canvas.line[line_idx]
            (ret,subscr_list_tmp) = self.checkConnect2(line,subscr_list_tmp)
            if ret == 0:
                self.connect2(line_idx,line.subscription_type)
            else:
                # get uuid
                inp_ref = canvas.line[line_idx].g_inp.inport['ref']
                connect_num = self.checkConnect(inp_ref, subscription_list)
                self.uuid[line_idx] = subscription_list[connect_num].id

		# ³ϳ줿subscribeθСnaming-serviceΥߡ
        for line_idx in self.line_idx:
            line = canvas.line[line_idx]
            (ret,subscr_list_tmp) = self.checkConnect2(line,subscr_list_tmp)
            if ret == 0:
                self.connect2(line_idx,line.subscription_type)
        if len(subscr_list_tmp) > 0:
#            print "reconnect "
            self.disconnectToObjref(subscr_list_tmp)

    def dcoords(self):
        """ȥݡȿ޷κɸ
        ߤposition򸫤ƿ޷θꤹ
        ĺ(x,y)Υץ

        []
        ʤ

        []
        void
        """
        if self.position == 'Left':
            self.points = [ (self.x, self.y+self.y_size/2),
                            ( self.x+self.x_size/2, self.y),
                            ( self.x+self.x_size, self.y),
                            ( self.x+self.x_size, self.y+self.y_size),
                            ( self.x+self.x_size/2, self.y+self.y_size),
                            ( self.x, self.y+self.y_size/2) ]
        elif self.position == 'Right' :
            self.points = [ ( self.x+self.x_size, self.y+self.y_size/2 ),
                            ( self.x+self.x_size/2, self.y+self.y_size ),
                            ( self.x, self.y+self.y_size ),
                            ( self.x, self.y ),
                            ( self.x+self.x_size/2, self.y ),
                            ( self.x+self.x_size, self.y+self.y_size/2) ]
        elif self.position == 'Top' :
            self.points = [ ( self.x+self.x_size/2, self.y ),
                            ( self.x+self.x_size, self.y+self.y_size/2 ),
                            ( self.x+self.x_size, self.y+self.y_size ),
                            ( self.x, self.y+self.y_size ),
                            ( self.x, self.y+self.y_size/2 ),
                            ( self.x+self.x_size/2, self.y ) ]
        elif self.position == 'Bottom' :
            self.points = [ ( self.x+self.x_size/2, self.y+self.y_size ),
                            ( self.x, self.y+self.y_size/2 ),
                            ( self.x, self.y ),
                            ( self.x+self.x_size, self.y ),
                            ( self.x+self.x_size, self.y+self.y_size/2 ),
                            ( self.x+self.x_size/2, self.y+self.y_size ) ]

#----------------------------------------------------------------------
class GRtc(ogl.Shape):
    """ݡͥȿ޷Τ륯饹"""
    def __init__(self, parent, fullpath, pos_x, pos_y):
        """饹νʥݡͥȿ޷κ

        []
        parent     -- ƥ饹ꤹ
        fullpath   -- ݡͥȤΥ󥰥͡
        pos_x      -- ݡͥȿ޷Σɸ
        pos_y      -- ݡͥȿ޷Σɸ

        []
        void
        """
        ogl.Shape.__init__(self)
        self.parent = parent
        self.fullpath = fullpath
        self.ns_dict = self.parent.frame.myDict
#        print "check cur_dict:",cur_dict[0]
        self.name = self.ns_dict.GetCompName(fullpath)
        self.in_list = self.ns_dict.GetInPortToRef(fullpath)
        self.out_list = self.ns_dict.GetOutPortToRef(fullpath)

        self.x = pos_x
        self.y = pos_y
        self.color = INACTIVE_COLOR
        self.state = 'inactive'
        self.x_size = BOX_WIDTH
        self.y_size = BOX_WIDTH
        self.ratioW = 1.0
        self.ratioH = 1.0
        self.rotTogle = 0
        self.revTogle = 1
        self.lastRot = 'LR'   # LR(Left/Right) or TB(Top/Bottom)
        self.xy_swap = 0
        self.mark = None
        self.tag = 'body'
        self.text = None
        self.lastBBoxWidth = 0
        self.lastBBoxHeight = 0
        self.text_x = 0
        self.text_y = 0
        self.px_size = POLYGON_SIZE
        self.py_size = POLYGON_SIZE
        tmp = max(len(self.in_list), len(self.out_list))
        self.minWidth = self.x_size
        self.minHeight = 2 * POLYGON_SIZE * tmp
#        self.blink = blinkTimer()
        self.createWidget(0)

    def remakeLines(self):
# assembly dummy process
#        return
# assembly dummy process
        for outp in self.out_list :
            if outp['name'] in self.out_dict.keys():
                self.out_dict[outp['name']].remakeLines()

    def checkOtherConnect(self):
        """Ť³ʲ̾ɽƤʤsubscribeˤå

        []
        ʤ

        []
        ret   ---  True:Ť󤢤 / False:Ťʤ
        """
        ret = False
        for outp in self.out_list :
            if outp['name'] in self.out_dict.keys():
                ret = self.out_dict[outp['name']].checkOtherConnect()
                if ret == True:
                    break
        return ret

    def reConnectLine(self):
        """³
        ݡͥȤΥȥݡȤκ³ƤӽФ

        []
        ʤ

        []
        void
        """
        for outp in self.out_list :
            if outp['name'] in self.out_dict.keys():
                self.out_dict[outp['name']].reConnectLine()

    def portToFlash(self):
        """ݡ(Shape)Flashʺ衩ˤƤӽФ
        ݡͥȤγβ˥ݡȤγ⤰ॱλ˸ƤӽФƤ롣ʲ
        ¾ɤСѹ

        []
        ʤ

        []
        void
        """
        for inp in self.in_list :
            if inp['name'] in self.in_dict.keys():
                self.in_dict[inp['name']].body.Flash()
        for outp in self.out_list :
            if outp['name'] in self.out_dict.keys():
                self.out_dict[outp['name']].body.Flash()

    def checkCompState(self):
        """ݡͥȤΥơå

        []
        ʤ

        []
        void
        """
        state = 'inactive'

        canvas = self.body.GetCanvas()
        tmp = self.ns_dict.GetCompState(self.fullpath)
        if tmp == RTM.RTComponent.RTC_STARTING or tmp == RTM.RTComponent.RTC_ACTIVE:
            state = 'active'
        elif tmp == RTM.RTComponent.RTC_READY or tmp == RTM.RTComponent.RTC_STOPPING:
            state = 'inactive'
        elif tmp >= RTM.RTComponent.RTC_ABORTING :
            state = 'error'
        else:   # unknown , born?, initializing
            state = 'unloaded'
        if canvas.viewMode == True and state != 'unloaded':
            state = 'virtual'

        self.state = state

    def ref_start(self):
        """ݡͥȤstart̿ȯ

        []
        ʤ

        []
        void
        """
        try:
            ref = self.ns_dict.GetObjRefToFullpath(self.fullpath)
            ref = ref._narrow(RTM.RTCBase)
            ref.rtc_start()
        except :
            err_mess = 'rtc_start error:%s\n'%self.fullpath
            except_mess(err_mess)
        self.checkCompState()
#        setBodyColor(self.baseBox, self.state)
#        setBodyColor(self.baseBox, 'active')
        self.ns_dict.setCompBodyColor(self.fullpath, 'active')
        self.state = 'active'
        self.portToFlash()

    def ref_stop(self):
        """ݡͥȤstop̿ȯ

        []
        ʤ

        []
        void
        """
        try:
            ref = self.ns_dict.GetObjRefToFullpath(self.fullpath)
            ref = ref._narrow(RTM.RTCBase)
            ref.rtc_stop()
        except :
            err_mess = 'rtc_stop error:%s\n'%self.fullpath
            except_mess(err_mess)
        self.checkCompState()
#        setBodyColor(self.baseBox, self.state)
#        setBodyColor(self.baseBox, 'inactive')
        self.ns_dict.setCompBodyColor(self.fullpath, 'inactive')
        self.state = 'inactive'
        self.portToFlash()

    def ref_reset(self):
        """ݡͥȤreset̿ȯ

        []
        ʤ

        []
        void
        """
        try:
            ref = self.ns_dict.GetObjRefToFullpath(self.fullpath)
            ref = ref._narrow(RTM.RTCBase)
            ref.rtc_reset()
        except :
            err_mess = 'rtc_reset error:%s\n'%self.fullpath
            except_mess(err_mess)
#        self.checkCompState()
#        setBodyColor(self.baseBox, self.state)
        self.ns_dict.setCompBodyColor(self.fullpath, self.state)
        self.portToFlash()

    def ref_kill(self):
        """ݡͥȤkill̿ȯ

        []
        ʤ

        []
        void
        """
        try:
            ref = self.ns_dict.GetObjRefToFullpath(self.fullpath)
            ref = ref._narrow(RTM.RTCBase)
            ref.rtc_kill()
        except :
            err_mess = 'rtc_kill error:%s\n'%self.fullpath
            except_mess(err_mess)
        self.checkCompState()
#        setBodyColor(self.baseBox, self.state)
#        setBodyColor(self.baseBox, 'inactive')
        self.ns_dict.setCompBodyColor(self.fullpath, 'unloaded')
        self.state = 'inactive'
        self.portToFlash()

    def ref_exit(self):
        """ݡͥȤexit̿ȯ

        []
        ʤ

        []
        void
        """
        try:
            ref = self.ns_dict.GetObjRefToFullpath(self.fullpath)
            ref = ref._narrow(RTM.RTCBase)
            ref.rtc_exit()
        except :
            err_mess = 'rtc_exit error:%s\n'%self.fullpath
            except_mess(err_mess)
        self.checkCompState()
#        setBodyColor(self.baseBox, self.state)
#        setBodyColor(self.baseBox, 'unloaded')
        self.ns_dict.setCompBodyColor(self.fullpath, 'unloaded')
        self.state = 'unloaded'
        self.portToFlash()

    def changeBodyColor(self,state):
        """ơˤꥳݡͥȤοꤹ

        []
        state  ---  ݡͥȤξ֤ꤹ
                    'active','inactive','error',unloaded','virtual'

        []
        void
        """
        if state == 'unloaded':
            self.state = 'unloaded'
            self.color = UNLOADED_COLOR
        elif state == 'active' :
            self.state = 'active'
            self.color = ACTIVE_COLOR
        elif state == 'inactive':
            self.state = 'inactive'
            self.color = INACTIVE_COLOR
        elif state == 'error' :
            self.state = 'error'
            self.color = ERROR_COLOR
#        canvas = self.body.GetCanvas()
        canvas = self.parent.diagram.GetCanvas()
        dc = wx.ClientDC(canvas)
        canvas.PrepareDC(dc)
        if canvas.viewMode == True and self.state != 'unloaded':
            self.state = 'virtual'
            self.color = VIRTUAL_COLOR
        setBodyColor(self.baseBox, self.state)
        self.portToFlash()
        canvas.Redraw(dc)

    def refresh_outp(self):
        """ȥݡȤrefresh

        []
        ʤ

        []
        void
        """
        for outp in self.out_list :
            if outp['name'] in self.out_dict.keys():
                self.out_dict[outp['name']].refresh()

    def refresh(self):
        """եå
        ݡͥȤstateե饰Ǹߤξ֡active,error,inactiveˤ

        []
        ʤ

        []
        void
        """
        old_state = self.state
        canvas = self.body.GetCanvas()
        dc = wx.ClientDC(canvas)
        canvas.PrepareDC(dc)
        try :  
            ref = self.ns_dict.GetObjRefToFullpath(self.fullpath)
            ref = ref._narrow(RTM.RTCBase)
            tmp_port = ref._get_rtc_state()
            tmp_port = tmp_port._narrow(RTM.OutPort)
            tmp = tmp_port.get()
            tmp = tmp.value()
            tmp = tmp.data
            print "refresh state:",tmp
        except :
            except_mess("except error:")
            ref = None

        if not ref:
            self.state = 'unloaded'
            self.color = UNLOADED_COLOR
        else:
            self.name = self.ns_dict.GetCompName(self.fullpath)
            self.in_list = self.ns_dict.GetInPortToRef(self.fullpath)
            self.out_list = self.ns_dict.GetOutPortToRef(self.fullpath)

            for outp in self.out_list :
                if outp['name'] in self.out_dict.keys():
                    self.out_dict[outp['name']].outport = outp
            for inp in self.in_list :
                if inp['name'] in self.in_dict.keys():
                    self.in_dict[inp['name']].inport = inp


            if tmp == RTM.RTComponent.RTC_STARTING or tmp == RTM.RTComponent.RTC_ACTIVE:
                self.state = 'active'
                self.color = ACTIVE_COLOR
            elif tmp == RTM.RTComponent.RTC_STOPPING or tmp == RTM.RTComponent.RTC_READY:
                self.state = 'inactive'
                self.color = INACTIVE_COLOR
            elif tmp >= RTM.RTComponent.RTC_ABORTING :
                self.state = 'error'
                self.color = ERROR_COLOR
            else :
                self.state = 'unloaded'
                self.color = UNLOADED_COLOR

#            if old_state == 'unloaded' and self.state != 'unloaded':
            if len(self.out_dict.keys()) != len(self.out_list):
                self.removeWidget(dc,0)

                old_rot = self.rotTogle
                old_rev = self.revTogle
                old_lastrot = self.lastRot
                self.rotTogle = 0
                self.revTogle = 1
                self.lastRot = 'LR'   # LR(Left/Right) or TB(Top/Bottom)
                self.x_size = BOX_WIDTH
                self.x = self.x - self.x_size/2
                self.y = self.y - self.y_size/2
                self.ratioW = 1.0
                self.ratioH = 1.0
                self.createWidget(0)
                if old_lastrot == 'LR':
                    if old_rev == 0:
                        self.reversesBody()
                else:
                    if old_rot == 1:
                        self.rotatesBody()
                    else:
                        self.rotatesBody()
                        self.rotatesBody()

#        setBodyColor(self.baseBox, self.state)
        self.ns_dict.setCompBodyColor(self.fullpath, self.state)
        self.portToFlash()
        canvas.Redraw(dc)

    def removeWidget(self, dc, rot=0):
        """ݡͥȿ޷
        ݡȿ޷ȥݡȿ޷Ϣ

        []
        dc     -- 褹ǥХƥȤ
        rot    -- κݤꤹ롣ʲžǻѡ
                  0:  /  1:ʤ

        []
        void
        """
        # ο޷򥭥ХDC夫
        canvas = self.body.GetCanvas()
        self.body.Erase(dc)
        self.body.RemoveFromCanvas(canvas)

        # ӥåȥޥåפκ
        if self.bmp:
            self.bmp.Erase(dc)
            self.bmp.RemoveFromCanvas(canvas)

        # ݡͥ̾Τκ
        self.text.Erase(dc)
        self.text.RemoveFromCanvas(canvas)

        # ݡȡȥݡȤκ
        for inp in self.in_list:
            if inp['name'] in self.in_dict.keys():
                self.in_dict[inp['name']].removeWidget(dc,rot)
        for outp in self.out_list:
            if outp['name'] in self.out_dict.keys():
                self.out_dict[outp['name']].removeWidget(dc,rot)


    def createWidget(self, rot):
        """ݡͥȿ޷κ

        []
        rot     -- ޷βžԤե饰
                   0:žʤʺɸ׻ǵ 1:ž(¸κɸѡ

        []
        void
        """
        if rot == 0:
            tmp = max(len(self.in_list), len(self.out_list))
            if tmp == 0:
                tmp = 1
            self.y_size = 2 * POLYGON_SIZE * self.ratioH * tmp
            pos_x = self.x + (BOX_WIDTH * self.ratioW)/2
            pos_y = self.y + self.y_size/2
        else:
            pos_x = self.x
            pos_y = self.y

        # ݡͥ̾(TextShape)κ
        canvas = self.parent.diagram.GetCanvas()
        dc = wx.ClientDC(canvas)
        canvas.PrepareDC(dc)
        cnt = len(self.name)
        charW = dc.GetCharWidth()
        charH = dc.GetCharHeight()
        tmpW = charW * (cnt*1.2)
        tmpH = charH * 1.4
        self.text_x = pos_x + (self.x_size/2)
        self.text_y = self.y + self.y_size + POLYGON_SIZE

        self.text = makeTextShape(self,tmpW, tmpH)
        self.text.AddText(self.name)
        self.parent.MyAddText(self.text, self.text_x, self.text_y,wx.BLACK_PEN)
###
        # ӥåȥޥåפκ
        self.bmp = ogl.BitmapShape()
#        if self.rtc.icon_path != None or self.rtc.icon_path != "":
#        if self.rtc.icon_path != "":
#            bitmap = wx.Bitmap(self.rtc.icon_path)
#        else:
#            bitmap = wx.NullBitmap
#            self.bmp.SetSize(10,10,False)
        bitmap = wx.NullBitmap
        self.bmp.SetSize(10,10,False)
#
        self.bmp.SetBitmap(bitmap)
        self.bmp.parent = self
        self.parent.MyAddBmp( self.bmp, pos_x, pos_y, wx.BLACK_PEN )

        # Τλͳѷ
        self.baseBox = makeRectangle(self, self.x_size, self.y_size)
        self.parent.MyAddShape(self.baseBox, pos_x, pos_y, wx.BLACK_PEN, wx.Brush(self.color, wx.SOLID), "" ,0)
        # ҤΥѡķCompositeShapeȤơƻҹ¤ˤ
        self.body = makeCompositeShape(self)
        self.body.AddChild(self.baseBox)
        self.body.AddChild(self.bmp)
        self.body.AddChild(self.text)
#
        self.constraint = ogl.OGLConstraint(ogl.gyCONSTRAINT_ALIGNED_TOP, self.baseBox, [self.bmp])
        self.body.AddConstraint(self.constraint)
        self.constraint2 = ogl.OGLConstraint(ogl.gyCONSTRAINT_CENTRED_HORIZONTALLY, self.bmp, [self.text])
        self.body.AddConstraint(self.constraint2)
#        self.constraint = ogl.OGLConstraint(ogl.gyCONSTRAINT_CENTRED_HORIZONTALLY, self.baseBox, [self.text])
#        self.body.AddConstraint(self.constraint)
        self.body.Recompute()
        self.body.CalculateSize()
###
        self.parent.MyAddShape(
            self.body, pos_x, pos_y, wx.BLACK_PEN, wx.Brush(self.color, wx.SOLID), "" ,0)
        # Ψ׻ѤκǸκɸӳ̾ѤκǸΥ
        self.baseBox.lastx = self.body.GetX()
        self.baseBox.lasty = self.body.GetY()
        self.lastBBoxWidth, self.lastBBoxHeight = self.baseBox.GetBoundingBoxMin()

        if rot == 0:
            # ݡȤκʲžϹԤʤ
            self.in_dict = {}
            port_x = self.x - (POLYGON_SIZE*self.ratioW)*2/3
            port_y = self.y + (POLYGON_SIZE*self.ratioH)/2
            for inp in self.in_list :
                self.in_dict[inp['name']] = GRtcIn(self, self.ns_dict, self.fullpath,
                                            inp,
                                            port_x, port_y)
                port_y = port_y + (POLYGON_SIZE*self.ratioH)*2
#
            # ȥݡȤκʲžϹԤʤ
            port_x = self.x + (BOX_WIDTH*self.ratioW) - (POLYGON_SIZE*self.ratioW)/3
            port_y = self.y + (POLYGON_SIZE*self.ratioH)/2
            self.out_dict = {}
            for outp in self.out_list :
                self.out_dict[outp['name']] = GRtcOut(self, self.ns_dict, self.fullpath,
                                         outp, 
                                         port_x, port_y)
                port_y = port_y + (POLYGON_SIZE*self.ratioH)*2

        self.portToFlash()


    def dmove(self, dc, movex, movey):
        """ݡͥȿ޷ΰư
        ݡȡȥݡȿ޷ӴϢư

        []
        dc     -- 褹ǥХƥȤ
        movex  -- ɸаư̤
        movey  -- ɸаư̤

        []
        void
        """
        canvas = self.body.GetCanvas()

        self.x = self.body.GetX() + movex
        self.y = self.body.GetY() + movey
        self.body.Erase(dc)
        self.body.Move(dc, self.x, self.y)
        # ݡȡȥݡȿ޷ΰư
        for inp in self.in_list:
            if inp['name'] in self.in_dict.keys():
                self.in_dict[inp['name']].dmove(dc, movex, movey)
        for outp in self.out_list:
            if outp['name'] in self.out_dict.keys():
                self.out_dict[outp['name']].dmove(dc, movex, movey)


    def selected(self):
        """ݡͥȿ޷ʿѹ

        []
        ʤ

        []
        void
        """
        self.baseBox.SetBrush(wx.Brush(wx.NamedColor(SELECTED_COLOR)))
        self.body.Flash()
        # ݡȡȥݡȿ޷եåʺˤ޷̤ɽ
        self.portToFlash()
        
    def unselected(self,dc):
        """ݡͥȿ޷ʿѹ

        []
        dc     -- 褷ƤǥХƥȤ

        []
        void
        """
        self.checkCompState()
        setBodyColor(self.baseBox, self.state)
        # ݡȡȥݡȿ޷եåʺˤ޷̤ɽ
        self.portToFlash()

    def updatePolygonSize(self, x, y, ratioW, ratioH):
        """ݡͥȿ޷ʥݡȡȥݡȡˤΥѹ
        ݡͥȿ޷ΤΥѹϥǥեȡʥƥ¦ˤǹԤ

        []
        x      -- 褹ɸ
        y      -- 褹ɸ
        ratioW -- ѹWidthΨ
        ratioH -- ѹHeightΨ

        []
        void
        """
        self.x = x
        self.y = y
        self.ratioW = ratioW
        self.ratioH = ratioH
        self.x_size, self.y_size = self.baseBox.GetBoundingBoxMin()

        canvas = self.body.GetCanvas()
        dc = wx.ClientDC(canvas)
        canvas.PrepareDC(dc)

        # ǾΥå꾮äѹ
        if self.lastRot == 'TB':
            minW, minH = self.minHeight, self.minWidth
        else:
            minH, minW = self.minHeight, self.minWidth
        if minW > self.x_size or minH > self.y_size:
            self.ratioW = 1.0
            self.ratioH = 1.0
            self.x_size = minW
            self.y_size = minH
            # ٿ޷嵭ꤷǺƺ
            self.body.Select(False, dc)
            tmp = canvas.selected.index(self.baseBox)
            del canvas.selected[tmp]
            self.removeWidget(dc,1)
            self.createWidget(1)
            self.baseBox.Select(True, dc)
            canvas.selected.append(self.baseBox)


        x_size = self.px_size 
        y_size = self.py_size 
        # ݡȤ¸ߤݡȤΥѹ
        if len(self.in_dict) > 0:
            in_pos = self.in_dict[self.in_list[0]['name']].position

            port_x = self.x - self.x_size/2 + x_size -1
            port_y = self.y - self.y_size/2 + y_size -1
            # ݡȤpositionˤĴ
            if in_pos == 'Right':
                port_x = self.x + self.x_size/2 + x_size/6
            elif in_pos == 'Left':
                port_x = self.x - self.x_size/2 - x_size/6
            elif in_pos == 'Top':
                port_y = self.y - self.y_size/2 - y_size/6
            elif in_pos == 'Bottom':
                port_y = self.y + self.y_size/2 + y_size/6

            for inp in self.in_list:
                if inp['name'] in self.in_dict.keys():
                    self.in_dict[inp['name']].updatePolygonSize(port_x, port_y, ratioW, ratioH)
                    # ݡȤpositionˤĴ
                    if in_pos == 'Right' or in_pos == 'Left':
                        port_y = port_y + y_size*2
                    else:
                        port_x = port_x + x_size*2
#

        # ȥݡȤ¸ߤȥݡȤΥѹ
        if len(self.out_dict) > 0:
            out_pos = self.out_dict[self.out_list[0]['name']].position

            port_x = self.x - self.x_size/2 + x_size -1
            port_y = self.y - self.y_size/2 + y_size -1
            # ݡȤpositionˤĴ
            if out_pos == 'Right':
                port_x = self.x + self.x_size/2 + x_size/6
            elif out_pos == 'Left':
                port_x = self.x - self.x_size/2 - x_size/6
            elif out_pos == 'Top':
                port_y = self.y - self.y_size/2 - y_size/6
            elif out_pos == 'Bottom':
                port_y = self.y + self.y_size/2 + y_size/6

            for outp in self.out_list:
                if outp['name'] in self.out_dict.keys():
                    self.out_dict[outp['name']].updatePolygonSize(port_x, port_y, ratioW, ratioH)
                    # ݡȤpositionˤĴ
                    if out_pos == 'Right' or out_pos == 'Left':
                        port_y = port_y + y_size*2
                    else:
                        port_x = port_x + x_size*self.ratioW*2

        # ݡͥ̾ΤɽĴ
        if self.lastRot == 'LR':
            self.text_y = self.y + self.y_size/2 + POLYGON_SIZE
        else:
            self.text_y = self.y + self.y_size/2 + self.py_size
        self.text.Erase(dc)
        self.text.SetY(self.text_y)
        self.text.Flash()

        # ӥåȥޥåפɽĴ
        tmpw, tmph = self.bmp.GetBoundingBoxMin()
        pos_y = self.y - self.y_size/2 + tmph/2
        if self.lastRot != 'LR':
            pos_y = pos_y + self.py_size/2
        self.bmp.Erase(dc)
        self.bmp.SetY(pos_y)
        self.bmp.Flash()

        self.selected()
        self.portToFlash()

    def reversesBody(self):
        """ȿžʲž˽

        []
        ʤ

        []
        void
        """
        # ȥե饰ι
        self.revTogle = self.revTogle + 1
        if self.revTogle % 2 == 0 :
            self.revTogle = 0
        
        self.x = self.baseBox.GetX()
        self.y = self.baseBox.GetY()
        tmp = max(len(self.in_list), len(self.out_list))
        center_x = self.baseBox.GetX()
        center_y = self.baseBox.GetY()
        # Ǹ˺岼ɤβžԤ줿Width/Heightؤ
        if self.lastRot == 'LR':
            self.x_size, self.y_size = self.baseBox.GetBoundingBoxMin()
            self.xy_swap = 0
        else:
            self.y_size, self.x_size = self.baseBox.GetBoundingBoxMin()
            self.xy_swap = 1

        canvas = self.body.GetCanvas()
        dc = wx.ClientDC(canvas)
        canvas.PrepareDC(dc)
        # ٿ޷嵭ꤷǺƺ
        self.removeWidget(dc,1)
        self.createWidget(1)

        # ʣݡȤɽɸPOLYGON_SIZEˤ
        if self.xy_swap == 1:
            p_size = self.px_size
        else:
            p_size = self.py_size
        if self.revTogle == 1:  # inport is right side of body
            port_x = self.x - self.x_size/2 - p_size/6
            port_y = self.y - self.y_size/2 + p_size-1
            for inp in self.in_list:
                if inp['name'] in self.in_dict.keys():
                    self.in_dict[inp['name']].position = 'Left'
                    self.in_dict[inp['name']].updatePolygonSize(port_x, port_y, 1, 1)
                    port_y = port_y + p_size*2
#
            port_x = self.x + self.x_size/2 + p_size/6
            port_y = self.y - self.y_size/2 + p_size-1
            for outp in self.out_list:
                if outp['name'] in self.out_dict.keys():
                    self.out_dict[outp['name']].position = 'Right'
                    self.out_dict[outp['name']].updatePolygonSize(port_x, port_y, 1, 1)
                    port_y = port_y + p_size*2

        else :                  # inport is left side of body
            port_x = self.x + self.x_size/2 + p_size/6
            port_y = self.y - self.y_size/2 + p_size-1
            for inp in self.in_list:
                if inp['name'] in self.in_dict.keys():
                    self.in_dict[inp['name']].position = 'Right'
                    self.in_dict[inp['name']].updatePolygonSize(port_x, port_y, 1, 1)
                    port_y = port_y + p_size*2
#
            port_x = self.x - self.x_size/2 - p_size/6
            port_y = self.y - self.y_size/2 + p_size-1
            for outp in self.out_list:
                if outp['name'] in self.out_dict.keys():
                    self.out_dict[outp['name']].position = 'Left'
                    self.out_dict[outp['name']].updatePolygonSize(port_x, port_y, 1, 1)
                    port_y = port_y + p_size*2

        # ƥȤɽ֤Ʒ׻
        self.text_y = self.y + self.y_size/2 + POLYGON_SIZE
        self.text.Erase(dc)
        self.text.SetY(self.text_y)
        self.text.Flash()

        self.lastRot = 'LR'
        self.xy_swap = 0


    def rotatesBody(self):   ## +-90 degrees
        """岼ž

        []
        ʤ

        []
        void
        """
        tmp = max(len(self.in_list), len(self.out_list))
        self.x = center_x = self.baseBox.GetX()
        self.y = center_y = self.baseBox.GetY()
        # Ǹ˺岼ɤβžԤ줿Width/Heightؤ
        if self.lastRot == 'LR':
            self.y_size, self.x_size = self.baseBox.GetBoundingBoxMin()
            self.xy_swap = 1
        else:
            self.x_size, self.y_size = self.baseBox.GetBoundingBoxMin()
            self.xy_swap = 0

        canvas = self.body.GetCanvas()
        dc = wx.ClientDC(canvas)
        canvas.PrepareDC(dc)

        # ٿ޷嵭ꤷǺƺ
        self.removeWidget(dc,1)
        self.createWidget(1)


        # 岼ȥե饰ι
        self.rotTogle = self.rotTogle + 1
        if self.rotTogle % 2 == 0 :
            self.rotTogle = 0

        # ʣݡȤɽɸPOLYGON_SIZEˤ
        if self.xy_swap == 1:
            p_size = self.py_size
        else:
            p_size = self.px_size
        # ݡȡȥݡȤΥѹ
        if self.rotTogle == 1:  # inport is top side of body
            port_x = self.x - self.x_size/2 + p_size-1
            port_y = self.y - self.y_size/2 - p_size/6
            for inp in self.in_list:
                if inp['name'] in self.in_dict.keys():
                    self.in_dict[inp['name']].position = 'Top'
                    self.in_dict[inp['name']].updatePolygonSize(port_x, port_y, 1, 1)
                    port_x = port_x + p_size*2
#
            port_x = self.x - self.x_size/2 + p_size-1
            port_y = self.y + self.y_size/2 + p_size/6
            for outp in self.out_list:
                if outp['name'] in self.out_dict.keys():
                    self.out_dict[outp['name']].position = 'Bottom'
                    self.out_dict[outp['name']].updatePolygonSize(port_x, port_y, 1, 1)
                    port_x = port_x + p_size*2

        else :                  # inport is bottom side of body
            port_x = self.x - self.x_size/2 + p_size-1
            port_y = self.y + self.y_size/2 + p_size/6
            for inp in self.in_list:
                if inp['name'] in self.in_dict.keys():
                    self.in_dict[inp['name']].position = 'Bottom'
                    self.in_dict[inp['name']].updatePolygonSize(port_x, port_y, 1, 1)
                    port_x = port_x + p_size*2
#
            port_x = self.x - self.x_size/2 + p_size-1
            port_y = self.y - self.y_size/2 - p_size/6
            for outp in self.out_list:
                if outp['name'] in self.out_dict.keys():
                    self.out_dict[outp['name']].position = 'Top'
                    self.out_dict[outp['name']].updatePolygonSize(port_x, port_y, 1, 1)
                    port_x = port_x + p_size*2

        # ƥȤɽĴ
        self.text_y = self.y + self.y_size/2 + self.py_size
        self.text.Erase(dc)
        self.text.SetY(self.text_y)
        self.text.Flash()

        # ӥåȥޥåפɽĴ
        tmpw, tmph = self.bmp.GetBoundingBoxMin()
        pos_y = self.y - self.y_size/2 + tmph/2 + self.py_size/2
        self.bmp.Erase(dc)
        self.bmp.SetY(pos_y)
        self.bmp.Flash()

        self.lastRot = 'TB'
        self.xy_swap = 0

#----------------------------------------------------------------------
class MyEvtHandlerBmp(ogl.ShapeEvtHandler):
    """ӥåȥޥåѤΥߡ٥ȥ饹"""
    def __init__(self, log, frame):
        """饹ν

        []
        log     -- ϥ饹Υ֥
        frame   -- ơСΥ֥
        嵭ϡdemoץ̾ġ

        []
        void
        """
        ogl.ShapeEvtHandler.__init__(self)
        self.log = log
        self.statbarFrame = frame

    def OnEndDragLeft(self, x, y, keys = 0, attachment = 0):
        """ɥåλ˸ƤФ륤٥ȥϥɥ
        ̤passΤߡˤǥ٥ȤϿǥեȤư޻

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- å

        []
        void
        """
        pass

    def OnLeftClick(self, x, y, keys = 0, attachment = 0):
        """ޥå˸ƤФ륤٥ȥϥɥ
        ̤passΤߡˤǥ٥ȤϿǥեȤư޻

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- å

        []
        void
        """
        pass

    def OnSizingEndDragLeft(self, pt, x, y, keys, attch):
        """ѹλ˸ƤФ륤٥ȥϥɥ
        ̤passΤߡˤǥ٥ȤϿǥեȤư޻

        []
        pt         -- ȥݥ
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- å

        []
        void
        """
        pass

    def OnBeginDragLeft(self, x, y, keys, attachment):
        """ɥåϻ˸ƤФ륤٥ȥϥɥ
        ̤passΤߡˤǥ٥ȤϿǥեȤư޻

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- å

        []
        void
        """
        pass

#----------------------------------------------------------------------
class MyEvtHandlerOval(ogl.ShapeEvtHandler):
    """ưѤαߤΥ٥ȥ饹"""
    def __init__(self, log, frame):
        """饹νShapeEvtHandlerκ

        []
        log     -- ϥ饹Υ֥
        frame   -- ơСΥ֥
        嵭ϡdemoץ̾ġ

        []
        void
        """
        ogl.ShapeEvtHandler.__init__(self)
        self.log = log
        self.statbarFrame = frame

    def OnEndDragLeft(self, x, y, keys = 0, attachment = 0):
        """ɥåλ˸ƤФ륤٥ȥϥɥ
        ɥåե饰offˤ

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- åȡ̤ѡ

        []
        void
        """
        self.dragOn = 0

    def OnBeginDragLeft(self, x, y, keys=0, attachment=0):
        """ɥåϻ˸ƤФ륤٥ȥϥɥ
        ɥåե饰onˤ

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- åȡ̤ѡ

        []
        void
        """
        self.dragOn = 1

    def OnDragLeft(self, draw, x, y, keys, attachment):
        """ɥåϻ˸ƤФ륤٥ȥϥɥ
        ưѤαߤɥåǰưʱߤdmove᥽åǴϢư

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- åȡ̤ѡ

        []
        void
        """
#        self.base_OnBeginDragLeft(x, y, keys, attachment)
        shape = self.GetShape()

        if self.dragOn == 1:

            # DCBufferedDC)˳Redrawɽɽ
            canvas = shape.GetCanvas()
            dc = getBufferedDC(canvas)
            canvas.PrepareDC(dc)

            movex = x - shape.lastx
            movey = y - shape.lasty

            shape.parent.dmove(dc,movex,movey)

            shape.lastx = shape.GetX()
            shape.lasty = shape.GetY()

            canvas.Redraw(dc)

#----------------------------------------------------------------------
class MyEvtHandlerDummy(ogl.ShapeEvtHandler):
    """ߡ٥ȥϥɥ"""
    def __init__(self, log, frame):
        """饹ν

        []
        log     -- ϥ饹Υ֥
        frame   -- ơСΥ֥
        嵭ϡdemoץ̾ġ

        []
        void
        """
        ogl.ShapeEvtHandler.__init__(self)
        self.log = log
        ogl.ShapeEvtHandler.__init__(self)
        self.log = log
        self.statbarFrame = frame

    def OnEndDragLeft(self, x, y, keys = 0, attachment = 0):
        """ɥåλ˸ƤФ륤٥ȥϥɥ
        ̤passΤߡˤǥ٥ȤϿǥեȤư޻

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- åȡ̤ѡ

        []
        void
        """
        pass

    def OnDragLeft(self, draw, x, y, keys=0, attachment=0):
        """ɥå˸ƤФ륤٥ȥϥɥ
        ̤passΤߡˤǥ٥ȤϿǥեȤư޻

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- åȡ̤ѡ

        []
        void
        """
        pass

    def OnBeginDragLeft(self, x, y, keys, attachment):
        """ɥåϻ˸ƤФ륤٥ȥϥɥ
        ̤passΤߡˤǥ٥ȤϿǥեȤư޻

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- åȡ̤ѡ

        []
        void
        """
        pass

    def OnLeftClick(self, x, y, keys = 0, attachment = 0):
        """ޥå˸ƤФ륤٥ȥϥɥ
        ̤passΤߡˤǥ٥ȤϿǥեȤư޻

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- åȡ̤ѡ

        []
        void
        """
        pass


#----------------------------------------------------------------------
class MyEvtHandlerLine(ogl.ShapeEvtHandler):
    """Υ٥ȥ饹"""
    def __init__(self ):
        """饹ν

        []
        ʤ

        []
        void
        """
        ogl.ShapeEvtHandler.__init__(self)

    def OnLeftClick(self, x, y, keys = 0, attachment = 0):
        """ޥå˸ƤФ륤٥ȥϥɥ
        򡿲Ԥ
        ǤϡưѤαߤ

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- åȡ̤ѡ

        []
        void
        """
        shape = self.GetShape()
#        print shape.__class__, shape.GetClassName()
        canvas = shape.GetCanvas()
        dc = wx.ClientDC(canvas)
        canvas.PrepareDC(dc)
        # Ѥ
        if shape in canvas.selected:
            # ֤β
            for obj in shape.parent.lines:
                obj.Select(False, dc)
            shape.parent.unselected(dc)
            for obj in canvas.selected:
                if shape == obj:
                    obj.parent.unselected(dc)
                    idx = canvas.selected.index(obj)
                    del canvas.selected[idx]
        # ̤
        else:
            # ֤˰ܹ
            redraw = False
            shapeList = canvas.GetDiagram().GetShapeList()

            if canvas.selected and keys != 1:
                for s in canvas.selected:
                    s.Select(False, dc)
                    s.parent.unselected(dc)
                canvas.selected = []
                canvas.Redraw(dc)

            shape.parent.selected()

            for obj in shape.parent.lines:
                canvas.selected.append(obj)

            # create oval on line
            line = shape.parent
            if (line.coordT == None) or (len(line.coordT) == 2):
                return

            # ưѤαߤ
            num = len(line.coordT)
            line.oval_dict = {}
            for oval_id in range(1,num-2):
                line_pos_0 = line.coordT[oval_id]
                line_pos_1 = line.coordT[oval_id+1]
                if line_pos_0[0] == line_pos_1[0] and line_pos_0[1] != line_pos_1[1]: # width line
                    hight = line_pos_0[1] - line_pos_1[1]
                    pos_y = line_pos_1[1] + (hight/2)
                    pos_x = line_pos_0[0]
                    tag = (oval_id, "oval_width_pos")
                elif  line_pos_0[0] != line_pos_1[0] and line_pos_0[1] == line_pos_1[1] : # length line
                    width = line_pos_0[0] - line_pos_1[0]
                    pos_x = line_pos_1[0] + (width/2)
                    pos_y = line_pos_1[1]
                    tag = (oval_id, "oval_length_pos")
                line.oval_dict[oval_id] = GRectOval(line, tag, pos_x, pos_y)
                line.parent.parent.parent.MyAddOval(line.oval_dict[oval_id].body, pos_x, pos_y)

        canvas.Redraw(dc)

#----------------------------------------------------------------------

class MyEvtHandler(ogl.ShapeEvtHandler):
    """ݡͥȿ޷ʻͳѷΤΥ٥ȥ饹"""
    def __init__(self, log, frame):
        """饹ν

        []
        log     -- ϥ饹Υ֥
        frame   -- ơСΥ֥
        嵭ϡdemoץ̾ġ

        []
        void
        """
        ogl.ShapeEvtHandler.__init__(self)
        self.log = log
        self.statbarFrame = frame
        self.dragOn = 0

    def UpdateStatusBar(self, shape):
        """ơСɽι

        []
        shape   -- ޷Υ֥Ȥ

        []
        void
        """
        x,y = shape.GetX(), shape.GetY()
        width, height = shape.GetBoundingBoxMax()
        self.statbarFrame.SetStatusText("Pos: (%d,%d)  Size: (%d, %d)" %
                                        (x, y, width, height))


    def OnLeftClick(self, x, y, keys = 0, attachment = 0):
        """ޥå˸ƤФ륤٥ȥϥɥ
        Τ򡿲Ԥ

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- åȡ̤ѡ

        []
        void
        """
        shape = self.GetShape()
#        print shape.__class__, shape.GetClassName()
        canvas = shape.GetCanvas()
        dc = wx.ClientDC(canvas)
        canvas.PrepareDC(dc)

        # åץեɽ
        ref = self.statbarFrame.myDict.GetObjRefToFullpath(shape.parent.fullpath)
        try:
            ref = ref._narrow(RTM.RTCBase)
            self.statbarFrame.profilepanel.RefreshProfile(ref._get_profile())
        except:
            except_mess("obj-ref error:")

        # ٥ȤǸƤӽФ줿޷Ѥߤξ
        if shape in canvas.selected:
        #if shape.parent.tag == 'body' or shape.parent.tag == 'line':
            # 
            canvas.lineFrom = None
            shape.Select(False, dc)
            shape.parent.unselected(dc)
            for obj in canvas.selected:
                if shape == obj:
                    idx = canvas.selected.index(obj)
                    del canvas.selected[idx]
            canvas.Redraw(dc)
        # ٥ȤǸƤӽФ줿޷̤ξ
        else:
            # ֤ذܹ
            canvas.lineFrom = None
            redraw = False
            shapeList = canvas.GetDiagram().GetShapeList()

            shape.Select(True, dc)
            shape.parent.selected()

            if canvas.selected and keys != 1:
                for s in canvas.selected:
                    s.Select(False, dc)
                    s.parent.unselected(dc)
                canvas.selected = []
                canvas.Redraw(dc)

            canvas.selected.append(shape)

        self.UpdateStatusBar(shape)


    def OnEndDragLeft(self, x, y, keys = 0, attachment = 0):
        """ɥåλ˸ƤФ륤٥ȥϥɥ
        ֤޷ư

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- åȡ̤ѡ

        []
        void
        """
        if self.dragOn == 1:
            shape = self.GetShape()
#            self.base_OnEndDragLeft(x, y, keys, attachment)

            canvas = shape.GetCanvas()
            dc = wx.ClientDC(canvas)
            canvas.PrepareDC(dc)

            movex = x - shape.lastx
            movey = y - shape.lasty
            # ֤޷ư
            for obj in canvas.selected:

                # body/inport/outport
                obj.parent.dmove(dc,movex,movey)

                obj.lastx = obj.GetX()
                obj.lasty = obj.GetY()

                if obj.parent.tag != 'line':
                    obj.Select(True, dc)

            canvas.Redraw(dc)
            self.dragOn = 0

            self.UpdateStatusBar(shape)

    def OnSizingEndDragLeft(self, pt, x, y, keys, attch):
        """ѹλ˸ƤФ륤٥ȥϥɥ

        []
        pt         -- ȥݥ
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- åȡ̤ѡ

        []
        void
        """
        # ǥեȤΥѹ٥ȥϥɥƤӽФ
        self.base_OnSizingEndDragLeft(pt, x, y, keys, attch)

        shape = self.GetShape()
        canvas = shape.GetCanvas()
        dc = wx.ClientDC(canvas)
        canvas.PrepareDC(dc)
        # ѹWidth,HeightΨ
        width, height = shape.GetBoundingBoxMax()
        ratioW = width / shape.parent.lastBBoxWidth
        ratioH = height / shape.parent.lastBBoxHeight
        tmpx,tmpy = shape.GetX(), shape.GetY()
        # ѹ
        shape.parent.updatePolygonSize(tmpx,tmpy,ratioW,ratioH)
        self.UpdateStatusBar(shape)
        canvas.Redraw(dc)
        shape.parent.lastBBoxWidth, shape.parent.lastBBoxHeight = shape.GetBoundingBoxMax()

    def OnDragLeft(self, draw, x, y, keys, attachment):
        """ɥå˸ƤФ륤٥ȥϥɥ
        ֤޷ư

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- åȡ̤ѡ

        []
        void
        """
        shape = self.GetShape()
        canvas = shape.GetCanvas()
        if self.dragOn == 1:
            if shape not in canvas.selected:
                pass
            else:
                width, height = shape.GetBoundingBoxMax()
                self.statbarFrame.SetStatusText("Pos: (%d,%d)  Size: (%d, %d)" %
                                                (x, y, width, height))
#                self.base_OnDragLeft(1, x, y, keys, attachment)

                # DC(BufferedDC)˳ơRedrawdeɽɽ
                dc = getBufferedDC(canvas)
                canvas.PrepareDC(dc)

                # Ѥߤο޷ư
                movex = x - shape.lastx
                movey = y - shape.lasty
                for obj in canvas.selected:
                    obj.DeleteControlPoints()
                    # inport/outport
                    obj.parent.dmove(dc,movex,movey)

                    obj.lastx = obj.GetX()
                    obj.lasty = obj.GetY()

                canvas.Redraw(dc)

    def OnBeginDragLeft(self, x, y, keys, attachment):
        """ɥåϻ˸ƤФ륤٥ȥϥɥ

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- åȡ̤ѡ

        []
        void
        """
        shape = self.GetShape()
        canvas = shape.GetCanvas()
        dc = wx.ClientDC(canvas)
        canvas.PrepareDC(dc)
        if shape not in canvas.selected:
            shape.DeleteControlPoints()

            if canvas.selected and keys != 1:
                for s in canvas.selected:
                    s.Select(False, dc)
                    s.parent.unselected(dc)
                canvas.selected = []
                canvas.Redraw(dc)

            shape.Select(True, dc)
            shape.parent.selected()
            canvas.selected.append(shape)

        else:
            for s in canvas.selected:
                if s.parent.tag == 'line':
                    s.Select(False, dc)
                    s.parent.unselected(dc)
                    idx = canvas.selected.index(s)
                    del canvas.selected[idx]
            canvas.Redraw(dc)

            self.log.write("OnBeginDragLeft: %s, %s, %s\n" % (x, y, keys))
#            self.base_OnBeginDragLeft(x, y, keys, attachment)
        self.dragOn = 1

#----------------------------------------------------------------------

class MyPortEvtHandler(ogl.ShapeEvtHandler):
    """ݡȤΥ٥ȥ饹"""
    def __init__(self, log, frame):
        """饹ν

        []
        log     -- ϥ饹Υ֥
        frame   -- ơСΥ֥
        嵭ϡdemoץ̾ġ

        []
        void
        """
        ogl.ShapeEvtHandler.__init__(self)
        self.log = log
        self.statbarFrame = frame
        self.dragOn = 0

    def UpdateStatusBar(self, shape):
        """ơСɽι

        []
        shape   -- ޷Υ֥Ȥ

        []
        void
        """
        x,y = shape.GetX(), shape.GetY()
        width, height = shape.GetBoundingBoxMax()
        self.statbarFrame.SetStatusText("Pos: (%d,%d)  Size: (%d, %d)" %
                                        (x, y, width, height))


    def OnLeftClick(self, x, y, keys = 0, attachment = 0):
        """ޥå˸ƤФ륤٥ȥϥɥ
        ٤Ρorλ
        λϡ֤

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- åȡ̤ѡ

        []
        void
        """
        shape = self.GetShape()
#        print shape.__class__, shape.GetClassName()
        canvas = shape.GetCanvas()
        dc = wx.ClientDC(canvas)
        canvas.PrepareDC(dc)
        ref = shape.parent.ns_dict.GetObjRefToFullpath(shape.parent.fullpath)
        try:
            ref = ref._narrow(RTM.RTCBase)
            tmp = shape.parent.ns_dict.GetCompState(shape.parent.fullpath)
            if tmp >= RTM.RTComponent.RTC_ABORTING or tmp == 0:
                ref = None
        except :
            except_mess("except error:")
            ref = None

        if not ref:
            return

        if canvas.lineFrom == None:
            canvas.lineFrom = shape
        elif canvas.lineFrom != shape:
            if canvas.lineFrom.parent.tag == 'in':
                checktag = 'out'
            else:
                checktag = 'in'
            if shape.parent.tag != checktag:
                return
            if shape.parent.fullpath == canvas.lineFrom.parent.fullpath:
                return

            canvas.lineTo = shape
            line = GRtcLine(canvas,shape.parent)
            line.setLine2port(canvas, dc)
            line.g_outp.connect(line.idx, line.g_outp.subscription_type)

            canvas.lineFrom = None
            canvas.lineTo = None
            canvas.Redraw(dc)

        self.UpdateStatusBar(shape)


    def OnEndDragLeft(self, x, y, keys = 0, attachment = 0):
        """ɥåλ˸ƤФ륤٥ȥϥɥ
        ݡȾ˥ޥ뤬

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- åȡ̤ѡ

        []
        void
        """
        shape = self.GetShape()
        ref = shape.parent.ns_dict.GetObjRefToFullpath(shape.parent.fullpath)
        try:
            ref = ref._narrow(RTM.RTCBase)
            tmp = shape.parent.ns_dict.GetCompState(shape.parent.fullpath)
            if tmp >= RTM.RTComponent.RTC_ABORTING or tmp == 0:
                ref = None
        except :
            except_mess("except error:")
            ref = None
        if not ref:
            return

        if self.dragOn == 1:
#            shape.parent.parent.blink.Stop()
            self.dragOn = 0
            canvas = shape.GetCanvas()
            dc = wx.ClientDC(canvas)
            canvas.PrepareDC(dc)
            canvas.moveLine.removeWidget(dc)
            canvas.Redraw(dc)
            tmpShape = canvas.FindShape(x,y)
            if tmpShape == 0 or not hasattr(tmpShape[0], "parent") or not hasattr(tmpShape[0].parent, "ns_dict"):
                return
            ref = tmpShape[0].parent.ns_dict.GetObjRefToFullpath(tmpShape[0].parent.fullpath)
            try:
                ref = ref._narrow(RTM.RTCBase)
                tmp = tmpShape[0].parent.ns_dict.GetCompState(tmpShape[0].parent.fullpath)
                if tmp >= RTM.RTComponent.RTC_ABORTING or tmp == 0:
                    ref = None
                if shape.parent.fullpath == tmpShape[0].parent.fullpath:
                    ref = None
            except :
                except_mess("except error:")
                ref = None
            if not ref:
                return

            if canvas.lineFrom.parent.tag == 'in':
                checktag = 'out'
            else:
                checktag = 'in'
            if tmpShape[0].parent.tag == checktag:
                canvas.lineTo = tmpShape[0]
                line = GRtcLine(canvas,shape.parent)
                line.setLine2port(canvas, dc)
                line.g_outp.connect(line.idx, line.g_outp.subscription_type)

                canvas.lineFrom = None
                canvas.lineTo = None
                canvas.Redraw(dc)
        else:
            pass

    def OnDragLeft(self, draw, x, y, keys, attachment):
        """ɥå˸ƤФ륤٥ȥϥɥ
        ޥȻ֤

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- åȡ̤ѡ

        []
        void
        """
        shape = self.GetShape()
        if self.dragOn == 1:
            canvas = shape.GetCanvas()
            dc = getBufferedDC(canvas)
            canvas.PrepareDC(dc)

            # create line
            canvas.moveLine.setPoints(shape.GetX(), shape.GetY(), x, y)
            canvas.moveLine.lines[0].SetPen(wx.Pen(SELECTED_COLOR, 1))
            canvas.moveLine.lines[0].Show(True)
            canvas.Redraw(dc)
        else:
            pass

    def OnBeginDragLeft(self, x, y, keys, attachment):
        """ɥåϻ˸ƤФ륤٥ȥϥɥ
        ɥåˤγ(֥ȥե󥹤¸ߤ

        []
        x          -- ٥ȻΣɸ
        y          -- ٥ȻΣɸ
        keys       -- ֡SHIFTCTRL
        attachment -- åȡ̤ѡ

        []
        void
        """
        self.log.write("OnBeginDragLeft: %s, %s, %s\n" % (x, y, keys))
        self.dragOn = 1
        shape = self.GetShape()
        ref = shape.parent.ns_dict.GetObjRefToFullpath(shape.parent.fullpath)
        try:
            ref = ref._narrow(RTM.RTCBase)
            tmp = shape.parent.ns_dict.GetCompState(shape.parent.fullpath)
            if tmp >= RTM.RTComponent.RTC_ABORTING or tmp == 0:
                ref = None
        except :
            ref = None
            except_mess("except error:")
        if ref:
            canvas = shape.GetCanvas()
            dc = wx.ClientDC(canvas)
            canvas.PrepareDC(dc)
            canvas.lineFrom = shape
            # make line
            canvas.moveLine = GRtcLine(canvas, shape.parent)
            canvas.moveLine.setPoints(shape.GetX(), shape.GetY(), x, y)
            canvas.moveLine.lines[0].SetPen(wx.Pen(SELECTED_COLOR, 1))
            canvas.moveLine.lines[0].Show(True)
#            shape.parent.parent.blink.setBlinkState(shape.parent.parent, 'inactive', 'active')
#            shape.parent.parent.blink.Start(500)
        else:
            self.dragOn = 0


#----------------------------------------------------------------------

class RtdSystemDraw(ogl.ShapeCanvas):
    """޷ѤΥХ饹"""
    def __init__(self, parent, log, frame):
        """饹ν

        []
        log     -- ϥ饹Υ֥
        frame   -- ơСΥ֥
        嵭ϡdemoץ̾ġ
        parent  -- ƥɥ

        []
        void
        """
        ogl.ShapeCanvas.__init__(self, parent)

        maxWidth  = 1000
        maxHeight = 1000
#        self.SetScrollbars(20, 20, maxWidth/20, maxHeight/20)

        self.x_size = maxWidth
        self.y_size = maxHeight
        self.log = log
        self.frame = frame
        self.SetBackgroundColour(wx.WHITE)
        self.diagram = ogl.Diagram()
        self.save_gdi = []
        self.SetDiagram(self.diagram)
        self.diagram.SetCanvas(self)
        self.tooltip = None
        self.rtc_dict = {}
        self.rtc_list = []
        canvas = self.diagram.GetCanvas()
        canvas.lineFrom = None
        canvas.lineTo = None
        canvas.line_idx = 0
        canvas.line = {}
        canvas.moveLine = None
        canvas.selected = []
        canvas.viewMode = False

        rRectBrush = wx.Brush("MEDIUM TURQUOISE", wx.SOLID)
        dsBrush = wx.Brush("WHITE", wx.SOLID)

        # ɥåɥåסɥåץåȤ
        dt = MyTextDropTarget(self, log)
        self.SetDropTarget(dt)

        # ٥Ȥγ
        self.Bind(wx.EVT_WINDOW_DESTROY, self.OnDestroy)
        self.Bind(wx.EVT_KEY_DOWN, self.OnKeyDown)
        self.Bind(wx.EVT_LEFT_DOWN, self.OnLeftDown)
        self.Bind(wx.EVT_MIDDLE_DOWN, self.OnMiddleDown)
        self.Bind(wx.EVT_RIGHT_DOWN, self.OnRightDown)
        self.Bind(wx.EVT_RIGHT_UP,   self.OnRightUp)

    def changeCompColor(self, fullname, state) :
        """ݡͥñΤοѹrtc_state()ȡ

        []
        fullname   -- ݡͥȤΥեѥ̾

        []
        void
        """
        if fullname in self.rtc_list:
#            self.rtc_dict[fullname].refresh()
            self.rtc_dict[fullname].changeBodyColor(state)
            self.rtc_dict[fullname].state = state

    def search_g_inp(self, inp_ref) :
        """ݡȤθ

        []
        inp_ref   -- ݡȤΥ֥ȥե

        []
        g_inp -- ݡȤΥǥʥ꡼
        """
        print "len rtc_list:",len(self.rtc_list)
        for rtc_name in self.rtc_list :
            g_rtc = self.rtc_dict[rtc_name]
            ref = g_rtc.ns_dict.GetObjRefToFullpath(g_rtc.fullpath)
            if ref :
                print "len in_list:",len(g_rtc.in_list)
                for inp in g_rtc.in_list :
                    print "inp_ref:",inp_ref, " == ", g_rtc.in_dict[inp['name']].inport['ref']
                    if inp_ref._is_equivalent(g_rtc.in_dict[inp['name']].inport['ref']) :
                        print "_is_equivalent is OK!!!"
                        return g_rtc.in_dict[inp['name']]

    def openFileDialog(self):
        wildcard = "*.xml |*.xml| *.* |*.*"
        dialog = wx.FileDialog( self, strOPEN_TITLE, defaultDir=os.getcwd(),
                                defaultFile="", wildcard=wildcard, style=wx.OPEN)

        if dialog.ShowModal() != wx.ID_OK:
            return None

        openFileName = dialog.GetPath()
        dialog.Destroy()
        return openFileName

    def loadXML(self):
        if len(self.rtc_dict) > 0:
            ret = self.askDialog(strDEL_SYS)
            if ret != wx.ID_OK:
                return

        openFileName = self.openFileDialog()
        print "open file is :",openFileName
        if openFileName == None:
            return

        # delete
        self.deleteAllShape()

        rtxml = RtmParser.RtmParser()
        dict = rtxml.readXML(openFileName)

        canvas = self.diagram.GetCanvas()
        canvas.viewMode = True
        self.createGRtc_from_dict(dict)

    def saveFileDialog(self):
        wildcard = "*.xml |*.xml| *.* |*.*"
        dialog = wx.FileDialog( self, strSAVE_AS_TITLE, defaultDir=os.getcwd(),
                                defaultFile="", wildcard=wildcard, style=wx.SAVE)

        if dialog.ShowModal() != wx.ID_OK:
            return None

        saveFileName = dialog.GetPath()
        dialog.Destroy()
        return saveFileName

    def makeDumpData(self):
        canvas = self.diagram.GetCanvas()

        dict = {}
        dict['rtc'] = {}
        dict['line'] = []
        for fullname in self.rtc_list:
            comp = self.rtc_dict[fullname]
            name = fullname

            x_size, y_size = comp.baseBox.GetBoundingBoxMin()
            if comp.lastRot == 'TB':
                y_size, x_size = x_size, y_size

            x = comp.baseBox.GetX() - x_size/2
            y = comp.baseBox.GetY() - y_size/2
#            print "Comp name:",name," x=",x," y=",y
            dict['rtc'][name] = {}
            dict['rtc'][name]['x'] = x
            dict['rtc'][name]['y'] = y

            if comp.lastRot == 'LR':
                if comp.revTogle == 1:
                    dict['rtc'][name]['rot'] = 'Right'
                else:
                    dict['rtc'][name]['rot'] = 'Left'
            else:
                if comp.rotTogle == 1:
                    dict['rtc'][name]['rot'] = 'Top'
                else:
                    dict['rtc'][name]['rot'] = 'Bottom'
                  
#            comp.rotTogle  # 1 or 0 # 1 :inport's is top side of body
#            comp.revTogle  # 1 or 0 # 1 :inport's is right side of body
#            comp.lastRot   # LR(Left/Right) or TB(Top/Bottom)

        for line_idx in canvas.line:
            out_obj = canvas.line[line_idx].g_outp
            in_obj = canvas.line[line_idx].g_inp
            tmp = {}
#            tmp['type'] =

            tmp['pos'] = canvas.line[line_idx].coordT
            tmp['in-comp'] = in_obj.fullpath
            tmp['in-name'] = in_obj.inport['name']
            tmp['out-comp'] = out_obj.fullpath
            tmp['out-name'] = out_obj.outport['name']
            dict['line'].append(tmp)

        return dict

    def saveXML(self, saveFileName):

        dict = {}
        dict = self.makeDumpData()

        rtxml = RtmParser.RtmParser()

        rtxml.writeXML(saveFileName, dict)

    def saveAsXML(self):
        saveFileName = self.saveFileDialog()
        if saveFileName == None:
            return

        self.saveXML(saveFileName)

    def refresh(self):
        """եå
        ݡͥȵڤӡɽ޷ΥեåԤ

        []
        ʤ

        []
        void
        """
        canvas = self.diagram.GetCanvas()
        dc = wx.ClientDC(canvas)
        canvas.PrepareDC(dc)
        for obj in canvas.selected:
            obj.Select(False, dc)
            obj.parent.unselected(dc)
        canvas.selected = []
        for rtc_name in self.rtc_list:
            self.rtc_dict[rtc_name].refresh()
        for rtc_name in self.rtc_list:
            self.rtc_dict[rtc_name].refresh_outp()

    def reConnect(self):
        """³
        ̾ΥݡͥȤκ³ƤӽФ

        []
        ʤ

        []
        void
        """
# assembly dummy process
#        return
# assembly dummy process
        for rtc_name in self.rtc_list:
            self.rtc_dict[rtc_name].reConnectLine()

    def remakeLines(self):
# assembly dummy process
#        return
# assembly dummy process
        for rtc_name in self.rtc_list:
            self.rtc_dict[rtc_name].remakeLines()

    def createGRtc_from_dict(self,dict):
        """ǥʥ꡼饳ݡͥȿ޷

        []
        dict   -- ֥Υǥʥ꡼

        []
        void
        """
        canvas = self.diagram.GetCanvas()
        dc = wx.ClientDC(canvas)
        canvas.PrepareDC(dc)

        rtc_list = dict['rtc'].keys()
        self.rtc_dict = {}
        new_list = []
        pos_x = 0
        pos_y = 0
        for rtc_name in rtc_list:

            # obj-ref error check
            try:
                ref = self.frame.myDict.GetObjRefToFullpath(rtc_name)
                if ref == None:
                    print 'Component Create error!: %s'%rtc_name
                    continue
                ref = ref._narrow(RTM.RTCBase)
                tmp = self.frame.myDict.GetCompState(rtc_name)
#                if tmp >= RTM.RTComponent.RTC_ABORTING or tmp == 0:
#                    ref = None
            except:
                err_mess = 'Component Create error:%s\n'%rtc_name
                except_mess(err_mess)
                continue

            new_list.append(rtc_name)

            pos_x = dict['rtc'][rtc_name]['x']
            pos_y = dict['rtc'][rtc_name]['y']
            comp = GRtc(self, rtc_name, pos_x, pos_y)
            comp.changeBodyColor('virtual')
            self.rtc_dict[rtc_name] = comp

            if dict['rtc'][rtc_name]['rot'] == 'Left':
                comp.reversesBody()
            elif dict['rtc'][rtc_name]['rot'] == 'Top':
                comp.rotatesBody()
            elif dict['rtc'][rtc_name]['rot'] == 'Bottom':
                comp.rotatesBody()
                comp.rotatesBody()

            comp.refresh()

        if len(new_list) == 0:
            canvas.viewMode = False
            return

        self.rtc_list = new_list

        for line_num in range(len(dict['line'])):
            line_dict = dict['line'][line_num]
            out_comp_name = line_dict['out-comp']
            out_name = line_dict['out-name']

            in_comp_name = line_dict['in-comp']
            in_name = line_dict['in-name']

            #error check
            if not self.rtc_dict.has_key(out_comp_name):
                print 'Assembly Check: Port Connection Error!:',out_comp_name
                continue
            if not self.rtc_dict[out_comp_name].out_dict.has_key(out_name):
                print 'Assembly Check: Port Connection Error!: ',out_comp_name,":",out_name
                continue
            if not self.rtc_dict.has_key(in_comp_name):
                print 'Assembly Check: Port Connection Error!:',in_comp_name
                continue
            if not self.rtc_dict[in_comp_name].in_dict.has_key(in_name):
                print 'Assembly Check: Port Connection Error!: ',in_comp_name,":",in_name
                continue

            outp_obj = self.rtc_dict[out_comp_name].out_dict[out_name]
            inp_obj = self.rtc_dict[in_comp_name].in_dict[in_name]

            canvas.lineFrom = outp_obj.body
            canvas.lineTo = inp_obj.body
            line = GRtcLine(canvas,outp_obj)
            line.setLine2port(canvas, dc)
            line.g_outp.connect(line.idx, line.g_outp.subscription_type)

            pos = []
            pos_list = []
            pos_list = string.splitfields(line_dict['pos'],',')
            for num in range(len(pos_list)/2):
                pos.append((string.atof(pos_list[num*2]),string.atof(pos_list[num*2+1])))

            #line.move_child
            line.childMove(dc, pos)

            canvas.lineFrom = None
            canvas.lineTo = None
        canvas.Redraw(dc)

    def MyAddBmp(self, shape, x, y, pen):
        """ӥåȥޥå׿޷Ͽ
        Хࡢ٥ȤȤδϢդ

        []
        shape   -- ӥåȥޥå׿޷
        x       -- ɽɸ
        y       -- ɽɸ
        pen     -- ڥʿˤ

        []
        shape -- wx.Shape ޷֥
        """
        shape.SetDraggable(False, False)
        shape.SetCanvas(self)
        if pen:    shape.SetPen(pen)
        shape.SetX(x)
        shape.SetY(y)
        self.diagram.AddShape(shape)
        evthandler = MyEvtHandlerBmp(self.log, self.frame)
        evthandler.SetShape(shape)
        evthandler.SetPreviousHandler(shape.GetEventHandler())
        shape.SetEventHandler(evthandler)

        shape.Show(True)
        return shape

    def MyAddOval(self, shape, x, y):
        """߿޷Ͽ
        Хࡢ٥ȤȤδϢդ

        []
        shape   -- ӥåȥޥå׿޷
        x       -- ɽɸ
        y       -- ɽɸ

        []
        shape -- wx.Shape ޷֥
        """
        shape.SetDraggable(True, False)
        shape.SetCanvas(self)
        shape.SetX(x)
        shape.SetY(y)
        self.diagram.AddShape(shape)
        evthandler = MyEvtHandlerOval(self.log, self.frame)
        evthandler.SetShape(shape)
        evthandler.SetPreviousHandler(shape.GetEventHandler())
        shape.SetEventHandler(evthandler)

        shape.Show(True)
        return shape

    def MyAddText(self, shape, x, y, pen, brush=None ):
        """ƥȤϿ
        Хࡢ٥ȤȤδϢդ

        []
        shape   -- ӥåȥޥå׿޷
        x       -- ɽɸ
        y       -- ɽɸ
        pen     -- ڥʿˤ
        burush  -- ֥饷ʿˤ

        []
        shape -- wx.Shape ޷֥
        """
        shape.SetDraggable(False, False)
        shape.SetCanvas(self)
        shape.SetX(x)
        shape.SetY(y)
        if pen:    shape.SetPen(pen)
        if brush:  shape.SetBrush(brush)
        self.diagram.AddShape(shape)
        evthandler = MyEvtHandlerDummy(self.log, self.frame)
        evthandler.SetShape(shape)
        evthandler.SetPreviousHandler(shape.GetEventHandler())
        shape.SetEventHandler(evthandler)

        shape.Show(True)
        return shape

    def MyAddShape(self, shape, x, y, pen, brush, text, inoutPort=0):
        """ݡͥȿ޷ݡȿ޷Ͽ
        Хࡢ٥ȤȤδϢդ

        []
        shape   -- ӥåȥޥå׿޷
        x       -- ɽɸ
        y       -- ɽɸ
        pen     -- ڥʿˤ
        burush  -- ֥饷ʿˤ
        text    -- ޷ɽʸ
        inoutPort -- ݡȻե饰
                     0:ݡͥ / 1:Inpot,Outport

        []
        shape -- wx.Shape ޷֥
        """
        shape.SetDraggable(True, True)
        shape.SetCanvas(self)
        shape.SetX(x)
        shape.SetY(y)
        if pen:    shape.SetPen(pen)
        if brush:  shape.SetBrush(brush)
        if text:   shape.AddText(text)
        self.diagram.AddShape(shape)
        shape.Show(True)

        if inoutPort == 1:   # make in/out port event handler
            evthandler = MyPortEvtHandler(self.log, self.frame)
            evthandler.SetShape(shape)
            evthandler.SetPreviousHandler(shape.GetEventHandler())
            shape.SetEventHandler(evthandler)
        elif inoutPort == 0:                # make body event handler
            evthandler = MyEvtHandler(self.log, self.frame)
            evthandler.SetShape(shape)
            evthandler.SetPreviousHandler(shape.GetEventHandler())
            shape.SetEventHandler(evthandler)

        return shape

    def OnDestroy(self, evt):
        """ɥ٥ȥϥɥ

        []
        evt     -- ٥

        []
        void
        """
        # Do some cleanup
        for shape in self.diagram.GetShapeList():
            if shape.GetParent() == None:
                shape.SetCanvas(None)
                shape.Destroy()

        self.diagram.Destroy()

    def deleteShape(self,obj):
        """޷

        []
        ԤShape֥

        []
        void
        """
        canvas = self.diagram.GetCanvas()
        dc = wx.ClientDC(self)
        canvas.PrepareDC(dc)
        obj.parent.removeWidget(dc)

        if hasattr(obj, "parent") and obj.parent.tag == 'body':
            rtc_name = obj.parent.fullpath
            if rtc_name in self.rtc_list:
                tmp = self.rtc_list.index(rtc_name)
                del self.rtc_list[tmp]
                del self.rtc_dict[rtc_name]
        if hasattr(obj, "parent") and obj.parent.tag == 'line':
            idx = obj.parent.idx
            if idx in canvas.line.keys():
                del canvas.line[idx]

        del obj

    def deleteAllShape(self):
        """٤Ƥο޷

        []
        ʤ

        []
        void
        """
        canvas = self.diagram.GetCanvas()
        dc = wx.ClientDC(self)
        canvas.PrepareDC(dc)

        for s in canvas.selected:
            s.Select(False, dc)
            s.parent.unselected(dc)

        shapeList = canvas.GetDiagram().GetShapeList()
        for obj in shapeList:
            self.deleteShape(obj)

        canvas.selected = []
        canvas.line = {}

        canvas.Redraw(dc)

    def deleteSelectedShape(self):
        """ο޷

        []
        ʤ

        []
        void
        """
        canvas = self.diagram.GetCanvas()
        dc = wx.ClientDC(self)
        canvas.PrepareDC(dc)
        for obj in canvas.selected:
            self.deleteShape(obj)

        canvas.selected = []
        bdc = getBufferedDC(canvas)
        canvas.PrepareDC(dc)
        canvas.Redraw(dc)


    def OnKeyDown(self, evt):
        """Υ٥ȥϥɥ
        ο޷

        []
        evt     -- ٥

        []
        void
        """
        evtKey = evt.GetKeyCode()
        # DELETE λ򤵤Ƥ޷
        if evtKey == wx.WXK_DELETE:
            self.deleteSelectedShape()

        canvas = self.diagram.GetCanvas()
        dc = wx.ClientDC(self)
        canvas.PrepareDC(dc)
        bdc = getBufferedDC(canvas)
        canvas.PrepareDC(bdc)
        canvas.Redraw(bdc)

    def OnPopupStart(self, evt):
        """ݡͥΤΥȤԤ٥ȥϥɥ

        []
        evt    --  ٥(wx.CommandEvent)

        []
        void
        """
        pt = self.pt
        tmpShape = self.FindShape(pt[0],pt[1])
        if tmpShape != 0:
            tmpShape[0].parent.ref_start()

    def OnPopupStop(self, evt):
        """ݡͥΤΥȥåפԤ٥ȥϥɥ

        []
        evt    --  ٥(wx.CommandEvent)

        []
        void
        """
        pt = self.pt
        tmpShape = self.FindShape(pt[0],pt[1])
        if tmpShape != 0:
            tmpShape[0].parent.ref_stop()

    def OnPopupReset(self, evt):
        pt = self.pt
        tmpShape = self.FindShape(pt[0],pt[1])
        if tmpShape != 0:
            tmpShape[0].parent.ref_reset()

    def OnPopupExit(self, evt):
        pt = self.pt
        tmpShape = self.FindShape(pt[0],pt[1])
        if tmpShape != 0:
            tmpShape[0].parent.ref_exit()

    def OnPopupKill(self, evt):
        pt = self.pt
        tmpShape = self.FindShape(pt[0],pt[1])
        if tmpShape != 0:
            tmpShape[0].parent.ref_kill()

    def OnPopupDelete(self, evt):
        """ݡͥΤκԤ٥ȥϥɥ

        []
        evt    --  ٥(wx.CommandEvent)

        []
        void
        """
        canvas = self.diagram.GetCanvas()
        dc = wx.ClientDC(self)
        canvas.PrepareDC(dc)
        pt = self.pt
        tmpShape = self.FindShape(pt[0],pt[1])
        if tmpShape != 0:
            tmpShape[0].parent.removeWidget(dc)

#            rtc_name = tmpShape[0].parent.rtc.ref_key
            rtc_name = tmpShape[0].parent.fullpath
            del self.rtc_dict[rtc_name]
            tmp = self.rtc_list.index(rtc_name)
            del self.rtc_list[tmp]

            for obj in canvas.selected:
                if obj == tmpShape[0]:
                    tmp = canvas.selected.index(tmpShape[0])
                    del canvas.selected[tmp]
        bdc = getBufferedDC(canvas)
        canvas.PrepareDC(bdc)
#        canvas.Redraw(bdc)
        canvas.Redraw(dc)

    def OnPopupSub(self, evt):
        """֥˥塼μ¸ѥߡ٥ȥϥɥ

        []
        evt     --  ٥(wx.CommandEvent)

        []
        void
        """
        print "OnPopupSub!!!"

    def OnPopupDelSelectItem(self, evt):
        """򤵤줿ƥκԤ٥ȥϥɥ

        []
        evt    --  ٥(wx.CommandEvent)

        []
        void
        """
        self.deleteSelectedShape()

    def OnPopupLoadXML(self, evt):
        """XMLե(comp_data.xml)ɤ߹।٥ȥϥɥ

        []
        evt    --  ٥(wx.CommandEvent)

        []
        void
        """
        self.loadXML()

    def OnPopupSaveDefaultXML(self, evt):
        """XMLե(֥)񤭹।٥ȥϥɥ
        ¸
        ե̾:System?.xml   ? ˤϲֹ椬

        []
        evt    --  ٥(wx.CommandEvent)

        []
        void
        """
        filename = "System%d.xml" % self.frame.drawCurNum
        self.saveXML(filename)

    def OnPopupSaveXML(self, evt):
        """XMLե(֥)񤭹।٥ȥϥɥ
        ե̾ѹ¸
        ե̾ϡǥ桼Ǥջ

        []
        evt    --  ٥(wx.CommandEvent)

        []
        void
        """
        self.saveAsXML()

    def OnPopupRefresh(self, evt):
        """RefreshԤ٥ȥϥɥ
        Ť³(ݡͥȾˤsubuscribe󤬤롣̤ɽƤʤ)
        Ȥˡok/cancelɽ³ȺǿΥơǿѹ

        []
        evt    --  ٥(wx.CommandEvent)

        []
        void
        """
        canvas = self.diagram.GetCanvas()
        # yes/no dialog
        val = self.DelOldConnectAskDialog()
        if val != wx.ID_OK:
            return

        self.refresh()
        self.reConnect()

    def checkOtherConnect(self):
        ret = False
        for rtc_name in self.rtc_list:
            ret = self.rtc_dict[rtc_name].checkOtherConnect()
            if ret == True:
                break
        return ret

    def askDialog(self, str):
        """ɽǽ
        ok/cancel ɽ

        []
        str  ---  ɽå

        []
        val  ---  (wx.ID_OK/wx.ID_CANCEL)
        void
        """

        # yes/no dialog
        val = wx.ID_OK
        dlg = RtmDialog(self, -1, str)
        dlg.CenterOnParent()
        val = dlg.ShowModal()
        dlg.Destroy()

        return val

    def DelOldConnectAskDialog(self):
        """ɽǽ
        Ť³(ݡͥȾsubscribe󤬤̾ˤɽƤʤ)С
        ok/cancel ɽ

        []
        ʤ

        []
        val  ---  (wx.ID_OK/wx.ID_CANCEL)
                  Ť󤬤ʤϡwx.ID_OK֤
        void
        """
# assembly dummy
#        return wx.ID_OK
# assembly dummy
        # yes/no dialog
        val = wx.ID_OK
        connect_flag = self.checkOtherConnect()
        if connect_flag == True:
            val = askDialog(strASKMESSAGE)
        return val

    def OnPopupConnectView(self, evt):
        """Connect˥塼νԤ٥ȥϥɥ
        ֥եɤ߹߸³subscribe˽

        []
        evt    --  ٥(wx.CommandEvent)

        []
        void
        """
        canvas = self.diagram.GetCanvas()
        # yes/no dialog
        val = self.DelOldConnectAskDialog()
        if val != wx.ID_OK:
            return

        canvas.viewMode = False
        self.refresh()
        self.reConnect()

    def OnPopupDeleteView(self, evt):
        """Delete˥塼νԤ٥ȥϥɥ
        ֥եɤ߹߸ɽ

        []
        evt    --  ٥(wx.CommandEvent)

        []
        void
        """
        self.deleteAllShape()
        canvas = self.diagram.GetCanvas()
        canvas.viewMode = False

    def makeBodyPopupMenu(self, evt):
        """ݡͥȾΥݥåץåץ˥塼ʥƥȥ˥塼˺
        ݡͥȿ޷ΤOn/Off˥塼ɽ

        []
        evt     --  ٥(wx.MouseEvent)

        []
        void
        """
        # ˥塼ϢΥ٥ȤCommandEventǡޥɸʤ
        # Ǥϡɸself.pt˳ǼľΥ˥塼٥ȤǻѤ
        self.pt = evt.GetPosition()
        if not hasattr(self, "popupID1"):
            self.popupID1 = wx.NewId()         # start menu
            self.popupID2 = wx.NewId()         # stop menu
            self.popupID3 = wx.NewId()         # delete menu
            self.popupID4 = wx.NewId()         # reset menu
            self.popupID5 = wx.NewId()         # exit menu
            self.popupID6 = wx.NewId()         # kill menu

            self.Bind(wx.EVT_MENU, self.OnPopupStart, id = self.popupID1)
            self.Bind(wx.EVT_MENU, self.OnPopupStop, id = self.popupID2)
            self.Bind(wx.EVT_MENU, self.OnPopupDelete, id = self.popupID3)
            self.Bind(wx.EVT_MENU, self.OnPopupReset, id = self.popupID4)
            self.Bind(wx.EVT_MENU, self.OnPopupExit, id = self.popupID5)
            self.Bind(wx.EVT_MENU, self.OnPopupKill, id = self.popupID6)


        menu = wx.Menu()
        menu.Append(self.popupID1, strSTART)
        menu.Append(self.popupID2, strSTOP)
        menu.Append(self.popupID4, strRESET)
        menu.Append(self.popupID5, strEXIT)
        menu.Append(self.popupID6, strKILL)
        menu.AppendSeparator()
        menu.Append(self.popupID3, strDELITEM)

        self.PopupMenu(menu, evt.GetPosition())
        menu.Destroy()

    def makeBackgroundPopupMenu(self, evt ):
        """ХåɾΥݥåץåץ˥塼ʥƥȥ˥塼˺
        ɡ֤Υ˥塼ɽ

        []
        evt     --  ٥(wx.MouseEvent)

        []
        void
        """
        # ˥塼ϢΥ٥ȤCommandEventǡޥɸʤ
        # Ǥϡɸself.pt˳ǼľΥ˥塼٥ȤǻѤ
        self.pt = evt.GetPosition()
        if not hasattr(self, "popupIDa"):
            self.popupIDa = wx.NewId()         # selected item delete menu
            self.popupIDb = wx.NewId()         # refresh menu
            self.popupIDc = wx.NewId()         # xml file load menu
            self.popupIDd = wx.NewId()         # xml file save menu
            self.popupIDe = wx.NewId()         # xml file save as menu

            self.Bind(wx.EVT_MENU, self.OnPopupDelSelectItem,id = self.popupIDa)
            self.Bind(wx.EVT_MENU, self.OnPopupRefresh, id = self.popupIDb)
            self.Bind(wx.EVT_MENU, self.OnPopupLoadXML, id = self.popupIDc)
            self.Bind(wx.EVT_MENU, self.OnPopupSaveDefaultXML, id = self.popupIDd)
            self.Bind(wx.EVT_MENU, self.OnPopupSaveXML, id = self.popupIDe)

        menu = wx.Menu()
        menu.Append(self.popupIDa, strDEL_SELECT)
        menu.AppendSeparator()
        menu.Append(self.popupIDb, strREFRESH)
        menu.AppendSeparator()
        menu.Append(self.popupIDc, strOPEN) 
        menu.Append(self.popupIDd, strSAVE) 
        menu.Append(self.popupIDe, strSAVE_AS) 
# assembly disable
#        menu.FindItemById(self.popupIDc).Enable(False)
#        menu.FindItemById(self.popupIDd).Enable(False)
#        menu.FindItemById(self.popupIDe).Enable(False)
# assembly disable


        self.PopupMenu(menu, evt.GetPosition())
        menu.Destroy()

    def makeViewModePopupMenu(self, evt ):
        """ХåɾΥݥåץåץ˥塼ʥƥȥ˥塼˺
        ConnectDelete Υ˥塼ɽ

        []
        evt     --  ٥(wx.MouseEvent)

        []
        void
        """
        # ˥塼ϢΥ٥ȤCommandEventǡޥɸʤ
        # Ǥϡɸself.pt˳ǼľΥ˥塼٥ȤǻѤ
        self.pt = evt.GetPosition()
        if not hasattr(self, "popupID01"):
            self.popupID01 = wx.NewId()         # selected item delete menu
            self.popupID02 = wx.NewId()         # xml file load menu

            self.Bind(wx.EVT_MENU, self.OnPopupConnectView,id = self.popupID01)
            self.Bind(wx.EVT_MENU, self.OnPopupDeleteView, id = self.popupID02)

        menu = wx.Menu()
        menu.Append(self.popupID01, strASM_CONNECT)
        menu.AppendSeparator()
        menu.Append(self.popupID02, strASM_DELETE)

        self.PopupMenu(menu, evt.GetPosition())
        menu.Destroy()

    def OnRightDown(self, evt):
        """åΥ٥ȥϥɥ
        ޥ뤬Inport/OutportȡġåסʥХ롼إסˤɽԤ
        ݡͥξǤϡݥåץåץ˥塼ɽԤ

        []
        evt     -- ٥

        []
        void
        """
        self.log.write("OnRightDown")
        canvas = self.diagram.GetCanvas()
        dc = wx.ClientDC(self)
        canvas.PrepareDC(dc)
        pt = evt.GetPosition()
        tmpShape = self.FindShape(pt[0],pt[1])
        if tmpShape != 0:
            if hasattr(tmpShape[0], 'parent'):
                # Inport/Outportν
                if tmpShape[0].parent.tag == 'in' or tmpShape[0].parent.tag == 'out':
                    # ġåפκ
                    self.tooltip = makeToolTip(tmpShape[0].parent,pt,dc)

                    self.tooltip.body.SetCanvas(canvas)
                    self.diagram.AddShape(self.tooltip.body)
                    self.tooltip.body.Show(True)
                # ݡͥΤν
                elif tmpShape[0].parent.tag == 'body' and canvas.viewMode == False:
                    self.makeBodyPopupMenu(evt)
        else:
            if canvas.viewMode == False:
                self.makeBackgroundPopupMenu(evt)
            else:
                self.makeViewModePopupMenu(evt)

        canvas.Redraw(dc)
        evt.Skip()

    def OnRightUp(self, evt):
        """ååפΥ٥ȥϥɥ
        ġåסʥХ롼إסˤκԤ

        []
        evt     -- ٥

        []
        void
        """
        self.log.write("OnRightUp")
        canvas = self.diagram.GetCanvas()
        dc = wx.ClientDC(self)
        canvas.PrepareDC(dc)
        pt = evt.GetPosition()
        if self.tooltip != None:
            # ġåפκ
            self.tooltip.removeWidget(dc)
            del self.tooltip
            self.tooltip = None
        canvas.Redraw(dc)
        evt.Skip()

    def OnLeftDown(self, evt):
        """åΥ٥ȥϥɥ
        Хο޷ʤ֤Ǻå줿޷

        []
        evt     -- ٥

        []
        void
        """
        pt = evt.GetPosition()
        tmpShape = self.FindShape(pt[0],pt[1])
        if tmpShape == 0:
            canvas = self.diagram.GetCanvas()
            dc = wx.ClientDC(self)
            canvas.PrepareDC(dc)
            for s in canvas.selected:
                s.Select(False, dc)
                s.parent.unselected(dc)
            canvas.selected = []
            canvas.Redraw(dc)
        else:
            evt.Skip()

    def OnMiddleDown(self, evt):
        """ޥܥ󡦥Υ٥ȥϥɥ
        ݡͥȿ޷ξǲ줿顢žԤ

        []
        evt   -- ٥

        []
        void
        """
        pt = evt.GetPosition()
        isShift = evt.ShiftDown()
        canvas = self.diagram.GetCanvas()
        dc = wx.ClientDC(self)
        canvas.PrepareDC(dc)
        for s in canvas.selected:
            s.Select(False, dc)
            s.parent.unselected(dc)
        canvas.selected = []
        canvas.Redraw(dc)

        tmpShape = self.FindShape(pt[0],pt[1])
        if tmpShape != 0 and tmpShape[0].parent.tag == 'body' and isShift != True:  ## Middle Button
            self.log.write("OnMiddleDown: " )
            tmpShape[0].parent.reversesBody()
        elif tmpShape != 0 and tmpShape[0].parent.tag == 'body' and isShift == True:  ## Shift Key Down & Middle Button
            self.log.write("OnMiddleDown + Shift Key: " )
            tmpShape[0].parent.rotatesBody()
        else:
            evt.Skip()

        canvas.Redraw(dc)
        
#----------------------------------------------------------------------

def runTest(frame, nb, log):
    # This creates some pens and brushes that the OGL library uses.
    # It should be called after the app object has been created, but
    # before OGL is used.
    ogl.OGLInitialize()
    wx.lib.colourdb.updateColourDB()
    win = TestWindow(nb, log, frame)

    return win
    
#----------------------------------------------------------------------

# The OGL library holds some resources that need to be freed before
# the app shuts down.
class __Cleanup:
    def __del__(self, cleanup=ogl.OGLCleanUp):
        cleanup()

# When this module gets cleaned up by Python then __cu will be cleaned
# up and it's __dell__ is called, which will then call ogl.OGLCleanUp.
__cu = __Cleanup()


overview = """\
The Object Graphics Library is a library supporting the creation and
manipulation of simple and complex graphic images on a canvas.

"""

if __name__ == '__main__':
    import sys,os
    import run
    run.main(['', os.path.basename(sys.argv[0])] + sys.argv[1:])

