/**********************************************************
 *            AUTOGENERATED FILE                          *
 *             DO NOT MODIFY IT                           *
 *                                                        *
 * To add new commands :                                  *
 *  - Modify ../Xml/commands.xml file                     *
 *  - Re-run generateFeatureControllers.py script         *
 *                                                        *
 **********************************************************/

/**
* @file ARCONTROLLER_Feature.h
* @brief Feature controller allow to send command related of a Feature.
*/

#ifndef _ARCONTROLLER_FEATURE_H_
#define _ARCONTROLLER_FEATURE_H_

#include <stdlib.h>

#include <libARSAL/ARSAL_Print.h>
#include <libARSAL/ARSAL_Mutex.h>
#include <libARCommands/ARCommands.h>
#include <uthash/uthash.h>

#include <libARController/ARCONTROLLER_Error.h>
#include <libARController/ARCONTROLLER_Network.h>
#include <libARController/ARCONTROLLER_DICTIONARY_Key.h>
#include <libARController/ARCONTROLLER_Dictionary.h>

/*******************************
 * --- FEATURE generic --- 
 ******************************/

/**
 * @brief Private part of ARCONTROLLER_FEATURE_Generic_t.
 */
typedef struct ARCONTROLLER_FEATURE_Generic_Private_t ARCONTROLLER_FEATURE_Generic_Private_t;

/**
 * @brief Feature controller allow to send command related of generic Feature.
 * All generic messages
 */
typedef struct ARCONTROLLER_FEATURE_Generic_t ARCONTROLLER_FEATURE_Generic_t;

/**
 * @brief Create a new generic Feature Controller
 * @warning This function allocate memory
 * @post ARCONTROLLER_FEATURE_Generic_Delete() must be called to delete the Feature Controller and free the memory allocated.
 * @param[in] networkController The networkController used to send commands ; can be NULL and defind later with ARCONTROLLER_FEATURE_Generic_SetNetworkController().
 * @param[out] error executing error.
 * @return the new generic Feature Controller
 * @see ARCONTROLLER_FEATURE_Generic_Delete
 */
ARCONTROLLER_FEATURE_Generic_t *ARCONTROLLER_FEATURE_Generic_New (ARCONTROLLER_Network_t *networkController, eARCONTROLLER_ERROR *error);

/**
 * @brief Delete the generic Feature Controller
 * @warning This function free memory
 * @param feature The feature controller to delete
 * @see ARCONTROLLER_FEATURE_Generic_New
 */
void ARCONTROLLER_FEATURE_Generic_Delete (ARCONTROLLER_FEATURE_Generic_t **feature);

/**
 * @brief Get the dictionay of the generic Feature Controller
 * @param feature The feature controller owning the dictionary to get
 * @param[out] error executing error.
 */
ARCONTROLLER_DICTIONARY_COMMANDS_t *ARCONTROLLER_FEATURE_Generic_GetDictionary (ARCONTROLLER_FEATURE_Generic_t *feature, eARCONTROLLER_ERROR *error);

/**
 * @brief Add a callback to use when a command in project <code>Generic</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] callback the callback to add.
 * @param[in] commandKey Key of the command which the callback must be associated.
 * @param[out] error executing error.
 * @param[int] customData custom data given as parameter to the callback.
 * @see ARCONTROLLER_FEATURE_Generic_RemoveCallback.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_Generic_AddCallback (ARCONTROLLER_FEATURE_Generic_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

/**
 * @brief Remove a callback used when a command in project <code>Generic</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] callback the callback to remove.
 * @param[int] customData The custom data given to the register.
 * @param[out] error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_Generic_RemoveCallback (ARCONTROLLER_FEATURE_Generic_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

/**
 * @brief Send a command <code>Default</code> in feature <code>Generic</code>
 * default
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Generic_SendDefault_t) (ARCONTROLLER_FEATURE_Generic_t *feature);

/**
 * @brief Feature controller allow to send command related of generic Feature.
 * All generic messages
 */
struct ARCONTROLLER_FEATURE_Generic_t
{
    ARCONTROLLER_FEATURE_Generic_SendDefault_t sendDefault;
    ARCONTROLLER_FEATURE_Generic_Private_t *privatePart; /**< Private part of ARCONTROLLER_FEATURE_Generic_t */
};

/**
 * @brief Set a NetworkController to use to send commands.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] networkController The networkController used to send commands ; must be not NULL.
 * @return error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_Generic_SetNetworkController (ARCONTROLLER_FEATURE_Generic_t *feature, ARCONTROLLER_Network_t *networkController);

/**
 * @brief Get the elements of a command received.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command.
 * @param[out] error executing error.
 * @return Element dictionary of the command ; Can be null if an error is occurred.
 */
ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_Generic_GetCommandElements (ARCONTROLLER_FEATURE_Generic_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, eARCONTROLLER_ERROR *error);

/*******************************
 * --- FEATURE ARDrone3 --- 
 ******************************/

/**
 * @brief Private part of ARCONTROLLER_FEATURE_ARDrone3_t.
 */
typedef struct ARCONTROLLER_FEATURE_ARDrone3_Private_t ARCONTROLLER_FEATURE_ARDrone3_Private_t;

/**
 * @brief Feature controller allow to send command related of ARDrone3 Feature.
 * All ARDrone3-only commands
 */
typedef struct ARCONTROLLER_FEATURE_ARDrone3_t ARCONTROLLER_FEATURE_ARDrone3_t;

/**
 * @brief Create a new ARDrone3 Feature Controller
 * @warning This function allocate memory
 * @post ARCONTROLLER_FEATURE_ARDrone3_Delete() must be called to delete the Feature Controller and free the memory allocated.
 * @param[in] networkController The networkController used to send commands ; can be NULL and defind later with ARCONTROLLER_FEATURE_ARDrone3_SetNetworkController().
 * @param[out] error executing error.
 * @return the new ARDrone3 Feature Controller
 * @see ARCONTROLLER_FEATURE_ARDrone3_Delete
 */
ARCONTROLLER_FEATURE_ARDrone3_t *ARCONTROLLER_FEATURE_ARDrone3_New (ARCONTROLLER_Network_t *networkController, eARCONTROLLER_ERROR *error);

/**
 * @brief Delete the ARDrone3 Feature Controller
 * @warning This function free memory
 * @param feature The feature controller to delete
 * @see ARCONTROLLER_FEATURE_ARDrone3_New
 */
void ARCONTROLLER_FEATURE_ARDrone3_Delete (ARCONTROLLER_FEATURE_ARDrone3_t **feature);

/**
 * @brief Get the dictionay of the ARDrone3 Feature Controller
 * @param feature The feature controller owning the dictionary to get
 * @param[out] error executing error.
 */
ARCONTROLLER_DICTIONARY_COMMANDS_t *ARCONTROLLER_FEATURE_ARDrone3_GetDictionary (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCONTROLLER_ERROR *error);

/**
 * @brief Add a callback to use when a command in project <code>ARDrone3</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] callback the callback to add.
 * @param[in] commandKey Key of the command which the callback must be associated.
 * @param[out] error executing error.
 * @param[int] customData custom data given as parameter to the callback.
 * @see ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_AddCallback (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

/**
 * @brief Remove a callback used when a command in project <code>ARDrone3</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] callback the callback to remove.
 * @param[int] customData The custom data given to the register.
 * @param[out] error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>MediaRecordStatePictureStateChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGED_MASS_STORAGE_ID; /**< Key of the argument </code>mass_storage_id</code> of event <code>MediaRecordStatePictureStateChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>MediaRecordStateVideoStateChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_MASS_STORAGE_ID; /**< Key of the argument </code>mass_storage_id</code> of event <code>MediaRecordStateVideoStateChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE; /**< Key of the argument </code>state</code> of event <code>MediaRecordStatePictureStateChangedV2</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR; /**< Key of the argument </code>error</code> of event <code>MediaRecordStatePictureStateChangedV2</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE; /**< Key of the argument </code>state</code> of event <code>MediaRecordStateVideoStateChangedV2</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR; /**< Key of the argument </code>error</code> of event <code>MediaRecordStateVideoStateChangedV2</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT; /**< Key of the argument </code>event</code> of event <code>MediaRecordEventPictureEventChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR; /**< Key of the argument </code>error</code> of event <code>MediaRecordEventPictureEventChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT; /**< Key of the argument </code>event</code> of event <code>MediaRecordEventVideoEventChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR; /**< Key of the argument </code>error</code> of event <code>MediaRecordEventVideoEventChanged</code> in feature <code>ARDrone3</code> */


extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>PilotingStateFlyingStateChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>PilotingStateAlertStateChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>PilotingStateNavigateHomeStateChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON; /**< Key of the argument </code>reason</code> of event <code>PilotingStateNavigateHomeStateChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_POSITIONCHANGED_LATITUDE; /**< Key of the argument </code>latitude</code> of event <code>PilotingStatePositionChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_POSITIONCHANGED_LONGITUDE; /**< Key of the argument </code>longitude</code> of event <code>PilotingStatePositionChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_POSITIONCHANGED_ALTITUDE; /**< Key of the argument </code>altitude</code> of event <code>PilotingStatePositionChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_SPEEDCHANGED_SPEEDX; /**< Key of the argument </code>speedX</code> of event <code>PilotingStateSpeedChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_SPEEDCHANGED_SPEEDY; /**< Key of the argument </code>speedY</code> of event <code>PilotingStateSpeedChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_SPEEDCHANGED_SPEEDZ; /**< Key of the argument </code>speedZ</code> of event <code>PilotingStateSpeedChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ATTITUDECHANGED_ROLL; /**< Key of the argument </code>roll</code> of event <code>PilotingStateAttitudeChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ATTITUDECHANGED_PITCH; /**< Key of the argument </code>pitch</code> of event <code>PilotingStateAttitudeChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ATTITUDECHANGED_YAW; /**< Key of the argument </code>yaw</code> of event <code>PilotingStateAttitudeChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_AUTOTAKEOFFMODECHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>PilotingStateAutoTakeOffModeChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ALTITUDECHANGED_ALTITUDE; /**< Key of the argument </code>altitude</code> of event <code>PilotingStateAltitudeChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND_DX; /**< Key of the argument </code>dX</code> of event <code>PilotingEventMoveByEnd</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND_DY; /**< Key of the argument </code>dY</code> of event <code>PilotingEventMoveByEnd</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND_DZ; /**< Key of the argument </code>dZ</code> of event <code>PilotingEventMoveByEnd</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND_DPSI; /**< Key of the argument </code>dPsi</code> of event <code>PilotingEventMoveByEnd</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR; /**< Key of the argument </code>error</code> of event <code>PilotingEventMoveByEnd</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_SSID; /**< Key of the argument </code>ssid</code> of event <code>NetworkStateWifiScanListChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_RSSI; /**< Key of the argument </code>rssi</code> of event <code>NetworkStateWifiScanListChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND; /**< Key of the argument </code>band</code> of event <code>NetworkStateWifiScanListChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_CHANNEL; /**< Key of the argument </code>channel</code> of event <code>NetworkStateWifiScanListChanged</code> in feature <code>ARDrone3</code> */


extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND; /**< Key of the argument </code>band</code> of event <code>NetworkStateWifiAuthChannelListChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_CHANNEL; /**< Key of the argument </code>channel</code> of event <code>NetworkStateWifiAuthChannelListChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_IN_OR_OUT; /**< Key of the argument </code>in_or_out</code> of event <code>NetworkStateWifiAuthChannelListChanged</code> in feature <code>ARDrone3</code> */


extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED_CURRENT; /**< Key of the argument </code>current</code> of event <code>PilotingSettingsStateMaxAltitudeChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED_MIN; /**< Key of the argument </code>min</code> of event <code>PilotingSettingsStateMaxAltitudeChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED_MAX; /**< Key of the argument </code>max</code> of event <code>PilotingSettingsStateMaxAltitudeChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXTILTCHANGED_CURRENT; /**< Key of the argument </code>current</code> of event <code>PilotingSettingsStateMaxTiltChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXTILTCHANGED_MIN; /**< Key of the argument </code>min</code> of event <code>PilotingSettingsStateMaxTiltChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXTILTCHANGED_MAX; /**< Key of the argument </code>max</code> of event <code>PilotingSettingsStateMaxTiltChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_ABSOLUTCONTROLCHANGED_ON; /**< Key of the argument </code>on</code> of event <code>PilotingSettingsStateAbsolutControlChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXDISTANCECHANGED_CURRENT; /**< Key of the argument </code>current</code> of event <code>PilotingSettingsStateMaxDistanceChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXDISTANCECHANGED_MIN; /**< Key of the argument </code>min</code> of event <code>PilotingSettingsStateMaxDistanceChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXDISTANCECHANGED_MAX; /**< Key of the argument </code>max</code> of event <code>PilotingSettingsStateMaxDistanceChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_NOFLYOVERMAXDISTANCECHANGED_SHOULDNOTFLYOVER; /**< Key of the argument </code>shouldNotFlyOver</code> of event <code>PilotingSettingsStateNoFlyOverMaxDistanceChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXHORIZONTALSPEED_VALUE; /**< Key of the argument </code>value</code> of event <code>PilotingSettingsStateAutonomousFlightMaxHorizontalSpeed</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXVERTICALSPEED_VALUE; /**< Key of the argument </code>value</code> of event <code>PilotingSettingsStateAutonomousFlightMaxVerticalSpeed</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXHORIZONTALACCELERATION_VALUE; /**< Key of the argument </code>value</code> of event <code>PilotingSettingsStateAutonomousFlightMaxHorizontalAcceleration</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXVERTICALACCELERATION_VALUE; /**< Key of the argument </code>value</code> of event <code>PilotingSettingsStateAutonomousFlightMaxVerticalAcceleration</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXROTATIONSPEED_VALUE; /**< Key of the argument </code>value</code> of event <code>PilotingSettingsStateAutonomousFlightMaxRotationSpeed</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_BANKEDTURNCHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>PilotingSettingsStateBankedTurnChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MINALTITUDECHANGED_CURRENT; /**< Key of the argument </code>current</code> of event <code>PilotingSettingsStateMinAltitudeChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MINALTITUDECHANGED_MIN; /**< Key of the argument </code>min</code> of event <code>PilotingSettingsStateMinAltitudeChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MINALTITUDECHANGED_MAX; /**< Key of the argument </code>max</code> of event <code>PilotingSettingsStateMinAltitudeChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE; /**< Key of the argument </code>value</code> of event <code>PilotingSettingsStateCirclingDirectionChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGRADIUSCHANGED_CURRENT; /**< Key of the argument </code>current</code> of event <code>PilotingSettingsStateCirclingRadiusChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGRADIUSCHANGED_MIN; /**< Key of the argument </code>min</code> of event <code>PilotingSettingsStateCirclingRadiusChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGRADIUSCHANGED_MAX; /**< Key of the argument </code>max</code> of event <code>PilotingSettingsStateCirclingRadiusChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGALTITUDECHANGED_CURRENT; /**< Key of the argument </code>current</code> of event <code>PilotingSettingsStateCirclingAltitudeChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGALTITUDECHANGED_MIN; /**< Key of the argument </code>min</code> of event <code>PilotingSettingsStateCirclingAltitudeChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGALTITUDECHANGED_MAX; /**< Key of the argument </code>max</code> of event <code>PilotingSettingsStateCirclingAltitudeChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE; /**< Key of the argument </code>value</code> of event <code>PilotingSettingsStatePitchModeChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE; /**< Key of the argument </code>value</code> of event <code>PilotingSettingsStateLandingModeChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED_CURRENT; /**< Key of the argument </code>current</code> of event <code>SpeedSettingsStateMaxVerticalSpeedChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED_MIN; /**< Key of the argument </code>min</code> of event <code>SpeedSettingsStateMaxVerticalSpeedChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED_MAX; /**< Key of the argument </code>max</code> of event <code>SpeedSettingsStateMaxVerticalSpeedChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED_CURRENT; /**< Key of the argument </code>current</code> of event <code>SpeedSettingsStateMaxRotationSpeedChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED_MIN; /**< Key of the argument </code>min</code> of event <code>SpeedSettingsStateMaxRotationSpeedChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED_MAX; /**< Key of the argument </code>max</code> of event <code>SpeedSettingsStateMaxRotationSpeedChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_HULLPROTECTIONCHANGED_PRESENT; /**< Key of the argument </code>present</code> of event <code>SpeedSettingsStateHullProtectionChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_OUTDOORCHANGED_OUTDOOR; /**< Key of the argument </code>outdoor</code> of event <code>SpeedSettingsStateOutdoorChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXPITCHROLLROTATIONSPEEDCHANGED_CURRENT; /**< Key of the argument </code>current</code> of event <code>SpeedSettingsStateMaxPitchRollRotationSpeedChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXPITCHROLLROTATIONSPEEDCHANGED_MIN; /**< Key of the argument </code>min</code> of event <code>SpeedSettingsStateMaxPitchRollRotationSpeedChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXPITCHROLLROTATIONSPEEDCHANGED_MAX; /**< Key of the argument </code>max</code> of event <code>SpeedSettingsStateMaxPitchRollRotationSpeedChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE; /**< Key of the argument </code>type</code> of event <code>NetworkSettingsStateWifiSelectionChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND; /**< Key of the argument </code>band</code> of event <code>NetworkSettingsStateWifiSelectionChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_CHANNEL; /**< Key of the argument </code>channel</code> of event <code>NetworkSettingsStateWifiSelectionChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE; /**< Key of the argument </code>type</code> of event <code>NetworkSettingsStateWifiSecurityChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE; /**< Key of the argument </code>type</code> of event <code>NetworkSettingsStateWifiSecurity</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEY; /**< Key of the argument </code>key</code> of event <code>NetworkSettingsStateWifiSecurity</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEYTYPE; /**< Key of the argument </code>keyType</code> of event <code>NetworkSettingsStateWifiSecurity</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTMOTORVERSIONLISTCHANGED_MOTOR_NUMBER; /**< Key of the argument </code>motor_number</code> of event <code>SettingsStateProductMotorVersionListChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTMOTORVERSIONLISTCHANGED_TYPE; /**< Key of the argument </code>type</code> of event <code>SettingsStateProductMotorVersionListChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTMOTORVERSIONLISTCHANGED_SOFTWARE; /**< Key of the argument </code>software</code> of event <code>SettingsStateProductMotorVersionListChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTMOTORVERSIONLISTCHANGED_HARDWARE; /**< Key of the argument </code>hardware</code> of event <code>SettingsStateProductMotorVersionListChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED_SOFTWARE; /**< Key of the argument </code>software</code> of event <code>SettingsStateProductGPSVersionChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED_HARDWARE; /**< Key of the argument </code>hardware</code> of event <code>SettingsStateProductGPSVersionChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORIDS; /**< Key of the argument </code>motorIds</code> of event <code>SettingsStateMotorErrorStateChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR; /**< Key of the argument </code>motorError</code> of event <code>SettingsStateMotorErrorStateChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORSOFTWAREVERSIONCHANGED_VERSION; /**< Key of the argument </code>version</code> of event <code>SettingsStateMotorSoftwareVersionChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORFLIGHTSSTATUSCHANGED_NBFLIGHTS; /**< Key of the argument </code>nbFlights</code> of event <code>SettingsStateMotorFlightsStatusChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORFLIGHTSSTATUSCHANGED_LASTFLIGHTDURATION; /**< Key of the argument </code>lastFlightDuration</code> of event <code>SettingsStateMotorFlightsStatusChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORFLIGHTSSTATUSCHANGED_TOTALFLIGHTDURATION; /**< Key of the argument </code>totalFlightDuration</code> of event <code>SettingsStateMotorFlightsStatusChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR; /**< Key of the argument </code>motorError</code> of event <code>SettingsStateMotorErrorLastErrorChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_P7ID_SERIALID; /**< Key of the argument </code>serialID</code> of event <code>SettingsStateP7ID</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE; /**< Key of the argument </code>type</code> of event <code>PictureSettingsStatePictureFormatChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE; /**< Key of the argument </code>type</code> of event <code>PictureSettingsStateAutoWhiteBalanceChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_EXPOSITIONCHANGED_VALUE; /**< Key of the argument </code>value</code> of event <code>PictureSettingsStateExpositionChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_EXPOSITIONCHANGED_MIN; /**< Key of the argument </code>min</code> of event <code>PictureSettingsStateExpositionChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_EXPOSITIONCHANGED_MAX; /**< Key of the argument </code>max</code> of event <code>PictureSettingsStateExpositionChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_SATURATIONCHANGED_VALUE; /**< Key of the argument </code>value</code> of event <code>PictureSettingsStateSaturationChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_SATURATIONCHANGED_MIN; /**< Key of the argument </code>min</code> of event <code>PictureSettingsStateSaturationChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_SATURATIONCHANGED_MAX; /**< Key of the argument </code>max</code> of event <code>PictureSettingsStateSaturationChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_TIMELAPSECHANGED_ENABLED; /**< Key of the argument </code>enabled</code> of event <code>PictureSettingsStateTimelapseChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_TIMELAPSECHANGED_INTERVAL; /**< Key of the argument </code>interval</code> of event <code>PictureSettingsStateTimelapseChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_TIMELAPSECHANGED_MININTERVAL; /**< Key of the argument </code>minInterval</code> of event <code>PictureSettingsStateTimelapseChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_TIMELAPSECHANGED_MAXINTERVAL; /**< Key of the argument </code>maxInterval</code> of event <code>PictureSettingsStateTimelapseChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_VIDEOAUTORECORDCHANGED_ENABLED; /**< Key of the argument </code>enabled</code> of event <code>PictureSettingsStateVideoAutorecordChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_VIDEOAUTORECORDCHANGED_MASS_STORAGE_ID; /**< Key of the argument </code>mass_storage_id</code> of event <code>PictureSettingsStateVideoAutorecordChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE; /**< Key of the argument </code>mode</code> of event <code>PictureSettingsStateVideoStabilizationModeChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED; /**< Key of the argument </code>enabled</code> of event <code>MediaStreamingStateVideoEnableChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMECHANGED_LATITUDE; /**< Key of the argument </code>latitude</code> of event <code>GPSSettingsStateHomeChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMECHANGED_LONGITUDE; /**< Key of the argument </code>longitude</code> of event <code>GPSSettingsStateHomeChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMECHANGED_ALTITUDE; /**< Key of the argument </code>altitude</code> of event <code>GPSSettingsStateHomeChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RESETHOMECHANGED_LATITUDE; /**< Key of the argument </code>latitude</code> of event <code>GPSSettingsStateResetHomeChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RESETHOMECHANGED_LONGITUDE; /**< Key of the argument </code>longitude</code> of event <code>GPSSettingsStateResetHomeChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RESETHOMECHANGED_ALTITUDE; /**< Key of the argument </code>altitude</code> of event <code>GPSSettingsStateResetHomeChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_GPSFIXSTATECHANGED_FIXED; /**< Key of the argument </code>fixed</code> of event <code>GPSSettingsStateGPSFixStateChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>GPSSettingsStateGPSUpdateStateChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE; /**< Key of the argument </code>type</code> of event <code>GPSSettingsStateHomeTypeChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RETURNHOMEDELAYCHANGED_DELAY; /**< Key of the argument </code>delay</code> of event <code>GPSSettingsStateReturnHomeDelayChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_ORIENTATION_TILT; /**< Key of the argument </code>tilt</code> of event <code>CameraStateOrientation</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_ORIENTATION_PAN; /**< Key of the argument </code>pan</code> of event <code>CameraStateOrientation</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_DEFAULTCAMERAORIENTATION_TILT; /**< Key of the argument </code>tilt</code> of event <code>CameraStateDefaultCameraOrientation</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_DEFAULTCAMERAORIENTATION_PAN; /**< Key of the argument </code>pan</code> of event <code>CameraStateDefaultCameraOrientation</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY; /**< Key of the argument </code>frequency</code> of event <code>AntiflickeringStateElectricFrequencyChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE; /**< Key of the argument </code>mode</code> of event <code>AntiflickeringStateModeChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_NUMBEROFSATELLITECHANGED_NUMBEROFSATELLITE; /**< Key of the argument </code>numberOfSatellite</code> of event <code>GPSStateNumberOfSatelliteChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE; /**< Key of the argument </code>type</code> of event <code>GPSStateHomeTypeAvailabilityChanged</code> in feature <code>ARDrone3</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_AVAILABLE; /**< Key of the argument </code>available</code> of event <code>GPSStateHomeTypeAvailabilityChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE; /**< Key of the argument </code>type</code> of event <code>GPSStateHomeTypeChosenChanged</code> in feature <code>ARDrone3</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PROSTATE_FEATURES_FEATURES; /**< Key of the argument </code>features</code> of event <code>PROStateFeatures</code> in feature <code>ARDrone3</code> */

/**
 * @brief Send a command <code>PilotingFlatTrim</code> in feature <code>ARDrone3</code>
 * Do a flat trim
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingFlatTrim_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature);

/**
 * @brief Send a command <code>PilotingTakeOff</code> in feature <code>ARDrone3</code>
 * Ask the drone to take off
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingTakeOff_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature);

/**
 * @brief Send a command <code>PilotingPCMD</code> in feature <code>ARDrone3</code>
 * Ask the drone to move around.
 * @param feature feature owning the commands
 * @param flag Boolean flag to activate roll/pitch movement
 * @param roll Roll consign for the drone [-100;100]
 * @param pitch Pitch consign for the drone [-100;100]
 * @param yaw Yaw consign for the drone [-100;100]
 * @param gaz Gaz consign for the drone [-100;100]
 * @param timestampAndSeqNum Command timestamp in milliseconds (low 24 bits) + command sequence number [0;255] (high 8 bits).
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingPCMD_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t flag, int8_t roll, int8_t pitch, int8_t yaw, int8_t gaz, uint32_t timestampAndSeqNum);

/**
 * @brief Set the parameters to send through the command <code>PilotingPCMD</code> in project <code>ARDrone3</code>
 * Ask the drone to move around.
 * @param feature feature owning the commands
 * @param flag Boolean flag to activate roll/pitch movement
 * @param roll Roll consign for the drone [-100;100]
 * @param pitch Pitch consign for the drone [-100;100]
 * @param yaw Yaw consign for the drone [-100;100]
 * @param gaz Gaz consign for the drone [-100;100]
 * @param timestampAndSeqNum Command timestamp in milliseconds (low 24 bits) + command sequence number [0;255] (high 8 bits).
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMD_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t flag, int8_t roll, int8_t pitch, int8_t yaw, int8_t gaz, uint32_t timestampAndSeqNum);

/**
 * @brief Send the a command <code>PilotingPCMD</code> in project <code>ARDrone3</code> with the parame set beforehand 
 * Ask the drone to move around.
 * @param feature feature owning the commands
 * @param cmdBuffer buffer to store the command
 * @param cmdBufferSize size of the buffer
 * return executing error
 */
eARCONTROLLER_ERROR ARCONTROLLER_ARDrone3_SendPilotingPCMDStruct (ARCONTROLLER_FEATURE_ARDrone3_t *feature, u_int8_t *cmdBuffer, int32_t cmdBufferSize);

/**
 * @brief Set flag sent through the command <code>PilotingPCMD</code> in project <code>ARDrone3</code>
 * Ask the drone to move around.
 * @param feature feature owning the commands
 * @param flag Boolean flag to activate roll/pitch movement
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDFlag_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t flag);

/**
 * @brief Set roll sent through the command <code>PilotingPCMD</code> in project <code>ARDrone3</code>
 * Ask the drone to move around.
 * @param feature feature owning the commands
 * @param roll Roll consign for the drone [-100;100]
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDRoll_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, int8_t roll);

/**
 * @brief Set pitch sent through the command <code>PilotingPCMD</code> in project <code>ARDrone3</code>
 * Ask the drone to move around.
 * @param feature feature owning the commands
 * @param pitch Pitch consign for the drone [-100;100]
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDPitch_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, int8_t pitch);

/**
 * @brief Set yaw sent through the command <code>PilotingPCMD</code> in project <code>ARDrone3</code>
 * Ask the drone to move around.
 * @param feature feature owning the commands
 * @param yaw Yaw consign for the drone [-100;100]
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDYaw_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, int8_t yaw);

/**
 * @brief Set gaz sent through the command <code>PilotingPCMD</code> in project <code>ARDrone3</code>
 * Ask the drone to move around.
 * @param feature feature owning the commands
 * @param gaz Gaz consign for the drone [-100;100]
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDGaz_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, int8_t gaz);

/**
 * @brief Set timestampAndSeqNum sent through the command <code>PilotingPCMD</code> in project <code>ARDrone3</code>
 * Ask the drone to move around.
 * @param feature feature owning the commands
 * @param timestampAndSeqNum Command timestamp in milliseconds (low 24 bits) + command sequence number [0;255] (high 8 bits).
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDTimestampAndSeqNum_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint32_t timestampAndSeqNum);

/**
 * @brief Send a command <code>PilotingLanding</code> in feature <code>ARDrone3</code>
 * Ask the drone to land
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingLanding_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature);

/**
 * @brief Send a command <code>PilotingEmergency</code> in feature <code>ARDrone3</code>
 * Put drone in emergency user state
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingEmergency_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature);

/**
 * @brief Send a command <code>PilotingNavigateHome</code> in feature <code>ARDrone3</code>
 * Ask the drone to fly to home
 * @param feature feature owning the commands
 * @param start 1 to start the navigate home, 0 to stop it
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingNavigateHome_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t start);

/**
 * @brief Send a command <code>PilotingAutoTakeOffMode</code> in feature <code>ARDrone3</code>
 * @deprecated
 * [NOT USED] Set Drone3 in automatic take off mode
 * @param feature feature owning the commands
 * @param state State of automatic take off mode (1 for autotake off enabled)
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingAutoTakeOffMode_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t state);

/**
 * @brief Send a command <code>PilotingMoveBy</code> in feature <code>ARDrone3</code>
 * [DRAFT] Move the drone to a relative position and rotate heading by a given angle
 * The frame is horizontal and relative to the current drone orientation:
 * - X is front
 * - Y is right
 * - Z is down
 * The movement settings of the device are those set for the autonomous flight.
 * @param feature feature owning the commands
 * @param dX Wanted displacement along the front axis [m]
 * @param dY Wanted displacement along the right axis [m]
 * @param dZ Wanted displacement along the down axis [m]
 * @param dPsi Wanted rotation of heading  [rad]
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingMoveBy_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float dX, float dY, float dZ, float dPsi);

/**
 * @brief Send a command <code>PilotingUserTakeOff</code> in feature <code>ARDrone3</code>
 * Set drone in user take off state
 * @param feature feature owning the commands
 * @param state State of user take off mode
 * @param state - 1 to enter in user take off.
 * @param state - 0 to exit from user take off.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingUserTakeOff_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t state);

/**
 * @brief Send a command <code>PilotingCircle</code> in feature <code>ARDrone3</code>
 * Ask Fixed wings to circle
 * @param feature feature owning the commands
 * @param direction The circling direction
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingCircle_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PILOTING_CIRCLE_DIRECTION direction);

/**
 * @brief Send a command <code>AnimationsFlip</code> in feature <code>ARDrone3</code>
 * Make a flip
 * @param feature feature owning the commands
 * @param direction Direction for the flip
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendAnimationsFlip_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_ANIMATIONS_FLIP_DIRECTION direction);

/**
 * @brief Send a command <code>CameraOrientation</code> in feature <code>ARDrone3</code>
 * Ask the drone to move camera.
 * @param feature feature owning the commands
 * @param tilt Tilt camera consign for the drone (in degree)
 * @param tilt The value is saturated by the drone.
 * @param tilt Saturation value is sent by thre drone through CameraSettingsChanged command.
 * @param pan Pan camera consign for the drone (in degree)
 * @param pan The value is saturated by the drone.
 * @param pan Saturation value is sent by thre drone through CameraSettingsChanged command.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendCameraOrientation_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, int8_t tilt, int8_t pan);

/**
 * @brief Send a command <code>MediaRecordPicture</code> in feature <code>ARDrone3</code>
 * @deprecated
 * Take picture
 * @param feature feature owning the commands
 * @param mass_storage_id Mass storage id to take picture
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendMediaRecordPicture_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t mass_storage_id);

/**
 * @brief Send a command <code>MediaRecordVideo</code> in feature <code>ARDrone3</code>
 * @deprecated
 * Video record
 * @param feature feature owning the commands
 * @param record Command to record video
 * @param mass_storage_id Mass storage id to record
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendMediaRecordVideo_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEO_RECORD record, uint8_t mass_storage_id);

/**
 * @brief Send a command <code>MediaRecordPictureV2</code> in feature <code>ARDrone3</code>
 * Take picture
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendMediaRecordPictureV2_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature);

/**
 * @brief Send a command <code>MediaRecordVideoV2</code> in feature <code>ARDrone3</code>
 * Video record
 * @param feature feature owning the commands
 * @param record Command to record video
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendMediaRecordVideoV2_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEOV2_RECORD record);

/**
 * @brief Send a command <code>NetworkWifiScan</code> in feature <code>ARDrone3</code>
 * Launches wifi network scan
 * @param feature feature owning the commands
 * @param band The band(s) : 2.4 Ghz, 5 Ghz, or both
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendNetworkWifiScan_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_NETWORK_WIFISCAN_BAND band);

/**
 * @brief Send a command <code>NetworkWifiAuthChannel</code> in feature <code>ARDrone3</code>
 * Controller inquire the list of authorized wifi channels.
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendNetworkWifiAuthChannel_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature);

/**
 * @brief Send a command <code>PilotingSettingsMaxAltitude</code> in feature <code>ARDrone3</code>
 * Set Max Altitude
 * @param feature feature owning the commands
 * @param current Current altitude max in m
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsMaxAltitude_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float current);

/**
 * @brief Send a command <code>PilotingSettingsMaxTilt</code> in feature <code>ARDrone3</code>
 * Set Max Tilt
 * @param feature feature owning the commands
 * @param current Current tilt max in degree
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsMaxTilt_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float current);

/**
 * @brief Send a command <code>PilotingSettingsAbsolutControl</code> in feature <code>ARDrone3</code>
 * @deprecated
 * Enable/Disable absolut control
 * @param feature feature owning the commands
 * @param on 1 to enable, 0 to disable
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsAbsolutControl_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t on);

/**
 * @brief Send a command <code>PilotingSettingsMaxDistance</code> in feature <code>ARDrone3</code>
 * Set the distance max of the drone
 * @param feature feature owning the commands
 * @param value Current max distance in meter
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsMaxDistance_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float value);

/**
 * @brief Send a command <code>PilotingSettingsNoFlyOverMaxDistance</code> in feature <code>ARDrone3</code>
 * Indication about how the product handle flying over the max distance limitation
 * @param feature feature owning the commands
 * @param shouldNotFlyOver 1 if the drone can't fly further than max distance, 0 if no limitation on the drone should be done
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsNoFlyOverMaxDistance_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t shouldNotFlyOver);

/**
 * @brief Send a command <code>PilotingSettingsSetAutonomousFlightMaxHorizontalSpeed</code> in feature <code>ARDrone3</code>
 * [NOT USED] Set the maximum horizontal speed used by the autonomous flight
 * @param feature feature owning the commands
 * @param value maximum horizontal speed [m/s]
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxHorizontalSpeed_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float value);

/**
 * @brief Send a command <code>PilotingSettingsSetAutonomousFlightMaxVerticalSpeed</code> in feature <code>ARDrone3</code>
 * [NOT USED] Set the maximum vertical speed used by the autonomous flight
 * @param feature feature owning the commands
 * @param value maximum vertical speed [m/s]
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxVerticalSpeed_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float value);

/**
 * @brief Send a command <code>PilotingSettingsSetAutonomousFlightMaxHorizontalAcceleration</code> in feature <code>ARDrone3</code>
 * [NOT USED] Set the maximum horizontal acceleration used by the autonomous flight
 * @param feature feature owning the commands
 * @param value maximum horizontal acceleration [m/s2]
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxHorizontalAcceleration_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float value);

/**
 * @brief Send a command <code>PilotingSettingsSetAutonomousFlightMaxVerticalAcceleration</code> in feature <code>ARDrone3</code>
 * [NOT USED] Set the maximum vertical acceleration used by the autonomous flight
 * @param feature feature owning the commands
 * @param value maximum vertical acceleration [m/s2]
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxVerticalAcceleration_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float value);

/**
 * @brief Send a command <code>PilotingSettingsSetAutonomousFlightMaxRotationSpeed</code> in feature <code>ARDrone3</code>
 * [NOT USED] Set the maximum yaw rotation speed used by the autonomous flight
 * @param feature feature owning the commands
 * @param value maximum yaw rotation speed [rad/s]
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxRotationSpeed_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float value);

/**
 * @brief Send a command <code>PilotingSettingsBankedTurn</code> in feature <code>ARDrone3</code>
 * Enable / Disable Banked Turn mode.
 * @param feature feature owning the commands
 * @param value 1 to enable, 0 to disable
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsBankedTurn_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t value);

/**
 * @brief Send a command <code>PilotingSettingsMinAltitude</code> in feature <code>ARDrone3</code>
 * Set Min Altitude
 * @param feature feature owning the commands
 * @param current Current altitude min in m
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsMinAltitude_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float current);

/**
 * @brief Send a command <code>PilotingSettingsCirclingDirection</code> in feature <code>ARDrone3</code>
 * Set Fixed wings circling default direction
 * @param feature feature owning the commands
 * @param value The circling direction
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsCirclingDirection_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_CIRCLINGDIRECTION_VALUE value);

/**
 * @brief Send a command <code>PilotingSettingsCirclingRadius</code> in feature <code>ARDrone3</code>
 * Set Fixed wings circling radius
 * @param feature feature owning the commands
 * @param value The circling radius in meter
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsCirclingRadius_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint16_t value);

/**
 * @brief Send a command <code>PilotingSettingsCirclingAltitude</code> in feature <code>ARDrone3</code>
 * Set Fixed wings circling altitude
 * @param feature feature owning the commands
 * @param value The circling altitude in meter
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsCirclingAltitude_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint16_t value);

/**
 * @brief Send a command <code>PilotingSettingsPitchMode</code> in feature <code>ARDrone3</code>
 * Set pitch mode
 * @param feature feature owning the commands
 * @param value The Pitch mode
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsPitchMode_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_PITCHMODE_VALUE value);

/**
 * @brief Send a command <code>PilotingSettingsLandingMode</code> in feature <code>ARDrone3</code>
 * Set fixed wings Landing Mode
 * @param feature feature owning the commands
 * @param value The Landing mode
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsLandingMode_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_LANDINGMODE_VALUE value);

/**
 * @brief Send a command <code>SpeedSettingsMaxVerticalSpeed</code> in feature <code>ARDrone3</code>
 * Set Max Vertical speed
 * @param feature feature owning the commands
 * @param current Current max vertical speed in m/s
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsMaxVerticalSpeed_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float current);

/**
 * @brief Send a command <code>SpeedSettingsMaxRotationSpeed</code> in feature <code>ARDrone3</code>
 * Set Max Yaw Rotation speed
 * @param feature feature owning the commands
 * @param current Current max yaw rotation speed in degree/s
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsMaxRotationSpeed_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float current);

/**
 * @brief Send a command <code>SpeedSettingsHullProtection</code> in feature <code>ARDrone3</code>
 * Presence of hull protection
 * @param feature feature owning the commands
 * @param present 1 if present, 0 if not present
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsHullProtection_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t present);

/**
 * @brief Send a command <code>SpeedSettingsOutdoor</code> in feature <code>ARDrone3</code>
 * @deprecated
 * Outdoor property
 * @param feature feature owning the commands
 * @param outdoor 1 if outdoor flight, 0 if indoor flight
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsOutdoor_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t outdoor);

/**
 * @brief Send a command <code>SpeedSettingsMaxPitchRollRotationSpeed</code> in feature <code>ARDrone3</code>
 * Set Max Pitch/Rool Rotation speed
 * @param feature feature owning the commands
 * @param current Current max pitch/roll rotation speed in degree/s
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsMaxPitchRollRotationSpeed_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float current);

/**
 * @brief Send a command <code>NetworkSettingsWifiSelection</code> in feature <code>ARDrone3</code>
 * Auto-select channel of choosen band
 * @param feature feature owning the commands
 * @param type The type of wifi selection (auto, manual)
 * @param band The allowed band(s) : 2.4 Ghz, 5 Ghz, or all
 * @param channel The channel (not used in auto mode)
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendNetworkSettingsWifiSelection_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_TYPE type, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_BAND band, uint8_t channel);

/**
 * @brief Send a command <code>NetworkSettingsWifiSecurity</code> in feature <code>ARDrone3</code>
 * Sent by the controller to set the wifi security
 * @param feature feature owning the commands
 * @param type The type of wifi security (open, wpa2)
 * @param key The key to secure the network (empty if type is open)
 * @param keyType Type of the key
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendNetworkSettingsWifiSecurity_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_TYPE type, char * key, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_KEYTYPE keyType);

/**
 * @brief Send a command <code>PictureSettingsPictureFormatSelection</code> in feature <code>ARDrone3</code>
 * The format of the photo
 * @param feature feature owning the commands
 * @param type The type of photo format
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsPictureFormatSelection_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PICTURESETTINGS_PICTUREFORMATSELECTION_TYPE type);

/**
 * @brief Send a command <code>PictureSettingsAutoWhiteBalanceSelection</code> in feature <code>ARDrone3</code>
 * AutoWhiteBalance mode
 * @param feature feature owning the commands
 * @param type The type auto white balance
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsAutoWhiteBalanceSelection_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE type);

/**
 * @brief Send a command <code>PictureSettingsExpositionSelection</code> in feature <code>ARDrone3</code>
 * The exposition of the image
 * @param feature feature owning the commands
 * @param value Exposition value (bounds given by ExpositionChanged arg min and max, by default [-3:3])
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsExpositionSelection_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float value);

/**
 * @brief Send a command <code>PictureSettingsSaturationSelection</code> in feature <code>ARDrone3</code>
 * The saturation of the image
 * @param feature feature owning the commands
 * @param value Saturation value (bounds given by SaturationChanged arg min and max, by default [-100:100])
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsSaturationSelection_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float value);

/**
 * @brief Send a command <code>PictureSettingsTimelapseSelection</code> in feature <code>ARDrone3</code>
 * Picture taken periodically
 * @param feature feature owning the commands
 * @param enabled 1 if timelapse is enabled, 0 otherwise
 * @param interval interval in seconds for taking pictures
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsTimelapseSelection_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t enabled, float interval);

/**
 * @brief Send a command <code>PictureSettingsVideoAutorecordSelection</code> in feature <code>ARDrone3</code>
 * Video autorecord
 * @param feature feature owning the commands
 * @param enabled 1 if video autorecord is enabled, 0 otherwise
 * @param mass_storage_id Mass storage id to take video
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsVideoAutorecordSelection_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t enabled, uint8_t mass_storage_id);

/**
 * @brief Send a command <code>PictureSettingsVideoStabilizationMode</code> in feature <code>ARDrone3</code>
 * Set Video stabilization mode
 * @param feature feature owning the commands
 * @param mode Video stabilization mode
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsVideoStabilizationMode_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PICTURESETTINGS_VIDEOSTABILIZATIONMODE_MODE mode);

/**
 * @brief Send a command <code>MediaStreamingVideoEnable</code> in feature <code>ARDrone3</code>
 * Enable/disable video streaming.
 * @param feature feature owning the commands
 * @param enable 1 to enable, 0 to disable.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendMediaStreamingVideoEnable_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t enable);

/**
 * @brief Send a command <code>GPSSettingsSetHome</code> in feature <code>ARDrone3</code>
 * @deprecated
 * Set home location
 * @param feature feature owning the commands
 * @param latitude Home latitude in decimal degrees
 * @param longitude Home longitude in decimal degrees
 * @param altitude Home altitude in meters
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsSetHome_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, double latitude, double longitude, double altitude);

/**
 * @brief Send a command <code>GPSSettingsResetHome</code> in feature <code>ARDrone3</code>
 * Reset home location and let the drone make its own home
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsResetHome_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature);

/**
 * @brief Send a command <code>GPSSettingsSendControllerGPS</code> in feature <code>ARDrone3</code>
 * send controller GPS location
 * @param feature feature owning the commands
 * @param latitude GPS latitude in decimal degrees
 * @param longitude GPS longitude in decimal degrees
 * @param altitude GPS altitude in meters
 * @param horizontalAccuracy Horizontal Accuracy in meter ; equal -1 if no horizontal Accuracy
 * @param verticalAccuracy Vertical Accuracy in meter ; equal -1 if no vertical Accuracy
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsSendControllerGPS_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, double latitude, double longitude, double altitude, double horizontalAccuracy, double verticalAccuracy);

/**
 * @brief Send a command <code>GPSSettingsHomeType</code> in feature <code>ARDrone3</code>
 * Set user preference for the type of the home position. Note that this is only a preference
 * @param feature feature owning the commands
 * @param type The type of the home position
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsHomeType_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_GPSSETTINGS_HOMETYPE_TYPE type);

/**
 * @brief Send a command <code>GPSSettingsReturnHomeDelay</code> in feature <code>ARDrone3</code>
 * Set the delay after which the drone will automatically try to return home
 * @param feature feature owning the commands
 * @param delay Delay in second
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsReturnHomeDelay_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint16_t delay);

/**
 * @brief Send a command <code>AntiflickeringElectricFrequency</code> in feature <code>ARDrone3</code>
 * Electric frequency of the country determined by the position of the controller
 * @param feature feature owning the commands
 * @param frequency Type of the electric frequency
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendAntiflickeringElectricFrequency_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_ANTIFLICKERING_ELECTRICFREQUENCY_FREQUENCY frequency);

/**
 * @brief Send a command <code>AntiflickeringSetMode</code> in feature <code>ARDrone3</code>
 * Set the anti flickering mode
 * @param feature feature owning the commands
 * @param mode Mode of the anti flickering functionnality
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_ARDrone3_SendAntiflickeringSetMode_t) (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_ANTIFLICKERING_SETMODE_MODE mode);

/**
 * @brief Feature controller allow to send command related of ARDrone3 Feature.
 * All ARDrone3-only commands
 */
struct ARCONTROLLER_FEATURE_ARDrone3_t
{
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingFlatTrim_t sendPilotingFlatTrim;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingTakeOff_t sendPilotingTakeOff;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingPCMD_t sendPilotingPCMD;
    ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMD_t setPilotingPCMD;
    ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDFlag_t setPilotingPCMDFlag; /**< Send a command <code>PilotingPCMD</code> in feature <code>ARDrone3</code>. */
    ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDRoll_t setPilotingPCMDRoll; /**< Send a command <code>PilotingPCMD</code> in feature <code>ARDrone3</code>. */
    ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDPitch_t setPilotingPCMDPitch; /**< Send a command <code>PilotingPCMD</code> in feature <code>ARDrone3</code>. */
    ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDYaw_t setPilotingPCMDYaw; /**< Send a command <code>PilotingPCMD</code> in feature <code>ARDrone3</code>. */
    ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDGaz_t setPilotingPCMDGaz; /**< Send a command <code>PilotingPCMD</code> in feature <code>ARDrone3</code>. */
    ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDTimestampAndSeqNum_t setPilotingPCMDTimestampAndSeqNum; /**< Send a command <code>PilotingPCMD</code> in feature <code>ARDrone3</code>. */
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingLanding_t sendPilotingLanding;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingEmergency_t sendPilotingEmergency;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingNavigateHome_t sendPilotingNavigateHome;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingAutoTakeOffMode_t sendPilotingAutoTakeOffMode;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingMoveBy_t sendPilotingMoveBy;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingUserTakeOff_t sendPilotingUserTakeOff;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingCircle_t sendPilotingCircle;
    ARCONTROLLER_FEATURE_ARDrone3_SendAnimationsFlip_t sendAnimationsFlip;
    ARCONTROLLER_FEATURE_ARDrone3_SendCameraOrientation_t sendCameraOrientation;
    ARCONTROLLER_FEATURE_ARDrone3_SendMediaRecordPicture_t sendMediaRecordPicture;
    ARCONTROLLER_FEATURE_ARDrone3_SendMediaRecordVideo_t sendMediaRecordVideo;
    ARCONTROLLER_FEATURE_ARDrone3_SendMediaRecordPictureV2_t sendMediaRecordPictureV2;
    ARCONTROLLER_FEATURE_ARDrone3_SendMediaRecordVideoV2_t sendMediaRecordVideoV2;
    ARCONTROLLER_FEATURE_ARDrone3_SendNetworkWifiScan_t sendNetworkWifiScan;
    ARCONTROLLER_FEATURE_ARDrone3_SendNetworkWifiAuthChannel_t sendNetworkWifiAuthChannel;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsMaxAltitude_t sendPilotingSettingsMaxAltitude;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsMaxTilt_t sendPilotingSettingsMaxTilt;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsAbsolutControl_t sendPilotingSettingsAbsolutControl;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsMaxDistance_t sendPilotingSettingsMaxDistance;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsNoFlyOverMaxDistance_t sendPilotingSettingsNoFlyOverMaxDistance;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxHorizontalSpeed_t sendPilotingSettingsSetAutonomousFlightMaxHorizontalSpeed;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxVerticalSpeed_t sendPilotingSettingsSetAutonomousFlightMaxVerticalSpeed;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxHorizontalAcceleration_t sendPilotingSettingsSetAutonomousFlightMaxHorizontalAcceleration;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxVerticalAcceleration_t sendPilotingSettingsSetAutonomousFlightMaxVerticalAcceleration;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxRotationSpeed_t sendPilotingSettingsSetAutonomousFlightMaxRotationSpeed;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsBankedTurn_t sendPilotingSettingsBankedTurn;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsMinAltitude_t sendPilotingSettingsMinAltitude;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsCirclingDirection_t sendPilotingSettingsCirclingDirection;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsCirclingRadius_t sendPilotingSettingsCirclingRadius;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsCirclingAltitude_t sendPilotingSettingsCirclingAltitude;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsPitchMode_t sendPilotingSettingsPitchMode;
    ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsLandingMode_t sendPilotingSettingsLandingMode;
    ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsMaxVerticalSpeed_t sendSpeedSettingsMaxVerticalSpeed;
    ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsMaxRotationSpeed_t sendSpeedSettingsMaxRotationSpeed;
    ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsHullProtection_t sendSpeedSettingsHullProtection;
    ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsOutdoor_t sendSpeedSettingsOutdoor;
    ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsMaxPitchRollRotationSpeed_t sendSpeedSettingsMaxPitchRollRotationSpeed;
    ARCONTROLLER_FEATURE_ARDrone3_SendNetworkSettingsWifiSelection_t sendNetworkSettingsWifiSelection;
    ARCONTROLLER_FEATURE_ARDrone3_SendNetworkSettingsWifiSecurity_t sendNetworkSettingsWifiSecurity;
    ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsPictureFormatSelection_t sendPictureSettingsPictureFormatSelection;
    ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsAutoWhiteBalanceSelection_t sendPictureSettingsAutoWhiteBalanceSelection;
    ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsExpositionSelection_t sendPictureSettingsExpositionSelection;
    ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsSaturationSelection_t sendPictureSettingsSaturationSelection;
    ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsTimelapseSelection_t sendPictureSettingsTimelapseSelection;
    ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsVideoAutorecordSelection_t sendPictureSettingsVideoAutorecordSelection;
    ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsVideoStabilizationMode_t sendPictureSettingsVideoStabilizationMode;
    ARCONTROLLER_FEATURE_ARDrone3_SendMediaStreamingVideoEnable_t sendMediaStreamingVideoEnable;
    ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsSetHome_t sendGPSSettingsSetHome;
    ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsResetHome_t sendGPSSettingsResetHome;
    ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsSendControllerGPS_t sendGPSSettingsSendControllerGPS;
    ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsHomeType_t sendGPSSettingsHomeType;
    ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsReturnHomeDelay_t sendGPSSettingsReturnHomeDelay;
    ARCONTROLLER_FEATURE_ARDrone3_SendAntiflickeringElectricFrequency_t sendAntiflickeringElectricFrequency;
    ARCONTROLLER_FEATURE_ARDrone3_SendAntiflickeringSetMode_t sendAntiflickeringSetMode;
    ARCONTROLLER_FEATURE_ARDrone3_Private_t *privatePart; /**< Private part of ARCONTROLLER_FEATURE_ARDrone3_t */
};

/**
 * @brief Set a NetworkController to use to send commands.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] networkController The networkController used to send commands ; must be not NULL.
 * @return error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SetNetworkController (ARCONTROLLER_FEATURE_ARDrone3_t *feature, ARCONTROLLER_Network_t *networkController);

/**
 * @brief Get the elements of a command received.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command.
 * @param[out] error executing error.
 * @return Element dictionary of the command ; Can be null if an error is occurred.
 */
ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_GetCommandElements (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, eARCONTROLLER_ERROR *error);

/*******************************
 * --- FEATURE JumpingSumo --- 
 ******************************/

/**
 * @brief Private part of ARCONTROLLER_FEATURE_JumpingSumo_t.
 */
typedef struct ARCONTROLLER_FEATURE_JumpingSumo_Private_t ARCONTROLLER_FEATURE_JumpingSumo_Private_t;

/**
 * @brief Feature controller allow to send command related of JumpingSumo Feature.
 * All commands specific to the Jumping Sumo.
 */
typedef struct ARCONTROLLER_FEATURE_JumpingSumo_t ARCONTROLLER_FEATURE_JumpingSumo_t;

/**
 * @brief Create a new JumpingSumo Feature Controller
 * @warning This function allocate memory
 * @post ARCONTROLLER_FEATURE_JumpingSumo_Delete() must be called to delete the Feature Controller and free the memory allocated.
 * @param[in] networkController The networkController used to send commands ; can be NULL and defind later with ARCONTROLLER_FEATURE_JumpingSumo_SetNetworkController().
 * @param[out] error executing error.
 * @return the new JumpingSumo Feature Controller
 * @see ARCONTROLLER_FEATURE_JumpingSumo_Delete
 */
ARCONTROLLER_FEATURE_JumpingSumo_t *ARCONTROLLER_FEATURE_JumpingSumo_New (ARCONTROLLER_Network_t *networkController, eARCONTROLLER_ERROR *error);

/**
 * @brief Delete the JumpingSumo Feature Controller
 * @warning This function free memory
 * @param feature The feature controller to delete
 * @see ARCONTROLLER_FEATURE_JumpingSumo_New
 */
void ARCONTROLLER_FEATURE_JumpingSumo_Delete (ARCONTROLLER_FEATURE_JumpingSumo_t **feature);

/**
 * @brief Get the dictionay of the JumpingSumo Feature Controller
 * @param feature The feature controller owning the dictionary to get
 * @param[out] error executing error.
 */
ARCONTROLLER_DICTIONARY_COMMANDS_t *ARCONTROLLER_FEATURE_JumpingSumo_GetDictionary (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCONTROLLER_ERROR *error);

/**
 * @brief Add a callback to use when a command in project <code>JumpingSumo</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] callback the callback to add.
 * @param[in] commandKey Key of the command which the callback must be associated.
 * @param[out] error executing error.
 * @param[int] customData custom data given as parameter to the callback.
 * @see ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

/**
 * @brief Remove a callback used when a command in project <code>JumpingSumo</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] callback the callback to remove.
 * @param[int] customData The custom data given to the register.
 * @param[out] error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>PilotingStatePostureChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>PilotingStateAlertStateChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_SPEEDCHANGED_SPEED; /**< Key of the argument </code>speed</code> of event <code>PilotingStateSpeedChanged</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_SPEEDCHANGED_REALSPEED; /**< Key of the argument </code>realSpeed</code> of event <code>PilotingStateSpeedChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>AnimationsStateJumpLoadChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>AnimationsStateJumpTypeChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR; /**< Key of the argument </code>error</code> of event <code>AnimationsStateJumpMotorProblemChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED_SOFTWARE; /**< Key of the argument </code>software</code> of event <code>SettingsStateProductGPSVersionChanged</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED_HARDWARE; /**< Key of the argument </code>hardware</code> of event <code>SettingsStateProductGPSVersionChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>MediaRecordStatePictureStateChanged</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGED_MASS_STORAGE_ID; /**< Key of the argument </code>mass_storage_id</code> of event <code>MediaRecordStatePictureStateChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>MediaRecordStateVideoStateChanged</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_MASS_STORAGE_ID; /**< Key of the argument </code>mass_storage_id</code> of event <code>MediaRecordStateVideoStateChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE; /**< Key of the argument </code>state</code> of event <code>MediaRecordStatePictureStateChangedV2</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR; /**< Key of the argument </code>error</code> of event <code>MediaRecordStatePictureStateChangedV2</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE; /**< Key of the argument </code>state</code> of event <code>MediaRecordStateVideoStateChangedV2</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR; /**< Key of the argument </code>error</code> of event <code>MediaRecordStateVideoStateChangedV2</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT; /**< Key of the argument </code>event</code> of event <code>MediaRecordEventPictureEventChanged</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR; /**< Key of the argument </code>error</code> of event <code>MediaRecordEventPictureEventChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT; /**< Key of the argument </code>event</code> of event <code>MediaRecordEventVideoEventChanged</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR; /**< Key of the argument </code>error</code> of event <code>MediaRecordEventVideoEventChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE; /**< Key of the argument </code>type</code> of event <code>NetworkSettingsStateWifiSelectionChanged</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND; /**< Key of the argument </code>band</code> of event <code>NetworkSettingsStateWifiSelectionChanged</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_CHANNEL; /**< Key of the argument </code>channel</code> of event <code>NetworkSettingsStateWifiSelectionChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_SSID; /**< Key of the argument </code>ssid</code> of event <code>NetworkStateWifiScanListChanged</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_RSSI; /**< Key of the argument </code>rssi</code> of event <code>NetworkStateWifiScanListChanged</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND; /**< Key of the argument </code>band</code> of event <code>NetworkStateWifiScanListChanged</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_CHANNEL; /**< Key of the argument </code>channel</code> of event <code>NetworkStateWifiScanListChanged</code> in feature <code>JumpingSumo</code> */


extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND; /**< Key of the argument </code>band</code> of event <code>NetworkStateWifiAuthChannelListChanged</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_CHANNEL; /**< Key of the argument </code>channel</code> of event <code>NetworkStateWifiAuthChannelListChanged</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_IN_OR_OUT; /**< Key of the argument </code>in_or_out</code> of event <code>NetworkStateWifiAuthChannelListChanged</code> in feature <code>JumpingSumo</code> */


extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_LINKQUALITYCHANGED_QUALITY; /**< Key of the argument </code>quality</code> of event <code>NetworkStateLinkQualityChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_AUDIOSETTINGSSTATE_MASTERVOLUMECHANGED_VOLUME; /**< Key of the argument </code>volume</code> of event <code>AudioSettingsStateMasterVolumeChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME; /**< Key of the argument </code>theme</code> of event <code>AudioSettingsStateThemeChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED_UUID; /**< Key of the argument </code>uuid</code> of event <code>RoadPlanStateScriptMetadataListChanged</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED_VERSION; /**< Key of the argument </code>version</code> of event <code>RoadPlanStateScriptMetadataListChanged</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED_PRODUCT; /**< Key of the argument </code>product</code> of event <code>RoadPlanStateScriptMetadataListChanged</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED_NAME; /**< Key of the argument </code>name</code> of event <code>RoadPlanStateScriptMetadataListChanged</code> in feature <code>JumpingSumo</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED_LASTMODIFIED; /**< Key of the argument </code>lastModified</code> of event <code>RoadPlanStateScriptMetadataListChanged</code> in feature <code>JumpingSumo</code> */


extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE; /**< Key of the argument </code>resultCode</code> of event <code>RoadPlanStateScriptUploadChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE; /**< Key of the argument </code>resultCode</code> of event <code>RoadPlanStateScriptDeleteChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE; /**< Key of the argument </code>resultCode</code> of event <code>RoadPlanStatePlayScriptChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_SPEEDSETTINGSSTATE_OUTDOORCHANGED_OUTDOOR; /**< Key of the argument </code>outdoor</code> of event <code>SpeedSettingsStateOutdoorChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED; /**< Key of the argument </code>enabled</code> of event <code>MediaStreamingStateVideoEnableChanged</code> in feature <code>JumpingSumo</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_VIDEOSETTINGSSTATE_AUTORECORDCHANGED_ENABLED; /**< Key of the argument </code>enabled</code> of event <code>VideoSettingsStateAutorecordChanged</code> in feature <code>JumpingSumo</code> */

/**
 * @brief Send a command <code>PilotingPCMD</code> in feature <code>JumpingSumo</code>
 * Ask the JS speed and turn ratio.
 * @param feature feature owning the commands
 * @param flag Boolean for "touch screen".
 * @param speed Speed value [-100:100].
 * @param turn Turn value. [-100:100]
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendPilotingPCMD_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t flag, int8_t speed, int8_t turn);

/**
 * @brief Set the parameters to send through the command <code>PilotingPCMD</code> in project <code>JumpingSumo</code>
 * Ask the JS speed and turn ratio.
 * @param feature feature owning the commands
 * @param flag Boolean for "touch screen".
 * @param speed Speed value [-100:100].
 * @param turn Turn value. [-100:100]
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SetPilotingPCMD_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t flag, int8_t speed, int8_t turn);

/**
 * @brief Send the a command <code>PilotingPCMD</code> in project <code>JumpingSumo</code> with the parame set beforehand 
 * Ask the JS speed and turn ratio.
 * @param feature feature owning the commands
 * @param cmdBuffer buffer to store the command
 * @param cmdBufferSize size of the buffer
 * return executing error
 */
eARCONTROLLER_ERROR ARCONTROLLER_JumpingSumo_SendPilotingPCMDStruct (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, u_int8_t *cmdBuffer, int32_t cmdBufferSize);

/**
 * @brief Set flag sent through the command <code>PilotingPCMD</code> in project <code>JumpingSumo</code>
 * Ask the JS speed and turn ratio.
 * @param feature feature owning the commands
 * @param flag Boolean for "touch screen".
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SetPilotingPCMDFlag_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t flag);

/**
 * @brief Set speed sent through the command <code>PilotingPCMD</code> in project <code>JumpingSumo</code>
 * Ask the JS speed and turn ratio.
 * @param feature feature owning the commands
 * @param speed Speed value [-100:100].
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SetPilotingPCMDSpeed_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, int8_t speed);

/**
 * @brief Set turn sent through the command <code>PilotingPCMD</code> in project <code>JumpingSumo</code>
 * Ask the JS speed and turn ratio.
 * @param feature feature owning the commands
 * @param turn Turn value. [-100:100]
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SetPilotingPCMDTurn_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, int8_t turn);

/**
 * @brief Send a command <code>PilotingPosture</code> in feature <code>JumpingSumo</code>
 * Request a posture
 * @param feature feature owning the commands
 * @param type Type of Posture
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendPilotingPosture_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_PILOTING_POSTURE_TYPE type);

/**
 * @brief Send a command <code>PilotingAddCapOffset</code> in feature <code>JumpingSumo</code>
 * Add the specified offset to the current cap.
 * @param feature feature owning the commands
 * @param offset Offset value in radians.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendPilotingAddCapOffset_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, float offset);

/**
 * @brief Send a command <code>AnimationsJumpStop</code> in feature <code>JumpingSumo</code>
 * Stop jump, emergency jump stop, stop jump motor and stay there.
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsJumpStop_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature);

/**
 * @brief Send a command <code>AnimationsJumpCancel</code> in feature <code>JumpingSumo</code>
 * Cancel jump and come back to previous state (if possible).
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsJumpCancel_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature);

/**
 * @brief Send a command <code>AnimationsJumpLoad</code> in feature <code>JumpingSumo</code>
 * Request jump loading
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsJumpLoad_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature);

/**
 * @brief Send a command <code>AnimationsJump</code> in feature <code>JumpingSumo</code>
 * Request a jump
 * @param feature feature owning the commands
 * @param type Type of jump
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsJump_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_ANIMATIONS_JUMP_TYPE type);

/**
 * @brief Send a command <code>AnimationsSimpleAnimation</code> in feature <code>JumpingSumo</code>
 * Play a parameterless animation.
 * @param feature feature owning the commands
 * @param id Animation ID.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsSimpleAnimation_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID id);

/**
 * @brief Send a command <code>MediaRecordPicture</code> in feature <code>JumpingSumo</code>
 * @deprecated
 * Take picture
 * @param feature feature owning the commands
 * @param mass_storage_id Mass storage id to take picture
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendMediaRecordPicture_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t mass_storage_id);

/**
 * @brief Send a command <code>MediaRecordVideo</code> in feature <code>JumpingSumo</code>
 * @deprecated
 * Video record
 * @param feature feature owning the commands
 * @param record Command to record video
 * @param mass_storage_id Mass storage id to record
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendMediaRecordVideo_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEO_RECORD record, uint8_t mass_storage_id);

/**
 * @brief Send a command <code>MediaRecordPictureV2</code> in feature <code>JumpingSumo</code>
 * Take picture
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendMediaRecordPictureV2_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature);

/**
 * @brief Send a command <code>MediaRecordVideoV2</code> in feature <code>JumpingSumo</code>
 * Video record
 * @param feature feature owning the commands
 * @param record Command to record video
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendMediaRecordVideoV2_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEOV2_RECORD record);

/**
 * @brief Send a command <code>NetworkSettingsWifiSelection</code> in feature <code>JumpingSumo</code>
 * Auto-select channel of choosen band
 * @param feature feature owning the commands
 * @param type The type of wifi selection (auto, manual)
 * @param band The allowed band(s) : 2.4 Ghz, 5 Ghz, or all
 * @param channel The channel (not used in auto mode)
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendNetworkSettingsWifiSelection_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_TYPE type, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_BAND band, uint8_t channel);

/**
 * @brief Send a command <code>NetworkWifiScan</code> in feature <code>JumpingSumo</code>
 * Launches wifi network scan
 * @param feature feature owning the commands
 * @param band The band(s) : 2.4 Ghz, 5 Ghz, or both
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendNetworkWifiScan_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_NETWORK_WIFISCAN_BAND band);

/**
 * @brief Send a command <code>NetworkWifiAuthChannel</code> in feature <code>JumpingSumo</code>
 * Controller inquire the list of authorized wifi channels.
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendNetworkWifiAuthChannel_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature);

/**
 * @brief Send a command <code>AudioSettingsMasterVolume</code> in feature <code>JumpingSumo</code>
 * Master volume control.
 * @param feature feature owning the commands
 * @param volume Master audio volume [0:100].
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendAudioSettingsMasterVolume_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t volume);

/**
 * @brief Send a command <code>AudioSettingsTheme</code> in feature <code>JumpingSumo</code>
 * Audio Theme.
 * @param feature feature owning the commands
 * @param theme The audio theme to set.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendAudioSettingsTheme_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGS_THEME_THEME theme);

/**
 * @brief Send a command <code>RoadPlanAllScriptsMetadata</code> in feature <code>JumpingSumo</code>
 * Command to ask device all metadata scripts.
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendRoadPlanAllScriptsMetadata_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature);

/**
 * @brief Send a command <code>RoadPlanScriptUploaded</code> in feature <code>JumpingSumo</code>
 * Notify device that a new file has been uploaded.
 * @param feature feature owning the commands
 * @param uuid UUID of uploaded file.
 * @param md5Hash MD5 hash code computed over file.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendRoadPlanScriptUploaded_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, char * uuid, char * md5Hash);

/**
 * @brief Send a command <code>RoadPlanScriptDelete</code> in feature <code>JumpingSumo</code>
 * Ask the device to delete a script.
 * @param feature feature owning the commands
 * @param uuid UUID of the file to delete.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendRoadPlanScriptDelete_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, char * uuid);

/**
 * @brief Send a command <code>RoadPlanPlayScript</code> in feature <code>JumpingSumo</code>
 * Ask the device to play a script.
 * @param feature feature owning the commands
 * @param uuid UUID of the file to play.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendRoadPlanPlayScript_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, char * uuid);

/**
 * @brief Send a command <code>SpeedSettingsOutdoor</code> in feature <code>JumpingSumo</code>
 * @deprecated
 * Outdoor property
 * @param feature feature owning the commands
 * @param outdoor 1 if outdoor, 0 if indoor
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendSpeedSettingsOutdoor_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t outdoor);

/**
 * @brief Send a command <code>MediaStreamingVideoEnable</code> in feature <code>JumpingSumo</code>
 * Enable/disable video streaming.
 * @param feature feature owning the commands
 * @param enable 1 to enable, 0 to disable.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendMediaStreamingVideoEnable_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t enable);

/**
 * @brief Send a command <code>VideoSettingsAutorecord</code> in feature <code>JumpingSumo</code>
 * Set video automatic recording state.
 * @param feature feature owning the commands
 * @param enabled 0: Disabled 1: Enabled.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_JumpingSumo_SendVideoSettingsAutorecord_t) (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t enabled);

/**
 * @brief Feature controller allow to send command related of JumpingSumo Feature.
 * All commands specific to the Jumping Sumo.
 */
struct ARCONTROLLER_FEATURE_JumpingSumo_t
{
    ARCONTROLLER_FEATURE_JumpingSumo_SendPilotingPCMD_t sendPilotingPCMD;
    ARCONTROLLER_FEATURE_JumpingSumo_SetPilotingPCMD_t setPilotingPCMD;
    ARCONTROLLER_FEATURE_JumpingSumo_SetPilotingPCMDFlag_t setPilotingPCMDFlag; /**< Send a command <code>PilotingPCMD</code> in feature <code>JumpingSumo</code>. */
    ARCONTROLLER_FEATURE_JumpingSumo_SetPilotingPCMDSpeed_t setPilotingPCMDSpeed; /**< Send a command <code>PilotingPCMD</code> in feature <code>JumpingSumo</code>. */
    ARCONTROLLER_FEATURE_JumpingSumo_SetPilotingPCMDTurn_t setPilotingPCMDTurn; /**< Send a command <code>PilotingPCMD</code> in feature <code>JumpingSumo</code>. */
    ARCONTROLLER_FEATURE_JumpingSumo_SendPilotingPosture_t sendPilotingPosture;
    ARCONTROLLER_FEATURE_JumpingSumo_SendPilotingAddCapOffset_t sendPilotingAddCapOffset;
    ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsJumpStop_t sendAnimationsJumpStop;
    ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsJumpCancel_t sendAnimationsJumpCancel;
    ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsJumpLoad_t sendAnimationsJumpLoad;
    ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsJump_t sendAnimationsJump;
    ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsSimpleAnimation_t sendAnimationsSimpleAnimation;
    ARCONTROLLER_FEATURE_JumpingSumo_SendMediaRecordPicture_t sendMediaRecordPicture;
    ARCONTROLLER_FEATURE_JumpingSumo_SendMediaRecordVideo_t sendMediaRecordVideo;
    ARCONTROLLER_FEATURE_JumpingSumo_SendMediaRecordPictureV2_t sendMediaRecordPictureV2;
    ARCONTROLLER_FEATURE_JumpingSumo_SendMediaRecordVideoV2_t sendMediaRecordVideoV2;
    ARCONTROLLER_FEATURE_JumpingSumo_SendNetworkSettingsWifiSelection_t sendNetworkSettingsWifiSelection;
    ARCONTROLLER_FEATURE_JumpingSumo_SendNetworkWifiScan_t sendNetworkWifiScan;
    ARCONTROLLER_FEATURE_JumpingSumo_SendNetworkWifiAuthChannel_t sendNetworkWifiAuthChannel;
    ARCONTROLLER_FEATURE_JumpingSumo_SendAudioSettingsMasterVolume_t sendAudioSettingsMasterVolume;
    ARCONTROLLER_FEATURE_JumpingSumo_SendAudioSettingsTheme_t sendAudioSettingsTheme;
    ARCONTROLLER_FEATURE_JumpingSumo_SendRoadPlanAllScriptsMetadata_t sendRoadPlanAllScriptsMetadata;
    ARCONTROLLER_FEATURE_JumpingSumo_SendRoadPlanScriptUploaded_t sendRoadPlanScriptUploaded;
    ARCONTROLLER_FEATURE_JumpingSumo_SendRoadPlanScriptDelete_t sendRoadPlanScriptDelete;
    ARCONTROLLER_FEATURE_JumpingSumo_SendRoadPlanPlayScript_t sendRoadPlanPlayScript;
    ARCONTROLLER_FEATURE_JumpingSumo_SendSpeedSettingsOutdoor_t sendSpeedSettingsOutdoor;
    ARCONTROLLER_FEATURE_JumpingSumo_SendMediaStreamingVideoEnable_t sendMediaStreamingVideoEnable;
    ARCONTROLLER_FEATURE_JumpingSumo_SendVideoSettingsAutorecord_t sendVideoSettingsAutorecord;
    ARCONTROLLER_FEATURE_JumpingSumo_Private_t *privatePart; /**< Private part of ARCONTROLLER_FEATURE_JumpingSumo_t */
};

/**
 * @brief Set a NetworkController to use to send commands.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] networkController The networkController used to send commands ; must be not NULL.
 * @return error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SetNetworkController (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, ARCONTROLLER_Network_t *networkController);

/**
 * @brief Get the elements of a command received.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command.
 * @param[out] error executing error.
 * @return Element dictionary of the command ; Can be null if an error is occurred.
 */
ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_GetCommandElements (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, eARCONTROLLER_ERROR *error);

/*******************************
 * --- FEATURE MiniDrone --- 
 ******************************/

/**
 * @brief Private part of ARCONTROLLER_FEATURE_MiniDrone_t.
 */
typedef struct ARCONTROLLER_FEATURE_MiniDrone_Private_t ARCONTROLLER_FEATURE_MiniDrone_Private_t;

/**
 * @brief Feature controller allow to send command related of MiniDrone Feature.
 * All MiniDrone-only commands
 */
typedef struct ARCONTROLLER_FEATURE_MiniDrone_t ARCONTROLLER_FEATURE_MiniDrone_t;

/**
 * @brief Create a new MiniDrone Feature Controller
 * @warning This function allocate memory
 * @post ARCONTROLLER_FEATURE_MiniDrone_Delete() must be called to delete the Feature Controller and free the memory allocated.
 * @param[in] networkController The networkController used to send commands ; can be NULL and defind later with ARCONTROLLER_FEATURE_MiniDrone_SetNetworkController().
 * @param[out] error executing error.
 * @return the new MiniDrone Feature Controller
 * @see ARCONTROLLER_FEATURE_MiniDrone_Delete
 */
ARCONTROLLER_FEATURE_MiniDrone_t *ARCONTROLLER_FEATURE_MiniDrone_New (ARCONTROLLER_Network_t *networkController, eARCONTROLLER_ERROR *error);

/**
 * @brief Delete the MiniDrone Feature Controller
 * @warning This function free memory
 * @param feature The feature controller to delete
 * @see ARCONTROLLER_FEATURE_MiniDrone_New
 */
void ARCONTROLLER_FEATURE_MiniDrone_Delete (ARCONTROLLER_FEATURE_MiniDrone_t **feature);

/**
 * @brief Get the dictionay of the MiniDrone Feature Controller
 * @param feature The feature controller owning the dictionary to get
 * @param[out] error executing error.
 */
ARCONTROLLER_DICTIONARY_COMMANDS_t *ARCONTROLLER_FEATURE_MiniDrone_GetDictionary (ARCONTROLLER_FEATURE_MiniDrone_t *feature, eARCONTROLLER_ERROR *error);

/**
 * @brief Add a callback to use when a command in project <code>MiniDrone</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] callback the callback to add.
 * @param[in] commandKey Key of the command which the callback must be associated.
 * @param[out] error executing error.
 * @param[int] customData custom data given as parameter to the callback.
 * @see ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_AddCallback (ARCONTROLLER_FEATURE_MiniDrone_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

/**
 * @brief Remove a callback used when a command in project <code>MiniDrone</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] callback the callback to remove.
 * @param[int] customData The custom data given to the register.
 * @param[out] error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (ARCONTROLLER_FEATURE_MiniDrone_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);


extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>PilotingStateFlyingStateChanged</code> in feature <code>MiniDrone</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>PilotingStateAlertStateChanged</code> in feature <code>MiniDrone</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_AUTOTAKEOFFMODECHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>PilotingStateAutoTakeOffModeChanged</code> in feature <code>MiniDrone</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>MediaRecordStatePictureStateChanged</code> in feature <code>MiniDrone</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGED_MASS_STORAGE_ID; /**< Key of the argument </code>mass_storage_id</code> of event <code>MediaRecordStatePictureStateChanged</code> in feature <code>MiniDrone</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE; /**< Key of the argument </code>state</code> of event <code>MediaRecordStatePictureStateChangedV2</code> in feature <code>MiniDrone</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR; /**< Key of the argument </code>error</code> of event <code>MediaRecordStatePictureStateChangedV2</code> in feature <code>MiniDrone</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT; /**< Key of the argument </code>event</code> of event <code>MediaRecordEventPictureEventChanged</code> in feature <code>MiniDrone</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR; /**< Key of the argument </code>error</code> of event <code>MediaRecordEventPictureEventChanged</code> in feature <code>MiniDrone</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED_CURRENT; /**< Key of the argument </code>current</code> of event <code>PilotingSettingsStateMaxAltitudeChanged</code> in feature <code>MiniDrone</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED_MIN; /**< Key of the argument </code>min</code> of event <code>PilotingSettingsStateMaxAltitudeChanged</code> in feature <code>MiniDrone</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED_MAX; /**< Key of the argument </code>max</code> of event <code>PilotingSettingsStateMaxAltitudeChanged</code> in feature <code>MiniDrone</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSETTINGSSTATE_MAXTILTCHANGED_CURRENT; /**< Key of the argument </code>current</code> of event <code>PilotingSettingsStateMaxTiltChanged</code> in feature <code>MiniDrone</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSETTINGSSTATE_MAXTILTCHANGED_MIN; /**< Key of the argument </code>min</code> of event <code>PilotingSettingsStateMaxTiltChanged</code> in feature <code>MiniDrone</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSETTINGSSTATE_MAXTILTCHANGED_MAX; /**< Key of the argument </code>max</code> of event <code>PilotingSettingsStateMaxTiltChanged</code> in feature <code>MiniDrone</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED_CURRENT; /**< Key of the argument </code>current</code> of event <code>SpeedSettingsStateMaxVerticalSpeedChanged</code> in feature <code>MiniDrone</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED_MIN; /**< Key of the argument </code>min</code> of event <code>SpeedSettingsStateMaxVerticalSpeedChanged</code> in feature <code>MiniDrone</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED_MAX; /**< Key of the argument </code>max</code> of event <code>SpeedSettingsStateMaxVerticalSpeedChanged</code> in feature <code>MiniDrone</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED_CURRENT; /**< Key of the argument </code>current</code> of event <code>SpeedSettingsStateMaxRotationSpeedChanged</code> in feature <code>MiniDrone</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED_MIN; /**< Key of the argument </code>min</code> of event <code>SpeedSettingsStateMaxRotationSpeedChanged</code> in feature <code>MiniDrone</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED_MAX; /**< Key of the argument </code>max</code> of event <code>SpeedSettingsStateMaxRotationSpeedChanged</code> in feature <code>MiniDrone</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_WHEELSCHANGED_PRESENT; /**< Key of the argument </code>present</code> of event <code>SpeedSettingsStateWheelsChanged</code> in feature <code>MiniDrone</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXHORIZONTALSPEEDCHANGED_CURRENT; /**< Key of the argument </code>current</code> of event <code>SpeedSettingsStateMaxHorizontalSpeedChanged</code> in feature <code>MiniDrone</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXHORIZONTALSPEEDCHANGED_MIN; /**< Key of the argument </code>min</code> of event <code>SpeedSettingsStateMaxHorizontalSpeedChanged</code> in feature <code>MiniDrone</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXHORIZONTALSPEEDCHANGED_MAX; /**< Key of the argument </code>max</code> of event <code>SpeedSettingsStateMaxHorizontalSpeedChanged</code> in feature <code>MiniDrone</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_PRODUCTMOTORSVERSIONCHANGED_MOTOR; /**< Key of the argument </code>motor</code> of event <code>SettingsStateProductMotorsVersionChanged</code> in feature <code>MiniDrone</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_PRODUCTMOTORSVERSIONCHANGED_TYPE; /**< Key of the argument </code>type</code> of event <code>SettingsStateProductMotorsVersionChanged</code> in feature <code>MiniDrone</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_PRODUCTMOTORSVERSIONCHANGED_SOFTWARE; /**< Key of the argument </code>software</code> of event <code>SettingsStateProductMotorsVersionChanged</code> in feature <code>MiniDrone</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_PRODUCTMOTORSVERSIONCHANGED_HARDWARE; /**< Key of the argument </code>hardware</code> of event <code>SettingsStateProductMotorsVersionChanged</code> in feature <code>MiniDrone</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_PRODUCTINERTIALVERSIONCHANGED_SOFTWARE; /**< Key of the argument </code>software</code> of event <code>SettingsStateProductInertialVersionChanged</code> in feature <code>MiniDrone</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_PRODUCTINERTIALVERSIONCHANGED_HARDWARE; /**< Key of the argument </code>hardware</code> of event <code>SettingsStateProductInertialVersionChanged</code> in feature <code>MiniDrone</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_CUTOUTMODECHANGED_ENABLE; /**< Key of the argument </code>enable</code> of event <code>SettingsStateCutOutModeChanged</code> in feature <code>MiniDrone</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_FLOODCONTROLSTATE_FLOODCONTROLCHANGED_DELAY; /**< Key of the argument </code>delay</code> of event <code>FloodControlStateFloodControlChanged</code> in feature <code>MiniDrone</code> */

/**
 * @brief Send a command <code>PilotingFlatTrim</code> in feature <code>MiniDrone</code>
 * Do a flat trim
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendPilotingFlatTrim_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature);

/**
 * @brief Send a command <code>PilotingTakeOff</code> in feature <code>MiniDrone</code>
 * Ask the drone to take off
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendPilotingTakeOff_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature);

/**
 * @brief Send a command <code>PilotingPCMD</code> in feature <code>MiniDrone</code>
 * Ask the drone to move around.
 * @param feature feature owning the commands
 * @param flag Boolean flag to activate roll/pitch movement
 * @param roll Roll consign for the MiniDrone [-100;100]
 * @param pitch Pitch consign for the MiniDrone [-100;100]
 * @param yaw Yaw consign for the MiniDrone [-100;100]
 * @param gaz Gaz consign for the MiniDrone [-100;100]
 * @param timestamp Timestamp in miliseconds. Not an absolute time. (Typically 0 = time of connexion).
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendPilotingPCMD_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, uint8_t flag, int8_t roll, int8_t pitch, int8_t yaw, int8_t gaz, uint32_t timestamp);

/**
 * @brief Set the parameters to send through the command <code>PilotingPCMD</code> in project <code>MiniDrone</code>
 * Ask the drone to move around.
 * @param feature feature owning the commands
 * @param flag Boolean flag to activate roll/pitch movement
 * @param roll Roll consign for the MiniDrone [-100;100]
 * @param pitch Pitch consign for the MiniDrone [-100;100]
 * @param yaw Yaw consign for the MiniDrone [-100;100]
 * @param gaz Gaz consign for the MiniDrone [-100;100]
 * @param timestamp Timestamp in miliseconds. Not an absolute time. (Typically 0 = time of connexion).
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMD_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, uint8_t flag, int8_t roll, int8_t pitch, int8_t yaw, int8_t gaz, uint32_t timestamp);

/**
 * @brief Send the a command <code>PilotingPCMD</code> in project <code>MiniDrone</code> with the parame set beforehand 
 * Ask the drone to move around.
 * @param feature feature owning the commands
 * @param cmdBuffer buffer to store the command
 * @param cmdBufferSize size of the buffer
 * return executing error
 */
eARCONTROLLER_ERROR ARCONTROLLER_MiniDrone_SendPilotingPCMDStruct (ARCONTROLLER_FEATURE_MiniDrone_t *feature, u_int8_t *cmdBuffer, int32_t cmdBufferSize);

/**
 * @brief Set flag sent through the command <code>PilotingPCMD</code> in project <code>MiniDrone</code>
 * Ask the drone to move around.
 * @param feature feature owning the commands
 * @param flag Boolean flag to activate roll/pitch movement
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDFlag_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, uint8_t flag);

/**
 * @brief Set roll sent through the command <code>PilotingPCMD</code> in project <code>MiniDrone</code>
 * Ask the drone to move around.
 * @param feature feature owning the commands
 * @param roll Roll consign for the MiniDrone [-100;100]
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDRoll_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, int8_t roll);

/**
 * @brief Set pitch sent through the command <code>PilotingPCMD</code> in project <code>MiniDrone</code>
 * Ask the drone to move around.
 * @param feature feature owning the commands
 * @param pitch Pitch consign for the MiniDrone [-100;100]
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDPitch_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, int8_t pitch);

/**
 * @brief Set yaw sent through the command <code>PilotingPCMD</code> in project <code>MiniDrone</code>
 * Ask the drone to move around.
 * @param feature feature owning the commands
 * @param yaw Yaw consign for the MiniDrone [-100;100]
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDYaw_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, int8_t yaw);

/**
 * @brief Set gaz sent through the command <code>PilotingPCMD</code> in project <code>MiniDrone</code>
 * Ask the drone to move around.
 * @param feature feature owning the commands
 * @param gaz Gaz consign for the MiniDrone [-100;100]
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDGaz_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, int8_t gaz);

/**
 * @brief Set timestamp sent through the command <code>PilotingPCMD</code> in project <code>MiniDrone</code>
 * Ask the drone to move around.
 * @param feature feature owning the commands
 * @param timestamp Timestamp in miliseconds. Not an absolute time. (Typically 0 = time of connexion).
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDTimestamp_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, uint32_t timestamp);

/**
 * @brief Send a command <code>PilotingLanding</code> in feature <code>MiniDrone</code>
 * Ask the MiniDrone to land
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendPilotingLanding_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature);

/**
 * @brief Send a command <code>PilotingEmergency</code> in feature <code>MiniDrone</code>
 * Put drone in emergency state
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendPilotingEmergency_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature);

/**
 * @brief Send a command <code>PilotingAutoTakeOffMode</code> in feature <code>MiniDrone</code>
 * Set MiniDrone automatic take off mode
 * @param feature feature owning the commands
 * @param state State of automatic take off mode
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendPilotingAutoTakeOffMode_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, uint8_t state);

/**
 * @brief Send a command <code>AnimationsFlip</code> in feature <code>MiniDrone</code>
 * Make a flip
 * @param feature feature owning the commands
 * @param direction Direction for the flip
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendAnimationsFlip_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, eARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION direction);

/**
 * @brief Send a command <code>AnimationsCap</code> in feature <code>MiniDrone</code>
 * Change the product cap
 * @param feature feature owning the commands
 * @param offset Change the cap with offset angle [-180;180]
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendAnimationsCap_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, int16_t offset);

/**
 * @brief Send a command <code>MediaRecordPicture</code> in feature <code>MiniDrone</code>
 * @deprecated
 * Take picture
 * @param feature feature owning the commands
 * @param mass_storage_id Mass storage id to take picture
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendMediaRecordPicture_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, uint8_t mass_storage_id);

/**
 * @brief Send a command <code>MediaRecordPictureV2</code> in feature <code>MiniDrone</code>
 * Take picture
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendMediaRecordPictureV2_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature);

/**
 * @brief Send a command <code>PilotingSettingsMaxAltitude</code> in feature <code>MiniDrone</code>
 * Set Max Altitude
 * @param feature feature owning the commands
 * @param current Current altitude max in m
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendPilotingSettingsMaxAltitude_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, float current);

/**
 * @brief Send a command <code>PilotingSettingsMaxTilt</code> in feature <code>MiniDrone</code>
 * Set Max Tilt
 * @param feature feature owning the commands
 * @param current Current tilt max in degree
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendPilotingSettingsMaxTilt_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, float current);

/**
 * @brief Send a command <code>SpeedSettingsMaxVerticalSpeed</code> in feature <code>MiniDrone</code>
 * Set Max Vertical speed
 * @param feature feature owning the commands
 * @param current Current max vertical speed in m/s
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendSpeedSettingsMaxVerticalSpeed_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, float current);

/**
 * @brief Send a command <code>SpeedSettingsMaxRotationSpeed</code> in feature <code>MiniDrone</code>
 * Set Max Rotation speed
 * @param feature feature owning the commands
 * @param current Current max rotation speed in degree/s
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendSpeedSettingsMaxRotationSpeed_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, float current);

/**
 * @brief Send a command <code>SpeedSettingsWheels</code> in feature <code>MiniDrone</code>
 * Presence of wheels
 * @param feature feature owning the commands
 * @param present 1 if present, 0 if not present
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendSpeedSettingsWheels_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, uint8_t present);

/**
 * @brief Send a command <code>SpeedSettingsMaxHorizontalSpeed</code> in feature <code>MiniDrone</code>
 * Set Max Horizontal speed (only used in case where PilotingSettings_MaxTilt is not used like in hydrofoil mode)
 * @param feature feature owning the commands
 * @param current Current max Horizontal speed in m/s
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendSpeedSettingsMaxHorizontalSpeed_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, float current);

/**
 * @brief Send a command <code>SettingsCutOutMode</code> in feature <code>MiniDrone</code>
 * Set MiniDrone cut out mode
 * @param feature feature owning the commands
 * @param enable Enable cut out mode (1 if is activate, 0 otherwise)
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendSettingsCutOutMode_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, uint8_t enable);

/**
 * @brief Send a command <code>GPSControllerLatitudeForRun</code> in feature <code>MiniDrone</code>
 * Set the controller latitude for a run.
 * @param feature feature owning the commands
 * @param latitude Controller latitude in decimal degrees
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendGPSControllerLatitudeForRun_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, double latitude);

/**
 * @brief Send a command <code>GPSControllerLongitudeForRun</code> in feature <code>MiniDrone</code>
 * Set the controller longitude for a run.
 * @param feature feature owning the commands
 * @param longitude Controller longitude in decimal degrees
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendGPSControllerLongitudeForRun_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, double longitude);

/**
 * @brief Send a command <code>ConfigurationControllerType</code> in feature <code>MiniDrone</code>
 * Set the controller type.
 * @param feature feature owning the commands
 * @param type Controller type like iOS or Android
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendConfigurationControllerType_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, char * type);

/**
 * @brief Send a command <code>ConfigurationControllerName</code> in feature <code>MiniDrone</code>
 * Set the controller name.
 * @param feature feature owning the commands
 * @param name Controller name like com.parrot.freeflight3
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_MiniDrone_SendConfigurationControllerName_t) (ARCONTROLLER_FEATURE_MiniDrone_t *feature, char * name);

/**
 * @brief Feature controller allow to send command related of MiniDrone Feature.
 * All MiniDrone-only commands
 */
struct ARCONTROLLER_FEATURE_MiniDrone_t
{
    ARCONTROLLER_FEATURE_MiniDrone_SendPilotingFlatTrim_t sendPilotingFlatTrim;
    ARCONTROLLER_FEATURE_MiniDrone_SendPilotingTakeOff_t sendPilotingTakeOff;
    ARCONTROLLER_FEATURE_MiniDrone_SendPilotingPCMD_t sendPilotingPCMD;
    ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMD_t setPilotingPCMD;
    ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDFlag_t setPilotingPCMDFlag; /**< Send a command <code>PilotingPCMD</code> in feature <code>MiniDrone</code>. */
    ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDRoll_t setPilotingPCMDRoll; /**< Send a command <code>PilotingPCMD</code> in feature <code>MiniDrone</code>. */
    ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDPitch_t setPilotingPCMDPitch; /**< Send a command <code>PilotingPCMD</code> in feature <code>MiniDrone</code>. */
    ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDYaw_t setPilotingPCMDYaw; /**< Send a command <code>PilotingPCMD</code> in feature <code>MiniDrone</code>. */
    ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDGaz_t setPilotingPCMDGaz; /**< Send a command <code>PilotingPCMD</code> in feature <code>MiniDrone</code>. */
    ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDTimestamp_t setPilotingPCMDTimestamp; /**< Send a command <code>PilotingPCMD</code> in feature <code>MiniDrone</code>. */
    ARCONTROLLER_FEATURE_MiniDrone_SendPilotingLanding_t sendPilotingLanding;
    ARCONTROLLER_FEATURE_MiniDrone_SendPilotingEmergency_t sendPilotingEmergency;
    ARCONTROLLER_FEATURE_MiniDrone_SendPilotingAutoTakeOffMode_t sendPilotingAutoTakeOffMode;
    ARCONTROLLER_FEATURE_MiniDrone_SendAnimationsFlip_t sendAnimationsFlip;
    ARCONTROLLER_FEATURE_MiniDrone_SendAnimationsCap_t sendAnimationsCap;
    ARCONTROLLER_FEATURE_MiniDrone_SendMediaRecordPicture_t sendMediaRecordPicture;
    ARCONTROLLER_FEATURE_MiniDrone_SendMediaRecordPictureV2_t sendMediaRecordPictureV2;
    ARCONTROLLER_FEATURE_MiniDrone_SendPilotingSettingsMaxAltitude_t sendPilotingSettingsMaxAltitude;
    ARCONTROLLER_FEATURE_MiniDrone_SendPilotingSettingsMaxTilt_t sendPilotingSettingsMaxTilt;
    ARCONTROLLER_FEATURE_MiniDrone_SendSpeedSettingsMaxVerticalSpeed_t sendSpeedSettingsMaxVerticalSpeed;
    ARCONTROLLER_FEATURE_MiniDrone_SendSpeedSettingsMaxRotationSpeed_t sendSpeedSettingsMaxRotationSpeed;
    ARCONTROLLER_FEATURE_MiniDrone_SendSpeedSettingsWheels_t sendSpeedSettingsWheels;
    ARCONTROLLER_FEATURE_MiniDrone_SendSpeedSettingsMaxHorizontalSpeed_t sendSpeedSettingsMaxHorizontalSpeed;
    ARCONTROLLER_FEATURE_MiniDrone_SendSettingsCutOutMode_t sendSettingsCutOutMode;
    ARCONTROLLER_FEATURE_MiniDrone_SendGPSControllerLatitudeForRun_t sendGPSControllerLatitudeForRun;
    ARCONTROLLER_FEATURE_MiniDrone_SendGPSControllerLongitudeForRun_t sendGPSControllerLongitudeForRun;
    ARCONTROLLER_FEATURE_MiniDrone_SendConfigurationControllerType_t sendConfigurationControllerType;
    ARCONTROLLER_FEATURE_MiniDrone_SendConfigurationControllerName_t sendConfigurationControllerName;
    ARCONTROLLER_FEATURE_MiniDrone_Private_t *privatePart; /**< Private part of ARCONTROLLER_FEATURE_MiniDrone_t */
};

/**
 * @brief Set a NetworkController to use to send commands.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] networkController The networkController used to send commands ; must be not NULL.
 * @return error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SetNetworkController (ARCONTROLLER_FEATURE_MiniDrone_t *feature, ARCONTROLLER_Network_t *networkController);

/**
 * @brief Get the elements of a command received.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command.
 * @param[out] error executing error.
 * @return Element dictionary of the command ; Can be null if an error is occurred.
 */
ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_MiniDrone_GetCommandElements (ARCONTROLLER_FEATURE_MiniDrone_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, eARCONTROLLER_ERROR *error);

/*******************************
 * --- FEATURE SkyController --- 
 ******************************/

/**
 * @brief Private part of ARCONTROLLER_FEATURE_SkyController_t.
 */
typedef struct ARCONTROLLER_FEATURE_SkyController_Private_t ARCONTROLLER_FEATURE_SkyController_Private_t;

/**
 * @brief Feature controller allow to send command related of SkyController Feature.
 * All SkyController-only commands
 */
typedef struct ARCONTROLLER_FEATURE_SkyController_t ARCONTROLLER_FEATURE_SkyController_t;

/**
 * @brief Create a new SkyController Feature Controller
 * @warning This function allocate memory
 * @post ARCONTROLLER_FEATURE_SkyController_Delete() must be called to delete the Feature Controller and free the memory allocated.
 * @param[in] networkController The networkController used to send commands ; can be NULL and defind later with ARCONTROLLER_FEATURE_SkyController_SetNetworkController().
 * @param[out] error executing error.
 * @return the new SkyController Feature Controller
 * @see ARCONTROLLER_FEATURE_SkyController_Delete
 */
ARCONTROLLER_FEATURE_SkyController_t *ARCONTROLLER_FEATURE_SkyController_New (ARCONTROLLER_Network_t *networkController, eARCONTROLLER_ERROR *error);

/**
 * @brief Delete the SkyController Feature Controller
 * @warning This function free memory
 * @param feature The feature controller to delete
 * @see ARCONTROLLER_FEATURE_SkyController_New
 */
void ARCONTROLLER_FEATURE_SkyController_Delete (ARCONTROLLER_FEATURE_SkyController_t **feature);

/**
 * @brief Get the dictionay of the SkyController Feature Controller
 * @param feature The feature controller owning the dictionary to get
 * @param[out] error executing error.
 */
ARCONTROLLER_DICTIONARY_COMMANDS_t *ARCONTROLLER_FEATURE_SkyController_GetDictionary (ARCONTROLLER_FEATURE_SkyController_t *feature, eARCONTROLLER_ERROR *error);

/**
 * @brief Add a callback to use when a command in project <code>SkyController</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] callback the callback to add.
 * @param[in] commandKey Key of the command which the callback must be associated.
 * @param[out] error executing error.
 * @param[int] customData custom data given as parameter to the callback.
 * @see ARCONTROLLER_FEATURE_SkyController_RemoveCallback.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_SkyController_AddCallback (ARCONTROLLER_FEATURE_SkyController_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

/**
 * @brief Remove a callback used when a command in project <code>SkyController</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] callback the callback to remove.
 * @param[int] customData The custom data given to the register.
 * @param[out] error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_SkyController_RemoveCallback (ARCONTROLLER_FEATURE_SkyController_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFILIST_BSSID; /**< Key of the argument </code>bssid</code> of event <code>WifiStateWifiList</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFILIST_SSID; /**< Key of the argument </code>ssid</code> of event <code>WifiStateWifiList</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFILIST_SECURED; /**< Key of the argument </code>secured</code> of event <code>WifiStateWifiList</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFILIST_SAVED; /**< Key of the argument </code>saved</code> of event <code>WifiStateWifiList</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFILIST_RSSI; /**< Key of the argument </code>rssi</code> of event <code>WifiStateWifiList</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFILIST_FREQUENCY; /**< Key of the argument </code>frequency</code> of event <code>WifiStateWifiList</code> in feature <code>SkyController</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED_SSID; /**< Key of the argument </code>ssid</code> of event <code>WifiStateConnexionChanged</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED_STATUS; /**< Key of the argument </code>status</code> of event <code>WifiStateConnexionChanged</code> in feature <code>SkyController</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED_BAND; /**< Key of the argument </code>band</code> of event <code>WifiStateWifiAuthChannelListChanged</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED_CHANNEL; /**< Key of the argument </code>channel</code> of event <code>WifiStateWifiAuthChannelListChanged</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED_IN_OR_OUT; /**< Key of the argument </code>in_or_out</code> of event <code>WifiStateWifiAuthChannelListChanged</code> in feature <code>SkyController</code> */


extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_WIFISTATE_WIFISIGNALCHANGED_LEVEL; /**< Key of the argument </code>level</code> of event <code>WifiStateWifiSignalChanged</code> in feature <code>SkyController</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_DEVICESTATE_DEVICELIST_NAME; /**< Key of the argument </code>name</code> of event <code>DeviceStateDeviceList</code> in feature <code>SkyController</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS; /**< Key of the argument </code>status</code> of event <code>DeviceStateConnexionChanged</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_DEVICENAME; /**< Key of the argument </code>deviceName</code> of event <code>DeviceStateConnexionChanged</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_DEVICEPRODUCTID; /**< Key of the argument </code>deviceProductID</code> of event <code>DeviceStateConnexionChanged</code> in feature <code>SkyController</code> */



extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SETTINGSSTATE_PRODUCTSERIALCHANGED_SERIALNUMBER; /**< Key of the argument </code>serialNumber</code> of event <code>SettingsStateProductSerialChanged</code> in feature <code>SkyController</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SETTINGSSTATE_PRODUCTVARIANTCHANGED_VARIANT; /**< Key of the argument </code>variant</code> of event <code>SettingsStateProductVariantChanged</code> in feature <code>SkyController</code> */


extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SKYCONTROLLERSTATE_BATTERYCHANGED_PERCENT; /**< Key of the argument </code>percent</code> of event <code>SkyControllerStateBatteryChanged</code> in feature <code>SkyController</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SKYCONTROLLERSTATE_GPSFIXCHANGED_FIXED; /**< Key of the argument </code>fixed</code> of event <code>SkyControllerStateGpsFixChanged</code> in feature <code>SkyController</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SKYCONTROLLERSTATE_GPSPOSITIONCHANGED_LATITUDE; /**< Key of the argument </code>latitude</code> of event <code>SkyControllerStateGpsPositionChanged</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SKYCONTROLLERSTATE_GPSPOSITIONCHANGED_LONGITUDE; /**< Key of the argument </code>longitude</code> of event <code>SkyControllerStateGpsPositionChanged</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SKYCONTROLLERSTATE_GPSPOSITIONCHANGED_ALTITUDE; /**< Key of the argument </code>altitude</code> of event <code>SkyControllerStateGpsPositionChanged</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_SKYCONTROLLERSTATE_GPSPOSITIONCHANGED_HEADING; /**< Key of the argument </code>heading</code> of event <code>SkyControllerStateGpsPositionChanged</code> in feature <code>SkyController</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_ACCESSPOINTSSIDCHANGED_SSID; /**< Key of the argument </code>ssid</code> of event <code>AccessPointSettingsStateAccessPointSSIDChanged</code> in feature <code>SkyController</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_ACCESSPOINTCHANNELCHANGED_CHANNEL; /**< Key of the argument </code>channel</code> of event <code>AccessPointSettingsStateAccessPointChannelChanged</code> in feature <code>SkyController</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE; /**< Key of the argument </code>type</code> of event <code>AccessPointSettingsStateWifiSelectionChanged</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_BAND; /**< Key of the argument </code>band</code> of event <code>AccessPointSettingsStateWifiSelectionChanged</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_CHANNEL; /**< Key of the argument </code>channel</code> of event <code>AccessPointSettingsStateWifiSelectionChanged</code> in feature <code>SkyController</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL_TYPE; /**< Key of the argument </code>type</code> of event <code>GamepadInfosStateGamepadControl</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL_ID; /**< Key of the argument </code>id</code> of event <code>GamepadInfosStateGamepadControl</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL_NAME; /**< Key of the argument </code>name</code> of event <code>GamepadInfosStateGamepadControl</code> in feature <code>SkyController</code> */


extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CURRENTBUTTONMAPPINGS_KEY_ID; /**< Key of the argument </code>key_id</code> of event <code>ButtonMappingsStateCurrentButtonMappings</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CURRENTBUTTONMAPPINGS_MAPPING_UID; /**< Key of the argument </code>mapping_uid</code> of event <code>ButtonMappingsStateCurrentButtonMappings</code> in feature <code>SkyController</code> */


extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONMAPPINGSSTATE_AVAILABLEBUTTONMAPPINGS_MAPPING_UID; /**< Key of the argument </code>mapping_uid</code> of event <code>ButtonMappingsStateAvailableButtonMappings</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_BUTTONMAPPINGSSTATE_AVAILABLEBUTTONMAPPINGS_NAME; /**< Key of the argument </code>name</code> of event <code>ButtonMappingsStateAvailableButtonMappings</code> in feature <code>SkyController</code> */


extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISMAPPINGSSTATE_CURRENTAXISMAPPINGS_AXIS_ID; /**< Key of the argument </code>axis_id</code> of event <code>AxisMappingsStateCurrentAxisMappings</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISMAPPINGSSTATE_CURRENTAXISMAPPINGS_MAPPING_UID; /**< Key of the argument </code>mapping_uid</code> of event <code>AxisMappingsStateCurrentAxisMappings</code> in feature <code>SkyController</code> */


extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISMAPPINGSSTATE_AVAILABLEAXISMAPPINGS_MAPPING_UID; /**< Key of the argument </code>mapping_uid</code> of event <code>AxisMappingsStateAvailableAxisMappings</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISMAPPINGSSTATE_AVAILABLEAXISMAPPINGS_NAME; /**< Key of the argument </code>name</code> of event <code>AxisMappingsStateAvailableAxisMappings</code> in feature <code>SkyController</code> */


extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISFILTERSSTATE_CURRENTAXISFILTERS_AXIS_ID; /**< Key of the argument </code>axis_id</code> of event <code>AxisFiltersStateCurrentAxisFilters</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISFILTERSSTATE_CURRENTAXISFILTERS_FILTER_UID_OR_BUILDER; /**< Key of the argument </code>filter_uid_or_builder</code> of event <code>AxisFiltersStateCurrentAxisFilters</code> in feature <code>SkyController</code> */


extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISFILTERSSTATE_PRESETAXISFILTERS_FILTER_UID; /**< Key of the argument </code>filter_uid</code> of event <code>AxisFiltersStatePresetAxisFilters</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_AXISFILTERSSTATE_PRESETAXISFILTERS_NAME; /**< Key of the argument </code>name</code> of event <code>AxisFiltersStatePresetAxisFilters</code> in feature <code>SkyController</code> */


extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_COPILOTINGSTATE_PILOTINGSOURCE_SOURCE; /**< Key of the argument </code>source</code> of event <code>CoPilotingStatePilotingSource</code> in feature <code>SkyController</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_STATUS; /**< Key of the argument </code>status</code> of event <code>CalibrationStateMagnetoCalibrationState</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_X_QUALITY; /**< Key of the argument </code>X_Quality</code> of event <code>CalibrationStateMagnetoCalibrationState</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_Y_QUALITY; /**< Key of the argument </code>Y_Quality</code> of event <code>CalibrationStateMagnetoCalibrationState</code> in feature <code>SkyController</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_Z_QUALITY; /**< Key of the argument </code>Z_Quality</code> of event <code>CalibrationStateMagnetoCalibrationState</code> in feature <code>SkyController</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONQUALITYUPDATESSTATE_ENABLED; /**< Key of the argument </code>enabled</code> of event <code>CalibrationStateMagnetoCalibrationQualityUpdatesState</code> in feature <code>SkyController</code> */


/**
 * @brief Send a command <code>WifiRequestWifiList</code> in feature <code>SkyController</code>
 * Request wifi list
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendWifiRequestWifiList_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>WifiRequestCurrentWifi</code> in feature <code>SkyController</code>
 * Request current connected wifi
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendWifiRequestCurrentWifi_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>WifiConnectToWifi</code> in feature <code>SkyController</code>
 * Connect to wifi
 * @param feature feature owning the commands
 * @param bssid Wifi bssid
 * @param ssid Wifi ssid
 * @param passphrase Wifi passphrase
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendWifiConnectToWifi_t) (ARCONTROLLER_FEATURE_SkyController_t *feature, char * bssid, char * ssid, char * passphrase);

/**
 * @brief Send a command <code>WifiForgetWifi</code> in feature <code>SkyController</code>
 * Forget wifi
 * @param feature feature owning the commands
 * @param ssid Wifi ssid
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendWifiForgetWifi_t) (ARCONTROLLER_FEATURE_SkyController_t *feature, char * ssid);

/**
 * @brief Send a command <code>WifiWifiAuthChannel</code> in feature <code>SkyController</code>
 * Controller inquire the list of authorized wifi channels
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendWifiWifiAuthChannel_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>DeviceRequestDeviceList</code> in feature <code>SkyController</code>
 * Request Device list
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendDeviceRequestDeviceList_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>DeviceRequestCurrentDevice</code> in feature <code>SkyController</code>
 * Request current connected Device
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendDeviceRequestCurrentDevice_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>DeviceConnectToDevice</code> in feature <code>SkyController</code>
 * ask to connect to a device
 * @param feature feature owning the commands
 * @param deviceName Device name
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendDeviceConnectToDevice_t) (ARCONTROLLER_FEATURE_SkyController_t *feature, char * deviceName);

/**
 * @brief Send a command <code>SettingsAllSettings</code> in feature <code>SkyController</code>
 * Get all product settings, the product must send all settings
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendSettingsAllSettings_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>SettingsReset</code> in feature <code>SkyController</code>
 * Reset all settings
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendSettingsReset_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>CommonAllStates</code> in feature <code>SkyController</code>
 * Get all product states
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendCommonAllStates_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>AccessPointSettingsAccessPointSSID</code> in feature <code>SkyController</code>
 * Set AccessPoint SSID
 * @param feature feature owning the commands
 * @param ssid AccessPoint SSID
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendAccessPointSettingsAccessPointSSID_t) (ARCONTROLLER_FEATURE_SkyController_t *feature, char * ssid);

/**
 * @brief Send a command <code>AccessPointSettingsAccessPointChannel</code> in feature <code>SkyController</code>
 * Set AccessPoint Channel
 * @param feature feature owning the commands
 * @param channel AccessPoint Channel
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendAccessPointSettingsAccessPointChannel_t) (ARCONTROLLER_FEATURE_SkyController_t *feature, uint8_t channel);

/**
 * @brief Send a command <code>AccessPointSettingsWifiSelection</code> in feature <code>SkyController</code>
 * Set AccessPoint Band and Channel
 * @param feature feature owning the commands
 * @param type The type of wifi selection (only manual at the moment)
 * @param band The allowed band : 2.4 Ghz or 5 Ghz
 * @param channel The channel
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendAccessPointSettingsWifiSelection_t) (ARCONTROLLER_FEATURE_SkyController_t *feature, eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_TYPE type, eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_BAND band, uint8_t channel);

/**
 * @brief Send a command <code>CameraResetOrientation</code> in feature <code>SkyController</code>
 * Reset pan and tilt to center
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendCameraResetOrientation_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>GamepadInfosGetGamepadControls</code> in feature <code>SkyController</code>
 * Asks the SkyController to send the button and axis list
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendGamepadInfosGetGamepadControls_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>ButtonMappingsGetCurrentButtonMappings</code> in feature <code>SkyController</code>
 * Asks the SkyController to send its current button mapping
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendButtonMappingsGetCurrentButtonMappings_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>ButtonMappingsGetAvailableButtonMappings</code> in feature <code>SkyController</code>
 * Asks the SkyController to send the possible mappings for each button
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendButtonMappingsGetAvailableButtonMappings_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>ButtonMappingsSetButtonMapping</code> in feature <code>SkyController</code>
 * Set a button mapping to the SkyController
 * @note replaces previous mapping for the given key
 * @param feature feature owning the commands
 * @param key_id The keycode to map
 * @param mapping_uid The mapping to associate with the key
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendButtonMappingsSetButtonMapping_t) (ARCONTROLLER_FEATURE_SkyController_t *feature, int32_t key_id, char * mapping_uid);

/**
 * @brief Send a command <code>ButtonMappingsDefaultButtonMapping</code> in feature <code>SkyController</code>
 * Asks the SkyController to reset the button mappings to the default value
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendButtonMappingsDefaultButtonMapping_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>AxisMappingsGetCurrentAxisMappings</code> in feature <code>SkyController</code>
 * Asks the SkyController to send its current axis mapping
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendAxisMappingsGetCurrentAxisMappings_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>AxisMappingsGetAvailableAxisMappings</code> in feature <code>SkyController</code>
 * Asks the SkyController to send the possible mappings for each axis
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendAxisMappingsGetAvailableAxisMappings_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>AxisMappingsSetAxisMapping</code> in feature <code>SkyController</code>
 * Set a axis mapping to the SkyController
 * @note replaces previous mapping for the given axis
 * @param feature feature owning the commands
 * @param axis_id The axiscode to map
 * @param mapping_uid The mapping to associate with the axis
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendAxisMappingsSetAxisMapping_t) (ARCONTROLLER_FEATURE_SkyController_t *feature, int32_t axis_id, char * mapping_uid);

/**
 * @brief Send a command <code>AxisMappingsDefaultAxisMapping</code> in feature <code>SkyController</code>
 * Asks the SkyController to reset the axis mappings to the default value
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendAxisMappingsDefaultAxisMapping_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>AxisFiltersGetCurrentAxisFilters</code> in feature <code>SkyController</code>
 * Asks the SkyController to send its current axis filters
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendAxisFiltersGetCurrentAxisFilters_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>AxisFiltersGetPresetAxisFilters</code> in feature <code>SkyController</code>
 * Asks the SkyController to send the preset filters
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendAxisFiltersGetPresetAxisFilters_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>AxisFiltersSetAxisFilter</code> in feature <code>SkyController</code>
 * Set an axis filter to the SkyController
 * @note replaces previous filter for the given axis
 * @param feature feature owning the commands
 * @param axis_id The axiscode to filter
 * @param filter_uid_or_builder The mapping preset to associate with the axis
 * @param filter_uid_or_builder (Or a string to build a new one)
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendAxisFiltersSetAxisFilter_t) (ARCONTROLLER_FEATURE_SkyController_t *feature, int32_t axis_id, char * filter_uid_or_builder);

/**
 * @brief Send a command <code>AxisFiltersDefaultAxisFilters</code> in feature <code>SkyController</code>
 * Asks the SkyController to reset the axis filters to the default value
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendAxisFiltersDefaultAxisFilters_t) (ARCONTROLLER_FEATURE_SkyController_t *feature);

/**
 * @brief Send a command <code>CoPilotingSetPilotingSource</code> in feature <code>SkyController</code>
 * Set the SkyController piloting source
 * @param feature feature owning the commands
 * @param source The source
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendCoPilotingSetPilotingSource_t) (ARCONTROLLER_FEATURE_SkyController_t *feature, eARCOMMANDS_SKYCONTROLLER_COPILOTING_SETPILOTINGSOURCE_SOURCE source);

/**
 * @brief Send a command <code>CalibrationEnableMagnetoCalibrationQualityUpdates</code> in feature <code>SkyController</code>
 * Asks the SkyController to send (or not) the magneto calibration quality updates.
 * The MagnetoCalibrationState will always be sent when the status parameters changes,
 * regardless of this setting.
 * @param feature feature owning the commands
 * @param enable Flag to enable the feature.
 * @param enable 1 = enable quality updates
 * @param enable 0 = disable quality updates
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_SkyController_SendCalibrationEnableMagnetoCalibrationQualityUpdates_t) (ARCONTROLLER_FEATURE_SkyController_t *feature, uint8_t enable);

/**
 * @brief Feature controller allow to send command related of SkyController Feature.
 * All SkyController-only commands
 */
struct ARCONTROLLER_FEATURE_SkyController_t
{
    ARCONTROLLER_FEATURE_SkyController_SendWifiRequestWifiList_t sendWifiRequestWifiList;
    ARCONTROLLER_FEATURE_SkyController_SendWifiRequestCurrentWifi_t sendWifiRequestCurrentWifi;
    ARCONTROLLER_FEATURE_SkyController_SendWifiConnectToWifi_t sendWifiConnectToWifi;
    ARCONTROLLER_FEATURE_SkyController_SendWifiForgetWifi_t sendWifiForgetWifi;
    ARCONTROLLER_FEATURE_SkyController_SendWifiWifiAuthChannel_t sendWifiWifiAuthChannel;
    ARCONTROLLER_FEATURE_SkyController_SendDeviceRequestDeviceList_t sendDeviceRequestDeviceList;
    ARCONTROLLER_FEATURE_SkyController_SendDeviceRequestCurrentDevice_t sendDeviceRequestCurrentDevice;
    ARCONTROLLER_FEATURE_SkyController_SendDeviceConnectToDevice_t sendDeviceConnectToDevice;
    ARCONTROLLER_FEATURE_SkyController_SendSettingsAllSettings_t sendSettingsAllSettings;
    ARCONTROLLER_FEATURE_SkyController_SendSettingsReset_t sendSettingsReset;
    ARCONTROLLER_FEATURE_SkyController_SendCommonAllStates_t sendCommonAllStates;
    ARCONTROLLER_FEATURE_SkyController_SendAccessPointSettingsAccessPointSSID_t sendAccessPointSettingsAccessPointSSID;
    ARCONTROLLER_FEATURE_SkyController_SendAccessPointSettingsAccessPointChannel_t sendAccessPointSettingsAccessPointChannel;
    ARCONTROLLER_FEATURE_SkyController_SendAccessPointSettingsWifiSelection_t sendAccessPointSettingsWifiSelection;
    ARCONTROLLER_FEATURE_SkyController_SendCameraResetOrientation_t sendCameraResetOrientation;
    ARCONTROLLER_FEATURE_SkyController_SendGamepadInfosGetGamepadControls_t sendGamepadInfosGetGamepadControls;
    ARCONTROLLER_FEATURE_SkyController_SendButtonMappingsGetCurrentButtonMappings_t sendButtonMappingsGetCurrentButtonMappings;
    ARCONTROLLER_FEATURE_SkyController_SendButtonMappingsGetAvailableButtonMappings_t sendButtonMappingsGetAvailableButtonMappings;
    ARCONTROLLER_FEATURE_SkyController_SendButtonMappingsSetButtonMapping_t sendButtonMappingsSetButtonMapping;
    ARCONTROLLER_FEATURE_SkyController_SendButtonMappingsDefaultButtonMapping_t sendButtonMappingsDefaultButtonMapping;
    ARCONTROLLER_FEATURE_SkyController_SendAxisMappingsGetCurrentAxisMappings_t sendAxisMappingsGetCurrentAxisMappings;
    ARCONTROLLER_FEATURE_SkyController_SendAxisMappingsGetAvailableAxisMappings_t sendAxisMappingsGetAvailableAxisMappings;
    ARCONTROLLER_FEATURE_SkyController_SendAxisMappingsSetAxisMapping_t sendAxisMappingsSetAxisMapping;
    ARCONTROLLER_FEATURE_SkyController_SendAxisMappingsDefaultAxisMapping_t sendAxisMappingsDefaultAxisMapping;
    ARCONTROLLER_FEATURE_SkyController_SendAxisFiltersGetCurrentAxisFilters_t sendAxisFiltersGetCurrentAxisFilters;
    ARCONTROLLER_FEATURE_SkyController_SendAxisFiltersGetPresetAxisFilters_t sendAxisFiltersGetPresetAxisFilters;
    ARCONTROLLER_FEATURE_SkyController_SendAxisFiltersSetAxisFilter_t sendAxisFiltersSetAxisFilter;
    ARCONTROLLER_FEATURE_SkyController_SendAxisFiltersDefaultAxisFilters_t sendAxisFiltersDefaultAxisFilters;
    ARCONTROLLER_FEATURE_SkyController_SendCoPilotingSetPilotingSource_t sendCoPilotingSetPilotingSource;
    ARCONTROLLER_FEATURE_SkyController_SendCalibrationEnableMagnetoCalibrationQualityUpdates_t sendCalibrationEnableMagnetoCalibrationQualityUpdates;
    ARCONTROLLER_FEATURE_SkyController_Private_t *privatePart; /**< Private part of ARCONTROLLER_FEATURE_SkyController_t */
};

/**
 * @brief Set a NetworkController to use to send commands.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] networkController The networkController used to send commands ; must be not NULL.
 * @return error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_SkyController_SetNetworkController (ARCONTROLLER_FEATURE_SkyController_t *feature, ARCONTROLLER_Network_t *networkController);

/**
 * @brief Get the elements of a command received.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command.
 * @param[out] error executing error.
 * @return Element dictionary of the command ; Can be null if an error is occurred.
 */
ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_SkyController_GetCommandElements (ARCONTROLLER_FEATURE_SkyController_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, eARCONTROLLER_ERROR *error);

/*******************************
 * --- FEATURE unknown_feature_1 --- 
 ******************************/

/**
 * @brief Private part of ARCONTROLLER_FEATURE_UnknownFeature1_t.
 */
typedef struct ARCONTROLLER_FEATURE_UnknownFeature1_Private_t ARCONTROLLER_FEATURE_UnknownFeature1_Private_t;

/**
 * @brief Feature controller allow to send command related of unknown_feature_1 Feature.
 * UnknownFeature_1 feature
 */
typedef struct ARCONTROLLER_FEATURE_UnknownFeature1_t ARCONTROLLER_FEATURE_UnknownFeature1_t;

/**
 * @brief Create a new unknown_feature_1 Feature Controller
 * @warning This function allocate memory
 * @post ARCONTROLLER_FEATURE_UnknownFeature1_Delete() must be called to delete the Feature Controller and free the memory allocated.
 * @param[in] networkController The networkController used to send commands ; can be NULL and defind later with ARCONTROLLER_FEATURE_UnknownFeature1_SetNetworkController().
 * @param[out] error executing error.
 * @return the new unknown_feature_1 Feature Controller
 * @see ARCONTROLLER_FEATURE_UnknownFeature1_Delete
 */
ARCONTROLLER_FEATURE_UnknownFeature1_t *ARCONTROLLER_FEATURE_UnknownFeature1_New (ARCONTROLLER_Network_t *networkController, eARCONTROLLER_ERROR *error);

/**
 * @brief Delete the unknown_feature_1 Feature Controller
 * @warning This function free memory
 * @param feature The feature controller to delete
 * @see ARCONTROLLER_FEATURE_UnknownFeature1_New
 */
void ARCONTROLLER_FEATURE_UnknownFeature1_Delete (ARCONTROLLER_FEATURE_UnknownFeature1_t **feature);

/**
 * @brief Get the dictionay of the unknown_feature_1 Feature Controller
 * @param feature The feature controller owning the dictionary to get
 * @param[out] error executing error.
 */
ARCONTROLLER_DICTIONARY_COMMANDS_t *ARCONTROLLER_FEATURE_UnknownFeature1_GetDictionary (ARCONTROLLER_FEATURE_UnknownFeature1_t *feature, eARCONTROLLER_ERROR *error);

/**
 * @brief Add a callback to use when a command in project <code>UnknownFeature1</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] callback the callback to add.
 * @param[in] commandKey Key of the command which the callback must be associated.
 * @param[out] error executing error.
 * @param[int] customData custom data given as parameter to the callback.
 * @see ARCONTROLLER_FEATURE_UnknownFeature1_RemoveCallback.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_UnknownFeature1_AddCallback (ARCONTROLLER_FEATURE_UnknownFeature1_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

/**
 * @brief Remove a callback used when a command in project <code>UnknownFeature1</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] callback the callback to remove.
 * @param[int] customData The custom data given to the register.
 * @param[out] error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_UnknownFeature1_RemoveCallback (ARCONTROLLER_FEATURE_UnknownFeature1_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_AVAILABILITY_TYPE; /**< Key of the argument </code>type</code> of event <code>Availability</code> in feature <code>UnknownFeature1</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_RUN_TYPE; /**< Key of the argument </code>type</code> of event <code>Run</code> in feature <code>UnknownFeature1</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_GEOGRAPHICCONFIGCHANGED_DISTANCE_IS_DEFAULT; /**< Key of the argument </code>distance_is_default</code> of event <code>GeographicConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_GEOGRAPHICCONFIGCHANGED_DISTANCE; /**< Key of the argument </code>distance</code> of event <code>GeographicConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_GEOGRAPHICCONFIGCHANGED_ELEVATION_IS_DEFAULT; /**< Key of the argument </code>elevation_is_default</code> of event <code>GeographicConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_GEOGRAPHICCONFIGCHANGED_ELEVATION; /**< Key of the argument </code>elevation</code> of event <code>GeographicConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_GEOGRAPHICCONFIGCHANGED_AZIMUTH_IS_DEFAULT; /**< Key of the argument </code>azimuth_is_default</code> of event <code>GeographicConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_GEOGRAPHICCONFIGCHANGED_AZIMUTH; /**< Key of the argument </code>azimuth</code> of event <code>GeographicConfigChanged</code> in feature <code>UnknownFeature1</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_RELATIVECONFIGCHANGED_DISTANCE_IS_DEFAULT; /**< Key of the argument </code>distance_is_default</code> of event <code>RelativeConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_RELATIVECONFIGCHANGED_DISTANCE; /**< Key of the argument </code>distance</code> of event <code>RelativeConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_RELATIVECONFIGCHANGED_ELEVATION_IS_DEFAULT; /**< Key of the argument </code>elevation_is_default</code> of event <code>RelativeConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_RELATIVECONFIGCHANGED_ELEVATION; /**< Key of the argument </code>elevation</code> of event <code>RelativeConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_RELATIVECONFIGCHANGED_AZIMUTH_IS_DEFAULT; /**< Key of the argument </code>azimuth_is_default</code> of event <code>RelativeConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_RELATIVECONFIGCHANGED_AZIMUTH; /**< Key of the argument </code>azimuth</code> of event <code>RelativeConfigChanged</code> in feature <code>UnknownFeature1</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_ANIMRUN_TYPE; /**< Key of the argument </code>type</code> of event <code>AnimRun</code> in feature <code>UnknownFeature1</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_SPIRALANIMCONFIGCHANGED_SPEED_IS_DEFAULT; /**< Key of the argument </code>speed_is_default</code> of event <code>SpiralAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_SPIRALANIMCONFIGCHANGED_SPEED; /**< Key of the argument </code>speed</code> of event <code>SpiralAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_SPIRALANIMCONFIGCHANGED_REVOLUTION_NB_IS_DEFAULT; /**< Key of the argument </code>revolution_nb_is_default</code> of event <code>SpiralAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_SPIRALANIMCONFIGCHANGED_REVOLUTION_NB; /**< Key of the argument </code>revolution_nb</code> of event <code>SpiralAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_SPIRALANIMCONFIGCHANGED_VERTICAL_DISTANCE_IS_DEFAULT; /**< Key of the argument </code>vertical_distance_is_default</code> of event <code>SpiralAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_SPIRALANIMCONFIGCHANGED_VERTICAL_DISTANCE; /**< Key of the argument </code>vertical_distance</code> of event <code>SpiralAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_SWINGANIMCONFIGCHANGED_SPEED_IS_DEFAULT; /**< Key of the argument </code>speed_is_default</code> of event <code>SwingAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_SWINGANIMCONFIGCHANGED_SPEED; /**< Key of the argument </code>speed</code> of event <code>SwingAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_SWINGANIMCONFIGCHANGED_VERTICAL_DISTANCE_IS_DEFAULT; /**< Key of the argument </code>vertical_distance_is_default</code> of event <code>SwingAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_SWINGANIMCONFIGCHANGED_VERTICAL_DISTANCE; /**< Key of the argument </code>vertical_distance</code> of event <code>SwingAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_BOOMERANGANIMCONFIGCHANGED_SPEED_IS_DEFAULT; /**< Key of the argument </code>speed_is_default</code> of event <code>BoomerangAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_BOOMERANGANIMCONFIGCHANGED_SPEED; /**< Key of the argument </code>speed</code> of event <code>BoomerangAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_BOOMERANGANIMCONFIGCHANGED_DISTANCE_IS_DEFAULT; /**< Key of the argument </code>distance_is_default</code> of event <code>BoomerangAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_BOOMERANGANIMCONFIGCHANGED_DISTANCE; /**< Key of the argument </code>distance</code> of event <code>BoomerangAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_CANDLEANIMCONFIGCHANGED_SPEED_IS_DEFAULT; /**< Key of the argument </code>speed_is_default</code> of event <code>CandleAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_CANDLEANIMCONFIGCHANGED_SPEED; /**< Key of the argument </code>speed</code> of event <code>CandleAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_CANDLEANIMCONFIGCHANGED_VERTICAL_DISTANCE_IS_DEFAULT; /**< Key of the argument </code>vertical_distance_is_default</code> of event <code>CandleAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_CANDLEANIMCONFIGCHANGED_VERTICAL_DISTANCE; /**< Key of the argument </code>vertical_distance</code> of event <code>CandleAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_DOLLYSLIDEANIMCONFIGCHANGED_SPEED_IS_DEFAULT; /**< Key of the argument </code>speed_is_default</code> of event <code>DollySlideAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_DOLLYSLIDEANIMCONFIGCHANGED_SPEED; /**< Key of the argument </code>speed</code> of event <code>DollySlideAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_DOLLYSLIDEANIMCONFIGCHANGED_ANGLE_IS_DEFAULT; /**< Key of the argument </code>angle_is_default</code> of event <code>DollySlideAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_DOLLYSLIDEANIMCONFIGCHANGED_ANGLE; /**< Key of the argument </code>angle</code> of event <code>DollySlideAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_DOLLYSLIDEANIMCONFIGCHANGED_HORIZONTAL_DISTANCE_IS_DEFAULT; /**< Key of the argument </code>horizontal_distance_is_default</code> of event <code>DollySlideAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_DOLLYSLIDEANIMCONFIGCHANGED_HORIZONTAL_DISTANCE; /**< Key of the argument </code>horizontal_distance</code> of event <code>DollySlideAnimConfigChanged</code> in feature <code>UnknownFeature1</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_USERFRAMINGPOSITIONCHANGED_HORIZONTAL; /**< Key of the argument </code>horizontal</code> of event <code>UserFramingPositionChanged</code> in feature <code>UnknownFeature1</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_UNKNOWN_FEATURE_1_USERFRAMINGPOSITIONCHANGED_VERTICAL; /**< Key of the argument </code>vertical</code> of event <code>UserFramingPositionChanged</code> in feature <code>UnknownFeature1</code> */

/**
 * @brief Send a command <code>GeographicRun</code> in feature <code>UnknownFeature1</code>
 * Begin or stop geographic type followMe (follow the leader keeping the same vector). \n\                       Sending this command will stop other running followMe.
 * @param feature feature owning the commands
 * @param start 1 to start geographic unknown feature_1 process, 0 to stop it
 * @param start Begin or stop geographic type followMe (follow the leader keeping the same vector). \n\                       Sending this command will stop other running followMe.
 * @param distance_is_default 0 if distance is set by user, 1 if set by current distance (in this case distance value is not used)
 * @param distance_is_default Not used when arg start is at 0
 * @param distance_is_default Begin or stop geographic type followMe (follow the leader keeping the same vector). \n\                       Sending this command will stop other running followMe.
 * @param distance The distance leader-follower in meter
 * @param distance Not used when arg start is at 0
 * @param distance Begin or stop geographic type followMe (follow the leader keeping the same vector). \n\                       Sending this command will stop other running followMe.
 * @param elevation_is_default 0 if elevation is set by user, 1 if set by current elevation (in this case elevation value is not used) (not used when arg start is at 0)
 * @param elevation_is_default Begin or stop geographic type followMe (follow the leader keeping the same vector). \n\                       Sending this command will stop other running followMe.
 * @param elevation The elevation leader-follower in rad (not used when arg start is at 0)
 * @param elevation Begin or stop geographic type followMe (follow the leader keeping the same vector). \n\                       Sending this command will stop other running followMe.
 * @param azimuth_is_default 0 if azimuth is set by user, 1 if set by current azimuth (in this case azimuth value is not used) (not used when arg start is at 0)
 * @param azimuth_is_default Begin or stop geographic type followMe (follow the leader keeping the same vector). \n\                       Sending this command will stop other running followMe.
 * @param azimuth The azimuth north-leader-follower in rad (not used when arg start is at 0)
 * @param azimuth Begin or stop geographic type followMe (follow the leader keeping the same vector). \n\                       Sending this command will stop other running followMe.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_UnknownFeature1_SendGeographicRun_t) (ARCONTROLLER_FEATURE_UnknownFeature1_t *feature, uint8_t start, uint8_t distance_is_default, float distance, uint8_t elevation_is_default, float elevation, uint8_t azimuth_is_default, float azimuth);

/**
 * @brief Send a command <code>RelativeRun</code> in feature <code>UnknownFeature1</code>
 * Begin or stop relative type followMe (follow the leader keeping the same orientation to its direction).\n\                       Sending this command will stop other running followMe.
 * @param feature feature owning the commands
 * @param start 1 to start relative unknown feature_1 process, 0 to stop it
 * @param start Begin or stop relative type followMe (follow the leader keeping the same orientation to its direction).\n\                       Sending this command will stop other running followMe.
 * @param distance_is_default 0 if distance is set by user, 1 if set by current distance (in this case distance value is not used) (not used when arg start is at 0)
 * @param distance_is_default Begin or stop relative type followMe (follow the leader keeping the same orientation to its direction).\n\                       Sending this command will stop other running followMe.
 * @param distance The distance leader-follower in meter (not used when arg start is at 0)
 * @param distance Begin or stop relative type followMe (follow the leader keeping the same orientation to its direction).\n\                       Sending this command will stop other running followMe.
 * @param elevation_is_default 0 if elevation is set by user, 1 if set by current elevation (in this case elevation value is not used) (not used when arg start is at 0)
 * @param elevation_is_default Begin or stop relative type followMe (follow the leader keeping the same orientation to its direction).\n\                       Sending this command will stop other running followMe.
 * @param elevation The elevation leader-follower in rad (not used when arg start is at 0)
 * @param elevation Begin or stop relative type followMe (follow the leader keeping the same orientation to its direction).\n\                       Sending this command will stop other running followMe.
 * @param azimuth_is_default 0 if azimuth is set by user, 1 if set by current azimuth (in this case azimuth value is not used) (not used when arg start is at 0)
 * @param azimuth_is_default Begin or stop relative type followMe (follow the leader keeping the same orientation to its direction).\n\                       Sending this command will stop other running followMe.
 * @param azimuth The azimuth north-leader-follower in rad (not used when arg start is at 0)
 * @param azimuth Begin or stop relative type followMe (follow the leader keeping the same orientation to its direction).\n\                       Sending this command will stop other running followMe.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_UnknownFeature1_SendRelativeRun_t) (ARCONTROLLER_FEATURE_UnknownFeature1_t *feature, uint8_t start, uint8_t distance_is_default, float distance, uint8_t elevation_is_default, float elevation, uint8_t azimuth_is_default, float azimuth);

/**
 * @brief Send a command <code>LookAtRun</code> in feature <code>UnknownFeature1</code>
 * Begin or stop look at type followMe (stare at the leader while hovering).\n\                      Sending this command will stop other running followMe.
 * @param feature feature owning the commands
 * @param start 1 to start look at process, 0 to stop it
 * @param start Begin or stop look at type followMe (stare at the leader while hovering).\n\                      Sending this command will stop other running followMe.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_UnknownFeature1_SendLookAtRun_t) (ARCONTROLLER_FEATURE_UnknownFeature1_t *feature, uint8_t start);

/**
 * @brief Send a command <code>SpiralAnimRun</code> in feature <code>UnknownFeature1</code>
 * Begin or stop a spiral animation.\n\                      The spiral animation allows the drone to revolve around the target while going up, with a fixed radius.
 * @param feature feature owning the commands
 * @param start 1 to start the anim, 0 to stop it
 * @param start Begin or stop a spiral animation.\n\                      The spiral animation allows the drone to revolve around the target while going up, with a fixed radius.
 * @param speed_is_default 0 if speed is set by user, 1 if default speed should be used
 * @param speed_is_default Not used when start is 0
 * @param speed_is_default Begin or stop a spiral animation.\n\                      The spiral animation allows the drone to revolve around the target while going up, with a fixed radius.
 * @param speed The desired speed of the anim in m/s
 * @param speed Not used when speed_is_default is 1
 * @param speed Not used when start is 0
 * @param speed Begin or stop a spiral animation.\n\                      The spiral animation allows the drone to revolve around the target while going up, with a fixed radius.
 * @param revolution_nb_is_default 0 if the number of revolution is set by user, 1 if default revolution nb should be used
 * @param revolution_nb_is_default Not used when start is 0
 * @param revolution_nb_is_default Begin or stop a spiral animation.\n\                      The spiral animation allows the drone to revolve around the target while going up, with a fixed radius.
 * @param revolution_number The number of revolution (in turn)
 * @param revolution_number Negative value is infinite
 * @param revolution_number Example: 1.5 makes an entire turn plus half of a turn
 * @param revolution_number Not used when revolutionNb_is_default is 1
 * @param revolution_number Not used when start is 0
 * @param revolution_number Begin or stop a spiral animation.\n\                      The spiral animation allows the drone to revolve around the target while going up, with a fixed radius.
 * @param vertical_distance_is_default 0 if the vertical distance is set by user, 1 if default value should be used
 * @param vertical_distance_is_default Not used when start is 0
 * @param vertical_distance_is_default Begin or stop a spiral animation.\n\                      The spiral animation allows the drone to revolve around the target while going up, with a fixed radius.
 * @param vertical_distance Distance that should be made by the product to reach the top of the spiral in m
 * @param vertical_distance Not used when verticalDistance_is_default is 1
 * @param vertical_distance Not used when start is 0
 * @param vertical_distance Begin or stop a spiral animation.\n\                      The spiral animation allows the drone to revolve around the target while going up, with a fixed radius.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_UnknownFeature1_SendSpiralAnimRun_t) (ARCONTROLLER_FEATURE_UnknownFeature1_t *feature, uint8_t start, uint8_t speed_is_default, float speed, uint8_t revolution_nb_is_default, float revolution_number, uint8_t vertical_distance_is_default, float vertical_distance);

/**
 * @brief Send a command <code>SwingAnimRun</code> in feature <code>UnknownFeature1</code>
 * Begin or stop a swing animation.\n\                      The swing animation enables a vertical point of view while the drone passes over the target.
 * @param feature feature owning the commands
 * @param start 1 to start the anim, 0 to stop it
 * @param start Begin or stop a swing animation.\n\                      The swing animation enables a vertical point of view while the drone passes over the target.
 * @param speed_is_default 0 if speed is set by user, 1 if default speed should be used
 * @param speed_is_default Not used when start is 0
 * @param speed_is_default Begin or stop a swing animation.\n\                      The swing animation enables a vertical point of view while the drone passes over the target.
 * @param speed The desired speed of the anim in m/s
 * @param speed Not used when speed_is_default is 1
 * @param speed Not used when start is 0
 * @param speed Begin or stop a swing animation.\n\                      The swing animation enables a vertical point of view while the drone passes over the target.
 * @param vertical_distance_is_default 0 if the vertical distance is set by user, 1 if default value should be used
 * @param vertical_distance_is_default Not used when start is 0
 * @param vertical_distance_is_default Begin or stop a swing animation.\n\                      The swing animation enables a vertical point of view while the drone passes over the target.
 * @param vertical_distance Distance that should be made by the product to reach the top of the swing in m
 * @param vertical_distance Not used when verticalDistance_is_default is 1
 * @param vertical_distance Not used when start is 0
 * @param vertical_distance Begin or stop a swing animation.\n\                      The swing animation enables a vertical point of view while the drone passes over the target.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_UnknownFeature1_SendSwingAnimRun_t) (ARCONTROLLER_FEATURE_UnknownFeature1_t *feature, uint8_t start, uint8_t speed_is_default, float speed, uint8_t vertical_distance_is_default, float vertical_distance);

/**
 * @brief Send a command <code>BoomerangAnimRun</code> in feature <code>UnknownFeature1</code>
 * Begin or stop a boomerang animation.\n\                      The boomerang animation enables a zoom-out/zoom-in trajectory while preserving the framing chosen by the user.
 * @param feature feature owning the commands
 * @param start 1 to start the anim, 0 to stop it
 * @param start Begin or stop a boomerang animation.\n\                      The boomerang animation enables a zoom-out/zoom-in trajectory while preserving the framing chosen by the user.
 * @param speed_is_default 0 if speed is set by user, 1 if default speed should be used
 * @param speed_is_default Not used when start is 0
 * @param speed_is_default Begin or stop a boomerang animation.\n\                      The boomerang animation enables a zoom-out/zoom-in trajectory while preserving the framing chosen by the user.
 * @param speed The desired speed of the anim in m/s
 * @param speed Not used when speed_is_default is 1
 * @param speed Not used when start is 0
 * @param speed Begin or stop a boomerang animation.\n\                      The boomerang animation enables a zoom-out/zoom-in trajectory while preserving the framing chosen by the user.
 * @param distance_is_default 0 if the distance is set by user, 1 if default value should be used
 * @param distance_is_default Not used when start is 0
 * @param distance_is_default Begin or stop a boomerang animation.\n\                      The boomerang animation enables a zoom-out/zoom-in trajectory while preserving the framing chosen by the user.
 * @param distance Distance that should be made by the product to reach its return point in m
 * @param distance Not used when distance_is_default is 1
 * @param distance Not used when start is 0
 * @param distance Begin or stop a boomerang animation.\n\                      The boomerang animation enables a zoom-out/zoom-in trajectory while preserving the framing chosen by the user.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_UnknownFeature1_SendBoomerangAnimRun_t) (ARCONTROLLER_FEATURE_UnknownFeature1_t *feature, uint8_t start, uint8_t speed_is_default, float speed, uint8_t distance_is_default, float distance);

/**
 * @brief Send a command <code>CandleAnimRun</code> in feature <code>UnknownFeature1</code>
 * Begin or stop a candle animation.\n\                      The candle animation enables a zoom-in directly on the target followed by a vertical zoom-out.
 * @param feature feature owning the commands
 * @param start 1 to start the anim, 0 to stop it
 * @param start Begin or stop a candle animation.\n\                      The candle animation enables a zoom-in directly on the target followed by a vertical zoom-out.
 * @param speed_is_default 0 if speed is set by user, 1 if default speed should be used
 * @param speed_is_default Not used when start is 0
 * @param speed_is_default Begin or stop a candle animation.\n\                      The candle animation enables a zoom-in directly on the target followed by a vertical zoom-out.
 * @param speed The desired speed of the anim in m/s
 * @param speed Not used when speed_is_default is 1
 * @param speed Not used when start is 0
 * @param speed Begin or stop a candle animation.\n\                      The candle animation enables a zoom-in directly on the target followed by a vertical zoom-out.
 * @param vertical_distance_is_default 0 if the vertical distance is set by user, 1 if default value should be used
 * @param vertical_distance_is_default Not used when start is 0
 * @param vertical_distance_is_default Begin or stop a candle animation.\n\                      The candle animation enables a zoom-in directly on the target followed by a vertical zoom-out.
 * @param vertical_distance Distance that should be made by the product to reach the top of the vertical zoom-out in m
 * @param vertical_distance Not used when verticalDistance_is_default is 1
 * @param vertical_distance Not used when start is 0
 * @param vertical_distance Begin or stop a candle animation.\n\                      The candle animation enables a zoom-in directly on the target followed by a vertical zoom-out.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_UnknownFeature1_SendCandleAnimRun_t) (ARCONTROLLER_FEATURE_UnknownFeature1_t *feature, uint8_t start, uint8_t speed_is_default, float speed, uint8_t vertical_distance_is_default, float vertical_distance);

/**
 * @brief Send a command <code>DollySlideAnimRun</code> in feature <code>UnknownFeature1</code>
 * Begin or stop a dolly slide animation.\n\                      Allows the drone to catch up to the target before flying past it, creating a zoom-in/zoom_out effect without a curved path.
 * @param feature feature owning the commands
 * @param start 1 to start the anim, 0 to stop it
 * @param start Begin or stop a dolly slide animation.\n\                      Allows the drone to catch up to the target before flying past it, creating a zoom-in/zoom_out effect without a curved path.
 * @param speed_is_default 0 if speed is set by user, 1 if default speed should be used
 * @param speed_is_default Not used when start is 0
 * @param speed_is_default Begin or stop a dolly slide animation.\n\                      Allows the drone to catch up to the target before flying past it, creating a zoom-in/zoom_out effect without a curved path.
 * @param speed The desired speed of the anim in m/s
 * @param speed Not used when speed_is_default is 1
 * @param speed Not used when start is 0
 * @param speed Begin or stop a dolly slide animation.\n\                      Allows the drone to catch up to the target before flying past it, creating a zoom-in/zoom_out effect without a curved path.
 * @param angle_is_default 0 if the angle is set by user, 1 if default value should be used
 * @param angle_is_default Not used when start is 0
 * @param angle_is_default Begin or stop a dolly slide animation.\n\                      Allows the drone to catch up to the target before flying past it, creating a zoom-in/zoom_out effect without a curved path.
 * @param angle Desired angle Product-User-Target in rad
 * @param angle Not used when angle_is_default is 1
 * @param angle Not used when start is 0
 * @param angle Begin or stop a dolly slide animation.\n\                      Allows the drone to catch up to the target before flying past it, creating a zoom-in/zoom_out effect without a curved path.
 * @param horizontal_distance_is_default 0 if the horizontal distance is set by user, 1 if default value should be used
 * @param horizontal_distance_is_default Not used when start is 0
 * @param horizontal_distance_is_default Begin or stop a dolly slide animation.\n\                      Allows the drone to catch up to the target before flying past it, creating a zoom-in/zoom_out effect without a curved path.
 * @param horizontal_distance Distance that should be made by the product to reach its target in m
 * @param horizontal_distance Not used when horizontalDistance_is_default is 1
 * @param horizontal_distance Not used when start is 0
 * @param horizontal_distance Begin or stop a dolly slide animation.\n\                      Allows the drone to catch up to the target before flying past it, creating a zoom-in/zoom_out effect without a curved path.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_UnknownFeature1_SendDollySlideAnimRun_t) (ARCONTROLLER_FEATURE_UnknownFeature1_t *feature, uint8_t start, uint8_t speed_is_default, float speed, uint8_t angle_is_default, float angle, uint8_t horizontal_distance_is_default, float horizontal_distance);

/**
 * @brief Send a command <code>UserFramingPosition</code> in feature <code>UnknownFeature1</code>
 * User desired framing in the video.
 * @param feature feature owning the commands
 * @param horizontal Horizontal position in the video (in %, from left to right)
 * @param horizontal User desired framing in the video.
 * @param vertical Vertical position in the video (in %, from bottom to top)
 * @param vertical User desired framing in the video.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_UnknownFeature1_SendUserFramingPosition_t) (ARCONTROLLER_FEATURE_UnknownFeature1_t *feature, int8_t horizontal, int8_t vertical);

/**
 * @brief Send a command <code>UserGPSData</code> in feature <code>UnknownFeature1</code>
 * User gps data
 * @param feature feature owning the commands
 * @param latitude Latitude of the user (in deg)
 * @param longitude Longitude of the user (in deg)
 * @param altitude Altitude of the user (in meters, according to sea level)
 * @param horizontal_accuracy Horizontal accuracy (in meter)
 * @param vertical_accuracy Vertical accuracy (in meter)
 * @param north_speed North speed (in meter per second)
 * @param east_speed East speed (in meter per second)
 * @param down_speed Vertical speed (in meter per second) (down is positive)
 * @param timestamp Timestamp of the gps data
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_UnknownFeature1_SendUserGPSData_t) (ARCONTROLLER_FEATURE_UnknownFeature1_t *feature, double latitude, double longitude, float altitude, float horizontal_accuracy, float vertical_accuracy, float north_speed, float east_speed, float down_speed, double timestamp);

/**
 * @brief Send a command <code>UserBaroData</code> in feature <code>UnknownFeature1</code>
 * User barometer data
 * @param feature feature owning the commands
 * @param pressure Atmospheric pressure in hPa (millibar)
 * @param timestamp Timestamp of the barometer data
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_UnknownFeature1_SendUserBaroData_t) (ARCONTROLLER_FEATURE_UnknownFeature1_t *feature, float pressure, double timestamp);

/**
 * @brief Send a command <code>LynxDetection</code> in feature <code>UnknownFeature1</code>
 * Send vision detection results.
 * @param feature feature owning the commands
 * @param target_pan Pan angle of detected target in radian
 * @param target_pan Send vision detection results.
 * @param target_tilt Tilt angle of detected target in radian
 * @param target_tilt Send vision detection results.
 * @param change_of_scale Target's change of scale : new width = (1+ changOfScale) * old width
 * @param change_of_scale Send vision detection results.
 * @param confidence_index Confidence index of the Lynx detection (from 0 to 255, the highest is the best)
 * @param confidence_index Send vision detection results.
 * @param is_new_selection Boolean. 1 if the selection is new, 0 otherwise
 * @param is_new_selection Send vision detection results.
 * @param timestamp Acquisition time of processed picture in millisecond
 * @param timestamp Send vision detection results.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_UnknownFeature1_SendLynxDetection_t) (ARCONTROLLER_FEATURE_UnknownFeature1_t *feature, float target_pan, float target_tilt, float change_of_scale, uint8_t confidence_index, uint8_t is_new_selection, uint64_t timestamp);

/**
 * @brief Feature controller allow to send command related of unknown_feature_1 Feature.
 * UnknownFeature_1 feature
 */
struct ARCONTROLLER_FEATURE_UnknownFeature1_t
{
    ARCONTROLLER_FEATURE_UnknownFeature1_SendGeographicRun_t sendGeographicRun;
    ARCONTROLLER_FEATURE_UnknownFeature1_SendRelativeRun_t sendRelativeRun;
    ARCONTROLLER_FEATURE_UnknownFeature1_SendLookAtRun_t sendLookAtRun;
    ARCONTROLLER_FEATURE_UnknownFeature1_SendSpiralAnimRun_t sendSpiralAnimRun;
    ARCONTROLLER_FEATURE_UnknownFeature1_SendSwingAnimRun_t sendSwingAnimRun;
    ARCONTROLLER_FEATURE_UnknownFeature1_SendBoomerangAnimRun_t sendBoomerangAnimRun;
    ARCONTROLLER_FEATURE_UnknownFeature1_SendCandleAnimRun_t sendCandleAnimRun;
    ARCONTROLLER_FEATURE_UnknownFeature1_SendDollySlideAnimRun_t sendDollySlideAnimRun;
    ARCONTROLLER_FEATURE_UnknownFeature1_SendUserFramingPosition_t sendUserFramingPosition;
    ARCONTROLLER_FEATURE_UnknownFeature1_SendUserGPSData_t sendUserGPSData;
    ARCONTROLLER_FEATURE_UnknownFeature1_SendUserBaroData_t sendUserBaroData;
    ARCONTROLLER_FEATURE_UnknownFeature1_SendLynxDetection_t sendLynxDetection;
    ARCONTROLLER_FEATURE_UnknownFeature1_Private_t *privatePart; /**< Private part of ARCONTROLLER_FEATURE_UnknownFeature1_t */
};

/**
 * @brief Set a NetworkController to use to send commands.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] networkController The networkController used to send commands ; must be not NULL.
 * @return error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_UnknownFeature1_SetNetworkController (ARCONTROLLER_FEATURE_UnknownFeature1_t *feature, ARCONTROLLER_Network_t *networkController);

/**
 * @brief Get the elements of a command received.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command.
 * @param[out] error executing error.
 * @return Element dictionary of the command ; Can be null if an error is occurred.
 */
ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_UnknownFeature1_GetCommandElements (ARCONTROLLER_FEATURE_UnknownFeature1_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, eARCONTROLLER_ERROR *error);

/*******************************
 * --- FEATURE common --- 
 ******************************/

/**
 * @brief Private part of ARCONTROLLER_FEATURE_Common_t.
 */
typedef struct ARCONTROLLER_FEATURE_Common_Private_t ARCONTROLLER_FEATURE_Common_Private_t;

/**
 * @brief Feature controller allow to send command related of common Feature.
 * All common commands shared between all projects
 */
typedef struct ARCONTROLLER_FEATURE_Common_t ARCONTROLLER_FEATURE_Common_t;

/**
 * @brief Create a new common Feature Controller
 * @warning This function allocate memory
 * @post ARCONTROLLER_FEATURE_Common_Delete() must be called to delete the Feature Controller and free the memory allocated.
 * @param[in] networkController The networkController used to send commands ; can be NULL and defind later with ARCONTROLLER_FEATURE_Common_SetNetworkController().
 * @param[out] error executing error.
 * @return the new common Feature Controller
 * @see ARCONTROLLER_FEATURE_Common_Delete
 */
ARCONTROLLER_FEATURE_Common_t *ARCONTROLLER_FEATURE_Common_New (ARCONTROLLER_Network_t *networkController, eARCONTROLLER_ERROR *error);

/**
 * @brief Delete the common Feature Controller
 * @warning This function free memory
 * @param feature The feature controller to delete
 * @see ARCONTROLLER_FEATURE_Common_New
 */
void ARCONTROLLER_FEATURE_Common_Delete (ARCONTROLLER_FEATURE_Common_t **feature);

/**
 * @brief Get the dictionay of the common Feature Controller
 * @param feature The feature controller owning the dictionary to get
 * @param[out] error executing error.
 */
ARCONTROLLER_DICTIONARY_COMMANDS_t *ARCONTROLLER_FEATURE_Common_GetDictionary (ARCONTROLLER_FEATURE_Common_t *feature, eARCONTROLLER_ERROR *error);

/**
 * @brief Add a callback to use when a command in project <code>Common</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] callback the callback to add.
 * @param[in] commandKey Key of the command which the callback must be associated.
 * @param[out] error executing error.
 * @param[int] customData custom data given as parameter to the callback.
 * @see ARCONTROLLER_FEATURE_Common_RemoveCallback.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_Common_AddCallback (ARCONTROLLER_FEATURE_Common_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

/**
 * @brief Remove a callback used when a command in project <code>Common</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] callback the callback to remove.
 * @param[int] customData The custom data given to the register.
 * @param[out] error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_Common_RemoveCallback (ARCONTROLLER_FEATURE_Common_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_NETWORKEVENT_DISCONNECTION_CAUSE; /**< Key of the argument </code>cause</code> of event <code>NetworkEventDisconnection</code> in feature <code>Common</code> */



extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_PRODUCTNAMECHANGED_NAME; /**< Key of the argument </code>name</code> of event <code>SettingsStateProductNameChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_PRODUCTVERSIONCHANGED_SOFTWARE; /**< Key of the argument </code>software</code> of event <code>SettingsStateProductVersionChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_PRODUCTVERSIONCHANGED_HARDWARE; /**< Key of the argument </code>hardware</code> of event <code>SettingsStateProductVersionChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_PRODUCTSERIALHIGHCHANGED_HIGH; /**< Key of the argument </code>high</code> of event <code>SettingsStateProductSerialHighChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_PRODUCTSERIALLOWCHANGED_LOW; /**< Key of the argument </code>low</code> of event <code>SettingsStateProductSerialLowChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_COUNTRYCHANGED_CODE; /**< Key of the argument </code>code</code> of event <code>SettingsStateCountryChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_SETTINGSSTATE_AUTOCOUNTRYCHANGED_AUTOMATIC; /**< Key of the argument </code>automatic</code> of event <code>SettingsStateAutoCountryChanged</code> in feature <code>Common</code> */


extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_BATTERYSTATECHANGED_PERCENT; /**< Key of the argument </code>percent</code> of event <code>CommonStateBatteryStateChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGESTATELISTCHANGED_MASS_STORAGE_ID; /**< Key of the argument </code>mass_storage_id</code> of event <code>CommonStateMassStorageStateListChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGESTATELISTCHANGED_NAME; /**< Key of the argument </code>name</code> of event <code>CommonStateMassStorageStateListChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGEINFOSTATELISTCHANGED_MASS_STORAGE_ID; /**< Key of the argument </code>mass_storage_id</code> of event <code>CommonStateMassStorageInfoStateListChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGEINFOSTATELISTCHANGED_SIZE; /**< Key of the argument </code>size</code> of event <code>CommonStateMassStorageInfoStateListChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGEINFOSTATELISTCHANGED_USED_SIZE; /**< Key of the argument </code>used_size</code> of event <code>CommonStateMassStorageInfoStateListChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGEINFOSTATELISTCHANGED_PLUGGED; /**< Key of the argument </code>plugged</code> of event <code>CommonStateMassStorageInfoStateListChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGEINFOSTATELISTCHANGED_FULL; /**< Key of the argument </code>full</code> of event <code>CommonStateMassStorageInfoStateListChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGEINFOSTATELISTCHANGED_INTERNAL; /**< Key of the argument </code>internal</code> of event <code>CommonStateMassStorageInfoStateListChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_CURRENTDATECHANGED_DATE; /**< Key of the argument </code>date</code> of event <code>CommonStateCurrentDateChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_CURRENTTIMECHANGED_TIME; /**< Key of the argument </code>time</code> of event <code>CommonStateCurrentTimeChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGEINFOREMAININGLISTCHANGED_FREE_SPACE; /**< Key of the argument </code>free_space</code> of event <code>CommonStateMassStorageInfoRemainingListChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGEINFOREMAININGLISTCHANGED_REC_TIME; /**< Key of the argument </code>rec_time</code> of event <code>CommonStateMassStorageInfoRemainingListChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_MASSSTORAGEINFOREMAININGLISTCHANGED_PHOTO_REMAINING; /**< Key of the argument </code>photo_remaining</code> of event <code>CommonStateMassStorageInfoRemainingListChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_WIFISIGNALCHANGED_RSSI; /**< Key of the argument </code>rssi</code> of event <code>CommonStateWifiSignalChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME; /**< Key of the argument </code>sensorName</code> of event <code>CommonStateSensorsStatesListChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORSTATE; /**< Key of the argument </code>sensorState</code> of event <code>CommonStateSensorsStatesListChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL; /**< Key of the argument </code>model</code> of event <code>CommonStateProductModel</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_COUNTRYLISTKNOWN_LISTFLAGS; /**< Key of the argument </code>listFlags</code> of event <code>CommonStateCountryListKnown</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_COMMONSTATE_COUNTRYLISTKNOWN_COUNTRYCODES; /**< Key of the argument </code>countryCodes</code> of event <code>CommonStateCountryListKnown</code> in feature <code>Common</code> */


extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_OVERHEATSTATE_OVERHEATREGULATIONCHANGED_REGULATIONTYPE; /**< Key of the argument </code>regulationType</code> of event <code>OverHeatStateOverHeatRegulationChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_WIFISETTINGSSTATE_OUTDOORSETTINGSCHANGED_OUTDOOR; /**< Key of the argument </code>outdoor</code> of event <code>WifiSettingsStateOutdoorSettingsChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_STATE; /**< Key of the argument </code>state</code> of event <code>MavlinkStateMavlinkFilePlayingStateChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_FILEPATH; /**< Key of the argument </code>filepath</code> of event <code>MavlinkStateMavlinkFilePlayingStateChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_TYPE; /**< Key of the argument </code>type</code> of event <code>MavlinkStateMavlinkFilePlayingStateChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED_ERROR; /**< Key of the argument </code>error</code> of event <code>MavlinkStateMavlinkPlayErrorStateChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATECHANGED_XAXISCALIBRATION; /**< Key of the argument </code>xAxisCalibration</code> of event <code>CalibrationStateMagnetoCalibrationStateChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATECHANGED_YAXISCALIBRATION; /**< Key of the argument </code>yAxisCalibration</code> of event <code>CalibrationStateMagnetoCalibrationStateChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATECHANGED_ZAXISCALIBRATION; /**< Key of the argument </code>zAxisCalibration</code> of event <code>CalibrationStateMagnetoCalibrationStateChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATECHANGED_CALIBRATIONFAILED; /**< Key of the argument </code>calibrationFailed</code> of event <code>CalibrationStateMagnetoCalibrationStateChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONREQUIREDSTATE_REQUIRED; /**< Key of the argument </code>required</code> of event <code>CalibrationStateMagnetoCalibrationRequiredState</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED_AXIS; /**< Key of the argument </code>axis</code> of event <code>CalibrationStateMagnetoCalibrationAxisToCalibrateChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTARTEDCHANGED_STARTED; /**< Key of the argument </code>started</code> of event <code>CalibrationStateMagnetoCalibrationStartedChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CAMERASETTINGSSTATE_CAMERASETTINGSCHANGED_FOV; /**< Key of the argument </code>fov</code> of event <code>CameraSettingsStateCameraSettingsChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CAMERASETTINGSSTATE_CAMERASETTINGSCHANGED_PANMAX; /**< Key of the argument </code>panMax</code> of event <code>CameraSettingsStateCameraSettingsChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CAMERASETTINGSSTATE_CAMERASETTINGSCHANGED_PANMIN; /**< Key of the argument </code>panMin</code> of event <code>CameraSettingsStateCameraSettingsChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CAMERASETTINGSSTATE_CAMERASETTINGSCHANGED_TILTMAX; /**< Key of the argument </code>tiltMax</code> of event <code>CameraSettingsStateCameraSettingsChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CAMERASETTINGSSTATE_CAMERASETTINGSCHANGED_TILTMIN; /**< Key of the argument </code>tiltMin</code> of event <code>CameraSettingsStateCameraSettingsChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_FLIGHTPLANSTATE_AVAILABILITYSTATECHANGED_AVAILABILITYSTATE; /**< Key of the argument </code>AvailabilityState</code> of event <code>FlightPlanStateAvailabilityStateChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED_COMPONENT; /**< Key of the argument </code>component</code> of event <code>FlightPlanStateComponentStateListChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED_STATE; /**< Key of the argument </code>State</code> of event <code>FlightPlanStateComponentStateListChanged</code> in feature <code>Common</code> */



extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_ARLIBSVERSIONSSTATE_CONTROLLERLIBARCOMMANDSVERSION_VERSION; /**< Key of the argument </code>version</code> of event <code>ARLibsVersionsStateControllerLibARCommandsVersion</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_ARLIBSVERSIONSSTATE_SKYCONTROLLERLIBARCOMMANDSVERSION_VERSION; /**< Key of the argument </code>version</code> of event <code>ARLibsVersionsStateSkyControllerLibARCommandsVersion</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_ARLIBSVERSIONSSTATE_DEVICELIBARCOMMANDSVERSION_VERSION; /**< Key of the argument </code>version</code> of event <code>ARLibsVersionsStateDeviceLibARCommandsVersion</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_AUDIOSTATE_AUDIOSTREAMINGRUNNING_RUNNING; /**< Key of the argument </code>running</code> of event <code>AudioStateAudioStreamingRunning</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_HEADLIGHTSSTATE_INTENSITYCHANGED_LEFT; /**< Key of the argument </code>left</code> of event <code>HeadlightsStateIntensityChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_HEADLIGHTSSTATE_INTENSITYCHANGED_RIGHT; /**< Key of the argument </code>right</code> of event <code>HeadlightsStateIntensityChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_ANIMATIONSSTATE_LIST_ANIM; /**< Key of the argument </code>anim</code> of event <code>AnimationsStateList</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_ANIMATIONSSTATE_LIST_STATE; /**< Key of the argument </code>state</code> of event <code>AnimationsStateList</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_ANIMATIONSSTATE_LIST_ERROR; /**< Key of the argument </code>error</code> of event <code>AnimationsStateList</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED_ACCESSORY; /**< Key of the argument </code>accessory</code> of event <code>AccessoryStateSupportedAccessoriesListChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_NEWACCESSORY; /**< Key of the argument </code>newAccessory</code> of event <code>AccessoryStateAccessoryConfigChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_ERROR; /**< Key of the argument </code>error</code> of event <code>AccessoryStateAccessoryConfigChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGMODIFICATIONENABLED_ENABLED; /**< Key of the argument </code>enabled</code> of event <code>AccessoryStateAccessoryConfigModificationEnabled</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_MAXCHARGERATECHANGED_RATE; /**< Key of the argument </code>rate</code> of event <code>ChargerStateMaxChargeRateChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_STATUS; /**< Key of the argument </code>status</code> of event <code>ChargerStateCurrentChargeStateChanged</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_PHASE; /**< Key of the argument </code>phase</code> of event <code>ChargerStateCurrentChargeStateChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_LASTCHARGERATECHANGED_RATE; /**< Key of the argument </code>rate</code> of event <code>ChargerStateLastChargeRateChanged</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_CHARGINGINFO_PHASE; /**< Key of the argument </code>phase</code> of event <code>ChargerStateChargingInfo</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_CHARGINGINFO_RATE; /**< Key of the argument </code>rate</code> of event <code>ChargerStateChargingInfo</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_CHARGINGINFO_INTENSITY; /**< Key of the argument </code>intensity</code> of event <code>ChargerStateChargingInfo</code> in feature <code>Common</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_CHARGERSTATE_CHARGINGINFO_FULLCHARGINGTIME; /**< Key of the argument </code>fullChargingTime</code> of event <code>ChargerStateChargingInfo</code> in feature <code>Common</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMON_RUNSTATE_RUNIDCHANGED_RUNID; /**< Key of the argument </code>runId</code> of event <code>RunStateRunIdChanged</code> in feature <code>Common</code> */

/**
 * @brief Send a command <code>NetworkDisconnect</code> in feature <code>Common</code>
 * @deprecated
 * Signals the remote that the host will disconnect and close its
 * libARNetwork instance (and all threads that use libARNetwork)
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendNetworkDisconnect_t) (ARCONTROLLER_FEATURE_Common_t *feature);

/**
 * @brief Send a command <code>SettingsAllSettings</code> in feature <code>Common</code>
 * Get all product settings, the product must send all settings
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendSettingsAllSettings_t) (ARCONTROLLER_FEATURE_Common_t *feature);

/**
 * @brief Send a command <code>SettingsReset</code> in feature <code>Common</code>
 * Reset all settings
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendSettingsReset_t) (ARCONTROLLER_FEATURE_Common_t *feature);

/**
 * @brief Send a command <code>SettingsProductName</code> in feature <code>Common</code>
 * Set Product name
 * @param feature feature owning the commands
 * @param name Product name
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendSettingsProductName_t) (ARCONTROLLER_FEATURE_Common_t *feature, char * name);

/**
 * @brief Send a command <code>SettingsCountry</code> in feature <code>Common</code>
 * Set current Country of controller
 * @param feature feature owning the commands
 * @param code Country code with ISO 3166 format
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendSettingsCountry_t) (ARCONTROLLER_FEATURE_Common_t *feature, char * code);

/**
 * @brief Send a command <code>SettingsAutoCountry</code> in feature <code>Common</code>
 * Set Auto Country Settings
 * @param feature feature owning the commands
 * @param automatic Boolean : 0 : Manual / 1 : Auto
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendSettingsAutoCountry_t) (ARCONTROLLER_FEATURE_Common_t *feature, uint8_t automatic);

/**
 * @brief Send a command <code>CommonAllStates</code> in feature <code>Common</code>
 * Get all product states.
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendCommonAllStates_t) (ARCONTROLLER_FEATURE_Common_t *feature);

/**
 * @brief Send a command <code>CommonCurrentDate</code> in feature <code>Common</code>
 * Set current date of controller
 * @param feature feature owning the commands
 * @param date Date with ISO-8601 format
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendCommonCurrentDate_t) (ARCONTROLLER_FEATURE_Common_t *feature, char * date);

/**
 * @brief Send a command <code>CommonCurrentTime</code> in feature <code>Common</code>
 * Set current time of controller
 * @param feature feature owning the commands
 * @param time Time with ISO-8601 format
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendCommonCurrentTime_t) (ARCONTROLLER_FEATURE_Common_t *feature, char * time);

/**
 * @brief Send a command <code>CommonReboot</code> in feature <code>Common</code>
 * Command to ask reboot to product
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendCommonReboot_t) (ARCONTROLLER_FEATURE_Common_t *feature);

/**
 * @brief Send a command <code>OverHeatSwitchOff</code> in feature <code>Common</code>
 * @deprecated
 * Switch off the drone when a overheat appeared
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendOverHeatSwitchOff_t) (ARCONTROLLER_FEATURE_Common_t *feature);

/**
 * @brief Send a command <code>OverHeatVentilate</code> in feature <code>Common</code>
 * @deprecated
 * Ventilate the drone when a overheat appeared
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendOverHeatVentilate_t) (ARCONTROLLER_FEATURE_Common_t *feature);

/**
 * @brief Send a command <code>ControllerIsPiloting</code> in feature <code>Common</code>
 * Tell the device when the controller application enters/leaves the piloting HUD.
 * @param feature feature owning the commands
 * @param piloting 0 when the application is not in the piloting HUD, 1 when it enters the HUD.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendControllerIsPiloting_t) (ARCONTROLLER_FEATURE_Common_t *feature, uint8_t piloting);

/**
 * @brief Send a command <code>WifiSettingsOutdoorSetting</code> in feature <code>Common</code>
 * Send to product if it should use its outdoor wifi config, or indoor
 * @param feature feature owning the commands
 * @param outdoor 1 if it should use outdoor wifi settings, 0 otherwise
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendWifiSettingsOutdoorSetting_t) (ARCONTROLLER_FEATURE_Common_t *feature, uint8_t outdoor);

/**
 * @brief Send a command <code>MavlinkStart</code> in feature <code>Common</code>
 * Start the flight plan
 * @param feature feature owning the commands
 * @param filepath flight plan file path from the mavlink ftp root
 * @param type type of the played mavlink file
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendMavlinkStart_t) (ARCONTROLLER_FEATURE_Common_t *feature, char * filepath, eARCOMMANDS_COMMON_MAVLINK_START_TYPE type);

/**
 * @brief Send a command <code>MavlinkPause</code> in feature <code>Common</code>
 * Pause the flightplan (can be restarted with a start)
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendMavlinkPause_t) (ARCONTROLLER_FEATURE_Common_t *feature);

/**
 * @brief Send a command <code>MavlinkStop</code> in feature <code>Common</code>
 * Stop the flightplan
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendMavlinkStop_t) (ARCONTROLLER_FEATURE_Common_t *feature);

/**
 * @brief Send a command <code>CalibrationMagnetoCalibration</code> in feature <code>Common</code>
 * Sent when a calibration of the magnetometer is asked or is aborted
 * @param feature feature owning the commands
 * @param calibrate 1 if the calibration should be started, 0 if it should be aborted
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendCalibrationMagnetoCalibration_t) (ARCONTROLLER_FEATURE_Common_t *feature, uint8_t calibrate);

/**
 * @brief Send a command <code>GPSControllerPositionForRun</code> in feature <code>Common</code>
 * Set the controller position for a run. This command is used by all non gps products. Watch out, this command cannot be used with BLE products
 * @param feature feature owning the commands
 * @param latitude Controller latitude in decimal degrees
 * @param longitude Controller longitude in decimal degrees
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendGPSControllerPositionForRun_t) (ARCONTROLLER_FEATURE_Common_t *feature, double latitude, double longitude);

/**
 * @brief Send a command <code>AudioControllerReadyForStreaming</code> in feature <code>Common</code>
 * Tell the firmware whether the controller is ready to start audio streaming.
 * @param feature feature owning the commands
 * @param ready Bit field for TX and RX ready.
 * @param ready bit 0 is 1 if controller is ready and wants to receive sound (Drone TX)
 * @param ready bit 1 is 1 if controller is ready and wants to send sound (Drone RX)
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendAudioControllerReadyForStreaming_t) (ARCONTROLLER_FEATURE_Common_t *feature, uint8_t ready);

/**
 * @brief Send a command <code>HeadlightsIntensity</code> in feature <code>Common</code>
 * Set instensity of lighting LEDs.
 * @param feature feature owning the commands
 * @param left Set the left LED intensity value (0 through 255).
 * @param right Set the right LED intensity value (0 through 255).
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendHeadlightsIntensity_t) (ARCONTROLLER_FEATURE_Common_t *feature, uint8_t left, uint8_t right);

/**
 * @brief Send a command <code>AnimationsStartAnimation</code> in feature <code>Common</code>
 * Start a paramaterless animation.
 * @param feature feature owning the commands
 * @param anim Animation to start.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendAnimationsStartAnimation_t) (ARCONTROLLER_FEATURE_Common_t *feature, eARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM anim);

/**
 * @brief Send a command <code>AnimationsStopAnimation</code> in feature <code>Common</code>
 * Stop a running animation.
 * @param feature feature owning the commands
 * @param anim Animation to stop.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendAnimationsStopAnimation_t) (ARCONTROLLER_FEATURE_Common_t *feature, eARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM anim);

/**
 * @brief Send a command <code>AnimationsStopAllAnimations</code> in feature <code>Common</code>
 * Stop all running animations.
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendAnimationsStopAllAnimations_t) (ARCONTROLLER_FEATURE_Common_t *feature);

/**
 * @brief Send a command <code>AccessoryConfig</code> in feature <code>Common</code>
 * Set the current accessory configuration.
 * @param feature feature owning the commands
 * @param accessory Accessory configuration to set.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendAccessoryConfig_t) (ARCONTROLLER_FEATURE_Common_t *feature, eARCOMMANDS_COMMON_ACCESSORY_CONFIG_ACCESSORY accessory);

/**
 * @brief Send a command <code>ChargerSetMaxChargeRate</code> in feature <code>Common</code>
 * @deprecated
 * Set the maximum charge rate allowed to charge a battery.
 * @param feature feature owning the commands
 * @param rate The new maximum charge rate.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Common_SendChargerSetMaxChargeRate_t) (ARCONTROLLER_FEATURE_Common_t *feature, eARCOMMANDS_COMMON_CHARGER_SETMAXCHARGERATE_RATE rate);

/**
 * @brief Feature controller allow to send command related of common Feature.
 * All common commands shared between all projects
 */
struct ARCONTROLLER_FEATURE_Common_t
{
    ARCONTROLLER_FEATURE_Common_SendNetworkDisconnect_t sendNetworkDisconnect;
    ARCONTROLLER_FEATURE_Common_SendSettingsAllSettings_t sendSettingsAllSettings;
    ARCONTROLLER_FEATURE_Common_SendSettingsReset_t sendSettingsReset;
    ARCONTROLLER_FEATURE_Common_SendSettingsProductName_t sendSettingsProductName;
    ARCONTROLLER_FEATURE_Common_SendSettingsCountry_t sendSettingsCountry;
    ARCONTROLLER_FEATURE_Common_SendSettingsAutoCountry_t sendSettingsAutoCountry;
    ARCONTROLLER_FEATURE_Common_SendCommonAllStates_t sendCommonAllStates;
    ARCONTROLLER_FEATURE_Common_SendCommonCurrentDate_t sendCommonCurrentDate;
    ARCONTROLLER_FEATURE_Common_SendCommonCurrentTime_t sendCommonCurrentTime;
    ARCONTROLLER_FEATURE_Common_SendCommonReboot_t sendCommonReboot;
    ARCONTROLLER_FEATURE_Common_SendOverHeatSwitchOff_t sendOverHeatSwitchOff;
    ARCONTROLLER_FEATURE_Common_SendOverHeatVentilate_t sendOverHeatVentilate;
    ARCONTROLLER_FEATURE_Common_SendControllerIsPiloting_t sendControllerIsPiloting;
    ARCONTROLLER_FEATURE_Common_SendWifiSettingsOutdoorSetting_t sendWifiSettingsOutdoorSetting;
    ARCONTROLLER_FEATURE_Common_SendMavlinkStart_t sendMavlinkStart;
    ARCONTROLLER_FEATURE_Common_SendMavlinkPause_t sendMavlinkPause;
    ARCONTROLLER_FEATURE_Common_SendMavlinkStop_t sendMavlinkStop;
    ARCONTROLLER_FEATURE_Common_SendCalibrationMagnetoCalibration_t sendCalibrationMagnetoCalibration;
    ARCONTROLLER_FEATURE_Common_SendGPSControllerPositionForRun_t sendGPSControllerPositionForRun;
    ARCONTROLLER_FEATURE_Common_SendAudioControllerReadyForStreaming_t sendAudioControllerReadyForStreaming;
    ARCONTROLLER_FEATURE_Common_SendHeadlightsIntensity_t sendHeadlightsIntensity;
    ARCONTROLLER_FEATURE_Common_SendAnimationsStartAnimation_t sendAnimationsStartAnimation;
    ARCONTROLLER_FEATURE_Common_SendAnimationsStopAnimation_t sendAnimationsStopAnimation;
    ARCONTROLLER_FEATURE_Common_SendAnimationsStopAllAnimations_t sendAnimationsStopAllAnimations;
    ARCONTROLLER_FEATURE_Common_SendAccessoryConfig_t sendAccessoryConfig;
    ARCONTROLLER_FEATURE_Common_SendChargerSetMaxChargeRate_t sendChargerSetMaxChargeRate;
    ARCONTROLLER_FEATURE_Common_Private_t *privatePart; /**< Private part of ARCONTROLLER_FEATURE_Common_t */
};

/**
 * @brief Set a NetworkController to use to send commands.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] networkController The networkController used to send commands ; must be not NULL.
 * @return error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_Common_SetNetworkController (ARCONTROLLER_FEATURE_Common_t *feature, ARCONTROLLER_Network_t *networkController);

/**
 * @brief Get the elements of a command received.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command.
 * @param[out] error executing error.
 * @return Element dictionary of the command ; Can be null if an error is occurred.
 */
ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_Common_GetCommandElements (ARCONTROLLER_FEATURE_Common_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, eARCONTROLLER_ERROR *error);

/*******************************
 * --- FEATURE commonDebug --- 
 ******************************/

/**
 * @brief Private part of ARCONTROLLER_FEATURE_CommonDebug_t.
 */
typedef struct ARCONTROLLER_FEATURE_CommonDebug_Private_t ARCONTROLLER_FEATURE_CommonDebug_Private_t;

/**
 * @brief Feature controller allow to send command related of commonDebug Feature.
 * All debug commands shared between all projects
 */
typedef struct ARCONTROLLER_FEATURE_CommonDebug_t ARCONTROLLER_FEATURE_CommonDebug_t;

/**
 * @brief Create a new commonDebug Feature Controller
 * @warning This function allocate memory
 * @post ARCONTROLLER_FEATURE_CommonDebug_Delete() must be called to delete the Feature Controller and free the memory allocated.
 * @param[in] networkController The networkController used to send commands ; can be NULL and defind later with ARCONTROLLER_FEATURE_CommonDebug_SetNetworkController().
 * @param[out] error executing error.
 * @return the new commonDebug Feature Controller
 * @see ARCONTROLLER_FEATURE_CommonDebug_Delete
 */
ARCONTROLLER_FEATURE_CommonDebug_t *ARCONTROLLER_FEATURE_CommonDebug_New (ARCONTROLLER_Network_t *networkController, eARCONTROLLER_ERROR *error);

/**
 * @brief Delete the commonDebug Feature Controller
 * @warning This function free memory
 * @param feature The feature controller to delete
 * @see ARCONTROLLER_FEATURE_CommonDebug_New
 */
void ARCONTROLLER_FEATURE_CommonDebug_Delete (ARCONTROLLER_FEATURE_CommonDebug_t **feature);

/**
 * @brief Get the dictionay of the commonDebug Feature Controller
 * @param feature The feature controller owning the dictionary to get
 * @param[out] error executing error.
 */
ARCONTROLLER_DICTIONARY_COMMANDS_t *ARCONTROLLER_FEATURE_CommonDebug_GetDictionary (ARCONTROLLER_FEATURE_CommonDebug_t *feature, eARCONTROLLER_ERROR *error);

/**
 * @brief Add a callback to use when a command in project <code>CommonDebug</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] callback the callback to add.
 * @param[in] commandKey Key of the command which the callback must be associated.
 * @param[out] error executing error.
 * @param[int] customData custom data given as parameter to the callback.
 * @see ARCONTROLLER_FEATURE_CommonDebug_RemoveCallback.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_CommonDebug_AddCallback (ARCONTROLLER_FEATURE_CommonDebug_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

/**
 * @brief Remove a callback used when a command in project <code>CommonDebug</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] callback the callback to remove.
 * @param[int] customData The custom data given to the register.
 * @param[out] error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_CommonDebug_RemoveCallback (ARCONTROLLER_FEATURE_CommonDebug_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_STATSEVENT_SENDPACKET_PACKET; /**< Key of the argument </code>packet</code> of event <code>StatsEventSendPacket</code> in feature <code>CommonDebug</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_LISTFLAGS; /**< Key of the argument </code>listFlags</code> of event <code>DebugSettingsStateInfo</code> in feature <code>CommonDebug</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_ID; /**< Key of the argument </code>id</code> of event <code>DebugSettingsStateInfo</code> in feature <code>CommonDebug</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_LABEL; /**< Key of the argument </code>label</code> of event <code>DebugSettingsStateInfo</code> in feature <code>CommonDebug</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_TYPE; /**< Key of the argument </code>type</code> of event <code>DebugSettingsStateInfo</code> in feature <code>CommonDebug</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_MODE; /**< Key of the argument </code>mode</code> of event <code>DebugSettingsStateInfo</code> in feature <code>CommonDebug</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_RANGE_MIN; /**< Key of the argument </code>range_min</code> of event <code>DebugSettingsStateInfo</code> in feature <code>CommonDebug</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_RANGE_MAX; /**< Key of the argument </code>range_max</code> of event <code>DebugSettingsStateInfo</code> in feature <code>CommonDebug</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_RANGE_STEP; /**< Key of the argument </code>range_step</code> of event <code>DebugSettingsStateInfo</code> in feature <code>CommonDebug</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_VALUE; /**< Key of the argument </code>value</code> of event <code>DebugSettingsStateInfo</code> in feature <code>CommonDebug</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_DEBUGSETTINGSSTATE_LISTCHANGED_ID; /**< Key of the argument </code>id</code> of event <code>DebugSettingsStateListChanged</code> in feature <code>CommonDebug</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_COMMONDEBUG_DEBUGSETTINGSSTATE_LISTCHANGED_VALUE; /**< Key of the argument </code>value</code> of event <code>DebugSettingsStateListChanged</code> in feature <code>CommonDebug</code> */

/**
 * @brief Send a command <code>StatsSendPacket</code> in feature <code>CommonDebug</code>
 * Send a packet to the drone
 * @param feature feature owning the commands
 * @param packet Packet to send to the drone
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_CommonDebug_SendStatsSendPacket_t) (ARCONTROLLER_FEATURE_CommonDebug_t *feature, char * packet);

/**
 * @brief Send a command <code>StatsStartSendingPacketFromDrone</code> in feature <code>CommonDebug</code>
 * Ask drone to start sending packets
 * @param feature feature owning the commands
 * @param frequency Frequency of the packet
 * @param packetSize Size of the the packet
 * @param date time of day in sec
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_CommonDebug_SendStatsStartSendingPacketFromDrone_t) (ARCONTROLLER_FEATURE_CommonDebug_t *feature, uint8_t frequency, uint8_t packetSize, uint32_t date);

/**
 * @brief Send a command <code>StatsStopSendingPacketFromDrone</code> in feature <code>CommonDebug</code>
 * Ask drone to stop sending packets
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_CommonDebug_SendStatsStopSendingPacketFromDrone_t) (ARCONTROLLER_FEATURE_CommonDebug_t *feature);

/**
 * @brief Send a command <code>DebugSettingsGetAll</code> in feature <code>CommonDebug</code>
 * Cmd sent by controller to get all settings info (generate "SettingInfo" events).
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_CommonDebug_SendDebugSettingsGetAll_t) (ARCONTROLLER_FEATURE_CommonDebug_t *feature);

/**
 * @brief Send a command <code>DebugSettingsSet</code> in feature <code>CommonDebug</code>
 * Change setting value.
 * Cmd sent by controller to change a writable setting.
 * @param feature feature owning the commands
 * @param id Setting Id.
 * @param value New setting value (string encoded).
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_CommonDebug_SendDebugSettingsSet_t) (ARCONTROLLER_FEATURE_CommonDebug_t *feature, uint16_t id, char * value);

/**
 * @brief Feature controller allow to send command related of commonDebug Feature.
 * All debug commands shared between all projects
 */
struct ARCONTROLLER_FEATURE_CommonDebug_t
{
    ARCONTROLLER_FEATURE_CommonDebug_SendStatsSendPacket_t sendStatsSendPacket;
    ARCONTROLLER_FEATURE_CommonDebug_SendStatsStartSendingPacketFromDrone_t sendStatsStartSendingPacketFromDrone;
    ARCONTROLLER_FEATURE_CommonDebug_SendStatsStopSendingPacketFromDrone_t sendStatsStopSendingPacketFromDrone;
    ARCONTROLLER_FEATURE_CommonDebug_SendDebugSettingsGetAll_t sendDebugSettingsGetAll;
    ARCONTROLLER_FEATURE_CommonDebug_SendDebugSettingsSet_t sendDebugSettingsSet;
    ARCONTROLLER_FEATURE_CommonDebug_Private_t *privatePart; /**< Private part of ARCONTROLLER_FEATURE_CommonDebug_t */
};

/**
 * @brief Set a NetworkController to use to send commands.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] networkController The networkController used to send commands ; must be not NULL.
 * @return error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_CommonDebug_SetNetworkController (ARCONTROLLER_FEATURE_CommonDebug_t *feature, ARCONTROLLER_Network_t *networkController);

/**
 * @brief Get the elements of a command received.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command.
 * @param[out] error executing error.
 * @return Element dictionary of the command ; Can be null if an error is occurred.
 */
ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_CommonDebug_GetCommandElements (ARCONTROLLER_FEATURE_CommonDebug_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, eARCONTROLLER_ERROR *error);

/*******************************
 * --- FEATURE pro --- 
 ******************************/

/**
 * @brief Private part of ARCONTROLLER_FEATURE_Pro_t.
 */
typedef struct ARCONTROLLER_FEATURE_Pro_Private_t ARCONTROLLER_FEATURE_Pro_Private_t;

/**
 * @brief Feature controller allow to send command related of pro Feature.
 * Pro Feature
 */
typedef struct ARCONTROLLER_FEATURE_Pro_t ARCONTROLLER_FEATURE_Pro_t;

/**
 * @brief Create a new pro Feature Controller
 * @warning This function allocate memory
 * @post ARCONTROLLER_FEATURE_Pro_Delete() must be called to delete the Feature Controller and free the memory allocated.
 * @param[in] networkController The networkController used to send commands ; can be NULL and defind later with ARCONTROLLER_FEATURE_Pro_SetNetworkController().
 * @param[out] error executing error.
 * @return the new pro Feature Controller
 * @see ARCONTROLLER_FEATURE_Pro_Delete
 */
ARCONTROLLER_FEATURE_Pro_t *ARCONTROLLER_FEATURE_Pro_New (ARCONTROLLER_Network_t *networkController, eARCONTROLLER_ERROR *error);

/**
 * @brief Delete the pro Feature Controller
 * @warning This function free memory
 * @param feature The feature controller to delete
 * @see ARCONTROLLER_FEATURE_Pro_New
 */
void ARCONTROLLER_FEATURE_Pro_Delete (ARCONTROLLER_FEATURE_Pro_t **feature);

/**
 * @brief Get the dictionay of the pro Feature Controller
 * @param feature The feature controller owning the dictionary to get
 * @param[out] error executing error.
 */
ARCONTROLLER_DICTIONARY_COMMANDS_t *ARCONTROLLER_FEATURE_Pro_GetDictionary (ARCONTROLLER_FEATURE_Pro_t *feature, eARCONTROLLER_ERROR *error);

/**
 * @brief Add a callback to use when a command in project <code>Pro</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] callback the callback to add.
 * @param[in] commandKey Key of the command which the callback must be associated.
 * @param[out] error executing error.
 * @param[int] customData custom data given as parameter to the callback.
 * @see ARCONTROLLER_FEATURE_Pro_RemoveCallback.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_Pro_AddCallback (ARCONTROLLER_FEATURE_Pro_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

/**
 * @brief Remove a callback used when a command in project <code>Pro</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] callback the callback to remove.
 * @param[int] customData The custom data given to the register.
 * @param[out] error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_Pro_RemoveCallback (ARCONTROLLER_FEATURE_Pro_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

extern const char *ARCONTROLLER_DICTIONARY_KEY_PRO_PROSTATE_SUPPORTEDFEATURES_STATUS; /**< Key of the argument </code>status</code> of event <code>ProStateSupportedFeatures</code> in feature <code>Pro</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_PRO_PROSTATE_SUPPORTEDFEATURES_FEATURES; /**< Key of the argument </code>features</code> of event <code>ProStateSupportedFeatures</code> in feature <code>Pro</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_PRO_PROSTATE_FEATURESACTIVATED_FEATURES; /**< Key of the argument </code>features</code> of event <code>ProStateFeaturesActivated</code> in feature <code>Pro</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_PRO_PROEVENT_CHALLENGEEVENT_CHALLENGE; /**< Key of the argument </code>challenge</code> of event <code>ProEventChallengeEvent</code> in feature <code>Pro</code> */

/**
 * @brief Send a command <code>ProBoughtFeatures</code> in feature <code>Pro</code>
 * Bought features on this pro version of the controller (features that have been bought)
 * This command starts the pro authentification process
 * @param feature feature owning the commands
 * @param features Bought features
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Pro_SendProBoughtFeatures_t) (ARCONTROLLER_FEATURE_Pro_t *feature, uint64_t features);

/**
 * @brief Send a command <code>ProResponse</code> in feature <code>Pro</code>
 * Response to the challenge string sent by the controller
 * @param feature feature owning the commands
 * @param listFlags List entry attribute Bitfield.
 * @param listFlags 0x01: First: indicate it's the first element of the list.
 * @param listFlags 0x02: Last:  indicate it's the last element of the list.
 * @param listFlags 0x04: Empty: indicate the list is empty (implies First/Last). All other arguments should be ignored.
 * @param signedChallenge the signed challenge
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Pro_SendProResponse_t) (ARCONTROLLER_FEATURE_Pro_t *feature, uint8_t listFlags, char * signedChallenge);

/**
 * @brief Send a command <code>ProActivateFeatures</code> in feature <code>Pro</code>
 * Activate some pro features
 * Pro features activated should be part of the list returned by ProState->FeaturesSupported
 * @param feature feature owning the commands
 * @param features Pro features to activate
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Pro_SendProActivateFeatures_t) (ARCONTROLLER_FEATURE_Pro_t *feature, uint64_t features);

/**
 * @brief Feature controller allow to send command related of pro Feature.
 * Pro Feature
 */
struct ARCONTROLLER_FEATURE_Pro_t
{
    ARCONTROLLER_FEATURE_Pro_SendProBoughtFeatures_t sendProBoughtFeatures;
    ARCONTROLLER_FEATURE_Pro_SendProResponse_t sendProResponse;
    ARCONTROLLER_FEATURE_Pro_SendProActivateFeatures_t sendProActivateFeatures;
    ARCONTROLLER_FEATURE_Pro_Private_t *privatePart; /**< Private part of ARCONTROLLER_FEATURE_Pro_t */
};

/**
 * @brief Set a NetworkController to use to send commands.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] networkController The networkController used to send commands ; must be not NULL.
 * @return error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_Pro_SetNetworkController (ARCONTROLLER_FEATURE_Pro_t *feature, ARCONTROLLER_Network_t *networkController);

/**
 * @brief Get the elements of a command received.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command.
 * @param[out] error executing error.
 * @return Element dictionary of the command ; Can be null if an error is occurred.
 */
ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_Pro_GetCommandElements (ARCONTROLLER_FEATURE_Pro_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, eARCONTROLLER_ERROR *error);

/*******************************
 * --- FEATURE wifi --- 
 ******************************/

/**
 * @brief Private part of ARCONTROLLER_FEATURE_Wifi_t.
 */
typedef struct ARCONTROLLER_FEATURE_Wifi_Private_t ARCONTROLLER_FEATURE_Wifi_Private_t;

/**
 * @brief Feature controller allow to send command related of wifi Feature.
 * All commands/events related to the Wifi
 */
typedef struct ARCONTROLLER_FEATURE_Wifi_t ARCONTROLLER_FEATURE_Wifi_t;

/**
 * @brief Create a new wifi Feature Controller
 * @warning This function allocate memory
 * @post ARCONTROLLER_FEATURE_Wifi_Delete() must be called to delete the Feature Controller and free the memory allocated.
 * @param[in] networkController The networkController used to send commands ; can be NULL and defind later with ARCONTROLLER_FEATURE_Wifi_SetNetworkController().
 * @param[out] error executing error.
 * @return the new wifi Feature Controller
 * @see ARCONTROLLER_FEATURE_Wifi_Delete
 */
ARCONTROLLER_FEATURE_Wifi_t *ARCONTROLLER_FEATURE_Wifi_New (ARCONTROLLER_Network_t *networkController, eARCONTROLLER_ERROR *error);

/**
 * @brief Delete the wifi Feature Controller
 * @warning This function free memory
 * @param feature The feature controller to delete
 * @see ARCONTROLLER_FEATURE_Wifi_New
 */
void ARCONTROLLER_FEATURE_Wifi_Delete (ARCONTROLLER_FEATURE_Wifi_t **feature);

/**
 * @brief Get the dictionay of the wifi Feature Controller
 * @param feature The feature controller owning the dictionary to get
 * @param[out] error executing error.
 */
ARCONTROLLER_DICTIONARY_COMMANDS_t *ARCONTROLLER_FEATURE_Wifi_GetDictionary (ARCONTROLLER_FEATURE_Wifi_t *feature, eARCONTROLLER_ERROR *error);

/**
 * @brief Add a callback to use when a command in project <code>Wifi</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] callback the callback to add.
 * @param[in] commandKey Key of the command which the callback must be associated.
 * @param[out] error executing error.
 * @param[int] customData custom data given as parameter to the callback.
 * @see ARCONTROLLER_FEATURE_Wifi_RemoveCallback.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_Wifi_AddCallback (ARCONTROLLER_FEATURE_Wifi_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

/**
 * @brief Remove a callback used when a command in project <code>Wifi</code> is received
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] callback the callback to remove.
 * @param[int] customData The custom data given to the register.
 * @param[out] error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_Wifi_RemoveCallback (ARCONTROLLER_FEATURE_Wifi_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData);

extern const char *ARCONTROLLER_DICTIONARY_KEY_WIFI_SCANNEDITEM_SSID; /**< Key of the argument </code>ssid</code> of event <code>ScannedItem</code> in feature <code>Wifi</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_WIFI_SCANNEDITEM_RSSI; /**< Key of the argument </code>rssi</code> of event <code>ScannedItem</code> in feature <code>Wifi</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_WIFI_SCANNEDITEM_BAND; /**< Key of the argument </code>band</code> of event <code>ScannedItem</code> in feature <code>Wifi</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_WIFI_SCANNEDITEM_CHANNEL; /**< Key of the argument </code>channel</code> of event <code>ScannedItem</code> in feature <code>Wifi</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_WIFI_SCANNEDITEM_LIST_FLAGS; /**< Key of the argument </code>list_flags</code> of event <code>ScannedItem</code> in feature <code>Wifi</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_WIFI_AUTHORIZEDCHANNEL_BAND; /**< Key of the argument </code>band</code> of event <code>AuthorizedChannel</code> in feature <code>Wifi</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_WIFI_AUTHORIZEDCHANNEL_CHANNEL; /**< Key of the argument </code>channel</code> of event <code>AuthorizedChannel</code> in feature <code>Wifi</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_WIFI_AUTHORIZEDCHANNEL_ENVIRONEMENT; /**< Key of the argument </code>environement</code> of event <code>AuthorizedChannel</code> in feature <code>Wifi</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_WIFI_AUTHORIZEDCHANNEL_LIST_FLAGS; /**< Key of the argument </code>list_flags</code> of event <code>AuthorizedChannel</code> in feature <code>Wifi</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_WIFI_APCHANNELCHANGED_TYPE; /**< Key of the argument </code>type</code> of event <code>ApChannelChanged</code> in feature <code>Wifi</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_WIFI_APCHANNELCHANGED_BAND; /**< Key of the argument </code>band</code> of event <code>ApChannelChanged</code> in feature <code>Wifi</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_WIFI_APCHANNELCHANGED_CHANNEL; /**< Key of the argument </code>channel</code> of event <code>ApChannelChanged</code> in feature <code>Wifi</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_WIFI_SECURITYCHANGED_KEY; /**< Key of the argument </code>key</code> of event <code>SecurityChanged</code> in feature <code>Wifi</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_WIFI_SECURITYCHANGED_KEY_TYPE; /**< Key of the argument </code>key_type</code> of event <code>SecurityChanged</code> in feature <code>Wifi</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_WIFI_COUNTRYCHANGED_SELECTION_MODE; /**< Key of the argument </code>selection_mode</code> of event <code>CountryChanged</code> in feature <code>Wifi</code> */
extern const char *ARCONTROLLER_DICTIONARY_KEY_WIFI_COUNTRYCHANGED_CODE; /**< Key of the argument </code>code</code> of event <code>CountryChanged</code> in feature <code>Wifi</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_WIFI_ENVIRONEMENTCHANGED_ENVIRONEMENT; /**< Key of the argument </code>environement</code> of event <code>EnvironementChanged</code> in feature <code>Wifi</code> */

extern const char *ARCONTROLLER_DICTIONARY_KEY_WIFI_RSSICHANGED_RSSI; /**< Key of the argument </code>rssi</code> of event <code>RssiChanged</code> in feature <code>Wifi</code> */

/**
 * @brief Send a command <code>Scan</code> in feature <code>Wifi</code>
 * Launches wifi network scan for a given band to get a list of all wifi networks found by the drone.
 * @param feature feature owning the commands
 * @param band Launches wifi network scan for a given band to get a list of all wifi networks found by the drone.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Wifi_SendScan_t) (ARCONTROLLER_FEATURE_Wifi_t *feature, uint8_t band);

/**
 * @brief Send a command <code>UpdateAuthorizedChannels</code> in feature <code>Wifi</code>
 * Get all available Wifi channels.\nThe list of available Wifi channels is related to the country of the drone. You can get this country with the event [WifiCountryChanged](#wifi-CountryChanged).
 * @param feature feature owning the commands
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Wifi_SendUpdateAuthorizedChannels_t) (ARCONTROLLER_FEATURE_Wifi_t *feature);

/**
 * @brief Send a command <code>SetApChannel</code> in feature <code>Wifi</code>
 * Select channel of choosen band to put the drone's access point on this channel.
 * @param feature feature owning the commands
 * @param type Select channel of choosen band to put the drone's access point on this channel.
 * @param band Select channel of choosen band to put the drone's access point on this channel.
 * @param channel The channel you want to select. Used only when type is manual.
 * @param channel Select channel of choosen band to put the drone's access point on this channel.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Wifi_SendSetApChannel_t) (ARCONTROLLER_FEATURE_Wifi_t *feature, eARCOMMANDS_WIFI_SELECTION_TYPE type, eARCOMMANDS_WIFI_BAND band, uint8_t channel);

/**
 * @brief Send a command <code>SetSecurity</code> in feature <code>Wifi</code>
 * Set the wifi security.\nThe security is changed on the next boot.
 * @param feature feature owning the commands
 * @param type Set the wifi security.\nThe security is changed on the next boot.
 * @param key The key to secure the network. Not used if type is open
 * @param key Set the wifi security.\nThe security is changed on the next boot.
 * @param key_type Set the wifi security.\nThe security is changed on the next boot.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Wifi_SendSetSecurity_t) (ARCONTROLLER_FEATURE_Wifi_t *feature, eARCOMMANDS_WIFI_SECURITY_TYPE type, char * key, eARCOMMANDS_WIFI_SECURITY_KEY_TYPE key_type);

/**
 * @brief Send a command <code>SetCountry</code> in feature <code>Wifi</code>
 * Set the wifi country.
 * @param feature feature owning the commands
 * @param selection_mode Set the wifi country.
 * @param code Country code with ISO 3166 format. Not used if automatic is 1.
 * @param code Set the wifi country.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Wifi_SendSetCountry_t) (ARCONTROLLER_FEATURE_Wifi_t *feature, eARCOMMANDS_WIFI_COUNTRY_SELECTION selection_mode, char * code);

/**
 * @brief Send a command <code>SetEnvironement</code> in feature <code>Wifi</code>
 * Set indoor or outdoor wifi settings.
 * @param feature feature owning the commands
 * @param environement Set indoor or outdoor wifi settings.
 * return executing error
 */
typedef eARCONTROLLER_ERROR (*ARCONTROLLER_FEATURE_Wifi_SendSetEnvironement_t) (ARCONTROLLER_FEATURE_Wifi_t *feature, eARCOMMANDS_WIFI_ENVIRONEMENT environement);

/**
 * @brief Feature controller allow to send command related of wifi Feature.
 * All commands/events related to the Wifi
 */
struct ARCONTROLLER_FEATURE_Wifi_t
{
    ARCONTROLLER_FEATURE_Wifi_SendScan_t sendScan;
    ARCONTROLLER_FEATURE_Wifi_SendUpdateAuthorizedChannels_t sendUpdateAuthorizedChannels;
    ARCONTROLLER_FEATURE_Wifi_SendSetApChannel_t sendSetApChannel;
    ARCONTROLLER_FEATURE_Wifi_SendSetSecurity_t sendSetSecurity;
    ARCONTROLLER_FEATURE_Wifi_SendSetCountry_t sendSetCountry;
    ARCONTROLLER_FEATURE_Wifi_SendSetEnvironement_t sendSetEnvironement;
    ARCONTROLLER_FEATURE_Wifi_Private_t *privatePart; /**< Private part of ARCONTROLLER_FEATURE_Wifi_t */
};

/**
 * @brief Set a NetworkController to use to send commands.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command which the callback must be unassociated.
 * @param[in] networkController The networkController used to send commands ; must be not NULL.
 * @return error executing error.
 */
eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_Wifi_SetNetworkController (ARCONTROLLER_FEATURE_Wifi_t *feature, ARCONTROLLER_Network_t *networkController);

/**
 * @brief Get the elements of a command received.
 * @param feature The feature controller receiving the command.
 * @param[in] commandKey Key of the command.
 * @param[out] error executing error.
 * @return Element dictionary of the command ; Can be null if an error is occurred.
 */
ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_Wifi_GetCommandElements (ARCONTROLLER_FEATURE_Wifi_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, eARCONTROLLER_ERROR *error);

#endif /* _ARCONTROLLER_FEATURE_H_ */

// END GENERATED CODE
