/***
 *  Software License Agreement: BSD 3-Clause License
 *  
 *  Copyright (c) 2016-2021, qbrobotics®
 *  All rights reserved.
 *  
 *  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the
 *  following conditions are met:
 *  
 *  * Redistributions of source code must retain the above copyright notice, this list of conditions and the
 *    following disclaimer.
 *  
 *  * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other materials provided with the distribution.
 *  
 *  * Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote
 *    products derived from this software without specific prior written permission.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef QB_ARM2_CONTROLLER_H
#define QB_ARM2_CONTROLLER_H

#include <qb_chain_controllers/qb_kinematic_controller.h>
// libraries for direct and inverse kinematics
#include <kdl/chainiksolverpos_nr_jl.hpp>
#include <trac_ik/trac_ik.hpp>

namespace qb_chain_controllers {
  class Arm2KinematicController : public KitKinematicController {
    public:
      Arm2KinematicController();

      ~Arm2KinematicController();

    protected:
      // variables to solve direct and inverse kinematic
      KDL::JntArray q_;
      KDL::Chain chain_;
      KDL::Vector pos_tol_;
      KDL::Vector ang_tol_;
      KDL::Twist tolerances_;
      bool valid_;
      TRAC_IK::TRAC_IK ik_solver_; // inverse kinematic solver

      bool forwardKinematics(const std::vector<double> &joint_positions, geometry_msgs::Point &ee_pose);

      bool inverseKinematics(const geometry_msgs::Point &ee_pose, std::vector<double> &joint_positions);

      // Defines if the solution is suitable for 'moveL' type of motion
      bool isValidSolution(KDL::JntArray jointVariables, KDL::Frame end_effector_pose);
  };
}
#endif // QB_ARM2_CONTROLLER_H