// rokubimini
#include <rokubimini_serial/setup/RokubiminiSerial.hpp>

namespace rokubimini
{
namespace serial
{
namespace setup
{
void RokubiminiSerial::fromFile(const YAML::Node& yamlNode, const std::string& setupFile)
{
  Rokubimini::fromFile(yamlNode, setupFile);
  if (yamlNode["port"])
  {
    serialPort_ = yamlNode["port"].as<std::string>();
  }
  if (yamlNode["baud_rate"])
  {
    baudRate_ = yamlNode["baud_rate"].as<uint32_t>();
  }
  // if (yamlNode.hasKey("version"))
  // {
  //   version_ = yamlNode["version"].as<std::string>();
  // }
  // if (yamlNode.hasKey("dev_pid"))
  // {
  //   devPid_ = yamlNode["dev_pid"].as<std::uint32_t>();
  // }
}

}  // namespace setup
}  // namespace serial
}  // namespace rokubimini
