#ifndef MAPPINGSTATE_H
#define MAPPINGSTATE_H

#include <pluginlib/class_list_macros.h>
#include <rsm_core/BaseState.h>
#include <rsm_core/IdleState.h>
#include <rsm_core/EmergencyStopState.h>
#include <rsm_core/TeleoperationState.h>
#include <rsm_core/StateInterface.h>
#include <rsm_msgs/GoalCompleted.h>

namespace rsm {

/**
 * @class   MappingDummyState
 * @brief   Dummy state for mapping at a reached goal during exploration. Only initiates transition to
 * 			CalculateGoalState.
 */
class MappingDummyState: public BaseState {

public:

	/**
	 * Constructor
	 */
	MappingDummyState();

	/**
	 * Destructor
	 */
	~MappingDummyState();

	/**
	 * Called once when registered at StateInterface
	 */
	void onSetup();

	/**
	 * Called once when activated
	 */
	void onEntry();

	/**
	 * Process method (step-wise, never block this method)
	 */
	void onActive();

	/**
	 * Called once when left
	 */
	void onExit();

	/**
	 * Called when exploration was started manually
	 */
	void onExplorationStart(bool &success, std::string &message);

	/**
	 * Called when exploration was stopped manually
	 */
	void onExplorationStop(bool &success, std::string &message);

	/**
	 * Called when waypoint following was started/paused manually
	 */
	void onWaypointFollowingStart(bool &success, std::string &message);

	/**
	 * Called when waypoint following was stopped manually
	 */
	void onWaypointFollowingStop(bool &success, std::string &message);

	/**
	 * @brief Called when an operation mode interrupt was received
	 * @param interrupt Kind of interrupt (0=EmergencyStop, 1=TeleoperationInterupt)
	 */
	void onInterrupt(int interrupt);

private:
	ros::NodeHandle _nh;
	ros::ServiceClient _navigation_goal_completed_service;

	/**
	 * Was the mapping at the exploration goal successful or not
	 */
	int _navigation_completed_status;
};

}

#endif
