// *****************************************************************************
//
// © Copyright 2020, Septentrio NV/SA.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//    1. Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//    2. Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//    3. Neither the name of the copyright holder nor the names of its
//       contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE 
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE. 
//
// *****************************************************************************

// *****************************************************************************
//
// Boost Software License - Version 1.0 - August 17th, 2003
// 
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:

// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//
// *****************************************************************************

#ifndef GPRMC_HPP
#define GPRMC_HPP

// ROSaic includes
#include <septentrio_gnss_driver/parsers/parser_base_class.hpp>
#include <septentrio_gnss_driver/parsers/string_utilities.h>
// Boost and ROS includes
#include <septentrio_gnss_driver/Gprmc.h>
#include <boost/make_shared.hpp>

extern std::string g_frame_id;
extern bool g_use_gnss_time;

/**
 * @file gprmc.hpp
 * @brief Derived class for parsing RMC messages
 * @date 28/09/20 
 */

/**
 * @class GprmcParser
 * @brief Derived class for parsing RMC messages
 * @date 28/09/20 
 */
class GprmcParser : public BaseParser<septentrio_gnss_driver::GprmcPtr>
{
	public:
		
		/**
		 * @brief Constructor of the class GprmcParser
		 */
		GprmcParser(): BaseParser<septentrio_gnss_driver::GprmcPtr>(), was_last_gprmc_valid_(false) {}

		/**
		 * @brief Returns the ASCII message ID, here "$GPRMC"
		 * @return The message ID
		 */
		const std::string getMessageID() const override; 
		
		/**
		 * @brief Parses one RMC message 
		 * @param[in] sentence The RMC message to be parsed
		 * @return A ROS message pointer of ROS type septentrio_gnss_driver::GprmcPtr
		 */
		septentrio_gnss_driver::GprmcPtr parseASCII(const NMEASentence& sentence) noexcept(false) override;

		/**
		 * @brief Tells us whether the last RMC message was valid/usable or not 
		 * @return True if last RMC message was valid, false if not
		 * 
		 * E.g. if the status is V=Void, then this function will also return false.
		 */
		bool wasLastGPRMCValid() const;

		/**
		 * @brief Declares the string MESSAGE_ID
		 */
		static const std::string MESSAGE_ID;
		
		//! 1 kt = 0.51444444444 mps (meters per second)
		//! Note that constexpr is needed for in-class initialization of static data members.
		static constexpr double KNOTS_TO_MPS = 0.5144444;
		
	private:
		/**
		 * @brief Declares a boolean representing whether or not the last GPRMC message was valid
		 */
		bool was_last_gprmc_valid_;
};


#endif //GPRMC_HPP