/** **************************************************************************************
 * @file       log_message_example.c
 * @ingroup    Toposens Sensor Library
 * @copyright  Copyright (c) Toposens GmbH 2021. All rights reserved.
 ******************************************************************************************/

#include "example_common.h"
#include "toposens/sensor_lib.h"

#include <unistd.h>

#define SLEEP_TIME_SECONDS 60 * 60

static void LogMsgCallback(uint16_t SenderId_u16, uint8_t* ReceivedPayload_pu8);

int main()
{
  RegisterLogMsgCallback(LogMsgCallback);
  InitInterface("can0", 1000000, IF_CAN);
  sleep(SLEEP_TIME_SECONDS);

  DeinitInterface(IF_CAN);
  return 0;
}

static void LogMsgCallback(uint16_t SenderId_u16, uint8_t* ReceivedPayload_pu8)
{
  PrintLogMessage(SenderId_u16, ReceivedPayload_pu8);
}