# toposens_markers

This package provides functionality for transforming `TsScan` messages to *Markers* for visualizing in RViz.

It was developed and tested for ROS Melodic on Ubuntu 18.04 (Bionic) and ROS Kinetic on Ubuntu 16.04 (Xenial) using Toposens TS3 ultrasonic sensor.

## Overview

* Maps `TsPoint`s of incoming `TsScan` structure (received on the topic defined by `scans_topic` parameter, typically `/ts_scans`) to the `target_frame` (which is a parameter as well), utilizing subscribed tf
* Converts `TsScan`/`TsPoint` data to `visualization_msgs/MarkerArray` messages by making use of *RViz Visual Tools* (http://wiki.ros.org/rviz_visual_tools)
* Publishes converted messages on the topic `/ts_markers`

## Usage

### Build

Find information on how to build the package in the README of the `toposens` metapackage.

### Enable Serial Port Permissions

Find information on how to setup the serial port permissions in the README of the `toposens_driver` package.

### Run

The `ts_markers_node` translates the messages of type `toposens_msgs/TsScan` into messages of type `visualization_msgs/MarkerArray`, which can be visualized in RViz.

The driver node as well as the markers node are launched from within one launch-file:

```bash
roslaunch toposens_markers toposens_markers.launch port:=/dev/ttyUSB0
```

### Configuration

Configuration is done via a *dynamic reconfiguration server* and launch file parameters.

To manipulate sensor parameters as well as visualization parameters live in realtime, run in an additional terminal window:

```bash
rosrun rqt_reconfigure rqt_reconfigure
```

There are 2 parameters that can be changed in the `ts_markers_node`.

| Parameter Name | Description |
| --- | --- |
| `lifetime` | Duration for which a marker should remain visible |
| `scale` | Magnitude for resizing markers equally and simultaneously |
