/** @file     mapping.h
 *  @author   Adi Singh
 *  @date     March 2019
 */

#ifndef MAPPING_H
#define MAPPING_H

#define PCL_NO_PRECOMPILE

#include <pcl/point_cloud.h>
#include <pcl/point_types.h>

#include <Eigen/Core>
#include <Eigen/Dense>
#include <vector>

#include "toposens_msgs/TsPoint.h"
#include "toposens_msgs/TsScan.h"

using namespace Eigen;

namespace toposens_pointcloud
{
/** Templatized pointcloud containing points of type pcl::PointXYZINormal.*/
typedef pcl::PointCloud<pcl::PointXYZINormal> XYZINCloud;

/**
 * @brief Library for mapping/converting pcl::PointXYZINormal and toposens_msgs::TsPoint messages.
 */
class Mapping
{
public:
  Mapping() = default;

  /**
   * Performs a point translation and rotation to the target frame.
   * The input point is updated after transformation
   * @param pt Input point that is to be transformed.
   * @param translation translation vector.
   * @param quaternion quaternion vector.
   */
  void doTransform(pcl::PointXYZINormal &pt, Vector3f translation, Vector4f quaternion);

  /**
   * @brief Converts a point from a TsPoint message to a standard PCL point (PointXYZINormal).
   * @details The normal is generated as a vector pointing from the detected point to the sensor
   * origin with unit length.
   * @param i TsPoint to convert.
   * @returns PointXYZINormal created from the given input.
   */
  pcl::PointXYZINormal convertToXYZINormal(toposens_msgs::TsPoint i);
};

}  // namespace toposens_pointcloud

#endif