#include "toposens/errors.h"

char*
getErrorString(TopoError_t err)
{
    switch (err)
    {
        ERR_STR(TOPO_OK);
        ERR_STR(TOPO_ERROR_GENERIC);
        ERR_STR(TOPO_ERROR_UNSUPPORTED_INTERFACE);
        ERR_STR(TOPO_ERROR_UNKNOWN_INTERFACE);
        ERR_STR(TOPO_ERROR_ALREADY_INITIALIZED);
        ERR_STR(TOPO_ERROR_ALREADY_CONNECTED);
        ERR_STR(TOPO_ERROR_MAX_SENSORS_REACHED);
        ERR_STR(TOPO_ERROR_TIMEOUT);
        ERR_STR(TOPO_ERROR_NODATA);
        ERR_STR(TOPO_ERROR_TRYAGAIN);
        ERR_STR(TOPO_ERROR_BUSY);
        ERR_STR(TOPO_ERROR_INVALID_PARAMETER);
        ERR_STR(TOPO_ERROR_FLASH);
        ERR_STR(TOPO_ERROR_DATA_REJECTED);
    default:
        return "Unknown error code";
    }
}
