# Examples

[[_TOC_]]

## Introduction

This directory contains a number of examples which show how the *Toposens Sensor Library* can be used.

Note that small changes may be needed to the examples, for example, if the CAN interface is on *can1* rather than *can0*.

## Example Descriptions

### log_message_example

This example can be run using:

```none
./log_message_example
```

This example simply shows how the log message callback works. It does not command the sensor to take measurements or do anything so if the sensor is in idle mode, it is likely that no log messages will be sent by the sensor.

In order to see the log messages in action, start the example and then disconnect and reconnect the power barrel jack without disconnecting the CAN bus. When the sensor boots up, the *reset reason* log message will be sent and will be printed to the console. The purpose of this log message is to inform the user if the sensor unexpectedly restarts.

### n_frames_single_shot_example

This example can be run using:

```none
./n_frames_single_shot_example -n [i]
```

where *[i]* is to be replaced by the number of measurements to take.

This example restarts the sensor, sets the mode and then performs *i* measurements. The coordinates of the detected echoes are then printed to the screen for each frame.

### n_frames_single_shot_example_uart

This example can be run using:

```none
./n_frames_single_shot_example_uart -n [i]
```

where *[i]* is to be replaced by the number of measurements to take.

This example is the same as *n_frames_single_shot_example* except that it uses the service port rather than the CAN interface to communicate with the sensor. Ensure that the correct port is used when building the example (by default the example uses */dev/ttyUSB0*).

### adc_dump_save_example

This example can be run using:

```none
./adc_dump_save_example [file_path]
```

where *[file_path]* is to be replaced by a file path to where the ADC dump should be saved, Eg. */home/user/adc_dump.bin*.

This example restarts the sensor, triggers the sensor to perform a single measurement and it also retrieves the echoes recorded by the sensor's microphones. This data (which is encrypted) can be sent to Toposens if an issue occurs with the sensor.  
