# Dependencies

cffi

`pip3 install cffi`


# Generating the bindings

In the python bindings folder execute:

`python3 topo_cffi.py`


It will generate the python modules in the current folder.

TODO: Define how it will be delivered with the binary toposens C library, and
how it will be installed / updated on the users machines.

# Usage

!!! Since currently the python bindings aren't installed on the system, you have to
have the python libs/util script in the current working directory of your shell to use them

In your python interactive prompt/script you just need to

`import toposens` (or `import toposens as topo`)

The python util functions (like init_can()) can be accessed directly

`toposens.init_can()`

For init_uart() the baud rate needs to be passed using termios constants (the default is termios.B115200)

`toposens.init_uart("/dev/ttyUSBXX", termios.B115200)`

The functions/constants exported from the C library are available under .library

`topo.lib.InitInterface("can0".encode("ascii"), 1000000, toposens.lib.IF_CAN)`
