#!/usr/bin/env python

# Copyright (c) 2018, Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License").
# You may not use this file except in compliance with the License.
# A copy of the License is located at
#
#  http://aws.amazon.com/apache2.0
#
# or in the "license" file accompanying this file. This file is distributed
# on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
# express or implied. See the License for the specific language governing
# permissions and limitations under the License.

"""Usage:

(assuming TTS action server has been started via `roslaunch tts tts_polly.launch`)

Plain text::

    $ rosrun tts voicer.py 'Hello World'

SSML::

    $ rosrun tts voicer.py \
        '<speak>Mary has a <amazon:effect name="whispered">little lamb.</amazon:effect></speak>' \
        '{"text_type":"ssml"}'
"""


import sys
import actionlib
import rospy
from tts.msg import SpeechAction, SpeechGoal


if __name__ == '__main__':
    rospy.init_node('tts_action_client')
    client = actionlib.SimpleActionClient('tts', SpeechAction)
    client.wait_for_server()

    goal = SpeechGoal()

    goal.text = sys.argv[1] if len(sys.argv) > 1 else 'I got no idea.'
    goal.metadata = sys.argv[2] if len(sys.argv) > 2 else ''

    client.send_goal(goal)
    client.wait_for_result()
    print('\n' + client.get_result().response)
