# vrx_gazebo

## Description
This package provides gazebo models, plugins, and examples for simulating the [RobotX challenge](https://www.robotx.org/index.php/2014-01-05-21-55-32/2016-rules-requirements) within Gazebo using ROS.

## Usage
To launch gazebo with an example course layout and WAM-V platform, run:

```roslaunch vrx_gazebo sandisland.launch```


## Course models
The following models are used in the RobotX challenge and will be included in this package.

| Task Element                 | Product                  | Status | Model  |
|:-----------------------------|:-------------------------|:-------|:-------|
| Light Buoy                   | Custom                   | ADDED  | robotx_light_buoy |
| Obstacle - Small             | PolyForm A-3 black       | ADDED  | polyform_a3 |
| Obstacle - Medium            | PolyForm A-5 black       | ADDED  | polyform_a5 |
| Obstacle - Large             | PolyForm A-7 black       | ADDED  | polyform_a7 |
| Red Can buoy                 | Sur-Mark Can Buoy 950410 | ADDED  | surmark950410 |
| Green Can buoy               | Sur-Mark Can Buoy 950400 | ADDED  | surmark950400 |
| White Can buoy               | Sur-Mark Can Buoy 46104  | ADDED  | surmark46104 |
| Green Totem                  | 46104 w/ Green Cover     | ADDED  | green_totem |
| Yellow Totem                 | 46104 w/ Yellow Cover    | ADDED  | yellow_totem |
| Blue Totem                   | 46104 w/ Blue Cover      | ADDED  | blue_totem |
| Red Totem                    | 46104 w/ Red Cover       | ADDED  | red_totem |
| Black Totem                  | 46104 w/ Black Cover     | ADDED  | black_totem |
| Dock Material                | JetDock C000000008       | ADDED  | dock_block |
| 2016 Dock                    | Custom Assembly          | ADDED  | robotx_dock_2016 |
| 2018 Dock                    | Custom Assembly          | ADDED  | robotx_dock_2018 |
| Blue Circle Symbol           | Custom                   | ADDED  | symbol_circle |
| Blue Cruciform Symbol        | Custom                   | ADDED  | symbol_cross |
| Blue Triangle Symbol         | Custom                   | ADDED  | symbol_triangle |
| Green Circle Symbol          | Custom                   | ADDED  | symbol_circle |
| Green Cruciform Symbol       | Custom                   | ADDED  | symbol_cross |
| Green Triangle Symbol        | Custom                   | ADDED  | symbol_triangle |
| Red Circle Symbol            | Custom                   | ADDED  | symbol_circle |
| Red Cruciform Symbol         | Custom                   | ADDED  | symbol_cross |
| Red Triangle Symbol          | Custom                   | ADDED  | symbol_triangle |
| 2016 Pinger Transit (quals)  | Custom Group of objects  | ADDED  | robotx_2016_qualifying_pinger_transit |
| 2016 Pinger Transit (finals) | Custom Group of objects  | ADDED  | robotx_2016_finals_pinger_transit |
| 2018 Entrance/Exit Gate      | Custom Group of objects  | ADDED  | robotx_2018_entrance_gate |
| White placard                | Custom                   | ADDED  | placard |

*= More detailed model needed
