/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.msr.RiotEmulator;

import com.microsoft.msr.DiceEmulator.DICE;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemWriter;

public class RIoT {
    private static String rEcCurve = "P-256";
    private static String rSignAlg = "ECDSA";
    private static String rSigSch = "SHA256withECDSA";
    private static ASN1ObjectIdentifier rSignatureOID = X9ObjectIdentifiers.ecdsa_with_SHA256;
    private static byte[] rDigest = RIoT.hstoba("b5859493661e2eae9677c55d590b9294e094abafd740787e050dfe6d859053a0");
    private static byte[] rDevCertSerial = RIoT.hstoba("0e0d0c0b0a");
    private static byte[] rAlisCertSerial = RIoT.hstoba("0a0b0c0d0e");
    private static String rExtensionOID = "1.3.6.1.4.1.311.89.3.1";
    private static int rPathLenConstraint = 1;
    private static String rValidityStart = "20170101000000 GMT";
    private static String rValidityEnd = "99991231235959 GMT";

    public static DeviceAuthBundle CreateDeviceAuthBundle(byte[] UDS, byte[] FWID, boolean createCSR) {
        if (UDS.length != 32 || FWID.length != 32) {
            throw new IllegalArgumentException("UDS and FWID must be 32-bytes in length");
        }
        try {
            DeviceAuthBundle authBundle = new DeviceAuthBundle();
            byte[] digest = DICE.DiceSHA256(UDS);
            byte[] CDI = DICE.DiceSHA256(digest, rDigest);
            digest = RIoT.Hash(CDI);
            KeyPair devID = RIoT.DeriveEccKey(digest);
            digest = RIoT.Hash(digest, FWID);
            KeyPair aliasKey = RIoT.DeriveEccKey(digest);
            authBundle.DeviceIDPublic = devID.getPublic();
            authBundle.DeviceIDPublicPem = RIoT.dertopem("PUBLIC KEY", devID.getPublic().getEncoded());
            authBundle.AliasPublicKey = aliasKey.getPublic();
            authBundle.AliasPublicKeyPem = RIoT.dertopem("PUBLIC KEY", aliasKey.getPublic().getEncoded());
            authBundle.AliasPrivateKey = aliasKey.getPrivate();
            authBundle.AliasPrivateKeyPem = RIoT.dertopem("PRIVATE KEY", aliasKey.getPrivate().getEncoded());
            X509Certificate devCert = RIoT.MakeDeviceCert(devID);
            X509Certificate aliasCert = RIoT.MakeAliasCert(devID, aliasKey, FWID);
            authBundle.DeviceIDCert = devCert;
            authBundle.DeviceIDCertPem = RIoT.dertopem("CERTIFICATE", devCert.getEncoded());
            authBundle.AliasCert = aliasCert;
            authBundle.AliasCertPem = RIoT.dertopem("CERTIFICATE", aliasCert.getEncoded());
            return authBundle;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static X509Certificate MakeDeviceCert(KeyPair deviceID) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, IOException, ParseException, SignatureException, CertificateException {
        SubjectPublicKeyInfo pubKeyInfo = SubjectPublicKeyInfo.getInstance(deviceID.getPublic().getEncoded());
        X500Name certName = RIoT.toEncodedCN(pubKeyInfo.getEncoded());
        Signature sig = Signature.getInstance(rSigSch, "BC");
        sig.initSign(deviceID.getPrivate());
        Time vStart = new Time(new SimpleDateFormat("yyyymmddhhmmss Z").parse(rValidityStart));
        Time vEnd = new Time(new SimpleDateFormat("yyyymmddhhmmss Z").parse(rValidityEnd));
        V3TBSCertificateGenerator certGen = new V3TBSCertificateGenerator();
        certGen.setSerialNumber(new ASN1Integer(RIoT.hstoba("0E0D0C0B0A")));
        certGen.setIssuer(certName);
        certGen.setSubject(certName);
        certGen.setStartDate(vStart);
        certGen.setEndDate(vEnd);
        certGen.setSubjectPublicKeyInfo(pubKeyInfo);
        certGen.setSignature(new AlgorithmIdentifier(rSignatureOID));
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        extGen.addExtension(Extension.keyUsage, true, new KeyUsage(128));
        extGen.addExtension(Extension.basicConstraints, true, new BasicConstraints(rPathLenConstraint));
        certGen.setExtensions(extGen.generate());
        TBSCertificate tbsCert = certGen.generateTBSCertificate();
        sig.update(tbsCert.getEncoded("DER"));
        byte[] certSignature = sig.sign();
        ASN1EncodableVector encVec = new ASN1EncodableVector();
        encVec.add(tbsCert);
        encVec.add(new AlgorithmIdentifier(rSignatureOID));
        encVec.add(new DERBitString(certSignature));
        byte[] certDER = new DERSequence(encVec).getEncoded("DER");
        X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509", "BC").generateCertificate(new ByteArrayInputStream(certDER));
        return cert;
    }

    public static X509Certificate MakeAliasCert(KeyPair deviceID, KeyPair aliasKey, byte[] FWID) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, IOException, SignatureException, ParseException, CertificateException {
        SubjectPublicKeyInfo devicePub = SubjectPublicKeyInfo.getInstance(deviceID.getPublic().getEncoded());
        SubjectPublicKeyInfo aliasPub = SubjectPublicKeyInfo.getInstance(aliasKey.getPublic().getEncoded());
        Signature sig = Signature.getInstance(rSigSch, "BC");
        sig.initSign(deviceID.getPrivate());
        Time vStart = new Time(new SimpleDateFormat("yyyymmddhhmmss Z").parse(rValidityStart));
        Time vEnd = new Time(new SimpleDateFormat("yyyymmddhhmmss Z").parse(rValidityEnd));
        V3TBSCertificateGenerator certGen = new V3TBSCertificateGenerator();
        certGen.setSerialNumber(new ASN1Integer(rAlisCertSerial));
        certGen.setIssuer(RIoT.toEncodedCN(devicePub.getEncoded()));
        certGen.setSubject(RIoT.toEncodedCN(FWID));
        certGen.setStartDate(vStart);
        certGen.setEndDate(vEnd);
        certGen.setSubjectPublicKeyInfo(aliasPub);
        certGen.setSignature(new AlgorithmIdentifier(rSignatureOID));
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        extGen.addExtension(Extension.extendedKeyUsage, false, new ExtendedKeyUsage(KeyPurposeId.id_kp_clientAuth));
        DERSequence riotExtension = RIoT.getRiotExtension(FWID, deviceID);
        extGen.addExtension(Extension.subjectAlternativeName, true, riotExtension);
        certGen.setExtensions(extGen.generate());
        TBSCertificate tbsCert = certGen.generateTBSCertificate();
        sig.update(tbsCert.getEncoded("DER"));
        byte[] certSignature = sig.sign();
        ASN1EncodableVector encVec = new ASN1EncodableVector();
        encVec.add(tbsCert);
        encVec.add(new AlgorithmIdentifier(rSignatureOID));
        encVec.add(new DERBitString(certSignature));
        byte[] certDER = new DERSequence(encVec).getEncoded("DER");
        X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509", "BC").generateCertificate(new ByteArrayInputStream(certDER));
        return cert;
    }

    public static KeyPair DeriveEccKey(byte[] srcData) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        ECGenParameterSpec ecGenSpec = new ECGenParameterSpec(rEcCurve);
        KeyPairGenerator ecGen = KeyPairGenerator.getInstance(rSignAlg, "BC");
        SecureRandom seed = new SecureRandom(srcData);
        ecGen.initialize(ecGenSpec, seed);
        KeyPair eccKP = ecGen.generateKeyPair();
        return eccKP;
    }

    public static byte[] Hash(byte[] buf) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(buf);
        return md.digest();
    }

    public static byte[] Hash(byte[] buf1, byte[] buf2) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(buf1);
        md.update(buf2);
        return md.digest();
    }

    private static DERSequence getRiotExtension(byte[] FWID, KeyPair deviceID) {
        SubjectPublicKeyInfo devicePub = SubjectPublicKeyInfo.getInstance(deviceID.getPublic().getEncoded());
        DERSequence TaggedFWID = new DERSequence(new ASN1Encodable[]{NISTObjectIdentifiers.id_sha256, new DEROctetString(FWID)});
        DERSequence EncodedDICEIdentity = new DERSequence(new ASN1Encodable[]{new ASN1Integer(1L), devicePub, TaggedFWID});
        DERSequence TaggedEncodedID = new DERSequence(new ASN1Encodable[]{new ASN1ObjectIdentifier(rExtensionOID), EncodedDICEIdentity});
        return TaggedEncodedID;
    }

    private static X500Name toEncodedCN(byte[] buf) throws NoSuchAlgorithmException {
        String b64 = new String(Base64.encode(buf));
        X500NameBuilder bldr = new X500NameBuilder();
        bldr.addRDN(BCStyle.CN, b64);
        return bldr.build();
    }

    private static String dertopem(String header, byte[] derEncodedData) throws IOException {
        PemObject obj = new PemObject(header, derEncodedData);
        StringWriter strWri = new StringWriter();
        PemWriter pemWri = new PemWriter(strWri);
        pemWri.writeObject(obj);
        pemWri.close();
        return strWri.toString();
    }

    private static byte[] hstoba(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    public static class DeviceAuthBundle {
        public PublicKey DeviceIDPublic;
        public String DeviceIDPublicPem;
        public X509Certificate DeviceIDCert;
        public String DeviceIDCertPem;
        public String DeviceIDCSR;
        public PublicKey AliasPublicKey;
        public String AliasPublicKeyPem;
        public PrivateKey AliasPrivateKey;
        public String AliasPrivateKeyPem;
        public X509Certificate AliasCert;
        public String AliasCertPem;
    }
}

