/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.msr.RiotEmulator;

import com.microsoft.msr.DiceEmulator.DICE;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class RIoT {
    private static String rDRBG = "SHA1PRNG";
    private static String rEcCurve = "P-256";
    private static String rSignAlg = "ECDSA";
    private static String rSigSch = "SHA256withECDSA";
    private static ASN1ObjectIdentifier rSignatureOID = X9ObjectIdentifiers.ecdsa_with_SHA256;
    private static byte[] rDigest = RIoT.hstoba("b5859493661e2eae9677c55d590b9294e094abafd740787e050dfe6d859053a0");
    private static byte[] rR00t = RIoT.hstoba("e3e7c713573fd9c8b8e1eaf453f1561502f071c05349c8dae626a90b1788e570");
    private static byte[] rDevCertSerial = RIoT.hstoba("0e0d0c0b0a");
    private static byte[] rAlisCertSerial = RIoT.hstoba("0a0b0c0d0e");
    private static String rRootCertIssuerName = "RIoT R00t";
    private static String rRootCertIssuerOrg = "MSR_TEST";
    private static String rRootCertIssuerCountry = "US";
    private static String rRootCertSubjectName = rRootCertIssuerName;
    private static String rRootCertSubjectOrg = rRootCertIssuerOrg;
    private static String rRootCertSubjectCountry = rRootCertIssuerCountry;
    private static String rDeviceCertIssuerName = rRootCertSubjectName;
    private static String rDeviceCertIssuerOrg = rRootCertSubjectOrg;
    private static String rDeviceCertIssuerCountry = rRootCertSubjectCountry;
    private static String rDeviceCertSubjectName = "RIoT Core";
    private static String rDeviceCertSubjectOrg = "MSR_TEST";
    private static String rDeviceCertSubjectCountry = "US";
    private static String rAliasCertIssuerName = rDeviceCertSubjectName;
    private static String rAliasCertIssuerOrg = rDeviceCertSubjectOrg;
    private static String rAliasCertIssuerCountry = rDeviceCertSubjectCountry;
    private static String rAliasCertSubjectName = "RIoT Device";
    private static String rAliasCertSubjectOrg = "MSR_TEST";
    private static String rAliasCertSubjectCountry = "US";
    private static String rExtensionOID = "2.23.133.5.4.1";
    private static int rPathLenConstraint = 1;
    private static String rValidityStart = "20170101000000 GMT";
    private static String rValidityEnd = "37011231235959 GMT";

    public static void CreateLeafCert(DeviceAuthBundle devAuth, String commonName) {
        try {
            devAuth.LeafCert = RIoT.makeDeviceCert(devAuth, commonName);
            devAuth.LeafCertPem = RIoT.dertopem("CERTIFICATE", devAuth.LeafCert.getEncoded());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static DeviceAuthBundle CreateDeviceAuthBundle(byte[] UDS, byte[] FWID, boolean createCSR, String rCN, String dCN, String aCN) {
        rRootCertIssuerName = rDeviceCertIssuerName = rCN;
        rRootCertSubjectName = rDeviceCertIssuerName;
        rDeviceCertSubjectName = rAliasCertIssuerName = dCN;
        rAliasCertSubjectName = aCN;
        return RIoT.CreateDeviceAuthBundle(UDS, FWID, createCSR);
    }

    public static DeviceAuthBundle CreateDeviceAuthBundle(byte[] UDS, byte[] FWID, boolean createCSR) {
        if (UDS.length != 32 || FWID.length != 32) {
            throw new IllegalArgumentException("UDS and FWID must be 32-bytes in length");
        }
        try {
            DeviceAuthBundle authBundle = new DeviceAuthBundle();
            byte[] digest = DICE.DiceSHA256(UDS);
            byte[] CDI = DICE.DiceSHA256(digest, rDigest);
            digest = RIoT.Hash(CDI);
            KeyPair rootKey = RIoT.DeriveEccKey(rR00t);
            KeyPair devID = RIoT.DeriveEccKey(digest);
            digest = RIoT.Hash(digest, FWID);
            KeyPair aliasKey = RIoT.DeriveEccKey(digest);
            authBundle.RootPublicKey = rootKey.getPublic();
            authBundle.RootPublicKeyPem = RIoT.dertopem("PUBLIC KEY", rootKey.getPublic().getEncoded());
            authBundle.RootPrivateKey = rootKey.getPrivate();
            authBundle.RootPrivateKeyPem = RIoT.dertopem("PRIVATE KEY", rootKey.getPrivate().getEncoded());
            authBundle.DeviceIDPublic = devID.getPublic();
            authBundle.DeviceIDPublicPem = RIoT.dertopem("PUBLIC KEY", devID.getPublic().getEncoded());
            authBundle.AliasPublicKey = aliasKey.getPublic();
            authBundle.AliasPublicKeyPem = RIoT.dertopem("PUBLIC KEY", aliasKey.getPublic().getEncoded());
            authBundle.AliasPrivateKey = aliasKey.getPrivate();
            authBundle.AliasPrivateKeyPem = RIoT.dertopem("PRIVATE KEY", aliasKey.getPrivate().getEncoded());
            X509Certificate rootCert = RIoT.makeRootCert(rootKey);
            X509Certificate devCert = RIoT.makeDeviceCert(rootKey, devID);
            X509Certificate aliasCert = RIoT.makeAliasCert(devID, aliasKey, FWID);
            authBundle.RootCert = rootCert;
            authBundle.RootCertPem = RIoT.dertopem("CERTIFICATE", rootCert.getEncoded());
            authBundle.DeviceIDCert = devCert;
            authBundle.DeviceIDCertPem = RIoT.dertopem("CERTIFICATE", devCert.getEncoded());
            authBundle.AliasCert = aliasCert;
            authBundle.AliasCertPem = RIoT.dertopem("CERTIFICATE", aliasCert.getEncoded());
            return authBundle;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static X509Certificate makeRootCert(KeyPair rootKey) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, IOException, ParseException, SignatureException, CertificateException {
        SubjectPublicKeyInfo pubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)rootKey.getPublic().getEncoded());
        X500NameBuilder issBldr = new X500NameBuilder(BCStyle.INSTANCE);
        issBldr.addRDN(BCStyle.CN, rRootCertIssuerName);
        issBldr.addRDN(BCStyle.O, rRootCertIssuerOrg);
        issBldr.addRDN(BCStyle.C, rRootCertIssuerCountry);
        X500Name issuer = issBldr.build();
        X500NameBuilder subBldr = new X500NameBuilder(BCStyle.INSTANCE);
        subBldr.addRDN(BCStyle.CN, rRootCertSubjectName);
        subBldr.addRDN(BCStyle.O, rRootCertSubjectOrg);
        subBldr.addRDN(BCStyle.C, rRootCertSubjectCountry);
        X500Name subject = subBldr.build();
        Signature sig = Signature.getInstance(rSigSch, "BC");
        SecureRandom seed = SecureRandom.getInstance(rDRBG);
        seed.setSeed(RIoT.Hash(rR00t));
        sig.initSign(rootKey.getPrivate(), seed);
        Time vStart = new Time(new SimpleDateFormat("yyyymmddhhmmss Z").parse(rValidityStart));
        Time vEnd = new Time(new SimpleDateFormat("yyyymmddhhmmss Z").parse(rValidityEnd));
        V3TBSCertificateGenerator certGen = new V3TBSCertificateGenerator();
        certGen.setSerialNumber(new ASN1Integer(RIoT.hstoba("5A4B3C2D1E")));
        certGen.setIssuer(issuer);
        certGen.setSubject(subject);
        certGen.setStartDate(vStart);
        certGen.setEndDate(vEnd);
        certGen.setSubjectPublicKeyInfo(pubKeyInfo);
        certGen.setSignature(new AlgorithmIdentifier(rSignatureOID));
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        extGen.addExtension(Extension.keyUsage, false, (ASN1Encodable)new KeyUsage(4));
        extGen.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(rPathLenConstraint + 1));
        certGen.setExtensions(extGen.generate());
        TBSCertificate tbsCert = certGen.generateTBSCertificate();
        sig.update(tbsCert.getEncoded("DER"));
        byte[] certSignature = sig.sign();
        ASN1EncodableVector encVec = new ASN1EncodableVector();
        encVec.add((ASN1Encodable)tbsCert);
        encVec.add((ASN1Encodable)new AlgorithmIdentifier(rSignatureOID));
        encVec.add((ASN1Encodable)new DERBitString(certSignature));
        byte[] certDER = new DERSequence(encVec).getEncoded("DER");
        X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509", "BC").generateCertificate(new ByteArrayInputStream(certDER));
        return cert;
    }

    private static X509Certificate makeDeviceCert(DeviceAuthBundle devAuth, String commonName) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, IOException, ParseException, SignatureException, CertificateException {
        KeyPair root = new KeyPair(devAuth.RootPublicKey, devAuth.RootPrivateKey);
        KeyPair devID = new KeyPair(devAuth.DeviceIDPublic, null);
        return RIoT.makeDeviceCert(root, devID, commonName);
    }

    private static X509Certificate makeDeviceCert(KeyPair rootKey, KeyPair deviceID) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, IOException, ParseException, SignatureException, CertificateException {
        return RIoT.makeDeviceCert(rootKey, deviceID, rDeviceCertSubjectName);
    }

    private static X509Certificate makeDeviceCert(KeyPair rootKey, KeyPair deviceID, String commonName) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, IOException, ParseException, SignatureException, CertificateException {
        SubjectPublicKeyInfo pubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)deviceID.getPublic().getEncoded());
        X500NameBuilder issBldr = new X500NameBuilder(BCStyle.INSTANCE);
        issBldr.addRDN(BCStyle.CN, rDeviceCertIssuerName);
        issBldr.addRDN(BCStyle.O, rDeviceCertIssuerOrg);
        issBldr.addRDN(BCStyle.C, rDeviceCertIssuerCountry);
        X500Name issuer = issBldr.build();
        X500NameBuilder subBldr = new X500NameBuilder(BCStyle.INSTANCE);
        subBldr.addRDN(BCStyle.CN, commonName);
        subBldr.addRDN(BCStyle.O, rDeviceCertSubjectOrg);
        subBldr.addRDN(BCStyle.C, rDeviceCertSubjectCountry);
        X500Name subject = subBldr.build();
        Signature sig = Signature.getInstance(rSigSch, "BC");
        SecureRandom seed = SecureRandom.getInstance(rDRBG);
        seed.setSeed(RIoT.Hash(rDeviceCertSubjectName.getBytes()));
        sig.initSign(rootKey.getPrivate(), seed);
        Time vStart = new Time(new SimpleDateFormat("yyyymmddhhmmss Z").parse(rValidityStart));
        Time vEnd = new Time(new SimpleDateFormat("yyyymmddhhmmss Z").parse(rValidityEnd));
        V3TBSCertificateGenerator certGen = new V3TBSCertificateGenerator();
        certGen.setSerialNumber(new ASN1Integer(RIoT.hstoba("0E0D0C0B0A")));
        certGen.setIssuer(issuer);
        certGen.setSubject(subject);
        certGen.setStartDate(vStart);
        certGen.setEndDate(vEnd);
        certGen.setSubjectPublicKeyInfo(pubKeyInfo);
        certGen.setSignature(new AlgorithmIdentifier(rSignatureOID));
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        extGen.addExtension(Extension.keyUsage, false, (ASN1Encodable)new KeyUsage(4));
        extGen.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(rPathLenConstraint));
        certGen.setExtensions(extGen.generate());
        TBSCertificate tbsCert = certGen.generateTBSCertificate();
        sig.update(tbsCert.getEncoded("DER"));
        byte[] certSignature = sig.sign();
        ASN1EncodableVector encVec = new ASN1EncodableVector();
        encVec.add((ASN1Encodable)tbsCert);
        encVec.add((ASN1Encodable)new AlgorithmIdentifier(rSignatureOID));
        encVec.add((ASN1Encodable)new DERBitString(certSignature));
        byte[] certDER = new DERSequence(encVec).getEncoded("DER");
        X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509", "BC").generateCertificate(new ByteArrayInputStream(certDER));
        return cert;
    }

    private static X509Certificate makeAliasCert(KeyPair deviceID, KeyPair aliasKey, byte[] FWID) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, IOException, SignatureException, ParseException, CertificateException {
        SubjectPublicKeyInfo devicePub = SubjectPublicKeyInfo.getInstance((Object)deviceID.getPublic().getEncoded());
        SubjectPublicKeyInfo aliasPub = SubjectPublicKeyInfo.getInstance((Object)aliasKey.getPublic().getEncoded());
        X500NameBuilder issBldr = new X500NameBuilder(BCStyle.INSTANCE);
        issBldr.addRDN(BCStyle.CN, rAliasCertIssuerName);
        issBldr.addRDN(BCStyle.O, rAliasCertIssuerOrg);
        issBldr.addRDN(BCStyle.C, rAliasCertIssuerCountry);
        X500Name issuer = issBldr.build();
        X500NameBuilder subBldr = new X500NameBuilder(BCStyle.INSTANCE);
        subBldr.addRDN(BCStyle.CN, rAliasCertSubjectName);
        subBldr.addRDN(BCStyle.O, rAliasCertSubjectOrg);
        subBldr.addRDN(BCStyle.C, rAliasCertSubjectCountry);
        X500Name subject = subBldr.build();
        Signature sig = Signature.getInstance(rSigSch, "BC");
        SecureRandom seed = SecureRandom.getInstance(rDRBG);
        seed.setSeed(RIoT.Hash(FWID));
        sig.initSign(deviceID.getPrivate(), seed);
        Time vStart = new Time(new SimpleDateFormat("yyyymmddhhmmss Z").parse(rValidityStart));
        Time vEnd = new Time(new SimpleDateFormat("yyyymmddhhmmss Z").parse(rValidityEnd));
        V3TBSCertificateGenerator certGen = new V3TBSCertificateGenerator();
        certGen.setSerialNumber(new ASN1Integer(rAlisCertSerial));
        certGen.setIssuer(issuer);
        certGen.setSubject(subject);
        certGen.setStartDate(vStart);
        certGen.setEndDate(vEnd);
        certGen.setSubjectPublicKeyInfo(aliasPub);
        certGen.setSignature(new AlgorithmIdentifier(rSignatureOID));
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        extGen.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_clientAuth));
        DERSequence riotExtension = RIoT.getRiotExtension(FWID, deviceID);
        extGen.addExtension(new ASN1ObjectIdentifier(rExtensionOID), false, (ASN1Encodable)riotExtension);
        certGen.setExtensions(extGen.generate());
        TBSCertificate tbsCert = certGen.generateTBSCertificate();
        sig.update(tbsCert.getEncoded("DER"));
        byte[] certSignature = sig.sign();
        ASN1EncodableVector encVec = new ASN1EncodableVector();
        encVec.add((ASN1Encodable)tbsCert);
        encVec.add((ASN1Encodable)new AlgorithmIdentifier(rSignatureOID));
        encVec.add((ASN1Encodable)new DERBitString(certSignature));
        byte[] certDER = new DERSequence(encVec).getEncoded("DER");
        X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509", "BC").generateCertificate(new ByteArrayInputStream(certDER));
        return cert;
    }

    public static KeyPair DeriveEccKey(byte[] srcData) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        ECGenParameterSpec ecGenSpec = new ECGenParameterSpec(rEcCurve);
        KeyPairGenerator ecGen = KeyPairGenerator.getInstance(rSignAlg, "BC");
        SecureRandom seed = SecureRandom.getInstance(rDRBG);
        seed.setSeed(srcData);
        ecGen.initialize(ecGenSpec, seed);
        KeyPair eccKP = ecGen.generateKeyPair();
        return eccKP;
    }

    public static byte[] Hash(byte[] buf) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(buf);
        return md.digest();
    }

    public static byte[] Hash(byte[] buf1, byte[] buf2) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(buf1);
        md.update(buf2);
        return md.digest();
    }

    private static DERSequence getRiotExtension(byte[] FWID, KeyPair deviceID) {
        SubjectPublicKeyInfo devicePubInfo = SubjectPublicKeyInfo.getInstance((Object)deviceID.getPublic().getEncoded());
        DERSequence FWIDseq = new DERSequence(new ASN1Encodable[]{NISTObjectIdentifiers.id_sha256, new DEROctetString(FWID)});
        DERSequence EncodedDICEIdentity = new DERSequence(new ASN1Encodable[]{new ASN1Integer(1L), devicePubInfo, FWIDseq});
        return EncodedDICEIdentity;
    }

    private static String dertopem(String header, byte[] derEncodedData) throws IOException {
        PemObject obj = new PemObject(header, derEncodedData);
        StringWriter strWri = new StringWriter();
        PemWriter pemWri = new PemWriter((Writer)strWri);
        pemWri.writeObject((PemObjectGenerator)obj);
        pemWri.close();
        return strWri.toString();
    }

    private static byte[] hstoba(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static class DeviceAuthBundle {
        public PublicKey RootPublicKey;
        public String RootPublicKeyPem;
        public PrivateKey RootPrivateKey;
        public String RootPrivateKeyPem;
        public X509Certificate RootCert;
        public String RootCertPem;
        public PublicKey DeviceIDPublic;
        public String DeviceIDPublicPem;
        public X509Certificate DeviceIDCert;
        public String DeviceIDCertPem;
        public String DeviceIDCSR;
        public PublicKey AliasPublicKey;
        public String AliasPublicKeyPem;
        public PrivateKey AliasPrivateKey;
        public String AliasPrivateKeyPem;
        public X509Certificate AliasCert;
        public String AliasCertPem;
        public X509Certificate LeafCert;
        public String LeafCertPem;
    }
}

