# Cartesian Control Messages
A new take on Cartesian trajectory control in ROS.

Cartesian trajectory definitions have long been a complicated and highly-discussed topic in ROS.
This set of messages and definitions is the result of an in-depth investigation
of current approaches in both academia and industry.

While its arguably impossible to cover every detail, to meet all requirements
of such an interface, the goal is to nevertheless provide a consensus that
covers _most_ use cases and let's the community start using Cartesian trajectory control in ROS.

Please have a look at the [design document][1] for further details on decisions and rationals.


[1]: https://github.com/fzi-forschungszentrum-informatik/fzi_robot_interface_proposal

## Acknowledgement
Developed in collaboration between:

[<img height="60" alt="Universal Robots A/S" src="doc/resources/ur_logo.jpg">](https://www.universal-robots.com/) &nbsp; and &nbsp;
[<img height="60" alt="FZI Research Center for Information Technology" src="doc/resources/fzi_logo.png">](https://www.fzi.de).

***
<!-- 
    ROSIN acknowledgement from the ROSIN press kit
    @ https://github.com/rosin-project/press_kit
-->

<a href="http://rosin-project.eu">
  <img src="http://rosin-project.eu/wp-content/uploads/rosin_ack_logo_wide.png" 
       alt="rosin_logo" height="60" >
</a>

Supported by ROSIN - ROS-Industrial Quality-Assured Robot Software Components.  
More information: <a href="http://rosin-project.eu">rosin-project.eu</a>

<img src="http://rosin-project.eu/wp-content/uploads/rosin_eu_flag.jpg" 
     alt="eu_flag" height="45" align="left" >  

This project has received funding from the European Union’s Horizon 2020  
research and innovation programme under grant agreement no. 732287. 
