#pragma once

#include <regex>
#include <string>
#include <vector>

#include <xmlrpcpp/XmlRpc.h>

#include <foxglove_bridge/parameter.hpp>

namespace foxglove_bridge {

foxglove::Parameter fromRosParam(const std::string& name, const XmlRpc::XmlRpcValue& value);

std::vector<std::regex> parseRegexPatterns(const std::vector<std::string>& strings);

bool isWhitelisted(const std::string& name, const std::vector<std::regex>& regexPatterns);

}  // namespace foxglove_bridge
