
# Contributing to ifopt

:+1::tada: First off, thanks for taking the time to contribute! :tada::+1:

We are grateful to anyone who decides to actively engage in this project.
This project and everyone participating in it is governed by the [Code of Conduct](CODE_OF_CONDUCT.md). 
By participating, you are expected to uphold this code. 


## Question or Issue?
* [ROS Answers](https://answers.ros.org/questions/scope:all/sort:activity-desc/tags:ifopt/page:1/):
  If you want to ask a general usage question, please do this at ROS Answers using the tag `ifopt`. Asking there has the following advantages:

  - There are many more people reading questions there so your chances on getting an answer and in a timely manner are much   higher.
  - In the future other users will search there for similar problems and can find your question and the potential answers.

* [Issue tracker](https://github.com/ethz-adrl/ifopt/issues):
  In case you want to report bugs, request features or closely related to the code, the 
  Issue tracker in this repo is the way to go.   


## How Can I Contribute?
Unsure where to begin contributing to ifopt? You can start by looking through these `beginner` and `help-wanted` issues:

* [Good first issues](https://github.com/ethz-adrl/ifopt/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22) - issues which should only require a few lines of code, and a test or two.
* [Help wanted issues](https://github.com/ethz-adrl/ifopt/issues?q=is%3Aopen+is%3Aissue+label%3A%22help+wanted%22) - issues which should be a bit more involved than `beginner` issues.

Further ideas might include:
- writing interfaces to additional solvers
- reporting bugs
- enhance documentation
- add unit tests

Please follow the [Google Style Guide](https://google.github.io/styleguide/cppguide.html) when writing your C++ Code for this project. 


## Submitting a pull request
Please create a [pull request](https://github.com/ethz-adrl/ifopt/compare) from your forked repo to the master branch. 

- Keep pull requests small, focussing on one specific issue.
- Describe concisely what you are solving and reference the corresponding issue.
- Include weblinks to relevant information.
- Include screenshots and animated GIFs in your pull request whenever possible.

We are performing automatic pull request testing, so if you see anything red, please read through the log and update your pull request until the tests pass.

