/// autogenerated analytical inverse kinematics code from ikfast program part of OpenRAVE
/// \author Rosen Diankov
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///     http://www.apache.org/licenses/LICENSE-2.0
/// 
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// ikfast version 0x10000049 generated on 2019-10-17 10:37:13.698231
/// To compile with gcc:
///     gcc -lstdc++ ik.cpp
/// To compile without any main function as a shared object (might need -llapack):
///     gcc -fPIC -lstdc++ -DIKFAST_NO_MAIN -DIKFAST_CLIBRARY -shared -Wl,-soname,libik.so -o libik.so ik.cpp
#define IKFAST_HAS_LIBRARY
#include "ikfast.h" // found inside share/openrave-X.Y/python/ikfast.h
using namespace ikfast;

// check if the included ikfast version matches what this file was compiled with
#define IKFAST_COMPILE_ASSERT(x) extern int __dummy[(int)x]
IKFAST_COMPILE_ASSERT(IKFAST_VERSION==0x10000049);

#include <cmath>
#include <vector>
#include <limits>
#include <algorithm>
#include <complex>

#ifndef IKFAST_ASSERT
#include <stdexcept>
#include <sstream>
#include <iostream>

#ifdef _MSC_VER
#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __FUNCDNAME__
#endif
#endif

#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __func__
#endif

#define IKFAST_ASSERT(b) { if( !(b) ) { std::stringstream ss; ss << "ikfast exception: " << __FILE__ << ":" << __LINE__ << ": " <<__PRETTY_FUNCTION__ << ": Assertion '" << #b << "' failed"; throw std::runtime_error(ss.str()); } }

#endif

#if defined(_MSC_VER)
#define IKFAST_ALIGNED16(x) __declspec(align(16)) x
#else
#define IKFAST_ALIGNED16(x) x __attribute((aligned(16)))
#endif

#define IK2PI  ((IkReal)6.28318530717959)
#define IKPI  ((IkReal)3.14159265358979)
#define IKPI_2  ((IkReal)1.57079632679490)

#ifdef _MSC_VER
#ifndef isnan
#define isnan _isnan
#endif
#ifndef isinf
#define isinf _isinf
#endif
//#ifndef isfinite
//#define isfinite _isfinite
//#endif
#endif // _MSC_VER

// lapack routines
extern "C" {
  void dgetrf_ (const int* m, const int* n, double* a, const int* lda, int* ipiv, int* info);
  void zgetrf_ (const int* m, const int* n, std::complex<double>* a, const int* lda, int* ipiv, int* info);
  void dgetri_(const int* n, const double* a, const int* lda, int* ipiv, double* work, const int* lwork, int* info);
  void dgesv_ (const int* n, const int* nrhs, double* a, const int* lda, int* ipiv, double* b, const int* ldb, int* info);
  void dgetrs_(const char *trans, const int *n, const int *nrhs, double *a, const int *lda, int *ipiv, double *b, const int *ldb, int *info);
  void dgeev_(const char *jobvl, const char *jobvr, const int *n, double *a, const int *lda, double *wr, double *wi,double *vl, const int *ldvl, double *vr, const int *ldvr, double *work, const int *lwork, int *info);
}

using namespace std; // necessary to get std math routines

#ifdef IKFAST_NAMESPACE
namespace IKFAST_NAMESPACE {
#endif

inline float IKabs(float f) { return fabsf(f); }
inline double IKabs(double f) { return fabs(f); }

inline float IKsqr(float f) { return f*f; }
inline double IKsqr(double f) { return f*f; }

inline float IKlog(float f) { return logf(f); }
inline double IKlog(double f) { return log(f); }

// allows asin and acos to exceed 1. has to be smaller than thresholds used for branch conds and evaluation
#ifndef IKFAST_SINCOS_THRESH
#define IKFAST_SINCOS_THRESH ((IkReal)1e-7)
#endif

// used to check input to atan2 for degenerate cases. has to be smaller than thresholds used for branch conds and evaluation
#ifndef IKFAST_ATAN2_MAGTHRESH
#define IKFAST_ATAN2_MAGTHRESH ((IkReal)1e-7)
#endif

// minimum distance of separate solutions
#ifndef IKFAST_SOLUTION_THRESH
#define IKFAST_SOLUTION_THRESH ((IkReal)1e-6)
#endif

// there are checkpoints in ikfast that are evaluated to make sure they are 0. This threshold speicfies by how much they can deviate
#ifndef IKFAST_EVALCOND_THRESH
#define IKFAST_EVALCOND_THRESH ((IkReal)0.00001)
#endif


inline float IKasin(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(-IKPI_2);
else if( f >= 1 ) return float(IKPI_2);
return asinf(f);
}
inline double IKasin(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return -IKPI_2;
else if( f >= 1 ) return IKPI_2;
return asin(f);
}

// return positive value in [0,y)
inline float IKfmod(float x, float y)
{
    while(x < 0) {
        x += y;
    }
    return fmodf(x,y);
}

// return positive value in [0,y)
inline double IKfmod(double x, double y)
{
    while(x < 0) {
        x += y;
    }
    return fmod(x,y);
}

inline float IKacos(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(IKPI);
else if( f >= 1 ) return float(0);
return acosf(f);
}
inline double IKacos(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return IKPI;
else if( f >= 1 ) return 0;
return acos(f);
}
inline float IKsin(float f) { return sinf(f); }
inline double IKsin(double f) { return sin(f); }
inline float IKcos(float f) { return cosf(f); }
inline double IKcos(double f) { return cos(f); }
inline float IKtan(float f) { return tanf(f); }
inline double IKtan(double f) { return tan(f); }
inline float IKsqrt(float f) { if( f <= 0.0f ) return 0.0f; return sqrtf(f); }
inline double IKsqrt(double f) { if( f <= 0.0 ) return 0.0; return sqrt(f); }
inline float IKatan2Simple(float fy, float fx) {
    return atan2f(fy,fx);
}
inline float IKatan2(float fy, float fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return float(IKPI_2);
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2f(fy,fx);
}
inline double IKatan2Simple(double fy, double fx) {
    return atan2(fy,fx);
}
inline double IKatan2(double fy, double fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return IKPI_2;
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2(fy,fx);
}

template <typename T>
struct CheckValue
{
    T value;
    bool valid;
};

template <typename T>
inline CheckValue<T> IKatan2WithCheck(T fy, T fx, T epsilon)
{
    CheckValue<T> ret;
    ret.valid = false;
    ret.value = 0;
    if( !isnan(fy) && !isnan(fx) ) {
        if( IKabs(fy) >= IKFAST_ATAN2_MAGTHRESH || IKabs(fx) > IKFAST_ATAN2_MAGTHRESH ) {
            ret.value = IKatan2Simple(fy,fx);
            ret.valid = true;
        }
    }
    return ret;
}

inline float IKsign(float f) {
    if( f > 0 ) {
        return float(1);
    }
    else if( f < 0 ) {
        return float(-1);
    }
    return 0;
}

inline double IKsign(double f) {
    if( f > 0 ) {
        return 1.0;
    }
    else if( f < 0 ) {
        return -1.0;
    }
    return 0;
}

template <typename T>
inline CheckValue<T> IKPowWithIntegerCheck(T f, int n)
{
    CheckValue<T> ret;
    ret.valid = true;
    if( n == 0 ) {
        ret.value = 1.0;
        return ret;
    }
    else if( n == 1 )
    {
        ret.value = f;
        return ret;
    }
    else if( n < 0 )
    {
        if( f == 0 )
        {
            ret.valid = false;
            ret.value = (T)1.0e30;
            return ret;
        }
        if( n == -1 ) {
            ret.value = T(1.0)/f;
            return ret;
        }
    }

    int num = n > 0 ? n : -n;
    if( num == 2 ) {
        ret.value = f*f;
    }
    else if( num == 3 ) {
        ret.value = f*f*f;
    }
    else {
        ret.value = 1.0;
        while(num>0) {
            if( num & 1 ) {
                ret.value *= f;
            }
            num >>= 1;
            f *= f;
        }
    }
    
    if( n < 0 ) {
        ret.value = T(1.0)/ret.value;
    }
    return ret;
}

/// solves the forward kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API void ComputeFk(const IkReal* j, IkReal* eetrans, IkReal* eerot) {
IkReal x0,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,x21,x22,x23,x24,x25,x26,x27,x28,x29,x30,x31,x32,x33,x34,x35,x36,x37,x38,x39,x40,x41,x42,x43;
x0=IKsin(j[0]);
x1=IKcos(j[3]);
x2=IKcos(j[0]);
x3=IKsin(j[3]);
x4=IKcos(j[2]);
x5=IKsin(j[1]);
x6=IKcos(j[1]);
x7=IKsin(j[2]);
x8=IKsin(j[5]);
x9=IKcos(j[5]);
x10=IKcos(j[4]);
x11=IKsin(j[4]);
x12=((1.0)*x1);
x13=((0.078)*x6);
x14=((0.078)*x1);
x15=((1.0)*x3);
x16=((1.0)*x4);
x17=((0.078)*x3);
x18=((0.76)*x4);
x19=((0.76)*x6);
x20=((-1.0)*x10);
x21=(x2*x5);
x22=(x1*x11);
x23=((-1.0)*x11);
x24=(x0*x7);
x25=(x5*x7);
x26=(x4*x6);
x27=(x4*x5);
x28=(x0*x5);
x29=(x2*x7);
x30=(x15*x2);
x31=((1.0)*x6*x7);
x32=((1.0)*x29*x6);
x33=((((-1.0)*x31))+x27);
x34=((((-1.0)*x25))+(((-1.0)*x16*x6)));
x35=(x1*x33);
x36=(((x0*x26))+((x24*x5)));
x37=(x10*x35);
x38=((((-1.0)*x24*x6))+((x16*x28)));
x39=((((-1.0)*x21*x7))+(((-1.0)*x16*x2*x6)));
x40=(x3*x36);
x41=(x1*x39);
x42=(((x10*(((((-1.0)*x30))+((x1*x36))))))+((x11*x38)));
x43=(((x23*(((((-1.0)*x16*x21))+x32))))+((x20*(((((-1.0)*x0*x3))+x41)))));
eerot[0]=(((x9*((((x1*x2))+x40))))+((x42*x8)));
eerot[1]=(((x8*(((((-1.0)*x12*x2))+(((-1.0)*x15*x36))))))+((x42*x9)));
eerot[2]=(((x10*x38))+((x11*(((((-1.0)*x12*x36))+x30)))));
IkReal x44=((1.0)*x24);
eetrans[0]=(((x18*x28))+(((0.7)*x28))+((x11*(((((-1.0)*x14*x36))+((x17*x2))))))+(((-1.0)*x19*x44))+((x10*(((((0.078)*x0*x27))+(((-1.0)*x13*x44)))))));
eerot[3]=(((x43*x8))+((x9*(((((-1.0)*x0*x12))+(((-1.0)*x15*x39)))))));
eerot[4]=(((x8*((((x0*x1))+((x3*x39))))))+((x43*x9)));
eerot[5]=(((x10*(((((-1.0)*x32))+((x21*x4))))))+((x11*(((((-1.0)*x0*x15))+x41)))));
IkReal x45=((1.0)*x29);
eetrans[1]=(((x18*x21))+(((0.7)*x21))+((x10*(((((0.078)*x21*x4))+(((-1.0)*x13*x45))))))+((x11*(((((-1.0)*x0*x17))+((x14*x39))))))+(((-1.0)*x19*x45)));
eerot[6]=(((x8*(((((-1.0)*x10*x12*x33))+(((-1.0)*x11*x34))))))+((x3*x9*(((((-1.0)*x16*x5))+x31)))));
eerot[7]=(((x9*((((x20*x35))+((x23*x34))))))+((x3*x33*x8)));
eerot[8]=(((x22*x33))+((x10*((x25+x26)))));
eetrans[2]=((0.505)+((x18*x6))+(((0.7)*x6))+(((0.76)*x25))+((x10*(((((0.078)*x25))+((x13*x4))))))+((x22*(((((0.078)*x27))+(((-1.0)*x13*x7)))))));
}

IKFAST_API int GetNumFreeParameters() { return 0; }
IKFAST_API int* GetFreeParameters() { return NULL; }
IKFAST_API int GetNumJoints() { return 6; }

IKFAST_API int GetIkRealSize() { return sizeof(IkReal); }

IKFAST_API int GetIkType() { return 0x67000001; }

class IKSolver {
public:
IkReal j0,cj0,sj0,htj0,j0mul,j1,cj1,sj1,htj1,j1mul,j2,cj2,sj2,htj2,j2mul,j3,cj3,sj3,htj3,j3mul,j4,cj4,sj4,htj4,j4mul,j5,cj5,sj5,htj5,j5mul,new_r00,r00,rxp0_0,new_r01,r01,rxp0_1,new_r02,r02,rxp0_2,new_r10,r10,rxp1_0,new_r11,r11,rxp1_1,new_r12,r12,rxp1_2,new_r20,r20,rxp2_0,new_r21,r21,rxp2_1,new_r22,r22,rxp2_2,new_px,px,npx,new_py,py,npy,new_pz,pz,npz,pp;
unsigned char _ij0[2], _nj0,_ij1[2], _nj1,_ij2[2], _nj2,_ij3[2], _nj3,_ij4[2], _nj4,_ij5[2], _nj5;

IkReal j100, cj100, sj100;
unsigned char _ij100[2], _nj100;
bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
j0=numeric_limits<IkReal>::quiet_NaN(); _ij0[0] = -1; _ij0[1] = -1; _nj0 = -1; j1=numeric_limits<IkReal>::quiet_NaN(); _ij1[0] = -1; _ij1[1] = -1; _nj1 = -1; j2=numeric_limits<IkReal>::quiet_NaN(); _ij2[0] = -1; _ij2[1] = -1; _nj2 = -1; j3=numeric_limits<IkReal>::quiet_NaN(); _ij3[0] = -1; _ij3[1] = -1; _nj3 = -1; j4=numeric_limits<IkReal>::quiet_NaN(); _ij4[0] = -1; _ij4[1] = -1; _nj4 = -1; j5=numeric_limits<IkReal>::quiet_NaN(); _ij5[0] = -1; _ij5[1] = -1; _nj5 = -1; 
for(int dummyiter = 0; dummyiter < 1; ++dummyiter) {
    solutions.Clear();
r00 = eerot[0*3+0];
r01 = eerot[0*3+1];
r02 = eerot[0*3+2];
r10 = eerot[1*3+0];
r11 = eerot[1*3+1];
r12 = eerot[1*3+2];
r20 = eerot[2*3+0];
r21 = eerot[2*3+1];
r22 = eerot[2*3+2];
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];

new_r00=r00;
new_r01=r01;
new_r02=r02;
new_px=(px+(((-0.078)*r02)));
new_r10=((-1.0)*r10);
new_r11=((-1.0)*r11);
new_r12=((-1.0)*r12);
new_py=((((0.078)*r12))+(((-1.0)*py)));
new_r20=((-1.0)*r20);
new_r21=((-1.0)*r21);
new_r22=((-1.0)*r22);
new_pz=((0.505)+(((-1.0)*pz))+(((0.078)*r22)));
r00 = new_r00; r01 = new_r01; r02 = new_r02; r10 = new_r10; r11 = new_r11; r12 = new_r12; r20 = new_r20; r21 = new_r21; r22 = new_r22; px = new_px; py = new_py; pz = new_pz;
IkReal x46=((1.0)*px);
IkReal x47=((1.0)*pz);
IkReal x48=((1.0)*py);
pp=((px*px)+(py*py)+(pz*pz));
npx=(((px*r00))+((py*r10))+((pz*r20)));
npy=(((px*r01))+((py*r11))+((pz*r21)));
npz=(((px*r02))+((py*r12))+((pz*r22)));
rxp0_0=((((-1.0)*r20*x48))+((pz*r10)));
rxp0_1=(((px*r20))+(((-1.0)*r00*x47)));
rxp0_2=((((-1.0)*r10*x46))+((py*r00)));
rxp1_0=((((-1.0)*r21*x48))+((pz*r11)));
rxp1_1=(((px*r21))+(((-1.0)*r01*x47)));
rxp1_2=((((-1.0)*r11*x46))+((py*r01)));
rxp2_0=((((-1.0)*r22*x48))+((pz*r12)));
rxp2_1=((((-1.0)*r02*x47))+((px*r22)));
rxp2_2=((((-1.0)*r12*x46))+((py*r02)));
{
IkReal j2array[2], cj2array[2], sj2array[2];
bool j2valid[2]={false};
_nj2 = 2;
cj2array[0]=((-1.00338345864662)+(((0.93984962406015)*pp)));
if( cj2array[0] >= -1-IKFAST_SINCOS_THRESH && cj2array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j2valid[0] = j2valid[1] = true;
    j2array[0] = IKacos(cj2array[0]);
    sj2array[0] = IKsin(j2array[0]);
    cj2array[1] = cj2array[0];
    j2array[1] = -j2array[0];
    sj2array[1] = -sj2array[0];
}
else if( isnan(cj2array[0]) )
{
    // probably any value will work
    j2valid[0] = true;
    cj2array[0] = 1; sj2array[0] = 0; j2array[0] = 0;
}
for(int ij2 = 0; ij2 < 2; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 2; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];

{
IkReal j0eval[1];
j0eval[0]=((IKabs(px))+(IKabs(py)));
if( IKabs(j0eval[0]) < 0.0000010000000000  )
{
{
IkReal j1eval[2];
j1eval[0]=((1.0)+(((2.17142857142857)*cj2))+(((1.17877551020408)*(sj2*sj2)))+(((1.17877551020408)*(cj2*cj2))));
j1eval[1]=((((1.31578947368421)*(IKabs(((0.7)+(((0.76)*cj2)))))))+(IKabs(sj2)));
if( IKabs(j1eval[0]) < 0.0000010000000000  || IKabs(j1eval[1]) < 0.0000010000000000  )
{
continue; // no branches [j0, j1]

} else
{
{
IkReal j1array[2], cj1array[2], sj1array[2];
bool j1valid[2]={false};
_nj1 = 2;
IkReal x49=((0.7)+(((0.76)*cj2)));
CheckValue<IkReal> x52 = IKatan2WithCheck(IkReal(x49),IkReal(((0.76)*sj2)),IKFAST_ATAN2_MAGTHRESH);
if(!x52.valid){
continue;
}
IkReal x50=((1.0)*(x52.value));
if((((((0.5776)*(sj2*sj2)))+(x49*x49))) < -0.00001)
continue;
CheckValue<IkReal> x53=IKPowWithIntegerCheck(IKabs(IKsqrt(((((0.5776)*(sj2*sj2)))+(x49*x49)))),-1);
if(!x53.valid){
continue;
}
if( ((pz*(x53.value))) < -1-IKFAST_SINCOS_THRESH || ((pz*(x53.value))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x51=IKasin((pz*(x53.value)));
j1array[0]=((((-1.0)*x50))+(((-1.0)*x51)));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
j1array[1]=((3.14159265358979)+x51+(((-1.0)*x50)));
sj1array[1]=IKsin(j1array[1]);
cj1array[1]=IKcos(j1array[1]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
if( j1array[1] > IKPI )
{
    j1array[1]-=IK2PI;
}
else if( j1array[1] < -IKPI )
{    j1array[1]+=IK2PI;
}
j1valid[1] = true;
for(int ij1 = 0; ij1 < 2; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 2; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];

{
IkReal j0eval[3];
IkReal x54=((19.0)*sj2);
IkReal x55=((25.0)*pz*sj1);
IkReal x56=(((cj1*pp))+(((-1.0)*cj1*(pz*pz))));
j0eval[0]=x56;
j0eval[1]=((IKabs((((py*x54))+((py*x55)))))+(IKabs(((((-1.0)*px*x54))+(((-1.0)*px*x55))))));
j0eval[2]=IKsign(x56);
if( IKabs(j0eval[0]) < 0.0000010000000000  || IKabs(j0eval[1]) < 0.0000010000000000  || IKabs(j0eval[2]) < 0.0000010000000000  )
{
{
IkReal j0eval[3];
IkReal x57=((38.0)*cj2);
IkReal x58=((50.0)*cj1*pz);
IkReal x59=(((pp*sj1))+(((-1.0)*sj1*(pz*pz))));
j0eval[0]=x59;
j0eval[1]=((IKabs(((((-35.0)*py))+(((-1.0)*py*x57))+(((-1.0)*py*x58)))))+(IKabs((((px*x58))+((px*x57))+(((35.0)*px))))));
j0eval[2]=IKsign(x59);
if( IKabs(j0eval[0]) < 0.0000010000000000  || IKabs(j0eval[1]) < 0.0000010000000000  || IKabs(j0eval[2]) < 0.0000010000000000  )
{
{
IkReal j0eval[3];
IkReal x60=pz*pz;
IkReal x61=((7.0)*sj1);
IkReal x62=((2500.0)*pp);
IkReal x63=((3500.0)*cj1*pz);
j0eval[0]=(((pp*sj1))+(((-1.0)*sj1*x60)));
j0eval[1]=((IKabs(((((219.0)*py))+(((-1.0)*py*x62))+(((-1.0)*py*x63)))))+(IKabs(((((-219.0)*px))+((px*x63))+((px*x62))))));
j0eval[2]=IKsign((((pp*x61))+(((-1.0)*x60*x61))));
if( IKabs(j0eval[0]) < 0.0000010000000000  || IKabs(j0eval[1]) < 0.0000010000000000  || IKabs(j0eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j1))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0eval[4];
sj1=0;
cj1=1.0;
j1=0;
IkReal x64=pz*pz;
j0eval[0]=((((-1.0)*pp))+x64);
j0eval[1]=361.0;
j0eval[2]=sj2;
j0eval[3]=IKsign(((((-25.0)*pp))+(((25.0)*x64))));
if( IKabs(j0eval[0]) < 0.0000010000000000  || IKabs(j0eval[1]) < 0.0000010000000000  || IKabs(j0eval[2]) < 0.0000010000000000  || IKabs(j0eval[3]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j2))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0eval[1];
sj1=0;
cj1=1.0;
j1=0;
sj2=0;
cj2=1.0;
j2=0;
j0eval[0]=((IKabs(px))+(IKabs(py)));
if( IKabs(j0eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j0]

} else
{
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
CheckValue<IkReal> x66 = IKatan2WithCheck(IkReal(((-1.0)*py)),IkReal(px),IKFAST_ATAN2_MAGTHRESH);
if(!x66.valid){
continue;
}
IkReal x65=x66.value;
j0array[0]=((-1.0)*x65);
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((3.14159265358979)+(((-1.0)*x65)));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[1];
evalcond[0]=((((-1.0)*py*(IKsin(j0))))+(((-1.0)*px*(IKcos(j0)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j2)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0eval[1];
sj1=0;
cj1=1.0;
j1=0;
sj2=0;
cj2=-1.0;
j2=3.14159265358979;
j0eval[0]=((IKabs(px))+(IKabs(py)));
if( IKabs(j0eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j0]

} else
{
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
CheckValue<IkReal> x840 = IKatan2WithCheck(IkReal(((-1.0)*py)),IkReal(px),IKFAST_ATAN2_MAGTHRESH);
if(!x840.valid){
continue;
}
IkReal x839=x840.value;
j0array[0]=((-1.0)*x839);
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((3.14159265358979)+(((-1.0)*x839)));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[1];
evalcond[0]=((((-1.0)*py*(IKsin(j0))))+(((-1.0)*px*(IKcos(j0)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j0]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
CheckValue<IkReal> x841 = IKatan2WithCheck(IkReal(((19.0)*px*sj2)),IkReal(((-19.0)*py*sj2)),IKFAST_ATAN2_MAGTHRESH);
if(!x841.valid){
continue;
}
CheckValue<IkReal> x842=IKPowWithIntegerCheck(IKsign(((((25.0)*(pz*pz)))+(((-25.0)*pp)))),-1);
if(!x842.valid){
continue;
}
j0array[0]=((-1.5707963267949)+(x841.value)+(((1.5707963267949)*(x842.value))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[2];
IkReal x843=IKsin(j0);
IkReal x844=IKcos(j0);
IkReal x845=((1.0)*x844);
evalcond[0]=((((-1.0)*px*x845))+(((-1.0)*py*x843)));
evalcond[1]=((((-1.0)*py*x845))+(((0.76)*sj2))+((px*x843)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j1)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0eval[4];
sj1=0;
cj1=-1.0;
j1=3.14159265358979;
IkReal x846=pz*pz;
j0eval[0]=(pp+(((-1.0)*x846)));
j0eval[1]=361.0;
j0eval[2]=sj2;
j0eval[3]=IKsign(((((25.0)*pp))+(((-25.0)*x846))));
if( IKabs(j0eval[0]) < 0.0000010000000000  || IKabs(j0eval[1]) < 0.0000010000000000  || IKabs(j0eval[2]) < 0.0000010000000000  || IKabs(j0eval[3]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j2))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0eval[1];
sj1=0;
cj1=-1.0;
j1=3.14159265358979;
sj2=0;
cj2=1.0;
j2=0;
j0eval[0]=((IKabs(px))+(IKabs(py)));
if( IKabs(j0eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j0]

} else
{
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
CheckValue<IkReal> x848 = IKatan2WithCheck(IkReal(py),IkReal(((-1.0)*px)),IKFAST_ATAN2_MAGTHRESH);
if(!x848.valid){
continue;
}
IkReal x847=x848.value;
j0array[0]=((-1.0)*x847);
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((3.14159265358979)+(((-1.0)*x847)));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[1];
evalcond[0]=((((-1.0)*py*(IKsin(j0))))+(((-1.0)*px*(IKcos(j0)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j2)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0eval[1];
sj1=0;
cj1=-1.0;
j1=3.14159265358979;
sj2=0;
cj2=-1.0;
j2=3.14159265358979;
j0eval[0]=((IKabs(px))+(IKabs(py)));
if( IKabs(j0eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j0]

} else
{
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
CheckValue<IkReal> x850 = IKatan2WithCheck(IkReal(py),IkReal(((-1.0)*px)),IKFAST_ATAN2_MAGTHRESH);
if(!x850.valid){
continue;
}
IkReal x849=x850.value;
j0array[0]=((-1.0)*x849);
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((3.14159265358979)+(((-1.0)*x849)));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[1];
evalcond[0]=((((-1.0)*py*(IKsin(j0))))+(((-1.0)*px*(IKcos(j0)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j0]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
CheckValue<IkReal> x851 = IKatan2WithCheck(IkReal(((19.0)*px*sj2)),IkReal(((-19.0)*py*sj2)),IKFAST_ATAN2_MAGTHRESH);
if(!x851.valid){
continue;
}
CheckValue<IkReal> x852=IKPowWithIntegerCheck(IKsign(((((25.0)*pp))+(((-25.0)*(pz*pz))))),-1);
if(!x852.valid){
continue;
}
j0array[0]=((-1.5707963267949)+(x851.value)+(((1.5707963267949)*(x852.value))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[2];
IkReal x853=IKcos(j0);
IkReal x854=IKsin(j0);
IkReal x855=((1.0)*px);
evalcond[0]=((((-1.0)*x853*x855))+(((-1.0)*py*x854)));
evalcond[1]=((((0.76)*sj2))+((py*x853))+(((-1.0)*x854*x855)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j1)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0eval[3];
sj1=1.0;
cj1=0;
j1=1.5707963267949;
IkReal x856=((2500.0)*pp);
IkReal x857=(pp+(((-1.0)*(pz*pz))));
j0eval[0]=x857;
j0eval[1]=((IKabs(((((219.0)*py))+(((-1.0)*py*x856)))))+(IKabs(((((-219.0)*px))+((px*x856))))));
j0eval[2]=IKsign(x857);
if( IKabs(j0eval[0]) < 0.0000010000000000  || IKabs(j0eval[1]) < 0.0000010000000000  || IKabs(j0eval[2]) < 0.0000010000000000  )
{
{
IkReal j0eval[3];
sj1=1.0;
cj1=0;
j1=1.5707963267949;
IkReal x858=pz*pz;
IkReal x859=((2500.0)*pp);
j0eval[0]=((((-1.0)*pp))+x858);
j0eval[1]=((IKabs(((((219.0)*px))+(((-1.0)*px*x859)))))+(IKabs(((((-219.0)*py))+((py*x859))))));
j0eval[2]=IKsign(((((-7.0)*pp))+(((7.0)*x858))));
if( IKabs(j0eval[0]) < 0.0000010000000000  || IKabs(j0eval[1]) < 0.0000010000000000  || IKabs(j0eval[2]) < 0.0000010000000000  )
{
continue; // no branches [j0]

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x860=((5.0)*pp);
CheckValue<IkReal> x861 = IKatan2WithCheck(IkReal(((((0.438)*px))+(((-1.0)*px*x860)))),IkReal(((((-0.438)*py))+((py*x860)))),IKFAST_ATAN2_MAGTHRESH);
if(!x861.valid){
continue;
}
CheckValue<IkReal> x862=IKPowWithIntegerCheck(IKsign(((((-7.0)*pp))+(((7.0)*(pz*pz))))),-1);
if(!x862.valid){
continue;
}
j0array[0]=((-1.5707963267949)+(x861.value)+(((1.5707963267949)*(x862.value))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[3];
IkReal x863=IKcos(j0);
IkReal x864=IKsin(j0);
IkReal x865=((1.0)*px);
IkReal x866=(py*x863);
evalcond[0]=((((-1.0)*py*x864))+(((-1.0)*x863*x865)));
evalcond[1]=((-0.0625714285714286)+(((0.714285714285714)*pp))+(((-1.0)*x864*x865))+x866);
evalcond[2]=((0.0876)+(((-1.4)*x866))+(((1.4)*px*x864))+(((-1.0)*pp)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x867=((0.714285714285714)*pp);
CheckValue<IkReal> x868=IKPowWithIntegerCheck(IKsign((pp+(((-1.0)*(pz*pz))))),-1);
if(!x868.valid){
continue;
}
CheckValue<IkReal> x869 = IKatan2WithCheck(IkReal(((((-0.0625714285714286)*px))+((px*x867)))),IkReal(((((-1.0)*py*x867))+(((0.0625714285714286)*py)))),IKFAST_ATAN2_MAGTHRESH);
if(!x869.valid){
continue;
}
j0array[0]=((-1.5707963267949)+(((1.5707963267949)*(x868.value)))+(x869.value));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[3];
IkReal x870=IKcos(j0);
IkReal x871=IKsin(j0);
IkReal x872=((1.0)*px);
IkReal x873=(py*x870);
evalcond[0]=((((-1.0)*py*x871))+(((-1.0)*x870*x872)));
evalcond[1]=((-0.0625714285714286)+(((-1.0)*x871*x872))+(((0.714285714285714)*pp))+x873);
evalcond[2]=((0.0876)+(((-1.4)*x873))+(((1.4)*px*x871))+(((-1.0)*pp)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j1)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0eval[3];
sj1=-1.0;
cj1=0;
j1=-1.5707963267949;
IkReal x874=((2500.0)*pp);
IkReal x875=((((-1.0)*pp))+(pz*pz));
j0eval[0]=x875;
j0eval[1]=((IKabs(((((-1.0)*py*x874))+(((219.0)*py)))))+(IKabs(((((-219.0)*px))+((px*x874))))));
j0eval[2]=IKsign(x875);
if( IKabs(j0eval[0]) < 0.0000010000000000  || IKabs(j0eval[1]) < 0.0000010000000000  || IKabs(j0eval[2]) < 0.0000010000000000  )
{
{
IkReal j0eval[3];
sj1=-1.0;
cj1=0;
j1=-1.5707963267949;
IkReal x876=pz*pz;
IkReal x877=((2500.0)*pp);
j0eval[0]=((((-1.0)*x876))+pp);
j0eval[1]=IKsign(((((-7.0)*x876))+(((7.0)*pp))));
j0eval[2]=((IKabs(((((-219.0)*py))+((py*x877)))))+(IKabs(((((219.0)*px))+(((-1.0)*px*x877))))));
if( IKabs(j0eval[0]) < 0.0000010000000000  || IKabs(j0eval[1]) < 0.0000010000000000  || IKabs(j0eval[2]) < 0.0000010000000000  )
{
continue; // no branches [j0]

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x878=((5.0)*pp);
CheckValue<IkReal> x879=IKPowWithIntegerCheck(IKsign(((((-7.0)*(pz*pz)))+(((7.0)*pp)))),-1);
if(!x879.valid){
continue;
}
CheckValue<IkReal> x880 = IKatan2WithCheck(IkReal(((((0.438)*px))+(((-1.0)*px*x878)))),IkReal(((((-0.438)*py))+((py*x878)))),IKFAST_ATAN2_MAGTHRESH);
if(!x880.valid){
continue;
}
j0array[0]=((-1.5707963267949)+(((1.5707963267949)*(x879.value)))+(x880.value));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[3];
IkReal x881=IKsin(j0);
IkReal x882=IKcos(j0);
IkReal x883=(px*x881);
IkReal x884=((1.0)*x882);
evalcond[0]=((((-1.0)*py*x881))+(((-1.0)*px*x884)));
evalcond[1]=((-0.0625714285714286)+(((0.714285714285714)*pp))+(((-1.0)*py*x884))+x883);
evalcond[2]=((0.0876)+(((-1.0)*pp))+(((-1.4)*x883))+(((1.4)*py*x882)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x885=((0.714285714285714)*pp);
CheckValue<IkReal> x886=IKPowWithIntegerCheck(IKsign(((((-1.0)*pp))+(pz*pz))),-1);
if(!x886.valid){
continue;
}
CheckValue<IkReal> x887 = IKatan2WithCheck(IkReal((((px*x885))+(((-0.0625714285714286)*px)))),IkReal(((((-1.0)*py*x885))+(((0.0625714285714286)*py)))),IKFAST_ATAN2_MAGTHRESH);
if(!x887.valid){
continue;
}
j0array[0]=((-1.5707963267949)+(((1.5707963267949)*(x886.value)))+(x887.value));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[3];
IkReal x888=IKsin(j0);
IkReal x889=IKcos(j0);
IkReal x890=(px*x888);
IkReal x891=((1.0)*x889);
evalcond[0]=((((-1.0)*px*x891))+(((-1.0)*py*x888)));
evalcond[1]=((-0.0625714285714286)+(((-1.0)*py*x891))+(((0.714285714285714)*pp))+x890);
evalcond[2]=((0.0876)+(((-1.0)*pp))+(((-1.4)*x890))+(((1.4)*py*x889)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(pz))+(IKabs(((-3.14159265358979)+(IKfmod(((3.14159265358979)+j2), 6.28318530717959))))));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0eval[3];
IkReal x892=((-1.0)*py);
pz=0;
j2=0;
sj2=0;
cj2=1.0;
pp=((px*px)+(py*py));
npx=(((px*r00))+((py*r10)));
npy=(((px*r01))+((py*r11)));
npz=(((px*r02))+((py*r12)));
rxp0_0=(r20*x892);
rxp0_1=(px*r20);
rxp1_0=(r21*x892);
rxp1_1=(px*r21);
rxp2_0=(r22*x892);
rxp2_1=(px*r22);
IkReal x893=px*px;
IkReal x894=py*py;
IkReal x895=((50.0)*sj1);
j0eval[0]=(((sj1*x893))+((sj1*x894)));
j0eval[1]=IKsign((((x894*x895))+((x893*x895))));
j0eval[2]=((IKabs(px))+(IKabs(py)));
if( IKabs(j0eval[0]) < 0.0000010000000000  || IKabs(j0eval[1]) < 0.0000010000000000  || IKabs(j0eval[2]) < 0.0000010000000000  )
{
{
IkReal j0eval[4];
IkReal x896=((-1.0)*py);
pz=0;
j2=0;
sj2=0;
cj2=1.0;
pp=((px*px)+(py*py));
npx=(((px*r00))+((py*r10)));
npy=(((px*r01))+((py*r11)));
npz=(((px*r02))+((py*r12)));
rxp0_0=(r20*x896);
rxp0_1=(px*r20);
rxp1_0=(r21*x896);
rxp1_1=(px*r21);
rxp2_0=(r22*x896);
rxp2_1=(px*r22);
IkReal x897=py*py;
IkReal x898=px*px;
j0eval[0]=(x897+x898);
j0eval[1]=IKsign(((((50.0)*x897))+(((50.0)*x898))));
j0eval[2]=5329.0;
j0eval[3]=sj1;
if( IKabs(j0eval[0]) < 0.0000010000000000  || IKabs(j0eval[1]) < 0.0000010000000000  || IKabs(j0eval[2]) < 0.0000010000000000  || IKabs(j0eval[3]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j1))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0eval[1];
IkReal x899=((-1.0)*py);
pz=0;
j2=0;
sj2=0;
cj2=1.0;
pp=((px*px)+(py*py));
npx=(((px*r00))+((py*r10)));
npy=(((px*r01))+((py*r11)));
npz=(((px*r02))+((py*r12)));
rxp0_0=(r20*x899);
rxp0_1=(px*r20);
rxp1_0=(r21*x899);
rxp1_1=(px*r21);
rxp2_0=(r22*x899);
rxp2_1=(px*r22);
sj1=0;
cj1=1.0;
j1=0;
j0eval[0]=((IKabs(px))+(IKabs(py)));
if( IKabs(j0eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j0]

} else
{
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
CheckValue<IkReal> x901 = IKatan2WithCheck(IkReal(py),IkReal(((-1.0)*px)),IKFAST_ATAN2_MAGTHRESH);
if(!x901.valid){
continue;
}
IkReal x900=x901.value;
j0array[0]=((-1.0)*x900);
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((3.14159265358979)+(((-1.0)*x900)));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[1];
evalcond[0]=((((-1.0)*py*(IKsin(j0))))+(((-1.0)*px*(IKcos(j0)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j1)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0eval[1];
IkReal x902=((-1.0)*py);
pz=0;
j2=0;
sj2=0;
cj2=1.0;
pp=((px*px)+(py*py));
npx=(((px*r00))+((py*r10)));
npy=(((px*r01))+((py*r11)));
npz=(((px*r02))+((py*r12)));
rxp0_0=(r20*x902);
rxp0_1=(px*r20);
rxp1_0=(r21*x902);
rxp1_1=(px*r21);
rxp2_0=(r22*x902);
rxp2_1=(px*r22);
sj1=0;
cj1=-1.0;
j1=3.14159265358979;
j0eval[0]=((IKabs(px))+(IKabs(py)));
if( IKabs(j0eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j0]

} else
{
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
CheckValue<IkReal> x904 = IKatan2WithCheck(IkReal(py),IkReal(((-1.0)*px)),IKFAST_ATAN2_MAGTHRESH);
if(!x904.valid){
continue;
}
IkReal x903=x904.value;
j0array[0]=((-1.0)*x903);
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((3.14159265358979)+(((-1.0)*x903)));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[1];
evalcond[0]=((((-1.0)*py*(IKsin(j0))))+(((-1.0)*px*(IKcos(j0)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j0]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
CheckValue<IkReal> x905=IKPowWithIntegerCheck(IKsign(((((50.0)*(py*py)))+(((50.0)*(px*px))))),-1);
if(!x905.valid){
continue;
}
CheckValue<IkReal> x906 = IKatan2WithCheck(IkReal(((73.0)*px*sj1)),IkReal(((-73.0)*py*sj1)),IKFAST_ATAN2_MAGTHRESH);
if(!x906.valid){
continue;
}
j0array[0]=((-1.5707963267949)+(((1.5707963267949)*(x905.value)))+(x906.value));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x907=IKcos(j0);
IkReal x908=IKsin(j0);
IkReal x909=((1.0)*px);
IkReal x910=(sj1*x908);
IkReal x911=(py*x907);
evalcond[0]=((((-1.0)*py*x908))+(((-1.0)*x907*x909)));
evalcond[1]=((1.46)+((sj1*x911))+(((-1.0)*x909*x910)));
evalcond[2]=((((-1.0)*x908*x909))+(((1.46)*sj1))+x911);
evalcond[3]=((-2.044)+(((-1.4)*sj1*x911))+(((1.4)*px*x910)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x912=((50.0)*sj1);
CheckValue<IkReal> x913=IKPowWithIntegerCheck(IKsign((((x912*(py*py)))+((x912*(px*px))))),-1);
if(!x913.valid){
continue;
}
CheckValue<IkReal> x914 = IKatan2WithCheck(IkReal(((73.0)*px)),IkReal(((-73.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x914.valid){
continue;
}
j0array[0]=((-1.5707963267949)+(((1.5707963267949)*(x913.value)))+(x914.value));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x915=IKcos(j0);
IkReal x916=IKsin(j0);
IkReal x917=((1.0)*px);
IkReal x918=(sj1*x916);
IkReal x919=(py*x915);
evalcond[0]=((((-1.0)*py*x916))+(((-1.0)*x915*x917)));
evalcond[1]=((1.46)+((sj1*x919))+(((-1.0)*x917*x918)));
evalcond[2]=((((1.46)*sj1))+x919+(((-1.0)*x916*x917)));
evalcond[3]=((-2.044)+(((-1.4)*sj1*x919))+(((1.4)*px*x918)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(pz))+(IKabs(((-3.14159265358979)+(IKfmod(j2, 6.28318530717959))))));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0eval[3];
IkReal x920=((-1.0)*py);
pz=0;
j2=3.14159265358979;
sj2=0;
cj2=-1.0;
pp=((px*px)+(py*py));
npx=(((px*r00))+((py*r10)));
npy=(((px*r01))+((py*r11)));
npz=(((px*r02))+((py*r12)));
rxp0_0=(r20*x920);
rxp0_1=(px*r20);
rxp1_0=(r21*x920);
rxp1_1=(px*r21);
rxp2_0=(r22*x920);
rxp2_1=(px*r22);
IkReal x921=px*px;
IkReal x922=py*py;
IkReal x923=((50.0)*sj1);
j0eval[0]=(((sj1*x921))+((sj1*x922)));
j0eval[1]=IKsign((((x921*x923))+((x922*x923))));
j0eval[2]=((IKabs(px))+(IKabs(py)));
if( IKabs(j0eval[0]) < 0.0000010000000000  || IKabs(j0eval[1]) < 0.0000010000000000  || IKabs(j0eval[2]) < 0.0000010000000000  )
{
{
IkReal j0eval[4];
IkReal x924=((-1.0)*py);
pz=0;
j2=3.14159265358979;
sj2=0;
cj2=-1.0;
pp=((px*px)+(py*py));
npx=(((px*r00))+((py*r10)));
npy=(((px*r01))+((py*r11)));
npz=(((px*r02))+((py*r12)));
rxp0_0=(r20*x924);
rxp0_1=(px*r20);
rxp1_0=(r21*x924);
rxp1_1=(px*r21);
rxp2_0=(r22*x924);
rxp2_1=(px*r22);
IkReal x925=py*py;
IkReal x926=px*px;
j0eval[0]=((((-1.0)*x925))+(((-1.0)*x926)));
j0eval[1]=IKsign(((((-50.0)*x926))+(((-50.0)*x925))));
j0eval[2]=9.0;
j0eval[3]=sj1;
if( IKabs(j0eval[0]) < 0.0000010000000000  || IKabs(j0eval[1]) < 0.0000010000000000  || IKabs(j0eval[2]) < 0.0000010000000000  || IKabs(j0eval[3]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j1))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0eval[1];
IkReal x927=((-1.0)*py);
pz=0;
j2=3.14159265358979;
sj2=0;
cj2=-1.0;
pp=((px*px)+(py*py));
npx=(((px*r00))+((py*r10)));
npy=(((px*r01))+((py*r11)));
npz=(((px*r02))+((py*r12)));
rxp0_0=(r20*x927);
rxp0_1=(px*r20);
rxp1_0=(r21*x927);
rxp1_1=(px*r21);
rxp2_0=(r22*x927);
rxp2_1=(px*r22);
sj1=0;
cj1=1.0;
j1=0;
j0eval[0]=((IKabs(px))+(IKabs(py)));
if( IKabs(j0eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j0]

} else
{
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
CheckValue<IkReal> x929 = IKatan2WithCheck(IkReal(py),IkReal(((-1.0)*px)),IKFAST_ATAN2_MAGTHRESH);
if(!x929.valid){
continue;
}
IkReal x928=x929.value;
j0array[0]=((-1.0)*x928);
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((3.14159265358979)+(((-1.0)*x928)));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[1];
evalcond[0]=((((-1.0)*py*(IKsin(j0))))+(((-1.0)*px*(IKcos(j0)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j1)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j0eval[1];
IkReal x930=((-1.0)*py);
pz=0;
j2=3.14159265358979;
sj2=0;
cj2=-1.0;
pp=((px*px)+(py*py));
npx=(((px*r00))+((py*r10)));
npy=(((px*r01))+((py*r11)));
npz=(((px*r02))+((py*r12)));
rxp0_0=(r20*x930);
rxp0_1=(px*r20);
rxp1_0=(r21*x930);
rxp1_1=(px*r21);
rxp2_0=(r22*x930);
rxp2_1=(px*r22);
sj1=0;
cj1=-1.0;
j1=3.14159265358979;
j0eval[0]=((IKabs(px))+(IKabs(py)));
if( IKabs(j0eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j0]

} else
{
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
CheckValue<IkReal> x932 = IKatan2WithCheck(IkReal(py),IkReal(((-1.0)*px)),IKFAST_ATAN2_MAGTHRESH);
if(!x932.valid){
continue;
}
IkReal x931=x932.value;
j0array[0]=((-1.0)*x931);
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((3.14159265358979)+(((-1.0)*x931)));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[1];
evalcond[0]=((((-1.0)*py*(IKsin(j0))))+(((-1.0)*px*(IKcos(j0)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j0]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
CheckValue<IkReal> x933=IKPowWithIntegerCheck(IKsign(((((-50.0)*(py*py)))+(((-50.0)*(px*px))))),-1);
if(!x933.valid){
continue;
}
CheckValue<IkReal> x934 = IKatan2WithCheck(IkReal(((3.0)*px*sj1)),IkReal(((-3.0)*py*sj1)),IKFAST_ATAN2_MAGTHRESH);
if(!x934.valid){
continue;
}
j0array[0]=((-1.5707963267949)+(((1.5707963267949)*(x933.value)))+(x934.value));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x935=IKcos(j0);
IkReal x936=IKsin(j0);
IkReal x937=((1.0)*px);
IkReal x938=(sj1*x936);
IkReal x939=(py*x935);
evalcond[0]=((((-1.0)*x935*x937))+(((-1.0)*py*x936)));
evalcond[1]=((-0.06)+((sj1*x939))+(((-1.0)*x937*x938)));
evalcond[2]=((((-0.06)*sj1))+(((-1.0)*x936*x937))+x939);
evalcond[3]=((0.084)+(((1.4)*px*x938))+(((-1.4)*sj1*x939)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x940=((50.0)*sj1);
CheckValue<IkReal> x941 = IKatan2WithCheck(IkReal(((-3.0)*px)),IkReal(((3.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x941.valid){
continue;
}
CheckValue<IkReal> x942=IKPowWithIntegerCheck(IKsign((((x940*(px*px)))+((x940*(py*py))))),-1);
if(!x942.valid){
continue;
}
j0array[0]=((-1.5707963267949)+(x941.value)+(((1.5707963267949)*(x942.value))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x943=IKcos(j0);
IkReal x944=IKsin(j0);
IkReal x945=((1.0)*px);
IkReal x946=(sj1*x944);
IkReal x947=(py*x943);
evalcond[0]=((((-1.0)*x943*x945))+(((-1.0)*py*x944)));
evalcond[1]=((-0.06)+(((-1.0)*x945*x946))+((sj1*x947)));
evalcond[2]=((((-0.06)*sj1))+(((-1.0)*x944*x945))+x947);
evalcond[3]=((0.084)+(((-1.4)*sj1*x947))+(((1.4)*px*x946)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j0]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x948=((7.0)*sj1);
IkReal x949=((5.0)*pp);
IkReal x950=((7.0)*cj1*pz);
CheckValue<IkReal> x951=IKPowWithIntegerCheck(IKsign((((pp*x948))+(((-1.0)*x948*(pz*pz))))),-1);
if(!x951.valid){
continue;
}
CheckValue<IkReal> x952 = IKatan2WithCheck(IkReal((((px*x950))+(((-0.438)*px))+((px*x949)))),IkReal(((((-1.0)*py*x949))+(((-1.0)*py*x950))+(((0.438)*py)))),IKFAST_ATAN2_MAGTHRESH);
if(!x952.valid){
continue;
}
j0array[0]=((-1.5707963267949)+(((1.5707963267949)*(x951.value)))+(x952.value));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[5];
IkReal x953=IKsin(j0);
IkReal x954=IKcos(j0);
IkReal x955=(cj1*pz);
IkReal x956=((0.76)*cj2);
IkReal x957=((0.76)*sj2);
IkReal x958=(px*sj1);
IkReal x959=((1.0)*x954);
IkReal x960=((1.0)*x953);
IkReal x961=(py*sj1*x954);
evalcond[0]=((((-1.0)*py*x960))+(((-1.0)*px*x959)));
evalcond[1]=(((cj1*px*x953))+(((-1.0)*cj1*py*x959))+((pz*sj1))+x957);
evalcond[2]=((0.7)+(((-1.0)*x958*x960))+x961+x956+x955);
evalcond[3]=((0.0876)+(((-1.4)*x961))+(((-1.4)*x955))+(((-1.0)*pp))+(((1.4)*x953*x958)));
evalcond[4]=((((0.7)*sj1))+(((-1.0)*cj1*x957))+((py*x954))+((sj1*x956))+(((-1.0)*px*x960)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x962=((0.76)*cj2);
IkReal x963=(cj1*pz);
CheckValue<IkReal> x964 = IKatan2WithCheck(IkReal((((px*x962))+((px*x963))+(((0.7)*px)))),IkReal(((((-0.7)*py))+(((-1.0)*py*x962))+(((-1.0)*py*x963)))),IKFAST_ATAN2_MAGTHRESH);
if(!x964.valid){
continue;
}
CheckValue<IkReal> x965=IKPowWithIntegerCheck(IKsign((((pp*sj1))+(((-1.0)*sj1*(pz*pz))))),-1);
if(!x965.valid){
continue;
}
j0array[0]=((-1.5707963267949)+(x964.value)+(((1.5707963267949)*(x965.value))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[5];
IkReal x966=IKsin(j0);
IkReal x967=IKcos(j0);
IkReal x968=(cj1*pz);
IkReal x969=((0.76)*cj2);
IkReal x970=((0.76)*sj2);
IkReal x971=(px*sj1);
IkReal x972=((1.0)*x967);
IkReal x973=((1.0)*x966);
IkReal x974=(py*sj1*x967);
evalcond[0]=((((-1.0)*px*x972))+(((-1.0)*py*x973)));
evalcond[1]=(((cj1*px*x966))+((pz*sj1))+x970+(((-1.0)*cj1*py*x972)));
evalcond[2]=((0.7)+(((-1.0)*x971*x973))+x974+x968+x969);
evalcond[3]=((0.0876)+(((-1.4)*x968))+(((-1.4)*x974))+(((-1.0)*pp))+(((1.4)*x966*x971)));
evalcond[4]=((((-1.0)*px*x973))+(((0.7)*sj1))+(((-1.0)*cj1*x970))+((py*x967))+((sj1*x969)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x975=(pz*sj1);
IkReal x976=((0.76)*sj2);
CheckValue<IkReal> x977=IKPowWithIntegerCheck(IKsign((((cj1*pp))+(((-1.0)*cj1*(pz*pz))))),-1);
if(!x977.valid){
continue;
}
CheckValue<IkReal> x978 = IKatan2WithCheck(IkReal(((((-1.0)*px*x976))+(((-1.0)*px*x975)))),IkReal((((py*x975))+((py*x976)))),IKFAST_ATAN2_MAGTHRESH);
if(!x978.valid){
continue;
}
j0array[0]=((-1.5707963267949)+(((1.5707963267949)*(x977.value)))+(x978.value));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[5];
IkReal x979=IKsin(j0);
IkReal x980=IKcos(j0);
IkReal x981=(cj1*pz);
IkReal x982=((0.76)*cj2);
IkReal x983=((0.76)*sj2);
IkReal x984=(px*sj1);
IkReal x985=((1.0)*x980);
IkReal x986=((1.0)*x979);
IkReal x987=(py*sj1*x980);
evalcond[0]=((((-1.0)*px*x985))+(((-1.0)*py*x986)));
evalcond[1]=(((cj1*px*x979))+((pz*sj1))+(((-1.0)*cj1*py*x985))+x983);
evalcond[2]=((0.7)+(((-1.0)*x984*x986))+x987+x981+x982);
evalcond[3]=((0.0876)+(((1.4)*x979*x984))+(((-1.4)*x987))+(((-1.4)*x981))+(((-1.0)*pp)));
evalcond[4]=((((-1.0)*cj1*x983))+(((-1.0)*px*x986))+(((0.7)*sj1))+((sj1*x982))+((py*x980)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}

}

} else
{
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
CheckValue<IkReal> x989 = IKatan2WithCheck(IkReal(((-1.0)*px)),IkReal(((-1.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x989.valid){
continue;
}
IkReal x988=x989.value;
j0array[0]=((-1.0)*x988);
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((3.14159265358979)+(((-1.0)*x988)));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];

{
IkReal j1eval[3];
IkReal x990=((475.0)*cj2);
IkReal x991=(cj0*py);
IkReal x992=(px*sj0);
IkReal x993=((475.0)*sj2);
j1eval[0]=((-1.00338345864662)+(((-1.0)*cj2)));
j1eval[1]=((IKabs(((((437.5)*x991))+((pz*x993))+((x990*x991))+(((-437.5)*x992))+(((-1.0)*x990*x992)))))+(IKabs((((x992*x993))+(((-1.0)*x991*x993))+((pz*x990))+(((437.5)*pz))))));
j1eval[2]=IKsign(((-667.25)+(((-665.0)*cj2))));
if( IKabs(j1eval[0]) < 0.0000010000000000  || IKabs(j1eval[1]) < 0.0000010000000000  || IKabs(j1eval[2]) < 0.0000010000000000  )
{
{
IkReal j1eval[3];
IkReal x994=(px*sj0);
IkReal x995=((1.08571428571429)*cj2);
IkReal x996=(cj0*py);
IkReal x997=(pz*sj2);
IkReal x998=((19.0)*cj2);
IkReal x999=((25.0)*pz);
j1eval[0]=((((-1.0)*x994))+(((-1.0)*x994*x995))+(((-1.08571428571429)*x997))+((x995*x996))+x996);
j1eval[1]=IKsign(((((-1.0)*x994*x998))+(((-19.0)*x997))+(((17.5)*x996))+(((-17.5)*x994))+((x996*x998))));
j1eval[2]=((IKabs((((x994*x999))+(((14.44)*cj2*sj2))+(((-1.0)*x996*x999))+(((13.3)*sj2)))))+(IKabs(((-12.25)+((pz*x999))+(((-14.44)*(cj2*cj2)))+(((-26.6)*cj2))))));
if( IKabs(j1eval[0]) < 0.0000010000000000  || IKabs(j1eval[1]) < 0.0000010000000000  || IKabs(j1eval[2]) < 0.0000010000000000  )
{
{
IkReal j1eval[3];
IkReal x1000=((1.08571428571429)*cj2);
IkReal x1001=(px*sj0);
IkReal x1002=(cj0*py);
IkReal x1003=(pz*sj2);
IkReal x1004=((133.0)*cj2);
IkReal x1005=((175.0)*pz);
IkReal x1006=((95.0)*pp);
j1eval[0]=((((-1.0)*x1001))+x1002+(((-1.08571428571429)*x1003))+((x1000*x1002))+(((-1.0)*x1000*x1001)));
j1eval[1]=((IKabs((((sj2*x1006))+(((-8.322)*sj2))+(((-1.0)*x1002*x1005))+((x1001*x1005)))))+(IKabs(((7.665)+(((-87.5)*pp))+((pz*x1005))+(((-1.0)*cj2*x1006))+(((8.322)*cj2))))));
j1eval[2]=IKsign(((((-122.5)*x1001))+(((-133.0)*x1003))+(((-1.0)*x1001*x1004))+(((122.5)*x1002))+((x1002*x1004))));
if( IKabs(j1eval[0]) < 0.0000010000000000  || IKabs(j1eval[1]) < 0.0000010000000000  || IKabs(j1eval[2]) < 0.0000010000000000  )
{
continue; // no branches [j1]

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1007=(px*sj0);
IkReal x1008=((133.0)*cj2);
IkReal x1009=(cj0*py);
IkReal x1010=((175.0)*pz);
IkReal x1011=((95.0)*pp);
CheckValue<IkReal> x1012=IKPowWithIntegerCheck(IKsign((((x1008*x1009))+(((-122.5)*x1007))+(((-1.0)*x1007*x1008))+(((122.5)*x1009))+(((-133.0)*pz*sj2)))),-1);
if(!x1012.valid){
continue;
}
CheckValue<IkReal> x1013 = IKatan2WithCheck(IkReal(((7.665)+(((-87.5)*pp))+(((-1.0)*cj2*x1011))+((pz*x1010))+(((8.322)*cj2)))),IkReal(((((-1.0)*x1009*x1010))+((sj2*x1011))+(((-8.322)*sj2))+((x1007*x1010)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1013.valid){
continue;
}
j1array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1012.value)))+(x1013.value));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[5];
IkReal x1014=IKcos(j1);
IkReal x1015=IKsin(j1);
IkReal x1016=((0.76)*sj2);
IkReal x1017=(px*sj0);
IkReal x1018=(cj0*py);
IkReal x1019=((0.76)*cj2);
IkReal x1020=(pz*x1014);
IkReal x1021=(x1015*x1018);
evalcond[0]=(((x1014*x1019))+(((0.7)*x1014))+pz+((x1015*x1016)));
evalcond[1]=(((x1014*x1017))+x1016+(((-1.0)*x1014*x1018))+((pz*x1015)));
evalcond[2]=((0.7)+x1019+x1021+x1020+(((-1.0)*x1015*x1017)));
evalcond[3]=((0.0876)+(((1.4)*x1015*x1017))+(((-1.0)*pp))+(((-1.4)*x1021))+(((-1.4)*x1020)));
evalcond[4]=((((0.7)*x1015))+x1018+(((-1.0)*x1014*x1016))+((x1015*x1019))+(((-1.0)*x1017)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1022=(px*sj0);
IkReal x1023=(cj0*py);
IkReal x1024=((19.0)*cj2);
IkReal x1025=((25.0)*pz);
CheckValue<IkReal> x1026=IKPowWithIntegerCheck(IKsign(((((-1.0)*x1022*x1024))+(((-17.5)*x1022))+((x1023*x1024))+(((-19.0)*pz*sj2))+(((17.5)*x1023)))),-1);
if(!x1026.valid){
continue;
}
CheckValue<IkReal> x1027 = IKatan2WithCheck(IkReal(((-12.25)+(((-14.44)*(cj2*cj2)))+(((-26.6)*cj2))+((pz*x1025)))),IkReal(((((-1.0)*x1023*x1025))+(((14.44)*cj2*sj2))+(((13.3)*sj2))+((x1022*x1025)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1027.valid){
continue;
}
j1array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1026.value)))+(x1027.value));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[5];
IkReal x1028=IKcos(j1);
IkReal x1029=IKsin(j1);
IkReal x1030=((0.76)*sj2);
IkReal x1031=(px*sj0);
IkReal x1032=(cj0*py);
IkReal x1033=((0.76)*cj2);
IkReal x1034=(pz*x1028);
IkReal x1035=(x1029*x1032);
evalcond[0]=(((x1028*x1033))+((x1029*x1030))+pz+(((0.7)*x1028)));
evalcond[1]=(x1030+((x1028*x1031))+((pz*x1029))+(((-1.0)*x1028*x1032)));
evalcond[2]=((0.7)+(((-1.0)*x1029*x1031))+x1033+x1034+x1035);
evalcond[3]=((0.0876)+(((1.4)*x1029*x1031))+(((-1.4)*x1034))+(((-1.4)*x1035))+(((-1.0)*pp)));
evalcond[4]=((((-1.0)*x1028*x1030))+x1032+(((-1.0)*x1031))+((x1029*x1033))+(((0.7)*x1029)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1036=((475.0)*cj2);
IkReal x1037=(px*sj0);
IkReal x1038=(cj0*py);
IkReal x1039=((475.0)*sj2);
CheckValue<IkReal> x1040 = IKatan2WithCheck(IkReal((((x1036*x1038))+(((437.5)*x1038))+(((-1.0)*x1036*x1037))+((pz*x1039))+(((-437.5)*x1037)))),IkReal(((((-1.0)*x1038*x1039))+((pz*x1036))+((x1037*x1039))+(((437.5)*pz)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1040.valid){
continue;
}
CheckValue<IkReal> x1041=IKPowWithIntegerCheck(IKsign(((-667.25)+(((-665.0)*cj2)))),-1);
if(!x1041.valid){
continue;
}
j1array[0]=((-1.5707963267949)+(x1040.value)+(((1.5707963267949)*(x1041.value))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[5];
IkReal x1042=IKcos(j1);
IkReal x1043=IKsin(j1);
IkReal x1044=((0.76)*sj2);
IkReal x1045=(px*sj0);
IkReal x1046=(cj0*py);
IkReal x1047=((0.76)*cj2);
IkReal x1048=(pz*x1042);
IkReal x1049=(x1043*x1046);
evalcond[0]=(((x1042*x1047))+((x1043*x1044))+(((0.7)*x1042))+pz);
evalcond[1]=(x1044+((x1042*x1045))+((pz*x1043))+(((-1.0)*x1042*x1046)));
evalcond[2]=((0.7)+x1047+x1049+x1048+(((-1.0)*x1043*x1045)));
evalcond[3]=((0.0876)+(((-1.4)*x1048))+(((-1.4)*x1049))+(((-1.0)*pp))+(((1.4)*x1043*x1045)));
evalcond[4]=(x1046+((x1043*x1047))+(((0.7)*x1043))+(((-1.0)*x1042*x1044))+(((-1.0)*x1045)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}

}
}
}
}
return solutions.GetNumSolutions()>0;
}
inline void rotationfunction0(IkSolutionListBase<IkReal>& solutions) {
for(int rotationiter = 0; rotationiter < 1; ++rotationiter) {
IkReal x67=((1.0)*sj0);
IkReal x68=(cj0*r12);
IkReal x69=((1.0)*sj1);
IkReal x70=((1.0)*cj1);
IkReal x71=(cj0*r11);
IkReal x72=(cj0*r10);
IkReal x73=(((cj2*sj1))+(((-1.0)*sj2*x70)));
IkReal x74=(((cj1*sj2))+(((-1.0)*cj2*x69)));
IkReal x75=((((-1.0)*sj2*x69))+(((-1.0)*cj2*x70)));
new_r00=(((r10*sj0))+((cj0*r00)));
new_r01=(((r11*sj0))+((cj0*r01)));
new_r02=(((r12*sj0))+((cj0*r02)));
new_r10=((((-1.0)*r00*x67*x75))+((x72*x75))+((r20*x73)));
new_r11=(((r21*x73))+(((-1.0)*r01*x67*x75))+((x71*x75)));
new_r12=(((r22*x73))+((x68*x75))+(((-1.0)*r02*x67*x75)));
new_r20=((((-1.0)*r00*x67*x74))+((x72*x74))+((r20*x75)));
new_r21=(((r21*x75))+(((-1.0)*r01*x67*x74))+((x71*x74)));
new_r22=(((r22*x75))+((x68*x74))+(((-1.0)*r02*x67*x74)));
{
IkReal j4array[2], cj4array[2], sj4array[2];
bool j4valid[2]={false};
_nj4 = 2;
cj4array[0]=new_r22;
if( cj4array[0] >= -1-IKFAST_SINCOS_THRESH && cj4array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j4valid[0] = j4valid[1] = true;
    j4array[0] = IKacos(cj4array[0]);
    sj4array[0] = IKsin(j4array[0]);
    cj4array[1] = cj4array[0];
    j4array[1] = -j4array[0];
    sj4array[1] = -sj4array[0];
}
else if( isnan(cj4array[0]) )
{
    // probably any value will work
    j4valid[0] = true;
    cj4array[0] = 1; sj4array[0] = 0; j4array[0] = 0;
}
for(int ij4 = 0; ij4 < 2; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 2; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];

{
IkReal j5eval[3];
j5eval[0]=sj4;
j5eval[1]=IKsign(sj4);
j5eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j3eval[3];
j3eval[0]=sj4;
j3eval[1]=IKsign(sj4);
j3eval[2]=((IKabs(new_r12))+(IKabs(new_r02)));
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  || IKabs(j3eval[2]) < 0.0000010000000000  )
{
{
IkReal j3eval[2];
j3eval[0]=new_r02;
j3eval[1]=sj4;
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j4))), 6.28318530717959)));
evalcond[1]=new_r12;
evalcond[2]=new_r02;
evalcond[3]=new_r20;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
IkReal j5mul = 1;
j5=0;
j3mul=-1.0;
if( IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r01))+IKsqr(new_r00)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3=IKatan2(((-1.0)*new_r01), new_r00);
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].fmul = j3mul;
vinfos[3].freeind = 0;
vinfos[3].maxsolutions = 0;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].fmul = j5mul;
vinfos[5].freeind = 0;
vinfos[5].maxsolutions = 0;
std::vector<int> vfree(1);
vfree[0] = 5;
solutions.AddSolution(vinfos,vfree);
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j4)))), 6.28318530717959)));
evalcond[1]=new_r12;
evalcond[2]=new_r02;
evalcond[3]=new_r20;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
IkReal j5mul = 1;
j5=0;
j3mul=1.0;
if( IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r01)+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3=IKatan2(new_r01, ((-1.0)*new_r11));
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].fmul = j3mul;
vinfos[3].freeind = 0;
vinfos[3].maxsolutions = 0;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].fmul = j5mul;
vinfos[5].freeind = 0;
vinfos[5].maxsolutions = 0;
std::vector<int> vfree(1);
vfree[0] = 5;
solutions.AddSolution(vinfos,vfree);
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3eval[1];
new_r21=0;
new_r20=0;
new_r02=0;
new_r12=0;
IkReal x76=new_r22*new_r22;
IkReal x77=((16.0)*new_r10);
IkReal x78=((16.0)*new_r01);
IkReal x79=((16.0)*new_r00);
IkReal x80=(new_r11*new_r22);
IkReal x81=((8.0)*new_r00);
IkReal x82=(x76*x77);
IkReal x83=(x76*x78);
j3eval[0]=((IKabs(((((32.0)*new_r00))+(((-16.0)*x80))+(((-1.0)*x76*x79)))))+(IKabs((x78+(((-1.0)*x83)))))+(IKabs(((((-1.0)*x78))+x83)))+(IKabs((((x76*x81))+(((-8.0)*x80)))))+(IKabs(((((-32.0)*new_r11*x76))+((new_r22*x79))+(((16.0)*new_r11)))))+(IKabs((((new_r22*x81))+(((-8.0)*new_r11)))))+(IKabs(((((-1.0)*x77))+x82)))+(IKabs((x77+(((-1.0)*x82))))));
if( IKabs(j3eval[0]) < 0.0000000010000000  )
{
continue; // no branches [j3, j5]

} else
{
IkReal op[4+1], zeror[4];
int numroots;
IkReal j3evalpoly[1];
IkReal x84=new_r22*new_r22;
IkReal x85=((16.0)*new_r01);
IkReal x86=(new_r00*new_r22);
IkReal x87=(x84*x85);
IkReal x88=((((8.0)*x86))+(((-8.0)*new_r11)));
op[0]=x88;
op[1]=(x87+(((-1.0)*x85)));
op[2]=((((16.0)*x86))+(((16.0)*new_r11))+(((-32.0)*new_r11*x84)));
op[3]=(x85+(((-1.0)*x87)));
op[4]=x88;
polyroots4(op,zeror,numroots);
IkReal j3array[4], cj3array[4], sj3array[4], tempj3array[1];
int numsolutions = 0;
for(int ij3 = 0; ij3 < numroots; ++ij3)
{
IkReal htj3 = zeror[ij3];
tempj3array[0]=((2.0)*(atan(htj3)));
for(int kj3 = 0; kj3 < 1; ++kj3)
{
j3array[numsolutions] = tempj3array[kj3];
if( j3array[numsolutions] > IKPI )
{
    j3array[numsolutions]-=IK2PI;
}
else if( j3array[numsolutions] < -IKPI )
{
    j3array[numsolutions]+=IK2PI;
}
sj3array[numsolutions] = IKsin(j3array[numsolutions]);
cj3array[numsolutions] = IKcos(j3array[numsolutions]);
numsolutions++;
}
}
bool j3valid[4]={true,true,true,true};
_nj3 = 4;
for(int ij3 = 0; ij3 < numsolutions; ++ij3)
    {
if( !j3valid[ij3] )
{
    continue;
}
    j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
htj3 = IKtan(j3/2);

IkReal x89=new_r22*new_r22;
IkReal x90=((16.0)*new_r10);
IkReal x91=(new_r11*new_r22);
IkReal x92=((8.0)*x91);
IkReal x93=(new_r00*x89);
IkReal x94=(x89*x90);
IkReal x95=((8.0)*x93);
j3evalpoly[0]=((((htj3*htj3*htj3)*((x90+(((-1.0)*x94))))))+((htj3*((x94+(((-1.0)*x90))))))+(((htj3*htj3)*(((((32.0)*new_r00))+(((-16.0)*x91))+(((-16.0)*x93))))))+x95+(((htj3*htj3*htj3*htj3)*((x95+(((-1.0)*x92))))))+(((-1.0)*x92)));
if( IKabs(j3evalpoly[0]) > 0.0000000010000000  )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < numsolutions; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
{
IkReal j5eval[3];
new_r21=0;
new_r20=0;
new_r02=0;
new_r12=0;
IkReal x96=cj3*cj3;
IkReal x97=new_r22*new_r22;
IkReal x98=(new_r22*sj3);
IkReal x99=(((x96*x97))+(((-1.0)*x97))+(((-1.0)*x96)));
j5eval[0]=x99;
j5eval[1]=IKsign(x99);
j5eval[2]=((IKabs((((new_r00*x98))+((cj3*new_r01)))))+(IKabs((((new_r01*x98))+(((-1.0)*cj3*new_r00))))));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
new_r21=0;
new_r20=0;
new_r02=0;
new_r12=0;
j5eval[0]=new_r22;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
new_r21=0;
new_r20=0;
new_r02=0;
new_r12=0;
j5eval[0]=cj3;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r11))+IKsqr(new_r10)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0)*new_r11), new_r10);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[4];
IkReal x100=IKsin(j5);
IkReal x101=IKcos(j5);
evalcond[0]=(x100+new_r11);
evalcond[1]=((-1.0)*x100);
evalcond[2]=((-1.0)*x101);
evalcond[3]=(new_r10+(((-1.0)*x101)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j3)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r11)+IKsqr(((-1.0)*new_r10))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r11, ((-1.0)*new_r10));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[4];
IkReal x102=IKsin(j5);
IkReal x103=IKcos(j5);
evalcond[0]=((-1.0)*x102);
evalcond[1]=((-1.0)*x103);
evalcond[2]=(x102+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*new_r10))+(((-1.0)*x103)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x104=new_r22*new_r22;
CheckValue<IkReal> x105=IKPowWithIntegerCheck(((-1.0)+x104),-1);
if(!x105.valid){
continue;
}
if(((x104*(x105.value))) < -0.00001)
continue;
IkReal gconst6=IKsqrt((x104*(x105.value)));
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.0)+(IKsign(sj3)))))+(IKabs((cj3+(((-1.0)*gconst6)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
IkReal x106=new_r22*new_r22;
new_r21=0;
new_r20=0;
new_r02=0;
new_r12=0;
if((((1.0)+(((-1.0)*(gconst6*gconst6))))) < -0.00001)
continue;
sj3=IKsqrt(((1.0)+(((-1.0)*(gconst6*gconst6)))));
cj3=gconst6;
if( (gconst6) < -1-IKFAST_SINCOS_THRESH || (gconst6) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=IKacos(gconst6);
CheckValue<IkReal> x107=IKPowWithIntegerCheck(((-1.0)+x106),-1);
if(!x107.valid){
continue;
}
if(((x106*(x107.value))) < -0.00001)
continue;
IkReal gconst6=IKsqrt((x106*(x107.value)));
j5eval[0]=((IKabs(new_r00))+(IKabs(new_r01)));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if((((1.0)+(((-1.0)*(gconst6*gconst6))))) < -0.00001)
continue;
CheckValue<IkReal> x108=IKPowWithIntegerCheck(gconst6,-1);
if(!x108.valid){
continue;
}
if( IKabs(((((-1.0)*gconst6*new_r01))+(((-1.0)*new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst6*gconst6)))))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r00*(x108.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*gconst6*new_r01))+(((-1.0)*new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst6*gconst6))))))))))+IKsqr((new_r00*(x108.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*gconst6*new_r01))+(((-1.0)*new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst6*gconst6))))))))), (new_r00*(x108.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x109=IKsin(j5);
IkReal x110=IKcos(j5);
IkReal x111=((1.0)*x110);
if((((1.0)+(((-1.0)*(gconst6*gconst6))))) < -0.00001)
continue;
IkReal x112=IKsqrt(((1.0)+(((-1.0)*(gconst6*gconst6)))));
evalcond[0]=((-1.0)*x109);
evalcond[1]=((-1.0)*x110);
evalcond[2]=(((gconst6*x109))+new_r01);
evalcond[3]=((((-1.0)*gconst6*x111))+new_r00);
evalcond[4]=(((x109*x112))+new_r11);
evalcond[5]=((((-1.0)*x111*x112))+new_r10);
evalcond[6]=(((new_r11*x112))+((gconst6*new_r01))+x109);
evalcond[7]=(((new_r10*x112))+((gconst6*new_r00))+(((-1.0)*x111)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x113 = IKatan2WithCheck(IkReal(((-1.0)*new_r01)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x113.valid){
continue;
}
CheckValue<IkReal> x114=IKPowWithIntegerCheck(IKsign(gconst6),-1);
if(!x114.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x113.value)+(((1.5707963267949)*(x114.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x115=IKsin(j5);
IkReal x116=IKcos(j5);
IkReal x117=((1.0)*x116);
if((((1.0)+(((-1.0)*(gconst6*gconst6))))) < -0.00001)
continue;
IkReal x118=IKsqrt(((1.0)+(((-1.0)*(gconst6*gconst6)))));
evalcond[0]=((-1.0)*x115);
evalcond[1]=((-1.0)*x116);
evalcond[2]=(((gconst6*x115))+new_r01);
evalcond[3]=((((-1.0)*gconst6*x117))+new_r00);
evalcond[4]=(new_r11+((x115*x118)));
evalcond[5]=((((-1.0)*x117*x118))+new_r10);
evalcond[6]=(((new_r11*x118))+((gconst6*new_r01))+x115);
evalcond[7]=(((new_r10*x118))+((gconst6*new_r00))+(((-1.0)*x117)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x119=new_r22*new_r22;
CheckValue<IkReal> x120=IKPowWithIntegerCheck(((-1.0)+x119),-1);
if(!x120.valid){
continue;
}
if(((x119*(x120.value))) < -0.00001)
continue;
IkReal gconst6=IKsqrt((x119*(x120.value)));
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs((cj3+(((-1.0)*gconst6)))))+(IKabs(((1.0)+(IKsign(sj3)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
IkReal x121=new_r22*new_r22;
new_r21=0;
new_r20=0;
new_r02=0;
new_r12=0;
if((((1.0)+(((-1.0)*(gconst6*gconst6))))) < -0.00001)
continue;
sj3=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst6*gconst6)))))));
cj3=gconst6;
if( (gconst6) < -1-IKFAST_SINCOS_THRESH || (gconst6) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=((-1.0)*(IKacos(gconst6)));
CheckValue<IkReal> x122=IKPowWithIntegerCheck(((-1.0)+x121),-1);
if(!x122.valid){
continue;
}
if(((x121*(x122.value))) < -0.00001)
continue;
IkReal gconst6=IKsqrt((x121*(x122.value)));
j5eval[0]=((IKabs(new_r00))+(IKabs(new_r01)));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if((((1.0)+(((-1.0)*(gconst6*gconst6))))) < -0.00001)
continue;
CheckValue<IkReal> x123=IKPowWithIntegerCheck(gconst6,-1);
if(!x123.valid){
continue;
}
if( IKabs(((((-1.0)*gconst6*new_r01))+((new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst6*gconst6)))))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r00*(x123.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*gconst6*new_r01))+((new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst6*gconst6))))))))))+IKsqr((new_r00*(x123.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*gconst6*new_r01))+((new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst6*gconst6))))))))), (new_r00*(x123.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x124=IKsin(j5);
IkReal x125=IKcos(j5);
IkReal x126=((1.0)*x125);
if((((1.0)+(((-1.0)*(gconst6*gconst6))))) < -0.00001)
continue;
IkReal x127=IKsqrt(((1.0)+(((-1.0)*(gconst6*gconst6)))));
IkReal x128=((1.0)*x127);
evalcond[0]=((-1.0)*x124);
evalcond[1]=((-1.0)*x125);
evalcond[2]=(((gconst6*x124))+new_r01);
evalcond[3]=((((-1.0)*gconst6*x126))+new_r00);
evalcond[4]=(((x125*x127))+new_r10);
evalcond[5]=((((-1.0)*x124*x128))+new_r11);
evalcond[6]=(((gconst6*new_r01))+x124+(((-1.0)*new_r11*x128)));
evalcond[7]=((((-1.0)*new_r10*x128))+((gconst6*new_r00))+(((-1.0)*x126)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x129 = IKatan2WithCheck(IkReal(((-1.0)*new_r01)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x129.valid){
continue;
}
CheckValue<IkReal> x130=IKPowWithIntegerCheck(IKsign(gconst6),-1);
if(!x130.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x129.value)+(((1.5707963267949)*(x130.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x131=IKsin(j5);
IkReal x132=IKcos(j5);
IkReal x133=((1.0)*x132);
if((((1.0)+(((-1.0)*(gconst6*gconst6))))) < -0.00001)
continue;
IkReal x134=IKsqrt(((1.0)+(((-1.0)*(gconst6*gconst6)))));
IkReal x135=((1.0)*x134);
evalcond[0]=((-1.0)*x131);
evalcond[1]=((-1.0)*x132);
evalcond[2]=(((gconst6*x131))+new_r01);
evalcond[3]=((((-1.0)*gconst6*x133))+new_r00);
evalcond[4]=(((x132*x134))+new_r10);
evalcond[5]=(new_r11+(((-1.0)*x131*x135)));
evalcond[6]=((((-1.0)*new_r11*x135))+((gconst6*new_r01))+x131);
evalcond[7]=((((-1.0)*new_r10*x135))+((gconst6*new_r00))+(((-1.0)*x133)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x136=new_r22*new_r22;
CheckValue<IkReal> x137=IKPowWithIntegerCheck(((-1.0)+x136),-1);
if(!x137.valid){
continue;
}
if(((x136*(x137.value))) < -0.00001)
continue;
IkReal gconst7=((-1.0)*(IKsqrt((x136*(x137.value)))));
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.0)+(IKsign(sj3)))))+(IKabs((cj3+(((-1.0)*gconst7)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
IkReal x138=new_r22*new_r22;
new_r21=0;
new_r20=0;
new_r02=0;
new_r12=0;
if((((1.0)+(((-1.0)*(gconst7*gconst7))))) < -0.00001)
continue;
sj3=IKsqrt(((1.0)+(((-1.0)*(gconst7*gconst7)))));
cj3=gconst7;
if( (gconst7) < -1-IKFAST_SINCOS_THRESH || (gconst7) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=IKacos(gconst7);
CheckValue<IkReal> x139=IKPowWithIntegerCheck(((-1.0)+x138),-1);
if(!x139.valid){
continue;
}
if(((x138*(x139.value))) < -0.00001)
continue;
IkReal gconst7=((-1.0)*(IKsqrt((x138*(x139.value)))));
j5eval[0]=((IKabs(new_r00))+(IKabs(new_r01)));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if((((1.0)+(((-1.0)*(gconst7*gconst7))))) < -0.00001)
continue;
CheckValue<IkReal> x140=IKPowWithIntegerCheck(gconst7,-1);
if(!x140.valid){
continue;
}
if( IKabs(((((-1.0)*gconst7*new_r01))+(((-1.0)*new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst7*gconst7)))))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r00*(x140.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*gconst7*new_r01))+(((-1.0)*new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst7*gconst7))))))))))+IKsqr((new_r00*(x140.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*gconst7*new_r01))+(((-1.0)*new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst7*gconst7))))))))), (new_r00*(x140.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x141=IKsin(j5);
IkReal x142=IKcos(j5);
IkReal x143=((1.0)*x142);
if((((1.0)+(((-1.0)*(gconst7*gconst7))))) < -0.00001)
continue;
IkReal x144=IKsqrt(((1.0)+(((-1.0)*(gconst7*gconst7)))));
evalcond[0]=((-1.0)*x141);
evalcond[1]=((-1.0)*x142);
evalcond[2]=(new_r01+((gconst7*x141)));
evalcond[3]=((((-1.0)*gconst7*x143))+new_r00);
evalcond[4]=(((x141*x144))+new_r11);
evalcond[5]=((((-1.0)*x143*x144))+new_r10);
evalcond[6]=(((new_r11*x144))+x141+((gconst7*new_r01)));
evalcond[7]=((((-1.0)*x143))+((new_r10*x144))+((gconst7*new_r00)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x145 = IKatan2WithCheck(IkReal(((-1.0)*new_r01)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x145.valid){
continue;
}
CheckValue<IkReal> x146=IKPowWithIntegerCheck(IKsign(gconst7),-1);
if(!x146.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x145.value)+(((1.5707963267949)*(x146.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x147=IKsin(j5);
IkReal x148=IKcos(j5);
IkReal x149=((1.0)*x148);
if((((1.0)+(((-1.0)*(gconst7*gconst7))))) < -0.00001)
continue;
IkReal x150=IKsqrt(((1.0)+(((-1.0)*(gconst7*gconst7)))));
evalcond[0]=((-1.0)*x147);
evalcond[1]=((-1.0)*x148);
evalcond[2]=(new_r01+((gconst7*x147)));
evalcond[3]=((((-1.0)*gconst7*x149))+new_r00);
evalcond[4]=(((x147*x150))+new_r11);
evalcond[5]=(new_r10+(((-1.0)*x149*x150)));
evalcond[6]=(((new_r11*x150))+x147+((gconst7*new_r01)));
evalcond[7]=((((-1.0)*x149))+((new_r10*x150))+((gconst7*new_r00)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x151=new_r22*new_r22;
CheckValue<IkReal> x152=IKPowWithIntegerCheck(((-1.0)+x151),-1);
if(!x152.valid){
continue;
}
if(((x151*(x152.value))) < -0.00001)
continue;
IkReal gconst7=((-1.0)*(IKsqrt((x151*(x152.value)))));
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs((cj3+(((-1.0)*gconst7)))))+(IKabs(((1.0)+(IKsign(sj3)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
IkReal x153=new_r22*new_r22;
new_r21=0;
new_r20=0;
new_r02=0;
new_r12=0;
if((((1.0)+(((-1.0)*(gconst7*gconst7))))) < -0.00001)
continue;
sj3=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst7*gconst7)))))));
cj3=gconst7;
if( (gconst7) < -1-IKFAST_SINCOS_THRESH || (gconst7) > 1+IKFAST_SINCOS_THRESH )
    continue;
j3=((-1.0)*(IKacos(gconst7)));
CheckValue<IkReal> x154=IKPowWithIntegerCheck(((-1.0)+x153),-1);
if(!x154.valid){
continue;
}
if(((x153*(x154.value))) < -0.00001)
continue;
IkReal gconst7=((-1.0)*(IKsqrt((x153*(x154.value)))));
j5eval[0]=((IKabs(new_r00))+(IKabs(new_r01)));
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if((((1.0)+(((-1.0)*(gconst7*gconst7))))) < -0.00001)
continue;
CheckValue<IkReal> x155=IKPowWithIntegerCheck(gconst7,-1);
if(!x155.valid){
continue;
}
if( IKabs((((new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst7*gconst7))))))))+(((-1.0)*gconst7*new_r01)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r00*(x155.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst7*gconst7))))))))+(((-1.0)*gconst7*new_r01))))+IKsqr((new_r00*(x155.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((((new_r11*(IKsqrt(((1.0)+(((-1.0)*(gconst7*gconst7))))))))+(((-1.0)*gconst7*new_r01))), (new_r00*(x155.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x156=IKsin(j5);
IkReal x157=IKcos(j5);
IkReal x158=((1.0)*x157);
if((((1.0)+(((-1.0)*(gconst7*gconst7))))) < -0.00001)
continue;
IkReal x159=IKsqrt(((1.0)+(((-1.0)*(gconst7*gconst7)))));
IkReal x160=((1.0)*x159);
evalcond[0]=((-1.0)*x156);
evalcond[1]=((-1.0)*x157);
evalcond[2]=(new_r01+((gconst7*x156)));
evalcond[3]=((((-1.0)*gconst7*x158))+new_r00);
evalcond[4]=(((x157*x159))+new_r10);
evalcond[5]=(new_r11+(((-1.0)*x156*x160)));
evalcond[6]=((((-1.0)*new_r11*x160))+x156+((gconst7*new_r01)));
evalcond[7]=((((-1.0)*x158))+(((-1.0)*new_r10*x160))+((gconst7*new_r00)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x161 = IKatan2WithCheck(IkReal(((-1.0)*new_r01)),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x161.valid){
continue;
}
CheckValue<IkReal> x162=IKPowWithIntegerCheck(IKsign(gconst7),-1);
if(!x162.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x161.value)+(((1.5707963267949)*(x162.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x163=IKsin(j5);
IkReal x164=IKcos(j5);
IkReal x165=((1.0)*x164);
if((((1.0)+(((-1.0)*(gconst7*gconst7))))) < -0.00001)
continue;
IkReal x166=IKsqrt(((1.0)+(((-1.0)*(gconst7*gconst7)))));
IkReal x167=((1.0)*x166);
evalcond[0]=((-1.0)*x163);
evalcond[1]=((-1.0)*x164);
evalcond[2]=(((gconst7*x163))+new_r01);
evalcond[3]=((((-1.0)*gconst7*x165))+new_r00);
evalcond[4]=(((x164*x166))+new_r10);
evalcond[5]=((((-1.0)*x163*x167))+new_r11);
evalcond[6]=((((-1.0)*new_r11*x167))+x163+((gconst7*new_r01)));
evalcond[7]=((((-1.0)*x165))+(((-1.0)*new_r10*x167))+((gconst7*new_r00)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x168=((1.0)*new_r22);
IkReal x169=(cj3*new_r01);
CheckValue<IkReal> x170=IKPowWithIntegerCheck(cj3,-1);
if(!x170.valid){
continue;
}
if( IKabs(((((-1.0)*x169))+(((-1.0)*new_r11*sj3)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x170.value)*(((((-1.0)*sj3*x168*x169))+(((-1.0)*new_r11*x168))+((new_r11*new_r22*(cj3*cj3)))+new_r00)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*x169))+(((-1.0)*new_r11*sj3))))+IKsqr(((x170.value)*(((((-1.0)*sj3*x168*x169))+(((-1.0)*new_r11*x168))+((new_r11*new_r22*(cj3*cj3)))+new_r00))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*x169))+(((-1.0)*new_r11*sj3))), ((x170.value)*(((((-1.0)*sj3*x168*x169))+(((-1.0)*new_r11*x168))+((new_r11*new_r22*(cj3*cj3)))+new_r00))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x171=IKsin(j5);
IkReal x172=IKcos(j5);
IkReal x173=((1.0)*cj3);
IkReal x174=((1.0)*sj3);
IkReal x175=(cj3*new_r10);
IkReal x176=(cj3*new_r11);
IkReal x177=((1.0)*x172);
IkReal x178=(new_r22*x172);
IkReal x179=(sj3*x171);
IkReal x180=(new_r22*x171);
evalcond[0]=(((new_r11*sj3))+x171+((cj3*new_r01)));
evalcond[1]=(((new_r10*sj3))+(((-1.0)*x177))+((cj3*new_r00)));
evalcond[2]=(((cj3*x171))+new_r01+((sj3*x178)));
evalcond[3]=(((new_r22*x179))+new_r00+(((-1.0)*x172*x173)));
evalcond[4]=(x179+new_r11+(((-1.0)*x173*x178)));
evalcond[5]=((((-1.0)*x180))+x175+(((-1.0)*new_r00*x174)));
evalcond[6]=(x176+(((-1.0)*new_r22*x177))+(((-1.0)*new_r01*x174)));
evalcond[7]=(new_r10+(((-1.0)*x173*x180))+(((-1.0)*x172*x174)));
evalcond[8]=((((-1.0)*x171))+((new_r22*x175))+(((-1.0)*new_r00*new_r22*x174)));
evalcond[9]=((((-1.0)*x177))+(((-1.0)*new_r01*new_r22*x174))+((new_r22*x176)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x181=((1.0)*new_r01);
CheckValue<IkReal> x182=IKPowWithIntegerCheck(new_r22,-1);
if(!x182.valid){
continue;
}
if( IKabs(((((-1.0)*new_r11*sj3))+(((-1.0)*cj3*x181)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x182.value)*((((cj3*new_r11))+(((-1.0)*sj3*x181)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r11*sj3))+(((-1.0)*cj3*x181))))+IKsqr(((x182.value)*((((cj3*new_r11))+(((-1.0)*sj3*x181))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*new_r11*sj3))+(((-1.0)*cj3*x181))), ((x182.value)*((((cj3*new_r11))+(((-1.0)*sj3*x181))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x183=IKsin(j5);
IkReal x184=IKcos(j5);
IkReal x185=((1.0)*cj3);
IkReal x186=((1.0)*sj3);
IkReal x187=(cj3*new_r10);
IkReal x188=(cj3*new_r11);
IkReal x189=((1.0)*x184);
IkReal x190=(new_r22*x184);
IkReal x191=(sj3*x183);
IkReal x192=(new_r22*x183);
evalcond[0]=(((new_r11*sj3))+x183+((cj3*new_r01)));
evalcond[1]=(((new_r10*sj3))+(((-1.0)*x189))+((cj3*new_r00)));
evalcond[2]=(((sj3*x190))+((cj3*x183))+new_r01);
evalcond[3]=((((-1.0)*x184*x185))+((new_r22*x191))+new_r00);
evalcond[4]=(x191+(((-1.0)*x185*x190))+new_r11);
evalcond[5]=((((-1.0)*x192))+x187+(((-1.0)*new_r00*x186)));
evalcond[6]=((((-1.0)*new_r22*x189))+x188+(((-1.0)*new_r01*x186)));
evalcond[7]=((((-1.0)*x184*x186))+(((-1.0)*x185*x192))+new_r10);
evalcond[8]=((((-1.0)*x183))+((new_r22*x187))+(((-1.0)*new_r00*new_r22*x186)));
evalcond[9]=((((-1.0)*x189))+((new_r22*x188))+(((-1.0)*new_r01*new_r22*x186)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x193=cj3*cj3;
IkReal x194=new_r22*new_r22;
IkReal x195=(new_r22*sj3);
CheckValue<IkReal> x196 = IKatan2WithCheck(IkReal((((new_r00*x195))+((cj3*new_r01)))),IkReal((((new_r01*x195))+(((-1.0)*cj3*new_r00)))),IKFAST_ATAN2_MAGTHRESH);
if(!x196.valid){
continue;
}
CheckValue<IkReal> x197=IKPowWithIntegerCheck(IKsign((((x193*x194))+(((-1.0)*x194))+(((-1.0)*x193)))),-1);
if(!x197.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(x196.value)+(((1.5707963267949)*(x197.value))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[10];
IkReal x198=IKsin(j5);
IkReal x199=IKcos(j5);
IkReal x200=((1.0)*cj3);
IkReal x201=((1.0)*sj3);
IkReal x202=(cj3*new_r10);
IkReal x203=(cj3*new_r11);
IkReal x204=((1.0)*x199);
IkReal x205=(new_r22*x199);
IkReal x206=(sj3*x198);
IkReal x207=(new_r22*x198);
evalcond[0]=(((new_r11*sj3))+x198+((cj3*new_r01)));
evalcond[1]=(((new_r10*sj3))+(((-1.0)*x204))+((cj3*new_r00)));
evalcond[2]=(((sj3*x205))+((cj3*x198))+new_r01);
evalcond[3]=(((new_r22*x206))+(((-1.0)*x199*x200))+new_r00);
evalcond[4]=((((-1.0)*x200*x205))+x206+new_r11);
evalcond[5]=((((-1.0)*new_r00*x201))+x202+(((-1.0)*x207)));
evalcond[6]=((((-1.0)*new_r22*x204))+x203+(((-1.0)*new_r01*x201)));
evalcond[7]=((((-1.0)*x200*x207))+(((-1.0)*x199*x201))+new_r10);
evalcond[8]=((((-1.0)*x198))+((new_r22*x202))+(((-1.0)*new_r00*new_r22*x201)));
evalcond[9]=((((-1.0)*x204))+(((-1.0)*new_r01*new_r22*x201))+((new_r22*x203)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j3, j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x209=IKPowWithIntegerCheck(sj4,-1);
if(!x209.valid){
continue;
}
IkReal x208=x209.value;
CheckValue<IkReal> x210=IKPowWithIntegerCheck(new_r02,-1);
if(!x210.valid){
continue;
}
if( IKabs((x208*(x210.value)*(((1.0)+(((-1.0)*(cj4*cj4)))+(((-1.0)*(new_r12*new_r12))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r12*x208)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x208*(x210.value)*(((1.0)+(((-1.0)*(cj4*cj4)))+(((-1.0)*(new_r12*new_r12)))))))+IKsqr(((-1.0)*new_r12*x208))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2((x208*(x210.value)*(((1.0)+(((-1.0)*(cj4*cj4)))+(((-1.0)*(new_r12*new_r12)))))), ((-1.0)*new_r12*x208));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x211=IKsin(j3);
IkReal x212=IKcos(j3);
IkReal x213=((1.0)*cj4);
IkReal x214=((1.0)*sj4);
IkReal x215=(new_r02*x211);
IkReal x216=(new_r12*x212);
IkReal x217=(sj4*x212);
evalcond[0]=(x217+new_r12);
evalcond[1]=((((-1.0)*x211*x214))+new_r02);
evalcond[2]=(((new_r02*x212))+((new_r12*x211)));
evalcond[3]=(sj4+x216+(((-1.0)*x215)));
evalcond[4]=(((cj4*x216))+((new_r22*sj4))+(((-1.0)*x213*x215)));
evalcond[5]=((((-1.0)*new_r00*x211*x214))+(((-1.0)*new_r20*x213))+((new_r10*x217)));
evalcond[6]=((((-1.0)*new_r01*x211*x214))+(((-1.0)*new_r21*x213))+((new_r11*x217)));
evalcond[7]=((1.0)+(((-1.0)*new_r22*x213))+(((-1.0)*x214*x215))+((sj4*x216)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j5eval[3];
j5eval[0]=sj4;
j5eval[1]=IKsign(sj4);
j5eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
j5eval[0]=sj4;
j5eval[1]=cj3;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[3];
j5eval[0]=sj4;
j5eval[1]=cj4;
j5eval[2]=sj3;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j4))), 6.28318530717959)));
evalcond[1]=new_r12;
evalcond[2]=new_r02;
evalcond[3]=new_r20;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x218=((1.0)*new_r01);
if( IKabs(((((-1.0)*cj3*x218))+(((-1.0)*new_r00*sj3)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*sj3*x218))+((cj3*new_r00)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*cj3*x218))+(((-1.0)*new_r00*sj3))))+IKsqr(((((-1.0)*sj3*x218))+((cj3*new_r00))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*cj3*x218))+(((-1.0)*new_r00*sj3))), ((((-1.0)*sj3*x218))+((cj3*new_r00))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x219=IKsin(j5);
IkReal x220=IKcos(j5);
IkReal x221=((1.0)*sj3);
IkReal x222=(sj3*x219);
IkReal x223=((1.0)*x220);
IkReal x224=((1.0)*x219);
IkReal x225=(cj3*x223);
evalcond[0]=(((new_r11*sj3))+x219+((cj3*new_r01)));
evalcond[1]=(((new_r10*sj3))+((cj3*new_r00))+(((-1.0)*x223)));
evalcond[2]=(((cj3*x219))+((sj3*x220))+new_r01);
evalcond[3]=(x222+new_r00+(((-1.0)*x225)));
evalcond[4]=(x222+new_r11+(((-1.0)*x225)));
evalcond[5]=(((cj3*new_r10))+(((-1.0)*x224))+(((-1.0)*new_r00*x221)));
evalcond[6]=((((-1.0)*new_r01*x221))+((cj3*new_r11))+(((-1.0)*x223)));
evalcond[7]=((((-1.0)*x220*x221))+(((-1.0)*cj3*x224))+new_r10);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j4)))), 6.28318530717959)));
evalcond[1]=new_r12;
evalcond[2]=new_r02;
evalcond[3]=new_r20;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x226=((1.0)*cj3);
if( IKabs(((((-1.0)*new_r01*x226))+(((-1.0)*new_r11*sj3)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*new_r11*x226))+((new_r01*sj3)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r01*x226))+(((-1.0)*new_r11*sj3))))+IKsqr(((((-1.0)*new_r11*x226))+((new_r01*sj3))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*new_r01*x226))+(((-1.0)*new_r11*sj3))), ((((-1.0)*new_r11*x226))+((new_r01*sj3))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x227=IKsin(j5);
IkReal x228=IKcos(j5);
IkReal x229=((1.0)*sj3);
IkReal x230=(cj3*x227);
IkReal x231=((1.0)*x228);
IkReal x232=(x228*x229);
evalcond[0]=(((new_r11*sj3))+x227+((cj3*new_r01)));
evalcond[1]=(x227+((cj3*new_r10))+(((-1.0)*new_r00*x229)));
evalcond[2]=((((-1.0)*new_r01*x229))+x228+((cj3*new_r11)));
evalcond[3]=(((new_r10*sj3))+(((-1.0)*x231))+((cj3*new_r00)));
evalcond[4]=(((cj3*x228))+((sj3*x227))+new_r11);
evalcond[5]=((((-1.0)*x232))+x230+new_r01);
evalcond[6]=((((-1.0)*x232))+x230+new_r10);
evalcond[7]=((((-1.0)*x227*x229))+(((-1.0)*cj3*x231))+new_r00);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j4)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r20)+IKsqr(new_r21)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r20, new_r21);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x233=IKsin(j5);
IkReal x234=IKcos(j5);
IkReal x235=((1.0)*x234);
IkReal x236=((1.0)*x233);
evalcond[0]=((((-1.0)*x236))+new_r20);
evalcond[1]=((((-1.0)*x235))+new_r21);
evalcond[2]=(new_r11+((sj3*x233)));
evalcond[3]=((((-1.0)*new_r12*x236))+new_r01);
evalcond[4]=((((-1.0)*cj3*x235))+new_r00);
evalcond[5]=((((-1.0)*sj3*x235))+new_r10);
evalcond[6]=(((new_r11*sj3))+x233+((cj3*new_r01)));
evalcond[7]=(((new_r10*sj3))+(((-1.0)*x235))+((cj3*new_r00)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j4)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r20))+IKsqr(((-1.0)*new_r21))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0)*new_r20), ((-1.0)*new_r21));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x237=IKsin(j5);
IkReal x238=IKcos(j5);
IkReal x239=((1.0)*x238);
evalcond[0]=(x237+new_r20);
evalcond[1]=(x238+new_r21);
evalcond[2]=(((new_r12*x237))+new_r01);
evalcond[3]=(new_r11+((sj3*x237)));
evalcond[4]=((((-1.0)*cj3*x239))+new_r00);
evalcond[5]=((((-1.0)*sj3*x239))+new_r10);
evalcond[6]=(((new_r11*sj3))+x237+((cj3*new_r01)));
evalcond[7]=(((new_r10*sj3))+(((-1.0)*x239))+((cj3*new_r00)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j3))), 6.28318530717959)));
evalcond[1]=new_r02;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r01))+IKsqr(new_r00)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0)*new_r01), new_r00);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x240=IKsin(j5);
IkReal x241=IKcos(j5);
IkReal x242=((1.0)*cj4);
IkReal x243=((1.0)*x241);
IkReal x244=((1.0)*x240);
evalcond[0]=(x240+new_r01);
evalcond[1]=((((-1.0)*x243))+new_r00);
evalcond[2]=((((-1.0)*sj4*x244))+new_r20);
evalcond[3]=((((-1.0)*sj4*x243))+new_r21);
evalcond[4]=((((-1.0)*x241*x242))+new_r11);
evalcond[5]=((((-1.0)*x240*x242))+new_r10);
evalcond[6]=(((new_r20*sj4))+((cj4*new_r10))+(((-1.0)*x244)));
evalcond[7]=(((cj4*new_r11))+(((-1.0)*x243))+((new_r21*sj4)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j3)))), 6.28318530717959)));
evalcond[1]=new_r02;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r01)+IKsqr(((-1.0)*new_r00))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r01, ((-1.0)*new_r00));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x245=IKsin(j5);
IkReal x246=IKcos(j5);
IkReal x247=((1.0)*cj4);
IkReal x248=((1.0)*x246);
IkReal x249=((1.0)*x245);
evalcond[0]=(x245+(((-1.0)*new_r01)));
evalcond[1]=(((cj4*x246))+new_r11);
evalcond[2]=((((-1.0)*sj4*x249))+new_r20);
evalcond[3]=((((-1.0)*sj4*x248))+new_r21);
evalcond[4]=((((-1.0)*new_r00))+(((-1.0)*x248)));
evalcond[5]=((((-1.0)*new_r10))+(((-1.0)*x245*x247)));
evalcond[6]=(((new_r20*sj4))+(((-1.0)*new_r10*x247))+(((-1.0)*x249)));
evalcond[7]=((((-1.0)*new_r11*x247))+(((-1.0)*x248))+((new_r21*sj4)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j3)))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r11))+IKsqr(new_r10)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0)*new_r11), new_r10);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x250=IKcos(j5);
IkReal x251=IKsin(j5);
IkReal x252=((1.0)*cj4);
IkReal x253=((1.0)*x250);
IkReal x254=((1.0)*x251);
evalcond[0]=(x251+new_r11);
evalcond[1]=(new_r10+(((-1.0)*x253)));
evalcond[2]=(new_r01+((cj4*x250)));
evalcond[3]=(new_r00+((cj4*x251)));
evalcond[4]=(new_r20+(((-1.0)*new_r02*x254)));
evalcond[5]=(new_r21+(((-1.0)*new_r02*x253)));
evalcond[6]=(((new_r20*sj4))+(((-1.0)*new_r00*x252))+(((-1.0)*x254)));
evalcond[7]=((((-1.0)*new_r01*x252))+((new_r21*sj4))+(((-1.0)*x253)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j3)))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
sj3=-1.0;
cj3=0;
j3=-1.5707963267949;
j5eval[0]=new_r02;
j5eval[1]=IKsign(new_r02);
j5eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
sj3=-1.0;
cj3=0;
j3=-1.5707963267949;
j5eval[0]=new_r02;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
sj3=-1.0;
cj3=0;
j3=-1.5707963267949;
j5eval[0]=new_r02;
j5eval[1]=cj4;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[4];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j4)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r20)+IKsqr(new_r21)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r20, new_r21);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[4];
IkReal x255=IKsin(j5);
IkReal x256=((1.0)*(IKcos(j5)));
evalcond[0]=(new_r20+(((-1.0)*x255)));
evalcond[1]=(new_r21+(((-1.0)*x256)));
evalcond[2]=(x255+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*new_r10))+(((-1.0)*x256)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j4)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r11)+IKsqr(((-1.0)*new_r21))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r11, ((-1.0)*new_r21));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[4];
IkReal x257=IKsin(j5);
IkReal x258=IKcos(j5);
evalcond[0]=(x257+new_r20);
evalcond[1]=(x258+new_r21);
evalcond[2]=(x257+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*new_r10))+(((-1.0)*x258)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(new_r02);
evalcond[1]=new_r20;
evalcond[2]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r11)+IKsqr(((-1.0)*new_r10))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r11, ((-1.0)*new_r10));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[6];
IkReal x259=IKsin(j5);
IkReal x260=IKcos(j5);
IkReal x261=((1.0)*cj4);
IkReal x262=((1.0)*x260);
evalcond[0]=(x259+(((-1.0)*new_r11)));
evalcond[1]=(new_r01+(((-1.0)*x260*x261)));
evalcond[2]=((((-1.0)*x259*x261))+new_r00);
evalcond[3]=((((-1.0)*new_r10))+(((-1.0)*x262)));
evalcond[4]=(((cj4*new_r00))+(((-1.0)*x259)));
evalcond[5]=(((cj4*new_r01))+(((-1.0)*x262)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r11)+IKsqr(((-1.0)*new_r10))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r11, ((-1.0)*new_r10));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[6];
IkReal x263=IKcos(j5);
IkReal x264=IKsin(j5);
IkReal x265=((-1.0)*x264);
IkReal x266=((-1.0)*x263);
evalcond[0]=x265;
evalcond[1]=x266;
evalcond[2]=(new_r22*x266);
evalcond[3]=(new_r22*x265);
evalcond[4]=(x264+(((-1.0)*new_r11)));
evalcond[5]=((((-1.0)*x263))+(((-1.0)*new_r10)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x267=IKPowWithIntegerCheck(new_r02,-1);
if(!x267.valid){
continue;
}
CheckValue<IkReal> x268=IKPowWithIntegerCheck(cj4,-1);
if(!x268.valid){
continue;
}
if( IKabs(((-1.0)*new_r20*(x267.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r01*(x268.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r20*(x267.value)))+IKsqr((new_r01*(x268.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0)*new_r20*(x267.value)), (new_r01*(x268.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x269=IKsin(j5);
IkReal x270=IKcos(j5);
IkReal x271=((1.0)*cj4);
IkReal x272=((1.0)*x270);
evalcond[0]=(new_r20+((new_r02*x269)));
evalcond[1]=(new_r21+((new_r02*x270)));
evalcond[2]=(x269+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*x270*x271))+new_r01);
evalcond[4]=((((-1.0)*x269*x271))+new_r00);
evalcond[5]=((((-1.0)*new_r10))+(((-1.0)*x272)));
evalcond[6]=((((-1.0)*x269))+((new_r20*sj4))+((cj4*new_r00)));
evalcond[7]=(((cj4*new_r01))+(((-1.0)*x272))+((new_r21*sj4)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x273=IKPowWithIntegerCheck(new_r02,-1);
if(!x273.valid){
continue;
}
if( IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r21*(x273.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r11)+IKsqr(((-1.0)*new_r21*(x273.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r11, ((-1.0)*new_r21*(x273.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x274=IKsin(j5);
IkReal x275=IKcos(j5);
IkReal x276=((1.0)*cj4);
IkReal x277=((1.0)*x275);
evalcond[0]=(new_r20+((new_r02*x274)));
evalcond[1]=(new_r21+((new_r02*x275)));
evalcond[2]=(x274+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*x275*x276))+new_r01);
evalcond[4]=((((-1.0)*x274*x276))+new_r00);
evalcond[5]=((((-1.0)*new_r10))+(((-1.0)*x277)));
evalcond[6]=(((new_r20*sj4))+((cj4*new_r00))+(((-1.0)*x274)));
evalcond[7]=(((cj4*new_r01))+(((-1.0)*x277))+((new_r21*sj4)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x278=IKPowWithIntegerCheck(IKsign(new_r02),-1);
if(!x278.valid){
continue;
}
CheckValue<IkReal> x279 = IKatan2WithCheck(IkReal(((-1.0)*new_r20)),IkReal(((-1.0)*new_r21)),IKFAST_ATAN2_MAGTHRESH);
if(!x279.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x278.value)))+(x279.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x280=IKsin(j5);
IkReal x281=IKcos(j5);
IkReal x282=((1.0)*cj4);
IkReal x283=((1.0)*x281);
evalcond[0]=(((new_r02*x280))+new_r20);
evalcond[1]=(((new_r02*x281))+new_r21);
evalcond[2]=(x280+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*x281*x282))+new_r01);
evalcond[4]=((((-1.0)*x280*x282))+new_r00);
evalcond[5]=((((-1.0)*new_r10))+(((-1.0)*x283)));
evalcond[6]=(((new_r20*sj4))+((cj4*new_r00))+(((-1.0)*x280)));
evalcond[7]=(((cj4*new_r01))+(((-1.0)*x283))+((new_r21*sj4)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
new_r21=0;
new_r20=0;
new_r02=0;
new_r12=0;
j5eval[0]=1.0;
if( IKabs(j5eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j5]

} else
{
IkReal op[2+1], zeror[2];
int numroots;
op[0]=1.0;
op[1]=0;
op[2]=-1.0;
polyroots2(op,zeror,numroots);
IkReal j5array[2], cj5array[2], sj5array[2], tempj5array[1];
int numsolutions = 0;
for(int ij5 = 0; ij5 < numroots; ++ij5)
{
IkReal htj5 = zeror[ij5];
tempj5array[0]=((2.0)*(atan(htj5)));
for(int kj5 = 0; kj5 < 1; ++kj5)
{
j5array[numsolutions] = tempj5array[kj5];
if( j5array[numsolutions] > IKPI )
{
    j5array[numsolutions]-=IK2PI;
}
else if( j5array[numsolutions] < -IKPI )
{
    j5array[numsolutions]+=IK2PI;
}
sj5array[numsolutions] = IKsin(j5array[numsolutions]);
cj5array[numsolutions] = IKcos(j5array[numsolutions]);
numsolutions++;
}
}
bool j5valid[2]={true,true};
_nj5 = 2;
for(int ij5 = 0; ij5 < numsolutions; ++ij5)
    {
if( !j5valid[ij5] )
{
    continue;
}
    j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
htj5 = IKtan(j5/2);

_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < numsolutions; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x285=IKPowWithIntegerCheck(sj4,-1);
if(!x285.valid){
continue;
}
IkReal x284=x285.value;
CheckValue<IkReal> x286=IKPowWithIntegerCheck(cj4,-1);
if(!x286.valid){
continue;
}
CheckValue<IkReal> x287=IKPowWithIntegerCheck(sj3,-1);
if(!x287.valid){
continue;
}
if( IKabs((new_r20*x284)) < IKFAST_ATAN2_MAGTHRESH && IKabs((x284*(x286.value)*(x287.value)*(((((-1.0)*new_r01*sj4))+(((-1.0)*cj3*new_r20)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r20*x284))+IKsqr((x284*(x286.value)*(x287.value)*(((((-1.0)*new_r01*sj4))+(((-1.0)*cj3*new_r20))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((new_r20*x284), (x284*(x286.value)*(x287.value)*(((((-1.0)*new_r01*sj4))+(((-1.0)*cj3*new_r20))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[12];
IkReal x288=IKsin(j5);
IkReal x289=IKcos(j5);
IkReal x290=(cj4*sj3);
IkReal x291=(cj3*new_r10);
IkReal x292=((1.0)*new_r01);
IkReal x293=(cj3*new_r11);
IkReal x294=((1.0)*new_r00);
IkReal x295=((1.0)*x289);
IkReal x296=(cj4*x288);
IkReal x297=((1.0)*x288);
evalcond[0]=(new_r20+(((-1.0)*sj4*x297)));
evalcond[1]=(new_r21+(((-1.0)*sj4*x295)));
evalcond[2]=(((new_r11*sj3))+x288+((cj3*new_r01)));
evalcond[3]=(((new_r10*sj3))+(((-1.0)*x295))+((cj3*new_r00)));
evalcond[4]=(((x289*x290))+((cj3*x288))+new_r01);
evalcond[5]=((((-1.0)*cj3*x295))+new_r00+((x288*x290)));
evalcond[6]=(((sj3*x288))+(((-1.0)*cj3*cj4*x295))+new_r11);
evalcond[7]=((((-1.0)*x296))+x291+(((-1.0)*sj3*x294)));
evalcond[8]=((((-1.0)*cj4*x295))+x293+(((-1.0)*sj3*x292)));
evalcond[9]=((((-1.0)*cj3*x296))+(((-1.0)*sj3*x295))+new_r10);
evalcond[10]=((((-1.0)*x290*x294))+((new_r20*sj4))+(((-1.0)*x297))+((cj4*x291)));
evalcond[11]=((((-1.0)*x290*x292))+(((-1.0)*x295))+((cj4*x293))+((new_r21*sj4)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x299=IKPowWithIntegerCheck(sj4,-1);
if(!x299.valid){
continue;
}
IkReal x298=x299.value;
CheckValue<IkReal> x300=IKPowWithIntegerCheck(cj3,-1);
if(!x300.valid){
continue;
}
if( IKabs((new_r20*x298)) < IKFAST_ATAN2_MAGTHRESH && IKabs((x298*(x300.value)*((((new_r00*sj4))+((cj4*new_r20*sj3)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r20*x298))+IKsqr((x298*(x300.value)*((((new_r00*sj4))+((cj4*new_r20*sj3))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((new_r20*x298), (x298*(x300.value)*((((new_r00*sj4))+((cj4*new_r20*sj3))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[12];
IkReal x301=IKsin(j5);
IkReal x302=IKcos(j5);
IkReal x303=(cj4*sj3);
IkReal x304=(cj3*new_r10);
IkReal x305=((1.0)*new_r01);
IkReal x306=(cj3*new_r11);
IkReal x307=((1.0)*new_r00);
IkReal x308=((1.0)*x302);
IkReal x309=(cj4*x301);
IkReal x310=((1.0)*x301);
evalcond[0]=((((-1.0)*sj4*x310))+new_r20);
evalcond[1]=((((-1.0)*sj4*x308))+new_r21);
evalcond[2]=(((new_r11*sj3))+x301+((cj3*new_r01)));
evalcond[3]=(((new_r10*sj3))+((cj3*new_r00))+(((-1.0)*x308)));
evalcond[4]=(((cj3*x301))+((x302*x303))+new_r01);
evalcond[5]=(((x301*x303))+(((-1.0)*cj3*x308))+new_r00);
evalcond[6]=(((sj3*x301))+new_r11+(((-1.0)*cj3*cj4*x308)));
evalcond[7]=((((-1.0)*sj3*x307))+(((-1.0)*x309))+x304);
evalcond[8]=((((-1.0)*sj3*x305))+(((-1.0)*cj4*x308))+x306);
evalcond[9]=((((-1.0)*sj3*x308))+(((-1.0)*cj3*x309))+new_r10);
evalcond[10]=(((new_r20*sj4))+(((-1.0)*x303*x307))+(((-1.0)*x310))+((cj4*x304)));
evalcond[11]=((((-1.0)*x303*x305))+((new_r21*sj4))+((cj4*x306))+(((-1.0)*x308)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x311=IKPowWithIntegerCheck(IKsign(sj4),-1);
if(!x311.valid){
continue;
}
CheckValue<IkReal> x312 = IKatan2WithCheck(IkReal(new_r20),IkReal(new_r21),IKFAST_ATAN2_MAGTHRESH);
if(!x312.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x311.value)))+(x312.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[12];
IkReal x313=IKsin(j5);
IkReal x314=IKcos(j5);
IkReal x315=(cj4*sj3);
IkReal x316=(cj3*new_r10);
IkReal x317=((1.0)*new_r01);
IkReal x318=(cj3*new_r11);
IkReal x319=((1.0)*new_r00);
IkReal x320=((1.0)*x314);
IkReal x321=(cj4*x313);
IkReal x322=((1.0)*x313);
evalcond[0]=(new_r20+(((-1.0)*sj4*x322)));
evalcond[1]=(new_r21+(((-1.0)*sj4*x320)));
evalcond[2]=(((new_r11*sj3))+x313+((cj3*new_r01)));
evalcond[3]=(((new_r10*sj3))+(((-1.0)*x320))+((cj3*new_r00)));
evalcond[4]=(((cj3*x313))+new_r01+((x314*x315)));
evalcond[5]=((((-1.0)*cj3*x320))+new_r00+((x313*x315)));
evalcond[6]=(new_r11+((sj3*x313))+(((-1.0)*cj3*cj4*x320)));
evalcond[7]=((((-1.0)*sj3*x319))+(((-1.0)*x321))+x316);
evalcond[8]=((((-1.0)*sj3*x317))+x318+(((-1.0)*cj4*x320)));
evalcond[9]=((((-1.0)*cj3*x321))+new_r10+(((-1.0)*sj3*x320)));
evalcond[10]=(((new_r20*sj4))+((cj4*x316))+(((-1.0)*x322))+(((-1.0)*x315*x319)));
evalcond[11]=(((cj4*x318))+(((-1.0)*x320))+(((-1.0)*x315*x317))+((new_r21*sj4)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x323=IKPowWithIntegerCheck(IKsign(sj4),-1);
if(!x323.valid){
continue;
}
CheckValue<IkReal> x324 = IKatan2WithCheck(IkReal(new_r02),IkReal(((-1.0)*new_r12)),IKFAST_ATAN2_MAGTHRESH);
if(!x324.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(((1.5707963267949)*(x323.value)))+(x324.value));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x325=IKsin(j3);
IkReal x326=IKcos(j3);
IkReal x327=((1.0)*cj4);
IkReal x328=((1.0)*sj4);
IkReal x329=(new_r02*x325);
IkReal x330=(new_r12*x326);
IkReal x331=(sj4*x326);
evalcond[0]=(x331+new_r12);
evalcond[1]=((((-1.0)*x325*x328))+new_r02);
evalcond[2]=(((new_r12*x325))+((new_r02*x326)));
evalcond[3]=(sj4+(((-1.0)*x329))+x330);
evalcond[4]=((((-1.0)*x327*x329))+((new_r22*sj4))+((cj4*x330)));
evalcond[5]=((((-1.0)*new_r00*x325*x328))+((new_r10*x331))+(((-1.0)*new_r20*x327)));
evalcond[6]=(((new_r11*x331))+(((-1.0)*new_r01*x325*x328))+(((-1.0)*new_r21*x327)));
evalcond[7]=((1.0)+(((-1.0)*new_r22*x327))+((sj4*x330))+(((-1.0)*x328*x329)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j5eval[3];
j5eval[0]=sj4;
j5eval[1]=IKsign(sj4);
j5eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
j5eval[0]=sj4;
j5eval[1]=cj3;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal j5eval[3];
j5eval[0]=sj4;
j5eval[1]=cj4;
j5eval[2]=sj3;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j4))), 6.28318530717959)));
evalcond[1]=new_r12;
evalcond[2]=new_r02;
evalcond[3]=new_r20;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x332=((1.0)*new_r01);
if( IKabs(((((-1.0)*new_r00*sj3))+(((-1.0)*cj3*x332)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*sj3*x332))+((cj3*new_r00)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*sj3))+(((-1.0)*cj3*x332))))+IKsqr(((((-1.0)*sj3*x332))+((cj3*new_r00))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*new_r00*sj3))+(((-1.0)*cj3*x332))), ((((-1.0)*sj3*x332))+((cj3*new_r00))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x333=IKsin(j5);
IkReal x334=IKcos(j5);
IkReal x335=((1.0)*sj3);
IkReal x336=(sj3*x333);
IkReal x337=((1.0)*x334);
IkReal x338=((1.0)*x333);
IkReal x339=(cj3*x337);
evalcond[0]=(((new_r11*sj3))+x333+((cj3*new_r01)));
evalcond[1]=(((new_r10*sj3))+(((-1.0)*x337))+((cj3*new_r00)));
evalcond[2]=(((sj3*x334))+((cj3*x333))+new_r01);
evalcond[3]=(x336+(((-1.0)*x339))+new_r00);
evalcond[4]=(x336+(((-1.0)*x339))+new_r11);
evalcond[5]=((((-1.0)*new_r00*x335))+((cj3*new_r10))+(((-1.0)*x338)));
evalcond[6]=(((cj3*new_r11))+(((-1.0)*x337))+(((-1.0)*new_r01*x335)));
evalcond[7]=(new_r10+(((-1.0)*x334*x335))+(((-1.0)*cj3*x338)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j4)))), 6.28318530717959)));
evalcond[1]=new_r12;
evalcond[2]=new_r02;
evalcond[3]=new_r20;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x340=((1.0)*cj3);
if( IKabs(((((-1.0)*new_r01*x340))+(((-1.0)*new_r11*sj3)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*new_r11*x340))+((new_r01*sj3)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r01*x340))+(((-1.0)*new_r11*sj3))))+IKsqr(((((-1.0)*new_r11*x340))+((new_r01*sj3))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((((-1.0)*new_r01*x340))+(((-1.0)*new_r11*sj3))), ((((-1.0)*new_r11*x340))+((new_r01*sj3))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x341=IKsin(j5);
IkReal x342=IKcos(j5);
IkReal x343=((1.0)*sj3);
IkReal x344=(cj3*x341);
IkReal x345=((1.0)*x342);
IkReal x346=(x342*x343);
evalcond[0]=(((new_r11*sj3))+x341+((cj3*new_r01)));
evalcond[1]=(x341+(((-1.0)*new_r00*x343))+((cj3*new_r10)));
evalcond[2]=(x342+((cj3*new_r11))+(((-1.0)*new_r01*x343)));
evalcond[3]=(((new_r10*sj3))+((cj3*new_r00))+(((-1.0)*x345)));
evalcond[4]=(((sj3*x341))+new_r11+((cj3*x342)));
evalcond[5]=(x344+new_r01+(((-1.0)*x346)));
evalcond[6]=(x344+new_r10+(((-1.0)*x346)));
evalcond[7]=((((-1.0)*cj3*x345))+(((-1.0)*x341*x343))+new_r00);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j4)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r20)+IKsqr(new_r21)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r20, new_r21);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x347=IKsin(j5);
IkReal x348=IKcos(j5);
IkReal x349=((1.0)*x348);
IkReal x350=((1.0)*x347);
evalcond[0]=((((-1.0)*x350))+new_r20);
evalcond[1]=(new_r21+(((-1.0)*x349)));
evalcond[2]=(((sj3*x347))+new_r11);
evalcond[3]=((((-1.0)*new_r12*x350))+new_r01);
evalcond[4]=((((-1.0)*cj3*x349))+new_r00);
evalcond[5]=(new_r10+(((-1.0)*sj3*x349)));
evalcond[6]=(((new_r11*sj3))+x347+((cj3*new_r01)));
evalcond[7]=(((new_r10*sj3))+((cj3*new_r00))+(((-1.0)*x349)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j4)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r20))+IKsqr(((-1.0)*new_r21))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0)*new_r20), ((-1.0)*new_r21));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x351=IKsin(j5);
IkReal x352=IKcos(j5);
IkReal x353=((1.0)*x352);
evalcond[0]=(x351+new_r20);
evalcond[1]=(x352+new_r21);
evalcond[2]=(new_r01+((new_r12*x351)));
evalcond[3]=(((sj3*x351))+new_r11);
evalcond[4]=((((-1.0)*cj3*x353))+new_r00);
evalcond[5]=(new_r10+(((-1.0)*sj3*x353)));
evalcond[6]=(((new_r11*sj3))+x351+((cj3*new_r01)));
evalcond[7]=(((new_r10*sj3))+(((-1.0)*x353))+((cj3*new_r00)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j3))), 6.28318530717959)));
evalcond[1]=new_r02;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r01))+IKsqr(new_r00)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0)*new_r01), new_r00);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x354=IKsin(j5);
IkReal x355=IKcos(j5);
IkReal x356=((1.0)*cj4);
IkReal x357=((1.0)*x355);
IkReal x358=((1.0)*x354);
evalcond[0]=(x354+new_r01);
evalcond[1]=((((-1.0)*x357))+new_r00);
evalcond[2]=(new_r20+(((-1.0)*sj4*x358)));
evalcond[3]=(new_r21+(((-1.0)*sj4*x357)));
evalcond[4]=(new_r11+(((-1.0)*x355*x356)));
evalcond[5]=(new_r10+(((-1.0)*x354*x356)));
evalcond[6]=(((new_r20*sj4))+((cj4*new_r10))+(((-1.0)*x358)));
evalcond[7]=(((cj4*new_r11))+(((-1.0)*x357))+((new_r21*sj4)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j3)))), 6.28318530717959)));
evalcond[1]=new_r02;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r01)+IKsqr(((-1.0)*new_r00))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r01, ((-1.0)*new_r00));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x359=IKsin(j5);
IkReal x360=IKcos(j5);
IkReal x361=((1.0)*cj4);
IkReal x362=((1.0)*x360);
IkReal x363=((1.0)*x359);
evalcond[0]=(x359+(((-1.0)*new_r01)));
evalcond[1]=(((cj4*x360))+new_r11);
evalcond[2]=((((-1.0)*sj4*x363))+new_r20);
evalcond[3]=((((-1.0)*sj4*x362))+new_r21);
evalcond[4]=((((-1.0)*x362))+(((-1.0)*new_r00)));
evalcond[5]=((((-1.0)*x359*x361))+(((-1.0)*new_r10)));
evalcond[6]=(((new_r20*sj4))+(((-1.0)*x363))+(((-1.0)*new_r10*x361)));
evalcond[7]=((((-1.0)*x362))+(((-1.0)*new_r11*x361))+((new_r21*sj4)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j3)))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r11))+IKsqr(new_r10)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0)*new_r11), new_r10);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x364=IKcos(j5);
IkReal x365=IKsin(j5);
IkReal x366=((1.0)*cj4);
IkReal x367=((1.0)*x364);
IkReal x368=((1.0)*x365);
evalcond[0]=(x365+new_r11);
evalcond[1]=((((-1.0)*x367))+new_r10);
evalcond[2]=(((cj4*x364))+new_r01);
evalcond[3]=(((cj4*x365))+new_r00);
evalcond[4]=(new_r20+(((-1.0)*new_r02*x368)));
evalcond[5]=(new_r21+(((-1.0)*new_r02*x367)));
evalcond[6]=((((-1.0)*new_r00*x366))+((new_r20*sj4))+(((-1.0)*x368)));
evalcond[7]=((((-1.0)*x367))+((new_r21*sj4))+(((-1.0)*new_r01*x366)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j3)))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[3];
sj3=-1.0;
cj3=0;
j3=-1.5707963267949;
j5eval[0]=new_r02;
j5eval[1]=IKsign(new_r02);
j5eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  || IKabs(j5eval[2]) < 0.0000010000000000  )
{
{
IkReal j5eval[1];
sj3=-1.0;
cj3=0;
j3=-1.5707963267949;
j5eval[0]=new_r02;
if( IKabs(j5eval[0]) < 0.0000010000000000  )
{
{
IkReal j5eval[2];
sj3=-1.0;
cj3=0;
j3=-1.5707963267949;
j5eval[0]=new_r02;
j5eval[1]=cj4;
if( IKabs(j5eval[0]) < 0.0000010000000000  || IKabs(j5eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[4];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j4)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r20)+IKsqr(new_r21)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r20, new_r21);
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[4];
IkReal x369=IKsin(j5);
IkReal x370=((1.0)*(IKcos(j5)));
evalcond[0]=((((-1.0)*x369))+new_r20);
evalcond[1]=((((-1.0)*x370))+new_r21);
evalcond[2]=(x369+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*x370))+(((-1.0)*new_r10)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j4)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r11)+IKsqr(((-1.0)*new_r21))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r11, ((-1.0)*new_r21));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[4];
IkReal x371=IKsin(j5);
IkReal x372=IKcos(j5);
evalcond[0]=(x371+new_r20);
evalcond[1]=(x372+new_r21);
evalcond[2]=(x371+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*x372))+(((-1.0)*new_r10)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(new_r02);
evalcond[1]=new_r20;
evalcond[2]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r11)+IKsqr(((-1.0)*new_r10))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r11, ((-1.0)*new_r10));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[6];
IkReal x373=IKsin(j5);
IkReal x374=IKcos(j5);
IkReal x375=((1.0)*cj4);
IkReal x376=((1.0)*x374);
evalcond[0]=(x373+(((-1.0)*new_r11)));
evalcond[1]=((((-1.0)*x374*x375))+new_r01);
evalcond[2]=((((-1.0)*x373*x375))+new_r00);
evalcond[3]=((((-1.0)*x376))+(((-1.0)*new_r10)));
evalcond[4]=((((-1.0)*x373))+((cj4*new_r00)));
evalcond[5]=(((cj4*new_r01))+(((-1.0)*x376)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
if( IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r11)+IKsqr(((-1.0)*new_r10))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r11, ((-1.0)*new_r10));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[6];
IkReal x377=IKcos(j5);
IkReal x378=IKsin(j5);
IkReal x379=((-1.0)*x378);
IkReal x380=((-1.0)*x377);
evalcond[0]=x379;
evalcond[1]=x380;
evalcond[2]=(new_r22*x380);
evalcond[3]=(new_r22*x379);
evalcond[4]=(x378+(((-1.0)*new_r11)));
evalcond[5]=((((-1.0)*x377))+(((-1.0)*new_r10)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x381=IKPowWithIntegerCheck(new_r02,-1);
if(!x381.valid){
continue;
}
CheckValue<IkReal> x382=IKPowWithIntegerCheck(cj4,-1);
if(!x382.valid){
continue;
}
if( IKabs(((-1.0)*new_r20*(x381.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r01*(x382.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r20*(x381.value)))+IKsqr((new_r01*(x382.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(((-1.0)*new_r20*(x381.value)), (new_r01*(x382.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x383=IKsin(j5);
IkReal x384=IKcos(j5);
IkReal x385=((1.0)*cj4);
IkReal x386=((1.0)*x384);
evalcond[0]=(((new_r02*x383))+new_r20);
evalcond[1]=(((new_r02*x384))+new_r21);
evalcond[2]=(x383+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*x384*x385))+new_r01);
evalcond[4]=(new_r00+(((-1.0)*x383*x385)));
evalcond[5]=((((-1.0)*x386))+(((-1.0)*new_r10)));
evalcond[6]=(((new_r20*sj4))+((cj4*new_r00))+(((-1.0)*x383)));
evalcond[7]=(((cj4*new_r01))+(((-1.0)*x386))+((new_r21*sj4)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x387=IKPowWithIntegerCheck(new_r02,-1);
if(!x387.valid){
continue;
}
if( IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r21*(x387.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r11)+IKsqr(((-1.0)*new_r21*(x387.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2(new_r11, ((-1.0)*new_r21*(x387.value)));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x388=IKsin(j5);
IkReal x389=IKcos(j5);
IkReal x390=((1.0)*cj4);
IkReal x391=((1.0)*x389);
evalcond[0]=(((new_r02*x388))+new_r20);
evalcond[1]=(((new_r02*x389))+new_r21);
evalcond[2]=(x388+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*x389*x390))+new_r01);
evalcond[4]=((((-1.0)*x388*x390))+new_r00);
evalcond[5]=((((-1.0)*x391))+(((-1.0)*new_r10)));
evalcond[6]=(((new_r20*sj4))+((cj4*new_r00))+(((-1.0)*x388)));
evalcond[7]=((((-1.0)*x391))+((cj4*new_r01))+((new_r21*sj4)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x392=IKPowWithIntegerCheck(IKsign(new_r02),-1);
if(!x392.valid){
continue;
}
CheckValue<IkReal> x393 = IKatan2WithCheck(IkReal(((-1.0)*new_r20)),IkReal(((-1.0)*new_r21)),IKFAST_ATAN2_MAGTHRESH);
if(!x393.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x392.value)))+(x393.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[8];
IkReal x394=IKsin(j5);
IkReal x395=IKcos(j5);
IkReal x396=((1.0)*cj4);
IkReal x397=((1.0)*x395);
evalcond[0]=(new_r20+((new_r02*x394)));
evalcond[1]=(new_r21+((new_r02*x395)));
evalcond[2]=(x394+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*x395*x396))+new_r01);
evalcond[4]=((((-1.0)*x394*x396))+new_r00);
evalcond[5]=((((-1.0)*x397))+(((-1.0)*new_r10)));
evalcond[6]=((((-1.0)*x394))+((new_r20*sj4))+((cj4*new_r00)));
evalcond[7]=((((-1.0)*x397))+((cj4*new_r01))+((new_r21*sj4)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j5eval[1];
new_r21=0;
new_r20=0;
new_r02=0;
new_r12=0;
j5eval[0]=1.0;
if( IKabs(j5eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j5]

} else
{
IkReal op[2+1], zeror[2];
int numroots;
op[0]=1.0;
op[1]=0;
op[2]=-1.0;
polyroots2(op,zeror,numroots);
IkReal j5array[2], cj5array[2], sj5array[2], tempj5array[1];
int numsolutions = 0;
for(int ij5 = 0; ij5 < numroots; ++ij5)
{
IkReal htj5 = zeror[ij5];
tempj5array[0]=((2.0)*(atan(htj5)));
for(int kj5 = 0; kj5 < 1; ++kj5)
{
j5array[numsolutions] = tempj5array[kj5];
if( j5array[numsolutions] > IKPI )
{
    j5array[numsolutions]-=IK2PI;
}
else if( j5array[numsolutions] < -IKPI )
{
    j5array[numsolutions]+=IK2PI;
}
sj5array[numsolutions] = IKsin(j5array[numsolutions]);
cj5array[numsolutions] = IKcos(j5array[numsolutions]);
numsolutions++;
}
}
bool j5valid[2]={true,true};
_nj5 = 2;
for(int ij5 = 0; ij5 < numsolutions; ++ij5)
    {
if( !j5valid[ij5] )
{
    continue;
}
    j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
htj5 = IKtan(j5/2);

_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < numsolutions; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j5]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x399=IKPowWithIntegerCheck(sj4,-1);
if(!x399.valid){
continue;
}
IkReal x398=x399.value;
CheckValue<IkReal> x400=IKPowWithIntegerCheck(cj4,-1);
if(!x400.valid){
continue;
}
CheckValue<IkReal> x401=IKPowWithIntegerCheck(sj3,-1);
if(!x401.valid){
continue;
}
if( IKabs((new_r20*x398)) < IKFAST_ATAN2_MAGTHRESH && IKabs((x398*(x400.value)*(x401.value)*(((((-1.0)*new_r01*sj4))+(((-1.0)*cj3*new_r20)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r20*x398))+IKsqr((x398*(x400.value)*(x401.value)*(((((-1.0)*new_r01*sj4))+(((-1.0)*cj3*new_r20))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((new_r20*x398), (x398*(x400.value)*(x401.value)*(((((-1.0)*new_r01*sj4))+(((-1.0)*cj3*new_r20))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[12];
IkReal x402=IKsin(j5);
IkReal x403=IKcos(j5);
IkReal x404=(cj4*sj3);
IkReal x405=(cj3*new_r10);
IkReal x406=((1.0)*new_r01);
IkReal x407=(cj3*new_r11);
IkReal x408=((1.0)*new_r00);
IkReal x409=((1.0)*x403);
IkReal x410=(cj4*x402);
IkReal x411=((1.0)*x402);
evalcond[0]=((((-1.0)*sj4*x411))+new_r20);
evalcond[1]=((((-1.0)*sj4*x409))+new_r21);
evalcond[2]=(((new_r11*sj3))+x402+((cj3*new_r01)));
evalcond[3]=(((new_r10*sj3))+((cj3*new_r00))+(((-1.0)*x409)));
evalcond[4]=(new_r01+((x403*x404))+((cj3*x402)));
evalcond[5]=((((-1.0)*cj3*x409))+new_r00+((x402*x404)));
evalcond[6]=(((sj3*x402))+(((-1.0)*cj3*cj4*x409))+new_r11);
evalcond[7]=(x405+(((-1.0)*sj3*x408))+(((-1.0)*x410)));
evalcond[8]=(x407+(((-1.0)*cj4*x409))+(((-1.0)*sj3*x406)));
evalcond[9]=((((-1.0)*cj3*x410))+new_r10+(((-1.0)*sj3*x409)));
evalcond[10]=(((new_r20*sj4))+((cj4*x405))+(((-1.0)*x404*x408))+(((-1.0)*x411)));
evalcond[11]=(((cj4*x407))+(((-1.0)*x404*x406))+((new_r21*sj4))+(((-1.0)*x409)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x413=IKPowWithIntegerCheck(sj4,-1);
if(!x413.valid){
continue;
}
IkReal x412=x413.value;
CheckValue<IkReal> x414=IKPowWithIntegerCheck(cj3,-1);
if(!x414.valid){
continue;
}
if( IKabs((new_r20*x412)) < IKFAST_ATAN2_MAGTHRESH && IKabs((x412*(x414.value)*((((new_r00*sj4))+((cj4*new_r20*sj3)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r20*x412))+IKsqr((x412*(x414.value)*((((new_r00*sj4))+((cj4*new_r20*sj3))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j5array[0]=IKatan2((new_r20*x412), (x412*(x414.value)*((((new_r00*sj4))+((cj4*new_r20*sj3))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[12];
IkReal x415=IKsin(j5);
IkReal x416=IKcos(j5);
IkReal x417=(cj4*sj3);
IkReal x418=(cj3*new_r10);
IkReal x419=((1.0)*new_r01);
IkReal x420=(cj3*new_r11);
IkReal x421=((1.0)*new_r00);
IkReal x422=((1.0)*x416);
IkReal x423=(cj4*x415);
IkReal x424=((1.0)*x415);
evalcond[0]=(new_r20+(((-1.0)*sj4*x424)));
evalcond[1]=(new_r21+(((-1.0)*sj4*x422)));
evalcond[2]=(((new_r11*sj3))+x415+((cj3*new_r01)));
evalcond[3]=(((new_r10*sj3))+(((-1.0)*x422))+((cj3*new_r00)));
evalcond[4]=(((x416*x417))+new_r01+((cj3*x415)));
evalcond[5]=((((-1.0)*cj3*x422))+((x415*x417))+new_r00);
evalcond[6]=(((sj3*x415))+(((-1.0)*cj3*cj4*x422))+new_r11);
evalcond[7]=((((-1.0)*x423))+(((-1.0)*sj3*x421))+x418);
evalcond[8]=(x420+(((-1.0)*cj4*x422))+(((-1.0)*sj3*x419)));
evalcond[9]=((((-1.0)*sj3*x422))+(((-1.0)*cj3*x423))+new_r10);
evalcond[10]=(((new_r20*sj4))+(((-1.0)*x424))+((cj4*x418))+(((-1.0)*x417*x421)));
evalcond[11]=((((-1.0)*x417*x419))+(((-1.0)*x422))+((cj4*x420))+((new_r21*sj4)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x425=IKPowWithIntegerCheck(IKsign(sj4),-1);
if(!x425.valid){
continue;
}
CheckValue<IkReal> x426 = IKatan2WithCheck(IkReal(new_r20),IkReal(new_r21),IKFAST_ATAN2_MAGTHRESH);
if(!x426.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x425.value)))+(x426.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[12];
IkReal x427=IKsin(j5);
IkReal x428=IKcos(j5);
IkReal x429=(cj4*sj3);
IkReal x430=(cj3*new_r10);
IkReal x431=((1.0)*new_r01);
IkReal x432=(cj3*new_r11);
IkReal x433=((1.0)*new_r00);
IkReal x434=((1.0)*x428);
IkReal x435=(cj4*x427);
IkReal x436=((1.0)*x427);
evalcond[0]=(new_r20+(((-1.0)*sj4*x436)));
evalcond[1]=(new_r21+(((-1.0)*sj4*x434)));
evalcond[2]=(((new_r11*sj3))+x427+((cj3*new_r01)));
evalcond[3]=((((-1.0)*x434))+((new_r10*sj3))+((cj3*new_r00)));
evalcond[4]=(((x428*x429))+((cj3*x427))+new_r01);
evalcond[5]=((((-1.0)*cj3*x434))+((x427*x429))+new_r00);
evalcond[6]=((((-1.0)*cj3*cj4*x434))+((sj3*x427))+new_r11);
evalcond[7]=((((-1.0)*sj3*x433))+(((-1.0)*x435))+x430);
evalcond[8]=((((-1.0)*sj3*x431))+(((-1.0)*cj4*x434))+x432);
evalcond[9]=((((-1.0)*sj3*x434))+(((-1.0)*cj3*x435))+new_r10);
evalcond[10]=((((-1.0)*x436))+((new_r20*sj4))+((cj4*x430))+(((-1.0)*x429*x433)));
evalcond[11]=((((-1.0)*x434))+((cj4*x432))+(((-1.0)*x429*x431))+((new_r21*sj4)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
CheckValue<IkReal> x437=IKPowWithIntegerCheck(IKsign(sj4),-1);
if(!x437.valid){
continue;
}
CheckValue<IkReal> x438 = IKatan2WithCheck(IkReal(new_r20),IkReal(new_r21),IKFAST_ATAN2_MAGTHRESH);
if(!x438.valid){
continue;
}
j5array[0]=((-1.5707963267949)+(((1.5707963267949)*(x437.value)))+(x438.value));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[2];
IkReal x439=((1.0)*sj4);
evalcond[0]=((((-1.0)*x439*(IKsin(j5))))+new_r20);
evalcond[1]=((((-1.0)*x439*(IKcos(j5))))+new_r21);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j3eval[3];
j3eval[0]=sj4;
j3eval[1]=IKsign(sj4);
j3eval[2]=((IKabs(new_r12))+(IKabs(new_r02)));
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  || IKabs(j3eval[2]) < 0.0000010000000000  )
{
{
IkReal j3eval[2];
j3eval[0]=new_r11;
j3eval[1]=sj4;
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j4))), 6.28318530717959)));
evalcond[1]=new_r12;
evalcond[2]=new_r02;
evalcond[3]=new_r20;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x440=((1.0)*new_r01);
if( IKabs(((((-1.0)*cj5*x440))+(((-1.0)*new_r00*sj5)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*sj5*x440))+((cj5*new_r00)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*cj5*x440))+(((-1.0)*new_r00*sj5))))+IKsqr(((((-1.0)*sj5*x440))+((cj5*new_r00))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((-1.0)*cj5*x440))+(((-1.0)*new_r00*sj5))), ((((-1.0)*sj5*x440))+((cj5*new_r00))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x441=IKcos(j3);
IkReal x442=IKsin(j3);
IkReal x443=((1.0)*cj5);
IkReal x444=(sj5*x442);
IkReal x445=(sj5*x441);
IkReal x446=((1.0)*x442);
IkReal x447=(x441*x443);
evalcond[0]=(((new_r01*x441))+sj5+((new_r11*x442)));
evalcond[1]=(((cj5*x442))+x445+new_r01);
evalcond[2]=((((-1.0)*x447))+x444+new_r00);
evalcond[3]=((((-1.0)*x447))+x444+new_r11);
evalcond[4]=(((new_r00*x441))+(((-1.0)*x443))+((new_r10*x442)));
evalcond[5]=((((-1.0)*x445))+new_r10+(((-1.0)*x442*x443)));
evalcond[6]=((((-1.0)*sj5))+(((-1.0)*new_r00*x446))+((new_r10*x441)));
evalcond[7]=((((-1.0)*x443))+(((-1.0)*new_r01*x446))+((new_r11*x441)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j4)))), 6.28318530717959)));
evalcond[1]=new_r12;
evalcond[2]=new_r02;
evalcond[3]=new_r20;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3eval[3];
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
IkReal x448=(((new_r11*sj5))+((cj5*new_r01)));
j3eval[0]=x448;
j3eval[1]=IKsign(x448);
j3eval[2]=((IKabs(((((-1.0)*cj5*sj5))+(((-1.0)*new_r01*new_r11)))))+(IKabs(((-1.0)+(new_r01*new_r01)+(cj5*cj5)))));
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  || IKabs(j3eval[2]) < 0.0000010000000000  )
{
{
IkReal j3eval[3];
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
IkReal x449=((1.0)*sj5);
IkReal x450=(((new_r10*new_r11))+((new_r00*new_r01)));
j3eval[0]=x450;
j3eval[1]=IKsign(x450);
j3eval[2]=((IKabs((((new_r01*sj5))+(((-1.0)*new_r10*x449)))))+(IKabs(((((-1.0)*new_r00*x449))+(((-1.0)*new_r11*x449))))));
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  || IKabs(j3eval[2]) < 0.0000010000000000  )
{
{
IkReal j3eval[3];
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
IkReal x451=((1.0)*sj5);
IkReal x452=((new_r01*new_r01)+(new_r11*new_r11));
j3eval[0]=x452;
j3eval[1]=((IKabs((((cj5*new_r01))+(((-1.0)*new_r11*x451)))))+(IKabs(((((-1.0)*new_r01*x451))+(((-1.0)*cj5*new_r11))))));
j3eval[2]=IKsign(x452);
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  || IKabs(j3eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((new_r01*new_r01)+(new_r11*new_r11));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3eval[1];
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
new_r01=0;
new_r11=0;
j3eval[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
CheckValue<IkReal> x454 = IKatan2WithCheck(IkReal(new_r00),IkReal(new_r10),IKFAST_ATAN2_MAGTHRESH);
if(!x454.valid){
continue;
}
IkReal x453=x454.value;
j3array[0]=((-1.0)*x453);
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
j3array[1]=((3.14159265358979)+(((-1.0)*x453)));
sj3array[1]=IKsin(j3array[1]);
cj3array[1]=IKcos(j3array[1]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
if( j3array[1] > IKPI )
{
    j3array[1]-=IK2PI;
}
else if( j3array[1] < -IKPI )
{    j3array[1]+=IK2PI;
}
j3valid[1] = true;
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[1];
evalcond[0]=((((-1.0)*new_r00*(IKsin(j3))))+((new_r10*(IKcos(j3)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j5))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
if( IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r01)+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(new_r01, ((-1.0)*new_r11));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x455=IKcos(j3);
IkReal x456=IKsin(j3);
IkReal x457=((1.0)*x456);
evalcond[0]=(x455+new_r11);
evalcond[1]=((((-1.0)*x457))+new_r01);
evalcond[2]=((((-1.0)*x455))+new_r00);
evalcond[3]=((((-1.0)*x457))+new_r10);
evalcond[4]=(((new_r11*x456))+((new_r01*x455)));
evalcond[5]=((-1.0)+((new_r10*x456))+((new_r00*x455)));
evalcond[6]=(((new_r10*x455))+(((-1.0)*new_r00*x457)));
evalcond[7]=((1.0)+((new_r11*x455))+(((-1.0)*new_r01*x457)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j5)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
if( IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r01))+IKsqr(((-1.0)*new_r00))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((-1.0)*new_r01), ((-1.0)*new_r00));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x458=IKsin(j3);
IkReal x459=IKcos(j3);
IkReal x460=((1.0)*x458);
evalcond[0]=(x458+new_r01);
evalcond[1]=(x459+new_r00);
evalcond[2]=(x458+new_r10);
evalcond[3]=((((-1.0)*x459))+new_r11);
evalcond[4]=(((new_r11*x458))+((new_r01*x459)));
evalcond[5]=((1.0)+((new_r10*x458))+((new_r00*x459)));
evalcond[6]=(((new_r10*x459))+(((-1.0)*new_r00*x460)));
evalcond[7]=((-1.0)+((new_r11*x459))+(((-1.0)*new_r01*x460)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x462 = ((new_r01*new_r01)+(new_r11*new_r11));
if(IKabs(x462)==0){
continue;
}
IkReal x461=pow(x462,-0.5);
CheckValue<IkReal> x463 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x463.valid){
continue;
}
IkReal gconst0=((-1.0)*(x463.value));
IkReal gconst1=((-1.0)*new_r01*x461);
IkReal gconst2=(new_r11*x461);
CheckValue<IkReal> x464 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x464.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((x464.value)+j5)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3eval[3];
CheckValue<IkReal> x467 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x467.valid){
continue;
}
IkReal x465=((-1.0)*(x467.value));
IkReal x466=x461;
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst1;
cj5=gconst2;
j5=x465;
IkReal gconst0=x465;
IkReal gconst1=((-1.0)*new_r01*x466);
IkReal gconst2=(new_r11*x466);
IkReal x468=new_r01*new_r01;
IkReal x469=(new_r00*new_r01);
IkReal x470=(((new_r10*new_r11))+x469);
IkReal x471=x461;
IkReal x472=(new_r01*x471);
j3eval[0]=x470;
j3eval[1]=((IKabs((((x469*x471))+((new_r11*x472)))))+(IKabs((((new_r10*x472))+(((-1.0)*x468*x471))))));
j3eval[2]=IKsign(x470);
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  || IKabs(j3eval[2]) < 0.0000010000000000  )
{
{
IkReal j3eval[2];
CheckValue<IkReal> x475 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x475.valid){
continue;
}
IkReal x473=((-1.0)*(x475.value));
IkReal x474=x461;
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst1;
cj5=gconst2;
j5=x473;
IkReal gconst0=x473;
IkReal gconst1=((-1.0)*new_r01*x474);
IkReal gconst2=(new_r11*x474);
IkReal x476=((new_r01*new_r01)+(new_r11*new_r11));
j3eval[0]=x476;
j3eval[1]=IKsign(x476);
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  )
{
{
IkReal j3eval[1];
CheckValue<IkReal> x479 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x479.valid){
continue;
}
IkReal x477=((-1.0)*(x479.value));
IkReal x478=x461;
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst1;
cj5=gconst2;
j5=x477;
IkReal gconst0=x477;
IkReal gconst1=((-1.0)*new_r01*x478);
IkReal gconst2=(new_r11*x478);
j3eval[0]=((new_r01*new_r01)+(new_r11*new_r11));
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((gconst1*gconst1)+(gconst2*gconst2));
evalcond[1]=new_r01;
evalcond[2]=new_r00;
evalcond[3]=new_r11;
evalcond[4]=new_r10;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3array[4], cj3array[4], sj3array[4];
bool j3valid[4]={false};
_nj3 = 4;
j3array[0]=0;
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
j3array[1]=1.5707963267949;
sj3array[1]=IKsin(j3array[1]);
cj3array[1]=IKcos(j3array[1]);
j3array[2]=3.14159265358979;
sj3array[2]=IKsin(j3array[2]);
cj3array[2]=IKcos(j3array[2]);
j3array[3]=-1.5707963267949;
sj3array[3]=IKsin(j3array[3]);
cj3array[3]=IKcos(j3array[3]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
if( j3array[1] > IKPI )
{
    j3array[1]-=IK2PI;
}
else if( j3array[1] < -IKPI )
{    j3array[1]+=IK2PI;
}
j3valid[1] = true;
if( j3array[2] > IKPI )
{
    j3array[2]-=IK2PI;
}
else if( j3array[2] < -IKPI )
{    j3array[2]+=IK2PI;
}
j3valid[2] = true;
if( j3array[3] > IKPI )
{
    j3array[3]-=IK2PI;
}
else if( j3array[3] < -IKPI )
{    j3array[3]+=IK2PI;
}
j3valid[3] = true;
for(int ij3 = 0; ij3 < 4; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 4; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r00)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3eval[1];
CheckValue<IkReal> x481 = IKatan2WithCheck(IkReal(new_r01),IkReal(0),IKFAST_ATAN2_MAGTHRESH);
if(!x481.valid){
continue;
}
IkReal x480=((-1.0)*(x481.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst1;
cj5=gconst2;
j5=x480;
new_r11=0;
new_r00=0;
IkReal gconst0=x480;
IkReal x482 = new_r01*new_r01;
if(IKabs(x482)==0){
continue;
}
IkReal gconst1=((-1.0)*new_r01*(pow(x482,-0.5)));
IkReal gconst2=0;
j3eval[0]=new_r01;
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
CheckValue<IkReal> x483=IKPowWithIntegerCheck(gconst1,-1);
if(!x483.valid){
continue;
}
cj3array[0]=((-1.0)*new_r01*(x483.value));
if( cj3array[0] >= -1-IKFAST_SINCOS_THRESH && cj3array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j3valid[0] = j3valid[1] = true;
    j3array[0] = IKacos(cj3array[0]);
    sj3array[0] = IKsin(j3array[0]);
    cj3array[1] = cj3array[0];
    j3array[1] = -j3array[0];
    sj3array[1] = -sj3array[0];
}
else if( isnan(cj3array[0]) )
{
    // probably any value will work
    j3valid[0] = true;
    cj3array[0] = 1; sj3array[0] = 0; j3array[0] = 0;
}
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x484=IKsin(j3);
IkReal x485=IKcos(j3);
IkReal x486=((-1.0)*x484);
evalcond[0]=(new_r10*x484);
evalcond[1]=(gconst1*x486);
evalcond[2]=(new_r01*x486);
evalcond[3]=(gconst1+((new_r01*x485)));
evalcond[4]=(gconst1+((new_r10*x485)));
evalcond[5]=(new_r10+((gconst1*x485)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
CheckValue<IkReal> x487=IKPowWithIntegerCheck(new_r01,-1);
if(!x487.valid){
continue;
}
cj3array[0]=((-1.0)*gconst1*(x487.value));
if( cj3array[0] >= -1-IKFAST_SINCOS_THRESH && cj3array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j3valid[0] = j3valid[1] = true;
    j3array[0] = IKacos(cj3array[0]);
    sj3array[0] = IKsin(j3array[0]);
    cj3array[1] = cj3array[0];
    j3array[1] = -j3array[0];
    sj3array[1] = -sj3array[0];
}
else if( isnan(cj3array[0]) )
{
    // probably any value will work
    j3valid[0] = true;
    cj3array[0] = 1; sj3array[0] = 0; j3array[0] = 0;
}
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x488=IKsin(j3);
IkReal x489=IKcos(j3);
IkReal x490=(gconst1*x489);
IkReal x491=((-1.0)*x488);
evalcond[0]=(new_r10*x488);
evalcond[1]=(gconst1*x491);
evalcond[2]=(new_r01*x491);
evalcond[3]=(x490+new_r01);
evalcond[4]=(gconst1+((new_r10*x489)));
evalcond[5]=(x490+new_r10);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r10))+(IKabs(new_r00)));
evalcond[1]=gconst1;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3eval[3];
CheckValue<IkReal> x493 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x493.valid){
continue;
}
IkReal x492=((-1.0)*(x493.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst1;
cj5=gconst2;
j5=x492;
new_r00=0;
new_r10=0;
new_r21=0;
new_r22=0;
IkReal gconst0=x492;
IkReal gconst1=((-1.0)*new_r01);
IkReal gconst2=new_r11;
j3eval[0]=-1.0;
j3eval[1]=((IKabs(new_r01*new_r01))+(IKabs((new_r01*new_r11))));
j3eval[2]=-1.0;
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  || IKabs(j3eval[2]) < 0.0000010000000000  )
{
{
IkReal j3eval[3];
CheckValue<IkReal> x495 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x495.valid){
continue;
}
IkReal x494=((-1.0)*(x495.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst1;
cj5=gconst2;
j5=x494;
new_r00=0;
new_r10=0;
new_r21=0;
new_r22=0;
IkReal gconst0=x494;
IkReal gconst1=((-1.0)*new_r01);
IkReal gconst2=new_r11;
j3eval[0]=-1.0;
j3eval[1]=-1.0;
j3eval[2]=((IKabs((new_r01*new_r11)))+(IKabs(((1.0)+(((-1.0)*(new_r01*new_r01)))))));
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  || IKabs(j3eval[2]) < 0.0000010000000000  )
{
{
IkReal j3eval[3];
CheckValue<IkReal> x497 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x497.valid){
continue;
}
IkReal x496=((-1.0)*(x497.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst1;
cj5=gconst2;
j5=x496;
new_r00=0;
new_r10=0;
new_r21=0;
new_r22=0;
IkReal gconst0=x496;
IkReal gconst1=((-1.0)*new_r01);
IkReal gconst2=new_r11;
j3eval[0]=1.0;
j3eval[1]=((((0.5)*(IKabs(((-1.0)+(((2.0)*(new_r01*new_r01))))))))+(IKabs((new_r01*new_r11))));
j3eval[2]=1.0;
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  || IKabs(j3eval[2]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x498=((1.0)*new_r11);
CheckValue<IkReal> x499 = IKatan2WithCheck(IkReal((((gconst2*new_r01))+(((-1.0)*gconst1*x498)))),IkReal(((((-1.0)*gconst2*x498))+(((-1.0)*gconst1*new_r01)))),IKFAST_ATAN2_MAGTHRESH);
if(!x499.valid){
continue;
}
CheckValue<IkReal> x500=IKPowWithIntegerCheck(IKsign(((new_r01*new_r01)+(new_r11*new_r11))),-1);
if(!x500.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(x499.value)+(((1.5707963267949)*(x500.value))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x501=IKcos(j3);
IkReal x502=IKsin(j3);
IkReal x503=((1.0)*gconst2);
IkReal x504=(gconst1*x501);
IkReal x505=(gconst1*x502);
IkReal x506=(x502*x503);
evalcond[0]=(gconst1+((new_r11*x502))+((new_r01*x501)));
evalcond[1]=(((gconst2*x501))+x505+new_r11);
evalcond[2]=((((-1.0)*x506))+x504);
evalcond[3]=((((-1.0)*x506))+x504+new_r01);
evalcond[4]=((((-1.0)*x501*x503))+(((-1.0)*x505)));
evalcond[5]=((((-1.0)*new_r01*x502))+gconst2+((new_r11*x501)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x507=IKPowWithIntegerCheck(IKsign(((((-1.0)*(gconst2*gconst2)))+(((-1.0)*(gconst1*gconst1))))),-1);
if(!x507.valid){
continue;
}
CheckValue<IkReal> x508 = IKatan2WithCheck(IkReal((gconst1*new_r11)),IkReal((gconst2*new_r11)),IKFAST_ATAN2_MAGTHRESH);
if(!x508.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(((1.5707963267949)*(x507.value)))+(x508.value));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x509=IKcos(j3);
IkReal x510=IKsin(j3);
IkReal x511=((1.0)*gconst2);
IkReal x512=(gconst1*x509);
IkReal x513=(gconst1*x510);
IkReal x514=(x510*x511);
evalcond[0]=(((new_r11*x510))+gconst1+((new_r01*x509)));
evalcond[1]=(((gconst2*x509))+x513+new_r11);
evalcond[2]=(x512+(((-1.0)*x514)));
evalcond[3]=(x512+new_r01+(((-1.0)*x514)));
evalcond[4]=((((-1.0)*x513))+(((-1.0)*x509*x511)));
evalcond[5]=(gconst2+((new_r11*x509))+(((-1.0)*new_r01*x510)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x515=IKPowWithIntegerCheck(IKsign((((gconst1*new_r01))+(((-1.0)*gconst2*new_r11)))),-1);
if(!x515.valid){
continue;
}
CheckValue<IkReal> x516 = IKatan2WithCheck(IkReal((gconst1*gconst2)),IkReal(((-1.0)*(gconst1*gconst1))),IKFAST_ATAN2_MAGTHRESH);
if(!x516.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(((1.5707963267949)*(x515.value)))+(x516.value));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x517=IKcos(j3);
IkReal x518=IKsin(j3);
IkReal x519=((1.0)*gconst2);
IkReal x520=(gconst1*x517);
IkReal x521=(gconst1*x518);
IkReal x522=(x518*x519);
evalcond[0]=(((new_r01*x517))+((new_r11*x518))+gconst1);
evalcond[1]=(x521+((gconst2*x517))+new_r11);
evalcond[2]=((((-1.0)*x522))+x520);
evalcond[3]=((((-1.0)*x522))+x520+new_r01);
evalcond[4]=((((-1.0)*x521))+(((-1.0)*x517*x519)));
evalcond[5]=(((new_r11*x517))+gconst2+(((-1.0)*new_r01*x518)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r10))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
CheckValue<IkReal> x523=IKPowWithIntegerCheck(gconst2,-1);
if(!x523.valid){
continue;
}
cj3array[0]=(new_r00*(x523.value));
if( cj3array[0] >= -1-IKFAST_SINCOS_THRESH && cj3array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j3valid[0] = j3valid[1] = true;
    j3array[0] = IKacos(cj3array[0]);
    sj3array[0] = IKsin(j3array[0]);
    cj3array[1] = cj3array[0];
    j3array[1] = -j3array[0];
    sj3array[1] = -sj3array[0];
}
else if( isnan(cj3array[0]) )
{
    // probably any value will work
    j3valid[0] = true;
    cj3array[0] = 1; sj3array[0] = 0; j3array[0] = 0;
}
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x524=IKsin(j3);
IkReal x525=IKcos(j3);
IkReal x526=((-1.0)*x524);
evalcond[0]=(new_r11*x524);
evalcond[1]=(gconst2*x526);
evalcond[2]=(new_r00*x526);
evalcond[3]=(((gconst2*x525))+new_r11);
evalcond[4]=(gconst2+((new_r11*x525)));
evalcond[5]=((((-1.0)*gconst2))+((new_r00*x525)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r00))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3eval[1];
CheckValue<IkReal> x528 = IKatan2WithCheck(IkReal(0),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x528.valid){
continue;
}
IkReal x527=((-1.0)*(x528.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst1;
cj5=gconst2;
j5=x527;
new_r00=0;
new_r01=0;
new_r12=0;
new_r22=0;
IkReal gconst0=x527;
IkReal gconst1=0;
IkReal x529 = ((1.0)+(((-1.0)*(new_r10*new_r10))));
if(IKabs(x529)==0){
continue;
}
IkReal gconst2=(new_r11*(pow(x529,-0.5)));
j3eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
{
IkReal j3eval[1];
CheckValue<IkReal> x531 = IKatan2WithCheck(IkReal(0),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x531.valid){
continue;
}
IkReal x530=((-1.0)*(x531.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst1;
cj5=gconst2;
j5=x530;
new_r00=0;
new_r01=0;
new_r12=0;
new_r22=0;
IkReal gconst0=x530;
IkReal gconst1=0;
IkReal x532 = ((1.0)+(((-1.0)*(new_r10*new_r10))));
if(IKabs(x532)==0){
continue;
}
IkReal gconst2=(new_r11*(pow(x532,-0.5)));
j3eval[0]=new_r11;
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
{
IkReal j3eval[1];
CheckValue<IkReal> x534 = IKatan2WithCheck(IkReal(0),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x534.valid){
continue;
}
IkReal x533=((-1.0)*(x534.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst1;
cj5=gconst2;
j5=x533;
new_r00=0;
new_r01=0;
new_r12=0;
new_r22=0;
IkReal gconst0=x533;
IkReal gconst1=0;
IkReal x535 = ((1.0)+(((-1.0)*(new_r10*new_r10))));
if(IKabs(x535)==0){
continue;
}
IkReal gconst2=(new_r11*(pow(x535,-0.5)));
j3eval[0]=new_r10;
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x536=IKPowWithIntegerCheck(new_r10,-1);
if(!x536.valid){
continue;
}
CheckValue<IkReal> x537=IKPowWithIntegerCheck(gconst2,-1);
if(!x537.valid){
continue;
}
if( IKabs((gconst2*(x536.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11*(x537.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((gconst2*(x536.value)))+IKsqr(((-1.0)*new_r11*(x537.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2((gconst2*(x536.value)), ((-1.0)*new_r11*(x537.value)));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x538=IKsin(j3);
IkReal x539=IKcos(j3);
IkReal x540=(gconst2*x538);
IkReal x541=(gconst2*x539);
evalcond[0]=(new_r11*x538);
evalcond[1]=(new_r10*x539);
evalcond[2]=((-1.0)*x540);
evalcond[3]=((-1.0)*x541);
evalcond[4]=(x541+new_r11);
evalcond[5]=(gconst2+((new_r11*x539)));
evalcond[6]=((((-1.0)*x540))+new_r10);
evalcond[7]=((((-1.0)*gconst2))+((new_r10*x538)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x542=IKPowWithIntegerCheck(gconst2,-1);
if(!x542.valid){
continue;
}
CheckValue<IkReal> x543=IKPowWithIntegerCheck(new_r11,-1);
if(!x543.valid){
continue;
}
if( IKabs((new_r10*(x542.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*gconst2*(x543.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r10*(x542.value)))+IKsqr(((-1.0)*gconst2*(x543.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2((new_r10*(x542.value)), ((-1.0)*gconst2*(x543.value)));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x544=IKsin(j3);
IkReal x545=IKcos(j3);
IkReal x546=(gconst2*x544);
IkReal x547=(gconst2*x545);
evalcond[0]=(new_r11*x544);
evalcond[1]=(new_r10*x545);
evalcond[2]=((-1.0)*x546);
evalcond[3]=((-1.0)*x547);
evalcond[4]=(x547+new_r11);
evalcond[5]=(gconst2+((new_r11*x545)));
evalcond[6]=((((-1.0)*x546))+new_r10);
evalcond[7]=(((new_r10*x544))+(((-1.0)*gconst2)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x548 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0)*new_r11)),IKFAST_ATAN2_MAGTHRESH);
if(!x548.valid){
continue;
}
CheckValue<IkReal> x549=IKPowWithIntegerCheck(IKsign(gconst2),-1);
if(!x549.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(x548.value)+(((1.5707963267949)*(x549.value))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x550=IKsin(j3);
IkReal x551=IKcos(j3);
IkReal x552=(gconst2*x550);
IkReal x553=(gconst2*x551);
evalcond[0]=(new_r11*x550);
evalcond[1]=(new_r10*x551);
evalcond[2]=((-1.0)*x552);
evalcond[3]=((-1.0)*x553);
evalcond[4]=(x553+new_r11);
evalcond[5]=(((new_r11*x551))+gconst2);
evalcond[6]=((((-1.0)*x552))+new_r10);
evalcond[7]=(((new_r10*x550))+(((-1.0)*gconst2)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(new_r01);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3eval[1];
CheckValue<IkReal> x555 = IKatan2WithCheck(IkReal(0),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x555.valid){
continue;
}
IkReal x554=((-1.0)*(x555.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst1;
cj5=gconst2;
j5=x554;
new_r01=0;
IkReal gconst0=x554;
IkReal gconst1=0;
IkReal x556 = new_r11*new_r11;
if(IKabs(x556)==0){
continue;
}
IkReal gconst2=(new_r11*(pow(x556,-0.5)));
j3eval[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
{
IkReal j3eval[1];
CheckValue<IkReal> x558 = IKatan2WithCheck(IkReal(0),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x558.valid){
continue;
}
IkReal x557=((-1.0)*(x558.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst1;
cj5=gconst2;
j5=x557;
new_r01=0;
IkReal gconst0=x557;
IkReal gconst1=0;
IkReal x559 = new_r11*new_r11;
if(IKabs(x559)==0){
continue;
}
IkReal gconst2=(new_r11*(pow(x559,-0.5)));
j3eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
{
IkReal j3eval[1];
CheckValue<IkReal> x561 = IKatan2WithCheck(IkReal(0),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x561.valid){
continue;
}
IkReal x560=((-1.0)*(x561.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst1;
cj5=gconst2;
j5=x560;
new_r01=0;
IkReal gconst0=x560;
IkReal gconst1=0;
IkReal x562 = new_r11*new_r11;
if(IKabs(x562)==0){
continue;
}
IkReal gconst2=(new_r11*(pow(x562,-0.5)));
j3eval[0]=new_r11;
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x563=IKPowWithIntegerCheck(gconst2,-1);
if(!x563.valid){
continue;
}
CheckValue<IkReal> x564=IKPowWithIntegerCheck(new_r11,-1);
if(!x564.valid){
continue;
}
if( IKabs((new_r10*(x563.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*gconst2*(x564.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r10*(x563.value)))+IKsqr(((-1.0)*gconst2*(x564.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2((new_r10*(x563.value)), ((-1.0)*gconst2*(x564.value)));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x565=IKsin(j3);
IkReal x566=IKcos(j3);
IkReal x567=(gconst2*x565);
IkReal x568=(gconst2*x566);
evalcond[0]=(new_r11*x565);
evalcond[1]=((-1.0)*x567);
evalcond[2]=(x568+new_r11);
evalcond[3]=(gconst2+((new_r11*x566)));
evalcond[4]=((((-1.0)*x568))+new_r00);
evalcond[5]=((((-1.0)*x567))+new_r10);
evalcond[6]=((((-1.0)*new_r00*x565))+((new_r10*x566)));
evalcond[7]=(((new_r00*x566))+(((-1.0)*gconst2))+((new_r10*x565)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x569 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0)*new_r11)),IKFAST_ATAN2_MAGTHRESH);
if(!x569.valid){
continue;
}
CheckValue<IkReal> x570=IKPowWithIntegerCheck(IKsign(gconst2),-1);
if(!x570.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(x569.value)+(((1.5707963267949)*(x570.value))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x571=IKsin(j3);
IkReal x572=IKcos(j3);
IkReal x573=(gconst2*x571);
IkReal x574=(gconst2*x572);
evalcond[0]=(new_r11*x571);
evalcond[1]=((-1.0)*x573);
evalcond[2]=(x574+new_r11);
evalcond[3]=(((new_r11*x572))+gconst2);
evalcond[4]=((((-1.0)*x574))+new_r00);
evalcond[5]=((((-1.0)*x573))+new_r10);
evalcond[6]=(((new_r10*x572))+(((-1.0)*new_r00*x571)));
evalcond[7]=(((new_r00*x572))+((new_r10*x571))+(((-1.0)*gconst2)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x575=IKPowWithIntegerCheck(IKsign(gconst2),-1);
if(!x575.valid){
continue;
}
CheckValue<IkReal> x576 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x576.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(((1.5707963267949)*(x575.value)))+(x576.value));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x577=IKsin(j3);
IkReal x578=IKcos(j3);
IkReal x579=(gconst2*x577);
IkReal x580=(gconst2*x578);
evalcond[0]=(new_r11*x577);
evalcond[1]=((-1.0)*x579);
evalcond[2]=(x580+new_r11);
evalcond[3]=(((new_r11*x578))+gconst2);
evalcond[4]=((((-1.0)*x580))+new_r00);
evalcond[5]=((((-1.0)*x579))+new_r10);
evalcond[6]=(((new_r10*x578))+(((-1.0)*new_r00*x577)));
evalcond[7]=(((new_r00*x578))+((new_r10*x577))+(((-1.0)*gconst2)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j3]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x581=((1.0)*new_r11);
CheckValue<IkReal> x582 = IKatan2WithCheck(IkReal(((((-1.0)*gconst1*x581))+((gconst2*new_r01)))),IkReal(((((-1.0)*gconst1*new_r01))+(((-1.0)*gconst2*x581)))),IKFAST_ATAN2_MAGTHRESH);
if(!x582.valid){
continue;
}
CheckValue<IkReal> x583=IKPowWithIntegerCheck(IKsign(((gconst1*gconst1)+(gconst2*gconst2))),-1);
if(!x583.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(x582.value)+(((1.5707963267949)*(x583.value))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x584=IKcos(j3);
IkReal x585=IKsin(j3);
IkReal x586=((1.0)*gconst2);
IkReal x587=(gconst1*x584);
IkReal x588=(gconst1*x585);
IkReal x589=((1.0)*x585);
IkReal x590=(x585*x586);
evalcond[0]=(gconst1+((new_r01*x584))+((new_r11*x585)));
evalcond[1]=(x588+((gconst2*x584))+new_r11);
evalcond[2]=((((-1.0)*x590))+x587+new_r01);
evalcond[3]=(gconst1+(((-1.0)*new_r00*x589))+((new_r10*x584)));
evalcond[4]=((((-1.0)*new_r01*x589))+gconst2+((new_r11*x584)));
evalcond[5]=((((-1.0)*x590))+x587+new_r10);
evalcond[6]=(((new_r00*x584))+(((-1.0)*x586))+((new_r10*x585)));
evalcond[7]=((((-1.0)*x588))+(((-1.0)*x584*x586))+new_r00);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x591=((1.0)*new_r11);
CheckValue<IkReal> x592=IKPowWithIntegerCheck(IKsign(((new_r01*new_r01)+(new_r11*new_r11))),-1);
if(!x592.valid){
continue;
}
CheckValue<IkReal> x593 = IKatan2WithCheck(IkReal((((gconst2*new_r01))+(((-1.0)*gconst1*x591)))),IkReal(((((-1.0)*gconst1*new_r01))+(((-1.0)*gconst2*x591)))),IKFAST_ATAN2_MAGTHRESH);
if(!x593.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(((1.5707963267949)*(x592.value)))+(x593.value));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x594=IKcos(j3);
IkReal x595=IKsin(j3);
IkReal x596=((1.0)*gconst2);
IkReal x597=(gconst1*x594);
IkReal x598=(gconst1*x595);
IkReal x599=((1.0)*x595);
IkReal x600=(x595*x596);
evalcond[0]=(((new_r11*x595))+gconst1+((new_r01*x594)));
evalcond[1]=(((gconst2*x594))+x598+new_r11);
evalcond[2]=(x597+(((-1.0)*x600))+new_r01);
evalcond[3]=((((-1.0)*new_r00*x599))+((new_r10*x594))+gconst1);
evalcond[4]=(((new_r11*x594))+gconst2+(((-1.0)*new_r01*x599)));
evalcond[5]=(x597+(((-1.0)*x600))+new_r10);
evalcond[6]=(((new_r10*x595))+((new_r00*x594))+(((-1.0)*x596)));
evalcond[7]=((((-1.0)*x598))+(((-1.0)*x594*x596))+new_r00);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x601=((1.0)*gconst1);
CheckValue<IkReal> x602=IKPowWithIntegerCheck(IKsign((((new_r10*new_r11))+((new_r00*new_r01)))),-1);
if(!x602.valid){
continue;
}
CheckValue<IkReal> x603 = IKatan2WithCheck(IkReal(((((-1.0)*new_r10*x601))+((gconst1*new_r01)))),IkReal(((((-1.0)*new_r11*x601))+(((-1.0)*new_r00*x601)))),IKFAST_ATAN2_MAGTHRESH);
if(!x603.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(((1.5707963267949)*(x602.value)))+(x603.value));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x604=IKcos(j3);
IkReal x605=IKsin(j3);
IkReal x606=((1.0)*gconst2);
IkReal x607=(gconst1*x604);
IkReal x608=(gconst1*x605);
IkReal x609=((1.0)*x605);
IkReal x610=(x605*x606);
evalcond[0]=(gconst1+((new_r11*x605))+((new_r01*x604)));
evalcond[1]=(((gconst2*x604))+x608+new_r11);
evalcond[2]=((((-1.0)*x610))+x607+new_r01);
evalcond[3]=(gconst1+((new_r10*x604))+(((-1.0)*new_r00*x609)));
evalcond[4]=(gconst2+((new_r11*x604))+(((-1.0)*new_r01*x609)));
evalcond[5]=((((-1.0)*x610))+x607+new_r10);
evalcond[6]=(((new_r10*x605))+((new_r00*x604))+(((-1.0)*x606)));
evalcond[7]=((((-1.0)*x604*x606))+(((-1.0)*x608))+new_r00);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x612 = ((new_r01*new_r01)+(new_r11*new_r11));
if(IKabs(x612)==0){
continue;
}
IkReal x611=pow(x612,-0.5);
CheckValue<IkReal> x613 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x613.valid){
continue;
}
IkReal gconst3=((3.14159265358979)+(((-1.0)*(x613.value))));
IkReal gconst4=((1.0)*new_r01*x611);
IkReal gconst5=((-1.0)*new_r11*x611);
CheckValue<IkReal> x614 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x614.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+(x614.value)+j5)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3eval[3];
CheckValue<IkReal> x617 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x617.valid){
continue;
}
IkReal x615=((1.0)*(x617.value));
IkReal x616=x611;
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst4;
cj5=gconst5;
j5=((3.14159265)+(((-1.0)*x615)));
IkReal gconst3=((3.14159265358979)+(((-1.0)*x615)));
IkReal gconst4=((1.0)*new_r01*x616);
IkReal gconst5=((-1.0)*new_r11*x616);
IkReal x618=new_r01*new_r01;
IkReal x619=(((new_r10*new_r11))+((new_r00*new_r01)));
IkReal x620=x611;
IkReal x621=((1.0)*new_r01*x620);
j3eval[0]=x619;
j3eval[1]=IKsign(x619);
j3eval[2]=((IKabs(((((-1.0)*new_r00*x621))+(((-1.0)*new_r11*x621)))))+(IKabs((((x618*x620))+(((-1.0)*new_r10*x621))))));
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  || IKabs(j3eval[2]) < 0.0000010000000000  )
{
{
IkReal j3eval[2];
CheckValue<IkReal> x624 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x624.valid){
continue;
}
IkReal x622=((1.0)*(x624.value));
IkReal x623=x611;
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst4;
cj5=gconst5;
j5=((3.14159265)+(((-1.0)*x622)));
IkReal gconst3=((3.14159265358979)+(((-1.0)*x622)));
IkReal gconst4=((1.0)*new_r01*x623);
IkReal gconst5=((-1.0)*new_r11*x623);
IkReal x625=((new_r01*new_r01)+(new_r11*new_r11));
j3eval[0]=x625;
j3eval[1]=IKsign(x625);
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  )
{
{
IkReal j3eval[1];
CheckValue<IkReal> x628 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x628.valid){
continue;
}
IkReal x626=((1.0)*(x628.value));
IkReal x627=x611;
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst4;
cj5=gconst5;
j5=((3.14159265)+(((-1.0)*x626)));
IkReal gconst3=((3.14159265358979)+(((-1.0)*x626)));
IkReal gconst4=((1.0)*new_r01*x627);
IkReal gconst5=((-1.0)*new_r11*x627);
j3eval[0]=((new_r01*new_r01)+(new_r11*new_r11));
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((gconst4*gconst4)+(gconst5*gconst5));
evalcond[1]=new_r01;
evalcond[2]=new_r00;
evalcond[3]=new_r11;
evalcond[4]=new_r10;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3array[4], cj3array[4], sj3array[4];
bool j3valid[4]={false};
_nj3 = 4;
j3array[0]=0;
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
j3array[1]=1.5707963267949;
sj3array[1]=IKsin(j3array[1]);
cj3array[1]=IKcos(j3array[1]);
j3array[2]=3.14159265358979;
sj3array[2]=IKsin(j3array[2]);
cj3array[2]=IKcos(j3array[2]);
j3array[3]=-1.5707963267949;
sj3array[3]=IKsin(j3array[3]);
cj3array[3]=IKcos(j3array[3]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
if( j3array[1] > IKPI )
{
    j3array[1]-=IK2PI;
}
else if( j3array[1] < -IKPI )
{    j3array[1]+=IK2PI;
}
j3valid[1] = true;
if( j3array[2] > IKPI )
{
    j3array[2]-=IK2PI;
}
else if( j3array[2] < -IKPI )
{    j3array[2]+=IK2PI;
}
j3valid[2] = true;
if( j3array[3] > IKPI )
{
    j3array[3]-=IK2PI;
}
else if( j3array[3] < -IKPI )
{    j3array[3]+=IK2PI;
}
j3valid[3] = true;
for(int ij3 = 0; ij3 < 4; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 4; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r00)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3eval[1];
CheckValue<IkReal> x630 = IKatan2WithCheck(IkReal(new_r01),IkReal(0),IKFAST_ATAN2_MAGTHRESH);
if(!x630.valid){
continue;
}
IkReal x629=((1.0)*(x630.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst4;
cj5=gconst5;
j5=((3.14159265)+(((-1.0)*x629)));
new_r11=0;
new_r00=0;
IkReal gconst3=((3.14159265358979)+(((-1.0)*x629)));
IkReal x631 = new_r01*new_r01;
if(IKabs(x631)==0){
continue;
}
IkReal gconst4=((1.0)*new_r01*(pow(x631,-0.5)));
IkReal gconst5=0;
j3eval[0]=new_r01;
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
CheckValue<IkReal> x632=IKPowWithIntegerCheck(gconst4,-1);
if(!x632.valid){
continue;
}
cj3array[0]=((-1.0)*new_r01*(x632.value));
if( cj3array[0] >= -1-IKFAST_SINCOS_THRESH && cj3array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j3valid[0] = j3valid[1] = true;
    j3array[0] = IKacos(cj3array[0]);
    sj3array[0] = IKsin(j3array[0]);
    cj3array[1] = cj3array[0];
    j3array[1] = -j3array[0];
    sj3array[1] = -sj3array[0];
}
else if( isnan(cj3array[0]) )
{
    // probably any value will work
    j3valid[0] = true;
    cj3array[0] = 1; sj3array[0] = 0; j3array[0] = 0;
}
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x633=IKsin(j3);
IkReal x634=IKcos(j3);
IkReal x635=((-1.0)*x633);
evalcond[0]=(new_r10*x633);
evalcond[1]=(gconst4*x635);
evalcond[2]=(new_r01*x635);
evalcond[3]=(gconst4+((new_r01*x634)));
evalcond[4]=(gconst4+((new_r10*x634)));
evalcond[5]=(((gconst4*x634))+new_r10);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
CheckValue<IkReal> x636=IKPowWithIntegerCheck(new_r01,-1);
if(!x636.valid){
continue;
}
cj3array[0]=((-1.0)*gconst4*(x636.value));
if( cj3array[0] >= -1-IKFAST_SINCOS_THRESH && cj3array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j3valid[0] = j3valid[1] = true;
    j3array[0] = IKacos(cj3array[0]);
    sj3array[0] = IKsin(j3array[0]);
    cj3array[1] = cj3array[0];
    j3array[1] = -j3array[0];
    sj3array[1] = -sj3array[0];
}
else if( isnan(cj3array[0]) )
{
    // probably any value will work
    j3valid[0] = true;
    cj3array[0] = 1; sj3array[0] = 0; j3array[0] = 0;
}
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x637=IKsin(j3);
IkReal x638=IKcos(j3);
IkReal x639=(gconst4*x638);
IkReal x640=((-1.0)*x637);
evalcond[0]=(new_r10*x637);
evalcond[1]=(gconst4*x640);
evalcond[2]=(new_r01*x640);
evalcond[3]=(x639+new_r01);
evalcond[4]=(gconst4+((new_r10*x638)));
evalcond[5]=(x639+new_r10);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r10))+(IKabs(new_r00)));
evalcond[1]=gconst4;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3eval[4];
CheckValue<IkReal> x642 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x642.valid){
continue;
}
IkReal x641=((1.0)*(x642.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst4;
cj5=gconst5;
j5=((3.14159265)+(((-1.0)*x641)));
new_r00=0;
new_r10=0;
new_r21=0;
new_r22=0;
IkReal gconst3=((3.14159265358979)+(((-1.0)*x641)));
IkReal gconst4=((1.0)*new_r01);
IkReal gconst5=((-1.0)*new_r11);
j3eval[0]=1.0;
j3eval[1]=1.0;
j3eval[2]=new_r01;
j3eval[3]=1.0;
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  || IKabs(j3eval[2]) < 0.0000010000000000  || IKabs(j3eval[3]) < 0.0000010000000000  )
{
{
IkReal j3eval[3];
CheckValue<IkReal> x644 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x644.valid){
continue;
}
IkReal x643=((1.0)*(x644.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst4;
cj5=gconst5;
j5=((3.14159265)+(((-1.0)*x643)));
new_r00=0;
new_r10=0;
new_r21=0;
new_r22=0;
IkReal gconst3=((3.14159265358979)+(((-1.0)*x643)));
IkReal gconst4=((1.0)*new_r01);
IkReal gconst5=((-1.0)*new_r11);
j3eval[0]=-1.0;
j3eval[1]=((IKabs(((-1.0)+(new_r01*new_r01))))+(IKabs(((1.0)*new_r01*new_r11))));
j3eval[2]=-1.0;
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  || IKabs(j3eval[2]) < 0.0000010000000000  )
{
{
IkReal j3eval[3];
CheckValue<IkReal> x646 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x646.valid){
continue;
}
IkReal x645=((1.0)*(x646.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst4;
cj5=gconst5;
j5=((3.14159265)+(((-1.0)*x645)));
new_r00=0;
new_r10=0;
new_r21=0;
new_r22=0;
IkReal gconst3=((3.14159265358979)+(((-1.0)*x645)));
IkReal gconst4=((1.0)*new_r01);
IkReal gconst5=((-1.0)*new_r11);
j3eval[0]=1.0;
j3eval[1]=((IKabs(((2.0)*new_r01*new_r11)))+(IKabs(((1.0)+(((-2.0)*(new_r01*new_r01)))))));
j3eval[2]=1.0;
if( IKabs(j3eval[0]) < 0.0000010000000000  || IKabs(j3eval[1]) < 0.0000010000000000  || IKabs(j3eval[2]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x647=((1.0)*new_r11);
CheckValue<IkReal> x648 = IKatan2WithCheck(IkReal((((gconst5*new_r01))+(((-1.0)*gconst4*x647)))),IkReal(((((-1.0)*gconst4*new_r01))+(((-1.0)*gconst5*x647)))),IKFAST_ATAN2_MAGTHRESH);
if(!x648.valid){
continue;
}
CheckValue<IkReal> x649=IKPowWithIntegerCheck(IKsign(((new_r01*new_r01)+(new_r11*new_r11))),-1);
if(!x649.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(x648.value)+(((1.5707963267949)*(x649.value))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x650=IKsin(j3);
IkReal x651=IKcos(j3);
IkReal x652=((1.0)*gconst5);
IkReal x653=(gconst4*x651);
IkReal x654=(gconst4*x650);
IkReal x655=(x650*x652);
evalcond[0]=(gconst4+((new_r01*x651))+((new_r11*x650)));
evalcond[1]=(x654+new_r11+((gconst5*x651)));
evalcond[2]=((((-1.0)*x655))+x653);
evalcond[3]=((((-1.0)*x655))+x653+new_r01);
evalcond[4]=((((-1.0)*x651*x652))+(((-1.0)*x654)));
evalcond[5]=(gconst5+(((-1.0)*new_r01*x650))+((new_r11*x651)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x656 = IKatan2WithCheck(IkReal((gconst4*new_r11)),IkReal((gconst5*new_r11)),IKFAST_ATAN2_MAGTHRESH);
if(!x656.valid){
continue;
}
CheckValue<IkReal> x657=IKPowWithIntegerCheck(IKsign(((((-1.0)*(gconst4*gconst4)))+(((-1.0)*(gconst5*gconst5))))),-1);
if(!x657.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(x656.value)+(((1.5707963267949)*(x657.value))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x658=IKsin(j3);
IkReal x659=IKcos(j3);
IkReal x660=((1.0)*gconst5);
IkReal x661=(gconst4*x659);
IkReal x662=(gconst4*x658);
IkReal x663=(x658*x660);
evalcond[0]=(gconst4+((new_r01*x659))+((new_r11*x658)));
evalcond[1]=(x662+new_r11+((gconst5*x659)));
evalcond[2]=((((-1.0)*x663))+x661);
evalcond[3]=((((-1.0)*x663))+x661+new_r01);
evalcond[4]=((((-1.0)*x659*x660))+(((-1.0)*x662)));
evalcond[5]=(gconst5+(((-1.0)*new_r01*x658))+((new_r11*x659)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x664 = IKatan2WithCheck(IkReal((gconst4*gconst5)),IkReal(((-1.0)*(gconst4*gconst4))),IKFAST_ATAN2_MAGTHRESH);
if(!x664.valid){
continue;
}
CheckValue<IkReal> x665=IKPowWithIntegerCheck(IKsign((((gconst4*new_r01))+(((-1.0)*gconst5*new_r11)))),-1);
if(!x665.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(x664.value)+(((1.5707963267949)*(x665.value))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x666=IKsin(j3);
IkReal x667=IKcos(j3);
IkReal x668=((1.0)*gconst5);
IkReal x669=(gconst4*x667);
IkReal x670=(gconst4*x666);
IkReal x671=(x666*x668);
evalcond[0]=(gconst4+((new_r11*x666))+((new_r01*x667)));
evalcond[1]=(((gconst5*x667))+x670+new_r11);
evalcond[2]=(x669+(((-1.0)*x671)));
evalcond[3]=(x669+new_r01+(((-1.0)*x671)));
evalcond[4]=((((-1.0)*x670))+(((-1.0)*x667*x668)));
evalcond[5]=(gconst5+((new_r11*x667))+(((-1.0)*new_r01*x666)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r10))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
CheckValue<IkReal> x672=IKPowWithIntegerCheck(gconst5,-1);
if(!x672.valid){
continue;
}
cj3array[0]=(new_r00*(x672.value));
if( cj3array[0] >= -1-IKFAST_SINCOS_THRESH && cj3array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j3valid[0] = j3valid[1] = true;
    j3array[0] = IKacos(cj3array[0]);
    sj3array[0] = IKsin(j3array[0]);
    cj3array[1] = cj3array[0];
    j3array[1] = -j3array[0];
    sj3array[1] = -sj3array[0];
}
else if( isnan(cj3array[0]) )
{
    // probably any value will work
    j3valid[0] = true;
    cj3array[0] = 1; sj3array[0] = 0; j3array[0] = 0;
}
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x673=IKsin(j3);
IkReal x674=IKcos(j3);
IkReal x675=((-1.0)*x673);
evalcond[0]=(new_r11*x673);
evalcond[1]=(gconst5*x675);
evalcond[2]=(new_r00*x675);
evalcond[3]=(((gconst5*x674))+new_r11);
evalcond[4]=(((new_r11*x674))+gconst5);
evalcond[5]=(((new_r00*x674))+(((-1.0)*gconst5)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r00))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3eval[1];
CheckValue<IkReal> x677 = IKatan2WithCheck(IkReal(0),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x677.valid){
continue;
}
IkReal x676=((1.0)*(x677.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst4;
cj5=gconst5;
j5=((3.14159265)+(((-1.0)*x676)));
new_r00=0;
new_r01=0;
new_r12=0;
new_r22=0;
IkReal gconst3=((3.14159265358979)+(((-1.0)*x676)));
IkReal gconst4=0;
IkReal x678 = ((1.0)+(((-1.0)*(new_r10*new_r10))));
if(IKabs(x678)==0){
continue;
}
IkReal gconst5=((-1.0)*new_r11*(pow(x678,-0.5)));
j3eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
{
IkReal j3eval[1];
CheckValue<IkReal> x680 = IKatan2WithCheck(IkReal(0),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x680.valid){
continue;
}
IkReal x679=((1.0)*(x680.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst4;
cj5=gconst5;
j5=((3.14159265)+(((-1.0)*x679)));
new_r00=0;
new_r01=0;
new_r12=0;
new_r22=0;
IkReal gconst3=((3.14159265358979)+(((-1.0)*x679)));
IkReal gconst4=0;
IkReal x681 = ((1.0)+(((-1.0)*(new_r10*new_r10))));
if(IKabs(x681)==0){
continue;
}
IkReal gconst5=((-1.0)*new_r11*(pow(x681,-0.5)));
j3eval[0]=new_r11;
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
{
IkReal j3eval[1];
CheckValue<IkReal> x683 = IKatan2WithCheck(IkReal(0),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x683.valid){
continue;
}
IkReal x682=((1.0)*(x683.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst4;
cj5=gconst5;
j5=((3.14159265)+(((-1.0)*x682)));
new_r00=0;
new_r01=0;
new_r12=0;
new_r22=0;
IkReal gconst3=((3.14159265358979)+(((-1.0)*x682)));
IkReal gconst4=0;
IkReal x684 = ((1.0)+(((-1.0)*(new_r10*new_r10))));
if(IKabs(x684)==0){
continue;
}
IkReal gconst5=((-1.0)*new_r11*(pow(x684,-0.5)));
j3eval[0]=new_r10;
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x685=IKPowWithIntegerCheck(new_r10,-1);
if(!x685.valid){
continue;
}
CheckValue<IkReal> x686=IKPowWithIntegerCheck(gconst5,-1);
if(!x686.valid){
continue;
}
if( IKabs((gconst5*(x685.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11*(x686.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((gconst5*(x685.value)))+IKsqr(((-1.0)*new_r11*(x686.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2((gconst5*(x685.value)), ((-1.0)*new_r11*(x686.value)));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x687=IKsin(j3);
IkReal x688=IKcos(j3);
IkReal x689=(gconst5*x687);
IkReal x690=(gconst5*x688);
evalcond[0]=(new_r11*x687);
evalcond[1]=(new_r10*x688);
evalcond[2]=((-1.0)*x689);
evalcond[3]=((-1.0)*x690);
evalcond[4]=(x690+new_r11);
evalcond[5]=(gconst5+((new_r11*x688)));
evalcond[6]=(new_r10+(((-1.0)*x689)));
evalcond[7]=((((-1.0)*gconst5))+((new_r10*x687)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x691=IKPowWithIntegerCheck(gconst5,-1);
if(!x691.valid){
continue;
}
CheckValue<IkReal> x692=IKPowWithIntegerCheck(new_r11,-1);
if(!x692.valid){
continue;
}
if( IKabs((new_r10*(x691.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*gconst5*(x692.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r10*(x691.value)))+IKsqr(((-1.0)*gconst5*(x692.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2((new_r10*(x691.value)), ((-1.0)*gconst5*(x692.value)));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x693=IKsin(j3);
IkReal x694=IKcos(j3);
IkReal x695=(gconst5*x693);
IkReal x696=(gconst5*x694);
evalcond[0]=(new_r11*x693);
evalcond[1]=(new_r10*x694);
evalcond[2]=((-1.0)*x695);
evalcond[3]=((-1.0)*x696);
evalcond[4]=(x696+new_r11);
evalcond[5]=(gconst5+((new_r11*x694)));
evalcond[6]=(new_r10+(((-1.0)*x695)));
evalcond[7]=(((new_r10*x693))+(((-1.0)*gconst5)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x697 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0)*new_r11)),IKFAST_ATAN2_MAGTHRESH);
if(!x697.valid){
continue;
}
CheckValue<IkReal> x698=IKPowWithIntegerCheck(IKsign(gconst5),-1);
if(!x698.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(x697.value)+(((1.5707963267949)*(x698.value))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x699=IKsin(j3);
IkReal x700=IKcos(j3);
IkReal x701=(gconst5*x699);
IkReal x702=(gconst5*x700);
evalcond[0]=(new_r11*x699);
evalcond[1]=(new_r10*x700);
evalcond[2]=((-1.0)*x701);
evalcond[3]=((-1.0)*x702);
evalcond[4]=(x702+new_r11);
evalcond[5]=(gconst5+((new_r11*x700)));
evalcond[6]=((((-1.0)*x701))+new_r10);
evalcond[7]=(((new_r10*x699))+(((-1.0)*gconst5)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(new_r01);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3eval[1];
CheckValue<IkReal> x704 = IKatan2WithCheck(IkReal(0),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x704.valid){
continue;
}
IkReal x703=((1.0)*(x704.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst4;
cj5=gconst5;
j5=((3.14159265)+(((-1.0)*x703)));
new_r01=0;
IkReal gconst3=((3.14159265358979)+(((-1.0)*x703)));
IkReal gconst4=0;
IkReal x705 = new_r11*new_r11;
if(IKabs(x705)==0){
continue;
}
IkReal gconst5=((-1.0)*new_r11*(pow(x705,-0.5)));
j3eval[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
{
IkReal j3eval[1];
CheckValue<IkReal> x707 = IKatan2WithCheck(IkReal(0),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x707.valid){
continue;
}
IkReal x706=((1.0)*(x707.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst4;
cj5=gconst5;
j5=((3.14159265)+(((-1.0)*x706)));
new_r01=0;
IkReal gconst3=((3.14159265358979)+(((-1.0)*x706)));
IkReal gconst4=0;
IkReal x708 = new_r11*new_r11;
if(IKabs(x708)==0){
continue;
}
IkReal gconst5=((-1.0)*new_r11*(pow(x708,-0.5)));
j3eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
{
IkReal j3eval[1];
CheckValue<IkReal> x710 = IKatan2WithCheck(IkReal(0),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x710.valid){
continue;
}
IkReal x709=((1.0)*(x710.value));
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
sj5=gconst4;
cj5=gconst5;
j5=((3.14159265)+(((-1.0)*x709)));
new_r01=0;
IkReal gconst3=((3.14159265358979)+(((-1.0)*x709)));
IkReal gconst4=0;
IkReal x711 = new_r11*new_r11;
if(IKabs(x711)==0){
continue;
}
IkReal gconst5=((-1.0)*new_r11*(pow(x711,-0.5)));
j3eval[0]=new_r11;
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x712=IKPowWithIntegerCheck(gconst5,-1);
if(!x712.valid){
continue;
}
CheckValue<IkReal> x713=IKPowWithIntegerCheck(new_r11,-1);
if(!x713.valid){
continue;
}
if( IKabs((new_r10*(x712.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*gconst5*(x713.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r10*(x712.value)))+IKsqr(((-1.0)*gconst5*(x713.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2((new_r10*(x712.value)), ((-1.0)*gconst5*(x713.value)));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x714=IKsin(j3);
IkReal x715=IKcos(j3);
IkReal x716=((1.0)*gconst5);
IkReal x717=(gconst5*x714);
evalcond[0]=(new_r11*x714);
evalcond[1]=((-1.0)*x717);
evalcond[2]=(((gconst5*x715))+new_r11);
evalcond[3]=(gconst5+((new_r11*x715)));
evalcond[4]=(new_r00+(((-1.0)*x715*x716)));
evalcond[5]=((((-1.0)*x714*x716))+new_r10);
evalcond[6]=((((-1.0)*new_r00*x714))+((new_r10*x715)));
evalcond[7]=(((new_r00*x715))+(((-1.0)*x716))+((new_r10*x714)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x718 = IKatan2WithCheck(IkReal(new_r10),IkReal(((-1.0)*new_r11)),IKFAST_ATAN2_MAGTHRESH);
if(!x718.valid){
continue;
}
CheckValue<IkReal> x719=IKPowWithIntegerCheck(IKsign(gconst5),-1);
if(!x719.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(x718.value)+(((1.5707963267949)*(x719.value))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x720=IKsin(j3);
IkReal x721=IKcos(j3);
IkReal x722=((1.0)*gconst5);
IkReal x723=(gconst5*x720);
evalcond[0]=(new_r11*x720);
evalcond[1]=((-1.0)*x723);
evalcond[2]=(((gconst5*x721))+new_r11);
evalcond[3]=(gconst5+((new_r11*x721)));
evalcond[4]=((((-1.0)*x721*x722))+new_r00);
evalcond[5]=((((-1.0)*x720*x722))+new_r10);
evalcond[6]=((((-1.0)*new_r00*x720))+((new_r10*x721)));
evalcond[7]=(((new_r00*x721))+(((-1.0)*x722))+((new_r10*x720)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x724 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r00),IKFAST_ATAN2_MAGTHRESH);
if(!x724.valid){
continue;
}
CheckValue<IkReal> x725=IKPowWithIntegerCheck(IKsign(gconst5),-1);
if(!x725.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(x724.value)+(((1.5707963267949)*(x725.value))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x726=IKsin(j3);
IkReal x727=IKcos(j3);
IkReal x728=((1.0)*gconst5);
IkReal x729=(gconst5*x726);
evalcond[0]=(new_r11*x726);
evalcond[1]=((-1.0)*x729);
evalcond[2]=(((gconst5*x727))+new_r11);
evalcond[3]=(gconst5+((new_r11*x727)));
evalcond[4]=((((-1.0)*x727*x728))+new_r00);
evalcond[5]=((((-1.0)*x726*x728))+new_r10);
evalcond[6]=((((-1.0)*new_r00*x726))+((new_r10*x727)));
evalcond[7]=(((new_r00*x727))+(((-1.0)*x728))+((new_r10*x726)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j3]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x730=((1.0)*new_r11);
CheckValue<IkReal> x731 = IKatan2WithCheck(IkReal((((gconst5*new_r01))+(((-1.0)*gconst4*x730)))),IkReal(((((-1.0)*gconst5*x730))+(((-1.0)*gconst4*new_r01)))),IKFAST_ATAN2_MAGTHRESH);
if(!x731.valid){
continue;
}
CheckValue<IkReal> x732=IKPowWithIntegerCheck(IKsign(((gconst4*gconst4)+(gconst5*gconst5))),-1);
if(!x732.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(x731.value)+(((1.5707963267949)*(x732.value))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x733=IKsin(j3);
IkReal x734=IKcos(j3);
IkReal x735=((1.0)*gconst5);
IkReal x736=(gconst4*x734);
IkReal x737=((1.0)*x733);
IkReal x738=(x733*x735);
evalcond[0]=(gconst4+((new_r01*x734))+((new_r11*x733)));
evalcond[1]=(((gconst4*x733))+((gconst5*x734))+new_r11);
evalcond[2]=((((-1.0)*x738))+x736+new_r01);
evalcond[3]=(gconst4+(((-1.0)*new_r00*x737))+((new_r10*x734)));
evalcond[4]=(gconst5+(((-1.0)*new_r01*x737))+((new_r11*x734)));
evalcond[5]=((((-1.0)*x738))+x736+new_r10);
evalcond[6]=(((new_r00*x734))+(((-1.0)*x735))+((new_r10*x733)));
evalcond[7]=((((-1.0)*x734*x735))+new_r00+(((-1.0)*gconst4*x737)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x739=((1.0)*new_r11);
CheckValue<IkReal> x740 = IKatan2WithCheck(IkReal((((gconst5*new_r01))+(((-1.0)*gconst4*x739)))),IkReal(((((-1.0)*gconst5*x739))+(((-1.0)*gconst4*new_r01)))),IKFAST_ATAN2_MAGTHRESH);
if(!x740.valid){
continue;
}
CheckValue<IkReal> x741=IKPowWithIntegerCheck(IKsign(((new_r01*new_r01)+(new_r11*new_r11))),-1);
if(!x741.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(x740.value)+(((1.5707963267949)*(x741.value))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x742=IKsin(j3);
IkReal x743=IKcos(j3);
IkReal x744=((1.0)*gconst5);
IkReal x745=(gconst4*x743);
IkReal x746=((1.0)*x742);
IkReal x747=(x742*x744);
evalcond[0]=(gconst4+((new_r01*x743))+((new_r11*x742)));
evalcond[1]=(((gconst4*x742))+((gconst5*x743))+new_r11);
evalcond[2]=(x745+new_r01+(((-1.0)*x747)));
evalcond[3]=((((-1.0)*new_r00*x746))+gconst4+((new_r10*x743)));
evalcond[4]=((((-1.0)*new_r01*x746))+gconst5+((new_r11*x743)));
evalcond[5]=(x745+new_r10+(((-1.0)*x747)));
evalcond[6]=(((new_r10*x742))+((new_r00*x743))+(((-1.0)*x744)));
evalcond[7]=((((-1.0)*gconst4*x746))+new_r00+(((-1.0)*x743*x744)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x748=((1.0)*gconst4);
CheckValue<IkReal> x749 = IKatan2WithCheck(IkReal((((gconst4*new_r01))+(((-1.0)*new_r10*x748)))),IkReal(((((-1.0)*new_r00*x748))+(((-1.0)*new_r11*x748)))),IKFAST_ATAN2_MAGTHRESH);
if(!x749.valid){
continue;
}
CheckValue<IkReal> x750=IKPowWithIntegerCheck(IKsign((((new_r10*new_r11))+((new_r00*new_r01)))),-1);
if(!x750.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(x749.value)+(((1.5707963267949)*(x750.value))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x751=IKsin(j3);
IkReal x752=IKcos(j3);
IkReal x753=((1.0)*gconst5);
IkReal x754=(gconst4*x752);
IkReal x755=((1.0)*x751);
IkReal x756=(x751*x753);
evalcond[0]=(gconst4+((new_r11*x751))+((new_r01*x752)));
evalcond[1]=(new_r11+((gconst5*x752))+((gconst4*x751)));
evalcond[2]=(x754+new_r01+(((-1.0)*x756)));
evalcond[3]=(gconst4+(((-1.0)*new_r00*x755))+((new_r10*x752)));
evalcond[4]=((((-1.0)*new_r01*x755))+gconst5+((new_r11*x752)));
evalcond[5]=(x754+new_r10+(((-1.0)*x756)));
evalcond[6]=(((new_r00*x752))+((new_r10*x751))+(((-1.0)*x753)));
evalcond[7]=((((-1.0)*gconst4*x755))+(((-1.0)*x752*x753))+new_r00);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3eval[1];
sj4=0;
cj4=-1.0;
j4=3.14159265358979;
new_r11=0;
new_r01=0;
new_r22=0;
new_r20=0;
j3eval[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j3]

} else
{
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
CheckValue<IkReal> x758 = IKatan2WithCheck(IkReal(new_r00),IkReal(new_r10),IKFAST_ATAN2_MAGTHRESH);
if(!x758.valid){
continue;
}
IkReal x757=x758.value;
j3array[0]=((-1.0)*x757);
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
j3array[1]=((3.14159265358979)+(((-1.0)*x757)));
sj3array[1]=IKsin(j3array[1]);
cj3array[1]=IKcos(j3array[1]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
if( j3array[1] > IKPI )
{
    j3array[1]-=IK2PI;
}
else if( j3array[1] < -IKPI )
{    j3array[1]+=IK2PI;
}
j3valid[1] = true;
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[1];
evalcond[0]=((((-1.0)*new_r00*(IKsin(j3))))+((new_r10*(IKcos(j3)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j3]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x759=((1.0)*sj5);
CheckValue<IkReal> x760 = IKatan2WithCheck(IkReal((((cj5*new_r01))+(((-1.0)*new_r11*x759)))),IkReal(((((-1.0)*new_r01*x759))+(((-1.0)*cj5*new_r11)))),IKFAST_ATAN2_MAGTHRESH);
if(!x760.valid){
continue;
}
CheckValue<IkReal> x761=IKPowWithIntegerCheck(IKsign(((new_r01*new_r01)+(new_r11*new_r11))),-1);
if(!x761.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(x760.value)+(((1.5707963267949)*(x761.value))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x762=IKsin(j3);
IkReal x763=IKcos(j3);
IkReal x764=((1.0)*cj5);
IkReal x765=(sj5*x763);
IkReal x766=(sj5*x762);
IkReal x767=((1.0)*x762);
IkReal x768=(x762*x764);
evalcond[0]=(sj5+((new_r11*x762))+((new_r01*x763)));
evalcond[1]=(((cj5*x763))+x766+new_r11);
evalcond[2]=((((-1.0)*x768))+x765+new_r01);
evalcond[3]=(((new_r10*x763))+sj5+(((-1.0)*new_r00*x767)));
evalcond[4]=(((new_r11*x763))+cj5+(((-1.0)*new_r01*x767)));
evalcond[5]=((((-1.0)*x768))+x765+new_r10);
evalcond[6]=(((new_r10*x762))+(((-1.0)*x764))+((new_r00*x763)));
evalcond[7]=((((-1.0)*x763*x764))+(((-1.0)*x766))+new_r00);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x769=((1.0)*sj5);
CheckValue<IkReal> x770 = IKatan2WithCheck(IkReal((((new_r01*sj5))+(((-1.0)*new_r10*x769)))),IkReal(((((-1.0)*new_r00*x769))+(((-1.0)*new_r11*x769)))),IKFAST_ATAN2_MAGTHRESH);
if(!x770.valid){
continue;
}
CheckValue<IkReal> x771=IKPowWithIntegerCheck(IKsign((((new_r10*new_r11))+((new_r00*new_r01)))),-1);
if(!x771.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(x770.value)+(((1.5707963267949)*(x771.value))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x772=IKsin(j3);
IkReal x773=IKcos(j3);
IkReal x774=((1.0)*cj5);
IkReal x775=(sj5*x773);
IkReal x776=(sj5*x772);
IkReal x777=((1.0)*x772);
IkReal x778=(x772*x774);
evalcond[0]=(sj5+((new_r11*x772))+((new_r01*x773)));
evalcond[1]=(x776+new_r11+((cj5*x773)));
evalcond[2]=(x775+(((-1.0)*x778))+new_r01);
evalcond[3]=(sj5+(((-1.0)*new_r00*x777))+((new_r10*x773)));
evalcond[4]=(cj5+(((-1.0)*new_r01*x777))+((new_r11*x773)));
evalcond[5]=(x775+(((-1.0)*x778))+new_r10);
evalcond[6]=(((new_r00*x773))+((new_r10*x772))+(((-1.0)*x774)));
evalcond[7]=((((-1.0)*x773*x774))+new_r00+(((-1.0)*x776)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x779 = IKatan2WithCheck(IkReal(((-1.0)+(new_r01*new_r01)+(cj5*cj5))),IkReal(((((-1.0)*cj5*sj5))+(((-1.0)*new_r01*new_r11)))),IKFAST_ATAN2_MAGTHRESH);
if(!x779.valid){
continue;
}
CheckValue<IkReal> x780=IKPowWithIntegerCheck(IKsign((((new_r11*sj5))+((cj5*new_r01)))),-1);
if(!x780.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(x779.value)+(((1.5707963267949)*(x780.value))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[8];
IkReal x781=IKsin(j3);
IkReal x782=IKcos(j3);
IkReal x783=((1.0)*cj5);
IkReal x784=(sj5*x782);
IkReal x785=(sj5*x781);
IkReal x786=((1.0)*x781);
IkReal x787=(x781*x783);
evalcond[0]=(sj5+((new_r11*x781))+((new_r01*x782)));
evalcond[1]=(((cj5*x782))+x785+new_r11);
evalcond[2]=((((-1.0)*x787))+x784+new_r01);
evalcond[3]=(sj5+((new_r10*x782))+(((-1.0)*new_r00*x786)));
evalcond[4]=((((-1.0)*new_r01*x786))+cj5+((new_r11*x782)));
evalcond[5]=((((-1.0)*x787))+x784+new_r10);
evalcond[6]=(((new_r10*x781))+(((-1.0)*x783))+((new_r00*x782)));
evalcond[7]=((((-1.0)*x782*x783))+(((-1.0)*x785))+new_r00);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r12))+(IKabs(new_r02)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j3eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j3eval[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
{
IkReal j3eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j3eval[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
{
IkReal j3eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j3eval[0]=((IKabs((new_r10*new_r22)))+(IKabs((new_r00*new_r22))));
if( IKabs(j3eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j3]

} else
{
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
CheckValue<IkReal> x789 = IKatan2WithCheck(IkReal((new_r10*new_r22)),IkReal(((-1.0)*new_r00*new_r22)),IKFAST_ATAN2_MAGTHRESH);
if(!x789.valid){
continue;
}
IkReal x788=x789.value;
j3array[0]=((-1.0)*x788);
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
j3array[1]=((3.14159265358979)+(((-1.0)*x788)));
sj3array[1]=IKsin(j3array[1]);
cj3array[1]=IKcos(j3array[1]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
if( j3array[1] > IKPI )
{
    j3array[1]-=IK2PI;
}
else if( j3array[1] < -IKPI )
{    j3array[1]+=IK2PI;
}
j3valid[1] = true;
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[5];
IkReal x790=IKsin(j3);
IkReal x791=IKcos(j3);
IkReal x792=(new_r11*x791);
IkReal x793=((1.0)*x790);
evalcond[0]=(((new_r11*x790))+((new_r01*x791)));
evalcond[1]=(((new_r10*x790))+((new_r00*x791)));
evalcond[2]=(((new_r10*x791))+(((-1.0)*new_r00*x793)));
evalcond[3]=((((-1.0)*new_r01*x793))+x792);
evalcond[4]=(((new_r22*x792))+(((-1.0)*new_r01*new_r22*x793)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
CheckValue<IkReal> x795 = IKatan2WithCheck(IkReal(new_r00),IkReal(new_r10),IKFAST_ATAN2_MAGTHRESH);
if(!x795.valid){
continue;
}
IkReal x794=x795.value;
j3array[0]=((-1.0)*x794);
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
j3array[1]=((3.14159265358979)+(((-1.0)*x794)));
sj3array[1]=IKsin(j3array[1]);
cj3array[1]=IKcos(j3array[1]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
if( j3array[1] > IKPI )
{
    j3array[1]-=IK2PI;
}
else if( j3array[1] < -IKPI )
{    j3array[1]+=IK2PI;
}
j3valid[1] = true;
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[5];
IkReal x796=IKcos(j3);
IkReal x797=IKsin(j3);
IkReal x798=(new_r11*x796);
IkReal x799=(new_r10*x796);
IkReal x800=((1.0)*x797);
evalcond[0]=(((new_r11*x797))+((new_r01*x796)));
evalcond[1]=((((-1.0)*new_r00*x800))+x799);
evalcond[2]=((((-1.0)*new_r01*x800))+x798);
evalcond[3]=(((new_r22*x799))+(((-1.0)*new_r00*new_r22*x800)));
evalcond[4]=(((new_r22*x798))+(((-1.0)*new_r01*new_r22*x800)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
CheckValue<IkReal> x802 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x802.valid){
continue;
}
IkReal x801=x802.value;
j3array[0]=((-1.0)*x801);
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
j3array[1]=((3.14159265358979)+(((-1.0)*x801)));
sj3array[1]=IKsin(j3array[1]);
cj3array[1]=IKcos(j3array[1]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
if( j3array[1] > IKPI )
{
    j3array[1]-=IK2PI;
}
else if( j3array[1] < -IKPI )
{    j3array[1]+=IK2PI;
}
j3valid[1] = true;
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[5];
IkReal x803=IKcos(j3);
IkReal x804=IKsin(j3);
IkReal x805=(new_r11*x803);
IkReal x806=(new_r10*x803);
IkReal x807=((1.0)*x804);
evalcond[0]=(((new_r00*x803))+((new_r10*x804)));
evalcond[1]=((((-1.0)*new_r00*x807))+x806);
evalcond[2]=((((-1.0)*new_r01*x807))+x805);
evalcond[3]=(((new_r22*x806))+(((-1.0)*new_r00*new_r22*x807)));
evalcond[4]=(((new_r22*x805))+(((-1.0)*new_r01*new_r22*x807)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j3]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x809=IKPowWithIntegerCheck(sj4,-1);
if(!x809.valid){
continue;
}
IkReal x808=x809.value;
CheckValue<IkReal> x810=IKPowWithIntegerCheck(new_r11,-1);
if(!x810.valid){
continue;
}
if( IKabs((x808*(x810.value)*((((new_r01*new_r12))+(((-1.0)*sj4*sj5)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r12*x808)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x808*(x810.value)*((((new_r01*new_r12))+(((-1.0)*sj4*sj5))))))+IKsqr(((-1.0)*new_r12*x808))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2((x808*(x810.value)*((((new_r01*new_r12))+(((-1.0)*sj4*sj5))))), ((-1.0)*new_r12*x808));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[18];
IkReal x811=IKsin(j3);
IkReal x812=IKcos(j3);
IkReal x813=((1.0)*cj5);
IkReal x814=((1.0)*cj4);
IkReal x815=(new_r11*x812);
IkReal x816=(sj5*x812);
IkReal x817=(cj4*x812);
IkReal x818=(sj4*x812);
IkReal x819=(new_r00*x811);
IkReal x820=(cj4*x811);
IkReal x821=(new_r01*x811);
IkReal x822=(new_r02*x811);
IkReal x823=((1.0)*sj4*x811);
evalcond[0]=(new_r12+x818);
evalcond[1]=((((-1.0)*x823))+new_r02);
evalcond[2]=(((new_r12*x811))+((new_r02*x812)));
evalcond[3]=(sj5+((new_r11*x811))+((new_r01*x812)));
evalcond[4]=(sj4+((new_r12*x812))+(((-1.0)*x822)));
evalcond[5]=(((cj5*x820))+new_r01+x816);
evalcond[6]=(((new_r00*x812))+((new_r10*x811))+(((-1.0)*x813)));
evalcond[7]=((((-1.0)*x812*x813))+((sj5*x820))+new_r00);
evalcond[8]=(((sj5*x811))+(((-1.0)*x813*x817))+new_r11);
evalcond[9]=((((-1.0)*x811*x813))+(((-1.0)*x814*x816))+new_r10);
evalcond[10]=(((new_r10*x812))+(((-1.0)*x819))+(((-1.0)*sj5*x814)));
evalcond[11]=((((-1.0)*x821))+(((-1.0)*cj4*x813))+x815);
evalcond[12]=(((new_r12*x817))+(((-1.0)*x814*x822))+((new_r22*sj4)));
evalcond[13]=(((new_r10*x818))+(((-1.0)*new_r20*x814))+(((-1.0)*sj4*x819)));
evalcond[14]=(((sj4*x815))+(((-1.0)*new_r21*x814))+(((-1.0)*sj4*x821)));
evalcond[15]=((1.0)+((new_r12*x818))+(((-1.0)*sj4*x822))+(((-1.0)*new_r22*x814)));
evalcond[16]=((((-1.0)*sj5))+((new_r20*sj4))+((new_r10*x817))+(((-1.0)*x814*x819)));
evalcond[17]=((((-1.0)*x814*x821))+(((-1.0)*x813))+((cj4*x815))+((new_r21*sj4)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
CheckValue<IkReal> x824=IKPowWithIntegerCheck(IKsign(sj4),-1);
if(!x824.valid){
continue;
}
CheckValue<IkReal> x825 = IKatan2WithCheck(IkReal(new_r02),IkReal(((-1.0)*new_r12)),IKFAST_ATAN2_MAGTHRESH);
if(!x825.valid){
continue;
}
j3array[0]=((-1.5707963267949)+(((1.5707963267949)*(x824.value)))+(x825.value));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[18];
IkReal x826=IKsin(j3);
IkReal x827=IKcos(j3);
IkReal x828=((1.0)*cj5);
IkReal x829=((1.0)*cj4);
IkReal x830=(new_r11*x827);
IkReal x831=(sj5*x827);
IkReal x832=(cj4*x827);
IkReal x833=(sj4*x827);
IkReal x834=(new_r00*x826);
IkReal x835=(cj4*x826);
IkReal x836=(new_r01*x826);
IkReal x837=(new_r02*x826);
IkReal x838=((1.0)*sj4*x826);
evalcond[0]=(new_r12+x833);
evalcond[1]=((((-1.0)*x838))+new_r02);
evalcond[2]=(((new_r12*x826))+((new_r02*x827)));
evalcond[3]=(sj5+((new_r01*x827))+((new_r11*x826)));
evalcond[4]=(sj4+((new_r12*x827))+(((-1.0)*x837)));
evalcond[5]=(((cj5*x835))+new_r01+x831);
evalcond[6]=(((new_r10*x826))+(((-1.0)*x828))+((new_r00*x827)));
evalcond[7]=((((-1.0)*x827*x828))+((sj5*x835))+new_r00);
evalcond[8]=((((-1.0)*x828*x832))+((sj5*x826))+new_r11);
evalcond[9]=((((-1.0)*x826*x828))+new_r10+(((-1.0)*x829*x831)));
evalcond[10]=(((new_r10*x827))+(((-1.0)*x834))+(((-1.0)*sj5*x829)));
evalcond[11]=((((-1.0)*cj4*x828))+(((-1.0)*x836))+x830);
evalcond[12]=(((new_r12*x832))+((new_r22*sj4))+(((-1.0)*x829*x837)));
evalcond[13]=((((-1.0)*new_r20*x829))+(((-1.0)*sj4*x834))+((new_r10*x833)));
evalcond[14]=(((sj4*x830))+(((-1.0)*sj4*x836))+(((-1.0)*new_r21*x829)));
evalcond[15]=((1.0)+((new_r12*x833))+(((-1.0)*sj4*x837))+(((-1.0)*new_r22*x829)));
evalcond[16]=((((-1.0)*sj5))+((new_r20*sj4))+(((-1.0)*x829*x834))+((new_r10*x832)));
evalcond[17]=((((-1.0)*x828))+((cj4*x830))+((new_r21*sj4))+(((-1.0)*x829*x836)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}
}
}
}
}static inline void polyroots3(IkReal rawcoeffs[3+1], IkReal rawroots[3], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots2(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[3];
    const int maxsteps = 110;
    for(int i = 0; i < 3; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[3];
    IkReal err[3];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 3; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 3; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 3; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 3; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[3] = {false};
    for(int i = 0; i < 3; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 3; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots2(IkReal rawcoeffs[2+1], IkReal rawroots[2], int& numroots) {
    IkReal det = rawcoeffs[1]*rawcoeffs[1]-4*rawcoeffs[0]*rawcoeffs[2];
    if( det < 0 ) {
        numroots=0;
    }
    else if( det == 0 ) {
        rawroots[0] = -0.5*rawcoeffs[1]/rawcoeffs[0];
        numroots = 1;
    }
    else {
        det = IKsqrt(det);
        rawroots[0] = (-rawcoeffs[1]+det)/(2*rawcoeffs[0]);
        rawroots[1] = (-rawcoeffs[1]-det)/(2*rawcoeffs[0]);//rawcoeffs[2]/(rawcoeffs[0]*rawroots[0]);
        numroots = 2;
    }
}
static inline void polyroots4(IkReal rawcoeffs[4+1], IkReal rawroots[4], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots3(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[4];
    const int maxsteps = 110;
    for(int i = 0; i < 4; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[4];
    IkReal err[4];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 4; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 4; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 4; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 4; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[4] = {false};
    for(int i = 0; i < 4; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 4; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
};


/// solves the inverse kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API bool ComputeIk2(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions, void* pOpenRAVEManip) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API const char* GetKinematicsHash() { return "<robot:GenericRobot - khi_rs013n (5fabbc108a7789503f31e24981d282cb)>"; }

IKFAST_API const char* GetIkFastVersion() { return "0x10000049"; }

#ifdef IKFAST_NAMESPACE
} // end namespace
#endif

#ifndef IKFAST_NO_MAIN
#include <stdio.h>
#include <stdlib.h>
#ifdef IKFAST_NAMESPACE
using namespace IKFAST_NAMESPACE;
#endif
int main(int argc, char** argv)
{
    if( argc != 12+GetNumFreeParameters()+1 ) {
        printf("\nUsage: ./ik r00 r01 r02 t0 r10 r11 r12 t1 r20 r21 r22 t2 free0 ...\n\n"
               "Returns the ik solutions given the transformation of the end effector specified by\n"
               "a 3x3 rotation R (rXX), and a 3x1 translation (tX).\n"
               "There are %d free parameters that have to be specified.\n\n",GetNumFreeParameters());
        return 1;
    }

    IkSolutionList<IkReal> solutions;
    std::vector<IkReal> vfree(GetNumFreeParameters());
    IkReal eerot[9],eetrans[3];
    eerot[0] = atof(argv[1]); eerot[1] = atof(argv[2]); eerot[2] = atof(argv[3]); eetrans[0] = atof(argv[4]);
    eerot[3] = atof(argv[5]); eerot[4] = atof(argv[6]); eerot[5] = atof(argv[7]); eetrans[1] = atof(argv[8]);
    eerot[6] = atof(argv[9]); eerot[7] = atof(argv[10]); eerot[8] = atof(argv[11]); eetrans[2] = atof(argv[12]);
    for(std::size_t i = 0; i < vfree.size(); ++i)
        vfree[i] = atof(argv[13+i]);
    bool bSuccess = ComputeIk(eetrans, eerot, vfree.size() > 0 ? &vfree[0] : NULL, solutions);

    if( !bSuccess ) {
        fprintf(stderr,"Failed to get ik solution\n");
        return -1;
    }

    printf("Found %d ik solutions:\n", (int)solutions.GetNumSolutions());
    std::vector<IkReal> solvalues(GetNumJoints());
    for(std::size_t i = 0; i < solutions.GetNumSolutions(); ++i) {
        const IkSolutionBase<IkReal>& sol = solutions.GetSolution(i);
        printf("sol%d (free=%d): ", (int)i, (int)sol.GetFree().size());
        std::vector<IkReal> vsolfree(sol.GetFree().size());
        sol.GetSolution(&solvalues[0],vsolfree.size()>0?&vsolfree[0]:NULL);
        for( std::size_t j = 0; j < solvalues.size(); ++j)
            printf("%.15f, ", solvalues[j]);
        printf("\n");
    }
    return 0;
}

#endif
