// License: Apache 2.0. See LICENSE file in root directory.
// Copyright(c) 2019 Intel Corporation. All Rights Reserved.
#pragma once


#include <cstdint>
#include <cstring>

#define ONE_NIBBLE_ROLLED() \
       currentState = stateWord & 0x7fc0; \
       nextStateWord = *(uint32_t *)(((unsigned char *)DecompressionStateTable) + currentState + nibble); \
       if (stateWord & 0x8) { \
              *currentImageLine++ = byteAbove + (unsigned char)(stateWord >> 24); \
              byteAbove = *previousImageLine++; \
              for (i = 0; i < (stateWord & 0x7); i++) { \
                     *currentImageLine++ = byteAbove; \
                     byteAbove = *previousImageLine++; \
              } \
       } \
       stateWord = nextStateWord;

#define ONE_NIBBLE_UNROLLED() \
       currentState = stateWord & 0x7fc0; \
       nextStateWord = *(uint32_t *)(((unsigned char *)DecompressionStateTable) + currentState + nibble); \
       if (stateWord & 0x8) { \
              *currentImageLine++ = byteAbove + (unsigned char)(stateWord >> 24); \
              byteAbove = *previousImageLine++; \
              currentImageLine += (stateWord & 0x7); \
              previousImageLine += (stateWord &0x7); \
              switch (stateWord & 0x7) { \
                     case 7:\
                           currentImageLine[-7] = byteAbove; \
                           byteAbove = previousImageLine[-7]; \
                     case 6:\
                           currentImageLine[-6] = byteAbove; \
                           byteAbove = previousImageLine[-6]; \
                     case 5:\
                           currentImageLine[-5] = byteAbove; \
                           byteAbove = previousImageLine[-5]; \
                     case 4:\
                           currentImageLine[-4] = byteAbove; \
                           byteAbove = previousImageLine[-4]; \
                     case 3:\
                           currentImageLine[-3] = byteAbove; \
                           byteAbove = previousImageLine[-3]; \
                     case 2:\
                           currentImageLine[-2] = byteAbove; \
                           byteAbove = previousImageLine[-2]; \
                     case 1:\
                           currentImageLine[-1] = byteAbove; \
                           byteAbove = previousImageLine[-1]; \
                           break; \
                     default: \
                           break; \
              } \
       } \
       stateWord = nextStateWord;

#define ONE_NIBBLE_LONG() \
       currentState = stateWord & 0x7fc0; \
       nextStateWord = *(uint32_t *)(((unsigned char *)DecompressionStateTable) + currentState + nibble); \
       switch (stateWord & 0xf) { \
              case 0xf:\
                     *currentImageLine = byteAbove + (unsigned char)(stateWord >> 24); \
                     currentImageLine += 8; \
                     previousImageLine += 8; \
                     currentImageLine[-7] = previousImageLine[-8]; \
                     currentImageLine[-6] = previousImageLine[-7]; \
                     currentImageLine[-5] = previousImageLine[-6]; \
                     currentImageLine[-4] = previousImageLine[-5]; \
                     currentImageLine[-3] = previousImageLine[-4]; \
                     currentImageLine[-2] = previousImageLine[-3]; \
                     currentImageLine[-1] = previousImageLine[-2]; \
                     byteAbove = previousImageLine[-1]; \
                     break; \
              case 0xe:\
                     *currentImageLine = byteAbove + (unsigned char)(stateWord >> 24); \
                     currentImageLine += 7; \
                     previousImageLine += 7; \
                     currentImageLine[-6] = previousImageLine[-7]; \
                     currentImageLine[-5] = previousImageLine[-6]; \
                     currentImageLine[-4] = previousImageLine[-5]; \
                     currentImageLine[-3] = previousImageLine[-4]; \
                     currentImageLine[-2] = previousImageLine[-3]; \
                     currentImageLine[-1] = previousImageLine[-2]; \
                     byteAbove = previousImageLine[-1]; \
                     break; \
              case 0xd:\
                     *currentImageLine = byteAbove + (unsigned char)(stateWord >> 24); \
                     currentImageLine += 6; \
                     previousImageLine += 6; \
                     currentImageLine[-5] = previousImageLine[-6]; \
                     currentImageLine[-4] = previousImageLine[-5]; \
                     currentImageLine[-3] = previousImageLine[-4]; \
                     currentImageLine[-2] = previousImageLine[-3]; \
                     currentImageLine[-1] = previousImageLine[-2]; \
                     byteAbove = previousImageLine[-1]; \
                     break; \
              case 0xc:\
                     *currentImageLine = byteAbove + (unsigned char)(stateWord >> 24); \
                     currentImageLine += 5; \
                     previousImageLine += 5; \
                     currentImageLine[-4] = previousImageLine[-5]; \
                     currentImageLine[-3] = previousImageLine[-4]; \
                     currentImageLine[-2] = previousImageLine[-3]; \
                     currentImageLine[-1] = previousImageLine[-2]; \
                     byteAbove = previousImageLine[-1]; \
                     break; \
              case 0xb: \
                     *currentImageLine = byteAbove + (unsigned char)(stateWord >> 24); \
                     currentImageLine += 4; \
                     previousImageLine += 4; \
                     currentImageLine[-3] = previousImageLine[-4]; \
                     currentImageLine[-2] = previousImageLine[-3]; \
                     currentImageLine[-1] = previousImageLine[-2]; \
                     byteAbove = previousImageLine[-1]; \
                     break; \
              case 0xa: \
                     *currentImageLine = byteAbove + (unsigned char)(stateWord >> 24); \
                     currentImageLine += 3; \
                     previousImageLine += 3; \
                     currentImageLine[-2] = previousImageLine[-3]; \
                     currentImageLine[-1] = previousImageLine[-2]; \
                     byteAbove = previousImageLine[-1]; \
                     break; \
              case 0x9:\
                     *currentImageLine = byteAbove + (unsigned char)(stateWord >> 24); \
                     currentImageLine += 2; \
                     previousImageLine += 2; \
                     currentImageLine[-1] = previousImageLine[-2]; \
                     byteAbove = previousImageLine[-1]; \
                     break; \
              case 0x8:\
                     *currentImageLine = byteAbove + (unsigned char)(stateWord >> 24); \
                     byteAbove = *previousImageLine; \
                     currentImageLine += 1; \
                     previousImageLine += 1; \
                     break; \
       } \
       stateWord = nextStateWord;

#define ONE_NIBBLE_ROLLED_CHECKING(_bound_) \
       currentState = stateWord & 0x7fc0; \
       nextStateWord = *(uint32_t *)(((unsigned char *)DecompressionStateTable) + currentState + nibble); \
       if (stateWord & 0x8) { \
              *currentImageLine++ = byteAbove + (unsigned char)(stateWord >> 24); \
              byteAbove = *previousImageLine++; \
              for (i = 0; i < (stateWord & 0x7) && currentImageLine < (_bound_); i++) { \
                     *currentImageLine++ = byteAbove; \
                     byteAbove = *previousImageLine++; \
              } \
       } \
       stateWord = nextStateWord;

#define ONE_NIBBLE ONE_NIBBLE_LONG

static int DecompressionStateTable[510 * 16] =
{
    // State 0
    (0 << 24) | (4 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (112 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (149 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (150 << 6) | (0 << 3) | 0, // nibble 03
    (0 << 24) | (225 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (261 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (295 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (398 << 6) | (0 << 3) | 0, // nibble 07
    (0 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (0 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (0 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (0 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (0 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (0 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (0 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (0 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 1
    (0 << 24) | (5 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (20 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (113 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (129 << 6) | (0 << 3) | 0, // nibble 03
    (1 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (255 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (0 << 24) | (151 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (152 << 6) | (0 << 3) | 0, // nibble 07
    (0 << 24) | (226 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (239 << 6) | (0 << 3) | 0, // nibble 09
    (0 << 24) | (262 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (263 << 6) | (0 << 3) | 0, // nibble 0b
    (0 << 24) | (296 << 6) | (0 << 3) | 0, // nibble 0c
    (0 << 24) | (396 << 6) | (0 << 3) | 0, // nibble 0d
    (0 << 24) | (399 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (471 << 6) | (0 << 3) | 0, // nibble 0f
    // State 2
    (9 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (0 << 24) | (6 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (21 << 6) | (0 << 3) | 0, // nibble 02
    (248 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (8 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (0 << 24) | (114 << 6) | (0 << 3) | 0, // nibble 05
    (7 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (0 << 24) | (130 << 6) | (0 << 3) | 0, // nibble 07
    (1 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (1 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (255 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (255 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (249 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (250 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (0 << 24) | (153 << 6) | (0 << 3) | 0, // nibble 0e
    (6 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 3
    (9 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (9 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (0 << 24) | (7 << 6) | (0 << 3) | 0, // nibble 02
    (15 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (0 << 24) | (22 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (50 << 6) | (0 << 3) | 0, // nibble 05
    (248 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (248 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (8 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (8 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (242 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (0 << 24) | (115 << 6) | (0 << 3) | 0, // nibble 0b
    (7 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (7 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (0 << 24) | (131 << 6) | (0 << 3) | 0, // nibble 0e
    (14 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 4
    (9 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (9 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (9 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (9 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (0 << 24) | (8 << 6) | (0 << 3) | 0, // nibble 04
    (236 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (15 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (15 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (0 << 24) | (23 << 6) | (0 << 3) | 0, // nibble 08
    (20 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (0 << 24) | (51 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (78 << 6) | (0 << 3) | 0, // nibble 0b
    (248 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (248 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (248 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (248 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 5
    (9 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (9 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (9 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (9 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (9 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (9 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (9 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (9 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (232 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (0 << 24) | (9 << 6) | (0 << 3) | 0, // nibble 09
    (236 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (236 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (15 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (15 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (15 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (15 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 6
    (232 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (232 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (0 << 24) | (10 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (16 << 6) | (0 << 3) | 0, // nibble 03
    (236 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (236 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (236 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (236 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (15 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (15 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (15 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (15 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (15 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (15 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (15 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (15 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 7
    (232 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (232 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (232 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (232 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (0 << 24) | (11 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (13 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (17 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (18 << 6) | (0 << 3) | 0, // nibble 07
    (236 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (236 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (236 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (236 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (236 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (236 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (236 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (236 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 8
    (232 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (232 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (232 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (232 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (232 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (232 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (232 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (232 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (244 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (0 << 24) | (12 << 6) | (0 << 3) | 0, // nibble 09
    (0 << 24) | (14 << 6) | (0 << 3) | 0, // nibble 0a
    (245 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (193 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (207 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (247 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (0 << 24) | (19 << 6) | (0 << 3) | 0, // nibble 0f
    // State 9
    (244 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (244 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (152 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (80 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (82 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (0 << 24) | (15 << 6) | (0 << 3) | 0, // nibble 05
    (245 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (245 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (193 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (193 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (207 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (207 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (247 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (247 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (160 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (171 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 10
    (244 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (244 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (244 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (244 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (152 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (152 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (80 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (80 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (82 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (82 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (211 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (30 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (245 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (245 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (245 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (245 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 11
    (244 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (244 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (244 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (244 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (244 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (244 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (244 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (244 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (152 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (152 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (152 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (152 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (80 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (80 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (80 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (80 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 12
    (152 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (152 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (152 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (152 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (152 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (152 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (152 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (152 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (80 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (80 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (80 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (80 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (80 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (80 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (80 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (80 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 13
    (82 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (82 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (82 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (82 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (211 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (211 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (30 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (30 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (245 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (245 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (245 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (245 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (245 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (245 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (245 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (245 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 14
    (82 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (82 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (82 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (82 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (82 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (82 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (82 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (82 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (211 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (211 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (211 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (211 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (30 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (30 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (30 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (30 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 15
    (211 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (211 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (211 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (211 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (211 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (211 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (211 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (211 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (30 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (30 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (30 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (30 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (30 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (30 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (30 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (30 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 16
    (193 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (193 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (193 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (193 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (207 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (207 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (207 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (207 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (247 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (247 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (247 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (247 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (160 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (160 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (171 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (171 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 17
    (193 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (193 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (193 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (193 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (193 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (193 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (193 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (193 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (207 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (207 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (207 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (207 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (207 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (207 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (207 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (207 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 18
    (247 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (247 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (247 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (247 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (247 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (247 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (247 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (247 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (160 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (160 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (160 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (160 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (171 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (171 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (171 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (171 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 19
    (160 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (160 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (160 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (160 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (160 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (160 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (160 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (160 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (171 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (171 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (171 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (171 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (171 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (171 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (171 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (171 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 20
    (0 << 24) | (24 << 6) | (0 << 3) | 0, // nibble 00
    (25 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (20 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (20 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (0 << 24) | (52 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (63 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (79 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (102 << 6) | (0 << 3) | 0, // nibble 07
    (248 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (248 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (248 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (248 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (248 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (248 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (248 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (248 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 21
    (0 << 24) | (25 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (43 << 6) | (0 << 3) | 0, // nibble 01
    (25 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (25 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (20 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (20 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (20 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (20 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (0 << 24) | (53 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (60 << 6) | (0 << 3) | 0, // nibble 09
    (0 << 24) | (64 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (73 << 6) | (0 << 3) | 0, // nibble 0b
    (0 << 24) | (80 << 6) | (0 << 3) | 0, // nibble 0c
    (0 << 24) | (87 << 6) | (0 << 3) | 0, // nibble 0d
    (228 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (0 << 24) | (103 << 6) | (0 << 3) | 0, // nibble 0f
    // State 22
    (0 << 24) | (26 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (32 << 6) | (0 << 3) | 0, // nibble 01
    (36 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (0 << 24) | (44 << 6) | (0 << 3) | 0, // nibble 03
    (25 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (25 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (25 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (25 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (20 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (20 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (20 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (20 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (20 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (20 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (20 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (20 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 23
    (0 << 24) | (27 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (29 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (33 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (36 << 6) | (0 << 3) | 0, // nibble 03
    (36 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (36 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (0 << 24) | (45 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (49 << 6) | (0 << 3) | 0, // nibble 07
    (25 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (25 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (25 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (25 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (25 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (25 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (25 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (25 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 24
    (232 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (0 << 24) | (28 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (30 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (31 << 6) | (0 << 3) | 0, // nibble 03
    (0 << 24) | (34 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (35 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (37 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (40 << 6) | (0 << 3) | 0, // nibble 07
    (36 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (36 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (36 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (36 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (0 << 24) | (46 << 6) | (0 << 3) | 0, // nibble 0c
    (156 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (164 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (83 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 25
    (232 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (232 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (32 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (141 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (97 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (103 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (147 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (156 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (165 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (179 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (192 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (213 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (0 << 24) | (38 << 6) | (0 << 3) | 0, // nibble 0c
    (0 << 24) | (39 << 6) | (0 << 3) | 0, // nibble 0d
    (0 << 24) | (41 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (42 << 6) | (0 << 3) | 0, // nibble 0f
    // State 26
    (232 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (232 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (232 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (232 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (32 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (32 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (141 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (141 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (97 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (97 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (103 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (103 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (147 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (147 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (156 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (156 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 27
    (232 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (232 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (232 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (232 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (232 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (232 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (232 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (232 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (32 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (32 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (32 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (32 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (141 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (141 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (141 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (141 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 28
    (32 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (32 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (32 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (32 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (32 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (32 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (32 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (32 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (141 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (141 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (141 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (141 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (141 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (141 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (141 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (141 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 29
    (97 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (97 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (97 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (97 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (103 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (103 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (103 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (103 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (147 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (147 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (147 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (147 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (156 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (156 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (156 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (156 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 30
    (97 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (97 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (97 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (97 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (97 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (97 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (97 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (97 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (103 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (103 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (103 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (103 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (103 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (103 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (103 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (103 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 31
    (147 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (147 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (147 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (147 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (147 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (147 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (147 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (147 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (156 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (156 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (156 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (156 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (156 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (156 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (156 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (156 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 32
    (165 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (165 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (179 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (179 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (192 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (192 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (213 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (213 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (1 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (39 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (47 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (122 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (117 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (135 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (136 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (141 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 33
    (165 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (165 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (165 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (165 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (179 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (179 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (179 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (179 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (192 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (192 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (192 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (192 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (213 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (213 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (213 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (213 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 34
    (165 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (165 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (165 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (165 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (165 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (165 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (165 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (165 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (179 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (179 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (179 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (179 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (179 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (179 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (179 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (179 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 35
    (192 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (192 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (192 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (192 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (192 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (192 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (192 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (192 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (213 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (213 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (213 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (213 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (213 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (213 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (213 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (213 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 36
    (1 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (1 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (39 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (39 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (47 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (47 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (122 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (122 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (117 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (117 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (135 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (135 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (136 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (136 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (141 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (141 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 37
    (1 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (1 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (1 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (1 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (39 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (39 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (39 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (39 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (47 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (47 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (47 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (47 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (122 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (122 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (122 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (122 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 38
    (1 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (1 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (1 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (1 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (1 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (1 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (1 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (1 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (39 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (39 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (39 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (39 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (39 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (39 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (39 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (39 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 39
    (47 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (47 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (47 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (47 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (47 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (47 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (47 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (47 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (122 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (122 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (122 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (122 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (122 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (122 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (122 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (122 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 40
    (117 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (117 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (117 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (117 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (135 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (135 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (135 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (135 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (136 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (136 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (136 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (136 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (141 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (141 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (141 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (141 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 41
    (117 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (117 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (117 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (117 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (117 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (117 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (117 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (117 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (135 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (135 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (135 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (135 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (135 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (135 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (135 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (135 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 42
    (136 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (136 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (136 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (136 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (136 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (136 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (136 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (136 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (141 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (141 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (141 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (141 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (141 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (141 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (141 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (141 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 43
    (36 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (36 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (36 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (36 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (36 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (36 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (36 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (36 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (0 << 24) | (47 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (48 << 6) | (0 << 3) | 0, // nibble 09
    (156 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (156 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (164 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (164 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (83 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (83 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 44
    (144 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (149 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (151 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (155 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (156 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (156 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (156 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (156 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (164 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (164 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (164 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (164 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (83 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (83 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (83 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (83 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 45
    (144 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (144 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (149 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (149 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (151 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (151 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (155 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (155 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (156 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (156 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (156 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (156 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (156 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (156 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (156 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (156 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 46
    (144 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (144 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (144 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (144 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (149 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (149 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (149 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (149 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (151 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (151 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (151 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (151 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (155 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (155 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (155 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (155 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 47
    (144 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (144 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (144 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (144 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (144 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (144 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (144 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (144 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (149 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (149 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (149 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (149 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (149 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (149 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (149 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (149 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 48
    (151 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (151 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (151 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (151 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (151 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (151 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (151 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (151 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (155 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (155 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (155 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (155 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (155 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (155 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (155 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (155 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 49
    (164 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (164 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (164 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (164 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (164 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (164 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (164 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (164 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (83 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (83 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (83 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (83 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (83 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (83 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (83 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (83 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 50
    (0 << 24) | (54 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (59 << 6) | (0 << 3) | 0, // nibble 01
    (221 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (0 << 24) | (61 << 6) | (0 << 3) | 0, // nibble 03
    (0 << 24) | (65 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (69 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (74 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (76 << 6) | (0 << 3) | 0, // nibble 07
    (0 << 24) | (81 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (82 << 6) | (0 << 3) | 0, // nibble 09
    (0 << 24) | (88 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (91 << 6) | (0 << 3) | 0, // nibble 0b
    (228 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (228 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (0 << 24) | (104 << 6) | (0 << 3) | 0, // nibble 0e
    (222 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 51
    (0 << 24) | (55 << 6) | (0 << 3) | 0, // nibble 00
    (17 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (208 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (243 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (221 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (221 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (246 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (0 << 24) | (62 << 6) | (0 << 3) | 0, // nibble 07
    (0 << 24) | (66 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (67 << 6) | (0 << 3) | 0, // nibble 09
    (0 << 24) | (70 << 6) | (0 << 3) | 0, // nibble 0a
    (48 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (248 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (0 << 24) | (75 << 6) | (0 << 3) | 0, // nibble 0d
    (0 << 24) | (77 << 6) | (0 << 3) | 0, // nibble 0e
    (8 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 52
    (84 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (0 << 24) | (56 << 6) | (0 << 3) | 0, // nibble 01
    (17 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (17 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (208 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (208 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (243 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (243 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (221 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (221 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (221 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (221 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (246 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (246 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (23 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (150 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 53
    (84 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (84 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (0 << 24) | (57 << 6) | (0 << 3) | 0, // nibble 02
    (126 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (17 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (17 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (17 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (17 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (208 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (208 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (208 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (208 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (243 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (243 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (243 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (243 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 54
    (84 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (84 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (84 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (84 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (188 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (0 << 24) | (58 << 6) | (0 << 3) | 0, // nibble 05
    (126 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (126 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (17 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (17 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (17 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (17 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (17 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (17 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (17 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (17 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 55
    (84 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (84 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (84 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (84 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (84 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (84 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (84 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (84 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (188 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (188 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (48 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (97 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (126 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (126 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (126 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (126 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 56
    (188 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (188 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (188 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (188 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (48 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (48 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (97 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (97 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (126 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (126 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (126 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (126 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (126 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (126 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (126 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (126 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 57
    (188 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (188 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (188 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (188 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (188 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (188 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (188 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (188 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (48 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (48 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (48 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (48 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (97 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (97 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (97 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (97 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 58
    (48 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (48 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (48 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (48 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (48 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (48 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (48 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (48 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (97 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (97 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (97 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (97 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (97 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (97 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (97 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (97 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 59
    (208 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (208 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (208 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (208 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (208 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (208 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (208 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (208 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (243 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (243 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (243 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (243 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (243 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (243 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (243 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (243 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 60
    (221 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (221 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (221 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (221 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (221 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (221 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (221 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (221 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (246 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (246 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (246 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (246 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (23 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (23 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (150 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (150 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 61
    (246 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (246 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (246 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (246 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (246 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (246 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (246 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (246 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (23 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (23 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (23 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (23 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (150 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (150 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (150 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (150 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 62
    (23 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (23 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (23 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (23 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (23 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (23 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (23 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (23 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (150 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (150 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (150 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (150 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (150 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (150 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (150 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (150 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 63
    (73 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (92 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (231 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (0 << 24) | (68 << 6) | (0 << 3) | 0, // nibble 03
    (0 << 24) | (71 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (72 << 6) | (0 << 3) | 0, // nibble 05
    (48 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (48 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (248 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (248 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (163 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (170 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (65 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (76 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (8 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (8 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 64
    (73 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (73 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (92 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (92 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (231 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (231 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (130 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (132 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (140 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (107 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (168 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (224 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (48 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (48 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (48 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (48 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 65
    (73 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (73 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (73 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (73 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (92 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (92 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (92 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (92 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (231 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (231 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (231 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (231 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (130 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (130 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (132 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (132 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 66
    (73 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (73 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (73 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (73 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (73 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (73 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (73 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (73 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (92 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (92 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (92 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (92 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (92 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (92 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (92 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (92 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 67
    (231 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (231 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (231 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (231 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (231 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (231 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (231 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (231 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (130 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (130 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (130 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (130 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (132 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (132 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (132 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (132 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 68
    (130 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (130 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (130 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (130 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (130 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (130 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (130 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (130 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (132 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (132 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (132 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (132 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (132 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (132 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (132 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (132 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 69
    (140 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (140 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (107 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (107 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (168 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (168 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (224 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (224 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (48 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (48 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (48 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (48 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (48 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (48 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (48 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (48 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 70
    (140 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (140 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (140 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (140 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (107 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (107 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (107 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (107 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (168 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (168 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (168 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (168 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (224 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (224 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (224 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (224 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 71
    (140 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (140 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (140 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (140 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (140 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (140 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (140 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (140 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (107 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (107 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (107 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (107 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (107 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (107 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (107 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (107 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 72
    (168 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (168 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (168 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (168 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (168 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (168 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (168 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (168 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (224 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (224 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (224 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (224 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (224 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (224 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (224 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (224 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 73
    (248 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (248 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (248 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (248 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (163 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (163 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (170 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (170 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (65 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (65 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (76 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (76 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (8 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (8 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (8 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (8 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 74
    (248 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (248 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (248 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (248 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (248 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (248 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (248 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (248 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (163 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (163 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (163 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (163 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (170 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (170 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (170 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (170 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 75
    (163 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (163 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (163 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (163 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (163 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (163 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (163 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (163 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (170 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (170 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (170 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (170 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (170 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (170 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (170 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (170 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 76
    (65 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (65 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (65 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (65 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (76 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (76 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (76 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (76 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (8 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (8 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (8 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (8 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (8 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (8 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (8 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (8 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 77
    (65 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (65 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (65 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (65 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (65 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (65 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (65 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (65 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (76 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (76 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (76 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (76 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (76 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (76 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (76 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (76 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 78
    (9 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (209 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (44 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (0 << 24) | (83 << 6) | (0 << 3) | 0, // nibble 03
    (0 << 24) | (89 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (90 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (92 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (95 << 6) | (0 << 3) | 0, // nibble 07
    (228 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (228 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (228 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (228 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (0 << 24) | (105 << 6) | (0 << 3) | 0, // nibble 0c
    (210 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (222 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (222 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 79
    (9 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (9 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (209 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (209 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (44 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (44 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (0 << 24) | (84 << 6) | (0 << 3) | 0, // nibble 06
    (172 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (187 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (78 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (98 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (102 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (0 << 24) | (93 << 6) | (0 << 3) | 0, // nibble 0c
    (0 << 24) | (94 << 6) | (0 << 3) | 0, // nibble 0d
    (0 << 24) | (96 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (99 << 6) | (0 << 3) | 0, // nibble 0f
    // State 80
    (9 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (9 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (9 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (9 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (209 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (209 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (209 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (209 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (44 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (44 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (44 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (44 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (0 << 24) | (85 << 6) | (0 << 3) | 0, // nibble 0c
    (29 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (172 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (172 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 81
    (9 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (9 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (9 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (9 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (9 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (9 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (9 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (9 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (209 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (209 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (209 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (209 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (209 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (209 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (209 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (209 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 82
    (44 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (44 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (44 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (44 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (44 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (44 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (44 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (44 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (0 << 24) | (86 << 6) | (0 << 3) | 0, // nibble 08
    (49 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (29 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (29 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (172 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (172 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (172 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (172 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 83
    (112 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (195 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (49 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (49 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (29 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (29 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (29 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (29 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (172 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (172 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (172 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (172 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (172 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (172 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (172 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (172 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 84
    (112 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (112 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (195 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (195 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (49 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (49 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (49 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (49 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (29 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (29 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (29 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (29 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (29 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (29 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (29 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (29 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 85
    (112 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (112 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (112 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (112 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (195 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (195 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (195 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (195 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (49 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (49 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (49 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (49 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (49 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (49 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (49 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (49 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 86
    (112 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (112 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (112 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (112 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (112 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (112 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (112 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (112 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (195 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (195 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (195 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (195 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (195 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (195 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (195 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (195 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 87
    (187 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (187 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (78 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (78 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (98 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (98 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (102 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (102 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (206 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (217 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (223 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (230 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (0 << 24) | (97 << 6) | (0 << 3) | 0, // nibble 0c
    (0 << 24) | (98 << 6) | (0 << 3) | 0, // nibble 0d
    (0 << 24) | (100 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (101 << 6) | (0 << 3) | 0, // nibble 0f
    // State 88
    (187 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (187 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (187 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (187 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (78 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (78 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (78 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (78 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (98 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (98 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (98 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (98 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (102 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (102 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (102 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (102 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 89
    (187 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (187 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (187 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (187 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (187 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (187 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (187 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (187 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (78 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (78 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (78 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (78 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (78 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (78 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (78 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (78 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 90
    (98 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (98 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (98 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (98 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (98 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (98 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (98 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (98 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (102 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (102 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (102 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (102 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (102 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (102 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (102 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (102 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 91
    (206 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (206 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (217 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (217 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (223 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (223 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (230 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (230 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (54 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (60 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (65 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (69 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (76 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (78 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (96 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (117 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 92
    (206 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (206 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (206 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (206 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (217 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (217 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (217 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (217 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (223 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (223 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (223 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (223 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (230 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (230 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (230 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (230 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 93
    (206 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (206 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (206 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (206 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (206 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (206 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (206 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (206 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (217 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (217 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (217 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (217 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (217 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (217 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (217 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (217 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 94
    (223 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (223 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (223 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (223 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (223 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (223 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (223 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (223 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (230 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (230 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (230 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (230 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (230 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (230 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (230 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (230 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 95
    (54 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (54 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (60 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (60 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (65 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (65 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (69 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (69 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (76 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (76 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (78 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (78 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (96 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (96 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (117 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (117 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 96
    (54 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (54 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (54 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (54 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (60 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (60 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (60 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (60 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (65 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (65 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (65 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (65 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (69 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (69 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (69 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (69 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 97
    (54 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (54 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (54 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (54 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (54 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (54 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (54 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (54 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (60 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (60 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (60 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (60 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (60 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (60 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (60 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (60 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 98
    (65 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (65 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (65 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (65 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (65 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (65 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (65 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (65 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (69 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (69 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (69 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (69 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (69 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (69 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (69 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (69 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 99
    (76 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (76 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (76 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (76 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (78 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (78 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (78 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (78 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (96 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (96 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (96 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (96 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (117 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (117 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (117 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (117 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 100
    (76 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (76 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (76 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (76 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (76 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (76 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (76 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (76 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (78 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (78 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (78 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (78 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (78 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (78 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (78 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (78 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 101
    (96 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (96 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (96 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (96 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (96 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (96 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (96 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (96 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (117 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (117 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (117 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (117 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (117 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (117 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (117 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (117 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 102
    (228 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (228 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (228 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (228 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (228 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (228 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (228 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (228 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (0 << 24) | (106 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (109 << 6) | (0 << 3) | 0, // nibble 09
    (210 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (210 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (222 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (222 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (222 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (222 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 103
    (0 << 24) | (107 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (108 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (110 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (111 << 6) | (0 << 3) | 0, // nibble 03
    (210 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (210 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (210 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (210 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (222 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (222 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (222 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (222 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (222 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (222 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (222 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (222 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 104
    (119 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (114 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (122 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (146 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (153 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (157 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (194 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (201 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (210 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (210 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (210 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (210 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (210 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (210 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (210 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (210 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 105
    (119 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (119 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (114 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (114 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (122 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (122 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (146 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (146 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (153 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (153 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (157 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (157 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (194 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (194 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (201 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (201 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 106
    (119 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (119 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (119 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (119 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (114 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (114 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (114 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (114 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (122 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (122 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (122 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (122 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (146 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (146 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (146 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (146 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 107
    (119 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (119 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (119 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (119 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (119 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (119 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (119 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (119 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (114 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (114 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (114 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (114 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (114 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (114 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (114 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (114 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 108
    (122 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (122 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (122 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (122 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (122 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (122 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (122 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (122 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (146 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (146 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (146 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (146 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (146 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (146 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (146 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (146 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 109
    (153 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (153 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (153 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (153 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (157 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (157 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (157 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (157 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (194 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (194 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (194 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (194 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (201 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (201 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (201 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (201 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 110
    (153 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (153 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (153 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (153 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (153 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (153 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (153 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (153 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (157 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (157 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (157 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (157 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (157 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (157 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (157 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (157 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 111
    (194 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (194 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (194 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (194 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (194 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (194 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (194 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (194 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (201 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (201 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (201 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (201 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (201 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (201 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (201 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (201 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 112
    (8 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (8 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (8 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (8 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (242 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (242 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (237 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (0 << 24) | (116 << 6) | (0 << 3) | 0, // nibble 07
    (7 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (7 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (7 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (7 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (0 << 24) | (132 << 6) | (0 << 3) | 0, // nibble 0c
    (19 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (14 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (14 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 113
    (8 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (8 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (8 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (8 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (8 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (8 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (8 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (8 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (242 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (242 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (242 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (242 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (237 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (237 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (24 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (0 << 24) | (117 << 6) | (0 << 3) | 0, // nibble 0f
    // State 114
    (242 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (242 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (242 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (242 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (242 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (242 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (242 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (242 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (237 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (237 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (237 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (237 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (24 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (24 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (0 << 24) | (118 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (124 << 6) | (0 << 3) | 0, // nibble 0f
    // State 115
    (237 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (237 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (237 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (237 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (237 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (237 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (237 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (237 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (24 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (24 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (24 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (24 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (0 << 24) | (119 << 6) | (0 << 3) | 0, // nibble 0c
    (0 << 24) | (121 << 6) | (0 << 3) | 0, // nibble 0d
    (0 << 24) | (125 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (127 << 6) | (0 << 3) | 0, // nibble 0f
    // State 116
    (24 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (24 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (24 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (24 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (24 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (24 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (24 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (24 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (10 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (0 << 24) | (120 << 6) | (0 << 3) | 0, // nibble 09
    (0 << 24) | (122 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (123 << 6) | (0 << 3) | 0, // nibble 0b
    (0 << 24) | (126 << 6) | (0 << 3) | 0, // nibble 0c
    (46 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (217 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (0 << 24) | (128 << 6) | (0 << 3) | 0, // nibble 0f
    // State 117
    (10 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (10 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (25 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (159 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (162 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (169 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (173 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (87 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (89 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (234 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (46 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (46 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (217 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (217 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (24 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (177 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 118
    (10 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (10 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (10 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (10 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (25 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (25 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (159 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (159 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (162 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (162 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (169 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (169 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (173 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (173 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (87 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (87 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 119
    (10 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (10 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (10 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (10 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (10 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (10 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (10 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (10 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (25 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (25 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (25 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (25 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (159 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (159 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (159 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (159 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 120
    (25 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (25 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (25 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (25 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (25 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (25 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (25 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (25 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (159 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (159 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (159 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (159 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (159 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (159 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (159 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (159 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 121
    (162 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (162 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (162 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (162 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (169 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (169 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (169 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (169 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (173 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (173 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (173 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (173 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (87 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (87 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (87 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (87 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 122
    (162 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (162 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (162 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (162 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (162 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (162 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (162 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (162 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (169 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (169 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (169 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (169 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (169 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (169 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (169 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (169 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 123
    (173 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (173 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (173 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (173 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (173 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (173 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (173 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (173 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (87 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (87 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (87 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (87 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (87 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (87 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (87 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (87 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 124
    (89 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (89 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (234 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (234 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (46 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (46 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (46 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (46 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (217 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (217 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (217 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (217 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (24 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (24 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (177 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (177 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 125
    (89 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (89 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (89 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (89 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (234 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (234 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (234 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (234 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (46 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (46 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (46 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (46 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (46 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (46 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (46 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (46 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 126
    (89 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (89 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (89 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (89 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (89 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (89 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (89 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (89 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (234 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (234 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (234 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (234 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (234 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (234 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (234 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (234 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 127
    (217 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (217 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (217 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (217 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (217 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (217 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (217 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (217 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (24 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (24 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (24 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (24 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (177 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (177 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (177 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (177 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 128
    (24 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (24 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (24 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (24 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (24 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (24 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (24 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (24 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (177 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (177 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (177 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (177 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (177 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (177 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (177 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (177 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 129
    (7 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (7 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (7 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (7 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (7 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (7 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (7 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (7 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (233 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (0 << 24) | (133 << 6) | (0 << 3) | 0, // nibble 09
    (19 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (19 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (14 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (14 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (14 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (14 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 130
    (233 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (233 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (0 << 24) | (134 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (140 << 6) | (0 << 3) | 0, // nibble 03
    (19 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (19 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (19 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (19 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (14 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (14 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (14 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (14 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (14 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (14 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (14 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (14 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 131
    (233 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (233 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (233 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (233 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (0 << 24) | (135 << 6) | (0 << 3) | 0, // nibble 04
    (34 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (0 << 24) | (141 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (145 << 6) | (0 << 3) | 0, // nibble 07
    (19 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (19 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (19 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (19 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (19 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (19 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (19 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (19 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 132
    (233 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (233 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (233 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (233 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (233 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (233 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (233 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (233 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (0 << 24) | (136 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (137 << 6) | (0 << 3) | 0, // nibble 09
    (34 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (34 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (0 << 24) | (142 << 6) | (0 << 3) | 0, // nibble 0c
    (12 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (0 << 24) | (146 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (147 << 6) | (0 << 3) | 0, // nibble 0f
    // State 133
    (233 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (252 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (0 << 24) | (138 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (139 << 6) | (0 << 3) | 0, // nibble 03
    (34 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (34 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (34 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (34 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (0 << 24) | (143 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (144 << 6) | (0 << 3) | 0, // nibble 09
    (12 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (12 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (69 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (71 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (77 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (79 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 134
    (233 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (233 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (252 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (252 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (138 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (139 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (145 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (161 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (34 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (34 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (34 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (34 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (34 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (34 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (34 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (34 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 135
    (233 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (233 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (233 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (233 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (252 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (252 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (252 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (252 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (138 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (138 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (139 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (139 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (145 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (145 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (161 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (161 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 136
    (233 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (233 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (233 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (233 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (233 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (233 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (233 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (233 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (252 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (252 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (252 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (252 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (252 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (252 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (252 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (252 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 137
    (138 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (138 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (138 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (138 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (139 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (139 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (139 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (139 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (145 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (145 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (145 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (145 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (161 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (161 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (161 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (161 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 138
    (138 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (138 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (138 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (138 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (138 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (138 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (138 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (138 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (139 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (139 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (139 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (139 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (139 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (139 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (139 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (139 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 139
    (145 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (145 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (145 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (145 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (145 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (145 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (145 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (145 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (161 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (161 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (161 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (161 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (161 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (161 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (161 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (161 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 140
    (112 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (119 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (127 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (216 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (12 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (12 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (12 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (12 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (69 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (69 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (71 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (71 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (77 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (77 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (79 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (79 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 141
    (112 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (112 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (119 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (119 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (127 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (127 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (216 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (216 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (12 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (12 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (12 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (12 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (12 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (12 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (12 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (12 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 142
    (112 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (112 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (112 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (112 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (119 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (119 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (119 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (119 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (127 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (127 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (127 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (127 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (216 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (216 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (216 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (216 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 143
    (112 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (112 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (112 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (112 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (112 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (112 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (112 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (112 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (119 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (119 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (119 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (119 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (119 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (119 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (119 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (119 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 144
    (127 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (127 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (127 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (127 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (127 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (127 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (127 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (127 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (216 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (216 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (216 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (216 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (216 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (216 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (216 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (216 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 145
    (69 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (69 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (69 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (69 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (71 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (71 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (71 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (71 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (77 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (77 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (77 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (77 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (79 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (79 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (79 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (79 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 146
    (69 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (69 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (69 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (69 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (69 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (69 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (69 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (69 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (71 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (71 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (71 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (71 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (71 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (71 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (71 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (71 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 147
    (77 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (77 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (77 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (77 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (77 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (77 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (77 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (77 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (79 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (79 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (79 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (79 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (79 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (79 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (79 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (79 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 148
    (1 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (1 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (1 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (1 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (255 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (255 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (255 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (255 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (249 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (249 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (250 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (250 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (0 << 24) | (154 << 6) | (0 << 3) | 0, // nibble 0c
    (243 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (6 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (6 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 149
    (1 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (1 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (1 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (1 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (1 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (1 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (1 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (1 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (255 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (255 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (255 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (255 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (255 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (255 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (255 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (255 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 150
    (249 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (249 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (249 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (249 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (250 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (250 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (250 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (250 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (0 << 24) | (155 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (185 << 6) | (0 << 3) | 0, // nibble 09
    (243 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (243 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (6 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (6 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (6 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (6 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 151
    (249 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (249 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (249 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (249 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (249 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (249 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (249 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (249 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (250 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (250 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (250 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (250 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (250 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (250 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (250 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (250 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 152
    (0 << 24) | (156 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (173 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (186 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (196 << 6) | (0 << 3) | 0, // nibble 03
    (243 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (243 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (243 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (243 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (6 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (6 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (6 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (6 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (6 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (6 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (6 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (6 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 153
    (29 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (0 << 24) | (157 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (174 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (181 << 6) | (0 << 3) | 0, // nibble 03
    (0 << 24) | (187 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (195 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (197 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (216 << 6) | (0 << 3) | 0, // nibble 07
    (243 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (243 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (243 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (243 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (243 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (243 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (243 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (243 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 154
    (29 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (29 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (0 << 24) | (158 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (172 << 6) | (0 << 3) | 0, // nibble 03
    (0 << 24) | (175 << 6) | (0 << 3) | 0, // nibble 04
    (35 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (0 << 24) | (182 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (183 << 6) | (0 << 3) | 0, // nibble 07
    (0 << 24) | (188 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (193 << 6) | (0 << 3) | 0, // nibble 09
    (224 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (223 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (0 << 24) | (198 << 6) | (0 << 3) | 0, // nibble 0c
    (0 << 24) | (201 << 6) | (0 << 3) | 0, // nibble 0d
    (33 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (0 << 24) | (217 << 6) | (0 << 3) | 0, // nibble 0f
    // State 155
    (29 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (29 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (29 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (29 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (0 << 24) | (159 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (165 << 6) | (0 << 3) | 0, // nibble 05
    (11 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (14 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (42 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (0 << 24) | (176 << 6) | (0 << 3) | 0, // nibble 09
    (35 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (35 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (16 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (212 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (0 << 24) | (184 << 6) | (0 << 3) | 0, // nibble 0e
    (218 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 156
    (29 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (29 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (29 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (29 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (29 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (29 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (29 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (29 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (0 << 24) | (160 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (164 << 6) | (0 << 3) | 0, // nibble 09
    (0 << 24) | (166 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (169 << 6) | (0 << 3) | 0, // nibble 0b
    (11 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (11 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (14 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (14 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 157
    (0 << 24) | (161 << 6) | (0 << 3) | 0, // nibble 00
    (136 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (104 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (109 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (0 << 24) | (167 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (168 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (170 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (171 << 6) | (0 << 3) | 0, // nibble 07
    (11 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (11 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (11 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (11 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (14 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (14 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (14 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (14 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 158
    (0 << 24) | (162 << 6) | (0 << 3) | 0, // nibble 00
    (43 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (136 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (136 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (104 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (104 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (109 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (109 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (68 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (81 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (84 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (129 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (150 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (173 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (185 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (203 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 159
    (0 << 24) | (163 << 6) | (0 << 3) | 0, // nibble 00
    (37 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (43 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (43 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (136 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (136 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (136 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (136 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (104 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (104 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (104 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (104 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (109 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (109 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (109 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (109 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 160
    (103 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (62 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (37 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (37 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (43 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (43 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (43 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (43 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (136 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (136 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (136 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (136 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (136 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (136 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (136 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (136 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 161
    (103 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (103 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (62 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (62 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (37 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (37 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (37 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (37 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (43 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (43 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (43 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (43 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (43 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (43 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (43 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (43 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 162
    (103 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (103 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (103 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (103 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (62 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (62 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (62 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (62 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (37 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (37 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (37 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (37 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (37 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (37 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (37 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (37 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 163
    (103 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (103 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (103 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (103 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (103 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (103 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (103 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (103 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (62 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (62 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (62 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (62 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (62 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (62 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (62 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (62 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 164
    (104 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (104 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (104 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (104 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (104 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (104 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (104 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (104 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (109 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (109 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (109 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (109 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (109 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (109 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (109 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (109 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 165
    (68 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (68 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (81 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (81 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (84 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (84 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (129 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (129 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (150 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (150 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (173 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (173 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (185 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (185 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (203 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (203 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 166
    (68 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (68 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (68 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (68 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (81 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (81 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (81 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (81 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (84 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (84 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (84 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (84 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (129 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (129 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (129 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (129 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 167
    (68 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (68 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (68 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (68 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (68 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (68 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (68 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (68 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (81 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (81 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (81 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (81 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (81 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (81 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (81 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (81 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 168
    (84 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (84 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (84 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (84 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (84 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (84 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (84 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (84 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (129 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (129 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (129 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (129 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (129 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (129 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (129 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (129 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 169
    (150 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (150 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (150 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (150 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (173 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (173 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (173 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (173 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (185 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (185 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (185 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (185 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (203 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (203 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (203 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (203 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 170
    (150 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (150 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (150 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (150 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (150 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (150 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (150 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (150 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (173 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (173 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (173 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (173 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (173 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (173 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (173 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (173 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 171
    (185 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (185 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (185 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (185 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (185 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (185 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (185 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (185 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (203 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (203 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (203 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (203 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (203 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (203 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (203 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (203 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 172
    (11 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (11 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (11 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (11 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (11 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (11 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (11 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (11 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (14 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (14 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (14 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (14 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (14 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (14 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (14 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (14 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 173
    (42 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (42 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (0 << 24) | (177 << 6) | (0 << 3) | 0, // nibble 02
    (158 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (35 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (35 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (35 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (35 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (16 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (16 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (212 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (212 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (62 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (66 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (218 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (218 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 174
    (42 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (42 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (42 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (42 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (0 << 24) | (178 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (179 << 6) | (0 << 3) | 0, // nibble 05
    (158 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (158 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (35 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (35 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (35 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (35 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (35 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (35 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (35 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (35 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 175
    (42 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (42 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (42 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (42 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (42 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (42 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (42 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (42 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (205 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (208 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (255 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (0 << 24) | (180 << 6) | (0 << 3) | 0, // nibble 0b
    (158 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (158 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (158 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (158 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 176
    (205 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (205 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (208 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (208 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (255 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (255 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (94 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (102 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (158 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (158 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (158 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (158 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (158 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (158 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (158 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (158 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 177
    (205 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (205 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (205 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (205 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (208 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (208 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (208 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (208 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (255 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (255 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (255 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (255 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (94 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (94 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (102 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (102 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 178
    (205 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (205 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (205 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (205 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (205 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (205 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (205 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (205 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (208 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (208 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (208 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (208 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (208 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (208 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (208 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (208 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 179
    (255 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (255 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (255 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (255 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (255 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (255 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (255 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (255 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (94 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (94 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (94 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (94 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (102 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (102 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (102 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (102 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 180
    (94 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (94 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (94 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (94 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (94 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (94 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (94 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (94 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (102 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (102 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (102 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (102 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (102 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (102 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (102 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (102 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 181
    (16 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (16 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (16 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (16 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (212 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (212 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (212 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (212 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (62 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (62 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (66 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (66 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (218 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (218 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (218 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (218 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 182
    (16 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (16 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (16 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (16 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (16 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (16 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (16 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (16 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (212 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (212 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (212 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (212 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (212 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (212 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (212 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (212 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 183
    (62 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (62 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (62 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (62 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (66 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (66 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (66 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (66 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (218 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (218 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (218 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (218 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (218 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (218 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (218 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (218 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 184
    (62 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (62 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (62 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (62 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (62 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (62 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (62 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (62 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (66 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (66 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (66 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (66 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (66 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (66 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (66 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (66 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 185
    (0 << 24) | (189 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (190 << 6) | (0 << 3) | 0, // nibble 01
    (43 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (0 << 24) | (194 << 6) | (0 << 3) | 0, // nibble 03
    (224 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (224 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (223 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (223 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (0 << 24) | (199 << 6) | (0 << 3) | 0, // nibble 08
    (216 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (0 << 24) | (202 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (209 << 6) | (0 << 3) | 0, // nibble 0b
    (33 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (33 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (0 << 24) | (218 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (222 << 6) | (0 << 3) | 0, // nibble 0f
    // State 186
    (186 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (251 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (0 << 24) | (191 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (192 << 6) | (0 << 3) | 0, // nibble 03
    (43 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (43 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (168 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (64 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (224 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (224 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (224 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (224 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (223 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (223 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (223 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (223 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 187
    (186 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (186 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (251 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (251 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (28 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (135 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (226 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (227 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (43 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (43 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (43 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (43 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (168 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (168 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (64 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (64 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 188
    (186 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (186 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (186 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (186 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (251 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (251 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (251 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (251 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (28 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (28 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (135 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (135 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (226 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (226 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (227 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (227 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 189
    (186 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (186 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (186 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (186 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (186 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (186 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (186 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (186 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (251 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (251 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (251 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (251 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (251 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (251 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (251 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (251 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 190
    (28 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (28 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (28 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (28 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (135 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (135 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (135 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (135 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (226 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (226 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (226 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (226 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (227 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (227 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (227 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (227 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 191
    (28 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (28 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (28 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (28 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (28 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (28 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (28 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (28 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (135 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (135 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (135 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (135 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (135 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (135 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (135 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (135 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 192
    (226 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (226 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (226 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (226 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (226 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (226 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (226 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (226 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (227 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (227 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (227 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (227 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (227 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (227 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (227 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (227 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 193
    (43 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (43 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (43 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (43 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (43 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (43 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (43 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (43 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (168 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (168 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (168 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (168 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (64 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (64 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (64 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (64 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 194
    (168 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (168 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (168 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (168 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (168 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (168 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (168 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (168 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (64 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (64 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (64 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (64 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (64 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (64 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (64 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (64 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 195
    (224 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (224 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (224 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (224 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (224 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (224 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (224 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (224 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (223 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (223 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (223 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (223 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (223 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (223 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (223 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (223 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 196
    (0 << 24) | (200 << 6) | (0 << 3) | 0, // nibble 00
    (249 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (216 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (216 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (0 << 24) | (203 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (206 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (210 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (213 << 6) | (0 << 3) | 0, // nibble 07
    (33 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (33 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (33 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (33 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (0 << 24) | (219 << 6) | (0 << 3) | 0, // nibble 0c
    (61 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (21 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (176 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 197
    (229 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (171 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (249 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (249 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (216 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (216 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (216 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (216 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (0 << 24) | (204 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (205 << 6) | (0 << 3) | 0, // nibble 09
    (0 << 24) | (207 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (208 << 6) | (0 << 3) | 0, // nibble 0b
    (0 << 24) | (211 << 6) | (0 << 3) | 0, // nibble 0c
    (0 << 24) | (212 << 6) | (0 << 3) | 0, // nibble 0d
    (0 << 24) | (214 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (215 << 6) | (0 << 3) | 0, // nibble 0f
    // State 198
    (229 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (229 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (171 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (171 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (249 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (249 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (249 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (249 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (216 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (216 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (216 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (216 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (216 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (216 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (216 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (216 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 199
    (229 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (229 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (229 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (229 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (171 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (171 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (171 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (171 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (249 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (249 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (249 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (249 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (249 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (249 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (249 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (249 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 200
    (229 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (229 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (229 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (229 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (229 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (229 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (229 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (229 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (171 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (171 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (171 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (171 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (171 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (171 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (171 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (171 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 201
    (45 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (46 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (58 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (67 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (74 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (79 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (82 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (85 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (87 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (89 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (93 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (101 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (104 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (107 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (110 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (115 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 202
    (45 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (45 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (46 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (46 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (58 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (58 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (67 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (67 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (74 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (74 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (79 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (79 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (82 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (82 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (85 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (85 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 203
    (45 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (45 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (45 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (45 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (46 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (46 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (46 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (46 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (58 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (58 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (58 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (58 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (67 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (67 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (67 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (67 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 204
    (45 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (45 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (45 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (45 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (45 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (45 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (45 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (45 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (46 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (46 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (46 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (46 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (46 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (46 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (46 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (46 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 205
    (58 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (58 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (58 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (58 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (58 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (58 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (58 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (58 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (67 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (67 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (67 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (67 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (67 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (67 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (67 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (67 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 206
    (74 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (74 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (74 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (74 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (79 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (79 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (79 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (79 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (82 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (82 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (82 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (82 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (85 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (85 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (85 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (85 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 207
    (74 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (74 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (74 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (74 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (74 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (74 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (74 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (74 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (79 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (79 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (79 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (79 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (79 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (79 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (79 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (79 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 208
    (82 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (82 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (82 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (82 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (82 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (82 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (82 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (82 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (85 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (85 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (85 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (85 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (85 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (85 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (85 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (85 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 209
    (87 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (87 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (89 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (89 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (93 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (93 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (101 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (101 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (104 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (104 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (107 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (107 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (110 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (110 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (115 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (115 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 210
    (87 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (87 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (87 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (87 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (89 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (89 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (89 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (89 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (93 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (93 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (93 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (93 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (101 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (101 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (101 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (101 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 211
    (87 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (87 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (87 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (87 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (87 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (87 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (87 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (87 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (89 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (89 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (89 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (89 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (89 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (89 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (89 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (89 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 212
    (93 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (93 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (93 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (93 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (93 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (93 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (93 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (93 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (101 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (101 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (101 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (101 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (101 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (101 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (101 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (101 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 213
    (104 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (104 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (104 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (104 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (107 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (107 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (107 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (107 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (110 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (110 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (110 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (110 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (115 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (115 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (115 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (115 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 214
    (104 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (104 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (104 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (104 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (104 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (104 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (104 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (104 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (107 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (107 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (107 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (107 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (107 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (107 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (107 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (107 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 215
    (110 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (110 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (110 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (110 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (110 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (110 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (110 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (110 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (115 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (115 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (115 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (115 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (115 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (115 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (115 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (115 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 216
    (33 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (33 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (33 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (33 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (33 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (33 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (33 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (33 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (0 << 24) | (220 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (221 << 6) | (0 << 3) | 0, // nibble 09
    (61 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (61 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (21 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (21 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (176 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (176 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 217
    (142 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (154 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (215 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (222 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (61 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (61 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (61 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (61 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (21 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (21 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (21 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (21 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (176 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (176 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (176 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (176 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 218
    (142 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (142 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (154 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (154 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (215 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (215 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (222 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (222 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (61 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (61 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (61 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (61 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (61 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (61 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (61 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (61 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 219
    (142 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (142 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (142 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (142 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (154 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (154 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (154 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (154 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (215 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (215 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (215 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (215 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (222 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (222 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (222 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (222 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 220
    (142 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (142 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (142 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (142 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (142 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (142 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (142 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (142 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (154 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (154 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (154 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (154 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (154 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (154 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (154 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (154 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 221
    (215 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (215 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (215 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (215 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (215 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (215 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (215 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (215 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (222 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (222 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (222 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (222 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (222 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (222 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (222 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (222 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 222
    (21 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (21 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (21 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (21 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (21 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (21 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (21 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (21 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (176 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (176 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (176 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (176 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (176 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (176 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (176 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (176 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 223
    (0 << 24) | (227 << 6) | (0 << 3) | 0, // nibble 00
    (251 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (0 << 24) | (240 << 6) | (0 << 3) | 0, // nibble 02
    (5 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (252 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (4 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (0 << 24) | (264 << 6) | (0 << 3) | 0, // nibble 06
    (253 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (0 << 24) | (297 << 6) | (0 << 3) | 0, // nibble 08
    (3 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (0 << 24) | (397 << 6) | (0 << 3) | 0, // nibble 0a
    (254 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (2 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (0 << 24) | (400 << 6) | (0 << 3) | 0, // nibble 0d
    (0 << 24) | (472 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (473 << 6) | (0 << 3) | 0, // nibble 0f
    // State 224
    (13 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (0 << 24) | (228 << 6) | (0 << 3) | 0, // nibble 01
    (251 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (251 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (0 << 24) | (241 << 6) | (0 << 3) | 0, // nibble 04
    (244 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (5 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (5 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (252 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (252 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (4 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (4 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (12 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (0 << 24) | (265 << 6) | (0 << 3) | 0, // nibble 0d
    (253 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (253 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 225
    (13 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (13 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (238 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (0 << 24) | (229 << 6) | (0 << 3) | 0, // nibble 03
    (251 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (251 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (251 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (251 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (18 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (0 << 24) | (242 << 6) | (0 << 3) | 0, // nibble 09
    (244 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (244 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (5 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (5 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (5 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (5 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 226
    (13 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (13 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (13 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (13 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (238 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (238 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (23 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (0 << 24) | (230 << 6) | (0 << 3) | 0, // nibble 07
    (251 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (251 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (251 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (251 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (251 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (251 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (251 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (251 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 227
    (13 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (13 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (13 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (13 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (13 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (13 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (13 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (13 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (238 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (238 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (238 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (238 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (23 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (23 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (0 << 24) | (231 << 6) | (0 << 3) | 0, // nibble 0e
    (229 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 228
    (238 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (238 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (238 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (238 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (238 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (238 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (238 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (238 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (23 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (23 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (23 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (23 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (0 << 24) | (232 << 6) | (0 << 3) | 0, // nibble 0c
    (0 << 24) | (236 << 6) | (0 << 3) | 0, // nibble 0d
    (229 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (229 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 229
    (23 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (23 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (23 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (23 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (23 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (23 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (23 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (23 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (0 << 24) | (233 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (234 << 6) | (0 << 3) | 0, // nibble 09
    (0 << 24) | (237 << 6) | (0 << 3) | 0, // nibble 0a
    (41 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (229 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (229 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (229 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (229 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 230
    (60 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (70 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (74 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (0 << 24) | (235 << 6) | (0 << 3) | 0, // nibble 03
    (0 << 24) | (238 << 6) | (0 << 3) | 0, // nibble 04
    (175 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (41 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (41 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (229 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (229 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (229 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (229 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (229 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (229 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (229 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (229 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 231
    (60 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (60 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (70 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (70 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (74 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (74 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (129 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (144 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (93 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (106 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (175 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (175 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (41 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (41 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (41 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (41 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 232
    (60 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (60 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (60 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (60 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (70 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (70 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (70 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (70 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (74 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (74 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (74 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (74 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (129 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (129 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (144 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (144 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 233
    (60 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (60 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (60 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (60 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (60 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (60 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (60 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (60 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (70 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (70 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (70 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (70 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (70 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (70 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (70 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (70 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 234
    (74 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (74 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (74 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (74 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (74 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (74 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (74 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (74 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (129 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (129 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (129 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (129 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (144 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (144 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (144 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (144 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 235
    (129 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (129 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (129 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (129 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (129 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (129 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (129 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (129 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (144 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (144 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (144 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (144 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (144 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (144 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (144 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (144 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 236
    (93 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (93 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (106 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (106 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (175 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (175 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (175 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (175 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (41 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (41 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (41 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (41 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (41 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (41 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (41 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (41 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 237
    (93 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (93 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (93 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (93 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (106 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (106 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (106 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (106 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (175 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (175 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (175 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (175 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (175 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (175 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (175 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (175 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 238
    (93 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (93 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (93 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (93 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (93 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (93 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (93 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (93 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (106 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (106 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (106 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (106 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (106 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (106 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (106 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (106 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 239
    (18 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (18 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (0 << 24) | (243 << 6) | (0 << 3) | 0, // nibble 02
    (234 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (244 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (244 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (244 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (244 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (5 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (5 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (5 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (5 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (5 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (5 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (5 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (5 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 240
    (18 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (18 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (18 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (18 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (0 << 24) | (244 << 6) | (0 << 3) | 0, // nibble 04
    (28 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (234 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (234 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (244 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (244 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (244 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (244 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (244 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (244 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (244 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (244 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 241
    (18 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (18 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (18 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (18 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (18 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (18 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (18 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (18 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (0 << 24) | (245 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (248 << 6) | (0 << 3) | 0, // nibble 09
    (28 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (28 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (234 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (234 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (234 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (234 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 242
    (0 << 24) | (246 << 6) | (0 << 3) | 0, // nibble 00
    (13 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (0 << 24) | (249 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (254 << 6) | (0 << 3) | 0, // nibble 03
    (28 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (28 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (28 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (28 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (234 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (234 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (234 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (234 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (234 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (234 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (234 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (234 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 243
    (0 << 24) | (247 << 6) | (0 << 3) | 0, // nibble 00
    (154 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (13 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (13 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (0 << 24) | (250 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (251 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (255 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (258 << 6) | (0 << 3) | 0, // nibble 07
    (28 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (28 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (28 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (28 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (28 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (28 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (28 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (28 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 244
    (169 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (99 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (154 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (154 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (13 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (13 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (13 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (13 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (101 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (253 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (0 << 24) | (252 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (253 << 6) | (0 << 3) | 0, // nibble 0b
    (0 << 24) | (256 << 6) | (0 << 3) | 0, // nibble 0c
    (0 << 24) | (257 << 6) | (0 << 3) | 0, // nibble 0d
    (0 << 24) | (259 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (260 << 6) | (0 << 3) | 0, // nibble 0f
    // State 245
    (169 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (169 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (99 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (99 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (154 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (154 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (154 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (154 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (13 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (13 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (13 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (13 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (13 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (13 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (13 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (13 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 246
    (169 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (169 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (169 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (169 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (99 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (99 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (99 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (99 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (154 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (154 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (154 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (154 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (154 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (154 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (154 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (154 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 247
    (169 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (169 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (169 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (169 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (169 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (169 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (169 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (169 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (99 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (99 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (99 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (99 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (99 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (99 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (99 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (99 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 248
    (101 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (101 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (253 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (253 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (34 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (36 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (57 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (66 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (71 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (75 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (114 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (118 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (128 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (116 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (134 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (139 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 249
    (101 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (101 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (101 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (101 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (253 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (253 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (253 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (253 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (34 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (34 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (36 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (36 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (57 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (57 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (66 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (66 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 250
    (101 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (101 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (101 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (101 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (101 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (101 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (101 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (101 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (253 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (253 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (253 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (253 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (253 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (253 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (253 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (253 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 251
    (34 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (34 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (34 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (34 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (36 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (36 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (36 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (36 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (57 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (57 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (57 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (57 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (66 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (66 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (66 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (66 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 252
    (34 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (34 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (34 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (34 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (34 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (34 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (34 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (34 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (36 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (36 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (36 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (36 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (36 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (36 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (36 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (36 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 253
    (57 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (57 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (57 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (57 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (57 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (57 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (57 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (57 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (66 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (66 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (66 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (66 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (66 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (66 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (66 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (66 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 254
    (71 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (71 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (75 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (75 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (114 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (114 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (118 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (118 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (128 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (128 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (116 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (116 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (134 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (134 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (139 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (139 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 255
    (71 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (71 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (71 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (71 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (75 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (75 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (75 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (75 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (114 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (114 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (114 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (114 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (118 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (118 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (118 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (118 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 256
    (71 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (71 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (71 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (71 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (71 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (71 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (71 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (71 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (75 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (75 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (75 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (75 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (75 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (75 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (75 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (75 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 257
    (114 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (114 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (114 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (114 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (114 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (114 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (114 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (114 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (118 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (118 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (118 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (118 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (118 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (118 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (118 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (118 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 258
    (128 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (128 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (128 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (128 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (116 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (116 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (116 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (116 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (134 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (134 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (134 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (134 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (139 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (139 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (139 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (139 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 259
    (128 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (128 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (128 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (128 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (128 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (128 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (128 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (128 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (116 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (116 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (116 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (116 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (116 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (116 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (116 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (116 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 260
    (134 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (134 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (134 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (134 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (134 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (134 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (134 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (134 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (139 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (139 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (139 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (139 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (139 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (139 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (139 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (139 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 261
    (252 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (252 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (252 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (252 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (4 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (4 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (4 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (4 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (12 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (12 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (0 << 24) | (266 << 6) | (0 << 3) | 0, // nibble 0a
    (239 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (253 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (253 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (253 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (253 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 262
    (252 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (252 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (252 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (252 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (252 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (252 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (252 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (252 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (4 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (4 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (4 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (4 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (4 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (4 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (4 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (4 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 263
    (12 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (12 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (12 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (12 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (0 << 24) | (267 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (293 << 6) | (0 << 3) | 0, // nibble 05
    (239 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (239 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (253 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (253 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (253 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (253 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (253 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (253 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (253 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (253 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 264
    (12 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (12 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (12 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (12 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (12 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (12 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (12 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (12 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (0 << 24) | (268 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (283 << 6) | (0 << 3) | 0, // nibble 09
    (27 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (230 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (239 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (239 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (239 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (239 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 265
    (0 << 24) | (269 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (280 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (284 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (287 << 6) | (0 << 3) | 0, // nibble 03
    (27 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (27 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (230 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (230 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (239 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (239 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (239 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (239 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (239 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (239 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (239 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (239 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 266
    (0 << 24) | (270 << 6) | (0 << 3) | 0, // nibble 00
    (213 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (0 << 24) | (281 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (282 << 6) | (0 << 3) | 0, // nibble 03
    (0 << 24) | (285 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (286 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (288 << 6) | (0 << 3) | 0, // nibble 06
    (214 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (27 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (27 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (27 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (27 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (230 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (230 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (230 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (230 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 267
    (0 << 24) | (271 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (274 << 6) | (0 << 3) | 0, // nibble 01
    (213 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (213 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (22 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (189 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (58 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (236 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (174 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (194 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (72 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (75 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (235 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (0 << 24) | (289 << 6) | (0 << 3) | 0, // nibble 0d
    (214 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (214 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 268
    (0 << 24) | (272 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (273 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (275 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (277 << 6) | (0 << 3) | 0, // nibble 03
    (213 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (213 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (213 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (213 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (22 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (22 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (189 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (189 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (58 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (58 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (236 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (236 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 269
    (186 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (193 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (204 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (209 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (225 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (0 << 24) | (276 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (278 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (279 << 6) | (0 << 3) | 0, // nibble 07
    (213 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (213 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (213 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (213 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (213 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (213 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (213 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (213 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 270
    (186 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (186 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (193 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (193 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (204 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (204 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (209 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (209 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (225 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (225 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (44 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (53 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (56 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (64 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (109 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (181 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 271
    (186 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (186 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (186 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (186 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (193 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (193 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (193 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (193 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (204 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (204 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (204 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (204 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (209 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (209 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (209 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (209 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 272
    (186 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (186 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (186 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (186 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (186 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (186 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (186 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (186 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (193 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (193 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (193 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (193 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (193 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (193 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (193 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (193 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 273
    (204 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (204 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (204 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (204 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (204 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (204 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (204 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (204 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (209 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (209 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (209 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (209 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (209 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (209 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (209 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (209 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 274
    (225 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (225 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (225 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (225 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (44 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (44 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (53 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (53 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (56 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (56 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (64 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (64 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (109 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (109 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (181 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (181 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 275
    (225 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (225 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (225 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (225 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (225 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (225 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (225 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (225 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (44 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (44 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (44 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (44 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (53 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (53 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (53 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (53 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 276
    (44 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (44 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (44 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (44 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (44 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (44 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (44 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (44 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (53 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (53 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (53 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (53 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (53 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (53 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (53 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (53 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 277
    (56 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (56 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (56 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (56 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (64 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (64 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (64 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (64 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (109 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (109 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (109 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (109 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (181 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (181 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (181 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (181 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 278
    (56 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (56 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (56 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (56 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (56 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (56 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (56 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (56 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (64 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (64 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (64 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (64 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (64 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (64 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (64 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (64 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 279
    (109 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (109 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (109 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (109 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (109 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (109 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (109 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (109 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (181 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (181 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (181 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (181 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (181 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (181 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (181 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (181 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 280
    (22 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (22 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (22 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (22 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (189 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (189 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (189 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (189 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (58 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (58 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (58 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (58 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (236 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (236 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (236 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (236 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 281
    (22 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (22 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (22 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (22 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (22 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (22 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (22 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (22 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (189 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (189 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (189 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (189 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (189 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (189 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (189 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (189 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 282
    (58 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (58 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (58 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (58 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (58 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (58 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (58 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (58 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (236 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (236 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (236 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (236 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (236 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (236 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (236 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (236 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 283
    (174 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (174 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (194 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (194 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (72 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (72 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (75 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (75 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (235 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (235 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (170 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (0 << 24) | (290 << 6) | (0 << 3) | 0, // nibble 0b
    (214 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (214 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (214 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (214 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 284
    (174 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (174 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (174 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (174 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (194 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (194 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (194 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (194 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (72 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (72 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (72 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (72 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (75 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (75 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (75 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (75 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 285
    (174 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (174 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (174 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (174 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (174 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (174 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (174 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (174 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (194 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (194 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (194 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (194 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (194 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (194 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (194 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (194 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 286
    (72 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (72 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (72 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (72 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (72 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (72 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (72 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (72 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (75 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (75 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (75 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (75 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (75 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (75 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (75 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (75 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 287
    (235 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (235 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (235 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (235 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (170 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (170 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (0 << 24) | (291 << 6) | (0 << 3) | 0, // nibble 06
    (72 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (214 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (214 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (214 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (214 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (214 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (214 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (214 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (214 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 288
    (235 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (235 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (235 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (235 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (235 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (235 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (235 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (235 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (170 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (170 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (170 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (170 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (200 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (0 << 24) | (292 << 6) | (0 << 3) | 0, // nibble 0d
    (72 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (72 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 289
    (170 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (170 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (170 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (170 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (170 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (170 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (170 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (170 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (200 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (200 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (196 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (106 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (72 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (72 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (72 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (72 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 290
    (200 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (200 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (200 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (200 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (196 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (196 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (106 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (106 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (72 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (72 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (72 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (72 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (72 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (72 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (72 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (72 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 291
    (200 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (200 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (200 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (200 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (200 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (200 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (200 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (200 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (196 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (196 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (196 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (196 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (106 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (106 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (106 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (106 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 292
    (196 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (196 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (196 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (196 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (196 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (196 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (196 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (196 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (106 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (106 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (106 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (106 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (106 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (106 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (106 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (106 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 293
    (27 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (27 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (27 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (27 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (27 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (27 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (27 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (27 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (230 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (230 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (230 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (230 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (230 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (230 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (230 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (230 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 294
    (0 << 24) | (298 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (345 << 6) | (0 << 3) | 0, // nibble 01
    (3 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (3 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (245 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (11 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (254 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (254 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (2 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (2 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (0 << 24) | (401 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (413 << 6) | (0 << 3) | 0, // nibble 0b
    (246 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (10 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (0 << 24) | (474 << 6) | (0 << 3) | 0, // nibble 0e
    (247 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 295
    (0 << 24) | (299 << 6) | (0 << 3) | 0, // nibble 00
    (17 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (0 << 24) | (346 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (347 << 6) | (0 << 3) | 0, // nibble 03
    (3 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (3 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (3 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (3 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (245 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (245 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (11 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (11 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (254 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (254 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (254 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (254 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 296
    (0 << 24) | (300 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (325 << 6) | (0 << 3) | 0, // nibble 01
    (17 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (17 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (22 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (235 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (0 << 24) | (348 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (384 << 6) | (0 << 3) | 0, // nibble 07
    (3 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (3 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (3 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (3 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (3 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (3 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (3 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (3 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 297
    (0 << 24) | (301 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (307 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (326 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (339 << 6) | (0 << 3) | 0, // nibble 03
    (17 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (17 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (17 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (17 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (22 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (22 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (235 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (235 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (0 << 24) | (349 << 6) | (0 << 3) | 0, // nibble 0c
    (26 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (0 << 24) | (385 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (390 << 6) | (0 << 3) | 0, // nibble 0f
    // State 298
    (0 << 24) | (302 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (304 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (308 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (312 << 6) | (0 << 3) | 0, // nibble 03
    (0 << 24) | (327 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (334 << 6) | (0 << 3) | 0, // nibble 05
    (225 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (0 << 24) | (340 << 6) | (0 << 3) | 0, // nibble 07
    (17 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (17 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (17 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (17 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (17 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (17 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (17 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (17 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 299
    (0 << 24) | (303 << 6) | (0 << 3) | 0, // nibble 00
    (39 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (0 << 24) | (305 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (306 << 6) | (0 << 3) | 0, // nibble 03
    (0 << 24) | (309 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (310 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (313 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (318 << 6) | (0 << 3) | 0, // nibble 07
    (0 << 24) | (328 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (332 << 6) | (0 << 3) | 0, // nibble 09
    (0 << 24) | (335 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (338 << 6) | (0 << 3) | 0, // nibble 0b
    (225 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (225 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (0 << 24) | (341 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (342 << 6) | (0 << 3) | 0, // nibble 0f
    // State 300
    (165 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (178 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (39 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (39 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (181 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (185 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (188 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (54 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (55 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (67 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (237 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (0 << 24) | (311 << 6) | (0 << 3) | 0, // nibble 0b
    (0 << 24) | (314 << 6) | (0 << 3) | 0, // nibble 0c
    (0 << 24) | (315 << 6) | (0 << 3) | 0, // nibble 0d
    (0 << 24) | (319 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (322 << 6) | (0 << 3) | 0, // nibble 0f
    // State 301
    (165 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (165 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (178 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (178 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (39 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (39 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (39 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (39 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (181 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (181 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (185 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (185 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (188 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (188 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (54 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (54 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 302
    (165 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (165 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (165 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (165 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (178 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (178 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (178 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (178 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (39 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (39 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (39 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (39 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (39 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (39 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (39 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (39 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 303
    (165 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (165 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (165 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (165 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (165 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (165 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (165 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (165 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (178 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (178 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (178 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (178 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (178 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (178 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (178 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (178 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 304
    (181 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (181 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (181 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (181 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (185 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (185 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (185 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (185 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (188 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (188 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (188 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (188 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (54 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (54 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (54 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (54 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 305
    (181 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (181 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (181 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (181 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (181 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (181 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (181 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (181 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (185 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (185 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (185 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (185 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (185 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (185 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (185 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (185 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 306
    (188 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (188 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (188 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (188 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (188 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (188 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (188 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (188 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (54 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (54 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (54 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (54 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (54 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (54 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (54 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (54 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 307
    (55 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (55 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (67 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (67 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (237 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (237 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (134 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (146 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (228 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (254 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (0 << 24) | (316 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (317 << 6) | (0 << 3) | 0, // nibble 0b
    (0 << 24) | (320 << 6) | (0 << 3) | 0, // nibble 0c
    (0 << 24) | (321 << 6) | (0 << 3) | 0, // nibble 0d
    (0 << 24) | (323 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (324 << 6) | (0 << 3) | 0, // nibble 0f
    // State 308
    (55 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (55 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (55 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (55 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (67 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (67 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (67 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (67 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (237 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (237 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (237 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (237 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (134 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (134 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (146 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (146 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 309
    (55 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (55 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (55 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (55 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (55 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (55 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (55 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (55 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (67 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (67 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (67 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (67 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (67 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (67 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (67 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (67 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 310
    (237 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (237 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (237 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (237 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (237 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (237 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (237 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (237 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (134 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (134 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (134 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (134 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (146 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (146 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (146 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (146 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 311
    (134 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (134 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (134 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (134 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (134 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (134 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (134 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (134 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (146 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (146 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (146 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (146 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (146 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (146 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (146 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (146 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 312
    (228 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (228 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (254 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (254 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (80 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (88 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (95 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (98 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (110 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (116 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (121 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (125 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (133 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (118 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (132 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (152 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 313
    (228 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (228 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (228 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (228 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (254 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (254 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (254 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (254 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (80 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (80 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (88 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (88 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (95 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (95 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (98 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (98 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 314
    (228 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (228 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (228 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (228 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (228 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (228 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (228 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (228 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (254 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (254 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (254 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (254 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (254 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (254 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (254 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (254 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 315
    (80 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (80 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (80 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (80 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (88 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (88 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (88 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (88 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (95 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (95 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (95 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (95 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (98 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (98 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (98 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (98 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 316
    (80 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (80 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (80 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (80 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (80 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (80 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (80 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (80 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (88 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (88 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (88 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (88 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (88 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (88 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (88 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (88 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 317
    (95 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (95 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (95 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (95 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (95 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (95 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (95 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (95 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (98 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (98 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (98 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (98 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (98 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (98 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (98 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (98 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 318
    (110 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (110 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (116 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (116 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (121 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (121 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (125 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (125 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (133 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (133 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (118 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (118 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (132 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (132 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (152 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (152 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 319
    (110 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (110 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (110 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (110 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (116 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (116 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (116 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (116 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (121 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (121 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (121 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (121 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (125 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (125 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (125 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (125 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 320
    (110 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (110 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (110 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (110 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (110 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (110 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (110 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (110 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (116 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (116 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (116 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (116 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (116 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (116 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (116 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (116 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 321
    (121 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (121 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (121 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (121 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (121 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (121 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (121 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (121 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (125 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (125 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (125 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (125 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (125 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (125 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (125 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (125 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 322
    (133 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (133 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (133 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (133 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (118 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (118 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (118 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (118 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (132 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (132 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (132 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (132 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (152 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (152 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (152 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (152 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 323
    (133 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (133 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (133 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (133 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (133 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (133 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (133 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (133 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (118 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (118 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (118 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (118 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (118 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (118 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (118 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (118 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 324
    (132 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (132 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (132 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (132 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (132 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (132 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (132 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (132 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (152 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (152 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (152 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (152 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (152 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (152 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (152 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (152 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 325
    (0 << 24) | (329 << 6) | (0 << 3) | 0, // nibble 00
    (7 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (20 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (0 << 24) | (333 << 6) | (0 << 3) | 0, // nibble 03
    (0 << 24) | (336 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (337 << 6) | (0 << 3) | 0, // nibble 05
    (191 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (59 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (225 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (225 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (225 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (225 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (241 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (250 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (0 << 24) | (343 << 6) | (0 << 3) | 0, // nibble 0e
    (57 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 326
    (0 << 24) | (330 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (331 << 6) | (0 << 3) | 0, // nibble 01
    (7 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (7 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (20 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (20 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (27 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (147 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (155 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (86 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (88 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (96 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (191 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (191 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (59 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (59 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 327
    (158 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (197 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (198 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (210 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (7 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (7 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (7 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (7 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (20 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (20 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (20 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (20 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (27 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (27 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (147 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (147 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 328
    (158 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (158 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (197 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (197 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (198 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (198 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (210 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (210 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (7 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (7 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (7 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (7 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (7 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (7 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (7 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (7 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 329
    (158 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (158 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (158 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (158 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (197 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (197 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (197 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (197 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (198 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (198 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (198 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (198 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (210 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (210 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (210 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (210 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 330
    (158 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (158 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (158 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (158 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (158 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (158 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (158 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (158 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (197 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (197 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (197 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (197 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (197 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (197 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (197 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (197 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 331
    (198 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (198 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (198 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (198 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (198 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (198 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (198 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (198 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (210 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (210 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (210 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (210 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (210 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (210 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (210 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (210 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 332
    (20 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (20 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (20 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (20 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (20 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (20 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (20 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (20 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (27 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (27 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (27 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (27 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (147 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (147 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (147 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (147 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 333
    (27 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (27 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (27 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (27 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (27 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (27 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (27 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (27 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (147 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (147 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (147 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (147 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (147 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (147 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (147 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (147 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 334
    (155 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (155 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (86 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (86 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (88 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (88 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (96 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (96 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (191 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (191 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (191 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (191 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (59 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (59 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (59 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (59 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 335
    (155 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (155 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (155 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (155 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (86 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (86 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (86 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (86 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (88 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (88 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (88 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (88 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (96 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (96 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (96 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (96 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 336
    (155 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (155 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (155 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (155 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (155 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (155 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (155 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (155 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (86 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (86 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (86 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (86 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (86 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (86 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (86 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (86 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 337
    (88 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (88 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (88 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (88 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (88 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (88 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (88 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (88 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (96 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (96 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (96 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (96 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (96 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (96 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (96 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (96 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 338
    (191 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (191 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (191 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (191 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (191 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (191 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (191 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (191 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (59 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (59 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (59 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (59 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (59 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (59 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (59 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (59 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 339
    (225 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (225 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (225 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (225 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (225 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (225 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (225 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (225 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (241 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (241 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (250 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (250 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (0 << 24) | (344 << 6) | (0 << 3) | 0, // nibble 0c
    (143 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (57 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (57 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 340
    (241 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (241 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (241 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (241 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (250 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (250 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (250 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (250 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (219 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (33 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (143 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (143 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (57 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (57 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (57 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (57 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 341
    (241 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (241 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (241 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (241 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (241 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (241 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (241 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (241 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (250 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (250 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (250 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (250 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (250 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (250 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (250 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (250 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 342
    (219 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (219 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (33 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (33 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (143 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (143 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (143 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (143 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (57 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (57 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (57 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (57 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (57 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (57 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (57 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (57 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 343
    (219 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (219 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (219 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (219 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (33 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (33 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (33 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (33 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (143 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (143 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (143 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (143 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (143 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (143 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (143 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (143 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 344
    (219 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (219 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (219 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (219 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (219 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (219 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (219 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (219 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (33 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (33 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (33 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (33 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (33 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (33 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (33 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (33 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 345
    (22 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (22 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (22 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (22 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (235 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (235 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (235 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (235 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (0 << 24) | (350 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (363 << 6) | (0 << 3) | 0, // nibble 09
    (26 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (26 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (0 << 24) | (386 << 6) | (0 << 3) | 0, // nibble 0c
    (0 << 24) | (387 << 6) | (0 << 3) | 0, // nibble 0d
    (0 << 24) | (391 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (394 << 6) | (0 << 3) | 0, // nibble 0f
    // State 346
    (22 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (22 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (22 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (22 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (22 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (22 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (22 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (22 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (235 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (235 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (235 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (235 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (235 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (235 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (235 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (235 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 347
    (0 << 24) | (351 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (356 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (364 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (374 << 6) | (0 << 3) | 0, // nibble 03
    (26 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (26 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (26 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (26 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (215 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (220 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (0 << 24) | (388 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (389 << 6) | (0 << 3) | 0, // nibble 0b
    (0 << 24) | (392 << 6) | (0 << 3) | 0, // nibble 0c
    (0 << 24) | (393 << 6) | (0 << 3) | 0, // nibble 0d
    (37 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (0 << 24) | (395 << 6) | (0 << 3) | 0, // nibble 0f
    // State 348
    (0 << 24) | (352 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (353 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (357 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (360 << 6) | (0 << 3) | 0, // nibble 03
    (0 << 24) | (365 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (368 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (375 << 6) | (0 << 3) | 0, // nibble 06
    (19 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (26 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (26 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (26 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (26 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (26 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (26 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (26 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (26 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 349
    (148 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (151 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (0 << 24) | (354 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (355 << 6) | (0 << 3) | 0, // nibble 03
    (0 << 24) | (358 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (359 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (361 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (362 << 6) | (0 << 3) | 0, // nibble 07
    (0 << 24) | (366 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (367 << 6) | (0 << 3) | 0, // nibble 09
    (0 << 24) | (369 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (371 << 6) | (0 << 3) | 0, // nibble 0b
    (0 << 24) | (376 << 6) | (0 << 3) | 0, // nibble 0c
    (0 << 24) | (379 << 6) | (0 << 3) | 0, // nibble 0d
    (19 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (19 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 350
    (148 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (148 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (151 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (151 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (35 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (73 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (124 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (100 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (125 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (126 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (130 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (131 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (137 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (159 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (162 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (172 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 351
    (148 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (148 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (148 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (148 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (151 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (151 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (151 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (151 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (35 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (35 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (73 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (73 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (124 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (124 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (100 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (100 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 352
    (148 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (148 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (148 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (148 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (148 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (148 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (148 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (148 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (151 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (151 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (151 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (151 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (151 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (151 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (151 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (151 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 353
    (35 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (35 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (35 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (35 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (73 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (73 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (73 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (73 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (124 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (124 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (124 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (124 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (100 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (100 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (100 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (100 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 354
    (35 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (35 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (35 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (35 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (35 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (35 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (35 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (35 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (73 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (73 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (73 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (73 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (73 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (73 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (73 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (73 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 355
    (124 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (124 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (124 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (124 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (124 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (124 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (124 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (124 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (100 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (100 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (100 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (100 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (100 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (100 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (100 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (100 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 356
    (125 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (125 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (126 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (126 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (130 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (130 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (131 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (131 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (137 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (137 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (159 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (159 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (162 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (162 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (172 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (172 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 357
    (125 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (125 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (125 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (125 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (126 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (126 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (126 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (126 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (130 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (130 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (130 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (130 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (131 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (131 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (131 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (131 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 358
    (125 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (125 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (125 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (125 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (125 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (125 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (125 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (125 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (126 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (126 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (126 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (126 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (126 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (126 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (126 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (126 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 359
    (130 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (130 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (130 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (130 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (130 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (130 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (130 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (130 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (131 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (131 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (131 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (131 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (131 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (131 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (131 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (131 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 360
    (137 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (137 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (137 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (137 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (159 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (159 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (159 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (159 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (162 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (162 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (162 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (162 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (172 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (172 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (172 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (172 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 361
    (137 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (137 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (137 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (137 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (137 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (137 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (137 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (137 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (159 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (159 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (159 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (159 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (159 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (159 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (159 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (159 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 362
    (162 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (162 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (162 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (162 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (162 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (162 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (162 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (162 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (172 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (172 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (172 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (172 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (172 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (172 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (172 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (172 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 363
    (182 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (189 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (212 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (214 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (218 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (0 << 24) | (370 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (372 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (373 << 6) | (0 << 3) | 0, // nibble 07
    (0 << 24) | (377 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (378 << 6) | (0 << 3) | 0, // nibble 09
    (0 << 24) | (380 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (381 << 6) | (0 << 3) | 0, // nibble 0b
    (19 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (19 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (19 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (19 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 364
    (182 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (182 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (189 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (189 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (212 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (212 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (214 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (214 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (218 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (218 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (42 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (50 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (51 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (52 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (55 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (90 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 365
    (182 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (182 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (182 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (182 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (189 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (189 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (189 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (189 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (212 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (212 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (212 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (212 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (214 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (214 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (214 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (214 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 366
    (182 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (182 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (182 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (182 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (182 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (182 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (182 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (182 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (189 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (189 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (189 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (189 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (189 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (189 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (189 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (189 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 367
    (212 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (212 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (212 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (212 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (212 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (212 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (212 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (212 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (214 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (214 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (214 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (214 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (214 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (214 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (214 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (214 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 368
    (218 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (218 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (218 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (218 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (42 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (42 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (50 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (50 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (51 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (51 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (52 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (52 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (55 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (55 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (90 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (90 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 369
    (218 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (218 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (218 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (218 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (218 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (218 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (218 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (218 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (42 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (42 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (42 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (42 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (50 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (50 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (50 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (50 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 370
    (42 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (42 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (42 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (42 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (42 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (42 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (42 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (42 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (50 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (50 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (50 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (50 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (50 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (50 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (50 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (50 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 371
    (51 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (51 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (51 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (51 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (52 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (52 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (52 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (52 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (55 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (55 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (55 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (55 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (90 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (90 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (90 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (90 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 372
    (51 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (51 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (51 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (51 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (51 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (51 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (51 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (51 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (52 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (52 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (52 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (52 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (52 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (52 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (52 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (52 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 373
    (55 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (55 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (55 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (55 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (55 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (55 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (55 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (55 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (90 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (90 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (90 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (90 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (90 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (90 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (90 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (90 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 374
    (100 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (113 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (143 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (180 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (187 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (199 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (0 << 24) | (382 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (383 << 6) | (0 << 3) | 0, // nibble 07
    (19 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (19 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (19 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (19 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (19 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (19 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (19 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (19 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 375
    (100 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (100 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (113 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (113 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (143 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (143 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (180 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (180 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (187 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (187 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (199 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (199 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (108 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (111 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (140 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (145 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 376
    (100 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (100 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (100 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (100 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (113 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (113 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (113 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (113 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (143 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (143 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (143 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (143 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (180 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (180 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (180 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (180 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 377
    (100 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (100 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (100 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (100 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (100 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (100 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (100 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (100 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (113 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (113 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (113 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (113 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (113 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (113 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (113 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (113 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 378
    (143 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (143 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (143 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (143 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (143 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (143 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (143 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (143 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (180 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (180 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (180 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (180 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (180 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (180 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (180 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (180 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 379
    (187 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (187 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (187 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (187 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (199 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (199 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (199 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (199 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (108 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (108 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (111 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (111 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (140 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (140 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (145 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (145 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 380
    (187 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (187 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (187 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (187 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (187 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (187 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (187 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (187 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (199 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (199 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (199 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (199 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (199 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (199 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (199 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (199 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 381
    (108 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (108 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (108 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (108 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (111 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (111 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (111 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (111 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (140 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (140 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (140 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (140 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (145 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (145 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (145 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (145 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 382
    (108 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (108 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (108 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (108 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (108 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (108 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (108 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (108 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (111 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (111 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (111 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (111 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (111 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (111 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (111 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (111 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 383
    (140 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (140 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (140 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (140 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (140 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (140 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (140 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (140 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (145 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (145 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (145 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (145 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (145 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (145 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (145 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (145 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 384
    (215 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (215 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (220 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (220 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (182 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (63 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (238 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (18 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (180 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (195 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (196 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (198 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (37 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (37 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (199 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (68 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 385
    (215 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (215 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (215 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (215 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (220 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (220 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (220 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (220 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (182 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (182 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (63 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (63 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (238 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (238 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (18 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (18 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 386
    (215 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (215 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (215 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (215 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (215 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (215 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (215 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (215 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (220 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (220 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (220 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (220 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (220 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (220 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (220 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (220 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 387
    (182 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (182 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (182 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (182 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (63 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (63 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (63 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (63 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (238 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (238 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (238 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (238 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (18 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (18 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (18 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (18 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 388
    (182 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (182 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (182 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (182 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (182 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (182 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (182 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (182 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (63 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (63 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (63 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (63 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (63 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (63 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (63 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (63 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 389
    (238 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (238 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (238 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (238 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (238 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (238 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (238 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (238 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (18 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (18 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (18 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (18 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (18 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (18 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (18 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (18 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 390
    (180 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (180 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (195 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (195 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (196 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (196 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (198 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (198 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (37 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (37 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (37 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (37 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (199 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (199 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (68 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (68 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 391
    (180 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (180 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (180 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (180 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (195 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (195 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (195 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (195 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (196 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (196 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (196 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (196 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (198 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (198 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (198 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (198 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 392
    (180 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (180 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (180 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (180 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (180 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (180 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (180 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (180 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (195 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (195 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (195 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (195 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (195 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (195 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (195 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (195 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 393
    (196 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (196 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (196 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (196 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (196 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (196 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (196 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (196 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (198 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (198 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (198 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (198 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (198 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (198 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (198 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (198 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 394
    (37 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (37 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (37 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (37 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (37 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (37 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (37 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (37 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (199 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (199 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (199 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (199 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (68 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (68 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (68 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (68 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 395
    (199 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (199 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (199 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (199 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (199 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (199 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (199 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (199 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (68 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (68 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (68 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (68 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (68 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (68 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (68 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (68 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 396
    (245 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (245 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (245 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (245 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (11 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (11 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (11 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (11 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (254 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (254 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (254 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (254 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (254 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (254 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (254 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (254 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 397
    (245 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (245 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (245 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (245 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (245 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (245 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (245 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (245 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (11 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (11 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (11 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (11 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (11 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (11 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (11 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (11 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 398
    (2 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (2 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (2 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (2 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (240 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (0 << 24) | (402 << 6) | (0 << 3) | 0, // nibble 05
    (16 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (0 << 24) | (414 << 6) | (0 << 3) | 0, // nibble 07
    (246 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (246 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (10 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (10 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (0 << 24) | (475 << 6) | (0 << 3) | 0, // nibble 0c
    (241 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (247 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (247 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 399
    (2 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (2 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (2 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (2 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (2 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (2 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (2 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (2 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (240 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (240 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (0 << 24) | (403 << 6) | (0 << 3) | 0, // nibble 0a
    (21 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (16 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (16 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (0 << 24) | (415 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (442 << 6) | (0 << 3) | 0, // nibble 0f
    // State 400
    (240 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (240 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (240 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (240 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (0 << 24) | (404 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (408 << 6) | (0 << 3) | 0, // nibble 05
    (21 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (21 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (16 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (16 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (16 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (16 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (0 << 24) | (416 << 6) | (0 << 3) | 0, // nibble 0c
    (0 << 24) | (430 << 6) | (0 << 3) | 0, // nibble 0d
    (0 << 24) | (443 << 6) | (0 << 3) | 0, // nibble 0e
    (231 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 401
    (240 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (240 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (240 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (240 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (240 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (240 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (240 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (240 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (32 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (0 << 24) | (405 << 6) | (0 << 3) | 0, // nibble 09
    (226 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (0 << 24) | (409 << 6) | (0 << 3) | 0, // nibble 0b
    (21 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (21 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (21 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (21 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 402
    (32 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (32 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (40 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (0 << 24) | (406 << 6) | (0 << 3) | 0, // nibble 03
    (226 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (226 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (38 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (0 << 24) | (410 << 6) | (0 << 3) | 0, // nibble 07
    (21 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (21 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (21 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (21 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (21 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (21 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (21 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (21 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 403
    (32 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (32 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (32 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (32 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (40 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (40 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (0 << 24) | (407 << 6) | (0 << 3) | 0, // nibble 06
    (49 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (226 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (226 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (226 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (226 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (38 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (38 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (50 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (0 << 24) | (411 << 6) | (0 << 3) | 0, // nibble 0f
    // State 404
    (32 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (32 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (32 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (32 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (32 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (32 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (32 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (32 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (40 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (40 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (40 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (40 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (149 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (81 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (49 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (49 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 405
    (40 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (40 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (40 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (40 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (40 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (40 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (40 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (40 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (149 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (149 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (81 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (81 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (49 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (49 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (49 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (49 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 406
    (149 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (149 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (149 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (149 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (81 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (81 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (81 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (81 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (49 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (49 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (49 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (49 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (49 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (49 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (49 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (49 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 407
    (149 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (149 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (149 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (149 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (149 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (149 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (149 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (149 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (81 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (81 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (81 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (81 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (81 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (81 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (81 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (81 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 408
    (226 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (226 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (226 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (226 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (226 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (226 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (226 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (226 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (38 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (38 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (38 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (38 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (50 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (50 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (90 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (0 << 24) | (412 << 6) | (0 << 3) | 0, // nibble 0f
    // State 409
    (38 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (38 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (38 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (38 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (38 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (38 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (38 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (38 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (50 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (50 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (50 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (50 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (90 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (90 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (99 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (123 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 410
    (50 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (50 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (50 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (50 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (50 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (50 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (50 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (50 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (90 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (90 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (90 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (90 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (99 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (99 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (123 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (123 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 411
    (90 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (90 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (90 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (90 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (90 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (90 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (90 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (90 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (99 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (99 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (99 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (99 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (123 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (123 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (123 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (123 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 412
    (99 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (99 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (99 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (99 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (99 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (99 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (99 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (99 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (123 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (123 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (123 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (123 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (123 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (123 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (123 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (123 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 413
    (16 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (16 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (16 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (16 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (16 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (16 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (16 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (16 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (0 << 24) | (417 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (426 << 6) | (0 << 3) | 0, // nibble 09
    (0 << 24) | (431 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (436 << 6) | (0 << 3) | 0, // nibble 0b
    (0 << 24) | (444 << 6) | (0 << 3) | 0, // nibble 0c
    (0 << 24) | (468 << 6) | (0 << 3) | 0, // nibble 0d
    (231 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (231 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 414
    (0 << 24) | (418 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (425 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (427 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (428 << 6) | (0 << 3) | 0, // nibble 03
    (0 << 24) | (432 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (433 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (437 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (438 << 6) | (0 << 3) | 0, // nibble 07
    (0 << 24) | (445 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (453 << 6) | (0 << 3) | 0, // nibble 09
    (0 << 24) | (469 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (470 << 6) | (0 << 3) | 0, // nibble 0b
    (231 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (231 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (231 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (231 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 415
    (0 << 24) | (419 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (422 << 6) | (0 << 3) | 0, // nibble 01
    (53 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (5 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (6 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (197 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (0 << 24) | (429 << 6) | (0 << 3) | 0, // nibble 06
    (179 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (184 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (52 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (0 << 24) | (434 << 6) | (0 << 3) | 0, // nibble 0a
    (183 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (200 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (45 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (51 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (0 << 24) | (439 << 6) | (0 << 3) | 0, // nibble 0f
    // State 416
    (0 << 24) | (420 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (421 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (423 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (424 << 6) | (0 << 3) | 0, // nibble 03
    (53 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (53 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (5 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (5 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (6 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (6 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (197 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (197 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (3 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (4 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (179 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (179 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 417
    (113 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (124 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (133 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (160 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (163 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (174 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (175 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (177 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (53 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (53 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (53 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (53 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (5 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (5 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (5 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (5 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 418
    (113 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (113 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (124 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (124 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (133 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (133 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (160 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (160 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (163 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (163 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (174 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (174 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (175 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (175 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (177 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (177 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 419
    (113 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (113 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (113 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (113 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (124 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (124 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (124 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (124 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (133 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (133 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (133 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (133 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (160 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (160 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (160 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (160 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 420
    (113 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (113 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (113 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (113 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (113 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (113 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (113 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (113 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (124 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (124 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (124 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (124 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (124 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (124 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (124 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (124 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 421
    (133 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (133 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (133 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (133 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (133 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (133 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (133 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (133 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (160 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (160 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (160 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (160 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (160 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (160 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (160 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (160 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 422
    (163 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (163 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (163 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (163 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (174 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (174 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (174 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (174 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (175 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (175 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (175 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (175 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (177 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (177 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (177 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (177 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 423
    (163 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (163 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (163 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (163 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (163 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (163 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (163 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (163 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (174 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (174 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (174 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (174 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (174 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (174 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (174 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (174 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 424
    (175 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (175 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (175 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (175 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (175 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (175 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (175 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (175 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (177 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (177 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (177 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (177 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (177 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (177 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (177 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (177 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 425
    (53 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (53 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (53 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (53 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (53 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (53 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (53 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (53 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (5 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (5 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (5 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (5 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (5 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (5 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (5 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (5 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 426
    (6 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (6 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (6 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (6 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (197 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (197 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (197 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (197 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (3 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (3 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (4 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (4 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (179 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (179 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (179 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (179 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 427
    (6 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (6 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (6 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (6 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (6 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (6 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (6 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (6 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (197 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (197 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (197 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (197 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (197 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (197 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (197 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (197 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 428
    (3 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (3 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (3 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (3 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (4 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (4 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (4 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (4 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (179 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (179 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (179 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (179 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (179 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (179 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (179 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (179 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 429
    (3 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (3 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (3 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (3 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (3 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (3 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (3 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (3 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (4 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (4 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (4 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (4 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (4 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (4 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (4 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (4 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 430
    (184 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (184 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (52 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (52 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (0 << 24) | (435 << 6) | (0 << 3) | 0, // nibble 04
    (91 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (183 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (183 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (200 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (200 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (45 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (45 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (51 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (51 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (0 << 24) | (440 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (441 << 6) | (0 << 3) | 0, // nibble 0f
    // State 431
    (184 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (184 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (184 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (184 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (52 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (52 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (52 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (52 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (178 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (131 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (91 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (91 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (183 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (183 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (183 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (183 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 432
    (184 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (184 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (184 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (184 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (184 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (184 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (184 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (184 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (52 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (52 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (52 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (52 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (52 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (52 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (52 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (52 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 433
    (178 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (178 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (131 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (131 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (91 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (91 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (91 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (91 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (183 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (183 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (183 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (183 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (183 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (183 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (183 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (183 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 434
    (178 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (178 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (178 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (178 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (131 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (131 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (131 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (131 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (91 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (91 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (91 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (91 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (91 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (91 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (91 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (91 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 435
    (178 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (178 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (178 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (178 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (178 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (178 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (178 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (178 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (131 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (131 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (131 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (131 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (131 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (131 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (131 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (131 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 436
    (200 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (200 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (200 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (200 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (45 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (45 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (45 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (45 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (51 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (51 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (51 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (51 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (142 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (105 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (111 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (121 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 437
    (200 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (200 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (200 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (200 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (200 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (200 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (200 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (200 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (45 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (45 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (45 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (45 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (45 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (45 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (45 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (45 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 438
    (51 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (51 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (51 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (51 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (51 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (51 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (51 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (51 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (142 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (142 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (105 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (105 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (111 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (111 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (121 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (121 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 439
    (142 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (142 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (142 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (142 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (105 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (105 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (105 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (105 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (111 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (111 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (111 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (111 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (121 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (121 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (121 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (121 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 440
    (142 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (142 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (142 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (142 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (142 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (142 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (142 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (142 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (105 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (105 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (105 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (105 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (105 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (105 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (105 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (105 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 441
    (111 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (111 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (111 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (111 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (111 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (111 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (111 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (111 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (121 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (121 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (121 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (121 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (121 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (121 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (121 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (121 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 442
    (0 << 24) | (446 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (449 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (454 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (461 << 6) | (0 << 3) | 0, // nibble 03
    (190 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (192 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (15 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (56 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (231 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (231 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (231 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (231 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (231 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (231 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (231 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (231 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 443
    (0 << 24) | (447 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (448 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (450 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (451 << 6) | (0 << 3) | 0, // nibble 03
    (0 << 24) | (455 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (458 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (462 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (465 << 6) | (0 << 3) | 0, // nibble 07
    (190 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (190 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (192 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (192 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (15 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (15 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (56 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (56 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 444
    (161 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (167 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (176 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (183 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (207 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (220 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (221 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (0 << 24) | (452 << 6) | (0 << 3) | 0, // nibble 07
    (0 << 24) | (456 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (457 << 6) | (0 << 3) | 0, // nibble 09
    (0 << 24) | (459 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (460 << 6) | (0 << 3) | 0, // nibble 0b
    (0 << 24) | (463 << 6) | (0 << 3) | 0, // nibble 0c
    (0 << 24) | (464 << 6) | (0 << 3) | 0, // nibble 0d
    (0 << 24) | (466 << 6) | (0 << 3) | 0, // nibble 0e
    (0 << 24) | (467 << 6) | (0 << 3) | 0, // nibble 0f
    // State 445
    (161 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (161 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (167 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (167 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (176 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (176 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (183 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (183 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (207 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (207 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (220 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (220 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (221 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (221 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (38 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (40 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 446
    (161 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (161 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (161 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (161 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (167 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (167 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (167 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (167 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (176 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (176 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (176 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (176 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (183 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (183 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (183 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (183 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 447
    (161 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (161 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (161 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (161 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (161 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (161 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (161 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (161 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (167 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (167 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (167 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (167 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (167 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (167 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (167 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (167 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 448
    (176 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (176 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (176 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (176 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (176 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (176 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (176 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (176 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (183 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (183 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (183 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (183 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (183 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (183 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (183 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (183 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 449
    (207 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (207 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (207 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (207 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (220 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (220 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (220 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (220 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (221 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (221 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (221 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (221 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (38 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (38 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (40 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (40 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 450
    (207 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (207 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (207 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (207 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (207 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (207 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (207 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (207 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (220 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (220 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (220 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (220 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (220 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (220 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (220 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (220 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 451
    (221 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (221 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (221 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (221 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (221 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (221 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (221 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (221 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (38 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (38 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (38 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (38 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (40 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (40 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (40 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (40 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 452
    (38 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (38 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (38 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (38 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (38 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (38 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (38 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (38 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (40 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (40 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (40 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (40 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (40 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (40 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (40 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (40 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 453
    (41 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (59 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (61 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (63 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (70 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (77 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (83 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (86 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (91 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 08
    (92 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (105 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (115 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (120 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (123 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (128 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (138 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 454
    (41 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (41 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (59 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (59 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (61 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (61 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (63 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (63 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (70 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (70 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (77 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (77 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (83 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (83 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (86 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (86 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 455
    (41 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (41 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (41 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (41 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (59 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (59 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (59 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (59 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (61 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (61 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (61 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (61 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (63 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (63 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (63 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (63 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 456
    (41 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (41 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (41 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (41 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (41 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (41 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (41 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (41 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (59 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (59 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (59 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (59 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (59 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (59 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (59 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (59 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 457
    (61 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (61 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (61 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (61 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (61 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (61 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (61 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (61 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (63 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (63 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (63 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (63 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (63 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (63 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (63 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (63 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 458
    (70 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (70 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (70 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (70 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (77 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (77 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (77 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (77 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (83 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (83 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (83 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (83 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (86 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (86 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (86 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (86 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 459
    (70 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (70 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (70 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (70 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (70 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (70 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (70 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (70 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (77 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (77 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (77 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (77 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (77 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (77 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (77 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (77 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 460
    (83 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (83 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (83 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (83 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (83 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (83 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (83 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (83 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (86 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (86 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (86 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (86 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (86 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (86 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (86 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (86 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 461
    (91 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (91 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (92 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (92 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (105 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (105 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (115 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (115 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (120 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (120 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (123 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (123 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (128 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (128 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (138 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (138 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 462
    (91 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (91 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (91 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (91 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (92 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (92 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (92 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (92 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (105 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (105 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (105 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (105 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (115 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (115 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (115 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (115 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 463
    (91 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (91 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (91 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (91 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (91 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (91 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (91 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (91 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (92 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (92 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (92 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (92 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (92 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (92 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (92 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (92 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 464
    (105 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (105 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (105 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (105 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (105 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (105 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (105 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (105 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (115 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (115 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (115 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (115 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (115 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (115 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (115 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (115 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 465
    (120 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (120 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (120 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (120 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (123 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (123 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (123 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (123 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (128 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (128 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (128 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (128 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (138 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (138 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (138 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (138 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 466
    (120 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (120 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (120 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (120 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (120 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (120 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (120 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (120 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (123 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (123 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (123 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (123 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (123 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (123 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (123 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (123 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 467
    (128 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (128 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (128 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (128 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (128 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (128 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (128 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (128 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (138 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (138 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (138 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (138 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (138 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (138 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (138 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (138 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 468
    (190 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (190 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (190 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (190 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (192 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (192 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (192 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (192 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (15 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (15 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (15 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (15 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (56 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (56 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (56 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (56 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 469
    (190 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (190 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (190 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (190 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (190 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (190 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (190 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (190 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (192 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (192 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (192 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (192 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (192 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (192 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (192 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (192 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 470
    (15 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (15 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (15 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (15 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (15 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (15 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (15 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (15 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (56 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (56 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (56 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (56 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (56 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (56 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (56 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (56 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 471
    (246 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (246 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (246 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (246 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (10 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (10 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (10 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (10 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (0 << 24) | (476 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (490 << 6) | (0 << 3) | 0, // nibble 09
    (241 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (241 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (247 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (247 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (247 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (247 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 472
    (246 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (246 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (246 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (246 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (246 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (246 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (246 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (246 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (10 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (10 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (10 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (10 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (10 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (10 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (10 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (10 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 473
    (0 << 24) | (477 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (483 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (491 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (507 << 6) | (0 << 3) | 0, // nibble 03
    (241 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (241 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (241 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (241 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (247 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (247 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (247 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (247 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (247 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (247 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (247 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (247 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 474
    (0 << 24) | (478 << 6) | (0 << 3) | 0, // nibble 00
    (227 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (30 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (0 << 24) | (484 << 6) | (0 << 3) | 0, // nibble 03
    (0 << 24) | (492 << 6) | (0 << 3) | 0, // nibble 04
    (0 << 24) | (501 << 6) | (0 << 3) | 0, // nibble 05
    (31 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (0 << 24) | (508 << 6) | (0 << 3) | 0, // nibble 07
    (241 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (241 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (241 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (241 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (241 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (241 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (241 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (241 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 475
    (0 << 24) | (479 << 6) | (0 << 3) | 0, // nibble 00
    (0 << 24) | (481 << 6) | (0 << 3) | 0, // nibble 01
    (227 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (227 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (30 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (30 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (0 << 24) | (485 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (489 << 6) | (0 << 3) | 0, // nibble 07
    (0 << 24) | (493 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (495 << 6) | (0 << 3) | 0, // nibble 09
    (0 << 24) | (502 << 6) | (0 << 3) | 0, // nibble 0a
    (0 << 24) | (506 << 6) | (0 << 3) | 0, // nibble 0b
    (31 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (31 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (219 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (0 << 24) | (509 << 6) | (0 << 3) | 0, // nibble 0f
    // State 476
    (240 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (0 << 24) | (480 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (482 << 6) | (0 << 3) | 0, // nibble 02
    (203 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (227 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (227 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (227 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (227 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (30 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (30 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (30 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (30 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (0 << 24) | (486 << 6) | (0 << 3) | 0, // nibble 0c
    (202 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (204 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (211 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 477
    (240 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (240 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (26 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (167 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (94 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (95 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (203 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (203 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (227 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (227 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (227 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (227 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (227 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (227 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (227 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (227 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 478
    (240 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (240 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (240 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (240 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (26 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (26 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (167 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (167 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (94 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (94 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (95 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (95 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (203 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (203 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (203 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (203 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 479
    (240 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (240 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (240 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (240 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (240 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (240 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (240 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (240 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (26 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (26 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (26 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (26 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (167 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (167 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (167 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (167 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 480
    (26 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (26 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (26 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (26 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (26 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (26 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (26 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (26 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (167 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (167 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (167 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (167 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (167 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (167 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (167 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (167 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 481
    (94 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (94 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (94 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (94 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (95 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (95 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (95 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (95 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (203 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (203 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (203 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (203 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (203 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (203 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (203 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (203 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 482
    (94 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (94 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (94 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (94 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (94 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (94 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (94 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (94 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (95 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (95 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (95 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (95 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (95 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (95 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (95 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (95 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 483
    (30 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (30 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (30 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (30 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (30 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (30 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (30 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (30 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (0 << 24) | (487 << 6) | (0 << 3) | 0, // nibble 08
    (153 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 09
    (202 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (202 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (204 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (204 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (211 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (211 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 484
    (0 << 24) | (488 << 6) | (0 << 3) | 0, // nibble 00
    (2 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (153 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (153 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (202 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (202 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (202 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (202 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (204 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (204 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (204 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (204 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (211 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (211 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (211 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (211 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 485
    (148 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (191 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (2 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (2 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (153 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (153 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (153 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (153 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (202 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (202 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (202 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (202 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (202 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (202 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (202 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (202 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 486
    (148 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (148 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (191 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (191 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (2 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (2 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (2 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (2 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (153 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (153 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (153 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (153 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (153 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (153 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (153 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (153 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 487
    (148 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (148 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (148 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (148 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (191 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (191 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (191 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (191 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (2 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (2 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (2 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (2 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (2 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (2 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (2 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (2 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 488
    (148 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (148 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (148 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (148 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (148 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (148 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (148 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (148 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (191 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (191 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (191 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (191 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (191 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (191 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (191 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (191 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 489
    (204 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (204 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (204 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (204 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (204 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (204 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (204 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (204 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (211 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (211 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (211 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (211 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (211 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (211 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (211 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (211 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 490
    (47 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (0 << 24) | (494 << 6) | (0 << 3) | 0, // nibble 01
    (0 << 24) | (496 << 6) | (0 << 3) | 0, // nibble 02
    (0 << 24) | (498 << 6) | (0 << 3) | 0, // nibble 03
    (0 << 24) | (503 << 6) | (0 << 3) | 0, // nibble 04
    (206 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 05
    (242 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 06
    (201 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 07
    (31 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (31 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (31 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (31 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (219 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (219 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (205 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (239 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 491
    (47 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (47 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (157 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (166 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (85 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 04
    (0 << 24) | (497 << 6) | (0 << 3) | 0, // nibble 05
    (0 << 24) | (499 << 6) | (0 << 3) | 0, // nibble 06
    (0 << 24) | (500 << 6) | (0 << 3) | 0, // nibble 07
    (0 << 24) | (504 << 6) | (0 << 3) | 0, // nibble 08
    (0 << 24) | (505 << 6) | (0 << 3) | 0, // nibble 09
    (206 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (206 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (242 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (242 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (201 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (201 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 492
    (47 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (47 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (47 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (47 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (157 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (157 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (166 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (166 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (85 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (85 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (31 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0a
    (127 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0b
    (137 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0c
    (108 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0d
    (120 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0e
    (164 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 0f
    // State 493
        (47 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
        (47 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
        (47 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
        (47 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
        (47 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
        (47 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
        (47 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
        (47 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
        (157 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
        (157 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
        (157 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
        (157 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
        (166 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
        (166 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
        (166 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
        (166 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 494
    (157 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (157 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (157 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (157 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (157 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (157 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (157 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (157 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (166 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (166 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (166 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (166 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (166 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (166 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (166 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (166 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 495
    (85 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (85 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (85 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (85 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (31 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (31 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (127 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (127 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (137 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 08
    (137 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 09
    (108 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0a
    (108 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0b
    (120 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (120 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (164 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (164 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 496
    (85 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (85 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (85 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (85 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (85 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (85 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (85 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (85 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (31 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (31 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (31 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (31 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (127 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (127 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (127 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (127 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 497
    (31 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (31 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (31 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (31 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (31 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (31 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (31 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (31 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (127 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (127 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (127 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (127 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (127 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (127 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (127 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (127 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 498
    (137 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (137 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (137 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (137 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (108 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (108 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (108 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (108 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (120 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (120 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (120 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (120 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (164 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (164 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (164 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (164 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 499
    (137 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (137 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (137 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (137 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (137 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (137 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (137 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (137 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (108 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (108 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (108 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (108 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (108 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (108 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (108 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (108 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 500
    (120 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (120 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (120 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (120 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (120 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (120 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (120 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (120 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (164 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (164 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (164 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (164 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (164 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (164 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (164 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (164 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 501
    (166 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 00
    (184 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 01
    (190 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 02
    (202 << 24) | (0 << 6) | (1 << 3) | 0, // nibble 03
    (206 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (206 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (206 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (206 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (242 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (242 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (242 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (242 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (201 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (201 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (201 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (201 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 502
    (166 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 00
    (166 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 01
    (184 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 02
    (184 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 03
    (190 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 04
    (190 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 05
    (202 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 06
    (202 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 07
    (206 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (206 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (206 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (206 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (206 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (206 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (206 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (206 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 503
    (166 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 00
    (166 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 01
    (166 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 02
    (166 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 03
    (184 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 04
    (184 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 05
    (184 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 06
    (184 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 07
    (190 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (190 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (190 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (190 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (202 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (202 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (202 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (202 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 504
    (166 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (166 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (166 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (166 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (166 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (166 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (166 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (166 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (184 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (184 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (184 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (184 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (184 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (184 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (184 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (184 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 505
    (190 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (190 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (190 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (190 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (190 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (190 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (190 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (190 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (202 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (202 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (202 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (202 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (202 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (202 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (202 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (202 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 506
    (242 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (242 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (242 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (242 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (242 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (242 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (242 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (242 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (201 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (201 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (201 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (201 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (201 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (201 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (201 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (201 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
    // State 507
    (31 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (31 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (31 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (31 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (31 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (31 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (31 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (31 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (219 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (219 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (219 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (219 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (205 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0c
    (205 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0d
    (239 << 24) | (1 << 6) | (1 << 3) | 0, // nibble 0e
    (239 << 24) | (0 << 6) | (1 << 3) | 1, // nibble 0f
    // State 508
    (219 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (219 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (219 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (219 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (219 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (219 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (219 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (219 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (205 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 08
    (205 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 09
    (205 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0a
    (205 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0b
    (239 << 24) | (2 << 6) | (1 << 3) | 0, // nibble 0c
    (239 << 24) | (223 << 6) | (1 << 3) | 0, // nibble 0d
    (239 << 24) | (1 << 6) | (1 << 3) | 1, // nibble 0e
    (239 << 24) | (0 << 6) | (1 << 3) | 2, // nibble 0f
    // State 509
    (205 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 00
    (205 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 01
    (205 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 02
    (205 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 03
    (205 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 04
    (205 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 05
    (205 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 06
    (205 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 07
    (239 << 24) | (3 << 6) | (1 << 3) | 0, // nibble 08
    (239 << 24) | (148 << 6) | (1 << 3) | 0, // nibble 09
    (239 << 24) | (224 << 6) | (1 << 3) | 0, // nibble 0a
    (239 << 24) | (294 << 6) | (1 << 3) | 0, // nibble 0b
    (239 << 24) | (2 << 6) | (1 << 3) | 1, // nibble 0c
    (239 << 24) | (223 << 6) | (1 << 3) | 1, // nibble 0d
    (239 << 24) | (1 << 6) | (1 << 3) | 2, // nibble 0e
    (239 << 24) | (0 << 6) | (1 << 3) | 3, // nibble 0f
};


bool unhuffimage4(uint32_t* compressed_image, uint32_t compressed_length_u32s, uint32_t stride_bytes, uint32_t height, unsigned char* image)
{
    memcpy(((char*)(image)), ((char*)(compressed_image)), stride_bytes);
    uint32_t wordCount = (stride_bytes + 3) >> 2;
    uint32_t* currentCompressedWordP = compressed_image + wordCount;
    unsigned char* previousImageLine = image;
    unsigned char* currentImageLine = image + stride_bytes;
    uint32_t currentState = 0;
    unsigned char byteAbove = *previousImageLine++;
    uint32_t* compressedLim = compressed_image + compressed_length_u32s;

    // start first loop
    uint32_t compressedWord = *currentCompressedWordP++;
    uint32_t nibble = (compressedWord >> 26) & 0x3c;
    uint32_t stateWord = *(uint32_t*)(((unsigned char*)DecompressionStateTable) + currentState + nibble);

    unsigned char* end = image + stride_bytes * height - 32;
    while (currentImageLine < end) {

        uint32_t nextStateWord;
        uint32_t i;

        nibble = (compressedWord >> 22) & 0x3c;

        ONE_NIBBLE();

        nibble = (compressedWord >> 18) & 0x3c;

        ONE_NIBBLE();

        nibble = (compressedWord >> 14) & 0x3c;

        ONE_NIBBLE();

        nibble = (compressedWord >> 10) & 0x3c;

        ONE_NIBBLE();

        nibble = (compressedWord >> 6) & 0x3c;

        ONE_NIBBLE();

        nibble = (compressedWord >> 2) & 0x3c;

        ONE_NIBBLE();

        nibble = (compressedWord << 2) & 0x3c;

        if (currentCompressedWordP >= compressedLim) {
            // we need to avoid accessing the next word of compressed data
            end += 32;
            ONE_NIBBLE_ROLLED_CHECKING(end); // processing 'nibble = (compressedWord >> 2) & 0x3c'
            ONE_NIBBLE_ROLLED_CHECKING(end); // processing 'nibble = (compressedWord << 2) & 0x3c'
            goto done;
        }
        compressedWord = *currentCompressedWordP++;

        ONE_NIBBLE(); // processing 'nibble = (compressedWord >> 2) & 0x3c'

        nibble = (compressedWord >> 26) & 0x3c;

        ONE_NIBBLE(); // processing 'nibble = (compressedWord << 2) & 0x3c'
    }

    end += 32;

    while (currentImageLine < end && currentCompressedWordP <= compressedLim) {
        uint32_t nextStateWord;
        uint32_t i;
        nibble = (compressedWord >> 22) & 0x3c;
        ONE_NIBBLE_ROLLED_CHECKING(end);
        if (currentImageLine < end) {
            nibble = (compressedWord >> 18) & 0x3c;
            ONE_NIBBLE_ROLLED_CHECKING(end);
            if (currentImageLine < end) {
                nibble = (compressedWord >> 14) & 0x3c;
                ONE_NIBBLE_ROLLED_CHECKING(end);
                if (currentImageLine < end) {
                    nibble = (compressedWord >> 10) & 0x3c;
                    ONE_NIBBLE_ROLLED_CHECKING(end);
                    if (currentImageLine < end) {
                        nibble = (compressedWord >> 6) & 0x3c;
                        ONE_NIBBLE_ROLLED_CHECKING(end);
                        if (currentImageLine < end) {
                            nibble = (compressedWord >> 2) & 0x3c;
                            ONE_NIBBLE_ROLLED_CHECKING(end);
                            if (currentImageLine < end) {
                                nibble = (compressedWord << 2) & 0x3c;
                                ONE_NIBBLE_ROLLED_CHECKING(end); // processing 'nibble = (compressedWord >> 2) & 0x3c'
                                if (currentImageLine < end) {
                                    if (currentCompressedWordP == compressedLim) {
                                        ONE_NIBBLE_ROLLED_CHECKING(end); // processing 'nibble = (compressedWord << 2) & 0x3c'
                                        goto done;
                                    }
                                    else {
                                        compressedWord = *currentCompressedWordP++;
                                        nibble = (compressedWord >> 26) & 0x3c;  // processing 'nibble = (compressedWord << 2) & 0x3c'
                                        ONE_NIBBLE_ROLLED_CHECKING(end);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

done:
    int64_t compressionOffset = (int64_t)(currentCompressedWordP - compressedLim);
    int64_t resultOffset = end - currentImageLine;

    bool good = compressionOffset == 0 && resultOffset == 0;

    return good;
}
