/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import OpenRTM.CdrDataHolder;
import OpenRTM.OutPortCdr;
import OpenRTM.PortStatus;
import _SDOPackage.NVListHolder;
import jp.go.aist.rtm.RTC.Manager;
import jp.go.aist.rtm.RTC.ObjectCreator;
import jp.go.aist.rtm.RTC.ObjectDestructor;
import jp.go.aist.rtm.RTC.OutPortConsumerFactory;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.port.ConnectorBase;
import jp.go.aist.rtm.RTC.port.ConnectorListeners;
import jp.go.aist.rtm.RTC.port.CorbaConsumer;
import jp.go.aist.rtm.RTC.port.InPortConnector;
import jp.go.aist.rtm.RTC.port.OutPortConsumer;
import jp.go.aist.rtm.RTC.port.ReturnCode;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.Properties;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.portable.OutputStream;

public class OutPortCorbaCdrConsumer
extends CorbaConsumer<OutPortCdr>
implements OutPortConsumer,
ObjectCreator<OutPortConsumer>,
ObjectDestructor {
    private BufferBase<OutputStream> m_buffer;
    private Logbuf rtcout = new Logbuf("OutPortCorbaCdrConsumer");
    private InPortConnector m_connector;
    private ConnectorListeners m_listeners;
    private ConnectorBase.ConnectorInfo m_profile;

    public OutPortCorbaCdrConsumer() {
        super(OutPortCdr.class);
    }

    @Override
    public void init(Properties properties) {
        this.rtcout.println(2, "OutPutCorbaCdrConsumer.init()");
    }

    @Override
    public void setBuffer(BufferBase<OutputStream> bufferBase) {
        this.rtcout.println(2, "OutPutCorbaCdrConsumer.setBuffer()");
        this.m_buffer = bufferBase;
    }

    @Override
    public void setListener(ConnectorBase.ConnectorInfo connectorInfo, ConnectorListeners connectorListeners) {
        this.rtcout.println(2, "OutPutCorbaCdrConsumer.setListener()");
        this.m_listeners = connectorListeners;
        this.m_profile = connectorInfo;
    }

    @Override
    public ReturnCode get(OutputStream outputStream) {
        this.rtcout.println(2, "OutPutCorbaCdrConsumer.get()");
        CdrDataHolder cdrDataHolder = new CdrDataHolder();
        try {
            PortStatus portStatus = ((OutPortCdr)this._ptr()).get(cdrDataHolder);
            if (portStatus == PortStatus.PORT_OK) {
                this.rtcout.println(3, "get() successful");
                outputStream.write_octet_array(cdrDataHolder.value, 0, cdrDataHolder.value.length);
                this.rtcout.println(0, "CDR data length: " + cdrDataHolder.value.length);
                this.onReceived(outputStream);
                this.onBufferWrite(outputStream);
                if (this.m_buffer.full()) {
                    this.rtcout.println(4, "InPort buffer is full.");
                    this.onBufferFull(outputStream);
                    this.onReceiverFull(outputStream);
                }
                this.m_buffer.put(outputStream);
                this.m_buffer.advanceWptr();
                this.m_buffer.advanceRptr();
                return ReturnCode.PORT_OK;
            }
            return this.convertReturn(portStatus);
        }
        catch (Exception exception) {
            this.rtcout.println(5, "Exception caought from OutPort.get().");
            return ReturnCode.CONNECTION_LOST;
        }
    }

    @Override
    public boolean subscribeInterface(NVListHolder nVListHolder) {
        this.rtcout.println(2, "OutPortCorbaCdrConsumer.subscribeInterface()");
        int n = NVUtil.find_index(nVListHolder, "dataport.corba_cdr.outport_ior");
        if (n < 0) {
            this.rtcout.println(3, "dataport.corba_cdr.outport_ior not found.");
            return false;
        }
        if (NVUtil.isString(nVListHolder, "dataport.corba_cdr.outport_ior")) {
            String string;
            this.rtcout.println(3, "dataport.corba_cdr.outport_ior found.");
            try {
                string = nVListHolder.value[n].value.type().kind() == TCKind.tk_wstring ? nVListHolder.value[n].value.extract_wstring() : nVListHolder.value[n].value.extract_string();
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                this.rtcout.println(6, "outport_ior has no string");
                return false;
            }
            ORB oRB = Manager.instance().getORB();
            Object object = oRB.string_to_object(string);
            if (object == null) {
                this.rtcout.println(6, "invalid IOR string has been passed");
                return false;
            }
            if (!super.setObject(object)) {
                this.rtcout.println(6, "Invalid object reference.");
                return false;
            }
            this.rtcout.println(3, "CorbaConsumer was set successfully.");
            return true;
        }
        return false;
    }

    @Override
    public void unsubscribeInterface(NVListHolder nVListHolder) {
        String string;
        this.rtcout.println(2, "OutPortCorbaCdrConsumer.unsubscribeInterface()");
        int n = NVUtil.find_index(nVListHolder, "dataport.corba_cdr.outport_ior");
        if (n < 0) {
            this.rtcout.println(3, "dataport.corba_cdr.outport_ior not found.");
            return;
        }
        try {
            string = nVListHolder.value[n].value.type().kind() == TCKind.tk_wstring ? nVListHolder.value[n].value.extract_wstring() : nVListHolder.value[n].value.extract_string();
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            this.rtcout.println(6, "inport_ior has no string");
            return;
        }
        this.rtcout.println(3, "dataport.corba_cdr.outport_ior found.");
        ORB oRB = Manager.instance().getORB();
        Object object = oRB.string_to_object(string);
        if (((OutPortCdr)this._ptr())._is_equivalent(object)) {
            this.releaseObject();
            this.rtcout.println(3, "CorbaConsumer's reference was released.");
            return;
        }
        this.rtcout.println(6, "hmm. Inconsistent object reference.");
    }

    protected ReturnCode convertReturn(PortStatus portStatus) {
        switch (portStatus.value()) {
            case 0: {
                return ReturnCode.PORT_OK;
            }
            case 1: {
                this.onSenderError();
                return ReturnCode.PORT_ERROR;
            }
            case 2: {
                return ReturnCode.BUFFER_FULL;
            }
            case 3: {
                this.onSenderEmpty();
                return ReturnCode.BUFFER_EMPTY;
            }
            case 4: {
                this.onSenderTimeout();
                return ReturnCode.BUFFER_TIMEOUT;
            }
            case 5: {
                this.onSenderError();
                return ReturnCode.UNKNOWN_ERROR;
            }
        }
        this.onSenderError();
        return ReturnCode.UNKNOWN_ERROR;
    }

    @Override
    public OutPortConsumer creator_() {
        return new OutPortCorbaCdrConsumer();
    }

    @Override
    public void destructor_(java.lang.Object object) {
        object = null;
    }

    public static void OutPortCorbaCdrConsumerInit() {
        OutPortConsumerFactory outPortConsumerFactory = OutPortConsumerFactory.instance();
        outPortConsumerFactory.addFactory("corba_cdr", new OutPortCorbaCdrConsumer(), new OutPortCorbaCdrConsumer());
    }

    @Override
    public void setConnector(InPortConnector inPortConnector) {
        this.m_connector = inPortConnector;
    }

    private void onBufferWrite(OutputStream outputStream) {
        this.m_listeners.connectorData_[0].notify(this.m_profile, outputStream);
    }

    private void onBufferFull(OutputStream outputStream) {
        this.m_listeners.connectorData_[1].notify(this.m_profile, outputStream);
    }

    private void onReceived(OutputStream outputStream) {
        this.m_listeners.connectorData_[6].notify(this.m_profile, outputStream);
    }

    private void onReceiverFull(OutputStream outputStream) {
        this.m_listeners.connectorData_[7].notify(this.m_profile, outputStream);
    }

    private void onSenderEmpty() {
        this.m_listeners.connector_[2].notify(this.m_profile);
    }

    private void onSenderTimeout() {
        this.m_listeners.connector_[3].notify(this.m_profile);
    }

    private void onSenderError() {
        this.m_listeners.connector_[4].notify(this.m_profile);
    }
}

