/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.StringUtil;

public class ModuleManager {
    private final String CONFIG_EXT = "manager.modules.config_ext";
    private final String CONFIG_PATH = "manager.modules.config_path";
    private final String DETECT_MOD = "manager.modules.detect_loadable";
    private final String MOD_LOADPTH = "manager.modules.load_path";
    private final String INITFUNC_SFX = "manager.modules.init_func_suffix";
    private final String INITFUNC_PFX = "manager.modules.init_func_prefix";
    private final String ALLOW_ABSPATH = "manager.modules.abs_path_allowed";
    private final String ALLOW_URL = "manager.modules.download_allowed";
    private final String MOD_DWNDIR = "manager.modules.download_dir";
    private final String MOD_DELMOD = "manager.modules.download_cleanup";
    private final String MOD_PRELOAD = "manager.modules.preload";
    protected Properties m_properties;
    protected Map<String, Class> m_modules = new HashMap<String, Class>();
    protected Vector<String> m_loadPath = new Vector();
    protected Vector<String> m_configPath = new Vector();
    protected boolean m_downloadAllowed;
    protected boolean m_absoluteAllowed;
    protected String m_initFuncSuffix = new String();
    protected String m_initFuncPrefix = new String();

    public ModuleManager(Properties properties) {
        this.m_properties = properties;
        this.m_configPath = new Vector();
        String[] stringArray = properties.getProperty("manager.modules.config_path").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_configPath.add(stringArray[i].trim());
        }
        this.m_loadPath = new Vector();
        String[] stringArray2 = properties.getProperty("manager.modules.load_path").split(",");
        for (int i = 0; i < stringArray2.length; ++i) {
            this.m_loadPath.add(stringArray2[i].trim());
        }
        this.m_absoluteAllowed = StringUtil.toBool(properties.getProperty("manager.modules.abs_path_allowed"), "yes", "no", false);
        this.m_downloadAllowed = StringUtil.toBool(properties.getProperty("manager.modules.download_allowed"), "yes", "no", false);
        this.m_initFuncSuffix = properties.getProperty("manager.modules.init_func_suffix");
        this.m_initFuncPrefix = properties.getProperty("manager.modules.init_func_prefix");
    }

    public void destruct() {
        this.unloadAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destruct();
        }
        finally {
            super.finalize();
        }
    }

    public String load(String string) throws Exception {
        String string2 = null;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("moduleName is empty.:load()");
        }
        try {
            new URL(string);
            if (!this.m_downloadAllowed) {
                throw new IllegalArgumentException("Downloading module is not allowed.");
            }
            throw new IllegalArgumentException("Not implemented." + string);
        }
        catch (MalformedURLException malformedURLException) {
            Class<?> clazz = null;
            if (StringUtil.isAbsolutePath(string)) {
                try {
                    if (!this.m_absoluteAllowed) {
                        throw new IllegalArgumentException("Absolute path is not allowed");
                    }
                    clazz = Class.forName(string);
                    string2 = string;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ClassNotFoundException("Not implemented." + string, classNotFoundException);
                }
            } else {
                if (this.m_loadPath.size() == 0) {
                    throw new ClassNotFoundException();
                }
                for (int i = 0; i < this.m_loadPath.size(); ++i) {
                    String string3 = this.m_loadPath.elementAt(i) + "." + string;
                    try {
                        clazz = Class.forName(string3);
                        string2 = string3;
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (clazz == null) {
                    throw new ClassNotFoundException("Not implemented." + string);
                }
            }
            if (string2 == null || string2.length() == 0) {
                throw new IllegalArgumentException("Invalid file name.");
            }
            this.m_modules.put(string2, clazz);
            return string2;
        }
    }

    public String load(String string, String string2) throws Exception {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("moduleName is empty.:load()");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("methodName is empty.:load()");
        }
        String string3 = this.load(string);
        Method method = this.symbol(string3, string2);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassNotFoundException("Not implemented." + string, classNotFoundException);
        }
        try {
            method.invoke(clazz.newInstance(), new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw illegalAccessException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (InstantiationException instantiationException) {
            throw instantiationException;
        }
        return string3;
    }

    public void unload(String string) throws Exception {
        if (!this.m_modules.containsKey(string)) {
            throw new IllegalArgumentException("Not Found:" + string);
        }
        this.m_modules.remove(string);
    }

    public void unloadAll() {
        this.m_modules = new HashMap<String, Class>();
    }

    public Method symbol(String string, String string2) throws Exception {
        Method method;
        Class clazz = this.m_modules.get(string);
        if (clazz == null) {
            throw new IllegalArgumentException("Not Found(symbol):" + string);
        }
        try {
            method = clazz.getMethod(string2, new Class[0]);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw noSuchMethodException;
        }
        return method;
    }

    public String getInitFuncName(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = string.split("\\.");
        return this.m_initFuncPrefix + stringArray[stringArray.length - 1] + this.m_initFuncSuffix;
    }

    public void setLoadpath(Vector<String> vector) {
        this.m_loadPath = new Vector<String>(vector);
    }

    public Vector<String> getLoadPath() {
        return new Vector<String>(this.m_loadPath);
    }

    public void addLoadPath(Vector<String> vector) {
        this.m_loadPath.addAll(vector);
    }

    public Map<String, Class> getLoadedModules() {
        return this.m_modules;
    }

    public Vector<Properties> getLoadableModules() {
        return new Vector<Properties>();
    }

    public void allowAbsolutePath() {
        this.m_absoluteAllowed = true;
    }

    public void disallowAbsolutePath() {
        this.m_absoluteAllowed = false;
    }

    public void allowModuleDownload() {
        this.m_downloadAllowed = true;
    }

    public void disallowModuleDownload() {
        this.m_downloadAllowed = false;
    }
}

