/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import OpenRTM.DataFlowComponent;
import OpenRTM.DataFlowComponentHelper;
import OpenRTM.DataFlowComponentPOA;
import RTC.ComponentProfile;
import RTC.ExecutionContext;
import RTC.ExecutionContextHelper;
import RTC.ExecutionContextListHolder;
import RTC.ExecutionContextService;
import RTC.ExecutionContextServiceHelper;
import RTC.ExecutionContextServiceListHolder;
import RTC.LightweightRTObject;
import RTC.PortProfile;
import RTC.PortService;
import RTC.RTObject;
import RTC.RTObjectHelper;
import RTC.ReturnCode_t;
import _SDOPackage.Configuration;
import _SDOPackage.DeviceProfile;
import _SDOPackage.InterfaceNotImplemented;
import _SDOPackage.InternalError;
import _SDOPackage.InvalidParameter;
import _SDOPackage.Monitoring;
import _SDOPackage.NVListHolder;
import _SDOPackage.NameValue;
import _SDOPackage.NotAvailable;
import _SDOPackage.Organization;
import _SDOPackage.OrganizationListHolder;
import _SDOPackage.SDOService;
import _SDOPackage.SDOServiceHolder;
import _SDOPackage.ServiceProfile;
import _SDOPackage.ServiceProfileHolder;
import _SDOPackage.ServiceProfileListHolder;
import java.util.Vector;
import jp.go.aist.rtm.RTC.ConfigAdmin;
import jp.go.aist.rtm.RTC.Manager;
import jp.go.aist.rtm.RTC.SDOPackage.Configuration_impl;
import jp.go.aist.rtm.RTC.executionContext.ExecutionContextBase;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.port.InPort;
import jp.go.aist.rtm.RTC.port.InPortBase;
import jp.go.aist.rtm.RTC.port.OutPort;
import jp.go.aist.rtm.RTC.port.OutPortBase;
import jp.go.aist.rtm.RTC.port.PortAdmin;
import jp.go.aist.rtm.RTC.port.PortBase;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.ORBUtil;
import jp.go.aist.rtm.RTC.util.POAUtil;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.ValueHolder;
import jp.go.aist.rtm.RTC.util.equalFunctor;
import jp.go.aist.rtm.RTC.util.operatorFunc;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class RTObject_impl
extends DataFlowComponentPOA {
    static final String[] default_conf = new String[]{"implementation_id", "", "type_name", "", "description", "", "version", "", "vendor", "", "category", "", "activity_type", "", "max_instance", "", "language", "", "lang_type", "", "conf", "", ""};
    public static final int ECOTHER_OFFSET = 1000;
    protected Manager m_pManager;
    protected ORB m_pORB;
    protected POA m_pPOA;
    protected OrganizationListHolder m_sdoOwnedOrganizations = new OrganizationListHolder();
    protected ServiceProfileListHolder m_sdoSvcProfiles = new ServiceProfileListHolder();
    protected Configuration_impl m_pSdoConfigImpl;
    protected Configuration m_pSdoConfig;
    protected OrganizationListHolder m_sdoOrganizations = new OrganizationListHolder();
    protected NVListHolder m_sdoStatus = new NVListHolder();
    protected ComponentProfile m_profile = new ComponentProfile();
    protected RTObject m_objref;
    protected PortAdmin m_portAdmin;
    protected ExecutionContextServiceListHolder m_ecMine;
    protected Vector<ExecutionContextBase> m_eclist = new Vector();
    protected ExecutionContextServiceListHolder m_ecOther;
    protected boolean m_created;
    protected Properties m_properties = new Properties();
    protected ConfigAdmin m_configsets;
    protected Logbuf rtcout;

    public RTObject_impl(Manager manager) {
        this.m_pManager = manager;
        this.m_pORB = manager.getORB();
        this.m_pPOA = manager.getPOA();
        this.m_portAdmin = new PortAdmin(manager.getORB(), manager.getPOA());
        this.m_created = true;
        this.m_properties = new Properties(default_conf);
        this.m_configsets = new ConfigAdmin(this.m_properties.getNode("conf"));
        this.m_objref = this._this();
        this.m_pSdoConfigImpl = new Configuration_impl(this.m_configsets);
        this.m_pSdoConfig = this.m_pSdoConfigImpl.getObjRef();
        if (this.m_ecMine == null) {
            this.m_ecMine = new ExecutionContextServiceListHolder();
            this.m_ecMine.value = new ExecutionContextService[0];
        }
        if (this.m_ecOther == null) {
            this.m_ecOther = new ExecutionContextServiceListHolder();
            this.m_ecOther.value = new ExecutionContextService[0];
        }
        if (this.m_sdoOwnedOrganizations.value == null) {
            this.m_sdoOwnedOrganizations.value = new Organization[0];
        }
        this.rtcout = new Logbuf("RTObject_impl");
    }

    public RTObject_impl(ORB oRB, POA pOA) {
        this.m_pManager = null;
        this.m_pORB = oRB;
        this.m_pPOA = pOA;
        this.m_portAdmin = new PortAdmin(oRB, pOA);
        this.m_created = true;
        this.m_properties = new Properties(default_conf);
        this.m_configsets = new ConfigAdmin(this.m_properties.getNode("conf"));
        this.m_objref = this._this();
        this.m_pSdoConfigImpl = new Configuration_impl(this.m_configsets);
        this.m_pSdoConfig = this.m_pSdoConfigImpl.getObjRef();
        if (this.m_ecMine == null) {
            this.m_ecMine = new ExecutionContextServiceListHolder();
            this.m_ecMine.value = new ExecutionContextService[0];
        }
        if (this.m_ecOther == null) {
            this.m_ecOther = new ExecutionContextServiceListHolder();
            this.m_ecOther.value = new ExecutionContextService[0];
        }
        Manager manager = Manager.instance();
        this.rtcout = new Logbuf("RTObject_impl");
    }

    @Override
    public DataFlowComponent _this() {
        if (this.m_objref == null) {
            try {
                this.m_objref = RTObjectHelper.narrow(POAUtil.getRef(this));
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return DataFlowComponentHelper.narrow(this.m_objref);
    }

    protected ReturnCode_t onInitialize() {
        this.rtcout.println(2, "RTObject_impl.onInitialize()");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onFinalize() {
        this.rtcout.println(2, "RTObject_impl.onFinalize()");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onStartup(int n) {
        this.rtcout.println(2, "RTObject_impl.onStartup(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onShutdown(int n) {
        this.rtcout.println(2, "RTObject_impl.onShutdown(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onActivated(int n) {
        this.rtcout.println(2, "RTObject_impl.onActivated(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onDeactivated(int n) {
        this.rtcout.println(2, "RTObject_impl.onDeactivated(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onExecute(int n) {
        this.rtcout.println(2, "RTObject_impl.onExecute(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onAborting(int n) {
        this.rtcout.println(2, "RTObject_impl.onAborting(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onError(int n) {
        this.rtcout.println(2, "RTObject_impl.onError(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onReset(int n) {
        this.rtcout.println(2, "RTObject_impl.onReset(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onStateUpdate(int n) {
        this.rtcout.println(2, "RTObject_impl.onStateUpdete(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onRateChanged(int n) {
        this.rtcout.println(2, "RTObject_impl.onRateChanged(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    @Override
    public ReturnCode_t initialize() {
        this.rtcout.println(2, "RTObject_impl.initialize()");
        if (!this.m_created) {
            return ReturnCode_t.PRECONDITION_NOT_MET;
        }
        String string = new String();
        string = string + this.m_properties.getProperty("exec_cxt.periodic.type");
        string = string + "?";
        string = string + "rate=" + this.m_properties.getProperty("exec_cxt.periodic.rate");
        ExecutionContextBase executionContextBase = Manager.instance().createContext(string);
        if (executionContextBase == null) {
            return ReturnCode_t.RTC_ERROR;
        }
        executionContextBase.set_rate(Double.valueOf(this.m_properties.getProperty("exec_cxt.periodic.rate")));
        this.m_eclist.add(executionContextBase);
        ExecutionContextService executionContextService = executionContextBase.getObjRef();
        if (executionContextService == null) {
            return ReturnCode_t.RTC_ERROR;
        }
        executionContextBase.bindComponent(this);
        ReturnCode_t returnCode_t = this.on_initialize();
        if (returnCode_t != ReturnCode_t.RTC_OK) {
            return returnCode_t;
        }
        this.m_created = false;
        if (this.m_ecMine.value.length == 0) {
            return ReturnCode_t.PRECONDITION_NOT_MET;
        }
        for (int i = 0; i < this.m_ecMine.value.length; ++i) {
            this.rtcout.println(3, "EC[" + i + "] starting");
            this.m_ecMine.value[i].start();
        }
        return returnCode_t;
    }

    @Override
    public ReturnCode_t _finalize() throws SystemException {
        this.rtcout.println(2, "RTObject_impl._finalize()");
        if (this.m_created) {
            return ReturnCode_t.PRECONDITION_NOT_MET;
        }
        if (this.m_ecOther.value.length != 0) {
            int n = this.m_ecOther.value.length;
            for (int i = 0; i < n; ++i) {
                if (this.m_ecOther.value[i] == null) continue;
                return ReturnCode_t.PRECONDITION_NOT_MET;
            }
        }
        ReturnCode_t returnCode_t = this.on_finalize();
        this.shutdown();
        return returnCode_t;
    }

    @Override
    public ReturnCode_t exit() throws SystemException {
        int n;
        this.rtcout.println(2, "RTObject_impl.exit()");
        if (this.m_created) {
            return ReturnCode_t.PRECONDITION_NOT_MET;
        }
        CORBA_SeqUtil.for_each(this.m_ecMine, (operatorFunc)new deactivate_comps((LightweightRTObject)this.m_objref._duplicate()));
        CORBA_SeqUtil.for_each(this.m_ecOther, (operatorFunc)new deactivate_comps((LightweightRTObject)this.m_objref._duplicate()));
        int n2 = this.m_ecMine.value.length;
        for (n = 0; n < n2; ++n) {
        }
        n2 = this.m_ecOther.value.length;
        for (n = 0; n < n2; ++n) {
            if (this.m_ecOther.value[n] == null) continue;
            this.m_ecOther.value[n].remove_component(this._this());
        }
        ReturnCode_t returnCode_t = this._finalize();
        return returnCode_t;
    }

    @Override
    public boolean is_alive(ExecutionContext executionContext) throws SystemException {
        int n;
        this.rtcout.println(2, "RTObject_impl.is_alive()");
        int n2 = this.m_ecMine.value.length;
        for (n = 0; n < n2; ++n) {
            if (!executionContext._is_equivalent(this.m_ecMine.value[n])) continue;
            return true;
        }
        n2 = this.m_ecOther.value.length;
        for (n = 0; n < n2; ++n) {
            if (this.m_ecOther.value[n] == null || !executionContext._is_equivalent(this.m_ecOther.value[n])) continue;
            return true;
        }
        return false;
    }

    @Override
    public ExecutionContext[] get_owned_contexts() throws SystemException {
        this.rtcout.println(2, "RTObject_impl.get_owned_contexts()");
        ExecutionContextListHolder executionContextListHolder = new ExecutionContextListHolder();
        executionContextListHolder.value = new ExecutionContext[0];
        CORBA_SeqUtil.for_each(this.m_ecMine, (operatorFunc)new ec_copy(executionContextListHolder));
        return executionContextListHolder.value;
    }

    @Override
    public ExecutionContext get_context(int n) {
        this.rtcout.println(2, "RTObject_impl.get_context(" + n + ")");
        if (n < 1000) {
            if (n < this.m_ecMine.value.length) {
                ExecutionContextService executionContextService = this.m_ecMine.value[n];
                return executionContextService;
            }
            return null;
        }
        int n2 = n - 1000;
        if (n2 < this.m_ecOther.value.length && this.m_ecOther.value[n2] != null) {
            ExecutionContextService executionContextService = this.m_ecOther.value[n2];
            return executionContextService;
        }
        return null;
    }

    @Override
    public ExecutionContext[] get_participating_contexts() throws SystemException {
        this.rtcout.println(2, "RTObject_impl.get_participating_contexts()");
        ExecutionContextListHolder executionContextListHolder = new ExecutionContextListHolder();
        executionContextListHolder.value = new ExecutionContext[0];
        CORBA_SeqUtil.for_each(this.m_ecOther, (operatorFunc)new ec_copy(executionContextListHolder));
        return executionContextListHolder.value;
    }

    @Override
    public int get_context_handle(ExecutionContext executionContext) throws SystemException {
        this.rtcout.println(2, "RTObject_impl.get_context_handle()");
        int n = 0;
        if (executionContext._is_equivalent(this.m_ecMine.value[0])) {
            return n;
        }
        int n2 = CORBA_SeqUtil.find(this.m_ecOther, (equalFunctor)new ec_find(executionContext));
        return n2 + 1;
    }

    public int bindContext(ExecutionContext executionContext) {
        this.rtcout.println(2, "RTObject_impl.bindContext()");
        ExecutionContextService executionContextService = ExecutionContextServiceHelper.narrow(executionContext);
        if (executionContextService == null) {
            return -1;
        }
        int n = this.m_ecMine.value.length;
        for (int i = 0; i < n; ++i) {
            if (this.m_ecMine.value[i] != null) continue;
            this.m_ecMine.value[i] = (ExecutionContextService)executionContextService._duplicate();
            return i;
        }
        CORBA_SeqUtil.push_back(this.m_ecMine, (ExecutionContextService)executionContextService._duplicate());
        return this.m_ecMine.value.length - 1;
    }

    @Override
    public ComponentProfile get_component_profile() {
        this.rtcout.println(2, "RTObject_impl.get_component_profile()");
        try {
            ComponentProfile componentProfile = new ComponentProfile();
            componentProfile.instance_name = this.m_profile.instance_name;
            componentProfile.type_name = this.m_profile.type_name;
            componentProfile.description = this.m_profile.description;
            componentProfile.version = this.m_profile.version;
            componentProfile.vendor = this.m_profile.vendor;
            componentProfile.category = this.m_profile.category;
            componentProfile.port_profiles = this.m_profile.port_profiles;
            componentProfile.parent = this.m_profile.parent;
            componentProfile.properties = this.m_profile.properties;
            componentProfile.port_profiles = this.m_portAdmin.getPortProfileList().value;
            return componentProfile;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public PortService[] get_ports() {
        this.rtcout.println(2, "RTObject_impl.get_ports()");
        try {
            return this.m_portAdmin.getPortServiceList().value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public int attach_context(ExecutionContext executionContext) throws SystemException {
        this.rtcout.println(2, "RTObject_impl.attach_context()");
        ExecutionContextService executionContextService = ExecutionContextServiceHelper.narrow(executionContext);
        if (executionContextService == null) {
            return -1;
        }
        int n = this.m_ecOther.value.length;
        for (int i = 0; i < n; ++i) {
            if (this.m_ecOther.value[i] != null) continue;
            this.m_ecOther.value[i] = (ExecutionContextService)executionContextService._duplicate();
            return i + 1000;
        }
        CORBA_SeqUtil.push_back(this.m_ecOther, (ExecutionContextService)executionContextService._duplicate());
        return this.m_ecOther.value.length - 1 + 1000;
    }

    @Override
    public ReturnCode_t detach_context(int n) throws SystemException {
        this.rtcout.println(2, "RTObject_impl.detach_context(" + n + ")");
        int n2 = this.m_ecOther.value.length;
        if (n < 1000 || n - 1000 > n2) {
            return ReturnCode_t.BAD_PARAMETER;
        }
        int n3 = n - 1000;
        if (this.m_ecOther.value[n3] == null) {
            return ReturnCode_t.BAD_PARAMETER;
        }
        this.m_ecOther.value[n3] = null;
        return ReturnCode_t.RTC_OK;
    }

    @Override
    public ReturnCode_t on_initialize() {
        this.rtcout.println(2, "RTObject_impl.on_initialize()");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            String string = this.m_properties.getProperty("active_config");
            if (string.length() == 0 || string.equals("")) {
                this.m_configsets.update("default");
            } else if (this.m_configsets.haveConfig(string)) {
                this.m_configsets.update(string);
            } else {
                this.m_configsets.update("default");
            }
            returnCode_t = this.onInitialize();
        }
        catch (Exception exception) {
            return ReturnCode_t.RTC_ERROR;
        }
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_finalize() {
        this.rtcout.println(2, "RTObject_impl.on_finalize()");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            returnCode_t = this.onFinalize();
        }
        catch (Exception exception) {
            return ReturnCode_t.RTC_ERROR;
        }
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_startup(int n) {
        this.rtcout.println(2, "RTObject_impl.on_startup(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            returnCode_t = this.onStartup(n);
        }
        catch (Exception exception) {
            return ReturnCode_t.RTC_ERROR;
        }
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_shutdown(int n) {
        this.rtcout.println(2, "RTObject_impl.on_shutdown(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            returnCode_t = this.onShutdown(n);
        }
        catch (Exception exception) {
            return ReturnCode_t.RTC_ERROR;
        }
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_activated(int n) {
        this.rtcout.println(2, "RTObject_impl.on_activated(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            this.m_configsets.update();
            returnCode_t = this.onActivated(n);
            this.m_portAdmin.activatePorts();
        }
        catch (Exception exception) {
            return ReturnCode_t.RTC_ERROR;
        }
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_deactivated(int n) {
        this.rtcout.println(2, "RTObject_impl.on_deactivated(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            this.m_portAdmin.deactivatePorts();
            returnCode_t = this.onDeactivated(n);
        }
        catch (Exception exception) {
            return ReturnCode_t.RTC_ERROR;
        }
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_aborting(int n) {
        this.rtcout.println(2, "RTObject_impl.on_aborting(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            returnCode_t = this.onAborting(n);
        }
        catch (Exception exception) {
            return ReturnCode_t.RTC_ERROR;
        }
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_error(int n) {
        this.rtcout.println(2, "RTObject_impl.on_error(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            returnCode_t = this.onError(n);
            this.m_configsets.update();
        }
        catch (Exception exception) {
            return ReturnCode_t.RTC_ERROR;
        }
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_reset(int n) {
        this.rtcout.println(2, "RTObject_impl.on_reset(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            returnCode_t = this.onReset(n);
        }
        catch (Exception exception) {
            return ReturnCode_t.RTC_ERROR;
        }
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_execute(int n) {
        this.rtcout.println(2, "RTObject_impl.on_execute(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            returnCode_t = this.onExecute(n);
        }
        catch (Exception exception) {
            return ReturnCode_t.RTC_ERROR;
        }
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_state_update(int n) {
        this.rtcout.println(2, "RTObject_impl.on_state_update(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            returnCode_t = this.onStateUpdate(n);
            this.m_configsets.update();
        }
        catch (Exception exception) {
            return ReturnCode_t.RTC_ERROR;
        }
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_rate_changed(int n) {
        this.rtcout.println(2, "RTObject_impl.on_rate_changed(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            returnCode_t = this.onRateChanged(n);
        }
        catch (Exception exception) {
            return ReturnCode_t.RTC_ERROR;
        }
        return returnCode_t;
    }

    @Override
    public Organization[] get_owned_organizations() throws NotAvailable {
        this.rtcout.println(2, "RTObject_impl.get_owned_organizations()");
        try {
            return (Organization[])this.m_sdoOwnedOrganizations.value.clone();
        }
        catch (Exception exception) {
            throw new NotAvailable();
        }
    }

    @Override
    public String get_sdo_id() throws NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_sdo_id()");
        try {
            String string = this.m_profile.instance_name;
            return string;
        }
        catch (Exception exception) {
            throw new InternalError("get_sdo_id()");
        }
    }

    @Override
    public String get_sdo_type() throws NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_sdo_type()");
        try {
            String string = this.m_profile.description;
            return string;
        }
        catch (Exception exception) {
            throw new InternalError("get_sdo_type()");
        }
    }

    @Override
    public DeviceProfile get_device_profile() throws NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_device_profile()");
        try {
            DeviceProfile deviceProfile = this.m_pSdoConfigImpl.getDeviceProfile();
            return deviceProfile;
        }
        catch (Exception exception) {
            throw new InternalError("get_device_profile()");
        }
    }

    @Override
    public ServiceProfile[] get_service_profiles() throws NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_service_profiles()");
        try {
            return this.m_pSdoConfigImpl.getServiceProfiles().value;
        }
        catch (Exception exception) {
            throw new InternalError("get_service_profiles()");
        }
    }

    @Override
    public ServiceProfile get_service_profile(String string) throws InvalidParameter, NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_service_profile(" + string + ")");
        try {
            if (string == null || string.equals("")) {
                throw new InvalidParameter("get_service_profile(): Empty name.");
            }
            ServiceProfile serviceProfile = this.m_pSdoConfigImpl.getServiceProfile(string);
            if (serviceProfile == null || !string.equals(serviceProfile.id)) {
                throw new InvalidParameter("get_service_profile(): Inexist id.");
            }
            ServiceProfileHolder serviceProfileHolder = new ServiceProfileHolder(serviceProfile);
            return serviceProfileHolder.value;
        }
        catch (InvalidParameter invalidParameter) {
            throw invalidParameter;
        }
        catch (Exception exception) {
            throw new InternalError("get_service_profile()");
        }
    }

    @Override
    public SDOService get_sdo_service(String string) throws InvalidParameter, NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_sdo_service(" + string + ")");
        try {
            if (string == null || string.equals("")) {
                throw new InvalidParameter("get_sdo_service(): Empty name.");
            }
            ServiceProfile serviceProfile = this.m_pSdoConfigImpl.getServiceProfile(string);
            if (serviceProfile == null || !string.equals(serviceProfile.id)) {
                throw new InvalidParameter("get_sdo_service(): Inexist id.");
            }
            SDOServiceHolder sDOServiceHolder = new SDOServiceHolder(serviceProfile.service);
            return sDOServiceHolder.value;
        }
        catch (InvalidParameter invalidParameter) {
            throw invalidParameter;
        }
        catch (Exception exception) {
            throw new InternalError("get_service_profile()");
        }
    }

    @Override
    public Configuration get_configuration() throws InterfaceNotImplemented, NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_configuration()");
        if (this.m_pSdoConfig == null) {
            throw new InterfaceNotImplemented();
        }
        try {
            Configuration configuration = this.m_pSdoConfig;
            return configuration;
        }
        catch (Exception exception) {
            throw new InternalError("get_configuration()");
        }
    }

    @Override
    public Monitoring get_monitoring() throws InterfaceNotImplemented, NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_monitoring()");
        throw new InterfaceNotImplemented();
    }

    @Override
    public Organization[] get_organizations() throws NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_organizations()");
        try {
            OrganizationListHolder organizationListHolder = new OrganizationListHolder(this.m_pSdoConfigImpl.getOrganizations().value);
            return organizationListHolder.value;
        }
        catch (Exception exception) {
            throw new InternalError("get_organizations()");
        }
    }

    @Override
    public NameValue[] get_status_list() throws NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_status_list()");
        if (this.m_sdoStatus.value == null) {
            NVListHolder nVListHolder = new NVListHolder();
            CORBA_SeqUtil.push_back(nVListHolder, NVUtil.newNV("", "", String.class));
            try {
                return (NameValue[])nVListHolder.value.clone();
            }
            catch (Exception exception) {
                throw new InternalError("get_status_list()");
            }
        }
        try {
            return (NameValue[])this.m_sdoStatus.value.clone();
        }
        catch (Exception exception) {
            throw new InternalError("get_status_list()");
        }
    }

    @Override
    public Any get_status(String string) throws InvalidParameter, NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_status(" + string + ")");
        int n = CORBA_SeqUtil.find(this.m_sdoStatus, (equalFunctor)new nv_name(string));
        if (n < 0) {
            throw new InvalidParameter("get_status(): Not found");
        }
        try {
            Any any = ORBUtil.getOrb().create_any();
            any = this.m_sdoStatus.value[n].value;
            return any;
        }
        catch (Exception exception) {
            throw new InternalError("get_status()");
        }
    }

    public final String getInstanceName() {
        this.rtcout.println(2, "RTObject_impl.getInstanceName()");
        return this.m_profile.instance_name;
    }

    public void setInstanceName(String string) {
        this.rtcout.println(2, "RTObject_impl.setInstanceName(" + string + ")");
        this.m_properties.setProperty("instance_name", string);
        this.m_profile.instance_name = this.m_properties.getProperty("instance_name");
    }

    public final String getTypeName() {
        this.rtcout.println(2, "RTObject_impl.getTypeName()");
        return this.m_profile.type_name;
    }

    public final String getCategory() {
        this.rtcout.println(2, "RTObject_impl.getCategory()");
        return this.m_profile.category;
    }

    public String[] getNamingNames() {
        this.rtcout.println(2, "RTObject_impl.getNamingNames()");
        return this.m_properties.getProperty("naming.names").split(",");
    }

    public void setObjRef(RTObject rTObject) {
        this.rtcout.println(2, "RTObject_impl.setObjRef()");
        this.m_objref = rTObject;
    }

    public final RTObject getObjRef() {
        this.rtcout.println(2, "RTObject_impl.getObjRef()");
        return (RTObject)this.m_objref._duplicate();
    }

    public void setProperties(Properties properties) {
        this.rtcout.println(2, "RTObject_impl.setProperties()");
        this.m_properties.merge(properties);
        try {
            this.syncAttributesByProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void syncAttributesByProperties() throws Exception {
        DeviceProfile deviceProfile = this.m_pSdoConfigImpl.getDeviceProfile();
        deviceProfile.device_type = this.m_properties.getProperty("category");
        deviceProfile.manufacturer = this.m_properties.getProperty("vendor");
        deviceProfile.model = this.m_properties.getProperty("type_name");
        deviceProfile.version = this.m_properties.getProperty("version");
        deviceProfile.properties = new NameValue[0];
        this.m_pSdoConfigImpl.set_device_profile(deviceProfile);
        this.m_profile.instance_name = this.m_properties.getProperty("instance_name");
        this.m_profile.type_name = this.m_properties.getProperty("type_name");
        this.m_profile.description = this.m_properties.getProperty("description");
        this.m_profile.version = this.m_properties.getProperty("version");
        this.m_profile.vendor = this.m_properties.getProperty("vendor");
        this.m_profile.category = this.m_properties.getProperty("category");
        this.m_profile.properties = new NameValue[0];
        this.m_profile.port_profiles = new PortProfile[0];
    }

    public Properties getProperties() {
        this.rtcout.println(2, "RTObject_impl.getProperties()");
        return this.m_properties;
    }

    public boolean bindParameter(String string, ValueHolder valueHolder, String string2) {
        this.rtcout.println(2, "RTObject_impl.bindParameter(" + string + "," + string2 + ")");
        this.m_configsets.bindParameter(string, valueHolder, string2);
        return true;
    }

    public void updateParameters(String string) {
        this.rtcout.println(2, "RTObject_impl.updateParameters(" + string + ")");
        this.m_configsets.update(string);
    }

    public void registerPort(PortBase portBase) {
        this.rtcout.println(2, "RTObject_impl.registerPort(PortBase)");
        this.m_portAdmin.registerPort(portBase);
        portBase.setOwner(this.getObjRef());
    }

    public void registerPort(PortService portService) {
        this.rtcout.println(2, "RTObject_impl.registerPort(PortService)");
        this.m_portAdmin.registerPort(portService);
    }

    public <DataType, Buffer> void registerInPort(Class<DataType> clazz, String string, InPort<DataType> inPort) throws Exception {
        this.rtcout.println(2, "RTObject_impl.registerInPort()");
        this.registerInPort(string, inPort);
    }

    public void registerInPort(String string, InPortBase inPortBase) throws Exception {
        String string2;
        this.rtcout.println(2, "RTObject_impl.registerInPort()");
        if (this.m_properties.hasKey("port.inport") != null) {
            inPortBase.properties().merge(this.m_properties.getNode("port.inport"));
        }
        if (this.m_properties.hasKey(string2 = "port.inport." + string) != null) {
            inPortBase.properties().merge(this.m_properties.getNode(string2));
        }
        inPortBase.init();
        this.registerPort(inPortBase);
    }

    public <DataType, Buffer> void registerOutPort(Class<DataType> clazz, String string, OutPort<DataType> outPort) throws Exception {
        this.rtcout.println(2, "RTObject_impl.registerOutPort()");
        this.registerOutPort(string, outPort);
    }

    public void registerOutPort(String string, OutPortBase outPortBase) throws Exception {
        this.rtcout.println(2, "RTObject_impl.registerOutPort()");
        String string2 = "port.outport." + string;
        this.m_properties.getNode(string2).merge(this.m_properties.getNode("port.outport.dataport"));
        outPortBase.properties().merge(this.m_properties.getNode(string2));
        this.registerPort(outPortBase);
    }

    public void deletePort(PortBase portBase) {
        this.rtcout.println(2, "RTObject_impl.deletePort(PortBase)");
        this.m_portAdmin.deletePort(portBase);
    }

    public void deletePort(PortService portService) {
        this.rtcout.println(2, "RTObject_impl.deletePort(PortService)");
        this.m_portAdmin.deletePort(portService);
    }

    public void deletePortByName(String string) {
        this.rtcout.println(2, "RTObject_impl.deletePortByNamed(" + string + ")");
        this.m_portAdmin.deletePortByName(string);
    }

    public void finalizePorts() {
        this.rtcout.println(2, "RTObject_impl.finalizePorts()");
        this.m_portAdmin.finalizePorts();
    }

    public void finalizeContexts() {
        this.rtcout.println(2, "RTObject_impl.finalizeContexts()");
        int n = this.m_eclist.size();
        for (int i = 0; i < n; ++i) {
            try {
                this.m_eclist.elementAt(i).stop();
                this.m_pPOA.deactivate_object(this.m_pPOA.servant_to_id((Servant)this.m_eclist.elementAt(i)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.m_eclist.isEmpty()) {
            this.m_eclist.clear();
        }
    }

    protected void shutdown() {
        try {
            this.finalizePorts();
            this.finalizeContexts();
            this.m_pPOA.deactivate_object(this.m_pPOA.servant_to_id((Servant)this.m_pSdoConfigImpl));
            this.m_pPOA.deactivate_object(this.m_pPOA.servant_to_id((Servant)this));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_pManager != null) {
            this.m_pManager.cleanupComponent(this);
        }
    }

    class deactivate_comps
    implements operatorFunc {
        LightweightRTObject m_comp;

        deactivate_comps(LightweightRTObject lightweightRTObject) {
            this.m_comp = lightweightRTObject;
        }

        @Override
        public void operator(Object object) {
            this.operator((ExecutionContextService)object);
        }

        void operator(ExecutionContextService executionContextService) {
            executionContextService.deactivate_component((LightweightRTObject)this.m_comp._duplicate());
        }
    }

    class ec_find
    implements equalFunctor {
        private ExecutionContext m_ec;

        public ec_find(ExecutionContext executionContext) {
            this.m_ec = executionContext;
        }

        @Override
        public boolean equalof(Object object) {
            return this.operator((ExecutionContextService)object);
        }

        public boolean operator(ExecutionContextService executionContextService) {
            try {
                ExecutionContext executionContext = ExecutionContextHelper.narrow(executionContextService);
                return this.m_ec._is_equivalent(executionContext);
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    class ec_copy
    implements operatorFunc {
        private ExecutionContextListHolder m_eclist;

        public ec_copy(ExecutionContextListHolder executionContextListHolder) {
            this.m_eclist = executionContextListHolder;
        }

        @Override
        public void operator(Object object) {
            this.operator((ExecutionContextService)object);
        }

        public void operator(ExecutionContextService executionContextService) {
            CORBA_SeqUtil.push_back(this.m_eclist, (ExecutionContext)executionContextService._duplicate());
        }
    }

    class nv_name
    implements equalFunctor {
        private String m_name;

        public nv_name(String string) {
            this.m_name = string;
        }

        @Override
        public boolean equalof(Object object) {
            return this.m_name.equals(((NameValue)object).name);
        }
    }
}

