/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import jp.go.aist.rtm.RTC.ObjectCreator;
import jp.go.aist.rtm.RTC.ObjectDestructor;
import jp.go.aist.rtm.RTC.PeriodicTaskBase;
import jp.go.aist.rtm.RTC.PeriodicTaskFactory;
import jp.go.aist.rtm.RTC.TaskFuncBase;
import jp.go.aist.rtm.RTC.TimeMeasure;
import jp.go.aist.rtm.RTC.util.TimeValue;

public class PeriodicTask
extends PeriodicTaskBase
implements ObjectCreator<PeriodicTaskBase>,
ObjectDestructor {
    protected TimeValue m_period = new TimeValue(0.0);
    protected boolean m_nowait = false;
    protected TaskFuncBase m_func = null;
    protected boolean m_deleteInDtor = true;
    protected alive_t m_alive = new alive_t(false);
    protected suspend_t m_suspend = new suspend_t(false);
    protected boolean m_execMeasure;
    protected int m_execCount = 0;
    protected int m_execCountMax = 10;
    protected statistics_t m_execStat;
    protected TimeMeasure m_execTime = new TimeMeasure();
    protected boolean m_periodMeasure;
    protected int m_periodCount = 0;
    protected int m_periodCountMax = 10;
    protected statistics_t m_periodStat;
    protected TimeMeasure m_periodTime;

    public PeriodicTask() {
        this.m_execStat = new statistics_t();
        this.m_execStat.stat = this.m_execTime.getStatistics();
        this.m_periodTime = new TimeMeasure();
        this.m_periodStat = new statistics_t();
        this.m_periodStat.stat = this.m_periodTime.getStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate() {
        String string = this.m_alive.mutex;
        synchronized (string) {
            if (this.m_func == null) {
                return;
            }
            if (this.m_alive.value) {
                return;
            }
            this.m_alive.value = true;
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _finalize() {
        String string = this.m_alive.mutex;
        synchronized (string) {
            this.m_alive.value = false;
        }
        string = this.m_suspend.mutex;
        synchronized (string) {
            this.m_suspend.suspend = false;
            try {
                this.m_suspend.mutex.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int _suspend() {
        String string = this.m_suspend.mutex;
        synchronized (string) {
            this.m_suspend.suspend = true;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int _resume() {
        this.m_periodTime.reset();
        this.m_execTime.reset();
        String string = this.m_suspend.mutex;
        synchronized (string) {
            this.m_suspend.suspend = false;
            try {
                this.m_suspend.mutex.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signal() {
        String string = this.m_suspend.mutex;
        synchronized (string) {
            try {
                this.m_suspend.mutex.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean setTask(Object object, String string, boolean bl) {
        if (object == null) {
            return false;
        }
        this.m_deleteInDtor = bl;
        this.m_func = new TaskFuncBase(object, string);
        return true;
    }

    @Override
    public boolean setTask(Object object) {
        return this.setTask(object, "svc", true);
    }

    @Override
    public boolean setTask(Object object, String string) {
        return this.setTask(object, string, true);
    }

    @Override
    public boolean setTask(Object object, boolean bl) {
        return this.setTask(object, "svc", bl);
    }

    @Override
    public void setPeriod(double d) {
        this.m_period.convert(d);
        if (this.m_period.sec() == 0L && this.m_period.usec() == 0L) {
            this.m_nowait = true;
            return;
        }
        this.m_nowait = false;
    }

    @Override
    public void setPeriod(TimeValue timeValue) {
        this.m_period = timeValue;
        if (this.m_period.sec() == 0L && this.m_period.usec() == 0L) {
            this.m_nowait = true;
            return;
        }
        this.m_nowait = false;
    }

    @Override
    public void executionMeasure(boolean bl) {
        this.m_execMeasure = bl;
    }

    @Override
    public void executionMeasureCount(int n) {
        this.m_execCountMax = n;
    }

    @Override
    public void periodicMeasure(boolean bl) {
        this.m_periodMeasure = bl;
    }

    @Override
    public void periodicMeasureCount(int n) {
        this.m_periodCountMax = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeMeasure.Statistics getExecStat() {
        String string = this.m_execStat.mutex;
        synchronized (string) {
            return this.m_execStat.stat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeMeasure.Statistics getPeriodStat() {
        String string = this.m_periodStat.mutex;
        synchronized (string) {
            return this.m_periodStat.stat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int svc() {
        while (this.m_alive.value) {
            if (this.m_periodMeasure) {
                this.m_periodTime.tack();
            }
            String string = this.m_suspend.mutex;
            synchronized (string) {
                if (this.m_suspend.suspend) {
                    try {
                        this.m_suspend.mutex.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.m_alive.value) {
                        return 0;
                    }
                }
            }
            if (this.m_periodMeasure) {
                this.m_periodTime.tick();
            }
            if (this.m_execMeasure) {
                this.m_execTime.tick();
            }
            this.m_func.svc();
            if (this.m_execMeasure) {
                this.m_execTime.tack();
            }
            this.updateExecStat();
            this.sleep();
            this.updatePeriodStat();
        }
        return 0;
    }

    @Override
    public void run() {
        this.svc();
    }

    protected void sleep() {
        if (this.m_nowait) {
            return;
        }
        TimeValue timeValue = new TimeValue(this.m_period.toDouble() - this.m_execTime.interval().toDouble());
        if (timeValue.toDouble() < 0.0) {
            return;
        }
        try {
            PeriodicTask.sleep((long)(timeValue.toDouble() * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateExecStat() {
        if (this.m_execCount > this.m_execCountMax) {
            String string = this.m_execStat.mutex;
            synchronized (string) {
                this.m_execStat.stat = this.m_execTime.getStatistics();
                this.m_execCount = 0;
            }
        }
        ++this.m_execCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePeriodStat() {
        if (this.m_periodCount > this.m_periodCountMax) {
            String string = this.m_periodStat.mutex;
            synchronized (string) {
                this.m_periodStat.stat = this.m_periodTime.getStatistics();
                this.m_periodCount = 0;
            }
        }
        ++this.m_periodCount;
    }

    @Override
    public PeriodicTaskBase creator_() {
        return new PeriodicTask();
    }

    @Override
    public void destructor_(Object object) {
        PeriodicTaskBase periodicTaskBase = (PeriodicTaskBase)object;
        periodicTaskBase._finalize();
        try {
            periodicTaskBase.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        object = null;
    }

    public static void PeriodicTaskInit() {
        PeriodicTaskFactory periodicTaskFactory = PeriodicTaskFactory.instance();
        periodicTaskFactory.addFactory("default", new PeriodicTask(), new PeriodicTask());
    }

    protected class statistics_t {
        public TimeMeasure.Statistics stat;
        public String mutex = new String();

        protected statistics_t() {
        }
    }

    protected class suspend_t {
        public boolean suspend;
        public String mutex = new String();

        public suspend_t(boolean bl) {
            this.suspend = bl;
        }
    }

    protected class alive_t {
        public boolean value;
        public String mutex = new String();

        public alive_t(boolean bl) {
            this.value = bl;
        }
    }
}

