/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import RTC.ConnectorProfile;
import RTC.ConnectorProfileHolder;
import RTC.ReturnCode_t;
import _SDOPackage.NVListHolder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import jp.go.aist.rtm.RTC.InPortConsumerFactory;
import jp.go.aist.rtm.RTC.OutPortProviderFactory;
import jp.go.aist.rtm.RTC.PublisherBaseFactory;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.port.ConnectorBase;
import jp.go.aist.rtm.RTC.port.ConnectorDataListenerT;
import jp.go.aist.rtm.RTC.port.ConnectorDataListenerType;
import jp.go.aist.rtm.RTC.port.ConnectorListener;
import jp.go.aist.rtm.RTC.port.ConnectorListenerType;
import jp.go.aist.rtm.RTC.port.ConnectorListeners;
import jp.go.aist.rtm.RTC.port.InPortConsumer;
import jp.go.aist.rtm.RTC.port.OutPortConnector;
import jp.go.aist.rtm.RTC.port.OutPortProvider;
import jp.go.aist.rtm.RTC.port.OutPortPullConnector;
import jp.go.aist.rtm.RTC.port.OutPortPushConnector;
import jp.go.aist.rtm.RTC.port.PortBase;
import jp.go.aist.rtm.RTC.port.publisher.PublisherBase;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.StringUtil;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.portable.OutputStream;

public abstract class OutPortBase
extends PortBase {
    protected List<Publisher> m_publishers = new ArrayList<Publisher>();
    protected Properties m_properties = new Properties();
    protected Vector<OutPortConnector> m_connectors = new Vector();
    protected Vector<String> m_providerTypes = new Vector();
    protected Vector<String> m_consumerTypes = new Vector();
    private boolean m_isLittleEndian = true;
    protected ConnectorListeners m_listeners = new ConnectorListeners();

    public OutPortBase(String string, String string2) {
        super(string);
        this.rtcout.println(3, "Port name: " + string);
        this.rtcout.println(3, "setting port.port_type: DataOutPort");
        this.addProperty("port.port_type", "DataOutPort", String.class);
        this.rtcout.println(3, "setting dataport.data_type: " + string2);
        this.addProperty("dataport.data_type", string2, String.class);
        PublisherBaseFactory publisherBaseFactory = PublisherBaseFactory.instance();
        String string3 = StringUtil.flatten(publisherBaseFactory.getIdentifiers());
        string3 = string3.trim();
        this.rtcout.println(3, "available subscription_type: " + string3);
        this.addProperty("dataport.subscription_type", string3, String.class);
    }

    public void init(Properties properties) {
        this.rtcout.println(2, "init()");
        this.rtcout.println(0, "given properties:");
        String string = new String();
        properties._dump(string, properties, 0);
        this.rtcout.println(3, string);
        this.m_properties.merge(properties);
        this.rtcout.println(0, "updated properties:");
        string = "";
        this.m_properties._dump(string, this.m_properties, 0);
        this.rtcout.println(3, string);
        this.configure();
        this.initConsumers();
        this.initProviders();
        int n = -1;
        String string2 = this.m_properties.getProperty("connection_limit", "-1");
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            this.rtcout.println(6, "invalid connection_limit value: " + string2);
        }
        this.setConnectionLimit(n);
    }

    public abstract boolean write();

    public Properties properties() {
        this.rtcout.println(2, "properties()");
        return this.m_properties;
    }

    public final Vector<OutPortConnector> connectors() {
        this.rtcout.println(2, "connectors(): size = " + this.m_connectors.size());
        return this.m_connectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<ConnectorBase.ConnectorInfo> getConnectorProfiles() {
        this.rtcout.println(2, "getConnectorProfiles(): size = " + this.m_connectors.size());
        Vector<ConnectorBase.ConnectorInfo> vector = new Vector<ConnectorBase.ConnectorInfo>();
        Vector<OutPortConnector> vector2 = this.m_connectors;
        synchronized (vector2) {
            int n = this.m_connectors.size();
            for (int i = 0; i < n; ++i) {
                vector.add(this.m_connectors.elementAt(i).profile());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> getConnectorIds() {
        Vector<String> vector = new Vector<String>();
        Vector<OutPortConnector> vector2 = this.m_connectors;
        synchronized (vector2) {
            int n = this.m_connectors.size();
            for (int i = 0; i < n; ++i) {
                vector.add(this.m_connectors.elementAt(i).id());
            }
        }
        this.rtcout.println(2, "getConnectorIds(): " + vector.toString());
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> getConnectorNames() {
        Vector<String> vector = new Vector<String>();
        Vector<OutPortConnector> vector2 = this.m_connectors;
        synchronized (vector2) {
            int n = this.m_connectors.size();
            for (int i = 0; i < n; ++i) {
                vector.add(this.m_connectors.elementAt(i).name());
            }
        }
        this.rtcout.println(2, "getConnectorNames(): " + vector.toString());
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutPortConnector getConnectorById(String string) {
        this.rtcout.println(2, "getConnectorById(id = " + string + ")");
        String string2 = string;
        Vector<OutPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            int n = this.m_connectors.size();
            for (int i = 0; i < n; ++i) {
                if (!string2.equals(this.m_connectors.elementAt(i).id())) continue;
                return this.m_connectors.elementAt(i);
            }
        }
        this.rtcout.println(5, "ConnectorProfile with the id(" + string + ") not found.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OutPortConnector getConnectorByName(String string) {
        this.rtcout.println(2, "getConnectorByName(name = " + string + ")");
        String string2 = string;
        Vector<OutPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            int n = this.m_connectors.size();
            for (int i = 0; i < n; ++i) {
                if (!string2.equals(this.m_connectors.elementAt(i).name())) continue;
                return this.m_connectors.elementAt(i);
            }
        }
        this.rtcout.println(5, "ConnectorProfile with the name(" + string + ") not found.");
        return null;
    }

    public boolean getConnectorProfileById(String string, ConnectorBase.ConnectorInfoHolder connectorInfoHolder) {
        this.rtcout.println(2, "getConnectorProfileById(id = " + string + ")");
        OutPortConnector outPortConnector = this.getConnectorById(string);
        if (outPortConnector == null) {
            return false;
        }
        connectorInfoHolder.value = outPortConnector.profile();
        return true;
    }

    public boolean getConnectorProfileByName(String string, ConnectorBase.ConnectorInfoHolder connectorInfoHolder) {
        this.rtcout.println(2, "getConnectorProfileByNmae(name = " + string + ")");
        OutPortConnector outPortConnector = this.getConnectorByName(string);
        if (outPortConnector == null) {
            return false;
        }
        connectorInfoHolder.value = outPortConnector.profile();
        return true;
    }

    public void onConnect(String string, PublisherBase publisherBase) {
    }

    public void onDisconnect(String string) {
    }

    @Override
    public ReturnCode_t connect(ConnectorProfileHolder connectorProfileHolder) {
        int n;
        NVListHolder nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
        Properties properties = new Properties();
        NVUtil.copyToProperties(properties, nVListHolder);
        if (null != properties.findNode("dataport") && (n = NVUtil.find_index(nVListHolder, "dataport.serializer.cdr.endian")) < 0) {
            CORBA_SeqUtil.push_back(nVListHolder, NVUtil.newNVString("dataport.serializer.cdr.endian", "little,big"));
            connectorProfileHolder.value.properties = nVListHolder.value;
        }
        return super.connect(connectorProfileHolder);
    }

    @Override
    protected ReturnCode_t publishInterfaces(ConnectorProfileHolder connectorProfileHolder) {
        Object object;
        Object object2;
        Object object3;
        this.rtcout.println(2, "publishInterfaces()");
        ReturnCode_t returnCode_t = this._publishInterfaces();
        if (returnCode_t != ReturnCode_t.RTC_OK) {
            return returnCode_t;
        }
        Properties properties = this.m_properties;
        Object object4 = new Properties();
        NVListHolder nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
        NVUtil.copyToProperties((Properties)object4, nVListHolder);
        properties.merge(((Properties)object4).getNode("dataport"));
        properties.merge(((Properties)object4).getNode("dataport.outport"));
        this.rtcout.println(3, "ConnectorProfile::properties are as follows.");
        object4 = new String();
        object4 = properties._dump((String)object4, properties, 0);
        this.rtcout.println(3, (String)object4);
        nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
        try {
            int n;
            object3 = NVUtil.find(nVListHolder, "dataport.serializer.cdr.endian");
            object2 = object3.type().kind() == TCKind.tk_wstring ? object3.extract_wstring() : object3.extract_string();
            object2 = StringUtil.normalize((String)object2);
            object = ((String)object2).split(",");
            object2 = "";
            for (n = 0; n < ((String[])object).length; ++n) {
                String string = object[n].trim();
                if (!string.equals("big") && !string.equals("little")) continue;
                object2 = ((String)object2).length() != 0 ? (String)object2 + "," + string : (String)object2 + string;
            }
            n = NVUtil.find_index(nVListHolder, "dataport.serializer.cdr.endian");
            nVListHolder.value[n].value.insert_string((String)object2);
            connectorProfileHolder.value.properties = nVListHolder.value;
        }
        catch (Exception exception) {
            // empty catch block
        }
        object3 = properties.getProperty("dataflow_type");
        object3 = StringUtil.normalize((String)object3);
        if (((String)object3).equals("push")) {
            this.rtcout.println(3, "dataflow_type = push .... do nothing");
            return ReturnCode_t.RTC_OK;
        }
        if (((String)object3).equals("pull")) {
            this.rtcout.println(3, "dataflow_type = pull .... create PushConnector");
            object2 = this.createProvider(connectorProfileHolder, properties);
            if (object2 == null) {
                return ReturnCode_t.BAD_PARAMETER;
            }
            object = this.createConnector(connectorProfileHolder, properties, (OutPortProvider)object2);
            if (object == null) {
                return ReturnCode_t.RTC_ERROR;
            }
            object2.setConnector((OutPortConnector)object);
            ((OutPortConnector)object).setOutPortBase(this);
            this.rtcout.println(3, "publishInterface() successfully finished.");
            return ReturnCode_t.RTC_OK;
        }
        this.rtcout.println(6, "unsupported dataflow_type");
        return ReturnCode_t.BAD_PARAMETER;
    }

    @Override
    protected ReturnCode_t subscribeInterfaces(ConnectorProfileHolder connectorProfileHolder) {
        Object object;
        Object object2;
        Object object3;
        this.rtcout.println(2, "subscribeInterfaces()");
        Properties properties = this.m_properties;
        Object object4 = new Properties();
        NVListHolder nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
        NVUtil.copyToProperties((Properties)object4, nVListHolder);
        properties.merge(((Properties)object4).getNode("dataport"));
        properties.merge(((Properties)object4).getNode("dataport.outport"));
        this.rtcout.println(3, "ConnectorProfile::properties are as follows.");
        object4 = new String();
        object4 = properties._dump((String)object4, properties, 0);
        this.rtcout.println(3, (String)object4);
        nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
        try {
            object3 = NVUtil.find(nVListHolder, "dataport.serializer.cdr.endian");
            object2 = object3.type().kind() == TCKind.tk_wstring ? object3.extract_wstring() : object3.extract_string();
            object2 = StringUtil.normalize((String)object2);
            object = ((String)object2).split(",");
            String string = object[0].trim();
            if (string.length() == 0) {
                this.rtcout.println(6, "unsupported endian");
                return ReturnCode_t.UNSUPPORTED;
            }
            this.m_isLittleEndian = string.equals("little") ? true : !string.equals("big");
        }
        catch (Exception exception) {
            this.m_isLittleEndian = true;
        }
        this.rtcout.println(2, "Little Endian = " + this.m_isLittleEndian);
        object3 = properties.getProperty("dataflow_type");
        object3 = StringUtil.normalize((String)object3);
        if (((String)object3).equals("push")) {
            this.rtcout.println(3, "dataflow_type is push.");
            object2 = this.createConsumer(connectorProfileHolder, properties);
            if (object2 == null) {
                return ReturnCode_t.BAD_PARAMETER;
            }
            object = this.createConnector(connectorProfileHolder, properties, (InPortConsumer)object2);
            if (object == null) {
                return ReturnCode_t.RTC_ERROR;
            }
            object2.setConnector((OutPortConnector)object);
            ((OutPortConnector)object).setOutPortBase(this);
            this.rtcout.println(3, "publishInterface() successfully finished.");
            ((OutPortConnector)object).setEndian(this.m_isLittleEndian);
            return ReturnCode_t.RTC_OK;
        }
        if (((String)object3).equals("pull")) {
            this.rtcout.println(3, "dataflow_type is pull.");
            object2 = this.getConnectorById(connectorProfileHolder.value.connector_id);
            if (object2 == null) {
                this.rtcout.println(6, "specified connector not found: " + connectorProfileHolder.value.connector_id);
                return ReturnCode_t.RTC_ERROR;
            }
            ((OutPortConnector)object2).setEndian(this.m_isLittleEndian);
            this.rtcout.println(3, "subscribeInterfaces() successfully finished.");
            return ReturnCode_t.RTC_OK;
        }
        this.rtcout.println(6, "unsupported dataflow_type:" + (String)object3);
        return ReturnCode_t.BAD_PARAMETER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unsubscribeInterfaces(ConnectorProfile connectorProfile) {
        this.rtcout.println(2, "unsubscribeInterfaces()");
        String string = connectorProfile.connector_id;
        this.rtcout.println(0, "connector_id: " + string);
        Vector<OutPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            Iterator<OutPortConnector> iterator = this.m_connectors.iterator();
            while (iterator.hasNext()) {
                OutPortConnector outPortConnector = iterator.next();
                if (!string.equals(outPortConnector.id())) continue;
                outPortConnector.disconnect();
                iterator.remove();
                this.rtcout.println(2, "delete connector: " + string);
                return;
            }
        }
        this.rtcout.println(6, "specified connector not found: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateInterfaces() {
        Vector<OutPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            int n = this.m_connectors.size();
            for (int i = 0; i < n; ++i) {
                this.m_connectors.elementAt(i).activate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivateInterfaces() {
        Vector<OutPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            int n = this.m_connectors.size();
            for (int i = 0; i < n; ++i) {
                this.m_connectors.elementAt(i).deactivate();
            }
        }
    }

    public void addConnectorDataListener(int n, ConnectorDataListenerT connectorDataListenerT, boolean bl) {
        if (n < 10) {
            this.rtcout.println(2, "addConnectorDataListener(" + ConnectorDataListenerType.toString(n) + ")");
            this.m_listeners.connectorData_[n].addObserver(connectorDataListenerT);
            return;
        }
        this.rtcout.println(6, "addConnectorDataListener(): Invalid listener type.");
    }

    public void addConnectorDataListener(int n, ConnectorDataListenerT connectorDataListenerT) {
        this.addConnectorDataListener(n, connectorDataListenerT, true);
    }

    public void removeConnectorDataListener(int n, ConnectorDataListenerT connectorDataListenerT) {
        if (n < 10) {
            this.rtcout.println(2, "removeConnectorDataListener(" + ConnectorDataListenerType.toString(n) + ")");
            this.m_listeners.connectorData_[n].deleteObserver(connectorDataListenerT);
            return;
        }
        this.rtcout.println(6, "removeConnectorDataListener(): Invalid listener type.");
    }

    public void addConnectorListener(int n, ConnectorListener connectorListener, boolean bl) {
        if (n < 7) {
            this.rtcout.println(2, "addConnectorListener(" + ConnectorListenerType.toString(n) + ")");
            this.m_listeners.connector_[n].addObserver(connectorListener);
            return;
        }
        this.rtcout.println(6, "addConnectorListener(): Invalid listener type.");
    }

    public void addConnectorListener(int n, ConnectorListener connectorListener) {
        this.addConnectorListener(n, connectorListener, true);
    }

    public void removeConnectorListener(int n, ConnectorListener connectorListener) {
        if (n < 7) {
            this.rtcout.println(2, "removeConnectorListener(" + ConnectorListenerType.toString(n) + ")");
            this.m_listeners.connector_[n].deleteObserver(connectorListener);
            return;
        }
        this.rtcout.println(6, "removeConnectorListener(): Invalid listener type.");
    }

    protected void configure() {
    }

    protected void initProviders() {
        Object object;
        this.rtcout.println(2, "initProviders()");
        OutPortProviderFactory outPortProviderFactory = OutPortProviderFactory.instance();
        Set set = outPortProviderFactory.getIdentifiers();
        this.rtcout.println(3, "available providers: " + set.toString());
        String string = StringUtil.normalize(this.m_properties.getProperty("provider_types"));
        if (this.m_properties.hasKey("provider_types") != null && !string.equals("all")) {
            this.rtcout.println(3, "allowed providers: " + this.m_properties.getProperty("provider_types"));
            object = set;
            set.clear();
            Vector<String> vector = StringUtil.split(this.m_properties.getProperty("provider_types"), ",");
            HashSet hashSet = new HashSet(object);
            HashSet<String> hashSet2 = new HashSet<String>(vector);
            for (String string2 : hashSet) {
                if (!hashSet2.contains(string2)) continue;
                set.add(string2);
            }
        }
        if (set.size() > 0) {
            this.rtcout.println(3, "dataflow_type pull is supported");
            this.appendProperty("dataport.dataflow_type", "pull");
            this.appendProperty("dataport.interface_type", StringUtil.flatten(set));
        }
        object = set.iterator();
        while (object.hasNext()) {
            this.m_providerTypes.add((String)object.next());
        }
    }

    protected void initConsumers() {
        Object object;
        this.rtcout.println(2, "initConsumers()");
        InPortConsumerFactory inPortConsumerFactory = InPortConsumerFactory.instance();
        Set set = inPortConsumerFactory.getIdentifiers();
        this.rtcout.println(3, "available InPortConsumer: " + set.toString());
        String string = StringUtil.normalize(this.m_properties.getProperty("consumer_types"));
        if (this.m_properties.hasKey("consumer_types") != null && !string.equals("all")) {
            this.rtcout.println(3, "allowed consumers: " + this.m_properties.getProperty("consumer_types"));
            object = set;
            set.clear();
            Vector<String> vector = StringUtil.split(this.m_properties.getProperty("consumer_types"), ",");
            HashSet hashSet = new HashSet(object);
            HashSet<String> hashSet2 = new HashSet<String>(vector);
            for (String string2 : hashSet) {
                if (!hashSet2.contains(string2)) continue;
                set.add(string2);
            }
        }
        if (set.size() > 0) {
            this.rtcout.println(3, "dataflow_type pull is supported");
            this.appendProperty("dataport.dataflow_type", "push");
            this.appendProperty("dataport.interface_type", StringUtil.flatten(set));
        }
        object = set.iterator();
        while (object.hasNext()) {
            this.m_consumerTypes.add((String)object.next());
        }
    }

    protected OutPortProvider createProvider(ConnectorProfileHolder connectorProfileHolder, Properties properties) {
        if (properties.getProperty("interface_type").length() != 0 && !StringUtil.includes(this.m_providerTypes, properties.getProperty("interface_type"), true)) {
            this.rtcout.println(6, "no provider found");
            this.rtcout.println(6, "interface_type:  " + properties.getProperty("interface_type"));
            this.rtcout.println(6, "interface_types:  " + this.m_providerTypes.toString());
            return null;
        }
        this.rtcout.println(3, "interface_type:  " + properties.getProperty("interface_type"));
        OutPortProviderFactory outPortProviderFactory = OutPortProviderFactory.instance();
        OutPortProvider outPortProvider = (OutPortProvider)outPortProviderFactory.createObject(properties.getProperty("interface_type"));
        if (outPortProvider != null) {
            this.rtcout.println(3, "provider created");
            outPortProvider.init(properties.getNode("provider"));
            NVListHolder nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
            if (!outPortProvider.publishInterface(nVListHolder)) {
                this.rtcout.println(6, "publishing interface information error");
                outPortProviderFactory.deleteObject(outPortProvider);
                return null;
            }
            connectorProfileHolder.value.properties = nVListHolder.value;
            return outPortProvider;
        }
        this.rtcout.println(6, "provider creation failed");
        return null;
    }

    protected InPortConsumer createConsumer(ConnectorProfileHolder connectorProfileHolder, Properties properties) {
        if (properties.getProperty("interface_type").length() != 0 && !StringUtil.includes(this.m_consumerTypes, properties.getProperty("interface_type"), true)) {
            this.rtcout.println(6, "no consumer found");
            this.rtcout.println(6, "interface_type:  " + properties.getProperty("interface_type"));
            this.rtcout.println(6, "interface_types:  " + this.m_consumerTypes.toString());
            return null;
        }
        this.rtcout.println(3, "interface_type:  " + properties.getProperty("interface_type"));
        InPortConsumerFactory inPortConsumerFactory = InPortConsumerFactory.instance();
        InPortConsumer inPortConsumer = (InPortConsumer)inPortConsumerFactory.createObject(properties.getProperty("interface_type"));
        if (inPortConsumer != null) {
            this.rtcout.println(3, "consumer created");
            inPortConsumer.init(properties.getNode("consumer"));
            NVListHolder nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
            if (!inPortConsumer.subscribeInterface(nVListHolder)) {
                this.rtcout.println(6, "interface subscription failed.");
                inPortConsumerFactory.deleteObject(inPortConsumer);
                return null;
            }
            return inPortConsumer;
        }
        this.rtcout.println(6, "consumer creation failed");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutPortConnector createConnector(ConnectorProfileHolder connectorProfileHolder, Properties properties, InPortConsumer inPortConsumer) {
        ConnectorBase.ConnectorInfo connectorInfo = new ConnectorBase.ConnectorInfo(connectorProfileHolder.value.name, connectorProfileHolder.value.connector_id, CORBA_SeqUtil.refToVstring(connectorProfileHolder.value.ports), properties);
        OutPortPushConnector outPortPushConnector = null;
        Vector<OutPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            try {
                BufferBase<OutputStream> bufferBase = null;
                outPortPushConnector = new OutPortPushConnector(connectorInfo, inPortConsumer, this.m_listeners, bufferBase);
                if (outPortPushConnector == null) {
                    this.rtcout.println(6, "old compiler? new returned 0;");
                    return null;
                }
                this.rtcout.println(2, "OutPortPushConnector create");
                this.m_connectors.add(outPortPushConnector);
                this.rtcout.println(0, "connector push backed: " + this.m_connectors.size());
                return outPortPushConnector;
            }
            catch (Exception exception) {
                this.rtcout.println(6, "OutPortPushConnector creation failed");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutPortConnector createConnector(ConnectorProfileHolder connectorProfileHolder, Properties properties, OutPortProvider outPortProvider) {
        ConnectorBase.ConnectorInfo connectorInfo = new ConnectorBase.ConnectorInfo(connectorProfileHolder.value.name, connectorProfileHolder.value.connector_id, CORBA_SeqUtil.refToVstring(connectorProfileHolder.value.ports), properties);
        OutPortPullConnector outPortPullConnector = null;
        Vector<OutPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            try {
                BufferBase<OutputStream> bufferBase = null;
                outPortPullConnector = new OutPortPullConnector(connectorInfo, outPortProvider, this.m_listeners, bufferBase);
                if (outPortPullConnector == null) {
                    this.rtcout.println(6, "old compiler? new returned 0;");
                    return null;
                }
                this.rtcout.println(2, "OutPortPullConnector create");
                this.m_connectors.add(outPortPullConnector);
                this.rtcout.println(0, "connector push backed: " + this.m_connectors.size());
                return outPortPullConnector;
            }
            catch (Exception exception) {
                this.rtcout.println(6, "OutPortPullConnector creation failed");
                return null;
            }
        }
    }

    public boolean isLittleEndian() {
        return this.m_isLittleEndian;
    }

    protected class Publisher {
        public String id;
        public PublisherBase publisher;

        public Publisher(String string, PublisherBase publisherBase) {
            this.id = string;
            this.publisher = publisherBase;
        }
    }
}

