// -*- C++ -*-
/*!
 * @file DynamicLib_posix.h
 * @brief DynamicLib class
 * @date $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2008 Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#ifndef COIL_DYNAMICLIB_H
#define COIL_DYNAMICLIB_H

#include <dlfcn.h>
#include <string>
#include <coil/config_coil.h>

#define COIL_DEFAULT_DYNLIB_MODE RTLD_LAZY

extern "C"
{
  int ForExternTest(void);
}

namespace coil
{
  /*!
   * @if jp
   *
   * @class DynamicLib
   * @brief DynamicLib 饹
   *
   * @else
   *
   * @class DynamicLib
   * @brief DynamicLib class
   *
   * @endif
   */
  class DynamicLib
  {
  public:

    /*!
     * @if jp
     *
     * @brief 󥹥ȥ饯
     *
     * 󥹥ȥ饯
     *
     * @param close_handle_on_destruction ե饰
     *
     * @else
     *
     * @brief Constructor
     *
     * Constructor
     *
     * @param close_handle_on_destruction Close flag.
     *
     * @endif
     */
    DynamicLib(int close_handle_on_destruction = 1);

    /*!
     * @if jp
     *
     * @brief 󥹥ȥ饯
     *
     * 󥹥ȥ饯
     *
     * @param dynlib_name ưŪ󥯥饤֥̾
     * @param open_mode ץ⡼
     * @param close_handle_on_destruction ե饰
     *
     * @else
     *
     * @brief Constructor
     *
     * Constructor
     *
     * @param dynlib_name Dynamic link library name.
     * @param open_mode Open mode.
     * @param close_handle_on_destruction Close flag.
     *
     * @endif
     */
    DynamicLib(const char* dynlib_name,
               int open_mode = COIL_DEFAULT_DYNLIB_MODE,
               int close_handle_on_destruction = 1);

    /*!
     * @if jp
     *
     * @brief ǥȥ饯
     *
     * ǥȥ饯
     *
     * @else
     *
     * @brief Destructor
     *
     * Destructor
     *
     * @endif
     */
    virtual ~DynamicLib();

    /*!
     * @if jp
     *
     * @brief ԡ󥹥ȥ饯
     *
     * ԡ󥹥ȥ饯
     *
     * @param rhs ԡưŪ󥯥饤֥ꥪ֥
     *
     * @else
     *
     * @brief Copy Constructor
     *
     * Copy Constructor
     *
     * @param rhs Dynamic link library object of copy source.
     *
     * @endif
     */
    DynamicLib(const DynamicLib& rhs);

    /*!
     * @if jp
     *
     * @brief 黻
     *
     * ưŪ󥯥饤֥ꥪ֥Ȥ򥳥ԡ롣
     *
     * @param rhs ưŪ󥯥饤֥ꥪ֥
     *
     * @return 
     *
     * @else
     *
     * @brief Assignment operator
     *
     * Copy a Dynamic link library object.
     *
     * @param rhs Dynamic link library object of assignment source.
     *
     * @return Assignment result.
     *
     * @endif
     */
    DynamicLib& operator=(const DynamicLib& rhs);

    /*!
     * @if jp
     *
     * @brief ưŪ󥯥饤֥Υ
     *
     * ưŪ󥯥饤֥ɤ롣
     *
     * @param dll_name ưŪ󥯥饤֥̾
     * @param open_mode ץ⡼
     * @param close_handle_on_destruction ե饰
     *
     * @return 0: , -1: 
     *
     * @else
     *
     * @brief Load of the Dynamic link library 
     *
     * Load of the Dynamic link library.
     *
     * @param dll_name Dynamic link library name.
     * @param open_mode Open mode.
     * @param close_handle_on_destruction Close flag.
     *
     * @return 0: successful, -1: failed
     *
     * @endif
     */
    virtual int open(const char* dll_name,
                     int open_mode = COIL_DEFAULT_DYNLIB_MODE,
                     int close_handle_on_destruction = 1);

    /*!
     * @if jp
     *
     * @brief ưŪ󥯥饤֥Υ
     *
     * ưŪ󥯥饤֥򥢥ɤ롣
     *
     * @return 0: , -1: 
     *
     * @else
     *
     * @brief Unload of the Dynamic link library 
     *
     * Unload of the Dynamic link library.
     *
     * @return 0: successful, -1: failed
     *
     * @endif
     */
    virtual int close(void);

    /*!
     * @if jp
     *
     * @brief ܥ뤬ɤ줿ꥢɥ쥹֤
     *
     * ܥ뤬ɤ줿ꥢɥ쥹֤
     *
     * @param symbol_name ܥ̾
     *
     * @return ꥢɥ쥹(NULL: )
     *
     * @else
     *
     * @brief Return an address of the memory where a symbol was loaded
     *
     * Return an address of the memory where a symbol was loaded.
     *
     * @param symbol_name Symbol name.
     *
     * @return Memory address.(NULL: failed)
     *
     * @endif
     */
    void *symbol (const char* symbol_name);

    /*!
     * @if jp
     *
     * @brief 顼ˤĤƤå֤
     *
     * 顼ˤĤƤå֤
     *
     * @return 顼å(NULL: 顼ʤ)
     *
     * @else
     *
     * @brief Return the explanation message about the error
     *
     * Return the explanation message about the error.
     *
     * @return Error message.(NULL: not an error)
     *
     * @endif
     */
    const char* error(void) const;

    /*!
     * @if jp
     *
     * @brief ˥åȥƥ
     *
     * ˥åȥƥȤԤ
     *
     * @return 0xdeadbeef
     *
     * @else
     *
     * @brief Unit Test
     *
     * Unit Test.
     *
     * @return 0xdeadbeef
     *
     * @endif
     */
    static int ForExternTest(void) { return 0xdeadbeef; }

  private:
    std::string m_name;
    int m_mode;
    int m_closeflag;
    void* m_handle;
    int m_error;
  };

};

#endif // DynamicLib_h
