// -*- C++ -*-
/*!
 * @file DataFlowComponentBase.h
 * @brief DataFlowParticipant RT-Component base class
 * @date $Date: 2007-12-31 03:08:02 $
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2006-2008
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#ifndef RTC_DATAFLOWCOMPONENTBASE_H
#define RTC_DATAFLOWCOMPONENTBASE_H

#include <rtm/idl/RTCSkel.h>
#include <rtm/RTObject.h>
#include <rtm/PeriodicExecutionContext.h>

/*!
 * @if jp
 * @namespace RTC
 *
 * @brief RTݡͥ
 *
 * @else
 *
 * @namespace RTC
 *
 * @brief RT-Component
 *
 * @endif
 */

namespace RTC
{

  class Manager;
  /*!
   * @if jp
   * @class DataFlowComponentBase
   * @brief DataFlowComponentBase 饹
   *
   * ǡեRTComponentδ쥯饹
   * ƼǡեRTComponentϡܥ饹ѾǼ
   * 롣
   *
   * @since 0.4.0
   *
   * @else
   * @class DataFlowComponentBase
   * @brief DataFlowComponentBase class
   *
   * This is a base class of the data flow type RT-Component.
   * Inherit this class when implementing various data flow type RT-Components.
   *
   * @since 0.4.0
   *
   * @endif
   */
  
  class DataFlowComponentBase
    : public RTObject_impl
  {
  public:
    /*!
     * @if jp
     * @brief 󥹥ȥ饯
     *
     * 󥹥ȥ饯
     *
     * @param manager ޥ͡㥪֥
     *
     * @else
     * @brief Constructor
     *
     * Constructor
     *
     * @param manager Manager object
     *
     * @endif
     */
    DataFlowComponentBase(Manager* manager);
    
    /*!
     * @if jp
     * @brief ǥȥ饯
     *
     * ǥȥ饯
     *
     * @else
     * @brief Destructor
     *
     * Destructor
     *
     * @endif
     */
    virtual ~DataFlowComponentBase(void);
    
    /*!
     * @if jp
     * @brief 
     *
     * ǡե RTComponent ν¹Ԥ롣
     * ºݤνϡƶݥ饹˵Ҥ롣
     *
     * @else
     * @brief Initialization
     *
     * Initialization the data flow type RT-Component.
     * Write the actual initialization code in each concrete class.
     *
     * @endif
     */
    void init();
    
  private:
    //    OpenRTM::DataFlowComponent_var m_ref;
    //    PeriodicExecutionContext* m_pec;
    //    ExecutionContextService_var m_ecref;
  };
}; // namespace RTC
#endif // RTC_DATAFLOWCOMPONENTBASE_H
