// -*- C++ -*-
/*!
 * @file  OutPortConsumer.h
 * @brief OutPortConsumer class
 * @date  $Date: 2007-12-31 03:08:05 $
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2006-2009
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#ifndef RTC_OUTPORTCONSUMER_H
#define RTC_OUTPORTCONSUMER_H

#include <coil/Factory.h>
#include <rtm/DataPortStatus.h>
#include <rtm/CdrBufferBase.h>

// Why RtORB does not allow the following foward declaration?
#ifndef ORB_IS_RTORB
namespace SDOPackage
{
  class NVList;
};
#endif // ORB_IS_RTORB

namespace coil
{
  class Properties;
};

namespace RTC
{
  class ConnectorListeners;
  class ConnectorInfo;

  /*!
   * @if jp
   *
   * @class OutPortConsumer
   *
   * @brief OutPortConsumer ݥ饹
   *
   * OutPort  REQUIRED 󥿡ե뤿ݴ쥯饹
   * Υ֥饹Υ֥Ȥ InPort °pull Υǡ
   * ꡼¸롣InPort Фƿ󥿡ե
   * ˤϡΥ饹Ѿʲδؿɬפ롣
   * 
   * - init()
   * - setBuffer()
   * - setListener()
   * - get()
   *
   * ˡʲβ۴ؿˡConnectorProfile ɬפȤ
   * ʤɡ³Ω뤤³Ǥ¹Ԥ뤿ɬפʽ
   * ʤФʤʤ
   *
   * - subscribeInterface()
   * - unsubscribeInterface()
   *
   * InPort  OutPortConsumer Υեȥ饹ФѲǽ
   *  OutPortConsumer 礻󶡲ǽʥ󥿡եפ
   * 롣äơInPortФ REQUIRED 󥿡ե
   * 󶡤 OutPortConsumer Υ֥饹ϡOutPortConsumerFactory
   * ˥եȥؿϿɬפ롣
   *
   * RTC::OutPortConsumerFactory::instance().addFactory() 
   *
   * - 1: ץХ̾, "corba_cdr" ʤ
   * - 2: եȥؿ coil::Creator<B, T>
   * - 3: ؿ coil::Destructor<B, T>
   * 
   * ͿƸƤӽФɬפ롣ʲϡեȥؤϿȡ
   * ؿȤǤ롣
   * 
   * <pre>
   * extern "C"
   * {
   *   void OutPortCorbaCdrConsumerInit(void)
   *   {
   *     RTC::OutPortConsumerFactory&
   *                         factory(RTC::OutPortConsumerFactory::instance());
   *     factory.addFactory("corba_cdr",
   *                        ::coil::Creator<::RTC::OutPortConsumer,
   *                                        ::RTC::OutPortCorbaCdrConsumer>,
   *                        ::coil::Destructor<::RTC::OutPortConsumer,
   *                                           ::RTC::OutPortCorbaCdrConsumer>);
   *   }
   * };
   * </pre>
   *
   * Τ褦ˡեȥؤϿؿȤơextern "C"
   * ˤꥷܥ򻲾ȲǽˤƤ뤳Ȥǡ
   * OutPortConsumer ֥ͭȲ (DLL) ưŪɲǽ
   * ץХηưŪɲä뤳ȤǽȤʤ롣
   *
   * @since 0.4.0
   *
   * @else
   * @class OutPortConsumer
   *
   * @brief OutPortConsumer abstract class
   *
   * The virtual class for OutPort's PROVIDED interface
   * implementation.  New interface for OutPort have to inherit this
   * class, and have to implement the following functions.
   *
   * - init()
   * - setBuffer()
   * - setListener()
   * - get()
   *
   * Furthermore, connecting or disconnecting processes, such as
   * obtaining some information from ConnectorProfile or releasing
   * some resources, should be implemented in the following virtual
   * functions.
   *
   * - subscribeInterface()
   * - unsubscribeInterface()
   *
   * InPort inquires available OutPortConsumers to the factory class
   * of OutPortConsumer, and publishes available interfaces to
   * others. Therefore, sub-classes of OutPortConsumer that provides
   * PROVIDED interface to OutPort should register its factory to
   * OutPortConsumerFactory.
   *
   * RTC::OutPortConsumerFactory::instance().addFactory() would be
   * called with the following arguments.
   *
   * 1st arg: The name of provider. ex. "corba_cdr"
   * 2nd arg: Factory function. coil::Creator<B, T>
   * 3rd arg: Destruction function. coil::Destructor<B, T>
   *
   * The following example shows how to register factory function.
   * And it is also declared as a initialization function.
   *
   * <pre>
   * extern "C"
   * {
   *   void OutPortCorbaCdrConsumerInit(void)
   *   {
   *     RTC::OutPortConsumerFactory&
   *                         factory(RTC::OutPortConsumerFactory::instance());
   *     factory.addFactory("corba_cdr",
   *                        ::coil::Creator<::RTC::OutPortConsumer,
   *                                        ::RTC::OutPortCorbaCdrConsumer>,
   *                        ::coil::Destructor<::RTC::OutPortConsumer,
   *                                           ::RTC::OutPortCorbaCdrConsumer>);
   *   }
   * };
   * </pre>
   *
   * It is recommended that the registration process is declared as a
   * initialization function with "extern C" to be accessed from the
   * outside of module.  If the OutPortConsumers are compiled as a
   * shared object or DLL for dynamic loading, new OutPortConsumer
   * types can be added dynamically.
   *
   * @since 0.4.0
   *
   * @endif
   */
  class OutPortConsumer
    : public DataPortStatus
  {
  public:
    DATAPORTSTATUS_ENUM
    
    /*!
     * @if jp
     *
     * @brief ǥȥ饯
     *
     * ۥǥȥ饯
     *
     * @else
     * @brief Destructor
     *
     * Virtual destructor
     *
     * @endif
     */
    virtual ~OutPortConsumer(void){};

    /*!
     * @if jp
     * @brief 
     *
     * OutPortConsumerγƼԤ饹ǤϡͿ줿
     * PropertiesɬפʾƳƼԤ init() 
     * ϡOutPortProviderľ太ӡ³ˤ줾ƤФ
     * ǽ롣äơδؿʣƤФ뤳ȤꤷƵ
     * Ҥ٤Ǥ롣
     * 
     * @param prop 
     *
     * @else
     *
     * @brief Initializing configuration
     *
     * This operation would be called to configure in initialization.
     * In the concrete class, configuration should be performed
     * getting appropriate information from the given Properties data.
     * This function might be called right after instantiation and
     * connection sequence respectivly.  Therefore, this function
     * should be implemented assuming multiple call.
     *
     * @param prop Configuration information
     *
     * @endif
     */
    virtual void init(coil::Properties& prop) = 0;

    /*!
     * @if jp
     * @brief Хåե򥻥åȤ
     *
     * OutPortConsumerǡФХåե򥻥åȤ롣
     * Ǥ˥åȤ줿Хåե硢ΥХåեؤ
     * ݥ󥿤Фƾ񤭤롣
     * OutPortProviderϥХåեνͭꤷƤʤΤǡ
     * Хåեκϥ桼ǤǹԤʤФʤʤ
     *
     * @param buffer OutPortProviderǡФХåեؤΥݥ
     *
     * @else
     * @brief Setting outside buffer's pointer
     *
     * A pointer to a buffer from which OutPortProvider retrieve data.
     * If already buffer is set, previous buffer's pointer will be
     * overwritten by the given pointer to a buffer.  Since
     * OutPortProvider does not assume ownership of the buffer
     * pointer, destructor of the buffer should be done by user.
     * 
     * @param buffer A pointer to a data buffer to be used by OutPortProvider
     *
     * @endif
     */
    virtual void setBuffer(CdrBufferBase* buffer) = 0;

    /*!
     * @if jp
     * @brief ꥹʤꤹ롣
     *
     * OutPort ϥǡˤƼ磻٥ȤФΥꥹ
     * ֥Ȥ򥳡뤹륳Хå󶡤롣ܺ٤
     * ConnectorListener.h  ConnectorDataListener, ConnectorListener
     * 򻲾ȤΤȡOutPortProvider Υ֥饹ǤϡͿ줿ꥹ
     * ʤŬڤʥߥ󥰤ǸƤӽФ٤Ǥ롣٤ƤΥꥹ
     * ƤӽФɬפϤʤ
     *
     * @param info ³
     * @param listeners ꥹʥ֥
     *
     * @else
     * @brief Set the listener. 
     *
     * OutPort provides callback functionality that calls specific
     * listener objects according to the events in the data publishing
     * process. For details, see documentation of
     * ConnectorDataListener class and ConnectorListener class in
     * ConnectorListener.h. In the sub-classes of OutPortProvider, the
     * given listeners should be called in the proper timing. However,
     * it is not necessary to call all the listeners.
     *
     * @param info Connector information
     * @param listeners Listener objects
     *
     * @endif
     */
    virtual void setListener(ConnectorInfo& info,
                             ConnectorListeners* listeners) = 0;

    /*!
     * @if jp
     *
     * @brief ǡ
     *
     * ǡ¹Ԥ뤿ν貾۴ؿ
     * ݥ饹Ǥϡ줾ˡǥ⡼ȤOutPortǡ
     * å롣
     * ˴ؤ֤˱ưʲ֤ͤ
     *
     * @param data ǡ
     * @return PORT_OK         ｪλ
     *         BUFFER_TIMEOUT  ॢȤ
     *         RECV_EMPTY      ΥХåեǤ롣
     *         CONNECTION_LOST ³Ǥ줿
     *         PORT_ERROR      顼
     *         UNKNOWN_ERROR   褢ꤨʤ顼
     *
     * @else
     *
     * @brief Receive data
     *
     * Pure virtual function to receive data.
     *
     * @endif
     */
    virtual ReturnCode get(cdrMemoryStream& data) = 0;

    /*!
     * @if jp
     *
     * @brief ǡΤؤϿ
     *
     * ꤵ줿ץѥƥ˴ŤơǡΤϿ뤿
     * 貾۴ؿ
     *
     * @param properties Ͽѥץѥƥ
     *
     * @return Ͽ(Ͽ:trueϿ:false)
     *
     * @else
     *
     * @brief Subscribe the data receive notification
     *
     * Pure virtual function to subscribe the data receive notification
     * based on specified property information.
     *
     * @param properties Properties for subscription
     *
     * @return Subscription result (Successful:true, Failed:false)
     *
     * @endif
     */
    virtual bool subscribeInterface(const SDOPackage::NVList& properties) = 0;
    
    /*!
     * @if jp
     *
     * @brief ǡΤϿ
     *
     * ǡΤϿ뤿ν貾۴ؿ
     *
     * @param properties Ͽѥץѥƥ
     *
     * @return Ͽ(Ͽ:trueϿ:false)
     *
     * @else
     *
     * @brief Unsubscribe the data receive notification
     *
     * Pure virtual function to unsubscribe the data receive notification.
     *
     * @param properties Properties for unsubscription
     *
     * @return Unsubscription result (Successful:true, Failed:false)
     *
     * @endif
     */
    virtual void unsubscribeInterface(const SDOPackage::NVList& properties) = 0;

  protected:
    /*!
     * @if jp
     * @brief ȥ꡼
     * @else
     * @brief Logger stream
     * @endif
     */
    mutable Logger rtclog;

    /*!
     * @if jp
     * @brief Interface³Functor
     * @else
     * @brief Functor to subscribe the interface
     * @endif
     */
    struct subscribe
    {
      subscribe(const SDOPackage::NVList& prop) : m_prop(prop) {}
      void operator()(OutPortConsumer* consumer)
      {
        consumer->subscribeInterface(m_prop);
      }
      const SDOPackage::NVList& m_prop;
    };
    
    /*!
     * @if jp
     * @brief Interface³Functor
     * @else
     * @brief Functor to unsubscribe the interface
     * @endif
     */
    struct unsubscribe
    {
      unsubscribe(const SDOPackage::NVList& prop) : m_prop(prop) {}
      void operator()(OutPortConsumer* consumer)
      {
        consumer->unsubscribeInterface(m_prop);
      }
      const SDOPackage::NVList& m_prop;
    };
  };

  /*!
   * @if jp
   * @brief OutPortConsumerFactory
   * @else
   * @brief OutPortConsumerFactory type definition
   * @endif
   */
  typedef ::coil::GlobalFactory<OutPortConsumer> OutPortConsumerFactory;

#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__) || defined(__NT__)
  EXTERN template class DLL_PLUGIN ::coil::GlobalFactory<OutPortConsumer>;
#endif
};     // namespace RTC
#endif // RTC_OUTPORTCONSUMER_H

