// -*- C++ -*-
/*!
 * @file SdoServiceProviderBase.h
 * @brief SDO service provider base class and its factory
 * @date $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2011
 *     Noriaki Ando
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */


#ifndef RTC_SDOSERVICEPROVIDERBASE_H
#define RTC_SDOSERVICEPROVIDERBASE_H

#include <coil/Mutex.h>
#include <coil/Factory.h>
#include <coil/Timer.h>
#include <rtm/RTC.h>
#include <rtm/RTObject.h>
#include <rtm/idl/SDOPackageStub.h>

namespace RTC
{
  /*!
   * @if jp
   *
   * @brief SdoServiceProvider쥯饹
   *
   * SDOƤSDOӥΥץХ뤿δ쥯
   * SDOӥˤϡ󶡥ӥRTC(SDO)¦Ѥ
   * SDOӥ󥷥塼ޤȡRTC(SDO)ȤSDOӥ󶡤SDO
   * ӥץХ롣٤ƤSDOӥץХϤδ
   * 饹ѾƼ롣
   *
   * Υ֥ȤΥ饤եϰʲ̤ꡣ
   *
   * -# ֥Ȥ̾֥ͭ (so, DLL) Ȥƥѥ롦
   *    󥯤롣
   * -# ޥ͡Фƥɤȥ⥸塼ؿˤꥪ
   *    ȥեȥ꤬SdoServiceProviderFactory ФϿ
   *    롣ϿΥˤϥӥ󥿡ե IFR (interface
   *    repository) ID Ѥ졢ˤꥵӥ̤롣
   * -# rtc.confΥե졼ˤꡢͭ뤳Ȥ
   *    ꤵƤ륵ӥץХϡRTCεưƱ˥
   *    󥹲롣
   * -# 󥹥󥹲塢ؿ init() ƤФ롣ˤ
   *    ӥΤΥե졼󥪥ץ coil::Property
   *    Ϥ롣
   * -# 󥹥󥹲줿SDOӥץХ
   *    SDO::get_get_sdo_service() ˤ곰饢롣Τ
   *    ӥꤹIDIFR IDƱǤ롣ΤȤΥ
   *    󥹤ϰʲ̤ꡣ
   * -# RTCfinalizeΤƱSDOӥץХ
   *    뤬κݤˤSdoServiceProviderBase::finalize()
   *    Τǡǥ꥽βʤɽλԤ
   *
   * <pre>
   * 
   *   [RTC]      [SDO service]               [Other]
   *     |              :                        |
   *     | instantiate  :                        |
   *     |------------->:                        |
   *     |    init()    |                        |
   *     |------------->|                        |
   *     |              | get_service_profiles() |
   *     |<--------------------------------------|
   *     |              |    get_sdo_service()   |
   *     |<--------------------------------------|
   *     |              |        use service     |
   *     |              |<-----------------------|
   *     |              |                        |
   *     |  finalize()  |                        |
   *     |------------->x                        |
   *     x              x                        |
   *
   * </pre>
   *
   * Υ饹μäƤϡʤȤʲν貾۴ؿ
   * ɬפ롣
   *
   * - init(): ؿͿ줿 RTObject  ServiceProfile 
   *   顢֥Ȥ롣
   * - reinit(): ƽؿServiceProfile 󹹿ΤƱ
   *   IDǸƤӽФ뤳Ȥͭ뤬κݤˤδؿ
   *   ServiceProfile ȤȤ˸ƤӽФ롣ؿǤϡѹʤ
   *   ƽ롣
   * - getProfile(): ꤵ줿ץե֤ؿ
   * - finalize(): λ󥷥塼ޤǥåݤ˸ƤӽФ
   *   ؿؿǤϽλ롣
   *
   * SdoServiceProvider ̾ﶦ֥ͭȤȤƥѥ롦
   * 롣֥ͭȤΥȥݥȤ̾拾ѥ뤵줿ե
   * ̾ basename + "Init" ˤƤʲˡ饹̾ե
   * ̾ȥݥȴؿ̾ο侩򼨤
   *
   * - 饹̾: MySdoServiceConusmer 
   * - ե̾: MySdoServiceProvider.h. MySdoServiceProvider.cpp
   * - ֥ͭ̾: MySdoServiceProvider.so (or DLL)
   * - ȥݥȴؿ̾: MySdoServiceProviderInit()
   *
   * ȥݥȴؿ̾ʲΤ褦ˡSdoServiceProviderFactory
   * 󥷥塼ޤΥեȥ (ȲΥե󥯥) Ͽʲ
   * 褦ʴؿˤʤ롣
   *
   * <pre>
   * extern "C"
   * {
   *   void MySdoServiceProviderInit()
   *   {
   *     RTC::SdoServiceProviderFactory& factory
   *       = RTC::SdoServiceProviderFactory::instance();
   *     factory.addFactory(CORBA_Util::toRepositoryId<OpenRTM::MySdoService>(),
   *                        ::coil::Creator< ::RTC::SdoServiceProviderBase,
   *                        ::RTC::MySdoServiceProvider>,
   *                        ::coil::Destructor< ::RTC::SdoServiceProviderBase,
   *                        ::RTC::MySdoServiceProvider>);
   *   }
   * };
   * </pre>
   * 
   * @else
   *
   * @endif
   *
   */
  class SdoServiceProviderBase
    : public virtual POA_SDOPackage::SDOService,
      public virtual PortableServer::RefCountServantBase
  {
  public:
    /*!
     * @if jp
     * @brief ۥǥȥ饯
     * @else
     * @brief virtual destructor
     * @endif
     */
    virtual ~SdoServiceProviderBase() {};

    /*!
     * @if jp
     * @brief 󥷥塼ޥ饹νؿ
     *
     * Υ֥ȤνԤSDOӥ
     * ServiceProfile ȤȤ˥åȡSDO󥷥塼ޤ
     * 󥹲졢ľ SDO ӥå줿 RTC Ϳ
     * 줿 ServiceProfile ȤƤδؿƤФ롣
     *
     * ؿǤϡServiceProfile  SDO ӥե󥹤
     * CorbaProvider 饹Ѥ֥ݻȤȤˡ
     * properties Ƥɤ߹ߥӥͭԤͿ
     * 줿ӥΥ֥ȥե󥹤뤤
     * properties Ƥξͤ false ֤
     *
     * @param rtobj Υ֥Ȥ󥹥󥹲줿 RTC
     * @param profile Ϳ줿 SDO ServiceProfile
     * @return Ϳ줿 SDO Service  ServiceProfile ξ false
     *
     * @else
     * @brief Initialization function of the consumer class
     *
     * @endif
     */
    virtual bool init(RTObject_impl& rtobj,
                      const SDOPackage::ServiceProfile& profile) = 0;
    /*!
     * @if jp
     * @brief 󥷥塼ޥ饹κƽؿ
     *
     * Υ֥ȤκƽԤServiceProfile ˤ id ե
     * ɤ˥åͭ UUID åȤƤ뤬Ʊ id ξ
     * 硢properties ꤵ줿ѹ䡢service ե
     * ΥӥλȤѹԤ롣κݤ˸ƤФΤ
     * reinit() ؿǤ롣Ǥϡservice եɤΥ֥
     * ե󥹤ƱǧۤʤäƤݻƤե
     * 󥹤򹹿ɬפ롣ޤ properties ˤϿ꤬Ϳ
     * ƤǽΤǡƤɤ߹򹹿롣
     *
     * @param profile Ϳ줿 SDO ServiceProfile
     * @return  ServiceProfile Ϳ줿 false
     *
     * @else
     * @brief Reinitialization function of the consumer class
     *
     * @endif
     */
    virtual bool reinit(const SDOPackage::ServiceProfile& profile) = 0;

    /*!
     * @if jp
     * @brief ServiceProfile ֤
     *
     * init()/reinit()Ϳ줿 ServiceProfile ̾索֥
     * ݻ롣SDO Service ե졼ϴ夳Υ֥
     * Ȥб ServiceProfile ɬפȤΤǡδؿǤݻ
     * Ƥ ServiceProfile ֤
     * 
     * @return Υ֥ȤݻƤ ServiceProfile
     *
     * @else
     * @brief Getting ServiceProfile
     * @endif
     */
    virtual const SDOPackage::ServiceProfile& getProfile() const = 0;

    /*!
     * @if jp
     * @brief λ
     *
     * SDOӥǥåݤ˸ƤӽФ뽪λѴؿ
     * ӥΤǥå˺ݤơ֥Ȥݻ꥽
     * ʤɤνԤ
     *
     * @else
     * @brief Finalization
     *
     * @endif
     */
    virtual void finalize() = 0;
  };

    /*!
     * @if jp
     * @brief SdoServiceProviderFactory  typedef
     * @else
     * @brief typedef of sdoServiceProviderFactory
     * @endif
     */
  typedef ::coil::GlobalFactory<
    ::RTC::SdoServiceProviderBase > SdoServiceProviderFactory;

#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__) || defined(__NT__)
    /*!
     * @if jp
     * @brief 饹ƥץ졼ȤŪ󥹥󥹲
     * @else
     * @brief Explicit instantiation of class template
     * @endif
     */
  EXTERN template class DLL_PLUGIN 
                     ::coil::GlobalFactory< ::RTC::SdoServiceProviderBase >;
#endif  
}; // namespace RTC

#endif // RTC_SDOSERVICEPROVIDERBASE_H
