;;
;; DO NOT EDIT THIS FILE
;;
;; this file is automatically generated from /tmp/pr2_16412.l on (Linux ubuntu-18 4.15.0-29-generic x86_64) at 2019-12-19 10:43:01 UTC
;;
;; /home/user/.ros $ ;;

;;
;; copy euscollada-robot class definition from euscollada/src/euscollada-robot.l
;;
(defclass euscollada-robot
;; This euscollada-robot class is for robots converted from collada files.
;; This class provides :init-ending override.
  :super robot-model
  :slots ()
  )
(defmethod euscollada-robot
  (:init-ending
   (&optional (type :urdf))
   (when (eq type :collada)
     ;; fix all links' mass properties ;; root link relative (collada) -> link local (euslisp)
     (dolist (l (append links
                        (mapcan #'(lambda (x) (if (and (derivedp (cdr x) bodyset-link)
                                                       (not (memq (cdr x) links)))
                                                  (list (cdr x)))) (send self :slots))))
       (unless (= (send l :weight) 0.0)
       (setq (l . acentroid) (send l :inverse-transform-vector
                                   (send (send (car links) :worldcoords) :transform-vector
                                         (l . acentroid))))
       (setq (l . inertia-tensor) (m* (transpose (send l :worldrot))
                                      (m* (send (car links) :worldrot)
                                          (l . inertia-tensor))))
       )))
   (send-super :init-ending)
   (send self :make-collision-model-for-links)
   ;;
   (dolist (j (mapcan #'(lambda (x) (if (and (derivedp (cdr x) joint)
                                             (not (memq (cdr x) (send self :joint-list))))
                                        (list (cdr x)))) (send self :slots)))
     (send (send j :child-link) :add-joint j)
     (send (send j :child-link) :add-parent-link (send j :parent-link))
     (send (send j :parent-link) :add-child-links (send j :child-link)))
   )
  (:change-visual
   (&optional (visual :convex))
   (dolist (lk (send self :links))
     (dolist (bd (send lk :bodies))
       (when (derivedp bd collada-body)
         (send bd :change-visual visual)))))
  ;; fullbody-inverse-kinematics overwrite
  ;;  reduce root-link's weight based on leg's joint limit
  ;;  increase stop and cog-gain
  (:fullbody-inverse-kinematics
   (target-coords &rest args &key (stop 250) (cog-gain 2.0) (additional-weight-list) (use-6dof-joint-leg-gain nil) &allow-other-keys)
   (let* ((leg-ul (send self :calc-union-link-list (send self :legs :links))))
     (send self :reset-joint-angle-limit-weight-old leg-ul)
     (send-message* self robot-model :fullbody-inverse-kinematics
                    target-coords
                    :stop stop :cog-gain cog-gain
                    :additional-weight-list
                    (append
                     additional-weight-list
                     (if use-6dof-joint-leg-gain
                         (list
                          (list (car (send self :links))
                                #'(lambda ()
                                    ;; set root-link 6dof-joint's weight based on legs' joint limit
                                    (let* ((min-weight
                                            (reduce #'(lambda (x y) (min x y))
                                                    (coerce (send self :calc-inverse-kinematics-weight-from-link-list
                                                                  leg-ul :union-link-list leg-ul) cons))))
                                      (fill (instantiate float-vector 6) min-weight)))
                                )
                          )))
                    args)
     ))
  ;; make collision model from faces or gl-vertices
  (:make-collision-model-for-links
   (&key (fat 0) (collision-func 'pqp-collision-check) ((:links ls) (send self :links)))
   (dolist (ll ls)
     (let (fs glv usefs)
       (dolist (bd (send ll :bodies))
         (if (derivedp bd collada-body)
             (push (send bd :glvertices) glv)
           (push (send bd :faces) fs)))
       (setq fs (flatten fs))
       (cond
        ((and (not fs) glv) ;; if there is no faces, use glvertices for creating pqpmodel
         (setq usefs (instance gl::glvertices :init nil))
         (send usefs :transform (send ll :worldcoords))
         (send usefs :append-glvertices glv)
         (let ((m (send usefs (read-from-string
                               (format nil ":make-~Amodel"
                                       (string-right-trim "-COLLISION-CHECK" (string collision-func))))
                        :fat fat)))
           (setf (get ll :pqpmodel) m)
           ))
        (fs
         (setq usefs
               (append fs
                       (mapcar #'(lambda (gv) (send gv :convert-to-faces :wrt :world)) glv)))
         (send ll
               (read-from-string
                (format nil ":make-~Amodel"
                        (string-right-trim "-COLLISION-CHECK" (string collision-func))))
               :fat fat
               :faces usefs))
        ))
     ))
  )

;; copy euscollada-body class definition from euscollada/src/euscollada-robot.l
;; This euscollada-body class is for bodies in robot model converted from collada files.
(defclass collada-body
  :super gl::glbody
  :slots (glvertices) ;; glvertices slot for backward compatibility
  )
(defmethod collada-body
  (:init (&key (name) (replace-obj))
    (if replace-obj
        (replace-object self replace-obj)
      (replace-object self (make-cube 10 10 10)))
    (if name (send self :name name))
    (setq glvertices gl::aglvertices)
    self)
  (:change-visual
   (&optional (visual :convex))
   (case visual
     ((list :convex :hull :convex-hull)
      (unless (send self :get :original-mesh)
        (send self :put :original-mesh gl::aglvertices)) ;; store original mesh
      (let* ((org-mesh (send self :get :original-mesh))
             (org-cds (send org-mesh :copy-worldcoords))
             (glv (gl::make-glvertices-from-faces (send self :faces))))
        (send glv :set-offset (send org-cds :inverse-transformation))
        (send glv :transform org-cds)
        (send org-mesh :assoc glv)
        (setq gl::aglvertices glv)
        glv))
     ((list :original :mesh :glvertices :original-mesh)
      (let ((org-mesh (send self :get :original-mesh)))
        (when org-mesh
          (dolist (d (send org-mesh :descendants)) ;; dissoc all discendants
            (send org-mesh :dissoc d))
          (setq gl::aglvertices org-mesh)
          org-mesh)))
     ))
  )
;;
;; end of copy from /home/user/pr2eus_ws/src/euscollada/src/euscollada-robot.l
;;
(defun pr2 () (setq *pr2* (instance pr2-robot :init)))

(defclass pr2-robot
  :super euscollada-robot
  :slots ( ;; link names
          base_bellow_link_lk base_footprint_lk base_laser_link_lk base_link_lk bl_caster_l_wheel_link_lk bl_caster_r_wheel_link_lk bl_caster_rotation_link_lk br_caster_l_wheel_link_lk br_caster_r_wheel_link_lk br_caster_rotation_link_lk double_stereo_link_lk fl_caster_l_wheel_link_lk fl_caster_r_wheel_link_lk fl_caster_rotation_link_lk fr_caster_l_wheel_link_lk fr_caster_r_wheel_link_lk fr_caster_rotation_link_lk head_chain_cb_link_lk head_mount_kinect_ir_link_lk head_mount_kinect_ir_optical_frame_lk head_mount_kinect_rgb_link_lk head_mount_kinect_rgb_optical_frame_lk head_mount_link_lk head_mount_prosilica_link_lk head_mount_prosilica_optical_frame_lk head_pan_link_lk head_plate_frame_lk head_tilt_link_lk high_def_frame_lk high_def_optical_frame_lk imu_link_lk l_elbow_flex_link_lk l_forearm_cam_frame_lk l_forearm_cam_optical_frame_lk l_forearm_link_lk l_forearm_roll_link_lk l_gripper_l_finger_link_lk l_gripper_l_finger_tip_frame_lk l_gripper_l_finger_tip_link_lk l_gripper_led_frame_lk l_gripper_motor_accelerometer_link_lk l_gripper_motor_screw_link_lk l_gripper_motor_slider_link_lk l_gripper_palm_link_lk l_gripper_r_finger_link_lk l_gripper_r_finger_tip_link_lk l_gripper_tool_frame_lk l_shoulder_lift_link_lk l_shoulder_pan_link_lk l_torso_lift_side_plate_link_lk l_upper_arm_link_lk l_upper_arm_roll_link_lk l_wrist_flex_link_lk l_wrist_roll_link_lk laser_tilt_link_lk laser_tilt_mount_link_lk left_arm_chain_cb_link_lk narrow_stereo_l_stereo_camera_frame_lk narrow_stereo_l_stereo_camera_optical_frame_lk narrow_stereo_link_lk narrow_stereo_optical_frame_lk narrow_stereo_r_stereo_camera_frame_lk narrow_stereo_r_stereo_camera_optical_frame_lk projector_wg6802418_child_frame_lk projector_wg6802418_frame_lk r_elbow_flex_link_lk r_forearm_cam_frame_lk r_forearm_cam_optical_frame_lk r_forearm_link_lk r_forearm_roll_link_lk r_gripper_l_finger_link_lk r_gripper_l_finger_tip_frame_lk r_gripper_l_finger_tip_link_lk r_gripper_led_frame_lk r_gripper_motor_accelerometer_link_lk r_gripper_motor_screw_link_lk r_gripper_motor_slider_link_lk r_gripper_palm_link_lk r_gripper_r_finger_link_lk r_gripper_r_finger_tip_link_lk r_gripper_tool_frame_lk r_shoulder_lift_link_lk r_shoulder_pan_link_lk r_torso_lift_side_plate_link_lk r_upper_arm_link_lk r_upper_arm_roll_link_lk r_wrist_flex_link_lk r_wrist_roll_link_lk right_arm_chain_cb_link_lk sensor_mount_link_lk torso_lift_link_lk torso_lift_motor_screw_link_lk wide_stereo_l_stereo_camera_frame_lk wide_stereo_l_stereo_camera_optical_frame_lk wide_stereo_link_lk wide_stereo_optical_frame_lk wide_stereo_r_stereo_camera_frame_lk wide_stereo_r_stereo_camera_optical_frame_lk
         ;; joint names
          base_bellow_joint_fixed_jt base_footprint_joint_fixed_jt base_laser_joint_fixed_jt bl_caster_l_wheel_joint_jt bl_caster_r_wheel_joint_jt bl_caster_rotation_joint_jt br_caster_l_wheel_joint_jt br_caster_r_wheel_joint_jt br_caster_rotation_joint_jt double_stereo_frame_joint_fixed_jt fl_caster_l_wheel_joint_jt fl_caster_r_wheel_joint_jt fl_caster_rotation_joint_jt fr_caster_l_wheel_joint_jt fr_caster_r_wheel_joint_jt fr_caster_rotation_joint_jt head_chain_cb_fixed_jt head_mount_joint_fixed_jt head_mount_kinect_ir_joint_fixed_jt head_mount_kinect_ir_optical_frame_joint_fixed_jt head_mount_kinect_rgb_joint_fixed_jt head_mount_kinect_rgb_optical_frame_joint_fixed_jt head_mount_prosilica_joint_fixed_jt head_mount_prosilica_optical_frame_joint_fixed_jt head_pan_joint_jt head_plate_frame_joint_fixed_jt head_tilt_joint_jt high_def_frame_joint_fixed_jt high_def_optical_frame_joint_fixed_jt imu_joint_fixed_jt l_elbow_flex_joint_jt l_forearm_cam_frame_joint_fixed_jt l_forearm_cam_optical_frame_joint_fixed_jt l_forearm_joint_fixed_jt l_forearm_roll_joint_jt l_gripper_joint_jt l_gripper_l_finger_joint_jt l_gripper_l_finger_tip_joint_jt l_gripper_led_joint_fixed_jt l_gripper_motor_accelerometer_joint_fixed_jt l_gripper_motor_screw_joint_jt l_gripper_motor_slider_joint_jt l_gripper_palm_joint_fixed_jt l_gripper_r_finger_joint_jt l_gripper_r_finger_tip_joint_jt l_gripper_tool_joint_fixed_jt l_shoulder_lift_joint_jt l_shoulder_pan_joint_jt l_torso_lift_side_plate_joint_fixed_jt l_upper_arm_joint_fixed_jt l_upper_arm_roll_joint_jt l_wrist_flex_joint_jt l_wrist_roll_joint_jt laser_tilt_joint_fixed_jt laser_tilt_mount_joint_jt left_arm_chain_cb_fixed_jt narrow_stereo_frame_joint_fixed_jt narrow_stereo_l_stereo_camera_frame_joint_fixed_jt narrow_stereo_l_stereo_camera_optical_frame_joint_fixed_jt narrow_stereo_optical_frame_joint_fixed_jt narrow_stereo_r_stereo_camera_frame_joint_fixed_jt narrow_stereo_r_stereo_camera_optical_frame_joint_fixed_jt projector_wg6802418_child_frame_joint_fixed_jt projector_wg6802418_frame_joint_fixed_jt r_elbow_flex_joint_jt r_forearm_cam_frame_joint_fixed_jt r_forearm_cam_optical_frame_joint_fixed_jt r_forearm_joint_fixed_jt r_forearm_roll_joint_jt r_gripper_joint_jt r_gripper_l_finger_joint_jt r_gripper_l_finger_tip_joint_jt r_gripper_led_joint_fixed_jt r_gripper_motor_accelerometer_joint_fixed_jt r_gripper_motor_screw_joint_jt r_gripper_motor_slider_joint_jt r_gripper_palm_joint_fixed_jt r_gripper_r_finger_joint_jt r_gripper_r_finger_tip_joint_jt r_gripper_tool_joint_fixed_jt r_shoulder_lift_joint_jt r_shoulder_pan_joint_jt r_torso_lift_side_plate_joint_fixed_jt r_upper_arm_joint_fixed_jt r_upper_arm_roll_joint_jt r_wrist_flex_joint_jt r_wrist_roll_joint_jt right_arm_chain_cb_fixed_jt sensor_mount_frame_joint_fixed_jt torso_lift_joint_jt torso_lift_motor_screw_joint_jt wide_stereo_frame_joint_fixed_jt wide_stereo_l_stereo_camera_frame_joint_fixed_jt wide_stereo_l_stereo_camera_optical_frame_joint_fixed_jt wide_stereo_optical_frame_joint_fixed_jt wide_stereo_r_stereo_camera_frame_joint_fixed_jt wide_stereo_r_stereo_camera_optical_frame_joint_fixed_jt
         ;; sensor names
         
         )
  )
(defmethod pr2-robot
  (:init
   (&rest args)
   (let ()
     (send-super* :init :name "pr2" args)

     ;; link: base_bellow_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_base_bellow_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq base_bellow_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "base_bellow_link"))
       ;; inertial parameter for base_bellow_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send base_bellow_link_lk :weight 1000.000)
         (setq (base_bellow_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (base_bellow_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for base_bellow_link_lk
       (let ((world-cds (make-coords :pos (float-vector -2.9000000000000000e+02 0.0000000000000000e+00 8.5100000000000011e+02))
                        ))
         (send base_bellow_link_lk :transform world-cds))
       )

     ;; link: base_footprint_lk
     (let ((geom-lst (list
                       (send self :_make_instance_base_footprint_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq base_footprint_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "base_footprint"))
       ;; inertial parameter for base_footprint_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send base_footprint_lk :weight 1000.000)
         (setq (base_footprint_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (base_footprint_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for base_footprint_lk
       (let ((world-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                        ))
         (send base_footprint_lk :transform world-cds))
       )

     ;; link: base_laser_link_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq base_laser_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "base_laser_link"))
       ;; inertial parameter for base_laser_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send base_laser_link_lk :weight 1.000)
         (setq (base_laser_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+05 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+03 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+05))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (base_laser_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for base_laser_link_lk
       (let ((world-cds (make-coords :pos (float-vector 2.7500000000000000e+02 0.0000000000000000e+00 3.0300000000000000e+02))
                        ))
         (send base_laser_link_lk :transform world-cds))
       )

     ;; link: base_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_base_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq base_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "base_link"))
       ;; inertial parameter for base_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector -6.1000000000000000e+01 0.0000000000000000e+00 1.4650000000000003e+02)
                                   :rot (quaternion2matrix (float-vector 6.8719103493307054e-01 -6.8968508724111810e-01 1.6794397935461167e-01 -1.5458907381624593e-01)))
                      ))
         (send base_link_lk :weight 116000.000)
         (setq (base_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 6.2938848215018797e+09 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 3.0417723116333189e+09 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 5.6692450764548006e+09))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (base_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for base_link_lk
       (let ((world-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 5.1000000000000000e+01))
                        ))
         (send base_link_lk :transform world-cds))
       )

     ;; link: bl_caster_l_wheel_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_bl_caster_l_wheel_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq bl_caster_l_wheel_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "bl_caster_l_wheel_link"))
       ;; inertial parameter for bl_caster_l_wheel_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                                   :rot (quaternion2matrix (float-vector 6.8630934663031751e-01 6.6285921044798191e-01 2.7864936668790563e-01 1.0932373162572707e-01)))
                      ))
         (send bl_caster_l_wheel_link_lk :weight 440.360)
         (setq (bl_caster_l_wheel_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.2544593986297460e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.1456840427869651e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5392469553832879e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (bl_caster_l_wheel_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for bl_caster_l_wheel_link_lk
       (let ((world-cds (make-coords :pos (float-vector -2.2459999999999999e+02 2.7360000000000002e+02 7.9199999999999989e+01))
                        ))
         (send bl_caster_l_wheel_link_lk :transform world-cds))
       )

     ;; link: bl_caster_r_wheel_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_bl_caster_r_wheel_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq bl_caster_r_wheel_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "bl_caster_r_wheel_link"))
       ;; inertial parameter for bl_caster_r_wheel_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 2.7755575615628914e-14 0.0000000000000000e+00)
                                   :rot (quaternion2matrix (float-vector 6.8630934663031751e-01 6.6285921044798191e-01 2.7864936668790563e-01 1.0932373162572707e-01)))
                      ))
         (send bl_caster_r_wheel_link_lk :weight 440.360)
         (setq (bl_caster_r_wheel_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.2544593986297460e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.1456840427869651e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5392469553832879e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (bl_caster_r_wheel_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for bl_caster_r_wheel_link_lk
       (let ((world-cds (make-coords :pos (float-vector -2.2459999999999999e+02 1.7559999999999997e+02 7.9199999999999989e+01))
                        ))
         (send bl_caster_r_wheel_link_lk :transform world-cds))
       )

     ;; link: bl_caster_rotation_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_bl_caster_rotation_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq bl_caster_rotation_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "bl_caster_rotation_link"))
       ;; inertial parameter for bl_caster_rotation_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 7.0000000000000000e+01)
                                   :rot (quaternion2matrix (float-vector 6.8630934663031751e-01 6.6285921044798191e-01 2.7864936668790563e-01 1.0932373162572707e-01)))
                      ))
         (send bl_caster_rotation_link_lk :weight 3473.082)
         (setq (bl_caster_rotation_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.2544593986297460e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.1456840427869651e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5392469553832879e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (bl_caster_rotation_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for bl_caster_rotation_link_lk
       (let ((world-cds (make-coords :pos (float-vector -2.2459999999999999e+02 2.2459999999999999e+02 7.9199999999999989e+01))
                        ))
         (send bl_caster_rotation_link_lk :transform world-cds))
       )

     ;; link: br_caster_l_wheel_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_br_caster_l_wheel_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq br_caster_l_wheel_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "br_caster_l_wheel_link"))
       ;; inertial parameter for br_caster_l_wheel_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 -2.7755575615628914e-14 0.0000000000000000e+00)
                                   :rot (quaternion2matrix (float-vector 6.8630934663031751e-01 6.6285921044798191e-01 2.7864936668790563e-01 1.0932373162572707e-01)))
                      ))
         (send br_caster_l_wheel_link_lk :weight 440.360)
         (setq (br_caster_l_wheel_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.2544593986297460e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.1456840427869651e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5392469553832879e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (br_caster_l_wheel_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for br_caster_l_wheel_link_lk
       (let ((world-cds (make-coords :pos (float-vector -2.2459999999999999e+02 -1.7559999999999997e+02 7.9199999999999989e+01))
                        ))
         (send br_caster_l_wheel_link_lk :transform world-cds))
       )

     ;; link: br_caster_r_wheel_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_br_caster_r_wheel_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq br_caster_r_wheel_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "br_caster_r_wheel_link"))
       ;; inertial parameter for br_caster_r_wheel_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                                   :rot (quaternion2matrix (float-vector 6.8630934663031751e-01 6.6285921044798191e-01 2.7864936668790563e-01 1.0932373162572707e-01)))
                      ))
         (send br_caster_r_wheel_link_lk :weight 440.360)
         (setq (br_caster_r_wheel_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.2544593986297460e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.1456840427869651e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5392469553832879e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (br_caster_r_wheel_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for br_caster_r_wheel_link_lk
       (let ((world-cds (make-coords :pos (float-vector -2.2459999999999999e+02 -2.7360000000000002e+02 7.9199999999999989e+01))
                        ))
         (send br_caster_r_wheel_link_lk :transform world-cds))
       )

     ;; link: br_caster_rotation_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_br_caster_rotation_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq br_caster_rotation_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "br_caster_rotation_link"))
       ;; inertial parameter for br_caster_rotation_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 7.0000000000000000e+01)
                                   :rot (quaternion2matrix (float-vector 6.8630934663031751e-01 6.6285921044798191e-01 2.7864936668790563e-01 1.0932373162572707e-01)))
                      ))
         (send br_caster_rotation_link_lk :weight 3473.082)
         (setq (br_caster_rotation_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.2544593986297460e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.1456840427869651e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5392469553832879e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (br_caster_rotation_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for br_caster_rotation_link_lk
       (let ((world-cds (make-coords :pos (float-vector -2.2459999999999999e+02 -2.2459999999999999e+02 7.9199999999999989e+01))
                        ))
         (send br_caster_rotation_link_lk :transform world-cds))
       )

     ;; link: double_stereo_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_double_stereo_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq double_stereo_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "double_stereo_link"))
       ;; inertial parameter for double_stereo_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send double_stereo_link_lk :weight 100.000)
         (setq (double_stereo_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (double_stereo_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for double_stereo_link_lk
       (let ((world-cds (make-coords :pos (float-vector 2.4129999999999999e+01 0.0000000000000000e+00 1.2366250000000000e+03))
                        ))
         (send double_stereo_link_lk :transform world-cds))
       )

     ;; link: fl_caster_l_wheel_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_fl_caster_l_wheel_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq fl_caster_l_wheel_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "fl_caster_l_wheel_link"))
       ;; inertial parameter for fl_caster_l_wheel_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                                   :rot (quaternion2matrix (float-vector 6.8630934663031751e-01 6.6285921044798191e-01 2.7864936668790563e-01 1.0932373162572707e-01)))
                      ))
         (send fl_caster_l_wheel_link_lk :weight 440.360)
         (setq (fl_caster_l_wheel_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.2544593986297460e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.1456840427869651e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5392469553832879e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (fl_caster_l_wheel_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for fl_caster_l_wheel_link_lk
       (let ((world-cds (make-coords :pos (float-vector 2.2459999999999999e+02 2.7360000000000002e+02 7.9199999999999989e+01))
                        ))
         (send fl_caster_l_wheel_link_lk :transform world-cds))
       )

     ;; link: fl_caster_r_wheel_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_fl_caster_r_wheel_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq fl_caster_r_wheel_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "fl_caster_r_wheel_link"))
       ;; inertial parameter for fl_caster_r_wheel_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 2.7755575615628914e-14 0.0000000000000000e+00)
                                   :rot (quaternion2matrix (float-vector 6.8630934663031751e-01 6.6285921044798191e-01 2.7864936668790563e-01 1.0932373162572707e-01)))
                      ))
         (send fl_caster_r_wheel_link_lk :weight 440.360)
         (setq (fl_caster_r_wheel_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.2544593986297460e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.1456840427869651e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5392469553832879e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (fl_caster_r_wheel_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for fl_caster_r_wheel_link_lk
       (let ((world-cds (make-coords :pos (float-vector 2.2459999999999999e+02 1.7559999999999997e+02 7.9199999999999989e+01))
                        ))
         (send fl_caster_r_wheel_link_lk :transform world-cds))
       )

     ;; link: fl_caster_rotation_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_fl_caster_rotation_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq fl_caster_rotation_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "fl_caster_rotation_link"))
       ;; inertial parameter for fl_caster_rotation_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 7.0000000000000000e+01)
                                   :rot (quaternion2matrix (float-vector 6.8630934663031751e-01 6.6285921044798191e-01 2.7864936668790563e-01 1.0932373162572707e-01)))
                      ))
         (send fl_caster_rotation_link_lk :weight 3473.082)
         (setq (fl_caster_rotation_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.2544593986297460e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.1456840427869651e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5392469553832879e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (fl_caster_rotation_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for fl_caster_rotation_link_lk
       (let ((world-cds (make-coords :pos (float-vector 2.2459999999999999e+02 2.2459999999999999e+02 7.9199999999999989e+01))
                        ))
         (send fl_caster_rotation_link_lk :transform world-cds))
       )

     ;; link: fr_caster_l_wheel_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_fr_caster_l_wheel_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq fr_caster_l_wheel_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "fr_caster_l_wheel_link"))
       ;; inertial parameter for fr_caster_l_wheel_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 -2.7755575615628914e-14 0.0000000000000000e+00)
                                   :rot (quaternion2matrix (float-vector 6.8630934663031751e-01 6.6285921044798191e-01 2.7864936668790563e-01 1.0932373162572707e-01)))
                      ))
         (send fr_caster_l_wheel_link_lk :weight 440.360)
         (setq (fr_caster_l_wheel_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.2544593986297460e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.1456840427869651e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5392469553832879e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (fr_caster_l_wheel_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for fr_caster_l_wheel_link_lk
       (let ((world-cds (make-coords :pos (float-vector 2.2459999999999999e+02 -1.7559999999999997e+02 7.9199999999999989e+01))
                        ))
         (send fr_caster_l_wheel_link_lk :transform world-cds))
       )

     ;; link: fr_caster_r_wheel_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_fr_caster_r_wheel_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq fr_caster_r_wheel_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "fr_caster_r_wheel_link"))
       ;; inertial parameter for fr_caster_r_wheel_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                                   :rot (quaternion2matrix (float-vector 6.8630934663031751e-01 6.6285921044798191e-01 2.7864936668790563e-01 1.0932373162572707e-01)))
                      ))
         (send fr_caster_r_wheel_link_lk :weight 440.360)
         (setq (fr_caster_r_wheel_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.2544593986297460e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.1456840427869651e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5392469553832879e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (fr_caster_r_wheel_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for fr_caster_r_wheel_link_lk
       (let ((world-cds (make-coords :pos (float-vector 2.2459999999999999e+02 -2.7360000000000002e+02 7.9199999999999989e+01))
                        ))
         (send fr_caster_r_wheel_link_lk :transform world-cds))
       )

     ;; link: fr_caster_rotation_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_fr_caster_rotation_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq fr_caster_rotation_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "fr_caster_rotation_link"))
       ;; inertial parameter for fr_caster_rotation_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 7.0000000000000000e+01)
                                   :rot (quaternion2matrix (float-vector 6.8630934663031751e-01 6.6285921044798191e-01 2.7864936668790563e-01 1.0932373162572707e-01)))
                      ))
         (send fr_caster_rotation_link_lk :weight 3473.082)
         (setq (fr_caster_rotation_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.2544593986297460e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.1456840427869651e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5392469553832879e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (fr_caster_rotation_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for fr_caster_rotation_link_lk
       (let ((world-cds (make-coords :pos (float-vector 2.2459999999999999e+02 -2.2459999999999999e+02 7.9199999999999989e+01))
                        ))
         (send fr_caster_rotation_link_lk :transform world-cds))
       )

     ;; link: head_chain_cb_link_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq head_chain_cb_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "head_chain_cb_link"))
       (progn (send head_chain_cb_link_lk :weight 0.0) (setq (head_chain_cb_link_lk . acentroid) (float-vector 0 0 0)) (send head_chain_cb_link_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for head_chain_cb_link_lk
       (let ((world-cds (make-coords :pos (float-vector 9.3000000000000027e-01 0.0000000000000000e+00 1.1721250000000000e+03))
                        ))
         (send head_chain_cb_link_lk :transform world-cds))
       )

     ;; link: head_mount_kinect_ir_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_head_mount_kinect_ir_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq head_mount_kinect_ir_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "head_mount_kinect_ir_link"))
       ;; inertial parameter for head_mount_kinect_ir_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 2.7755575615628914e-14 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send head_mount_kinect_ir_link_lk :weight 100.000)
         (setq (head_mount_kinect_ir_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (head_mount_kinect_ir_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for head_mount_kinect_ir_link_lk
       (let ((world-cds (make-coords :pos (float-vector -1.4613700000000003e+02 1.2500000000000000e+01 1.4640780000000000e+03))
                        ))
         (send head_mount_kinect_ir_link_lk :transform world-cds))
       )

     ;; link: head_mount_kinect_ir_optical_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq head_mount_kinect_ir_optical_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "head_mount_kinect_ir_optical_frame"))
       (progn (send head_mount_kinect_ir_optical_frame_lk :weight 0.0) (setq (head_mount_kinect_ir_optical_frame_lk . acentroid) (float-vector 0 0 0)) (send head_mount_kinect_ir_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for head_mount_kinect_ir_optical_frame_lk
       (let ((world-cds (make-coords :pos (float-vector -1.4613700000000003e+02 2.2500000000000000e+01 1.4640780000000000e+03)
                                   :rot (quaternion2matrix (float-vector 5.0000000000244815e-01 -5.0000000000000011e-01 4.9999999999755174e-01 -5.0000000000000011e-01)))
                        ))
         (send head_mount_kinect_ir_optical_frame_lk :transform world-cds))
       )

     ;; link: head_mount_kinect_rgb_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_head_mount_kinect_rgb_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq head_mount_kinect_rgb_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "head_mount_kinect_rgb_link"))
       ;; inertial parameter for head_mount_kinect_rgb_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send head_mount_kinect_rgb_link_lk :weight 100.000)
         (setq (head_mount_kinect_rgb_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (head_mount_kinect_rgb_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for head_mount_kinect_rgb_link_lk
       (let ((world-cds (make-coords :pos (float-vector -1.6450399138460000e+02 -8.7223001369000013e+00 1.4421910357032000e+03)
                                   :rot (quaternion2matrix (float-vector 9.9967297120778287e-01 -5.6000060945167749e-03 -2.4366744094289648e-02 -5.3714384096068416e-03)))
                        ))
         (send head_mount_kinect_rgb_link_lk :transform world-cds))
       )

     ;; link: head_mount_kinect_rgb_optical_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq head_mount_kinect_rgb_optical_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "head_mount_kinect_rgb_optical_frame"))
       (progn (send head_mount_kinect_rgb_optical_frame_lk :weight 0.0) (setq (head_mount_kinect_rgb_optical_frame_lk . acentroid) (float-vector 0 0 0)) (send head_mount_kinect_rgb_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for head_mount_kinect_rgb_optical_frame_lk
       (let ((world-cds (make-coords :pos (float-vector -1.6450399138460000e+02 -8.7223001369000013e+00 1.4421910357032000e+03)
                                   :rot (quaternion2matrix (float-vector 5.0653413540136216e-01 -4.8776739739922853e-01 4.8753882971178447e-01 -5.1750557990309753e-01)))
                        ))
         (send head_mount_kinect_rgb_optical_frame_lk :transform world-cds))
       )

     ;; link: head_mount_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_head_mount_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq head_mount_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "head_mount_link"))
       ;; inertial parameter for head_mount_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 1.3877787807814457e-14 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send head_mount_link_lk :weight 100.000)
         (setq (head_mount_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (head_mount_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for head_mount_link_lk
       (let ((world-cds (make-coords :pos (float-vector -1.1387000000000002e+02 0.0000000000000000e+00 1.3276250000000000e+03))
                        ))
         (send head_mount_link_lk :transform world-cds))
       )

     ;; link: head_mount_prosilica_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_head_mount_prosilica_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq head_mount_prosilica_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "head_mount_prosilica_link"))
       ;; inertial parameter for head_mount_prosilica_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send head_mount_prosilica_link_lk :weight 100.000)
         (setq (head_mount_prosilica_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (head_mount_prosilica_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for head_mount_prosilica_link_lk
       (let ((world-cds (make-coords :pos (float-vector -1.6032700000000000e+02 1.2500000000000000e+01 1.4165460000000000e+03))
                        ))
         (send head_mount_prosilica_link_lk :transform world-cds))
       )

     ;; link: head_mount_prosilica_optical_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq head_mount_prosilica_optical_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "head_mount_prosilica_optical_frame"))
       (progn (send head_mount_prosilica_optical_frame_lk :weight 0.0) (setq (head_mount_prosilica_optical_frame_lk . acentroid) (float-vector 0 0 0)) (send head_mount_prosilica_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for head_mount_prosilica_optical_frame_lk
       (let ((world-cds (make-coords :pos (float-vector -1.6032700000000000e+02 1.2500000000000000e+01 1.4165460000000000e+03)
                                   :rot (quaternion2matrix (float-vector 5.0000000000244815e-01 -5.0000000000000011e-01 4.9999999999755174e-01 -5.0000000000000011e-01)))
                        ))
         (send head_mount_prosilica_optical_frame_lk :transform world-cds))
       )

     ;; link: head_pan_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_head_pan_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq head_pan_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "head_pan_link"))
       ;; inertial parameter for head_pan_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 1.0907000000000007e+01 3.1692999999999998e+01 9.0506999999999891e+01)
                                   :rot (quaternion2matrix (float-vector 9.9332080286057656e-01 -9.7402366566314874e-02 -5.0156631550354866e-02 3.6205992642419915e-02)))
                      ))
         (send head_pan_link_lk :weight 6339.000)
         (setq (head_pan_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 3.2179798694053225e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 4.6122618877570637e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 5.8393525428376131e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (head_pan_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for head_pan_link_lk
       (let ((world-cds (make-coords :pos (float-vector -6.7070000000000007e+01 0.0000000000000000e+00 1.1721250000000000e+03))
                        ))
         (send head_pan_link_lk :transform world-cds))
       )

     ;; link: head_plate_frame_lk
     (let ((geom-lst (list
                       (send self :_make_instance_head_plate_frame_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq head_plate_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "head_plate_frame"))
       ;; inertial parameter for head_plate_frame_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send head_plate_frame_lk :weight 10.000)
         (setq (head_plate_frame_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (head_plate_frame_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for head_plate_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 2.4129999999999999e+01 0.0000000000000000e+00 1.2366250000000000e+03))
                        ))
         (send head_plate_frame_lk :transform world-cds))
       )

     ;; link: head_tilt_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_head_tilt_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq head_tilt_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "head_tilt_link"))
       ;; inertial parameter for head_tilt_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 1.7159999999999997e+00 -1.9556000000000001e+01 5.5001999999999995e+01)
                                   :rot (quaternion2matrix (float-vector 9.9447945946553229e-01 1.0440601476237568e-01 7.0609131813543287e-04 1.0463757338150654e-02)))
                      ))
         (send head_tilt_link_lk :weight 4479.000)
         (setq (head_tilt_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 2.4210046119098920e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 5.4142523398749784e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 6.7900115482151285e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (head_tilt_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for head_tilt_link_lk
       (let ((world-cds (make-coords :pos (float-vector 9.3000000000000027e-01 0.0000000000000000e+00 1.1721250000000000e+03))
                        ))
         (send head_tilt_link_lk :transform world-cds))
       )

     ;; link: high_def_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq high_def_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "high_def_frame"))
       ;; inertial parameter for high_def_frame_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -2.2204460492503131e-13))
                      ))
         (send high_def_frame_lk :weight 10.000)
         (setq (high_def_frame_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (high_def_frame_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for high_def_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 4.7640579288500000e+01 -1.0750883907600000e+02 1.2866355484246001e+03)
                                   :rot (quaternion2matrix (float-vector 9.9997012409009334e-01 2.0284391083384063e-03 -7.4480164138416224e-03 4.0424438923839174e-04)))
                        ))
         (send high_def_frame_lk :transform world-cds))
       )

     ;; link: high_def_optical_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq high_def_optical_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "high_def_optical_frame"))
       ;; inertial parameter for high_def_optical_frame_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 2.2204460492503131e-13 -1.3877787807814457e-14)
                                   :rot (quaternion2matrix (float-vector 1.0000000000000000e+00 -2.7755575615628918e-16 3.8857805861880489e-16 -2.7755575615628918e-16)))
                      ))
         (send high_def_optical_frame_lk :weight 10.000)
         (setq (high_def_optical_frame_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (high_def_optical_frame_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for high_def_optical_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 4.7640579288500000e+01 -1.0750883907600000e+02 1.2866355484246001e+03)
                                   :rot (quaternion2matrix (float-vector 5.0492541200318575e-01 -4.9544895647856996e-01 4.9707315119520945e-01 -5.0249272850318305e-01)))
                        ))
         (send high_def_optical_frame_lk :transform world-cds))
       )

     ;; link: imu_link_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq imu_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "imu_link"))
       ;; inertial parameter for imu_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send imu_link_lk :weight 1.000)
         (setq (imu_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+05 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+03 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+05))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (imu_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for imu_link_lk
       (let ((world-cds (make-coords :pos (float-vector -7.9770000000000010e+01 -1.4969999999999999e+02 9.5467500000000007e+02)
                                   :rot (quaternion2matrix (float-vector -1.0286788442024686e-13 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)))
                        ))
         (send imu_link_lk :transform world-cds))
       )

     ;; link: l_elbow_flex_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_l_elbow_flex_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_elbow_flex_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_elbow_flex_link"))
       ;; inertial parameter for l_elbow_flex_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 1.0139999999999983e+01 3.1999999999998696e-01 -1.2109999999999953e+01)
                                   :rot (quaternion2matrix (float-vector 6.7023857211269999e-01 -6.5469615865643171e-01 -2.3355256344108982e-01 2.6001230048391416e-01)))
                      ))
         (send l_elbow_flex_link_lk :weight 1903.270)
         (setq (l_elbow_flex_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 3.0897687844015122e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 3.9647676565655996e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 4.4185162390328888e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_elbow_flex_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_elbow_flex_link_lk
       (let ((world-cds (make-coords :pos (float-vector 4.5000000000000000e+02 1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send l_elbow_flex_link_lk :transform world-cds))
       )

     ;; link: l_forearm_cam_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_forearm_cam_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_forearm_cam_frame"))
       ;; inertial parameter for l_forearm_cam_frame_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send l_forearm_cam_frame_lk :weight 10.000)
         (setq (l_forearm_cam_frame_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_forearm_cam_frame_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_forearm_cam_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 5.8888260177999996e+02 2.0468654474639999e+02 8.3695536614599996e+02)
                                   :rot (quaternion2matrix (float-vector 7.0376576488431553e-01 -6.6021535308457147e-01 -1.7154001878113354e-01 -1.9850304200383823e-01)))
                        ))
         (send l_forearm_cam_frame_lk :transform world-cds))
       )

     ;; link: l_forearm_cam_optical_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_forearm_cam_optical_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_forearm_cam_optical_frame"))
       (progn (send l_forearm_cam_optical_frame_lk :weight 0.0) (setq (l_forearm_cam_optical_frame_lk . acentroid) (float-vector 0 0 0)) (send l_forearm_cam_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for l_forearm_cam_optical_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 5.8888260177999996e+02 2.0468654474639999e+02 8.3695536614599996e+02)
                                   :rot (quaternion2matrix (float-vector 8.2936942898225313e-03 -4.9696902859405995e-01 3.5256717509081381e-02 -8.6701208937579910e-01)))
                        ))
         (send l_forearm_cam_optical_frame_lk :transform world-cds))
       )

     ;; link: l_forearm_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_l_forearm_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_forearm_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_forearm_link"))
       ;; inertial parameter for l_forearm_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 1.8790999999999997e+02 -1.7000000000000348e-01 -9.1200000000000170e+00)
                                   :rot (quaternion2matrix (float-vector 7.0455582233769354e-01 -7.0911110961966251e-01 -1.7761550919348956e-02 2.1143668862499916e-02)))
                      ))
         (send l_forearm_link_lk :weight 2579.680)
         (setq (l_forearm_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 3.6089171216999060e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.6632586642306658e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5077544915993441e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_forearm_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_forearm_link_lk
       (let ((world-cds (make-coords :pos (float-vector 4.5000000000000000e+02 1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send l_forearm_link_lk :transform world-cds))
       )

     ;; link: l_forearm_roll_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_l_forearm_roll_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_forearm_roll_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_forearm_roll_link"))
       ;; inertial parameter for l_forearm_roll_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send l_forearm_roll_link_lk :weight 100.000)
         (setq (l_forearm_roll_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_forearm_roll_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_forearm_roll_link_lk
       (let ((world-cds (make-coords :pos (float-vector 4.5000000000000000e+02 1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send l_forearm_roll_link_lk :transform world-cds))
       )

     ;; link: l_gripper_l_finger_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_l_gripper_l_finger_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_gripper_l_finger_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_gripper_l_finger_link"))
       ;; inertial parameter for l_gripper_l_finger_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 3.5979999999999905e+01 1.7299999999999983e+01 -1.6399999999999748e+00)
                                   :rot (quaternion2matrix (float-vector 6.3262934235930901e-01 7.7302450075385043e-01 2.5774405529421746e-02 3.9356275737085514e-02)))
                      ))
         (send l_gripper_l_finger_link_lk :weight 171.260)
         (setq (l_gripper_l_finger_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 7.6623944609730548e+04 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.8133591439139261e+05 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.9773963099887679e+05))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_gripper_l_finger_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_gripper_l_finger_link_lk
       (let ((world-cds (make-coords :pos (float-vector 8.4791000000000008e+02 1.9800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send l_gripper_l_finger_link_lk :transform world-cds))
       )

     ;; link: l_gripper_l_finger_tip_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_gripper_l_finger_tip_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_gripper_l_finger_tip_frame"))
       (progn (send l_gripper_l_finger_tip_frame_lk :weight 0.0) (setq (l_gripper_l_finger_tip_frame_lk . acentroid) (float-vector 0 0 0)) (send l_gripper_l_finger_tip_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for l_gripper_l_finger_tip_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 9.3928000000000009e+02 1.7304999999999998e+02 7.9067500000000007e+02))
                        ))
         (send l_gripper_l_finger_tip_frame_lk :transform world-cds))
       )

     ;; link: l_gripper_l_finger_tip_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_l_gripper_l_finger_tip_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_gripper_l_finger_tip_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_gripper_l_finger_tip_link"))
       ;; inertial parameter for l_gripper_l_finger_tip_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 4.2299999999998450e+00 2.8399999999999812e+00 0.0000000000000000e+00)
                                   :rot (quaternion2matrix (float-vector 9.3563462459842295e-01 0.0000000000000000e+00 0.0000000000000000e+00 3.5297004016285605e-01)))
                      ))
         (send l_gripper_l_finger_tip_link_lk :weight 44.190)
         (setq (l_gripper_l_finger_tip_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 3.2362449620368520e+03 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.5004895037963150e+04 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5417679999999997e+04))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_gripper_l_finger_tip_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_gripper_l_finger_tip_link_lk
       (let ((world-cds (make-coords :pos (float-vector 9.3928000000000009e+02 2.0295000000000002e+02 7.9067500000000007e+02))
                        ))
         (send l_gripper_l_finger_tip_link_lk :transform world-cds))
       )

     ;; link: l_gripper_led_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_gripper_led_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_gripper_led_frame"))
       (progn (send l_gripper_led_frame_lk :weight 0.0) (setq (l_gripper_led_frame_lk . acentroid) (float-vector 0 0 0)) (send l_gripper_led_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for l_gripper_led_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 8.2230000000000007e+02 1.8800000000000000e+02 8.1507500000000005e+02))
                        ))
         (send l_gripper_led_frame_lk :transform world-cds))
       )

     ;; link: l_gripper_motor_accelerometer_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_l_gripper_motor_accelerometer_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_gripper_motor_accelerometer_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_gripper_motor_accelerometer_link"))
       ;; inertial parameter for l_gripper_motor_accelerometer_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send l_gripper_motor_accelerometer_link_lk :weight 1.000)
         (setq (l_gripper_motor_accelerometer_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_gripper_motor_accelerometer_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_gripper_motor_accelerometer_link_lk
       (let ((world-cds (make-coords :pos (float-vector 7.7100000000000000e+02 1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send l_gripper_motor_accelerometer_link_lk :transform world-cds))
       )

     ;; link: l_gripper_motor_screw_link_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_gripper_motor_screw_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_gripper_motor_screw_link"))
       ;; inertial parameter for l_gripper_motor_screw_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send l_gripper_motor_screw_link_lk :weight 10.000)
         (setq (l_gripper_motor_screw_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+05 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+05 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+05))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_gripper_motor_screw_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_gripper_motor_screw_link_lk
       (let ((world-cds (make-coords :pos (float-vector 9.3927999999999997e+02 1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send l_gripper_motor_screw_link_lk :transform world-cds))
       )

     ;; link: l_gripper_motor_slider_link_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_gripper_motor_slider_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_gripper_motor_slider_link"))
       ;; inertial parameter for l_gripper_motor_slider_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send l_gripper_motor_slider_link_lk :weight 10.000)
         (setq (l_gripper_motor_slider_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_gripper_motor_slider_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_gripper_motor_slider_link_lk
       (let ((world-cds (make-coords :pos (float-vector 9.3927999999999997e+02 1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send l_gripper_motor_slider_link_lk :transform world-cds))
       )

     ;; link: l_gripper_palm_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_l_gripper_palm_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_gripper_palm_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_gripper_palm_link"))
       ;; inertial parameter for l_gripper_palm_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 6.6230000000000018e+01 5.3000000000000269e-01 -1.1900000000000244e+00)
                                   :rot (quaternion2matrix (float-vector 1.4899072945442145e-03 9.9970499746458896e-01 2.4226387096224839e-02 8.8339619865787514e-04)))
                      ))
         (send l_gripper_palm_link_lk :weight 580.070)
         (setq (l_gripper_palm_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 3.5147110342667863e+05 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 6.7817787266766967e+05 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 8.6563651390565163e+05))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_gripper_palm_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_gripper_palm_link_lk
       (let ((world-cds (make-coords :pos (float-vector 7.7100000000000000e+02 1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send l_gripper_palm_link_lk :transform world-cds))
       )

     ;; link: l_gripper_r_finger_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_l_gripper_r_finger_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_gripper_r_finger_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_gripper_r_finger_link"))
       ;; inertial parameter for l_gripper_r_finger_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 3.5759999999999906e+01 -1.7359999999999985e+01 -9.5000000000000639e-01)
                                   :rot (quaternion2matrix (float-vector 7.5776139467964265e-01 6.5127216354607009e-01 3.5226594320275487e-02 2.0033092017423846e-02)))
                      ))
         (send l_gripper_r_finger_link_lk :weight 173.890)
         (setq (l_gripper_r_finger_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 7.6684670622283287e+04 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.8134000171817749e+05 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.9890313765953921e+05))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_gripper_r_finger_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_gripper_r_finger_link_lk
       (let ((world-cds (make-coords :pos (float-vector 8.4791000000000008e+02 1.7800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send l_gripper_r_finger_link_lk :transform world-cds))
       )

     ;; link: l_gripper_r_finger_tip_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_l_gripper_r_finger_tip_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_gripper_r_finger_tip_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_gripper_r_finger_tip_link"))
       ;; inertial parameter for l_gripper_r_finger_tip_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 4.2299999999998450e+00 -2.8399999999999812e+00 0.0000000000000000e+00)
                                   :rot (quaternion2matrix (float-vector 9.3563462459842295e-01 0.0000000000000000e+00 0.0000000000000000e+00 -3.5297004016285605e-01)))
                      ))
         (send l_gripper_r_finger_tip_link_lk :weight 44.190)
         (setq (l_gripper_r_finger_tip_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 3.2362449620368520e+03 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.5004895037963150e+04 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5417679999999997e+04))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_gripper_r_finger_tip_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_gripper_r_finger_tip_link_lk
       (let ((world-cds (make-coords :pos (float-vector 9.3928000000000009e+02 1.7304999999999998e+02 7.9067500000000007e+02))
                        ))
         (send l_gripper_r_finger_tip_link_lk :transform world-cds))
       )

     ;; link: l_gripper_tool_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_gripper_tool_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_gripper_tool_frame"))
       (progn (send l_gripper_tool_frame_lk :weight 0.0) (setq (l_gripper_tool_frame_lk . acentroid) (float-vector 0 0 0)) (send l_gripper_tool_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for l_gripper_tool_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 9.5100000000000011e+02 1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send l_gripper_tool_frame_lk :transform world-cds))
       )

     ;; link: l_shoulder_lift_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_l_shoulder_lift_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_shoulder_lift_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_shoulder_lift_link"))
       ;; inertial parameter for l_shoulder_lift_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 2.1949999999999996e+01 -2.6639999999999997e+01 -3.1270000000000021e+01)
                                   :rot (quaternion2matrix (float-vector 2.9576183828508645e-01 2.3898442472179413e-01 -4.7801368988356990e-01 7.9177919399193220e-01)))
                      ))
         (send l_shoulder_lift_link_lk :weight 2749.880)
         (setq (l_shoulder_lift_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 2.6187368693981063e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 2.0730163313329030e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5168089652689919e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_shoulder_lift_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_shoulder_lift_link_lk
       (let ((world-cds (make-coords :pos (float-vector 5.0000000000000000e+01 1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send l_shoulder_lift_link_lk :transform world-cds))
       )

     ;; link: l_shoulder_pan_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_l_shoulder_pan_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_shoulder_pan_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_shoulder_pan_link"))
       ;; inertial parameter for l_shoulder_pan_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector -1.2010000000000007e+00 2.4513000000000005e+01 -9.8230999999999952e+01)
                                   :rot (quaternion2matrix (float-vector 9.2748205313791365e-01 8.7656121686357058e-02 -7.4059439643071295e-02 3.5582108543162694e-01)))
                      ))
         (send l_shoulder_pan_link_lk :weight 25799.322)
         (setq (l_shoulder_pan_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 9.3420134354104972e+08 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 8.3770052521175265e+08 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 2.4203263939719772e+08))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_shoulder_pan_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_shoulder_pan_link_lk
       (let ((world-cds (make-coords :pos (float-vector -5.0000000000000000e+01 1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send l_shoulder_pan_link_lk :transform world-cds))
       )

     ;; link: l_torso_lift_side_plate_link_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_torso_lift_side_plate_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_torso_lift_side_plate_link"))
       ;; inertial parameter for l_torso_lift_side_plate_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector -6.2499999999999993e+01 0.0000000000000000e+00 5.0000000000000043e+01))
                      ))
         (send l_torso_lift_side_plate_link_lk :weight 100.000)
         (setq (l_torso_lift_side_plate_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_torso_lift_side_plate_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_torso_lift_side_plate_link_lk
       (let ((world-cds (make-coords :pos (float-vector 3.4999999999999960e+00 2.0928500000000000e+02 9.6730000000000007e+02))
                        ))
         (send l_torso_lift_side_plate_link_lk :transform world-cds))
       )

     ;; link: l_upper_arm_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_l_upper_arm_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_upper_arm_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_upper_arm_link"))
       ;; inertial parameter for l_upper_arm_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 2.1405000000000001e+02 1.6580000000000013e+01 -5.6999999999995943e-01)
                                   :rot (quaternion2matrix (float-vector 1.0079044589567206e-01 9.9449021067012888e-01 2.7763076482626922e-02 -7.7277733956259828e-03)))
                      ))
         (send l_upper_arm_link_lk :weight 6017.690)
         (setq (l_upper_arm_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.5107107160877610e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 7.4882121073444754e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 7.6069696785677612e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_upper_arm_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_upper_arm_link_lk
       (let ((world-cds (make-coords :pos (float-vector 5.0000000000000000e+01 1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send l_upper_arm_link_lk :transform world-cds))
       )

     ;; link: l_upper_arm_roll_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_l_upper_arm_roll_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_upper_arm_roll_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_upper_arm_roll_link"))
       ;; inertial parameter for l_upper_arm_roll_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send l_upper_arm_roll_link_lk :weight 100.000)
         (setq (l_upper_arm_roll_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_upper_arm_roll_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_upper_arm_roll_link_lk
       (let ((world-cds (make-coords :pos (float-vector 5.0000000000000000e+01 1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send l_upper_arm_roll_link_lk :transform world-cds))
       )

     ;; link: l_wrist_flex_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_l_wrist_flex_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_wrist_flex_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_wrist_flex_link"))
       ;; inertial parameter for l_wrist_flex_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector -1.5699999999999603e+00 0.0000000000000000e+00 -7.5000000000002842e-01)
                                   :rot (quaternion2matrix (float-vector 6.9597592710835521e-01 -6.9641143568018082e-01 1.2355973330960543e-01 -1.2394197611783576e-01)))
                      ))
         (send l_wrist_flex_link_lk :weight 614.020)
         (setq (l_wrist_flex_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 6.5277143381554517e+05 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 6.4339106681473507e+05 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.9824412936971989e+05))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_wrist_flex_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_wrist_flex_link_lk
       (let ((world-cds (make-coords :pos (float-vector 7.7100000000000000e+02 1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send l_wrist_flex_link_lk :transform world-cds))
       )

     ;; link: l_wrist_roll_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_l_wrist_roll_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq l_wrist_roll_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "l_wrist_roll_link"))
       ;; inertial parameter for l_wrist_roll_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send l_wrist_roll_link_lk :weight 100.000)
         (setq (l_wrist_roll_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (l_wrist_roll_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for l_wrist_roll_link_lk
       (let ((world-cds (make-coords :pos (float-vector 7.7100000000000000e+02 1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send l_wrist_roll_link_lk :transform world-cds))
       )

     ;; link: laser_tilt_link_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq laser_tilt_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "laser_tilt_link"))
       ;; inertial parameter for laser_tilt_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -2.2204460492503131e-13))
                      ))
         (send laser_tilt_link_lk :weight 1.000)
         (setq (laser_tilt_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+05 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+03 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+05))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (laser_tilt_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for laser_tilt_link_lk
       (let ((world-cds (make-coords :pos (float-vector 4.8930000000000000e+01 0.0000000000000000e+00 1.0468768892415001e+03)
                                   :rot (quaternion2matrix (float-vector 9.9998671474247458e-01 0.0000000000000000e+00 0.0000000000000000e+00 -5.1546424272613288e-03)))
                        ))
         (send laser_tilt_link_lk :transform world-cds))
       )

     ;; link: laser_tilt_mount_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_laser_tilt_mount_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq laser_tilt_mount_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "laser_tilt_mount_link"))
       ;; inertial parameter for laser_tilt_mount_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector -1.1359999999999981e+00 1.6700000000000002e+00 -7.1300000000000807e+00)
                                   :rot (quaternion2matrix (float-vector 9.9128618671773705e-01 -5.0096581162311353e-02 4.8442481946443447e-02 -1.1178262173220145e-01)))
                      ))
         (send laser_tilt_mount_link_lk :weight 591.000)
         (setq (laser_tilt_mount_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.2045714172574708e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0817501043531031e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 7.8792147838942648e+05))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (laser_tilt_mount_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for laser_tilt_mount_link_lk
       (let ((world-cds (make-coords :pos (float-vector 4.8930000000000000e+01 0.0000000000000000e+00 1.0176750000000001e+03))
                        ))
         (send laser_tilt_mount_link_lk :transform world-cds))
       )

     ;; link: left_arm_chain_cb_link_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq left_arm_chain_cb_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "left_arm_chain_cb_link"))
       (progn (send left_arm_chain_cb_link_lk :weight 0.0) (setq (left_arm_chain_cb_link_lk . acentroid) (float-vector 0 0 0)) (send left_arm_chain_cb_link_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for left_arm_chain_cb_link_lk
       (let ((world-cds (make-coords :pos (float-vector 7.7100000000000000e+02 1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send left_arm_chain_cb_link_lk :transform world-cds))
       )

     ;; link: narrow_stereo_l_stereo_camera_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq narrow_stereo_l_stereo_camera_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "narrow_stereo_l_stereo_camera_frame"))
       ;; inertial parameter for narrow_stereo_l_stereo_camera_frame_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send narrow_stereo_l_stereo_camera_frame_lk :weight 10.000)
         (setq (narrow_stereo_l_stereo_camera_frame_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (narrow_stereo_l_stereo_camera_frame_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for narrow_stereo_l_stereo_camera_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 5.7820754083899999e+01 6.0632256042200005e+01 1.2807375486935000e+03)
                                   :rot (quaternion2matrix (float-vector 9.9995864257776801e-01 -5.0348889792875724e-03 -5.5210231623546158e-03 -5.1847208444301598e-03)))
                        ))
         (send narrow_stereo_l_stereo_camera_frame_lk :transform world-cds))
       )

     ;; link: narrow_stereo_l_stereo_camera_optical_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq narrow_stereo_l_stereo_camera_optical_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "narrow_stereo_l_stereo_camera_optical_frame"))
       (progn (send narrow_stereo_l_stereo_camera_optical_frame_lk :weight 0.0) (setq (narrow_stereo_l_stereo_camera_optical_frame_lk . acentroid) (float-vector 0 0 0)) (send narrow_stereo_l_stereo_camera_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for narrow_stereo_l_stereo_camera_optical_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 5.7820754083899999e+01 6.0632256042200005e+01 1.2807375486935000e+03)
                                   :rot (quaternion2matrix (float-vector 4.9763002796063699e-01 -4.9714389377516049e-01 4.9729372563781626e-01 -5.0784963778192060e-01)))
                        ))
         (send narrow_stereo_l_stereo_camera_optical_frame_lk :transform world-cds))
       )

     ;; link: narrow_stereo_link_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq narrow_stereo_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "narrow_stereo_link"))
       ;; inertial parameter for narrow_stereo_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send narrow_stereo_link_lk :weight 100.000)
         (setq (narrow_stereo_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (narrow_stereo_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for narrow_stereo_link_lk
       (let ((world-cds (make-coords :pos (float-vector 5.7820754083899999e+01 6.0632256042200005e+01 1.2807375486935000e+03)
                                   :rot (quaternion2matrix (float-vector 9.9995864257776801e-01 -5.0348889792875724e-03 -5.5210231623546158e-03 -5.1847208444301598e-03)))
                        ))
         (send narrow_stereo_link_lk :transform world-cds))
       )

     ;; link: narrow_stereo_optical_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq narrow_stereo_optical_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "narrow_stereo_optical_frame"))
       (progn (send narrow_stereo_optical_frame_lk :weight 0.0) (setq (narrow_stereo_optical_frame_lk . acentroid) (float-vector 0 0 0)) (send narrow_stereo_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for narrow_stereo_optical_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 5.7820754083899999e+01 6.0632256042200005e+01 1.2807375486935000e+03)
                                   :rot (quaternion2matrix (float-vector 4.9763002796063699e-01 -4.9714389377516049e-01 4.9729372563781626e-01 -5.0784963778192060e-01)))
                        ))
         (send narrow_stereo_optical_frame_lk :transform world-cds))
       )

     ;; link: narrow_stereo_r_stereo_camera_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq narrow_stereo_r_stereo_camera_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "narrow_stereo_r_stereo_camera_frame"))
       ;; inertial parameter for narrow_stereo_r_stereo_camera_frame_lk
       (let ((tmp-cds (make-coords :pos (float-vector 1.3877787807814457e-14 0.0000000000000000e+00 -4.4408920985006262e-13))
                      ))
         (send narrow_stereo_r_stereo_camera_frame_lk :weight 10.000)
         (setq (narrow_stereo_r_stereo_camera_frame_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (narrow_stereo_r_stereo_camera_frame_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for narrow_stereo_r_stereo_camera_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 5.6882539335745200e+01 -2.9358342299091692e+01 1.2816386387348696e+03)
                                   :rot (quaternion2matrix (float-vector 9.9995864257776801e-01 -5.0348889792875724e-03 -5.5210231623546158e-03 -5.1847208444301598e-03)))
                        ))
         (send narrow_stereo_r_stereo_camera_frame_lk :transform world-cds))
       )

     ;; link: narrow_stereo_r_stereo_camera_optical_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq narrow_stereo_r_stereo_camera_optical_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "narrow_stereo_r_stereo_camera_optical_frame"))
       (progn (send narrow_stereo_r_stereo_camera_optical_frame_lk :weight 0.0) (setq (narrow_stereo_r_stereo_camera_optical_frame_lk . acentroid) (float-vector 0 0 0)) (send narrow_stereo_r_stereo_camera_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for narrow_stereo_r_stereo_camera_optical_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 5.6882539335745200e+01 -2.9358342299091692e+01 1.2816386387348696e+03)
                                   :rot (quaternion2matrix (float-vector 4.9763002796063699e-01 -4.9714389377516049e-01 4.9729372563781626e-01 -5.0784963778192060e-01)))
                        ))
         (send narrow_stereo_r_stereo_camera_optical_frame_lk :transform world-cds))
       )

     ;; link: projector_wg6802418_child_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq projector_wg6802418_child_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "projector_wg6802418_child_frame"))
       ;; inertial parameter for projector_wg6802418_child_frame_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send projector_wg6802418_child_frame_lk :weight 10.000)
         (setq (projector_wg6802418_child_frame_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (projector_wg6802418_child_frame_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for projector_wg6802418_child_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 2.4129999999999999e+01 1.1000000000000000e+02 1.2912250000000001e+03)
                                   :rot (quaternion2matrix (float-vector 7.0710678118827863e-01 0.0000000000000000e+00 -7.0710678118481640e-01 0.0000000000000000e+00)))
                        ))
         (send projector_wg6802418_child_frame_lk :transform world-cds))
       )

     ;; link: projector_wg6802418_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq projector_wg6802418_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "projector_wg6802418_frame"))
       ;; inertial parameter for projector_wg6802418_frame_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send projector_wg6802418_frame_lk :weight 10.000)
         (setq (projector_wg6802418_frame_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (projector_wg6802418_frame_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for projector_wg6802418_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 2.4129999999999999e+01 1.1000000000000000e+02 1.2912250000000001e+03))
                        ))
         (send projector_wg6802418_frame_lk :transform world-cds))
       )

     ;; link: r_elbow_flex_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_r_elbow_flex_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_elbow_flex_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_elbow_flex_link"))
       ;; inertial parameter for r_elbow_flex_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 1.0139999999999983e+01 3.1999999999998696e-01 -1.2109999999999953e+01)
                                   :rot (quaternion2matrix (float-vector 6.7023857211269999e-01 -6.5469615865643171e-01 -2.3355256344108982e-01 2.6001230048391416e-01)))
                      ))
         (send r_elbow_flex_link_lk :weight 1903.270)
         (setq (r_elbow_flex_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 3.0897687844015122e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 3.9647676565655996e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 4.4185162390328888e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_elbow_flex_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_elbow_flex_link_lk
       (let ((world-cds (make-coords :pos (float-vector 4.5000000000000000e+02 -1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send r_elbow_flex_link_lk :transform world-cds))
       )

     ;; link: r_forearm_cam_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_forearm_cam_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_forearm_cam_frame"))
       ;; inertial parameter for r_forearm_cam_frame_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send r_forearm_cam_frame_lk :weight 10.000)
         (setq (r_forearm_cam_frame_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_forearm_cam_frame_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_forearm_cam_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 5.9278174482800000e+02 -2.0033502870120000e+02 8.2942074642509999e+02)
                                   :rot (quaternion2matrix (float-vector 6.7977275225487255e-01 6.7856950148554640e-01 -1.9274528806062191e-01 2.0075281038112730e-01)))
                        ))
         (send r_forearm_cam_frame_lk :transform world-cds))
       )

     ;; link: r_forearm_cam_optical_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_forearm_cam_optical_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_forearm_cam_optical_frame"))
       (progn (send r_forearm_cam_optical_frame_lk :weight 0.0) (setq (r_forearm_cam_optical_frame_lk . acentroid) (float-vector 0 0 0)) (send r_forearm_cam_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for r_forearm_cam_optical_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 5.9278174482800000e+02 -2.0033502870120000e+02 8.2942074642509999e+02)
                                   :rot (quaternion2matrix (float-vector 8.7592017609227635e-01 -4.6053865427630736e-03 4.8242207764719869e-01 3.4021357744196679e-03)))
                        ))
         (send r_forearm_cam_optical_frame_lk :transform world-cds))
       )

     ;; link: r_forearm_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_r_forearm_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_forearm_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_forearm_link"))
       ;; inertial parameter for r_forearm_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 1.8790999999999997e+02 -1.7000000000000348e-01 -9.1200000000000170e+00)
                                   :rot (quaternion2matrix (float-vector 7.0455582233769354e-01 -7.0911110961966251e-01 -1.7761550919348956e-02 2.1143668862499916e-02)))
                      ))
         (send r_forearm_link_lk :weight 2579.680)
         (setq (r_forearm_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 3.6089171216999060e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.6632586642306658e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5077544915993441e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_forearm_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_forearm_link_lk
       (let ((world-cds (make-coords :pos (float-vector 4.5000000000000000e+02 -1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send r_forearm_link_lk :transform world-cds))
       )

     ;; link: r_forearm_roll_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_r_forearm_roll_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_forearm_roll_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_forearm_roll_link"))
       ;; inertial parameter for r_forearm_roll_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send r_forearm_roll_link_lk :weight 100.000)
         (setq (r_forearm_roll_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_forearm_roll_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_forearm_roll_link_lk
       (let ((world-cds (make-coords :pos (float-vector 4.5000000000000000e+02 -1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send r_forearm_roll_link_lk :transform world-cds))
       )

     ;; link: r_gripper_l_finger_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_r_gripper_l_finger_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_gripper_l_finger_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_gripper_l_finger_link"))
       ;; inertial parameter for r_gripper_l_finger_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 3.5979999999999905e+01 1.7299999999999983e+01 -1.6399999999999748e+00)
                                   :rot (quaternion2matrix (float-vector 6.3262934235930901e-01 7.7302450075385043e-01 2.5774405529421746e-02 3.9356275737085514e-02)))
                      ))
         (send r_gripper_l_finger_link_lk :weight 171.260)
         (setq (r_gripper_l_finger_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 7.6623944609730548e+04 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.8133591439139261e+05 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.9773963099887679e+05))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_gripper_l_finger_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_gripper_l_finger_link_lk
       (let ((world-cds (make-coords :pos (float-vector 8.4791000000000008e+02 -1.7800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send r_gripper_l_finger_link_lk :transform world-cds))
       )

     ;; link: r_gripper_l_finger_tip_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_gripper_l_finger_tip_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_gripper_l_finger_tip_frame"))
       (progn (send r_gripper_l_finger_tip_frame_lk :weight 0.0) (setq (r_gripper_l_finger_tip_frame_lk . acentroid) (float-vector 0 0 0)) (send r_gripper_l_finger_tip_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for r_gripper_l_finger_tip_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 9.3928000000000009e+02 -2.0295000000000002e+02 7.9067500000000007e+02))
                        ))
         (send r_gripper_l_finger_tip_frame_lk :transform world-cds))
       )

     ;; link: r_gripper_l_finger_tip_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_r_gripper_l_finger_tip_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_gripper_l_finger_tip_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_gripper_l_finger_tip_link"))
       ;; inertial parameter for r_gripper_l_finger_tip_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 4.2299999999998450e+00 2.8399999999999812e+00 0.0000000000000000e+00)
                                   :rot (quaternion2matrix (float-vector 9.3563462459842295e-01 0.0000000000000000e+00 0.0000000000000000e+00 3.5297004016285605e-01)))
                      ))
         (send r_gripper_l_finger_tip_link_lk :weight 44.190)
         (setq (r_gripper_l_finger_tip_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 3.2362449620368520e+03 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.5004895037963150e+04 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5417679999999997e+04))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_gripper_l_finger_tip_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_gripper_l_finger_tip_link_lk
       (let ((world-cds (make-coords :pos (float-vector 9.3928000000000009e+02 -1.7304999999999998e+02 7.9067500000000007e+02))
                        ))
         (send r_gripper_l_finger_tip_link_lk :transform world-cds))
       )

     ;; link: r_gripper_led_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_gripper_led_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_gripper_led_frame"))
       (progn (send r_gripper_led_frame_lk :weight 0.0) (setq (r_gripper_led_frame_lk . acentroid) (float-vector 0 0 0)) (send r_gripper_led_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for r_gripper_led_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 8.2230000000000007e+02 -1.8800000000000000e+02 8.1507500000000005e+02))
                        ))
         (send r_gripper_led_frame_lk :transform world-cds))
       )

     ;; link: r_gripper_motor_accelerometer_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_r_gripper_motor_accelerometer_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_gripper_motor_accelerometer_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_gripper_motor_accelerometer_link"))
       ;; inertial parameter for r_gripper_motor_accelerometer_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send r_gripper_motor_accelerometer_link_lk :weight 1.000)
         (setq (r_gripper_motor_accelerometer_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_gripper_motor_accelerometer_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_gripper_motor_accelerometer_link_lk
       (let ((world-cds (make-coords :pos (float-vector 7.7100000000000000e+02 -1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send r_gripper_motor_accelerometer_link_lk :transform world-cds))
       )

     ;; link: r_gripper_motor_screw_link_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_gripper_motor_screw_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_gripper_motor_screw_link"))
       ;; inertial parameter for r_gripper_motor_screw_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send r_gripper_motor_screw_link_lk :weight 10.000)
         (setq (r_gripper_motor_screw_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+05 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+05 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+05))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_gripper_motor_screw_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_gripper_motor_screw_link_lk
       (let ((world-cds (make-coords :pos (float-vector 9.3927999999999997e+02 -1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send r_gripper_motor_screw_link_lk :transform world-cds))
       )

     ;; link: r_gripper_motor_slider_link_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_gripper_motor_slider_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_gripper_motor_slider_link"))
       ;; inertial parameter for r_gripper_motor_slider_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send r_gripper_motor_slider_link_lk :weight 10.000)
         (setq (r_gripper_motor_slider_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_gripper_motor_slider_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_gripper_motor_slider_link_lk
       (let ((world-cds (make-coords :pos (float-vector 9.3927999999999997e+02 -1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send r_gripper_motor_slider_link_lk :transform world-cds))
       )

     ;; link: r_gripper_palm_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_r_gripper_palm_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_gripper_palm_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_gripper_palm_link"))
       ;; inertial parameter for r_gripper_palm_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 6.6230000000000018e+01 5.3000000000000269e-01 -1.1900000000000244e+00)
                                   :rot (quaternion2matrix (float-vector 1.4899072945442145e-03 9.9970499746458896e-01 2.4226387096224839e-02 8.8339619865787514e-04)))
                      ))
         (send r_gripper_palm_link_lk :weight 580.070)
         (setq (r_gripper_palm_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 3.5147110342667863e+05 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 6.7817787266766967e+05 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 8.6563651390565163e+05))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_gripper_palm_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_gripper_palm_link_lk
       (let ((world-cds (make-coords :pos (float-vector 7.7100000000000000e+02 -1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send r_gripper_palm_link_lk :transform world-cds))
       )

     ;; link: r_gripper_r_finger_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_r_gripper_r_finger_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_gripper_r_finger_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_gripper_r_finger_link"))
       ;; inertial parameter for r_gripper_r_finger_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 3.5759999999999906e+01 -1.7359999999999985e+01 -9.5000000000000639e-01)
                                   :rot (quaternion2matrix (float-vector 7.5776139467964265e-01 6.5127216354607009e-01 3.5226594320275487e-02 2.0033092017423846e-02)))
                      ))
         (send r_gripper_r_finger_link_lk :weight 173.890)
         (setq (r_gripper_r_finger_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 7.6684670622283287e+04 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.8134000171817749e+05 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.9890313765953921e+05))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_gripper_r_finger_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_gripper_r_finger_link_lk
       (let ((world-cds (make-coords :pos (float-vector 8.4791000000000008e+02 -1.9800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send r_gripper_r_finger_link_lk :transform world-cds))
       )

     ;; link: r_gripper_r_finger_tip_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_r_gripper_r_finger_tip_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_gripper_r_finger_tip_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_gripper_r_finger_tip_link"))
       ;; inertial parameter for r_gripper_r_finger_tip_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 4.2299999999998450e+00 -2.8399999999999812e+00 0.0000000000000000e+00)
                                   :rot (quaternion2matrix (float-vector 9.3563462459842295e-01 0.0000000000000000e+00 0.0000000000000000e+00 -3.5297004016285605e-01)))
                      ))
         (send r_gripper_r_finger_tip_link_lk :weight 44.190)
         (setq (r_gripper_r_finger_tip_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 3.2362449620368520e+03 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.5004895037963150e+04 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5417679999999997e+04))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_gripper_r_finger_tip_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_gripper_r_finger_tip_link_lk
       (let ((world-cds (make-coords :pos (float-vector 9.3928000000000009e+02 -2.0295000000000002e+02 7.9067500000000007e+02))
                        ))
         (send r_gripper_r_finger_tip_link_lk :transform world-cds))
       )

     ;; link: r_gripper_tool_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_gripper_tool_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_gripper_tool_frame"))
       (progn (send r_gripper_tool_frame_lk :weight 0.0) (setq (r_gripper_tool_frame_lk . acentroid) (float-vector 0 0 0)) (send r_gripper_tool_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for r_gripper_tool_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 9.5100000000000011e+02 -1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send r_gripper_tool_frame_lk :transform world-cds))
       )

     ;; link: r_shoulder_lift_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_r_shoulder_lift_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_shoulder_lift_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_shoulder_lift_link"))
       ;; inertial parameter for r_shoulder_lift_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 2.1949999999999996e+01 -2.6639999999999997e+01 -3.1270000000000021e+01)
                                   :rot (quaternion2matrix (float-vector 2.9576183828508645e-01 2.3898442472179413e-01 -4.7801368988356990e-01 7.9177919399193220e-01)))
                      ))
         (send r_shoulder_lift_link_lk :weight 2749.880)
         (setq (r_shoulder_lift_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 2.6187368693981063e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 2.0730163313329030e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.5168089652689919e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_shoulder_lift_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_shoulder_lift_link_lk
       (let ((world-cds (make-coords :pos (float-vector 5.0000000000000000e+01 -1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send r_shoulder_lift_link_lk :transform world-cds))
       )

     ;; link: r_shoulder_pan_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_r_shoulder_pan_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_shoulder_pan_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_shoulder_pan_link"))
       ;; inertial parameter for r_shoulder_pan_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector -1.2010000000000007e+00 2.4513000000000005e+01 -9.8230999999999952e+01)
                                   :rot (quaternion2matrix (float-vector 9.2748205313791365e-01 8.7656121686357058e-02 -7.4059439643071295e-02 3.5582108543162694e-01)))
                      ))
         (send r_shoulder_pan_link_lk :weight 25799.322)
         (setq (r_shoulder_pan_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 9.3420134354104972e+08 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 8.3770052521175265e+08 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 2.4203263939719772e+08))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_shoulder_pan_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_shoulder_pan_link_lk
       (let ((world-cds (make-coords :pos (float-vector -5.0000000000000000e+01 -1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send r_shoulder_pan_link_lk :transform world-cds))
       )

     ;; link: r_torso_lift_side_plate_link_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_torso_lift_side_plate_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_torso_lift_side_plate_link"))
       ;; inertial parameter for r_torso_lift_side_plate_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector -6.2499999999999993e+01 0.0000000000000000e+00 5.0000000000000043e+01))
                      ))
         (send r_torso_lift_side_plate_link_lk :weight 100.000)
         (setq (r_torso_lift_side_plate_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_torso_lift_side_plate_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_torso_lift_side_plate_link_lk
       (let ((world-cds (make-coords :pos (float-vector 3.4999999999999960e+00 -2.0928500000000000e+02 9.6730000000000007e+02))
                        ))
         (send r_torso_lift_side_plate_link_lk :transform world-cds))
       )

     ;; link: r_upper_arm_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_r_upper_arm_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_upper_arm_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_upper_arm_link"))
       ;; inertial parameter for r_upper_arm_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 2.1397999999999999e+02 -1.6210000000000001e+01 -1.9999999999997797e-01)
                                   :rot (quaternion2matrix (float-vector 9.9501733410487181e-01 -9.4438775088367580e-02 8.6566840214665347e-03 3.0771487003312628e-02)))
                      ))
         (send r_upper_arm_link_lk :weight 6017.690)
         (setq (r_upper_arm_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.5132686535267271e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 7.4930655272408575e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 7.6138485232324168e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_upper_arm_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_upper_arm_link_lk
       (let ((world-cds (make-coords :pos (float-vector 5.0000000000000000e+01 -1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send r_upper_arm_link_lk :transform world-cds))
       )

     ;; link: r_upper_arm_roll_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_r_upper_arm_roll_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_upper_arm_roll_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_upper_arm_roll_link"))
       ;; inertial parameter for r_upper_arm_roll_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send r_upper_arm_roll_link_lk :weight 100.000)
         (setq (r_upper_arm_roll_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_upper_arm_roll_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_upper_arm_roll_link_lk
       (let ((world-cds (make-coords :pos (float-vector 5.0000000000000000e+01 -1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send r_upper_arm_roll_link_lk :transform world-cds))
       )

     ;; link: r_wrist_flex_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_r_wrist_flex_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_wrist_flex_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_wrist_flex_link"))
       ;; inertial parameter for r_wrist_flex_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector -1.5699999999999603e+00 0.0000000000000000e+00 -7.5000000000002842e-01)
                                   :rot (quaternion2matrix (float-vector 6.9597592710835521e-01 -6.9641143568018082e-01 1.2355973330960543e-01 -1.2394197611783576e-01)))
                      ))
         (send r_wrist_flex_link_lk :weight 614.020)
         (setq (r_wrist_flex_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 6.5277143381554517e+05 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 6.4339106681473507e+05 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.9824412936971989e+05))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_wrist_flex_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_wrist_flex_link_lk
       (let ((world-cds (make-coords :pos (float-vector 7.7100000000000000e+02 -1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send r_wrist_flex_link_lk :transform world-cds))
       )

     ;; link: r_wrist_roll_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_r_wrist_roll_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq r_wrist_roll_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "r_wrist_roll_link"))
       ;; inertial parameter for r_wrist_roll_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send r_wrist_roll_link_lk :weight 100.000)
         (setq (r_wrist_roll_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (r_wrist_roll_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for r_wrist_roll_link_lk
       (let ((world-cds (make-coords :pos (float-vector 7.7100000000000000e+02 -1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send r_wrist_roll_link_lk :transform world-cds))
       )

     ;; link: right_arm_chain_cb_link_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq right_arm_chain_cb_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "right_arm_chain_cb_link"))
       (progn (send right_arm_chain_cb_link_lk :weight 0.0) (setq (right_arm_chain_cb_link_lk . acentroid) (float-vector 0 0 0)) (send right_arm_chain_cb_link_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for right_arm_chain_cb_link_lk
       (let ((world-cds (make-coords :pos (float-vector 7.7100000000000000e+02 -1.8800000000000000e+02 7.9067500000000007e+02))
                        ))
         (send right_arm_chain_cb_link_lk :transform world-cds))
       )

     ;; link: sensor_mount_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_sensor_mount_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq sensor_mount_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "sensor_mount_link"))
       ;; inertial parameter for sensor_mount_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send sensor_mount_link_lk :weight 50.000)
         (setq (sensor_mount_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (sensor_mount_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for sensor_mount_link_lk
       (let ((world-cds (make-coords :pos (float-vector 2.4129999999999999e+01 0.0000000000000000e+00 1.2366250000000000e+03))
                        ))
         (send sensor_mount_link_lk :transform world-cds))
       )

     ;; link: torso_lift_link_lk
     (let ((geom-lst (list
                       (send self :_make_instance_torso_lift_link_geom0))))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq torso_lift_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "torso_lift_link"))
       ;; inertial parameter for torso_lift_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector -9.9999999999999986e+01 0.0000000000000000e+00 -8.8500000000000028e+01)
                                   :rot (quaternion2matrix (float-vector 7.1202942589785090e-01 7.0124419064990795e-01 -2.2444350358472802e-02 -2.7693552901690011e-02)))
                      ))
         (send torso_lift_link_lk :weight 36248.046)
         (setq (torso_lift_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 2.7830748220493431e+09 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 5.1458072243189907e+08 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 2.5104500693077579e+09))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (torso_lift_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for torso_lift_link_lk
       (let ((world-cds (make-coords :pos (float-vector -5.0000000000000000e+01 0.0000000000000000e+00 7.9067500000000007e+02))
                        ))
         (send torso_lift_link_lk :transform world-cds))
       )

     ;; link: torso_lift_motor_screw_link_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq torso_lift_motor_screw_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "torso_lift_motor_screw_link"))
       ;; inertial parameter for torso_lift_motor_screw_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))
                      ))
         (send torso_lift_motor_screw_link_lk :weight 1000.000)
         (setq (torso_lift_motor_screw_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (torso_lift_motor_screw_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for torso_lift_motor_screw_link_lk
       (let ((world-cds (make-coords :pos (float-vector -1.5000000000000000e+02 0.0000000000000000e+00 7.5100000000000000e+02))
                        ))
         (send torso_lift_motor_screw_link_lk :transform world-cds))
       )

     ;; link: wide_stereo_l_stereo_camera_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq wide_stereo_l_stereo_camera_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "wide_stereo_l_stereo_camera_frame"))
       ;; inertial parameter for wide_stereo_l_stereo_camera_frame_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 3.4694469519536142e-15 -2.2204460492503131e-13)
                                   :rot (quaternion2matrix (float-vector 1.0000000000000000e+00 3.3881317890172014e-21 8.6736173798840355e-19 0.0000000000000000e+00)))
                      ))
         (send wide_stereo_l_stereo_camera_frame_lk :weight 10.000)
         (setq (wide_stereo_l_stereo_camera_frame_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (wide_stereo_l_stereo_camera_frame_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for wide_stereo_l_stereo_camera_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 5.9219675205800002e+01 3.0581954459599999e+01 1.2807163111347002e+03)
                                   :rot (quaternion2matrix (float-vector 9.9996564324259862e-01 -3.7075010798754715e-03 -6.2133588949438764e-03 -4.0448660548236034e-03)))
                        ))
         (send wide_stereo_l_stereo_camera_frame_lk :transform world-cds))
       )

     ;; link: wide_stereo_l_stereo_camera_optical_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq wide_stereo_l_stereo_camera_optical_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "wide_stereo_l_stereo_camera_optical_frame"))
       (progn (send wide_stereo_l_stereo_camera_optical_frame_lk :weight 0.0) (setq (wide_stereo_l_stereo_camera_optical_frame_lk . acentroid) (float-vector 0 0 0)) (send wide_stereo_l_stereo_camera_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for wide_stereo_l_stereo_camera_optical_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 5.9219675205800002e+01 3.0581954459599999e+01 1.2807163111347002e+03)
                                   :rot (quaternion2matrix (float-vector 4.9921331750385456e-01 -4.9670745968637237e-01 4.9704482465883804e-01 -5.0696568463612168e-01)))
                        ))
         (send wide_stereo_l_stereo_camera_optical_frame_lk :transform world-cds))
       )

     ;; link: wide_stereo_link_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq wide_stereo_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "wide_stereo_link"))
       ;; inertial parameter for wide_stereo_link_lk
       (let ((tmp-cds (make-coords :pos (float-vector 0.0000000000000000e+00 3.4694469519536142e-15 -2.2204460492503131e-13)
                                   :rot (quaternion2matrix (float-vector 1.0000000000000000e+00 3.3881317890172014e-21 8.6736173798840355e-19 0.0000000000000000e+00)))
                      ))
         (send wide_stereo_link_lk :weight 100.000)
         (setq (wide_stereo_link_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+07 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+07 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+07))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (wide_stereo_link_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for wide_stereo_link_lk
       (let ((world-cds (make-coords :pos (float-vector 5.9219675205800002e+01 3.0581954459599999e+01 1.2807163111347002e+03)
                                   :rot (quaternion2matrix (float-vector 9.9996564324259862e-01 -3.7075010798754715e-03 -6.2133588949438764e-03 -4.0448660548236034e-03)))
                        ))
         (send wide_stereo_link_lk :transform world-cds))
       )

     ;; link: wide_stereo_optical_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq wide_stereo_optical_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "wide_stereo_optical_frame"))
       (progn (send wide_stereo_optical_frame_lk :weight 0.0) (setq (wide_stereo_optical_frame_lk . acentroid) (float-vector 0 0 0)) (send wide_stereo_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for wide_stereo_optical_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 5.9219675205800002e+01 3.0581954459599999e+01 1.2807163111347002e+03)
                                   :rot (quaternion2matrix (float-vector 4.9921331750385456e-01 -4.9670745968637237e-01 4.9704482465883804e-01 -5.0696568463612168e-01)))
                        ))
         (send wide_stereo_optical_frame_lk :transform world-cds))
       )

     ;; link: wide_stereo_r_stereo_camera_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq wide_stereo_r_stereo_camera_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "wide_stereo_r_stereo_camera_frame"))
       ;; inertial parameter for wide_stereo_r_stereo_camera_frame_lk
       (let ((tmp-cds (make-coords :pos (float-vector -2.7755575615628914e-14 0.0000000000000000e+00 -4.4408920985006262e-13)
                                   :rot (quaternion2matrix (float-vector 1.0000000000000000e+00 3.3881317890172014e-21 8.6736173798840355e-19 0.0000000000000000e+00)))
                      ))
         (send wide_stereo_r_stereo_camera_frame_lk :weight 10.000)
         (setq (wide_stereo_r_stereo_camera_frame_lk . inertia-tensor)
               (m* (m* (send tmp-cds :worldrot) (matrix
                                                  (float-vector 1.0000000000000000e+06 0.0000000000000000e+00 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 1.0000000000000000e+06 0.0000000000000000e+00)
                                                  (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+06))
                 ) (transpose (send tmp-cds :worldrot))))
         (setq (wide_stereo_r_stereo_camera_frame_lk . acentroid) (copy-seq (send tmp-cds :worldpos)))
         )
       ;; global coordinates for wide_stereo_r_stereo_camera_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 5.8487477843992188e+01 -5.9412626369381421e+01 1.2813791146042824e+03)
                                   :rot (quaternion2matrix (float-vector 9.9996564324259862e-01 -3.7075010798754715e-03 -6.2133588949438764e-03 -4.0448660548236034e-03)))
                        ))
         (send wide_stereo_r_stereo_camera_frame_lk :transform world-cds))
       )

     ;; link: wide_stereo_r_stereo_camera_optical_frame_lk
     (let ((geom-lst (list
)))
       (dolist (g (cdr geom-lst)) (send (car geom-lst) :assoc g))
       (setq wide_stereo_r_stereo_camera_optical_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies geom-lst
                       :name "wide_stereo_r_stereo_camera_optical_frame"))
       (progn (send wide_stereo_r_stereo_camera_optical_frame_lk :weight 0.0) (setq (wide_stereo_r_stereo_camera_optical_frame_lk . acentroid) (float-vector 0 0 0)) (send wide_stereo_r_stereo_camera_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))
       ;; global coordinates for wide_stereo_r_stereo_camera_optical_frame_lk
       (let ((world-cds (make-coords :pos (float-vector 5.8487477843992188e+01 -5.9412626369381421e+01 1.2813791146042824e+03)
                                   :rot (quaternion2matrix (float-vector 4.9921331750385456e-01 -4.9670745968637237e-01 4.9704482465883804e-01 -5.0696568463612168e-01)))
                        ))
         (send wide_stereo_r_stereo_camera_optical_frame_lk :transform world-cds))
       )

     (send base_link_lk :assoc base_bellow_link_lk)
     (send base_footprint_lk :assoc base_link_lk)
     (send base_link_lk :assoc base_laser_link_lk)
     (send bl_caster_rotation_link_lk :assoc bl_caster_l_wheel_link_lk)
     (send bl_caster_rotation_link_lk :assoc bl_caster_r_wheel_link_lk)
     (send base_link_lk :assoc bl_caster_rotation_link_lk)
     (send br_caster_rotation_link_lk :assoc br_caster_l_wheel_link_lk)
     (send br_caster_rotation_link_lk :assoc br_caster_r_wheel_link_lk)
     (send base_link_lk :assoc br_caster_rotation_link_lk)
     (send sensor_mount_link_lk :assoc double_stereo_link_lk)
     (send fl_caster_rotation_link_lk :assoc fl_caster_l_wheel_link_lk)
     (send fl_caster_rotation_link_lk :assoc fl_caster_r_wheel_link_lk)
     (send base_link_lk :assoc fl_caster_rotation_link_lk)
     (send fr_caster_rotation_link_lk :assoc fr_caster_l_wheel_link_lk)
     (send fr_caster_rotation_link_lk :assoc fr_caster_r_wheel_link_lk)
     (send base_link_lk :assoc fr_caster_rotation_link_lk)
     (send head_tilt_link_lk :assoc head_chain_cb_link_lk)
     (send head_plate_frame_lk :assoc head_mount_link_lk)
     (send head_mount_link_lk :assoc head_mount_kinect_ir_link_lk)
     (send head_mount_kinect_ir_link_lk :assoc head_mount_kinect_ir_optical_frame_lk)
     (send head_mount_kinect_ir_link_lk :assoc head_mount_kinect_rgb_link_lk)
     (send head_mount_kinect_rgb_link_lk :assoc head_mount_kinect_rgb_optical_frame_lk)
     (send head_mount_link_lk :assoc head_mount_prosilica_link_lk)
     (send head_mount_prosilica_link_lk :assoc head_mount_prosilica_optical_frame_lk)
     (send torso_lift_link_lk :assoc head_pan_link_lk)
     (send head_tilt_link_lk :assoc head_plate_frame_lk)
     (send head_pan_link_lk :assoc head_tilt_link_lk)
     (send sensor_mount_link_lk :assoc high_def_frame_lk)
     (send high_def_frame_lk :assoc high_def_optical_frame_lk)
     (send torso_lift_link_lk :assoc imu_link_lk)
     (send l_upper_arm_link_lk :assoc l_elbow_flex_link_lk)
     (send l_forearm_roll_link_lk :assoc l_forearm_cam_frame_lk)
     (send l_forearm_cam_frame_lk :assoc l_forearm_cam_optical_frame_lk)
     (send l_forearm_roll_link_lk :assoc l_forearm_link_lk)
     (send l_elbow_flex_link_lk :assoc l_forearm_roll_link_lk)
     (send l_gripper_r_finger_tip_link_lk :assoc l_gripper_l_finger_tip_frame_lk)
     (send l_gripper_palm_link_lk :assoc l_gripper_l_finger_link_lk)
     (send l_gripper_l_finger_link_lk :assoc l_gripper_l_finger_tip_link_lk)
     (send l_gripper_palm_link_lk :assoc l_gripper_led_frame_lk)
     (send l_gripper_palm_link_lk :assoc l_gripper_motor_accelerometer_link_lk)
     (send l_gripper_motor_slider_link_lk :assoc l_gripper_motor_screw_link_lk)
     (send l_gripper_palm_link_lk :assoc l_gripper_motor_slider_link_lk)
     (send l_wrist_roll_link_lk :assoc l_gripper_palm_link_lk)
     (send l_gripper_palm_link_lk :assoc l_gripper_r_finger_link_lk)
     (send l_gripper_r_finger_link_lk :assoc l_gripper_r_finger_tip_link_lk)
     (send l_gripper_palm_link_lk :assoc l_gripper_tool_frame_lk)
     (send l_shoulder_pan_link_lk :assoc l_shoulder_lift_link_lk)
     (send torso_lift_link_lk :assoc l_shoulder_pan_link_lk)
     (send torso_lift_link_lk :assoc l_torso_lift_side_plate_link_lk)
     (send l_upper_arm_roll_link_lk :assoc l_upper_arm_link_lk)
     (send l_shoulder_lift_link_lk :assoc l_upper_arm_roll_link_lk)
     (send l_forearm_link_lk :assoc l_wrist_flex_link_lk)
     (send l_wrist_flex_link_lk :assoc l_wrist_roll_link_lk)
     (send laser_tilt_mount_link_lk :assoc laser_tilt_link_lk)
     (send torso_lift_link_lk :assoc laser_tilt_mount_link_lk)
     (send l_wrist_roll_link_lk :assoc left_arm_chain_cb_link_lk)
     (send double_stereo_link_lk :assoc narrow_stereo_link_lk)
     (send narrow_stereo_link_lk :assoc narrow_stereo_l_stereo_camera_frame_lk)
     (send narrow_stereo_l_stereo_camera_frame_lk :assoc narrow_stereo_l_stereo_camera_optical_frame_lk)
     (send narrow_stereo_link_lk :assoc narrow_stereo_optical_frame_lk)
     (send narrow_stereo_l_stereo_camera_frame_lk :assoc narrow_stereo_r_stereo_camera_frame_lk)
     (send narrow_stereo_r_stereo_camera_frame_lk :assoc narrow_stereo_r_stereo_camera_optical_frame_lk)
     (send projector_wg6802418_frame_lk :assoc projector_wg6802418_child_frame_lk)
     (send head_plate_frame_lk :assoc projector_wg6802418_frame_lk)
     (send r_upper_arm_link_lk :assoc r_elbow_flex_link_lk)
     (send r_forearm_roll_link_lk :assoc r_forearm_cam_frame_lk)
     (send r_forearm_cam_frame_lk :assoc r_forearm_cam_optical_frame_lk)
     (send r_forearm_roll_link_lk :assoc r_forearm_link_lk)
     (send r_elbow_flex_link_lk :assoc r_forearm_roll_link_lk)
     (send r_gripper_r_finger_tip_link_lk :assoc r_gripper_l_finger_tip_frame_lk)
     (send r_gripper_palm_link_lk :assoc r_gripper_l_finger_link_lk)
     (send r_gripper_l_finger_link_lk :assoc r_gripper_l_finger_tip_link_lk)
     (send r_gripper_palm_link_lk :assoc r_gripper_led_frame_lk)
     (send r_gripper_palm_link_lk :assoc r_gripper_motor_accelerometer_link_lk)
     (send r_gripper_motor_slider_link_lk :assoc r_gripper_motor_screw_link_lk)
     (send r_gripper_palm_link_lk :assoc r_gripper_motor_slider_link_lk)
     (send r_wrist_roll_link_lk :assoc r_gripper_palm_link_lk)
     (send r_gripper_palm_link_lk :assoc r_gripper_r_finger_link_lk)
     (send r_gripper_r_finger_link_lk :assoc r_gripper_r_finger_tip_link_lk)
     (send r_gripper_palm_link_lk :assoc r_gripper_tool_frame_lk)
     (send r_shoulder_pan_link_lk :assoc r_shoulder_lift_link_lk)
     (send torso_lift_link_lk :assoc r_shoulder_pan_link_lk)
     (send torso_lift_link_lk :assoc r_torso_lift_side_plate_link_lk)
     (send r_upper_arm_roll_link_lk :assoc r_upper_arm_link_lk)
     (send r_shoulder_lift_link_lk :assoc r_upper_arm_roll_link_lk)
     (send r_forearm_link_lk :assoc r_wrist_flex_link_lk)
     (send r_wrist_flex_link_lk :assoc r_wrist_roll_link_lk)
     (send r_wrist_roll_link_lk :assoc right_arm_chain_cb_link_lk)
     (send head_plate_frame_lk :assoc sensor_mount_link_lk)
     (send base_link_lk :assoc torso_lift_link_lk)
     (send base_link_lk :assoc torso_lift_motor_screw_link_lk)
     (send double_stereo_link_lk :assoc wide_stereo_link_lk)
     (send wide_stereo_link_lk :assoc wide_stereo_l_stereo_camera_frame_lk)
     (send wide_stereo_l_stereo_camera_frame_lk :assoc wide_stereo_l_stereo_camera_optical_frame_lk)
     (send wide_stereo_link_lk :assoc wide_stereo_optical_frame_lk)
     (send wide_stereo_l_stereo_camera_frame_lk :assoc wide_stereo_r_stereo_camera_frame_lk)
     (send wide_stereo_r_stereo_camera_frame_lk :assoc wide_stereo_r_stereo_camera_optical_frame_lk)
     (send self :assoc base_footprint_lk)

     ;; joint models
     ;; joint: base_bellow_joint_fixed_jt
     (setq base_bellow_joint_fixed_jt
           (instance rotational-joint :init
                     :name "base_bellow_joint"
                     :parent-link base_link_lk :child-link base_bellow_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: base_footprint_joint_fixed_jt
     (setq base_footprint_joint_fixed_jt
           (instance rotational-joint :init
                     :name "base_footprint_joint"
                     :parent-link base_footprint_lk :child-link base_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: base_laser_joint_fixed_jt
     (setq base_laser_joint_fixed_jt
           (instance rotational-joint :init
                     :name "base_laser_joint"
                     :parent-link base_link_lk :child-link base_laser_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: bl_caster_l_wheel_joint_jt
     (setq bl_caster_l_wheel_joint_jt
           (instance rotational-joint :init
                     :name "bl_caster_l_wheel_joint"
                     :parent-link bl_caster_rotation_link_lk :child-link bl_caster_l_wheel_link_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 15.000000
                     :max-joint-torque 7.000000
                     ))
     ;; joint: bl_caster_r_wheel_joint_jt
     (setq bl_caster_r_wheel_joint_jt
           (instance rotational-joint :init
                     :name "bl_caster_r_wheel_joint"
                     :parent-link bl_caster_rotation_link_lk :child-link bl_caster_r_wheel_link_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 15.000000
                     :max-joint-torque 7.000000
                     ))
     ;; joint: bl_caster_rotation_joint_jt
     (setq bl_caster_rotation_joint_jt
           (instance rotational-joint :init
                     :name "bl_caster_rotation_joint"
                     :parent-link base_link_lk :child-link bl_caster_rotation_link_lk
                     :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 10.000000
                     :max-joint-torque 6.500000
                     ))
     ;; joint: br_caster_l_wheel_joint_jt
     (setq br_caster_l_wheel_joint_jt
           (instance rotational-joint :init
                     :name "br_caster_l_wheel_joint"
                     :parent-link br_caster_rotation_link_lk :child-link br_caster_l_wheel_link_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 15.000000
                     :max-joint-torque 7.000000
                     ))
     ;; joint: br_caster_r_wheel_joint_jt
     (setq br_caster_r_wheel_joint_jt
           (instance rotational-joint :init
                     :name "br_caster_r_wheel_joint"
                     :parent-link br_caster_rotation_link_lk :child-link br_caster_r_wheel_link_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 15.000000
                     :max-joint-torque 7.000000
                     ))
     ;; joint: br_caster_rotation_joint_jt
     (setq br_caster_rotation_joint_jt
           (instance rotational-joint :init
                     :name "br_caster_rotation_joint"
                     :parent-link base_link_lk :child-link br_caster_rotation_link_lk
                     :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 10.000000
                     :max-joint-torque 6.500000
                     ))
     ;; joint: double_stereo_frame_joint_fixed_jt
     (setq double_stereo_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "double_stereo_frame_joint"
                     :parent-link sensor_mount_link_lk :child-link double_stereo_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: fl_caster_l_wheel_joint_jt
     (setq fl_caster_l_wheel_joint_jt
           (instance rotational-joint :init
                     :name "fl_caster_l_wheel_joint"
                     :parent-link fl_caster_rotation_link_lk :child-link fl_caster_l_wheel_link_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 15.000000
                     :max-joint-torque 7.000000
                     ))
     ;; joint: fl_caster_r_wheel_joint_jt
     (setq fl_caster_r_wheel_joint_jt
           (instance rotational-joint :init
                     :name "fl_caster_r_wheel_joint"
                     :parent-link fl_caster_rotation_link_lk :child-link fl_caster_r_wheel_link_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 15.000000
                     :max-joint-torque 7.000000
                     ))
     ;; joint: fl_caster_rotation_joint_jt
     (setq fl_caster_rotation_joint_jt
           (instance rotational-joint :init
                     :name "fl_caster_rotation_joint"
                     :parent-link base_link_lk :child-link fl_caster_rotation_link_lk
                     :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 10.000000
                     :max-joint-torque 6.500000
                     ))
     ;; joint: fr_caster_l_wheel_joint_jt
     (setq fr_caster_l_wheel_joint_jt
           (instance rotational-joint :init
                     :name "fr_caster_l_wheel_joint"
                     :parent-link fr_caster_rotation_link_lk :child-link fr_caster_l_wheel_link_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 15.000000
                     :max-joint-torque 7.000000
                     ))
     ;; joint: fr_caster_r_wheel_joint_jt
     (setq fr_caster_r_wheel_joint_jt
           (instance rotational-joint :init
                     :name "fr_caster_r_wheel_joint"
                     :parent-link fr_caster_rotation_link_lk :child-link fr_caster_r_wheel_link_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 15.000000
                     :max-joint-torque 7.000000
                     ))
     ;; joint: fr_caster_rotation_joint_jt
     (setq fr_caster_rotation_joint_jt
           (instance rotational-joint :init
                     :name "fr_caster_rotation_joint"
                     :parent-link base_link_lk :child-link fr_caster_rotation_link_lk
                     :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 10.000000
                     :max-joint-torque 6.500000
                     ))
     ;; joint: head_chain_cb_fixed_jt
     (setq head_chain_cb_fixed_jt
           (instance rotational-joint :init
                     :name "head_chain_cb"
                     :parent-link head_tilt_link_lk :child-link head_chain_cb_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: head_mount_joint_fixed_jt
     (setq head_mount_joint_fixed_jt
           (instance rotational-joint :init
                     :name "head_mount_joint"
                     :parent-link head_plate_frame_lk :child-link head_mount_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: head_mount_kinect_ir_joint_fixed_jt
     (setq head_mount_kinect_ir_joint_fixed_jt
           (instance rotational-joint :init
                     :name "head_mount_kinect_ir_joint"
                     :parent-link head_mount_link_lk :child-link head_mount_kinect_ir_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: head_mount_kinect_ir_optical_frame_joint_fixed_jt
     (setq head_mount_kinect_ir_optical_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "head_mount_kinect_ir_optical_frame_joint"
                     :parent-link head_mount_kinect_ir_link_lk :child-link head_mount_kinect_ir_optical_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: head_mount_kinect_rgb_joint_fixed_jt
     (setq head_mount_kinect_rgb_joint_fixed_jt
           (instance rotational-joint :init
                     :name "head_mount_kinect_rgb_joint"
                     :parent-link head_mount_kinect_ir_link_lk :child-link head_mount_kinect_rgb_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: head_mount_kinect_rgb_optical_frame_joint_fixed_jt
     (setq head_mount_kinect_rgb_optical_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "head_mount_kinect_rgb_optical_frame_joint"
                     :parent-link head_mount_kinect_rgb_link_lk :child-link head_mount_kinect_rgb_optical_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: head_mount_prosilica_joint_fixed_jt
     (setq head_mount_prosilica_joint_fixed_jt
           (instance rotational-joint :init
                     :name "head_mount_prosilica_joint"
                     :parent-link head_mount_link_lk :child-link head_mount_prosilica_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: head_mount_prosilica_optical_frame_joint_fixed_jt
     (setq head_mount_prosilica_optical_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "head_mount_prosilica_optical_frame_joint"
                     :parent-link head_mount_prosilica_link_lk :child-link head_mount_prosilica_optical_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: head_pan_joint_jt
     (setq head_pan_joint_jt
           (instance rotational-joint :init
                     :name "head_pan_joint"
                     :parent-link torso_lift_link_lk :child-link head_pan_link_lk
                     :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)
                     :min -163.694049 :max 163.694049
                     :max-joint-velocity 6.000000
                     :max-joint-torque 2.645000
                     ))
     ;; joint: head_plate_frame_joint_fixed_jt
     (setq head_plate_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "head_plate_frame_joint"
                     :parent-link head_tilt_link_lk :child-link head_plate_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: head_tilt_joint_jt
     (setq head_tilt_joint_jt
           (instance rotational-joint :init
                     :name "head_tilt_joint"
                     :parent-link head_pan_link_lk :child-link head_tilt_link_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                     :min -21.268193 :max 74.270227
                     :max-joint-velocity 5.000000
                     :max-joint-torque 18.000000
                     ))
     ;; joint: high_def_frame_joint_fixed_jt
     (setq high_def_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "high_def_frame_joint"
                     :parent-link sensor_mount_link_lk :child-link high_def_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: high_def_optical_frame_joint_fixed_jt
     (setq high_def_optical_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "high_def_optical_frame_joint"
                     :parent-link high_def_frame_lk :child-link high_def_optical_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: imu_joint_fixed_jt
     (setq imu_joint_fixed_jt
           (instance rotational-joint :init
                     :name "imu_joint"
                     :parent-link torso_lift_link_lk :child-link imu_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: l_elbow_flex_joint_jt
     (setq l_elbow_flex_joint_jt
           (instance rotational-joint :init
                     :name "l_elbow_flex_joint"
                     :parent-link l_upper_arm_link_lk :child-link l_elbow_flex_link_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                     :min -121.541536 :max -8.594367
                     :max-joint-velocity 3.300000
                     :max-joint-torque 30.000000
                     ))
     ;; joint: l_forearm_cam_frame_joint_fixed_jt
     (setq l_forearm_cam_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "l_forearm_cam_frame_joint"
                     :parent-link l_forearm_roll_link_lk :child-link l_forearm_cam_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: l_forearm_cam_optical_frame_joint_fixed_jt
     (setq l_forearm_cam_optical_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "l_forearm_cam_optical_frame_joint"
                     :parent-link l_forearm_cam_frame_lk :child-link l_forearm_cam_optical_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: l_forearm_joint_fixed_jt
     (setq l_forearm_joint_fixed_jt
           (instance rotational-joint :init
                     :name "l_forearm_joint"
                     :parent-link l_forearm_roll_link_lk :child-link l_forearm_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: l_forearm_roll_joint_jt
     (setq l_forearm_roll_joint_jt
           (instance rotational-joint :init
                     :name "l_forearm_roll_joint"
                     :parent-link l_elbow_flex_link_lk :child-link l_forearm_roll_link_lk
                     :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 3.600000
                     :max-joint-torque 30.000000
                     ))
     ;; joint: l_gripper_joint_jt
     (setq l_gripper_joint_jt
           (instance linear-joint :init
                     :name "l_gripper_joint"
                     :parent-link l_gripper_r_finger_tip_link_lk :child-link l_gripper_l_finger_tip_frame_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                     :min -10.000000 :max 88.000000
                     :max-joint-velocity 0.200000
                     :max-joint-torque 1000.000000
                     ))
     ;; joint: l_gripper_l_finger_joint_jt
     (setq l_gripper_l_finger_joint_jt
           (instance rotational-joint :init
                     :name "l_gripper_l_finger_joint"
                     :parent-link l_gripper_palm_link_lk :child-link l_gripper_l_finger_link_lk
                     :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)
                     :min 0.000000 :max 31.398086
                     :max-joint-velocity 0.500000
                     :max-joint-torque 1000.000000
                     ))
     ;; joint: l_gripper_l_finger_tip_joint_jt
     (setq l_gripper_l_finger_tip_joint_jt
           (instance rotational-joint :init
                     :name "l_gripper_l_finger_tip_joint"
                     :parent-link l_gripper_l_finger_link_lk :child-link l_gripper_l_finger_tip_link_lk
                     :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00)
                     :min 0.000000 :max 31.398086
                     :max-joint-velocity 0.500000
                     :max-joint-torque 1000.000000
                     ))
     ;; joint: l_gripper_led_joint_fixed_jt
     (setq l_gripper_led_joint_fixed_jt
           (instance rotational-joint :init
                     :name "l_gripper_led_joint"
                     :parent-link l_gripper_palm_link_lk :child-link l_gripper_led_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: l_gripper_motor_accelerometer_joint_fixed_jt
     (setq l_gripper_motor_accelerometer_joint_fixed_jt
           (instance rotational-joint :init
                     :name "l_gripper_motor_accelerometer_joint"
                     :parent-link l_gripper_palm_link_lk :child-link l_gripper_motor_accelerometer_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: l_gripper_motor_screw_joint_jt
     (setq l_gripper_motor_screw_joint_jt
           (instance rotational-joint :init
                     :name "l_gripper_motor_screw_joint"
                     :parent-link l_gripper_motor_slider_link_lk :child-link l_gripper_motor_screw_link_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: l_gripper_motor_slider_joint_jt
     (setq l_gripper_motor_slider_joint_jt
           (instance linear-joint :init
                     :name "l_gripper_motor_slider_joint"
                     :parent-link l_gripper_palm_link_lk :child-link l_gripper_motor_slider_link_lk
                     :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                     :min -100.000000 :max 100.000000
                     :max-joint-velocity 0.200000
                     :max-joint-torque 1000.000000
                     ))
     ;; joint: l_gripper_palm_joint_fixed_jt
     (setq l_gripper_palm_joint_fixed_jt
           (instance rotational-joint :init
                     :name "l_gripper_palm_joint"
                     :parent-link l_wrist_roll_link_lk :child-link l_gripper_palm_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: l_gripper_r_finger_joint_jt
     (setq l_gripper_r_finger_joint_jt
           (instance rotational-joint :init
                     :name "l_gripper_r_finger_joint"
                     :parent-link l_gripper_palm_link_lk :child-link l_gripper_r_finger_link_lk
                     :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00)
                     :min 0.000000 :max 31.398086
                     :max-joint-velocity 0.500000
                     :max-joint-torque 1000.000000
                     ))
     ;; joint: l_gripper_r_finger_tip_joint_jt
     (setq l_gripper_r_finger_tip_joint_jt
           (instance rotational-joint :init
                     :name "l_gripper_r_finger_tip_joint"
                     :parent-link l_gripper_r_finger_link_lk :child-link l_gripper_r_finger_tip_link_lk
                     :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)
                     :min 0.000000 :max 31.398086
                     :max-joint-velocity 0.500000
                     :max-joint-torque 1000.000000
                     ))
     ;; joint: l_gripper_tool_joint_fixed_jt
     (setq l_gripper_tool_joint_fixed_jt
           (instance rotational-joint :init
                     :name "l_gripper_tool_joint"
                     :parent-link l_gripper_palm_link_lk :child-link l_gripper_tool_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: l_shoulder_lift_joint_jt
     (setq l_shoulder_lift_joint_jt
           (instance rotational-joint :init
                     :name "l_shoulder_lift_joint"
                     :parent-link l_shoulder_pan_link_lk :child-link l_shoulder_lift_link_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                     :min -20.259787 :max 74.272522
                     :max-joint-velocity 2.082000
                     :max-joint-torque 30.000000
                     ))
     ;; joint: l_shoulder_pan_joint_jt
     (setq l_shoulder_pan_joint_jt
           (instance rotational-joint :init
                     :name "l_shoulder_pan_joint"
                     :parent-link torso_lift_link_lk :child-link l_shoulder_pan_link_lk
                     :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)
                     :min -32.349302 :max 122.349302
                     :max-joint-velocity 2.088000
                     :max-joint-torque 30.000000
                     ))
     ;; joint: l_torso_lift_side_plate_joint_fixed_jt
     (setq l_torso_lift_side_plate_joint_fixed_jt
           (instance rotational-joint :init
                     :name "l_torso_lift_side_plate_joint"
                     :parent-link torso_lift_link_lk :child-link l_torso_lift_side_plate_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: l_upper_arm_joint_fixed_jt
     (setq l_upper_arm_joint_fixed_jt
           (instance rotational-joint :init
                     :name "l_upper_arm_joint"
                     :parent-link l_upper_arm_roll_link_lk :child-link l_upper_arm_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: l_upper_arm_roll_joint_jt
     (setq l_upper_arm_roll_joint_jt
           (instance rotational-joint :init
                     :name "l_upper_arm_roll_joint"
                     :parent-link l_shoulder_lift_link_lk :child-link l_upper_arm_roll_link_lk
                     :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                     :min -37.242255 :max 214.859173
                     :max-joint-velocity 3.270000
                     :max-joint-torque 30.000000
                     ))
     ;; joint: l_wrist_flex_joint_jt
     (setq l_wrist_flex_joint_jt
           (instance rotational-joint :init
                     :name "l_wrist_flex_joint"
                     :parent-link l_forearm_link_lk :child-link l_wrist_flex_link_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                     :min -114.591559 :max -5.729578
                     :max-joint-velocity 3.078000
                     :max-joint-torque 10.000000
                     ))
     ;; joint: l_wrist_roll_joint_jt
     (setq l_wrist_roll_joint_jt
           (instance rotational-joint :init
                     :name "l_wrist_roll_joint"
                     :parent-link l_wrist_flex_link_lk :child-link l_wrist_roll_link_lk
                     :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 3.600000
                     :max-joint-torque 10.000000
                     ))
     ;; joint: laser_tilt_joint_fixed_jt
     (setq laser_tilt_joint_fixed_jt
           (instance rotational-joint :init
                     :name "laser_tilt_joint"
                     :parent-link laser_tilt_mount_link_lk :child-link laser_tilt_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: laser_tilt_mount_joint_jt
     (setq laser_tilt_mount_joint_jt
           (instance rotational-joint :init
                     :name "laser_tilt_mount_joint"
                     :parent-link torso_lift_link_lk :child-link laser_tilt_mount_link_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                     :min -42.135317 :max 82.135217
                     :max-joint-velocity 10.000000
                     :max-joint-torque 0.650000
                     ))
     ;; joint: left_arm_chain_cb_fixed_jt
     (setq left_arm_chain_cb_fixed_jt
           (instance rotational-joint :init
                     :name "left_arm_chain_cb"
                     :parent-link l_wrist_roll_link_lk :child-link left_arm_chain_cb_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: narrow_stereo_frame_joint_fixed_jt
     (setq narrow_stereo_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "narrow_stereo_frame_joint"
                     :parent-link double_stereo_link_lk :child-link narrow_stereo_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: narrow_stereo_l_stereo_camera_frame_joint_fixed_jt
     (setq narrow_stereo_l_stereo_camera_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "narrow_stereo_l_stereo_camera_frame_joint"
                     :parent-link narrow_stereo_link_lk :child-link narrow_stereo_l_stereo_camera_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: narrow_stereo_l_stereo_camera_optical_frame_joint_fixed_jt
     (setq narrow_stereo_l_stereo_camera_optical_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "narrow_stereo_l_stereo_camera_optical_frame_joint"
                     :parent-link narrow_stereo_l_stereo_camera_frame_lk :child-link narrow_stereo_l_stereo_camera_optical_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: narrow_stereo_optical_frame_joint_fixed_jt
     (setq narrow_stereo_optical_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "narrow_stereo_optical_frame_joint"
                     :parent-link narrow_stereo_link_lk :child-link narrow_stereo_optical_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: narrow_stereo_r_stereo_camera_frame_joint_fixed_jt
     (setq narrow_stereo_r_stereo_camera_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "narrow_stereo_r_stereo_camera_frame_joint"
                     :parent-link narrow_stereo_l_stereo_camera_frame_lk :child-link narrow_stereo_r_stereo_camera_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: narrow_stereo_r_stereo_camera_optical_frame_joint_fixed_jt
     (setq narrow_stereo_r_stereo_camera_optical_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "narrow_stereo_r_stereo_camera_optical_frame_joint"
                     :parent-link narrow_stereo_r_stereo_camera_frame_lk :child-link narrow_stereo_r_stereo_camera_optical_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: projector_wg6802418_child_frame_joint_fixed_jt
     (setq projector_wg6802418_child_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "projector_wg6802418_child_frame_joint"
                     :parent-link projector_wg6802418_frame_lk :child-link projector_wg6802418_child_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: projector_wg6802418_frame_joint_fixed_jt
     (setq projector_wg6802418_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "projector_wg6802418_frame_joint"
                     :parent-link head_plate_frame_lk :child-link projector_wg6802418_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: r_elbow_flex_joint_jt
     (setq r_elbow_flex_joint_jt
           (instance rotational-joint :init
                     :name "r_elbow_flex_joint"
                     :parent-link r_upper_arm_link_lk :child-link r_elbow_flex_link_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                     :min -121.541536 :max -8.594367
                     :max-joint-velocity 3.300000
                     :max-joint-torque 30.000000
                     ))
     ;; joint: r_forearm_cam_frame_joint_fixed_jt
     (setq r_forearm_cam_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "r_forearm_cam_frame_joint"
                     :parent-link r_forearm_roll_link_lk :child-link r_forearm_cam_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: r_forearm_cam_optical_frame_joint_fixed_jt
     (setq r_forearm_cam_optical_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "r_forearm_cam_optical_frame_joint"
                     :parent-link r_forearm_cam_frame_lk :child-link r_forearm_cam_optical_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: r_forearm_joint_fixed_jt
     (setq r_forearm_joint_fixed_jt
           (instance rotational-joint :init
                     :name "r_forearm_joint"
                     :parent-link r_forearm_roll_link_lk :child-link r_forearm_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: r_forearm_roll_joint_jt
     (setq r_forearm_roll_joint_jt
           (instance rotational-joint :init
                     :name "r_forearm_roll_joint"
                     :parent-link r_elbow_flex_link_lk :child-link r_forearm_roll_link_lk
                     :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 3.600000
                     :max-joint-torque 30.000000
                     ))
     ;; joint: r_gripper_joint_jt
     (setq r_gripper_joint_jt
           (instance linear-joint :init
                     :name "r_gripper_joint"
                     :parent-link r_gripper_r_finger_tip_link_lk :child-link r_gripper_l_finger_tip_frame_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                     :min -10.000000 :max 88.000000
                     :max-joint-velocity 0.200000
                     :max-joint-torque 1000.000000
                     ))
     ;; joint: r_gripper_l_finger_joint_jt
     (setq r_gripper_l_finger_joint_jt
           (instance rotational-joint :init
                     :name "r_gripper_l_finger_joint"
                     :parent-link r_gripper_palm_link_lk :child-link r_gripper_l_finger_link_lk
                     :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)
                     :min 0.000000 :max 31.398086
                     :max-joint-velocity 0.500000
                     :max-joint-torque 1000.000000
                     ))
     ;; joint: r_gripper_l_finger_tip_joint_jt
     (setq r_gripper_l_finger_tip_joint_jt
           (instance rotational-joint :init
                     :name "r_gripper_l_finger_tip_joint"
                     :parent-link r_gripper_l_finger_link_lk :child-link r_gripper_l_finger_tip_link_lk
                     :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00)
                     :min 0.000000 :max 31.398086
                     :max-joint-velocity 0.500000
                     :max-joint-torque 1000.000000
                     ))
     ;; joint: r_gripper_led_joint_fixed_jt
     (setq r_gripper_led_joint_fixed_jt
           (instance rotational-joint :init
                     :name "r_gripper_led_joint"
                     :parent-link r_gripper_palm_link_lk :child-link r_gripper_led_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: r_gripper_motor_accelerometer_joint_fixed_jt
     (setq r_gripper_motor_accelerometer_joint_fixed_jt
           (instance rotational-joint :init
                     :name "r_gripper_motor_accelerometer_joint"
                     :parent-link r_gripper_palm_link_lk :child-link r_gripper_motor_accelerometer_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: r_gripper_motor_screw_joint_jt
     (setq r_gripper_motor_screw_joint_jt
           (instance rotational-joint :init
                     :name "r_gripper_motor_screw_joint"
                     :parent-link r_gripper_motor_slider_link_lk :child-link r_gripper_motor_screw_link_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: r_gripper_motor_slider_joint_jt
     (setq r_gripper_motor_slider_joint_jt
           (instance linear-joint :init
                     :name "r_gripper_motor_slider_joint"
                     :parent-link r_gripper_palm_link_lk :child-link r_gripper_motor_slider_link_lk
                     :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                     :min -100.000000 :max 100.000000
                     :max-joint-velocity 0.200000
                     :max-joint-torque 1000.000000
                     ))
     ;; joint: r_gripper_palm_joint_fixed_jt
     (setq r_gripper_palm_joint_fixed_jt
           (instance rotational-joint :init
                     :name "r_gripper_palm_joint"
                     :parent-link r_wrist_roll_link_lk :child-link r_gripper_palm_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: r_gripper_r_finger_joint_jt
     (setq r_gripper_r_finger_joint_jt
           (instance rotational-joint :init
                     :name "r_gripper_r_finger_joint"
                     :parent-link r_gripper_palm_link_lk :child-link r_gripper_r_finger_link_lk
                     :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00)
                     :min 0.000000 :max 31.398086
                     :max-joint-velocity 0.500000
                     :max-joint-torque 1000.000000
                     ))
     ;; joint: r_gripper_r_finger_tip_joint_jt
     (setq r_gripper_r_finger_tip_joint_jt
           (instance rotational-joint :init
                     :name "r_gripper_r_finger_tip_joint"
                     :parent-link r_gripper_r_finger_link_lk :child-link r_gripper_r_finger_tip_link_lk
                     :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)
                     :min 0.000000 :max 31.398086
                     :max-joint-velocity 0.500000
                     :max-joint-torque 1000.000000
                     ))
     ;; joint: r_gripper_tool_joint_fixed_jt
     (setq r_gripper_tool_joint_fixed_jt
           (instance rotational-joint :init
                     :name "r_gripper_tool_joint"
                     :parent-link r_gripper_palm_link_lk :child-link r_gripper_tool_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: r_shoulder_lift_joint_jt
     (setq r_shoulder_lift_joint_jt
           (instance rotational-joint :init
                     :name "r_shoulder_lift_joint"
                     :parent-link r_shoulder_pan_link_lk :child-link r_shoulder_lift_link_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                     :min -20.259787 :max 74.272522
                     :max-joint-velocity 2.082000
                     :max-joint-torque 30.000000
                     ))
     ;; joint: r_shoulder_pan_joint_jt
     (setq r_shoulder_pan_joint_jt
           (instance rotational-joint :init
                     :name "r_shoulder_pan_joint"
                     :parent-link torso_lift_link_lk :child-link r_shoulder_pan_link_lk
                     :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)
                     :min -122.349302 :max 32.349302
                     :max-joint-velocity 2.088000
                     :max-joint-torque 30.000000
                     ))
     ;; joint: r_torso_lift_side_plate_joint_fixed_jt
     (setq r_torso_lift_side_plate_joint_fixed_jt
           (instance rotational-joint :init
                     :name "r_torso_lift_side_plate_joint"
                     :parent-link torso_lift_link_lk :child-link r_torso_lift_side_plate_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: r_upper_arm_joint_fixed_jt
     (setq r_upper_arm_joint_fixed_jt
           (instance rotational-joint :init
                     :name "r_upper_arm_joint"
                     :parent-link r_upper_arm_roll_link_lk :child-link r_upper_arm_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: r_upper_arm_roll_joint_jt
     (setq r_upper_arm_roll_joint_jt
           (instance rotational-joint :init
                     :name "r_upper_arm_roll_joint"
                     :parent-link r_shoulder_lift_link_lk :child-link r_upper_arm_roll_link_lk
                     :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                     :min -214.859173 :max 37.242255
                     :max-joint-velocity 3.270000
                     :max-joint-torque 30.000000
                     ))
     ;; joint: r_wrist_flex_joint_jt
     (setq r_wrist_flex_joint_jt
           (instance rotational-joint :init
                     :name "r_wrist_flex_joint"
                     :parent-link r_forearm_link_lk :child-link r_wrist_flex_link_lk
                     :axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00)
                     :min -114.591559 :max -5.729578
                     :max-joint-velocity 3.078000
                     :max-joint-torque 10.000000
                     ))
     ;; joint: r_wrist_roll_joint_jt
     (setq r_wrist_roll_joint_jt
           (instance rotational-joint :init
                     :name "r_wrist_roll_joint"
                     :parent-link r_wrist_flex_link_lk :child-link r_wrist_roll_link_lk
                     :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 3.600000
                     :max-joint-torque 10.000000
                     ))
     ;; joint: right_arm_chain_cb_fixed_jt
     (setq right_arm_chain_cb_fixed_jt
           (instance rotational-joint :init
                     :name "right_arm_chain_cb"
                     :parent-link r_wrist_roll_link_lk :child-link right_arm_chain_cb_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: sensor_mount_frame_joint_fixed_jt
     (setq sensor_mount_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "sensor_mount_frame_joint"
                     :parent-link head_plate_frame_lk :child-link sensor_mount_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: torso_lift_joint_jt
     (setq torso_lift_joint_jt
           (instance linear-joint :init
                     :name "torso_lift_joint"
                     :parent-link base_link_lk :child-link torso_lift_link_lk
                     :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)
                     :min 11.500000 :max 325.000000
                     :max-joint-velocity 0.013000
                     :max-joint-torque 10000.000000
                     ))
     ;; joint: torso_lift_motor_screw_joint_jt
     (setq torso_lift_motor_screw_joint_jt
           (instance rotational-joint :init
                     :name "torso_lift_motor_screw_joint"
                     :parent-link base_link_lk :child-link torso_lift_motor_screw_link_lk
                     :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)
                                          :min *-inf* :max *inf*
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: wide_stereo_frame_joint_fixed_jt
     (setq wide_stereo_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "wide_stereo_frame_joint"
                     :parent-link double_stereo_link_lk :child-link wide_stereo_link_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: wide_stereo_l_stereo_camera_frame_joint_fixed_jt
     (setq wide_stereo_l_stereo_camera_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "wide_stereo_l_stereo_camera_frame_joint"
                     :parent-link wide_stereo_link_lk :child-link wide_stereo_l_stereo_camera_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: wide_stereo_l_stereo_camera_optical_frame_joint_fixed_jt
     (setq wide_stereo_l_stereo_camera_optical_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "wide_stereo_l_stereo_camera_optical_frame_joint"
                     :parent-link wide_stereo_l_stereo_camera_frame_lk :child-link wide_stereo_l_stereo_camera_optical_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: wide_stereo_optical_frame_joint_fixed_jt
     (setq wide_stereo_optical_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "wide_stereo_optical_frame_joint"
                     :parent-link wide_stereo_link_lk :child-link wide_stereo_optical_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: wide_stereo_r_stereo_camera_frame_joint_fixed_jt
     (setq wide_stereo_r_stereo_camera_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "wide_stereo_r_stereo_camera_frame_joint"
                     :parent-link wide_stereo_l_stereo_camera_frame_lk :child-link wide_stereo_r_stereo_camera_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; joint: wide_stereo_r_stereo_camera_optical_frame_joint_fixed_jt
     (setq wide_stereo_r_stereo_camera_optical_frame_joint_fixed_jt
           (instance rotational-joint :init
                     :name "wide_stereo_r_stereo_camera_optical_frame_joint"
                     :parent-link wide_stereo_r_stereo_camera_frame_lk :child-link wide_stereo_r_stereo_camera_optical_frame_lk
                     :axis (float-vector 1 1 1) ;; fixed joint??
                     :min 0.000000 :max 0.000000
                     :max-joint-velocity 0.500000
                     :max-joint-torque 0.000000
                     ))
     ;; end coords from yaml file
     (setq torso-end-coords (make-cascoords :coords (send torso_lift_link_lk :copy-worldcoords) :name :torso-end-coords))
     (send torso_lift_link_lk :assoc torso-end-coords)
     (setq larm-end-coords (make-cascoords :coords (send l_gripper_tool_frame_lk :copy-worldcoords) :name :larm-end-coords))
     (send larm-end-coords :rotate 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))
     (send l_gripper_tool_frame_lk :assoc larm-end-coords)
     (setq rarm-end-coords (make-cascoords :coords (send r_gripper_tool_frame_lk :copy-worldcoords) :name :rarm-end-coords))
     (send rarm-end-coords :rotate 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))
     (send r_gripper_tool_frame_lk :assoc rarm-end-coords)
     (setq head-end-coords (make-cascoords :coords (send head_tilt_link_lk :copy-worldcoords) :name :head-end-coords))
     (send head-end-coords :translate (float-vector 8.0000000000000000e+01 0.0000000000000000e+00 1.3000000000000000e+02))
     (send head-end-coords :rotate 1.5707963267948966e+00 (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))
     (send head_tilt_link_lk :assoc head-end-coords)

     ;; limbs
     (setq torso (list torso_lift_link_lk))

     (setq torso-root-link
           (labels ((find-parent (l) (if (find (send l :parent) torso) (find-parent (send l :parent)) l)))
             (find-parent (car torso))))
     (setq larm (list l_shoulder_pan_link_lk l_shoulder_lift_link_lk l_upper_arm_roll_link_lk l_elbow_flex_link_lk l_forearm_roll_link_lk l_wrist_flex_link_lk l_wrist_roll_link_lk))

     (setq larm-root-link
           (labels ((find-parent (l) (if (find (send l :parent) larm) (find-parent (send l :parent)) l)))
             (find-parent (car larm))))
     (setq rarm (list r_shoulder_pan_link_lk r_shoulder_lift_link_lk r_upper_arm_roll_link_lk r_elbow_flex_link_lk r_forearm_roll_link_lk r_wrist_flex_link_lk r_wrist_roll_link_lk))

     (setq rarm-root-link
           (labels ((find-parent (l) (if (find (send l :parent) rarm) (find-parent (send l :parent)) l)))
             (find-parent (car rarm))))
     (setq head (list head_pan_link_lk head_tilt_link_lk))

     (setq head-root-link
           (labels ((find-parent (l) (if (find (send l :parent) head) (find-parent (send l :parent)) l)))
             (find-parent (car head))))

     ;; links
     (setq links (list base_footprint_lk torso_lift_link_lk l_shoulder_pan_link_lk l_shoulder_lift_link_lk l_upper_arm_roll_link_lk l_elbow_flex_link_lk l_forearm_roll_link_lk l_wrist_flex_link_lk l_wrist_roll_link_lk r_shoulder_pan_link_lk r_shoulder_lift_link_lk r_upper_arm_roll_link_lk r_elbow_flex_link_lk r_forearm_roll_link_lk r_wrist_flex_link_lk r_wrist_roll_link_lk head_pan_link_lk head_tilt_link_lk))

     ;; joint-list
     (setq joint-list (list torso_lift_joint_jt l_shoulder_pan_joint_jt l_shoulder_lift_joint_jt l_upper_arm_roll_joint_jt l_elbow_flex_joint_jt l_forearm_roll_joint_jt l_wrist_flex_joint_jt l_wrist_roll_joint_jt r_shoulder_pan_joint_jt r_shoulder_lift_joint_jt r_upper_arm_roll_joint_jt r_elbow_flex_joint_jt r_forearm_roll_joint_jt r_wrist_flex_joint_jt r_wrist_roll_joint_jt head_pan_joint_jt head_tilt_joint_jt))

     ;; sensor-coords

     ;; attach_sensor lists
     (setq force-sensors (list ))
     (setq imu-sensors (list ))
     (setq cameras (list ))

     ;; init-ending
     (send self :init-ending) ;; :urdf

     ;; overwrite bodies to return draw-things links not (send link :bodies)
     (setq bodies (flatten (mapcar #'(lambda (b) (if (find-method b :bodies) (send b :bodies))) (list base_bellow_link_lk base_footprint_lk base_laser_link_lk base_link_lk bl_caster_l_wheel_link_lk bl_caster_r_wheel_link_lk bl_caster_rotation_link_lk br_caster_l_wheel_link_lk br_caster_r_wheel_link_lk br_caster_rotation_link_lk double_stereo_link_lk fl_caster_l_wheel_link_lk fl_caster_r_wheel_link_lk fl_caster_rotation_link_lk fr_caster_l_wheel_link_lk fr_caster_r_wheel_link_lk fr_caster_rotation_link_lk head_chain_cb_link_lk head_mount_kinect_ir_link_lk head_mount_kinect_ir_optical_frame_lk head_mount_kinect_rgb_link_lk head_mount_kinect_rgb_optical_frame_lk head_mount_link_lk head_mount_prosilica_link_lk head_mount_prosilica_optical_frame_lk head_pan_link_lk head_plate_frame_lk head_tilt_link_lk high_def_frame_lk high_def_optical_frame_lk imu_link_lk l_elbow_flex_link_lk l_forearm_cam_frame_lk l_forearm_cam_optical_frame_lk l_forearm_link_lk l_forearm_roll_link_lk l_gripper_l_finger_link_lk l_gripper_l_finger_tip_frame_lk l_gripper_l_finger_tip_link_lk l_gripper_led_frame_lk l_gripper_motor_accelerometer_link_lk l_gripper_motor_screw_link_lk l_gripper_motor_slider_link_lk l_gripper_palm_link_lk l_gripper_r_finger_link_lk l_gripper_r_finger_tip_link_lk l_gripper_tool_frame_lk l_shoulder_lift_link_lk l_shoulder_pan_link_lk l_torso_lift_side_plate_link_lk l_upper_arm_link_lk l_upper_arm_roll_link_lk l_wrist_flex_link_lk l_wrist_roll_link_lk laser_tilt_link_lk laser_tilt_mount_link_lk left_arm_chain_cb_link_lk narrow_stereo_l_stereo_camera_frame_lk narrow_stereo_l_stereo_camera_optical_frame_lk narrow_stereo_link_lk narrow_stereo_optical_frame_lk narrow_stereo_r_stereo_camera_frame_lk narrow_stereo_r_stereo_camera_optical_frame_lk projector_wg6802418_child_frame_lk projector_wg6802418_frame_lk r_elbow_flex_link_lk r_forearm_cam_frame_lk r_forearm_cam_optical_frame_lk r_forearm_link_lk r_forearm_roll_link_lk r_gripper_l_finger_link_lk r_gripper_l_finger_tip_frame_lk r_gripper_l_finger_tip_link_lk r_gripper_led_frame_lk r_gripper_motor_accelerometer_link_lk r_gripper_motor_screw_link_lk r_gripper_motor_slider_link_lk r_gripper_palm_link_lk r_gripper_r_finger_link_lk r_gripper_r_finger_tip_link_lk r_gripper_tool_frame_lk r_shoulder_lift_link_lk r_shoulder_pan_link_lk r_torso_lift_side_plate_link_lk r_upper_arm_link_lk r_upper_arm_roll_link_lk r_wrist_flex_link_lk r_wrist_roll_link_lk right_arm_chain_cb_link_lk sensor_mount_link_lk torso_lift_link_lk torso_lift_motor_screw_link_lk wide_stereo_l_stereo_camera_frame_lk wide_stereo_l_stereo_camera_optical_frame_lk wide_stereo_link_lk wide_stereo_optical_frame_lk wide_stereo_r_stereo_camera_frame_lk wide_stereo_r_stereo_camera_optical_frame_lk))))

     (when (member :reset-pose (send self :methods))           (send self :reset-pose)) ;; :set reset-pose

     self)) ;; end of :init

  ;; pre-defined pose methods

    (:reset-manip-pose (&optional (limbs '(:torso :larm :rarm :head)))
      "Predefined pose named reset-manip-pose."
      (unless (listp limbs) (setq limbs (list limbs)))
      (dolist (limb limbs)
        (case limb
          (:torso (send self limb :angle-vector (float-vector 300.000000)))
          (:larm (send self limb :angle-vector (float-vector 75.000000 50.000000 110.000000 -110.000000 -20.000000 -10.000000 -10.000000)))
          (:rarm (send self limb :angle-vector (float-vector -75.000000 50.000000 -110.000000 -110.000000 20.000000 -10.000000 -10.000000)))
          (:head (send self limb :angle-vector (float-vector 0.000000 50.000000)))
          (t (format t "Unknown limb is passed: ~a~%" limb))))
      (send self :angle-vector))
    (:reset-pose (&optional (limbs '(:torso :larm :rarm :head)))
      "Predefined pose named reset-pose."
      (unless (listp limbs) (setq limbs (list limbs)))
      (dolist (limb limbs)
        (case limb
          (:torso (send self limb :angle-vector (float-vector 50.000000)))
          (:larm (send self limb :angle-vector (float-vector 60.000000 74.000000 70.000000 -120.000000 20.000000 -30.000000 180.000000)))
          (:rarm (send self limb :angle-vector (float-vector -60.000000 74.000000 -70.000000 -120.000000 -20.000000 -30.000000 180.000000)))
          (:head (send self limb :angle-vector (float-vector 0.000000 0.000000)))
          (t (format t "Unknown limb is passed: ~a~%" limb))))
      (send self :angle-vector))
  ;; all joints
  (:base_bellow_joint (&rest args) (forward-message-to base_bellow_joint_fixed_jt args))
  (:base_footprint_joint (&rest args) (forward-message-to base_footprint_joint_fixed_jt args))
  (:base_laser_joint (&rest args) (forward-message-to base_laser_joint_fixed_jt args))
  (:bl_caster_l_wheel_joint (&rest args) (forward-message-to bl_caster_l_wheel_joint_jt args))
  (:bl_caster_r_wheel_joint (&rest args) (forward-message-to bl_caster_r_wheel_joint_jt args))
  (:bl_caster_rotation_joint (&rest args) (forward-message-to bl_caster_rotation_joint_jt args))
  (:br_caster_l_wheel_joint (&rest args) (forward-message-to br_caster_l_wheel_joint_jt args))
  (:br_caster_r_wheel_joint (&rest args) (forward-message-to br_caster_r_wheel_joint_jt args))
  (:br_caster_rotation_joint (&rest args) (forward-message-to br_caster_rotation_joint_jt args))
  (:double_stereo_frame_joint (&rest args) (forward-message-to double_stereo_frame_joint_fixed_jt args))
  (:fl_caster_l_wheel_joint (&rest args) (forward-message-to fl_caster_l_wheel_joint_jt args))
  (:fl_caster_r_wheel_joint (&rest args) (forward-message-to fl_caster_r_wheel_joint_jt args))
  (:fl_caster_rotation_joint (&rest args) (forward-message-to fl_caster_rotation_joint_jt args))
  (:fr_caster_l_wheel_joint (&rest args) (forward-message-to fr_caster_l_wheel_joint_jt args))
  (:fr_caster_r_wheel_joint (&rest args) (forward-message-to fr_caster_r_wheel_joint_jt args))
  (:fr_caster_rotation_joint (&rest args) (forward-message-to fr_caster_rotation_joint_jt args))
  (:head_chain_cb (&rest args) (forward-message-to head_chain_cb_fixed_jt args))
  (:head_mount_joint (&rest args) (forward-message-to head_mount_joint_fixed_jt args))
  (:head_mount_kinect_ir_joint (&rest args) (forward-message-to head_mount_kinect_ir_joint_fixed_jt args))
  (:head_mount_kinect_ir_optical_frame_joint (&rest args) (forward-message-to head_mount_kinect_ir_optical_frame_joint_fixed_jt args))
  (:head_mount_kinect_rgb_joint (&rest args) (forward-message-to head_mount_kinect_rgb_joint_fixed_jt args))
  (:head_mount_kinect_rgb_optical_frame_joint (&rest args) (forward-message-to head_mount_kinect_rgb_optical_frame_joint_fixed_jt args))
  (:head_mount_prosilica_joint (&rest args) (forward-message-to head_mount_prosilica_joint_fixed_jt args))
  (:head_mount_prosilica_optical_frame_joint (&rest args) (forward-message-to head_mount_prosilica_optical_frame_joint_fixed_jt args))
  (:head_pan_joint (&rest args) (forward-message-to head_pan_joint_jt args))
  (:head_plate_frame_joint (&rest args) (forward-message-to head_plate_frame_joint_fixed_jt args))
  (:head_tilt_joint (&rest args) (forward-message-to head_tilt_joint_jt args))
  (:high_def_frame_joint (&rest args) (forward-message-to high_def_frame_joint_fixed_jt args))
  (:high_def_optical_frame_joint (&rest args) (forward-message-to high_def_optical_frame_joint_fixed_jt args))
  (:imu_joint (&rest args) (forward-message-to imu_joint_fixed_jt args))
  (:l_elbow_flex_joint (&rest args) (forward-message-to l_elbow_flex_joint_jt args))
  (:l_forearm_cam_frame_joint (&rest args) (forward-message-to l_forearm_cam_frame_joint_fixed_jt args))
  (:l_forearm_cam_optical_frame_joint (&rest args) (forward-message-to l_forearm_cam_optical_frame_joint_fixed_jt args))
  (:l_forearm_joint (&rest args) (forward-message-to l_forearm_joint_fixed_jt args))
  (:l_forearm_roll_joint (&rest args) (forward-message-to l_forearm_roll_joint_jt args))
  (:l_gripper_joint (&rest args) (forward-message-to l_gripper_joint_jt args))
  (:l_gripper_l_finger_joint (&rest args) (forward-message-to l_gripper_l_finger_joint_jt args))
  (:l_gripper_l_finger_tip_joint (&rest args) (forward-message-to l_gripper_l_finger_tip_joint_jt args))
  (:l_gripper_led_joint (&rest args) (forward-message-to l_gripper_led_joint_fixed_jt args))
  (:l_gripper_motor_accelerometer_joint (&rest args) (forward-message-to l_gripper_motor_accelerometer_joint_fixed_jt args))
  (:l_gripper_motor_screw_joint (&rest args) (forward-message-to l_gripper_motor_screw_joint_jt args))
  (:l_gripper_motor_slider_joint (&rest args) (forward-message-to l_gripper_motor_slider_joint_jt args))
  (:l_gripper_palm_joint (&rest args) (forward-message-to l_gripper_palm_joint_fixed_jt args))
  (:l_gripper_r_finger_joint (&rest args) (forward-message-to l_gripper_r_finger_joint_jt args))
  (:l_gripper_r_finger_tip_joint (&rest args) (forward-message-to l_gripper_r_finger_tip_joint_jt args))
  (:l_gripper_tool_joint (&rest args) (forward-message-to l_gripper_tool_joint_fixed_jt args))
  (:l_shoulder_lift_joint (&rest args) (forward-message-to l_shoulder_lift_joint_jt args))
  (:l_shoulder_pan_joint (&rest args) (forward-message-to l_shoulder_pan_joint_jt args))
  (:l_torso_lift_side_plate_joint (&rest args) (forward-message-to l_torso_lift_side_plate_joint_fixed_jt args))
  (:l_upper_arm_joint (&rest args) (forward-message-to l_upper_arm_joint_fixed_jt args))
  (:l_upper_arm_roll_joint (&rest args) (forward-message-to l_upper_arm_roll_joint_jt args))
  (:l_wrist_flex_joint (&rest args) (forward-message-to l_wrist_flex_joint_jt args))
  (:l_wrist_roll_joint (&rest args) (forward-message-to l_wrist_roll_joint_jt args))
  (:laser_tilt_joint (&rest args) (forward-message-to laser_tilt_joint_fixed_jt args))
  (:laser_tilt_mount_joint (&rest args) (forward-message-to laser_tilt_mount_joint_jt args))
  (:left_arm_chain_cb (&rest args) (forward-message-to left_arm_chain_cb_fixed_jt args))
  (:narrow_stereo_frame_joint (&rest args) (forward-message-to narrow_stereo_frame_joint_fixed_jt args))
  (:narrow_stereo_l_stereo_camera_frame_joint (&rest args) (forward-message-to narrow_stereo_l_stereo_camera_frame_joint_fixed_jt args))
  (:narrow_stereo_l_stereo_camera_optical_frame_joint (&rest args) (forward-message-to narrow_stereo_l_stereo_camera_optical_frame_joint_fixed_jt args))
  (:narrow_stereo_optical_frame_joint (&rest args) (forward-message-to narrow_stereo_optical_frame_joint_fixed_jt args))
  (:narrow_stereo_r_stereo_camera_frame_joint (&rest args) (forward-message-to narrow_stereo_r_stereo_camera_frame_joint_fixed_jt args))
  (:narrow_stereo_r_stereo_camera_optical_frame_joint (&rest args) (forward-message-to narrow_stereo_r_stereo_camera_optical_frame_joint_fixed_jt args))
  (:projector_wg6802418_child_frame_joint (&rest args) (forward-message-to projector_wg6802418_child_frame_joint_fixed_jt args))
  (:projector_wg6802418_frame_joint (&rest args) (forward-message-to projector_wg6802418_frame_joint_fixed_jt args))
  (:r_elbow_flex_joint (&rest args) (forward-message-to r_elbow_flex_joint_jt args))
  (:r_forearm_cam_frame_joint (&rest args) (forward-message-to r_forearm_cam_frame_joint_fixed_jt args))
  (:r_forearm_cam_optical_frame_joint (&rest args) (forward-message-to r_forearm_cam_optical_frame_joint_fixed_jt args))
  (:r_forearm_joint (&rest args) (forward-message-to r_forearm_joint_fixed_jt args))
  (:r_forearm_roll_joint (&rest args) (forward-message-to r_forearm_roll_joint_jt args))
  (:r_gripper_joint (&rest args) (forward-message-to r_gripper_joint_jt args))
  (:r_gripper_l_finger_joint (&rest args) (forward-message-to r_gripper_l_finger_joint_jt args))
  (:r_gripper_l_finger_tip_joint (&rest args) (forward-message-to r_gripper_l_finger_tip_joint_jt args))
  (:r_gripper_led_joint (&rest args) (forward-message-to r_gripper_led_joint_fixed_jt args))
  (:r_gripper_motor_accelerometer_joint (&rest args) (forward-message-to r_gripper_motor_accelerometer_joint_fixed_jt args))
  (:r_gripper_motor_screw_joint (&rest args) (forward-message-to r_gripper_motor_screw_joint_jt args))
  (:r_gripper_motor_slider_joint (&rest args) (forward-message-to r_gripper_motor_slider_joint_jt args))
  (:r_gripper_palm_joint (&rest args) (forward-message-to r_gripper_palm_joint_fixed_jt args))
  (:r_gripper_r_finger_joint (&rest args) (forward-message-to r_gripper_r_finger_joint_jt args))
  (:r_gripper_r_finger_tip_joint (&rest args) (forward-message-to r_gripper_r_finger_tip_joint_jt args))
  (:r_gripper_tool_joint (&rest args) (forward-message-to r_gripper_tool_joint_fixed_jt args))
  (:r_shoulder_lift_joint (&rest args) (forward-message-to r_shoulder_lift_joint_jt args))
  (:r_shoulder_pan_joint (&rest args) (forward-message-to r_shoulder_pan_joint_jt args))
  (:r_torso_lift_side_plate_joint (&rest args) (forward-message-to r_torso_lift_side_plate_joint_fixed_jt args))
  (:r_upper_arm_joint (&rest args) (forward-message-to r_upper_arm_joint_fixed_jt args))
  (:r_upper_arm_roll_joint (&rest args) (forward-message-to r_upper_arm_roll_joint_jt args))
  (:r_wrist_flex_joint (&rest args) (forward-message-to r_wrist_flex_joint_jt args))
  (:r_wrist_roll_joint (&rest args) (forward-message-to r_wrist_roll_joint_jt args))
  (:right_arm_chain_cb (&rest args) (forward-message-to right_arm_chain_cb_fixed_jt args))
  (:sensor_mount_frame_joint (&rest args) (forward-message-to sensor_mount_frame_joint_fixed_jt args))
  (:torso_lift_joint (&rest args) (forward-message-to torso_lift_joint_jt args))
  (:torso_lift_motor_screw_joint (&rest args) (forward-message-to torso_lift_motor_screw_joint_jt args))
  (:wide_stereo_frame_joint (&rest args) (forward-message-to wide_stereo_frame_joint_fixed_jt args))
  (:wide_stereo_l_stereo_camera_frame_joint (&rest args) (forward-message-to wide_stereo_l_stereo_camera_frame_joint_fixed_jt args))
  (:wide_stereo_l_stereo_camera_optical_frame_joint (&rest args) (forward-message-to wide_stereo_l_stereo_camera_optical_frame_joint_fixed_jt args))
  (:wide_stereo_optical_frame_joint (&rest args) (forward-message-to wide_stereo_optical_frame_joint_fixed_jt args))
  (:wide_stereo_r_stereo_camera_frame_joint (&rest args) (forward-message-to wide_stereo_r_stereo_camera_frame_joint_fixed_jt args))
  (:wide_stereo_r_stereo_camera_optical_frame_joint (&rest args) (forward-message-to wide_stereo_r_stereo_camera_optical_frame_joint_fixed_jt args))

  ;; all links forwarding
  (:links (&rest args)
   (if (null args) (return-from :links (send-super :links)))
   (let ((key (car args))
           (nargs (cdr args)))
     (unless (keywordp key)
         (return-from :links (send-super* :links args)))
       (case key
       (:base_bellow_link (forward-message-to base_bellow_link_lk nargs))
       (:base_footprint (forward-message-to base_footprint_lk nargs))
       (:base_laser_link (forward-message-to base_laser_link_lk nargs))
       (:base_link (forward-message-to base_link_lk nargs))
       (:bl_caster_l_wheel_link (forward-message-to bl_caster_l_wheel_link_lk nargs))
       (:bl_caster_r_wheel_link (forward-message-to bl_caster_r_wheel_link_lk nargs))
       (:bl_caster_rotation_link (forward-message-to bl_caster_rotation_link_lk nargs))
       (:br_caster_l_wheel_link (forward-message-to br_caster_l_wheel_link_lk nargs))
       (:br_caster_r_wheel_link (forward-message-to br_caster_r_wheel_link_lk nargs))
       (:br_caster_rotation_link (forward-message-to br_caster_rotation_link_lk nargs))
       (:double_stereo_link (forward-message-to double_stereo_link_lk nargs))
       (:fl_caster_l_wheel_link (forward-message-to fl_caster_l_wheel_link_lk nargs))
       (:fl_caster_r_wheel_link (forward-message-to fl_caster_r_wheel_link_lk nargs))
       (:fl_caster_rotation_link (forward-message-to fl_caster_rotation_link_lk nargs))
       (:fr_caster_l_wheel_link (forward-message-to fr_caster_l_wheel_link_lk nargs))
       (:fr_caster_r_wheel_link (forward-message-to fr_caster_r_wheel_link_lk nargs))
       (:fr_caster_rotation_link (forward-message-to fr_caster_rotation_link_lk nargs))
       (:head_chain_cb_link (forward-message-to head_chain_cb_link_lk nargs))
       (:head_mount_kinect_ir_link (forward-message-to head_mount_kinect_ir_link_lk nargs))
       (:head_mount_kinect_ir_optical_frame (forward-message-to head_mount_kinect_ir_optical_frame_lk nargs))
       (:head_mount_kinect_rgb_link (forward-message-to head_mount_kinect_rgb_link_lk nargs))
       (:head_mount_kinect_rgb_optical_frame (forward-message-to head_mount_kinect_rgb_optical_frame_lk nargs))
       (:head_mount_link (forward-message-to head_mount_link_lk nargs))
       (:head_mount_prosilica_link (forward-message-to head_mount_prosilica_link_lk nargs))
       (:head_mount_prosilica_optical_frame (forward-message-to head_mount_prosilica_optical_frame_lk nargs))
       (:head_pan_link (forward-message-to head_pan_link_lk nargs))
       (:head_plate_frame (forward-message-to head_plate_frame_lk nargs))
       (:head_tilt_link (forward-message-to head_tilt_link_lk nargs))
       (:high_def_frame (forward-message-to high_def_frame_lk nargs))
       (:high_def_optical_frame (forward-message-to high_def_optical_frame_lk nargs))
       (:imu_link (forward-message-to imu_link_lk nargs))
       (:l_elbow_flex_link (forward-message-to l_elbow_flex_link_lk nargs))
       (:l_forearm_cam_frame (forward-message-to l_forearm_cam_frame_lk nargs))
       (:l_forearm_cam_optical_frame (forward-message-to l_forearm_cam_optical_frame_lk nargs))
       (:l_forearm_link (forward-message-to l_forearm_link_lk nargs))
       (:l_forearm_roll_link (forward-message-to l_forearm_roll_link_lk nargs))
       (:l_gripper_l_finger_link (forward-message-to l_gripper_l_finger_link_lk nargs))
       (:l_gripper_l_finger_tip_frame (forward-message-to l_gripper_l_finger_tip_frame_lk nargs))
       (:l_gripper_l_finger_tip_link (forward-message-to l_gripper_l_finger_tip_link_lk nargs))
       (:l_gripper_led_frame (forward-message-to l_gripper_led_frame_lk nargs))
       (:l_gripper_motor_accelerometer_link (forward-message-to l_gripper_motor_accelerometer_link_lk nargs))
       (:l_gripper_motor_screw_link (forward-message-to l_gripper_motor_screw_link_lk nargs))
       (:l_gripper_motor_slider_link (forward-message-to l_gripper_motor_slider_link_lk nargs))
       (:l_gripper_palm_link (forward-message-to l_gripper_palm_link_lk nargs))
       (:l_gripper_r_finger_link (forward-message-to l_gripper_r_finger_link_lk nargs))
       (:l_gripper_r_finger_tip_link (forward-message-to l_gripper_r_finger_tip_link_lk nargs))
       (:l_gripper_tool_frame (forward-message-to l_gripper_tool_frame_lk nargs))
       (:l_shoulder_lift_link (forward-message-to l_shoulder_lift_link_lk nargs))
       (:l_shoulder_pan_link (forward-message-to l_shoulder_pan_link_lk nargs))
       (:l_torso_lift_side_plate_link (forward-message-to l_torso_lift_side_plate_link_lk nargs))
       (:l_upper_arm_link (forward-message-to l_upper_arm_link_lk nargs))
       (:l_upper_arm_roll_link (forward-message-to l_upper_arm_roll_link_lk nargs))
       (:l_wrist_flex_link (forward-message-to l_wrist_flex_link_lk nargs))
       (:l_wrist_roll_link (forward-message-to l_wrist_roll_link_lk nargs))
       (:laser_tilt_link (forward-message-to laser_tilt_link_lk nargs))
       (:laser_tilt_mount_link (forward-message-to laser_tilt_mount_link_lk nargs))
       (:left_arm_chain_cb_link (forward-message-to left_arm_chain_cb_link_lk nargs))
       (:narrow_stereo_l_stereo_camera_frame (forward-message-to narrow_stereo_l_stereo_camera_frame_lk nargs))
       (:narrow_stereo_l_stereo_camera_optical_frame (forward-message-to narrow_stereo_l_stereo_camera_optical_frame_lk nargs))
       (:narrow_stereo_link (forward-message-to narrow_stereo_link_lk nargs))
       (:narrow_stereo_optical_frame (forward-message-to narrow_stereo_optical_frame_lk nargs))
       (:narrow_stereo_r_stereo_camera_frame (forward-message-to narrow_stereo_r_stereo_camera_frame_lk nargs))
       (:narrow_stereo_r_stereo_camera_optical_frame (forward-message-to narrow_stereo_r_stereo_camera_optical_frame_lk nargs))
       (:projector_wg6802418_child_frame (forward-message-to projector_wg6802418_child_frame_lk nargs))
       (:projector_wg6802418_frame (forward-message-to projector_wg6802418_frame_lk nargs))
       (:r_elbow_flex_link (forward-message-to r_elbow_flex_link_lk nargs))
       (:r_forearm_cam_frame (forward-message-to r_forearm_cam_frame_lk nargs))
       (:r_forearm_cam_optical_frame (forward-message-to r_forearm_cam_optical_frame_lk nargs))
       (:r_forearm_link (forward-message-to r_forearm_link_lk nargs))
       (:r_forearm_roll_link (forward-message-to r_forearm_roll_link_lk nargs))
       (:r_gripper_l_finger_link (forward-message-to r_gripper_l_finger_link_lk nargs))
       (:r_gripper_l_finger_tip_frame (forward-message-to r_gripper_l_finger_tip_frame_lk nargs))
       (:r_gripper_l_finger_tip_link (forward-message-to r_gripper_l_finger_tip_link_lk nargs))
       (:r_gripper_led_frame (forward-message-to r_gripper_led_frame_lk nargs))
       (:r_gripper_motor_accelerometer_link (forward-message-to r_gripper_motor_accelerometer_link_lk nargs))
       (:r_gripper_motor_screw_link (forward-message-to r_gripper_motor_screw_link_lk nargs))
       (:r_gripper_motor_slider_link (forward-message-to r_gripper_motor_slider_link_lk nargs))
       (:r_gripper_palm_link (forward-message-to r_gripper_palm_link_lk nargs))
       (:r_gripper_r_finger_link (forward-message-to r_gripper_r_finger_link_lk nargs))
       (:r_gripper_r_finger_tip_link (forward-message-to r_gripper_r_finger_tip_link_lk nargs))
       (:r_gripper_tool_frame (forward-message-to r_gripper_tool_frame_lk nargs))
       (:r_shoulder_lift_link (forward-message-to r_shoulder_lift_link_lk nargs))
       (:r_shoulder_pan_link (forward-message-to r_shoulder_pan_link_lk nargs))
       (:r_torso_lift_side_plate_link (forward-message-to r_torso_lift_side_plate_link_lk nargs))
       (:r_upper_arm_link (forward-message-to r_upper_arm_link_lk nargs))
       (:r_upper_arm_roll_link (forward-message-to r_upper_arm_roll_link_lk nargs))
       (:r_wrist_flex_link (forward-message-to r_wrist_flex_link_lk nargs))
       (:r_wrist_roll_link (forward-message-to r_wrist_roll_link_lk nargs))
       (:right_arm_chain_cb_link (forward-message-to right_arm_chain_cb_link_lk nargs))
       (:sensor_mount_link (forward-message-to sensor_mount_link_lk nargs))
       (:torso_lift_link (forward-message-to torso_lift_link_lk nargs))
       (:torso_lift_motor_screw_link (forward-message-to torso_lift_motor_screw_link_lk nargs))
       (:wide_stereo_l_stereo_camera_frame (forward-message-to wide_stereo_l_stereo_camera_frame_lk nargs))
       (:wide_stereo_l_stereo_camera_optical_frame (forward-message-to wide_stereo_l_stereo_camera_optical_frame_lk nargs))
       (:wide_stereo_link (forward-message-to wide_stereo_link_lk nargs))
       (:wide_stereo_optical_frame (forward-message-to wide_stereo_optical_frame_lk nargs))
       (:wide_stereo_r_stereo_camera_frame (forward-message-to wide_stereo_r_stereo_camera_frame_lk nargs))
       (:wide_stereo_r_stereo_camera_optical_frame (forward-message-to wide_stereo_r_stereo_camera_optical_frame_lk nargs))
       (t (send-super* :links args)))))

  ;; all links
  (:base_bellow_link_lk (&rest args) (forward-message-to base_bellow_link_lk args))
  (:base_footprint_lk (&rest args) (forward-message-to base_footprint_lk args))
  (:base_laser_link_lk (&rest args) (forward-message-to base_laser_link_lk args))
  (:base_link_lk (&rest args) (forward-message-to base_link_lk args))
  (:bl_caster_l_wheel_link_lk (&rest args) (forward-message-to bl_caster_l_wheel_link_lk args))
  (:bl_caster_r_wheel_link_lk (&rest args) (forward-message-to bl_caster_r_wheel_link_lk args))
  (:bl_caster_rotation_link_lk (&rest args) (forward-message-to bl_caster_rotation_link_lk args))
  (:br_caster_l_wheel_link_lk (&rest args) (forward-message-to br_caster_l_wheel_link_lk args))
  (:br_caster_r_wheel_link_lk (&rest args) (forward-message-to br_caster_r_wheel_link_lk args))
  (:br_caster_rotation_link_lk (&rest args) (forward-message-to br_caster_rotation_link_lk args))
  (:double_stereo_link_lk (&rest args) (forward-message-to double_stereo_link_lk args))
  (:fl_caster_l_wheel_link_lk (&rest args) (forward-message-to fl_caster_l_wheel_link_lk args))
  (:fl_caster_r_wheel_link_lk (&rest args) (forward-message-to fl_caster_r_wheel_link_lk args))
  (:fl_caster_rotation_link_lk (&rest args) (forward-message-to fl_caster_rotation_link_lk args))
  (:fr_caster_l_wheel_link_lk (&rest args) (forward-message-to fr_caster_l_wheel_link_lk args))
  (:fr_caster_r_wheel_link_lk (&rest args) (forward-message-to fr_caster_r_wheel_link_lk args))
  (:fr_caster_rotation_link_lk (&rest args) (forward-message-to fr_caster_rotation_link_lk args))
  (:head_chain_cb_link_lk (&rest args) (forward-message-to head_chain_cb_link_lk args))
  (:head_mount_kinect_ir_link_lk (&rest args) (forward-message-to head_mount_kinect_ir_link_lk args))
  (:head_mount_kinect_ir_optical_frame_lk (&rest args) (forward-message-to head_mount_kinect_ir_optical_frame_lk args))
  (:head_mount_kinect_rgb_link_lk (&rest args) (forward-message-to head_mount_kinect_rgb_link_lk args))
  (:head_mount_kinect_rgb_optical_frame_lk (&rest args) (forward-message-to head_mount_kinect_rgb_optical_frame_lk args))
  (:head_mount_link_lk (&rest args) (forward-message-to head_mount_link_lk args))
  (:head_mount_prosilica_link_lk (&rest args) (forward-message-to head_mount_prosilica_link_lk args))
  (:head_mount_prosilica_optical_frame_lk (&rest args) (forward-message-to head_mount_prosilica_optical_frame_lk args))
  (:head_pan_link_lk (&rest args) (forward-message-to head_pan_link_lk args))
  (:head_plate_frame_lk (&rest args) (forward-message-to head_plate_frame_lk args))
  (:head_tilt_link_lk (&rest args) (forward-message-to head_tilt_link_lk args))
  (:high_def_frame_lk (&rest args) (forward-message-to high_def_frame_lk args))
  (:high_def_optical_frame_lk (&rest args) (forward-message-to high_def_optical_frame_lk args))
  (:imu_link_lk (&rest args) (forward-message-to imu_link_lk args))
  (:l_elbow_flex_link_lk (&rest args) (forward-message-to l_elbow_flex_link_lk args))
  (:l_forearm_cam_frame_lk (&rest args) (forward-message-to l_forearm_cam_frame_lk args))
  (:l_forearm_cam_optical_frame_lk (&rest args) (forward-message-to l_forearm_cam_optical_frame_lk args))
  (:l_forearm_link_lk (&rest args) (forward-message-to l_forearm_link_lk args))
  (:l_forearm_roll_link_lk (&rest args) (forward-message-to l_forearm_roll_link_lk args))
  (:l_gripper_l_finger_link_lk (&rest args) (forward-message-to l_gripper_l_finger_link_lk args))
  (:l_gripper_l_finger_tip_frame_lk (&rest args) (forward-message-to l_gripper_l_finger_tip_frame_lk args))
  (:l_gripper_l_finger_tip_link_lk (&rest args) (forward-message-to l_gripper_l_finger_tip_link_lk args))
  (:l_gripper_led_frame_lk (&rest args) (forward-message-to l_gripper_led_frame_lk args))
  (:l_gripper_motor_accelerometer_link_lk (&rest args) (forward-message-to l_gripper_motor_accelerometer_link_lk args))
  (:l_gripper_motor_screw_link_lk (&rest args) (forward-message-to l_gripper_motor_screw_link_lk args))
  (:l_gripper_motor_slider_link_lk (&rest args) (forward-message-to l_gripper_motor_slider_link_lk args))
  (:l_gripper_palm_link_lk (&rest args) (forward-message-to l_gripper_palm_link_lk args))
  (:l_gripper_r_finger_link_lk (&rest args) (forward-message-to l_gripper_r_finger_link_lk args))
  (:l_gripper_r_finger_tip_link_lk (&rest args) (forward-message-to l_gripper_r_finger_tip_link_lk args))
  (:l_gripper_tool_frame_lk (&rest args) (forward-message-to l_gripper_tool_frame_lk args))
  (:l_shoulder_lift_link_lk (&rest args) (forward-message-to l_shoulder_lift_link_lk args))
  (:l_shoulder_pan_link_lk (&rest args) (forward-message-to l_shoulder_pan_link_lk args))
  (:l_torso_lift_side_plate_link_lk (&rest args) (forward-message-to l_torso_lift_side_plate_link_lk args))
  (:l_upper_arm_link_lk (&rest args) (forward-message-to l_upper_arm_link_lk args))
  (:l_upper_arm_roll_link_lk (&rest args) (forward-message-to l_upper_arm_roll_link_lk args))
  (:l_wrist_flex_link_lk (&rest args) (forward-message-to l_wrist_flex_link_lk args))
  (:l_wrist_roll_link_lk (&rest args) (forward-message-to l_wrist_roll_link_lk args))
  (:laser_tilt_link_lk (&rest args) (forward-message-to laser_tilt_link_lk args))
  (:laser_tilt_mount_link_lk (&rest args) (forward-message-to laser_tilt_mount_link_lk args))
  (:left_arm_chain_cb_link_lk (&rest args) (forward-message-to left_arm_chain_cb_link_lk args))
  (:narrow_stereo_l_stereo_camera_frame_lk (&rest args) (forward-message-to narrow_stereo_l_stereo_camera_frame_lk args))
  (:narrow_stereo_l_stereo_camera_optical_frame_lk (&rest args) (forward-message-to narrow_stereo_l_stereo_camera_optical_frame_lk args))
  (:narrow_stereo_link_lk (&rest args) (forward-message-to narrow_stereo_link_lk args))
  (:narrow_stereo_optical_frame_lk (&rest args) (forward-message-to narrow_stereo_optical_frame_lk args))
  (:narrow_stereo_r_stereo_camera_frame_lk (&rest args) (forward-message-to narrow_stereo_r_stereo_camera_frame_lk args))
  (:narrow_stereo_r_stereo_camera_optical_frame_lk (&rest args) (forward-message-to narrow_stereo_r_stereo_camera_optical_frame_lk args))
  (:projector_wg6802418_child_frame_lk (&rest args) (forward-message-to projector_wg6802418_child_frame_lk args))
  (:projector_wg6802418_frame_lk (&rest args) (forward-message-to projector_wg6802418_frame_lk args))
  (:r_elbow_flex_link_lk (&rest args) (forward-message-to r_elbow_flex_link_lk args))
  (:r_forearm_cam_frame_lk (&rest args) (forward-message-to r_forearm_cam_frame_lk args))
  (:r_forearm_cam_optical_frame_lk (&rest args) (forward-message-to r_forearm_cam_optical_frame_lk args))
  (:r_forearm_link_lk (&rest args) (forward-message-to r_forearm_link_lk args))
  (:r_forearm_roll_link_lk (&rest args) (forward-message-to r_forearm_roll_link_lk args))
  (:r_gripper_l_finger_link_lk (&rest args) (forward-message-to r_gripper_l_finger_link_lk args))
  (:r_gripper_l_finger_tip_frame_lk (&rest args) (forward-message-to r_gripper_l_finger_tip_frame_lk args))
  (:r_gripper_l_finger_tip_link_lk (&rest args) (forward-message-to r_gripper_l_finger_tip_link_lk args))
  (:r_gripper_led_frame_lk (&rest args) (forward-message-to r_gripper_led_frame_lk args))
  (:r_gripper_motor_accelerometer_link_lk (&rest args) (forward-message-to r_gripper_motor_accelerometer_link_lk args))
  (:r_gripper_motor_screw_link_lk (&rest args) (forward-message-to r_gripper_motor_screw_link_lk args))
  (:r_gripper_motor_slider_link_lk (&rest args) (forward-message-to r_gripper_motor_slider_link_lk args))
  (:r_gripper_palm_link_lk (&rest args) (forward-message-to r_gripper_palm_link_lk args))
  (:r_gripper_r_finger_link_lk (&rest args) (forward-message-to r_gripper_r_finger_link_lk args))
  (:r_gripper_r_finger_tip_link_lk (&rest args) (forward-message-to r_gripper_r_finger_tip_link_lk args))
  (:r_gripper_tool_frame_lk (&rest args) (forward-message-to r_gripper_tool_frame_lk args))
  (:r_shoulder_lift_link_lk (&rest args) (forward-message-to r_shoulder_lift_link_lk args))
  (:r_shoulder_pan_link_lk (&rest args) (forward-message-to r_shoulder_pan_link_lk args))
  (:r_torso_lift_side_plate_link_lk (&rest args) (forward-message-to r_torso_lift_side_plate_link_lk args))
  (:r_upper_arm_link_lk (&rest args) (forward-message-to r_upper_arm_link_lk args))
  (:r_upper_arm_roll_link_lk (&rest args) (forward-message-to r_upper_arm_roll_link_lk args))
  (:r_wrist_flex_link_lk (&rest args) (forward-message-to r_wrist_flex_link_lk args))
  (:r_wrist_roll_link_lk (&rest args) (forward-message-to r_wrist_roll_link_lk args))
  (:right_arm_chain_cb_link_lk (&rest args) (forward-message-to right_arm_chain_cb_link_lk args))
  (:sensor_mount_link_lk (&rest args) (forward-message-to sensor_mount_link_lk args))
  (:torso_lift_link_lk (&rest args) (forward-message-to torso_lift_link_lk args))
  (:torso_lift_motor_screw_link_lk (&rest args) (forward-message-to torso_lift_motor_screw_link_lk args))
  (:wide_stereo_l_stereo_camera_frame_lk (&rest args) (forward-message-to wide_stereo_l_stereo_camera_frame_lk args))
  (:wide_stereo_l_stereo_camera_optical_frame_lk (&rest args) (forward-message-to wide_stereo_l_stereo_camera_optical_frame_lk args))
  (:wide_stereo_link_lk (&rest args) (forward-message-to wide_stereo_link_lk args))
  (:wide_stereo_optical_frame_lk (&rest args) (forward-message-to wide_stereo_optical_frame_lk args))
  (:wide_stereo_r_stereo_camera_frame_lk (&rest args) (forward-message-to wide_stereo_r_stereo_camera_frame_lk args))
  (:wide_stereo_r_stereo_camera_optical_frame_lk (&rest args) (forward-message-to wide_stereo_r_stereo_camera_optical_frame_lk args))

  ;; user-defined joint
  (:torso-waist-z (&rest args) (forward-message-to torso_lift_joint_jt args))
  (:larm-collar-y (&rest args) (forward-message-to l_shoulder_pan_joint_jt args))
  (:larm-shoulder-p (&rest args) (forward-message-to l_shoulder_lift_joint_jt args))
  (:larm-shoulder-r (&rest args) (forward-message-to l_upper_arm_roll_joint_jt args))
  (:larm-elbow-p (&rest args) (forward-message-to l_elbow_flex_joint_jt args))
  (:larm-elbow-r (&rest args) (forward-message-to l_forearm_roll_joint_jt args))
  (:larm-wrist-p (&rest args) (forward-message-to l_wrist_flex_joint_jt args))
  (:larm-wrist-r (&rest args) (forward-message-to l_wrist_roll_joint_jt args))
  (:rarm-collar-y (&rest args) (forward-message-to r_shoulder_pan_joint_jt args))
  (:rarm-shoulder-p (&rest args) (forward-message-to r_shoulder_lift_joint_jt args))
  (:rarm-shoulder-r (&rest args) (forward-message-to r_upper_arm_roll_joint_jt args))
  (:rarm-elbow-p (&rest args) (forward-message-to r_elbow_flex_joint_jt args))
  (:rarm-elbow-r (&rest args) (forward-message-to r_forearm_roll_joint_jt args))
  (:rarm-wrist-p (&rest args) (forward-message-to r_wrist_flex_joint_jt args))
  (:rarm-wrist-r (&rest args) (forward-message-to r_wrist_roll_joint_jt args))
  (:head-neck-y (&rest args) (forward-message-to head_pan_joint_jt args))
  (:head-neck-p (&rest args) (forward-message-to head_tilt_joint_jt args))

  ;; attach_sensor methods

  ;; geometries
  (:_make_instance_base_bellow_link_geom0 ()
    (let (geom glv qhull
          (local-cds (make-coords :pos (float-vector -2.9000000000000000e+02 0.0000000000000000e+00 8.0000000000000000e+02))))
      (setq glv
       (instance gl::glvertices :init
                 (list ;; mesh list
                  (list ;; mesh description
                   (list :type :triangles)
                   (list :material (list
                    (list :ambient (float-vector 0.050000 0.050000 0.050000 1.000000))
                    (list :diffuse (float-vector 0.100000 0.100000 0.100000 1.000000))))
                   (list :indices #i( 0 1 2 2 3 0 4 3 2 2 5 4 6 5 2 2 1 6 3 4 7 7 0 3 0 7 6 6 1 0 6 7 4 4 5 6))
                   (list :vertices (let ((mat (make-matrix 8 3))) (fvector-replace (array-entity mat) #f(2.6500000000000000e+02 -1.8500000000000000e+02 -9.5000000000000000e+02 3.1500000000000000e+02 -1.8500000000000000e+02 -9.5000000000000000e+02 3.1500000000000000e+02 -1.8500000000000000e+02 -6.5000000000000000e+02 2.6500000000000000e+02 -1.8500000000000000e+02 -6.5000000000000000e+02 2.6500000000000000e+02 1.8500000000000000e+02 -6.5000000000000000e+02 3.1500000000000000e+02 1.8500000000000000e+02 -6.5000000000000000e+02 3.1500000000000000e+02 1.8500000000000000e+02 -9.5000000000000000e+02 2.6500000000000000e+02 1.8500000000000000e+02 -9.5000000000000000e+02 )) mat)))
                  )
                 ))
      (send glv :transform local-cds)
      (send glv :calc-normals)
      (setq qhull
            ;; qhull 36 -> 6 faces
            (instance faceset :init :faces (list
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.6499998569488525e+02 -1.8500000238418579e+02 -9.4999998807907104e+02) (float-vector 2.6499998569488525e+02 -1.8500000238418579e+02 -6.4999997615814209e+02) (float-vector 3.1499999761581421e+02 -1.8500000238418579e+02 -6.4999997615814209e+02) (float-vector 3.1499999761581421e+02 -1.8500000238418579e+02 -9.4999998807907104e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.6499998569488525e+02 1.8500000238418579e+02 -9.4999998807907104e+02) (float-vector 2.6499998569488525e+02 1.8500000238418579e+02 -6.4999997615814209e+02) (float-vector 2.6499998569488525e+02 -1.8500000238418579e+02 -6.4999997615814209e+02) (float-vector 2.6499998569488525e+02 -1.8500000238418579e+02 -9.4999998807907104e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1499999761581421e+02 1.8500000238418579e+02 -9.4999998807907104e+02) (float-vector 2.6499998569488525e+02 1.8500000238418579e+02 -9.4999998807907104e+02) (float-vector 2.6499998569488525e+02 -1.8500000238418579e+02 -9.4999998807907104e+02) (float-vector 3.1499999761581421e+02 -1.8500000238418579e+02 -9.4999998807907104e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.6499998569488525e+02 1.8500000238418579e+02 -6.4999997615814209e+02) (float-vector 3.1499999761581421e+02 1.8500000238418579e+02 -6.4999997615814209e+02) (float-vector 3.1499999761581421e+02 -1.8500000238418579e+02 -6.4999997615814209e+02) (float-vector 2.6499998569488525e+02 -1.8500000238418579e+02 -6.4999997615814209e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1499999761581421e+02 1.8500000238418579e+02 -9.4999998807907104e+02) (float-vector 3.1499999761581421e+02 1.8500000238418579e+02 -6.4999997615814209e+02) (float-vector 2.6499998569488525e+02 1.8500000238418579e+02 -6.4999997615814209e+02) (float-vector 2.6499998569488525e+02 1.8500000238418579e+02 -9.4999998807907104e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1499999761581421e+02 1.8500000238418579e+02 -6.4999997615814209e+02) (float-vector 3.1499999761581421e+02 1.8500000238418579e+02 -9.4999998807907104e+02) (float-vector 3.1499999761581421e+02 -1.8500000238418579e+02 -9.4999998807907104e+02) (float-vector 3.1499999761581421e+02 -1.8500000238418579e+02 -6.4999997615814209e+02)))))
              ))
             )
      (setq geom (instance collada-body :init :replace-obj qhull :name "base_bellow_link_geom0"))
      (when glv
        (setq (geom . gl::aglvertices) glv)
        (send geom :assoc glv))
      geom))
  (:_make_instance_base_footprint_geom0 ()
    (let (geom glv qhull
          (local-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
      (setq glv
       (instance gl::glvertices :init
                 (list ;; mesh list
                  (list ;; mesh description
                   (list :type :triangles)
                   (list :material (list
                    (list :ambient (float-vector 0.500000 0.500000 0.500000 1.000000))
                    (list :diffuse (float-vector 1.000000 1.000000 1.000000 1.000000))))
                   (list :indices #i( 0 1 2 2 3 0 4 3 2 2 5 4 6 5 2 2 1 6 3 4 7 7 0 3 0 7 6 6 1 0 6 7 4 4 5 6))
                   (list :vertices (let ((mat (make-matrix 8 3))) (fvector-replace (array-entity mat) #f(-5.0000000000000000e+00 -5.0000000000000000e+00 -5.0000000000000000e+00 5.0000000000000000e+00 -5.0000000000000000e+00 -5.0000000000000000e+00 5.0000000000000000e+00 -5.0000000000000000e+00 5.0000000000000000e+00 -5.0000000000000000e+00 -5.0000000000000000e+00 5.0000000000000000e+00 -5.0000000000000000e+00 5.0000000000000000e+00 5.0000000000000000e+00 5.0000000000000000e+00 5.0000000000000000e+00 5.0000000000000000e+00 5.0000000000000000e+00 5.0000000000000000e+00 -5.0000000000000000e+00 -5.0000000000000000e+00 5.0000000000000000e+00 -5.0000000000000000e+00 )) mat)))
                  )
                 ))
      (send glv :transform local-cds)
      (send glv :calc-normals)
      (setq qhull
            ;; qhull 36 -> 6 faces
            (instance faceset :init :faces (list
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.9999998882412910e+00 -4.9999998882412910e+00 -4.9999998882412910e+00) (float-vector -4.9999998882412910e+00 -4.9999998882412910e+00 4.9999998882412910e+00) (float-vector 4.9999998882412910e+00 -4.9999998882412910e+00 4.9999998882412910e+00) (float-vector 4.9999998882412910e+00 -4.9999998882412910e+00 -4.9999998882412910e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.9999998882412910e+00 4.9999998882412910e+00 -4.9999998882412910e+00) (float-vector -4.9999998882412910e+00 4.9999998882412910e+00 4.9999998882412910e+00) (float-vector -4.9999998882412910e+00 -4.9999998882412910e+00 4.9999998882412910e+00) (float-vector -4.9999998882412910e+00 -4.9999998882412910e+00 -4.9999998882412910e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.9999998882412910e+00 4.9999998882412910e+00 -4.9999998882412910e+00) (float-vector -4.9999998882412910e+00 4.9999998882412910e+00 -4.9999998882412910e+00) (float-vector -4.9999998882412910e+00 -4.9999998882412910e+00 -4.9999998882412910e+00) (float-vector 4.9999998882412910e+00 -4.9999998882412910e+00 -4.9999998882412910e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.9999998882412910e+00 4.9999998882412910e+00 4.9999998882412910e+00) (float-vector 4.9999998882412910e+00 4.9999998882412910e+00 4.9999998882412910e+00) (float-vector 4.9999998882412910e+00 -4.9999998882412910e+00 4.9999998882412910e+00) (float-vector -4.9999998882412910e+00 -4.9999998882412910e+00 4.9999998882412910e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.9999998882412910e+00 4.9999998882412910e+00 -4.9999998882412910e+00) (float-vector 4.9999998882412910e+00 4.9999998882412910e+00 4.9999998882412910e+00) (float-vector -4.9999998882412910e+00 4.9999998882412910e+00 4.9999998882412910e+00) (float-vector -4.9999998882412910e+00 4.9999998882412910e+00 -4.9999998882412910e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.9999998882412910e+00 4.9999998882412910e+00 4.9999998882412910e+00) (float-vector 4.9999998882412910e+00 4.9999998882412910e+00 -4.9999998882412910e+00) (float-vector 4.9999998882412910e+00 -4.9999998882412910e+00 -4.9999998882412910e+00) (float-vector 4.9999998882412910e+00 -4.9999998882412910e+00 4.9999998882412910e+00)))))
              ))
             )
      (setq geom (instance collada-body :init :replace-obj qhull :name "base_footprint_geom0"))
      (when glv
        (setq (geom . gl::aglvertices) glv)
        (send geom :assoc glv))
      geom))
  (:_make_instance_base_link_geom0 ()
    (let (geom glv qhull
          (local-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 5.1000000000000000e+01))))
      (setq glv
       (instance gl::glvertices :init
                 (list ;; mesh list
                  (list ;; mesh description
                   (list :type :triangles)
                   (list :material (list
                    (list :ambient (float-vector 0.500000 0.500000 0.500000 1.000000))
                    (list :diffuse (float-vector 1.000000 1.000000 1.000000 1.000000))))
                   (list :indices #i( 0 1 2 1 0 6 329 0 2 0 328 6 329 328 0 9 12 6 1 6 12 9 6 328 327 328 279 280 279 328 280 328 329 327 9 328 321 327 277 327 279 277 327 321 9 279 278 277 279 280 278 280 281 278 282 281 280 282 280 329 283 281 282 278 281 314 314 281 283 283 282 284 329 330 282 330 284 282 284 285 283 330 331 284 331 285 284 3 330 2 329 2 330 330 3 331 335 274 331 274 285 331 3 397 331 331 397 335 285 256 283 285 274 256 254 255 256 256 255 257 274 254 256 283 256 257 312 283 257 312 314 283 312 257 255 314 312 255 255 315 314 314 315 278 255 313 315 313 278 315 277 278 276 313 276 278 255 311 313 276 313 273 273 313 311 276 273 269 269 277 276 321 277 269 318 321 269 318 7 321 9 321 7 7 8 9 318 393 7 393 436 7 436 437 7 437 8 7 13 12 9 13 9 8 13 474 12 8 474 13 12 475 1 474 475 12 471 474 8 471 475 474 438 471 8 438 472 471 485 471 51 471 488 51 471 472 488 475 471 485 438 153 472 153 473 472 473 486 472 472 486 488 488 48 51 48 488 49 486 49 488 487 486 473 486 487 69 69 46 486 49 486 46 48 49 46 46 51 48 45 46 47 50 51 46 46 45 50 69 72 46 46 72 47 47 24 45 25 24 47 47 73 25 72 73 47 71 74 72 72 74 73 71 72 69 69 70 71 74 71 225 70 225 71 61 225 63 225 61 224 225 226 63 225 70 226 74 225 224 61 32 62 32 61 63 223 224 61 62 223 61 63 64 32 63 65 64 63 226 65 226 227 65 226 70 227 65 66 64 65 227 66 66 68 64 29 32 64 29 64 68 66 67 68 66 228 67 227 228 66 227 70 228 229 67 228 228 230 229 230 228 70 67 77 68 87 77 67 67 229 87 235 229 230 235 237 229 87 229 237 87 89 77 87 237 89 238 237 235 89 237 238 89 41 77 41 89 88 236 89 238 236 88 89 236 238 85 235 85 238 234 236 84 84 236 85 234 88 236 62 41 88 234 62 88 223 234 84 234 223 62 32 41 62 29 26 32 26 33 32 32 33 41 34 33 25 26 25 33 42 33 34 33 42 41 25 35 34 34 35 60 34 60 42 25 26 24 35 25 73 35 73 221 35 221 60 42 60 44 217 218 60 60 221 217 218 44 60 221 219 217 221 73 219 74 222 73 73 222 219 217 219 220 219 215 220 222 215 219 220 218 217 231 232 218 220 231 218 232 44 218 215 214 220 220 214 231 214 215 216 222 216 215 222 74 216 233 216 79 214 216 233 84 216 74 216 84 79 214 233 231 231 82 232 231 233 82 44 232 83 232 82 83 81 82 79 83 82 81 233 79 82 78 79 80 79 78 81 79 84 80 80 84 85 74 223 84 80 85 78 78 86 81 93 78 85 86 78 93 81 43 83 81 86 43 44 83 43 42 43 41 40 41 43 42 44 43 40 43 21 86 21 43 93 52 86 21 86 52 20 17 21 21 17 18 18 40 21 21 52 20 20 19 17 19 20 22 52 22 20 17 16 18 17 19 16 16 30 18 30 31 18 31 40 18 14 15 16 16 19 14 16 28 30 28 16 15 14 19 23 22 23 19 26 14 23 15 14 26 15 27 28 15 26 27 28 37 30 37 28 38 28 29 38 28 27 29 26 29 27 23 24 26 23 22 24 22 45 24 22 52 45 52 53 45 45 56 50 57 56 45 53 55 45 55 57 45 56 489 50 56 476 489 56 446 476 56 57 446 485 51 50 485 50 489 485 489 475 475 489 476 10 475 11 1 475 10 11 475 476 1 10 2 2 10 11 2 11 4 11 476 4 2 4 3 3 4 5 5 4 447 447 4 476 3 5 397 335 397 395 5 395 397 274 335 334 335 395 334 334 395 396 395 5 396 274 334 333 334 396 333 333 396 394 394 396 439 5 439 396 332 274 333 333 394 332 394 398 332 398 394 439 332 305 274 341 305 332 332 398 341 274 305 301 305 306 301 305 307 306 341 307 305 345 307 341 341 398 345 306 307 308 309 308 307 345 309 307 336 301 306 336 306 337 337 306 308 274 301 300 336 300 301 336 316 300 337 316 336 337 338 316 308 338 337 316 288 300 288 316 317 338 339 316 317 316 340 316 339 340 300 275 274 300 288 275 271 274 275 271 275 286 288 289 275 275 289 364 286 275 364 286 287 271 290 287 286 378 290 286 286 364 378 287 290 291 377 290 378 377 291 290 364 377 378 291 377 420 377 421 420 377 364 421 420 421 295 420 295 291 422 295 421 422 421 364 291 295 296 297 296 295 297 295 298 422 298 295 298 422 365 364 365 422 299 298 289 298 299 297 298 365 289 365 364 289 288 299 289 302 299 288 302 288 340 288 317 340 302 303 304 304 299 302 303 302 340 340 339 303 308 310 303 310 304 303 303 339 308 342 304 343 310 343 304 299 304 342 308 309 310 310 344 343 344 310 309 338 308 339 344 309 345 343 344 399 345 402 344 402 399 344 343 399 342 399 400 342 399 454 400 399 402 456 456 454 399 345 401 402 401 458 402 402 458 456 345 398 401 398 457 401 401 457 458 458 212 456 213 458 457 213 212 458 456 212 454 209 212 210 212 213 207 207 210 212 212 493 454 501 493 212 209 501 212 207 213 208 213 59 208 457 59 213 206 203 207 208 206 207 207 203 210 208 59 58 206 208 58 206 204 203 204 206 528 58 528 206 203 204 205 205 204 529 528 529 204 201 528 58 200 529 528 200 528 201 199 530 529 199 529 200 529 574 205 530 574 529 205 565 203 574 565 205 530 573 574 565 574 573 202 530 199 202 531 530 573 530 531 573 531 583 565 573 562 562 573 583 564 565 566 203 565 564 565 562 566 561 562 563 561 566 562 562 583 563 566 561 522 522 564 566 522 203 564 203 522 210 522 211 210 511 211 522 561 511 522 561 563 520 520 511 561 510 209 511 211 511 209 511 521 510 519 511 520 519 521 511 209 210 211 494 209 510 494 501 209 455 493 494 494 484 455 484 494 510 493 501 494 454 493 455 400 454 455 342 400 356 356 400 419 455 419 400 299 342 356 355 299 356 356 419 355 355 419 418 455 417 419 419 417 418 299 355 354 355 418 354 354 418 417 354 417 416 455 416 417 353 351 354 299 354 351 354 416 353 353 416 351 416 413 351 416 466 413 466 416 484 455 484 416 299 351 352 351 413 414 351 414 352 466 467 413 413 467 414 352 414 415 414 470 415 467 470 414 349 299 352 352 415 349 349 415 412 470 483 415 415 483 412 470 466 483 467 466 470 483 466 505 505 466 484 412 483 465 465 483 178 169 178 483 169 483 503 483 505 503 503 505 506 505 484 507 507 506 505 503 502 169 503 512 502 503 506 517 503 517 512 506 515 516 516 517 506 506 507 515 518 517 516 517 518 512 514 518 516 515 514 516 513 514 515 515 507 513 514 525 518 525 514 527 513 527 514 524 512 518 525 524 518 524 523 512 524 525 567 171 524 567 524 170 523 170 524 171 523 139 512 523 170 139 139 170 171 140 139 171 171 172 140 567 569 171 172 171 569 139 140 141 504 139 141 512 139 504 512 504 502 502 504 141 142 141 140 169 141 166 141 142 166 141 169 502 137 142 140 165 166 142 165 142 167 137 167 142 166 173 174 166 165 173 166 174 178 169 166 178 173 165 175 165 176 175 167 176 165 168 167 137 176 167 168 177 176 168 463 461 176 461 175 176 463 176 177 460 175 461 460 173 175 461 407 460 405 461 406 406 461 463 407 461 405 463 462 406 463 177 462 177 168 112 462 177 112 404 406 462 404 462 373 462 146 373 112 146 462 405 406 293 404 292 406 406 292 293 287 404 373 404 287 292 372 287 373 146 372 373 144 145 146 145 372 146 112 144 146 374 271 372 372 271 287 145 374 372 291 292 287 291 293 292 291 294 293 291 296 294 407 405 294 407 294 296 405 293 294 403 296 297 296 403 407 460 407 459 403 459 407 403 297 347 347 459 403 297 346 347 297 299 346 408 409 347 346 408 347 347 409 459 460 459 173 409 174 459 459 174 173 469 174 409 469 178 174 468 469 409 468 178 469 465 178 468 409 465 468 465 409 464 465 464 412 464 409 410 410 411 464 412 464 411 350 412 411 349 412 350 411 410 348 350 411 348 410 408 348 408 410 409 299 348 346 348 349 350 348 299 349 348 408 346 374 375 271 147 374 145 375 374 147 376 266 375 266 271 375 150 375 147 150 376 375 266 267 271 267 272 271 274 271 272 263 267 266 362 272 267 267 263 362 258 263 262 262 263 266 363 362 263 263 258 363 362 361 272 361 362 363 363 258 358 363 358 361 272 361 360 357 361 358 357 359 361 361 359 360 258 357 358 357 258 265 359 357 265 268 359 265 270 359 268 360 359 270 272 360 270 269 270 268 270 273 272 270 269 273 264 268 265 269 268 264 265 258 264 258 259 260 260 261 258 262 259 258 261 264 258 368 369 259 368 259 262 369 260 259 370 260 369 260 370 261 370 371 261 261 371 264 425 370 426 369 426 370 370 425 371 368 424 369 424 426 369 426 424 160 426 162 425 162 426 161 426 160 161 425 427 371 427 425 163 425 162 163 162 133 136 162 136 163 161 133 162 160 133 161 132 133 131 131 133 135 132 136 133 135 133 160 155 136 132 155 157 136 136 157 163 131 95 132 94 155 132 132 95 94 95 131 134 134 131 113 135 113 131 113 135 159 159 135 160 158 113 159 423 159 424 424 159 160 159 423 158 120 113 158 149 158 423 120 158 149 368 423 424 149 423 367 367 423 368 148 120 149 366 149 367 149 366 148 366 367 266 262 266 367 367 368 262 366 266 376 148 366 376 150 120 148 148 376 150 150 147 120 145 144 147 144 120 147 144 112 118 144 115 120 115 144 118 116 120 115 116 113 120 115 114 116 115 119 114 118 119 115 113 116 114 97 113 114 134 113 97 122 114 119 97 114 96 114 122 96 117 119 118 122 119 117 122 117 123 122 123 100 96 122 100 95 96 52 96 95 97 52 96 98 96 100 98 97 95 134 94 95 93 93 95 52 98 53 52 54 55 53 53 99 54 53 98 99 58 57 55 55 54 190 55 190 192 55 192 197 55 197 58 59 57 58 58 197 201 198 197 192 201 197 200 200 197 198 190 193 192 192 193 195 192 195 198 198 195 199 199 200 198 196 195 193 195 196 199 191 193 190 191 194 193 194 196 193 202 199 196 194 532 196 196 532 202 532 194 533 533 194 191 191 190 54 184 191 54 184 533 191 532 533 534 534 533 535 184 536 533 536 535 533 54 181 184 184 181 187 187 536 184 181 54 99 99 180 181 98 253 99 251 99 253 180 99 251 180 182 181 251 252 180 180 252 553 182 180 553 250 251 245 245 251 249 250 252 251 251 253 249 98 249 253 245 249 243 249 247 243 249 101 247 249 98 101 243 244 245 245 559 250 244 559 245 244 243 247 246 247 101 247 246 244 101 98 100 100 102 101 246 101 248 248 101 102 248 557 246 246 558 244 557 558 246 558 559 244 558 557 240 242 558 240 559 558 242 248 560 557 240 557 241 557 560 241 102 560 248 241 560 143 560 102 143 240 241 172 164 241 143 172 241 164 172 242 240 164 140 172 569 242 172 140 164 143 137 140 143 102 137 143 108 107 137 108 137 138 137 102 138 107 168 137 102 100 103 138 102 103 100 123 103 124 103 123 125 103 124 125 138 103 117 108 123 108 124 123 126 125 124 127 126 124 108 130 124 130 127 124 129 125 126 129 138 125 127 129 126 128 129 127 130 128 127 108 138 130 130 138 128 128 138 129 107 108 104 104 108 109 108 117 118 108 118 109 104 112 107 168 107 112 112 104 118 118 121 109 104 121 118 104 105 106 109 105 104 121 104 106 109 121 105 111 121 106 110 121 111 105 121 110 105 110 106 110 111 106 598 559 242 569 568 242 598 242 568 559 598 589 589 598 568 559 589 594 559 594 250 592 594 589 594 592 556 597 594 556 250 594 597 250 556 252 556 250 597 556 555 553 252 556 553 592 555 556 553 555 554 555 551 554 555 596 551 593 555 592 593 596 555 553 554 182 554 551 183 182 554 183 181 182 183 183 551 181 551 552 181 593 551 596 593 552 551 185 181 186 181 185 187 552 595 181 181 595 186 593 595 552 595 549 186 549 595 593 186 549 548 549 593 548 548 547 186 548 588 547 588 548 591 548 593 591 547 545 186 585 545 547 547 587 585 547 588 587 590 587 588 588 591 590 591 593 590 590 593 592 590 592 587 585 587 589 587 592 589 585 572 545 585 586 572 585 589 586 186 545 546 545 572 546 546 572 526 526 572 525 572 586 525 525 586 567 586 589 568 586 568 567 526 525 527 527 570 526 527 513 570 563 570 520 526 570 571 520 570 513 570 563 571 507 520 513 509 520 507 509 519 520 484 509 507 508 509 484 508 519 509 510 519 508 510 521 519 484 510 508 544 526 571 571 584 544 571 581 584 581 571 563 526 544 546 546 544 186 189 185 186 186 544 189 185 188 187 185 537 188 537 185 538 185 189 579 538 185 579 188 537 187 187 539 536 187 537 539 536 539 535 537 535 539 537 540 535 535 577 534 535 540 577 580 540 537 599 577 540 540 580 599 577 575 534 599 575 577 575 532 534 575 531 532 575 576 531 599 576 575 578 576 599 580 578 599 580 537 578 578 579 543 537 538 578 579 578 538 578 543 542 542 576 578 583 576 542 576 583 531 532 531 202 582 583 541 581 583 582 583 542 541 563 583 581 541 542 189 542 543 189 189 543 579 550 541 189 544 550 189 550 582 541 581 582 550 550 584 581 550 544 584 567 568 569 59 179 57 482 446 57 481 482 57 179 481 57 441 59 457 441 490 59 179 59 490 457 398 441 398 439 441 440 439 5 441 439 442 440 443 439 439 443 442 440 444 445 440 5 444 440 452 443 445 452 440 5 447 444 444 447 449 447 451 449 447 446 451 447 476 446 448 449 450 449 451 450 444 449 448 451 453 450 446 453 451 444 446 445 453 446 444 446 482 445 444 448 453 450 453 448 445 482 452 482 481 452 480 481 477 480 452 481 179 492 481 481 492 477 443 480 442 442 480 477 443 452 480 442 477 441 477 478 441 478 490 441 477 479 478 478 491 179 479 491 478 179 490 478 491 492 179 479 477 492 479 492 491 91 92 93 93 92 94 85 151 93 151 91 93 154 92 91 154 91 151 92 154 155 94 92 155 152 153 154 156 152 154 155 154 157 154 151 156 154 153 157 85 156 151 500 156 85 235 500 85 152 156 498 498 156 499 156 500 499 499 500 235 230 239 235 239 499 235 499 239 498 495 152 498 498 230 495 498 239 230 495 230 496 497 496 230 70 497 230 152 495 473 495 496 473 496 487 473 496 497 487 497 70 69 487 497 69 152 473 153 435 157 153 435 153 438 163 157 435 163 434 390 429 434 163 435 429 163 427 163 390 391 434 389 389 434 386 390 434 391 429 386 434 325 390 391 326 390 325 427 390 326 326 371 427 325 264 326 326 264 371 325 324 264 388 324 325 391 388 325 388 391 389 324 389 386 388 389 324 323 322 324 269 324 322 269 264 324 324 386 323 323 385 384 323 384 322 386 387 323 323 387 385 385 429 430 385 430 384 387 429 385 384 383 322 384 428 383 384 430 431 384 431 428 435 431 430 429 435 430 386 429 387 435 428 431 435 432 433 435 438 432 428 435 433 428 433 383 322 383 382 383 433 382 382 433 432 382 380 320 322 382 320 382 432 380 322 320 269 269 320 319 320 379 319 380 381 320 320 381 379 432 381 380 381 432 8 381 8 437 381 437 379 318 319 379 379 392 318 436 379 437 379 436 392 318 269 319 318 392 393 392 436 393 432 438 8 273 254 272 254 273 255 311 255 273 254 274 272 38 29 75 75 29 68 36 37 38 38 75 36 36 75 76 75 90 76 75 68 90 77 90 68 76 90 77 36 76 39 76 77 39 37 36 30 30 36 31 39 31 36 39 40 31 39 41 40 39 77 41 223 74 224))
                   (list :vertices (let ((mat (make-matrix 600 3))) (fvector-replace (array-entity mat) #f(3.0023101806640625e+02 -2.9510501098632812e+02 3.8796100616455078e+01 2.9685299682617188e+02 -2.9019702148437500e+02 1.5182299804687500e+02 2.7438500976562500e+02 -3.1605099487304688e+02 4.1262500762939453e+01 2.3932600402832031e+02 -3.2802999877929688e+02 4.4508098602294922e+01 2.3239700317382812e+02 -3.2586700439453125e+02 1.5397399902343750e+02 2.1941400146484375e+02 -3.2824002075195312e+02 9.5353401184082031e+01 3.1445397949218750e+02 -2.7596798706054688e+02 3.7462398529052734e+01 3.2864001464843750e+02 -2.1992300415039062e+02 3.6972400665283203e+01 3.2252899169921875e+02 -2.2448100280761719e+02 1.5353298950195312e+02 3.2601998901367188e+02 -2.4838000488281250e+02 3.6334800720214844e+01 2.7942999267578125e+02 -3.0592999267578125e+02 1.5210699462890625e+02 2.6038500976562500e+02 -3.1690499877929688e+02 1.5375199890136719e+02 3.1106399536132812e+02 -2.6823300170898438e+02 1.5271499633789062e+02 3.1945999145507812e+02 -2.4776400756835938e+02 1.5087300109863281e+02 2.0341000366210938e+02 -3.2873798370361328e+01 2.3513099670410156e+02 2.1236599731445312e+02 -3.3848201751708984e+01 2.3870800781250000e+02 2.0356999206542969e+02 1.1939000129699707e+01 2.3772299194335938e+02 1.8414199829101562e+02 2.4342599868774414e+01 2.1270300292968750e+02 2.0572399902343750e+02 3.4897899627685547e+01 2.3584899902343750e+02 1.8070698547363281e+02 -3.2239201068878174e+00 2.1111399841308594e+02 1.6318899536132812e+02 2.1084100723266602e+01 1.7987899780273438e+02 1.6983799743652344e+02 4.1547500610351562e+01 1.7990699768066406e+02 1.6247000122070312e+02 -1.6208499908447266e+01 1.8021699523925781e+02 1.9430099487304688e+02 -3.7104099273681641e+01 2.2271400451660156e+02 1.6974798583984375e+02 -4.1105098724365234e+01 1.7973199462890625e+02 1.7928401184082031e+02 -4.4960498809814453e+01 1.8107600402832031e+02 2.0852400207519531e+02 -3.9552600860595703e+01 2.3290798950195312e+02 2.4219799804687500e+02 -3.8239097595214844e+01 2.3796499633789062e+02 2.3323500061035156e+02 -3.3860900878906250e+01 2.4195500183105469e+02 2.9444302368164062e+02 -3.8886497497558594e+01 2.3469599914550781e+02 2.3372599792480469e+02 1.3878700256347656e+01 2.4342300415039062e+02 2.4476000976562500e+02 3.6303901672363281e+01 2.4060000610351562e+02 2.1288299560546875e+02 -4.1764999389648438e+01 2.1188600158691406e+02 2.0504798889160156e+02 -4.2515197753906250e+01 2.0309600830078125e+02 1.9998200988769531e+02 -4.3613399505615234e+01 1.8569999694824219e+02 2.0038299560546875e+02 -4.3849502563476562e+01 1.8206199645996094e+02 2.9490798950195312e+02 3.3810501098632812e+01 2.3929699707031250e+02 2.6420797729492188e+02 -1.1748200416564941e+01 2.4302299499511719e+02 2.9603601074218750e+02 -3.2187000274658203e+01 2.3927299499511719e+02 2.9394702148437500e+02 3.9552101135253906e+01 2.3317800903320312e+02 2.0685699462890625e+02 3.9679100036621094e+01 2.3236499023437500e+02 2.1044000244140625e+02 4.1786102294921875e+01 2.1115100097656250e+02 2.0000299072265625e+02 4.3600997924804688e+01 1.8601599121093750e+02 1.7970800781250000e+02 4.4697696685791016e+01 1.8177000427246094e+02 2.0004100036621094e+02 4.3783798217773438e+01 1.8265600585937500e+02 7.8551902770996094e+01 -1.3927799987792969e+02 1.8049000549316406e+02 2.6282998657226562e+02 -5.5588802337646484e+01 1.7665100097656250e+02 1.7663900756835938e+02 -4.7864299774169922e+01 1.7929199218750000e+02 2.9806100463867188e+02 -1.2864799499511719e+02 1.7509300231933594e+02 2.9769598388671875e+02 -6.7902099609375000e+01 1.7585200500488281e+02 2.2196299743652344e+02 -2.5503799438476562e+02 1.7638400268554688e+02 2.6352502441406250e+02 -1.3535400390625000e+02 1.7648098754882812e+02 5.8946800231933594e+01 1.1198600006103516e+02 1.8082701110839844e+02 -9.6140098571777344e+01 -2.4160598754882812e+01 1.8090200805664062e+02 -2.6149899291992188e+02 -1.9596800231933594e+02 1.7660600280761719e+02 -2.0651200866699219e+02 -1.9753601074218750e+02 1.7780000305175781e+02 6.9552398681640625e+01 -3.0918197631835938e+02 1.7782499694824219e+02 -7.2508605957031250e+01 -3.1709701538085938e+02 1.7715699768066406e+02 -1.9201399230957031e+02 -2.8525399780273438e+02 1.7702400207519531e+02 -2.3391099548339844e+02 -3.1606997680664062e+02 1.7403599548339844e+02 2.0022599792480469e+02 -1.2567600250244141e+01 1.8247898864746094e+02 2.4542300415039062e+02 -1.5419400215148926e+01 2.1282899475097656e+02 2.3913800048828125e+02 6.2237095832824707e-01 2.1283599853515625e+02 2.5926199340820312e+02 -2.3050600051879883e+01 2.1283699035644531e+02 2.9569900512695312e+02 -3.9568901062011719e+01 2.1284599304199219e+02 2.7478601074218750e+02 -1.9590200424194336e+01 2.1283300781250000e+02 2.8245898437500000e+02 -1.1313400268554688e+01 2.1283200073242188e+02 2.8575000000000000e+02 1.5033500194549561e+00 2.1283499145507812e+02 3.0166198730468750e+02 -3.2401000976562500e+01 2.1283200073242188e+02 2.6123602294921875e+02 -4.4348999023437500e+01 1.7713299560546875e+02 2.9357202148437500e+02 -4.1024497985839844e+01 1.7981100463867188e+02 2.3130599975585938e+02 -4.3458702087402344e+01 1.7995500183105469e+02 2.0768600463867188e+02 -4.6056503295898438e+01 1.7898100280761719e+02 2.0216200256347656e+02 -4.4616699218750000e+01 1.8039999389648438e+02 2.0461599731445312e+02 -4.4860603332519531e+01 1.8000199890136719e+02 3.0025500488281250e+02 -3.3223201751708984e+01 2.3401800537109375e+02 3.0006301879882812e+02 3.3962299346923828e+01 2.3393598937988281e+02 2.9554400634765625e+02 3.9623497009277344e+01 2.1284100341796875e+02 2.1501699829101562e+02 4.7756099700927734e+01 1.7840100097656250e+02 2.0672200012207031e+02 4.5097297668457031e+01 1.7961399841308594e+02 2.2939799499511719e+02 4.5011600494384766e+01 1.7861700439453125e+02 1.9177999877929688e+02 4.6298900604248047e+01 1.7943699645996094e+02 2.0243099975585938e+02 4.4678600311279297e+01 1.8032899475097656e+02 2.0074499511718750e+02 4.4034400939941406e+01 1.8151399230957031e+02 2.1320899963378906e+02 4.4390499114990234e+01 1.7999800109863281e+02 2.4777301025390625e+02 4.3880802154541016e+01 1.7922000122070312e+02 1.7758999633789062e+02 4.7441699981689453e+01 1.7928500366210938e+02 2.7845999145507812e+02 1.7165800094604492e+01 2.1283100891113281e+02 2.4873899841308594e+02 1.8789300918579102e+01 2.1283499145507812e+02 2.6383798217773438e+02 2.2990900039672852e+01 2.1283100891113281e+02 3.0166000366210938e+02 3.2466999053955078e+01 2.1283499145507812e+02 2.9717599487304688e+02 6.7286796569824219e+01 1.7581999206542969e+02 2.9814700317382812e+02 1.2812899780273438e+02 1.7512500000000000e+02 2.5847900390625000e+02 5.9713699340820312e+01 1.7720599365234375e+02 2.5811599731445312e+02 1.3580699157714844e+02 1.7669200134277344e+02 2.2257299804687500e+02 2.5874099731445312e+02 1.7601100158691406e+02 3.1376998901367188e+01 3.0716699218750000e+02 1.7849800109863281e+02 1.3860099792480469e+02 2.9823699951171875e+02 1.7703599548339844e+02 -2.0646299743652344e+02 1.9765399169921875e+02 1.7781500244140625e+02 -2.6150000000000000e+02 1.9598298645019531e+02 1.7622399902343750e+02 -1.3077700805664062e+02 3.1197000122070312e+02 1.7724398803710938e+02 -1.9161500549316406e+02 2.7025399780273438e+02 1.7707798767089844e+02 -1.9309300231933594e+02 2.8225799560546875e+02 1.7705099487304688e+02 -1.8581800842285156e+02 3.1222201538085938e+02 1.7624301147460938e+02 -1.7911698913574219e+02 3.2547900390625000e+02 1.6679899597167969e+02 -1.7919999694824219e+02 3.2491400146484375e+02 1.6765100097656250e+02 -1.7917900085449219e+02 3.2491497802734375e+02 1.6765100097656250e+02 -2.1599200439453125e+02 3.2079199218750000e+02 1.7174600219726562e+02 -1.8271099853515625e+02 3.2019601440429688e+02 1.7350498962402344e+02 -1.7984800720214844e+02 3.2392401123046875e+02 1.6887500000000000e+02 -1.7917900085449219e+02 3.2491400146484375e+02 1.6765199279785156e+02 -1.7915800476074219e+02 3.2491497802734375e+02 1.6765199279785156e+02 -2.3092700195312500e+02 3.2662899780273438e+02 1.6051599121093750e+02 2.3786599731445312e+02 3.2063299560546875e+02 1.5918299865722656e+02 3.0916999816894531e+01 3.1327301025390625e+02 1.7738099670410156e+02 4.5053401947021484e+01 3.2668798828125000e+02 1.6403500366210938e+02 1.1757099914550781e+02 3.2356799316406250e+02 1.6558200073242188e+02 -1.1809200286865234e+02 3.1984799194335938e+02 1.7472100830078125e+02 -1.5924600219726562e+02 3.2662399291992188e+02 1.6535400390625000e+02 -3.8491699218750000e+01 3.2398999023437500e+02 1.7080700683593750e+02 2.2307400512695312e+02 3.2685198974609375e+02 1.5413099670410156e+02 -1.7919699096679688e+02 3.2483200073242188e+02 1.6759001159667969e+02 -6.1780399322509766e+01 3.1545999145507812e+02 1.7735000610351562e+02 -1.8468299865722656e+02 3.1623599243164062e+02 1.7552400207519531e+02 -1.8542900085449219e+02 3.1414801025390625e+02 1.7602799987792969e+02 -1.8583799743652344e+02 3.1261700439453125e+02 1.7623298645019531e+02 -1.8571299743652344e+02 3.1323199462890625e+02 1.7620399475097656e+02 -1.8554499816894531e+02 3.1391702270507812e+02 1.7613400268554688e+02 -1.8543901062011719e+02 3.1431002807617188e+02 1.7608100891113281e+02 -1.8568800354003906e+02 3.1324499511718750e+02 1.7617399597167969e+02 -1.8513000488281250e+02 3.1524700927734375e+02 1.7587600708007812e+02 2.5339099121093750e+02 2.8096197509765625e+02 1.6768099975585938e+02 2.8237301635742188e+02 2.1796299743652344e+02 1.6980099487304688e+02 3.0177999877929688e+02 2.7633200073242188e+02 1.5799400329589844e+02 2.0117199707031250e+02 3.0224697875976562e+02 1.6986900329589844e+02 2.7186300659179688e+02 3.0599200439453125e+02 1.5794099426269531e+02 3.1493899536132812e+02 2.4052999877929688e+02 1.5967500305175781e+02 -2.3655400085449219e+02 3.1402798461914062e+02 1.7471299743652344e+02 -1.8853700256347656e+02 3.1477297973632812e+02 1.7596200561523438e+02 -3.0256399536132812e+02 1.7047099304199219e+02 1.7408299255371094e+02 -2.6421600341796875e+02 2.6445599365234375e+02 1.7533700561523438e+02 -3.0819500732421875e+02 1.7200100708007812e+02 1.7402101135253906e+02 -3.0009698486328125e+02 2.5403898620605469e+02 1.7367599487304688e+02 -2.4089500427246094e+02 2.8654299926757812e+02 1.7572900390625000e+02 -2.2261700439453125e+02 3.2789599609375000e+02 1.1502899932861328e+02 -7.8173194885253906e+01 3.2863000488281250e+02 7.3000495910644531e+01 -2.2846400451660156e+02 3.2837500000000000e+02 8.6464599609375000e+01 -2.1326700210571289e+01 3.2871899414062500e+02 6.7909706115722656e+01 1.5932301330566406e+02 3.2900100708007812e+02 5.1731998443603516e+01 2.3917298889160156e+02 3.2810900878906250e+02 4.4524402618408203e+01 9.9946502685546875e+01 3.2890899658203125e+02 5.7049400329589844e+01 2.8766998291015625e+02 5.6536903381347656e+01 1.7271800231933594e+02 3.0680798339843750e+02 3.0199098587036133e+01 1.6822500610351562e+02 3.1838400268554688e+02 4.9684402465820312e+01 1.6428999328613281e+02 3.0510501098632812e+02 6.0503700256347656e+01 1.6866999816894531e+02 3.0182498168945312e+02 1.3732699584960938e+02 1.6860499572753906e+02 2.9748400878906250e+02 4.2789798736572266e+01 1.7061300659179688e+02 3.1875000000000000e+02 2.1195100402832031e+02 1.5965199279785156e+02 2.4675000000000000e+02 3.2253100585937500e+02 1.5247200012207031e+02 2.7029998779296875e+02 3.1249301147460938e+02 1.5154998779296875e+02 2.8920199584960938e+02 2.9747702026367188e+02 1.5252900695800781e+02 3.0161602783203125e+02 2.8380599975585938e+02 1.5234201049804688e+02 3.1447100830078125e+02 2.6122601318359375e+02 1.5284500122070312e+02 3.2175500488281250e+02 2.3548799133300781e+02 1.5270300292968750e+02 -2.5834201049804688e+02 2.6732901000976562e+02 1.7773300170898438e+02 -2.9482202148437500e+02 2.6980401611328125e+02 1.7189399719238281e+02 -3.1003100585937500e+02 2.3203698730468750e+02 1.6980799865722656e+02 -2.6874398803710938e+02 2.9855599975585938e+02 1.7247499084472656e+02 -2.4317799377441406e+02 3.1462100219726562e+02 1.7238500976562500e+02 -3.1538000488281250e+02 1.7843099975585938e+02 1.6900399780273438e+02 -2.9707901000976562e+02 1.7267100524902344e+02 1.7908000183105469e+02 -2.7793197631835938e+02 2.1571000671386719e+02 1.7839500427246094e+02 -2.6491400146484375e+02 2.5324800109863281e+02 1.7956100463867188e+02 -3.1386300659179688e+02 2.7184600830078125e+02 1.4402799987792969e+02 -3.2482299804687500e+02 2.4593701171875000e+02 1.3718701171875000e+02 -2.9955700683593750e+02 2.9183099365234375e+02 1.4918998718261719e+02 -2.7596301269531250e+02 3.1145098876953125e+02 1.5510000610351562e+02 -2.4861900329589844e+02 3.2278799438476562e+02 1.5946499633789062e+02 -3.2710702514648438e+02 2.2128399658203125e+02 1.3685099792480469e+02 -1.8126699829101562e+02 -3.2193698120117188e+02 1.7145500183105469e+02 -2.6111502075195312e+02 1.9584100341796875e+02 3.4833700561523438e+02 -2.6144497680664062e+02 1.5934700012207031e+02 5.1925097656250000e+02 -2.6128900146484375e+02 1.9582499694824219e+02 4.0603399658203125e+02 -2.6150000000000000e+02 1.9600000000000000e+02 5.1925000000000000e+02 -2.6132501220703125e+02 -1.9569200134277344e+02 3.6470498657226562e+02 -2.6150000000000000e+02 -1.5934300231933594e+02 5.1925000000000000e+02 -2.6150000000000000e+02 1.5932499694824219e+02 6.0518402099609375e+02 -2.6148599243164062e+02 -1.9573600769042969e+02 4.5809500122070312e+02 -2.6149697875976562e+02 -1.9593299865722656e+02 5.1924902343750000e+02 -2.6150000000000000e+02 -1.5932899475097656e+02 6.0517504882812500e+02 -2.2931001281738281e+02 -1.9607398986816406e+02 2.0614999389648438e+02 -2.5288900756835938e+02 -1.9620401000976562e+02 2.7667300415039062e+02 -2.2611999511718750e+02 -1.9904499816894531e+02 2.0755099487304688e+02 -2.4024400329589844e+02 -1.9952400207519531e+02 2.4231700134277344e+02 -2.4942100524902344e+02 -1.9983999633789062e+02 2.8594900512695312e+02 -2.2738800048828125e+02 -2.3076899719238281e+02 2.2246800231933594e+02 -2.4097000122070312e+02 -2.1888500976562500e+02 2.5647100830078125e+02 -1.9946299743652344e+02 -2.5894702148437500e+02 1.8476899719238281e+02 -2.1461799621582031e+02 -2.4117300415039062e+02 2.0202099609375000e+02 -2.2911700439453125e+02 -2.3447399902343750e+02 2.1992900085449219e+02 -2.1546900939941406e+02 -2.4787800598144531e+02 1.9810299682617188e+02 -2.0363600158691406e+02 -2.6391000366210938e+02 1.8427099609375000e+02 -2.4216799926757812e+02 -2.2350000000000000e+02 2.5558900451660156e+02 -2.6229501342773438e+02 -2.5929299926757812e+02 1.8034300231933594e+02 -2.6451000976562500e+02 -2.5069902038574219e+02 1.9633000183105469e+02 -2.7507000732421875e+02 -2.3969100952148438e+02 2.1160200500488281e+02 -2.5323701477050781e+02 -2.6886901855468750e+02 1.8138099670410156e+02 -2.6401599121093750e+02 -2.6082800292968750e+02 1.7567999267578125e+02 -2.4242900085449219e+02 -2.8712298583984375e+02 1.7536999511718750e+02 -3.0822598266601562e+02 -1.7281100463867188e+02 1.7408999633789062e+02 -2.8341900634765625e+02 -2.0654701232910156e+02 1.7632899475097656e+02 -3.0140798950195312e+02 -1.7303399658203125e+02 1.7486199951171875e+02 -2.9611300659179688e+02 -2.6439999389648438e+02 1.7290599060058594e+02 -2.6557897949218750e+02 -2.9969299316406250e+02 1.7357901000976562e+02 2.0293000793457031e+02 5.0859296321868896e-01 1.8022698974609375e+02 2.0283000183105469e+02 -2.8047001361846924e+00 1.8025199890136719e+02 2.0466999816894531e+02 0.0000000000000000e+00 1.8000000000000000e+02 2.0125601196289062e+02 -1.0167099952697754e+01 1.8105200195312500e+02 2.0125601196289062e+02 8.7646894454956055e+00 1.8105200195312500e+02 2.0188400268554688e+02 -1.8756401062011719e+01 1.8062800598144531e+02 2.0187098693847656e+02 0.0000000000000000e+00 1.8063700866699219e+02 2.0080900573730469e+02 -2.6118799209594727e+01 1.8143800354003906e+02 2.0283000183105469e+02 -2.8397600173950195e+01 1.8025199890136719e+02 2.3685699462890625e+02 -5.2378802299499512e+00 1.8000000000000000e+02 2.4335600280761719e+02 -1.7477701187133789e+01 1.8000100708007812e+02 2.5403898620605469e+02 -2.4762699127197266e+01 1.7999800109863281e+02 2.6624398803710938e+02 -2.5739299774169922e+01 1.8000100708007812e+02 2.7947100830078125e+02 -2.0265100479125977e+01 1.8000698852539062e+02 2.8759899902343750e+02 -7.4400200843811035e+00 1.7999800109863281e+02 2.8732101440429688e+02 9.4460096359252930e+00 1.7999400329589844e+02 3.0267797851562500e+02 -3.3678901672363281e+01 1.7988999938964844e+02 2.0188400268554688e+02 2.1035301208496094e+01 1.8062800598144531e+02 2.0125601196289062e+02 2.9098798751831055e+01 1.8105200195312500e+02 2.0283000183105469e+02 2.8222299575805664e+01 1.8025199890136719e+02 2.3855000305175781e+02 1.0203200340270996e+01 1.8000100708007812e+02 2.9382101440429688e+02 4.1014999389648438e+01 1.8000000000000000e+02 2.4909300231933594e+02 2.2630701065063477e+01 1.8000199890136719e+02 2.7705197143554688e+02 2.1724800109863281e+01 1.8000199890136719e+02 2.6431500244140625e+02 2.6104598999023438e+01 1.8000000000000000e+02 3.0304000854492188e+02 3.2920200347900391e+01 1.8000500488281250e+02 -2.6883102416992188e+02 2.4736300659179688e+02 1.9901899719238281e+02 -2.5888897705078125e+02 2.6074298095703125e+02 1.8611698913574219e+02 -2.7971600341796875e+02 2.3434700012207031e+02 2.2360501098632812e+02 -2.2705400085449219e+02 2.3114100646972656e+02 2.2156399536132812e+02 -2.3005400085449219e+02 2.3336000061035156e+02 2.2234700012207031e+02 -2.3801300048828125e+02 2.2264300537109375e+02 2.4547299194335938e+02 -2.1811799621582031e+02 2.4438899230957031e+02 2.0163198852539062e+02 -2.1348500061035156e+02 2.4323600769042969e+02 2.0051499938964844e+02 -2.0441299438476562e+02 2.6262600708007812e+02 1.8508799743652344e+02 -2.2692201232910156e+02 1.9850500488281250e+02 2.0857398986816406e+02 -2.4676998901367188e+02 2.1743299865722656e+02 2.8203799438476562e+02 -2.4114300537109375e+02 1.9724301147460938e+02 2.4053500366210938e+02 -2.5104200744628906e+02 2.0007699584960938e+02 2.9490200805664062e+02 -2.2318199157714844e+02 1.9609199523925781e+02 1.9523399353027344e+02 1.3856900024414062e+02 -1.6670899963378906e+02 -5.1000000000000000e+01 1.3856900024414062e+02 -1.6670899963378906e+02 1.4900000000000000e+02 1.3856900024414062e+02 -2.9789999389648438e+02 -5.1000000000000000e+01 1.3856900024414062e+02 -2.9789999389648438e+02 1.4900000000000000e+02 2.8499798583984375e+02 2.8055599975585938e+02 -5.1000000000000000e+01 2.8756600952148438e+02 3.1275299072265625e+02 -5.1000400543212891e+01 3.0837301635742188e+02 2.9295700073242188e+02 -5.1000198364257812e+01 3.2558102416992188e+02 2.6504299926757812e+02 -5.1001399993896484e+01 2.6423498535156250e+02 3.2544601440429688e+02 -5.0999599456787109e+01 2.2517800903320312e+02 2.9789999389648438e+02 -5.1000000000000000e+01 3.3315100097656250e+02 2.3254199218750000e+02 -5.1000198364257812e+01 3.0478298950195312e+02 2.2474099731445312e+02 -5.1000000000000000e+01 2.3840800476074219e+02 3.3261001586914062e+02 -5.1001300811767578e+01 1.3856900024414062e+02 2.9789999389648438e+02 -5.1000000000000000e+01 3.0478298950195312e+02 1.3168499755859375e+02 -5.1000000000000000e+01 3.3337399291992188e+02 -1.1711899566650391e+02 -5.1000000000000000e+01 1.7298799133300781e+02 1.3168499755859375e+02 -5.1000000000000000e+01 8.4165702819824219e+01 3.3337500000000000e+02 -5.1000000000000000e+01 1.3856900024414062e+02 1.6670899963378906e+02 -5.1000000000000000e+01 1.7298799133300781e+02 -1.3168499755859375e+02 -5.1000000000000000e+01 -1.0734500122070312e+02 -3.3337500000000000e+02 -5.1000000000000000e+01 -1.3856900024414062e+02 1.6670899963378906e+02 -5.1000000000000000e+01 3.0478298950195312e+02 -1.3168499755859375e+02 -5.1000000000000000e+01 3.3300201416015625e+02 -2.3394499206542969e+02 -5.1002101898193359e+01 3.0478298950195312e+02 -2.2474099731445312e+02 -5.1000000000000000e+01 3.2534201049804688e+02 -2.6543499755859375e+02 -5.0973499298095703e+01 3.0749499511718750e+02 -2.9423800659179688e+02 -5.1000499725341797e+01 2.8499798583984375e+02 -2.8055599975585938e+02 -5.1000000000000000e+01 2.8329000854492188e+02 -3.1575201416015625e+02 -5.0999702453613281e+01 2.2517800903320312e+02 -2.9789999389648438e+02 -5.1000000000000000e+01 2.5389701843261719e+02 -3.2920599365234375e+02 -5.1000499725341797e+01 2.2955999755859375e+02 -3.3329000854492188e+02 -5.1000000000000000e+01 -1.3856900024414062e+02 2.9789999389648438e+02 -5.1000000000000000e+01 -2.3388299560546875e+02 3.3305499267578125e+02 -5.1000198364257812e+01 -1.7298799133300781e+02 -1.3168499755859375e+02 -5.1000000000000000e+01 -1.7298799133300781e+02 1.3168499755859375e+02 -5.1000000000000000e+01 -2.2517800903320312e+02 2.9789999389648438e+02 -5.1000000000000000e+01 -2.8499798583984375e+02 2.8055599975585938e+02 -5.1000000000000000e+01 -2.6282400512695312e+02 3.2623699951171875e+02 -5.1001197814941406e+01 -2.8578698730468750e+02 3.1374499511718750e+02 -5.1000099182128906e+01 -3.0551498413085938e+02 2.9663400268554688e+02 -5.1000499725341797e+01 -3.0478298950195312e+02 2.2474099731445312e+02 -5.1000000000000000e+01 -3.2179598999023438e+02 2.7240399169921875e+02 -5.1000598907470703e+01 -3.3221200561523438e+02 2.4176600646972656e+02 -5.0998199462890625e+01 -3.0478298950195312e+02 1.3168499755859375e+02 -5.1000000000000000e+01 -3.3337597656250000e+02 -1.0389300346374512e+01 -5.1000000000000000e+01 -1.3856900024414062e+02 -1.6670899963378906e+02 -5.1000000000000000e+01 -1.3856900024414062e+02 -2.9789999389648438e+02 -5.1000000000000000e+01 -3.0478298950195312e+02 -1.3168499755859375e+02 -5.1000000000000000e+01 -3.0478298950195312e+02 -2.2474099731445312e+02 -5.1000000000000000e+01 -3.3225100708007812e+02 -2.4223999023437500e+02 -5.0993698120117188e+01 -2.4388999938964844e+02 -3.3201599121093750e+02 -5.1000301361083984e+01 -2.2517800903320312e+02 -2.9789999389648438e+02 -5.1000000000000000e+01 -2.7797897338867188e+02 -3.1890402221679688e+02 -5.1000698089599609e+01 -2.8499798583984375e+02 -2.8055599975585938e+02 -5.1000000000000000e+01 -3.0359701538085938e+02 -2.9891699218750000e+02 -5.0996398925781250e+01 -3.2203500366210938e+02 -2.7198498535156250e+02 -5.1000301361083984e+01 1.7298799133300781e+02 -1.3168499755859375e+02 1.4900000000000000e+02 2.2517800903320312e+02 -2.9789999389648438e+02 1.4900000000000000e+02 3.0478298950195312e+02 -1.3168499755859375e+02 1.4900000000000000e+02 2.8499798583984375e+02 -2.8055599975585938e+02 1.4900000000000000e+02 3.0478298950195312e+02 -2.2474099731445312e+02 1.4900000000000000e+02 -1.3856900024414062e+02 -1.6670899963378906e+02 1.4900000000000000e+02 -1.7298799133300781e+02 -1.3168499755859375e+02 1.4900000000000000e+02 3.3335501098632812e+02 -2.0438900756835938e+02 4.4105297088623047e+01 3.3337500000000000e+02 -1.6071798706054688e+02 1.0454499816894531e+02 3.3335998535156250e+02 -1.4279100036621094e+02 1.1729299926757812e+02 3.3338201904296875e+02 -2.2422599792480469e+02 3.6235198974609375e+01 3.3337500000000000e+02 -3.9860401153564453e+01 1.1850199890136719e+02 3.3337799072265625e+02 1.4074200439453125e+02 1.1764099884033203e+02 3.3337500000000000e+02 1.5934300231933594e+02 1.0647599792480469e+02 3.3333099365234375e+02 2.0433599853515625e+02 4.4074600219726562e+01 3.3373098754882812e+02 2.2492800903320312e+02 3.6267898559570312e+01 3.3044299316406250e+02 -2.4968099975585938e+02 3.6400703430175781e+01 3.1859100341796875e+02 -2.7849002075195312e+02 3.7449699401855469e+01 2.9427099609375000e+02 -3.0797897338867188e+02 3.9645702362060547e+01 2.5936499023437500e+02 -3.2758398437500000e+02 4.2793197631835938e+01 2.3212699890136719e+02 -3.3319000244140625e+02 4.5215099334716797e+01 -2.3000000000000000e+02 -3.3321899414062500e+02 8.6587898254394531e+01 -1.0266600036621094e+02 -3.3337500000000000e+02 7.5194000244140625e+01 -4.4496798515319824e-01 -3.3337500000000000e+02 6.6039894104003906e+01 1.2655499267578125e+02 -3.3337500000000000e+02 5.4666702270507812e+01 -1.3856900024414062e+02 -2.9789999389648438e+02 1.4900000000000000e+02 -2.2517800903320312e+02 -2.9789999389648438e+02 1.4900000000000000e+02 -2.8499798583984375e+02 -2.8055599975585938e+02 1.4900000000000000e+02 -3.0478298950195312e+02 -2.2474099731445312e+02 1.4900000000000000e+02 -3.0478298950195312e+02 -1.3168499755859375e+02 1.4900000000000000e+02 -2.5181401062011719e+02 -3.2976898193359375e+02 8.8549705505371094e+01 -3.3258502197265625e+02 -2.3938200378417969e+02 9.5798004150390625e+01 -3.2442297363281250e+02 -2.6655001831054688e+02 9.5054199218750000e+01 -3.1073098754882812e+02 -2.9012600708007812e+02 9.3821304321289062e+01 -2.8527200317382812e+02 -3.1483798217773438e+02 9.1549095153808594e+01 -3.3337500000000000e+02 1.6147799682617188e+02 9.5922302246093750e+01 -3.3301800537109375e+02 2.3431100463867188e+02 9.5815002441406250e+01 -3.3334799194335938e+02 1.4255799865722656e+02 1.0345500183105469e+02 -3.3337597656250000e+02 1.0433499908447266e+02 1.3582899475097656e+02 -3.3335800170898438e+02 1.2336399841308594e+02 1.2909199523925781e+02 -3.3337500000000000e+02 -3.6560600280761719e+01 1.3586700439453125e+02 -3.3337500000000000e+02 1.2175199508666992e+01 1.3585501098632812e+02 -3.3337500000000000e+02 -1.0636900329589844e+02 1.3565499877929688e+02 -3.3335501098632812e+02 -1.2448699951171875e+02 1.2786999511718750e+02 -3.3337500000000000e+02 -1.4438999938964844e+02 1.0244400024414062e+02 -3.3337500000000000e+02 -1.6136799621582031e+02 9.5947303771972656e+01 3.0478298950195312e+02 2.2474099731445312e+02 1.4900000000000000e+02 2.8499798583984375e+02 2.8055599975585938e+02 1.4900000000000000e+02 3.0478298950195312e+02 1.3168499755859375e+02 1.4900000000000000e+02 1.7298799133300781e+02 1.3168499755859375e+02 1.4900000000000000e+02 1.3856900024414062e+02 1.6670899963378906e+02 1.4900000000000000e+02 1.3856900024414062e+02 2.9789999389648438e+02 1.4900000000000000e+02 2.2517800903320312e+02 2.9789999389648438e+02 1.4900000000000000e+02 -1.3856900024414062e+02 1.6670899963378906e+02 1.4900000000000000e+02 -1.7298799133300781e+02 1.3168499755859375e+02 1.4900000000000000e+02 2.2822000122070312e+02 3.3336099243164062e+02 4.5563999176025391e+01 2.5065199279785156e+02 3.3002099609375000e+02 4.3569000244140625e+01 2.7867599487304688e+02 3.1863900756835938e+02 4.1054401397705078e+01 3.0261401367187500e+02 2.9948498535156250e+02 3.8896099090576172e+01 3.1850299072265625e+02 2.7859301757812500e+02 3.7477298736572266e+01 3.2872702026367188e+02 2.5509300231933594e+02 3.6569599151611328e+01 -1.3309899902343750e+02 3.3337500000000000e+02 7.7919296264648438e+01 -2.2697000122070312e+02 3.3336199951171875e+02 8.6324600219726562e+01 -1.2736499786376953e+01 3.3337500000000000e+02 6.7140602111816406e+01 5.6024497985839844e+01 3.3337500000000000e+02 6.0982902526855469e+01 1.3019000244140625e+02 3.3337500000000000e+02 5.4341201782226562e+01 -2.2517800903320312e+02 2.9789999389648438e+02 1.4900000000000000e+02 -1.3856900024414062e+02 2.9789999389648438e+02 1.4900000000000000e+02 3.2678402709960938e+02 -1.5887300109863281e+02 1.0685800170898438e+02 3.2628198242187500e+02 -1.3295100402832031e+02 1.1849600219726562e+02 3.2519799804687500e+02 -1.4426899719238281e+02 1.1664400482177734e+02 3.2633599853515625e+02 -6.9561195373535156e+01 1.1852099609375000e+02 3.2644097900390625e+02 -1.6672800064086914e+01 1.1850199890136719e+02 3.2645999145507812e+02 5.3080600738525391e+01 1.1849900054931641e+02 3.2642498779296875e+02 1.2969699096679688e+02 1.1849900054931641e+02 3.2684500122070312e+02 1.5598500061035156e+02 1.1039300537109375e+02 3.2605499267578125e+02 1.3662300109863281e+02 1.1807999420166016e+02 3.2896600341796875e+02 1.9909199523925781e+02 5.0066799163818359e+01 3.2782598876953125e+02 1.7954699707031250e+02 7.7868797302246094e+01 3.2861901855468750e+02 2.2239199829101562e+02 3.6643596649169922e+01 3.2831100463867188e+02 2.0663400268554688e+02 4.3131500244140625e+01 3.2897500610351562e+02 -1.9821299743652344e+02 5.1098701477050781e+01 3.2830599975585938e+02 -2.0621900939941406e+02 4.3482200622558594e+01 -1.4276499938964844e+02 -3.2852899169921875e+02 7.8784896850585938e+01 6.1352397918701172e+01 -3.2884799194335938e+02 6.0505599975585938e+01 -5.5821800231933594e+01 -3.2866497802734375e+02 7.0998901367187500e+01 2.0085800170898438e+02 -3.2906600952148438e+02 4.8012496948242188e+01 -2.4555200195312500e+02 -3.2663400268554688e+02 8.8080101013183594e+01 -3.2123898315429688e+02 -2.6225399780273438e+02 9.5177001953125000e+01 -3.2832501220703125e+02 -2.3432501220703125e+02 9.5809494018554688e+01 -2.8053097534179688e+02 -3.1139001464843750e+02 9.1370704650878906e+01 -3.0475598144531250e+02 -2.8972198486328125e+02 9.3654197692871094e+01 -3.2779800415039062e+02 2.5799798583984375e+02 9.5354103088378906e+01 -2.3978100585937500e+02 3.3222399902343750e+02 8.7463806152343750e+01 -2.9361599731445312e+02 3.0790100097656250e+02 9.2287300109863281e+01 -2.6799200439453125e+02 3.2413900756835938e+02 8.9992004394531250e+01 -3.1370602416992188e+02 2.8636700439453125e+02 9.4082496643066406e+01 -3.2881701660156250e+02 1.5968998718261719e+02 9.5975402832031250e+01 -3.2880999755859375e+02 2.2752999877929688e+02 9.5856002807617188e+01 -3.2866601562500000e+02 1.4169599914550781e+02 1.0481200408935547e+02 -3.2936901855468750e+02 1.2512799835205078e+02 1.2753899383544922e+02 -3.2814599609375000e+02 1.0685399627685547e+02 1.3593701171875000e+02 -3.2820098876953125e+02 -5.1091800689697266e+01 1.3607199096679688e+02 -3.2851699829101562e+02 -4.4033002853393555e+00 1.3585501098632812e+02 -3.2851898193359375e+02 6.1788200378417969e+01 1.3585301208496094e+02 -3.2819500732421875e+02 -1.0958300018310547e+02 1.3566699218750000e+02 -3.2872302246093750e+02 -1.2441699981689453e+02 1.2831500244140625e+02 -3.2875000000000000e+02 -1.4176599121093750e+02 1.0445800018310547e+02 -3.2880398559570312e+02 -1.5834901428222656e+02 9.6359199523925781e+01 -2.8499798583984375e+02 2.8055599975585938e+02 1.4900000000000000e+02 -3.0478298950195312e+02 2.2474099731445312e+02 1.4900000000000000e+02 -3.0478298950195312e+02 1.3168499755859375e+02 1.4900000000000000e+02 2.6558300781250000e+02 3.1989300537109375e+02 4.2066200256347656e+01 2.8560299682617188e+02 3.0813198852539062e+02 4.0175998687744141e+01 3.2064599609375000e+02 2.6342199707031250e+02 3.6899898529052734e+01 3.0614599609375000e+02 2.8867901611328125e+02 3.8240501403808594e+01 3.2740499877929688e+02 2.4039599609375000e+02 3.6170799255371094e+01 3.2452999877929688e+02 2.4608699798583984e+01 1.2006100463867188e+02 3.2452099609375000e+02 1.3579598999023438e+02 1.1996099853515625e+02 3.2448699951171875e+02 8.4366500854492188e+01 1.2014199829101562e+02 3.2447799682617188e+02 5.4313999176025391e+01 1.2005599975585938e+02 3.2445098876953125e+02 -1.1847399902343750e+02 1.2039999389648438e+02 3.2445401000976562e+02 -2.7274499893188477e+01 1.2029100036621094e+02 3.2495700073242188e+02 1.5911399841308594e+02 1.1015299987792969e+02 3.2234500122070312e+02 8.5601303100585938e+01 1.5727600097656250e+02 3.2713400268554688e+02 -1.8976199340820312e+02 6.6868995666503906e+01 3.2522000122070312e+02 -1.6357600402832031e+02 1.0434899902343750e+02 3.2199200439453125e+02 -8.0251098632812500e+01 1.5942601013183594e+02 -2.2170999145507812e+02 -3.2744299316406250e+02 1.4100599670410156e+02 -4.2555500030517578e+01 -3.2706698608398438e+02 1.6232598876953125e+02 -2.3522200012207031e+02 -3.2597000122070312e+02 1.6054501342773438e+02 -1.7615998840332031e+02 -3.2709802246093750e+02 1.6071600341796875e+02 -1.1189600372314453e+02 -3.2708401489257812e+02 1.6184799194335938e+02 5.5040699005126953e+01 -3.2728100585937500e+02 1.5029299926757812e+02 -9.1366195678710938e+00 -3.2699099731445312e+02 1.6330200195312500e+02 5.1523700714111328e+01 -3.2613000488281250e+02 1.6540699768066406e+02 1.3582800292968750e+02 -3.2717098999023438e+02 1.5649400329589844e+02 6.8765701293945312e+01 -3.2713897705078125e+02 1.5844100952148438e+02 7.2230804443359375e+01 -3.2713897705078125e+02 1.5844100952148438e+02 7.0861602783203125e+01 -3.2713601684570312e+02 1.5857099914550781e+02 7.2053703308105469e+01 -3.2713699340820312e+02 1.5852000427246094e+02 -6.9020797729492188e+01 -3.2690298461914062e+02 1.6466699218750000e+02 6.7366798400878906e+01 -3.2713400268554688e+02 1.5871598815917969e+02 -3.1965701293945312e+02 -2.6117599487304688e+02 1.4095700073242188e+02 -3.2693200683593750e+02 -2.3180699157714844e+02 1.3650900268554688e+02 -3.0651901245117188e+02 -2.8348999023437500e+02 1.4657199096679688e+02 -2.6593597412109375e+02 -3.1660101318359375e+02 1.5708700561523438e+02 -2.9085699462890625e+02 -3.0013900756835938e+02 1.5192500305175781e+02 -3.2446701049804688e+02 2.5293200683593750e+02 9.5469398498535156e+01 -3.1331698608398438e+02 2.7737399291992188e+02 9.4438301086425781e+01 -2.9489099121093750e+02 3.0032699584960938e+02 9.2717994689941406e+01 -2.4774200439453125e+02 3.2546298217773438e+02 8.8283004760742188e+01 -2.7051602172851562e+02 3.1705700683593750e+02 9.0411994934082031e+01 -3.2756701660156250e+02 1.2531499481201172e+02 1.3281401062011719e+02 -3.2724099731445312e+02 1.5401600646972656e+02 1.3927799987792969e+02 -3.2593899536132812e+02 -3.3571399688720703e+01 1.4755000305175781e+02 -3.2760000610351562e+02 -2.7569299697875977e+01 1.3800700378417969e+02 -3.2741299438476562e+02 1.8479199218750000e+02 1.3618899536132812e+02 -3.2749398803710938e+02 2.2315100097656250e+02 1.3386300659179688e+02 -3.2746499633789062e+02 1.9822200775146484e+01 1.3811000061035156e+02 3.1641400146484375e+02 -2.2644999694824219e+02 1.6091799926757812e+02 3.1488101196289062e+02 -1.0623200225830078e+02 1.6526100158691406e+02 3.0612200927734375e+02 -2.9491800308227539e+01 1.6855398559570312e+02 3.1378100585937500e+02 -2.5191200256347656e+02 1.5838099670410156e+02 2.8745401000976562e+02 -2.9413299560546875e+02 1.5808900451660156e+02 2.2658599853515625e+02 -3.2358801269531250e+02 1.5932899475097656e+02 -1.7785800170898438e+02 -3.2652700805664062e+02 1.6483599853515625e+02 -2.0237500000000000e+02 -3.2555801391601562e+02 1.6567799377441406e+02 -1.7932798767089844e+02 -3.2473098754882812e+02 1.6793099975585938e+02 -1.5150900268554688e+02 -3.2680599975585938e+02 1.6396099853515625e+02 -1.3496800231933594e+02 -3.2525698852539062e+02 1.6834999084472656e+02 -8.8504800796508789e+00 -3.2523001098632812e+02 1.6805000305175781e+02 -3.2386199951171875e+02 1.5032800292968750e+02 1.5052899169921875e+02 -3.2293701171875000e+02 -1.5748699951171875e+02 1.5246400451660156e+02 2.5544100952148438e+02 -2.6166702270507812e+02 1.7052400207519531e+02 3.0282299804687500e+02 -5.8106300354003906e+01 1.6934700012207031e+02 2.9760198974609375e+02 -4.2628799438476562e+01 1.7069000244140625e+02 3.0507901000976562e+02 -1.3638999938964844e+02 1.6768400573730469e+02 2.1387100219726562e+02 -2.9993798828125000e+02 1.6931599426269531e+02 -2.2204600524902344e+02 -3.2106799316406250e+02 1.7079701232910156e+02 -1.8054600524902344e+02 -3.2292102050781250e+02 1.7031799316406250e+02 -1.8002900695800781e+02 -3.2363998413085938e+02 1.6921099853515625e+02 -3.1016497802734375e+02 -2.3015100097656250e+02 1.6975498962402344e+02 -3.1407601928710938e+02 -1.7473899841308594e+02 1.7088200378417969e+02 3.0492098999023438e+02 1.0516300201416016e+01 1.6976000976562500e+02 3.0332800292968750e+02 -3.3155097961425781e+01 1.7165699768066406e+02 2.9415899658203125e+02 -4.1012100219726562e+01 1.7449000549316406e+02 3.0460101318359375e+02 2.9287200927734375e+01 1.7010099792480469e+02 2.9919201660156250e+02 3.8502799987792969e+01 1.7304199218750000e+02 2.8874798583984375e+02 4.1856300354003906e+01 1.7458699035644531e+02 -3.0493301391601562e+02 -2.2846299743652344e+02 1.7358100891113281e+02 -3.1627600097656250e+02 1.6320199584960938e+02 1.6055799865722656e+02 -3.1827801513671875e+02 1.5213999938964844e+02 1.5573899841308594e+02 -3.0509799194335938e+02 1.6375700378417969e+02 1.6438299560546875e+02 -3.2194900512695312e+02 2.4537399291992188e+01 1.5401600646972656e+02 -3.1455697631835938e+02 1.9115900039672852e+01 1.5718199157714844e+02 -3.1270901489257812e+02 -4.9305801391601562e+01 1.5828799438476562e+02 -3.1630700683593750e+02 -1.5177200317382812e+02 1.5641699218750000e+02 -3.1061300659179688e+02 -1.2055300140380859e+02 1.5739599609375000e+02 -3.1427301025390625e+02 -1.6215899658203125e+02 1.6066299438476562e+02 -3.0157299804687500e+02 -1.6569200134277344e+02 1.7182398986816406e+02 -3.0350802612304688e+02 1.5475498962402344e+02 1.5961801147460938e+02 -3.1233901977539062e+02 -2.0917798995971680e+01 1.6161599731445312e+02 -3.1180599975585938e+02 5.4337898254394531e+01 1.6234600830078125e+02 -3.1248001098632812e+02 1.5646899223327637e+01 1.6002499389648438e+02 -3.1203100585937500e+02 5.8979400634765625e+01 1.5925900268554688e+02 -3.1236801147460938e+02 9.6297599792480469e+01 1.5731700134277344e+02 -3.0872100830078125e+02 1.1442900085449219e+02 1.6050498962402344e+02 -3.0471398925781250e+02 -1.5420399475097656e+02 1.5857798767089844e+02 -3.0895001220703125e+02 -1.1543399810791016e+02 1.6111401367187500e+02 -3.0524298095703125e+02 -1.6322499084472656e+02 1.6386000061035156e+02 -2.9724697875976562e+02 -1.7182699584960938e+02 1.7868899536132812e+02 -3.0170199584960938e+02 1.6335299682617188e+02 1.7239401245117188e+02 -3.1284698486328125e+02 1.6672999572753906e+02 2.5202798461914062e+02 -3.2143301391601562e+02 1.7361000061035156e+02 3.3749099731445312e+02 -3.2953100585937500e+02 8.2005996704101562e+01 4.1253701782226562e+02 -3.1772399902343750e+02 3.2468399047851562e+01 2.2300599670410156e+02 -2.0275999450683594e+02 -2.6726800537109375e+02 1.8476699829101562e+02 -2.2279399108886719e+02 -2.4315299987792969e+02 2.0999099731445312e+02 -2.3953099060058594e+02 -2.2955599975585938e+02 2.4698699951171875e+02 -2.5018000793457031e+02 -2.2291499328613281e+02 2.9407998657226562e+02 -2.4970899963378906e+02 -2.1475399780273438e+02 3.0451000976562500e+02 -2.5513198852539062e+02 -1.9814999389648438e+02 3.4915798950195312e+02 -2.5269299316406250e+02 -2.1032199096679688e+02 3.5886898803710938e+02 -2.5446600341796875e+02 -1.9991099548339844e+02 4.0204302978515625e+02 -2.5721401977539062e+02 -1.9676899719238281e+02 4.1741897583007812e+02 -2.5502999877929688e+02 -1.9741400146484375e+02 5.1954797363281250e+02 -2.5500000000000000e+02 -1.5934300231933594e+02 5.1954797363281250e+02 -2.5823199462890625e+02 -1.9618000793457031e+02 4.6032800292968750e+02 -2.5329101562500000e+02 -2.0433799743652344e+02 5.1956701660156250e+02 -3.1909899902343750e+02 -1.9309599304199219e+02 6.0515795898437500e+02 -3.0545602416992188e+02 -2.0641799926757812e+02 6.0515704345703125e+02 -2.5500000000000000e+02 -2.0825700378417969e+02 6.0518096923828125e+02 -3.3568099975585938e+02 -1.2105299949645996e+01 6.0515997314453125e+02 -3.2935000610351562e+02 1.7470599365234375e+02 6.0516796875000000e+02 -3.3431500244140625e+02 8.5528205871582031e+01 6.0516796875000000e+02 -3.1781701660156250e+02 1.9390699768066406e+02 6.0516998291015625e+02 -3.0496298217773438e+02 2.0630900573730469e+02 6.0517199707031250e+02 -2.5500000000000000e+02 2.0825100708007812e+02 6.0518298339843750e+02 -3.2984301757812500e+02 -1.7271200561523438e+02 6.0517297363281250e+02 -2.5495300292968750e+02 1.9707800292968750e+02 5.1956396484375000e+02 -2.5500000000000000e+02 1.5934300231933594e+02 5.1954797363281250e+02 -2.5548699951171875e+02 1.9827301025390625e+02 3.8352700805664062e+02 -2.5636898803710938e+02 1.9681001281738281e+02 4.7587200927734375e+02 -2.5358599853515625e+02 2.0324101257324219e+02 4.6423599243164062e+02 -2.5371000671386719e+02 2.1019900512695312e+02 3.7048797607421875e+02 -2.0922000122070312e+02 2.5864801025390625e+02 1.9109599304199219e+02 -2.2512899780273438e+02 2.4139100646972656e+02 2.1429400634765625e+02 -2.3936801147460938e+02 2.2954100036621094e+02 2.4531399536132812e+02 -1.9598999023437500e+02 2.7671398925781250e+02 1.8085600280761719e+02 -3.0971200561523438e+02 -1.6624600219726562e+02 2.3053300476074219e+02 -3.0113598632812500e+02 -2.1763099670410156e+02 3.0714602661132812e+02 -3.2332299804687500e+02 -1.7587100219726562e+02 3.6520901489257812e+02 -2.7903802490234375e+02 -2.1911099243164062e+02 1.9331900024414062e+02 -2.9199002075195312e+02 -2.2284899902343750e+02 2.4740499877929688e+02 -2.9717498779296875e+02 -2.0201300048828125e+02 2.4540299987792969e+02 -3.0441201782226562e+02 1.9688600158691406e+02 2.7567398071289062e+02 -2.9479101562500000e+02 2.2127400207519531e+02 2.6209197998046875e+02 -2.8853100585937500e+02 2.2532499694824219e+02 2.3627400207519531e+02 -3.2213000488281250e+02 -9.9647598266601562e+01 2.9715402221679688e+02 -3.3085299682617188e+02 -4.5833900451660156e+01 4.3428799438476562e+02 -3.2891400146484375e+02 1.7582798767089844e+02 4.9897998046875000e+02 -2.9340402221679688e+02 -2.2323399353027344e+02 2.7301800537109375e+02 -2.8330001831054688e+02 -2.2965000915527344e+02 2.3834899902343750e+02 -2.5477900695800781e+02 -2.1310099792480469e+02 3.6739700317382812e+02 -2.5486001586914062e+02 -2.1820799255371094e+02 3.7055001831054688e+02 -2.5323098754882812e+02 -2.0838198852539062e+02 4.1945401000976562e+02 -2.5497698974609375e+02 -2.1187500000000000e+02 5.2882702636718750e+02 -2.5500000000000000e+02 -1.5934599304199219e+02 6.0518597412109375e+02 -2.5490098571777344e+02 -2.0725299072265625e+02 5.1955401611328125e+02 -3.2811199951171875e+02 -1.7760301208496094e+02 4.7830297851562500e+02 -3.2433200073242188e+02 -1.8688800048828125e+02 5.4137701416015625e+02 -3.0391601562500000e+02 -2.1531700134277344e+02 3.7580999755859375e+02 -3.3335598754882812e+02 -8.7930503845214844e+01 5.3862298583984375e+02 -3.2280999755859375e+02 1.8986799621582031e+02 5.1736804199218750e+02 -3.2085800170898438e+02 1.8414099121093750e+02 3.7886599731445312e+02 -3.0456701660156250e+02 2.1263900756835938e+02 4.6054199218750000e+02 -3.0566299438476562e+02 2.0894599914550781e+02 5.3762799072265625e+02 -3.0058898925781250e+02 2.1900700378417969e+02 3.0662500000000000e+02 -3.0277899169921875e+02 2.1115800476074219e+02 5.0672198486328125e+02 -3.0196899414062500e+02 2.0997999572753906e+02 5.3383599853515625e+02 -2.5498802185058594e+02 2.1765499877929688e+02 3.8479800415039062e+02 -2.5557899475097656e+02 2.1074398803710938e+02 5.4078100585937500e+02 -2.5244599914550781e+02 2.2113000488281250e+02 3.1606701660156250e+02 -2.5500000000000000e+02 1.5934400939941406e+02 6.0518597412109375e+02 -2.5428599548339844e+02 2.0588600158691406e+02 5.1952203369140625e+02 -2.5233099365234375e+02 2.1589801025390625e+02 3.2177600097656250e+02 -2.8729598999023438e+02 2.2629299926757812e+02 2.5503199768066406e+02 -2.5481001281738281e+02 -2.0962600708007812e+02 4.6008398437500000e+02 )) mat)))
                  )
                 ))
      (send glv :transform local-cds)
      (send glv :calc-normals)
      (setq qhull
            ;; qhull 3600 -> 81 faces
            (instance faceset :init :faces (list
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.5499999523162842e+02 -2.0825700461864471e+02 6.0518097877502441e+02) (float-vector 2.9603600502014160e+02 -3.2186999917030334e+01 2.3927299678325653e+02) (float-vector 3.1378099322319031e+02 -2.5191199779510498e+02 1.5838100016117096e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.5499999523162842e+02 2.0825099945068359e+02 6.0518300533294678e+02) (float-vector 2.2307400405406952e+02 3.2685199379920959e+02 1.5413099527359009e+02) (float-vector 2.4674999713897705e+02 3.2253101468086243e+02 1.5247200429439545e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.2307400405406952e+02 3.2685199379920959e+02 1.5413099527359009e+02) (float-vector -2.5499999523162842e+02 2.0825099945068359e+02 6.0518300533294678e+02) (float-vector 4.5053400099277496e+01 3.2668799161911011e+02 1.6403500735759735e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.9490798711776733e+02 3.3810500055551529e+01 2.3929700255393982e+02) (float-vector 2.9603600502014160e+02 -3.2186999917030334e+01 2.3927299678325653e+02) (float-vector -2.5499999523162842e+02 -2.0825700461864471e+02 6.0518097877502441e+02) (float-vector -2.5499999523162842e+02 2.0825099945068359e+02 6.0518300533294678e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.6038500666618347e+02 -3.1690499186515808e+02 1.5375199913978577e+02) (float-vector 2.3239700496196747e+02 -3.2586699724197388e+02 1.5397399663925171e+02) (float-vector -2.5499999523162842e+02 -2.0825700461864471e+02 6.0518097877502441e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.3239700496196747e+02 -3.2586699724197388e+02 1.5397399663925171e+02) (float-vector 5.1523700356483459e+01 -3.2613000273704529e+02 1.6540700197219849e+02) (float-vector -2.5499999523162842e+02 -2.0825700461864471e+02 6.0518097877502441e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.3522199690341949e+02 -3.2596999406814575e+02 1.6054500639438629e+02) (float-vector 5.1523700356483459e+01 -3.2613000273704529e+02 1.6540700197219849e+02) (float-vector 2.3239700496196747e+02 -3.2586699724197388e+02 1.5397399663925171e+02) (float-vector 2.3212699592113495e+02 -3.3318999409675598e+02 4.5215100049972534e+01) (float-vector -2.3000000417232513e+02 -3.3321899175643921e+02 8.6587898433208466e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.0545601248741150e+02 -2.0641799271106720e+02 6.0515701770782471e+02) (float-vector -2.5499999523162842e+02 -2.0825700461864471e+02 6.0518097877502441e+02) (float-vector 5.1523700356483459e+01 -3.2613000273704529e+02 1.6540700197219849e+02) (float-vector -2.3522199690341949e+02 -3.2596999406814575e+02 1.6054500639438629e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.4861900508403778e+02 3.2278800010681152e+02 1.5946500003337860e+02) (float-vector -2.3092700541019440e+02 3.2662901282310486e+02 1.6051599383354187e+02) (float-vector -3.0496299266815186e+02 2.0630900561809540e+02 6.0517197847366333e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.5499999523162842e+02 2.0825099945068359e+02 6.0518300533294678e+02) (float-vector -3.0496299266815186e+02 2.0630900561809540e+02 6.0517197847366333e+02) (float-vector -2.3092700541019440e+02 3.2662901282310486e+02 1.6051599383354187e+02) (float-vector 4.5053400099277496e+01 3.2668799161911011e+02 1.6403500735759735e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1859099864959717e+02 -2.7849000692367554e+02 3.7449698895215988e+01) (float-vector 3.0749499797821045e+02 -2.9423800110816956e+02 -5.1000498235225677e+01) (float-vector 2.9427099227905273e+02 -3.0797898769378662e+02 3.9645701646804810e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.3338201045989990e+02 -2.2422599792480469e+02 3.6235198378562927e+01) (float-vector 3.3335998654365540e+02 -1.4279100298881531e+02 1.1729300022125244e+02) (float-vector 3.3337798714637756e+02 1.4074200391769409e+02 1.1764100193977356e+02) (float-vector 3.3373099565505981e+02 2.2492800652980804e+02 3.6267898976802826e+01) (float-vector 3.3315101265907288e+02 2.3254199326038361e+02 -5.1000200212001801e+01) (float-vector 3.3300200104713440e+02 -2.3394499719142914e+02 -5.1002100110054016e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.0749499797821045e+02 -2.9423800110816956e+02 -5.1000498235225677e+01) (float-vector 2.8328999876976013e+02 -3.1575199961662292e+02 -5.0999701023101807e+01) (float-vector 2.9427099227905273e+02 -3.0797898769378662e+02 3.9645701646804810e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.2442298531532288e+02 -2.6655000448226929e+02 9.5054201781749725e+01) (float-vector -3.3258500695228577e+02 -2.3938199877738953e+02 9.5798000693321228e+01) (float-vector -3.2984301447868347e+02 -1.7271199822425842e+02 6.0517299175262451e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.2984301447868347e+02 -1.7271199822425842e+02 6.0517299175262451e+02) (float-vector -3.3258500695228577e+02 -2.3938199877738953e+02 9.5798000693321228e+01) (float-vector -3.3568099141120911e+02 -1.2105300091207027e+01 6.0515999794006348e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.3568099141120911e+02 -1.2105300091207027e+01 6.0515999794006348e+02) (float-vector -3.3258500695228577e+02 -2.3938199877738953e+02 9.5798000693321228e+01) (float-vector -3.3225101232528687e+02 -2.4223999679088593e+02 -5.0993699580430984e+01) (float-vector -3.3221200108528137e+02 2.4176600575447083e+02 -5.0998199731111526e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.0496299266815186e+02 2.0630900561809540e+02 6.0517197847366333e+02) (float-vector -2.5499999523162842e+02 2.0825099945068359e+02 6.0518300533294678e+02) (float-vector -2.5499999523162842e+02 -2.0825700461864471e+02 6.0518097877502441e+02) (float-vector -3.0545601248741150e+02 -2.0641799271106720e+02 6.0515701770782471e+02) (float-vector -3.1909900903701782e+02 -1.9309599697589874e+02 6.0515797138214111e+02) (float-vector -3.2984301447868347e+02 -1.7271199822425842e+02 6.0517299175262451e+02) (float-vector -3.3568099141120911e+02 -1.2105300091207027e+01 6.0515999794006348e+02) (float-vector -3.2934999465942383e+02 1.7470599710941315e+02 6.0516798496246338e+02) (float-vector -3.1781700253486633e+02 1.9390699267387390e+02 6.0517001152038574e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.2984301447868347e+02 -1.7271199822425842e+02 6.0517299175262451e+02) (float-vector -3.1909900903701782e+02 -1.9309599697589874e+02 6.0515797138214111e+02) (float-vector -3.1073099374771118e+02 -2.9012599587440491e+02 9.3821302056312561e+01) (float-vector -3.2442298531532288e+02 -2.6655000448226929e+02 9.5054201781749725e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.3258500695228577e+02 -2.3938199877738953e+02 9.5798000693321228e+01) (float-vector -3.2442298531532288e+02 -2.6655000448226929e+02 9.5054201781749725e+01) (float-vector -3.2203501462936401e+02 -2.7198499441146851e+02 -5.1000300794839859e+01) (float-vector -3.3225101232528687e+02 -2.4223999679088593e+02 -5.0993699580430984e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.2203501462936401e+02 -2.7198499441146851e+02 -5.1000300794839859e+01) (float-vector -3.2442298531532288e+02 -2.6655000448226929e+02 9.5054201781749725e+01) (float-vector -3.1073099374771118e+02 -2.9012599587440491e+02 9.3821302056312561e+01) (float-vector -3.0359700322151184e+02 -2.9891699552536011e+02 -5.0996400415897369e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.2697000205516815e+02 3.3336201310157776e+02 8.6324602365493774e+01) (float-vector -2.3092700541019440e+02 3.2662901282310486e+02 1.6051599383354187e+02) (float-vector -2.4861900508403778e+02 3.2278800010681152e+02 1.5946500003337860e+02) (float-vector -2.6799198985099792e+02 3.2413899898529053e+02 8.9992001652717590e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.2822000086307526e+02 3.3336099982261658e+02 4.5563999563455582e+01) (float-vector -2.2697000205516815e+02 3.3336201310157776e+02 8.6324602365493774e+01) (float-vector -2.3388299345970154e+02 3.3305498957633972e+02 -5.1000200212001801e+01) (float-vector 2.3840799927711487e+02 3.3261001110076904e+02 -5.1001299172639847e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.5053400099277496e+01 3.2668799161911011e+02 1.6403500735759735e+02) (float-vector -2.3092700541019440e+02 3.2662901282310486e+02 1.6051599383354187e+02) (float-vector -2.2697000205516815e+02 3.3336201310157776e+02 8.6324602365493774e+01) (float-vector 2.2822000086307526e+02 3.3336099982261658e+02 4.5563999563455582e+01) (float-vector 2.2307400405406952e+02 3.2685199379920959e+02 1.5413099527359009e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.2175499200820923e+02 2.3548799753189087e+02 1.5270300209522247e+02) (float-vector 3.2872700691223145e+02 2.5509300827980042e+02 3.6569599062204361e+01) (float-vector 3.3373099565505981e+02 2.2492800652980804e+02 3.6267898976802826e+01) (float-vector 3.3337798714637756e+02 1.4074200391769409e+02 1.1764100193977356e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.6799198985099792e+02 3.2413899898529053e+02 8.9992001652717590e+01) (float-vector -2.6282399892807007e+02 3.2623699307441711e+02 -5.1001198589801788e+01) (float-vector -2.3388299345970154e+02 3.3305498957633972e+02 -5.1000200212001801e+01) (float-vector -2.2697000205516815e+02 3.3336201310157776e+02 8.6324602365493774e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.8578698635101318e+02 3.1374499201774597e+02 -5.1000099629163742e+01) (float-vector -2.6282399892807007e+02 3.2623699307441711e+02 -5.1001198589801788e+01) (float-vector -2.6799198985099792e+02 3.2413899898529053e+02 8.9992001652717590e+01) (float-vector -2.9361599683761597e+02 3.0790099501609802e+02 9.2287302017211914e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.2934999465942383e+02 1.7470599710941315e+02 6.0516798496246338e+02) (float-vector -3.2779800891876221e+02 2.5799798965454102e+02 9.5354102551937103e+01) (float-vector -3.1370601058006287e+02 2.8636699914932251e+02 9.4082497060298920e+01) (float-vector -3.1781700253486633e+02 1.9390699267387390e+02 6.0517001152038574e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.3221200108528137e+02 2.4176600575447083e+02 -5.0998199731111526e+01) (float-vector -3.2779800891876221e+02 2.5799798965454102e+02 9.5354102551937103e+01) (float-vector -3.2934999465942383e+02 1.7470599710941315e+02 6.0516798496246338e+02) (float-vector -3.3568099141120911e+02 -1.2105300091207027e+01 6.0515999794006348e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.2779800891876221e+02 2.5799798965454102e+02 9.5354102551937103e+01) (float-vector -3.2179600000381470e+02 2.7240398526191711e+02 -5.1000598818063736e+01) (float-vector -3.1370601058006287e+02 2.8636699914932251e+02 9.4082497060298920e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.2179600000381470e+02 2.7240398526191711e+02 -5.1000598818063736e+01) (float-vector -3.2779800891876221e+02 2.5799798965454102e+02 9.5354102551937103e+01) (float-vector -3.3221200108528137e+02 2.4176600575447083e+02 -5.0998199731111526e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.3373099565505981e+02 2.2492800652980804e+02 3.6267898976802826e+01) (float-vector 3.2872700691223145e+02 2.5509300827980042e+02 3.6569599062204361e+01) (float-vector 3.2558101415634155e+02 2.6504299044609070e+02 -5.1001399755477905e+01) (float-vector 3.3315101265907288e+02 2.3254199326038361e+02 -5.1000200212001801e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.7867600321769714e+02 3.1863901019096375e+02 4.1054401546716690e+01) (float-vector 2.8756600618362427e+02 3.1275299191474915e+02 -5.1000401377677917e+01) (float-vector 3.0837300419807434e+02 2.9295700788497925e+02 -5.1000200212001801e+01) (float-vector 3.0261400341987610e+02 2.9948499798774719e+02 3.8896098732948303e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1859099864959717e+02 -2.7849000692367554e+02 3.7449698895215988e+01) (float-vector 3.2534199953079224e+02 -2.6543501019477844e+02 -5.0973501056432724e+01) (float-vector 3.0749499797821045e+02 -2.9423800110816956e+02 -5.1000498235225677e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1946000456809998e+02 -2.4776400625705719e+02 1.5087300539016724e+02) (float-vector 3.1106400489807129e+02 -2.6823300123214722e+02 1.5271499752998352e+02) (float-vector 3.1378099322319031e+02 -2.5191199779510498e+02 1.5838100016117096e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.5936499238014221e+02 -3.2758399844169617e+02 4.2793199419975281e+01) (float-vector 2.6038500666618347e+02 -3.1690499186515808e+02 1.5375199913978577e+02) (float-vector 2.7943000197410583e+02 -3.0592998862266541e+02 1.5210700035095215e+02) (float-vector 2.9427099227905273e+02 -3.0797898769378662e+02 3.9645701646804810e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.3212699592113495e+02 -3.3318999409675598e+02 4.5215100049972534e+01) (float-vector 2.5936499238014221e+02 -3.2758399844169617e+02 4.2793199419975281e+01) (float-vector 2.5389701128005981e+02 -3.2920598983764648e+02 -5.1000498235225677e+01) (float-vector 2.2956000268459320e+02 -3.3329001069068909e+02 -5.0999999046325684e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.8328999876976013e+02 -3.1575199961662292e+02 -5.0999701023101807e+01) (float-vector 2.5389701128005981e+02 -3.2920598983764648e+02 -5.1000498235225677e+01) (float-vector 2.5936499238014221e+02 -3.2758399844169617e+02 4.2793199419975281e+01) (float-vector 2.9427099227905273e+02 -3.0797898769378662e+02 3.9645701646804810e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.3212699592113495e+02 -3.3318999409675598e+02 4.5215100049972534e+01) (float-vector 2.3239700496196747e+02 -3.2586699724197388e+02 1.5397399663925171e+02) (float-vector 2.6038500666618347e+02 -3.1690499186515808e+02 1.5375199913978577e+02) (float-vector 2.5936499238014221e+02 -3.2758399844169617e+02 4.2793199419975281e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.6593598723411560e+02 -3.1660100817680359e+02 1.5708699822425842e+02) (float-vector -3.0545601248741150e+02 -2.0641799271106720e+02 6.0515701770782471e+02) (float-vector -2.3522199690341949e+02 -3.2596999406814575e+02 1.6054500639438629e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.5065198540687561e+02 3.3002099394798279e+02 4.3568998575210571e+01) (float-vector 2.4674999713897705e+02 3.2253101468086243e+02 1.5247200429439545e+02) (float-vector 2.2307400405406952e+02 3.2685199379920959e+02 1.5413099527359009e+02) (float-vector 2.2822000086307526e+02 3.3336099982261658e+02 4.5563999563455582e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.7867600321769714e+02 3.1863901019096375e+02 4.1054401546716690e+01) (float-vector 2.5065198540687561e+02 3.3002099394798279e+02 4.3568998575210571e+01) (float-vector 2.6423498988151550e+02 3.2544600963592529e+02 -5.0999600440263748e+01) (float-vector 2.8756600618362427e+02 3.1275299191474915e+02 -5.1000401377677917e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.5065198540687561e+02 3.3002099394798279e+02 4.3568998575210571e+01) (float-vector 2.2822000086307526e+02 3.3336099982261658e+02 4.5563999563455582e+01) (float-vector 2.3840799927711487e+02 3.3261001110076904e+02 -5.1001299172639847e+01) (float-vector 2.6423498988151550e+02 3.2544600963592529e+02 -5.0999600440263748e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.7867600321769714e+02 3.1863901019096375e+02 4.1054401546716690e+01) (float-vector 2.7030000090599060e+02 3.1249299645423889e+02 1.5154999494552612e+02) (float-vector 2.4674999713897705e+02 3.2253101468086243e+02 1.5247200429439545e+02) (float-vector 2.5065198540687561e+02 3.3002099394798279e+02 4.3568998575210571e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.5499999523162842e+02 2.0825099945068359e+02 6.0518300533294678e+02) (float-vector 2.4674999713897705e+02 3.2253101468086243e+02 1.5247200429439545e+02) (float-vector 2.7030000090599060e+02 3.1249299645423889e+02 1.5154999494552612e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.2175499200820923e+02 2.3548799753189087e+02 1.5270300209522247e+02) (float-vector 3.1447100639343262e+02 2.6122599840164185e+02 1.5284499526023865e+02) (float-vector 3.2872700691223145e+02 2.5509300827980042e+02 3.6569599062204361e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.9603600502014160e+02 -3.2186999917030334e+01 2.3927299678325653e+02) (float-vector 3.0025500059127808e+02 -3.3223200589418411e+01 2.3401799798011780e+02) (float-vector 3.2252898812294006e+02 -2.2448100149631500e+02 1.5353299677371979e+02) (float-vector 3.1946000456809998e+02 -2.4776400625705719e+02 1.5087300539016724e+02) (float-vector 3.1378099322319031e+02 -2.5191199779510498e+02 1.5838100016117096e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.7596300840377808e+02 3.1145098805427551e+02 1.5510000288486481e+02) (float-vector -2.6799198985099792e+02 3.2413899898529053e+02 8.9992001652717590e+01) (float-vector -2.4861900508403778e+02 3.2278800010681152e+02 1.5946500003337860e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.7596300840377808e+02 3.1145098805427551e+02 1.5510000288486481e+02) (float-vector -2.4861900508403778e+02 3.2278800010681152e+02 1.5946500003337860e+02) (float-vector -3.0496299266815186e+02 2.0630900561809540e+02 6.0517197847366333e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.7596300840377808e+02 3.1145098805427551e+02 1.5510000288486481e+02) (float-vector -2.9361599683761597e+02 3.0790099501609802e+02 9.2287302017211914e+01) (float-vector -2.6799198985099792e+02 3.2413899898529053e+02 8.9992001652717590e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.1370601058006287e+02 2.8636699914932251e+02 9.4082497060298920e+01) (float-vector -2.9361599683761597e+02 3.0790099501609802e+02 9.2287302017211914e+01) (float-vector -2.7596300840377808e+02 3.1145098805427551e+02 1.5510000288486481e+02) (float-vector -3.0496299266815186e+02 2.0630900561809540e+02 6.0517197847366333e+02) (float-vector -3.1781700253486633e+02 1.9390699267387390e+02 6.0517001152038574e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.2179600000381470e+02 2.7240398526191711e+02 -5.1000598818063736e+01) (float-vector -3.0551499128341675e+02 2.9663398861885071e+02 -5.1000498235225677e+01) (float-vector -3.1370601058006287e+02 2.8636699914932251e+02 9.4082497060298920e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.0551499128341675e+02 2.9663398861885071e+02 -5.1000498235225677e+01) (float-vector -2.8578698635101318e+02 3.1374499201774597e+02 -5.1000099629163742e+01) (float-vector -2.9361599683761597e+02 3.0790099501609802e+02 9.2287302017211914e+01) (float-vector -3.1370601058006287e+02 2.8636699914932251e+02 9.4082497060298920e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1850299239158630e+02 2.7859300374984741e+02 3.7477299571037292e+01) (float-vector 3.2558101415634155e+02 2.6504299044609070e+02 -5.1001399755477905e+01) (float-vector 3.2872700691223145e+02 2.5509300827980042e+02 3.6569599062204361e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1850299239158630e+02 2.7859300374984741e+02 3.7477299571037292e+01) (float-vector 3.0261400341987610e+02 2.9948499798774719e+02 3.8896098732948303e+01) (float-vector 3.0837300419807434e+02 2.9295700788497925e+02 -5.1000200212001801e+01) (float-vector 3.2558101415634155e+02 2.6504299044609070e+02 -5.1001399755477905e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.3044299483299255e+02 -2.4968099594116211e+02 3.6400701850652695e+01) (float-vector 3.3338201045989990e+02 -2.2422599792480469e+02 3.6235198378562927e+01) (float-vector 3.3300200104713440e+02 -2.3394499719142914e+02 -5.1002100110054016e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.2534199953079224e+02 -2.6543501019477844e+02 -5.0973501056432724e+01) (float-vector 3.3044299483299255e+02 -2.4968099594116211e+02 3.6400701850652695e+01) (float-vector 3.3300200104713440e+02 -2.3394499719142914e+02 -5.1002100110054016e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.3044299483299255e+02 -2.4968099594116211e+02 3.6400701850652695e+01) (float-vector 3.2534199953079224e+02 -2.6543501019477844e+02 -5.0973501056432724e+01) (float-vector 3.1859099864959717e+02 -2.7849000692367554e+02 3.7449698895215988e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.3044299483299255e+02 -2.4968099594116211e+02 3.6400701850652695e+01) (float-vector 3.1946000456809998e+02 -2.4776400625705719e+02 1.5087300539016724e+02) (float-vector 3.2252898812294006e+02 -2.2448100149631500e+02 1.5353299677371979e+02) (float-vector 3.3335998654365540e+02 -1.4279100298881531e+02 1.1729300022125244e+02) (float-vector 3.3338201045989990e+02 -2.2422599792480469e+02 3.6235198378562927e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1946000456809998e+02 -2.4776400625705719e+02 1.5087300539016724e+02) (float-vector 3.3044299483299255e+02 -2.4968099594116211e+02 3.6400701850652695e+01) (float-vector 3.1859099864959717e+02 -2.7849000692367554e+02 3.7449698895215988e+01) (float-vector 3.1106400489807129e+02 -2.6823300123214722e+02 1.5271499752998352e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.7943000197410583e+02 -3.0592998862266541e+02 1.5210700035095215e+02) (float-vector 2.9685300588607788e+02 -2.9019701480865479e+02 1.5182299911975861e+02) (float-vector 2.9427099227905273e+02 -3.0797898769378662e+02 3.9645701646804810e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1378099322319031e+02 -2.5191199779510498e+02 1.5838100016117096e+02) (float-vector 3.1106400489807129e+02 -2.6823300123214722e+02 1.5271499752998352e+02) (float-vector 2.9685300588607788e+02 -2.9019701480865479e+02 1.5182299911975861e+02) (float-vector -2.5499999523162842e+02 -2.0825700461864471e+02 6.0518097877502441e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1859099864959717e+02 -2.7849000692367554e+02 3.7449698895215988e+01) (float-vector 2.9427099227905273e+02 -3.0797898769378662e+02 3.9645701646804810e+01) (float-vector 2.9685300588607788e+02 -2.9019701480865479e+02 1.5182299911975861e+02) (float-vector 3.1106400489807129e+02 -2.6823300123214722e+02 1.5271499752998352e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.5499999523162842e+02 -2.0825700461864471e+02 6.0518097877502441e+02) (float-vector 2.9685300588607788e+02 -2.9019701480865479e+02 1.5182299911975861e+02) (float-vector 2.7943000197410583e+02 -3.0592998862266541e+02 1.5210700035095215e+02) (float-vector 2.6038500666618347e+02 -3.1690499186515808e+02 1.5375199913978577e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.5181400775909424e+02 -3.2976898550987244e+02 8.8549703359603882e+01) (float-vector -2.6593598723411560e+02 -3.1660100817680359e+02 1.5708699822425842e+02) (float-vector -2.3522199690341949e+02 -3.2596999406814575e+02 1.6054500639438629e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.3000000417232513e+02 -3.3321899175643921e+02 8.6587898433208466e+01) (float-vector -2.5181400775909424e+02 -3.2976898550987244e+02 8.8549703359603882e+01) (float-vector -2.3522199690341949e+02 -3.2596999406814575e+02 1.6054500639438629e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.5181400775909424e+02 -3.2976898550987244e+02 8.8549703359603882e+01) (float-vector -2.3000000417232513e+02 -3.3321899175643921e+02 8.6587898433208466e+01) (float-vector 2.3212699592113495e+02 -3.3318999409675598e+02 4.5215100049972534e+01) (float-vector 2.2956000268459320e+02 -3.3329001069068909e+02 -5.0999999046325684e+01) (float-vector -2.4389000236988068e+02 -3.3201599121093750e+02 -5.1000300794839859e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.2175499200820923e+02 2.3548799753189087e+02 1.5270300209522247e+02) (float-vector 3.0006301403045654e+02 3.3962298184633255e+01 2.3393599689006805e+02) (float-vector 2.9490798711776733e+02 3.3810500055551529e+01 2.3929700255393982e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.2252898812294006e+02 -2.2448100149631500e+02 1.5353299677371979e+02) (float-vector 3.0025500059127808e+02 -3.3223200589418411e+01 2.3401799798011780e+02) (float-vector 3.0006301403045654e+02 3.3962298184633255e+01 2.3393599689006805e+02) (float-vector 3.2175499200820923e+02 2.3548799753189087e+02 1.5270300209522247e+02) (float-vector 3.3337798714637756e+02 1.4074200391769409e+02 1.1764100193977356e+02) (float-vector 3.3335998654365540e+02 -1.4279100298881531e+02 1.1729300022125244e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.0006301403045654e+02 3.3962298184633255e+01 2.3393599689006805e+02) (float-vector 3.0025500059127808e+02 -3.3223200589418411e+01 2.3401799798011780e+02) (float-vector 2.9603600502014160e+02 -3.2186999917030334e+01 2.3927299678325653e+02) (float-vector 2.9490798711776733e+02 3.3810500055551529e+01 2.3929700255393982e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1850299239158630e+02 2.7859300374984741e+02 3.7477299571037292e+01) (float-vector 3.0161601305007935e+02 2.8380599617958069e+02 1.5234200656414032e+02) (float-vector 3.0261400341987610e+02 2.9948499798774719e+02 3.8896098732948303e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.7030000090599060e+02 3.1249299645423889e+02 1.5154999494552612e+02) (float-vector 3.0161601305007935e+02 2.8380599617958069e+02 1.5234200656414032e+02) (float-vector -2.5499999523162842e+02 2.0825099945068359e+02 6.0518300533294678e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.7867600321769714e+02 3.1863901019096375e+02 4.1054401546716690e+01) (float-vector 3.0261400341987610e+02 2.9948499798774719e+02 3.8896098732948303e+01) (float-vector 3.0161601305007935e+02 2.8380599617958069e+02 1.5234200656414032e+02) (float-vector 2.7030000090599060e+02 3.1249299645423889e+02 1.5154999494552612e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1447100639343262e+02 2.6122599840164185e+02 1.5284499526023865e+02) (float-vector 3.0161601305007935e+02 2.8380599617958069e+02 1.5234200656414032e+02) (float-vector 3.1850299239158630e+02 2.7859300374984741e+02 3.7477299571037292e+01) (float-vector 3.2872700691223145e+02 2.5509300827980042e+02 3.6569599062204361e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.0161601305007935e+02 2.8380599617958069e+02 1.5234200656414032e+02) (float-vector 3.1447100639343262e+02 2.6122599840164185e+02 1.5284499526023865e+02) (float-vector 3.2175499200820923e+02 2.3548799753189087e+02 1.5270300209522247e+02) (float-vector 2.9490798711776733e+02 3.3810500055551529e+01 2.3929700255393982e+02) (float-vector -2.5499999523162842e+02 2.0825099945068359e+02 6.0518300533294678e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.8578698635101318e+02 3.1374499201774597e+02 -5.1000099629163742e+01) (float-vector -3.0551499128341675e+02 2.9663398861885071e+02 -5.1000498235225677e+01) (float-vector -3.2179600000381470e+02 2.7240398526191711e+02 -5.1000598818063736e+01) (float-vector -3.3221200108528137e+02 2.4176600575447083e+02 -5.0998199731111526e+01) (float-vector -3.3225101232528687e+02 -2.4223999679088593e+02 -5.0993699580430984e+01) (float-vector -3.2203501462936401e+02 -2.7198499441146851e+02 -5.1000300794839859e+01) (float-vector -3.0359700322151184e+02 -2.9891699552536011e+02 -5.0996400415897369e+01) (float-vector -2.7797898650169373e+02 -3.1890401244163513e+02 -5.1000699400901794e+01) (float-vector -2.4389000236988068e+02 -3.3201599121093750e+02 -5.1000300794839859e+01) (float-vector 2.2956000268459320e+02 -3.3329001069068909e+02 -5.0999999046325684e+01) (float-vector 2.5389701128005981e+02 -3.2920598983764648e+02 -5.1000498235225677e+01) (float-vector 2.8328999876976013e+02 -3.1575199961662292e+02 -5.0999701023101807e+01) (float-vector 3.0749499797821045e+02 -2.9423800110816956e+02 -5.1000498235225677e+01) (float-vector 3.2534199953079224e+02 -2.6543501019477844e+02 -5.0973501056432724e+01) (float-vector 3.3300200104713440e+02 -2.3394499719142914e+02 -5.1002100110054016e+01) (float-vector 3.3315101265907288e+02 2.3254199326038361e+02 -5.1000200212001801e+01) (float-vector 3.2558101415634155e+02 2.6504299044609070e+02 -5.1001399755477905e+01) (float-vector 3.0837300419807434e+02 2.9295700788497925e+02 -5.1000200212001801e+01) (float-vector 2.8756600618362427e+02 3.1275299191474915e+02 -5.1000401377677917e+01) (float-vector 2.6423498988151550e+02 3.2544600963592529e+02 -5.0999600440263748e+01) (float-vector 2.3840799927711487e+02 3.3261001110076904e+02 -5.1001299172639847e+01) (float-vector -2.3388299345970154e+02 3.3305498957633972e+02 -5.1000200212001801e+01) (float-vector -2.6282399892807007e+02 3.2623699307441711e+02 -5.1001198589801788e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.5181400775909424e+02 -3.2976898550987244e+02 8.8549703359603882e+01) (float-vector -2.8527200222015381e+02 -3.1483799219131470e+02 9.1549098491668701e+01) (float-vector -2.6593598723411560e+02 -3.1660100817680359e+02 1.5708699822425842e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.8527200222015381e+02 -3.1483799219131470e+02 9.1549098491668701e+01) (float-vector -2.7797898650169373e+02 -3.1890401244163513e+02 -5.1000699400901794e+01) (float-vector -3.0359700322151184e+02 -2.9891699552536011e+02 -5.0996400415897369e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.8527200222015381e+02 -3.1483799219131470e+02 9.1549098491668701e+01) (float-vector -3.0359700322151184e+02 -2.9891699552536011e+02 -5.0996400415897369e+01) (float-vector -3.1073099374771118e+02 -2.9012599587440491e+02 9.3821302056312561e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.6593598723411560e+02 -3.1660100817680359e+02 1.5708699822425842e+02) (float-vector -2.8527200222015381e+02 -3.1483799219131470e+02 9.1549098491668701e+01) (float-vector -3.0545601248741150e+02 -2.0641799271106720e+02 6.0515701770782471e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.0545601248741150e+02 -2.0641799271106720e+02 6.0515701770782471e+02) (float-vector -2.8527200222015381e+02 -3.1483799219131470e+02 9.1549098491668701e+01) (float-vector -3.1073099374771118e+02 -2.9012599587440491e+02 9.3821302056312561e+01) (float-vector -3.1909900903701782e+02 -1.9309599697589874e+02 6.0515797138214111e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.8527200222015381e+02 -3.1483799219131470e+02 9.1549098491668701e+01) (float-vector -2.5181400775909424e+02 -3.2976898550987244e+02 8.8549703359603882e+01) (float-vector -2.4389000236988068e+02 -3.3201599121093750e+02 -5.1000300794839859e+01) (float-vector -2.7797898650169373e+02 -3.1890401244163513e+02 -5.1000699400901794e+01)))))
              ))
             )
      (setq geom (instance collada-body :init :replace-obj qhull :name "base_link_geom0"))
      (when glv
        (setq (geom . gl::aglvertices) glv)
        (send geom :assoc glv))
      geom))
  (:_make_instance_bl_caster_l_wheel_link_geom0 ()
    (let (geom glv qhull
          (local-cds (make-coords :pos (float-vector 0.0000000000000000e+00 4.9000000000000000e+01 0.0000000000000000e+00))))
      (setq glv
       (instance gl::glvertices :init
                 (list ;; mesh list
                  (list ;; mesh description
                   (list :type :triangles)
                   (list :material (list
                    (list :ambient (float-vector 0.000100 0.000100 0.000100 1.000000))
                    (list :diffuse (float-vector 0.000000 0.000000 0.000000 1.000000))))
                   (list :indices #i( 0 1 2 0 4 1 2 28 0 30 4 0 28 30 0 21 22 2 22 28 2 2 1 21 28 29 30 22 29 28 30 29 31 30 31 4 404 29 407 408 407 29 31 29 404 22 408 29 20 22 21 22 20 408 18 20 21 17 20 18 412 20 17 408 20 412 17 18 19 21 486 18 18 486 19 17 19 16 412 17 16 412 413 414 412 414 408 412 16 413 413 415 414 409 415 413 413 15 409 413 16 481 413 481 15 14 15 7 409 15 14 481 7 15 481 16 7 6 7 8 8 7 11 14 7 6 16 11 7 14 6 10 409 14 10 9 10 6 6 487 9 8 489 6 6 489 487 8 11 13 8 488 489 13 488 8 12 13 11 11 16 12 13 12 19 19 488 13 486 488 19 486 499 488 488 499 497 488 497 489 16 19 12 489 497 494 489 494 487 497 459 494 499 459 497 486 498 499 499 474 459 499 498 474 493 498 486 474 498 475 498 493 475 40 474 475 475 478 471 40 475 471 475 493 478 37 39 40 41 37 40 41 40 471 39 474 40 41 471 378 471 478 378 478 476 378 478 493 476 69 378 379 37 41 378 37 378 69 378 476 379 476 477 379 476 493 477 69 379 376 379 477 376 376 477 473 493 473 477 492 493 3 1 493 486 3 493 1 492 473 493 491 496 492 491 492 3 492 496 473 3 4 5 4 3 1 491 3 5 21 1 486 4 31 5 482 5 483 33 483 5 33 5 31 482 491 5 33 31 34 31 404 34 34 35 33 35 483 33 36 482 483 35 36 483 34 36 35 34 26 36 406 34 404 27 34 406 26 34 27 404 405 406 407 405 404 27 406 410 434 406 405 410 406 434 434 405 423 407 423 405 407 408 423 423 408 417 440 408 414 417 408 440 416 417 418 417 427 418 417 416 423 417 440 427 414 439 440 427 440 439 451 427 439 398 427 402 427 398 418 451 402 427 419 416 418 418 398 419 423 416 419 419 422 423 401 419 398 419 401 400 400 422 419 422 421 423 421 434 423 420 421 422 425 421 420 425 434 421 420 424 425 424 434 425 426 424 420 426 434 424 420 381 426 422 396 420 381 420 382 382 420 396 434 426 435 426 381 435 380 381 382 260 392 381 381 380 260 392 435 381 393 382 396 380 382 393 258 380 257 380 393 257 260 380 258 235 259 260 260 258 235 259 392 260 392 259 391 430 392 391 430 435 392 231 259 235 229 262 259 229 259 231 259 262 391 231 232 229 235 236 231 231 236 232 232 237 229 232 236 177 183 232 177 183 237 232 235 234 236 236 234 181 177 236 181 177 178 167 168 177 167 177 181 178 168 183 177 179 181 180 178 181 179 181 234 180 166 178 164 164 178 179 167 178 166 167 161 162 166 161 167 162 168 167 161 166 160 160 166 164 160 164 159 164 165 159 164 179 165 180 165 179 358 165 363 159 165 358 363 165 365 180 365 165 118 159 117 160 159 118 117 159 358 161 160 119 119 160 118 105 118 117 104 119 118 104 118 105 117 116 105 116 117 329 329 117 358 104 105 98 105 116 95 98 105 95 97 103 104 98 97 104 103 119 104 92 97 98 92 98 95 95 81 92 95 316 81 316 95 317 95 116 317 92 93 94 81 93 92 94 97 92 99 97 94 97 99 103 93 96 94 96 99 94 93 81 72 61 93 72 61 96 93 101 99 96 59 96 61 59 101 96 100 99 101 100 106 99 99 106 103 101 102 100 101 108 102 59 108 101 100 109 106 102 109 100 121 120 106 106 120 103 109 121 106 120 119 103 120 162 161 120 161 119 121 162 120 109 122 121 163 162 121 122 163 121 102 113 109 113 122 109 123 122 113 122 169 163 123 169 122 163 168 162 163 169 174 174 168 163 170 169 123 170 175 169 169 175 174 124 123 114 114 123 113 124 170 123 124 171 170 176 170 171 175 170 176 175 182 174 176 185 175 185 182 175 171 173 176 173 184 176 176 184 185 152 171 125 125 171 124 152 173 171 172 173 152 173 172 184 172 201 184 201 204 184 184 204 210 184 210 185 186 172 152 186 190 172 190 201 172 148 152 125 148 186 152 187 186 149 149 186 148 187 190 186 190 187 191 191 201 190 150 188 187 150 187 149 188 191 187 149 148 136 150 149 137 137 149 136 131 148 125 136 148 131 89 136 131 132 137 136 132 136 89 133 137 132 133 138 137 138 150 137 130 132 89 133 132 134 134 132 130 89 90 91 91 130 89 90 89 131 90 110 91 90 115 110 131 115 90 112 91 107 107 91 110 91 129 130 91 112 129 110 111 107 110 114 111 110 115 114 125 124 115 115 124 114 131 125 115 111 114 113 107 111 102 111 113 102 107 102 108 108 112 107 58 108 59 58 112 108 58 59 57 59 60 57 59 61 60 60 61 62 62 63 60 63 57 60 61 72 62 63 62 64 62 72 64 72 65 64 72 81 82 72 82 65 64 65 66 66 63 64 66 65 70 65 80 70 65 82 80 82 314 80 81 316 82 82 316 314 80 79 70 305 306 80 314 305 80 80 306 79 317 318 314 317 314 316 314 318 305 305 319 315 318 319 305 305 315 306 306 309 79 306 313 309 306 315 313 315 327 325 319 327 315 315 325 313 320 319 318 328 327 319 320 328 319 317 320 318 317 116 320 329 328 320 116 329 320 360 359 328 328 359 327 329 360 328 327 354 325 327 359 354 325 324 313 325 354 324 354 353 324 354 356 353 354 359 361 361 356 354 360 362 359 359 362 361 362 364 361 361 272 356 361 364 272 356 357 353 356 274 357 356 272 274 269 272 268 272 273 268 274 272 269 272 364 273 362 365 364 364 365 273 268 273 234 234 273 180 273 365 180 264 268 234 264 269 268 233 234 235 264 234 233 256 264 233 256 253 264 253 269 264 256 233 257 235 258 233 258 257 233 253 256 263 257 393 256 256 395 263 393 395 256 254 253 263 263 394 254 263 395 394 393 396 395 395 399 400 395 400 394 396 399 395 254 394 255 400 401 394 394 401 255 250 253 254 255 250 254 250 255 251 255 248 251 255 398 248 255 401 398 248 250 251 247 246 248 248 246 250 398 402 248 248 402 247 245 246 247 402 403 247 247 403 245 448 403 402 402 451 448 245 403 397 403 448 397 244 242 245 245 242 246 245 397 244 243 242 244 244 397 243 243 397 386 397 450 386 448 447 397 450 397 447 242 243 240 386 240 243 386 384 387 387 240 386 384 386 449 449 386 450 441 449 450 450 447 441 443 447 448 441 447 442 442 447 443 414 441 442 438 441 414 441 438 449 384 449 454 449 438 454 414 415 438 415 445 438 454 438 445 443 439 414 414 442 443 439 443 448 448 451 439 444 445 415 444 446 445 454 445 452 446 452 445 384 454 452 385 384 452 452 453 385 452 446 453 453 446 444 385 453 389 455 389 453 453 444 455 383 384 385 385 389 238 385 238 383 383 388 384 384 388 387 249 388 383 383 238 249 228 238 239 226 249 238 226 238 228 238 389 239 226 241 249 241 388 249 387 388 241 240 387 241 240 241 225 225 241 226 225 226 227 217 227 226 228 218 226 217 226 218 227 212 225 211 225 212 242 240 225 225 211 242 212 227 217 208 211 212 205 212 217 208 212 205 211 209 213 209 211 208 213 221 211 211 221 242 242 221 246 220 221 213 220 222 221 222 246 221 213 347 346 213 346 220 209 347 213 220 215 222 220 346 336 337 220 336 220 337 215 214 222 215 214 246 222 214 215 216 348 215 343 343 215 337 215 348 216 333 337 332 332 337 336 343 337 333 333 338 343 338 344 343 344 348 343 216 348 344 339 344 338 344 339 345 345 216 344 301 338 333 339 338 302 302 338 301 333 332 300 301 333 300 291 301 300 302 301 294 294 301 291 303 302 295 295 302 294 303 339 302 285 294 291 293 295 294 293 294 285 283 291 289 285 291 283 291 300 289 284 285 283 290 285 75 284 75 285 290 293 285 292 293 290 292 295 293 83 277 290 290 277 292 290 75 83 74 75 76 75 74 83 75 284 76 283 282 284 284 282 76 88 76 87 76 88 74 87 76 278 76 282 278 282 280 278 280 282 286 283 289 282 282 289 286 278 279 87 278 280 279 279 280 281 280 286 287 281 280 287 299 298 286 289 299 286 286 298 287 300 299 289 299 332 331 299 331 298 300 332 299 287 298 297 331 330 298 298 330 297 287 288 281 287 297 288 288 297 158 297 196 158 330 196 297 330 334 196 331 335 330 330 335 334 336 331 332 335 331 336 335 346 334 336 346 335 196 334 199 334 347 199 334 346 347 193 158 196 196 199 193 193 199 200 200 199 207 199 209 207 209 199 347 157 158 193 157 193 195 193 200 195 195 200 198 200 207 198 198 207 206 207 208 206 207 209 208 195 198 194 194 198 197 198 206 197 195 194 156 157 195 156 154 194 189 156 194 154 189 194 197 197 192 189 205 202 197 197 202 192 197 206 205 208 205 206 205 217 202 191 202 203 192 202 191 202 217 203 189 192 188 188 192 191 189 188 151 154 189 151 151 188 150 151 150 138 154 151 138 127 138 133 127 139 138 139 154 138 126 127 128 127 133 135 126 139 127 127 135 128 134 135 133 130 135 134 135 366 128 130 366 135 73 366 130 129 73 130 128 366 367 366 53 367 370 53 366 73 370 366 367 86 143 128 367 143 53 47 367 86 367 47 140 143 142 142 143 85 140 128 143 143 86 85 140 126 128 144 145 140 144 140 142 140 145 126 141 142 85 142 141 144 85 86 87 141 85 279 87 279 85 141 153 144 279 281 141 288 153 141 281 288 141 144 147 145 144 153 147 147 146 145 145 146 126 157 156 147 153 157 147 147 156 146 153 158 157 158 153 288 126 146 139 156 155 146 146 155 139 155 156 154 139 155 154 87 86 88 86 369 88 47 369 86 369 368 88 88 368 74 369 43 368 43 369 47 46 47 48 46 43 47 48 47 52 52 47 53 45 43 46 46 461 45 48 461 46 44 43 45 45 458 44 45 461 458 458 461 456 456 461 48 456 457 458 44 458 472 458 457 472 42 43 44 44 472 42 472 56 42 472 457 480 472 480 56 456 459 457 457 459 480 459 456 48 48 460 459 459 460 470 470 494 459 459 474 480 56 480 479 474 479 480 39 479 474 56 479 39 37 38 39 39 38 56 68 37 69 38 37 84 68 84 37 67 68 69 67 71 68 71 84 68 70 69 66 67 69 70 69 376 66 67 77 71 70 79 67 67 79 77 71 77 78 78 84 71 83 84 78 78 77 277 78 277 83 83 74 84 74 38 84 74 368 38 56 38 42 38 43 42 43 38 368 275 276 277 276 292 277 277 77 275 77 308 275 275 311 307 308 311 275 276 275 307 276 296 292 307 296 276 292 296 295 304 303 296 296 303 295 307 304 296 307 321 304 311 321 307 321 326 304 326 340 304 304 340 303 303 340 339 345 339 340 326 342 340 340 342 345 341 342 326 321 351 326 351 341 326 322 321 311 322 351 321 352 351 322 352 355 351 351 355 341 342 341 349 355 350 341 341 350 349 342 349 345 345 349 216 271 349 350 216 349 223 223 349 271 357 350 355 350 357 271 355 352 353 357 355 353 271 357 274 224 271 270 271 274 270 224 223 271 223 224 214 223 214 216 224 267 214 224 270 265 224 265 267 265 270 266 266 270 269 270 274 269 265 266 253 253 250 265 267 265 250 246 267 250 214 267 246 266 269 253 323 353 352 324 353 323 323 322 312 324 323 312 323 352 322 313 324 312 308 312 311 309 312 308 309 313 312 312 322 311 309 308 310 310 308 77 310 79 309 79 310 77 66 375 63 66 376 377 377 375 66 63 375 374 375 466 464 374 375 464 377 466 375 63 374 373 63 373 57 374 464 465 465 373 374 464 496 465 464 466 496 377 473 466 496 466 473 376 473 377 490 496 491 495 496 490 496 495 465 467 373 465 465 495 467 494 495 490 495 494 467 468 373 467 467 463 372 467 372 468 467 494 470 467 470 463 487 494 490 9 487 23 23 487 490 23 10 9 23 24 10 32 23 485 24 23 32 23 490 485 409 10 24 32 27 24 24 27 409 27 32 25 485 25 32 485 484 25 485 490 484 484 490 491 26 484 482 25 484 26 482 484 491 25 26 27 409 27 410 409 410 411 409 411 415 428 410 434 428 411 410 437 411 436 436 411 428 411 444 415 411 437 444 436 432 437 437 455 444 455 437 432 436 433 432 433 436 428 431 432 433 431 433 428 455 432 389 391 390 432 389 432 390 431 391 432 431 428 430 431 430 391 390 391 261 391 262 261 389 390 252 261 252 390 239 389 252 239 252 228 228 252 261 228 261 229 229 261 262 228 229 230 219 218 228 230 219 228 229 237 230 237 219 230 204 219 210 204 218 219 210 219 237 203 217 218 203 218 204 203 204 201 203 201 191 210 237 185 185 237 183 182 185 183 182 183 174 174 183 168 428 429 430 430 429 435 428 434 429 429 434 435 36 26 482 462 372 463 469 462 463 463 470 469 51 462 469 50 462 51 50 372 462 371 372 49 372 50 49 468 372 371 49 50 51 54 55 51 51 55 49 469 54 51 470 54 469 460 54 470 52 53 54 54 53 55 460 52 54 55 58 49 55 73 58 370 73 55 55 53 370 57 49 58 73 112 58 129 112 73 57 371 49 57 373 371 371 373 468 48 52 460 399 422 400 422 399 396 363 365 362 358 363 360 360 363 362 329 358 360))
                   (list :vertices (let ((mat (make-matrix 500 3))) (fvector-replace (array-entity mat) #f(5.1378703117370605e+00 -2.9734701156616211e+01 -9.3289899826049805e+00 2.7445201873779297e+00 -2.9418100357055664e+01 -1.2800700187683105e+01 1.0573199987411499e+00 -2.9640798568725586e+01 -1.0600199699401855e+01 1.0544799804687500e+01 -2.9430900573730469e+01 -8.4442996978759766e+00 8.2298793792724609e+00 -2.9580398559570312e+01 -6.8257398605346680e+00 1.0452800750732422e+01 -2.9676599502563477e+01 -2.3365499973297119e+00 -6.6212201118469238e+00 -2.9607198715209961e+01 8.3633699417114258e+00 -1.0304100036621094e+01 -8.0464500427246094e+01 4.2757096290588379e+00 -9.9000797271728516e+00 -2.9565000534057617e+01 4.3990101814270020e+00 -3.0437600612640381e+00 -2.9632600784301758e+01 1.0238399505615234e+01 -3.0640001296997070e+00 -8.0891304016113281e+01 1.0639900207519531e+01 -1.0523200035095215e+01 -2.9807800292968750e+01 2.0460700988769531e+00 -1.0421499252319336e+01 -2.9872400283813477e+01 -1.9288499355316162e+00 -1.1160599708557129e+01 -2.9559000015258789e+01 -8.0958700180053711e-01 -7.1614899635314941e+00 -8.0892097473144531e+01 8.4554700851440430e+00 -1.0192299842834473e+01 -8.0942695617675781e+01 5.5663700103759766e+00 -1.0925999641418457e+01 -8.0888397216796875e+01 -2.1682801246643066e+00 -8.4008197784423828e+00 -8.0911102294921875e+01 -7.2349200248718262e+00 -6.7002696990966797e+00 -2.9603599548339844e+01 -8.3113307952880859e+00 -9.4348793029785156e+00 -2.9594200134277344e+01 -4.9726400375366211e+00 -5.3217201232910156e+00 -8.0856101989746094e+01 -9.7155799865722656e+00 -2.8588600158691406e+00 -2.9677499771118164e+01 -1.0273599624633789e+01 -1.0057700872421265e+00 -8.0903297424316406e+01 -1.1044600486755371e+01 1.0178999900817871e+00 -2.9632200241088867e+01 1.0607999801635742e+01 1.0090099573135376e+00 -8.0902297973632812e+01 1.1044500350952148e+01 7.1427397727966309e+00 -8.0804000854492188e+01 8.4595899581909180e+00 9.8030099868774414e+00 -8.0907203674316406e+01 5.1623497009277344e+00 7.4257197380065918e+00 -8.1105201721191406e+01 1.1212299346923828e+01 3.3442101478576660e+00 -8.0903900146484375e+01 -1.0557999610900879e+01 6.1998200416564941e+00 -8.1096000671386719e+01 -1.1747900009155273e+01 7.2372202873229980e+00 -8.0794494628906250e+01 -8.3683700561523438e+00 9.8025293350219727e+00 -8.0921005249023438e+01 -5.1738500595092773e+00 4.0853300094604492e+00 -8.0921997070312500e+01 1.0249599456787109e+01 1.0831099510192871e+01 -8.0742095947265625e+01 -2.0039701461791992e+00 1.2268199920654297e+01 -8.1127998352050781e+01 3.9475402832031250e+00 1.1011500358581543e+01 -8.0664100646972656e+01 0.0000000000000000e+00 1.0836700439453125e+01 -8.0821899414062500e+01 2.0019199848175049e+00 -1.1417300224304199e+01 -3.1931400299072266e+01 -6.0313899993896484e+01 -3.8845100402832031e+01 -3.1901300430297852e+01 -4.7875999450683594e+01 -3.0698499679565430e+01 -3.3114299774169922e+01 -3.9734401702880859e+01 -1.5955299377441406e+01 -3.3060798645019531e+01 -4.7729400634765625e+01 -2.3467898368835449e+00 -3.3005496978759766e+01 -5.1267002105712891e+01 -4.5538898468017578e+01 -3.2922698974609375e+01 -2.5041301727294922e+01 -6.0313198089599609e+01 -3.1965400695800781e+01 -7.4321599006652832e+00 -4.9943901062011719e+01 -3.2961498260498047e+01 -1.3358200073242188e+01 -5.1267002105712891e+01 -3.3005199432373047e+01 2.3467597961425781e+00 -4.8763401031494141e+01 -3.2972099304199219e+01 1.6582399368286133e+01 -6.1740497589111328e+01 -3.1979299545288086e+01 1.0151400566101074e+01 -4.5477100372314453e+01 -3.3045398712158203e+01 2.1893899917602539e+01 1.6372301101684570e+01 -3.1941600799560547e+01 5.8962200164794922e+01 2.3468399047851562e+00 -3.3007396697998047e+01 5.1267200469970703e+01 -9.9129495620727539e+00 -3.3083801269531250e+01 4.9431499481201172e+01 -3.6015296936035156e+01 -3.3108100891113281e+01 3.4995300292968750e+01 -4.8726200103759766e+01 -3.1919502258300781e+01 3.8182498931884766e+01 -2.5745399475097656e+01 -3.3058502197265625e+01 4.3290298461914062e+01 -6.4798698425292969e+00 -3.1922300338745117e+01 6.1833000183105469e+01 -3.9104801177978516e+01 -3.3105998992919922e+01 -3.1760398864746094e+01 3.8039699554443359e+01 -3.1931098937988281e+01 4.8811397552490234e+01 2.0110498428344727e+01 -3.2998302459716797e+01 6.3504100799560547e+01 4.7388999938964844e+01 -3.3059799194335938e+01 4.7388999938964844e+01 5.0501701354980469e+01 -3.2199699401855469e+01 3.8274200439453125e+01 6.3447898864746094e+01 -3.3059898376464844e+01 2.0092599868774414e+01 6.0778099060058594e+01 -3.2144401550292969e+01 1.7475801467895508e+01 6.0313198089599609e+01 -3.1965400695800781e+01 7.4321599006652832e+00 6.3284599304199219e+01 -3.2191196441650391e+01 -4.4547400474548340e+00 5.9817501068115234e+01 -3.3059898376464844e+01 -2.9234298706054688e+01 5.5512199401855469e+01 -3.1871200561523438e+01 -2.7132499694824219e+01 2.8417900085449219e+01 -3.3024398803710938e+01 -6.0260898590087891e+01 4.4547300338745117e+00 -3.2191101074218750e+01 -6.3284301757812500e+01 3.3109401702880859e+01 -3.1901699066162109e+01 -5.2159999847412109e+01 4.6935901641845703e+01 -3.2998600006103516e+01 -4.6935901641845703e+01 4.6696701049804688e+00 -3.3059997558593750e+01 -6.6339698791503906e+01 6.6339698791503906e+01 -3.3059997558593750e+01 -4.6691398620605469e+00 -1.2190400123596191e+01 -3.3019302368164062e+01 6.5981704711914062e+01 -4.4070800781250000e+01 -3.3025100708007812e+01 -4.9997600555419922e+01 -3.9661098480224609e+01 -3.2243999481201172e+01 -5.7238800048828125e+01 -5.8180297851562500e+01 -3.2244602203369141e+01 -3.8144996643066406e+01 1.5174099922180176e+01 -3.2350498199462891e+01 -6.8473693847656250e+01 4.8838300704956055e+00 -3.2246299743652344e+01 -6.9384094238281250e+01 4.1918899536132812e+01 -3.2255702972412109e+01 -5.5662799835205078e+01 5.6185497283935547e+01 -3.2231498718261719e+01 -4.1026100158691406e+01 6.9456398010253906e+01 -3.2233699798583984e+01 -1.5821299552917480e+00 6.6359199523925781e+01 -3.2246299743652344e+01 -2.1015600204467773e+01 -2.1015600204467773e+01 -3.2246299743652344e+01 -6.6359199523925781e+01 -2.0110498428344727e+01 -3.2998302459716797e+01 -6.3504100799560547e+01 -6.9488693237304688e+01 -3.2240303039550781e+01 1.4109100103378296e+00 -6.6339698791503906e+01 -3.3059997558593750e+01 -4.6691398620605469e+00 -6.6359199523925781e+01 -3.2246299743652344e+01 -2.1015600204467773e+01 -5.9817501068115234e+01 -3.3059898376464844e+01 -2.9234298706054688e+01 -1.5645200729370117e+01 -3.8389400482177734e+01 7.4474800109863281e+01 -1.7341400384902954e+00 -3.8391998291015625e+01 7.6071098327636719e+01 5.1130599975585938e+00 -3.4403301239013672e+01 7.2644706726074219e+01 7.1366401672363281e+01 -3.4439002990722656e+01 1.3268600463867188e+01 6.7285202026367188e+01 -3.2246299743652344e+01 1.7788499832153320e+01 6.7477394104003906e+01 -3.4428897857666016e+01 2.6760299682617188e+01 7.5355300903320312e+01 -3.7268402099609375e+01 1.7170599699020386e+00 5.9104999542236328e+01 -3.2233699798583984e+01 3.6562202453613281e+01 7.0040397644042969e+01 -3.8387001037597656e+01 2.9782499313354492e+01 7.4474800109863281e+01 -3.8389400482177734e+01 1.5645200729370117e+01 6.2013099670410156e+01 -3.7266197204589844e+01 4.2893001556396484e+01 5.1923801422119141e+01 -3.7266002655029297e+01 5.4677501678466797e+01 4.9207698822021484e+01 -3.2231403350830078e+01 4.9181400299072266e+01 3.9661300659179688e+01 -3.7265899658203125e+01 6.4126296997070312e+01 6.6670997619628906e+01 -4.3020999908447266e+01 4.1205699920654297e+01 7.3550094604492188e+01 -4.3022300720214844e+01 2.7057100296020508e+01 7.7358497619628906e+01 -4.3024600982666016e+01 1.2475700378417969e+01 5.6843299865722656e+01 -4.3021598815917969e+01 5.3966102600097656e+01 2.5049600601196289e+01 -3.4442001342773438e+01 6.8122604370117188e+01 3.6946399688720703e+01 -3.2240901947021484e+01 5.8903797149658203e+01 4.4562896728515625e+01 -4.3020900726318359e+01 6.4476997375488281e+01 1.2114600181579590e+01 -3.8389999389648438e+01 7.5127197265625000e+01 2.6272998809814453e+01 -3.8387500762939453e+01 7.1428794860839844e+01 2.1015600204467773e+01 -3.2246299743652344e+01 6.6359199523925781e+01 3.0671701431274414e+01 -4.3021900177001953e+01 7.2120101928710938e+01 1.6111700057983398e+01 -4.3023998260498047e+01 7.6686698913574219e+01 1.7856500148773193e+00 -4.3026500701904297e+01 7.8329895019531250e+01 7.8330101013183594e+01 -4.3027000427246094e+01 -1.7853500843048096e+00 7.9383201599121094e+01 -4.8954898834228516e+01 -3.4461998939514160e-01 7.8114799499511719e+01 -4.8949199676513672e+01 1.4203499794006348e+01 7.3951698303222656e+01 -4.8940597534179688e+01 2.8930398941040039e+01 6.6686599731445312e+01 -4.8934600830078125e+01 4.3129802703857422e+01 5.6477798461914062e+01 -4.8932300567626953e+01 5.5839900970458984e+01 4.3869800567626953e+01 -4.8934097290039062e+01 6.6202606201171875e+01 2.9704099655151367e+01 -4.8939601898193359e+01 7.3644798278808594e+01 1.4941699981689453e+01 -4.8947898864746094e+01 7.7977600097656250e+01 3.4459200501441956e-01 -4.8954898834228516e+01 7.9383300781250000e+01 -6.4126296997070312e+01 -3.7265899658203125e+01 3.9661300659179688e+01 -5.3850097656250000e+01 -3.6490200042724609e+01 5.2007102966308594e+01 -5.6481498718261719e+01 -3.2248001098632812e+01 4.0724998474121094e+01 -4.8838300704956055e+00 -3.2246299743652344e+01 6.9384094238281250e+01 -1.5174099922180176e+01 -3.2350498199462891e+01 6.8473693847656250e+01 -1.2475700378417969e+01 -4.3024600982666016e+01 7.7358497619628906e+01 -2.9782499313354492e+01 -3.8387001037597656e+01 7.0040397644042969e+01 -4.2893001556396484e+01 -3.7266197204589844e+01 6.2013099670410156e+01 -2.8395601272583008e+01 -3.4441600799560547e+01 6.6799201965332031e+01 -4.3375499725341797e+01 -3.2257099151611328e+01 5.4680000305175781e+01 -2.7057100296020508e+01 -4.3022300720214844e+01 7.3550094604492188e+01 -4.1205699920654297e+01 -4.3020999908447266e+01 6.6670997619628906e+01 -5.3966102600097656e+01 -4.3021598815917969e+01 5.6843299865722656e+01 -6.4476997375488281e+01 -4.3020900726318359e+01 4.4562896728515625e+01 -6.7513504028320312e+01 -3.4440597534179688e+01 2.6707201004028320e+01 -7.5355300903320312e+01 -3.7268402099609375e+01 -1.7170599699020386e+00 -7.1374496459960938e+01 -3.4436901092529297e+01 1.3211199760437012e+01 -6.7285202026367188e+01 -3.2246299743652344e+01 1.7788499832153320e+01 -7.5127197265625000e+01 -3.8389999389648438e+01 1.2114600181579590e+01 -7.1428794860839844e+01 -3.8387500762939453e+01 2.6272998809814453e+01 -7.2120101928710938e+01 -4.3021900177001953e+01 3.0671701431274414e+01 -7.6686698913574219e+01 -4.3023998260498047e+01 1.6111700057983398e+01 -1.4203499794006348e+01 -4.8949199676513672e+01 7.8114799499511719e+01 -2.8930398941040039e+01 -4.8940597534179688e+01 7.3951698303222656e+01 -4.3129802703857422e+01 -4.8934600830078125e+01 6.6686599731445312e+01 -5.4402599334716797e+01 -4.9551700592041016e+01 5.7758701324462891e+01 -1.7856500148773193e+00 -5.4973503112792969e+01 7.8329895019531250e+01 -7.8330101013183594e+01 -4.3027000427246094e+01 1.7853500843048096e+00 -6.4116600036621094e+01 -4.8947498321533203e+01 4.6979301452636719e+01 -6.7437301635742188e+01 -4.7811298370361328e+01 4.1716197967529297e+01 -7.3951698303222656e+01 -4.9059398651123047e+01 2.8930398941040039e+01 -7.8114799499511719e+01 -4.9050800323486328e+01 1.4203499794006348e+01 -7.9383201599121094e+01 -4.9045101165771484e+01 -3.4461998939514160e-01 7.8330101013183594e+01 -5.4972999572753906e+01 1.7853500843048096e+00 7.6686698913574219e+01 -5.4976001739501953e+01 1.6111700057983398e+01 7.2120101928710938e+01 -5.4978099822998047e+01 3.0671701431274414e+01 6.4476997375488281e+01 -5.4979099273681641e+01 4.4562896728515625e+01 5.3966102600097656e+01 -5.4978401184082031e+01 5.6843299865722656e+01 7.5127197265625000e+01 -5.9610000610351562e+01 1.2114600181579590e+01 7.5355300903320312e+01 -6.0731601715087891e+01 -1.7170599699020386e+00 7.1428794860839844e+01 -5.9612503051757812e+01 2.6272998809814453e+01 6.4126296997070312e+01 -6.0734100341796875e+01 3.9661300659179688e+01 5.3850097656250000e+01 -6.1509799957275391e+01 5.2007102966308594e+01 4.1205699920654297e+01 -5.4979000091552734e+01 6.6670997619628906e+01 2.7057100296020508e+01 -5.4977699279785156e+01 7.3550094604492188e+01 1.2475700378417969e+01 -5.4975402832031250e+01 7.7358497619628906e+01 -1.2114600181579590e+01 -5.9610000610351562e+01 7.5127197265625000e+01 1.7341400384902954e+00 -5.9608001708984375e+01 7.6071098327636719e+01 4.2893001556396484e+01 -6.0733798980712891e+01 6.2013099670410156e+01 2.9782499313354492e+01 -5.9612998962402344e+01 7.0040397644042969e+01 1.5645200729370117e+01 -5.9610603332519531e+01 7.4474800109863281e+01 5.6481498718261719e+01 -6.5751998901367188e+01 4.0724998474121094e+01 6.7513504028320312e+01 -6.3559398651123047e+01 2.6707201004028320e+01 7.1374496459960938e+01 -6.3563102722167969e+01 1.3211199760437012e+01 6.9488693237304688e+01 -6.5759704589843750e+01 1.4108999967575073e+00 6.7285202026367188e+01 -6.5753700256347656e+01 1.7788499832153320e+01 2.8395601272583008e+01 -6.3558399200439453e+01 6.6799201965332031e+01 4.3375499725341797e+01 -6.5742904663085938e+01 5.4680000305175781e+01 -5.1130700111389160e+00 -6.3596702575683594e+01 7.2644706726074219e+01 1.5174099922180176e+01 -6.5649505615234375e+01 6.8473693847656250e+01 -1.6111700057983398e+01 -5.4976001739501953e+01 7.6686698913574219e+01 -3.0671701431274414e+01 -5.4978099822998047e+01 7.2120101928710938e+01 -4.4562896728515625e+01 -5.4979099273681641e+01 6.4476997375488281e+01 -5.6843299865722656e+01 -5.4978401184082031e+01 5.3966102600097656e+01 -2.6272998809814453e+01 -5.9612503051757812e+01 7.1428794860839844e+01 -3.9661300659179688e+01 -6.0734100341796875e+01 6.4126296997070312e+01 -5.1923801422119141e+01 -6.0734001159667969e+01 5.4677501678466797e+01 -7.7358497619628906e+01 -5.4975402832031250e+01 1.2475700378417969e+01 -6.6670997619628906e+01 -5.4979000091552734e+01 4.1205699920654297e+01 -7.3550094604492188e+01 -5.4977699279785156e+01 2.7057100296020508e+01 -7.8330101013183594e+01 -5.4972999572753906e+01 -1.7853500843048096e+00 -6.2013099670410156e+01 -6.0733798980712891e+01 4.2893001556396484e+01 -7.0040397644042969e+01 -5.9612998962402344e+01 2.9782499313354492e+01 -7.5355300903320312e+01 -6.0731601715087891e+01 1.7170599699020386e+00 -7.4474800109863281e+01 -5.9610603332519531e+01 1.5645200729370117e+01 -2.5049600601196289e+01 -6.3557998657226562e+01 6.8122604370117188e+01 -4.9207698822021484e+01 -6.5768600463867188e+01 4.9181400299072266e+01 -3.6946399688720703e+01 -6.5759101867675781e+01 5.8903797149658203e+01 -2.1015600204467773e+01 -6.5753700256347656e+01 6.6359199523925781e+01 -5.9104999542236328e+01 -6.5766296386718750e+01 3.6562202453613281e+01 -6.7477394104003906e+01 -6.3571102142333984e+01 2.6760299682617188e+01 -7.1366401672363281e+01 -6.3561000823974609e+01 1.3268600463867188e+01 -6.7285202026367188e+01 -6.5753700256347656e+01 1.7788499832153320e+01 -6.9456398010253906e+01 -6.5766296386718750e+01 -1.5821199417114258e+00 4.8838300704956055e+00 -6.5753700256347656e+01 6.9384094238281250e+01 -6.5954093933105469e+01 -6.5003295898437500e+01 -1.1007699966430664e+01 -6.3504100799560547e+01 -6.5001693725585938e+01 2.0110498428344727e+01 -6.6359199523925781e+01 -6.5753700256347656e+01 -2.1015600204467773e+01 -2.0092599868774414e+01 -6.4940101623535156e+01 -6.3447898864746094e+01 -4.1918899536132812e+01 -6.5744300842285156e+01 -5.5662799835205078e+01 -1.5174099922180176e+01 -6.5649505615234375e+01 -6.8473693847656250e+01 -5.0577800750732422e+01 -6.4940101623535156e+01 4.3333198547363281e+01 -2.5114198684692383e+01 -6.5005798339843750e+01 6.1894699096679688e+01 -4.6691398620605469e+00 -6.4939994812011719e+01 6.6339698791503906e+01 -5.6185497283935547e+01 -6.5768501281738281e+01 -4.1026100158691406e+01 -5.9442901611328125e+01 -6.4974800109863281e+01 -3.0091600418090820e+01 -4.3333198547363281e+01 -6.4940101623535156e+01 -5.0577800750732422e+01 -4.8838400840759277e+00 -6.5753700256347656e+01 -6.9384094238281250e+01 4.6691398620605469e+00 -6.4939994812011719e+01 -6.6339698791503906e+01 -6.1515499114990234e+01 -6.6084396362304688e+01 7.3676099777221680e+00 -3.9422199249267578e+01 -6.6119201660156250e+01 4.7579696655273438e+01 -4.8702198028564453e+01 -6.5940795898437500e+01 3.9441997528076172e+01 -8.7784500122070312e+00 -6.6089698791503906e+01 6.1264701843261719e+01 3.0705200195312500e+01 -6.6117897033691406e+01 5.3397201538085938e+01 1.5252799987792969e+01 -6.5862602233886719e+01 6.1349498748779297e+01 5.0155899047851562e+01 -6.6073204040527344e+01 3.6021900177001953e+01 4.3594100952148438e+01 -6.4963195800781250e+01 5.0356700897216797e+01 6.0698596954345703e+01 -6.6066696166992188e+01 -6.7463498115539551e+00 6.6711799621582031e+01 -6.5003898620605469e+01 1.3542500138282776e-01 5.9121696472167969e+01 -6.6100502014160156e+01 1.8429199218750000e+01 5.9817501068115234e+01 -6.4940101623535156e+01 2.9234298706054688e+01 2.0092599868774414e+01 -6.4940101623535156e+01 6.3447898864746094e+01 -2.4017601013183594e+01 -6.4924705505371094e+01 4.4330997467041016e+01 -1.2296899795532227e+01 -6.4922195434570312e+01 4.8861900329589844e+01 -4.9878101348876953e+01 -6.4923797607421875e+01 6.1260700225830078e+00 -4.7621898651123047e+01 -6.5026702880859375e+01 2.0646100997924805e+01 -5.8962200164794922e+01 -6.6058395385742188e+01 -1.6372301101684570e+01 -4.9968898773193359e+01 -6.4928802490234375e+01 -5.5101404190063477e+00 -4.6904499053955078e+01 -6.4901504516601562e+01 -1.8820098876953125e+01 -4.1162097930908203e+01 -6.4915802001953125e+01 -2.8893501281738281e+01 -4.1316501617431641e+01 -6.6128295898437500e+01 -4.6076801300048828e+01 -3.1769998550415039e+01 -6.4940605163574219e+01 -3.8861301422119141e+01 -1.5955600738525391e+01 -6.4898902893066406e+01 -4.8028099060058594e+01 -3.6749000549316406e+01 -6.5010696411132812e+01 3.6192996978759766e+01 -7.4321599006652832e+00 -6.6034599304199219e+01 -6.0313198089599609e+01 -4.9870600700378418e+00 -6.5038299560546875e+01 -5.1429000854492188e+01 6.1151897907257080e-01 -6.4899902343750000e+01 5.0388702392578125e+01 4.0430500030517578e+01 -6.6047805786132812e+01 -4.7272399902343750e+01 2.1093599319458008e+01 -6.5008094787597656e+01 -4.7210800170898438e+01 5.7853302955627441e+00 -6.4969100952148438e+01 -5.0313201904296875e+01 4.5625198364257812e+01 -6.5076095581054688e+01 -2.5078199386596680e+01 5.2289600372314453e+01 -6.5047103881835938e+01 -4.6615300178527832e+00 4.9076499938964844e+01 -6.5030502319335938e+01 1.6025699615478516e+01 3.6085098266601562e+01 -6.4887702941894531e+01 3.5027797698974609e+01 4.5658901214599609e+01 -6.4956298828125000e+01 2.1977499008178711e+01 1.2848500251770020e+01 -6.4922805786132812e+01 4.8701698303222656e+01 2.4957799911499023e+01 -6.4924301147460938e+01 4.3825702667236328e+01 3.6392799377441406e+01 -6.5013999938964844e+01 -3.6605201721191406e+01 5.6047599792480469e+01 -6.6018997192382812e+01 -2.7524799346923828e+01 4.4547400474548340e+00 -6.5808799743652344e+01 -6.3284599304199219e+01 2.7442001342773438e+01 -6.5952598571777344e+01 -5.6365200042724609e+01 -1.7475801467895508e+01 -6.5855598449707031e+01 -6.0778099060058594e+01 6.3447898864746094e+01 -6.4940101623535156e+01 -2.0092599868774414e+01 5.0577800750732422e+01 -6.4940101623535156e+01 -4.3333198547363281e+01 2.9234298706054688e+01 -6.4940101623535156e+01 -5.9817501068115234e+01 2.1015600204467773e+01 -6.5753700256347656e+01 -6.6359199523925781e+01 5.6820499420166016e+01 -6.5761795043945312e+01 -4.0331298828125000e+01 6.6359199523925781e+01 -6.5753700256347656e+01 -2.1015600204467773e+01 4.3921298980712891e+01 -6.5758102416992188e+01 -5.3944599151611328e+01 1.5645200729370117e+01 -3.8389400482177734e+01 -7.4474800109863281e+01 1.7341400384902954e+00 -3.8391998291015625e+01 -7.6071098327636719e+01 -5.1130700111389160e+00 -3.4403301239013672e+01 -7.2644706726074219e+01 -6.7477394104003906e+01 -3.4428897857666016e+01 -2.6760299682617188e+01 -7.1366401672363281e+01 -3.4439002990722656e+01 -1.3268600463867188e+01 -7.0040397644042969e+01 -3.8387001037597656e+01 -2.9782499313354492e+01 -7.4474800109863281e+01 -3.8389400482177734e+01 -1.5645200729370117e+01 -6.2013099670410156e+01 -3.7266197204589844e+01 -4.2893001556396484e+01 -5.1923801422119141e+01 -3.7266002655029297e+01 -5.4677501678466797e+01 -5.1424598693847656e+01 -3.3472698211669922e+01 -4.9469097137451172e+01 -3.9661300659179688e+01 -3.7265899658203125e+01 -6.4126296997070312e+01 -6.6670997619628906e+01 -4.3020999908447266e+01 -4.1205699920654297e+01 -7.3550094604492188e+01 -4.3022300720214844e+01 -2.7057100296020508e+01 -7.7358497619628906e+01 -4.3024600982666016e+01 -1.2475700378417969e+01 -5.6843299865722656e+01 -4.3021598815917969e+01 -5.3966102600097656e+01 -2.5049600601196289e+01 -3.4442001342773438e+01 -6.8122604370117188e+01 -4.4562896728515625e+01 -4.3020900726318359e+01 -6.4476997375488281e+01 -1.2114600181579590e+01 -3.8389999389648438e+01 -7.5127197265625000e+01 -2.6272998809814453e+01 -3.8387500762939453e+01 -7.1428794860839844e+01 -3.0671701431274414e+01 -4.3021900177001953e+01 -7.2120101928710938e+01 -1.6111700057983398e+01 -4.3023998260498047e+01 -7.6686698913574219e+01 -1.7856500148773193e+00 -4.3026500701904297e+01 -7.8329895019531250e+01 -7.7977600097656250e+01 -4.9052101135253906e+01 -1.4941699981689453e+01 -7.3644798278808594e+01 -4.9060401916503906e+01 -2.9704099655151367e+01 -6.6202606201171875e+01 -4.9065898895263672e+01 -4.3869800567626953e+01 -5.5839900970458984e+01 -4.9067699432373047e+01 -5.6477798461914062e+01 -4.3129802703857422e+01 -4.9065399169921875e+01 -6.6686599731445312e+01 -2.8930398941040039e+01 -4.9059398651123047e+01 -7.3951698303222656e+01 -1.4203499794006348e+01 -4.9050800323486328e+01 -7.8114799499511719e+01 3.4459200501441956e-01 -4.9045101165771484e+01 -7.9383300781250000e+01 6.4126296997070312e+01 -3.7265899658203125e+01 -3.9661300659179688e+01 5.3850097656250000e+01 -3.6490200042724609e+01 -5.2007102966308594e+01 1.2475700378417969e+01 -4.3024600982666016e+01 -7.7358497619628906e+01 2.9782499313354492e+01 -3.8387001037597656e+01 -7.0040397644042969e+01 4.2893001556396484e+01 -3.7266197204589844e+01 -6.2013099670410156e+01 2.8395601272583008e+01 -3.4441600799560547e+01 -6.6799201965332031e+01 2.7057100296020508e+01 -4.3022300720214844e+01 -7.3550094604492188e+01 4.1205699920654297e+01 -4.3020999908447266e+01 -6.6670997619628906e+01 5.3966102600097656e+01 -4.3021598815917969e+01 -5.6843299865722656e+01 6.7513504028320312e+01 -3.4440597534179688e+01 -2.6707201004028320e+01 6.4476997375488281e+01 -4.3020900726318359e+01 -4.4562896728515625e+01 7.1374496459960938e+01 -3.4436901092529297e+01 -1.3211199760437012e+01 7.5127197265625000e+01 -3.8389999389648438e+01 -1.2114600181579590e+01 7.1428794860839844e+01 -3.8387500762939453e+01 -2.6272998809814453e+01 7.2120101928710938e+01 -4.3021900177001953e+01 -3.0671701431274414e+01 7.6686698913574219e+01 -4.3023998260498047e+01 -1.6111700057983398e+01 1.4941699981689453e+01 -4.9052101135253906e+01 -7.7977600097656250e+01 2.9704099655151367e+01 -4.9060401916503906e+01 -7.3644798278808594e+01 4.1731800079345703e+01 -4.9570999145507812e+01 -6.7475105285644531e+01 4.9999198913574219e+01 -4.8999500274658203e+01 -6.1567001342773438e+01 5.7531902313232422e+01 -4.8420101165771484e+01 -5.4633300781250000e+01 1.7856500148773193e+00 -5.4973503112792969e+01 -7.8329895019531250e+01 6.6202606201171875e+01 -4.8934097290039062e+01 -4.3869800567626953e+01 7.3644798278808594e+01 -4.8939601898193359e+01 -2.9704099655151367e+01 7.7977600097656250e+01 -4.8947898864746094e+01 -1.4941699981689453e+01 -7.6686698913574219e+01 -5.4976001739501953e+01 -1.6111700057983398e+01 -7.2120101928710938e+01 -5.4978099822998047e+01 -3.0671701431274414e+01 -6.4476997375488281e+01 -5.4979099273681641e+01 -4.4562896728515625e+01 -5.3966102600097656e+01 -5.4978401184082031e+01 -5.6843299865722656e+01 -7.5127197265625000e+01 -5.9610000610351562e+01 -1.2114600181579590e+01 -7.1428794860839844e+01 -5.9612503051757812e+01 -2.6272998809814453e+01 -6.4126296997070312e+01 -6.0734100341796875e+01 -3.9661300659179688e+01 -5.3850097656250000e+01 -6.1509799957275391e+01 -5.2007102966308594e+01 -4.1205699920654297e+01 -5.4979000091552734e+01 -6.6670997619628906e+01 -2.7057100296020508e+01 -5.4977699279785156e+01 -7.3550094604492188e+01 -1.2475700378417969e+01 -5.4975402832031250e+01 -7.7358497619628906e+01 1.2114600181579590e+01 -5.9610000610351562e+01 -7.5127197265625000e+01 -1.7341400384902954e+00 -5.9608001708984375e+01 -7.6071098327636719e+01 -4.2893001556396484e+01 -6.0733798980712891e+01 -6.2013099670410156e+01 -2.9782499313354492e+01 -5.9612998962402344e+01 -7.0040397644042969e+01 -1.5645200729370117e+01 -5.9610603332519531e+01 -7.4474800109863281e+01 -6.7513504028320312e+01 -6.3559398651123047e+01 -2.6707201004028320e+01 -7.1374496459960938e+01 -6.3563102722167969e+01 -1.3211199760437012e+01 -2.8395601272583008e+01 -6.3558399200439453e+01 -6.6799201965332031e+01 5.1130599975585938e+00 -6.3596702575683594e+01 -7.2644706726074219e+01 2.5049600601196289e+01 -6.3557998657226562e+01 -6.8122604370117188e+01 1.6111700057983398e+01 -5.4976001739501953e+01 -7.6686698913574219e+01 3.0671701431274414e+01 -5.4978099822998047e+01 -7.2120101928710938e+01 4.2744701385498047e+01 -5.6259502410888672e+01 -6.5250297546386719e+01 5.6843299865722656e+01 -5.4978401184082031e+01 -5.3966102600097656e+01 2.6272998809814453e+01 -5.9612503051757812e+01 -7.1428794860839844e+01 5.1923801422119141e+01 -6.0734001159667969e+01 -5.4677501678466797e+01 3.8678096771240234e+01 -6.2713600158691406e+01 -6.2656597137451172e+01 7.7358497619628906e+01 -5.4975402832031250e+01 -1.2475700378417969e+01 6.6670997619628906e+01 -5.4979000091552734e+01 -4.1205699920654297e+01 7.3550094604492188e+01 -5.4977699279785156e+01 -2.7057100296020508e+01 6.2013099670410156e+01 -6.0733798980712891e+01 -4.2893001556396484e+01 7.0040397644042969e+01 -5.9612998962402344e+01 -2.9782499313354492e+01 7.4474800109863281e+01 -5.9610603332519531e+01 -1.5645200729370117e+01 6.7477394104003906e+01 -6.3571102142333984e+01 -2.6760299682617188e+01 7.1366401672363281e+01 -6.3561000823974609e+01 -1.3268600463867188e+01 -4.6283000946044922e+01 -3.3059700012207031e+01 4.8698802947998047e+01 -6.3504100799560547e+01 -3.2998302459716797e+01 2.0110498428344727e+01 -5.2329101562500000e+01 -3.2130302429199219e+01 -3.4909000396728516e+01 -6.1349498748779297e+01 -3.2137401580810547e+01 -1.5252799987792969e+01 -3.8747798919677734e+01 -3.2020099639892578e+01 4.9141799926757812e+01 2.8352600097656250e+01 -3.2989597320556641e+01 4.3039199829101562e+01 1.5969698905944824e+01 -3.3055599212646484e+01 4.7725498199462891e+01 3.9991699218750000e+01 -3.3097698211669922e+01 3.0614299774169922e+01 4.8633197784423828e+01 -3.3084796905517578e+01 1.3720000267028809e+01 5.0044700622558594e+01 -3.3111999511718750e+01 -5.6227302551269531e+00 3.5953800201416016e+01 -3.3097698211669922e+01 -3.5078903198242188e+01 4.5476398468017578e+01 -3.3045200347900391e+01 -2.1894300460815430e+01 9.9145097732543945e+00 -3.3083801269531250e+01 -4.9431201934814453e+01 2.5745399475097656e+01 -3.3058502197265625e+01 -4.3290298461914062e+01 4.9954399108886719e+01 -6.5034202575683594e+01 5.4540300369262695e+00 4.8967998504638672e+01 -6.7537704467773438e+01 1.3350299835205078e+01 5.0034500122070312e+01 -6.7539604187011719e+01 -4.1453199386596680e+00 -3.3270900726318359e+01 -6.5033500671386719e+01 3.7523998260498047e+01 -4.3557899475097656e+01 -6.7537895202636719e+01 2.6049699783325195e+01 -2.8130199432373047e+01 -6.7539604187011719e+01 4.1621601104736328e+01 -4.9887100219726562e+01 -6.7539398193359375e+01 6.8354101181030273e+00 -4.7150398254394531e+01 -6.5031204223632812e+01 1.8047500610351562e+01 -4.0905799865722656e+01 -6.5034301757812500e+01 2.9103500366210938e+01 -9.2679700851440430e+00 -6.7539001464843750e+01 4.9685398101806641e+01 9.3136892318725586e+00 -6.7538703918457031e+01 4.9535301208496094e+01 2.6869998931884766e+01 -6.7538597106933594e+01 4.2637798309326172e+01 4.0471401214599609e+01 -6.7539604187011719e+01 2.9807500839233398e+01 4.8870899200439453e+01 -6.5032897949218750e+01 -1.3342700004577637e+01 2.4033800125122070e+01 -6.5031997680664062e+01 -4.4287799835205078e+01 3.8291000366210938e+01 -6.5033897399902344e+01 -3.2910102844238281e+01 4.7313400268554688e+01 -6.7535400390625000e+01 -1.8334699630737305e+01 -4.8967998504638672e+01 -6.7537704467773438e+01 -1.3350299835205078e+01 -6.9415998458862305e+00 -6.7539398193359375e+01 -4.9904800415039062e+01 3.7271400451660156e+01 -6.7538406372070312e+01 -3.3985900878906250e+01 2.5166799545288086e+01 -6.7537002563476562e+01 -4.3544601440429688e+01 1.0624900817871094e+01 -6.7538406372070312e+01 -4.9357997894287109e+01 -2.6072299957275391e+01 -6.7537796020507812e+01 -4.3274299621582031e+01 -4.0471401214599609e+01 -6.7539604187011719e+01 -2.9807500839233398e+01 1.2806200027465820e+01 -8.1073295593261719e+01 -3.8097999095916748e+00 1.3205300331115723e+01 -8.0267494201660156e+01 -5.5868902206420898e+00 1.3861199378967285e+01 -8.0269203186035156e+01 4.1422801017761230e+00 6.8685703277587891e+00 -8.0269203186035156e+01 -1.2765500068664551e+01 -3.6473600864410400e+00 -8.0430801391601562e+01 -1.3761699676513672e+01 -5.0008997917175293e+00 -8.1080497741699219e+01 1.2562399864196777e+01 6.8692898750305176e+00 -8.0268096923828125e+01 1.2766799926757812e+01 -2.6745600700378418e+00 -8.0267105102539062e+01 1.4119600296020508e+01 -1.0887900352478027e+01 -8.1082099914550781e+01 -8.1607704162597656e+00 -1.2876600265502930e+01 -8.1073501586914062e+01 3.7914199829101562e+00 -1.3522299766540527e+01 -8.0268005371093750e+01 -5.6108503341674805e+00 -1.2266799926757812e+01 -8.0268394470214844e+01 8.1145401000976562e+00 1.4918000221252441e+01 -8.0275100708007812e+01 -3.5685497283935547e+01 3.7123301029205322e+00 -8.0275100708007812e+01 -3.8456001281738281e+01 5.6025695800781250e+00 -6.7521499633789062e+01 -3.8081703186035156e+01 1.6305999755859375e+01 -6.7521499633789062e+01 -3.5007499694824219e+01 3.6341297149658203e+01 -6.7521499633789062e+01 -1.3186100006103516e+01 3.0869201660156250e+01 -8.0274299621582031e+01 -2.3010200500488281e+01 2.9183500289916992e+01 -6.7522102355957031e+01 -2.5193401336669922e+01 2.3136499404907227e+01 -8.0274299621582031e+01 -3.0677999496459961e+01 3.8549598693847656e+01 -8.0275100708007812e+01 -1.6160999536514282e+00 3.7004398345947266e+01 -8.0275100708007812e+01 -1.1183599472045898e+01 3.8620300292968750e+01 -6.7521499633789062e+01 8.1181198358535767e-01 -4.5067396163940430e+00 -6.7521499633789062e+01 -3.8375400543212891e+01 2.5930200576782227e+01 -8.0275100708007812e+01 2.8557600021362305e+01 3.1677902221679688e+01 -8.0274200439453125e+01 2.1873998641967773e+01 3.1033300399780273e+01 -6.7523498535156250e+01 2.2732900619506836e+01 2.0160699844360352e+01 -6.7523300170898438e+01 3.2750801086425781e+01 6.2813601493835449e+00 -6.7521499633789062e+01 3.8171100616455078e+01 1.6532600402832031e+01 -8.0275100708007812e+01 3.4899303436279297e+01 3.7707702636718750e+01 -8.0275100708007812e+01 8.4654598236083984e+00 3.6223800659179688e+01 -6.7521499633789062e+01 1.2949000358581543e+01 5.2079100608825684e+00 -8.0275100708007812e+01 3.8213302612304688e+01 -3.4080798625946045e+00 -8.0275100708007812e+01 3.8494800567626953e+01 -3.7614700317382812e+01 -8.0275100708007812e+01 9.4110794067382812e+00 -1.6054100036621094e+01 -8.0275100708007812e+01 -3.5240402221679688e+01 -5.2079100608825684e+00 -8.0275100708007812e+01 -3.8213302612304688e+01 -3.8329299926757812e+01 -8.0275100708007812e+01 -5.8210501670837402e+00 -3.2840499877929688e+01 -8.0274406433105469e+01 -1.9909101486206055e+01 -2.6819799423217773e+01 -8.0275001525878906e+01 -2.7747999191284180e+01 -1.7555700302124023e+01 -8.0275001525878906e+01 3.4412902832031250e+01 -3.1601600646972656e+01 -8.0274200439453125e+01 2.1895799636840820e+01 -2.5230501174926758e+01 -8.0274902343750000e+01 2.9101999282836914e+01 -3.3142398834228516e+01 -6.7523193359375000e+01 -1.9787399291992188e+01 -2.4508100509643555e+01 -6.7522598266601562e+01 -2.9667200088500977e+01 -3.8129898071289062e+01 -6.7521499633789062e+01 6.3573803901672363e+00 -3.7880397796630859e+01 -6.7521499633789062e+01 -7.4131999015808105e+00 -1.6590700149536133e+01 -6.7521499633789062e+01 -3.4709499359130859e+01 -2.8872499465942383e+01 -6.7521804809570312e+01 2.5504301071166992e+01 -1.9341501235961914e+01 -6.7523002624511719e+01 3.3339103698730469e+01 -3.4695800781250000e+01 -6.7521499633789062e+01 1.6600400924682617e+01 -7.6062998771667480e+00 -6.7521499633789062e+01 3.7799701690673828e+01 -4.9609901428222656e+01 -3.0460399627685547e+01 8.1507596969604492e+00 -4.9868400573730469e+01 -3.0460399627685547e+01 -6.8321399688720703e+00 -4.9947601318359375e+01 -3.2965702056884766e+01 -5.4530901908874512e+00 -4.4943298339843750e+01 -3.0460399627685547e+01 2.2791400909423828e+01 -3.5167198181152344e+01 -3.0460399627685547e+01 3.5853599548339844e+01 -4.9730598449707031e+01 -3.2965702056884766e+01 6.7970499992370605e+00 2.9969398975372314e+00 -3.2965702056884766e+01 5.0145702362060547e+01 6.9386696815490723e+00 -3.0460399627685547e+01 4.9888397216796875e+01 4.8833702087402344e+01 -3.0460399627685547e+01 1.3304400444030762e+01 4.0471401214599609e+01 -3.0460399627685547e+01 2.9807500839233398e+01 4.9868400573730469e+01 -3.0460399627685547e+01 -6.8321399688720703e+00 2.5877500534057617e+01 -3.0460399627685547e+01 4.3248897552490234e+01 2.9460500717163086e+01 -3.2965702056884766e+01 4.0491600036621094e+01 -1.0601699829101562e+01 -3.0460399627685547e+01 4.9272800445556641e+01 -2.4852701187133789e+01 -3.0460399627685547e+01 4.3484500885009766e+01 -2.9969398975372314e+00 -3.2965702056884766e+01 -5.0145702362060547e+01 -4.6939998626708984e+01 -3.2965702056884766e+01 -1.7957401275634766e+01 4.3438598632812500e+01 -3.0460399627685547e+01 -2.5998600006103516e+01 -2.4852701187133789e+01 -3.0460399627685547e+01 -4.3484500885009766e+01 -1.0601699829101562e+01 -3.0460399627685547e+01 -4.9272800445556641e+01 1.7176401138305664e+01 -3.0460399627685547e+01 -4.7315002441406250e+01 3.1059000015258789e+01 -3.0460399627685547e+01 -3.9376998901367188e+01 2.9829699993133545e+00 -3.0460399627685547e+01 -5.0146999359130859e+01 -3.5167198181152344e+01 -3.0460399627685547e+01 -3.5853599548339844e+01 -4.4943298339843750e+01 -3.0460399627685547e+01 -2.2791400909423828e+01 -1.1755400657653809e+01 -8.1032798767089844e+01 1.1027499437332153e+00 1.0264200210571289e+01 -2.9614400863647461e+01 2.9392998218536377e+00 1.0690099716186523e+01 -4.1044399261474609e+01 0.0000000000000000e+00 8.1825199127197266e+00 -2.9608499526977539e+01 6.8735299110412598e+00 5.0151400566101074e+00 -2.9599399566650391e+01 9.4172601699829102e+00 -6.3304600715637207e+00 -2.9442100524902344e+01 -1.2118599891662598e+01 -5.5505099296569824e+00 -2.9454700469970703e+01 1.2124200820922852e+01 -1.3189299583435059e+01 -2.9452299118041992e+01 -2.1639201641082764e+00 -1.1655500411987305e+01 -2.9457300186157227e+01 6.2997603416442871e+00 6.3305301666259766e+00 -2.9442100524902344e+01 1.2118599891662598e+01 1.3189299583435059e+01 -2.9452299118041992e+01 2.1639201641082764e+00 1.2706499099731445e+01 -3.0459199905395508e+01 -6.5114102363586426e+00 3.8211998939514160e+00 -3.0459899902343750e+01 -1.4019599914550781e+01 -3.8208501338958740e+00 -3.0458499908447266e+01 1.4018300056457520e+01 8.3117198944091797e+00 -3.0458000183105469e+01 1.1874300003051758e+01 1.4127900123596191e+01 -3.0459999084472656e+01 3.0538599491119385e+00 -1.2706499099731445e+01 -3.0459199905395508e+01 6.5114398002624512e+00 -8.3115901947021484e+00 -3.0458000183105469e+01 -1.1874400138854980e+01 -1.4127199172973633e+01 -3.0459199905395508e+01 -3.0536701679229736e+00 )) mat)))
                  )
                 ))
      (send glv :transform local-cds)
      (send glv :calc-normals)
      (setq qhull
            ;; qhull 3000 -> 81 faces
            (instance faceset :init :faces (list
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1677901744842529e+01 -8.0274201929569244e+01 2.1873999387025833e+01) (float-vector 1.6532599925994873e+01 -8.0275103449821472e+01 3.4899301826953888e+01) (float-vector 1.5174100175499916e+01 -6.5649501979351044e+01 6.8473696708679199e+01) (float-vector 4.3375499546527863e+01 -6.5742902457714081e+01 5.4680000990629196e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.7057100087404251e+01 -5.4977700114250183e+01 7.3550097644329071e+01) (float-vector 3.0671700835227966e+01 -4.3021898716688156e+01 7.2120100259780884e+01) (float-vector 4.4562898576259613e+01 -4.3020900338888168e+01 6.4476996660232544e+01) (float-vector 5.6477800011634827e+01 -4.8932299017906189e+01 5.5839899927377701e+01) (float-vector 4.2892999947071075e+01 -6.0733798891305923e+01 6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.6477800011634827e+01 -4.8932299017906189e+01 5.5839899927377701e+01) (float-vector 6.6686600446701050e+01 -4.8934601247310638e+01 4.3129801750183105e+01) (float-vector 6.4126297831535339e+01 -6.0734100639820099e+01 3.9661299437284470e+01) (float-vector 4.3375499546527863e+01 -6.5742902457714081e+01 5.4680000990629196e+01) (float-vector 4.2892999947071075e+01 -6.0733798891305923e+01 6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.1731800884008408e+01 -4.9571000039577484e+01 -6.7475102841854095e+01) (float-vector 2.7057100087404251e+01 -4.3022301048040390e+01 -7.3550097644329071e+01) (float-vector 3.4459200105629861e-01 -4.9045100808143616e+01 -7.9383298754692078e+01) (float-vector 1.2114600278437138e+01 -5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector 3.0671700835227966e+01 -5.4978098720312119e+01 -7.2120100259780884e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7341399798169732e+00 -3.8391999900341034e+01 -7.6071098446846008e+01) (float-vector -1.2114600278437138e+01 -3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector 3.4459200105629861e-01 -4.9045100808143616e+01 -7.9383298754692078e+01) (float-vector 2.7057100087404251e+01 -4.3022301048040390e+01 -7.3550097644329071e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.7614699453115463e+01 -8.0275103449821472e+01 9.4110798090696335e+00) (float-vector -6.7285202443599701e+01 -6.5753698348999023e+01 1.7788499593734741e+01) (float-vector -7.0040397346019745e+01 -5.9613000601530075e+01 2.9782500118017197e+01) (float-vector -6.2013100832700729e+01 -6.0733798891305923e+01 4.2892999947071075e+01) (float-vector -4.9207698553800583e+01 -6.5768599510192871e+01 4.9181401729583740e+01) (float-vector -2.5230500847101212e+01 -8.0274902284145355e+01 2.9101999476552010e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3129801750183105e+01 -4.8934601247310638e+01 6.6686600446701050e+01) (float-vector -3.9661299437284470e+01 -6.0734100639820099e+01 6.4126297831535339e+01) (float-vector -4.9207698553800583e+01 -6.5768599510192871e+01 4.9181401729583740e+01) (float-vector -6.2013100832700729e+01 -6.0733798891305923e+01 4.2892999947071075e+01) (float-vector -5.4402600973844528e+01 -4.9551699310541153e+01 5.7758700102567673e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.9661299437284470e+01 -6.0734100639820099e+01 6.4126297831535339e+01) (float-vector -4.3129801750183105e+01 -4.8934601247310638e+01 6.6686600446701050e+01) (float-vector -2.7057100087404251e+01 -4.3022301048040390e+01 7.3550097644329071e+01) (float-vector -1.4203500002622604e+01 -4.8949200659990311e+01 7.8114800155162811e+01) (float-vector -2.6272999122738838e+01 -5.9612501412630081e+01 7.1428798139095306e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.2892999947071075e+01 -3.7266198545694351e+01 6.2013100832700729e+01) (float-vector -5.3850099444389343e+01 -3.6490198224782944e+01 5.2007101476192474e+01) (float-vector -5.6481499224901199e+01 -3.2248001545667648e+01 4.0725000202655792e+01) (float-vector -4.3375499546527863e+01 -3.2257098704576492e+01 5.4680000990629196e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.6819799095392227e+01 -8.0274999141693115e+01 -2.7747999876737595e+01) (float-vector -3.7614699453115463e+01 -8.0275103449821472e+01 9.4110798090696335e+00) (float-vector -2.5230500847101212e+01 -8.0274902284145355e+01 2.9101999476552010e+01) (float-vector -3.4080799669027328e+00 -8.0275103449821472e+01 3.8494799286127090e+01) (float-vector 1.6532599925994873e+01 -8.0275103449821472e+01 3.4899301826953888e+01) (float-vector 3.1677901744842529e+01 -8.0274201929569244e+01 2.1873999387025833e+01) (float-vector 3.7004400044679642e+01 -8.0275103449821472e+01 -1.1183599941432476e+01) (float-vector 2.3136500269174576e+01 -8.0274298787117004e+01 -3.0678000301122665e+01) (float-vector -5.2079102024435997e+00 -8.0275103449821472e+01 -3.8213301450014114e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.7057100087404251e+01 -5.4977700114250183e+01 7.3550097644329071e+01) (float-vector 1.7341399798169732e+00 -5.9608001261949539e+01 7.6071098446846008e+01) (float-vector 3.4459200105629861e-01 -4.8954900354146957e+01 7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7341399798169732e+00 -5.9608001261949539e+01 7.6071098446846008e+01) (float-vector 2.7057100087404251e+01 -5.4977700114250183e+01 7.3550097644329071e+01) (float-vector 4.2892999947071075e+01 -6.0733798891305923e+01 6.2013100832700729e+01) (float-vector 4.3375499546527863e+01 -6.5742902457714081e+01 5.4680000990629196e+01) (float-vector 1.5174100175499916e+01 -6.5649501979351044e+01 6.8473696708679199e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7341399798169732e+00 -5.9608001261949539e+01 7.6071098446846008e+01) (float-vector 1.5174100175499916e+01 -6.5649501979351044e+01 6.8473696708679199e+01) (float-vector 1.6532599925994873e+01 -8.0275103449821472e+01 3.4899301826953888e+01) (float-vector -3.4080799669027328e+00 -8.0275103449821472e+01 3.8494799286127090e+01) (float-vector -2.1015599370002747e+01 -6.5753698348999023e+01 6.6359199583530426e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.9661299437284470e+01 -6.0734100639820099e+01 6.4126297831535339e+01) (float-vector -2.6272999122738838e+01 -5.9612501412630081e+01 7.1428798139095306e+01) (float-vector -2.1015599370002747e+01 -6.5753698348999023e+01 6.6359199583530426e+01) (float-vector -3.4080799669027328e+00 -8.0275103449821472e+01 3.8494799286127090e+01) (float-vector -2.5230500847101212e+01 -8.0274902284145355e+01 2.9101999476552010e+01) (float-vector -4.9207698553800583e+01 -6.5768599510192871e+01 4.9181401729583740e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.4459200105629861e-01 -4.8954900354146957e+01 7.9383298754692078e+01) (float-vector 1.7341399798169732e+00 -5.9608001261949539e+01 7.6071098446846008e+01) (float-vector -2.1015599370002747e+01 -6.5753698348999023e+01 6.6359199583530426e+01) (float-vector -2.6272999122738838e+01 -5.9612501412630081e+01 7.1428798139095306e+01) (float-vector -1.4203500002622604e+01 -4.8949200659990311e+01 7.8114800155162811e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.3644801974296570e+01 -4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector 7.4474796652793884e+01 -5.9610601514577866e+01 -1.5645200386643410e+01) (float-vector 7.9383201897144318e+01 -4.8954900354146957e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.2892999947071075e+01 -3.7266198545694351e+01 -6.2013100832700729e+01) (float-vector 5.6185498833656311e+01 -3.2231498509645462e+01 -4.1026100516319275e+01) (float-vector 1.5174100175499916e+01 -3.2350499182939529e+01 -6.8473696708679199e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.2892999947071075e+01 -3.7266198545694351e+01 -6.2013100832700729e+01) (float-vector 2.7057100087404251e+01 -4.3022301048040390e+01 -7.3550097644329071e+01) (float-vector 4.1731800884008408e+01 -4.9571000039577484e+01 -6.7475102841854095e+01) (float-vector 5.3966101258993149e+01 -4.3021600693464279e+01 -5.6843299418687820e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.5174100175499916e+01 -3.2350499182939529e+01 -6.8473696708679199e+01) (float-vector 1.7341399798169732e+00 -3.8391999900341034e+01 -7.6071098446846008e+01) (float-vector 2.7057100087404251e+01 -4.3022301048040390e+01 -7.3550097644329071e+01) (float-vector 4.2892999947071075e+01 -3.7266198545694351e+01 -6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.4459200105629861e-01 -4.8954900354146957e+01 7.9383298754692078e+01) (float-vector 1.7856500344350934e+00 -4.3026499450206757e+01 7.8329898416996002e+01) (float-vector 3.0671700835227966e+01 -4.3021898716688156e+01 7.2120100259780884e+01) (float-vector 2.7057100087404251e+01 -5.4977700114250183e+01 7.3550097644329071e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6686600446701050e+01 -4.8934601247310638e+01 4.3129801750183105e+01) (float-vector 6.2013100832700729e+01 -3.7266198545694351e+01 4.2892999947071075e+01) (float-vector 7.3550097644329071e+01 -4.3022301048040390e+01 2.7057100087404251e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.2013100832700729e+01 -3.7266198545694351e+01 4.2892999947071075e+01) (float-vector 5.9105001389980316e+01 -3.2233700156211853e+01 3.6562200635671616e+01) (float-vector 7.1366399526596069e+01 -3.4439001232385635e+01 1.3268600217998028e+01) (float-vector 7.3550097644329071e+01 -4.3022301048040390e+01 2.7057100087404251e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.2013100832700729e+01 -3.7266198545694351e+01 4.2892999947071075e+01) (float-vector 6.6686600446701050e+01 -4.8934601247310638e+01 4.3129801750183105e+01) (float-vector 5.6477800011634827e+01 -4.8932299017906189e+01 5.5839899927377701e+01) (float-vector 4.4562898576259613e+01 -4.3020900338888168e+01 6.4476996660232544e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.3644801974296570e+01 -4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector 7.9383201897144318e+01 -4.8954900354146957e+01 -3.4461999894119799e-01) (float-vector 7.5355298817157745e+01 -3.7268400192260742e+01 1.7170599894598126e+00) (float-vector 7.1428798139095306e+01 -3.8387499749660492e+01 -2.6272999122738838e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.1366399526596069e+01 -3.4439001232385635e+01 1.3268600217998028e+01) (float-vector 7.5355298817157745e+01 -3.7268400192260742e+01 1.7170599894598126e+00) (float-vector 7.9383201897144318e+01 -4.8954900354146957e+01 -3.4461999894119799e-01) (float-vector 7.3550097644329071e+01 -4.3022301048040390e+01 2.7057100087404251e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.6185498833656311e+01 -6.5768502652645111e+01 -4.1026100516319275e+01) (float-vector -7.1374498307704926e+01 -6.3563100993633270e+01 -1.3211200013756752e+01) (float-vector -6.7285202443599701e+01 -6.5753698348999023e+01 1.7788499593734741e+01) (float-vector -3.7614699453115463e+01 -8.0275103449821472e+01 9.4110798090696335e+00) (float-vector -2.6819799095392227e+01 -8.0274999141693115e+01 -2.7747999876737595e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.3850099444389343e+01 -6.1509799212217331e+01 -5.2007101476192474e+01) (float-vector -5.6185498833656311e+01 -6.5768502652645111e+01 -4.1026100516319275e+01) (float-vector -2.6819799095392227e+01 -8.0274999141693115e+01 -2.7747999876737595e+01) (float-vector -4.1918899863958359e+01 -6.5744303166866302e+01 -5.5662799626588821e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.2079102024435997e+00 -8.0275103449821472e+01 -3.8213301450014114e+01) (float-vector -4.8838402144610882e+00 -6.5753698348999023e+01 -6.9384098052978516e+01) (float-vector -2.9782500118017197e+01 -5.9613000601530075e+01 -7.0040397346019745e+01) (float-vector -4.1918899863958359e+01 -6.5744303166866302e+01 -5.5662799626588821e+01) (float-vector -2.6819799095392227e+01 -8.0274999141693115e+01 -2.7747999876737595e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.2114600278437138e+01 -5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector 2.5049600750207901e+01 -6.3557997345924377e+01 -6.8122602999210358e+01) (float-vector 3.0671700835227966e+01 -5.4978098720312119e+01 -7.2120100259780884e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.1731800884008408e+01 -4.9571000039577484e+01 -6.7475102841854095e+01) (float-vector 3.0671700835227966e+01 -5.4978098720312119e+01 -7.2120100259780884e+01) (float-vector 2.5049600750207901e+01 -6.3557997345924377e+01 -6.8122602999210358e+01) (float-vector 4.3921299278736115e+01 -6.5758101642131805e+01 -5.3944598883390427e+01) (float-vector 5.6843299418687820e+01 -5.4978400468826294e+01 -5.3966101258993149e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.3921299278736115e+01 -6.5758101642131805e+01 -5.3944598883390427e+01) (float-vector 2.5049600750207901e+01 -6.3557997345924377e+01 -6.8122602999210358e+01) (float-vector 1.2114600278437138e+01 -5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector -4.8838402144610882e+00 -6.5753698348999023e+01 -6.9384098052978516e+01) (float-vector -5.2079102024435997e+00 -8.0275103449821472e+01 -3.8213301450014114e+01) (float-vector 2.3136500269174576e+01 -8.0274298787117004e+01 -3.0678000301122665e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3375499546527863e+01 -3.2257098704576492e+01 5.4680000990629196e+01) (float-vector -5.6481499224901199e+01 -3.2248001545667648e+01 4.0725000202655792e+01) (float-vector -6.9488696753978729e+01 -3.2240301370620728e+01 1.4109100447967649e+00) (float-vector -5.8180298656225204e+01 -3.2244600355625153e+01 -3.8144998252391815e+01) (float-vector -3.9661098271608353e+01 -3.2244000583887100e+01 -5.7238798588514328e+01) (float-vector 2.7445200830698013e+00 -2.9418099671602249e+01 -1.2800700031220913e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.9661098271608353e+01 -3.2244000583887100e+01 -5.7238798588514328e+01) (float-vector -5.8180298656225204e+01 -3.2244600355625153e+01 -3.8144998252391815e+01) (float-vector -6.6670998930931091e+01 -4.3021000921726227e+01 -4.1205700486898422e+01) (float-vector -5.5839899927377701e+01 -4.9067698419094086e+01 -5.6477800011634827e+01) (float-vector -4.3129801750183105e+01 -4.9065399914979935e+01 -6.6686600446701050e+01) (float-vector -3.9661299437284470e+01 -3.7265900522470474e+01 -6.4126297831535339e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.1015599370002747e+01 -3.2246299088001251e+01 -6.6359199583530426e+01) (float-vector 1.5174100175499916e+01 -3.2350499182939529e+01 -6.8473696708679199e+01) (float-vector 5.6185498833656311e+01 -3.2231498509645462e+01 -4.1026100516319275e+01) (float-vector 2.7445200830698013e+00 -2.9418099671602249e+01 -1.2800700031220913e+01) (float-vector -3.9661098271608353e+01 -3.2244000583887100e+01 -5.7238798588514328e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.1015599370002747e+01 -3.2246299088001251e+01 -6.6359199583530426e+01) (float-vector -1.2114600278437138e+01 -3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector 1.7341399798169732e+00 -3.8391999900341034e+01 -7.6071098446846008e+01) (float-vector 1.5174100175499916e+01 -3.2350499182939529e+01 -6.8473696708679199e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.1015599370002747e+01 -3.2246299088001251e+01 -6.6359199583530426e+01) (float-vector -3.9661098271608353e+01 -3.2244000583887100e+01 -5.7238798588514328e+01) (float-vector -3.9661299437284470e+01 -3.7265900522470474e+01 -6.4126297831535339e+01) (float-vector -1.2114600278437138e+01 -3.8389999419450760e+01 -7.5127199292182922e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -6.7285202443599701e+01 -6.5753698348999023e+01 1.7788499593734741e+01) (float-vector -7.5355298817157745e+01 -6.0731600970029831e+01 1.7170599894598126e+00) (float-vector -7.0040397346019745e+01 -5.9613000601530075e+01 2.9782500118017197e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.5355298817157745e+01 -6.0731600970029831e+01 1.7170599894598126e+00) (float-vector -6.7285202443599701e+01 -6.5753698348999023e+01 1.7788499593734741e+01) (float-vector -7.1374498307704926e+01 -6.3563100993633270e+01 -1.3211200013756752e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.5839899927377701e+01 -4.9067698419094086e+01 -5.6477800011634827e+01) (float-vector -6.4476996660232544e+01 -5.4979100823402405e+01 -4.4562898576259613e+01) (float-vector -5.3850099444389343e+01 -6.1509799212217331e+01 -5.2007101476192474e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.3644801974296570e+01 -4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector -6.4476996660232544e+01 -5.4979100823402405e+01 -4.4562898576259613e+01) (float-vector -5.5839899927377701e+01 -4.9067698419094086e+01 -5.6477800011634827e+01) (float-vector -6.6670998930931091e+01 -4.3021000921726227e+01 -4.1205700486898422e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.3951698839664459e+01 -4.9059398472309113e+01 2.8930399566888809e+01) (float-vector -7.0040397346019745e+01 -5.9613000601530075e+01 2.9782500118017197e+01) (float-vector -7.5355298817157745e+01 -6.0731600970029831e+01 1.7170599894598126e+00) (float-vector -7.9383201897144318e+01 -4.9045100808143616e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6686600446701050e+01 -4.8934601247310638e+01 4.3129801750183105e+01) (float-vector 7.2120100259780884e+01 -5.4978098720312119e+01 3.0671700835227966e+01) (float-vector 6.4126297831535339e+01 -6.0734100639820099e+01 3.9661299437284470e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.5127199292182922e+01 -5.9610001742839813e+01 1.2114600278437138e+01) (float-vector 7.2120100259780884e+01 -5.4978098720312119e+01 3.0671700835227966e+01) (float-vector 6.6686600446701050e+01 -4.8934601247310638e+01 4.3129801750183105e+01) (float-vector 7.3550097644329071e+01 -4.3022301048040390e+01 2.7057100087404251e+01) (float-vector 7.9383201897144318e+01 -4.8954900354146957e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.4474796652793884e+01 -5.9610601514577866e+01 -1.5645200386643410e+01) (float-vector 6.9488696753978729e+01 -6.5759703516960144e+01 1.4109000330790877e+00) (float-vector 7.5127199292182922e+01 -5.9610001742839813e+01 1.2114600278437138e+01) (float-vector 7.9383201897144318e+01 -4.8954900354146957e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.4476996660232544e+01 -4.3020900338888168e+01 -4.4562898576259613e+01) (float-vector 6.6202603280544281e+01 -4.8934098333120346e+01 -4.3869800865650177e+01) (float-vector 7.3644801974296570e+01 -4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector 7.1428798139095306e+01 -3.8387499749660492e+01 -2.6272999122738838e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6202603280544281e+01 -4.8934098333120346e+01 -4.3869800865650177e+01) (float-vector 6.4476996660232544e+01 -4.3020900338888168e+01 -4.4562898576259613e+01) (float-vector 5.3966101258993149e+01 -4.3021600693464279e+01 -5.6843299418687820e+01) (float-vector 4.1731800884008408e+01 -4.9571000039577484e+01 -6.7475102841854095e+01) (float-vector 5.6843299418687820e+01 -5.4978400468826294e+01 -5.3966101258993149e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.1428798139095306e+01 -3.8387499749660492e+01 -2.6272999122738838e+01) (float-vector 5.6185498833656311e+01 -3.2231498509645462e+01 -4.1026100516319275e+01) (float-vector 4.2892999947071075e+01 -3.7266198545694351e+01 -6.2013100832700729e+01) (float-vector 5.3966101258993149e+01 -4.3021600693464279e+01 -5.6843299418687820e+01) (float-vector 6.4476996660232544e+01 -4.3020900338888168e+01 -4.4562898576259613e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 -3.2246299088001251e+01 -2.1015599370002747e+01) (float-vector 5.6185498833656311e+01 -3.2231498509645462e+01 -4.1026100516319275e+01) (float-vector 7.1428798139095306e+01 -3.8387499749660492e+01 -2.6272999122738838e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 -3.2246299088001251e+01 -2.1015599370002747e+01) (float-vector 7.1366399526596069e+01 -3.4439001232385635e+01 1.3268600217998028e+01) (float-vector 5.9105001389980316e+01 -3.2233700156211853e+01 3.6562200635671616e+01) (float-vector 2.7445200830698013e+00 -2.9418099671602249e+01 -1.2800700031220913e+01) (float-vector 5.6185498833656311e+01 -3.2231498509645462e+01 -4.1026100516319275e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.1366399526596069e+01 -3.4439001232385635e+01 1.3268600217998028e+01) (float-vector 6.6359199583530426e+01 -3.2246299088001251e+01 -2.1015599370002747e+01) (float-vector 7.1428798139095306e+01 -3.8387499749660492e+01 -2.6272999122738838e+01) (float-vector 7.5355298817157745e+01 -3.7268400192260742e+01 1.7170599894598126e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.5645200386643410e+01 -5.9610601514577866e+01 -7.4474796652793884e+01) (float-vector -2.9782500118017197e+01 -5.9613000601530075e+01 -7.0040397346019745e+01) (float-vector -4.8838402144610882e+00 -6.5753698348999023e+01 -6.9384098052978516e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.5645200386643410e+01 -5.9610601514577866e+01 -7.4474796652793884e+01) (float-vector -4.8838402144610882e+00 -6.5753698348999023e+01 -6.9384098052978516e+01) (float-vector 1.2114600278437138e+01 -5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector 3.4459200105629861e-01 -4.9045100808143616e+01 -7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.4474796652793884e+01 -3.8389399647712708e+01 -1.5645200386643410e+01) (float-vector -5.8180298656225204e+01 -3.2244600355625153e+01 -3.8144998252391815e+01) (float-vector -6.9488696753978729e+01 -3.2240301370620728e+01 1.4109100447967649e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.4474796652793884e+01 -3.8389399647712708e+01 -1.5645200386643410e+01) (float-vector -7.3644801974296570e+01 -4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector -6.6670998930931091e+01 -4.3021000921726227e+01 -4.1205700486898422e+01) (float-vector -5.8180298656225204e+01 -3.2244600355625153e+01 -3.8144998252391815e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.3850099444389343e+01 -6.1509799212217331e+01 -5.2007101476192474e+01) (float-vector -6.4476996660232544e+01 -5.4979100823402405e+01 -4.4562898576259613e+01) (float-vector -7.3644801974296570e+01 -4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector -7.6686702668666840e+01 -5.4976001381874084e+01 -1.6111699864268303e+01) (float-vector -7.1374498307704926e+01 -6.3563100993633270e+01 -1.3211200013756752e+01) (float-vector -5.6185498833656311e+01 -6.5768502652645111e+01 -4.1026100516319275e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.9383201897144318e+01 -4.9045100808143616e+01 -3.4461999894119799e-01) (float-vector -7.6686702668666840e+01 -5.4976001381874084e+01 -1.6111699864268303e+01) (float-vector -7.3644801974296570e+01 -4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector -7.4474796652793884e+01 -3.8389399647712708e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.1374498307704926e+01 -6.3563100993633270e+01 -1.3211200013756752e+01) (float-vector -7.6686702668666840e+01 -5.4976001381874084e+01 -1.6111699864268303e+01) (float-vector -7.9383201897144318e+01 -4.9045100808143616e+01 -3.4461999894119799e-01) (float-vector -7.5355298817157745e+01 -6.0731600970029831e+01 1.7170599894598126e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.0040397346019745e+01 -5.9613000601530075e+01 2.9782500118017197e+01) (float-vector -7.3951698839664459e+01 -4.9059398472309113e+01 2.8930399566888809e+01) (float-vector -6.4476996660232544e+01 -4.3020900338888168e+01 4.4562898576259613e+01) (float-vector -5.4402600973844528e+01 -4.9551699310541153e+01 5.7758700102567673e+01) (float-vector -6.2013100832700729e+01 -6.0733798891305923e+01 4.2892999947071075e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.2892999947071075e+01 -3.7266198545694351e+01 6.2013100832700729e+01) (float-vector -2.7057100087404251e+01 -4.3022301048040390e+01 7.3550097644329071e+01) (float-vector -4.3129801750183105e+01 -4.8934601247310638e+01 6.6686600446701050e+01) (float-vector -5.4402600973844528e+01 -4.9551699310541153e+01 5.7758700102567673e+01) (float-vector -6.4476996660232544e+01 -4.3020900338888168e+01 4.4562898576259613e+01) (float-vector -5.3850099444389343e+01 -3.6490198224782944e+01 5.2007101476192474e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 -6.5753698348999023e+01 -2.1015599370002747e+01) (float-vector 6.9488696753978729e+01 -6.5759703516960144e+01 1.4109000330790877e+00) (float-vector 7.4474796652793884e+01 -5.9610601514577866e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.9488696753978729e+01 -6.5759703516960144e+01 1.4109000330790877e+00) (float-vector 6.7513503134250641e+01 -6.3559398055076599e+01 2.6707200333476067e+01) (float-vector 7.5127199292182922e+01 -5.9610001742839813e+01 1.2114600278437138e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.7513503134250641e+01 -6.3559398055076599e+01 2.6707200333476067e+01) (float-vector 6.9488696753978729e+01 -6.5759703516960144e+01 1.4109000330790877e+00) (float-vector 6.6359199583530426e+01 -6.5753698348999023e+01 -2.1015599370002747e+01) (float-vector 3.7004400044679642e+01 -8.0275103449821472e+01 -1.1183599941432476e+01) (float-vector 3.1677901744842529e+01 -8.0274201929569244e+01 2.1873999387025833e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.7513503134250641e+01 -6.3559398055076599e+01 2.6707200333476067e+01) (float-vector 6.4126297831535339e+01 -6.0734100639820099e+01 3.9661299437284470e+01) (float-vector 7.2120100259780884e+01 -5.4978098720312119e+01 3.0671700835227966e+01) (float-vector 7.5127199292182922e+01 -5.9610001742839813e+01 1.2114600278437138e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.4126297831535339e+01 -6.0734100639820099e+01 3.9661299437284470e+01) (float-vector 6.7513503134250641e+01 -6.3559398055076599e+01 2.6707200333476067e+01) (float-vector 3.1677901744842529e+01 -8.0274201929569244e+01 2.1873999387025833e+01) (float-vector 4.3375499546527863e+01 -6.5742902457714081e+01 5.4680000990629196e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3375499546527863e+01 -3.2257098704576492e+01 5.4680000990629196e+01) (float-vector -1.5174100175499916e+01 -3.2350499182939529e+01 6.8473696708679199e+01) (float-vector -2.7057100087404251e+01 -4.3022301048040390e+01 7.3550097644329071e+01) (float-vector -4.2892999947071075e+01 -3.7266198545694351e+01 6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.4562898576259613e+01 -4.3020900338888168e+01 6.4476996660232544e+01) (float-vector 3.0671700835227966e+01 -4.3021898716688156e+01 7.2120100259780884e+01) (float-vector 2.1015599370002747e+01 -3.2246299088001251e+01 6.6359199583530426e+01) (float-vector 3.6946401000022888e+01 -3.2240901142358780e+01 5.8903798460960388e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.6946401000022888e+01 -3.2240901142358780e+01 5.8903798460960388e+01) (float-vector 5.9105001389980316e+01 -3.2233700156211853e+01 3.6562200635671616e+01) (float-vector 6.2013100832700729e+01 -3.7266198545694351e+01 4.2892999947071075e+01) (float-vector 4.4562898576259613e+01 -4.3020900338888168e+01 6.4476996660232544e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.2114600278437138e+01 -3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector -2.8930399566888809e+01 -4.9059398472309113e+01 -7.3951698839664459e+01) (float-vector 3.4459200105629861e-01 -4.9045100808143616e+01 -7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3129801750183105e+01 -4.9065399914979935e+01 -6.6686600446701050e+01) (float-vector -2.8930399566888809e+01 -4.9059398472309113e+01 -7.3951698839664459e+01) (float-vector -1.2114600278437138e+01 -3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector -3.9661299437284470e+01 -3.7265900522470474e+01 -6.4126297831535339e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.8930399566888809e+01 -4.9059398472309113e+01 -7.3951698839664459e+01) (float-vector -2.9782500118017197e+01 -5.9613000601530075e+01 -7.0040397346019745e+01) (float-vector -1.5645200386643410e+01 -5.9610601514577866e+01 -7.4474796652793884e+01) (float-vector 3.4459200105629861e-01 -4.9045100808143616e+01 -7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.3850099444389343e+01 -6.1509799212217331e+01 -5.2007101476192474e+01) (float-vector -4.1918899863958359e+01 -6.5744303166866302e+01 -5.5662799626588821e+01) (float-vector -2.9782500118017197e+01 -5.9613000601530075e+01 -7.0040397346019745e+01) (float-vector -2.8930399566888809e+01 -4.9059398472309113e+01 -7.3951698839664459e+01) (float-vector -4.3129801750183105e+01 -4.9065399914979935e+01 -6.6686600446701050e+01) (float-vector -5.5839899927377701e+01 -4.9067698419094086e+01 -5.6477800011634827e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.6481499224901199e+01 -3.2248001545667648e+01 4.0725000202655792e+01) (float-vector -7.1428798139095306e+01 -3.8387499749660492e+01 2.6272999122738838e+01) (float-vector -6.9488696753978729e+01 -3.2240301370620728e+01 1.4109100447967649e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.1428798139095306e+01 -3.8387499749660492e+01 2.6272999122738838e+01) (float-vector -6.4476996660232544e+01 -4.3020900338888168e+01 4.4562898576259613e+01) (float-vector -7.3951698839664459e+01 -4.9059398472309113e+01 2.8930399566888809e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.1428798139095306e+01 -3.8387499749660492e+01 2.6272999122738838e+01) (float-vector -5.6481499224901199e+01 -3.2248001545667648e+01 4.0725000202655792e+01) (float-vector -5.3850099444389343e+01 -3.6490198224782944e+01 5.2007101476192474e+01) (float-vector -6.4476996660232544e+01 -4.3020900338888168e+01 4.4562898576259613e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -6.9488696753978729e+01 -3.2240301370620728e+01 1.4109100447967649e+00) (float-vector -7.1428798139095306e+01 -3.8387499749660492e+01 2.6272999122738838e+01) (float-vector -7.3951698839664459e+01 -4.9059398472309113e+01 2.8930399566888809e+01) (float-vector -7.9383201897144318e+01 -4.9045100808143616e+01 -3.4461999894119799e-01) (float-vector -7.4474796652793884e+01 -3.8389399647712708e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.6820500642061234e+01 -6.5761797130107880e+01 -4.0331300348043442e+01) (float-vector 5.6843299418687820e+01 -5.4978400468826294e+01 -5.3966101258993149e+01) (float-vector 4.3921299278736115e+01 -6.5758101642131805e+01 -5.3944598883390427e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 -6.5753698348999023e+01 -2.1015599370002747e+01) (float-vector 5.6820500642061234e+01 -6.5761797130107880e+01 -4.0331300348043442e+01) (float-vector 4.3921299278736115e+01 -6.5758101642131805e+01 -5.3944598883390427e+01) (float-vector 2.3136500269174576e+01 -8.0274298787117004e+01 -3.0678000301122665e+01) (float-vector 3.7004400044679642e+01 -8.0275103449821472e+01 -1.1183599941432476e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.3644801974296570e+01 -4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector 6.6202603280544281e+01 -4.8934098333120346e+01 -4.3869800865650177e+01) (float-vector 5.6843299418687820e+01 -5.4978400468826294e+01 -5.3966101258993149e+01) (float-vector 5.6820500642061234e+01 -6.5761797130107880e+01 -4.0331300348043442e+01) (float-vector 6.6359199583530426e+01 -6.5753698348999023e+01 -2.1015599370002747e+01) (float-vector 7.4474796652793884e+01 -5.9610601514577866e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.4203500002622604e+01 -4.8949200659990311e+01 7.8114800155162811e+01) (float-vector -2.7057100087404251e+01 -4.3022301048040390e+01 7.3550097644329071e+01) (float-vector -1.5174100175499916e+01 -3.2350499182939529e+01 6.8473696708679199e+01) (float-vector 5.1130601204931736e+00 -3.4403301775455475e+01 7.2644703090190887e+01) (float-vector 1.7856500344350934e+00 -4.3026499450206757e+01 7.8329898416996002e+01) (float-vector 3.4459200105629861e-01 -4.8954900354146957e+01 7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.1130601204931736e+00 -3.4403301775455475e+01 7.2644703090190887e+01) (float-vector 2.1015599370002747e+01 -3.2246299088001251e+01 6.6359199583530426e+01) (float-vector 3.0671700835227966e+01 -4.3021898716688156e+01 7.2120100259780884e+01) (float-vector 1.7856500344350934e+00 -4.3026499450206757e+01 7.8329898416996002e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.9105001389980316e+01 -3.2233700156211853e+01 3.6562200635671616e+01) (float-vector 3.6946401000022888e+01 -3.2240901142358780e+01 5.8903798460960388e+01) (float-vector 2.1015599370002747e+01 -3.2246299088001251e+01 6.6359199583530426e+01) (float-vector 5.1130601204931736e+00 -3.4403301775455475e+01 7.2644703090190887e+01) (float-vector -1.5174100175499916e+01 -3.2350499182939529e+01 6.8473696708679199e+01) (float-vector -4.3375499546527863e+01 -3.2257098704576492e+01 5.4680000990629196e+01) (float-vector 2.7445200830698013e+00 -2.9418099671602249e+01 -1.2800700031220913e+01)))))
              ))
             )
      (setq geom (instance collada-body :init :replace-obj qhull :name "bl_caster_l_wheel_link_geom0"))
      (when glv
        (setq (geom . gl::aglvertices) glv)
        (send geom :assoc glv))
      geom))
  (:_make_instance_bl_caster_r_wheel_link_geom0 ()
    (let (geom glv qhull
          (local-cds (make-coords :pos (float-vector 0.0000000000000000e+00 -4.9000000000000000e+01 0.0000000000000000e+00))))
      (setq glv
       (instance gl::glvertices :init
                 (list ;; mesh list
                  (list ;; mesh description
                   (list :type :triangles)
                   (list :material (list
                    (list :ambient (float-vector 0.000100 0.000100 0.000100 1.000000))
                    (list :diffuse (float-vector 0.000000 0.000000 0.000000 1.000000))))
                   (list :indices #i( 0 1 2 0 4 1 2 28 0 30 4 0 28 30 0 21 22 2 22 28 2 2 1 21 28 29 30 22 29 28 30 29 31 30 31 4 404 29 407 408 407 29 31 29 404 22 408 29 20 22 21 22 20 408 18 20 21 17 20 18 412 20 17 408 20 412 17 18 19 21 486 18 18 486 19 17 19 16 412 17 16 412 413 414 412 414 408 412 16 413 413 415 414 409 415 413 413 15 409 413 16 481 413 481 15 14 15 7 409 15 14 481 7 15 481 16 7 6 7 8 8 7 11 14 7 6 16 11 7 14 6 10 409 14 10 9 10 6 6 487 9 8 489 6 6 489 487 8 11 13 8 488 489 13 488 8 12 13 11 11 16 12 13 12 19 19 488 13 486 488 19 486 499 488 488 499 497 488 497 489 16 19 12 489 497 494 489 494 487 497 459 494 499 459 497 486 498 499 499 474 459 499 498 474 493 498 486 474 498 475 498 493 475 40 474 475 475 478 471 40 475 471 475 493 478 37 39 40 41 37 40 41 40 471 39 474 40 41 471 378 471 478 378 478 476 378 478 493 476 69 378 379 37 41 378 37 378 69 378 476 379 476 477 379 476 493 477 69 379 376 379 477 376 376 477 473 493 473 477 492 493 3 1 493 486 3 493 1 492 473 493 491 496 492 491 492 3 492 496 473 3 4 5 4 3 1 491 3 5 21 1 486 4 31 5 482 5 483 33 483 5 33 5 31 482 491 5 33 31 34 31 404 34 34 35 33 35 483 33 36 482 483 35 36 483 34 36 35 34 26 36 406 34 404 27 34 406 26 34 27 404 405 406 407 405 404 27 406 410 434 406 405 410 406 434 434 405 423 407 423 405 407 408 423 423 408 417 440 408 414 417 408 440 416 417 418 417 427 418 417 416 423 417 440 427 414 439 440 427 440 439 451 427 439 398 427 402 427 398 418 451 402 427 419 416 418 418 398 419 423 416 419 419 422 423 401 419 398 419 401 400 400 422 419 422 421 423 421 434 423 420 421 422 425 421 420 425 434 421 420 424 425 424 434 425 426 424 420 426 434 424 420 381 426 422 396 420 381 420 382 382 420 396 434 426 435 426 381 435 380 381 382 260 392 381 381 380 260 392 435 381 393 382 396 380 382 393 258 380 257 380 393 257 260 380 258 235 259 260 260 258 235 259 392 260 392 259 391 430 392 391 430 435 392 231 259 235 229 262 259 229 259 231 259 262 391 231 232 229 235 236 231 231 236 232 232 237 229 232 236 177 183 232 177 183 237 232 235 234 236 236 234 181 177 236 181 177 178 167 168 177 167 177 181 178 168 183 177 179 181 180 178 181 179 181 234 180 166 178 164 164 178 179 167 178 166 167 161 162 166 161 167 162 168 167 161 166 160 160 166 164 160 164 159 164 165 159 164 179 165 180 165 179 358 165 363 159 165 358 363 165 365 180 365 165 118 159 117 160 159 118 117 159 358 161 160 119 119 160 118 105 118 117 104 119 118 104 118 105 117 116 105 116 117 329 329 117 358 104 105 98 105 116 95 98 105 95 97 103 104 98 97 104 103 119 104 92 97 98 92 98 95 95 81 92 95 316 81 316 95 317 95 116 317 92 93 94 81 93 92 94 97 92 99 97 94 97 99 103 93 96 94 96 99 94 93 81 72 61 93 72 61 96 93 101 99 96 59 96 61 59 101 96 100 99 101 100 106 99 99 106 103 101 102 100 101 108 102 59 108 101 100 109 106 102 109 100 121 120 106 106 120 103 109 121 106 120 119 103 120 162 161 120 161 119 121 162 120 109 122 121 163 162 121 122 163 121 102 113 109 113 122 109 123 122 113 122 169 163 123 169 122 163 168 162 163 169 174 174 168 163 170 169 123 170 175 169 169 175 174 124 123 114 114 123 113 124 170 123 124 171 170 176 170 171 175 170 176 175 182 174 176 185 175 185 182 175 171 173 176 173 184 176 176 184 185 152 171 125 125 171 124 152 173 171 172 173 152 173 172 184 172 201 184 201 204 184 184 204 210 184 210 185 186 172 152 186 190 172 190 201 172 148 152 125 148 186 152 187 186 149 149 186 148 187 190 186 190 187 191 191 201 190 150 188 187 150 187 149 188 191 187 149 148 136 150 149 137 137 149 136 131 148 125 136 148 131 89 136 131 132 137 136 132 136 89 133 137 132 133 138 137 138 150 137 130 132 89 133 132 134 134 132 130 89 90 91 91 130 89 90 89 131 90 110 91 90 115 110 131 115 90 112 91 107 107 91 110 91 129 130 91 112 129 110 111 107 110 114 111 110 115 114 125 124 115 115 124 114 131 125 115 111 114 113 107 111 102 111 113 102 107 102 108 108 112 107 58 108 59 58 112 108 58 59 57 59 60 57 59 61 60 60 61 62 62 63 60 63 57 60 61 72 62 63 62 64 62 72 64 72 65 64 72 81 82 72 82 65 64 65 66 66 63 64 66 65 70 65 80 70 65 82 80 82 314 80 81 316 82 82 316 314 80 79 70 305 306 80 314 305 80 80 306 79 317 318 314 317 314 316 314 318 305 305 319 315 318 319 305 305 315 306 306 309 79 306 313 309 306 315 313 315 327 325 319 327 315 315 325 313 320 319 318 328 327 319 320 328 319 317 320 318 317 116 320 329 328 320 116 329 320 360 359 328 328 359 327 329 360 328 327 354 325 327 359 354 325 324 313 325 354 324 354 353 324 354 356 353 354 359 361 361 356 354 360 362 359 359 362 361 362 364 361 361 272 356 361 364 272 356 357 353 356 274 357 356 272 274 269 272 268 272 273 268 274 272 269 272 364 273 362 365 364 364 365 273 268 273 234 234 273 180 273 365 180 264 268 234 264 269 268 233 234 235 264 234 233 256 264 233 256 253 264 253 269 264 256 233 257 235 258 233 258 257 233 253 256 263 257 393 256 256 395 263 393 395 256 254 253 263 263 394 254 263 395 394 393 396 395 395 399 400 395 400 394 396 399 395 254 394 255 400 401 394 394 401 255 250 253 254 255 250 254 250 255 251 255 248 251 255 398 248 255 401 398 248 250 251 247 246 248 248 246 250 398 402 248 248 402 247 245 246 247 402 403 247 247 403 245 448 403 402 402 451 448 245 403 397 403 448 397 244 242 245 245 242 246 245 397 244 243 242 244 244 397 243 243 397 386 397 450 386 448 447 397 450 397 447 242 243 240 386 240 243 386 384 387 387 240 386 384 386 449 449 386 450 441 449 450 450 447 441 443 447 448 441 447 442 442 447 443 414 441 442 438 441 414 441 438 449 384 449 454 449 438 454 414 415 438 415 445 438 454 438 445 443 439 414 414 442 443 439 443 448 448 451 439 444 445 415 444 446 445 454 445 452 446 452 445 384 454 452 385 384 452 452 453 385 452 446 453 453 446 444 385 453 389 455 389 453 453 444 455 383 384 385 385 389 238 385 238 383 383 388 384 384 388 387 249 388 383 383 238 249 228 238 239 226 249 238 226 238 228 238 389 239 226 241 249 241 388 249 387 388 241 240 387 241 240 241 225 225 241 226 225 226 227 217 227 226 228 218 226 217 226 218 227 212 225 211 225 212 242 240 225 225 211 242 212 227 217 208 211 212 205 212 217 208 212 205 211 209 213 209 211 208 213 221 211 211 221 242 242 221 246 220 221 213 220 222 221 222 246 221 213 347 346 213 346 220 209 347 213 220 215 222 220 346 336 337 220 336 220 337 215 214 222 215 214 246 222 214 215 216 348 215 343 343 215 337 215 348 216 333 337 332 332 337 336 343 337 333 333 338 343 338 344 343 344 348 343 216 348 344 339 344 338 344 339 345 345 216 344 301 338 333 339 338 302 302 338 301 333 332 300 301 333 300 291 301 300 302 301 294 294 301 291 303 302 295 295 302 294 303 339 302 285 294 291 293 295 294 293 294 285 283 291 289 285 291 283 291 300 289 284 285 283 290 285 75 284 75 285 290 293 285 292 293 290 292 295 293 83 277 290 290 277 292 290 75 83 74 75 76 75 74 83 75 284 76 283 282 284 284 282 76 88 76 87 76 88 74 87 76 278 76 282 278 282 280 278 280 282 286 283 289 282 282 289 286 278 279 87 278 280 279 279 280 281 280 286 287 281 280 287 299 298 286 289 299 286 286 298 287 300 299 289 299 332 331 299 331 298 300 332 299 287 298 297 331 330 298 298 330 297 287 288 281 287 297 288 288 297 158 297 196 158 330 196 297 330 334 196 331 335 330 330 335 334 336 331 332 335 331 336 335 346 334 336 346 335 196 334 199 334 347 199 334 346 347 193 158 196 196 199 193 193 199 200 200 199 207 199 209 207 209 199 347 157 158 193 157 193 195 193 200 195 195 200 198 200 207 198 198 207 206 207 208 206 207 209 208 195 198 194 194 198 197 198 206 197 195 194 156 157 195 156 154 194 189 156 194 154 189 194 197 197 192 189 205 202 197 197 202 192 197 206 205 208 205 206 205 217 202 191 202 203 192 202 191 202 217 203 189 192 188 188 192 191 189 188 151 154 189 151 151 188 150 151 150 138 154 151 138 127 138 133 127 139 138 139 154 138 126 127 128 127 133 135 126 139 127 127 135 128 134 135 133 130 135 134 135 366 128 130 366 135 73 366 130 129 73 130 128 366 367 366 53 367 370 53 366 73 370 366 367 86 143 128 367 143 53 47 367 86 367 47 140 143 142 142 143 85 140 128 143 143 86 85 140 126 128 144 145 140 144 140 142 140 145 126 141 142 85 142 141 144 85 86 87 141 85 279 87 279 85 141 153 144 279 281 141 288 153 141 281 288 141 144 147 145 144 153 147 147 146 145 145 146 126 157 156 147 153 157 147 147 156 146 153 158 157 158 153 288 126 146 139 156 155 146 146 155 139 155 156 154 139 155 154 87 86 88 86 369 88 47 369 86 369 368 88 88 368 74 369 43 368 43 369 47 46 47 48 46 43 47 48 47 52 52 47 53 45 43 46 46 461 45 48 461 46 44 43 45 45 458 44 45 461 458 458 461 456 456 461 48 456 457 458 44 458 472 458 457 472 42 43 44 44 472 42 472 56 42 472 457 480 472 480 56 456 459 457 457 459 480 459 456 48 48 460 459 459 460 470 470 494 459 459 474 480 56 480 479 474 479 480 39 479 474 56 479 39 37 38 39 39 38 56 68 37 69 38 37 84 68 84 37 67 68 69 67 71 68 71 84 68 70 69 66 67 69 70 69 376 66 67 77 71 70 79 67 67 79 77 71 77 78 78 84 71 83 84 78 78 77 277 78 277 83 83 74 84 74 38 84 74 368 38 56 38 42 38 43 42 43 38 368 275 276 277 276 292 277 277 77 275 77 308 275 275 311 307 308 311 275 276 275 307 276 296 292 307 296 276 292 296 295 304 303 296 296 303 295 307 304 296 307 321 304 311 321 307 321 326 304 326 340 304 304 340 303 303 340 339 345 339 340 326 342 340 340 342 345 341 342 326 321 351 326 351 341 326 322 321 311 322 351 321 352 351 322 352 355 351 351 355 341 342 341 349 355 350 341 341 350 349 342 349 345 345 349 216 271 349 350 216 349 223 223 349 271 357 350 355 350 357 271 355 352 353 357 355 353 271 357 274 224 271 270 271 274 270 224 223 271 223 224 214 223 214 216 224 267 214 224 270 265 224 265 267 265 270 266 266 270 269 270 274 269 265 266 253 253 250 265 267 265 250 246 267 250 214 267 246 266 269 253 323 353 352 324 353 323 323 322 312 324 323 312 323 352 322 313 324 312 308 312 311 309 312 308 309 313 312 312 322 311 309 308 310 310 308 77 310 79 309 79 310 77 66 375 63 66 376 377 377 375 66 63 375 374 375 466 464 374 375 464 377 466 375 63 374 373 63 373 57 374 464 465 465 373 374 464 496 465 464 466 496 377 473 466 496 466 473 376 473 377 490 496 491 495 496 490 496 495 465 467 373 465 465 495 467 494 495 490 495 494 467 468 373 467 467 463 372 467 372 468 467 494 470 467 470 463 487 494 490 9 487 23 23 487 490 23 10 9 23 24 10 32 23 485 24 23 32 23 490 485 409 10 24 32 27 24 24 27 409 27 32 25 485 25 32 485 484 25 485 490 484 484 490 491 26 484 482 25 484 26 482 484 491 25 26 27 409 27 410 409 410 411 409 411 415 428 410 434 428 411 410 437 411 436 436 411 428 411 444 415 411 437 444 436 432 437 437 455 444 455 437 432 436 433 432 433 436 428 431 432 433 431 433 428 455 432 389 391 390 432 389 432 390 431 391 432 431 428 430 431 430 391 390 391 261 391 262 261 389 390 252 261 252 390 239 389 252 239 252 228 228 252 261 228 261 229 229 261 262 228 229 230 219 218 228 230 219 228 229 237 230 237 219 230 204 219 210 204 218 219 210 219 237 203 217 218 203 218 204 203 204 201 203 201 191 210 237 185 185 237 183 182 185 183 182 183 174 174 183 168 428 429 430 430 429 435 428 434 429 429 434 435 36 26 482 462 372 463 469 462 463 463 470 469 51 462 469 50 462 51 50 372 462 371 372 49 372 50 49 468 372 371 49 50 51 54 55 51 51 55 49 469 54 51 470 54 469 460 54 470 52 53 54 54 53 55 460 52 54 55 58 49 55 73 58 370 73 55 55 53 370 57 49 58 73 112 58 129 112 73 57 371 49 57 373 371 371 373 468 48 52 460 399 422 400 422 399 396 363 365 362 358 363 360 360 363 362 329 358 360))
                   (list :vertices (let ((mat (make-matrix 500 3))) (fvector-replace (array-entity mat) #f(5.1378703117370605e+00 6.8265296936035156e+01 -9.3289899826049805e+00 2.7445201873779297e+00 6.8581901550292969e+01 -1.2800700187683105e+01 1.0573199987411499e+00 6.8359207153320312e+01 -1.0600199699401855e+01 1.0544799804687500e+01 6.8569099426269531e+01 -8.4442996978759766e+00 8.2298793792724609e+00 6.8419601440429688e+01 -6.8257398605346680e+00 1.0452800750732422e+01 6.8323402404785156e+01 -2.3365499973297119e+00 -6.6212201118469238e+00 6.8392799377441406e+01 8.3633699417114258e+00 -1.0304100036621094e+01 1.7535499572753906e+01 4.2757096290588379e+00 -9.9000797271728516e+00 6.8434997558593750e+01 4.3990101814270020e+00 -3.0437600612640381e+00 6.8367401123046875e+01 1.0238399505615234e+01 -3.0640001296997070e+00 1.7108699798583984e+01 1.0639900207519531e+01 -1.0523200035095215e+01 6.8192199707031250e+01 2.0460700988769531e+00 -1.0421499252319336e+01 6.8127601623535156e+01 -1.9288499355316162e+00 -1.1160599708557129e+01 6.8441001892089844e+01 -8.0958700180053711e-01 -7.1614899635314941e+00 1.7107900619506836e+01 8.4554700851440430e+00 -1.0192299842834473e+01 1.7057300567626953e+01 5.5663700103759766e+00 -1.0925999641418457e+01 1.7111598968505859e+01 -2.1682801246643066e+00 -8.4008197784423828e+00 1.7088899612426758e+01 -7.2349200248718262e+00 -6.7002696990966797e+00 6.8396400451660156e+01 -8.3113307952880859e+00 -9.4348793029785156e+00 6.8405799865722656e+01 -4.9726400375366211e+00 -5.3217201232910156e+00 1.7143899917602539e+01 -9.7155799865722656e+00 -2.8588600158691406e+00 6.8322502136230469e+01 -1.0273599624633789e+01 -1.0057700872421265e+00 1.7096700668334961e+01 -1.1044600486755371e+01 1.0178999900817871e+00 6.8367797851562500e+01 1.0607999801635742e+01 1.0090099573135376e+00 1.7097700119018555e+01 1.1044500350952148e+01 7.1427397727966309e+00 1.7195999145507812e+01 8.4595899581909180e+00 9.8030099868774414e+00 1.7092800140380859e+01 5.1623497009277344e+00 7.4257197380065918e+00 1.6894800186157227e+01 1.1212299346923828e+01 3.3442101478576660e+00 1.7096099853515625e+01 -1.0557999610900879e+01 6.1998200416564941e+00 1.6903999328613281e+01 -1.1747900009155273e+01 7.2372202873229980e+00 1.7205499649047852e+01 -8.3683700561523438e+00 9.8025293350219727e+00 1.7078998565673828e+01 -5.1738500595092773e+00 4.0853300094604492e+00 1.7077999114990234e+01 1.0249599456787109e+01 1.0831099510192871e+01 1.7257900238037109e+01 -2.0039701461791992e+00 1.2268199920654297e+01 1.6871999740600586e+01 3.9475402832031250e+00 1.1011500358581543e+01 1.7335899353027344e+01 0.0000000000000000e+00 1.0836700439453125e+01 1.7178098678588867e+01 2.0019199848175049e+00 -1.1417300224304199e+01 6.6068595886230469e+01 -6.0313899993896484e+01 -3.8845100402832031e+01 6.6098693847656250e+01 -4.7875999450683594e+01 -3.0698499679565430e+01 6.4885696411132812e+01 -3.9734401702880859e+01 -1.5955299377441406e+01 6.4939201354980469e+01 -4.7729400634765625e+01 -2.3467898368835449e+00 6.4994499206542969e+01 -5.1267002105712891e+01 -4.5538898468017578e+01 6.5077301025390625e+01 -2.5041301727294922e+01 -6.0313198089599609e+01 6.6034599304199219e+01 -7.4321599006652832e+00 -4.9943901062011719e+01 6.5038505554199219e+01 -1.3358200073242188e+01 -5.1267002105712891e+01 6.4994796752929688e+01 2.3467597961425781e+00 -4.8763401031494141e+01 6.5027900695800781e+01 1.6582399368286133e+01 -6.1740497589111328e+01 6.6020698547363281e+01 1.0151400566101074e+01 -4.5477100372314453e+01 6.4954597473144531e+01 2.1893899917602539e+01 1.6372301101684570e+01 6.6058395385742188e+01 5.8962200164794922e+01 2.3468399047851562e+00 6.4992599487304688e+01 5.1267200469970703e+01 -9.9129495620727539e+00 6.4916198730468750e+01 4.9431499481201172e+01 -3.6015296936035156e+01 6.4891899108886719e+01 3.4995300292968750e+01 -4.8726200103759766e+01 6.6080505371093750e+01 3.8182498931884766e+01 -2.5745399475097656e+01 6.4941505432128906e+01 4.3290298461914062e+01 -6.4798698425292969e+00 6.6077705383300781e+01 6.1833000183105469e+01 -3.9104801177978516e+01 6.4893997192382812e+01 -3.1760398864746094e+01 3.8039699554443359e+01 6.6068901062011719e+01 4.8811397552490234e+01 2.0110498428344727e+01 6.5001693725585938e+01 6.3504100799560547e+01 4.7388999938964844e+01 6.4940200805664062e+01 4.7388999938964844e+01 5.0501701354980469e+01 6.5800300598144531e+01 3.8274200439453125e+01 6.3447898864746094e+01 6.4940101623535156e+01 2.0092599868774414e+01 6.0778099060058594e+01 6.5855598449707031e+01 1.7475801467895508e+01 6.0313198089599609e+01 6.6034599304199219e+01 7.4321599006652832e+00 6.3284599304199219e+01 6.5808799743652344e+01 -4.4547400474548340e+00 5.9817501068115234e+01 6.4940101623535156e+01 -2.9234298706054688e+01 5.5512199401855469e+01 6.6128799438476562e+01 -2.7132499694824219e+01 2.8417900085449219e+01 6.4975593566894531e+01 -6.0260898590087891e+01 4.4547300338745117e+00 6.5808898925781250e+01 -6.3284301757812500e+01 3.3109401702880859e+01 6.6098304748535156e+01 -5.2159999847412109e+01 4.6935901641845703e+01 6.5001396179199219e+01 -4.6935901641845703e+01 4.6696701049804688e+00 6.4939994812011719e+01 -6.6339698791503906e+01 6.6339698791503906e+01 6.4939994812011719e+01 -4.6691398620605469e+00 -1.2190400123596191e+01 6.4980697631835938e+01 6.5981704711914062e+01 -4.4070800781250000e+01 6.4974899291992188e+01 -4.9997600555419922e+01 -3.9661098480224609e+01 6.5756004333496094e+01 -5.7238800048828125e+01 -5.8180297851562500e+01 6.5755393981933594e+01 -3.8144996643066406e+01 1.5174099922180176e+01 6.5649505615234375e+01 -6.8473693847656250e+01 4.8838300704956055e+00 6.5753700256347656e+01 -6.9384094238281250e+01 4.1918899536132812e+01 6.5744300842285156e+01 -5.5662799835205078e+01 5.6185497283935547e+01 6.5768501281738281e+01 -4.1026100158691406e+01 6.9456398010253906e+01 6.5766296386718750e+01 -1.5821299552917480e+00 6.6359199523925781e+01 6.5753700256347656e+01 -2.1015600204467773e+01 -2.1015600204467773e+01 6.5753700256347656e+01 -6.6359199523925781e+01 -2.0110498428344727e+01 6.5001693725585938e+01 -6.3504100799560547e+01 -6.9488693237304688e+01 6.5759704589843750e+01 1.4109100103378296e+00 -6.6339698791503906e+01 6.4939994812011719e+01 -4.6691398620605469e+00 -6.6359199523925781e+01 6.5753700256347656e+01 -2.1015600204467773e+01 -5.9817501068115234e+01 6.4940101623535156e+01 -2.9234298706054688e+01 -1.5645200729370117e+01 5.9610603332519531e+01 7.4474800109863281e+01 -1.7341400384902954e+00 5.9608001708984375e+01 7.6071098327636719e+01 5.1130599975585938e+00 6.3596702575683594e+01 7.2644706726074219e+01 7.1366401672363281e+01 6.3561000823974609e+01 1.3268600463867188e+01 6.7285202026367188e+01 6.5753700256347656e+01 1.7788499832153320e+01 6.7477394104003906e+01 6.3571102142333984e+01 2.6760299682617188e+01 7.5355300903320312e+01 6.0731601715087891e+01 1.7170599699020386e+00 5.9104999542236328e+01 6.5766296386718750e+01 3.6562202453613281e+01 7.0040397644042969e+01 5.9612998962402344e+01 2.9782499313354492e+01 7.4474800109863281e+01 5.9610603332519531e+01 1.5645200729370117e+01 6.2013099670410156e+01 6.0733798980712891e+01 4.2893001556396484e+01 5.1923801422119141e+01 6.0734001159667969e+01 5.4677501678466797e+01 4.9207698822021484e+01 6.5768600463867188e+01 4.9181400299072266e+01 3.9661300659179688e+01 6.0734100341796875e+01 6.4126296997070312e+01 6.6670997619628906e+01 5.4979000091552734e+01 4.1205699920654297e+01 7.3550094604492188e+01 5.4977699279785156e+01 2.7057100296020508e+01 7.7358497619628906e+01 5.4975402832031250e+01 1.2475700378417969e+01 5.6843299865722656e+01 5.4978401184082031e+01 5.3966102600097656e+01 2.5049600601196289e+01 6.3557998657226562e+01 6.8122604370117188e+01 3.6946399688720703e+01 6.5759101867675781e+01 5.8903797149658203e+01 4.4562896728515625e+01 5.4979099273681641e+01 6.4476997375488281e+01 1.2114600181579590e+01 5.9610000610351562e+01 7.5127197265625000e+01 2.6272998809814453e+01 5.9612503051757812e+01 7.1428794860839844e+01 2.1015600204467773e+01 6.5753700256347656e+01 6.6359199523925781e+01 3.0671701431274414e+01 5.4978099822998047e+01 7.2120101928710938e+01 1.6111700057983398e+01 5.4976001739501953e+01 7.6686698913574219e+01 1.7856500148773193e+00 5.4973503112792969e+01 7.8329895019531250e+01 7.8330101013183594e+01 5.4972999572753906e+01 -1.7853500843048096e+00 7.9383201599121094e+01 4.9045101165771484e+01 -3.4461998939514160e-01 7.8114799499511719e+01 4.9050800323486328e+01 1.4203499794006348e+01 7.3951698303222656e+01 4.9059398651123047e+01 2.8930398941040039e+01 6.6686599731445312e+01 4.9065399169921875e+01 4.3129802703857422e+01 5.6477798461914062e+01 4.9067699432373047e+01 5.5839900970458984e+01 4.3869800567626953e+01 4.9065898895263672e+01 6.6202606201171875e+01 2.9704099655151367e+01 4.9060401916503906e+01 7.3644798278808594e+01 1.4941699981689453e+01 4.9052101135253906e+01 7.7977600097656250e+01 3.4459200501441956e-01 4.9045101165771484e+01 7.9383300781250000e+01 -6.4126296997070312e+01 6.0734100341796875e+01 3.9661300659179688e+01 -5.3850097656250000e+01 6.1509799957275391e+01 5.2007102966308594e+01 -5.6481498718261719e+01 6.5751998901367188e+01 4.0724998474121094e+01 -4.8838300704956055e+00 6.5753700256347656e+01 6.9384094238281250e+01 -1.5174099922180176e+01 6.5649505615234375e+01 6.8473693847656250e+01 -1.2475700378417969e+01 5.4975402832031250e+01 7.7358497619628906e+01 -2.9782499313354492e+01 5.9612998962402344e+01 7.0040397644042969e+01 -4.2893001556396484e+01 6.0733798980712891e+01 6.2013099670410156e+01 -2.8395601272583008e+01 6.3558399200439453e+01 6.6799201965332031e+01 -4.3375499725341797e+01 6.5742904663085938e+01 5.4680000305175781e+01 -2.7057100296020508e+01 5.4977699279785156e+01 7.3550094604492188e+01 -4.1205699920654297e+01 5.4979000091552734e+01 6.6670997619628906e+01 -5.3966102600097656e+01 5.4978401184082031e+01 5.6843299865722656e+01 -6.4476997375488281e+01 5.4979099273681641e+01 4.4562896728515625e+01 -6.7513504028320312e+01 6.3559398651123047e+01 2.6707201004028320e+01 -7.5355300903320312e+01 6.0731601715087891e+01 -1.7170599699020386e+00 -7.1374496459960938e+01 6.3563102722167969e+01 1.3211199760437012e+01 -6.7285202026367188e+01 6.5753700256347656e+01 1.7788499832153320e+01 -7.5127197265625000e+01 5.9610000610351562e+01 1.2114600181579590e+01 -7.1428794860839844e+01 5.9612503051757812e+01 2.6272998809814453e+01 -7.2120101928710938e+01 5.4978099822998047e+01 3.0671701431274414e+01 -7.6686698913574219e+01 5.4976001739501953e+01 1.6111700057983398e+01 -1.4203499794006348e+01 4.9050800323486328e+01 7.8114799499511719e+01 -2.8930398941040039e+01 4.9059398651123047e+01 7.3951698303222656e+01 -4.3129802703857422e+01 4.9065399169921875e+01 6.6686599731445312e+01 -5.4402599334716797e+01 4.8448303222656250e+01 5.7758701324462891e+01 -1.7856500148773193e+00 4.3026500701904297e+01 7.8329895019531250e+01 -7.8330101013183594e+01 5.4972999572753906e+01 1.7853500843048096e+00 -6.4116600036621094e+01 4.9052497863769531e+01 4.6979301452636719e+01 -6.7437301635742188e+01 5.0188701629638672e+01 4.1716197967529297e+01 -7.3951698303222656e+01 4.8940597534179688e+01 2.8930398941040039e+01 -7.8114799499511719e+01 4.8949199676513672e+01 1.4203499794006348e+01 -7.9383201599121094e+01 4.8954898834228516e+01 -3.4461998939514160e-01 7.8330101013183594e+01 4.3027000427246094e+01 1.7853500843048096e+00 7.6686698913574219e+01 4.3023998260498047e+01 1.6111700057983398e+01 7.2120101928710938e+01 4.3021900177001953e+01 3.0671701431274414e+01 6.4476997375488281e+01 4.3020900726318359e+01 4.4562896728515625e+01 5.3966102600097656e+01 4.3021598815917969e+01 5.6843299865722656e+01 7.5127197265625000e+01 3.8389999389648438e+01 1.2114600181579590e+01 7.5355300903320312e+01 3.7268402099609375e+01 -1.7170599699020386e+00 7.1428794860839844e+01 3.8387500762939453e+01 2.6272998809814453e+01 6.4126296997070312e+01 3.7265899658203125e+01 3.9661300659179688e+01 5.3850097656250000e+01 3.6490200042724609e+01 5.2007102966308594e+01 4.1205699920654297e+01 4.3020999908447266e+01 6.6670997619628906e+01 2.7057100296020508e+01 4.3022300720214844e+01 7.3550094604492188e+01 1.2475700378417969e+01 4.3024600982666016e+01 7.7358497619628906e+01 -1.2114600181579590e+01 3.8389999389648438e+01 7.5127197265625000e+01 1.7341400384902954e+00 3.8391998291015625e+01 7.6071098327636719e+01 4.2893001556396484e+01 3.7266197204589844e+01 6.2013099670410156e+01 2.9782499313354492e+01 3.8387001037597656e+01 7.0040397644042969e+01 1.5645200729370117e+01 3.8389400482177734e+01 7.4474800109863281e+01 5.6481498718261719e+01 3.2248001098632812e+01 4.0724998474121094e+01 6.7513504028320312e+01 3.4440597534179688e+01 2.6707201004028320e+01 7.1374496459960938e+01 3.4436901092529297e+01 1.3211199760437012e+01 6.9488693237304688e+01 3.2240303039550781e+01 1.4108999967575073e+00 6.7285202026367188e+01 3.2246299743652344e+01 1.7788499832153320e+01 2.8395601272583008e+01 3.4441600799560547e+01 6.6799201965332031e+01 4.3375499725341797e+01 3.2257099151611328e+01 5.4680000305175781e+01 -5.1130700111389160e+00 3.4403301239013672e+01 7.2644706726074219e+01 1.5174099922180176e+01 3.2350498199462891e+01 6.8473693847656250e+01 -1.6111700057983398e+01 4.3023998260498047e+01 7.6686698913574219e+01 -3.0671701431274414e+01 4.3021900177001953e+01 7.2120101928710938e+01 -4.4562896728515625e+01 4.3020900726318359e+01 6.4476997375488281e+01 -5.6843299865722656e+01 4.3021598815917969e+01 5.3966102600097656e+01 -2.6272998809814453e+01 3.8387500762939453e+01 7.1428794860839844e+01 -3.9661300659179688e+01 3.7265899658203125e+01 6.4126296997070312e+01 -5.1923801422119141e+01 3.7266002655029297e+01 5.4677501678466797e+01 -7.7358497619628906e+01 4.3024600982666016e+01 1.2475700378417969e+01 -6.6670997619628906e+01 4.3020999908447266e+01 4.1205699920654297e+01 -7.3550094604492188e+01 4.3022300720214844e+01 2.7057100296020508e+01 -7.8330101013183594e+01 4.3027000427246094e+01 -1.7853500843048096e+00 -6.2013099670410156e+01 3.7266197204589844e+01 4.2893001556396484e+01 -7.0040397644042969e+01 3.8387001037597656e+01 2.9782499313354492e+01 -7.5355300903320312e+01 3.7268402099609375e+01 1.7170599699020386e+00 -7.4474800109863281e+01 3.8389400482177734e+01 1.5645200729370117e+01 -2.5049600601196289e+01 3.4442001342773438e+01 6.8122604370117188e+01 -4.9207698822021484e+01 3.2231403350830078e+01 4.9181400299072266e+01 -3.6946399688720703e+01 3.2240901947021484e+01 5.8903797149658203e+01 -2.1015600204467773e+01 3.2246299743652344e+01 6.6359199523925781e+01 -5.9104999542236328e+01 3.2233699798583984e+01 3.6562202453613281e+01 -6.7477394104003906e+01 3.4428897857666016e+01 2.6760299682617188e+01 -7.1366401672363281e+01 3.4439002990722656e+01 1.3268600463867188e+01 -6.7285202026367188e+01 3.2246299743652344e+01 1.7788499832153320e+01 -6.9456398010253906e+01 3.2233699798583984e+01 -1.5821199417114258e+00 4.8838300704956055e+00 3.2246299743652344e+01 6.9384094238281250e+01 -6.5954093933105469e+01 3.2996700286865234e+01 -1.1007699966430664e+01 -6.3504100799560547e+01 3.2998302459716797e+01 2.0110498428344727e+01 -6.6359199523925781e+01 3.2246299743652344e+01 -2.1015600204467773e+01 -2.0092599868774414e+01 3.3059898376464844e+01 -6.3447898864746094e+01 -4.1918899536132812e+01 3.2255702972412109e+01 -5.5662799835205078e+01 -1.5174099922180176e+01 3.2350498199462891e+01 -6.8473693847656250e+01 -5.0577800750732422e+01 3.3059898376464844e+01 4.3333198547363281e+01 -2.5114198684692383e+01 3.2994197845458984e+01 6.1894699096679688e+01 -4.6691398620605469e+00 3.3059997558593750e+01 6.6339698791503906e+01 -5.6185497283935547e+01 3.2231498718261719e+01 -4.1026100158691406e+01 -5.9442901611328125e+01 3.3025199890136719e+01 -3.0091600418090820e+01 -4.3333198547363281e+01 3.3059898376464844e+01 -5.0577800750732422e+01 -4.8838400840759277e+00 3.2246299743652344e+01 -6.9384094238281250e+01 4.6691398620605469e+00 3.3059997558593750e+01 -6.6339698791503906e+01 -6.1515499114990234e+01 3.1915601730346680e+01 7.3676099777221680e+00 -3.9422199249267578e+01 3.1880800247192383e+01 4.7579696655273438e+01 -4.8702198028564453e+01 3.2059200286865234e+01 3.9441997528076172e+01 -8.7784500122070312e+00 3.1910301208496094e+01 6.1264701843261719e+01 3.0705200195312500e+01 3.1882099151611328e+01 5.3397201538085938e+01 1.5252799987792969e+01 3.2137401580810547e+01 6.1349498748779297e+01 5.0155899047851562e+01 3.1926799774169922e+01 3.6021900177001953e+01 4.3594100952148438e+01 3.3036796569824219e+01 5.0356700897216797e+01 6.0698596954345703e+01 3.1933300018310547e+01 -6.7463498115539551e+00 6.6711799621582031e+01 3.2996097564697266e+01 1.3542500138282776e-01 5.9121696472167969e+01 3.1899499893188477e+01 1.8429199218750000e+01 5.9817501068115234e+01 3.3059898376464844e+01 2.9234298706054688e+01 2.0092599868774414e+01 3.3059898376464844e+01 6.3447898864746094e+01 -2.4017601013183594e+01 3.3075298309326172e+01 4.4330997467041016e+01 -1.2296899795532227e+01 3.3077796936035156e+01 4.8861900329589844e+01 -4.9878101348876953e+01 3.3076202392578125e+01 6.1260700225830078e+00 -4.7621898651123047e+01 3.2973300933837891e+01 2.0646100997924805e+01 -5.8962200164794922e+01 3.1941600799560547e+01 -1.6372301101684570e+01 -4.9968898773193359e+01 3.3071201324462891e+01 -5.5101404190063477e+00 -4.6904499053955078e+01 3.3098499298095703e+01 -1.8820098876953125e+01 -4.1162097930908203e+01 3.3084197998046875e+01 -2.8893501281738281e+01 -4.1316501617431641e+01 3.1871698379516602e+01 -4.6076801300048828e+01 -3.1769998550415039e+01 3.3059398651123047e+01 -3.8861301422119141e+01 -1.5955600738525391e+01 3.3101100921630859e+01 -4.8028099060058594e+01 -3.6749000549316406e+01 3.2989299774169922e+01 3.6192996978759766e+01 -7.4321599006652832e+00 3.1965400695800781e+01 -6.0313198089599609e+01 -4.9870600700378418e+00 3.2961700439453125e+01 -5.1429000854492188e+01 6.1151897907257080e-01 3.3100097656250000e+01 5.0388702392578125e+01 4.0430500030517578e+01 3.1952198028564453e+01 -4.7272399902343750e+01 2.1093599319458008e+01 3.2991901397705078e+01 -4.7210800170898438e+01 5.7853302955627441e+00 3.3030902862548828e+01 -5.0313201904296875e+01 4.5625198364257812e+01 3.2923900604248047e+01 -2.5078199386596680e+01 5.2289600372314453e+01 3.2952899932861328e+01 -4.6615300178527832e+00 4.9076499938964844e+01 3.2969501495361328e+01 1.6025699615478516e+01 3.6085098266601562e+01 3.3112297058105469e+01 3.5027797698974609e+01 4.5658901214599609e+01 3.3043701171875000e+01 2.1977499008178711e+01 1.2848500251770020e+01 3.3077198028564453e+01 4.8701698303222656e+01 2.4957799911499023e+01 3.3075702667236328e+01 4.3825702667236328e+01 3.6392799377441406e+01 3.2986000061035156e+01 -3.6605201721191406e+01 5.6047599792480469e+01 3.1980998992919922e+01 -2.7524799346923828e+01 4.4547400474548340e+00 3.2191196441650391e+01 -6.3284599304199219e+01 2.7442001342773438e+01 3.2047397613525391e+01 -5.6365200042724609e+01 -1.7475801467895508e+01 3.2144401550292969e+01 -6.0778099060058594e+01 6.3447898864746094e+01 3.3059898376464844e+01 -2.0092599868774414e+01 5.0577800750732422e+01 3.3059898376464844e+01 -4.3333198547363281e+01 2.9234298706054688e+01 3.3059898376464844e+01 -5.9817501068115234e+01 2.1015600204467773e+01 3.2246299743652344e+01 -6.6359199523925781e+01 5.6820499420166016e+01 3.2238201141357422e+01 -4.0331298828125000e+01 6.6359199523925781e+01 3.2246299743652344e+01 -2.1015600204467773e+01 4.3921298980712891e+01 3.2241901397705078e+01 -5.3944599151611328e+01 1.5645200729370117e+01 5.9610603332519531e+01 -7.4474800109863281e+01 1.7341400384902954e+00 5.9608001708984375e+01 -7.6071098327636719e+01 -5.1130700111389160e+00 6.3596702575683594e+01 -7.2644706726074219e+01 -6.7477394104003906e+01 6.3571102142333984e+01 -2.6760299682617188e+01 -7.1366401672363281e+01 6.3561000823974609e+01 -1.3268600463867188e+01 -7.0040397644042969e+01 5.9612998962402344e+01 -2.9782499313354492e+01 -7.4474800109863281e+01 5.9610603332519531e+01 -1.5645200729370117e+01 -6.2013099670410156e+01 6.0733798980712891e+01 -4.2893001556396484e+01 -5.1923801422119141e+01 6.0734001159667969e+01 -5.4677501678466797e+01 -5.1424598693847656e+01 6.4527305603027344e+01 -4.9469097137451172e+01 -3.9661300659179688e+01 6.0734100341796875e+01 -6.4126296997070312e+01 -6.6670997619628906e+01 5.4979000091552734e+01 -4.1205699920654297e+01 -7.3550094604492188e+01 5.4977699279785156e+01 -2.7057100296020508e+01 -7.7358497619628906e+01 5.4975402832031250e+01 -1.2475700378417969e+01 -5.6843299865722656e+01 5.4978401184082031e+01 -5.3966102600097656e+01 -2.5049600601196289e+01 6.3557998657226562e+01 -6.8122604370117188e+01 -4.4562896728515625e+01 5.4979099273681641e+01 -6.4476997375488281e+01 -1.2114600181579590e+01 5.9610000610351562e+01 -7.5127197265625000e+01 -2.6272998809814453e+01 5.9612503051757812e+01 -7.1428794860839844e+01 -3.0671701431274414e+01 5.4978099822998047e+01 -7.2120101928710938e+01 -1.6111700057983398e+01 5.4976001739501953e+01 -7.6686698913574219e+01 -1.7856500148773193e+00 5.4973503112792969e+01 -7.8329895019531250e+01 -7.7977600097656250e+01 4.8947898864746094e+01 -1.4941699981689453e+01 -7.3644798278808594e+01 4.8939601898193359e+01 -2.9704099655151367e+01 -6.6202606201171875e+01 4.8934097290039062e+01 -4.3869800567626953e+01 -5.5839900970458984e+01 4.8932300567626953e+01 -5.6477798461914062e+01 -4.3129802703857422e+01 4.8934600830078125e+01 -6.6686599731445312e+01 -2.8930398941040039e+01 4.8940597534179688e+01 -7.3951698303222656e+01 -1.4203499794006348e+01 4.8949199676513672e+01 -7.8114799499511719e+01 3.4459200501441956e-01 4.8954898834228516e+01 -7.9383300781250000e+01 6.4126296997070312e+01 6.0734100341796875e+01 -3.9661300659179688e+01 5.3850097656250000e+01 6.1509799957275391e+01 -5.2007102966308594e+01 1.2475700378417969e+01 5.4975402832031250e+01 -7.7358497619628906e+01 2.9782499313354492e+01 5.9612998962402344e+01 -7.0040397644042969e+01 4.2893001556396484e+01 6.0733798980712891e+01 -6.2013099670410156e+01 2.8395601272583008e+01 6.3558399200439453e+01 -6.6799201965332031e+01 2.7057100296020508e+01 5.4977699279785156e+01 -7.3550094604492188e+01 4.1205699920654297e+01 5.4979000091552734e+01 -6.6670997619628906e+01 5.3966102600097656e+01 5.4978401184082031e+01 -5.6843299865722656e+01 6.7513504028320312e+01 6.3559398651123047e+01 -2.6707201004028320e+01 6.4476997375488281e+01 5.4979099273681641e+01 -4.4562896728515625e+01 7.1374496459960938e+01 6.3563102722167969e+01 -1.3211199760437012e+01 7.5127197265625000e+01 5.9610000610351562e+01 -1.2114600181579590e+01 7.1428794860839844e+01 5.9612503051757812e+01 -2.6272998809814453e+01 7.2120101928710938e+01 5.4978099822998047e+01 -3.0671701431274414e+01 7.6686698913574219e+01 5.4976001739501953e+01 -1.6111700057983398e+01 1.4941699981689453e+01 4.8947898864746094e+01 -7.7977600097656250e+01 2.9704099655151367e+01 4.8939601898193359e+01 -7.3644798278808594e+01 4.1731800079345703e+01 4.8429000854492188e+01 -6.7475105285644531e+01 4.9999198913574219e+01 4.9000503540039062e+01 -6.1567001342773438e+01 5.7531902313232422e+01 4.9579898834228516e+01 -5.4633300781250000e+01 1.7856500148773193e+00 4.3026500701904297e+01 -7.8329895019531250e+01 6.6202606201171875e+01 4.9065898895263672e+01 -4.3869800567626953e+01 7.3644798278808594e+01 4.9060401916503906e+01 -2.9704099655151367e+01 7.7977600097656250e+01 4.9052101135253906e+01 -1.4941699981689453e+01 -7.6686698913574219e+01 4.3023998260498047e+01 -1.6111700057983398e+01 -7.2120101928710938e+01 4.3021900177001953e+01 -3.0671701431274414e+01 -6.4476997375488281e+01 4.3020900726318359e+01 -4.4562896728515625e+01 -5.3966102600097656e+01 4.3021598815917969e+01 -5.6843299865722656e+01 -7.5127197265625000e+01 3.8389999389648438e+01 -1.2114600181579590e+01 -7.1428794860839844e+01 3.8387500762939453e+01 -2.6272998809814453e+01 -6.4126296997070312e+01 3.7265899658203125e+01 -3.9661300659179688e+01 -5.3850097656250000e+01 3.6490200042724609e+01 -5.2007102966308594e+01 -4.1205699920654297e+01 4.3020999908447266e+01 -6.6670997619628906e+01 -2.7057100296020508e+01 4.3022300720214844e+01 -7.3550094604492188e+01 -1.2475700378417969e+01 4.3024600982666016e+01 -7.7358497619628906e+01 1.2114600181579590e+01 3.8389999389648438e+01 -7.5127197265625000e+01 -1.7341400384902954e+00 3.8391998291015625e+01 -7.6071098327636719e+01 -4.2893001556396484e+01 3.7266197204589844e+01 -6.2013099670410156e+01 -2.9782499313354492e+01 3.8387001037597656e+01 -7.0040397644042969e+01 -1.5645200729370117e+01 3.8389400482177734e+01 -7.4474800109863281e+01 -6.7513504028320312e+01 3.4440597534179688e+01 -2.6707201004028320e+01 -7.1374496459960938e+01 3.4436901092529297e+01 -1.3211199760437012e+01 -2.8395601272583008e+01 3.4441600799560547e+01 -6.6799201965332031e+01 5.1130599975585938e+00 3.4403301239013672e+01 -7.2644706726074219e+01 2.5049600601196289e+01 3.4442001342773438e+01 -6.8122604370117188e+01 1.6111700057983398e+01 4.3023998260498047e+01 -7.6686698913574219e+01 3.0671701431274414e+01 4.3021900177001953e+01 -7.2120101928710938e+01 4.2744701385498047e+01 4.1740497589111328e+01 -6.5250297546386719e+01 5.6843299865722656e+01 4.3021598815917969e+01 -5.3966102600097656e+01 2.6272998809814453e+01 3.8387500762939453e+01 -7.1428794860839844e+01 5.1923801422119141e+01 3.7266002655029297e+01 -5.4677501678466797e+01 3.8678096771240234e+01 3.5286399841308594e+01 -6.2656597137451172e+01 7.7358497619628906e+01 4.3024600982666016e+01 -1.2475700378417969e+01 6.6670997619628906e+01 4.3020999908447266e+01 -4.1205699920654297e+01 7.3550094604492188e+01 4.3022300720214844e+01 -2.7057100296020508e+01 6.2013099670410156e+01 3.7266197204589844e+01 -4.2893001556396484e+01 7.0040397644042969e+01 3.8387001037597656e+01 -2.9782499313354492e+01 7.4474800109863281e+01 3.8389400482177734e+01 -1.5645200729370117e+01 6.7477394104003906e+01 3.4428897857666016e+01 -2.6760299682617188e+01 7.1366401672363281e+01 3.4439002990722656e+01 -1.3268600463867188e+01 -4.6283000946044922e+01 6.4940299987792969e+01 4.8698802947998047e+01 -6.3504100799560547e+01 6.5001693725585938e+01 2.0110498428344727e+01 -5.2329101562500000e+01 6.5869697570800781e+01 -3.4909000396728516e+01 -6.1349498748779297e+01 6.5862602233886719e+01 -1.5252799987792969e+01 -3.8747798919677734e+01 6.5979896545410156e+01 4.9141799926757812e+01 2.8352600097656250e+01 6.5010398864746094e+01 4.3039199829101562e+01 1.5969698905944824e+01 6.4944404602050781e+01 4.7725498199462891e+01 3.9991699218750000e+01 6.4902297973632812e+01 3.0614299774169922e+01 4.8633197784423828e+01 6.4915199279785156e+01 1.3720000267028809e+01 5.0044700622558594e+01 6.4888000488281250e+01 -5.6227302551269531e+00 3.5953800201416016e+01 6.4902297973632812e+01 -3.5078903198242188e+01 4.5476398468017578e+01 6.4954803466796875e+01 -2.1894300460815430e+01 9.9145097732543945e+00 6.4916198730468750e+01 -4.9431201934814453e+01 2.5745399475097656e+01 6.4941505432128906e+01 -4.3290298461914062e+01 4.9954399108886719e+01 3.2965801239013672e+01 5.4540300369262695e+00 4.8967998504638672e+01 3.0462301254272461e+01 1.3350299835205078e+01 5.0034500122070312e+01 3.0460399627685547e+01 -4.1453199386596680e+00 -3.3270900726318359e+01 3.2966499328613281e+01 3.7523998260498047e+01 -4.3557899475097656e+01 3.0462099075317383e+01 2.6049699783325195e+01 -2.8130199432373047e+01 3.0460399627685547e+01 4.1621601104736328e+01 -4.9887100219726562e+01 3.0460599899291992e+01 6.8354101181030273e+00 -4.7150398254394531e+01 3.2968799591064453e+01 1.8047500610351562e+01 -4.0905799865722656e+01 3.2965702056884766e+01 2.9103500366210938e+01 -9.2679700851440430e+00 3.0461000442504883e+01 4.9685398101806641e+01 9.3136892318725586e+00 3.0461299896240234e+01 4.9535301208496094e+01 2.6869998931884766e+01 3.0461400985717773e+01 4.2637798309326172e+01 4.0471401214599609e+01 3.0460399627685547e+01 2.9807500839233398e+01 4.8870899200439453e+01 3.2967102050781250e+01 -1.3342700004577637e+01 2.4033800125122070e+01 3.2967998504638672e+01 -4.4287799835205078e+01 3.8291000366210938e+01 3.2966098785400391e+01 -3.2910102844238281e+01 4.7313400268554688e+01 3.0464601516723633e+01 -1.8334699630737305e+01 -4.8967998504638672e+01 3.0462301254272461e+01 -1.3350299835205078e+01 -6.9415998458862305e+00 3.0460599899291992e+01 -4.9904800415039062e+01 3.7271400451660156e+01 3.0461599349975586e+01 -3.3985900878906250e+01 2.5166799545288086e+01 3.0463001251220703e+01 -4.3544601440429688e+01 1.0624900817871094e+01 3.0461599349975586e+01 -4.9357997894287109e+01 -2.6072299957275391e+01 3.0462200164794922e+01 -4.3274299621582031e+01 -4.0471401214599609e+01 3.0460399627685547e+01 -2.9807500839233398e+01 1.2806200027465820e+01 1.6926700592041016e+01 -3.8097999095916748e+00 1.3205300331115723e+01 1.7732500076293945e+01 -5.5868902206420898e+00 1.3861199378967285e+01 1.7730800628662109e+01 4.1422801017761230e+00 6.8685703277587891e+00 1.7730800628662109e+01 -1.2765500068664551e+01 -3.6473600864410400e+00 1.7569198608398438e+01 -1.3761699676513672e+01 -5.0008997917175293e+00 1.6919498443603516e+01 1.2562399864196777e+01 6.8692898750305176e+00 1.7731899261474609e+01 1.2766799926757812e+01 -2.6745600700378418e+00 1.7732898712158203e+01 1.4119600296020508e+01 -1.0887900352478027e+01 1.6917900085449219e+01 -8.1607704162597656e+00 -1.2876600265502930e+01 1.6926498413085938e+01 3.7914199829101562e+00 -1.3522299766540527e+01 1.7732000350952148e+01 -5.6108503341674805e+00 -1.2266799926757812e+01 1.7731599807739258e+01 8.1145401000976562e+00 1.4918000221252441e+01 1.7724899291992188e+01 -3.5685497283935547e+01 3.7123301029205322e+00 1.7724899291992188e+01 -3.8456001281738281e+01 5.6025695800781250e+00 3.0478500366210938e+01 -3.8081703186035156e+01 1.6305999755859375e+01 3.0478500366210938e+01 -3.5007499694824219e+01 3.6341297149658203e+01 3.0478500366210938e+01 -1.3186100006103516e+01 3.0869201660156250e+01 1.7725700378417969e+01 -2.3010200500488281e+01 2.9183500289916992e+01 3.0477899551391602e+01 -2.5193401336669922e+01 2.3136499404907227e+01 1.7725700378417969e+01 -3.0677999496459961e+01 3.8549598693847656e+01 1.7724899291992188e+01 -1.6160999536514282e+00 3.7004398345947266e+01 1.7724899291992188e+01 -1.1183599472045898e+01 3.8620300292968750e+01 3.0478500366210938e+01 8.1181198358535767e-01 -4.5067396163940430e+00 3.0478500366210938e+01 -3.8375400543212891e+01 2.5930200576782227e+01 1.7724899291992188e+01 2.8557600021362305e+01 3.1677902221679688e+01 1.7725799560546875e+01 2.1873998641967773e+01 3.1033300399780273e+01 3.0476499557495117e+01 2.2732900619506836e+01 2.0160699844360352e+01 3.0476699829101562e+01 3.2750801086425781e+01 6.2813601493835449e+00 3.0478500366210938e+01 3.8171100616455078e+01 1.6532600402832031e+01 1.7724899291992188e+01 3.4899303436279297e+01 3.7707702636718750e+01 1.7724899291992188e+01 8.4654598236083984e+00 3.6223800659179688e+01 3.0478500366210938e+01 1.2949000358581543e+01 5.2079100608825684e+00 1.7724899291992188e+01 3.8213302612304688e+01 -3.4080798625946045e+00 1.7724899291992188e+01 3.8494800567626953e+01 -3.7614700317382812e+01 1.7724899291992188e+01 9.4110794067382812e+00 -1.6054100036621094e+01 1.7724899291992188e+01 -3.5240402221679688e+01 -5.2079100608825684e+00 1.7724899291992188e+01 -3.8213302612304688e+01 -3.8329299926757812e+01 1.7724899291992188e+01 -5.8210501670837402e+00 -3.2840499877929688e+01 1.7725599288940430e+01 -1.9909101486206055e+01 -2.6819799423217773e+01 1.7725000381469727e+01 -2.7747999191284180e+01 -1.7555700302124023e+01 1.7725000381469727e+01 3.4412902832031250e+01 -3.1601600646972656e+01 1.7725799560546875e+01 2.1895799636840820e+01 -2.5230501174926758e+01 1.7725101470947266e+01 2.9101999282836914e+01 -3.3142398834228516e+01 3.0476799011230469e+01 -1.9787399291992188e+01 -2.4508100509643555e+01 3.0477401733398438e+01 -2.9667200088500977e+01 -3.8129898071289062e+01 3.0478500366210938e+01 6.3573803901672363e+00 -3.7880397796630859e+01 3.0478500366210938e+01 -7.4131999015808105e+00 -1.6590700149536133e+01 3.0478500366210938e+01 -3.4709499359130859e+01 -2.8872499465942383e+01 3.0478199005126953e+01 2.5504301071166992e+01 -1.9341501235961914e+01 3.0477001190185547e+01 3.3339103698730469e+01 -3.4695800781250000e+01 3.0478500366210938e+01 1.6600400924682617e+01 -7.6062998771667480e+00 3.0478500366210938e+01 3.7799701690673828e+01 -4.9609901428222656e+01 6.7539604187011719e+01 8.1507596969604492e+00 -4.9868400573730469e+01 6.7539604187011719e+01 -6.8321399688720703e+00 -4.9947601318359375e+01 6.5034301757812500e+01 -5.4530901908874512e+00 -4.4943298339843750e+01 6.7539604187011719e+01 2.2791400909423828e+01 -3.5167198181152344e+01 6.7539604187011719e+01 3.5853599548339844e+01 -4.9730598449707031e+01 6.5034301757812500e+01 6.7970499992370605e+00 2.9969398975372314e+00 6.5034301757812500e+01 5.0145702362060547e+01 6.9386696815490723e+00 6.7539604187011719e+01 4.9888397216796875e+01 4.8833702087402344e+01 6.7539604187011719e+01 1.3304400444030762e+01 4.0471401214599609e+01 6.7539604187011719e+01 2.9807500839233398e+01 4.9868400573730469e+01 6.7539604187011719e+01 -6.8321399688720703e+00 2.5877500534057617e+01 6.7539604187011719e+01 4.3248897552490234e+01 2.9460500717163086e+01 6.5034301757812500e+01 4.0491600036621094e+01 -1.0601699829101562e+01 6.7539604187011719e+01 4.9272800445556641e+01 -2.4852701187133789e+01 6.7539604187011719e+01 4.3484500885009766e+01 -2.9969398975372314e+00 6.5034301757812500e+01 -5.0145702362060547e+01 -4.6939998626708984e+01 6.5034301757812500e+01 -1.7957401275634766e+01 4.3438598632812500e+01 6.7539604187011719e+01 -2.5998600006103516e+01 -2.4852701187133789e+01 6.7539604187011719e+01 -4.3484500885009766e+01 -1.0601699829101562e+01 6.7539604187011719e+01 -4.9272800445556641e+01 1.7176401138305664e+01 6.7539604187011719e+01 -4.7315002441406250e+01 3.1059000015258789e+01 6.7539604187011719e+01 -3.9376998901367188e+01 2.9829699993133545e+00 6.7539604187011719e+01 -5.0146999359130859e+01 -3.5167198181152344e+01 6.7539604187011719e+01 -3.5853599548339844e+01 -4.4943298339843750e+01 6.7539604187011719e+01 -2.2791400909423828e+01 -1.1755400657653809e+01 1.6967199325561523e+01 1.1027499437332153e+00 1.0264200210571289e+01 6.8385604858398438e+01 2.9392998218536377e+00 1.0690099716186523e+01 5.6955596923828125e+01 0.0000000000000000e+00 8.1825199127197266e+00 6.8391502380371094e+01 6.8735299110412598e+00 5.0151400566101074e+00 6.8400596618652344e+01 9.4172601699829102e+00 -6.3304600715637207e+00 6.8557899475097656e+01 -1.2118599891662598e+01 -5.5505099296569824e+00 6.8545295715332031e+01 1.2124200820922852e+01 -1.3189299583435059e+01 6.8547706604003906e+01 -2.1639201641082764e+00 -1.1655500411987305e+01 6.8542694091796875e+01 6.2997603416442871e+00 6.3305301666259766e+00 6.8557899475097656e+01 1.2118599891662598e+01 1.3189299583435059e+01 6.8547706604003906e+01 2.1639201641082764e+00 1.2706499099731445e+01 6.7540802001953125e+01 -6.5114102363586426e+00 3.8211998939514160e+00 6.7540100097656250e+01 -1.4019599914550781e+01 -3.8208501338958740e+00 6.7541503906250000e+01 1.4018300056457520e+01 8.3117198944091797e+00 6.7541999816894531e+01 1.1874300003051758e+01 1.4127900123596191e+01 6.7540000915527344e+01 3.0538599491119385e+00 -1.2706499099731445e+01 6.7540802001953125e+01 6.5114398002624512e+00 -8.3115901947021484e+00 6.7541999816894531e+01 -1.1874400138854980e+01 -1.4127199172973633e+01 6.7540802001953125e+01 -3.0536701679229736e+00 )) mat)))
                  )
                 ))
      (send glv :transform local-cds)
      (send glv :calc-normals)
      (setq qhull
            ;; qhull 3000 -> 81 faces
            (instance faceset :init :faces (list
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1677901744842529e+01 1.7725799232721329e+01 2.1873999387025833e+01) (float-vector 1.6532599925994873e+01 1.7724899575114250e+01 3.4899301826953888e+01) (float-vector 1.5174100175499916e+01 3.2350499182939529e+01 6.8473696708679199e+01) (float-vector 4.3375499546527863e+01 3.2257098704576492e+01 5.4680000990629196e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.7057100087404251e+01 4.3022301048040390e+01 7.3550097644329071e+01) (float-vector 3.0671700835227966e+01 5.4978098720312119e+01 7.2120100259780884e+01) (float-vector 4.4562898576259613e+01 5.4979100823402405e+01 6.4476996660232544e+01) (float-vector 5.6477800011634827e+01 4.9067698419094086e+01 5.5839899927377701e+01) (float-vector 4.2892999947071075e+01 3.7266198545694351e+01 6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.6477800011634827e+01 4.9067698419094086e+01 5.5839899927377701e+01) (float-vector 6.6686600446701050e+01 4.9065399914979935e+01 4.3129801750183105e+01) (float-vector 6.4126297831535339e+01 3.7265900522470474e+01 3.9661299437284470e+01) (float-vector 4.3375499546527863e+01 3.2257098704576492e+01 5.4680000990629196e+01) (float-vector 4.2892999947071075e+01 3.7266198545694351e+01 6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.1731800884008408e+01 4.8429001122713089e+01 -6.7475102841854095e+01) (float-vector 2.7057100087404251e+01 5.4977700114250183e+01 -7.3550097644329071e+01) (float-vector 3.4459200105629861e-01 4.8954900354146957e+01 -7.9383298754692078e+01) (float-vector 1.2114600278437138e+01 3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector 3.0671700835227966e+01 4.3021898716688156e+01 -7.2120100259780884e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7341399798169732e+00 5.9608001261949539e+01 -7.6071098446846008e+01) (float-vector -1.2114600278437138e+01 5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector 3.4459200105629861e-01 4.8954900354146957e+01 -7.9383298754692078e+01) (float-vector 2.7057100087404251e+01 5.4977700114250183e+01 -7.3550097644329071e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.7614699453115463e+01 1.7724899575114250e+01 9.4110798090696335e+00) (float-vector -6.7285202443599701e+01 3.2246299088001251e+01 1.7788499593734741e+01) (float-vector -7.0040397346019745e+01 3.8387000560760498e+01 2.9782500118017197e+01) (float-vector -6.2013100832700729e+01 3.7266198545694351e+01 4.2892999947071075e+01) (float-vector -4.9207698553800583e+01 3.2231401652097702e+01 4.9181401729583740e+01) (float-vector -2.5230500847101212e+01 1.7725100740790367e+01 2.9101999476552010e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3129801750183105e+01 4.9065399914979935e+01 6.6686600446701050e+01) (float-vector -3.9661299437284470e+01 3.7265900522470474e+01 6.4126297831535339e+01) (float-vector -4.9207698553800583e+01 3.2231401652097702e+01 4.9181401729583740e+01) (float-vector -6.2013100832700729e+01 3.7266198545694351e+01 4.2892999947071075e+01) (float-vector -5.4402600973844528e+01 4.8448301851749420e+01 5.7758700102567673e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.9661299437284470e+01 3.7265900522470474e+01 6.4126297831535339e+01) (float-vector -4.3129801750183105e+01 4.9065399914979935e+01 6.6686600446701050e+01) (float-vector -2.7057100087404251e+01 5.4977700114250183e+01 7.3550097644329071e+01) (float-vector -1.4203500002622604e+01 4.9050800502300262e+01 7.8114800155162811e+01) (float-vector -2.6272999122738838e+01 3.8387499749660492e+01 7.1428798139095306e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.2892999947071075e+01 6.0733798891305923e+01 6.2013100832700729e+01) (float-vector -5.3850099444389343e+01 6.1509799212217331e+01 5.2007101476192474e+01) (float-vector -5.6481499224901199e+01 6.5751999616622925e+01 4.0725000202655792e+01) (float-vector -4.3375499546527863e+01 6.5742902457714081e+01 5.4680000990629196e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.6819799095392227e+01 1.7725000157952309e+01 -2.7747999876737595e+01) (float-vector -3.7614699453115463e+01 1.7724899575114250e+01 9.4110798090696335e+00) (float-vector -2.5230500847101212e+01 1.7725100740790367e+01 2.9101999476552010e+01) (float-vector -3.4080799669027328e+00 1.7724899575114250e+01 3.8494799286127090e+01) (float-vector 1.6532599925994873e+01 1.7724899575114250e+01 3.4899301826953888e+01) (float-vector 3.1677901744842529e+01 1.7725799232721329e+01 2.1873999387025833e+01) (float-vector 3.7004400044679642e+01 1.7724899575114250e+01 -1.1183599941432476e+01) (float-vector 2.3136500269174576e+01 1.7725700512528419e+01 -3.0678000301122665e+01) (float-vector -5.2079102024435997e+00 1.7724899575114250e+01 -3.8213301450014114e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.7057100087404251e+01 4.3022301048040390e+01 7.3550097644329071e+01) (float-vector 1.7341399798169732e+00 3.8391999900341034e+01 7.6071098446846008e+01) (float-vector 3.4459200105629861e-01 4.9045100808143616e+01 7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7341399798169732e+00 3.8391999900341034e+01 7.6071098446846008e+01) (float-vector 2.7057100087404251e+01 4.3022301048040390e+01 7.3550097644329071e+01) (float-vector 4.2892999947071075e+01 3.7266198545694351e+01 6.2013100832700729e+01) (float-vector 4.3375499546527863e+01 3.2257098704576492e+01 5.4680000990629196e+01) (float-vector 1.5174100175499916e+01 3.2350499182939529e+01 6.8473696708679199e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7341399798169732e+00 3.8391999900341034e+01 7.6071098446846008e+01) (float-vector 1.5174100175499916e+01 3.2350499182939529e+01 6.8473696708679199e+01) (float-vector 1.6532599925994873e+01 1.7724899575114250e+01 3.4899301826953888e+01) (float-vector -3.4080799669027328e+00 1.7724899575114250e+01 3.8494799286127090e+01) (float-vector -2.1015599370002747e+01 3.2246299088001251e+01 6.6359199583530426e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.9661299437284470e+01 3.7265900522470474e+01 6.4126297831535339e+01) (float-vector -2.6272999122738838e+01 3.8387499749660492e+01 7.1428798139095306e+01) (float-vector -2.1015599370002747e+01 3.2246299088001251e+01 6.6359199583530426e+01) (float-vector -3.4080799669027328e+00 1.7724899575114250e+01 3.8494799286127090e+01) (float-vector -2.5230500847101212e+01 1.7725100740790367e+01 2.9101999476552010e+01) (float-vector -4.9207698553800583e+01 3.2231401652097702e+01 4.9181401729583740e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.4459200105629861e-01 4.9045100808143616e+01 7.9383298754692078e+01) (float-vector 1.7341399798169732e+00 3.8391999900341034e+01 7.6071098446846008e+01) (float-vector -2.1015599370002747e+01 3.2246299088001251e+01 6.6359199583530426e+01) (float-vector -2.6272999122738838e+01 3.8387499749660492e+01 7.1428798139095306e+01) (float-vector -1.4203500002622604e+01 4.9050800502300262e+01 7.8114800155162811e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.3644801974296570e+01 4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector 7.4474796652793884e+01 3.8389399647712708e+01 -1.5645200386643410e+01) (float-vector 7.9383201897144318e+01 4.9045100808143616e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.2892999947071075e+01 6.0733798891305923e+01 -6.2013100832700729e+01) (float-vector 5.6185498833656311e+01 6.5768502652645111e+01 -4.1026100516319275e+01) (float-vector 1.5174100175499916e+01 6.5649501979351044e+01 -6.8473696708679199e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.2892999947071075e+01 6.0733798891305923e+01 -6.2013100832700729e+01) (float-vector 2.7057100087404251e+01 5.4977700114250183e+01 -7.3550097644329071e+01) (float-vector 4.1731800884008408e+01 4.8429001122713089e+01 -6.7475102841854095e+01) (float-vector 5.3966101258993149e+01 5.4978400468826294e+01 -5.6843299418687820e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.5174100175499916e+01 6.5649501979351044e+01 -6.8473696708679199e+01) (float-vector 1.7341399798169732e+00 5.9608001261949539e+01 -7.6071098446846008e+01) (float-vector 2.7057100087404251e+01 5.4977700114250183e+01 -7.3550097644329071e+01) (float-vector 4.2892999947071075e+01 6.0733798891305923e+01 -6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.4459200105629861e-01 4.9045100808143616e+01 7.9383298754692078e+01) (float-vector 1.7856500344350934e+00 5.4973501712083817e+01 7.8329898416996002e+01) (float-vector 3.0671700835227966e+01 5.4978098720312119e+01 7.2120100259780884e+01) (float-vector 2.7057100087404251e+01 4.3022301048040390e+01 7.3550097644329071e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6686600446701050e+01 4.9065399914979935e+01 4.3129801750183105e+01) (float-vector 6.2013100832700729e+01 6.0733798891305923e+01 4.2892999947071075e+01) (float-vector 7.3550097644329071e+01 5.4977700114250183e+01 2.7057100087404251e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.2013100832700729e+01 6.0733798891305923e+01 4.2892999947071075e+01) (float-vector 5.9105001389980316e+01 6.5766297280788422e+01 3.6562200635671616e+01) (float-vector 7.1366399526596069e+01 6.3560999929904938e+01 1.3268600217998028e+01) (float-vector 7.3550097644329071e+01 5.4977700114250183e+01 2.7057100087404251e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.2013100832700729e+01 6.0733798891305923e+01 4.2892999947071075e+01) (float-vector 6.6686600446701050e+01 4.9065399914979935e+01 4.3129801750183105e+01) (float-vector 5.6477800011634827e+01 4.9067698419094086e+01 5.5839899927377701e+01) (float-vector 4.4562898576259613e+01 5.4979100823402405e+01 6.4476996660232544e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.3644801974296570e+01 4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector 7.9383201897144318e+01 4.9045100808143616e+01 -3.4461999894119799e-01) (float-vector 7.5355298817157745e+01 6.0731600970029831e+01 1.7170599894598126e+00) (float-vector 7.1428798139095306e+01 5.9612501412630081e+01 -2.6272999122738838e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.1366399526596069e+01 6.3560999929904938e+01 1.3268600217998028e+01) (float-vector 7.5355298817157745e+01 6.0731600970029831e+01 1.7170599894598126e+00) (float-vector 7.9383201897144318e+01 4.9045100808143616e+01 -3.4461999894119799e-01) (float-vector 7.3550097644329071e+01 5.4977700114250183e+01 2.7057100087404251e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.6185498833656311e+01 3.2231498509645462e+01 -4.1026100516319275e+01) (float-vector -7.1374498307704926e+01 3.4436900168657303e+01 -1.3211200013756752e+01) (float-vector -6.7285202443599701e+01 3.2246299088001251e+01 1.7788499593734741e+01) (float-vector -3.7614699453115463e+01 1.7724899575114250e+01 9.4110798090696335e+00) (float-vector -2.6819799095392227e+01 1.7725000157952309e+01 -2.7747999876737595e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.3850099444389343e+01 3.6490198224782944e+01 -5.2007101476192474e+01) (float-vector -5.6185498833656311e+01 3.2231498509645462e+01 -4.1026100516319275e+01) (float-vector -2.6819799095392227e+01 1.7725000157952309e+01 -2.7747999876737595e+01) (float-vector -4.1918899863958359e+01 3.2255701720714569e+01 -5.5662799626588821e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.2079102024435997e+00 1.7724899575114250e+01 -3.8213301450014114e+01) (float-vector -4.8838402144610882e+00 3.2246299088001251e+01 -6.9384098052978516e+01) (float-vector -2.9782500118017197e+01 3.8387000560760498e+01 -7.0040397346019745e+01) (float-vector -4.1918899863958359e+01 3.2255701720714569e+01 -5.5662799626588821e+01) (float-vector -2.6819799095392227e+01 1.7725000157952309e+01 -2.7747999876737595e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.2114600278437138e+01 3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector 2.5049600750207901e+01 3.4442000091075897e+01 -6.8122602999210358e+01) (float-vector 3.0671700835227966e+01 4.3021898716688156e+01 -7.2120100259780884e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.1731800884008408e+01 4.8429001122713089e+01 -6.7475102841854095e+01) (float-vector 3.0671700835227966e+01 4.3021898716688156e+01 -7.2120100259780884e+01) (float-vector 2.5049600750207901e+01 3.4442000091075897e+01 -6.8122602999210358e+01) (float-vector 4.3921299278736115e+01 3.2241899520158768e+01 -5.3944598883390427e+01) (float-vector 5.6843299418687820e+01 4.3021600693464279e+01 -5.3966101258993149e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.3921299278736115e+01 3.2241899520158768e+01 -5.3944598883390427e+01) (float-vector 2.5049600750207901e+01 3.4442000091075897e+01 -6.8122602999210358e+01) (float-vector 1.2114600278437138e+01 3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector -4.8838402144610882e+00 3.2246299088001251e+01 -6.9384098052978516e+01) (float-vector -5.2079102024435997e+00 1.7724899575114250e+01 -3.8213301450014114e+01) (float-vector 2.3136500269174576e+01 1.7725700512528419e+01 -3.0678000301122665e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3375499546527863e+01 6.5742902457714081e+01 5.4680000990629196e+01) (float-vector -5.6481499224901199e+01 6.5751999616622925e+01 4.0725000202655792e+01) (float-vector -6.9488696753978729e+01 6.5759703516960144e+01 1.4109100447967649e+00) (float-vector -5.8180298656225204e+01 6.5755397081375122e+01 -3.8144998252391815e+01) (float-vector -3.9661098271608353e+01 6.5756000578403473e+01 -5.7238798588514328e+01) (float-vector 2.7445200830698013e+00 6.8581901490688324e+01 -1.2800700031220913e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.9661098271608353e+01 6.5756000578403473e+01 -5.7238798588514328e+01) (float-vector -5.8180298656225204e+01 6.5755397081375122e+01 -3.8144998252391815e+01) (float-vector -6.6670998930931091e+01 5.4979000240564346e+01 -4.1205700486898422e+01) (float-vector -5.5839899927377701e+01 4.8932299017906189e+01 -5.6477800011634827e+01) (float-vector -4.3129801750183105e+01 4.8934601247310638e+01 -6.6686600446701050e+01) (float-vector -3.9661299437284470e+01 6.0734100639820099e+01 -6.4126297831535339e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.1015599370002747e+01 6.5753698348999023e+01 -6.6359199583530426e+01) (float-vector 1.5174100175499916e+01 6.5649501979351044e+01 -6.8473696708679199e+01) (float-vector 5.6185498833656311e+01 6.5768502652645111e+01 -4.1026100516319275e+01) (float-vector 2.7445200830698013e+00 6.8581901490688324e+01 -1.2800700031220913e+01) (float-vector -3.9661098271608353e+01 6.5756000578403473e+01 -5.7238798588514328e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.1015599370002747e+01 6.5753698348999023e+01 -6.6359199583530426e+01) (float-vector -1.2114600278437138e+01 5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector 1.7341399798169732e+00 5.9608001261949539e+01 -7.6071098446846008e+01) (float-vector 1.5174100175499916e+01 6.5649501979351044e+01 -6.8473696708679199e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.1015599370002747e+01 6.5753698348999023e+01 -6.6359199583530426e+01) (float-vector -3.9661098271608353e+01 6.5756000578403473e+01 -5.7238798588514328e+01) (float-vector -3.9661299437284470e+01 6.0734100639820099e+01 -6.4126297831535339e+01) (float-vector -1.2114600278437138e+01 5.9610001742839813e+01 -7.5127199292182922e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -6.7285202443599701e+01 3.2246299088001251e+01 1.7788499593734741e+01) (float-vector -7.5355298817157745e+01 3.7268400192260742e+01 1.7170599894598126e+00) (float-vector -7.0040397346019745e+01 3.8387000560760498e+01 2.9782500118017197e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.5355298817157745e+01 3.7268400192260742e+01 1.7170599894598126e+00) (float-vector -6.7285202443599701e+01 3.2246299088001251e+01 1.7788499593734741e+01) (float-vector -7.1374498307704926e+01 3.4436900168657303e+01 -1.3211200013756752e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.5839899927377701e+01 4.8932299017906189e+01 -5.6477800011634827e+01) (float-vector -6.4476996660232544e+01 4.3020900338888168e+01 -4.4562898576259613e+01) (float-vector -5.3850099444389343e+01 3.6490198224782944e+01 -5.2007101476192474e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.3644801974296570e+01 4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector -6.4476996660232544e+01 4.3020900338888168e+01 -4.4562898576259613e+01) (float-vector -5.5839899927377701e+01 4.8932299017906189e+01 -5.6477800011634827e+01) (float-vector -6.6670998930931091e+01 5.4979000240564346e+01 -4.1205700486898422e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.3951698839664459e+01 4.8940598964691162e+01 2.8930399566888809e+01) (float-vector -7.0040397346019745e+01 3.8387000560760498e+01 2.9782500118017197e+01) (float-vector -7.5355298817157745e+01 3.7268400192260742e+01 1.7170599894598126e+00) (float-vector -7.9383201897144318e+01 4.8954900354146957e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6686600446701050e+01 4.9065399914979935e+01 4.3129801750183105e+01) (float-vector 7.2120100259780884e+01 4.3021898716688156e+01 3.0671700835227966e+01) (float-vector 6.4126297831535339e+01 3.7265900522470474e+01 3.9661299437284470e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.5127199292182922e+01 3.8389999419450760e+01 1.2114600278437138e+01) (float-vector 7.2120100259780884e+01 4.3021898716688156e+01 3.0671700835227966e+01) (float-vector 6.6686600446701050e+01 4.9065399914979935e+01 4.3129801750183105e+01) (float-vector 7.3550097644329071e+01 5.4977700114250183e+01 2.7057100087404251e+01) (float-vector 7.9383201897144318e+01 4.9045100808143616e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.4474796652793884e+01 3.8389399647712708e+01 -1.5645200386643410e+01) (float-vector 6.9488696753978729e+01 3.2240301370620728e+01 1.4109000330790877e+00) (float-vector 7.5127199292182922e+01 3.8389999419450760e+01 1.2114600278437138e+01) (float-vector 7.9383201897144318e+01 4.9045100808143616e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.4476996660232544e+01 5.4979100823402405e+01 -4.4562898576259613e+01) (float-vector 6.6202603280544281e+01 4.9065899103879929e+01 -4.3869800865650177e+01) (float-vector 7.3644801974296570e+01 4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector 7.1428798139095306e+01 5.9612501412630081e+01 -2.6272999122738838e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6202603280544281e+01 4.9065899103879929e+01 -4.3869800865650177e+01) (float-vector 6.4476996660232544e+01 5.4979100823402405e+01 -4.4562898576259613e+01) (float-vector 5.3966101258993149e+01 5.4978400468826294e+01 -5.6843299418687820e+01) (float-vector 4.1731800884008408e+01 4.8429001122713089e+01 -6.7475102841854095e+01) (float-vector 5.6843299418687820e+01 4.3021600693464279e+01 -5.3966101258993149e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.1428798139095306e+01 5.9612501412630081e+01 -2.6272999122738838e+01) (float-vector 5.6185498833656311e+01 6.5768502652645111e+01 -4.1026100516319275e+01) (float-vector 4.2892999947071075e+01 6.0733798891305923e+01 -6.2013100832700729e+01) (float-vector 5.3966101258993149e+01 5.4978400468826294e+01 -5.6843299418687820e+01) (float-vector 6.4476996660232544e+01 5.4979100823402405e+01 -4.4562898576259613e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 6.5753698348999023e+01 -2.1015599370002747e+01) (float-vector 5.6185498833656311e+01 6.5768502652645111e+01 -4.1026100516319275e+01) (float-vector 7.1428798139095306e+01 5.9612501412630081e+01 -2.6272999122738838e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 6.5753698348999023e+01 -2.1015599370002747e+01) (float-vector 7.1366399526596069e+01 6.3560999929904938e+01 1.3268600217998028e+01) (float-vector 5.9105001389980316e+01 6.5766297280788422e+01 3.6562200635671616e+01) (float-vector 2.7445200830698013e+00 6.8581901490688324e+01 -1.2800700031220913e+01) (float-vector 5.6185498833656311e+01 6.5768502652645111e+01 -4.1026100516319275e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.1366399526596069e+01 6.3560999929904938e+01 1.3268600217998028e+01) (float-vector 6.6359199583530426e+01 6.5753698348999023e+01 -2.1015599370002747e+01) (float-vector 7.1428798139095306e+01 5.9612501412630081e+01 -2.6272999122738838e+01) (float-vector 7.5355298817157745e+01 6.0731600970029831e+01 1.7170599894598126e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.5645200386643410e+01 3.8389399647712708e+01 -7.4474796652793884e+01) (float-vector -2.9782500118017197e+01 3.8387000560760498e+01 -7.0040397346019745e+01) (float-vector -4.8838402144610882e+00 3.2246299088001251e+01 -6.9384098052978516e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.5645200386643410e+01 3.8389399647712708e+01 -7.4474796652793884e+01) (float-vector -4.8838402144610882e+00 3.2246299088001251e+01 -6.9384098052978516e+01) (float-vector 1.2114600278437138e+01 3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector 3.4459200105629861e-01 4.8954900354146957e+01 -7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.4474796652793884e+01 5.9610601514577866e+01 -1.5645200386643410e+01) (float-vector -5.8180298656225204e+01 6.5755397081375122e+01 -3.8144998252391815e+01) (float-vector -6.9488696753978729e+01 6.5759703516960144e+01 1.4109100447967649e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.4474796652793884e+01 5.9610601514577866e+01 -1.5645200386643410e+01) (float-vector -7.3644801974296570e+01 4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector -6.6670998930931091e+01 5.4979000240564346e+01 -4.1205700486898422e+01) (float-vector -5.8180298656225204e+01 6.5755397081375122e+01 -3.8144998252391815e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.3850099444389343e+01 3.6490198224782944e+01 -5.2007101476192474e+01) (float-vector -6.4476996660232544e+01 4.3020900338888168e+01 -4.4562898576259613e+01) (float-vector -7.3644801974296570e+01 4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector -7.6686702668666840e+01 4.3023999780416489e+01 -1.6111699864268303e+01) (float-vector -7.1374498307704926e+01 3.4436900168657303e+01 -1.3211200013756752e+01) (float-vector -5.6185498833656311e+01 3.2231498509645462e+01 -4.1026100516319275e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.9383201897144318e+01 4.8954900354146957e+01 -3.4461999894119799e-01) (float-vector -7.6686702668666840e+01 4.3023999780416489e+01 -1.6111699864268303e+01) (float-vector -7.3644801974296570e+01 4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector -7.4474796652793884e+01 5.9610601514577866e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.1374498307704926e+01 3.4436900168657303e+01 -1.3211200013756752e+01) (float-vector -7.6686702668666840e+01 4.3023999780416489e+01 -1.6111699864268303e+01) (float-vector -7.9383201897144318e+01 4.8954900354146957e+01 -3.4461999894119799e-01) (float-vector -7.5355298817157745e+01 3.7268400192260742e+01 1.7170599894598126e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.0040397346019745e+01 3.8387000560760498e+01 2.9782500118017197e+01) (float-vector -7.3951698839664459e+01 4.8940598964691162e+01 2.8930399566888809e+01) (float-vector -6.4476996660232544e+01 5.4979100823402405e+01 4.4562898576259613e+01) (float-vector -5.4402600973844528e+01 4.8448301851749420e+01 5.7758700102567673e+01) (float-vector -6.2013100832700729e+01 3.7266198545694351e+01 4.2892999947071075e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.2892999947071075e+01 6.0733798891305923e+01 6.2013100832700729e+01) (float-vector -2.7057100087404251e+01 5.4977700114250183e+01 7.3550097644329071e+01) (float-vector -4.3129801750183105e+01 4.9065399914979935e+01 6.6686600446701050e+01) (float-vector -5.4402600973844528e+01 4.8448301851749420e+01 5.7758700102567673e+01) (float-vector -6.4476996660232544e+01 5.4979100823402405e+01 4.4562898576259613e+01) (float-vector -5.3850099444389343e+01 6.1509799212217331e+01 5.2007101476192474e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 3.2246299088001251e+01 -2.1015599370002747e+01) (float-vector 6.9488696753978729e+01 3.2240301370620728e+01 1.4109000330790877e+00) (float-vector 7.4474796652793884e+01 3.8389399647712708e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.9488696753978729e+01 3.2240301370620728e+01 1.4109000330790877e+00) (float-vector 6.7513503134250641e+01 3.4440599381923676e+01 2.6707200333476067e+01) (float-vector 7.5127199292182922e+01 3.8389999419450760e+01 1.2114600278437138e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.7513503134250641e+01 3.4440599381923676e+01 2.6707200333476067e+01) (float-vector 6.9488696753978729e+01 3.2240301370620728e+01 1.4109000330790877e+00) (float-vector 6.6359199583530426e+01 3.2246299088001251e+01 -2.1015599370002747e+01) (float-vector 3.7004400044679642e+01 1.7724899575114250e+01 -1.1183599941432476e+01) (float-vector 3.1677901744842529e+01 1.7725799232721329e+01 2.1873999387025833e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.7513503134250641e+01 3.4440599381923676e+01 2.6707200333476067e+01) (float-vector 6.4126297831535339e+01 3.7265900522470474e+01 3.9661299437284470e+01) (float-vector 7.2120100259780884e+01 4.3021898716688156e+01 3.0671700835227966e+01) (float-vector 7.5127199292182922e+01 3.8389999419450760e+01 1.2114600278437138e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.4126297831535339e+01 3.7265900522470474e+01 3.9661299437284470e+01) (float-vector 6.7513503134250641e+01 3.4440599381923676e+01 2.6707200333476067e+01) (float-vector 3.1677901744842529e+01 1.7725799232721329e+01 2.1873999387025833e+01) (float-vector 4.3375499546527863e+01 3.2257098704576492e+01 5.4680000990629196e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3375499546527863e+01 6.5742902457714081e+01 5.4680000990629196e+01) (float-vector -1.5174100175499916e+01 6.5649501979351044e+01 6.8473696708679199e+01) (float-vector -2.7057100087404251e+01 5.4977700114250183e+01 7.3550097644329071e+01) (float-vector -4.2892999947071075e+01 6.0733798891305923e+01 6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.4562898576259613e+01 5.4979100823402405e+01 6.4476996660232544e+01) (float-vector 3.0671700835227966e+01 5.4978098720312119e+01 7.2120100259780884e+01) (float-vector 2.1015599370002747e+01 6.5753698348999023e+01 6.6359199583530426e+01) (float-vector 3.6946401000022888e+01 6.5759100019931793e+01 5.8903798460960388e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.6946401000022888e+01 6.5759100019931793e+01 5.8903798460960388e+01) (float-vector 5.9105001389980316e+01 6.5766297280788422e+01 3.6562200635671616e+01) (float-vector 6.2013100832700729e+01 6.0733798891305923e+01 4.2892999947071075e+01) (float-vector 4.4562898576259613e+01 5.4979100823402405e+01 6.4476996660232544e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.2114600278437138e+01 5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector -2.8930399566888809e+01 4.8940598964691162e+01 -7.3951698839664459e+01) (float-vector 3.4459200105629861e-01 4.8954900354146957e+01 -7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3129801750183105e+01 4.8934601247310638e+01 -6.6686600446701050e+01) (float-vector -2.8930399566888809e+01 4.8940598964691162e+01 -7.3951698839664459e+01) (float-vector -1.2114600278437138e+01 5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector -3.9661299437284470e+01 6.0734100639820099e+01 -6.4126297831535339e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.8930399566888809e+01 4.8940598964691162e+01 -7.3951698839664459e+01) (float-vector -2.9782500118017197e+01 3.8387000560760498e+01 -7.0040397346019745e+01) (float-vector -1.5645200386643410e+01 3.8389399647712708e+01 -7.4474796652793884e+01) (float-vector 3.4459200105629861e-01 4.8954900354146957e+01 -7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.3850099444389343e+01 3.6490198224782944e+01 -5.2007101476192474e+01) (float-vector -4.1918899863958359e+01 3.2255701720714569e+01 -5.5662799626588821e+01) (float-vector -2.9782500118017197e+01 3.8387000560760498e+01 -7.0040397346019745e+01) (float-vector -2.8930399566888809e+01 4.8940598964691162e+01 -7.3951698839664459e+01) (float-vector -4.3129801750183105e+01 4.8934601247310638e+01 -6.6686600446701050e+01) (float-vector -5.5839899927377701e+01 4.8932299017906189e+01 -5.6477800011634827e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.6481499224901199e+01 6.5751999616622925e+01 4.0725000202655792e+01) (float-vector -7.1428798139095306e+01 5.9612501412630081e+01 2.6272999122738838e+01) (float-vector -6.9488696753978729e+01 6.5759703516960144e+01 1.4109100447967649e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.1428798139095306e+01 5.9612501412630081e+01 2.6272999122738838e+01) (float-vector -6.4476996660232544e+01 5.4979100823402405e+01 4.4562898576259613e+01) (float-vector -7.3951698839664459e+01 4.8940598964691162e+01 2.8930399566888809e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.1428798139095306e+01 5.9612501412630081e+01 2.6272999122738838e+01) (float-vector -5.6481499224901199e+01 6.5751999616622925e+01 4.0725000202655792e+01) (float-vector -5.3850099444389343e+01 6.1509799212217331e+01 5.2007101476192474e+01) (float-vector -6.4476996660232544e+01 5.4979100823402405e+01 4.4562898576259613e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -6.9488696753978729e+01 6.5759703516960144e+01 1.4109100447967649e+00) (float-vector -7.1428798139095306e+01 5.9612501412630081e+01 2.6272999122738838e+01) (float-vector -7.3951698839664459e+01 4.8940598964691162e+01 2.8930399566888809e+01) (float-vector -7.9383201897144318e+01 4.8954900354146957e+01 -3.4461999894119799e-01) (float-vector -7.4474796652793884e+01 5.9610601514577866e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.6820500642061234e+01 3.2238200306892395e+01 -4.0331300348043442e+01) (float-vector 5.6843299418687820e+01 4.3021600693464279e+01 -5.3966101258993149e+01) (float-vector 4.3921299278736115e+01 3.2241899520158768e+01 -5.3944598883390427e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 3.2246299088001251e+01 -2.1015599370002747e+01) (float-vector 5.6820500642061234e+01 3.2238200306892395e+01 -4.0331300348043442e+01) (float-vector 4.3921299278736115e+01 3.2241899520158768e+01 -5.3944598883390427e+01) (float-vector 2.3136500269174576e+01 1.7725700512528419e+01 -3.0678000301122665e+01) (float-vector 3.7004400044679642e+01 1.7724899575114250e+01 -1.1183599941432476e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.3644801974296570e+01 4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector 6.6202603280544281e+01 4.9065899103879929e+01 -4.3869800865650177e+01) (float-vector 5.6843299418687820e+01 4.3021600693464279e+01 -5.3966101258993149e+01) (float-vector 5.6820500642061234e+01 3.2238200306892395e+01 -4.0331300348043442e+01) (float-vector 6.6359199583530426e+01 3.2246299088001251e+01 -2.1015599370002747e+01) (float-vector 7.4474796652793884e+01 3.8389399647712708e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.4203500002622604e+01 4.9050800502300262e+01 7.8114800155162811e+01) (float-vector -2.7057100087404251e+01 5.4977700114250183e+01 7.3550097644329071e+01) (float-vector -1.5174100175499916e+01 6.5649501979351044e+01 6.8473696708679199e+01) (float-vector 5.1130601204931736e+00 6.3596703112125397e+01 7.2644703090190887e+01) (float-vector 1.7856500344350934e+00 5.4973501712083817e+01 7.8329898416996002e+01) (float-vector 3.4459200105629861e-01 4.9045100808143616e+01 7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.1130601204931736e+00 6.3596703112125397e+01 7.2644703090190887e+01) (float-vector 2.1015599370002747e+01 6.5753698348999023e+01 6.6359199583530426e+01) (float-vector 3.0671700835227966e+01 5.4978098720312119e+01 7.2120100259780884e+01) (float-vector 1.7856500344350934e+00 5.4973501712083817e+01 7.8329898416996002e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.9105001389980316e+01 6.5766297280788422e+01 3.6562200635671616e+01) (float-vector 3.6946401000022888e+01 6.5759100019931793e+01 5.8903798460960388e+01) (float-vector 2.1015599370002747e+01 6.5753698348999023e+01 6.6359199583530426e+01) (float-vector 5.1130601204931736e+00 6.3596703112125397e+01 7.2644703090190887e+01) (float-vector -1.5174100175499916e+01 6.5649501979351044e+01 6.8473696708679199e+01) (float-vector -4.3375499546527863e+01 6.5742902457714081e+01 5.4680000990629196e+01) (float-vector 2.7445200830698013e+00 6.8581901490688324e+01 -1.2800700031220913e+01)))))
              ))
             )
      (setq geom (instance collada-body :init :replace-obj qhull :name "bl_caster_r_wheel_link_geom0"))
      (when glv
        (setq (geom . gl::aglvertices) glv)
        (send geom :assoc glv))
      geom))
  (:_make_instance_bl_caster_rotation_link_geom0 ()
    (let (geom glv qhull
          (local-cds (make-coords :pos (float-vector -2.2459999999999999e+02 2.2459999999999999e+02 2.8199999999999999e+01))))
      (setq glv
       (instance gl::glvertices :init
                 (list ;; mesh list
                  (list ;; mesh description
                   (list :type :triangles)
                   (list :material (list
                    (list :ambient (float-vector 0.000100 0.000100 0.000100 1.000000))
                    (list :diffuse (float-vector 0.000000 0.000000 0.000000 1.000000))))
                   (list :indices #i( 0 1 2 162 0 2 1 0 151 0 162 151 1 151 152 1 152 215 1 284 2 1 215 284 151 223 152 151 162 223 2 299 162 162 299 223 274 299 2 150 299 274 299 150 223 2 273 274 274 351 148 150 274 148 289 351 274 273 289 274 168 148 351 288 351 289 351 166 168 166 351 288 288 289 175 273 175 289 177 167 288 288 175 177 166 288 167 166 167 168 167 311 168 235 234 167 234 380 167 454 167 380 235 167 177 311 167 454 453 311 454 182 311 453 168 311 182 453 454 451 454 380 451 159 182 453 451 159 453 451 160 159 160 451 380 159 160 161 181 182 159 214 181 159 214 159 161 161 160 380 440 214 161 161 380 440 347 158 214 214 440 347 158 181 214 181 339 47 181 47 182 158 339 181 37 158 134 134 158 347 158 37 339 476 47 339 476 339 37 72 476 36 68 476 427 476 68 47 72 427 476 476 37 36 36 37 38 70 72 36 91 36 38 91 70 36 38 37 368 23 38 368 91 38 287 287 38 23 91 86 70 91 195 86 91 287 195 86 87 70 498 87 86 195 498 86 35 195 287 35 318 195 498 195 497 195 318 497 498 497 418 498 418 87 418 331 87 87 331 70 331 90 71 331 426 90 418 426 331 70 331 71 70 71 72 72 71 82 71 412 82 71 90 412 72 82 414 414 427 72 82 329 414 412 329 82 412 413 329 90 89 412 412 89 413 328 329 142 328 191 329 191 414 329 329 413 142 190 414 191 190 427 414 190 68 427 189 190 191 189 69 190 69 68 190 205 191 328 189 191 205 141 328 142 141 205 328 204 189 205 216 218 205 212 216 205 218 204 205 212 205 141 189 204 499 499 69 189 499 204 42 499 42 452 499 452 69 42 43 44 201 42 202 42 44 202 452 42 201 204 43 42 43 330 44 43 327 344 43 344 330 204 327 43 44 330 325 44 325 202 324 202 325 202 324 201 452 201 324 45 452 46 45 69 452 452 324 341 341 46 452 45 46 47 45 68 69 68 45 47 182 47 46 341 182 46 340 148 341 341 365 182 148 365 341 341 324 340 182 365 168 168 365 148 148 149 150 149 148 340 324 149 340 324 333 149 333 81 149 150 149 81 223 150 224 150 81 224 79 80 81 333 75 81 80 224 81 75 79 81 222 223 224 222 224 80 429 80 428 80 79 428 222 80 429 74 97 79 74 79 75 97 428 79 73 74 75 73 75 333 73 420 74 420 496 74 74 496 97 495 494 73 495 73 333 494 420 73 324 495 333 325 494 495 324 325 495 330 420 494 325 330 494 330 416 420 330 344 416 344 415 416 416 415 420 420 415 496 415 423 95 496 415 95 344 423 415 344 217 345 345 423 344 327 217 344 320 95 423 321 320 423 345 321 423 95 96 97 96 95 320 496 95 97 320 321 96 217 321 345 321 17 96 321 217 17 17 16 96 96 16 97 97 16 326 326 428 97 15 16 17 16 15 326 17 131 15 17 217 213 17 213 131 15 131 52 15 52 245 15 245 286 15 286 326 213 52 131 51 35 52 52 35 34 213 51 52 245 52 34 318 51 319 51 88 319 213 88 51 51 318 35 497 318 418 318 319 418 319 417 418 417 319 88 418 417 426 426 417 90 90 417 88 88 89 90 78 413 89 89 88 76 78 89 76 76 77 78 142 413 78 142 78 77 88 77 76 141 142 77 212 141 77 77 88 212 212 88 213 213 216 212 213 217 216 216 217 218 218 217 327 204 218 327 33 34 35 35 66 67 35 203 66 35 287 203 35 364 33 67 411 35 411 364 35 245 34 314 34 33 314 244 245 101 286 245 223 405 245 314 101 245 405 244 223 245 405 314 33 405 409 402 102 101 405 409 405 33 102 405 402 33 111 110 33 110 409 364 315 33 33 315 111 402 409 110 401 402 110 493 102 402 493 402 401 110 111 112 112 401 110 112 462 401 462 493 401 322 493 197 462 197 493 322 102 493 462 112 332 58 60 462 58 462 332 60 197 462 111 332 112 111 58 332 58 59 60 315 58 111 315 59 58 61 59 62 62 59 30 59 364 30 59 315 364 59 61 477 60 59 477 477 61 92 61 62 92 92 62 32 62 30 32 30 31 32 364 31 30 364 411 31 411 178 31 32 31 178 92 32 93 32 178 93 92 93 94 477 92 421 421 92 94 313 94 93 93 178 180 93 180 313 178 179 180 411 67 178 178 67 179 180 179 83 410 180 85 180 83 85 313 180 410 313 410 342 94 313 342 410 99 342 99 410 85 83 84 85 98 99 85 84 432 85 432 98 85 179 66 83 66 84 83 430 431 84 430 84 66 431 432 84 419 432 431 419 98 432 419 200 98 98 343 99 200 343 98 342 99 343 200 129 343 342 343 278 343 129 278 198 199 200 129 200 199 198 200 419 198 419 431 198 431 375 375 431 430 198 129 199 287 198 375 129 198 287 287 375 203 203 375 430 465 355 287 287 130 129 22 465 287 23 22 287 355 130 287 128 129 130 130 355 308 130 308 307 130 307 128 128 479 129 278 129 479 468 126 479 479 126 278 337 468 479 337 479 128 121 278 126 232 342 278 121 280 278 280 232 278 408 342 232 408 94 342 408 422 94 317 408 316 317 422 408 316 408 232 421 94 422 317 421 422 316 60 317 317 60 477 317 477 421 60 196 197 196 60 316 196 323 197 196 298 323 196 348 298 196 316 348 197 323 322 322 323 11 298 11 323 9 11 298 9 298 348 316 9 348 9 10 11 9 316 10 304 11 53 322 11 304 11 54 53 10 54 11 304 102 322 304 53 100 102 304 100 53 54 55 100 53 55 171 140 54 54 139 55 54 140 139 171 54 10 424 55 425 424 100 55 267 425 55 139 267 55 100 101 102 424 101 100 425 244 424 244 101 424 244 425 223 223 425 461 425 267 461 286 223 222 223 461 239 223 239 271 271 458 223 223 458 152 461 267 266 461 266 239 144 238 239 238 271 239 144 239 266 265 266 267 145 266 265 266 145 144 279 265 267 145 265 279 267 369 104 267 104 279 267 139 369 279 104 173 145 279 173 103 172 173 103 173 104 173 172 366 366 145 173 64 103 104 172 103 64 172 64 63 172 357 367 172 63 357 366 172 367 366 367 145 483 143 367 357 475 367 483 367 448 143 145 367 448 367 475 143 144 145 482 395 143 482 143 483 395 144 143 448 125 483 483 125 482 443 482 125 482 443 395 144 395 396 443 396 395 358 238 144 358 144 450 144 396 450 396 480 450 396 481 480 443 481 396 485 450 277 450 480 277 358 450 350 450 485 350 334 238 358 358 350 334 271 238 272 238 334 272 485 458 271 350 485 271 406 271 272 271 406 350 485 379 458 379 485 277 379 152 458 283 215 379 215 152 379 283 379 277 215 283 284 247 283 208 208 283 277 284 283 247 285 284 247 2 284 285 2 285 273 273 285 439 439 285 247 176 273 439 175 273 176 176 439 177 177 439 247 175 176 177 246 398 177 246 177 247 253 235 177 398 253 177 208 246 247 399 398 246 208 399 246 188 398 399 188 253 398 399 436 472 207 436 399 399 472 188 208 207 399 206 207 208 277 206 208 480 481 206 481 207 206 480 206 277 481 256 207 443 256 481 256 257 207 185 186 256 257 256 209 256 186 209 443 185 256 443 124 185 443 125 124 185 124 186 209 186 13 186 124 264 13 186 264 39 209 13 209 484 257 39 484 209 484 39 257 39 40 41 39 41 194 194 257 39 39 13 12 39 187 40 39 270 187 12 270 39 436 194 41 41 40 436 207 194 436 194 207 257 40 472 436 188 472 40 40 187 188 253 188 254 254 188 292 187 292 188 292 187 270 292 270 260 254 292 260 260 253 254 269 253 260 253 233 235 253 269 233 269 260 270 270 133 269 306 233 269 433 269 491 269 133 491 269 433 306 233 234 235 233 380 234 233 306 380 226 157 380 440 380 157 306 226 380 8 225 226 225 157 226 8 226 306 6 7 8 306 6 8 8 7 225 7 155 225 157 225 155 388 7 6 388 155 7 388 6 27 388 27 394 388 464 155 388 394 464 25 26 27 27 6 132 132 25 27 394 27 26 394 389 464 138 394 26 389 394 138 464 487 488 464 488 155 389 487 464 487 349 488 487 478 349 389 478 487 349 155 488 155 156 157 391 156 155 349 392 155 391 155 392 377 378 156 346 377 156 156 378 157 156 391 346 157 378 393 440 157 393 377 374 378 374 393 378 393 347 440 374 347 393 374 134 347 377 134 374 134 135 56 134 377 135 134 56 37 57 135 305 135 377 305 56 135 57 37 56 57 57 368 37 305 108 57 57 108 109 109 368 57 108 305 346 346 305 377 108 21 109 346 391 108 21 108 391 368 109 21 21 23 368 21 22 23 21 391 392 21 392 349 349 22 21 465 22 349 349 249 248 459 349 248 465 349 459 478 249 349 459 105 465 220 355 465 105 220 465 459 474 105 248 474 459 105 106 107 105 255 106 105 107 220 105 474 255 255 474 355 355 474 308 308 474 248 354 255 355 355 220 354 106 255 354 220 221 354 221 106 354 220 165 221 49 106 221 165 164 221 164 49 221 48 49 50 49 437 106 363 437 49 49 48 363 50 49 164 48 192 193 48 193 363 48 50 192 50 164 192 193 192 164 363 193 445 445 193 164 444 363 445 363 444 437 438 445 164 444 445 438 437 444 438 437 438 275 164 275 438 258 275 211 164 211 275 258 437 275 258 211 259 259 437 258 163 210 211 163 211 164 210 259 211 163 164 165 489 210 163 489 163 165 210 489 437 259 210 437 106 437 489 106 489 243 243 489 165 107 165 220 107 243 165 107 106 243 117 248 249 404 449 248 449 252 248 117 404 248 252 308 248 478 400 249 400 117 249 389 400 478 117 400 4 389 4 400 4 389 390 138 390 389 227 390 137 390 138 137 4 390 227 136 137 138 26 136 138 137 133 268 268 227 137 137 136 26 133 137 26 227 228 229 268 228 227 4 227 229 133 228 268 115 312 228 4 229 228 133 115 228 312 4 228 5 4 312 115 5 312 3 4 5 117 4 3 116 3 5 5 115 116 116 117 3 117 116 404 116 403 404 114 116 115 116 114 403 404 386 449 404 403 386 403 236 386 114 263 403 403 263 236 113 114 115 370 114 113 114 370 263 113 12 370 12 113 115 12 115 133 12 13 14 12 469 470 12 14 469 470 370 12 12 133 270 470 263 370 261 470 469 470 261 263 469 231 261 231 469 14 261 262 263 261 231 301 397 261 301 397 262 261 14 230 231 231 300 301 231 230 300 301 300 441 397 301 295 441 295 301 397 295 372 397 372 466 262 397 466 466 372 237 466 237 407 407 262 466 236 407 237 263 407 236 262 407 263 120 236 237 353 386 236 120 119 236 236 119 353 118 119 120 120 219 118 237 219 120 352 353 119 118 352 119 310 353 352 353 310 387 353 387 386 121 123 352 310 352 123 121 352 118 276 118 219 121 118 276 276 219 383 237 383 219 276 184 232 232 280 276 184 276 383 121 276 280 121 122 123 126 122 121 126 127 122 122 127 123 468 467 126 126 467 127 127 467 468 123 127 337 127 468 337 251 337 128 251 376 337 337 376 123 250 251 252 376 251 250 252 251 490 490 251 128 307 490 128 307 252 490 307 308 252 449 386 252 250 252 386 386 387 250 387 309 250 309 376 250 310 309 387 123 309 310 123 376 309 184 383 169 383 384 169 457 383 237 384 383 457 183 184 169 184 183 232 169 10 183 232 183 316 10 316 183 171 10 169 169 170 171 171 170 140 170 169 359 140 170 64 64 170 146 359 147 170 170 147 146 104 139 140 140 64 104 63 64 65 65 64 146 146 147 65 63 65 357 65 147 357 356 357 147 382 475 357 356 382 357 381 382 356 297 356 371 381 356 297 371 356 147 471 475 382 471 382 381 475 471 448 381 296 471 296 448 471 296 381 297 295 296 297 295 297 371 295 371 372 372 371 147 295 441 442 295 442 296 300 230 441 441 230 442 230 373 442 296 442 373 14 373 230 373 29 296 373 14 29 14 28 29 13 240 14 447 446 14 240 447 14 28 14 446 29 28 460 460 296 29 446 460 28 446 447 448 446 448 460 240 242 447 448 447 242 240 241 242 241 240 13 448 242 125 125 242 241 448 296 460 241 13 125 124 125 13 13 264 124 147 455 372 147 359 455 455 359 456 455 457 372 455 456 457 457 237 372 384 457 456 359 384 456 359 169 384 104 369 139 132 133 25 133 281 282 133 434 433 133 282 434 491 133 433 281 133 132 25 133 26 281 302 303 282 281 303 302 281 132 434 282 435 303 435 282 433 434 435 433 435 306 306 435 303 6 303 302 6 306 303 132 6 302 350 335 334 406 335 350 334 335 336 335 338 336 335 406 154 338 335 154 291 334 293 291 272 334 334 336 293 290 154 291 293 290 291 406 272 291 154 406 291 501 290 293 154 290 501 154 501 473 473 501 293 154 473 385 473 293 385 385 153 154 385 293 492 153 385 492 153 18 154 294 153 492 153 294 18 492 293 294 293 19 294 294 19 18 18 19 20 362 18 20 18 362 154 20 19 24 19 174 24 19 293 174 486 362 20 486 20 24 486 24 174 174 463 486 463 362 486 174 293 336 500 174 361 174 336 361 500 463 174 463 360 362 500 360 463 360 500 361 360 361 362 362 361 336 362 336 338 362 338 154 429 286 222 326 286 429 326 429 428 203 430 66 67 66 179))
                   (list :vertices (let ((mat (make-matrix 502 3))) (fvector-replace (array-entity mat) #f(1.5309399414062500e+02 -2.8678799438476562e+02 1.0526599884033203e+02 1.6749499511718750e+02 -2.8678799438476562e+02 1.0526599884033203e+02 1.4962998962402344e+02 -2.8165600585937500e+02 1.0526599884033203e+02 2.5771398925781250e+02 -1.5725999450683594e+02 1.3304998779296875e+02 2.4495401000976562e+02 -1.5231401062011719e+02 1.3304998779296875e+02 2.5889199829101562e+02 -1.5772599792480469e+02 1.3955000305175781e+02 1.7266799926757812e+02 -1.7026600646972656e+02 1.3304998779296875e+02 1.8274299621582031e+02 -1.9238999938964844e+02 1.3304998779296875e+02 1.7675300598144531e+02 -2.0243699645996094e+02 1.3304998779296875e+02 2.9864697265625000e+02 -2.3860499572753906e+02 1.0230000305175781e+02 3.1669802856445312e+02 -2.4011799621582031e+02 1.0230000305175781e+02 2.9776699829101562e+02 -2.4332800292968750e+02 1.0230000305175781e+02 2.8804498291015625e+02 -1.8449600219726562e+02 1.3955000305175781e+02 2.4302198791503906e+02 -2.9742898559570312e+02 1.3955000305175781e+02 2.7962301635742188e+02 -2.7573800659179688e+02 1.3955000305175781e+02 1.4557699584960938e+02 -2.5060800170898438e+02 -1.6409799575805664e+01 1.4248800659179688e+02 -2.5027900695800781e+02 -2.7892499923706055e+01 1.4242399597167969e+02 -2.5025099182128906e+02 -5.9969299316406250e+01 2.3170300292968750e+02 -3.0809997558593750e+02 -5.4909603118896484e+01 2.2893800354003906e+02 -3.1110000610351562e+02 -5.5569801330566406e+01 2.2042399597167969e+02 -3.0809997558593750e+02 -5.5612400054931641e+01 1.8657299804687500e+02 -1.5891499328613281e+02 1.0230000305175781e+02 1.9710000610351562e+02 -1.5458999633789062e+02 1.0230000305175781e+02 1.9573899841308594e+02 -1.6975000000000000e+02 1.0230000305175781e+02 2.1716299438476562e+02 -3.1110000610351562e+02 -5.4838798522949219e+01 1.8395500183105469e+02 -1.6153399658203125e+02 1.3955000305175781e+02 1.9309399414062500e+02 -1.5641400146484375e+02 1.3955000305175781e+02 1.8358898925781250e+02 -1.6171499633789062e+02 1.3304998779296875e+02 2.8716799926757812e+02 -2.6609997558593750e+02 1.3955000305175781e+02 2.9236502075195312e+02 -2.5684197998046875e+02 1.3955000305175781e+02 2.9864697265625000e+02 -2.1059500122070312e+02 -4.3196701049804688e+01 2.9844998168945312e+02 -2.0828900146484375e+02 -5.8984100341796875e+01 2.9835598754882812e+02 -2.0765798950195312e+02 -9.5243206024169922e+00 2.9099398803710938e+02 -2.4985200500488281e+02 -5.9969898223876953e+01 2.8664700317382812e+02 -2.5060498046875000e+02 -5.9969802856445312e+01 2.8664700317382812e+02 -1.9859500122070312e+02 -5.9969802856445312e+01 1.4111100769042969e+02 -1.9941101074218750e+02 1.0230100250244141e+02 1.4256199645996094e+02 -1.7952099609375000e+02 1.0230000305175781e+02 1.4557699584960938e+02 -1.9859500122070312e+02 1.0230000305175781e+02 1.9108801269531250e+02 -2.9180200195312500e+02 1.3955000305175781e+02 1.6508399963378906e+02 -2.7040798950195312e+02 1.3955000305175781e+02 1.7696299743652344e+02 -2.8273098754882812e+02 1.3955000305175781e+02 1.3398300170898438e+02 -2.4170899963378906e+02 5.7514900207519531e+01 1.3398300170898438e+02 -2.4170899963378906e+02 1.3412400245666504e+01 1.3448699951171875e+02 -2.4319400024414062e+02 3.6914199829101562e+01 1.3357701110839844e+02 -2.1059500122070312e+02 1.0230000305175781e+02 1.3136099243164062e+02 -2.1862699890136719e+02 1.0230000305175781e+02 1.3324299621582031e+02 -2.0552900695800781e+02 1.0230000305175781e+02 2.4409001159667969e+02 -1.3809999084472656e+02 -4.7562698364257812e+01 2.5209999084472656e+02 -1.3809999084472656e+02 -2.8200000762939453e+01 2.5044300842285156e+02 -1.3809899902343750e+02 -3.8267398834228516e+01 1.4557699584960938e+02 -1.9859500122070312e+02 -5.9969802856445312e+01 2.0645800781250000e+02 -2.5060498046875000e+02 -5.9969802856445312e+01 2.9491900634765625e+02 -2.4729399108886719e+02 1.0230000305175781e+02 3.1264599609375000e+02 -2.5572999572753906e+02 1.0230000305175781e+02 2.9153399658203125e+02 -2.4962500000000000e+02 1.0230000305175781e+02 1.5309399414062500e+02 -1.6241200256347656e+02 1.0230000305175781e+02 1.7484899902343750e+02 -1.6241200256347656e+02 1.0230000305175781e+02 2.9866799926757812e+02 -2.3860600280761719e+02 -2.7142898559570312e+01 2.9864697265625000e+02 -2.2679800415039062e+02 -1.8764699935913086e+01 2.9864697265625000e+02 -2.3860499572753906e+02 4.0985599517822266e+01 2.9864697265625000e+02 -2.1059500122070312e+02 8.0976800918579102e+00 2.9864697265625000e+02 -2.1059500122070312e+02 -1.5550399780273438e+01 2.8689398193359375e+02 -2.6575698852539062e+02 1.2900000000000000e+02 2.8834399414062500e+02 -2.6370498657226562e+02 1.0526499938964844e+02 2.9076199340820312e+02 -2.5917398071289062e+02 1.2900000000000000e+02 2.9051000976562500e+02 -1.9920599365234375e+02 -3.7053100585937500e+01 2.9255102539062500e+02 -2.0005700683593750e+02 -5.9970798492431641e+01 1.3385299682617188e+02 -2.0815499877929688e+02 1.0230000305175781e+02 1.3357701110839844e+02 -2.1059500122070312e+02 9.6058898925781250e+01 1.4085800170898438e+02 -1.9949099731445312e+02 7.5261901855468750e+01 1.3889401245117188e+02 -2.0059500122070312e+02 3.5743999481201172e+01 1.3716799926757812e+02 -2.0194900512695312e+02 1.0056999969482422e+02 1.3708799743652344e+02 -2.4708999633789062e+02 6.0708602905273438e+01 1.3826901245117188e+02 -2.4812600708007812e+02 3.2135898590087891e+01 1.3826901245117188e+02 -2.4812600708007812e+02 7.9724601745605469e+01 1.3706498718261719e+02 -2.0214300537109375e+02 -5.9969802856445312e+01 1.3508500671386719e+02 -2.0466500854492188e+02 -5.9969898223876953e+01 1.3605200195312500e+02 -2.0329199218750000e+02 -2.9373600006103516e+01 1.3957600402832031e+02 -2.4899899291992188e+02 5.0942001342773438e+01 1.4098399353027344e+02 -2.4969300842285156e+02 7.8505599975585938e+01 1.3957800292968750e+02 -2.4899800109863281e+02 1.0230000305175781e+02 1.3624400329589844e+02 -2.0303300476074219e+02 5.2590198516845703e+01 2.9264199829101562e+02 -2.0019799804687500e+02 -2.3319999694824219e+01 2.9123498535156250e+02 -1.9950500488281250e+02 6.6349101066589355e+00 2.9264199829101562e+02 -2.0019799804687500e+02 3.0526800155639648e+01 1.4401000976562500e+02 -1.9869599914550781e+02 5.8514400482177734e+01 1.4247099304199219e+02 -1.9900199890136719e+02 4.6641597747802734e+01 1.3939698791503906e+02 -2.0022900390625000e+02 -5.9969802856445312e+01 1.3708799743652344e+02 -2.0211000061035156e+02 -1.3356300354003906e+01 1.3895599365234375e+02 -2.0055499267578125e+02 -1.2914799690246582e+01 1.4557699584960938e+02 -1.9859500122070312e+02 7.6262695312500000e+01 2.9844201660156250e+02 -2.0824700927734375e+02 4.4407596588134766e+00 2.9742300415039062e+02 -2.0525500488281250e+02 1.1596100807189941e+01 2.9778701782226562e+02 -2.0599200439453125e+02 6.4847000122070312e+01 1.3826901245117188e+02 -2.4812600708007812e+02 -2.5375299453735352e+01 1.3957600402832031e+02 -2.4899899291992188e+02 -5.3728698730468750e+01 1.3957600402832031e+02 -2.4899899291992188e+02 2.4416298866271973e+00 2.9123498535156250e+02 -1.9950500488281250e+02 4.8518898010253906e+01 2.9264199829101562e+02 -2.0019799804687500e+02 7.6920997619628906e+01 2.9280001831054688e+02 -2.4899398803710938e+02 9.9975700378417969e+01 2.8942901611328125e+02 -2.5033700561523438e+02 4.1235500335693359e+01 2.9379598999023438e+02 -2.4830200195312500e+02 3.2989101409912109e+01 2.8116799926757812e+02 -2.7345401000976562e+02 1.0526599884033203e+02 2.9610601806640625e+02 -2.8678799438476562e+02 1.0526599884033203e+02 1.9710000610351562e+02 -1.3809999084472656e+02 7.0520500183105469e+01 2.5209999084472656e+02 -1.3809999084472656e+02 4.0198602676391602e+00 1.9710000610351562e+02 -1.3809999084472656e+02 -4.4480600357055664e+00 1.8028799438476562e+02 -1.6241200256347656e+02 1.0526599884033203e+02 1.8028799438476562e+02 -1.6241200256347656e+02 1.0230000305175781e+02 2.9537399291992188e+02 -2.4685899353027344e+02 -5.9969699859619141e+01 2.9824502563476562e+02 -2.4205599975585938e+02 -5.9969200134277344e+01 2.9711199951171875e+02 -2.4459999084472656e+02 -5.9332698822021484e+01 2.8169799804687500e+02 -1.7591198730468750e+02 1.3955000305175781e+02 2.7608499145507812e+02 -1.6997300720214844e+02 1.3304998779296875e+02 2.7249099731445312e+02 -1.6669799804687500e+02 1.3955000305175781e+02 2.6763900756835938e+02 -1.6309001159667969e+02 1.3304998779296875e+02 2.3421099853515625e+02 -1.7264300537109375e+02 1.3304998779296875e+02 2.9465298461914062e+02 -1.9881900024414062e+02 1.0526599884033203e+02 2.9307199096679688e+02 -1.9487699890136719e+02 1.2900000000000000e+02 2.9649002075195312e+02 -2.0441099548339844e+02 1.2900000000000000e+02 3.0603997802734375e+02 -1.7843400573730469e+02 1.0526499938964844e+02 2.9958599853515625e+02 -1.6756999206542969e+02 1.0526599884033203e+02 2.9044100952148438e+02 -1.7463000488281250e+02 1.0526599884033203e+02 2.3265499877929688e+02 -2.9920300292968750e+02 1.3304998779296875e+02 2.4584298706054688e+02 -2.9663000488281250e+02 1.3304998779296875e+02 3.0038198852539062e+02 -1.6870899963378906e+02 1.0230000305175781e+02 2.9610601806640625e+02 -1.6241200256347656e+02 1.0526599884033203e+02 2.6147799682617188e+02 -1.5966198730468750e+02 1.0230000305175781e+02 2.8664700317382812e+02 -1.9859500122070312e+02 1.0230000305175781e+02 2.5209999084472656e+02 -1.5523699951171875e+02 1.0230000305175781e+02 1.4557699584960938e+02 -2.5060498046875000e+02 -5.9969802856445312e+01 1.7570999145507812e+02 -1.6766999816894531e+02 1.3955000305175781e+02 1.4987799072265625e+02 -2.1699699401855469e+02 1.3955000305175781e+02 1.4608299255371094e+02 -1.7312001037597656e+02 1.0526599884033203e+02 1.5309399414062500e+02 -1.6241200256347656e+02 1.0526599884033203e+02 2.0329299926757812e+02 -1.5263700866699219e+02 1.3955000305175781e+02 2.1438600158691406e+02 -1.5020799255371094e+02 1.3955000305175781e+02 2.0333399963378906e+02 -1.5257400512695312e+02 1.3304998779296875e+02 3.0329598999023438e+02 -2.7587701416015625e+02 1.0230000305175781e+02 3.0589498901367188e+02 -2.7118899536132812e+02 1.0526499938964844e+02 1.3395599365234375e+02 -2.0738500976562500e+02 -5.7594200134277344e+01 1.3517999267578125e+02 -2.0459899902343750e+02 -1.8744100570678711e+01 2.3902900695800781e+02 -2.7551699829101562e+02 1.2900000000000000e+02 2.5209999084472656e+02 -2.9396298217773438e+02 1.2900000000000000e+02 2.6639300537109375e+02 -2.8657400512695312e+02 1.2900000000000000e+02 2.9268597412109375e+02 -2.5514900207519531e+02 1.0615900421142578e+02 2.9504098510742188e+02 -2.4939500427246094e+02 1.2900000000000000e+02 1.3500599670410156e+02 -2.5077700805664062e+02 1.0526599884033203e+02 1.3477499389648438e+02 -2.4980099487304688e+02 1.0230000305175781e+02 1.3919799804687500e+02 -2.6235101318359375e+02 1.0230000305175781e+02 1.5853300476074219e+02 -2.8678799438476562e+02 1.0230000305175781e+02 1.8028799438476562e+02 -2.8678799438476562e+02 1.0230000305175781e+02 2.4075900268554688e+02 -3.0809997558593750e+02 -5.0521602630615234e+01 2.5209999084472656e+02 -3.0809997558593750e+02 -2.8200000762939453e+01 1.9024099731445312e+02 -1.8453900146484375e+02 1.2900000000000000e+02 1.6681100463867188e+02 -1.7186300659179688e+02 1.2900000000000000e+02 1.6750100708007812e+02 -1.9886000061035156e+02 1.2900000000000000e+02 1.3976199340820312e+02 -1.8562600708007812e+02 1.0526499938964844e+02 1.3922299194335938e+02 -2.1037899780273438e+02 1.0526599884033203e+02 1.3915100097656250e+02 -2.1066899108886719e+02 1.2900000000000000e+02 1.4256300354003906e+02 -2.0203700256347656e+02 1.2900000000000000e+02 1.5309399414062500e+02 -2.8678799438476562e+02 1.0230000305175781e+02 1.9846600341796875e+02 -1.4110099792480469e+02 -3.7242900848388672e+01 2.5142500305175781e+02 -1.4110000610351562e+02 -3.5301700592041016e+01 1.9710000610351562e+02 -1.4110000610351562e+02 -2.8200000762939453e+01 1.3873300170898438e+02 -2.3700300598144531e+02 1.2900000000000000e+02 1.3734400939941406e+02 -2.3003601074218750e+02 1.2900000000000000e+02 1.3826699829101562e+02 -2.3524501037597656e+02 1.0526599884033203e+02 3.1782400512695312e+02 -2.3255400085449219e+02 1.0526599884033203e+02 2.9512100219726562e+02 -2.4906698608398438e+02 1.0526499938964844e+02 3.1402700805664062e+02 -2.5151602172851562e+02 1.0526599884033203e+02 2.8136700439453125e+02 -2.7329699707031250e+02 1.2900000000000000e+02 2.7288601684570312e+02 -2.8176199340820312e+02 1.0526599884033203e+02 2.0844100952148438e+02 -3.1110000610351562e+02 -5.0521602630615234e+01 1.5099899291992188e+02 -2.6083499145507812e+02 1.2900000000000000e+02 1.5566900634765625e+02 -2.6645401000976562e+02 1.2900000000000000e+02 1.7562599182128906e+02 -2.4422299194335938e+02 1.2900000000000000e+02 2.9703701782226562e+02 -2.0445999145507812e+02 -5.6779602050781250e+01 2.9418298339843750e+02 -2.0116600036621094e+02 -5.5256900787353516e+01 2.9490100097656250e+02 -2.0181900024414062e+02 -5.0245699882507324e+00 1.3526399230957031e+02 -1.9760600280761719e+02 1.0526599884033203e+02 1.3131399536132812e+02 -2.1692399597167969e+02 1.0526499938964844e+02 3.1815100097656250e+02 -2.2218499755859375e+02 1.0230000305175781e+02 3.1764001464843750e+02 -2.1607899475097656e+02 1.0526499938964844e+02 2.2460000610351562e+02 -2.9960000610351562e+02 1.3304998779296875e+02 2.2460000610351562e+02 -2.9960000610351562e+02 1.3955000305175781e+02 1.5775000000000000e+02 -2.5875000000000000e+02 1.3955000305175781e+02 1.5778799438476562e+02 -2.5906500244140625e+02 1.3304998779296875e+02 1.3357701110839844e+02 -2.1059500122070312e+02 3.6371799468994141e+01 1.3377999877929688e+02 -2.0825100708007812e+02 6.8863502502441406e+01 1.3396400451660156e+02 -2.0736700439453125e+02 2.6833299636840820e+01 2.4668400573730469e+02 -1.4110000610351562e+02 -4.4711601257324219e+01 2.3904600524902344e+02 -1.4110000610351562e+02 -5.1552700042724609e+01 1.8644200134277344e+02 -2.8926501464843750e+02 1.3304998779296875e+02 1.4557699584960938e+02 -1.9859500122070312e+02 3.4281200408935547e+01 2.9864697265625000e+02 -2.3860499572753906e+02 7.4117301940917969e+01 2.9782199096679688e+02 -2.4319599914550781e+02 3.4616500854492188e+01 2.8664700317382812e+02 -1.9859500122070312e+02 4.6495399475097656e+01 2.8821200561523438e+02 -1.9869599914550781e+02 7.6994102478027344e+01 2.8975000000000000e+02 -1.9900099182128906e+02 7.7262298583984375e+01 1.3398300170898438e+02 -2.4170899963378906e+02 1.0073999786376953e+02 1.3448699951171875e+02 -2.4319400024414062e+02 7.5190002441406250e+01 2.8664700317382812e+02 -1.9859500122070312e+02 -1.6379301071166992e+01 1.3357701110839844e+02 -2.3860499572753906e+02 1.6008800506591797e+01 1.3357199096679688e+02 -2.1059500122070312e+02 -1.9097600936889648e+01 1.9756900024414062e+02 -2.6990899658203125e+02 1.2900000000000000e+02 1.9400100708007812e+02 -2.6754000854492188e+02 1.3304998779296875e+02 1.8794900512695312e+02 -2.6259698486328125e+02 1.2900000000000000e+02 2.1553898620605469e+02 -2.9913101196289062e+02 1.3955000305175781e+02 1.9994099426269531e+02 -1.3809999084472656e+02 -4.0683502197265625e+01 2.0565399169921875e+02 -1.4110099792480469e+02 -4.8183097839355469e+01 1.3357701110839844e+02 -2.1059500122070312e+02 -5.9969802856445312e+01 1.4923500061035156e+02 -2.2532499694824219e+02 -5.9969802856445312e+01 1.4327398681640625e+02 -2.0052400207519531e+02 1.0526499938964844e+02 1.8028799438476562e+02 -2.8678799438476562e+02 1.0526599884033203e+02 1.3357701110839844e+02 -2.3860499572753906e+02 -5.9969802856445312e+01 1.3440899658203125e+02 -2.4332398986816406e+02 -5.9969997406005859e+01 1.3357701110839844e+02 -2.3860499572753906e+02 -3.5175899505615234e+01 2.9744000244140625e+02 -2.0791200256347656e+02 1.0526599884033203e+02 1.9710000610351562e+02 -1.4110000610351562e+02 3.3263198852539062e+01 2.5209999084472656e+02 -1.4110000610351562e+02 -2.8200000762939453e+01 1.4318899536132812e+02 -2.5039300537109375e+02 1.0037599945068359e+02 1.4557699584960938e+02 -2.5060498046875000e+02 1.0230000305175781e+02 1.4098899841308594e+02 -2.4969099426269531e+02 1.0230000305175781e+02 1.8041000366210938e+02 -1.9582598876953125e+02 1.2900000000000000e+02 1.7478799438476562e+02 -2.0738500976562500e+02 1.2900000000000000e+02 2.2460000610351562e+02 -1.4960000610351562e+02 1.3304998779296875e+02 2.3610099792480469e+02 -1.5035900878906250e+02 1.3955000305175781e+02 2.3293499755859375e+02 -1.4997799682617188e+02 1.3304998779296875e+02 2.9869699096679688e+02 -2.3633200073242188e+02 1.3955000305175781e+02 2.9907598876953125e+02 -2.1499099731445312e+02 1.3955000305175781e+02 3.1489700317382812e+02 -2.0074899291992188e+02 1.0230000305175781e+02 1.7183099365234375e+02 -2.2582901000976562e+02 1.3304998779296875e+02 1.7183200073242188e+02 -2.2460000610351562e+02 1.2900000000000000e+02 1.7263999938964844e+02 -2.3378300476074219e+02 1.2900000000000000e+02 2.6605001831054688e+02 -1.9209399414062500e+02 1.2900000000000000e+02 2.9861300659179688e+02 -2.1417799377441406e+02 1.2900000000000000e+02 2.5209999084472656e+02 -3.1110000610351562e+02 1.2900000000000000e+02 2.5209999084472656e+02 -2.9396298217773438e+02 1.0230000305175781e+02 2.7039999389648438e+02 -2.8405801391601562e+02 1.3955000305175781e+02 2.5811099243164062e+02 -2.9184100341796875e+02 1.3955000305175781e+02 2.6037298583984375e+02 -2.9061700439453125e+02 1.3304998779296875e+02 1.9710000610351562e+02 -1.3809999084472656e+02 -2.8200000762939453e+01 2.8664700317382812e+02 -2.5060498046875000e+02 4.8323799133300781e+01 2.8664700317382812e+02 -2.5060600280761719e+02 -1.1485099792480469e+01 1.8070599365234375e+02 -2.5367900085449219e+02 1.2900000000000000e+02 1.7005999755859375e+02 -2.7990402221679688e+02 1.2900000000000000e+02 2.3843600463867188e+02 -1.7356201171875000e+02 1.2900000000000000e+02 2.2460000610351562e+02 -1.7191999816894531e+02 1.2900000000000000e+02 2.7411599731445312e+02 -1.6866700744628906e+02 1.2900000000000000e+02 2.6835098266601562e+02 -1.6405400085449219e+02 1.2900000000000000e+02 2.5306901550292969e+02 -1.7144100952148438e+02 1.2900000000000000e+02 1.7326599121093750e+02 -2.3665100097656250e+02 1.3304998779296875e+02 1.5291200256347656e+02 -2.4683799743652344e+02 1.3304998779296875e+02 2.5209999084472656e+02 -1.3809999084472656e+02 4.8852600097656250e+01 2.1570800781250000e+02 -2.9912799072265625e+02 1.3304998779296875e+02 2.0256500244140625e+02 -2.9646398925781250e+02 1.3304998779296875e+02 2.1015399169921875e+02 -1.3809999084472656e+02 -5.1552700042724609e+01 2.0447200012207031e+02 -1.3809999084472656e+02 -4.6919902801513672e+01 1.5073699951171875e+02 -2.3773098754882812e+02 1.3304998779296875e+02 2.9652899169921875e+02 -2.0289599609375000e+02 1.3304998779296875e+02 2.7405300903320312e+02 -2.0636199951171875e+02 1.3304998779296875e+02 2.6901800537109375e+02 -1.9599699401855469e+02 1.3304998779296875e+02 2.3209600830078125e+02 -2.9928399658203125e+02 1.3955000305175781e+02 2.6312301635742188e+02 -2.8852902221679688e+02 1.0764700317382812e+02 2.5779101562500000e+02 -2.9151300048828125e+02 1.0230000305175781e+02 2.6589901733398438e+02 -2.8678799438476562e+02 1.0230000305175781e+02 2.2460000610351562e+02 -1.4960000610351562e+02 1.3955000305175781e+02 1.4963099670410156e+02 -2.2807499694824219e+02 1.3304998779296875e+02 1.4979701232910156e+02 -2.3099899291992188e+02 1.3955000305175781e+02 2.5209999084472656e+02 -3.0809997558593750e+02 1.0230000305175781e+02 2.5209999084472656e+02 -3.1110000610351562e+02 6.0071498870849609e+01 1.5450799560546875e+02 -2.6530700683593750e+02 1.0526599884033203e+02 1.4160198974609375e+02 -2.6774298095703125e+02 1.0526599884033203e+02 2.1649000549316406e+02 -1.4110000610351562e+02 -5.4577102661132812e+01 3.1553302001953125e+02 -2.0333599853515625e+02 1.0526499938964844e+02 1.8995300292968750e+02 -2.9181201171875000e+02 1.2900000000000000e+02 3.0832897949218750e+02 -1.8309199523925781e+02 1.0230000305175781e+02 2.6589901733398438e+02 -2.8678799438476562e+02 1.0526599884033203e+02 3.1113601684570312e+02 -1.8976399230957031e+02 1.0526599884033203e+02 1.6152200317382812e+02 -1.8396798706054688e+02 1.3955000305175781e+02 1.5676400756835938e+02 -1.9252200317382812e+02 1.3955000305175781e+02 1.7967599487304688e+02 -2.8647698974609375e+02 1.2900000000000000e+02 1.7568099975585938e+02 -2.8393099975585938e+02 1.0526499938964844e+02 1.6472099304199219e+02 -2.7552999877929688e+02 1.0526599884033203e+02 1.4557699584960938e+02 -2.5060498046875000e+02 5.6637203216552734e+01 2.2284899902343750e+02 -1.9859500122070312e+02 1.0230000305175781e+02 1.4279800415039062e+02 -2.4782200622558594e+02 1.2900000000000000e+02 1.4629598999023438e+02 -2.5397598266601562e+02 1.0526499938964844e+02 2.5209999084472656e+02 -3.1110000610351562e+02 -2.8200000762939453e+01 2.5209999084472656e+02 -3.1110000610351562e+02 6.6848897933959961e+00 1.5219700622558594e+02 -2.4467300415039062e+02 1.3955000305175781e+02 2.4951100158691406e+02 -3.1110000610351562e+02 -4.0130100250244141e+01 2.3811499023437500e+02 -3.1110000610351562e+02 -5.2161602020263672e+01 2.7734597778320312e+02 -2.2850100708007812e+02 1.3304998779296875e+02 2.9570599365234375e+02 -2.4869099426269531e+02 1.3304998779296875e+02 2.7431698608398438e+02 -2.4233599853515625e+02 1.3304998779296875e+02 2.9855200195312500e+02 -2.4014900207519531e+02 9.8952499389648438e+01 1.4419700622558594e+02 -2.7258999633789062e+02 1.0230000305175781e+02 2.9960998535156250e+02 -2.2743701171875000e+02 1.3955000305175781e+02 2.9927798461914062e+02 -2.1676499938964844e+02 1.3304998779296875e+02 1.6753900146484375e+02 -1.7586100769042969e+02 1.3955000305175781e+02 1.6169898986816406e+02 -1.8353498840332031e+02 1.3304998779296875e+02 2.9578598022460938e+02 -2.4641899108886719e+02 9.9576896667480469e+01 1.6680000305175781e+02 -1.6241200256347656e+02 1.0526599884033203e+02 1.7321200561523438e+02 -2.1257301330566406e+02 1.3304998779296875e+02 2.5579801940917969e+02 -1.5679800415039062e+02 1.2900000000000000e+02 2.5209999084472656e+02 -1.5523699951171875e+02 1.2900000000000000e+02 2.7987399291992188e+02 -1.7425000000000000e+02 1.0526599884033203e+02 2.8616601562500000e+02 -1.8236100769042969e+02 1.0526599884033203e+02 1.3711399841308594e+02 -2.2774900817871094e+02 1.0526599884033203e+02 2.4758100891113281e+02 -1.5314599609375000e+02 1.3955000305175781e+02 2.9628100585937500e+02 -2.0336000061035156e+02 4.9794101715087891e+01 2.8899197387695312e+02 -2.5040200805664062e+02 -4.6152801513671875e+01 2.9864697265625000e+02 -2.3860499572753906e+02 -5.9969802856445312e+01 2.9864697265625000e+02 -2.1059500122070312e+02 1.0230000305175781e+02 2.9864697265625000e+02 -2.1059500122070312e+02 7.5970199584960938e+01 1.4557699584960938e+02 -1.9859500122070312e+02 -1.6964399337768555e+01 1.4247099304199219e+02 -1.9900199890136719e+02 -5.8409500122070312e+01 1.3827900695800781e+02 -2.4813800048828125e+02 -5.6251296997070312e+01 1.3875498962402344e+02 -2.4852999877929688e+02 -5.9969802856445312e+01 2.9710198974609375e+02 -2.4460501098632812e+02 6.6583404541015625e+01 2.9823898315429688e+02 -2.4171200561523438e+02 7.0289703369140625e+01 1.3495799255371094e+02 -2.4423699951171875e+02 1.0230100250244141e+02 1.3517999267578125e+02 -2.4460099792480469e+02 4.8860198974609375e+01 1.4252699279785156e+02 -2.5026699829101562e+02 9.7371997833251953e+00 1.3398300170898438e+02 -2.4170899963378906e+02 -2.7545099258422852e+01 1.3388600158691406e+02 -2.0759199523925781e+02 -1.4892200469970703e+01 1.3556799316406250e+02 -2.0392599487304688e+02 2.2798498153686523e+01 1.3479800415039062e+02 -2.4394099426269531e+02 1.4838599205017090e+01 1.4098399353027344e+02 -1.9950700378417969e+02 2.7942600250244141e+01 2.9823898315429688e+02 -2.4171200561523438e+02 -3.9637302398681641e+01 1.3732600402832031e+02 -2.4733500671386719e+02 1.0230000305175781e+02 1.9710000610351562e+02 -3.1110000610351562e+02 6.7655197143554688e+01 1.9710000610351562e+02 -3.0809997558593750e+02 3.0641500473022461e+01 1.9710000610351562e+02 -3.1110000610351562e+02 -2.8200000762939453e+01 2.6589901733398438e+02 -1.6241200256347656e+02 1.0526599884033203e+02 1.9710000610351562e+02 -3.0809997558593750e+02 -2.8200000762939453e+01 1.3625300598144531e+02 -1.9457800292968750e+02 1.0230000305175781e+02 1.3335501098632812e+02 -2.4401300048828125e+02 1.0230000305175781e+02 1.3172599792480469e+02 -2.3520700073242188e+02 1.0230000305175781e+02 2.9474600219726562e+02 -2.0163699340820312e+02 1.0230000305175781e+02 2.9122998046875000e+02 -1.9950700378417969e+02 1.0230000305175781e+02 1.3503999328613281e+02 -2.4447399902343750e+02 -2.9775800704956055e+01 1.3569299316406250e+02 -2.4546701049804688e+02 -5.6444297790527344e+01 1.7152301025390625e+02 -1.6816200256347656e+02 1.0526599884033203e+02 1.4907400512695312e+02 -1.9101600646972656e+02 1.0526499938964844e+02 2.9864697265625000e+02 -2.3860499572753906e+02 9.6058898925781250e+01 1.9710000610351562e+02 -1.5458999633789062e+02 1.2900000000000000e+02 1.9710000610351562e+02 -3.0809997558593750e+02 1.0230000305175781e+02 1.4120599365234375e+02 -2.4430799865722656e+02 1.0526599884033203e+02 2.9019900512695312e+02 -1.8892300415039062e+02 1.0526599884033203e+02 2.8852001953125000e+02 -1.8586898803710938e+02 1.2900000000000000e+02 2.5209999084472656e+02 -1.4110000610351562e+02 3.3724399566650391e+01 2.5209999084472656e+02 -1.4110000610351562e+02 1.0230000305175781e+02 2.7383200073242188e+02 -2.4358399963378906e+02 1.2900000000000000e+02 2.7957598876953125e+02 -2.6200399780273438e+02 1.2900000000000000e+02 1.9710000610351562e+02 -3.1110000610351562e+02 1.2900000000000000e+02 2.9720700073242188e+02 -2.4201899719238281e+02 1.0526599884033203e+02 1.9979000854492188e+02 -3.0809997558593750e+02 -4.0305999755859375e+01 1.9807000732421875e+02 -3.1110000610351562e+02 -3.5835197448730469e+01 1.9743099975585938e+02 -3.0809997558593750e+02 -3.2848102569580078e+01 2.3736700439453125e+02 -1.3809999084472656e+02 -5.2639400482177734e+01 2.9864697265625000e+02 -2.1059500122070312e+02 -5.9969802856445312e+01 1.3168099975585938e+02 -2.3469500732421875e+02 1.0526499938964844e+02 2.7409399414062500e+02 -2.8055300903320312e+02 1.2900000000000000e+02 2.5115200805664062e+02 -2.7025000000000000e+02 1.2900000000000000e+02 1.8046000671386719e+02 -1.7152099609375000e+02 1.0230000305175781e+02 2.9610601806640625e+02 -2.8678799438476562e+02 1.0230000305175781e+02 2.8583300781250000e+02 -1.8104901123046875e+02 1.3304998779296875e+02 2.7653698730468750e+02 -2.3392500305175781e+02 1.2900000000000000e+02 2.7736801147460938e+02 -2.2460000610351562e+02 1.2900000000000000e+02 2.9672198486328125e+02 -2.4558999633789062e+02 1.3955000305175781e+02 1.5493998718261719e+02 -1.8357600402832031e+02 1.0526499938964844e+02 2.8664700317382812e+02 -1.9859500122070312e+02 1.8190799713134766e+01 2.7342401123046875e+02 -1.6802999877929688e+02 1.0526599884033203e+02 1.6157099914550781e+02 -1.7661199951171875e+02 1.0526599884033203e+02 1.5872200012207031e+02 -1.7946299743652344e+02 1.2900000000000000e+02 1.8820098876953125e+02 -2.9105300903320312e+02 1.0230000305175781e+02 1.7218800354003906e+02 -2.1809700012207031e+02 1.2900000000000000e+02 2.7005197143554688e+02 -2.5137600708007812e+02 1.3304998779296875e+02 2.6845498657226562e+02 -2.5375300598144531e+02 1.2900000000000000e+02 2.9926998901367188e+02 -2.2078399658203125e+02 1.0526599884033203e+02 2.9904898071289062e+02 -2.3122799682617188e+02 1.0526599884033203e+02 2.4791600036621094e+02 -3.0809997558593750e+02 -4.2833202362060547e+01 2.5867501831054688e+02 -1.8430400085449219e+02 1.2900000000000000e+02 2.8079598999023438e+02 -1.7529701232910156e+02 1.2900000000000000e+02 1.9052700805664062e+02 -1.8435501098632812e+02 1.3304998779296875e+02 2.1260699462890625e+02 -1.7323100280761719e+02 1.3304998779296875e+02 2.1548100280761719e+02 -1.5006799316406250e+02 1.3304998779296875e+02 1.7942399597167969e+02 -1.6287399291992188e+02 1.2900000000000000e+02 1.8971000671386719e+02 -1.5747900390625000e+02 1.2900000000000000e+02 1.5330999755859375e+02 -1.8548699951171875e+02 1.2900000000000000e+02 1.9372000122070312e+02 -1.5622801208496094e+02 1.3304998779296875e+02 2.2460000610351562e+02 -2.7727999877929688e+02 1.2900000000000000e+02 2.1852900695800781e+02 -2.7699398803710938e+02 1.2900000000000000e+02 2.7646899414062500e+02 -2.1490299987792969e+02 1.3304998779296875e+02 1.7781401062011719e+02 -2.4922299194335938e+02 1.3304998779296875e+02 1.8584300231933594e+02 -2.6041900634765625e+02 1.3304998779296875e+02 2.2460000610351562e+02 -1.7191999816894531e+02 1.3304998779296875e+02 2.9613598632812500e+02 -2.4604499816894531e+02 -2.8803701400756836e+01 2.9336801147460938e+02 -2.4857899475097656e+02 -2.5463699340820312e+01 2.5990301513671875e+02 -1.8534199523925781e+02 1.3304998779296875e+02 2.4913699340820312e+02 -1.7780500793457031e+02 1.3304998779296875e+02 2.9085000610351562e+02 -2.4988398742675781e+02 -1.0737000465393066e+01 2.5209999084472656e+02 -3.0809997558593750e+02 5.9928802490234375e+01 2.7216799926757812e+02 -2.0191299438476562e+02 1.2900000000000000e+02 2.9787200927734375e+02 -2.0621800231933594e+02 1.0230200195312500e+02 2.9310797119140625e+02 -2.4874400329589844e+02 -5.2422698974609375e+01 2.9394900512695312e+02 -2.0106999206542969e+02 5.2651199340820312e+01 2.9772799682617188e+02 -2.0572799682617188e+02 -5.9969898223876953e+01 1.3708799743652344e+02 -2.0211000061035156e+02 3.2074897766113281e+01 1.3605200195312500e+02 -2.0329199218750000e+02 3.9531700611114502e+00 1.3481800842285156e+02 -2.0522000122070312e+02 5.3571498870849609e+01 1.3708799743652344e+02 -2.4708999633789062e+02 -1.9134199142456055e+01 1.3605200195312500e+02 -2.4590800476074219e+02 -1.5331000328063965e+01 1.4098399353027344e+02 -1.9950700378417969e+02 -3.0812000274658203e+01 1.4247099304199219e+02 -1.9900199890136719e+02 -6.3017100095748901e-01 2.8975000000000000e+02 -1.9900099182128906e+02 5.3029102325439453e+01 1.3661601257324219e+02 -2.4662500000000000e+02 1.3570899963378906e+01 2.9854598999023438e+02 -2.0902799987792969e+02 5.6193798065185547e+01 2.9823898315429688e+02 -2.0748800659179688e+02 7.7798599243164062e+01 1.3712200927734375e+02 -2.4712799072265625e+02 -5.5226299285888672e+01 2.8899099731445312e+02 -2.5040200805664062e+02 7.4531799316406250e+01 2.8664700317382812e+02 -2.5060498046875000e+02 1.0230000305175781e+02 1.4098399353027344e+02 -1.9950700378417969e+02 2.2100400924682617e+00 1.3469099426269531e+02 -2.0547300720214844e+02 9.9347999572753906e+01 1.4098399353027344e+02 -2.4969300842285156e+02 3.1258199691772461e+01 1.4323001098632812e+02 -2.5040098571777344e+02 5.7319896697998047e+01 2.8975000000000000e+02 -1.9900099182128906e+02 -1.2929599761962891e+01 2.8975000000000000e+02 -1.9900099182128906e+02 2.4188098907470703e+01 2.9123498535156250e+02 -1.9950500488281250e+02 3.9644699096679688e+01 1.5102099609375000e+02 -2.0980999755859375e+02 1.3304998779296875e+02 1.5259001159667969e+02 -2.0331900024414062e+02 1.3955000305175781e+02 1.5463400268554688e+02 -1.9719700622558594e+02 1.3304998779296875e+02 1.7339498901367188e+02 -2.7959201049804688e+02 1.3304998779296875e+02 2.1661199951171875e+02 -1.3809999084472656e+02 -5.4595897674560547e+01 2.2325199890136719e+02 -1.4109899902343750e+02 -5.5724899291992188e+01 1.6186199951171875e+02 -2.7287301635742188e+02 1.2900000000000000e+02 1.4721499633789062e+02 -1.9375500488281250e+02 1.2900000000000000e+02 2.9952899169921875e+02 -2.2879899597167969e+02 1.3304998779296875e+02 2.9821597290039062e+02 -2.3927799987792969e+02 1.3304998779296875e+02 2.2460000610351562e+02 -2.7727999877929688e+02 1.3304998779296875e+02 2.2794699096679688e+02 -1.3809999084472656e+02 -5.5608501434326172e+01 2.3258799743652344e+02 -1.4110000610351562e+02 -5.4595897674560547e+01 2.8195397949218750e+02 -2.7299099731445312e+02 1.3304998779296875e+02 2.7096301269531250e+02 -2.8374099731445312e+02 1.3304998779296875e+02 2.5526600646972656e+02 -2.6752999877929688e+02 1.3304998779296875e+02 2.4900401306152344e+02 -1.7777600097656250e+02 1.2900000000000000e+02 1.9710000610351562e+02 -2.9460998535156250e+02 1.2900000000000000e+02 1.3756098937988281e+02 -2.1766200256347656e+02 1.2899899291992188e+02 1.3357701110839844e+02 -2.3860499572753906e+02 1.0230000305175781e+02 1.3734201049804688e+02 -2.1923300170898438e+02 1.0526599884033203e+02 1.3703900146484375e+02 -2.2442199707031250e+02 1.2900000000000000e+02 2.9777301025390625e+02 -2.3950498962402344e+02 1.2900000000000000e+02 2.9842697143554688e+02 -2.3592900085449219e+02 1.2113300323486328e+02 2.9930300903320312e+02 -2.2786801147460938e+02 1.2900000000000000e+02 1.9333299255371094e+02 -2.8661502075195312e+02 1.0230000305175781e+02 1.9710000610351562e+02 -1.3809999084472656e+02 1.2900000000000000e+02 2.8951901245117188e+02 -2.6239599609375000e+02 1.3304998779296875e+02 2.5841400146484375e+02 -2.8409500122070312e+02 1.0230000305175781e+02 2.9802200317382812e+02 -2.4251100158691406e+02 3.0843800306320190e-01 2.0461300659179688e+02 -3.0809997558593750e+02 -4.7107498168945312e+01 1.9941400146484375e+02 -1.7815600585937500e+02 1.3304998779296875e+02 1.9710000610351562e+02 -1.4110000610351562e+02 1.0230000305175781e+02 2.7598101806640625e+02 -2.1263900756835938e+02 1.2900000000000000e+02 2.9610601806640625e+02 -1.6241200256347656e+02 1.0230000305175781e+02 2.9006500244140625e+02 -1.6241200256347656e+02 1.0230000305175781e+02 2.9501000976562500e+02 -1.9822399902343750e+02 1.3955000305175781e+02 2.9176800537109375e+02 -1.9114700317382812e+02 1.3304998779296875e+02 2.6477301025390625e+02 -2.5882299804687500e+02 1.3304998779296875e+02 1.6498799133300781e+02 -2.7023599243164062e+02 1.3304998779296875e+02 2.5113400268554688e+02 -3.0809997558593750e+02 -3.5868499755859375e+01 2.5209999084472656e+02 -1.3809999084472656e+02 1.2900000000000000e+02 2.6063299560546875e+02 -2.6313998413085938e+02 1.2900000000000000e+02 1.3556100463867188e+02 -2.0359599304199219e+02 1.0230000305175781e+02 2.9864697265625000e+02 -2.1059500122070312e+02 3.7548099517822266e+01 2.1934500122070312e+02 -1.7213598632812500e+02 1.2900000000000000e+02 2.6589901733398438e+02 -1.6241200256347656e+02 1.0230000305175781e+02 2.0792900085449219e+02 -2.7490197753906250e+02 1.2900000000000000e+02 2.0652200317382812e+02 -2.7427499389648438e+02 1.3304998779296875e+02 2.3538699340820312e+02 -2.7634600830078125e+02 1.3304998779296875e+02 2.4668000793457031e+02 -2.7246099853515625e+02 1.3304998779296875e+02 2.0340100097656250e+02 -2.9661599731445312e+02 1.3955000305175781e+02 1.9710000610351562e+02 -2.9460998535156250e+02 1.0230000305175781e+02 2.1063000488281250e+02 -3.0809997558593750e+02 -5.1869602203369141e+01 2.0934899902343750e+02 -1.7401100158691406e+02 1.2900000000000000e+02 1.9981799316406250e+02 -1.7794700622558594e+02 1.2900000000000000e+02 1.9738101196289062e+02 -1.3809999084472656e+02 -3.2403598785400391e+01 2.6235800170898438e+02 -1.6020600891113281e+02 1.2900000000000000e+02 1.4971099853515625e+02 -2.1989700317382812e+02 1.3304998779296875e+02 2.4458700561523438e+02 -3.1110000610351562e+02 -4.7107498168945312e+01 2.9598001098632812e+02 -2.4623699951171875e+02 1.8911499023437500e+01 1.3605200195312500e+02 -2.4590800476074219e+02 3.8815799713134766e+01 1.3605200195312500e+02 -2.4590800476074219e+02 7.5726394653320312e+01 1.3826901245117188e+02 -2.4812600708007812e+02 -2.7268099784851074e+00 1.4401000976562500e+02 -1.9869599914550781e+02 6.1473302841186523e+00 1.4401000976562500e+02 -1.9869599914550781e+02 2.9441900253295898e+01 1.3357701110839844e+02 -2.3860499572753906e+02 4.6775699615478516e+01 2.0128401184082031e+02 -3.1110000610351562e+02 -4.2833202362060547e+01 2.5176901245117188e+02 -3.1110000610351562e+02 -3.2848102569580078e+01 )) mat)))
                  )
                 ))
      (send glv :transform local-cds)
      (send glv :calc-normals)
      (setq qhull
            ;; qhull 3000 -> 55 faces
            (instance faceset :init :faces (list
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3440899550914764e+02 -2.4332399666309357e+02 -5.9969998896121979e+01) (float-vector 1.3508500158786774e+02 -2.0466500520706177e+02 -5.9969898313283920e+01) (float-vector 1.3131399452686310e+02 -2.1692399680614471e+02 1.0526499897241592e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1113600730895996e+02 -1.8976399302482605e+02 1.0526599735021591e+02) (float-vector 2.9864698648452759e+02 -2.1059499680995941e+02 -5.9969801455736160e+01) (float-vector 3.1815099716186523e+02 -2.2218500077724457e+02 1.0230000317096710e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1113600730895996e+02 -1.8976399302482605e+02 1.0526599735021591e+02) (float-vector 2.9610601067543030e+02 -1.6241200268268585e+02 1.0230000317096710e+02) (float-vector 2.9255101084709167e+02 -2.0005699992179871e+02 -5.9970799833536148e+01) (float-vector 2.9864698648452759e+02 -2.1059499680995941e+02 -5.9969801455736160e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.9709999859333038e+02 -3.1110000610351562e+02 1.2899999320507050e+02) (float-vector 1.9709999859333038e+02 -3.1110000610351562e+02 -2.8200000524520874e+01) (float-vector 1.5309399366378784e+02 -2.8678798675537109e+02 1.0526599735021591e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3508500158786774e+02 -2.0466500520706177e+02 -5.9969898313283920e+01) (float-vector 1.3976199924945831e+02 -1.8562600016593933e+02 1.0526499897241592e+02) (float-vector 1.3131399452686310e+02 -2.1692399680614471e+02 1.0526499897241592e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.5309399366378784e+02 -1.6241200268268585e+02 1.0526599735021591e+02) (float-vector 1.3976199924945831e+02 -1.8562600016593933e+02 1.0526499897241592e+02) (float-vector 1.3508500158786774e+02 -2.0466500520706177e+02 -5.9969898313283920e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3500599563121796e+02 -2.5077700614929199e+02 1.0526599735021591e+02) (float-vector 1.3440899550914764e+02 -2.4332399666309357e+02 -5.9969998896121979e+01) (float-vector 1.3131399452686310e+02 -2.1692399680614471e+02 1.0526499897241592e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3440899550914764e+02 -2.4332399666309357e+02 -5.9969998896121979e+01) (float-vector 1.3500599563121796e+02 -2.5077700614929199e+02 1.0526599735021591e+02) (float-vector 1.5309399366378784e+02 -2.8678798675537109e+02 1.0526599735021591e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.9610601067543030e+02 -1.6241200268268585e+02 1.0230000317096710e+02) (float-vector 2.5044301152229309e+02 -1.3809899985790253e+02 -3.8267400115728378e+01) (float-vector 2.9255101084709167e+02 -2.0005699992179871e+02 -5.9970799833536148e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.5044301152229309e+02 -1.3809899985790253e+02 -3.8267400115728378e+01) (float-vector 2.3736700415611267e+02 -1.3809999823570251e+02 -5.2639398723840714e+01) (float-vector 2.9255101084709167e+02 -2.0005699992179871e+02 -5.9970799833536148e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.9738100469112396e+02 -1.3809999823570251e+02 -3.2403599470853806e+01) (float-vector 1.5309399366378784e+02 -1.6241200268268585e+02 1.0526599735021591e+02) (float-vector 1.3508500158786774e+02 -2.0466500520706177e+02 -5.9969898313283920e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3440899550914764e+02 -2.4332399666309357e+02 -5.9969998896121979e+01) (float-vector 2.0128400623798370e+02 -3.1110000610351562e+02 -4.2833201587200165e+01) (float-vector 2.0844100415706635e+02 -3.1110000610351562e+02 -5.0521600991487503e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3440899550914764e+02 -2.4332399666309357e+02 -5.9969998896121979e+01) (float-vector 1.5309399366378784e+02 -2.8678798675537109e+02 1.0526599735021591e+02) (float-vector 1.9709999859333038e+02 -3.1110000610351562e+02 -2.8200000524520874e+01) (float-vector 2.0128400623798370e+02 -3.1110000610351562e+02 -4.2833201587200165e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.0340099930763245e+02 -2.9661598801612854e+02 1.3955000042915344e+02) (float-vector 2.2460000216960907e+02 -2.9960000514984131e+02 1.3955000042915344e+02) (float-vector 2.5209999084472656e+02 -3.1110000610351562e+02 1.2899999320507050e+02) (float-vector 1.9709999859333038e+02 -3.1110000610351562e+02 1.2899999320507050e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3440899550914764e+02 -2.4332399666309357e+02 -5.9969998896121979e+01) (float-vector 2.9537400603294373e+02 -2.4685899913311005e+02 -5.9969700872898102e+01) (float-vector 2.9864698648452759e+02 -2.3860499262809753e+02 -5.9969801455736160e+01) (float-vector 2.9864698648452759e+02 -2.1059499680995941e+02 -5.9969801455736160e+01) (float-vector 2.9255101084709167e+02 -2.0005699992179871e+02 -5.9970799833536148e+01) (float-vector 1.3508500158786774e+02 -2.0466500520706177e+02 -5.9969898313283920e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.9864698648452759e+02 -2.3860499262809753e+02 -5.9969801455736160e+01) (float-vector 2.9537400603294373e+02 -2.4685899913311005e+02 -5.9969700872898102e+01) (float-vector 3.0589500069618225e+02 -2.7118900418281555e+02 1.0526499897241592e+02) (float-vector 3.1669801473617554e+02 -2.4011799693107605e+02 1.0230000317096710e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1669801473617554e+02 -2.4011799693107605e+02 1.0230000317096710e+02) (float-vector 3.1815099716186523e+02 -2.2218500077724457e+02 1.0230000317096710e+02) (float-vector 2.9864698648452759e+02 -2.1059499680995941e+02 -5.9969801455736160e+01) (float-vector 2.9864698648452759e+02 -2.3860499262809753e+02 -5.9969801455736160e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.2460000216960907e+02 -2.9960000514984131e+02 1.3955000042915344e+02) (float-vector 2.5811100006103516e+02 -2.9184100031852722e+02 1.3955000042915344e+02) (float-vector 2.5209999084472656e+02 -3.1110000610351562e+02 1.2899999320507050e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1815099716186523e+02 -2.2218500077724457e+02 1.0230000317096710e+02) (float-vector 3.1669801473617554e+02 -2.4011799693107605e+02 1.0230000317096710e+02) (float-vector 2.9672199487686157e+02 -2.4559000134468079e+02 1.3955000042915344e+02) (float-vector 2.9960998892784119e+02 -2.2743700444698334e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.8716799616813660e+02 -2.6609998941421509e+02 1.3955000042915344e+02) (float-vector 2.9672199487686157e+02 -2.4559000134468079e+02 1.3955000042915344e+02) (float-vector 3.1669801473617554e+02 -2.4011799693107605e+02 1.0230000317096710e+02) (float-vector 3.0589500069618225e+02 -2.7118900418281555e+02 1.0526499897241592e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.9610601067543030e+02 -2.8678798675537109e+02 1.0230000317096710e+02) (float-vector 2.5176900625228882e+02 -3.1110000610351562e+02 -3.2848101109266281e+01) (float-vector 2.5209999084472656e+02 -3.1110000610351562e+02 1.2899999320507050e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.9537400603294373e+02 -2.4685899913311005e+02 -5.9969700872898102e+01) (float-vector 2.5176900625228882e+02 -3.1110000610351562e+02 -3.2848101109266281e+01) (float-vector 2.9610601067543030e+02 -2.8678798675537109e+02 1.0230000317096710e+02) (float-vector 3.0589500069618225e+02 -2.7118900418281555e+02 1.0526499897241592e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.5209999084472656e+02 -3.1110000610351562e+02 1.2899999320507050e+02) (float-vector 2.5811100006103516e+02 -2.9184100031852722e+02 1.3955000042915344e+02) (float-vector 2.8716799616813660e+02 -2.6609998941421509e+02 1.3955000042915344e+02) (float-vector 3.0589500069618225e+02 -2.7118900418281555e+02 1.0526499897241592e+02) (float-vector 2.9610601067543030e+02 -2.8678798675537109e+02 1.0230000317096710e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.3811499774456024e+02 -3.1110000610351562e+02 -5.2161600440740585e+01) (float-vector 2.5176900625228882e+02 -3.1110000610351562e+02 -3.2848101109266281e+01) (float-vector 2.9537400603294373e+02 -2.4685899913311005e+02 -5.9969700872898102e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.5209999084472656e+02 -1.3809999823570251e+02 1.2899999320507050e+02) (float-vector 2.5044301152229309e+02 -1.3809899985790253e+02 -3.8267400115728378e+01) (float-vector 2.9610601067543030e+02 -1.6241200268268585e+02 1.0230000317096710e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.8169798851013184e+02 -1.7591199278831482e+02 1.3955000042915344e+02) (float-vector 2.5209999084472656e+02 -1.3809999823570251e+02 1.2899999320507050e+02) (float-vector 2.9610601067543030e+02 -1.6241200268268585e+02 1.0230000317096710e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.1015399694442749e+02 -1.3809999823570251e+02 -5.1552701741456985e+01) (float-vector 1.9738100469112396e+02 -1.3809999823570251e+02 -3.2403599470853806e+01) (float-vector 1.3508500158786774e+02 -2.0466500520706177e+02 -5.9969898313283920e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.9501000046730042e+02 -1.9822399318218231e+02 1.3955000042915344e+02) (float-vector 3.1113600730895996e+02 -1.8976399302482605e+02 1.0526599735021591e+02) (float-vector 3.1815099716186523e+02 -2.2218500077724457e+02 1.0230000317096710e+02) (float-vector 2.9960998892784119e+02 -2.2743700444698334e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.9501000046730042e+02 -1.9822399318218231e+02 1.3955000042915344e+02) (float-vector 2.8169798851013184e+02 -1.7591199278831482e+02 1.3955000042915344e+02) (float-vector 2.9610601067543030e+02 -1.6241200268268585e+02 1.0230000317096710e+02) (float-vector 3.1113600730895996e+02 -1.8976399302482605e+02 1.0526599735021591e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3440899550914764e+02 -2.4332399666309357e+02 -5.9969998896121979e+01) (float-vector 2.2893799841403961e+02 -3.1110000610351562e+02 -5.5569801479578018e+01) (float-vector 2.9537400603294373e+02 -2.4685899913311005e+02 -5.9969700872898102e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.2893799841403961e+02 -3.1110000610351562e+02 -5.5569801479578018e+01) (float-vector 1.3440899550914764e+02 -2.4332399666309357e+02 -5.9969998896121979e+01) (float-vector 2.0844100415706635e+02 -3.1110000610351562e+02 -5.0521600991487503e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.2893799841403961e+02 -3.1110000610351562e+02 -5.5569801479578018e+01) (float-vector 2.3811499774456024e+02 -3.1110000610351562e+02 -5.2161600440740585e+01) (float-vector 2.9537400603294373e+02 -2.4685899913311005e+02 -5.9969700872898102e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.5209999084472656e+02 -3.1110000610351562e+02 1.2899999320507050e+02) (float-vector 2.5176900625228882e+02 -3.1110000610351562e+02 -3.2848101109266281e+01) (float-vector 2.3811499774456024e+02 -3.1110000610351562e+02 -5.2161600440740585e+01) (float-vector 2.2893799841403961e+02 -3.1110000610351562e+02 -5.5569801479578018e+01) (float-vector 2.0844100415706635e+02 -3.1110000610351562e+02 -5.0521600991487503e+01) (float-vector 2.0128400623798370e+02 -3.1110000610351562e+02 -4.2833201587200165e+01) (float-vector 1.9709999859333038e+02 -3.1110000610351562e+02 -2.8200000524520874e+01) (float-vector 1.9709999859333038e+02 -3.1110000610351562e+02 1.2899999320507050e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.5209999084472656e+02 -1.3809999823570251e+02 1.2899999320507050e+02) (float-vector 2.5889199972152710e+02 -1.5772600471973419e+02 1.3955000042915344e+02) (float-vector 2.3610100150108337e+02 -1.5035900473594666e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.5889199972152710e+02 -1.5772600471973419e+02 1.3955000042915344e+02) (float-vector 2.5209999084472656e+02 -1.3809999823570251e+02 1.2899999320507050e+02) (float-vector 2.8169798851013184e+02 -1.7591199278831482e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.2794699668884277e+02 -1.3809999823570251e+02 -5.5608499795198441e+01) (float-vector 2.1015399694442749e+02 -1.3809999823570251e+02 -5.1552701741456985e+01) (float-vector 1.3508500158786774e+02 -2.0466500520706177e+02 -5.9969898313283920e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.3736700415611267e+02 -1.3809999823570251e+02 -5.2639398723840714e+01) (float-vector 2.2794699668884277e+02 -1.3809999823570251e+02 -5.5608499795198441e+01) (float-vector 1.3508500158786774e+02 -2.0466500520706177e+02 -5.9969898313283920e+01) (float-vector 2.9255101084709167e+02 -2.0005699992179871e+02 -5.9970799833536148e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7696300148963928e+02 -2.8273099660873413e+02 1.3955000042915344e+02) (float-vector 2.0340099930763245e+02 -2.9661598801612854e+02 1.3955000042915344e+02) (float-vector 1.9709999859333038e+02 -3.1110000610351562e+02 1.2899999320507050e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7696300148963928e+02 -2.8273099660873413e+02 1.3955000042915344e+02) (float-vector 1.9709999859333038e+02 -3.1110000610351562e+02 1.2899999320507050e+02) (float-vector 1.5309399366378784e+02 -2.8678798675537109e+02 1.0526599735021591e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3734400272369385e+02 -2.3003600537776947e+02 1.2899999320507050e+02) (float-vector 1.3500599563121796e+02 -2.5077700614929199e+02 1.0526599735021591e+02) (float-vector 1.3131399452686310e+02 -2.1692399680614471e+02 1.0526499897241592e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.9738100469112396e+02 -1.3809999823570251e+02 -3.2403599470853806e+01) (float-vector 1.9709999859333038e+02 -1.3809999823570251e+02 1.2899999320507050e+02) (float-vector 1.5309399366378784e+02 -1.6241200268268585e+02 1.0526599735021591e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.9709999859333038e+02 -1.3809999823570251e+02 1.2899999320507050e+02) (float-vector 2.1438600122928619e+02 -1.5020799636840820e+02 1.3955000042915344e+02) (float-vector 1.9309400022029877e+02 -1.5641400218009949e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.5209999084472656e+02 -1.3809999823570251e+02 1.2899999320507050e+02) (float-vector 1.9709999859333038e+02 -1.3809999823570251e+02 1.2899999320507050e+02) (float-vector 1.9738100469112396e+02 -1.3809999823570251e+02 -3.2403599470853806e+01) (float-vector 2.1015399694442749e+02 -1.3809999823570251e+02 -5.1552701741456985e+01) (float-vector 2.2794699668884277e+02 -1.3809999823570251e+02 -5.5608499795198441e+01) (float-vector 2.3736700415611267e+02 -1.3809999823570251e+02 -5.2639398723840714e+01) (float-vector 2.5044301152229309e+02 -1.3809899985790253e+02 -3.8267400115728378e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.9709999859333038e+02 -1.3809999823570251e+02 1.2899999320507050e+02) (float-vector 2.5209999084472656e+02 -1.3809999823570251e+02 1.2899999320507050e+02) (float-vector 2.3610100150108337e+02 -1.5035900473594666e+02 1.3955000042915344e+02) (float-vector 2.1438600122928619e+02 -1.5020799636840820e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.5309399366378784e+02 -2.8678798675537109e+02 1.0526599735021591e+02) (float-vector 1.4279800653457642e+02 -2.4782200157642365e+02 1.2899999320507050e+02) (float-vector 1.5774999558925629e+02 -2.5874999165534973e+02 1.3955000042915344e+02) (float-vector 1.7696300148963928e+02 -2.8273099660873413e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3500599563121796e+02 -2.5077700614929199e+02 1.0526599735021591e+02) (float-vector 1.3734400272369385e+02 -2.3003600537776947e+02 1.2899999320507050e+02) (float-vector 1.4279800653457642e+02 -2.4782200157642365e+02 1.2899999320507050e+02) (float-vector 1.5309399366378784e+02 -2.8678798675537109e+02 1.0526599735021591e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.9709999859333038e+02 -1.3809999823570251e+02 1.2899999320507050e+02) (float-vector 1.6753900051116943e+02 -1.7586100101470947e+02 1.3955000042915344e+02) (float-vector 1.5309399366378784e+02 -1.6241200268268585e+02 1.0526599735021591e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.6753900051116943e+02 -1.7586100101470947e+02 1.3955000042915344e+02) (float-vector 1.9709999859333038e+02 -1.3809999823570251e+02 1.2899999320507050e+02) (float-vector 1.9309400022029877e+02 -1.5641400218009949e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3976199924945831e+02 -1.8562600016593933e+02 1.0526499897241592e+02) (float-vector 1.3915100693702698e+02 -2.1066899597644806e+02 1.2899999320507050e+02) (float-vector 1.3131399452686310e+02 -2.1692399680614471e+02 1.0526499897241592e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3915100693702698e+02 -2.1066899597644806e+02 1.2899999320507050e+02) (float-vector 1.3734400272369385e+02 -2.3003600537776947e+02 1.2899999320507050e+02) (float-vector 1.3131399452686310e+02 -2.1692399680614471e+02 1.0526499897241592e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3976199924945831e+02 -1.8562600016593933e+02 1.0526499897241592e+02) (float-vector 1.5309399366378784e+02 -1.6241200268268585e+02 1.0526599735021591e+02) (float-vector 1.6753900051116943e+02 -1.7586100101470947e+02 1.3955000042915344e+02) (float-vector 1.3915100693702698e+02 -2.1066899597644806e+02 1.2899999320507050e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.5259000658988953e+02 -2.0331899821758270e+02 1.3955000042915344e+02) (float-vector 1.3915100693702698e+02 -2.1066899597644806e+02 1.2899999320507050e+02) (float-vector 1.6753900051116943e+02 -1.7586100101470947e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.9960998892784119e+02 -2.2743700444698334e+02 1.3955000042915344e+02) (float-vector 2.9672199487686157e+02 -2.4559000134468079e+02 1.3955000042915344e+02) (float-vector 2.8716799616813660e+02 -2.6609998941421509e+02 1.3955000042915344e+02) (float-vector 2.5811100006103516e+02 -2.9184100031852722e+02 1.3955000042915344e+02) (float-vector 2.2460000216960907e+02 -2.9960000514984131e+02 1.3955000042915344e+02) (float-vector 2.0340099930763245e+02 -2.9661598801612854e+02 1.3955000042915344e+02) (float-vector 1.7696300148963928e+02 -2.8273099660873413e+02 1.3955000042915344e+02) (float-vector 1.5774999558925629e+02 -2.5874999165534973e+02 1.3955000042915344e+02) (float-vector 1.4979700744152069e+02 -2.3099899291992188e+02 1.3955000042915344e+02) (float-vector 1.5259000658988953e+02 -2.0331899821758270e+02 1.3955000042915344e+02) (float-vector 1.6753900051116943e+02 -1.7586100101470947e+02 1.3955000042915344e+02) (float-vector 1.9309400022029877e+02 -1.5641400218009949e+02 1.3955000042915344e+02) (float-vector 2.1438600122928619e+02 -1.5020799636840820e+02 1.3955000042915344e+02) (float-vector 2.3610100150108337e+02 -1.5035900473594666e+02 1.3955000042915344e+02) (float-vector 2.5889199972152710e+02 -1.5772600471973419e+02 1.3955000042915344e+02) (float-vector 2.8169798851013184e+02 -1.7591199278831482e+02 1.3955000042915344e+02) (float-vector 2.9501000046730042e+02 -1.9822399318218231e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.4979700744152069e+02 -2.3099899291992188e+02 1.3955000042915344e+02) (float-vector 1.3734400272369385e+02 -2.3003600537776947e+02 1.2899999320507050e+02) (float-vector 1.3915100693702698e+02 -2.1066899597644806e+02 1.2899999320507050e+02) (float-vector 1.5259000658988953e+02 -2.0331899821758270e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3734400272369385e+02 -2.3003600537776947e+02 1.2899999320507050e+02) (float-vector 1.4979700744152069e+02 -2.3099899291992188e+02 1.3955000042915344e+02) (float-vector 1.5774999558925629e+02 -2.5874999165534973e+02 1.3955000042915344e+02) (float-vector 1.4279800653457642e+02 -2.4782200157642365e+02 1.2899999320507050e+02)))))
              ))
             )
      (setq geom (instance collada-body :init :replace-obj qhull :name "bl_caster_rotation_link_geom0"))
      (when glv
        (setq (geom . gl::aglvertices) glv)
        (send geom :assoc glv))
      geom))
  (:_make_instance_br_caster_l_wheel_link_geom0 ()
    (let (geom glv qhull
          (local-cds (make-coords :pos (float-vector 0.0000000000000000e+00 4.9000000000000000e+01 0.0000000000000000e+00))))
      (setq glv
       (instance gl::glvertices :init
                 (list ;; mesh list
                  (list ;; mesh description
                   (list :type :triangles)
                   (list :material (list
                    (list :ambient (float-vector 0.000100 0.000100 0.000100 1.000000))
                    (list :diffuse (float-vector 0.000000 0.000000 0.000000 1.000000))))
                   (list :indices #i( 0 1 2 0 4 1 2 28 0 30 4 0 28 30 0 21 22 2 22 28 2 2 1 21 28 29 30 22 29 28 30 29 31 30 31 4 404 29 407 408 407 29 31 29 404 22 408 29 20 22 21 22 20 408 18 20 21 17 20 18 412 20 17 408 20 412 17 18 19 21 486 18 18 486 19 17 19 16 412 17 16 412 413 414 412 414 408 412 16 413 413 415 414 409 415 413 413 15 409 413 16 481 413 481 15 14 15 7 409 15 14 481 7 15 481 16 7 6 7 8 8 7 11 14 7 6 16 11 7 14 6 10 409 14 10 9 10 6 6 487 9 8 489 6 6 489 487 8 11 13 8 488 489 13 488 8 12 13 11 11 16 12 13 12 19 19 488 13 486 488 19 486 499 488 488 499 497 488 497 489 16 19 12 489 497 494 489 494 487 497 459 494 499 459 497 486 498 499 499 474 459 499 498 474 493 498 486 474 498 475 498 493 475 40 474 475 475 478 471 40 475 471 475 493 478 37 39 40 41 37 40 41 40 471 39 474 40 41 471 378 471 478 378 478 476 378 478 493 476 69 378 379 37 41 378 37 378 69 378 476 379 476 477 379 476 493 477 69 379 376 379 477 376 376 477 473 493 473 477 492 493 3 1 493 486 3 493 1 492 473 493 491 496 492 491 492 3 492 496 473 3 4 5 4 3 1 491 3 5 21 1 486 4 31 5 482 5 483 33 483 5 33 5 31 482 491 5 33 31 34 31 404 34 34 35 33 35 483 33 36 482 483 35 36 483 34 36 35 34 26 36 406 34 404 27 34 406 26 34 27 404 405 406 407 405 404 27 406 410 434 406 405 410 406 434 434 405 423 407 423 405 407 408 423 423 408 417 440 408 414 417 408 440 416 417 418 417 427 418 417 416 423 417 440 427 414 439 440 427 440 439 451 427 439 398 427 402 427 398 418 451 402 427 419 416 418 418 398 419 423 416 419 419 422 423 401 419 398 419 401 400 400 422 419 422 421 423 421 434 423 420 421 422 425 421 420 425 434 421 420 424 425 424 434 425 426 424 420 426 434 424 420 381 426 422 396 420 381 420 382 382 420 396 434 426 435 426 381 435 380 381 382 260 392 381 381 380 260 392 435 381 393 382 396 380 382 393 258 380 257 380 393 257 260 380 258 235 259 260 260 258 235 259 392 260 392 259 391 430 392 391 430 435 392 231 259 235 229 262 259 229 259 231 259 262 391 231 232 229 235 236 231 231 236 232 232 237 229 232 236 177 183 232 177 183 237 232 235 234 236 236 234 181 177 236 181 177 178 167 168 177 167 177 181 178 168 183 177 179 181 180 178 181 179 181 234 180 166 178 164 164 178 179 167 178 166 167 161 162 166 161 167 162 168 167 161 166 160 160 166 164 160 164 159 164 165 159 164 179 165 180 165 179 358 165 363 159 165 358 363 165 365 180 365 165 118 159 117 160 159 118 117 159 358 161 160 119 119 160 118 105 118 117 104 119 118 104 118 105 117 116 105 116 117 329 329 117 358 104 105 98 105 116 95 98 105 95 97 103 104 98 97 104 103 119 104 92 97 98 92 98 95 95 81 92 95 316 81 316 95 317 95 116 317 92 93 94 81 93 92 94 97 92 99 97 94 97 99 103 93 96 94 96 99 94 93 81 72 61 93 72 61 96 93 101 99 96 59 96 61 59 101 96 100 99 101 100 106 99 99 106 103 101 102 100 101 108 102 59 108 101 100 109 106 102 109 100 121 120 106 106 120 103 109 121 106 120 119 103 120 162 161 120 161 119 121 162 120 109 122 121 163 162 121 122 163 121 102 113 109 113 122 109 123 122 113 122 169 163 123 169 122 163 168 162 163 169 174 174 168 163 170 169 123 170 175 169 169 175 174 124 123 114 114 123 113 124 170 123 124 171 170 176 170 171 175 170 176 175 182 174 176 185 175 185 182 175 171 173 176 173 184 176 176 184 185 152 171 125 125 171 124 152 173 171 172 173 152 173 172 184 172 201 184 201 204 184 184 204 210 184 210 185 186 172 152 186 190 172 190 201 172 148 152 125 148 186 152 187 186 149 149 186 148 187 190 186 190 187 191 191 201 190 150 188 187 150 187 149 188 191 187 149 148 136 150 149 137 137 149 136 131 148 125 136 148 131 89 136 131 132 137 136 132 136 89 133 137 132 133 138 137 138 150 137 130 132 89 133 132 134 134 132 130 89 90 91 91 130 89 90 89 131 90 110 91 90 115 110 131 115 90 112 91 107 107 91 110 91 129 130 91 112 129 110 111 107 110 114 111 110 115 114 125 124 115 115 124 114 131 125 115 111 114 113 107 111 102 111 113 102 107 102 108 108 112 107 58 108 59 58 112 108 58 59 57 59 60 57 59 61 60 60 61 62 62 63 60 63 57 60 61 72 62 63 62 64 62 72 64 72 65 64 72 81 82 72 82 65 64 65 66 66 63 64 66 65 70 65 80 70 65 82 80 82 314 80 81 316 82 82 316 314 80 79 70 305 306 80 314 305 80 80 306 79 317 318 314 317 314 316 314 318 305 305 319 315 318 319 305 305 315 306 306 309 79 306 313 309 306 315 313 315 327 325 319 327 315 315 325 313 320 319 318 328 327 319 320 328 319 317 320 318 317 116 320 329 328 320 116 329 320 360 359 328 328 359 327 329 360 328 327 354 325 327 359 354 325 324 313 325 354 324 354 353 324 354 356 353 354 359 361 361 356 354 360 362 359 359 362 361 362 364 361 361 272 356 361 364 272 356 357 353 356 274 357 356 272 274 269 272 268 272 273 268 274 272 269 272 364 273 362 365 364 364 365 273 268 273 234 234 273 180 273 365 180 264 268 234 264 269 268 233 234 235 264 234 233 256 264 233 256 253 264 253 269 264 256 233 257 235 258 233 258 257 233 253 256 263 257 393 256 256 395 263 393 395 256 254 253 263 263 394 254 263 395 394 393 396 395 395 399 400 395 400 394 396 399 395 254 394 255 400 401 394 394 401 255 250 253 254 255 250 254 250 255 251 255 248 251 255 398 248 255 401 398 248 250 251 247 246 248 248 246 250 398 402 248 248 402 247 245 246 247 402 403 247 247 403 245 448 403 402 402 451 448 245 403 397 403 448 397 244 242 245 245 242 246 245 397 244 243 242 244 244 397 243 243 397 386 397 450 386 448 447 397 450 397 447 242 243 240 386 240 243 386 384 387 387 240 386 384 386 449 449 386 450 441 449 450 450 447 441 443 447 448 441 447 442 442 447 443 414 441 442 438 441 414 441 438 449 384 449 454 449 438 454 414 415 438 415 445 438 454 438 445 443 439 414 414 442 443 439 443 448 448 451 439 444 445 415 444 446 445 454 445 452 446 452 445 384 454 452 385 384 452 452 453 385 452 446 453 453 446 444 385 453 389 455 389 453 453 444 455 383 384 385 385 389 238 385 238 383 383 388 384 384 388 387 249 388 383 383 238 249 228 238 239 226 249 238 226 238 228 238 389 239 226 241 249 241 388 249 387 388 241 240 387 241 240 241 225 225 241 226 225 226 227 217 227 226 228 218 226 217 226 218 227 212 225 211 225 212 242 240 225 225 211 242 212 227 217 208 211 212 205 212 217 208 212 205 211 209 213 209 211 208 213 221 211 211 221 242 242 221 246 220 221 213 220 222 221 222 246 221 213 347 346 213 346 220 209 347 213 220 215 222 220 346 336 337 220 336 220 337 215 214 222 215 214 246 222 214 215 216 348 215 343 343 215 337 215 348 216 333 337 332 332 337 336 343 337 333 333 338 343 338 344 343 344 348 343 216 348 344 339 344 338 344 339 345 345 216 344 301 338 333 339 338 302 302 338 301 333 332 300 301 333 300 291 301 300 302 301 294 294 301 291 303 302 295 295 302 294 303 339 302 285 294 291 293 295 294 293 294 285 283 291 289 285 291 283 291 300 289 284 285 283 290 285 75 284 75 285 290 293 285 292 293 290 292 295 293 83 277 290 290 277 292 290 75 83 74 75 76 75 74 83 75 284 76 283 282 284 284 282 76 88 76 87 76 88 74 87 76 278 76 282 278 282 280 278 280 282 286 283 289 282 282 289 286 278 279 87 278 280 279 279 280 281 280 286 287 281 280 287 299 298 286 289 299 286 286 298 287 300 299 289 299 332 331 299 331 298 300 332 299 287 298 297 331 330 298 298 330 297 287 288 281 287 297 288 288 297 158 297 196 158 330 196 297 330 334 196 331 335 330 330 335 334 336 331 332 335 331 336 335 346 334 336 346 335 196 334 199 334 347 199 334 346 347 193 158 196 196 199 193 193 199 200 200 199 207 199 209 207 209 199 347 157 158 193 157 193 195 193 200 195 195 200 198 200 207 198 198 207 206 207 208 206 207 209 208 195 198 194 194 198 197 198 206 197 195 194 156 157 195 156 154 194 189 156 194 154 189 194 197 197 192 189 205 202 197 197 202 192 197 206 205 208 205 206 205 217 202 191 202 203 192 202 191 202 217 203 189 192 188 188 192 191 189 188 151 154 189 151 151 188 150 151 150 138 154 151 138 127 138 133 127 139 138 139 154 138 126 127 128 127 133 135 126 139 127 127 135 128 134 135 133 130 135 134 135 366 128 130 366 135 73 366 130 129 73 130 128 366 367 366 53 367 370 53 366 73 370 366 367 86 143 128 367 143 53 47 367 86 367 47 140 143 142 142 143 85 140 128 143 143 86 85 140 126 128 144 145 140 144 140 142 140 145 126 141 142 85 142 141 144 85 86 87 141 85 279 87 279 85 141 153 144 279 281 141 288 153 141 281 288 141 144 147 145 144 153 147 147 146 145 145 146 126 157 156 147 153 157 147 147 156 146 153 158 157 158 153 288 126 146 139 156 155 146 146 155 139 155 156 154 139 155 154 87 86 88 86 369 88 47 369 86 369 368 88 88 368 74 369 43 368 43 369 47 46 47 48 46 43 47 48 47 52 52 47 53 45 43 46 46 461 45 48 461 46 44 43 45 45 458 44 45 461 458 458 461 456 456 461 48 456 457 458 44 458 472 458 457 472 42 43 44 44 472 42 472 56 42 472 457 480 472 480 56 456 459 457 457 459 480 459 456 48 48 460 459 459 460 470 470 494 459 459 474 480 56 480 479 474 479 480 39 479 474 56 479 39 37 38 39 39 38 56 68 37 69 38 37 84 68 84 37 67 68 69 67 71 68 71 84 68 70 69 66 67 69 70 69 376 66 67 77 71 70 79 67 67 79 77 71 77 78 78 84 71 83 84 78 78 77 277 78 277 83 83 74 84 74 38 84 74 368 38 56 38 42 38 43 42 43 38 368 275 276 277 276 292 277 277 77 275 77 308 275 275 311 307 308 311 275 276 275 307 276 296 292 307 296 276 292 296 295 304 303 296 296 303 295 307 304 296 307 321 304 311 321 307 321 326 304 326 340 304 304 340 303 303 340 339 345 339 340 326 342 340 340 342 345 341 342 326 321 351 326 351 341 326 322 321 311 322 351 321 352 351 322 352 355 351 351 355 341 342 341 349 355 350 341 341 350 349 342 349 345 345 349 216 271 349 350 216 349 223 223 349 271 357 350 355 350 357 271 355 352 353 357 355 353 271 357 274 224 271 270 271 274 270 224 223 271 223 224 214 223 214 216 224 267 214 224 270 265 224 265 267 265 270 266 266 270 269 270 274 269 265 266 253 253 250 265 267 265 250 246 267 250 214 267 246 266 269 253 323 353 352 324 353 323 323 322 312 324 323 312 323 352 322 313 324 312 308 312 311 309 312 308 309 313 312 312 322 311 309 308 310 310 308 77 310 79 309 79 310 77 66 375 63 66 376 377 377 375 66 63 375 374 375 466 464 374 375 464 377 466 375 63 374 373 63 373 57 374 464 465 465 373 374 464 496 465 464 466 496 377 473 466 496 466 473 376 473 377 490 496 491 495 496 490 496 495 465 467 373 465 465 495 467 494 495 490 495 494 467 468 373 467 467 463 372 467 372 468 467 494 470 467 470 463 487 494 490 9 487 23 23 487 490 23 10 9 23 24 10 32 23 485 24 23 32 23 490 485 409 10 24 32 27 24 24 27 409 27 32 25 485 25 32 485 484 25 485 490 484 484 490 491 26 484 482 25 484 26 482 484 491 25 26 27 409 27 410 409 410 411 409 411 415 428 410 434 428 411 410 437 411 436 436 411 428 411 444 415 411 437 444 436 432 437 437 455 444 455 437 432 436 433 432 433 436 428 431 432 433 431 433 428 455 432 389 391 390 432 389 432 390 431 391 432 431 428 430 431 430 391 390 391 261 391 262 261 389 390 252 261 252 390 239 389 252 239 252 228 228 252 261 228 261 229 229 261 262 228 229 230 219 218 228 230 219 228 229 237 230 237 219 230 204 219 210 204 218 219 210 219 237 203 217 218 203 218 204 203 204 201 203 201 191 210 237 185 185 237 183 182 185 183 182 183 174 174 183 168 428 429 430 430 429 435 428 434 429 429 434 435 36 26 482 462 372 463 469 462 463 463 470 469 51 462 469 50 462 51 50 372 462 371 372 49 372 50 49 468 372 371 49 50 51 54 55 51 51 55 49 469 54 51 470 54 469 460 54 470 52 53 54 54 53 55 460 52 54 55 58 49 55 73 58 370 73 55 55 53 370 57 49 58 73 112 58 129 112 73 57 371 49 57 373 371 371 373 468 48 52 460 399 422 400 422 399 396 363 365 362 358 363 360 360 363 362 329 358 360))
                   (list :vertices (let ((mat (make-matrix 500 3))) (fvector-replace (array-entity mat) #f(5.1378703117370605e+00 -2.9734701156616211e+01 -9.3289899826049805e+00 2.7445201873779297e+00 -2.9418100357055664e+01 -1.2800700187683105e+01 1.0573199987411499e+00 -2.9640798568725586e+01 -1.0600199699401855e+01 1.0544799804687500e+01 -2.9430900573730469e+01 -8.4442996978759766e+00 8.2298793792724609e+00 -2.9580398559570312e+01 -6.8257398605346680e+00 1.0452800750732422e+01 -2.9676599502563477e+01 -2.3365499973297119e+00 -6.6212201118469238e+00 -2.9607198715209961e+01 8.3633699417114258e+00 -1.0304100036621094e+01 -8.0464500427246094e+01 4.2757096290588379e+00 -9.9000797271728516e+00 -2.9565000534057617e+01 4.3990101814270020e+00 -3.0437600612640381e+00 -2.9632600784301758e+01 1.0238399505615234e+01 -3.0640001296997070e+00 -8.0891304016113281e+01 1.0639900207519531e+01 -1.0523200035095215e+01 -2.9807800292968750e+01 2.0460700988769531e+00 -1.0421499252319336e+01 -2.9872400283813477e+01 -1.9288499355316162e+00 -1.1160599708557129e+01 -2.9559000015258789e+01 -8.0958700180053711e-01 -7.1614899635314941e+00 -8.0892097473144531e+01 8.4554700851440430e+00 -1.0192299842834473e+01 -8.0942695617675781e+01 5.5663700103759766e+00 -1.0925999641418457e+01 -8.0888397216796875e+01 -2.1682801246643066e+00 -8.4008197784423828e+00 -8.0911102294921875e+01 -7.2349200248718262e+00 -6.7002696990966797e+00 -2.9603599548339844e+01 -8.3113307952880859e+00 -9.4348793029785156e+00 -2.9594200134277344e+01 -4.9726400375366211e+00 -5.3217201232910156e+00 -8.0856101989746094e+01 -9.7155799865722656e+00 -2.8588600158691406e+00 -2.9677499771118164e+01 -1.0273599624633789e+01 -1.0057700872421265e+00 -8.0903297424316406e+01 -1.1044600486755371e+01 1.0178999900817871e+00 -2.9632200241088867e+01 1.0607999801635742e+01 1.0090099573135376e+00 -8.0902297973632812e+01 1.1044500350952148e+01 7.1427397727966309e+00 -8.0804000854492188e+01 8.4595899581909180e+00 9.8030099868774414e+00 -8.0907203674316406e+01 5.1623497009277344e+00 7.4257197380065918e+00 -8.1105201721191406e+01 1.1212299346923828e+01 3.3442101478576660e+00 -8.0903900146484375e+01 -1.0557999610900879e+01 6.1998200416564941e+00 -8.1096000671386719e+01 -1.1747900009155273e+01 7.2372202873229980e+00 -8.0794494628906250e+01 -8.3683700561523438e+00 9.8025293350219727e+00 -8.0921005249023438e+01 -5.1738500595092773e+00 4.0853300094604492e+00 -8.0921997070312500e+01 1.0249599456787109e+01 1.0831099510192871e+01 -8.0742095947265625e+01 -2.0039701461791992e+00 1.2268199920654297e+01 -8.1127998352050781e+01 3.9475402832031250e+00 1.1011500358581543e+01 -8.0664100646972656e+01 0.0000000000000000e+00 1.0836700439453125e+01 -8.0821899414062500e+01 2.0019199848175049e+00 -1.1417300224304199e+01 -3.1931400299072266e+01 -6.0313899993896484e+01 -3.8845100402832031e+01 -3.1901300430297852e+01 -4.7875999450683594e+01 -3.0698499679565430e+01 -3.3114299774169922e+01 -3.9734401702880859e+01 -1.5955299377441406e+01 -3.3060798645019531e+01 -4.7729400634765625e+01 -2.3467898368835449e+00 -3.3005496978759766e+01 -5.1267002105712891e+01 -4.5538898468017578e+01 -3.2922698974609375e+01 -2.5041301727294922e+01 -6.0313198089599609e+01 -3.1965400695800781e+01 -7.4321599006652832e+00 -4.9943901062011719e+01 -3.2961498260498047e+01 -1.3358200073242188e+01 -5.1267002105712891e+01 -3.3005199432373047e+01 2.3467597961425781e+00 -4.8763401031494141e+01 -3.2972099304199219e+01 1.6582399368286133e+01 -6.1740497589111328e+01 -3.1979299545288086e+01 1.0151400566101074e+01 -4.5477100372314453e+01 -3.3045398712158203e+01 2.1893899917602539e+01 1.6372301101684570e+01 -3.1941600799560547e+01 5.8962200164794922e+01 2.3468399047851562e+00 -3.3007396697998047e+01 5.1267200469970703e+01 -9.9129495620727539e+00 -3.3083801269531250e+01 4.9431499481201172e+01 -3.6015296936035156e+01 -3.3108100891113281e+01 3.4995300292968750e+01 -4.8726200103759766e+01 -3.1919502258300781e+01 3.8182498931884766e+01 -2.5745399475097656e+01 -3.3058502197265625e+01 4.3290298461914062e+01 -6.4798698425292969e+00 -3.1922300338745117e+01 6.1833000183105469e+01 -3.9104801177978516e+01 -3.3105998992919922e+01 -3.1760398864746094e+01 3.8039699554443359e+01 -3.1931098937988281e+01 4.8811397552490234e+01 2.0110498428344727e+01 -3.2998302459716797e+01 6.3504100799560547e+01 4.7388999938964844e+01 -3.3059799194335938e+01 4.7388999938964844e+01 5.0501701354980469e+01 -3.2199699401855469e+01 3.8274200439453125e+01 6.3447898864746094e+01 -3.3059898376464844e+01 2.0092599868774414e+01 6.0778099060058594e+01 -3.2144401550292969e+01 1.7475801467895508e+01 6.0313198089599609e+01 -3.1965400695800781e+01 7.4321599006652832e+00 6.3284599304199219e+01 -3.2191196441650391e+01 -4.4547400474548340e+00 5.9817501068115234e+01 -3.3059898376464844e+01 -2.9234298706054688e+01 5.5512199401855469e+01 -3.1871200561523438e+01 -2.7132499694824219e+01 2.8417900085449219e+01 -3.3024398803710938e+01 -6.0260898590087891e+01 4.4547300338745117e+00 -3.2191101074218750e+01 -6.3284301757812500e+01 3.3109401702880859e+01 -3.1901699066162109e+01 -5.2159999847412109e+01 4.6935901641845703e+01 -3.2998600006103516e+01 -4.6935901641845703e+01 4.6696701049804688e+00 -3.3059997558593750e+01 -6.6339698791503906e+01 6.6339698791503906e+01 -3.3059997558593750e+01 -4.6691398620605469e+00 -1.2190400123596191e+01 -3.3019302368164062e+01 6.5981704711914062e+01 -4.4070800781250000e+01 -3.3025100708007812e+01 -4.9997600555419922e+01 -3.9661098480224609e+01 -3.2243999481201172e+01 -5.7238800048828125e+01 -5.8180297851562500e+01 -3.2244602203369141e+01 -3.8144996643066406e+01 1.5174099922180176e+01 -3.2350498199462891e+01 -6.8473693847656250e+01 4.8838300704956055e+00 -3.2246299743652344e+01 -6.9384094238281250e+01 4.1918899536132812e+01 -3.2255702972412109e+01 -5.5662799835205078e+01 5.6185497283935547e+01 -3.2231498718261719e+01 -4.1026100158691406e+01 6.9456398010253906e+01 -3.2233699798583984e+01 -1.5821299552917480e+00 6.6359199523925781e+01 -3.2246299743652344e+01 -2.1015600204467773e+01 -2.1015600204467773e+01 -3.2246299743652344e+01 -6.6359199523925781e+01 -2.0110498428344727e+01 -3.2998302459716797e+01 -6.3504100799560547e+01 -6.9488693237304688e+01 -3.2240303039550781e+01 1.4109100103378296e+00 -6.6339698791503906e+01 -3.3059997558593750e+01 -4.6691398620605469e+00 -6.6359199523925781e+01 -3.2246299743652344e+01 -2.1015600204467773e+01 -5.9817501068115234e+01 -3.3059898376464844e+01 -2.9234298706054688e+01 -1.5645200729370117e+01 -3.8389400482177734e+01 7.4474800109863281e+01 -1.7341400384902954e+00 -3.8391998291015625e+01 7.6071098327636719e+01 5.1130599975585938e+00 -3.4403301239013672e+01 7.2644706726074219e+01 7.1366401672363281e+01 -3.4439002990722656e+01 1.3268600463867188e+01 6.7285202026367188e+01 -3.2246299743652344e+01 1.7788499832153320e+01 6.7477394104003906e+01 -3.4428897857666016e+01 2.6760299682617188e+01 7.5355300903320312e+01 -3.7268402099609375e+01 1.7170599699020386e+00 5.9104999542236328e+01 -3.2233699798583984e+01 3.6562202453613281e+01 7.0040397644042969e+01 -3.8387001037597656e+01 2.9782499313354492e+01 7.4474800109863281e+01 -3.8389400482177734e+01 1.5645200729370117e+01 6.2013099670410156e+01 -3.7266197204589844e+01 4.2893001556396484e+01 5.1923801422119141e+01 -3.7266002655029297e+01 5.4677501678466797e+01 4.9207698822021484e+01 -3.2231403350830078e+01 4.9181400299072266e+01 3.9661300659179688e+01 -3.7265899658203125e+01 6.4126296997070312e+01 6.6670997619628906e+01 -4.3020999908447266e+01 4.1205699920654297e+01 7.3550094604492188e+01 -4.3022300720214844e+01 2.7057100296020508e+01 7.7358497619628906e+01 -4.3024600982666016e+01 1.2475700378417969e+01 5.6843299865722656e+01 -4.3021598815917969e+01 5.3966102600097656e+01 2.5049600601196289e+01 -3.4442001342773438e+01 6.8122604370117188e+01 3.6946399688720703e+01 -3.2240901947021484e+01 5.8903797149658203e+01 4.4562896728515625e+01 -4.3020900726318359e+01 6.4476997375488281e+01 1.2114600181579590e+01 -3.8389999389648438e+01 7.5127197265625000e+01 2.6272998809814453e+01 -3.8387500762939453e+01 7.1428794860839844e+01 2.1015600204467773e+01 -3.2246299743652344e+01 6.6359199523925781e+01 3.0671701431274414e+01 -4.3021900177001953e+01 7.2120101928710938e+01 1.6111700057983398e+01 -4.3023998260498047e+01 7.6686698913574219e+01 1.7856500148773193e+00 -4.3026500701904297e+01 7.8329895019531250e+01 7.8330101013183594e+01 -4.3027000427246094e+01 -1.7853500843048096e+00 7.9383201599121094e+01 -4.8954898834228516e+01 -3.4461998939514160e-01 7.8114799499511719e+01 -4.8949199676513672e+01 1.4203499794006348e+01 7.3951698303222656e+01 -4.8940597534179688e+01 2.8930398941040039e+01 6.6686599731445312e+01 -4.8934600830078125e+01 4.3129802703857422e+01 5.6477798461914062e+01 -4.8932300567626953e+01 5.5839900970458984e+01 4.3869800567626953e+01 -4.8934097290039062e+01 6.6202606201171875e+01 2.9704099655151367e+01 -4.8939601898193359e+01 7.3644798278808594e+01 1.4941699981689453e+01 -4.8947898864746094e+01 7.7977600097656250e+01 3.4459200501441956e-01 -4.8954898834228516e+01 7.9383300781250000e+01 -6.4126296997070312e+01 -3.7265899658203125e+01 3.9661300659179688e+01 -5.3850097656250000e+01 -3.6490200042724609e+01 5.2007102966308594e+01 -5.6481498718261719e+01 -3.2248001098632812e+01 4.0724998474121094e+01 -4.8838300704956055e+00 -3.2246299743652344e+01 6.9384094238281250e+01 -1.5174099922180176e+01 -3.2350498199462891e+01 6.8473693847656250e+01 -1.2475700378417969e+01 -4.3024600982666016e+01 7.7358497619628906e+01 -2.9782499313354492e+01 -3.8387001037597656e+01 7.0040397644042969e+01 -4.2893001556396484e+01 -3.7266197204589844e+01 6.2013099670410156e+01 -2.8395601272583008e+01 -3.4441600799560547e+01 6.6799201965332031e+01 -4.3375499725341797e+01 -3.2257099151611328e+01 5.4680000305175781e+01 -2.7057100296020508e+01 -4.3022300720214844e+01 7.3550094604492188e+01 -4.1205699920654297e+01 -4.3020999908447266e+01 6.6670997619628906e+01 -5.3966102600097656e+01 -4.3021598815917969e+01 5.6843299865722656e+01 -6.4476997375488281e+01 -4.3020900726318359e+01 4.4562896728515625e+01 -6.7513504028320312e+01 -3.4440597534179688e+01 2.6707201004028320e+01 -7.5355300903320312e+01 -3.7268402099609375e+01 -1.7170599699020386e+00 -7.1374496459960938e+01 -3.4436901092529297e+01 1.3211199760437012e+01 -6.7285202026367188e+01 -3.2246299743652344e+01 1.7788499832153320e+01 -7.5127197265625000e+01 -3.8389999389648438e+01 1.2114600181579590e+01 -7.1428794860839844e+01 -3.8387500762939453e+01 2.6272998809814453e+01 -7.2120101928710938e+01 -4.3021900177001953e+01 3.0671701431274414e+01 -7.6686698913574219e+01 -4.3023998260498047e+01 1.6111700057983398e+01 -1.4203499794006348e+01 -4.8949199676513672e+01 7.8114799499511719e+01 -2.8930398941040039e+01 -4.8940597534179688e+01 7.3951698303222656e+01 -4.3129802703857422e+01 -4.8934600830078125e+01 6.6686599731445312e+01 -5.4402599334716797e+01 -4.9551700592041016e+01 5.7758701324462891e+01 -1.7856500148773193e+00 -5.4973503112792969e+01 7.8329895019531250e+01 -7.8330101013183594e+01 -4.3027000427246094e+01 1.7853500843048096e+00 -6.4116600036621094e+01 -4.8947498321533203e+01 4.6979301452636719e+01 -6.7437301635742188e+01 -4.7811298370361328e+01 4.1716197967529297e+01 -7.3951698303222656e+01 -4.9059398651123047e+01 2.8930398941040039e+01 -7.8114799499511719e+01 -4.9050800323486328e+01 1.4203499794006348e+01 -7.9383201599121094e+01 -4.9045101165771484e+01 -3.4461998939514160e-01 7.8330101013183594e+01 -5.4972999572753906e+01 1.7853500843048096e+00 7.6686698913574219e+01 -5.4976001739501953e+01 1.6111700057983398e+01 7.2120101928710938e+01 -5.4978099822998047e+01 3.0671701431274414e+01 6.4476997375488281e+01 -5.4979099273681641e+01 4.4562896728515625e+01 5.3966102600097656e+01 -5.4978401184082031e+01 5.6843299865722656e+01 7.5127197265625000e+01 -5.9610000610351562e+01 1.2114600181579590e+01 7.5355300903320312e+01 -6.0731601715087891e+01 -1.7170599699020386e+00 7.1428794860839844e+01 -5.9612503051757812e+01 2.6272998809814453e+01 6.4126296997070312e+01 -6.0734100341796875e+01 3.9661300659179688e+01 5.3850097656250000e+01 -6.1509799957275391e+01 5.2007102966308594e+01 4.1205699920654297e+01 -5.4979000091552734e+01 6.6670997619628906e+01 2.7057100296020508e+01 -5.4977699279785156e+01 7.3550094604492188e+01 1.2475700378417969e+01 -5.4975402832031250e+01 7.7358497619628906e+01 -1.2114600181579590e+01 -5.9610000610351562e+01 7.5127197265625000e+01 1.7341400384902954e+00 -5.9608001708984375e+01 7.6071098327636719e+01 4.2893001556396484e+01 -6.0733798980712891e+01 6.2013099670410156e+01 2.9782499313354492e+01 -5.9612998962402344e+01 7.0040397644042969e+01 1.5645200729370117e+01 -5.9610603332519531e+01 7.4474800109863281e+01 5.6481498718261719e+01 -6.5751998901367188e+01 4.0724998474121094e+01 6.7513504028320312e+01 -6.3559398651123047e+01 2.6707201004028320e+01 7.1374496459960938e+01 -6.3563102722167969e+01 1.3211199760437012e+01 6.9488693237304688e+01 -6.5759704589843750e+01 1.4108999967575073e+00 6.7285202026367188e+01 -6.5753700256347656e+01 1.7788499832153320e+01 2.8395601272583008e+01 -6.3558399200439453e+01 6.6799201965332031e+01 4.3375499725341797e+01 -6.5742904663085938e+01 5.4680000305175781e+01 -5.1130700111389160e+00 -6.3596702575683594e+01 7.2644706726074219e+01 1.5174099922180176e+01 -6.5649505615234375e+01 6.8473693847656250e+01 -1.6111700057983398e+01 -5.4976001739501953e+01 7.6686698913574219e+01 -3.0671701431274414e+01 -5.4978099822998047e+01 7.2120101928710938e+01 -4.4562896728515625e+01 -5.4979099273681641e+01 6.4476997375488281e+01 -5.6843299865722656e+01 -5.4978401184082031e+01 5.3966102600097656e+01 -2.6272998809814453e+01 -5.9612503051757812e+01 7.1428794860839844e+01 -3.9661300659179688e+01 -6.0734100341796875e+01 6.4126296997070312e+01 -5.1923801422119141e+01 -6.0734001159667969e+01 5.4677501678466797e+01 -7.7358497619628906e+01 -5.4975402832031250e+01 1.2475700378417969e+01 -6.6670997619628906e+01 -5.4979000091552734e+01 4.1205699920654297e+01 -7.3550094604492188e+01 -5.4977699279785156e+01 2.7057100296020508e+01 -7.8330101013183594e+01 -5.4972999572753906e+01 -1.7853500843048096e+00 -6.2013099670410156e+01 -6.0733798980712891e+01 4.2893001556396484e+01 -7.0040397644042969e+01 -5.9612998962402344e+01 2.9782499313354492e+01 -7.5355300903320312e+01 -6.0731601715087891e+01 1.7170599699020386e+00 -7.4474800109863281e+01 -5.9610603332519531e+01 1.5645200729370117e+01 -2.5049600601196289e+01 -6.3557998657226562e+01 6.8122604370117188e+01 -4.9207698822021484e+01 -6.5768600463867188e+01 4.9181400299072266e+01 -3.6946399688720703e+01 -6.5759101867675781e+01 5.8903797149658203e+01 -2.1015600204467773e+01 -6.5753700256347656e+01 6.6359199523925781e+01 -5.9104999542236328e+01 -6.5766296386718750e+01 3.6562202453613281e+01 -6.7477394104003906e+01 -6.3571102142333984e+01 2.6760299682617188e+01 -7.1366401672363281e+01 -6.3561000823974609e+01 1.3268600463867188e+01 -6.7285202026367188e+01 -6.5753700256347656e+01 1.7788499832153320e+01 -6.9456398010253906e+01 -6.5766296386718750e+01 -1.5821199417114258e+00 4.8838300704956055e+00 -6.5753700256347656e+01 6.9384094238281250e+01 -6.5954093933105469e+01 -6.5003295898437500e+01 -1.1007699966430664e+01 -6.3504100799560547e+01 -6.5001693725585938e+01 2.0110498428344727e+01 -6.6359199523925781e+01 -6.5753700256347656e+01 -2.1015600204467773e+01 -2.0092599868774414e+01 -6.4940101623535156e+01 -6.3447898864746094e+01 -4.1918899536132812e+01 -6.5744300842285156e+01 -5.5662799835205078e+01 -1.5174099922180176e+01 -6.5649505615234375e+01 -6.8473693847656250e+01 -5.0577800750732422e+01 -6.4940101623535156e+01 4.3333198547363281e+01 -2.5114198684692383e+01 -6.5005798339843750e+01 6.1894699096679688e+01 -4.6691398620605469e+00 -6.4939994812011719e+01 6.6339698791503906e+01 -5.6185497283935547e+01 -6.5768501281738281e+01 -4.1026100158691406e+01 -5.9442901611328125e+01 -6.4974800109863281e+01 -3.0091600418090820e+01 -4.3333198547363281e+01 -6.4940101623535156e+01 -5.0577800750732422e+01 -4.8838400840759277e+00 -6.5753700256347656e+01 -6.9384094238281250e+01 4.6691398620605469e+00 -6.4939994812011719e+01 -6.6339698791503906e+01 -6.1515499114990234e+01 -6.6084396362304688e+01 7.3676099777221680e+00 -3.9422199249267578e+01 -6.6119201660156250e+01 4.7579696655273438e+01 -4.8702198028564453e+01 -6.5940795898437500e+01 3.9441997528076172e+01 -8.7784500122070312e+00 -6.6089698791503906e+01 6.1264701843261719e+01 3.0705200195312500e+01 -6.6117897033691406e+01 5.3397201538085938e+01 1.5252799987792969e+01 -6.5862602233886719e+01 6.1349498748779297e+01 5.0155899047851562e+01 -6.6073204040527344e+01 3.6021900177001953e+01 4.3594100952148438e+01 -6.4963195800781250e+01 5.0356700897216797e+01 6.0698596954345703e+01 -6.6066696166992188e+01 -6.7463498115539551e+00 6.6711799621582031e+01 -6.5003898620605469e+01 1.3542500138282776e-01 5.9121696472167969e+01 -6.6100502014160156e+01 1.8429199218750000e+01 5.9817501068115234e+01 -6.4940101623535156e+01 2.9234298706054688e+01 2.0092599868774414e+01 -6.4940101623535156e+01 6.3447898864746094e+01 -2.4017601013183594e+01 -6.4924705505371094e+01 4.4330997467041016e+01 -1.2296899795532227e+01 -6.4922195434570312e+01 4.8861900329589844e+01 -4.9878101348876953e+01 -6.4923797607421875e+01 6.1260700225830078e+00 -4.7621898651123047e+01 -6.5026702880859375e+01 2.0646100997924805e+01 -5.8962200164794922e+01 -6.6058395385742188e+01 -1.6372301101684570e+01 -4.9968898773193359e+01 -6.4928802490234375e+01 -5.5101404190063477e+00 -4.6904499053955078e+01 -6.4901504516601562e+01 -1.8820098876953125e+01 -4.1162097930908203e+01 -6.4915802001953125e+01 -2.8893501281738281e+01 -4.1316501617431641e+01 -6.6128295898437500e+01 -4.6076801300048828e+01 -3.1769998550415039e+01 -6.4940605163574219e+01 -3.8861301422119141e+01 -1.5955600738525391e+01 -6.4898902893066406e+01 -4.8028099060058594e+01 -3.6749000549316406e+01 -6.5010696411132812e+01 3.6192996978759766e+01 -7.4321599006652832e+00 -6.6034599304199219e+01 -6.0313198089599609e+01 -4.9870600700378418e+00 -6.5038299560546875e+01 -5.1429000854492188e+01 6.1151897907257080e-01 -6.4899902343750000e+01 5.0388702392578125e+01 4.0430500030517578e+01 -6.6047805786132812e+01 -4.7272399902343750e+01 2.1093599319458008e+01 -6.5008094787597656e+01 -4.7210800170898438e+01 5.7853302955627441e+00 -6.4969100952148438e+01 -5.0313201904296875e+01 4.5625198364257812e+01 -6.5076095581054688e+01 -2.5078199386596680e+01 5.2289600372314453e+01 -6.5047103881835938e+01 -4.6615300178527832e+00 4.9076499938964844e+01 -6.5030502319335938e+01 1.6025699615478516e+01 3.6085098266601562e+01 -6.4887702941894531e+01 3.5027797698974609e+01 4.5658901214599609e+01 -6.4956298828125000e+01 2.1977499008178711e+01 1.2848500251770020e+01 -6.4922805786132812e+01 4.8701698303222656e+01 2.4957799911499023e+01 -6.4924301147460938e+01 4.3825702667236328e+01 3.6392799377441406e+01 -6.5013999938964844e+01 -3.6605201721191406e+01 5.6047599792480469e+01 -6.6018997192382812e+01 -2.7524799346923828e+01 4.4547400474548340e+00 -6.5808799743652344e+01 -6.3284599304199219e+01 2.7442001342773438e+01 -6.5952598571777344e+01 -5.6365200042724609e+01 -1.7475801467895508e+01 -6.5855598449707031e+01 -6.0778099060058594e+01 6.3447898864746094e+01 -6.4940101623535156e+01 -2.0092599868774414e+01 5.0577800750732422e+01 -6.4940101623535156e+01 -4.3333198547363281e+01 2.9234298706054688e+01 -6.4940101623535156e+01 -5.9817501068115234e+01 2.1015600204467773e+01 -6.5753700256347656e+01 -6.6359199523925781e+01 5.6820499420166016e+01 -6.5761795043945312e+01 -4.0331298828125000e+01 6.6359199523925781e+01 -6.5753700256347656e+01 -2.1015600204467773e+01 4.3921298980712891e+01 -6.5758102416992188e+01 -5.3944599151611328e+01 1.5645200729370117e+01 -3.8389400482177734e+01 -7.4474800109863281e+01 1.7341400384902954e+00 -3.8391998291015625e+01 -7.6071098327636719e+01 -5.1130700111389160e+00 -3.4403301239013672e+01 -7.2644706726074219e+01 -6.7477394104003906e+01 -3.4428897857666016e+01 -2.6760299682617188e+01 -7.1366401672363281e+01 -3.4439002990722656e+01 -1.3268600463867188e+01 -7.0040397644042969e+01 -3.8387001037597656e+01 -2.9782499313354492e+01 -7.4474800109863281e+01 -3.8389400482177734e+01 -1.5645200729370117e+01 -6.2013099670410156e+01 -3.7266197204589844e+01 -4.2893001556396484e+01 -5.1923801422119141e+01 -3.7266002655029297e+01 -5.4677501678466797e+01 -5.1424598693847656e+01 -3.3472698211669922e+01 -4.9469097137451172e+01 -3.9661300659179688e+01 -3.7265899658203125e+01 -6.4126296997070312e+01 -6.6670997619628906e+01 -4.3020999908447266e+01 -4.1205699920654297e+01 -7.3550094604492188e+01 -4.3022300720214844e+01 -2.7057100296020508e+01 -7.7358497619628906e+01 -4.3024600982666016e+01 -1.2475700378417969e+01 -5.6843299865722656e+01 -4.3021598815917969e+01 -5.3966102600097656e+01 -2.5049600601196289e+01 -3.4442001342773438e+01 -6.8122604370117188e+01 -4.4562896728515625e+01 -4.3020900726318359e+01 -6.4476997375488281e+01 -1.2114600181579590e+01 -3.8389999389648438e+01 -7.5127197265625000e+01 -2.6272998809814453e+01 -3.8387500762939453e+01 -7.1428794860839844e+01 -3.0671701431274414e+01 -4.3021900177001953e+01 -7.2120101928710938e+01 -1.6111700057983398e+01 -4.3023998260498047e+01 -7.6686698913574219e+01 -1.7856500148773193e+00 -4.3026500701904297e+01 -7.8329895019531250e+01 -7.7977600097656250e+01 -4.9052101135253906e+01 -1.4941699981689453e+01 -7.3644798278808594e+01 -4.9060401916503906e+01 -2.9704099655151367e+01 -6.6202606201171875e+01 -4.9065898895263672e+01 -4.3869800567626953e+01 -5.5839900970458984e+01 -4.9067699432373047e+01 -5.6477798461914062e+01 -4.3129802703857422e+01 -4.9065399169921875e+01 -6.6686599731445312e+01 -2.8930398941040039e+01 -4.9059398651123047e+01 -7.3951698303222656e+01 -1.4203499794006348e+01 -4.9050800323486328e+01 -7.8114799499511719e+01 3.4459200501441956e-01 -4.9045101165771484e+01 -7.9383300781250000e+01 6.4126296997070312e+01 -3.7265899658203125e+01 -3.9661300659179688e+01 5.3850097656250000e+01 -3.6490200042724609e+01 -5.2007102966308594e+01 1.2475700378417969e+01 -4.3024600982666016e+01 -7.7358497619628906e+01 2.9782499313354492e+01 -3.8387001037597656e+01 -7.0040397644042969e+01 4.2893001556396484e+01 -3.7266197204589844e+01 -6.2013099670410156e+01 2.8395601272583008e+01 -3.4441600799560547e+01 -6.6799201965332031e+01 2.7057100296020508e+01 -4.3022300720214844e+01 -7.3550094604492188e+01 4.1205699920654297e+01 -4.3020999908447266e+01 -6.6670997619628906e+01 5.3966102600097656e+01 -4.3021598815917969e+01 -5.6843299865722656e+01 6.7513504028320312e+01 -3.4440597534179688e+01 -2.6707201004028320e+01 6.4476997375488281e+01 -4.3020900726318359e+01 -4.4562896728515625e+01 7.1374496459960938e+01 -3.4436901092529297e+01 -1.3211199760437012e+01 7.5127197265625000e+01 -3.8389999389648438e+01 -1.2114600181579590e+01 7.1428794860839844e+01 -3.8387500762939453e+01 -2.6272998809814453e+01 7.2120101928710938e+01 -4.3021900177001953e+01 -3.0671701431274414e+01 7.6686698913574219e+01 -4.3023998260498047e+01 -1.6111700057983398e+01 1.4941699981689453e+01 -4.9052101135253906e+01 -7.7977600097656250e+01 2.9704099655151367e+01 -4.9060401916503906e+01 -7.3644798278808594e+01 4.1731800079345703e+01 -4.9570999145507812e+01 -6.7475105285644531e+01 4.9999198913574219e+01 -4.8999500274658203e+01 -6.1567001342773438e+01 5.7531902313232422e+01 -4.8420101165771484e+01 -5.4633300781250000e+01 1.7856500148773193e+00 -5.4973503112792969e+01 -7.8329895019531250e+01 6.6202606201171875e+01 -4.8934097290039062e+01 -4.3869800567626953e+01 7.3644798278808594e+01 -4.8939601898193359e+01 -2.9704099655151367e+01 7.7977600097656250e+01 -4.8947898864746094e+01 -1.4941699981689453e+01 -7.6686698913574219e+01 -5.4976001739501953e+01 -1.6111700057983398e+01 -7.2120101928710938e+01 -5.4978099822998047e+01 -3.0671701431274414e+01 -6.4476997375488281e+01 -5.4979099273681641e+01 -4.4562896728515625e+01 -5.3966102600097656e+01 -5.4978401184082031e+01 -5.6843299865722656e+01 -7.5127197265625000e+01 -5.9610000610351562e+01 -1.2114600181579590e+01 -7.1428794860839844e+01 -5.9612503051757812e+01 -2.6272998809814453e+01 -6.4126296997070312e+01 -6.0734100341796875e+01 -3.9661300659179688e+01 -5.3850097656250000e+01 -6.1509799957275391e+01 -5.2007102966308594e+01 -4.1205699920654297e+01 -5.4979000091552734e+01 -6.6670997619628906e+01 -2.7057100296020508e+01 -5.4977699279785156e+01 -7.3550094604492188e+01 -1.2475700378417969e+01 -5.4975402832031250e+01 -7.7358497619628906e+01 1.2114600181579590e+01 -5.9610000610351562e+01 -7.5127197265625000e+01 -1.7341400384902954e+00 -5.9608001708984375e+01 -7.6071098327636719e+01 -4.2893001556396484e+01 -6.0733798980712891e+01 -6.2013099670410156e+01 -2.9782499313354492e+01 -5.9612998962402344e+01 -7.0040397644042969e+01 -1.5645200729370117e+01 -5.9610603332519531e+01 -7.4474800109863281e+01 -6.7513504028320312e+01 -6.3559398651123047e+01 -2.6707201004028320e+01 -7.1374496459960938e+01 -6.3563102722167969e+01 -1.3211199760437012e+01 -2.8395601272583008e+01 -6.3558399200439453e+01 -6.6799201965332031e+01 5.1130599975585938e+00 -6.3596702575683594e+01 -7.2644706726074219e+01 2.5049600601196289e+01 -6.3557998657226562e+01 -6.8122604370117188e+01 1.6111700057983398e+01 -5.4976001739501953e+01 -7.6686698913574219e+01 3.0671701431274414e+01 -5.4978099822998047e+01 -7.2120101928710938e+01 4.2744701385498047e+01 -5.6259502410888672e+01 -6.5250297546386719e+01 5.6843299865722656e+01 -5.4978401184082031e+01 -5.3966102600097656e+01 2.6272998809814453e+01 -5.9612503051757812e+01 -7.1428794860839844e+01 5.1923801422119141e+01 -6.0734001159667969e+01 -5.4677501678466797e+01 3.8678096771240234e+01 -6.2713600158691406e+01 -6.2656597137451172e+01 7.7358497619628906e+01 -5.4975402832031250e+01 -1.2475700378417969e+01 6.6670997619628906e+01 -5.4979000091552734e+01 -4.1205699920654297e+01 7.3550094604492188e+01 -5.4977699279785156e+01 -2.7057100296020508e+01 6.2013099670410156e+01 -6.0733798980712891e+01 -4.2893001556396484e+01 7.0040397644042969e+01 -5.9612998962402344e+01 -2.9782499313354492e+01 7.4474800109863281e+01 -5.9610603332519531e+01 -1.5645200729370117e+01 6.7477394104003906e+01 -6.3571102142333984e+01 -2.6760299682617188e+01 7.1366401672363281e+01 -6.3561000823974609e+01 -1.3268600463867188e+01 -4.6283000946044922e+01 -3.3059700012207031e+01 4.8698802947998047e+01 -6.3504100799560547e+01 -3.2998302459716797e+01 2.0110498428344727e+01 -5.2329101562500000e+01 -3.2130302429199219e+01 -3.4909000396728516e+01 -6.1349498748779297e+01 -3.2137401580810547e+01 -1.5252799987792969e+01 -3.8747798919677734e+01 -3.2020099639892578e+01 4.9141799926757812e+01 2.8352600097656250e+01 -3.2989597320556641e+01 4.3039199829101562e+01 1.5969698905944824e+01 -3.3055599212646484e+01 4.7725498199462891e+01 3.9991699218750000e+01 -3.3097698211669922e+01 3.0614299774169922e+01 4.8633197784423828e+01 -3.3084796905517578e+01 1.3720000267028809e+01 5.0044700622558594e+01 -3.3111999511718750e+01 -5.6227302551269531e+00 3.5953800201416016e+01 -3.3097698211669922e+01 -3.5078903198242188e+01 4.5476398468017578e+01 -3.3045200347900391e+01 -2.1894300460815430e+01 9.9145097732543945e+00 -3.3083801269531250e+01 -4.9431201934814453e+01 2.5745399475097656e+01 -3.3058502197265625e+01 -4.3290298461914062e+01 4.9954399108886719e+01 -6.5034202575683594e+01 5.4540300369262695e+00 4.8967998504638672e+01 -6.7537704467773438e+01 1.3350299835205078e+01 5.0034500122070312e+01 -6.7539604187011719e+01 -4.1453199386596680e+00 -3.3270900726318359e+01 -6.5033500671386719e+01 3.7523998260498047e+01 -4.3557899475097656e+01 -6.7537895202636719e+01 2.6049699783325195e+01 -2.8130199432373047e+01 -6.7539604187011719e+01 4.1621601104736328e+01 -4.9887100219726562e+01 -6.7539398193359375e+01 6.8354101181030273e+00 -4.7150398254394531e+01 -6.5031204223632812e+01 1.8047500610351562e+01 -4.0905799865722656e+01 -6.5034301757812500e+01 2.9103500366210938e+01 -9.2679700851440430e+00 -6.7539001464843750e+01 4.9685398101806641e+01 9.3136892318725586e+00 -6.7538703918457031e+01 4.9535301208496094e+01 2.6869998931884766e+01 -6.7538597106933594e+01 4.2637798309326172e+01 4.0471401214599609e+01 -6.7539604187011719e+01 2.9807500839233398e+01 4.8870899200439453e+01 -6.5032897949218750e+01 -1.3342700004577637e+01 2.4033800125122070e+01 -6.5031997680664062e+01 -4.4287799835205078e+01 3.8291000366210938e+01 -6.5033897399902344e+01 -3.2910102844238281e+01 4.7313400268554688e+01 -6.7535400390625000e+01 -1.8334699630737305e+01 -4.8967998504638672e+01 -6.7537704467773438e+01 -1.3350299835205078e+01 -6.9415998458862305e+00 -6.7539398193359375e+01 -4.9904800415039062e+01 3.7271400451660156e+01 -6.7538406372070312e+01 -3.3985900878906250e+01 2.5166799545288086e+01 -6.7537002563476562e+01 -4.3544601440429688e+01 1.0624900817871094e+01 -6.7538406372070312e+01 -4.9357997894287109e+01 -2.6072299957275391e+01 -6.7537796020507812e+01 -4.3274299621582031e+01 -4.0471401214599609e+01 -6.7539604187011719e+01 -2.9807500839233398e+01 1.2806200027465820e+01 -8.1073295593261719e+01 -3.8097999095916748e+00 1.3205300331115723e+01 -8.0267494201660156e+01 -5.5868902206420898e+00 1.3861199378967285e+01 -8.0269203186035156e+01 4.1422801017761230e+00 6.8685703277587891e+00 -8.0269203186035156e+01 -1.2765500068664551e+01 -3.6473600864410400e+00 -8.0430801391601562e+01 -1.3761699676513672e+01 -5.0008997917175293e+00 -8.1080497741699219e+01 1.2562399864196777e+01 6.8692898750305176e+00 -8.0268096923828125e+01 1.2766799926757812e+01 -2.6745600700378418e+00 -8.0267105102539062e+01 1.4119600296020508e+01 -1.0887900352478027e+01 -8.1082099914550781e+01 -8.1607704162597656e+00 -1.2876600265502930e+01 -8.1073501586914062e+01 3.7914199829101562e+00 -1.3522299766540527e+01 -8.0268005371093750e+01 -5.6108503341674805e+00 -1.2266799926757812e+01 -8.0268394470214844e+01 8.1145401000976562e+00 1.4918000221252441e+01 -8.0275100708007812e+01 -3.5685497283935547e+01 3.7123301029205322e+00 -8.0275100708007812e+01 -3.8456001281738281e+01 5.6025695800781250e+00 -6.7521499633789062e+01 -3.8081703186035156e+01 1.6305999755859375e+01 -6.7521499633789062e+01 -3.5007499694824219e+01 3.6341297149658203e+01 -6.7521499633789062e+01 -1.3186100006103516e+01 3.0869201660156250e+01 -8.0274299621582031e+01 -2.3010200500488281e+01 2.9183500289916992e+01 -6.7522102355957031e+01 -2.5193401336669922e+01 2.3136499404907227e+01 -8.0274299621582031e+01 -3.0677999496459961e+01 3.8549598693847656e+01 -8.0275100708007812e+01 -1.6160999536514282e+00 3.7004398345947266e+01 -8.0275100708007812e+01 -1.1183599472045898e+01 3.8620300292968750e+01 -6.7521499633789062e+01 8.1181198358535767e-01 -4.5067396163940430e+00 -6.7521499633789062e+01 -3.8375400543212891e+01 2.5930200576782227e+01 -8.0275100708007812e+01 2.8557600021362305e+01 3.1677902221679688e+01 -8.0274200439453125e+01 2.1873998641967773e+01 3.1033300399780273e+01 -6.7523498535156250e+01 2.2732900619506836e+01 2.0160699844360352e+01 -6.7523300170898438e+01 3.2750801086425781e+01 6.2813601493835449e+00 -6.7521499633789062e+01 3.8171100616455078e+01 1.6532600402832031e+01 -8.0275100708007812e+01 3.4899303436279297e+01 3.7707702636718750e+01 -8.0275100708007812e+01 8.4654598236083984e+00 3.6223800659179688e+01 -6.7521499633789062e+01 1.2949000358581543e+01 5.2079100608825684e+00 -8.0275100708007812e+01 3.8213302612304688e+01 -3.4080798625946045e+00 -8.0275100708007812e+01 3.8494800567626953e+01 -3.7614700317382812e+01 -8.0275100708007812e+01 9.4110794067382812e+00 -1.6054100036621094e+01 -8.0275100708007812e+01 -3.5240402221679688e+01 -5.2079100608825684e+00 -8.0275100708007812e+01 -3.8213302612304688e+01 -3.8329299926757812e+01 -8.0275100708007812e+01 -5.8210501670837402e+00 -3.2840499877929688e+01 -8.0274406433105469e+01 -1.9909101486206055e+01 -2.6819799423217773e+01 -8.0275001525878906e+01 -2.7747999191284180e+01 -1.7555700302124023e+01 -8.0275001525878906e+01 3.4412902832031250e+01 -3.1601600646972656e+01 -8.0274200439453125e+01 2.1895799636840820e+01 -2.5230501174926758e+01 -8.0274902343750000e+01 2.9101999282836914e+01 -3.3142398834228516e+01 -6.7523193359375000e+01 -1.9787399291992188e+01 -2.4508100509643555e+01 -6.7522598266601562e+01 -2.9667200088500977e+01 -3.8129898071289062e+01 -6.7521499633789062e+01 6.3573803901672363e+00 -3.7880397796630859e+01 -6.7521499633789062e+01 -7.4131999015808105e+00 -1.6590700149536133e+01 -6.7521499633789062e+01 -3.4709499359130859e+01 -2.8872499465942383e+01 -6.7521804809570312e+01 2.5504301071166992e+01 -1.9341501235961914e+01 -6.7523002624511719e+01 3.3339103698730469e+01 -3.4695800781250000e+01 -6.7521499633789062e+01 1.6600400924682617e+01 -7.6062998771667480e+00 -6.7521499633789062e+01 3.7799701690673828e+01 -4.9609901428222656e+01 -3.0460399627685547e+01 8.1507596969604492e+00 -4.9868400573730469e+01 -3.0460399627685547e+01 -6.8321399688720703e+00 -4.9947601318359375e+01 -3.2965702056884766e+01 -5.4530901908874512e+00 -4.4943298339843750e+01 -3.0460399627685547e+01 2.2791400909423828e+01 -3.5167198181152344e+01 -3.0460399627685547e+01 3.5853599548339844e+01 -4.9730598449707031e+01 -3.2965702056884766e+01 6.7970499992370605e+00 2.9969398975372314e+00 -3.2965702056884766e+01 5.0145702362060547e+01 6.9386696815490723e+00 -3.0460399627685547e+01 4.9888397216796875e+01 4.8833702087402344e+01 -3.0460399627685547e+01 1.3304400444030762e+01 4.0471401214599609e+01 -3.0460399627685547e+01 2.9807500839233398e+01 4.9868400573730469e+01 -3.0460399627685547e+01 -6.8321399688720703e+00 2.5877500534057617e+01 -3.0460399627685547e+01 4.3248897552490234e+01 2.9460500717163086e+01 -3.2965702056884766e+01 4.0491600036621094e+01 -1.0601699829101562e+01 -3.0460399627685547e+01 4.9272800445556641e+01 -2.4852701187133789e+01 -3.0460399627685547e+01 4.3484500885009766e+01 -2.9969398975372314e+00 -3.2965702056884766e+01 -5.0145702362060547e+01 -4.6939998626708984e+01 -3.2965702056884766e+01 -1.7957401275634766e+01 4.3438598632812500e+01 -3.0460399627685547e+01 -2.5998600006103516e+01 -2.4852701187133789e+01 -3.0460399627685547e+01 -4.3484500885009766e+01 -1.0601699829101562e+01 -3.0460399627685547e+01 -4.9272800445556641e+01 1.7176401138305664e+01 -3.0460399627685547e+01 -4.7315002441406250e+01 3.1059000015258789e+01 -3.0460399627685547e+01 -3.9376998901367188e+01 2.9829699993133545e+00 -3.0460399627685547e+01 -5.0146999359130859e+01 -3.5167198181152344e+01 -3.0460399627685547e+01 -3.5853599548339844e+01 -4.4943298339843750e+01 -3.0460399627685547e+01 -2.2791400909423828e+01 -1.1755400657653809e+01 -8.1032798767089844e+01 1.1027499437332153e+00 1.0264200210571289e+01 -2.9614400863647461e+01 2.9392998218536377e+00 1.0690099716186523e+01 -4.1044399261474609e+01 0.0000000000000000e+00 8.1825199127197266e+00 -2.9608499526977539e+01 6.8735299110412598e+00 5.0151400566101074e+00 -2.9599399566650391e+01 9.4172601699829102e+00 -6.3304600715637207e+00 -2.9442100524902344e+01 -1.2118599891662598e+01 -5.5505099296569824e+00 -2.9454700469970703e+01 1.2124200820922852e+01 -1.3189299583435059e+01 -2.9452299118041992e+01 -2.1639201641082764e+00 -1.1655500411987305e+01 -2.9457300186157227e+01 6.2997603416442871e+00 6.3305301666259766e+00 -2.9442100524902344e+01 1.2118599891662598e+01 1.3189299583435059e+01 -2.9452299118041992e+01 2.1639201641082764e+00 1.2706499099731445e+01 -3.0459199905395508e+01 -6.5114102363586426e+00 3.8211998939514160e+00 -3.0459899902343750e+01 -1.4019599914550781e+01 -3.8208501338958740e+00 -3.0458499908447266e+01 1.4018300056457520e+01 8.3117198944091797e+00 -3.0458000183105469e+01 1.1874300003051758e+01 1.4127900123596191e+01 -3.0459999084472656e+01 3.0538599491119385e+00 -1.2706499099731445e+01 -3.0459199905395508e+01 6.5114398002624512e+00 -8.3115901947021484e+00 -3.0458000183105469e+01 -1.1874400138854980e+01 -1.4127199172973633e+01 -3.0459199905395508e+01 -3.0536701679229736e+00 )) mat)))
                  )
                 ))
      (send glv :transform local-cds)
      (send glv :calc-normals)
      (setq qhull
            ;; qhull 3000 -> 81 faces
            (instance faceset :init :faces (list
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1677901744842529e+01 -8.0274201929569244e+01 2.1873999387025833e+01) (float-vector 1.6532599925994873e+01 -8.0275103449821472e+01 3.4899301826953888e+01) (float-vector 1.5174100175499916e+01 -6.5649501979351044e+01 6.8473696708679199e+01) (float-vector 4.3375499546527863e+01 -6.5742902457714081e+01 5.4680000990629196e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.7057100087404251e+01 -5.4977700114250183e+01 7.3550097644329071e+01) (float-vector 3.0671700835227966e+01 -4.3021898716688156e+01 7.2120100259780884e+01) (float-vector 4.4562898576259613e+01 -4.3020900338888168e+01 6.4476996660232544e+01) (float-vector 5.6477800011634827e+01 -4.8932299017906189e+01 5.5839899927377701e+01) (float-vector 4.2892999947071075e+01 -6.0733798891305923e+01 6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.6477800011634827e+01 -4.8932299017906189e+01 5.5839899927377701e+01) (float-vector 6.6686600446701050e+01 -4.8934601247310638e+01 4.3129801750183105e+01) (float-vector 6.4126297831535339e+01 -6.0734100639820099e+01 3.9661299437284470e+01) (float-vector 4.3375499546527863e+01 -6.5742902457714081e+01 5.4680000990629196e+01) (float-vector 4.2892999947071075e+01 -6.0733798891305923e+01 6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.1731800884008408e+01 -4.9571000039577484e+01 -6.7475102841854095e+01) (float-vector 2.7057100087404251e+01 -4.3022301048040390e+01 -7.3550097644329071e+01) (float-vector 3.4459200105629861e-01 -4.9045100808143616e+01 -7.9383298754692078e+01) (float-vector 1.2114600278437138e+01 -5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector 3.0671700835227966e+01 -5.4978098720312119e+01 -7.2120100259780884e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7341399798169732e+00 -3.8391999900341034e+01 -7.6071098446846008e+01) (float-vector -1.2114600278437138e+01 -3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector 3.4459200105629861e-01 -4.9045100808143616e+01 -7.9383298754692078e+01) (float-vector 2.7057100087404251e+01 -4.3022301048040390e+01 -7.3550097644329071e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.7614699453115463e+01 -8.0275103449821472e+01 9.4110798090696335e+00) (float-vector -6.7285202443599701e+01 -6.5753698348999023e+01 1.7788499593734741e+01) (float-vector -7.0040397346019745e+01 -5.9613000601530075e+01 2.9782500118017197e+01) (float-vector -6.2013100832700729e+01 -6.0733798891305923e+01 4.2892999947071075e+01) (float-vector -4.9207698553800583e+01 -6.5768599510192871e+01 4.9181401729583740e+01) (float-vector -2.5230500847101212e+01 -8.0274902284145355e+01 2.9101999476552010e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3129801750183105e+01 -4.8934601247310638e+01 6.6686600446701050e+01) (float-vector -3.9661299437284470e+01 -6.0734100639820099e+01 6.4126297831535339e+01) (float-vector -4.9207698553800583e+01 -6.5768599510192871e+01 4.9181401729583740e+01) (float-vector -6.2013100832700729e+01 -6.0733798891305923e+01 4.2892999947071075e+01) (float-vector -5.4402600973844528e+01 -4.9551699310541153e+01 5.7758700102567673e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.9661299437284470e+01 -6.0734100639820099e+01 6.4126297831535339e+01) (float-vector -4.3129801750183105e+01 -4.8934601247310638e+01 6.6686600446701050e+01) (float-vector -2.7057100087404251e+01 -4.3022301048040390e+01 7.3550097644329071e+01) (float-vector -1.4203500002622604e+01 -4.8949200659990311e+01 7.8114800155162811e+01) (float-vector -2.6272999122738838e+01 -5.9612501412630081e+01 7.1428798139095306e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.2892999947071075e+01 -3.7266198545694351e+01 6.2013100832700729e+01) (float-vector -5.3850099444389343e+01 -3.6490198224782944e+01 5.2007101476192474e+01) (float-vector -5.6481499224901199e+01 -3.2248001545667648e+01 4.0725000202655792e+01) (float-vector -4.3375499546527863e+01 -3.2257098704576492e+01 5.4680000990629196e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.6819799095392227e+01 -8.0274999141693115e+01 -2.7747999876737595e+01) (float-vector -3.7614699453115463e+01 -8.0275103449821472e+01 9.4110798090696335e+00) (float-vector -2.5230500847101212e+01 -8.0274902284145355e+01 2.9101999476552010e+01) (float-vector -3.4080799669027328e+00 -8.0275103449821472e+01 3.8494799286127090e+01) (float-vector 1.6532599925994873e+01 -8.0275103449821472e+01 3.4899301826953888e+01) (float-vector 3.1677901744842529e+01 -8.0274201929569244e+01 2.1873999387025833e+01) (float-vector 3.7004400044679642e+01 -8.0275103449821472e+01 -1.1183599941432476e+01) (float-vector 2.3136500269174576e+01 -8.0274298787117004e+01 -3.0678000301122665e+01) (float-vector -5.2079102024435997e+00 -8.0275103449821472e+01 -3.8213301450014114e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.7057100087404251e+01 -5.4977700114250183e+01 7.3550097644329071e+01) (float-vector 1.7341399798169732e+00 -5.9608001261949539e+01 7.6071098446846008e+01) (float-vector 3.4459200105629861e-01 -4.8954900354146957e+01 7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7341399798169732e+00 -5.9608001261949539e+01 7.6071098446846008e+01) (float-vector 2.7057100087404251e+01 -5.4977700114250183e+01 7.3550097644329071e+01) (float-vector 4.2892999947071075e+01 -6.0733798891305923e+01 6.2013100832700729e+01) (float-vector 4.3375499546527863e+01 -6.5742902457714081e+01 5.4680000990629196e+01) (float-vector 1.5174100175499916e+01 -6.5649501979351044e+01 6.8473696708679199e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7341399798169732e+00 -5.9608001261949539e+01 7.6071098446846008e+01) (float-vector 1.5174100175499916e+01 -6.5649501979351044e+01 6.8473696708679199e+01) (float-vector 1.6532599925994873e+01 -8.0275103449821472e+01 3.4899301826953888e+01) (float-vector -3.4080799669027328e+00 -8.0275103449821472e+01 3.8494799286127090e+01) (float-vector -2.1015599370002747e+01 -6.5753698348999023e+01 6.6359199583530426e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.9661299437284470e+01 -6.0734100639820099e+01 6.4126297831535339e+01) (float-vector -2.6272999122738838e+01 -5.9612501412630081e+01 7.1428798139095306e+01) (float-vector -2.1015599370002747e+01 -6.5753698348999023e+01 6.6359199583530426e+01) (float-vector -3.4080799669027328e+00 -8.0275103449821472e+01 3.8494799286127090e+01) (float-vector -2.5230500847101212e+01 -8.0274902284145355e+01 2.9101999476552010e+01) (float-vector -4.9207698553800583e+01 -6.5768599510192871e+01 4.9181401729583740e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.4459200105629861e-01 -4.8954900354146957e+01 7.9383298754692078e+01) (float-vector 1.7341399798169732e+00 -5.9608001261949539e+01 7.6071098446846008e+01) (float-vector -2.1015599370002747e+01 -6.5753698348999023e+01 6.6359199583530426e+01) (float-vector -2.6272999122738838e+01 -5.9612501412630081e+01 7.1428798139095306e+01) (float-vector -1.4203500002622604e+01 -4.8949200659990311e+01 7.8114800155162811e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.3644801974296570e+01 -4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector 7.4474796652793884e+01 -5.9610601514577866e+01 -1.5645200386643410e+01) (float-vector 7.9383201897144318e+01 -4.8954900354146957e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.2892999947071075e+01 -3.7266198545694351e+01 -6.2013100832700729e+01) (float-vector 5.6185498833656311e+01 -3.2231498509645462e+01 -4.1026100516319275e+01) (float-vector 1.5174100175499916e+01 -3.2350499182939529e+01 -6.8473696708679199e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.2892999947071075e+01 -3.7266198545694351e+01 -6.2013100832700729e+01) (float-vector 2.7057100087404251e+01 -4.3022301048040390e+01 -7.3550097644329071e+01) (float-vector 4.1731800884008408e+01 -4.9571000039577484e+01 -6.7475102841854095e+01) (float-vector 5.3966101258993149e+01 -4.3021600693464279e+01 -5.6843299418687820e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.5174100175499916e+01 -3.2350499182939529e+01 -6.8473696708679199e+01) (float-vector 1.7341399798169732e+00 -3.8391999900341034e+01 -7.6071098446846008e+01) (float-vector 2.7057100087404251e+01 -4.3022301048040390e+01 -7.3550097644329071e+01) (float-vector 4.2892999947071075e+01 -3.7266198545694351e+01 -6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.4459200105629861e-01 -4.8954900354146957e+01 7.9383298754692078e+01) (float-vector 1.7856500344350934e+00 -4.3026499450206757e+01 7.8329898416996002e+01) (float-vector 3.0671700835227966e+01 -4.3021898716688156e+01 7.2120100259780884e+01) (float-vector 2.7057100087404251e+01 -5.4977700114250183e+01 7.3550097644329071e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6686600446701050e+01 -4.8934601247310638e+01 4.3129801750183105e+01) (float-vector 6.2013100832700729e+01 -3.7266198545694351e+01 4.2892999947071075e+01) (float-vector 7.3550097644329071e+01 -4.3022301048040390e+01 2.7057100087404251e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.2013100832700729e+01 -3.7266198545694351e+01 4.2892999947071075e+01) (float-vector 5.9105001389980316e+01 -3.2233700156211853e+01 3.6562200635671616e+01) (float-vector 7.1366399526596069e+01 -3.4439001232385635e+01 1.3268600217998028e+01) (float-vector 7.3550097644329071e+01 -4.3022301048040390e+01 2.7057100087404251e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.2013100832700729e+01 -3.7266198545694351e+01 4.2892999947071075e+01) (float-vector 6.6686600446701050e+01 -4.8934601247310638e+01 4.3129801750183105e+01) (float-vector 5.6477800011634827e+01 -4.8932299017906189e+01 5.5839899927377701e+01) (float-vector 4.4562898576259613e+01 -4.3020900338888168e+01 6.4476996660232544e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.3644801974296570e+01 -4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector 7.9383201897144318e+01 -4.8954900354146957e+01 -3.4461999894119799e-01) (float-vector 7.5355298817157745e+01 -3.7268400192260742e+01 1.7170599894598126e+00) (float-vector 7.1428798139095306e+01 -3.8387499749660492e+01 -2.6272999122738838e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.1366399526596069e+01 -3.4439001232385635e+01 1.3268600217998028e+01) (float-vector 7.5355298817157745e+01 -3.7268400192260742e+01 1.7170599894598126e+00) (float-vector 7.9383201897144318e+01 -4.8954900354146957e+01 -3.4461999894119799e-01) (float-vector 7.3550097644329071e+01 -4.3022301048040390e+01 2.7057100087404251e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.6185498833656311e+01 -6.5768502652645111e+01 -4.1026100516319275e+01) (float-vector -7.1374498307704926e+01 -6.3563100993633270e+01 -1.3211200013756752e+01) (float-vector -6.7285202443599701e+01 -6.5753698348999023e+01 1.7788499593734741e+01) (float-vector -3.7614699453115463e+01 -8.0275103449821472e+01 9.4110798090696335e+00) (float-vector -2.6819799095392227e+01 -8.0274999141693115e+01 -2.7747999876737595e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.3850099444389343e+01 -6.1509799212217331e+01 -5.2007101476192474e+01) (float-vector -5.6185498833656311e+01 -6.5768502652645111e+01 -4.1026100516319275e+01) (float-vector -2.6819799095392227e+01 -8.0274999141693115e+01 -2.7747999876737595e+01) (float-vector -4.1918899863958359e+01 -6.5744303166866302e+01 -5.5662799626588821e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.2079102024435997e+00 -8.0275103449821472e+01 -3.8213301450014114e+01) (float-vector -4.8838402144610882e+00 -6.5753698348999023e+01 -6.9384098052978516e+01) (float-vector -2.9782500118017197e+01 -5.9613000601530075e+01 -7.0040397346019745e+01) (float-vector -4.1918899863958359e+01 -6.5744303166866302e+01 -5.5662799626588821e+01) (float-vector -2.6819799095392227e+01 -8.0274999141693115e+01 -2.7747999876737595e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.2114600278437138e+01 -5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector 2.5049600750207901e+01 -6.3557997345924377e+01 -6.8122602999210358e+01) (float-vector 3.0671700835227966e+01 -5.4978098720312119e+01 -7.2120100259780884e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.1731800884008408e+01 -4.9571000039577484e+01 -6.7475102841854095e+01) (float-vector 3.0671700835227966e+01 -5.4978098720312119e+01 -7.2120100259780884e+01) (float-vector 2.5049600750207901e+01 -6.3557997345924377e+01 -6.8122602999210358e+01) (float-vector 4.3921299278736115e+01 -6.5758101642131805e+01 -5.3944598883390427e+01) (float-vector 5.6843299418687820e+01 -5.4978400468826294e+01 -5.3966101258993149e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.3921299278736115e+01 -6.5758101642131805e+01 -5.3944598883390427e+01) (float-vector 2.5049600750207901e+01 -6.3557997345924377e+01 -6.8122602999210358e+01) (float-vector 1.2114600278437138e+01 -5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector -4.8838402144610882e+00 -6.5753698348999023e+01 -6.9384098052978516e+01) (float-vector -5.2079102024435997e+00 -8.0275103449821472e+01 -3.8213301450014114e+01) (float-vector 2.3136500269174576e+01 -8.0274298787117004e+01 -3.0678000301122665e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3375499546527863e+01 -3.2257098704576492e+01 5.4680000990629196e+01) (float-vector -5.6481499224901199e+01 -3.2248001545667648e+01 4.0725000202655792e+01) (float-vector -6.9488696753978729e+01 -3.2240301370620728e+01 1.4109100447967649e+00) (float-vector -5.8180298656225204e+01 -3.2244600355625153e+01 -3.8144998252391815e+01) (float-vector -3.9661098271608353e+01 -3.2244000583887100e+01 -5.7238798588514328e+01) (float-vector 2.7445200830698013e+00 -2.9418099671602249e+01 -1.2800700031220913e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.9661098271608353e+01 -3.2244000583887100e+01 -5.7238798588514328e+01) (float-vector -5.8180298656225204e+01 -3.2244600355625153e+01 -3.8144998252391815e+01) (float-vector -6.6670998930931091e+01 -4.3021000921726227e+01 -4.1205700486898422e+01) (float-vector -5.5839899927377701e+01 -4.9067698419094086e+01 -5.6477800011634827e+01) (float-vector -4.3129801750183105e+01 -4.9065399914979935e+01 -6.6686600446701050e+01) (float-vector -3.9661299437284470e+01 -3.7265900522470474e+01 -6.4126297831535339e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.1015599370002747e+01 -3.2246299088001251e+01 -6.6359199583530426e+01) (float-vector 1.5174100175499916e+01 -3.2350499182939529e+01 -6.8473696708679199e+01) (float-vector 5.6185498833656311e+01 -3.2231498509645462e+01 -4.1026100516319275e+01) (float-vector 2.7445200830698013e+00 -2.9418099671602249e+01 -1.2800700031220913e+01) (float-vector -3.9661098271608353e+01 -3.2244000583887100e+01 -5.7238798588514328e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.1015599370002747e+01 -3.2246299088001251e+01 -6.6359199583530426e+01) (float-vector -1.2114600278437138e+01 -3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector 1.7341399798169732e+00 -3.8391999900341034e+01 -7.6071098446846008e+01) (float-vector 1.5174100175499916e+01 -3.2350499182939529e+01 -6.8473696708679199e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.1015599370002747e+01 -3.2246299088001251e+01 -6.6359199583530426e+01) (float-vector -3.9661098271608353e+01 -3.2244000583887100e+01 -5.7238798588514328e+01) (float-vector -3.9661299437284470e+01 -3.7265900522470474e+01 -6.4126297831535339e+01) (float-vector -1.2114600278437138e+01 -3.8389999419450760e+01 -7.5127199292182922e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -6.7285202443599701e+01 -6.5753698348999023e+01 1.7788499593734741e+01) (float-vector -7.5355298817157745e+01 -6.0731600970029831e+01 1.7170599894598126e+00) (float-vector -7.0040397346019745e+01 -5.9613000601530075e+01 2.9782500118017197e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.5355298817157745e+01 -6.0731600970029831e+01 1.7170599894598126e+00) (float-vector -6.7285202443599701e+01 -6.5753698348999023e+01 1.7788499593734741e+01) (float-vector -7.1374498307704926e+01 -6.3563100993633270e+01 -1.3211200013756752e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.5839899927377701e+01 -4.9067698419094086e+01 -5.6477800011634827e+01) (float-vector -6.4476996660232544e+01 -5.4979100823402405e+01 -4.4562898576259613e+01) (float-vector -5.3850099444389343e+01 -6.1509799212217331e+01 -5.2007101476192474e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.3644801974296570e+01 -4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector -6.4476996660232544e+01 -5.4979100823402405e+01 -4.4562898576259613e+01) (float-vector -5.5839899927377701e+01 -4.9067698419094086e+01 -5.6477800011634827e+01) (float-vector -6.6670998930931091e+01 -4.3021000921726227e+01 -4.1205700486898422e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.3951698839664459e+01 -4.9059398472309113e+01 2.8930399566888809e+01) (float-vector -7.0040397346019745e+01 -5.9613000601530075e+01 2.9782500118017197e+01) (float-vector -7.5355298817157745e+01 -6.0731600970029831e+01 1.7170599894598126e+00) (float-vector -7.9383201897144318e+01 -4.9045100808143616e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6686600446701050e+01 -4.8934601247310638e+01 4.3129801750183105e+01) (float-vector 7.2120100259780884e+01 -5.4978098720312119e+01 3.0671700835227966e+01) (float-vector 6.4126297831535339e+01 -6.0734100639820099e+01 3.9661299437284470e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.5127199292182922e+01 -5.9610001742839813e+01 1.2114600278437138e+01) (float-vector 7.2120100259780884e+01 -5.4978098720312119e+01 3.0671700835227966e+01) (float-vector 6.6686600446701050e+01 -4.8934601247310638e+01 4.3129801750183105e+01) (float-vector 7.3550097644329071e+01 -4.3022301048040390e+01 2.7057100087404251e+01) (float-vector 7.9383201897144318e+01 -4.8954900354146957e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.4474796652793884e+01 -5.9610601514577866e+01 -1.5645200386643410e+01) (float-vector 6.9488696753978729e+01 -6.5759703516960144e+01 1.4109000330790877e+00) (float-vector 7.5127199292182922e+01 -5.9610001742839813e+01 1.2114600278437138e+01) (float-vector 7.9383201897144318e+01 -4.8954900354146957e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.4476996660232544e+01 -4.3020900338888168e+01 -4.4562898576259613e+01) (float-vector 6.6202603280544281e+01 -4.8934098333120346e+01 -4.3869800865650177e+01) (float-vector 7.3644801974296570e+01 -4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector 7.1428798139095306e+01 -3.8387499749660492e+01 -2.6272999122738838e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6202603280544281e+01 -4.8934098333120346e+01 -4.3869800865650177e+01) (float-vector 6.4476996660232544e+01 -4.3020900338888168e+01 -4.4562898576259613e+01) (float-vector 5.3966101258993149e+01 -4.3021600693464279e+01 -5.6843299418687820e+01) (float-vector 4.1731800884008408e+01 -4.9571000039577484e+01 -6.7475102841854095e+01) (float-vector 5.6843299418687820e+01 -5.4978400468826294e+01 -5.3966101258993149e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.1428798139095306e+01 -3.8387499749660492e+01 -2.6272999122738838e+01) (float-vector 5.6185498833656311e+01 -3.2231498509645462e+01 -4.1026100516319275e+01) (float-vector 4.2892999947071075e+01 -3.7266198545694351e+01 -6.2013100832700729e+01) (float-vector 5.3966101258993149e+01 -4.3021600693464279e+01 -5.6843299418687820e+01) (float-vector 6.4476996660232544e+01 -4.3020900338888168e+01 -4.4562898576259613e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 -3.2246299088001251e+01 -2.1015599370002747e+01) (float-vector 5.6185498833656311e+01 -3.2231498509645462e+01 -4.1026100516319275e+01) (float-vector 7.1428798139095306e+01 -3.8387499749660492e+01 -2.6272999122738838e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 -3.2246299088001251e+01 -2.1015599370002747e+01) (float-vector 7.1366399526596069e+01 -3.4439001232385635e+01 1.3268600217998028e+01) (float-vector 5.9105001389980316e+01 -3.2233700156211853e+01 3.6562200635671616e+01) (float-vector 2.7445200830698013e+00 -2.9418099671602249e+01 -1.2800700031220913e+01) (float-vector 5.6185498833656311e+01 -3.2231498509645462e+01 -4.1026100516319275e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.1366399526596069e+01 -3.4439001232385635e+01 1.3268600217998028e+01) (float-vector 6.6359199583530426e+01 -3.2246299088001251e+01 -2.1015599370002747e+01) (float-vector 7.1428798139095306e+01 -3.8387499749660492e+01 -2.6272999122738838e+01) (float-vector 7.5355298817157745e+01 -3.7268400192260742e+01 1.7170599894598126e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.5645200386643410e+01 -5.9610601514577866e+01 -7.4474796652793884e+01) (float-vector -2.9782500118017197e+01 -5.9613000601530075e+01 -7.0040397346019745e+01) (float-vector -4.8838402144610882e+00 -6.5753698348999023e+01 -6.9384098052978516e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.5645200386643410e+01 -5.9610601514577866e+01 -7.4474796652793884e+01) (float-vector -4.8838402144610882e+00 -6.5753698348999023e+01 -6.9384098052978516e+01) (float-vector 1.2114600278437138e+01 -5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector 3.4459200105629861e-01 -4.9045100808143616e+01 -7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.4474796652793884e+01 -3.8389399647712708e+01 -1.5645200386643410e+01) (float-vector -5.8180298656225204e+01 -3.2244600355625153e+01 -3.8144998252391815e+01) (float-vector -6.9488696753978729e+01 -3.2240301370620728e+01 1.4109100447967649e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.4474796652793884e+01 -3.8389399647712708e+01 -1.5645200386643410e+01) (float-vector -7.3644801974296570e+01 -4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector -6.6670998930931091e+01 -4.3021000921726227e+01 -4.1205700486898422e+01) (float-vector -5.8180298656225204e+01 -3.2244600355625153e+01 -3.8144998252391815e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.3850099444389343e+01 -6.1509799212217331e+01 -5.2007101476192474e+01) (float-vector -6.4476996660232544e+01 -5.4979100823402405e+01 -4.4562898576259613e+01) (float-vector -7.3644801974296570e+01 -4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector -7.6686702668666840e+01 -5.4976001381874084e+01 -1.6111699864268303e+01) (float-vector -7.1374498307704926e+01 -6.3563100993633270e+01 -1.3211200013756752e+01) (float-vector -5.6185498833656311e+01 -6.5768502652645111e+01 -4.1026100516319275e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.9383201897144318e+01 -4.9045100808143616e+01 -3.4461999894119799e-01) (float-vector -7.6686702668666840e+01 -5.4976001381874084e+01 -1.6111699864268303e+01) (float-vector -7.3644801974296570e+01 -4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector -7.4474796652793884e+01 -3.8389399647712708e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.1374498307704926e+01 -6.3563100993633270e+01 -1.3211200013756752e+01) (float-vector -7.6686702668666840e+01 -5.4976001381874084e+01 -1.6111699864268303e+01) (float-vector -7.9383201897144318e+01 -4.9045100808143616e+01 -3.4461999894119799e-01) (float-vector -7.5355298817157745e+01 -6.0731600970029831e+01 1.7170599894598126e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.0040397346019745e+01 -5.9613000601530075e+01 2.9782500118017197e+01) (float-vector -7.3951698839664459e+01 -4.9059398472309113e+01 2.8930399566888809e+01) (float-vector -6.4476996660232544e+01 -4.3020900338888168e+01 4.4562898576259613e+01) (float-vector -5.4402600973844528e+01 -4.9551699310541153e+01 5.7758700102567673e+01) (float-vector -6.2013100832700729e+01 -6.0733798891305923e+01 4.2892999947071075e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.2892999947071075e+01 -3.7266198545694351e+01 6.2013100832700729e+01) (float-vector -2.7057100087404251e+01 -4.3022301048040390e+01 7.3550097644329071e+01) (float-vector -4.3129801750183105e+01 -4.8934601247310638e+01 6.6686600446701050e+01) (float-vector -5.4402600973844528e+01 -4.9551699310541153e+01 5.7758700102567673e+01) (float-vector -6.4476996660232544e+01 -4.3020900338888168e+01 4.4562898576259613e+01) (float-vector -5.3850099444389343e+01 -3.6490198224782944e+01 5.2007101476192474e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 -6.5753698348999023e+01 -2.1015599370002747e+01) (float-vector 6.9488696753978729e+01 -6.5759703516960144e+01 1.4109000330790877e+00) (float-vector 7.4474796652793884e+01 -5.9610601514577866e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.9488696753978729e+01 -6.5759703516960144e+01 1.4109000330790877e+00) (float-vector 6.7513503134250641e+01 -6.3559398055076599e+01 2.6707200333476067e+01) (float-vector 7.5127199292182922e+01 -5.9610001742839813e+01 1.2114600278437138e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.7513503134250641e+01 -6.3559398055076599e+01 2.6707200333476067e+01) (float-vector 6.9488696753978729e+01 -6.5759703516960144e+01 1.4109000330790877e+00) (float-vector 6.6359199583530426e+01 -6.5753698348999023e+01 -2.1015599370002747e+01) (float-vector 3.7004400044679642e+01 -8.0275103449821472e+01 -1.1183599941432476e+01) (float-vector 3.1677901744842529e+01 -8.0274201929569244e+01 2.1873999387025833e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.7513503134250641e+01 -6.3559398055076599e+01 2.6707200333476067e+01) (float-vector 6.4126297831535339e+01 -6.0734100639820099e+01 3.9661299437284470e+01) (float-vector 7.2120100259780884e+01 -5.4978098720312119e+01 3.0671700835227966e+01) (float-vector 7.5127199292182922e+01 -5.9610001742839813e+01 1.2114600278437138e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.4126297831535339e+01 -6.0734100639820099e+01 3.9661299437284470e+01) (float-vector 6.7513503134250641e+01 -6.3559398055076599e+01 2.6707200333476067e+01) (float-vector 3.1677901744842529e+01 -8.0274201929569244e+01 2.1873999387025833e+01) (float-vector 4.3375499546527863e+01 -6.5742902457714081e+01 5.4680000990629196e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3375499546527863e+01 -3.2257098704576492e+01 5.4680000990629196e+01) (float-vector -1.5174100175499916e+01 -3.2350499182939529e+01 6.8473696708679199e+01) (float-vector -2.7057100087404251e+01 -4.3022301048040390e+01 7.3550097644329071e+01) (float-vector -4.2892999947071075e+01 -3.7266198545694351e+01 6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.4562898576259613e+01 -4.3020900338888168e+01 6.4476996660232544e+01) (float-vector 3.0671700835227966e+01 -4.3021898716688156e+01 7.2120100259780884e+01) (float-vector 2.1015599370002747e+01 -3.2246299088001251e+01 6.6359199583530426e+01) (float-vector 3.6946401000022888e+01 -3.2240901142358780e+01 5.8903798460960388e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.6946401000022888e+01 -3.2240901142358780e+01 5.8903798460960388e+01) (float-vector 5.9105001389980316e+01 -3.2233700156211853e+01 3.6562200635671616e+01) (float-vector 6.2013100832700729e+01 -3.7266198545694351e+01 4.2892999947071075e+01) (float-vector 4.4562898576259613e+01 -4.3020900338888168e+01 6.4476996660232544e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.2114600278437138e+01 -3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector -2.8930399566888809e+01 -4.9059398472309113e+01 -7.3951698839664459e+01) (float-vector 3.4459200105629861e-01 -4.9045100808143616e+01 -7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3129801750183105e+01 -4.9065399914979935e+01 -6.6686600446701050e+01) (float-vector -2.8930399566888809e+01 -4.9059398472309113e+01 -7.3951698839664459e+01) (float-vector -1.2114600278437138e+01 -3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector -3.9661299437284470e+01 -3.7265900522470474e+01 -6.4126297831535339e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.8930399566888809e+01 -4.9059398472309113e+01 -7.3951698839664459e+01) (float-vector -2.9782500118017197e+01 -5.9613000601530075e+01 -7.0040397346019745e+01) (float-vector -1.5645200386643410e+01 -5.9610601514577866e+01 -7.4474796652793884e+01) (float-vector 3.4459200105629861e-01 -4.9045100808143616e+01 -7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.3850099444389343e+01 -6.1509799212217331e+01 -5.2007101476192474e+01) (float-vector -4.1918899863958359e+01 -6.5744303166866302e+01 -5.5662799626588821e+01) (float-vector -2.9782500118017197e+01 -5.9613000601530075e+01 -7.0040397346019745e+01) (float-vector -2.8930399566888809e+01 -4.9059398472309113e+01 -7.3951698839664459e+01) (float-vector -4.3129801750183105e+01 -4.9065399914979935e+01 -6.6686600446701050e+01) (float-vector -5.5839899927377701e+01 -4.9067698419094086e+01 -5.6477800011634827e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.6481499224901199e+01 -3.2248001545667648e+01 4.0725000202655792e+01) (float-vector -7.1428798139095306e+01 -3.8387499749660492e+01 2.6272999122738838e+01) (float-vector -6.9488696753978729e+01 -3.2240301370620728e+01 1.4109100447967649e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.1428798139095306e+01 -3.8387499749660492e+01 2.6272999122738838e+01) (float-vector -6.4476996660232544e+01 -4.3020900338888168e+01 4.4562898576259613e+01) (float-vector -7.3951698839664459e+01 -4.9059398472309113e+01 2.8930399566888809e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.1428798139095306e+01 -3.8387499749660492e+01 2.6272999122738838e+01) (float-vector -5.6481499224901199e+01 -3.2248001545667648e+01 4.0725000202655792e+01) (float-vector -5.3850099444389343e+01 -3.6490198224782944e+01 5.2007101476192474e+01) (float-vector -6.4476996660232544e+01 -4.3020900338888168e+01 4.4562898576259613e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -6.9488696753978729e+01 -3.2240301370620728e+01 1.4109100447967649e+00) (float-vector -7.1428798139095306e+01 -3.8387499749660492e+01 2.6272999122738838e+01) (float-vector -7.3951698839664459e+01 -4.9059398472309113e+01 2.8930399566888809e+01) (float-vector -7.9383201897144318e+01 -4.9045100808143616e+01 -3.4461999894119799e-01) (float-vector -7.4474796652793884e+01 -3.8389399647712708e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.6820500642061234e+01 -6.5761797130107880e+01 -4.0331300348043442e+01) (float-vector 5.6843299418687820e+01 -5.4978400468826294e+01 -5.3966101258993149e+01) (float-vector 4.3921299278736115e+01 -6.5758101642131805e+01 -5.3944598883390427e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 -6.5753698348999023e+01 -2.1015599370002747e+01) (float-vector 5.6820500642061234e+01 -6.5761797130107880e+01 -4.0331300348043442e+01) (float-vector 4.3921299278736115e+01 -6.5758101642131805e+01 -5.3944598883390427e+01) (float-vector 2.3136500269174576e+01 -8.0274298787117004e+01 -3.0678000301122665e+01) (float-vector 3.7004400044679642e+01 -8.0275103449821472e+01 -1.1183599941432476e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.3644801974296570e+01 -4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector 6.6202603280544281e+01 -4.8934098333120346e+01 -4.3869800865650177e+01) (float-vector 5.6843299418687820e+01 -5.4978400468826294e+01 -5.3966101258993149e+01) (float-vector 5.6820500642061234e+01 -6.5761797130107880e+01 -4.0331300348043442e+01) (float-vector 6.6359199583530426e+01 -6.5753698348999023e+01 -2.1015599370002747e+01) (float-vector 7.4474796652793884e+01 -5.9610601514577866e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.4203500002622604e+01 -4.8949200659990311e+01 7.8114800155162811e+01) (float-vector -2.7057100087404251e+01 -4.3022301048040390e+01 7.3550097644329071e+01) (float-vector -1.5174100175499916e+01 -3.2350499182939529e+01 6.8473696708679199e+01) (float-vector 5.1130601204931736e+00 -3.4403301775455475e+01 7.2644703090190887e+01) (float-vector 1.7856500344350934e+00 -4.3026499450206757e+01 7.8329898416996002e+01) (float-vector 3.4459200105629861e-01 -4.8954900354146957e+01 7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.1130601204931736e+00 -3.4403301775455475e+01 7.2644703090190887e+01) (float-vector 2.1015599370002747e+01 -3.2246299088001251e+01 6.6359199583530426e+01) (float-vector 3.0671700835227966e+01 -4.3021898716688156e+01 7.2120100259780884e+01) (float-vector 1.7856500344350934e+00 -4.3026499450206757e+01 7.8329898416996002e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.9105001389980316e+01 -3.2233700156211853e+01 3.6562200635671616e+01) (float-vector 3.6946401000022888e+01 -3.2240901142358780e+01 5.8903798460960388e+01) (float-vector 2.1015599370002747e+01 -3.2246299088001251e+01 6.6359199583530426e+01) (float-vector 5.1130601204931736e+00 -3.4403301775455475e+01 7.2644703090190887e+01) (float-vector -1.5174100175499916e+01 -3.2350499182939529e+01 6.8473696708679199e+01) (float-vector -4.3375499546527863e+01 -3.2257098704576492e+01 5.4680000990629196e+01) (float-vector 2.7445200830698013e+00 -2.9418099671602249e+01 -1.2800700031220913e+01)))))
              ))
             )
      (setq geom (instance collada-body :init :replace-obj qhull :name "br_caster_l_wheel_link_geom0"))
      (when glv
        (setq (geom . gl::aglvertices) glv)
        (send geom :assoc glv))
      geom))
  (:_make_instance_br_caster_r_wheel_link_geom0 ()
    (let (geom glv qhull
          (local-cds (make-coords :pos (float-vector 0.0000000000000000e+00 -4.9000000000000000e+01 0.0000000000000000e+00))))
      (setq glv
       (instance gl::glvertices :init
                 (list ;; mesh list
                  (list ;; mesh description
                   (list :type :triangles)
                   (list :material (list
                    (list :ambient (float-vector 0.000100 0.000100 0.000100 1.000000))
                    (list :diffuse (float-vector 0.000000 0.000000 0.000000 1.000000))))
                   (list :indices #i( 0 1 2 0 4 1 2 28 0 30 4 0 28 30 0 21 22 2 22 28 2 2 1 21 28 29 30 22 29 28 30 29 31 30 31 4 404 29 407 408 407 29 31 29 404 22 408 29 20 22 21 22 20 408 18 20 21 17 20 18 412 20 17 408 20 412 17 18 19 21 486 18 18 486 19 17 19 16 412 17 16 412 413 414 412 414 408 412 16 413 413 415 414 409 415 413 413 15 409 413 16 481 413 481 15 14 15 7 409 15 14 481 7 15 481 16 7 6 7 8 8 7 11 14 7 6 16 11 7 14 6 10 409 14 10 9 10 6 6 487 9 8 489 6 6 489 487 8 11 13 8 488 489 13 488 8 12 13 11 11 16 12 13 12 19 19 488 13 486 488 19 486 499 488 488 499 497 488 497 489 16 19 12 489 497 494 489 494 487 497 459 494 499 459 497 486 498 499 499 474 459 499 498 474 493 498 486 474 498 475 498 493 475 40 474 475 475 478 471 40 475 471 475 493 478 37 39 40 41 37 40 41 40 471 39 474 40 41 471 378 471 478 378 478 476 378 478 493 476 69 378 379 37 41 378 37 378 69 378 476 379 476 477 379 476 493 477 69 379 376 379 477 376 376 477 473 493 473 477 492 493 3 1 493 486 3 493 1 492 473 493 491 496 492 491 492 3 492 496 473 3 4 5 4 3 1 491 3 5 21 1 486 4 31 5 482 5 483 33 483 5 33 5 31 482 491 5 33 31 34 31 404 34 34 35 33 35 483 33 36 482 483 35 36 483 34 36 35 34 26 36 406 34 404 27 34 406 26 34 27 404 405 406 407 405 404 27 406 410 434 406 405 410 406 434 434 405 423 407 423 405 407 408 423 423 408 417 440 408 414 417 408 440 416 417 418 417 427 418 417 416 423 417 440 427 414 439 440 427 440 439 451 427 439 398 427 402 427 398 418 451 402 427 419 416 418 418 398 419 423 416 419 419 422 423 401 419 398 419 401 400 400 422 419 422 421 423 421 434 423 420 421 422 425 421 420 425 434 421 420 424 425 424 434 425 426 424 420 426 434 424 420 381 426 422 396 420 381 420 382 382 420 396 434 426 435 426 381 435 380 381 382 260 392 381 381 380 260 392 435 381 393 382 396 380 382 393 258 380 257 380 393 257 260 380 258 235 259 260 260 258 235 259 392 260 392 259 391 430 392 391 430 435 392 231 259 235 229 262 259 229 259 231 259 262 391 231 232 229 235 236 231 231 236 232 232 237 229 232 236 177 183 232 177 183 237 232 235 234 236 236 234 181 177 236 181 177 178 167 168 177 167 177 181 178 168 183 177 179 181 180 178 181 179 181 234 180 166 178 164 164 178 179 167 178 166 167 161 162 166 161 167 162 168 167 161 166 160 160 166 164 160 164 159 164 165 159 164 179 165 180 165 179 358 165 363 159 165 358 363 165 365 180 365 165 118 159 117 160 159 118 117 159 358 161 160 119 119 160 118 105 118 117 104 119 118 104 118 105 117 116 105 116 117 329 329 117 358 104 105 98 105 116 95 98 105 95 97 103 104 98 97 104 103 119 104 92 97 98 92 98 95 95 81 92 95 316 81 316 95 317 95 116 317 92 93 94 81 93 92 94 97 92 99 97 94 97 99 103 93 96 94 96 99 94 93 81 72 61 93 72 61 96 93 101 99 96 59 96 61 59 101 96 100 99 101 100 106 99 99 106 103 101 102 100 101 108 102 59 108 101 100 109 106 102 109 100 121 120 106 106 120 103 109 121 106 120 119 103 120 162 161 120 161 119 121 162 120 109 122 121 163 162 121 122 163 121 102 113 109 113 122 109 123 122 113 122 169 163 123 169 122 163 168 162 163 169 174 174 168 163 170 169 123 170 175 169 169 175 174 124 123 114 114 123 113 124 170 123 124 171 170 176 170 171 175 170 176 175 182 174 176 185 175 185 182 175 171 173 176 173 184 176 176 184 185 152 171 125 125 171 124 152 173 171 172 173 152 173 172 184 172 201 184 201 204 184 184 204 210 184 210 185 186 172 152 186 190 172 190 201 172 148 152 125 148 186 152 187 186 149 149 186 148 187 190 186 190 187 191 191 201 190 150 188 187 150 187 149 188 191 187 149 148 136 150 149 137 137 149 136 131 148 125 136 148 131 89 136 131 132 137 136 132 136 89 133 137 132 133 138 137 138 150 137 130 132 89 133 132 134 134 132 130 89 90 91 91 130 89 90 89 131 90 110 91 90 115 110 131 115 90 112 91 107 107 91 110 91 129 130 91 112 129 110 111 107 110 114 111 110 115 114 125 124 115 115 124 114 131 125 115 111 114 113 107 111 102 111 113 102 107 102 108 108 112 107 58 108 59 58 112 108 58 59 57 59 60 57 59 61 60 60 61 62 62 63 60 63 57 60 61 72 62 63 62 64 62 72 64 72 65 64 72 81 82 72 82 65 64 65 66 66 63 64 66 65 70 65 80 70 65 82 80 82 314 80 81 316 82 82 316 314 80 79 70 305 306 80 314 305 80 80 306 79 317 318 314 317 314 316 314 318 305 305 319 315 318 319 305 305 315 306 306 309 79 306 313 309 306 315 313 315 327 325 319 327 315 315 325 313 320 319 318 328 327 319 320 328 319 317 320 318 317 116 320 329 328 320 116 329 320 360 359 328 328 359 327 329 360 328 327 354 325 327 359 354 325 324 313 325 354 324 354 353 324 354 356 353 354 359 361 361 356 354 360 362 359 359 362 361 362 364 361 361 272 356 361 364 272 356 357 353 356 274 357 356 272 274 269 272 268 272 273 268 274 272 269 272 364 273 362 365 364 364 365 273 268 273 234 234 273 180 273 365 180 264 268 234 264 269 268 233 234 235 264 234 233 256 264 233 256 253 264 253 269 264 256 233 257 235 258 233 258 257 233 253 256 263 257 393 256 256 395 263 393 395 256 254 253 263 263 394 254 263 395 394 393 396 395 395 399 400 395 400 394 396 399 395 254 394 255 400 401 394 394 401 255 250 253 254 255 250 254 250 255 251 255 248 251 255 398 248 255 401 398 248 250 251 247 246 248 248 246 250 398 402 248 248 402 247 245 246 247 402 403 247 247 403 245 448 403 402 402 451 448 245 403 397 403 448 397 244 242 245 245 242 246 245 397 244 243 242 244 244 397 243 243 397 386 397 450 386 448 447 397 450 397 447 242 243 240 386 240 243 386 384 387 387 240 386 384 386 449 449 386 450 441 449 450 450 447 441 443 447 448 441 447 442 442 447 443 414 441 442 438 441 414 441 438 449 384 449 454 449 438 454 414 415 438 415 445 438 454 438 445 443 439 414 414 442 443 439 443 448 448 451 439 444 445 415 444 446 445 454 445 452 446 452 445 384 454 452 385 384 452 452 453 385 452 446 453 453 446 444 385 453 389 455 389 453 453 444 455 383 384 385 385 389 238 385 238 383 383 388 384 384 388 387 249 388 383 383 238 249 228 238 239 226 249 238 226 238 228 238 389 239 226 241 249 241 388 249 387 388 241 240 387 241 240 241 225 225 241 226 225 226 227 217 227 226 228 218 226 217 226 218 227 212 225 211 225 212 242 240 225 225 211 242 212 227 217 208 211 212 205 212 217 208 212 205 211 209 213 209 211 208 213 221 211 211 221 242 242 221 246 220 221 213 220 222 221 222 246 221 213 347 346 213 346 220 209 347 213 220 215 222 220 346 336 337 220 336 220 337 215 214 222 215 214 246 222 214 215 216 348 215 343 343 215 337 215 348 216 333 337 332 332 337 336 343 337 333 333 338 343 338 344 343 344 348 343 216 348 344 339 344 338 344 339 345 345 216 344 301 338 333 339 338 302 302 338 301 333 332 300 301 333 300 291 301 300 302 301 294 294 301 291 303 302 295 295 302 294 303 339 302 285 294 291 293 295 294 293 294 285 283 291 289 285 291 283 291 300 289 284 285 283 290 285 75 284 75 285 290 293 285 292 293 290 292 295 293 83 277 290 290 277 292 290 75 83 74 75 76 75 74 83 75 284 76 283 282 284 284 282 76 88 76 87 76 88 74 87 76 278 76 282 278 282 280 278 280 282 286 283 289 282 282 289 286 278 279 87 278 280 279 279 280 281 280 286 287 281 280 287 299 298 286 289 299 286 286 298 287 300 299 289 299 332 331 299 331 298 300 332 299 287 298 297 331 330 298 298 330 297 287 288 281 287 297 288 288 297 158 297 196 158 330 196 297 330 334 196 331 335 330 330 335 334 336 331 332 335 331 336 335 346 334 336 346 335 196 334 199 334 347 199 334 346 347 193 158 196 196 199 193 193 199 200 200 199 207 199 209 207 209 199 347 157 158 193 157 193 195 193 200 195 195 200 198 200 207 198 198 207 206 207 208 206 207 209 208 195 198 194 194 198 197 198 206 197 195 194 156 157 195 156 154 194 189 156 194 154 189 194 197 197 192 189 205 202 197 197 202 192 197 206 205 208 205 206 205 217 202 191 202 203 192 202 191 202 217 203 189 192 188 188 192 191 189 188 151 154 189 151 151 188 150 151 150 138 154 151 138 127 138 133 127 139 138 139 154 138 126 127 128 127 133 135 126 139 127 127 135 128 134 135 133 130 135 134 135 366 128 130 366 135 73 366 130 129 73 130 128 366 367 366 53 367 370 53 366 73 370 366 367 86 143 128 367 143 53 47 367 86 367 47 140 143 142 142 143 85 140 128 143 143 86 85 140 126 128 144 145 140 144 140 142 140 145 126 141 142 85 142 141 144 85 86 87 141 85 279 87 279 85 141 153 144 279 281 141 288 153 141 281 288 141 144 147 145 144 153 147 147 146 145 145 146 126 157 156 147 153 157 147 147 156 146 153 158 157 158 153 288 126 146 139 156 155 146 146 155 139 155 156 154 139 155 154 87 86 88 86 369 88 47 369 86 369 368 88 88 368 74 369 43 368 43 369 47 46 47 48 46 43 47 48 47 52 52 47 53 45 43 46 46 461 45 48 461 46 44 43 45 45 458 44 45 461 458 458 461 456 456 461 48 456 457 458 44 458 472 458 457 472 42 43 44 44 472 42 472 56 42 472 457 480 472 480 56 456 459 457 457 459 480 459 456 48 48 460 459 459 460 470 470 494 459 459 474 480 56 480 479 474 479 480 39 479 474 56 479 39 37 38 39 39 38 56 68 37 69 38 37 84 68 84 37 67 68 69 67 71 68 71 84 68 70 69 66 67 69 70 69 376 66 67 77 71 70 79 67 67 79 77 71 77 78 78 84 71 83 84 78 78 77 277 78 277 83 83 74 84 74 38 84 74 368 38 56 38 42 38 43 42 43 38 368 275 276 277 276 292 277 277 77 275 77 308 275 275 311 307 308 311 275 276 275 307 276 296 292 307 296 276 292 296 295 304 303 296 296 303 295 307 304 296 307 321 304 311 321 307 321 326 304 326 340 304 304 340 303 303 340 339 345 339 340 326 342 340 340 342 345 341 342 326 321 351 326 351 341 326 322 321 311 322 351 321 352 351 322 352 355 351 351 355 341 342 341 349 355 350 341 341 350 349 342 349 345 345 349 216 271 349 350 216 349 223 223 349 271 357 350 355 350 357 271 355 352 353 357 355 353 271 357 274 224 271 270 271 274 270 224 223 271 223 224 214 223 214 216 224 267 214 224 270 265 224 265 267 265 270 266 266 270 269 270 274 269 265 266 253 253 250 265 267 265 250 246 267 250 214 267 246 266 269 253 323 353 352 324 353 323 323 322 312 324 323 312 323 352 322 313 324 312 308 312 311 309 312 308 309 313 312 312 322 311 309 308 310 310 308 77 310 79 309 79 310 77 66 375 63 66 376 377 377 375 66 63 375 374 375 466 464 374 375 464 377 466 375 63 374 373 63 373 57 374 464 465 465 373 374 464 496 465 464 466 496 377 473 466 496 466 473 376 473 377 490 496 491 495 496 490 496 495 465 467 373 465 465 495 467 494 495 490 495 494 467 468 373 467 467 463 372 467 372 468 467 494 470 467 470 463 487 494 490 9 487 23 23 487 490 23 10 9 23 24 10 32 23 485 24 23 32 23 490 485 409 10 24 32 27 24 24 27 409 27 32 25 485 25 32 485 484 25 485 490 484 484 490 491 26 484 482 25 484 26 482 484 491 25 26 27 409 27 410 409 410 411 409 411 415 428 410 434 428 411 410 437 411 436 436 411 428 411 444 415 411 437 444 436 432 437 437 455 444 455 437 432 436 433 432 433 436 428 431 432 433 431 433 428 455 432 389 391 390 432 389 432 390 431 391 432 431 428 430 431 430 391 390 391 261 391 262 261 389 390 252 261 252 390 239 389 252 239 252 228 228 252 261 228 261 229 229 261 262 228 229 230 219 218 228 230 219 228 229 237 230 237 219 230 204 219 210 204 218 219 210 219 237 203 217 218 203 218 204 203 204 201 203 201 191 210 237 185 185 237 183 182 185 183 182 183 174 174 183 168 428 429 430 430 429 435 428 434 429 429 434 435 36 26 482 462 372 463 469 462 463 463 470 469 51 462 469 50 462 51 50 372 462 371 372 49 372 50 49 468 372 371 49 50 51 54 55 51 51 55 49 469 54 51 470 54 469 460 54 470 52 53 54 54 53 55 460 52 54 55 58 49 55 73 58 370 73 55 55 53 370 57 49 58 73 112 58 129 112 73 57 371 49 57 373 371 371 373 468 48 52 460 399 422 400 422 399 396 363 365 362 358 363 360 360 363 362 329 358 360))
                   (list :vertices (let ((mat (make-matrix 500 3))) (fvector-replace (array-entity mat) #f(5.1378703117370605e+00 6.8265296936035156e+01 -9.3289899826049805e+00 2.7445201873779297e+00 6.8581901550292969e+01 -1.2800700187683105e+01 1.0573199987411499e+00 6.8359207153320312e+01 -1.0600199699401855e+01 1.0544799804687500e+01 6.8569099426269531e+01 -8.4442996978759766e+00 8.2298793792724609e+00 6.8419601440429688e+01 -6.8257398605346680e+00 1.0452800750732422e+01 6.8323402404785156e+01 -2.3365499973297119e+00 -6.6212201118469238e+00 6.8392799377441406e+01 8.3633699417114258e+00 -1.0304100036621094e+01 1.7535499572753906e+01 4.2757096290588379e+00 -9.9000797271728516e+00 6.8434997558593750e+01 4.3990101814270020e+00 -3.0437600612640381e+00 6.8367401123046875e+01 1.0238399505615234e+01 -3.0640001296997070e+00 1.7108699798583984e+01 1.0639900207519531e+01 -1.0523200035095215e+01 6.8192199707031250e+01 2.0460700988769531e+00 -1.0421499252319336e+01 6.8127601623535156e+01 -1.9288499355316162e+00 -1.1160599708557129e+01 6.8441001892089844e+01 -8.0958700180053711e-01 -7.1614899635314941e+00 1.7107900619506836e+01 8.4554700851440430e+00 -1.0192299842834473e+01 1.7057300567626953e+01 5.5663700103759766e+00 -1.0925999641418457e+01 1.7111598968505859e+01 -2.1682801246643066e+00 -8.4008197784423828e+00 1.7088899612426758e+01 -7.2349200248718262e+00 -6.7002696990966797e+00 6.8396400451660156e+01 -8.3113307952880859e+00 -9.4348793029785156e+00 6.8405799865722656e+01 -4.9726400375366211e+00 -5.3217201232910156e+00 1.7143899917602539e+01 -9.7155799865722656e+00 -2.8588600158691406e+00 6.8322502136230469e+01 -1.0273599624633789e+01 -1.0057700872421265e+00 1.7096700668334961e+01 -1.1044600486755371e+01 1.0178999900817871e+00 6.8367797851562500e+01 1.0607999801635742e+01 1.0090099573135376e+00 1.7097700119018555e+01 1.1044500350952148e+01 7.1427397727966309e+00 1.7195999145507812e+01 8.4595899581909180e+00 9.8030099868774414e+00 1.7092800140380859e+01 5.1623497009277344e+00 7.4257197380065918e+00 1.6894800186157227e+01 1.1212299346923828e+01 3.3442101478576660e+00 1.7096099853515625e+01 -1.0557999610900879e+01 6.1998200416564941e+00 1.6903999328613281e+01 -1.1747900009155273e+01 7.2372202873229980e+00 1.7205499649047852e+01 -8.3683700561523438e+00 9.8025293350219727e+00 1.7078998565673828e+01 -5.1738500595092773e+00 4.0853300094604492e+00 1.7077999114990234e+01 1.0249599456787109e+01 1.0831099510192871e+01 1.7257900238037109e+01 -2.0039701461791992e+00 1.2268199920654297e+01 1.6871999740600586e+01 3.9475402832031250e+00 1.1011500358581543e+01 1.7335899353027344e+01 0.0000000000000000e+00 1.0836700439453125e+01 1.7178098678588867e+01 2.0019199848175049e+00 -1.1417300224304199e+01 6.6068595886230469e+01 -6.0313899993896484e+01 -3.8845100402832031e+01 6.6098693847656250e+01 -4.7875999450683594e+01 -3.0698499679565430e+01 6.4885696411132812e+01 -3.9734401702880859e+01 -1.5955299377441406e+01 6.4939201354980469e+01 -4.7729400634765625e+01 -2.3467898368835449e+00 6.4994499206542969e+01 -5.1267002105712891e+01 -4.5538898468017578e+01 6.5077301025390625e+01 -2.5041301727294922e+01 -6.0313198089599609e+01 6.6034599304199219e+01 -7.4321599006652832e+00 -4.9943901062011719e+01 6.5038505554199219e+01 -1.3358200073242188e+01 -5.1267002105712891e+01 6.4994796752929688e+01 2.3467597961425781e+00 -4.8763401031494141e+01 6.5027900695800781e+01 1.6582399368286133e+01 -6.1740497589111328e+01 6.6020698547363281e+01 1.0151400566101074e+01 -4.5477100372314453e+01 6.4954597473144531e+01 2.1893899917602539e+01 1.6372301101684570e+01 6.6058395385742188e+01 5.8962200164794922e+01 2.3468399047851562e+00 6.4992599487304688e+01 5.1267200469970703e+01 -9.9129495620727539e+00 6.4916198730468750e+01 4.9431499481201172e+01 -3.6015296936035156e+01 6.4891899108886719e+01 3.4995300292968750e+01 -4.8726200103759766e+01 6.6080505371093750e+01 3.8182498931884766e+01 -2.5745399475097656e+01 6.4941505432128906e+01 4.3290298461914062e+01 -6.4798698425292969e+00 6.6077705383300781e+01 6.1833000183105469e+01 -3.9104801177978516e+01 6.4893997192382812e+01 -3.1760398864746094e+01 3.8039699554443359e+01 6.6068901062011719e+01 4.8811397552490234e+01 2.0110498428344727e+01 6.5001693725585938e+01 6.3504100799560547e+01 4.7388999938964844e+01 6.4940200805664062e+01 4.7388999938964844e+01 5.0501701354980469e+01 6.5800300598144531e+01 3.8274200439453125e+01 6.3447898864746094e+01 6.4940101623535156e+01 2.0092599868774414e+01 6.0778099060058594e+01 6.5855598449707031e+01 1.7475801467895508e+01 6.0313198089599609e+01 6.6034599304199219e+01 7.4321599006652832e+00 6.3284599304199219e+01 6.5808799743652344e+01 -4.4547400474548340e+00 5.9817501068115234e+01 6.4940101623535156e+01 -2.9234298706054688e+01 5.5512199401855469e+01 6.6128799438476562e+01 -2.7132499694824219e+01 2.8417900085449219e+01 6.4975593566894531e+01 -6.0260898590087891e+01 4.4547300338745117e+00 6.5808898925781250e+01 -6.3284301757812500e+01 3.3109401702880859e+01 6.6098304748535156e+01 -5.2159999847412109e+01 4.6935901641845703e+01 6.5001396179199219e+01 -4.6935901641845703e+01 4.6696701049804688e+00 6.4939994812011719e+01 -6.6339698791503906e+01 6.6339698791503906e+01 6.4939994812011719e+01 -4.6691398620605469e+00 -1.2190400123596191e+01 6.4980697631835938e+01 6.5981704711914062e+01 -4.4070800781250000e+01 6.4974899291992188e+01 -4.9997600555419922e+01 -3.9661098480224609e+01 6.5756004333496094e+01 -5.7238800048828125e+01 -5.8180297851562500e+01 6.5755393981933594e+01 -3.8144996643066406e+01 1.5174099922180176e+01 6.5649505615234375e+01 -6.8473693847656250e+01 4.8838300704956055e+00 6.5753700256347656e+01 -6.9384094238281250e+01 4.1918899536132812e+01 6.5744300842285156e+01 -5.5662799835205078e+01 5.6185497283935547e+01 6.5768501281738281e+01 -4.1026100158691406e+01 6.9456398010253906e+01 6.5766296386718750e+01 -1.5821299552917480e+00 6.6359199523925781e+01 6.5753700256347656e+01 -2.1015600204467773e+01 -2.1015600204467773e+01 6.5753700256347656e+01 -6.6359199523925781e+01 -2.0110498428344727e+01 6.5001693725585938e+01 -6.3504100799560547e+01 -6.9488693237304688e+01 6.5759704589843750e+01 1.4109100103378296e+00 -6.6339698791503906e+01 6.4939994812011719e+01 -4.6691398620605469e+00 -6.6359199523925781e+01 6.5753700256347656e+01 -2.1015600204467773e+01 -5.9817501068115234e+01 6.4940101623535156e+01 -2.9234298706054688e+01 -1.5645200729370117e+01 5.9610603332519531e+01 7.4474800109863281e+01 -1.7341400384902954e+00 5.9608001708984375e+01 7.6071098327636719e+01 5.1130599975585938e+00 6.3596702575683594e+01 7.2644706726074219e+01 7.1366401672363281e+01 6.3561000823974609e+01 1.3268600463867188e+01 6.7285202026367188e+01 6.5753700256347656e+01 1.7788499832153320e+01 6.7477394104003906e+01 6.3571102142333984e+01 2.6760299682617188e+01 7.5355300903320312e+01 6.0731601715087891e+01 1.7170599699020386e+00 5.9104999542236328e+01 6.5766296386718750e+01 3.6562202453613281e+01 7.0040397644042969e+01 5.9612998962402344e+01 2.9782499313354492e+01 7.4474800109863281e+01 5.9610603332519531e+01 1.5645200729370117e+01 6.2013099670410156e+01 6.0733798980712891e+01 4.2893001556396484e+01 5.1923801422119141e+01 6.0734001159667969e+01 5.4677501678466797e+01 4.9207698822021484e+01 6.5768600463867188e+01 4.9181400299072266e+01 3.9661300659179688e+01 6.0734100341796875e+01 6.4126296997070312e+01 6.6670997619628906e+01 5.4979000091552734e+01 4.1205699920654297e+01 7.3550094604492188e+01 5.4977699279785156e+01 2.7057100296020508e+01 7.7358497619628906e+01 5.4975402832031250e+01 1.2475700378417969e+01 5.6843299865722656e+01 5.4978401184082031e+01 5.3966102600097656e+01 2.5049600601196289e+01 6.3557998657226562e+01 6.8122604370117188e+01 3.6946399688720703e+01 6.5759101867675781e+01 5.8903797149658203e+01 4.4562896728515625e+01 5.4979099273681641e+01 6.4476997375488281e+01 1.2114600181579590e+01 5.9610000610351562e+01 7.5127197265625000e+01 2.6272998809814453e+01 5.9612503051757812e+01 7.1428794860839844e+01 2.1015600204467773e+01 6.5753700256347656e+01 6.6359199523925781e+01 3.0671701431274414e+01 5.4978099822998047e+01 7.2120101928710938e+01 1.6111700057983398e+01 5.4976001739501953e+01 7.6686698913574219e+01 1.7856500148773193e+00 5.4973503112792969e+01 7.8329895019531250e+01 7.8330101013183594e+01 5.4972999572753906e+01 -1.7853500843048096e+00 7.9383201599121094e+01 4.9045101165771484e+01 -3.4461998939514160e-01 7.8114799499511719e+01 4.9050800323486328e+01 1.4203499794006348e+01 7.3951698303222656e+01 4.9059398651123047e+01 2.8930398941040039e+01 6.6686599731445312e+01 4.9065399169921875e+01 4.3129802703857422e+01 5.6477798461914062e+01 4.9067699432373047e+01 5.5839900970458984e+01 4.3869800567626953e+01 4.9065898895263672e+01 6.6202606201171875e+01 2.9704099655151367e+01 4.9060401916503906e+01 7.3644798278808594e+01 1.4941699981689453e+01 4.9052101135253906e+01 7.7977600097656250e+01 3.4459200501441956e-01 4.9045101165771484e+01 7.9383300781250000e+01 -6.4126296997070312e+01 6.0734100341796875e+01 3.9661300659179688e+01 -5.3850097656250000e+01 6.1509799957275391e+01 5.2007102966308594e+01 -5.6481498718261719e+01 6.5751998901367188e+01 4.0724998474121094e+01 -4.8838300704956055e+00 6.5753700256347656e+01 6.9384094238281250e+01 -1.5174099922180176e+01 6.5649505615234375e+01 6.8473693847656250e+01 -1.2475700378417969e+01 5.4975402832031250e+01 7.7358497619628906e+01 -2.9782499313354492e+01 5.9612998962402344e+01 7.0040397644042969e+01 -4.2893001556396484e+01 6.0733798980712891e+01 6.2013099670410156e+01 -2.8395601272583008e+01 6.3558399200439453e+01 6.6799201965332031e+01 -4.3375499725341797e+01 6.5742904663085938e+01 5.4680000305175781e+01 -2.7057100296020508e+01 5.4977699279785156e+01 7.3550094604492188e+01 -4.1205699920654297e+01 5.4979000091552734e+01 6.6670997619628906e+01 -5.3966102600097656e+01 5.4978401184082031e+01 5.6843299865722656e+01 -6.4476997375488281e+01 5.4979099273681641e+01 4.4562896728515625e+01 -6.7513504028320312e+01 6.3559398651123047e+01 2.6707201004028320e+01 -7.5355300903320312e+01 6.0731601715087891e+01 -1.7170599699020386e+00 -7.1374496459960938e+01 6.3563102722167969e+01 1.3211199760437012e+01 -6.7285202026367188e+01 6.5753700256347656e+01 1.7788499832153320e+01 -7.5127197265625000e+01 5.9610000610351562e+01 1.2114600181579590e+01 -7.1428794860839844e+01 5.9612503051757812e+01 2.6272998809814453e+01 -7.2120101928710938e+01 5.4978099822998047e+01 3.0671701431274414e+01 -7.6686698913574219e+01 5.4976001739501953e+01 1.6111700057983398e+01 -1.4203499794006348e+01 4.9050800323486328e+01 7.8114799499511719e+01 -2.8930398941040039e+01 4.9059398651123047e+01 7.3951698303222656e+01 -4.3129802703857422e+01 4.9065399169921875e+01 6.6686599731445312e+01 -5.4402599334716797e+01 4.8448303222656250e+01 5.7758701324462891e+01 -1.7856500148773193e+00 4.3026500701904297e+01 7.8329895019531250e+01 -7.8330101013183594e+01 5.4972999572753906e+01 1.7853500843048096e+00 -6.4116600036621094e+01 4.9052497863769531e+01 4.6979301452636719e+01 -6.7437301635742188e+01 5.0188701629638672e+01 4.1716197967529297e+01 -7.3951698303222656e+01 4.8940597534179688e+01 2.8930398941040039e+01 -7.8114799499511719e+01 4.8949199676513672e+01 1.4203499794006348e+01 -7.9383201599121094e+01 4.8954898834228516e+01 -3.4461998939514160e-01 7.8330101013183594e+01 4.3027000427246094e+01 1.7853500843048096e+00 7.6686698913574219e+01 4.3023998260498047e+01 1.6111700057983398e+01 7.2120101928710938e+01 4.3021900177001953e+01 3.0671701431274414e+01 6.4476997375488281e+01 4.3020900726318359e+01 4.4562896728515625e+01 5.3966102600097656e+01 4.3021598815917969e+01 5.6843299865722656e+01 7.5127197265625000e+01 3.8389999389648438e+01 1.2114600181579590e+01 7.5355300903320312e+01 3.7268402099609375e+01 -1.7170599699020386e+00 7.1428794860839844e+01 3.8387500762939453e+01 2.6272998809814453e+01 6.4126296997070312e+01 3.7265899658203125e+01 3.9661300659179688e+01 5.3850097656250000e+01 3.6490200042724609e+01 5.2007102966308594e+01 4.1205699920654297e+01 4.3020999908447266e+01 6.6670997619628906e+01 2.7057100296020508e+01 4.3022300720214844e+01 7.3550094604492188e+01 1.2475700378417969e+01 4.3024600982666016e+01 7.7358497619628906e+01 -1.2114600181579590e+01 3.8389999389648438e+01 7.5127197265625000e+01 1.7341400384902954e+00 3.8391998291015625e+01 7.6071098327636719e+01 4.2893001556396484e+01 3.7266197204589844e+01 6.2013099670410156e+01 2.9782499313354492e+01 3.8387001037597656e+01 7.0040397644042969e+01 1.5645200729370117e+01 3.8389400482177734e+01 7.4474800109863281e+01 5.6481498718261719e+01 3.2248001098632812e+01 4.0724998474121094e+01 6.7513504028320312e+01 3.4440597534179688e+01 2.6707201004028320e+01 7.1374496459960938e+01 3.4436901092529297e+01 1.3211199760437012e+01 6.9488693237304688e+01 3.2240303039550781e+01 1.4108999967575073e+00 6.7285202026367188e+01 3.2246299743652344e+01 1.7788499832153320e+01 2.8395601272583008e+01 3.4441600799560547e+01 6.6799201965332031e+01 4.3375499725341797e+01 3.2257099151611328e+01 5.4680000305175781e+01 -5.1130700111389160e+00 3.4403301239013672e+01 7.2644706726074219e+01 1.5174099922180176e+01 3.2350498199462891e+01 6.8473693847656250e+01 -1.6111700057983398e+01 4.3023998260498047e+01 7.6686698913574219e+01 -3.0671701431274414e+01 4.3021900177001953e+01 7.2120101928710938e+01 -4.4562896728515625e+01 4.3020900726318359e+01 6.4476997375488281e+01 -5.6843299865722656e+01 4.3021598815917969e+01 5.3966102600097656e+01 -2.6272998809814453e+01 3.8387500762939453e+01 7.1428794860839844e+01 -3.9661300659179688e+01 3.7265899658203125e+01 6.4126296997070312e+01 -5.1923801422119141e+01 3.7266002655029297e+01 5.4677501678466797e+01 -7.7358497619628906e+01 4.3024600982666016e+01 1.2475700378417969e+01 -6.6670997619628906e+01 4.3020999908447266e+01 4.1205699920654297e+01 -7.3550094604492188e+01 4.3022300720214844e+01 2.7057100296020508e+01 -7.8330101013183594e+01 4.3027000427246094e+01 -1.7853500843048096e+00 -6.2013099670410156e+01 3.7266197204589844e+01 4.2893001556396484e+01 -7.0040397644042969e+01 3.8387001037597656e+01 2.9782499313354492e+01 -7.5355300903320312e+01 3.7268402099609375e+01 1.7170599699020386e+00 -7.4474800109863281e+01 3.8389400482177734e+01 1.5645200729370117e+01 -2.5049600601196289e+01 3.4442001342773438e+01 6.8122604370117188e+01 -4.9207698822021484e+01 3.2231403350830078e+01 4.9181400299072266e+01 -3.6946399688720703e+01 3.2240901947021484e+01 5.8903797149658203e+01 -2.1015600204467773e+01 3.2246299743652344e+01 6.6359199523925781e+01 -5.9104999542236328e+01 3.2233699798583984e+01 3.6562202453613281e+01 -6.7477394104003906e+01 3.4428897857666016e+01 2.6760299682617188e+01 -7.1366401672363281e+01 3.4439002990722656e+01 1.3268600463867188e+01 -6.7285202026367188e+01 3.2246299743652344e+01 1.7788499832153320e+01 -6.9456398010253906e+01 3.2233699798583984e+01 -1.5821199417114258e+00 4.8838300704956055e+00 3.2246299743652344e+01 6.9384094238281250e+01 -6.5954093933105469e+01 3.2996700286865234e+01 -1.1007699966430664e+01 -6.3504100799560547e+01 3.2998302459716797e+01 2.0110498428344727e+01 -6.6359199523925781e+01 3.2246299743652344e+01 -2.1015600204467773e+01 -2.0092599868774414e+01 3.3059898376464844e+01 -6.3447898864746094e+01 -4.1918899536132812e+01 3.2255702972412109e+01 -5.5662799835205078e+01 -1.5174099922180176e+01 3.2350498199462891e+01 -6.8473693847656250e+01 -5.0577800750732422e+01 3.3059898376464844e+01 4.3333198547363281e+01 -2.5114198684692383e+01 3.2994197845458984e+01 6.1894699096679688e+01 -4.6691398620605469e+00 3.3059997558593750e+01 6.6339698791503906e+01 -5.6185497283935547e+01 3.2231498718261719e+01 -4.1026100158691406e+01 -5.9442901611328125e+01 3.3025199890136719e+01 -3.0091600418090820e+01 -4.3333198547363281e+01 3.3059898376464844e+01 -5.0577800750732422e+01 -4.8838400840759277e+00 3.2246299743652344e+01 -6.9384094238281250e+01 4.6691398620605469e+00 3.3059997558593750e+01 -6.6339698791503906e+01 -6.1515499114990234e+01 3.1915601730346680e+01 7.3676099777221680e+00 -3.9422199249267578e+01 3.1880800247192383e+01 4.7579696655273438e+01 -4.8702198028564453e+01 3.2059200286865234e+01 3.9441997528076172e+01 -8.7784500122070312e+00 3.1910301208496094e+01 6.1264701843261719e+01 3.0705200195312500e+01 3.1882099151611328e+01 5.3397201538085938e+01 1.5252799987792969e+01 3.2137401580810547e+01 6.1349498748779297e+01 5.0155899047851562e+01 3.1926799774169922e+01 3.6021900177001953e+01 4.3594100952148438e+01 3.3036796569824219e+01 5.0356700897216797e+01 6.0698596954345703e+01 3.1933300018310547e+01 -6.7463498115539551e+00 6.6711799621582031e+01 3.2996097564697266e+01 1.3542500138282776e-01 5.9121696472167969e+01 3.1899499893188477e+01 1.8429199218750000e+01 5.9817501068115234e+01 3.3059898376464844e+01 2.9234298706054688e+01 2.0092599868774414e+01 3.3059898376464844e+01 6.3447898864746094e+01 -2.4017601013183594e+01 3.3075298309326172e+01 4.4330997467041016e+01 -1.2296899795532227e+01 3.3077796936035156e+01 4.8861900329589844e+01 -4.9878101348876953e+01 3.3076202392578125e+01 6.1260700225830078e+00 -4.7621898651123047e+01 3.2973300933837891e+01 2.0646100997924805e+01 -5.8962200164794922e+01 3.1941600799560547e+01 -1.6372301101684570e+01 -4.9968898773193359e+01 3.3071201324462891e+01 -5.5101404190063477e+00 -4.6904499053955078e+01 3.3098499298095703e+01 -1.8820098876953125e+01 -4.1162097930908203e+01 3.3084197998046875e+01 -2.8893501281738281e+01 -4.1316501617431641e+01 3.1871698379516602e+01 -4.6076801300048828e+01 -3.1769998550415039e+01 3.3059398651123047e+01 -3.8861301422119141e+01 -1.5955600738525391e+01 3.3101100921630859e+01 -4.8028099060058594e+01 -3.6749000549316406e+01 3.2989299774169922e+01 3.6192996978759766e+01 -7.4321599006652832e+00 3.1965400695800781e+01 -6.0313198089599609e+01 -4.9870600700378418e+00 3.2961700439453125e+01 -5.1429000854492188e+01 6.1151897907257080e-01 3.3100097656250000e+01 5.0388702392578125e+01 4.0430500030517578e+01 3.1952198028564453e+01 -4.7272399902343750e+01 2.1093599319458008e+01 3.2991901397705078e+01 -4.7210800170898438e+01 5.7853302955627441e+00 3.3030902862548828e+01 -5.0313201904296875e+01 4.5625198364257812e+01 3.2923900604248047e+01 -2.5078199386596680e+01 5.2289600372314453e+01 3.2952899932861328e+01 -4.6615300178527832e+00 4.9076499938964844e+01 3.2969501495361328e+01 1.6025699615478516e+01 3.6085098266601562e+01 3.3112297058105469e+01 3.5027797698974609e+01 4.5658901214599609e+01 3.3043701171875000e+01 2.1977499008178711e+01 1.2848500251770020e+01 3.3077198028564453e+01 4.8701698303222656e+01 2.4957799911499023e+01 3.3075702667236328e+01 4.3825702667236328e+01 3.6392799377441406e+01 3.2986000061035156e+01 -3.6605201721191406e+01 5.6047599792480469e+01 3.1980998992919922e+01 -2.7524799346923828e+01 4.4547400474548340e+00 3.2191196441650391e+01 -6.3284599304199219e+01 2.7442001342773438e+01 3.2047397613525391e+01 -5.6365200042724609e+01 -1.7475801467895508e+01 3.2144401550292969e+01 -6.0778099060058594e+01 6.3447898864746094e+01 3.3059898376464844e+01 -2.0092599868774414e+01 5.0577800750732422e+01 3.3059898376464844e+01 -4.3333198547363281e+01 2.9234298706054688e+01 3.3059898376464844e+01 -5.9817501068115234e+01 2.1015600204467773e+01 3.2246299743652344e+01 -6.6359199523925781e+01 5.6820499420166016e+01 3.2238201141357422e+01 -4.0331298828125000e+01 6.6359199523925781e+01 3.2246299743652344e+01 -2.1015600204467773e+01 4.3921298980712891e+01 3.2241901397705078e+01 -5.3944599151611328e+01 1.5645200729370117e+01 5.9610603332519531e+01 -7.4474800109863281e+01 1.7341400384902954e+00 5.9608001708984375e+01 -7.6071098327636719e+01 -5.1130700111389160e+00 6.3596702575683594e+01 -7.2644706726074219e+01 -6.7477394104003906e+01 6.3571102142333984e+01 -2.6760299682617188e+01 -7.1366401672363281e+01 6.3561000823974609e+01 -1.3268600463867188e+01 -7.0040397644042969e+01 5.9612998962402344e+01 -2.9782499313354492e+01 -7.4474800109863281e+01 5.9610603332519531e+01 -1.5645200729370117e+01 -6.2013099670410156e+01 6.0733798980712891e+01 -4.2893001556396484e+01 -5.1923801422119141e+01 6.0734001159667969e+01 -5.4677501678466797e+01 -5.1424598693847656e+01 6.4527305603027344e+01 -4.9469097137451172e+01 -3.9661300659179688e+01 6.0734100341796875e+01 -6.4126296997070312e+01 -6.6670997619628906e+01 5.4979000091552734e+01 -4.1205699920654297e+01 -7.3550094604492188e+01 5.4977699279785156e+01 -2.7057100296020508e+01 -7.7358497619628906e+01 5.4975402832031250e+01 -1.2475700378417969e+01 -5.6843299865722656e+01 5.4978401184082031e+01 -5.3966102600097656e+01 -2.5049600601196289e+01 6.3557998657226562e+01 -6.8122604370117188e+01 -4.4562896728515625e+01 5.4979099273681641e+01 -6.4476997375488281e+01 -1.2114600181579590e+01 5.9610000610351562e+01 -7.5127197265625000e+01 -2.6272998809814453e+01 5.9612503051757812e+01 -7.1428794860839844e+01 -3.0671701431274414e+01 5.4978099822998047e+01 -7.2120101928710938e+01 -1.6111700057983398e+01 5.4976001739501953e+01 -7.6686698913574219e+01 -1.7856500148773193e+00 5.4973503112792969e+01 -7.8329895019531250e+01 -7.7977600097656250e+01 4.8947898864746094e+01 -1.4941699981689453e+01 -7.3644798278808594e+01 4.8939601898193359e+01 -2.9704099655151367e+01 -6.6202606201171875e+01 4.8934097290039062e+01 -4.3869800567626953e+01 -5.5839900970458984e+01 4.8932300567626953e+01 -5.6477798461914062e+01 -4.3129802703857422e+01 4.8934600830078125e+01 -6.6686599731445312e+01 -2.8930398941040039e+01 4.8940597534179688e+01 -7.3951698303222656e+01 -1.4203499794006348e+01 4.8949199676513672e+01 -7.8114799499511719e+01 3.4459200501441956e-01 4.8954898834228516e+01 -7.9383300781250000e+01 6.4126296997070312e+01 6.0734100341796875e+01 -3.9661300659179688e+01 5.3850097656250000e+01 6.1509799957275391e+01 -5.2007102966308594e+01 1.2475700378417969e+01 5.4975402832031250e+01 -7.7358497619628906e+01 2.9782499313354492e+01 5.9612998962402344e+01 -7.0040397644042969e+01 4.2893001556396484e+01 6.0733798980712891e+01 -6.2013099670410156e+01 2.8395601272583008e+01 6.3558399200439453e+01 -6.6799201965332031e+01 2.7057100296020508e+01 5.4977699279785156e+01 -7.3550094604492188e+01 4.1205699920654297e+01 5.4979000091552734e+01 -6.6670997619628906e+01 5.3966102600097656e+01 5.4978401184082031e+01 -5.6843299865722656e+01 6.7513504028320312e+01 6.3559398651123047e+01 -2.6707201004028320e+01 6.4476997375488281e+01 5.4979099273681641e+01 -4.4562896728515625e+01 7.1374496459960938e+01 6.3563102722167969e+01 -1.3211199760437012e+01 7.5127197265625000e+01 5.9610000610351562e+01 -1.2114600181579590e+01 7.1428794860839844e+01 5.9612503051757812e+01 -2.6272998809814453e+01 7.2120101928710938e+01 5.4978099822998047e+01 -3.0671701431274414e+01 7.6686698913574219e+01 5.4976001739501953e+01 -1.6111700057983398e+01 1.4941699981689453e+01 4.8947898864746094e+01 -7.7977600097656250e+01 2.9704099655151367e+01 4.8939601898193359e+01 -7.3644798278808594e+01 4.1731800079345703e+01 4.8429000854492188e+01 -6.7475105285644531e+01 4.9999198913574219e+01 4.9000503540039062e+01 -6.1567001342773438e+01 5.7531902313232422e+01 4.9579898834228516e+01 -5.4633300781250000e+01 1.7856500148773193e+00 4.3026500701904297e+01 -7.8329895019531250e+01 6.6202606201171875e+01 4.9065898895263672e+01 -4.3869800567626953e+01 7.3644798278808594e+01 4.9060401916503906e+01 -2.9704099655151367e+01 7.7977600097656250e+01 4.9052101135253906e+01 -1.4941699981689453e+01 -7.6686698913574219e+01 4.3023998260498047e+01 -1.6111700057983398e+01 -7.2120101928710938e+01 4.3021900177001953e+01 -3.0671701431274414e+01 -6.4476997375488281e+01 4.3020900726318359e+01 -4.4562896728515625e+01 -5.3966102600097656e+01 4.3021598815917969e+01 -5.6843299865722656e+01 -7.5127197265625000e+01 3.8389999389648438e+01 -1.2114600181579590e+01 -7.1428794860839844e+01 3.8387500762939453e+01 -2.6272998809814453e+01 -6.4126296997070312e+01 3.7265899658203125e+01 -3.9661300659179688e+01 -5.3850097656250000e+01 3.6490200042724609e+01 -5.2007102966308594e+01 -4.1205699920654297e+01 4.3020999908447266e+01 -6.6670997619628906e+01 -2.7057100296020508e+01 4.3022300720214844e+01 -7.3550094604492188e+01 -1.2475700378417969e+01 4.3024600982666016e+01 -7.7358497619628906e+01 1.2114600181579590e+01 3.8389999389648438e+01 -7.5127197265625000e+01 -1.7341400384902954e+00 3.8391998291015625e+01 -7.6071098327636719e+01 -4.2893001556396484e+01 3.7266197204589844e+01 -6.2013099670410156e+01 -2.9782499313354492e+01 3.8387001037597656e+01 -7.0040397644042969e+01 -1.5645200729370117e+01 3.8389400482177734e+01 -7.4474800109863281e+01 -6.7513504028320312e+01 3.4440597534179688e+01 -2.6707201004028320e+01 -7.1374496459960938e+01 3.4436901092529297e+01 -1.3211199760437012e+01 -2.8395601272583008e+01 3.4441600799560547e+01 -6.6799201965332031e+01 5.1130599975585938e+00 3.4403301239013672e+01 -7.2644706726074219e+01 2.5049600601196289e+01 3.4442001342773438e+01 -6.8122604370117188e+01 1.6111700057983398e+01 4.3023998260498047e+01 -7.6686698913574219e+01 3.0671701431274414e+01 4.3021900177001953e+01 -7.2120101928710938e+01 4.2744701385498047e+01 4.1740497589111328e+01 -6.5250297546386719e+01 5.6843299865722656e+01 4.3021598815917969e+01 -5.3966102600097656e+01 2.6272998809814453e+01 3.8387500762939453e+01 -7.1428794860839844e+01 5.1923801422119141e+01 3.7266002655029297e+01 -5.4677501678466797e+01 3.8678096771240234e+01 3.5286399841308594e+01 -6.2656597137451172e+01 7.7358497619628906e+01 4.3024600982666016e+01 -1.2475700378417969e+01 6.6670997619628906e+01 4.3020999908447266e+01 -4.1205699920654297e+01 7.3550094604492188e+01 4.3022300720214844e+01 -2.7057100296020508e+01 6.2013099670410156e+01 3.7266197204589844e+01 -4.2893001556396484e+01 7.0040397644042969e+01 3.8387001037597656e+01 -2.9782499313354492e+01 7.4474800109863281e+01 3.8389400482177734e+01 -1.5645200729370117e+01 6.7477394104003906e+01 3.4428897857666016e+01 -2.6760299682617188e+01 7.1366401672363281e+01 3.4439002990722656e+01 -1.3268600463867188e+01 -4.6283000946044922e+01 6.4940299987792969e+01 4.8698802947998047e+01 -6.3504100799560547e+01 6.5001693725585938e+01 2.0110498428344727e+01 -5.2329101562500000e+01 6.5869697570800781e+01 -3.4909000396728516e+01 -6.1349498748779297e+01 6.5862602233886719e+01 -1.5252799987792969e+01 -3.8747798919677734e+01 6.5979896545410156e+01 4.9141799926757812e+01 2.8352600097656250e+01 6.5010398864746094e+01 4.3039199829101562e+01 1.5969698905944824e+01 6.4944404602050781e+01 4.7725498199462891e+01 3.9991699218750000e+01 6.4902297973632812e+01 3.0614299774169922e+01 4.8633197784423828e+01 6.4915199279785156e+01 1.3720000267028809e+01 5.0044700622558594e+01 6.4888000488281250e+01 -5.6227302551269531e+00 3.5953800201416016e+01 6.4902297973632812e+01 -3.5078903198242188e+01 4.5476398468017578e+01 6.4954803466796875e+01 -2.1894300460815430e+01 9.9145097732543945e+00 6.4916198730468750e+01 -4.9431201934814453e+01 2.5745399475097656e+01 6.4941505432128906e+01 -4.3290298461914062e+01 4.9954399108886719e+01 3.2965801239013672e+01 5.4540300369262695e+00 4.8967998504638672e+01 3.0462301254272461e+01 1.3350299835205078e+01 5.0034500122070312e+01 3.0460399627685547e+01 -4.1453199386596680e+00 -3.3270900726318359e+01 3.2966499328613281e+01 3.7523998260498047e+01 -4.3557899475097656e+01 3.0462099075317383e+01 2.6049699783325195e+01 -2.8130199432373047e+01 3.0460399627685547e+01 4.1621601104736328e+01 -4.9887100219726562e+01 3.0460599899291992e+01 6.8354101181030273e+00 -4.7150398254394531e+01 3.2968799591064453e+01 1.8047500610351562e+01 -4.0905799865722656e+01 3.2965702056884766e+01 2.9103500366210938e+01 -9.2679700851440430e+00 3.0461000442504883e+01 4.9685398101806641e+01 9.3136892318725586e+00 3.0461299896240234e+01 4.9535301208496094e+01 2.6869998931884766e+01 3.0461400985717773e+01 4.2637798309326172e+01 4.0471401214599609e+01 3.0460399627685547e+01 2.9807500839233398e+01 4.8870899200439453e+01 3.2967102050781250e+01 -1.3342700004577637e+01 2.4033800125122070e+01 3.2967998504638672e+01 -4.4287799835205078e+01 3.8291000366210938e+01 3.2966098785400391e+01 -3.2910102844238281e+01 4.7313400268554688e+01 3.0464601516723633e+01 -1.8334699630737305e+01 -4.8967998504638672e+01 3.0462301254272461e+01 -1.3350299835205078e+01 -6.9415998458862305e+00 3.0460599899291992e+01 -4.9904800415039062e+01 3.7271400451660156e+01 3.0461599349975586e+01 -3.3985900878906250e+01 2.5166799545288086e+01 3.0463001251220703e+01 -4.3544601440429688e+01 1.0624900817871094e+01 3.0461599349975586e+01 -4.9357997894287109e+01 -2.6072299957275391e+01 3.0462200164794922e+01 -4.3274299621582031e+01 -4.0471401214599609e+01 3.0460399627685547e+01 -2.9807500839233398e+01 1.2806200027465820e+01 1.6926700592041016e+01 -3.8097999095916748e+00 1.3205300331115723e+01 1.7732500076293945e+01 -5.5868902206420898e+00 1.3861199378967285e+01 1.7730800628662109e+01 4.1422801017761230e+00 6.8685703277587891e+00 1.7730800628662109e+01 -1.2765500068664551e+01 -3.6473600864410400e+00 1.7569198608398438e+01 -1.3761699676513672e+01 -5.0008997917175293e+00 1.6919498443603516e+01 1.2562399864196777e+01 6.8692898750305176e+00 1.7731899261474609e+01 1.2766799926757812e+01 -2.6745600700378418e+00 1.7732898712158203e+01 1.4119600296020508e+01 -1.0887900352478027e+01 1.6917900085449219e+01 -8.1607704162597656e+00 -1.2876600265502930e+01 1.6926498413085938e+01 3.7914199829101562e+00 -1.3522299766540527e+01 1.7732000350952148e+01 -5.6108503341674805e+00 -1.2266799926757812e+01 1.7731599807739258e+01 8.1145401000976562e+00 1.4918000221252441e+01 1.7724899291992188e+01 -3.5685497283935547e+01 3.7123301029205322e+00 1.7724899291992188e+01 -3.8456001281738281e+01 5.6025695800781250e+00 3.0478500366210938e+01 -3.8081703186035156e+01 1.6305999755859375e+01 3.0478500366210938e+01 -3.5007499694824219e+01 3.6341297149658203e+01 3.0478500366210938e+01 -1.3186100006103516e+01 3.0869201660156250e+01 1.7725700378417969e+01 -2.3010200500488281e+01 2.9183500289916992e+01 3.0477899551391602e+01 -2.5193401336669922e+01 2.3136499404907227e+01 1.7725700378417969e+01 -3.0677999496459961e+01 3.8549598693847656e+01 1.7724899291992188e+01 -1.6160999536514282e+00 3.7004398345947266e+01 1.7724899291992188e+01 -1.1183599472045898e+01 3.8620300292968750e+01 3.0478500366210938e+01 8.1181198358535767e-01 -4.5067396163940430e+00 3.0478500366210938e+01 -3.8375400543212891e+01 2.5930200576782227e+01 1.7724899291992188e+01 2.8557600021362305e+01 3.1677902221679688e+01 1.7725799560546875e+01 2.1873998641967773e+01 3.1033300399780273e+01 3.0476499557495117e+01 2.2732900619506836e+01 2.0160699844360352e+01 3.0476699829101562e+01 3.2750801086425781e+01 6.2813601493835449e+00 3.0478500366210938e+01 3.8171100616455078e+01 1.6532600402832031e+01 1.7724899291992188e+01 3.4899303436279297e+01 3.7707702636718750e+01 1.7724899291992188e+01 8.4654598236083984e+00 3.6223800659179688e+01 3.0478500366210938e+01 1.2949000358581543e+01 5.2079100608825684e+00 1.7724899291992188e+01 3.8213302612304688e+01 -3.4080798625946045e+00 1.7724899291992188e+01 3.8494800567626953e+01 -3.7614700317382812e+01 1.7724899291992188e+01 9.4110794067382812e+00 -1.6054100036621094e+01 1.7724899291992188e+01 -3.5240402221679688e+01 -5.2079100608825684e+00 1.7724899291992188e+01 -3.8213302612304688e+01 -3.8329299926757812e+01 1.7724899291992188e+01 -5.8210501670837402e+00 -3.2840499877929688e+01 1.7725599288940430e+01 -1.9909101486206055e+01 -2.6819799423217773e+01 1.7725000381469727e+01 -2.7747999191284180e+01 -1.7555700302124023e+01 1.7725000381469727e+01 3.4412902832031250e+01 -3.1601600646972656e+01 1.7725799560546875e+01 2.1895799636840820e+01 -2.5230501174926758e+01 1.7725101470947266e+01 2.9101999282836914e+01 -3.3142398834228516e+01 3.0476799011230469e+01 -1.9787399291992188e+01 -2.4508100509643555e+01 3.0477401733398438e+01 -2.9667200088500977e+01 -3.8129898071289062e+01 3.0478500366210938e+01 6.3573803901672363e+00 -3.7880397796630859e+01 3.0478500366210938e+01 -7.4131999015808105e+00 -1.6590700149536133e+01 3.0478500366210938e+01 -3.4709499359130859e+01 -2.8872499465942383e+01 3.0478199005126953e+01 2.5504301071166992e+01 -1.9341501235961914e+01 3.0477001190185547e+01 3.3339103698730469e+01 -3.4695800781250000e+01 3.0478500366210938e+01 1.6600400924682617e+01 -7.6062998771667480e+00 3.0478500366210938e+01 3.7799701690673828e+01 -4.9609901428222656e+01 6.7539604187011719e+01 8.1507596969604492e+00 -4.9868400573730469e+01 6.7539604187011719e+01 -6.8321399688720703e+00 -4.9947601318359375e+01 6.5034301757812500e+01 -5.4530901908874512e+00 -4.4943298339843750e+01 6.7539604187011719e+01 2.2791400909423828e+01 -3.5167198181152344e+01 6.7539604187011719e+01 3.5853599548339844e+01 -4.9730598449707031e+01 6.5034301757812500e+01 6.7970499992370605e+00 2.9969398975372314e+00 6.5034301757812500e+01 5.0145702362060547e+01 6.9386696815490723e+00 6.7539604187011719e+01 4.9888397216796875e+01 4.8833702087402344e+01 6.7539604187011719e+01 1.3304400444030762e+01 4.0471401214599609e+01 6.7539604187011719e+01 2.9807500839233398e+01 4.9868400573730469e+01 6.7539604187011719e+01 -6.8321399688720703e+00 2.5877500534057617e+01 6.7539604187011719e+01 4.3248897552490234e+01 2.9460500717163086e+01 6.5034301757812500e+01 4.0491600036621094e+01 -1.0601699829101562e+01 6.7539604187011719e+01 4.9272800445556641e+01 -2.4852701187133789e+01 6.7539604187011719e+01 4.3484500885009766e+01 -2.9969398975372314e+00 6.5034301757812500e+01 -5.0145702362060547e+01 -4.6939998626708984e+01 6.5034301757812500e+01 -1.7957401275634766e+01 4.3438598632812500e+01 6.7539604187011719e+01 -2.5998600006103516e+01 -2.4852701187133789e+01 6.7539604187011719e+01 -4.3484500885009766e+01 -1.0601699829101562e+01 6.7539604187011719e+01 -4.9272800445556641e+01 1.7176401138305664e+01 6.7539604187011719e+01 -4.7315002441406250e+01 3.1059000015258789e+01 6.7539604187011719e+01 -3.9376998901367188e+01 2.9829699993133545e+00 6.7539604187011719e+01 -5.0146999359130859e+01 -3.5167198181152344e+01 6.7539604187011719e+01 -3.5853599548339844e+01 -4.4943298339843750e+01 6.7539604187011719e+01 -2.2791400909423828e+01 -1.1755400657653809e+01 1.6967199325561523e+01 1.1027499437332153e+00 1.0264200210571289e+01 6.8385604858398438e+01 2.9392998218536377e+00 1.0690099716186523e+01 5.6955596923828125e+01 0.0000000000000000e+00 8.1825199127197266e+00 6.8391502380371094e+01 6.8735299110412598e+00 5.0151400566101074e+00 6.8400596618652344e+01 9.4172601699829102e+00 -6.3304600715637207e+00 6.8557899475097656e+01 -1.2118599891662598e+01 -5.5505099296569824e+00 6.8545295715332031e+01 1.2124200820922852e+01 -1.3189299583435059e+01 6.8547706604003906e+01 -2.1639201641082764e+00 -1.1655500411987305e+01 6.8542694091796875e+01 6.2997603416442871e+00 6.3305301666259766e+00 6.8557899475097656e+01 1.2118599891662598e+01 1.3189299583435059e+01 6.8547706604003906e+01 2.1639201641082764e+00 1.2706499099731445e+01 6.7540802001953125e+01 -6.5114102363586426e+00 3.8211998939514160e+00 6.7540100097656250e+01 -1.4019599914550781e+01 -3.8208501338958740e+00 6.7541503906250000e+01 1.4018300056457520e+01 8.3117198944091797e+00 6.7541999816894531e+01 1.1874300003051758e+01 1.4127900123596191e+01 6.7540000915527344e+01 3.0538599491119385e+00 -1.2706499099731445e+01 6.7540802001953125e+01 6.5114398002624512e+00 -8.3115901947021484e+00 6.7541999816894531e+01 -1.1874400138854980e+01 -1.4127199172973633e+01 6.7540802001953125e+01 -3.0536701679229736e+00 )) mat)))
                  )
                 ))
      (send glv :transform local-cds)
      (send glv :calc-normals)
      (setq qhull
            ;; qhull 3000 -> 81 faces
            (instance faceset :init :faces (list
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1677901744842529e+01 1.7725799232721329e+01 2.1873999387025833e+01) (float-vector 1.6532599925994873e+01 1.7724899575114250e+01 3.4899301826953888e+01) (float-vector 1.5174100175499916e+01 3.2350499182939529e+01 6.8473696708679199e+01) (float-vector 4.3375499546527863e+01 3.2257098704576492e+01 5.4680000990629196e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.7057100087404251e+01 4.3022301048040390e+01 7.3550097644329071e+01) (float-vector 3.0671700835227966e+01 5.4978098720312119e+01 7.2120100259780884e+01) (float-vector 4.4562898576259613e+01 5.4979100823402405e+01 6.4476996660232544e+01) (float-vector 5.6477800011634827e+01 4.9067698419094086e+01 5.5839899927377701e+01) (float-vector 4.2892999947071075e+01 3.7266198545694351e+01 6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.6477800011634827e+01 4.9067698419094086e+01 5.5839899927377701e+01) (float-vector 6.6686600446701050e+01 4.9065399914979935e+01 4.3129801750183105e+01) (float-vector 6.4126297831535339e+01 3.7265900522470474e+01 3.9661299437284470e+01) (float-vector 4.3375499546527863e+01 3.2257098704576492e+01 5.4680000990629196e+01) (float-vector 4.2892999947071075e+01 3.7266198545694351e+01 6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.1731800884008408e+01 4.8429001122713089e+01 -6.7475102841854095e+01) (float-vector 2.7057100087404251e+01 5.4977700114250183e+01 -7.3550097644329071e+01) (float-vector 3.4459200105629861e-01 4.8954900354146957e+01 -7.9383298754692078e+01) (float-vector 1.2114600278437138e+01 3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector 3.0671700835227966e+01 4.3021898716688156e+01 -7.2120100259780884e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7341399798169732e+00 5.9608001261949539e+01 -7.6071098446846008e+01) (float-vector -1.2114600278437138e+01 5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector 3.4459200105629861e-01 4.8954900354146957e+01 -7.9383298754692078e+01) (float-vector 2.7057100087404251e+01 5.4977700114250183e+01 -7.3550097644329071e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.7614699453115463e+01 1.7724899575114250e+01 9.4110798090696335e+00) (float-vector -6.7285202443599701e+01 3.2246299088001251e+01 1.7788499593734741e+01) (float-vector -7.0040397346019745e+01 3.8387000560760498e+01 2.9782500118017197e+01) (float-vector -6.2013100832700729e+01 3.7266198545694351e+01 4.2892999947071075e+01) (float-vector -4.9207698553800583e+01 3.2231401652097702e+01 4.9181401729583740e+01) (float-vector -2.5230500847101212e+01 1.7725100740790367e+01 2.9101999476552010e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3129801750183105e+01 4.9065399914979935e+01 6.6686600446701050e+01) (float-vector -3.9661299437284470e+01 3.7265900522470474e+01 6.4126297831535339e+01) (float-vector -4.9207698553800583e+01 3.2231401652097702e+01 4.9181401729583740e+01) (float-vector -6.2013100832700729e+01 3.7266198545694351e+01 4.2892999947071075e+01) (float-vector -5.4402600973844528e+01 4.8448301851749420e+01 5.7758700102567673e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.9661299437284470e+01 3.7265900522470474e+01 6.4126297831535339e+01) (float-vector -4.3129801750183105e+01 4.9065399914979935e+01 6.6686600446701050e+01) (float-vector -2.7057100087404251e+01 5.4977700114250183e+01 7.3550097644329071e+01) (float-vector -1.4203500002622604e+01 4.9050800502300262e+01 7.8114800155162811e+01) (float-vector -2.6272999122738838e+01 3.8387499749660492e+01 7.1428798139095306e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.2892999947071075e+01 6.0733798891305923e+01 6.2013100832700729e+01) (float-vector -5.3850099444389343e+01 6.1509799212217331e+01 5.2007101476192474e+01) (float-vector -5.6481499224901199e+01 6.5751999616622925e+01 4.0725000202655792e+01) (float-vector -4.3375499546527863e+01 6.5742902457714081e+01 5.4680000990629196e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.6819799095392227e+01 1.7725000157952309e+01 -2.7747999876737595e+01) (float-vector -3.7614699453115463e+01 1.7724899575114250e+01 9.4110798090696335e+00) (float-vector -2.5230500847101212e+01 1.7725100740790367e+01 2.9101999476552010e+01) (float-vector -3.4080799669027328e+00 1.7724899575114250e+01 3.8494799286127090e+01) (float-vector 1.6532599925994873e+01 1.7724899575114250e+01 3.4899301826953888e+01) (float-vector 3.1677901744842529e+01 1.7725799232721329e+01 2.1873999387025833e+01) (float-vector 3.7004400044679642e+01 1.7724899575114250e+01 -1.1183599941432476e+01) (float-vector 2.3136500269174576e+01 1.7725700512528419e+01 -3.0678000301122665e+01) (float-vector -5.2079102024435997e+00 1.7724899575114250e+01 -3.8213301450014114e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.7057100087404251e+01 4.3022301048040390e+01 7.3550097644329071e+01) (float-vector 1.7341399798169732e+00 3.8391999900341034e+01 7.6071098446846008e+01) (float-vector 3.4459200105629861e-01 4.9045100808143616e+01 7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7341399798169732e+00 3.8391999900341034e+01 7.6071098446846008e+01) (float-vector 2.7057100087404251e+01 4.3022301048040390e+01 7.3550097644329071e+01) (float-vector 4.2892999947071075e+01 3.7266198545694351e+01 6.2013100832700729e+01) (float-vector 4.3375499546527863e+01 3.2257098704576492e+01 5.4680000990629196e+01) (float-vector 1.5174100175499916e+01 3.2350499182939529e+01 6.8473696708679199e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7341399798169732e+00 3.8391999900341034e+01 7.6071098446846008e+01) (float-vector 1.5174100175499916e+01 3.2350499182939529e+01 6.8473696708679199e+01) (float-vector 1.6532599925994873e+01 1.7724899575114250e+01 3.4899301826953888e+01) (float-vector -3.4080799669027328e+00 1.7724899575114250e+01 3.8494799286127090e+01) (float-vector -2.1015599370002747e+01 3.2246299088001251e+01 6.6359199583530426e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.9661299437284470e+01 3.7265900522470474e+01 6.4126297831535339e+01) (float-vector -2.6272999122738838e+01 3.8387499749660492e+01 7.1428798139095306e+01) (float-vector -2.1015599370002747e+01 3.2246299088001251e+01 6.6359199583530426e+01) (float-vector -3.4080799669027328e+00 1.7724899575114250e+01 3.8494799286127090e+01) (float-vector -2.5230500847101212e+01 1.7725100740790367e+01 2.9101999476552010e+01) (float-vector -4.9207698553800583e+01 3.2231401652097702e+01 4.9181401729583740e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.4459200105629861e-01 4.9045100808143616e+01 7.9383298754692078e+01) (float-vector 1.7341399798169732e+00 3.8391999900341034e+01 7.6071098446846008e+01) (float-vector -2.1015599370002747e+01 3.2246299088001251e+01 6.6359199583530426e+01) (float-vector -2.6272999122738838e+01 3.8387499749660492e+01 7.1428798139095306e+01) (float-vector -1.4203500002622604e+01 4.9050800502300262e+01 7.8114800155162811e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.3644801974296570e+01 4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector 7.4474796652793884e+01 3.8389399647712708e+01 -1.5645200386643410e+01) (float-vector 7.9383201897144318e+01 4.9045100808143616e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.2892999947071075e+01 6.0733798891305923e+01 -6.2013100832700729e+01) (float-vector 5.6185498833656311e+01 6.5768502652645111e+01 -4.1026100516319275e+01) (float-vector 1.5174100175499916e+01 6.5649501979351044e+01 -6.8473696708679199e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.2892999947071075e+01 6.0733798891305923e+01 -6.2013100832700729e+01) (float-vector 2.7057100087404251e+01 5.4977700114250183e+01 -7.3550097644329071e+01) (float-vector 4.1731800884008408e+01 4.8429001122713089e+01 -6.7475102841854095e+01) (float-vector 5.3966101258993149e+01 5.4978400468826294e+01 -5.6843299418687820e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.5174100175499916e+01 6.5649501979351044e+01 -6.8473696708679199e+01) (float-vector 1.7341399798169732e+00 5.9608001261949539e+01 -7.6071098446846008e+01) (float-vector 2.7057100087404251e+01 5.4977700114250183e+01 -7.3550097644329071e+01) (float-vector 4.2892999947071075e+01 6.0733798891305923e+01 -6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.4459200105629861e-01 4.9045100808143616e+01 7.9383298754692078e+01) (float-vector 1.7856500344350934e+00 5.4973501712083817e+01 7.8329898416996002e+01) (float-vector 3.0671700835227966e+01 5.4978098720312119e+01 7.2120100259780884e+01) (float-vector 2.7057100087404251e+01 4.3022301048040390e+01 7.3550097644329071e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6686600446701050e+01 4.9065399914979935e+01 4.3129801750183105e+01) (float-vector 6.2013100832700729e+01 6.0733798891305923e+01 4.2892999947071075e+01) (float-vector 7.3550097644329071e+01 5.4977700114250183e+01 2.7057100087404251e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.2013100832700729e+01 6.0733798891305923e+01 4.2892999947071075e+01) (float-vector 5.9105001389980316e+01 6.5766297280788422e+01 3.6562200635671616e+01) (float-vector 7.1366399526596069e+01 6.3560999929904938e+01 1.3268600217998028e+01) (float-vector 7.3550097644329071e+01 5.4977700114250183e+01 2.7057100087404251e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.2013100832700729e+01 6.0733798891305923e+01 4.2892999947071075e+01) (float-vector 6.6686600446701050e+01 4.9065399914979935e+01 4.3129801750183105e+01) (float-vector 5.6477800011634827e+01 4.9067698419094086e+01 5.5839899927377701e+01) (float-vector 4.4562898576259613e+01 5.4979100823402405e+01 6.4476996660232544e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.3644801974296570e+01 4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector 7.9383201897144318e+01 4.9045100808143616e+01 -3.4461999894119799e-01) (float-vector 7.5355298817157745e+01 6.0731600970029831e+01 1.7170599894598126e+00) (float-vector 7.1428798139095306e+01 5.9612501412630081e+01 -2.6272999122738838e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.1366399526596069e+01 6.3560999929904938e+01 1.3268600217998028e+01) (float-vector 7.5355298817157745e+01 6.0731600970029831e+01 1.7170599894598126e+00) (float-vector 7.9383201897144318e+01 4.9045100808143616e+01 -3.4461999894119799e-01) (float-vector 7.3550097644329071e+01 5.4977700114250183e+01 2.7057100087404251e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.6185498833656311e+01 3.2231498509645462e+01 -4.1026100516319275e+01) (float-vector -7.1374498307704926e+01 3.4436900168657303e+01 -1.3211200013756752e+01) (float-vector -6.7285202443599701e+01 3.2246299088001251e+01 1.7788499593734741e+01) (float-vector -3.7614699453115463e+01 1.7724899575114250e+01 9.4110798090696335e+00) (float-vector -2.6819799095392227e+01 1.7725000157952309e+01 -2.7747999876737595e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.3850099444389343e+01 3.6490198224782944e+01 -5.2007101476192474e+01) (float-vector -5.6185498833656311e+01 3.2231498509645462e+01 -4.1026100516319275e+01) (float-vector -2.6819799095392227e+01 1.7725000157952309e+01 -2.7747999876737595e+01) (float-vector -4.1918899863958359e+01 3.2255701720714569e+01 -5.5662799626588821e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.2079102024435997e+00 1.7724899575114250e+01 -3.8213301450014114e+01) (float-vector -4.8838402144610882e+00 3.2246299088001251e+01 -6.9384098052978516e+01) (float-vector -2.9782500118017197e+01 3.8387000560760498e+01 -7.0040397346019745e+01) (float-vector -4.1918899863958359e+01 3.2255701720714569e+01 -5.5662799626588821e+01) (float-vector -2.6819799095392227e+01 1.7725000157952309e+01 -2.7747999876737595e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.2114600278437138e+01 3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector 2.5049600750207901e+01 3.4442000091075897e+01 -6.8122602999210358e+01) (float-vector 3.0671700835227966e+01 4.3021898716688156e+01 -7.2120100259780884e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.1731800884008408e+01 4.8429001122713089e+01 -6.7475102841854095e+01) (float-vector 3.0671700835227966e+01 4.3021898716688156e+01 -7.2120100259780884e+01) (float-vector 2.5049600750207901e+01 3.4442000091075897e+01 -6.8122602999210358e+01) (float-vector 4.3921299278736115e+01 3.2241899520158768e+01 -5.3944598883390427e+01) (float-vector 5.6843299418687820e+01 4.3021600693464279e+01 -5.3966101258993149e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.3921299278736115e+01 3.2241899520158768e+01 -5.3944598883390427e+01) (float-vector 2.5049600750207901e+01 3.4442000091075897e+01 -6.8122602999210358e+01) (float-vector 1.2114600278437138e+01 3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector -4.8838402144610882e+00 3.2246299088001251e+01 -6.9384098052978516e+01) (float-vector -5.2079102024435997e+00 1.7724899575114250e+01 -3.8213301450014114e+01) (float-vector 2.3136500269174576e+01 1.7725700512528419e+01 -3.0678000301122665e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3375499546527863e+01 6.5742902457714081e+01 5.4680000990629196e+01) (float-vector -5.6481499224901199e+01 6.5751999616622925e+01 4.0725000202655792e+01) (float-vector -6.9488696753978729e+01 6.5759703516960144e+01 1.4109100447967649e+00) (float-vector -5.8180298656225204e+01 6.5755397081375122e+01 -3.8144998252391815e+01) (float-vector -3.9661098271608353e+01 6.5756000578403473e+01 -5.7238798588514328e+01) (float-vector 2.7445200830698013e+00 6.8581901490688324e+01 -1.2800700031220913e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.9661098271608353e+01 6.5756000578403473e+01 -5.7238798588514328e+01) (float-vector -5.8180298656225204e+01 6.5755397081375122e+01 -3.8144998252391815e+01) (float-vector -6.6670998930931091e+01 5.4979000240564346e+01 -4.1205700486898422e+01) (float-vector -5.5839899927377701e+01 4.8932299017906189e+01 -5.6477800011634827e+01) (float-vector -4.3129801750183105e+01 4.8934601247310638e+01 -6.6686600446701050e+01) (float-vector -3.9661299437284470e+01 6.0734100639820099e+01 -6.4126297831535339e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.1015599370002747e+01 6.5753698348999023e+01 -6.6359199583530426e+01) (float-vector 1.5174100175499916e+01 6.5649501979351044e+01 -6.8473696708679199e+01) (float-vector 5.6185498833656311e+01 6.5768502652645111e+01 -4.1026100516319275e+01) (float-vector 2.7445200830698013e+00 6.8581901490688324e+01 -1.2800700031220913e+01) (float-vector -3.9661098271608353e+01 6.5756000578403473e+01 -5.7238798588514328e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.1015599370002747e+01 6.5753698348999023e+01 -6.6359199583530426e+01) (float-vector -1.2114600278437138e+01 5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector 1.7341399798169732e+00 5.9608001261949539e+01 -7.6071098446846008e+01) (float-vector 1.5174100175499916e+01 6.5649501979351044e+01 -6.8473696708679199e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.1015599370002747e+01 6.5753698348999023e+01 -6.6359199583530426e+01) (float-vector -3.9661098271608353e+01 6.5756000578403473e+01 -5.7238798588514328e+01) (float-vector -3.9661299437284470e+01 6.0734100639820099e+01 -6.4126297831535339e+01) (float-vector -1.2114600278437138e+01 5.9610001742839813e+01 -7.5127199292182922e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -6.7285202443599701e+01 3.2246299088001251e+01 1.7788499593734741e+01) (float-vector -7.5355298817157745e+01 3.7268400192260742e+01 1.7170599894598126e+00) (float-vector -7.0040397346019745e+01 3.8387000560760498e+01 2.9782500118017197e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.5355298817157745e+01 3.7268400192260742e+01 1.7170599894598126e+00) (float-vector -6.7285202443599701e+01 3.2246299088001251e+01 1.7788499593734741e+01) (float-vector -7.1374498307704926e+01 3.4436900168657303e+01 -1.3211200013756752e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.5839899927377701e+01 4.8932299017906189e+01 -5.6477800011634827e+01) (float-vector -6.4476996660232544e+01 4.3020900338888168e+01 -4.4562898576259613e+01) (float-vector -5.3850099444389343e+01 3.6490198224782944e+01 -5.2007101476192474e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.3644801974296570e+01 4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector -6.4476996660232544e+01 4.3020900338888168e+01 -4.4562898576259613e+01) (float-vector -5.5839899927377701e+01 4.8932299017906189e+01 -5.6477800011634827e+01) (float-vector -6.6670998930931091e+01 5.4979000240564346e+01 -4.1205700486898422e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.3951698839664459e+01 4.8940598964691162e+01 2.8930399566888809e+01) (float-vector -7.0040397346019745e+01 3.8387000560760498e+01 2.9782500118017197e+01) (float-vector -7.5355298817157745e+01 3.7268400192260742e+01 1.7170599894598126e+00) (float-vector -7.9383201897144318e+01 4.8954900354146957e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6686600446701050e+01 4.9065399914979935e+01 4.3129801750183105e+01) (float-vector 7.2120100259780884e+01 4.3021898716688156e+01 3.0671700835227966e+01) (float-vector 6.4126297831535339e+01 3.7265900522470474e+01 3.9661299437284470e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.5127199292182922e+01 3.8389999419450760e+01 1.2114600278437138e+01) (float-vector 7.2120100259780884e+01 4.3021898716688156e+01 3.0671700835227966e+01) (float-vector 6.6686600446701050e+01 4.9065399914979935e+01 4.3129801750183105e+01) (float-vector 7.3550097644329071e+01 5.4977700114250183e+01 2.7057100087404251e+01) (float-vector 7.9383201897144318e+01 4.9045100808143616e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.4474796652793884e+01 3.8389399647712708e+01 -1.5645200386643410e+01) (float-vector 6.9488696753978729e+01 3.2240301370620728e+01 1.4109000330790877e+00) (float-vector 7.5127199292182922e+01 3.8389999419450760e+01 1.2114600278437138e+01) (float-vector 7.9383201897144318e+01 4.9045100808143616e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.4476996660232544e+01 5.4979100823402405e+01 -4.4562898576259613e+01) (float-vector 6.6202603280544281e+01 4.9065899103879929e+01 -4.3869800865650177e+01) (float-vector 7.3644801974296570e+01 4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector 7.1428798139095306e+01 5.9612501412630081e+01 -2.6272999122738838e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6202603280544281e+01 4.9065899103879929e+01 -4.3869800865650177e+01) (float-vector 6.4476996660232544e+01 5.4979100823402405e+01 -4.4562898576259613e+01) (float-vector 5.3966101258993149e+01 5.4978400468826294e+01 -5.6843299418687820e+01) (float-vector 4.1731800884008408e+01 4.8429001122713089e+01 -6.7475102841854095e+01) (float-vector 5.6843299418687820e+01 4.3021600693464279e+01 -5.3966101258993149e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.1428798139095306e+01 5.9612501412630081e+01 -2.6272999122738838e+01) (float-vector 5.6185498833656311e+01 6.5768502652645111e+01 -4.1026100516319275e+01) (float-vector 4.2892999947071075e+01 6.0733798891305923e+01 -6.2013100832700729e+01) (float-vector 5.3966101258993149e+01 5.4978400468826294e+01 -5.6843299418687820e+01) (float-vector 6.4476996660232544e+01 5.4979100823402405e+01 -4.4562898576259613e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 6.5753698348999023e+01 -2.1015599370002747e+01) (float-vector 5.6185498833656311e+01 6.5768502652645111e+01 -4.1026100516319275e+01) (float-vector 7.1428798139095306e+01 5.9612501412630081e+01 -2.6272999122738838e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 6.5753698348999023e+01 -2.1015599370002747e+01) (float-vector 7.1366399526596069e+01 6.3560999929904938e+01 1.3268600217998028e+01) (float-vector 5.9105001389980316e+01 6.5766297280788422e+01 3.6562200635671616e+01) (float-vector 2.7445200830698013e+00 6.8581901490688324e+01 -1.2800700031220913e+01) (float-vector 5.6185498833656311e+01 6.5768502652645111e+01 -4.1026100516319275e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.1366399526596069e+01 6.3560999929904938e+01 1.3268600217998028e+01) (float-vector 6.6359199583530426e+01 6.5753698348999023e+01 -2.1015599370002747e+01) (float-vector 7.1428798139095306e+01 5.9612501412630081e+01 -2.6272999122738838e+01) (float-vector 7.5355298817157745e+01 6.0731600970029831e+01 1.7170599894598126e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.5645200386643410e+01 3.8389399647712708e+01 -7.4474796652793884e+01) (float-vector -2.9782500118017197e+01 3.8387000560760498e+01 -7.0040397346019745e+01) (float-vector -4.8838402144610882e+00 3.2246299088001251e+01 -6.9384098052978516e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.5645200386643410e+01 3.8389399647712708e+01 -7.4474796652793884e+01) (float-vector -4.8838402144610882e+00 3.2246299088001251e+01 -6.9384098052978516e+01) (float-vector 1.2114600278437138e+01 3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector 3.4459200105629861e-01 4.8954900354146957e+01 -7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.4474796652793884e+01 5.9610601514577866e+01 -1.5645200386643410e+01) (float-vector -5.8180298656225204e+01 6.5755397081375122e+01 -3.8144998252391815e+01) (float-vector -6.9488696753978729e+01 6.5759703516960144e+01 1.4109100447967649e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.4474796652793884e+01 5.9610601514577866e+01 -1.5645200386643410e+01) (float-vector -7.3644801974296570e+01 4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector -6.6670998930931091e+01 5.4979000240564346e+01 -4.1205700486898422e+01) (float-vector -5.8180298656225204e+01 6.5755397081375122e+01 -3.8144998252391815e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.3850099444389343e+01 3.6490198224782944e+01 -5.2007101476192474e+01) (float-vector -6.4476996660232544e+01 4.3020900338888168e+01 -4.4562898576259613e+01) (float-vector -7.3644801974296570e+01 4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector -7.6686702668666840e+01 4.3023999780416489e+01 -1.6111699864268303e+01) (float-vector -7.1374498307704926e+01 3.4436900168657303e+01 -1.3211200013756752e+01) (float-vector -5.6185498833656311e+01 3.2231498509645462e+01 -4.1026100516319275e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.9383201897144318e+01 4.8954900354146957e+01 -3.4461999894119799e-01) (float-vector -7.6686702668666840e+01 4.3023999780416489e+01 -1.6111699864268303e+01) (float-vector -7.3644801974296570e+01 4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector -7.4474796652793884e+01 5.9610601514577866e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.1374498307704926e+01 3.4436900168657303e+01 -1.3211200013756752e+01) (float-vector -7.6686702668666840e+01 4.3023999780416489e+01 -1.6111699864268303e+01) (float-vector -7.9383201897144318e+01 4.8954900354146957e+01 -3.4461999894119799e-01) (float-vector -7.5355298817157745e+01 3.7268400192260742e+01 1.7170599894598126e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.0040397346019745e+01 3.8387000560760498e+01 2.9782500118017197e+01) (float-vector -7.3951698839664459e+01 4.8940598964691162e+01 2.8930399566888809e+01) (float-vector -6.4476996660232544e+01 5.4979100823402405e+01 4.4562898576259613e+01) (float-vector -5.4402600973844528e+01 4.8448301851749420e+01 5.7758700102567673e+01) (float-vector -6.2013100832700729e+01 3.7266198545694351e+01 4.2892999947071075e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.2892999947071075e+01 6.0733798891305923e+01 6.2013100832700729e+01) (float-vector -2.7057100087404251e+01 5.4977700114250183e+01 7.3550097644329071e+01) (float-vector -4.3129801750183105e+01 4.9065399914979935e+01 6.6686600446701050e+01) (float-vector -5.4402600973844528e+01 4.8448301851749420e+01 5.7758700102567673e+01) (float-vector -6.4476996660232544e+01 5.4979100823402405e+01 4.4562898576259613e+01) (float-vector -5.3850099444389343e+01 6.1509799212217331e+01 5.2007101476192474e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 3.2246299088001251e+01 -2.1015599370002747e+01) (float-vector 6.9488696753978729e+01 3.2240301370620728e+01 1.4109000330790877e+00) (float-vector 7.4474796652793884e+01 3.8389399647712708e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.9488696753978729e+01 3.2240301370620728e+01 1.4109000330790877e+00) (float-vector 6.7513503134250641e+01 3.4440599381923676e+01 2.6707200333476067e+01) (float-vector 7.5127199292182922e+01 3.8389999419450760e+01 1.2114600278437138e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.7513503134250641e+01 3.4440599381923676e+01 2.6707200333476067e+01) (float-vector 6.9488696753978729e+01 3.2240301370620728e+01 1.4109000330790877e+00) (float-vector 6.6359199583530426e+01 3.2246299088001251e+01 -2.1015599370002747e+01) (float-vector 3.7004400044679642e+01 1.7724899575114250e+01 -1.1183599941432476e+01) (float-vector 3.1677901744842529e+01 1.7725799232721329e+01 2.1873999387025833e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.7513503134250641e+01 3.4440599381923676e+01 2.6707200333476067e+01) (float-vector 6.4126297831535339e+01 3.7265900522470474e+01 3.9661299437284470e+01) (float-vector 7.2120100259780884e+01 4.3021898716688156e+01 3.0671700835227966e+01) (float-vector 7.5127199292182922e+01 3.8389999419450760e+01 1.2114600278437138e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.4126297831535339e+01 3.7265900522470474e+01 3.9661299437284470e+01) (float-vector 6.7513503134250641e+01 3.4440599381923676e+01 2.6707200333476067e+01) (float-vector 3.1677901744842529e+01 1.7725799232721329e+01 2.1873999387025833e+01) (float-vector 4.3375499546527863e+01 3.2257098704576492e+01 5.4680000990629196e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3375499546527863e+01 6.5742902457714081e+01 5.4680000990629196e+01) (float-vector -1.5174100175499916e+01 6.5649501979351044e+01 6.8473696708679199e+01) (float-vector -2.7057100087404251e+01 5.4977700114250183e+01 7.3550097644329071e+01) (float-vector -4.2892999947071075e+01 6.0733798891305923e+01 6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.4562898576259613e+01 5.4979100823402405e+01 6.4476996660232544e+01) (float-vector 3.0671700835227966e+01 5.4978098720312119e+01 7.2120100259780884e+01) (float-vector 2.1015599370002747e+01 6.5753698348999023e+01 6.6359199583530426e+01) (float-vector 3.6946401000022888e+01 6.5759100019931793e+01 5.8903798460960388e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.6946401000022888e+01 6.5759100019931793e+01 5.8903798460960388e+01) (float-vector 5.9105001389980316e+01 6.5766297280788422e+01 3.6562200635671616e+01) (float-vector 6.2013100832700729e+01 6.0733798891305923e+01 4.2892999947071075e+01) (float-vector 4.4562898576259613e+01 5.4979100823402405e+01 6.4476996660232544e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.2114600278437138e+01 5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector -2.8930399566888809e+01 4.8940598964691162e+01 -7.3951698839664459e+01) (float-vector 3.4459200105629861e-01 4.8954900354146957e+01 -7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3129801750183105e+01 4.8934601247310638e+01 -6.6686600446701050e+01) (float-vector -2.8930399566888809e+01 4.8940598964691162e+01 -7.3951698839664459e+01) (float-vector -1.2114600278437138e+01 5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector -3.9661299437284470e+01 6.0734100639820099e+01 -6.4126297831535339e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.8930399566888809e+01 4.8940598964691162e+01 -7.3951698839664459e+01) (float-vector -2.9782500118017197e+01 3.8387000560760498e+01 -7.0040397346019745e+01) (float-vector -1.5645200386643410e+01 3.8389399647712708e+01 -7.4474796652793884e+01) (float-vector 3.4459200105629861e-01 4.8954900354146957e+01 -7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.3850099444389343e+01 3.6490198224782944e+01 -5.2007101476192474e+01) (float-vector -4.1918899863958359e+01 3.2255701720714569e+01 -5.5662799626588821e+01) (float-vector -2.9782500118017197e+01 3.8387000560760498e+01 -7.0040397346019745e+01) (float-vector -2.8930399566888809e+01 4.8940598964691162e+01 -7.3951698839664459e+01) (float-vector -4.3129801750183105e+01 4.8934601247310638e+01 -6.6686600446701050e+01) (float-vector -5.5839899927377701e+01 4.8932299017906189e+01 -5.6477800011634827e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.6481499224901199e+01 6.5751999616622925e+01 4.0725000202655792e+01) (float-vector -7.1428798139095306e+01 5.9612501412630081e+01 2.6272999122738838e+01) (float-vector -6.9488696753978729e+01 6.5759703516960144e+01 1.4109100447967649e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.1428798139095306e+01 5.9612501412630081e+01 2.6272999122738838e+01) (float-vector -6.4476996660232544e+01 5.4979100823402405e+01 4.4562898576259613e+01) (float-vector -7.3951698839664459e+01 4.8940598964691162e+01 2.8930399566888809e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.1428798139095306e+01 5.9612501412630081e+01 2.6272999122738838e+01) (float-vector -5.6481499224901199e+01 6.5751999616622925e+01 4.0725000202655792e+01) (float-vector -5.3850099444389343e+01 6.1509799212217331e+01 5.2007101476192474e+01) (float-vector -6.4476996660232544e+01 5.4979100823402405e+01 4.4562898576259613e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -6.9488696753978729e+01 6.5759703516960144e+01 1.4109100447967649e+00) (float-vector -7.1428798139095306e+01 5.9612501412630081e+01 2.6272999122738838e+01) (float-vector -7.3951698839664459e+01 4.8940598964691162e+01 2.8930399566888809e+01) (float-vector -7.9383201897144318e+01 4.8954900354146957e+01 -3.4461999894119799e-01) (float-vector -7.4474796652793884e+01 5.9610601514577866e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.6820500642061234e+01 3.2238200306892395e+01 -4.0331300348043442e+01) (float-vector 5.6843299418687820e+01 4.3021600693464279e+01 -5.3966101258993149e+01) (float-vector 4.3921299278736115e+01 3.2241899520158768e+01 -5.3944598883390427e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 3.2246299088001251e+01 -2.1015599370002747e+01) (float-vector 5.6820500642061234e+01 3.2238200306892395e+01 -4.0331300348043442e+01) (float-vector 4.3921299278736115e+01 3.2241899520158768e+01 -5.3944598883390427e+01) (float-vector 2.3136500269174576e+01 1.7725700512528419e+01 -3.0678000301122665e+01) (float-vector 3.7004400044679642e+01 1.7724899575114250e+01 -1.1183599941432476e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.3644801974296570e+01 4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector 6.6202603280544281e+01 4.9065899103879929e+01 -4.3869800865650177e+01) (float-vector 5.6843299418687820e+01 4.3021600693464279e+01 -5.3966101258993149e+01) (float-vector 5.6820500642061234e+01 3.2238200306892395e+01 -4.0331300348043442e+01) (float-vector 6.6359199583530426e+01 3.2246299088001251e+01 -2.1015599370002747e+01) (float-vector 7.4474796652793884e+01 3.8389399647712708e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.4203500002622604e+01 4.9050800502300262e+01 7.8114800155162811e+01) (float-vector -2.7057100087404251e+01 5.4977700114250183e+01 7.3550097644329071e+01) (float-vector -1.5174100175499916e+01 6.5649501979351044e+01 6.8473696708679199e+01) (float-vector 5.1130601204931736e+00 6.3596703112125397e+01 7.2644703090190887e+01) (float-vector 1.7856500344350934e+00 5.4973501712083817e+01 7.8329898416996002e+01) (float-vector 3.4459200105629861e-01 4.9045100808143616e+01 7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.1130601204931736e+00 6.3596703112125397e+01 7.2644703090190887e+01) (float-vector 2.1015599370002747e+01 6.5753698348999023e+01 6.6359199583530426e+01) (float-vector 3.0671700835227966e+01 5.4978098720312119e+01 7.2120100259780884e+01) (float-vector 1.7856500344350934e+00 5.4973501712083817e+01 7.8329898416996002e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.9105001389980316e+01 6.5766297280788422e+01 3.6562200635671616e+01) (float-vector 3.6946401000022888e+01 6.5759100019931793e+01 5.8903798460960388e+01) (float-vector 2.1015599370002747e+01 6.5753698348999023e+01 6.6359199583530426e+01) (float-vector 5.1130601204931736e+00 6.3596703112125397e+01 7.2644703090190887e+01) (float-vector -1.5174100175499916e+01 6.5649501979351044e+01 6.8473696708679199e+01) (float-vector -4.3375499546527863e+01 6.5742902457714081e+01 5.4680000990629196e+01) (float-vector 2.7445200830698013e+00 6.8581901490688324e+01 -1.2800700031220913e+01)))))
              ))
             )
      (setq geom (instance collada-body :init :replace-obj qhull :name "br_caster_r_wheel_link_geom0"))
      (when glv
        (setq (geom . gl::aglvertices) glv)
        (send geom :assoc glv))
      geom))
  (:_make_instance_br_caster_rotation_link_geom0 ()
    (let (geom glv qhull
          (local-cds (make-coords :pos (float-vector -2.2459999999999999e+02 -2.2459999999999999e+02 2.8199999999999999e+01))))
      (setq glv
       (instance gl::glvertices :init
                 (list ;; mesh list
                  (list ;; mesh description
                   (list :type :triangles)
                   (list :material (list
                    (list :ambient (float-vector 0.000100 0.000100 0.000100 1.000000))
                    (list :diffuse (float-vector 0.000000 0.000000 0.000000 1.000000))))
                   (list :indices #i( 0 1 2 162 0 2 1 0 151 0 162 151 1 151 152 1 152 215 1 284 2 1 215 284 151 223 152 151 162 223 2 299 162 162 299 223 274 299 2 150 299 274 299 150 223 2 273 274 274 351 148 150 274 148 289 351 274 273 289 274 168 148 351 288 351 289 351 166 168 166 351 288 288 289 175 273 175 289 177 167 288 288 175 177 166 288 167 166 167 168 167 311 168 235 234 167 234 380 167 454 167 380 235 167 177 311 167 454 453 311 454 182 311 453 168 311 182 453 454 451 454 380 451 159 182 453 451 159 453 451 160 159 160 451 380 159 160 161 181 182 159 214 181 159 214 159 161 161 160 380 440 214 161 161 380 440 347 158 214 214 440 347 158 181 214 181 339 47 181 47 182 158 339 181 37 158 134 134 158 347 158 37 339 476 47 339 476 339 37 72 476 36 68 476 427 476 68 47 72 427 476 476 37 36 36 37 38 70 72 36 91 36 38 91 70 36 38 37 368 23 38 368 91 38 287 287 38 23 91 86 70 91 195 86 91 287 195 86 87 70 498 87 86 195 498 86 35 195 287 35 318 195 498 195 497 195 318 497 498 497 418 498 418 87 418 331 87 87 331 70 331 90 71 331 426 90 418 426 331 70 331 71 70 71 72 72 71 82 71 412 82 71 90 412 72 82 414 414 427 72 82 329 414 412 329 82 412 413 329 90 89 412 412 89 413 328 329 142 328 191 329 191 414 329 329 413 142 190 414 191 190 427 414 190 68 427 189 190 191 189 69 190 69 68 190 205 191 328 189 191 205 141 328 142 141 205 328 204 189 205 216 218 205 212 216 205 218 204 205 212 205 141 189 204 499 499 69 189 499 204 42 499 42 452 499 452 69 42 43 44 201 42 202 42 44 202 452 42 201 204 43 42 43 330 44 43 327 344 43 344 330 204 327 43 44 330 325 44 325 202 324 202 325 202 324 201 452 201 324 45 452 46 45 69 452 452 324 341 341 46 452 45 46 47 45 68 69 68 45 47 182 47 46 341 182 46 340 148 341 341 365 182 148 365 341 341 324 340 182 365 168 168 365 148 148 149 150 149 148 340 324 149 340 324 333 149 333 81 149 150 149 81 223 150 224 150 81 224 79 80 81 333 75 81 80 224 81 75 79 81 222 223 224 222 224 80 429 80 428 80 79 428 222 80 429 74 97 79 74 79 75 97 428 79 73 74 75 73 75 333 73 420 74 420 496 74 74 496 97 495 494 73 495 73 333 494 420 73 324 495 333 325 494 495 324 325 495 330 420 494 325 330 494 330 416 420 330 344 416 344 415 416 416 415 420 420 415 496 415 423 95 496 415 95 344 423 415 344 217 345 345 423 344 327 217 344 320 95 423 321 320 423 345 321 423 95 96 97 96 95 320 496 95 97 320 321 96 217 321 345 321 17 96 321 217 17 17 16 96 96 16 97 97 16 326 326 428 97 15 16 17 16 15 326 17 131 15 17 217 213 17 213 131 15 131 52 15 52 245 15 245 286 15 286 326 213 52 131 51 35 52 52 35 34 213 51 52 245 52 34 318 51 319 51 88 319 213 88 51 51 318 35 497 318 418 318 319 418 319 417 418 417 319 88 418 417 426 426 417 90 90 417 88 88 89 90 78 413 89 89 88 76 78 89 76 76 77 78 142 413 78 142 78 77 88 77 76 141 142 77 212 141 77 77 88 212 212 88 213 213 216 212 213 217 216 216 217 218 218 217 327 204 218 327 33 34 35 35 66 67 35 203 66 35 287 203 35 364 33 67 411 35 411 364 35 245 34 314 34 33 314 244 245 101 286 245 223 405 245 314 101 245 405 244 223 245 405 314 33 405 409 402 102 101 405 409 405 33 102 405 402 33 111 110 33 110 409 364 315 33 33 315 111 402 409 110 401 402 110 493 102 402 493 402 401 110 111 112 112 401 110 112 462 401 462 493 401 322 493 197 462 197 493 322 102 493 462 112 332 58 60 462 58 462 332 60 197 462 111 332 112 111 58 332 58 59 60 315 58 111 315 59 58 61 59 62 62 59 30 59 364 30 59 315 364 59 61 477 60 59 477 477 61 92 61 62 92 92 62 32 62 30 32 30 31 32 364 31 30 364 411 31 411 178 31 32 31 178 92 32 93 32 178 93 92 93 94 477 92 421 421 92 94 313 94 93 93 178 180 93 180 313 178 179 180 411 67 178 178 67 179 180 179 83 410 180 85 180 83 85 313 180 410 313 410 342 94 313 342 410 99 342 99 410 85 83 84 85 98 99 85 84 432 85 432 98 85 179 66 83 66 84 83 430 431 84 430 84 66 431 432 84 419 432 431 419 98 432 419 200 98 98 343 99 200 343 98 342 99 343 200 129 343 342 343 278 343 129 278 198 199 200 129 200 199 198 200 419 198 419 431 198 431 375 375 431 430 198 129 199 287 198 375 129 198 287 287 375 203 203 375 430 465 355 287 287 130 129 22 465 287 23 22 287 355 130 287 128 129 130 130 355 308 130 308 307 130 307 128 128 479 129 278 129 479 468 126 479 479 126 278 337 468 479 337 479 128 121 278 126 232 342 278 121 280 278 280 232 278 408 342 232 408 94 342 408 422 94 317 408 316 317 422 408 316 408 232 421 94 422 317 421 422 316 60 317 317 60 477 317 477 421 60 196 197 196 60 316 196 323 197 196 298 323 196 348 298 196 316 348 197 323 322 322 323 11 298 11 323 9 11 298 9 298 348 316 9 348 9 10 11 9 316 10 304 11 53 322 11 304 11 54 53 10 54 11 304 102 322 304 53 100 102 304 100 53 54 55 100 53 55 171 140 54 54 139 55 54 140 139 171 54 10 424 55 425 424 100 55 267 425 55 139 267 55 100 101 102 424 101 100 425 244 424 244 101 424 244 425 223 223 425 461 425 267 461 286 223 222 223 461 239 223 239 271 271 458 223 223 458 152 461 267 266 461 266 239 144 238 239 238 271 239 144 239 266 265 266 267 145 266 265 266 145 144 279 265 267 145 265 279 267 369 104 267 104 279 267 139 369 279 104 173 145 279 173 103 172 173 103 173 104 173 172 366 366 145 173 64 103 104 172 103 64 172 64 63 172 357 367 172 63 357 366 172 367 366 367 145 483 143 367 357 475 367 483 367 448 143 145 367 448 367 475 143 144 145 482 395 143 482 143 483 395 144 143 448 125 483 483 125 482 443 482 125 482 443 395 144 395 396 443 396 395 358 238 144 358 144 450 144 396 450 396 480 450 396 481 480 443 481 396 485 450 277 450 480 277 358 450 350 450 485 350 334 238 358 358 350 334 271 238 272 238 334 272 485 458 271 350 485 271 406 271 272 271 406 350 485 379 458 379 485 277 379 152 458 283 215 379 215 152 379 283 379 277 215 283 284 247 283 208 208 283 277 284 283 247 285 284 247 2 284 285 2 285 273 273 285 439 439 285 247 176 273 439 175 273 176 176 439 177 177 439 247 175 176 177 246 398 177 246 177 247 253 235 177 398 253 177 208 246 247 399 398 246 208 399 246 188 398 399 188 253 398 399 436 472 207 436 399 399 472 188 208 207 399 206 207 208 277 206 208 480 481 206 481 207 206 480 206 277 481 256 207 443 256 481 256 257 207 185 186 256 257 256 209 256 186 209 443 185 256 443 124 185 443 125 124 185 124 186 209 186 13 186 124 264 13 186 264 39 209 13 209 484 257 39 484 209 484 39 257 39 40 41 39 41 194 194 257 39 39 13 12 39 187 40 39 270 187 12 270 39 436 194 41 41 40 436 207 194 436 194 207 257 40 472 436 188 472 40 40 187 188 253 188 254 254 188 292 187 292 188 292 187 270 292 270 260 254 292 260 260 253 254 269 253 260 253 233 235 253 269 233 269 260 270 270 133 269 306 233 269 433 269 491 269 133 491 269 433 306 233 234 235 233 380 234 233 306 380 226 157 380 440 380 157 306 226 380 8 225 226 225 157 226 8 226 306 6 7 8 306 6 8 8 7 225 7 155 225 157 225 155 388 7 6 388 155 7 388 6 27 388 27 394 388 464 155 388 394 464 25 26 27 27 6 132 132 25 27 394 27 26 394 389 464 138 394 26 389 394 138 464 487 488 464 488 155 389 487 464 487 349 488 487 478 349 389 478 487 349 155 488 155 156 157 391 156 155 349 392 155 391 155 392 377 378 156 346 377 156 156 378 157 156 391 346 157 378 393 440 157 393 377 374 378 374 393 378 393 347 440 374 347 393 374 134 347 377 134 374 134 135 56 134 377 135 134 56 37 57 135 305 135 377 305 56 135 57 37 56 57 57 368 37 305 108 57 57 108 109 109 368 57 108 305 346 346 305 377 108 21 109 346 391 108 21 108 391 368 109 21 21 23 368 21 22 23 21 391 392 21 392 349 349 22 21 465 22 349 349 249 248 459 349 248 465 349 459 478 249 349 459 105 465 220 355 465 105 220 465 459 474 105 248 474 459 105 106 107 105 255 106 105 107 220 105 474 255 255 474 355 355 474 308 308 474 248 354 255 355 355 220 354 106 255 354 220 221 354 221 106 354 220 165 221 49 106 221 165 164 221 164 49 221 48 49 50 49 437 106 363 437 49 49 48 363 50 49 164 48 192 193 48 193 363 48 50 192 50 164 192 193 192 164 363 193 445 445 193 164 444 363 445 363 444 437 438 445 164 444 445 438 437 444 438 437 438 275 164 275 438 258 275 211 164 211 275 258 437 275 258 211 259 259 437 258 163 210 211 163 211 164 210 259 211 163 164 165 489 210 163 489 163 165 210 489 437 259 210 437 106 437 489 106 489 243 243 489 165 107 165 220 107 243 165 107 106 243 117 248 249 404 449 248 449 252 248 117 404 248 252 308 248 478 400 249 400 117 249 389 400 478 117 400 4 389 4 400 4 389 390 138 390 389 227 390 137 390 138 137 4 390 227 136 137 138 26 136 138 137 133 268 268 227 137 137 136 26 133 137 26 227 228 229 268 228 227 4 227 229 133 228 268 115 312 228 4 229 228 133 115 228 312 4 228 5 4 312 115 5 312 3 4 5 117 4 3 116 3 5 5 115 116 116 117 3 117 116 404 116 403 404 114 116 115 116 114 403 404 386 449 404 403 386 403 236 386 114 263 403 403 263 236 113 114 115 370 114 113 114 370 263 113 12 370 12 113 115 12 115 133 12 13 14 12 469 470 12 14 469 470 370 12 12 133 270 470 263 370 261 470 469 470 261 263 469 231 261 231 469 14 261 262 263 261 231 301 397 261 301 397 262 261 14 230 231 231 300 301 231 230 300 301 300 441 397 301 295 441 295 301 397 295 372 397 372 466 262 397 466 466 372 237 466 237 407 407 262 466 236 407 237 263 407 236 262 407 263 120 236 237 353 386 236 120 119 236 236 119 353 118 119 120 120 219 118 237 219 120 352 353 119 118 352 119 310 353 352 353 310 387 353 387 386 121 123 352 310 352 123 121 352 118 276 118 219 121 118 276 276 219 383 237 383 219 276 184 232 232 280 276 184 276 383 121 276 280 121 122 123 126 122 121 126 127 122 122 127 123 468 467 126 126 467 127 127 467 468 123 127 337 127 468 337 251 337 128 251 376 337 337 376 123 250 251 252 376 251 250 252 251 490 490 251 128 307 490 128 307 252 490 307 308 252 449 386 252 250 252 386 386 387 250 387 309 250 309 376 250 310 309 387 123 309 310 123 376 309 184 383 169 383 384 169 457 383 237 384 383 457 183 184 169 184 183 232 169 10 183 232 183 316 10 316 183 171 10 169 169 170 171 171 170 140 170 169 359 140 170 64 64 170 146 359 147 170 170 147 146 104 139 140 140 64 104 63 64 65 65 64 146 146 147 65 63 65 357 65 147 357 356 357 147 382 475 357 356 382 357 381 382 356 297 356 371 381 356 297 371 356 147 471 475 382 471 382 381 475 471 448 381 296 471 296 448 471 296 381 297 295 296 297 295 297 371 295 371 372 372 371 147 295 441 442 295 442 296 300 230 441 441 230 442 230 373 442 296 442 373 14 373 230 373 29 296 373 14 29 14 28 29 13 240 14 447 446 14 240 447 14 28 14 446 29 28 460 460 296 29 446 460 28 446 447 448 446 448 460 240 242 447 448 447 242 240 241 242 241 240 13 448 242 125 125 242 241 448 296 460 241 13 125 124 125 13 13 264 124 147 455 372 147 359 455 455 359 456 455 457 372 455 456 457 457 237 372 384 457 456 359 384 456 359 169 384 104 369 139 132 133 25 133 281 282 133 434 433 133 282 434 491 133 433 281 133 132 25 133 26 281 302 303 282 281 303 302 281 132 434 282 435 303 435 282 433 434 435 433 435 306 306 435 303 6 303 302 6 306 303 132 6 302 350 335 334 406 335 350 334 335 336 335 338 336 335 406 154 338 335 154 291 334 293 291 272 334 334 336 293 290 154 291 293 290 291 406 272 291 154 406 291 501 290 293 154 290 501 154 501 473 473 501 293 154 473 385 473 293 385 385 153 154 385 293 492 153 385 492 153 18 154 294 153 492 153 294 18 492 293 294 293 19 294 294 19 18 18 19 20 362 18 20 18 362 154 20 19 24 19 174 24 19 293 174 486 362 20 486 20 24 486 24 174 174 463 486 463 362 486 174 293 336 500 174 361 174 336 361 500 463 174 463 360 362 500 360 463 360 500 361 360 361 362 362 361 336 362 336 338 362 338 154 429 286 222 326 286 429 326 429 428 203 430 66 67 66 179))
                   (list :vertices (let ((mat (make-matrix 502 3))) (fvector-replace (array-entity mat) #f(1.5309399414062500e+02 1.6241200256347656e+02 1.0526599884033203e+02 1.6749499511718750e+02 1.6241200256347656e+02 1.0526599884033203e+02 1.4962998962402344e+02 1.6754400634765625e+02 1.0526599884033203e+02 2.5771398925781250e+02 2.9194000244140625e+02 1.3304998779296875e+02 2.4495401000976562e+02 2.9688598632812500e+02 1.3304998779296875e+02 2.5889199829101562e+02 2.9147402954101562e+02 1.3955000305175781e+02 1.7266799926757812e+02 2.7893399047851562e+02 1.3304998779296875e+02 1.8274299621582031e+02 2.5680999755859375e+02 1.3304998779296875e+02 1.7675300598144531e+02 2.4676300048828125e+02 1.3304998779296875e+02 2.9864697265625000e+02 2.1059500122070312e+02 1.0230000305175781e+02 3.1669802856445312e+02 2.0908200073242188e+02 1.0230000305175781e+02 2.9776699829101562e+02 2.0587199401855469e+02 1.0230000305175781e+02 2.8804498291015625e+02 2.6470397949218750e+02 1.3955000305175781e+02 2.4302198791503906e+02 1.5177099609375000e+02 1.3955000305175781e+02 2.7962301635742188e+02 1.7346200561523438e+02 1.3955000305175781e+02 1.4557699584960938e+02 1.9859201049804688e+02 -1.6409799575805664e+01 1.4248800659179688e+02 1.9892098999023438e+02 -2.7892499923706055e+01 1.4242399597167969e+02 1.9894898986816406e+02 -5.9969299316406250e+01 2.3170300292968750e+02 1.4110000610351562e+02 -5.4909603118896484e+01 2.2893800354003906e+02 1.3809999084472656e+02 -5.5569801330566406e+01 2.2042399597167969e+02 1.4110000610351562e+02 -5.5612400054931641e+01 1.8657299804687500e+02 2.9028500366210938e+02 1.0230000305175781e+02 1.9710000610351562e+02 2.9460998535156250e+02 1.0230000305175781e+02 1.9573899841308594e+02 2.7945001220703125e+02 1.0230000305175781e+02 2.1716299438476562e+02 1.3809999084472656e+02 -5.4838798522949219e+01 1.8395500183105469e+02 2.8766598510742188e+02 1.3955000305175781e+02 1.9309399414062500e+02 2.9278601074218750e+02 1.3955000305175781e+02 1.8358898925781250e+02 2.8748501586914062e+02 1.3304998779296875e+02 2.8716799926757812e+02 1.8310000610351562e+02 1.3955000305175781e+02 2.9236502075195312e+02 1.9235800170898438e+02 1.3955000305175781e+02 2.9864697265625000e+02 2.3860499572753906e+02 -4.3196701049804688e+01 2.9844998168945312e+02 2.4091101074218750e+02 -5.8984100341796875e+01 2.9835598754882812e+02 2.4154199218750000e+02 -9.5243206024169922e+00 2.9099398803710938e+02 1.9934800720214844e+02 -5.9969898223876953e+01 2.8664700317382812e+02 1.9859500122070312e+02 -5.9969802856445312e+01 2.8664700317382812e+02 2.5060498046875000e+02 -5.9969802856445312e+01 1.4111100769042969e+02 2.4978900146484375e+02 1.0230100250244141e+02 1.4256199645996094e+02 2.6967901611328125e+02 1.0230000305175781e+02 1.4557699584960938e+02 2.5060498046875000e+02 1.0230000305175781e+02 1.9108801269531250e+02 1.5739799499511719e+02 1.3955000305175781e+02 1.6508399963378906e+02 1.7879199218750000e+02 1.3955000305175781e+02 1.7696299743652344e+02 1.6646899414062500e+02 1.3955000305175781e+02 1.3398300170898438e+02 2.0749099731445312e+02 5.7514900207519531e+01 1.3398300170898438e+02 2.0749099731445312e+02 1.3412400245666504e+01 1.3448699951171875e+02 2.0600601196289062e+02 3.6914199829101562e+01 1.3357701110839844e+02 2.3860499572753906e+02 1.0230000305175781e+02 1.3136099243164062e+02 2.3057299804687500e+02 1.0230000305175781e+02 1.3324299621582031e+02 2.4367100524902344e+02 1.0230000305175781e+02 2.4409001159667969e+02 3.1110000610351562e+02 -4.7562698364257812e+01 2.5209999084472656e+02 3.1110000610351562e+02 -2.8200000762939453e+01 2.5044300842285156e+02 3.1110098266601562e+02 -3.8267398834228516e+01 1.4557699584960938e+02 2.5060498046875000e+02 -5.9969802856445312e+01 2.0645800781250000e+02 1.9859500122070312e+02 -5.9969802856445312e+01 2.9491900634765625e+02 2.0190599060058594e+02 1.0230000305175781e+02 3.1264599609375000e+02 1.9347000122070312e+02 1.0230000305175781e+02 2.9153399658203125e+02 1.9957501220703125e+02 1.0230000305175781e+02 1.5309399414062500e+02 2.8678799438476562e+02 1.0230000305175781e+02 1.7484899902343750e+02 2.8678799438476562e+02 1.0230000305175781e+02 2.9866799926757812e+02 2.1059399414062500e+02 -2.7142898559570312e+01 2.9864697265625000e+02 2.2240200805664062e+02 -1.8764699935913086e+01 2.9864697265625000e+02 2.1059500122070312e+02 4.0985599517822266e+01 2.9864697265625000e+02 2.3860499572753906e+02 8.0976800918579102e+00 2.9864697265625000e+02 2.3860499572753906e+02 -1.5550399780273438e+01 2.8689398193359375e+02 1.8344299316406250e+02 1.2900000000000000e+02 2.8834399414062500e+02 1.8549501037597656e+02 1.0526499938964844e+02 2.9076199340820312e+02 1.9002600097656250e+02 1.2900000000000000e+02 2.9051000976562500e+02 2.4999398803710938e+02 -3.7053100585937500e+01 2.9255102539062500e+02 2.4914300537109375e+02 -5.9970798492431641e+01 1.3385299682617188e+02 2.4104499816894531e+02 1.0230000305175781e+02 1.3357701110839844e+02 2.3860499572753906e+02 9.6058898925781250e+01 1.4085800170898438e+02 2.4970899963378906e+02 7.5261901855468750e+01 1.3889401245117188e+02 2.4860499572753906e+02 3.5743999481201172e+01 1.3716799926757812e+02 2.4725100708007812e+02 1.0056999969482422e+02 1.3708799743652344e+02 2.0211000061035156e+02 6.0708602905273438e+01 1.3826901245117188e+02 2.0107400512695312e+02 3.2135898590087891e+01 1.3826901245117188e+02 2.0107400512695312e+02 7.9724601745605469e+01 1.3706498718261719e+02 2.4705700683593750e+02 -5.9969802856445312e+01 1.3508500671386719e+02 2.4453500366210938e+02 -5.9969898223876953e+01 1.3605200195312500e+02 2.4590800476074219e+02 -2.9373600006103516e+01 1.3957600402832031e+02 2.0020100402832031e+02 5.0942001342773438e+01 1.4098399353027344e+02 1.9950700378417969e+02 7.8505599975585938e+01 1.3957800292968750e+02 2.0020199584960938e+02 1.0230000305175781e+02 1.3624400329589844e+02 2.4616700744628906e+02 5.2590198516845703e+01 2.9264199829101562e+02 2.4900199890136719e+02 -2.3319999694824219e+01 2.9123498535156250e+02 2.4969500732421875e+02 6.6349101066589355e+00 2.9264199829101562e+02 2.4900199890136719e+02 3.0526800155639648e+01 1.4401000976562500e+02 2.5050398254394531e+02 5.8514400482177734e+01 1.4247099304199219e+02 2.5019801330566406e+02 4.6641597747802734e+01 1.3939698791503906e+02 2.4897099304199219e+02 -5.9969802856445312e+01 1.3708799743652344e+02 2.4708999633789062e+02 -1.3356300354003906e+01 1.3895599365234375e+02 2.4864498901367188e+02 -1.2914799690246582e+01 1.4557699584960938e+02 2.5060498046875000e+02 7.6262695312500000e+01 2.9844201660156250e+02 2.4095300292968750e+02 4.4407596588134766e+00 2.9742300415039062e+02 2.4394500732421875e+02 1.1596100807189941e+01 2.9778701782226562e+02 2.4320800781250000e+02 6.4847000122070312e+01 1.3826901245117188e+02 2.0107400512695312e+02 -2.5375299453735352e+01 1.3957600402832031e+02 2.0020100402832031e+02 -5.3728698730468750e+01 1.3957600402832031e+02 2.0020100402832031e+02 2.4416298866271973e+00 2.9123498535156250e+02 2.4969500732421875e+02 4.8518898010253906e+01 2.9264199829101562e+02 2.4900199890136719e+02 7.6920997619628906e+01 2.9280001831054688e+02 2.0020599365234375e+02 9.9975700378417969e+01 2.8942901611328125e+02 1.9886300659179688e+02 4.1235500335693359e+01 2.9379598999023438e+02 2.0089801025390625e+02 3.2989101409912109e+01 2.8116799926757812e+02 1.7574598693847656e+02 1.0526599884033203e+02 2.9610601806640625e+02 1.6241200256347656e+02 1.0526599884033203e+02 1.9710000610351562e+02 3.1110000610351562e+02 7.0520500183105469e+01 2.5209999084472656e+02 3.1110000610351562e+02 4.0198602676391602e+00 1.9710000610351562e+02 3.1110000610351562e+02 -4.4480600357055664e+00 1.8028799438476562e+02 2.8678799438476562e+02 1.0526599884033203e+02 1.8028799438476562e+02 2.8678799438476562e+02 1.0230000305175781e+02 2.9537399291992188e+02 2.0234100341796875e+02 -5.9969699859619141e+01 2.9824502563476562e+02 2.0714401245117188e+02 -5.9969200134277344e+01 2.9711199951171875e+02 2.0460000610351562e+02 -5.9332698822021484e+01 2.8169799804687500e+02 2.7328802490234375e+02 1.3955000305175781e+02 2.7608499145507812e+02 2.7922698974609375e+02 1.3304998779296875e+02 2.7249099731445312e+02 2.8250198364257812e+02 1.3955000305175781e+02 2.6763900756835938e+02 2.8611001586914062e+02 1.3304998779296875e+02 2.3421099853515625e+02 2.7655700683593750e+02 1.3304998779296875e+02 2.9465298461914062e+02 2.5038099670410156e+02 1.0526599884033203e+02 2.9307199096679688e+02 2.5432299804687500e+02 1.2900000000000000e+02 2.9649002075195312e+02 2.4478900146484375e+02 1.2900000000000000e+02 3.0603997802734375e+02 2.7076599121093750e+02 1.0526499938964844e+02 2.9958599853515625e+02 2.8163000488281250e+02 1.0526599884033203e+02 2.9044100952148438e+02 2.7456997680664062e+02 1.0526599884033203e+02 2.3265499877929688e+02 1.4999699401855469e+02 1.3304998779296875e+02 2.4584298706054688e+02 1.5256999206542969e+02 1.3304998779296875e+02 3.0038198852539062e+02 2.8049099731445312e+02 1.0230000305175781e+02 2.9610601806640625e+02 2.8678799438476562e+02 1.0526599884033203e+02 2.6147799682617188e+02 2.8953799438476562e+02 1.0230000305175781e+02 2.8664700317382812e+02 2.5060498046875000e+02 1.0230000305175781e+02 2.5209999084472656e+02 2.9396298217773438e+02 1.0230000305175781e+02 1.4557699584960938e+02 1.9859500122070312e+02 -5.9969802856445312e+01 1.7570999145507812e+02 2.8152999877929688e+02 1.3955000305175781e+02 1.4987799072265625e+02 2.3220300292968750e+02 1.3955000305175781e+02 1.4608299255371094e+02 2.7608001708984375e+02 1.0526599884033203e+02 1.5309399414062500e+02 2.8678799438476562e+02 1.0526599884033203e+02 2.0329299926757812e+02 2.9656298828125000e+02 1.3955000305175781e+02 2.1438600158691406e+02 2.9899200439453125e+02 1.3955000305175781e+02 2.0333399963378906e+02 2.9662600708007812e+02 1.3304998779296875e+02 3.0329598999023438e+02 1.7332299804687500e+02 1.0230000305175781e+02 3.0589498901367188e+02 1.7801100158691406e+02 1.0526499938964844e+02 1.3395599365234375e+02 2.4181500244140625e+02 -5.7594200134277344e+01 1.3517999267578125e+02 2.4460099792480469e+02 -1.8744100570678711e+01 2.3902900695800781e+02 1.7368299865722656e+02 1.2900000000000000e+02 2.5209999084472656e+02 1.5523699951171875e+02 1.2900000000000000e+02 2.6639300537109375e+02 1.6262599182128906e+02 1.2900000000000000e+02 2.9268597412109375e+02 1.9405099487304688e+02 1.0615900421142578e+02 2.9504098510742188e+02 1.9980500793457031e+02 1.2900000000000000e+02 1.3500599670410156e+02 1.9842300415039062e+02 1.0526599884033203e+02 1.3477499389648438e+02 1.9939898681640625e+02 1.0230000305175781e+02 1.3919799804687500e+02 1.8684899902343750e+02 1.0230000305175781e+02 1.5853300476074219e+02 1.6241200256347656e+02 1.0230000305175781e+02 1.8028799438476562e+02 1.6241200256347656e+02 1.0230000305175781e+02 2.4075900268554688e+02 1.4110000610351562e+02 -5.0521602630615234e+01 2.5209999084472656e+02 1.4110000610351562e+02 -2.8200000762939453e+01 1.9024099731445312e+02 2.6466101074218750e+02 1.2900000000000000e+02 1.6681100463867188e+02 2.7733700561523438e+02 1.2900000000000000e+02 1.6750100708007812e+02 2.5034001159667969e+02 1.2900000000000000e+02 1.3976199340820312e+02 2.6357400512695312e+02 1.0526499938964844e+02 1.3922299194335938e+02 2.3882099914550781e+02 1.0526599884033203e+02 1.3915100097656250e+02 2.3853099060058594e+02 1.2900000000000000e+02 1.4256300354003906e+02 2.4716299438476562e+02 1.2900000000000000e+02 1.5309399414062500e+02 1.6241200256347656e+02 1.0230000305175781e+02 1.9846600341796875e+02 3.0809899902343750e+02 -3.7242900848388672e+01 2.5142500305175781e+02 3.0809997558593750e+02 -3.5301700592041016e+01 1.9710000610351562e+02 3.0809997558593750e+02 -2.8200000762939453e+01 1.3873300170898438e+02 2.1219700622558594e+02 1.2900000000000000e+02 1.3734400939941406e+02 2.1916400146484375e+02 1.2900000000000000e+02 1.3826699829101562e+02 2.1395500183105469e+02 1.0526599884033203e+02 3.1782400512695312e+02 2.1664599609375000e+02 1.0526599884033203e+02 2.9512100219726562e+02 2.0013299560546875e+02 1.0526499938964844e+02 3.1402700805664062e+02 1.9768400573730469e+02 1.0526599884033203e+02 2.8136700439453125e+02 1.7590299987792969e+02 1.2900000000000000e+02 2.7288601684570312e+02 1.6743800354003906e+02 1.0526599884033203e+02 2.0844100952148438e+02 1.3809999084472656e+02 -5.0521602630615234e+01 1.5099899291992188e+02 1.8836499023437500e+02 1.2900000000000000e+02 1.5566900634765625e+02 1.8274598693847656e+02 1.2900000000000000e+02 1.7562599182128906e+02 2.0497700500488281e+02 1.2900000000000000e+02 2.9703701782226562e+02 2.4473999023437500e+02 -5.6779602050781250e+01 2.9418298339843750e+02 2.4803399658203125e+02 -5.5256900787353516e+01 2.9490100097656250e+02 2.4738099670410156e+02 -5.0245699882507324e+00 1.3526399230957031e+02 2.5159400939941406e+02 1.0526599884033203e+02 1.3131399536132812e+02 2.3227598571777344e+02 1.0526499938964844e+02 3.1815100097656250e+02 2.2701499938964844e+02 1.0230000305175781e+02 3.1764001464843750e+02 2.3312098693847656e+02 1.0526499938964844e+02 2.2460000610351562e+02 1.4960000610351562e+02 1.3304998779296875e+02 2.2460000610351562e+02 1.4960000610351562e+02 1.3955000305175781e+02 1.5775000000000000e+02 1.9044999694824219e+02 1.3955000305175781e+02 1.5778799438476562e+02 1.9013500976562500e+02 1.3304998779296875e+02 1.3357701110839844e+02 2.3860499572753906e+02 3.6371799468994141e+01 1.3377999877929688e+02 2.4094900512695312e+02 6.8863502502441406e+01 1.3396400451660156e+02 2.4183300781250000e+02 2.6833299636840820e+01 2.4668400573730469e+02 3.0809997558593750e+02 -4.4711601257324219e+01 2.3904600524902344e+02 3.0809997558593750e+02 -5.1552700042724609e+01 1.8644200134277344e+02 1.5993499755859375e+02 1.3304998779296875e+02 1.4557699584960938e+02 2.5060498046875000e+02 3.4281200408935547e+01 2.9864697265625000e+02 2.1059500122070312e+02 7.4117301940917969e+01 2.9782199096679688e+02 2.0600399780273438e+02 3.4616500854492188e+01 2.8664700317382812e+02 2.5060498046875000e+02 4.6495399475097656e+01 2.8821200561523438e+02 2.5050398254394531e+02 7.6994102478027344e+01 2.8975000000000000e+02 2.5019898986816406e+02 7.7262298583984375e+01 1.3398300170898438e+02 2.0749099731445312e+02 1.0073999786376953e+02 1.3448699951171875e+02 2.0600601196289062e+02 7.5190002441406250e+01 2.8664700317382812e+02 2.5060498046875000e+02 -1.6379301071166992e+01 1.3357701110839844e+02 2.1059500122070312e+02 1.6008800506591797e+01 1.3357199096679688e+02 2.3860499572753906e+02 -1.9097600936889648e+01 1.9756900024414062e+02 1.7929100036621094e+02 1.2900000000000000e+02 1.9400100708007812e+02 1.8166000366210938e+02 1.3304998779296875e+02 1.8794900512695312e+02 1.8660299682617188e+02 1.2900000000000000e+02 2.1553898620605469e+02 1.5006900024414062e+02 1.3955000305175781e+02 1.9994099426269531e+02 3.1110000610351562e+02 -4.0683502197265625e+01 2.0565399169921875e+02 3.0809899902343750e+02 -4.8183097839355469e+01 1.3357701110839844e+02 2.3860499572753906e+02 -5.9969802856445312e+01 1.4923500061035156e+02 2.2387500000000000e+02 -5.9969802856445312e+01 1.4327398681640625e+02 2.4867599487304688e+02 1.0526499938964844e+02 1.8028799438476562e+02 1.6241200256347656e+02 1.0526599884033203e+02 1.3357701110839844e+02 2.1059500122070312e+02 -5.9969802856445312e+01 1.3440899658203125e+02 2.0587599182128906e+02 -5.9969997406005859e+01 1.3357701110839844e+02 2.1059500122070312e+02 -3.5175899505615234e+01 2.9744000244140625e+02 2.4128800964355469e+02 1.0526599884033203e+02 1.9710000610351562e+02 3.0809997558593750e+02 3.3263198852539062e+01 2.5209999084472656e+02 3.0809997558593750e+02 -2.8200000762939453e+01 1.4318899536132812e+02 1.9880700683593750e+02 1.0037599945068359e+02 1.4557699584960938e+02 1.9859500122070312e+02 1.0230000305175781e+02 1.4098899841308594e+02 1.9950898742675781e+02 1.0230000305175781e+02 1.8041000366210938e+02 2.5337400817871094e+02 1.2900000000000000e+02 1.7478799438476562e+02 2.4181500244140625e+02 1.2900000000000000e+02 2.2460000610351562e+02 2.9960000610351562e+02 1.3304998779296875e+02 2.3610099792480469e+02 2.9884100341796875e+02 1.3955000305175781e+02 2.3293499755859375e+02 2.9922198486328125e+02 1.3304998779296875e+02 2.9869699096679688e+02 2.1286801147460938e+02 1.3955000305175781e+02 2.9907598876953125e+02 2.3420899963378906e+02 1.3955000305175781e+02 3.1489700317382812e+02 2.4845098876953125e+02 1.0230000305175781e+02 1.7183099365234375e+02 2.2337100219726562e+02 1.3304998779296875e+02 1.7183200073242188e+02 2.2460000610351562e+02 1.2900000000000000e+02 1.7263999938964844e+02 2.1541699218750000e+02 1.2900000000000000e+02 2.6605001831054688e+02 2.5710601806640625e+02 1.2900000000000000e+02 2.9861300659179688e+02 2.3502198791503906e+02 1.2900000000000000e+02 2.5209999084472656e+02 1.3809999084472656e+02 1.2900000000000000e+02 2.5209999084472656e+02 1.5523699951171875e+02 1.0230000305175781e+02 2.7039999389648438e+02 1.6514199829101562e+02 1.3955000305175781e+02 2.5811099243164062e+02 1.5735900878906250e+02 1.3955000305175781e+02 2.6037298583984375e+02 1.5858300781250000e+02 1.3304998779296875e+02 1.9710000610351562e+02 3.1110000610351562e+02 -2.8200000762939453e+01 2.8664700317382812e+02 1.9859500122070312e+02 4.8323799133300781e+01 2.8664700317382812e+02 1.9859400939941406e+02 -1.1485099792480469e+01 1.8070599365234375e+02 1.9552099609375000e+02 1.2900000000000000e+02 1.7005999755859375e+02 1.6929598999023438e+02 1.2900000000000000e+02 2.3843600463867188e+02 2.7563800048828125e+02 1.2900000000000000e+02 2.2460000610351562e+02 2.7727999877929688e+02 1.2900000000000000e+02 2.7411599731445312e+02 2.8053298950195312e+02 1.2900000000000000e+02 2.6835098266601562e+02 2.8514599609375000e+02 1.2900000000000000e+02 2.5306901550292969e+02 2.7775897216796875e+02 1.2900000000000000e+02 1.7326599121093750e+02 2.1254899597167969e+02 1.3304998779296875e+02 1.5291200256347656e+02 2.0236199951171875e+02 1.3304998779296875e+02 2.5209999084472656e+02 3.1110000610351562e+02 4.8852600097656250e+01 2.1570800781250000e+02 1.5007199096679688e+02 1.3304998779296875e+02 2.0256500244140625e+02 1.5273599243164062e+02 1.3304998779296875e+02 2.1015399169921875e+02 3.1110000610351562e+02 -5.1552700042724609e+01 2.0447200012207031e+02 3.1110000610351562e+02 -4.6919902801513672e+01 1.5073699951171875e+02 2.1146899414062500e+02 1.3304998779296875e+02 2.9652899169921875e+02 2.4630400085449219e+02 1.3304998779296875e+02 2.7405300903320312e+02 2.4283799743652344e+02 1.3304998779296875e+02 2.6901800537109375e+02 2.5320300292968750e+02 1.3304998779296875e+02 2.3209600830078125e+02 1.4991600036621094e+02 1.3955000305175781e+02 2.6312301635742188e+02 1.6067098999023438e+02 1.0764700317382812e+02 2.5779101562500000e+02 1.5768699645996094e+02 1.0230000305175781e+02 2.6589901733398438e+02 1.6241200256347656e+02 1.0230000305175781e+02 2.2460000610351562e+02 2.9960000610351562e+02 1.3955000305175781e+02 1.4963099670410156e+02 2.2112500000000000e+02 1.3304998779296875e+02 1.4979701232910156e+02 2.1820100402832031e+02 1.3955000305175781e+02 2.5209999084472656e+02 1.4110000610351562e+02 1.0230000305175781e+02 2.5209999084472656e+02 1.3809999084472656e+02 6.0071498870849609e+01 1.5450799560546875e+02 1.8389299011230469e+02 1.0526599884033203e+02 1.4160198974609375e+02 1.8145700073242188e+02 1.0526599884033203e+02 2.1649000549316406e+02 3.0809997558593750e+02 -5.4577102661132812e+01 3.1553302001953125e+02 2.4586399841308594e+02 1.0526499938964844e+02 1.8995300292968750e+02 1.5738800048828125e+02 1.2900000000000000e+02 3.0832897949218750e+02 2.6610800170898438e+02 1.0230000305175781e+02 2.6589901733398438e+02 1.6241200256347656e+02 1.0526599884033203e+02 3.1113601684570312e+02 2.5943600463867188e+02 1.0526599884033203e+02 1.6152200317382812e+02 2.6523199462890625e+02 1.3955000305175781e+02 1.5676400756835938e+02 2.5667797851562500e+02 1.3955000305175781e+02 1.7967599487304688e+02 1.6272300720214844e+02 1.2900000000000000e+02 1.7568099975585938e+02 1.6526899719238281e+02 1.0526499938964844e+02 1.6472099304199219e+02 1.7366999816894531e+02 1.0526599884033203e+02 1.4557699584960938e+02 1.9859500122070312e+02 5.6637203216552734e+01 2.2284899902343750e+02 2.5060498046875000e+02 1.0230000305175781e+02 1.4279800415039062e+02 2.0137800598144531e+02 1.2900000000000000e+02 1.4629598999023438e+02 1.9522399902343750e+02 1.0526499938964844e+02 2.5209999084472656e+02 1.3809999084472656e+02 -2.8200000762939453e+01 2.5209999084472656e+02 1.3809999084472656e+02 6.6848897933959961e+00 1.5219700622558594e+02 2.0452700805664062e+02 1.3955000305175781e+02 2.4951100158691406e+02 1.3809999084472656e+02 -4.0130100250244141e+01 2.3811499023437500e+02 1.3809999084472656e+02 -5.2161602020263672e+01 2.7734597778320312e+02 2.2069898986816406e+02 1.3304998779296875e+02 2.9570599365234375e+02 2.0050900268554688e+02 1.3304998779296875e+02 2.7431698608398438e+02 2.0686399841308594e+02 1.3304998779296875e+02 2.9855200195312500e+02 2.0905099487304688e+02 9.8952499389648438e+01 1.4419700622558594e+02 1.7660998535156250e+02 1.0230000305175781e+02 2.9960998535156250e+02 2.2176300048828125e+02 1.3955000305175781e+02 2.9927798461914062e+02 2.3243499755859375e+02 1.3304998779296875e+02 1.6753900146484375e+02 2.7333898925781250e+02 1.3955000305175781e+02 1.6169898986816406e+02 2.6566500854492188e+02 1.3304998779296875e+02 2.9578598022460938e+02 2.0278100585937500e+02 9.9576896667480469e+01 1.6680000305175781e+02 2.8678799438476562e+02 1.0526599884033203e+02 1.7321200561523438e+02 2.3662699890136719e+02 1.3304998779296875e+02 2.5579801940917969e+02 2.9240200805664062e+02 1.2900000000000000e+02 2.5209999084472656e+02 2.9396298217773438e+02 1.2900000000000000e+02 2.7987399291992188e+02 2.7495001220703125e+02 1.0526599884033203e+02 2.8616601562500000e+02 2.6683898925781250e+02 1.0526599884033203e+02 1.3711399841308594e+02 2.2145100402832031e+02 1.0526599884033203e+02 2.4758100891113281e+02 2.9605401611328125e+02 1.3955000305175781e+02 2.9628100585937500e+02 2.4583999633789062e+02 4.9794101715087891e+01 2.8899197387695312e+02 1.9879800415039062e+02 -4.6152801513671875e+01 2.9864697265625000e+02 2.1059500122070312e+02 -5.9969802856445312e+01 2.9864697265625000e+02 2.3860499572753906e+02 1.0230000305175781e+02 2.9864697265625000e+02 2.3860499572753906e+02 7.5970199584960938e+01 1.4557699584960938e+02 2.5060498046875000e+02 -1.6964399337768555e+01 1.4247099304199219e+02 2.5019801330566406e+02 -5.8409500122070312e+01 1.3827900695800781e+02 2.0106199645996094e+02 -5.6251296997070312e+01 1.3875498962402344e+02 2.0066999816894531e+02 -5.9969802856445312e+01 2.9710198974609375e+02 2.0459500122070312e+02 6.6583404541015625e+01 2.9823898315429688e+02 2.0748800659179688e+02 7.0289703369140625e+01 1.3495799255371094e+02 2.0496299743652344e+02 1.0230100250244141e+02 1.3517999267578125e+02 2.0459899902343750e+02 4.8860198974609375e+01 1.4252699279785156e+02 1.9893299865722656e+02 9.7371997833251953e+00 1.3398300170898438e+02 2.0749099731445312e+02 -2.7545099258422852e+01 1.3388600158691406e+02 2.4160798645019531e+02 -1.4892200469970703e+01 1.3556799316406250e+02 2.4527400207519531e+02 2.2798498153686523e+01 1.3479800415039062e+02 2.0525900268554688e+02 1.4838599205017090e+01 1.4098399353027344e+02 2.4969300842285156e+02 2.7942600250244141e+01 2.9823898315429688e+02 2.0748800659179688e+02 -3.9637302398681641e+01 1.3732600402832031e+02 2.0186500549316406e+02 1.0230000305175781e+02 1.9710000610351562e+02 1.3809999084472656e+02 6.7655197143554688e+01 1.9710000610351562e+02 1.4110000610351562e+02 3.0641500473022461e+01 1.9710000610351562e+02 1.3809999084472656e+02 -2.8200000762939453e+01 2.6589901733398438e+02 2.8678799438476562e+02 1.0526599884033203e+02 1.9710000610351562e+02 1.4110000610351562e+02 -2.8200000762939453e+01 1.3625300598144531e+02 2.5462200927734375e+02 1.0230000305175781e+02 1.3335501098632812e+02 2.0518699645996094e+02 1.0230000305175781e+02 1.3172599792480469e+02 2.1399299621582031e+02 1.0230000305175781e+02 2.9474600219726562e+02 2.4756300354003906e+02 1.0230000305175781e+02 2.9122998046875000e+02 2.4969300842285156e+02 1.0230000305175781e+02 1.3503999328613281e+02 2.0472599792480469e+02 -2.9775800704956055e+01 1.3569299316406250e+02 2.0373300170898438e+02 -5.6444297790527344e+01 1.7152301025390625e+02 2.8103799438476562e+02 1.0526599884033203e+02 1.4907400512695312e+02 2.5818399047851562e+02 1.0526499938964844e+02 2.9864697265625000e+02 2.1059500122070312e+02 9.6058898925781250e+01 1.9710000610351562e+02 2.9460998535156250e+02 1.2900000000000000e+02 1.9710000610351562e+02 1.4110000610351562e+02 1.0230000305175781e+02 1.4120599365234375e+02 2.0489199829101562e+02 1.0526599884033203e+02 2.9019900512695312e+02 2.6027700805664062e+02 1.0526599884033203e+02 2.8852001953125000e+02 2.6333099365234375e+02 1.2900000000000000e+02 2.5209999084472656e+02 3.0809997558593750e+02 3.3724399566650391e+01 2.5209999084472656e+02 3.0809997558593750e+02 1.0230000305175781e+02 2.7383200073242188e+02 2.0561599731445312e+02 1.2900000000000000e+02 2.7957598876953125e+02 1.8719599914550781e+02 1.2900000000000000e+02 1.9710000610351562e+02 1.3809999084472656e+02 1.2900000000000000e+02 2.9720700073242188e+02 2.0718099975585938e+02 1.0526599884033203e+02 1.9979000854492188e+02 1.4110000610351562e+02 -4.0305999755859375e+01 1.9807000732421875e+02 1.3809999084472656e+02 -3.5835197448730469e+01 1.9743099975585938e+02 1.4110000610351562e+02 -3.2848102569580078e+01 2.3736700439453125e+02 3.1110000610351562e+02 -5.2639400482177734e+01 2.9864697265625000e+02 2.3860499572753906e+02 -5.9969802856445312e+01 1.3168099975585938e+02 2.1450500488281250e+02 1.0526499938964844e+02 2.7409399414062500e+02 1.6864700317382812e+02 1.2900000000000000e+02 2.5115200805664062e+02 1.7894999694824219e+02 1.2900000000000000e+02 1.8046000671386719e+02 2.7767898559570312e+02 1.0230000305175781e+02 2.9610601806640625e+02 1.6241200256347656e+02 1.0230000305175781e+02 2.8583300781250000e+02 2.6815097045898438e+02 1.3304998779296875e+02 2.7653698730468750e+02 2.1527500915527344e+02 1.2900000000000000e+02 2.7736801147460938e+02 2.2460000610351562e+02 1.2900000000000000e+02 2.9672198486328125e+02 2.0361000061035156e+02 1.3955000305175781e+02 1.5493998718261719e+02 2.6562399291992188e+02 1.0526499938964844e+02 2.8664700317382812e+02 2.5060498046875000e+02 1.8190799713134766e+01 2.7342401123046875e+02 2.8117001342773438e+02 1.0526599884033203e+02 1.6157099914550781e+02 2.7258801269531250e+02 1.0526599884033203e+02 1.5872200012207031e+02 2.6973699951171875e+02 1.2900000000000000e+02 1.8820098876953125e+02 1.5814700317382812e+02 1.0230000305175781e+02 1.7218800354003906e+02 2.3110299682617188e+02 1.2900000000000000e+02 2.7005197143554688e+02 1.9782400512695312e+02 1.3304998779296875e+02 2.6845498657226562e+02 1.9544699096679688e+02 1.2900000000000000e+02 2.9926998901367188e+02 2.2841600036621094e+02 1.0526599884033203e+02 2.9904898071289062e+02 2.1797200012207031e+02 1.0526599884033203e+02 2.4791600036621094e+02 1.4110000610351562e+02 -4.2833202362060547e+01 2.5867501831054688e+02 2.6489599609375000e+02 1.2900000000000000e+02 2.8079598999023438e+02 2.7390301513671875e+02 1.2900000000000000e+02 1.9052700805664062e+02 2.6484500122070312e+02 1.3304998779296875e+02 2.1260699462890625e+02 2.7596899414062500e+02 1.3304998779296875e+02 2.1548100280761719e+02 2.9913198852539062e+02 1.3304998779296875e+02 1.7942399597167969e+02 2.8632598876953125e+02 1.2900000000000000e+02 1.8971000671386719e+02 2.9172097778320312e+02 1.2900000000000000e+02 1.5330999755859375e+02 2.6371301269531250e+02 1.2900000000000000e+02 1.9372000122070312e+02 2.9297198486328125e+02 1.3304998779296875e+02 2.2460000610351562e+02 1.7191999816894531e+02 1.2900000000000000e+02 2.1852900695800781e+02 1.7220599365234375e+02 1.2900000000000000e+02 2.7646899414062500e+02 2.3429701232910156e+02 1.3304998779296875e+02 1.7781401062011719e+02 1.9997698974609375e+02 1.3304998779296875e+02 1.8584300231933594e+02 1.8878099060058594e+02 1.3304998779296875e+02 2.2460000610351562e+02 2.7727999877929688e+02 1.3304998779296875e+02 2.9613598632812500e+02 2.0315499877929688e+02 -2.8803701400756836e+01 2.9336801147460938e+02 2.0062098693847656e+02 -2.5463699340820312e+01 2.5990301513671875e+02 2.6385800170898438e+02 1.3304998779296875e+02 2.4913699340820312e+02 2.7139498901367188e+02 1.3304998779296875e+02 2.9085000610351562e+02 1.9931599426269531e+02 -1.0737000465393066e+01 2.5209999084472656e+02 1.4110000610351562e+02 5.9928802490234375e+01 2.7216799926757812e+02 2.4728700256347656e+02 1.2900000000000000e+02 2.9787200927734375e+02 2.4298199462890625e+02 1.0230200195312500e+02 2.9310797119140625e+02 2.0045599365234375e+02 -5.2422698974609375e+01 2.9394900512695312e+02 2.4812998962402344e+02 5.2651199340820312e+01 2.9772799682617188e+02 2.4347200012207031e+02 -5.9969898223876953e+01 1.3708799743652344e+02 2.4708999633789062e+02 3.2074897766113281e+01 1.3605200195312500e+02 2.4590800476074219e+02 3.9531700611114502e+00 1.3481800842285156e+02 2.4398001098632812e+02 5.3571498870849609e+01 1.3708799743652344e+02 2.0211000061035156e+02 -1.9134199142456055e+01 1.3605200195312500e+02 2.0329199218750000e+02 -1.5331000328063965e+01 1.4098399353027344e+02 2.4969300842285156e+02 -3.0812000274658203e+01 1.4247099304199219e+02 2.5019801330566406e+02 -6.3017100095748901e-01 2.8975000000000000e+02 2.5019898986816406e+02 5.3029102325439453e+01 1.3661601257324219e+02 2.0257499694824219e+02 1.3570899963378906e+01 2.9854598999023438e+02 2.4017199707031250e+02 5.6193798065185547e+01 2.9823898315429688e+02 2.4171200561523438e+02 7.7798599243164062e+01 1.3712200927734375e+02 2.0207199096679688e+02 -5.5226299285888672e+01 2.8899099731445312e+02 1.9879800415039062e+02 7.4531799316406250e+01 2.8664700317382812e+02 1.9859500122070312e+02 1.0230000305175781e+02 1.4098399353027344e+02 2.4969300842285156e+02 2.2100400924682617e+00 1.3469099426269531e+02 2.4372700500488281e+02 9.9347999572753906e+01 1.4098399353027344e+02 1.9950700378417969e+02 3.1258199691772461e+01 1.4323001098632812e+02 1.9879899597167969e+02 5.7319896697998047e+01 2.8975000000000000e+02 2.5019898986816406e+02 -1.2929599761962891e+01 2.8975000000000000e+02 2.5019898986816406e+02 2.4188098907470703e+01 2.9123498535156250e+02 2.4969500732421875e+02 3.9644699096679688e+01 1.5102099609375000e+02 2.3938999938964844e+02 1.3304998779296875e+02 1.5259001159667969e+02 2.4588101196289062e+02 1.3955000305175781e+02 1.5463400268554688e+02 2.5200302124023438e+02 1.3304998779296875e+02 1.7339498901367188e+02 1.6960800170898438e+02 1.3304998779296875e+02 2.1661199951171875e+02 3.1110000610351562e+02 -5.4595897674560547e+01 2.2325199890136719e+02 3.0810101318359375e+02 -5.5724899291992188e+01 1.6186199951171875e+02 1.7632701110839844e+02 1.2900000000000000e+02 1.4721499633789062e+02 2.5544500732421875e+02 1.2900000000000000e+02 2.9952899169921875e+02 2.2040100097656250e+02 1.3304998779296875e+02 2.9821597290039062e+02 2.0992199707031250e+02 1.3304998779296875e+02 2.2460000610351562e+02 1.7191999816894531e+02 1.3304998779296875e+02 2.2794699096679688e+02 3.1110000610351562e+02 -5.5608501434326172e+01 2.3258799743652344e+02 3.0809997558593750e+02 -5.4595897674560547e+01 2.8195397949218750e+02 1.7620899963378906e+02 1.3304998779296875e+02 2.7096301269531250e+02 1.6545899963378906e+02 1.3304998779296875e+02 2.5526600646972656e+02 1.8166999816894531e+02 1.3304998779296875e+02 2.4900401306152344e+02 2.7142398071289062e+02 1.2900000000000000e+02 1.9710000610351562e+02 1.5458999633789062e+02 1.2900000000000000e+02 1.3756098937988281e+02 2.3153799438476562e+02 1.2899899291992188e+02 1.3357701110839844e+02 2.1059500122070312e+02 1.0230000305175781e+02 1.3734201049804688e+02 2.2996699523925781e+02 1.0526599884033203e+02 1.3703900146484375e+02 2.2477799987792969e+02 1.2900000000000000e+02 2.9777301025390625e+02 2.0969499206542969e+02 1.2900000000000000e+02 2.9842697143554688e+02 2.1327101135253906e+02 1.2113300323486328e+02 2.9930300903320312e+02 2.2133200073242188e+02 1.2900000000000000e+02 1.9333299255371094e+02 1.6258500671386719e+02 1.0230000305175781e+02 1.9710000610351562e+02 3.1110000610351562e+02 1.2900000000000000e+02 2.8951901245117188e+02 1.8680400085449219e+02 1.3304998779296875e+02 2.5841400146484375e+02 1.6510499572753906e+02 1.0230000305175781e+02 2.9802200317382812e+02 2.0668899536132812e+02 3.0843800306320190e-01 2.0461300659179688e+02 1.4110000610351562e+02 -4.7107498168945312e+01 1.9941400146484375e+02 2.7104397583007812e+02 1.3304998779296875e+02 1.9710000610351562e+02 3.0809997558593750e+02 1.0230000305175781e+02 2.7598101806640625e+02 2.3656100463867188e+02 1.2900000000000000e+02 2.9610601806640625e+02 2.8678799438476562e+02 1.0230000305175781e+02 2.9006500244140625e+02 2.8678799438476562e+02 1.0230000305175781e+02 2.9501000976562500e+02 2.5097599792480469e+02 1.3955000305175781e+02 2.9176800537109375e+02 2.5805300903320312e+02 1.3304998779296875e+02 2.6477301025390625e+02 1.9037699890136719e+02 1.3304998779296875e+02 1.6498799133300781e+02 1.7896400451660156e+02 1.3304998779296875e+02 2.5113400268554688e+02 1.4110000610351562e+02 -3.5868499755859375e+01 2.5209999084472656e+02 3.1110000610351562e+02 1.2900000000000000e+02 2.6063299560546875e+02 1.8605999755859375e+02 1.2900000000000000e+02 1.3556100463867188e+02 2.4560398864746094e+02 1.0230000305175781e+02 2.9864697265625000e+02 2.3860499572753906e+02 3.7548099517822266e+01 2.1934500122070312e+02 2.7706399536132812e+02 1.2900000000000000e+02 2.6589901733398438e+02 2.8678799438476562e+02 1.0230000305175781e+02 2.0792900085449219e+02 1.7429800415039062e+02 1.2900000000000000e+02 2.0652200317382812e+02 1.7492500305175781e+02 1.3304998779296875e+02 2.3538699340820312e+02 1.7285400390625000e+02 1.3304998779296875e+02 2.4668000793457031e+02 1.7673901367187500e+02 1.3304998779296875e+02 2.0340100097656250e+02 1.5258399963378906e+02 1.3955000305175781e+02 1.9710000610351562e+02 1.5458999633789062e+02 1.0230000305175781e+02 2.1063000488281250e+02 1.4110000610351562e+02 -5.1869602203369141e+01 2.0934899902343750e+02 2.7518902587890625e+02 1.2900000000000000e+02 1.9981799316406250e+02 2.7125299072265625e+02 1.2900000000000000e+02 1.9738101196289062e+02 3.1110000610351562e+02 -3.2403598785400391e+01 2.6235800170898438e+02 2.8899401855468750e+02 1.2900000000000000e+02 1.4971099853515625e+02 2.2930300903320312e+02 1.3304998779296875e+02 2.4458700561523438e+02 1.3809999084472656e+02 -4.7107498168945312e+01 2.9598001098632812e+02 2.0296299743652344e+02 1.8911499023437500e+01 1.3605200195312500e+02 2.0329199218750000e+02 3.8815799713134766e+01 1.3605200195312500e+02 2.0329199218750000e+02 7.5726394653320312e+01 1.3826901245117188e+02 2.0107400512695312e+02 -2.7268099784851074e+00 1.4401000976562500e+02 2.5050398254394531e+02 6.1473302841186523e+00 1.4401000976562500e+02 2.5050398254394531e+02 2.9441900253295898e+01 1.3357701110839844e+02 2.1059500122070312e+02 4.6775699615478516e+01 2.0128401184082031e+02 1.3809999084472656e+02 -4.2833202362060547e+01 2.5176901245117188e+02 1.3809999084472656e+02 -3.2848102569580078e+01 )) mat)))
                  )
                 ))
      (send glv :transform local-cds)
      (send glv :calc-normals)
      (setq qhull
            ;; qhull 3000 -> 55 faces
            (instance faceset :init :faces (list
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3440899550914764e+02 2.0587599277496338e+02 -5.9969998896121979e+01) (float-vector 1.3508500158786774e+02 2.4453499913215637e+02 -5.9969898313283920e+01) (float-vector 1.3131399452686310e+02 2.3227599263191223e+02 1.0526499897241592e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1113600730895996e+02 2.5943601131439209e+02 1.0526599735021591e+02) (float-vector 2.9864698648452759e+02 2.3860499262809753e+02 -5.9969801455736160e+01) (float-vector 3.1815099716186523e+02 2.2701500356197357e+02 1.0230000317096710e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1113600730895996e+02 2.5943601131439209e+02 1.0526599735021591e+02) (float-vector 2.9610601067543030e+02 2.8678798675537109e+02 1.0230000317096710e+02) (float-vector 2.9255101084709167e+02 2.4914300441741943e+02 -5.9970799833536148e+01) (float-vector 2.9864698648452759e+02 2.3860499262809753e+02 -5.9969801455736160e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.9709999859333038e+02 1.3809999823570251e+02 1.2899999320507050e+02) (float-vector 1.9709999859333038e+02 1.3809999823570251e+02 -2.8200000524520874e+01) (float-vector 1.5309399366378784e+02 1.6241200268268585e+02 1.0526599735021591e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3508500158786774e+02 2.4453499913215637e+02 -5.9969898313283920e+01) (float-vector 1.3976199924945831e+02 2.6357400417327881e+02 1.0526499897241592e+02) (float-vector 1.3131399452686310e+02 2.3227599263191223e+02 1.0526499897241592e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.5309399366378784e+02 2.8678798675537109e+02 1.0526599735021591e+02) (float-vector 1.3976199924945831e+02 2.6357400417327881e+02 1.0526499897241592e+02) (float-vector 1.3508500158786774e+02 2.4453499913215637e+02 -5.9969898313283920e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3500599563121796e+02 1.9842299818992615e+02 1.0526599735021591e+02) (float-vector 1.3440899550914764e+02 2.0587599277496338e+02 -5.9969998896121979e+01) (float-vector 1.3131399452686310e+02 2.3227599263191223e+02 1.0526499897241592e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3440899550914764e+02 2.0587599277496338e+02 -5.9969998896121979e+01) (float-vector 1.3500599563121796e+02 1.9842299818992615e+02 1.0526599735021591e+02) (float-vector 1.5309399366378784e+02 1.6241200268268585e+02 1.0526599735021591e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.9610601067543030e+02 2.8678798675537109e+02 1.0230000317096710e+02) (float-vector 2.5044301152229309e+02 3.1110098958015442e+02 -3.8267400115728378e+01) (float-vector 2.9255101084709167e+02 2.4914300441741943e+02 -5.9970799833536148e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.5044301152229309e+02 3.1110098958015442e+02 -3.8267400115728378e+01) (float-vector 2.3736700415611267e+02 3.1110000610351562e+02 -5.2639398723840714e+01) (float-vector 2.9255101084709167e+02 2.4914300441741943e+02 -5.9970799833536148e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.9738100469112396e+02 3.1110000610351562e+02 -3.2403599470853806e+01) (float-vector 1.5309399366378784e+02 2.8678798675537109e+02 1.0526599735021591e+02) (float-vector 1.3508500158786774e+02 2.4453499913215637e+02 -5.9969898313283920e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3440899550914764e+02 2.0587599277496338e+02 -5.9969998896121979e+01) (float-vector 2.0128400623798370e+02 1.3809999823570251e+02 -4.2833201587200165e+01) (float-vector 2.0844100415706635e+02 1.3809999823570251e+02 -5.0521600991487503e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3440899550914764e+02 2.0587599277496338e+02 -5.9969998896121979e+01) (float-vector 1.5309399366378784e+02 1.6241200268268585e+02 1.0526599735021591e+02) (float-vector 1.9709999859333038e+02 1.3809999823570251e+02 -2.8200000524520874e+01) (float-vector 2.0128400623798370e+02 1.3809999823570251e+02 -4.2833201587200165e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.0340099930763245e+02 1.5258400142192841e+02 1.3955000042915344e+02) (float-vector 2.2460000216960907e+02 1.4959999918937683e+02 1.3955000042915344e+02) (float-vector 2.5209999084472656e+02 1.3809999823570251e+02 1.2899999320507050e+02) (float-vector 1.9709999859333038e+02 1.3809999823570251e+02 1.2899999320507050e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3440899550914764e+02 2.0587599277496338e+02 -5.9969998896121979e+01) (float-vector 2.9537400603294373e+02 2.0234100520610809e+02 -5.9969700872898102e+01) (float-vector 2.9864698648452759e+02 2.1059499680995941e+02 -5.9969801455736160e+01) (float-vector 2.9864698648452759e+02 2.3860499262809753e+02 -5.9969801455736160e+01) (float-vector 2.9255101084709167e+02 2.4914300441741943e+02 -5.9970799833536148e+01) (float-vector 1.3508500158786774e+02 2.4453499913215637e+02 -5.9969898313283920e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.9864698648452759e+02 2.1059499680995941e+02 -5.9969801455736160e+01) (float-vector 2.9537400603294373e+02 2.0234100520610809e+02 -5.9969700872898102e+01) (float-vector 3.0589500069618225e+02 1.7801100015640259e+02 1.0526499897241592e+02) (float-vector 3.1669801473617554e+02 2.0908200740814209e+02 1.0230000317096710e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1669801473617554e+02 2.0908200740814209e+02 1.0230000317096710e+02) (float-vector 3.1815099716186523e+02 2.2701500356197357e+02 1.0230000317096710e+02) (float-vector 2.9864698648452759e+02 2.3860499262809753e+02 -5.9969801455736160e+01) (float-vector 2.9864698648452759e+02 2.1059499680995941e+02 -5.9969801455736160e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.2460000216960907e+02 1.4959999918937683e+02 1.3955000042915344e+02) (float-vector 2.5811100006103516e+02 1.5735900402069092e+02 1.3955000042915344e+02) (float-vector 2.5209999084472656e+02 1.3809999823570251e+02 1.2899999320507050e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1815099716186523e+02 2.2701500356197357e+02 1.0230000317096710e+02) (float-vector 3.1669801473617554e+02 2.0908200740814209e+02 1.0230000317096710e+02) (float-vector 2.9672199487686157e+02 2.0361000299453735e+02 1.3955000042915344e+02) (float-vector 2.9960998892784119e+02 2.2176299989223480e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.8716799616813660e+02 1.8310000002384186e+02 1.3955000042915344e+02) (float-vector 2.9672199487686157e+02 2.0361000299453735e+02 1.3955000042915344e+02) (float-vector 3.1669801473617554e+02 2.0908200740814209e+02 1.0230000317096710e+02) (float-vector 3.0589500069618225e+02 1.7801100015640259e+02 1.0526499897241592e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.9610601067543030e+02 1.6241200268268585e+02 1.0230000317096710e+02) (float-vector 2.5176900625228882e+02 1.3809999823570251e+02 -3.2848101109266281e+01) (float-vector 2.5209999084472656e+02 1.3809999823570251e+02 1.2899999320507050e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.9537400603294373e+02 2.0234100520610809e+02 -5.9969700872898102e+01) (float-vector 2.5176900625228882e+02 1.3809999823570251e+02 -3.2848101109266281e+01) (float-vector 2.9610601067543030e+02 1.6241200268268585e+02 1.0230000317096710e+02) (float-vector 3.0589500069618225e+02 1.7801100015640259e+02 1.0526499897241592e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.5209999084472656e+02 1.3809999823570251e+02 1.2899999320507050e+02) (float-vector 2.5811100006103516e+02 1.5735900402069092e+02 1.3955000042915344e+02) (float-vector 2.8716799616813660e+02 1.8310000002384186e+02 1.3955000042915344e+02) (float-vector 3.0589500069618225e+02 1.7801100015640259e+02 1.0526499897241592e+02) (float-vector 2.9610601067543030e+02 1.6241200268268585e+02 1.0230000317096710e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.3811499774456024e+02 1.3809999823570251e+02 -5.2161600440740585e+01) (float-vector 2.5176900625228882e+02 1.3809999823570251e+02 -3.2848101109266281e+01) (float-vector 2.9537400603294373e+02 2.0234100520610809e+02 -5.9969700872898102e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.5209999084472656e+02 3.1110000610351562e+02 1.2899999320507050e+02) (float-vector 2.5044301152229309e+02 3.1110098958015442e+02 -3.8267400115728378e+01) (float-vector 2.9610601067543030e+02 2.8678798675537109e+02 1.0230000317096710e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.8169798851013184e+02 2.7328801155090332e+02 1.3955000042915344e+02) (float-vector 2.5209999084472656e+02 3.1110000610351562e+02 1.2899999320507050e+02) (float-vector 2.9610601067543030e+02 2.8678798675537109e+02 1.0230000317096710e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.1015399694442749e+02 3.1110000610351562e+02 -5.1552701741456985e+01) (float-vector 1.9738100469112396e+02 3.1110000610351562e+02 -3.2403599470853806e+01) (float-vector 1.3508500158786774e+02 2.4453499913215637e+02 -5.9969898313283920e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.9501000046730042e+02 2.5097599625587463e+02 1.3955000042915344e+02) (float-vector 3.1113600730895996e+02 2.5943601131439209e+02 1.0526599735021591e+02) (float-vector 3.1815099716186523e+02 2.2701500356197357e+02 1.0230000317096710e+02) (float-vector 2.9960998892784119e+02 2.2176299989223480e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.9501000046730042e+02 2.5097599625587463e+02 1.3955000042915344e+02) (float-vector 2.8169798851013184e+02 2.7328801155090332e+02 1.3955000042915344e+02) (float-vector 2.9610601067543030e+02 2.8678798675537109e+02 1.0230000317096710e+02) (float-vector 3.1113600730895996e+02 2.5943601131439209e+02 1.0526599735021591e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3440899550914764e+02 2.0587599277496338e+02 -5.9969998896121979e+01) (float-vector 2.2893799841403961e+02 1.3809999823570251e+02 -5.5569801479578018e+01) (float-vector 2.9537400603294373e+02 2.0234100520610809e+02 -5.9969700872898102e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.2893799841403961e+02 1.3809999823570251e+02 -5.5569801479578018e+01) (float-vector 1.3440899550914764e+02 2.0587599277496338e+02 -5.9969998896121979e+01) (float-vector 2.0844100415706635e+02 1.3809999823570251e+02 -5.0521600991487503e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.2893799841403961e+02 1.3809999823570251e+02 -5.5569801479578018e+01) (float-vector 2.3811499774456024e+02 1.3809999823570251e+02 -5.2161600440740585e+01) (float-vector 2.9537400603294373e+02 2.0234100520610809e+02 -5.9969700872898102e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.5209999084472656e+02 1.3809999823570251e+02 1.2899999320507050e+02) (float-vector 2.5176900625228882e+02 1.3809999823570251e+02 -3.2848101109266281e+01) (float-vector 2.3811499774456024e+02 1.3809999823570251e+02 -5.2161600440740585e+01) (float-vector 2.2893799841403961e+02 1.3809999823570251e+02 -5.5569801479578018e+01) (float-vector 2.0844100415706635e+02 1.3809999823570251e+02 -5.0521600991487503e+01) (float-vector 2.0128400623798370e+02 1.3809999823570251e+02 -4.2833201587200165e+01) (float-vector 1.9709999859333038e+02 1.3809999823570251e+02 -2.8200000524520874e+01) (float-vector 1.9709999859333038e+02 1.3809999823570251e+02 1.2899999320507050e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.5209999084472656e+02 3.1110000610351562e+02 1.2899999320507050e+02) (float-vector 2.5889199972152710e+02 2.9147401452064514e+02 1.3955000042915344e+02) (float-vector 2.3610100150108337e+02 2.9884099960327148e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.5889199972152710e+02 2.9147401452064514e+02 1.3955000042915344e+02) (float-vector 2.5209999084472656e+02 3.1110000610351562e+02 1.2899999320507050e+02) (float-vector 2.8169798851013184e+02 2.7328801155090332e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.2794699668884277e+02 3.1110000610351562e+02 -5.5608499795198441e+01) (float-vector 2.1015399694442749e+02 3.1110000610351562e+02 -5.1552701741456985e+01) (float-vector 1.3508500158786774e+02 2.4453499913215637e+02 -5.9969898313283920e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.3736700415611267e+02 3.1110000610351562e+02 -5.2639398723840714e+01) (float-vector 2.2794699668884277e+02 3.1110000610351562e+02 -5.5608499795198441e+01) (float-vector 1.3508500158786774e+02 2.4453499913215637e+02 -5.9969898313283920e+01) (float-vector 2.9255101084709167e+02 2.4914300441741943e+02 -5.9970799833536148e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7696300148963928e+02 1.6646899282932281e+02 1.3955000042915344e+02) (float-vector 2.0340099930763245e+02 1.5258400142192841e+02 1.3955000042915344e+02) (float-vector 1.9709999859333038e+02 1.3809999823570251e+02 1.2899999320507050e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7696300148963928e+02 1.6646899282932281e+02 1.3955000042915344e+02) (float-vector 1.9709999859333038e+02 1.3809999823570251e+02 1.2899999320507050e+02) (float-vector 1.5309399366378784e+02 1.6241200268268585e+02 1.0526599735021591e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3734400272369385e+02 2.1916399896144867e+02 1.2899999320507050e+02) (float-vector 1.3500599563121796e+02 1.9842299818992615e+02 1.0526599735021591e+02) (float-vector 1.3131399452686310e+02 2.3227599263191223e+02 1.0526499897241592e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.9738100469112396e+02 3.1110000610351562e+02 -3.2403599470853806e+01) (float-vector 1.9709999859333038e+02 3.1110000610351562e+02 1.2899999320507050e+02) (float-vector 1.5309399366378784e+02 2.8678798675537109e+02 1.0526599735021591e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.9709999859333038e+02 3.1110000610351562e+02 1.2899999320507050e+02) (float-vector 2.1438600122928619e+02 2.9899200797080994e+02 1.3955000042915344e+02) (float-vector 1.9309400022029877e+02 2.9278600215911865e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.5209999084472656e+02 3.1110000610351562e+02 1.2899999320507050e+02) (float-vector 1.9709999859333038e+02 3.1110000610351562e+02 1.2899999320507050e+02) (float-vector 1.9738100469112396e+02 3.1110000610351562e+02 -3.2403599470853806e+01) (float-vector 2.1015399694442749e+02 3.1110000610351562e+02 -5.1552701741456985e+01) (float-vector 2.2794699668884277e+02 3.1110000610351562e+02 -5.5608499795198441e+01) (float-vector 2.3736700415611267e+02 3.1110000610351562e+02 -5.2639398723840714e+01) (float-vector 2.5044301152229309e+02 3.1110098958015442e+02 -3.8267400115728378e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.9709999859333038e+02 3.1110000610351562e+02 1.2899999320507050e+02) (float-vector 2.5209999084472656e+02 3.1110000610351562e+02 1.2899999320507050e+02) (float-vector 2.3610100150108337e+02 2.9884099960327148e+02 1.3955000042915344e+02) (float-vector 2.1438600122928619e+02 2.9899200797080994e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.5309399366378784e+02 1.6241200268268585e+02 1.0526599735021591e+02) (float-vector 1.4279800653457642e+02 2.0137800276279449e+02 1.2899999320507050e+02) (float-vector 1.5774999558925629e+02 1.9044999778270721e+02 1.3955000042915344e+02) (float-vector 1.7696300148963928e+02 1.6646899282932281e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3500599563121796e+02 1.9842299818992615e+02 1.0526599735021591e+02) (float-vector 1.3734400272369385e+02 2.1916399896144867e+02 1.2899999320507050e+02) (float-vector 1.4279800653457642e+02 2.0137800276279449e+02 1.2899999320507050e+02) (float-vector 1.5309399366378784e+02 1.6241200268268585e+02 1.0526599735021591e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.9709999859333038e+02 3.1110000610351562e+02 1.2899999320507050e+02) (float-vector 1.6753900051116943e+02 2.7333900332450867e+02 1.3955000042915344e+02) (float-vector 1.5309399366378784e+02 2.8678798675537109e+02 1.0526599735021591e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.6753900051116943e+02 2.7333900332450867e+02 1.3955000042915344e+02) (float-vector 1.9709999859333038e+02 3.1110000610351562e+02 1.2899999320507050e+02) (float-vector 1.9309400022029877e+02 2.9278600215911865e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3976199924945831e+02 2.6357400417327881e+02 1.0526499897241592e+02) (float-vector 1.3915100693702698e+02 2.3853099346160889e+02 1.2899999320507050e+02) (float-vector 1.3131399452686310e+02 2.3227599263191223e+02 1.0526499897241592e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3915100693702698e+02 2.3853099346160889e+02 1.2899999320507050e+02) (float-vector 1.3734400272369385e+02 2.1916399896144867e+02 1.2899999320507050e+02) (float-vector 1.3131399452686310e+02 2.3227599263191223e+02 1.0526499897241592e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3976199924945831e+02 2.6357400417327881e+02 1.0526499897241592e+02) (float-vector 1.5309399366378784e+02 2.8678798675537109e+02 1.0526599735021591e+02) (float-vector 1.6753900051116943e+02 2.7333900332450867e+02 1.3955000042915344e+02) (float-vector 1.3915100693702698e+02 2.3853099346160889e+02 1.2899999320507050e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.5259000658988953e+02 2.4588100612163544e+02 1.3955000042915344e+02) (float-vector 1.3915100693702698e+02 2.3853099346160889e+02 1.2899999320507050e+02) (float-vector 1.6753900051116943e+02 2.7333900332450867e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.9960998892784119e+02 2.2176299989223480e+02 1.3955000042915344e+02) (float-vector 2.9672199487686157e+02 2.0361000299453735e+02 1.3955000042915344e+02) (float-vector 2.8716799616813660e+02 1.8310000002384186e+02 1.3955000042915344e+02) (float-vector 2.5811100006103516e+02 1.5735900402069092e+02 1.3955000042915344e+02) (float-vector 2.2460000216960907e+02 1.4959999918937683e+02 1.3955000042915344e+02) (float-vector 2.0340099930763245e+02 1.5258400142192841e+02 1.3955000042915344e+02) (float-vector 1.7696300148963928e+02 1.6646899282932281e+02 1.3955000042915344e+02) (float-vector 1.5774999558925629e+02 1.9044999778270721e+02 1.3955000042915344e+02) (float-vector 1.4979700744152069e+02 2.1820099651813507e+02 1.3955000042915344e+02) (float-vector 1.5259000658988953e+02 2.4588100612163544e+02 1.3955000042915344e+02) (float-vector 1.6753900051116943e+02 2.7333900332450867e+02 1.3955000042915344e+02) (float-vector 1.9309400022029877e+02 2.9278600215911865e+02 1.3955000042915344e+02) (float-vector 2.1438600122928619e+02 2.9899200797080994e+02 1.3955000042915344e+02) (float-vector 2.3610100150108337e+02 2.9884099960327148e+02 1.3955000042915344e+02) (float-vector 2.5889199972152710e+02 2.9147401452064514e+02 1.3955000042915344e+02) (float-vector 2.8169798851013184e+02 2.7328801155090332e+02 1.3955000042915344e+02) (float-vector 2.9501000046730042e+02 2.5097599625587463e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.4979700744152069e+02 2.1820099651813507e+02 1.3955000042915344e+02) (float-vector 1.3734400272369385e+02 2.1916399896144867e+02 1.2899999320507050e+02) (float-vector 1.3915100693702698e+02 2.3853099346160889e+02 1.2899999320507050e+02) (float-vector 1.5259000658988953e+02 2.4588100612163544e+02 1.3955000042915344e+02)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.3734400272369385e+02 2.1916399896144867e+02 1.2899999320507050e+02) (float-vector 1.4979700744152069e+02 2.1820099651813507e+02 1.3955000042915344e+02) (float-vector 1.5774999558925629e+02 1.9044999778270721e+02 1.3955000042915344e+02) (float-vector 1.4279800653457642e+02 2.0137800276279449e+02 1.2899999320507050e+02)))))
              ))
             )
      (setq geom (instance collada-body :init :replace-obj qhull :name "br_caster_rotation_link_geom0"))
      (when glv
        (setq (geom . gl::aglvertices) glv)
        (send geom :assoc glv))
      geom))
  (:_make_instance_double_stereo_link_geom0 ()
    (let (geom glv qhull
          (local-cds (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
      (setq glv
       (instance gl::glvertices :init
                 (list ;; mesh list
                  (list ;; mesh description
                   (list :type :triangles)
                   (list :material (list
                    (list :ambient (float-vector 0.000100 0.000100 0.400000 1.000000))
                    (list :diffuse (float-vector 0.000000 0.000000 0.800000 1.000000))))
                   (list :indices #i( 0 1 2 2 3 0 4 3 2 2 5 4 6 5 2 2 1 6 3 4 7 7 0 3 0 7 6 6 1 0 6 7 4 4 5 6))
                   (list :vertices (let ((mat (make-matrix 8 3))) (fvector-replace (array-entity mat) #f(-2.0000000000000000e+01 -6.0000000000000000e+01 -3.7252900142448198e-07 -2.2351699158207339e-07 -6.0000000000000000e+01 -3.7252900142448198e-07 -2.2351699158207339e-07 -6.0000000000000000e+01 5.0000000000000000e+01 -2.0000000000000000e+01 -6.0000000000000000e+01 5.0000000000000000e+01 -2.0000000000000000e+01 6.0000000000000000e+01 5.0000000000000000e+01 -2.2351699158207339e-07 6.0000000000000000e+01 5.0000000000000000e+01 -2.2351699158207339e-07 6.0000000000000000e+01 -3.7252900142448198e-07 -2.0000000000000000e+01 6.0000000000000000e+01 -3.7252900142448198e-07 )) mat)))
                  )
                 ))
      (send glv :transform local-cds)
      (send glv :calc-normals)
      (setq qhull
            ;; qhull 36 -> 6 faces
            (instance faceset :init :faces (list
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.9999999552965164e+01 -5.9999998658895493e+01 -3.7252900764173091e-07) (float-vector -1.9999999552965164e+01 -5.9999998658895493e+01 5.0000000745058060e+01) (float-vector -2.2351699657807700e-07 -5.9999998658895493e+01 5.0000000745058060e+01) (float-vector -2.2351699657807700e-07 -5.9999998658895493e+01 -3.7252900764173091e-07)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.9999999552965164e+01 5.9999998658895493e+01 -3.7252900764173091e-07) (float-vector -1.9999999552965164e+01 5.9999998658895493e+01 5.0000000745058060e+01) (float-vector -1.9999999552965164e+01 -5.9999998658895493e+01 5.0000000745058060e+01) (float-vector -1.9999999552965164e+01 -5.9999998658895493e+01 -3.7252900764173091e-07)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.2351699657807700e-07 5.9999998658895493e+01 -3.7252900764173091e-07) (float-vector -1.9999999552965164e+01 5.9999998658895493e+01 -3.7252900764173091e-07) (float-vector -1.9999999552965164e+01 -5.9999998658895493e+01 -3.7252900764173091e-07) (float-vector -2.2351699657807700e-07 -5.9999998658895493e+01 -3.7252900764173091e-07)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.9999999552965164e+01 5.9999998658895493e+01 5.0000000745058060e+01) (float-vector -2.2351699657807700e-07 5.9999998658895493e+01 5.0000000745058060e+01) (float-vector -2.2351699657807700e-07 -5.9999998658895493e+01 5.0000000745058060e+01) (float-vector -1.9999999552965164e+01 -5.9999998658895493e+01 5.0000000745058060e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.2351699657807700e-07 5.9999998658895493e+01 -3.7252900764173091e-07) (float-vector -2.2351699657807700e-07 5.9999998658895493e+01 5.0000000745058060e+01) (float-vector -1.9999999552965164e+01 5.9999998658895493e+01 5.0000000745058060e+01) (float-vector -1.9999999552965164e+01 5.9999998658895493e+01 -3.7252900764173091e-07)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.2351699657807700e-07 5.9999998658895493e+01 5.0000000745058060e+01) (float-vector -2.2351699657807700e-07 5.9999998658895493e+01 -3.7252900764173091e-07) (float-vector -2.2351699657807700e-07 -5.9999998658895493e+01 -3.7252900764173091e-07) (float-vector -2.2351699657807700e-07 -5.9999998658895493e+01 5.0000000745058060e+01)))))
              ))
             )
      (setq geom (instance collada-body :init :replace-obj qhull :name "double_stereo_link_geom0"))
      (when glv
        (setq (geom . gl::aglvertices) glv)
        (send geom :assoc glv))
      geom))
  (:_make_instance_fl_caster_l_wheel_link_geom0 ()
    (let (geom glv qhull
          (local-cds (make-coords :pos (float-vector 0.0000000000000000e+00 4.9000000000000000e+01 0.0000000000000000e+00))))
      (setq glv
       (instance gl::glvertices :init
                 (list ;; mesh list
                  (list ;; mesh description
                   (list :type :triangles)
                   (list :material (list
                    (list :ambient (float-vector 0.000100 0.000100 0.000100 1.000000))
                    (list :diffuse (float-vector 0.000000 0.000000 0.000000 1.000000))))
                   (list :indices #i( 0 1 2 0 4 1 2 28 0 30 4 0 28 30 0 21 22 2 22 28 2 2 1 21 28 29 30 22 29 28 30 29 31 30 31 4 404 29 407 408 407 29 31 29 404 22 408 29 20 22 21 22 20 408 18 20 21 17 20 18 412 20 17 408 20 412 17 18 19 21 486 18 18 486 19 17 19 16 412 17 16 412 413 414 412 414 408 412 16 413 413 415 414 409 415 413 413 15 409 413 16 481 413 481 15 14 15 7 409 15 14 481 7 15 481 16 7 6 7 8 8 7 11 14 7 6 16 11 7 14 6 10 409 14 10 9 10 6 6 487 9 8 489 6 6 489 487 8 11 13 8 488 489 13 488 8 12 13 11 11 16 12 13 12 19 19 488 13 486 488 19 486 499 488 488 499 497 488 497 489 16 19 12 489 497 494 489 494 487 497 459 494 499 459 497 486 498 499 499 474 459 499 498 474 493 498 486 474 498 475 498 493 475 40 474 475 475 478 471 40 475 471 475 493 478 37 39 40 41 37 40 41 40 471 39 474 40 41 471 378 471 478 378 478 476 378 478 493 476 69 378 379 37 41 378 37 378 69 378 476 379 476 477 379 476 493 477 69 379 376 379 477 376 376 477 473 493 473 477 492 493 3 1 493 486 3 493 1 492 473 493 491 496 492 491 492 3 492 496 473 3 4 5 4 3 1 491 3 5 21 1 486 4 31 5 482 5 483 33 483 5 33 5 31 482 491 5 33 31 34 31 404 34 34 35 33 35 483 33 36 482 483 35 36 483 34 36 35 34 26 36 406 34 404 27 34 406 26 34 27 404 405 406 407 405 404 27 406 410 434 406 405 410 406 434 434 405 423 407 423 405 407 408 423 423 408 417 440 408 414 417 408 440 416 417 418 417 427 418 417 416 423 417 440 427 414 439 440 427 440 439 451 427 439 398 427 402 427 398 418 451 402 427 419 416 418 418 398 419 423 416 419 419 422 423 401 419 398 419 401 400 400 422 419 422 421 423 421 434 423 420 421 422 425 421 420 425 434 421 420 424 425 424 434 425 426 424 420 426 434 424 420 381 426 422 396 420 381 420 382 382 420 396 434 426 435 426 381 435 380 381 382 260 392 381 381 380 260 392 435 381 393 382 396 380 382 393 258 380 257 380 393 257 260 380 258 235 259 260 260 258 235 259 392 260 392 259 391 430 392 391 430 435 392 231 259 235 229 262 259 229 259 231 259 262 391 231 232 229 235 236 231 231 236 232 232 237 229 232 236 177 183 232 177 183 237 232 235 234 236 236 234 181 177 236 181 177 178 167 168 177 167 177 181 178 168 183 177 179 181 180 178 181 179 181 234 180 166 178 164 164 178 179 167 178 166 167 161 162 166 161 167 162 168 167 161 166 160 160 166 164 160 164 159 164 165 159 164 179 165 180 165 179 358 165 363 159 165 358 363 165 365 180 365 165 118 159 117 160 159 118 117 159 358 161 160 119 119 160 118 105 118 117 104 119 118 104 118 105 117 116 105 116 117 329 329 117 358 104 105 98 105 116 95 98 105 95 97 103 104 98 97 104 103 119 104 92 97 98 92 98 95 95 81 92 95 316 81 316 95 317 95 116 317 92 93 94 81 93 92 94 97 92 99 97 94 97 99 103 93 96 94 96 99 94 93 81 72 61 93 72 61 96 93 101 99 96 59 96 61 59 101 96 100 99 101 100 106 99 99 106 103 101 102 100 101 108 102 59 108 101 100 109 106 102 109 100 121 120 106 106 120 103 109 121 106 120 119 103 120 162 161 120 161 119 121 162 120 109 122 121 163 162 121 122 163 121 102 113 109 113 122 109 123 122 113 122 169 163 123 169 122 163 168 162 163 169 174 174 168 163 170 169 123 170 175 169 169 175 174 124 123 114 114 123 113 124 170 123 124 171 170 176 170 171 175 170 176 175 182 174 176 185 175 185 182 175 171 173 176 173 184 176 176 184 185 152 171 125 125 171 124 152 173 171 172 173 152 173 172 184 172 201 184 201 204 184 184 204 210 184 210 185 186 172 152 186 190 172 190 201 172 148 152 125 148 186 152 187 186 149 149 186 148 187 190 186 190 187 191 191 201 190 150 188 187 150 187 149 188 191 187 149 148 136 150 149 137 137 149 136 131 148 125 136 148 131 89 136 131 132 137 136 132 136 89 133 137 132 133 138 137 138 150 137 130 132 89 133 132 134 134 132 130 89 90 91 91 130 89 90 89 131 90 110 91 90 115 110 131 115 90 112 91 107 107 91 110 91 129 130 91 112 129 110 111 107 110 114 111 110 115 114 125 124 115 115 124 114 131 125 115 111 114 113 107 111 102 111 113 102 107 102 108 108 112 107 58 108 59 58 112 108 58 59 57 59 60 57 59 61 60 60 61 62 62 63 60 63 57 60 61 72 62 63 62 64 62 72 64 72 65 64 72 81 82 72 82 65 64 65 66 66 63 64 66 65 70 65 80 70 65 82 80 82 314 80 81 316 82 82 316 314 80 79 70 305 306 80 314 305 80 80 306 79 317 318 314 317 314 316 314 318 305 305 319 315 318 319 305 305 315 306 306 309 79 306 313 309 306 315 313 315 327 325 319 327 315 315 325 313 320 319 318 328 327 319 320 328 319 317 320 318 317 116 320 329 328 320 116 329 320 360 359 328 328 359 327 329 360 328 327 354 325 327 359 354 325 324 313 325 354 324 354 353 324 354 356 353 354 359 361 361 356 354 360 362 359 359 362 361 362 364 361 361 272 356 361 364 272 356 357 353 356 274 357 356 272 274 269 272 268 272 273 268 274 272 269 272 364 273 362 365 364 364 365 273 268 273 234 234 273 180 273 365 180 264 268 234 264 269 268 233 234 235 264 234 233 256 264 233 256 253 264 253 269 264 256 233 257 235 258 233 258 257 233 253 256 263 257 393 256 256 395 263 393 395 256 254 253 263 263 394 254 263 395 394 393 396 395 395 399 400 395 400 394 396 399 395 254 394 255 400 401 394 394 401 255 250 253 254 255 250 254 250 255 251 255 248 251 255 398 248 255 401 398 248 250 251 247 246 248 248 246 250 398 402 248 248 402 247 245 246 247 402 403 247 247 403 245 448 403 402 402 451 448 245 403 397 403 448 397 244 242 245 245 242 246 245 397 244 243 242 244 244 397 243 243 397 386 397 450 386 448 447 397 450 397 447 242 243 240 386 240 243 386 384 387 387 240 386 384 386 449 449 386 450 441 449 450 450 447 441 443 447 448 441 447 442 442 447 443 414 441 442 438 441 414 441 438 449 384 449 454 449 438 454 414 415 438 415 445 438 454 438 445 443 439 414 414 442 443 439 443 448 448 451 439 444 445 415 444 446 445 454 445 452 446 452 445 384 454 452 385 384 452 452 453 385 452 446 453 453 446 444 385 453 389 455 389 453 453 444 455 383 384 385 385 389 238 385 238 383 383 388 384 384 388 387 249 388 383 383 238 249 228 238 239 226 249 238 226 238 228 238 389 239 226 241 249 241 388 249 387 388 241 240 387 241 240 241 225 225 241 226 225 226 227 217 227 226 228 218 226 217 226 218 227 212 225 211 225 212 242 240 225 225 211 242 212 227 217 208 211 212 205 212 217 208 212 205 211 209 213 209 211 208 213 221 211 211 221 242 242 221 246 220 221 213 220 222 221 222 246 221 213 347 346 213 346 220 209 347 213 220 215 222 220 346 336 337 220 336 220 337 215 214 222 215 214 246 222 214 215 216 348 215 343 343 215 337 215 348 216 333 337 332 332 337 336 343 337 333 333 338 343 338 344 343 344 348 343 216 348 344 339 344 338 344 339 345 345 216 344 301 338 333 339 338 302 302 338 301 333 332 300 301 333 300 291 301 300 302 301 294 294 301 291 303 302 295 295 302 294 303 339 302 285 294 291 293 295 294 293 294 285 283 291 289 285 291 283 291 300 289 284 285 283 290 285 75 284 75 285 290 293 285 292 293 290 292 295 293 83 277 290 290 277 292 290 75 83 74 75 76 75 74 83 75 284 76 283 282 284 284 282 76 88 76 87 76 88 74 87 76 278 76 282 278 282 280 278 280 282 286 283 289 282 282 289 286 278 279 87 278 280 279 279 280 281 280 286 287 281 280 287 299 298 286 289 299 286 286 298 287 300 299 289 299 332 331 299 331 298 300 332 299 287 298 297 331 330 298 298 330 297 287 288 281 287 297 288 288 297 158 297 196 158 330 196 297 330 334 196 331 335 330 330 335 334 336 331 332 335 331 336 335 346 334 336 346 335 196 334 199 334 347 199 334 346 347 193 158 196 196 199 193 193 199 200 200 199 207 199 209 207 209 199 347 157 158 193 157 193 195 193 200 195 195 200 198 200 207 198 198 207 206 207 208 206 207 209 208 195 198 194 194 198 197 198 206 197 195 194 156 157 195 156 154 194 189 156 194 154 189 194 197 197 192 189 205 202 197 197 202 192 197 206 205 208 205 206 205 217 202 191 202 203 192 202 191 202 217 203 189 192 188 188 192 191 189 188 151 154 189 151 151 188 150 151 150 138 154 151 138 127 138 133 127 139 138 139 154 138 126 127 128 127 133 135 126 139 127 127 135 128 134 135 133 130 135 134 135 366 128 130 366 135 73 366 130 129 73 130 128 366 367 366 53 367 370 53 366 73 370 366 367 86 143 128 367 143 53 47 367 86 367 47 140 143 142 142 143 85 140 128 143 143 86 85 140 126 128 144 145 140 144 140 142 140 145 126 141 142 85 142 141 144 85 86 87 141 85 279 87 279 85 141 153 144 279 281 141 288 153 141 281 288 141 144 147 145 144 153 147 147 146 145 145 146 126 157 156 147 153 157 147 147 156 146 153 158 157 158 153 288 126 146 139 156 155 146 146 155 139 155 156 154 139 155 154 87 86 88 86 369 88 47 369 86 369 368 88 88 368 74 369 43 368 43 369 47 46 47 48 46 43 47 48 47 52 52 47 53 45 43 46 46 461 45 48 461 46 44 43 45 45 458 44 45 461 458 458 461 456 456 461 48 456 457 458 44 458 472 458 457 472 42 43 44 44 472 42 472 56 42 472 457 480 472 480 56 456 459 457 457 459 480 459 456 48 48 460 459 459 460 470 470 494 459 459 474 480 56 480 479 474 479 480 39 479 474 56 479 39 37 38 39 39 38 56 68 37 69 38 37 84 68 84 37 67 68 69 67 71 68 71 84 68 70 69 66 67 69 70 69 376 66 67 77 71 70 79 67 67 79 77 71 77 78 78 84 71 83 84 78 78 77 277 78 277 83 83 74 84 74 38 84 74 368 38 56 38 42 38 43 42 43 38 368 275 276 277 276 292 277 277 77 275 77 308 275 275 311 307 308 311 275 276 275 307 276 296 292 307 296 276 292 296 295 304 303 296 296 303 295 307 304 296 307 321 304 311 321 307 321 326 304 326 340 304 304 340 303 303 340 339 345 339 340 326 342 340 340 342 345 341 342 326 321 351 326 351 341 326 322 321 311 322 351 321 352 351 322 352 355 351 351 355 341 342 341 349 355 350 341 341 350 349 342 349 345 345 349 216 271 349 350 216 349 223 223 349 271 357 350 355 350 357 271 355 352 353 357 355 353 271 357 274 224 271 270 271 274 270 224 223 271 223 224 214 223 214 216 224 267 214 224 270 265 224 265 267 265 270 266 266 270 269 270 274 269 265 266 253 253 250 265 267 265 250 246 267 250 214 267 246 266 269 253 323 353 352 324 353 323 323 322 312 324 323 312 323 352 322 313 324 312 308 312 311 309 312 308 309 313 312 312 322 311 309 308 310 310 308 77 310 79 309 79 310 77 66 375 63 66 376 377 377 375 66 63 375 374 375 466 464 374 375 464 377 466 375 63 374 373 63 373 57 374 464 465 465 373 374 464 496 465 464 466 496 377 473 466 496 466 473 376 473 377 490 496 491 495 496 490 496 495 465 467 373 465 465 495 467 494 495 490 495 494 467 468 373 467 467 463 372 467 372 468 467 494 470 467 470 463 487 494 490 9 487 23 23 487 490 23 10 9 23 24 10 32 23 485 24 23 32 23 490 485 409 10 24 32 27 24 24 27 409 27 32 25 485 25 32 485 484 25 485 490 484 484 490 491 26 484 482 25 484 26 482 484 491 25 26 27 409 27 410 409 410 411 409 411 415 428 410 434 428 411 410 437 411 436 436 411 428 411 444 415 411 437 444 436 432 437 437 455 444 455 437 432 436 433 432 433 436 428 431 432 433 431 433 428 455 432 389 391 390 432 389 432 390 431 391 432 431 428 430 431 430 391 390 391 261 391 262 261 389 390 252 261 252 390 239 389 252 239 252 228 228 252 261 228 261 229 229 261 262 228 229 230 219 218 228 230 219 228 229 237 230 237 219 230 204 219 210 204 218 219 210 219 237 203 217 218 203 218 204 203 204 201 203 201 191 210 237 185 185 237 183 182 185 183 182 183 174 174 183 168 428 429 430 430 429 435 428 434 429 429 434 435 36 26 482 462 372 463 469 462 463 463 470 469 51 462 469 50 462 51 50 372 462 371 372 49 372 50 49 468 372 371 49 50 51 54 55 51 51 55 49 469 54 51 470 54 469 460 54 470 52 53 54 54 53 55 460 52 54 55 58 49 55 73 58 370 73 55 55 53 370 57 49 58 73 112 58 129 112 73 57 371 49 57 373 371 371 373 468 48 52 460 399 422 400 422 399 396 363 365 362 358 363 360 360 363 362 329 358 360))
                   (list :vertices (let ((mat (make-matrix 500 3))) (fvector-replace (array-entity mat) #f(5.1378703117370605e+00 -2.9734701156616211e+01 -9.3289899826049805e+00 2.7445201873779297e+00 -2.9418100357055664e+01 -1.2800700187683105e+01 1.0573199987411499e+00 -2.9640798568725586e+01 -1.0600199699401855e+01 1.0544799804687500e+01 -2.9430900573730469e+01 -8.4442996978759766e+00 8.2298793792724609e+00 -2.9580398559570312e+01 -6.8257398605346680e+00 1.0452800750732422e+01 -2.9676599502563477e+01 -2.3365499973297119e+00 -6.6212201118469238e+00 -2.9607198715209961e+01 8.3633699417114258e+00 -1.0304100036621094e+01 -8.0464500427246094e+01 4.2757096290588379e+00 -9.9000797271728516e+00 -2.9565000534057617e+01 4.3990101814270020e+00 -3.0437600612640381e+00 -2.9632600784301758e+01 1.0238399505615234e+01 -3.0640001296997070e+00 -8.0891304016113281e+01 1.0639900207519531e+01 -1.0523200035095215e+01 -2.9807800292968750e+01 2.0460700988769531e+00 -1.0421499252319336e+01 -2.9872400283813477e+01 -1.9288499355316162e+00 -1.1160599708557129e+01 -2.9559000015258789e+01 -8.0958700180053711e-01 -7.1614899635314941e+00 -8.0892097473144531e+01 8.4554700851440430e+00 -1.0192299842834473e+01 -8.0942695617675781e+01 5.5663700103759766e+00 -1.0925999641418457e+01 -8.0888397216796875e+01 -2.1682801246643066e+00 -8.4008197784423828e+00 -8.0911102294921875e+01 -7.2349200248718262e+00 -6.7002696990966797e+00 -2.9603599548339844e+01 -8.3113307952880859e+00 -9.4348793029785156e+00 -2.9594200134277344e+01 -4.9726400375366211e+00 -5.3217201232910156e+00 -8.0856101989746094e+01 -9.7155799865722656e+00 -2.8588600158691406e+00 -2.9677499771118164e+01 -1.0273599624633789e+01 -1.0057700872421265e+00 -8.0903297424316406e+01 -1.1044600486755371e+01 1.0178999900817871e+00 -2.9632200241088867e+01 1.0607999801635742e+01 1.0090099573135376e+00 -8.0902297973632812e+01 1.1044500350952148e+01 7.1427397727966309e+00 -8.0804000854492188e+01 8.4595899581909180e+00 9.8030099868774414e+00 -8.0907203674316406e+01 5.1623497009277344e+00 7.4257197380065918e+00 -8.1105201721191406e+01 1.1212299346923828e+01 3.3442101478576660e+00 -8.0903900146484375e+01 -1.0557999610900879e+01 6.1998200416564941e+00 -8.1096000671386719e+01 -1.1747900009155273e+01 7.2372202873229980e+00 -8.0794494628906250e+01 -8.3683700561523438e+00 9.8025293350219727e+00 -8.0921005249023438e+01 -5.1738500595092773e+00 4.0853300094604492e+00 -8.0921997070312500e+01 1.0249599456787109e+01 1.0831099510192871e+01 -8.0742095947265625e+01 -2.0039701461791992e+00 1.2268199920654297e+01 -8.1127998352050781e+01 3.9475402832031250e+00 1.1011500358581543e+01 -8.0664100646972656e+01 0.0000000000000000e+00 1.0836700439453125e+01 -8.0821899414062500e+01 2.0019199848175049e+00 -1.1417300224304199e+01 -3.1931400299072266e+01 -6.0313899993896484e+01 -3.8845100402832031e+01 -3.1901300430297852e+01 -4.7875999450683594e+01 -3.0698499679565430e+01 -3.3114299774169922e+01 -3.9734401702880859e+01 -1.5955299377441406e+01 -3.3060798645019531e+01 -4.7729400634765625e+01 -2.3467898368835449e+00 -3.3005496978759766e+01 -5.1267002105712891e+01 -4.5538898468017578e+01 -3.2922698974609375e+01 -2.5041301727294922e+01 -6.0313198089599609e+01 -3.1965400695800781e+01 -7.4321599006652832e+00 -4.9943901062011719e+01 -3.2961498260498047e+01 -1.3358200073242188e+01 -5.1267002105712891e+01 -3.3005199432373047e+01 2.3467597961425781e+00 -4.8763401031494141e+01 -3.2972099304199219e+01 1.6582399368286133e+01 -6.1740497589111328e+01 -3.1979299545288086e+01 1.0151400566101074e+01 -4.5477100372314453e+01 -3.3045398712158203e+01 2.1893899917602539e+01 1.6372301101684570e+01 -3.1941600799560547e+01 5.8962200164794922e+01 2.3468399047851562e+00 -3.3007396697998047e+01 5.1267200469970703e+01 -9.9129495620727539e+00 -3.3083801269531250e+01 4.9431499481201172e+01 -3.6015296936035156e+01 -3.3108100891113281e+01 3.4995300292968750e+01 -4.8726200103759766e+01 -3.1919502258300781e+01 3.8182498931884766e+01 -2.5745399475097656e+01 -3.3058502197265625e+01 4.3290298461914062e+01 -6.4798698425292969e+00 -3.1922300338745117e+01 6.1833000183105469e+01 -3.9104801177978516e+01 -3.3105998992919922e+01 -3.1760398864746094e+01 3.8039699554443359e+01 -3.1931098937988281e+01 4.8811397552490234e+01 2.0110498428344727e+01 -3.2998302459716797e+01 6.3504100799560547e+01 4.7388999938964844e+01 -3.3059799194335938e+01 4.7388999938964844e+01 5.0501701354980469e+01 -3.2199699401855469e+01 3.8274200439453125e+01 6.3447898864746094e+01 -3.3059898376464844e+01 2.0092599868774414e+01 6.0778099060058594e+01 -3.2144401550292969e+01 1.7475801467895508e+01 6.0313198089599609e+01 -3.1965400695800781e+01 7.4321599006652832e+00 6.3284599304199219e+01 -3.2191196441650391e+01 -4.4547400474548340e+00 5.9817501068115234e+01 -3.3059898376464844e+01 -2.9234298706054688e+01 5.5512199401855469e+01 -3.1871200561523438e+01 -2.7132499694824219e+01 2.8417900085449219e+01 -3.3024398803710938e+01 -6.0260898590087891e+01 4.4547300338745117e+00 -3.2191101074218750e+01 -6.3284301757812500e+01 3.3109401702880859e+01 -3.1901699066162109e+01 -5.2159999847412109e+01 4.6935901641845703e+01 -3.2998600006103516e+01 -4.6935901641845703e+01 4.6696701049804688e+00 -3.3059997558593750e+01 -6.6339698791503906e+01 6.6339698791503906e+01 -3.3059997558593750e+01 -4.6691398620605469e+00 -1.2190400123596191e+01 -3.3019302368164062e+01 6.5981704711914062e+01 -4.4070800781250000e+01 -3.3025100708007812e+01 -4.9997600555419922e+01 -3.9661098480224609e+01 -3.2243999481201172e+01 -5.7238800048828125e+01 -5.8180297851562500e+01 -3.2244602203369141e+01 -3.8144996643066406e+01 1.5174099922180176e+01 -3.2350498199462891e+01 -6.8473693847656250e+01 4.8838300704956055e+00 -3.2246299743652344e+01 -6.9384094238281250e+01 4.1918899536132812e+01 -3.2255702972412109e+01 -5.5662799835205078e+01 5.6185497283935547e+01 -3.2231498718261719e+01 -4.1026100158691406e+01 6.9456398010253906e+01 -3.2233699798583984e+01 -1.5821299552917480e+00 6.6359199523925781e+01 -3.2246299743652344e+01 -2.1015600204467773e+01 -2.1015600204467773e+01 -3.2246299743652344e+01 -6.6359199523925781e+01 -2.0110498428344727e+01 -3.2998302459716797e+01 -6.3504100799560547e+01 -6.9488693237304688e+01 -3.2240303039550781e+01 1.4109100103378296e+00 -6.6339698791503906e+01 -3.3059997558593750e+01 -4.6691398620605469e+00 -6.6359199523925781e+01 -3.2246299743652344e+01 -2.1015600204467773e+01 -5.9817501068115234e+01 -3.3059898376464844e+01 -2.9234298706054688e+01 -1.5645200729370117e+01 -3.8389400482177734e+01 7.4474800109863281e+01 -1.7341400384902954e+00 -3.8391998291015625e+01 7.6071098327636719e+01 5.1130599975585938e+00 -3.4403301239013672e+01 7.2644706726074219e+01 7.1366401672363281e+01 -3.4439002990722656e+01 1.3268600463867188e+01 6.7285202026367188e+01 -3.2246299743652344e+01 1.7788499832153320e+01 6.7477394104003906e+01 -3.4428897857666016e+01 2.6760299682617188e+01 7.5355300903320312e+01 -3.7268402099609375e+01 1.7170599699020386e+00 5.9104999542236328e+01 -3.2233699798583984e+01 3.6562202453613281e+01 7.0040397644042969e+01 -3.8387001037597656e+01 2.9782499313354492e+01 7.4474800109863281e+01 -3.8389400482177734e+01 1.5645200729370117e+01 6.2013099670410156e+01 -3.7266197204589844e+01 4.2893001556396484e+01 5.1923801422119141e+01 -3.7266002655029297e+01 5.4677501678466797e+01 4.9207698822021484e+01 -3.2231403350830078e+01 4.9181400299072266e+01 3.9661300659179688e+01 -3.7265899658203125e+01 6.4126296997070312e+01 6.6670997619628906e+01 -4.3020999908447266e+01 4.1205699920654297e+01 7.3550094604492188e+01 -4.3022300720214844e+01 2.7057100296020508e+01 7.7358497619628906e+01 -4.3024600982666016e+01 1.2475700378417969e+01 5.6843299865722656e+01 -4.3021598815917969e+01 5.3966102600097656e+01 2.5049600601196289e+01 -3.4442001342773438e+01 6.8122604370117188e+01 3.6946399688720703e+01 -3.2240901947021484e+01 5.8903797149658203e+01 4.4562896728515625e+01 -4.3020900726318359e+01 6.4476997375488281e+01 1.2114600181579590e+01 -3.8389999389648438e+01 7.5127197265625000e+01 2.6272998809814453e+01 -3.8387500762939453e+01 7.1428794860839844e+01 2.1015600204467773e+01 -3.2246299743652344e+01 6.6359199523925781e+01 3.0671701431274414e+01 -4.3021900177001953e+01 7.2120101928710938e+01 1.6111700057983398e+01 -4.3023998260498047e+01 7.6686698913574219e+01 1.7856500148773193e+00 -4.3026500701904297e+01 7.8329895019531250e+01 7.8330101013183594e+01 -4.3027000427246094e+01 -1.7853500843048096e+00 7.9383201599121094e+01 -4.8954898834228516e+01 -3.4461998939514160e-01 7.8114799499511719e+01 -4.8949199676513672e+01 1.4203499794006348e+01 7.3951698303222656e+01 -4.8940597534179688e+01 2.8930398941040039e+01 6.6686599731445312e+01 -4.8934600830078125e+01 4.3129802703857422e+01 5.6477798461914062e+01 -4.8932300567626953e+01 5.5839900970458984e+01 4.3869800567626953e+01 -4.8934097290039062e+01 6.6202606201171875e+01 2.9704099655151367e+01 -4.8939601898193359e+01 7.3644798278808594e+01 1.4941699981689453e+01 -4.8947898864746094e+01 7.7977600097656250e+01 3.4459200501441956e-01 -4.8954898834228516e+01 7.9383300781250000e+01 -6.4126296997070312e+01 -3.7265899658203125e+01 3.9661300659179688e+01 -5.3850097656250000e+01 -3.6490200042724609e+01 5.2007102966308594e+01 -5.6481498718261719e+01 -3.2248001098632812e+01 4.0724998474121094e+01 -4.8838300704956055e+00 -3.2246299743652344e+01 6.9384094238281250e+01 -1.5174099922180176e+01 -3.2350498199462891e+01 6.8473693847656250e+01 -1.2475700378417969e+01 -4.3024600982666016e+01 7.7358497619628906e+01 -2.9782499313354492e+01 -3.8387001037597656e+01 7.0040397644042969e+01 -4.2893001556396484e+01 -3.7266197204589844e+01 6.2013099670410156e+01 -2.8395601272583008e+01 -3.4441600799560547e+01 6.6799201965332031e+01 -4.3375499725341797e+01 -3.2257099151611328e+01 5.4680000305175781e+01 -2.7057100296020508e+01 -4.3022300720214844e+01 7.3550094604492188e+01 -4.1205699920654297e+01 -4.3020999908447266e+01 6.6670997619628906e+01 -5.3966102600097656e+01 -4.3021598815917969e+01 5.6843299865722656e+01 -6.4476997375488281e+01 -4.3020900726318359e+01 4.4562896728515625e+01 -6.7513504028320312e+01 -3.4440597534179688e+01 2.6707201004028320e+01 -7.5355300903320312e+01 -3.7268402099609375e+01 -1.7170599699020386e+00 -7.1374496459960938e+01 -3.4436901092529297e+01 1.3211199760437012e+01 -6.7285202026367188e+01 -3.2246299743652344e+01 1.7788499832153320e+01 -7.5127197265625000e+01 -3.8389999389648438e+01 1.2114600181579590e+01 -7.1428794860839844e+01 -3.8387500762939453e+01 2.6272998809814453e+01 -7.2120101928710938e+01 -4.3021900177001953e+01 3.0671701431274414e+01 -7.6686698913574219e+01 -4.3023998260498047e+01 1.6111700057983398e+01 -1.4203499794006348e+01 -4.8949199676513672e+01 7.8114799499511719e+01 -2.8930398941040039e+01 -4.8940597534179688e+01 7.3951698303222656e+01 -4.3129802703857422e+01 -4.8934600830078125e+01 6.6686599731445312e+01 -5.4402599334716797e+01 -4.9551700592041016e+01 5.7758701324462891e+01 -1.7856500148773193e+00 -5.4973503112792969e+01 7.8329895019531250e+01 -7.8330101013183594e+01 -4.3027000427246094e+01 1.7853500843048096e+00 -6.4116600036621094e+01 -4.8947498321533203e+01 4.6979301452636719e+01 -6.7437301635742188e+01 -4.7811298370361328e+01 4.1716197967529297e+01 -7.3951698303222656e+01 -4.9059398651123047e+01 2.8930398941040039e+01 -7.8114799499511719e+01 -4.9050800323486328e+01 1.4203499794006348e+01 -7.9383201599121094e+01 -4.9045101165771484e+01 -3.4461998939514160e-01 7.8330101013183594e+01 -5.4972999572753906e+01 1.7853500843048096e+00 7.6686698913574219e+01 -5.4976001739501953e+01 1.6111700057983398e+01 7.2120101928710938e+01 -5.4978099822998047e+01 3.0671701431274414e+01 6.4476997375488281e+01 -5.4979099273681641e+01 4.4562896728515625e+01 5.3966102600097656e+01 -5.4978401184082031e+01 5.6843299865722656e+01 7.5127197265625000e+01 -5.9610000610351562e+01 1.2114600181579590e+01 7.5355300903320312e+01 -6.0731601715087891e+01 -1.7170599699020386e+00 7.1428794860839844e+01 -5.9612503051757812e+01 2.6272998809814453e+01 6.4126296997070312e+01 -6.0734100341796875e+01 3.9661300659179688e+01 5.3850097656250000e+01 -6.1509799957275391e+01 5.2007102966308594e+01 4.1205699920654297e+01 -5.4979000091552734e+01 6.6670997619628906e+01 2.7057100296020508e+01 -5.4977699279785156e+01 7.3550094604492188e+01 1.2475700378417969e+01 -5.4975402832031250e+01 7.7358497619628906e+01 -1.2114600181579590e+01 -5.9610000610351562e+01 7.5127197265625000e+01 1.7341400384902954e+00 -5.9608001708984375e+01 7.6071098327636719e+01 4.2893001556396484e+01 -6.0733798980712891e+01 6.2013099670410156e+01 2.9782499313354492e+01 -5.9612998962402344e+01 7.0040397644042969e+01 1.5645200729370117e+01 -5.9610603332519531e+01 7.4474800109863281e+01 5.6481498718261719e+01 -6.5751998901367188e+01 4.0724998474121094e+01 6.7513504028320312e+01 -6.3559398651123047e+01 2.6707201004028320e+01 7.1374496459960938e+01 -6.3563102722167969e+01 1.3211199760437012e+01 6.9488693237304688e+01 -6.5759704589843750e+01 1.4108999967575073e+00 6.7285202026367188e+01 -6.5753700256347656e+01 1.7788499832153320e+01 2.8395601272583008e+01 -6.3558399200439453e+01 6.6799201965332031e+01 4.3375499725341797e+01 -6.5742904663085938e+01 5.4680000305175781e+01 -5.1130700111389160e+00 -6.3596702575683594e+01 7.2644706726074219e+01 1.5174099922180176e+01 -6.5649505615234375e+01 6.8473693847656250e+01 -1.6111700057983398e+01 -5.4976001739501953e+01 7.6686698913574219e+01 -3.0671701431274414e+01 -5.4978099822998047e+01 7.2120101928710938e+01 -4.4562896728515625e+01 -5.4979099273681641e+01 6.4476997375488281e+01 -5.6843299865722656e+01 -5.4978401184082031e+01 5.3966102600097656e+01 -2.6272998809814453e+01 -5.9612503051757812e+01 7.1428794860839844e+01 -3.9661300659179688e+01 -6.0734100341796875e+01 6.4126296997070312e+01 -5.1923801422119141e+01 -6.0734001159667969e+01 5.4677501678466797e+01 -7.7358497619628906e+01 -5.4975402832031250e+01 1.2475700378417969e+01 -6.6670997619628906e+01 -5.4979000091552734e+01 4.1205699920654297e+01 -7.3550094604492188e+01 -5.4977699279785156e+01 2.7057100296020508e+01 -7.8330101013183594e+01 -5.4972999572753906e+01 -1.7853500843048096e+00 -6.2013099670410156e+01 -6.0733798980712891e+01 4.2893001556396484e+01 -7.0040397644042969e+01 -5.9612998962402344e+01 2.9782499313354492e+01 -7.5355300903320312e+01 -6.0731601715087891e+01 1.7170599699020386e+00 -7.4474800109863281e+01 -5.9610603332519531e+01 1.5645200729370117e+01 -2.5049600601196289e+01 -6.3557998657226562e+01 6.8122604370117188e+01 -4.9207698822021484e+01 -6.5768600463867188e+01 4.9181400299072266e+01 -3.6946399688720703e+01 -6.5759101867675781e+01 5.8903797149658203e+01 -2.1015600204467773e+01 -6.5753700256347656e+01 6.6359199523925781e+01 -5.9104999542236328e+01 -6.5766296386718750e+01 3.6562202453613281e+01 -6.7477394104003906e+01 -6.3571102142333984e+01 2.6760299682617188e+01 -7.1366401672363281e+01 -6.3561000823974609e+01 1.3268600463867188e+01 -6.7285202026367188e+01 -6.5753700256347656e+01 1.7788499832153320e+01 -6.9456398010253906e+01 -6.5766296386718750e+01 -1.5821199417114258e+00 4.8838300704956055e+00 -6.5753700256347656e+01 6.9384094238281250e+01 -6.5954093933105469e+01 -6.5003295898437500e+01 -1.1007699966430664e+01 -6.3504100799560547e+01 -6.5001693725585938e+01 2.0110498428344727e+01 -6.6359199523925781e+01 -6.5753700256347656e+01 -2.1015600204467773e+01 -2.0092599868774414e+01 -6.4940101623535156e+01 -6.3447898864746094e+01 -4.1918899536132812e+01 -6.5744300842285156e+01 -5.5662799835205078e+01 -1.5174099922180176e+01 -6.5649505615234375e+01 -6.8473693847656250e+01 -5.0577800750732422e+01 -6.4940101623535156e+01 4.3333198547363281e+01 -2.5114198684692383e+01 -6.5005798339843750e+01 6.1894699096679688e+01 -4.6691398620605469e+00 -6.4939994812011719e+01 6.6339698791503906e+01 -5.6185497283935547e+01 -6.5768501281738281e+01 -4.1026100158691406e+01 -5.9442901611328125e+01 -6.4974800109863281e+01 -3.0091600418090820e+01 -4.3333198547363281e+01 -6.4940101623535156e+01 -5.0577800750732422e+01 -4.8838400840759277e+00 -6.5753700256347656e+01 -6.9384094238281250e+01 4.6691398620605469e+00 -6.4939994812011719e+01 -6.6339698791503906e+01 -6.1515499114990234e+01 -6.6084396362304688e+01 7.3676099777221680e+00 -3.9422199249267578e+01 -6.6119201660156250e+01 4.7579696655273438e+01 -4.8702198028564453e+01 -6.5940795898437500e+01 3.9441997528076172e+01 -8.7784500122070312e+00 -6.6089698791503906e+01 6.1264701843261719e+01 3.0705200195312500e+01 -6.6117897033691406e+01 5.3397201538085938e+01 1.5252799987792969e+01 -6.5862602233886719e+01 6.1349498748779297e+01 5.0155899047851562e+01 -6.6073204040527344e+01 3.6021900177001953e+01 4.3594100952148438e+01 -6.4963195800781250e+01 5.0356700897216797e+01 6.0698596954345703e+01 -6.6066696166992188e+01 -6.7463498115539551e+00 6.6711799621582031e+01 -6.5003898620605469e+01 1.3542500138282776e-01 5.9121696472167969e+01 -6.6100502014160156e+01 1.8429199218750000e+01 5.9817501068115234e+01 -6.4940101623535156e+01 2.9234298706054688e+01 2.0092599868774414e+01 -6.4940101623535156e+01 6.3447898864746094e+01 -2.4017601013183594e+01 -6.4924705505371094e+01 4.4330997467041016e+01 -1.2296899795532227e+01 -6.4922195434570312e+01 4.8861900329589844e+01 -4.9878101348876953e+01 -6.4923797607421875e+01 6.1260700225830078e+00 -4.7621898651123047e+01 -6.5026702880859375e+01 2.0646100997924805e+01 -5.8962200164794922e+01 -6.6058395385742188e+01 -1.6372301101684570e+01 -4.9968898773193359e+01 -6.4928802490234375e+01 -5.5101404190063477e+00 -4.6904499053955078e+01 -6.4901504516601562e+01 -1.8820098876953125e+01 -4.1162097930908203e+01 -6.4915802001953125e+01 -2.8893501281738281e+01 -4.1316501617431641e+01 -6.6128295898437500e+01 -4.6076801300048828e+01 -3.1769998550415039e+01 -6.4940605163574219e+01 -3.8861301422119141e+01 -1.5955600738525391e+01 -6.4898902893066406e+01 -4.8028099060058594e+01 -3.6749000549316406e+01 -6.5010696411132812e+01 3.6192996978759766e+01 -7.4321599006652832e+00 -6.6034599304199219e+01 -6.0313198089599609e+01 -4.9870600700378418e+00 -6.5038299560546875e+01 -5.1429000854492188e+01 6.1151897907257080e-01 -6.4899902343750000e+01 5.0388702392578125e+01 4.0430500030517578e+01 -6.6047805786132812e+01 -4.7272399902343750e+01 2.1093599319458008e+01 -6.5008094787597656e+01 -4.7210800170898438e+01 5.7853302955627441e+00 -6.4969100952148438e+01 -5.0313201904296875e+01 4.5625198364257812e+01 -6.5076095581054688e+01 -2.5078199386596680e+01 5.2289600372314453e+01 -6.5047103881835938e+01 -4.6615300178527832e+00 4.9076499938964844e+01 -6.5030502319335938e+01 1.6025699615478516e+01 3.6085098266601562e+01 -6.4887702941894531e+01 3.5027797698974609e+01 4.5658901214599609e+01 -6.4956298828125000e+01 2.1977499008178711e+01 1.2848500251770020e+01 -6.4922805786132812e+01 4.8701698303222656e+01 2.4957799911499023e+01 -6.4924301147460938e+01 4.3825702667236328e+01 3.6392799377441406e+01 -6.5013999938964844e+01 -3.6605201721191406e+01 5.6047599792480469e+01 -6.6018997192382812e+01 -2.7524799346923828e+01 4.4547400474548340e+00 -6.5808799743652344e+01 -6.3284599304199219e+01 2.7442001342773438e+01 -6.5952598571777344e+01 -5.6365200042724609e+01 -1.7475801467895508e+01 -6.5855598449707031e+01 -6.0778099060058594e+01 6.3447898864746094e+01 -6.4940101623535156e+01 -2.0092599868774414e+01 5.0577800750732422e+01 -6.4940101623535156e+01 -4.3333198547363281e+01 2.9234298706054688e+01 -6.4940101623535156e+01 -5.9817501068115234e+01 2.1015600204467773e+01 -6.5753700256347656e+01 -6.6359199523925781e+01 5.6820499420166016e+01 -6.5761795043945312e+01 -4.0331298828125000e+01 6.6359199523925781e+01 -6.5753700256347656e+01 -2.1015600204467773e+01 4.3921298980712891e+01 -6.5758102416992188e+01 -5.3944599151611328e+01 1.5645200729370117e+01 -3.8389400482177734e+01 -7.4474800109863281e+01 1.7341400384902954e+00 -3.8391998291015625e+01 -7.6071098327636719e+01 -5.1130700111389160e+00 -3.4403301239013672e+01 -7.2644706726074219e+01 -6.7477394104003906e+01 -3.4428897857666016e+01 -2.6760299682617188e+01 -7.1366401672363281e+01 -3.4439002990722656e+01 -1.3268600463867188e+01 -7.0040397644042969e+01 -3.8387001037597656e+01 -2.9782499313354492e+01 -7.4474800109863281e+01 -3.8389400482177734e+01 -1.5645200729370117e+01 -6.2013099670410156e+01 -3.7266197204589844e+01 -4.2893001556396484e+01 -5.1923801422119141e+01 -3.7266002655029297e+01 -5.4677501678466797e+01 -5.1424598693847656e+01 -3.3472698211669922e+01 -4.9469097137451172e+01 -3.9661300659179688e+01 -3.7265899658203125e+01 -6.4126296997070312e+01 -6.6670997619628906e+01 -4.3020999908447266e+01 -4.1205699920654297e+01 -7.3550094604492188e+01 -4.3022300720214844e+01 -2.7057100296020508e+01 -7.7358497619628906e+01 -4.3024600982666016e+01 -1.2475700378417969e+01 -5.6843299865722656e+01 -4.3021598815917969e+01 -5.3966102600097656e+01 -2.5049600601196289e+01 -3.4442001342773438e+01 -6.8122604370117188e+01 -4.4562896728515625e+01 -4.3020900726318359e+01 -6.4476997375488281e+01 -1.2114600181579590e+01 -3.8389999389648438e+01 -7.5127197265625000e+01 -2.6272998809814453e+01 -3.8387500762939453e+01 -7.1428794860839844e+01 -3.0671701431274414e+01 -4.3021900177001953e+01 -7.2120101928710938e+01 -1.6111700057983398e+01 -4.3023998260498047e+01 -7.6686698913574219e+01 -1.7856500148773193e+00 -4.3026500701904297e+01 -7.8329895019531250e+01 -7.7977600097656250e+01 -4.9052101135253906e+01 -1.4941699981689453e+01 -7.3644798278808594e+01 -4.9060401916503906e+01 -2.9704099655151367e+01 -6.6202606201171875e+01 -4.9065898895263672e+01 -4.3869800567626953e+01 -5.5839900970458984e+01 -4.9067699432373047e+01 -5.6477798461914062e+01 -4.3129802703857422e+01 -4.9065399169921875e+01 -6.6686599731445312e+01 -2.8930398941040039e+01 -4.9059398651123047e+01 -7.3951698303222656e+01 -1.4203499794006348e+01 -4.9050800323486328e+01 -7.8114799499511719e+01 3.4459200501441956e-01 -4.9045101165771484e+01 -7.9383300781250000e+01 6.4126296997070312e+01 -3.7265899658203125e+01 -3.9661300659179688e+01 5.3850097656250000e+01 -3.6490200042724609e+01 -5.2007102966308594e+01 1.2475700378417969e+01 -4.3024600982666016e+01 -7.7358497619628906e+01 2.9782499313354492e+01 -3.8387001037597656e+01 -7.0040397644042969e+01 4.2893001556396484e+01 -3.7266197204589844e+01 -6.2013099670410156e+01 2.8395601272583008e+01 -3.4441600799560547e+01 -6.6799201965332031e+01 2.7057100296020508e+01 -4.3022300720214844e+01 -7.3550094604492188e+01 4.1205699920654297e+01 -4.3020999908447266e+01 -6.6670997619628906e+01 5.3966102600097656e+01 -4.3021598815917969e+01 -5.6843299865722656e+01 6.7513504028320312e+01 -3.4440597534179688e+01 -2.6707201004028320e+01 6.4476997375488281e+01 -4.3020900726318359e+01 -4.4562896728515625e+01 7.1374496459960938e+01 -3.4436901092529297e+01 -1.3211199760437012e+01 7.5127197265625000e+01 -3.8389999389648438e+01 -1.2114600181579590e+01 7.1428794860839844e+01 -3.8387500762939453e+01 -2.6272998809814453e+01 7.2120101928710938e+01 -4.3021900177001953e+01 -3.0671701431274414e+01 7.6686698913574219e+01 -4.3023998260498047e+01 -1.6111700057983398e+01 1.4941699981689453e+01 -4.9052101135253906e+01 -7.7977600097656250e+01 2.9704099655151367e+01 -4.9060401916503906e+01 -7.3644798278808594e+01 4.1731800079345703e+01 -4.9570999145507812e+01 -6.7475105285644531e+01 4.9999198913574219e+01 -4.8999500274658203e+01 -6.1567001342773438e+01 5.7531902313232422e+01 -4.8420101165771484e+01 -5.4633300781250000e+01 1.7856500148773193e+00 -5.4973503112792969e+01 -7.8329895019531250e+01 6.6202606201171875e+01 -4.8934097290039062e+01 -4.3869800567626953e+01 7.3644798278808594e+01 -4.8939601898193359e+01 -2.9704099655151367e+01 7.7977600097656250e+01 -4.8947898864746094e+01 -1.4941699981689453e+01 -7.6686698913574219e+01 -5.4976001739501953e+01 -1.6111700057983398e+01 -7.2120101928710938e+01 -5.4978099822998047e+01 -3.0671701431274414e+01 -6.4476997375488281e+01 -5.4979099273681641e+01 -4.4562896728515625e+01 -5.3966102600097656e+01 -5.4978401184082031e+01 -5.6843299865722656e+01 -7.5127197265625000e+01 -5.9610000610351562e+01 -1.2114600181579590e+01 -7.1428794860839844e+01 -5.9612503051757812e+01 -2.6272998809814453e+01 -6.4126296997070312e+01 -6.0734100341796875e+01 -3.9661300659179688e+01 -5.3850097656250000e+01 -6.1509799957275391e+01 -5.2007102966308594e+01 -4.1205699920654297e+01 -5.4979000091552734e+01 -6.6670997619628906e+01 -2.7057100296020508e+01 -5.4977699279785156e+01 -7.3550094604492188e+01 -1.2475700378417969e+01 -5.4975402832031250e+01 -7.7358497619628906e+01 1.2114600181579590e+01 -5.9610000610351562e+01 -7.5127197265625000e+01 -1.7341400384902954e+00 -5.9608001708984375e+01 -7.6071098327636719e+01 -4.2893001556396484e+01 -6.0733798980712891e+01 -6.2013099670410156e+01 -2.9782499313354492e+01 -5.9612998962402344e+01 -7.0040397644042969e+01 -1.5645200729370117e+01 -5.9610603332519531e+01 -7.4474800109863281e+01 -6.7513504028320312e+01 -6.3559398651123047e+01 -2.6707201004028320e+01 -7.1374496459960938e+01 -6.3563102722167969e+01 -1.3211199760437012e+01 -2.8395601272583008e+01 -6.3558399200439453e+01 -6.6799201965332031e+01 5.1130599975585938e+00 -6.3596702575683594e+01 -7.2644706726074219e+01 2.5049600601196289e+01 -6.3557998657226562e+01 -6.8122604370117188e+01 1.6111700057983398e+01 -5.4976001739501953e+01 -7.6686698913574219e+01 3.0671701431274414e+01 -5.4978099822998047e+01 -7.2120101928710938e+01 4.2744701385498047e+01 -5.6259502410888672e+01 -6.5250297546386719e+01 5.6843299865722656e+01 -5.4978401184082031e+01 -5.3966102600097656e+01 2.6272998809814453e+01 -5.9612503051757812e+01 -7.1428794860839844e+01 5.1923801422119141e+01 -6.0734001159667969e+01 -5.4677501678466797e+01 3.8678096771240234e+01 -6.2713600158691406e+01 -6.2656597137451172e+01 7.7358497619628906e+01 -5.4975402832031250e+01 -1.2475700378417969e+01 6.6670997619628906e+01 -5.4979000091552734e+01 -4.1205699920654297e+01 7.3550094604492188e+01 -5.4977699279785156e+01 -2.7057100296020508e+01 6.2013099670410156e+01 -6.0733798980712891e+01 -4.2893001556396484e+01 7.0040397644042969e+01 -5.9612998962402344e+01 -2.9782499313354492e+01 7.4474800109863281e+01 -5.9610603332519531e+01 -1.5645200729370117e+01 6.7477394104003906e+01 -6.3571102142333984e+01 -2.6760299682617188e+01 7.1366401672363281e+01 -6.3561000823974609e+01 -1.3268600463867188e+01 -4.6283000946044922e+01 -3.3059700012207031e+01 4.8698802947998047e+01 -6.3504100799560547e+01 -3.2998302459716797e+01 2.0110498428344727e+01 -5.2329101562500000e+01 -3.2130302429199219e+01 -3.4909000396728516e+01 -6.1349498748779297e+01 -3.2137401580810547e+01 -1.5252799987792969e+01 -3.8747798919677734e+01 -3.2020099639892578e+01 4.9141799926757812e+01 2.8352600097656250e+01 -3.2989597320556641e+01 4.3039199829101562e+01 1.5969698905944824e+01 -3.3055599212646484e+01 4.7725498199462891e+01 3.9991699218750000e+01 -3.3097698211669922e+01 3.0614299774169922e+01 4.8633197784423828e+01 -3.3084796905517578e+01 1.3720000267028809e+01 5.0044700622558594e+01 -3.3111999511718750e+01 -5.6227302551269531e+00 3.5953800201416016e+01 -3.3097698211669922e+01 -3.5078903198242188e+01 4.5476398468017578e+01 -3.3045200347900391e+01 -2.1894300460815430e+01 9.9145097732543945e+00 -3.3083801269531250e+01 -4.9431201934814453e+01 2.5745399475097656e+01 -3.3058502197265625e+01 -4.3290298461914062e+01 4.9954399108886719e+01 -6.5034202575683594e+01 5.4540300369262695e+00 4.8967998504638672e+01 -6.7537704467773438e+01 1.3350299835205078e+01 5.0034500122070312e+01 -6.7539604187011719e+01 -4.1453199386596680e+00 -3.3270900726318359e+01 -6.5033500671386719e+01 3.7523998260498047e+01 -4.3557899475097656e+01 -6.7537895202636719e+01 2.6049699783325195e+01 -2.8130199432373047e+01 -6.7539604187011719e+01 4.1621601104736328e+01 -4.9887100219726562e+01 -6.7539398193359375e+01 6.8354101181030273e+00 -4.7150398254394531e+01 -6.5031204223632812e+01 1.8047500610351562e+01 -4.0905799865722656e+01 -6.5034301757812500e+01 2.9103500366210938e+01 -9.2679700851440430e+00 -6.7539001464843750e+01 4.9685398101806641e+01 9.3136892318725586e+00 -6.7538703918457031e+01 4.9535301208496094e+01 2.6869998931884766e+01 -6.7538597106933594e+01 4.2637798309326172e+01 4.0471401214599609e+01 -6.7539604187011719e+01 2.9807500839233398e+01 4.8870899200439453e+01 -6.5032897949218750e+01 -1.3342700004577637e+01 2.4033800125122070e+01 -6.5031997680664062e+01 -4.4287799835205078e+01 3.8291000366210938e+01 -6.5033897399902344e+01 -3.2910102844238281e+01 4.7313400268554688e+01 -6.7535400390625000e+01 -1.8334699630737305e+01 -4.8967998504638672e+01 -6.7537704467773438e+01 -1.3350299835205078e+01 -6.9415998458862305e+00 -6.7539398193359375e+01 -4.9904800415039062e+01 3.7271400451660156e+01 -6.7538406372070312e+01 -3.3985900878906250e+01 2.5166799545288086e+01 -6.7537002563476562e+01 -4.3544601440429688e+01 1.0624900817871094e+01 -6.7538406372070312e+01 -4.9357997894287109e+01 -2.6072299957275391e+01 -6.7537796020507812e+01 -4.3274299621582031e+01 -4.0471401214599609e+01 -6.7539604187011719e+01 -2.9807500839233398e+01 1.2806200027465820e+01 -8.1073295593261719e+01 -3.8097999095916748e+00 1.3205300331115723e+01 -8.0267494201660156e+01 -5.5868902206420898e+00 1.3861199378967285e+01 -8.0269203186035156e+01 4.1422801017761230e+00 6.8685703277587891e+00 -8.0269203186035156e+01 -1.2765500068664551e+01 -3.6473600864410400e+00 -8.0430801391601562e+01 -1.3761699676513672e+01 -5.0008997917175293e+00 -8.1080497741699219e+01 1.2562399864196777e+01 6.8692898750305176e+00 -8.0268096923828125e+01 1.2766799926757812e+01 -2.6745600700378418e+00 -8.0267105102539062e+01 1.4119600296020508e+01 -1.0887900352478027e+01 -8.1082099914550781e+01 -8.1607704162597656e+00 -1.2876600265502930e+01 -8.1073501586914062e+01 3.7914199829101562e+00 -1.3522299766540527e+01 -8.0268005371093750e+01 -5.6108503341674805e+00 -1.2266799926757812e+01 -8.0268394470214844e+01 8.1145401000976562e+00 1.4918000221252441e+01 -8.0275100708007812e+01 -3.5685497283935547e+01 3.7123301029205322e+00 -8.0275100708007812e+01 -3.8456001281738281e+01 5.6025695800781250e+00 -6.7521499633789062e+01 -3.8081703186035156e+01 1.6305999755859375e+01 -6.7521499633789062e+01 -3.5007499694824219e+01 3.6341297149658203e+01 -6.7521499633789062e+01 -1.3186100006103516e+01 3.0869201660156250e+01 -8.0274299621582031e+01 -2.3010200500488281e+01 2.9183500289916992e+01 -6.7522102355957031e+01 -2.5193401336669922e+01 2.3136499404907227e+01 -8.0274299621582031e+01 -3.0677999496459961e+01 3.8549598693847656e+01 -8.0275100708007812e+01 -1.6160999536514282e+00 3.7004398345947266e+01 -8.0275100708007812e+01 -1.1183599472045898e+01 3.8620300292968750e+01 -6.7521499633789062e+01 8.1181198358535767e-01 -4.5067396163940430e+00 -6.7521499633789062e+01 -3.8375400543212891e+01 2.5930200576782227e+01 -8.0275100708007812e+01 2.8557600021362305e+01 3.1677902221679688e+01 -8.0274200439453125e+01 2.1873998641967773e+01 3.1033300399780273e+01 -6.7523498535156250e+01 2.2732900619506836e+01 2.0160699844360352e+01 -6.7523300170898438e+01 3.2750801086425781e+01 6.2813601493835449e+00 -6.7521499633789062e+01 3.8171100616455078e+01 1.6532600402832031e+01 -8.0275100708007812e+01 3.4899303436279297e+01 3.7707702636718750e+01 -8.0275100708007812e+01 8.4654598236083984e+00 3.6223800659179688e+01 -6.7521499633789062e+01 1.2949000358581543e+01 5.2079100608825684e+00 -8.0275100708007812e+01 3.8213302612304688e+01 -3.4080798625946045e+00 -8.0275100708007812e+01 3.8494800567626953e+01 -3.7614700317382812e+01 -8.0275100708007812e+01 9.4110794067382812e+00 -1.6054100036621094e+01 -8.0275100708007812e+01 -3.5240402221679688e+01 -5.2079100608825684e+00 -8.0275100708007812e+01 -3.8213302612304688e+01 -3.8329299926757812e+01 -8.0275100708007812e+01 -5.8210501670837402e+00 -3.2840499877929688e+01 -8.0274406433105469e+01 -1.9909101486206055e+01 -2.6819799423217773e+01 -8.0275001525878906e+01 -2.7747999191284180e+01 -1.7555700302124023e+01 -8.0275001525878906e+01 3.4412902832031250e+01 -3.1601600646972656e+01 -8.0274200439453125e+01 2.1895799636840820e+01 -2.5230501174926758e+01 -8.0274902343750000e+01 2.9101999282836914e+01 -3.3142398834228516e+01 -6.7523193359375000e+01 -1.9787399291992188e+01 -2.4508100509643555e+01 -6.7522598266601562e+01 -2.9667200088500977e+01 -3.8129898071289062e+01 -6.7521499633789062e+01 6.3573803901672363e+00 -3.7880397796630859e+01 -6.7521499633789062e+01 -7.4131999015808105e+00 -1.6590700149536133e+01 -6.7521499633789062e+01 -3.4709499359130859e+01 -2.8872499465942383e+01 -6.7521804809570312e+01 2.5504301071166992e+01 -1.9341501235961914e+01 -6.7523002624511719e+01 3.3339103698730469e+01 -3.4695800781250000e+01 -6.7521499633789062e+01 1.6600400924682617e+01 -7.6062998771667480e+00 -6.7521499633789062e+01 3.7799701690673828e+01 -4.9609901428222656e+01 -3.0460399627685547e+01 8.1507596969604492e+00 -4.9868400573730469e+01 -3.0460399627685547e+01 -6.8321399688720703e+00 -4.9947601318359375e+01 -3.2965702056884766e+01 -5.4530901908874512e+00 -4.4943298339843750e+01 -3.0460399627685547e+01 2.2791400909423828e+01 -3.5167198181152344e+01 -3.0460399627685547e+01 3.5853599548339844e+01 -4.9730598449707031e+01 -3.2965702056884766e+01 6.7970499992370605e+00 2.9969398975372314e+00 -3.2965702056884766e+01 5.0145702362060547e+01 6.9386696815490723e+00 -3.0460399627685547e+01 4.9888397216796875e+01 4.8833702087402344e+01 -3.0460399627685547e+01 1.3304400444030762e+01 4.0471401214599609e+01 -3.0460399627685547e+01 2.9807500839233398e+01 4.9868400573730469e+01 -3.0460399627685547e+01 -6.8321399688720703e+00 2.5877500534057617e+01 -3.0460399627685547e+01 4.3248897552490234e+01 2.9460500717163086e+01 -3.2965702056884766e+01 4.0491600036621094e+01 -1.0601699829101562e+01 -3.0460399627685547e+01 4.9272800445556641e+01 -2.4852701187133789e+01 -3.0460399627685547e+01 4.3484500885009766e+01 -2.9969398975372314e+00 -3.2965702056884766e+01 -5.0145702362060547e+01 -4.6939998626708984e+01 -3.2965702056884766e+01 -1.7957401275634766e+01 4.3438598632812500e+01 -3.0460399627685547e+01 -2.5998600006103516e+01 -2.4852701187133789e+01 -3.0460399627685547e+01 -4.3484500885009766e+01 -1.0601699829101562e+01 -3.0460399627685547e+01 -4.9272800445556641e+01 1.7176401138305664e+01 -3.0460399627685547e+01 -4.7315002441406250e+01 3.1059000015258789e+01 -3.0460399627685547e+01 -3.9376998901367188e+01 2.9829699993133545e+00 -3.0460399627685547e+01 -5.0146999359130859e+01 -3.5167198181152344e+01 -3.0460399627685547e+01 -3.5853599548339844e+01 -4.4943298339843750e+01 -3.0460399627685547e+01 -2.2791400909423828e+01 -1.1755400657653809e+01 -8.1032798767089844e+01 1.1027499437332153e+00 1.0264200210571289e+01 -2.9614400863647461e+01 2.9392998218536377e+00 1.0690099716186523e+01 -4.1044399261474609e+01 0.0000000000000000e+00 8.1825199127197266e+00 -2.9608499526977539e+01 6.8735299110412598e+00 5.0151400566101074e+00 -2.9599399566650391e+01 9.4172601699829102e+00 -6.3304600715637207e+00 -2.9442100524902344e+01 -1.2118599891662598e+01 -5.5505099296569824e+00 -2.9454700469970703e+01 1.2124200820922852e+01 -1.3189299583435059e+01 -2.9452299118041992e+01 -2.1639201641082764e+00 -1.1655500411987305e+01 -2.9457300186157227e+01 6.2997603416442871e+00 6.3305301666259766e+00 -2.9442100524902344e+01 1.2118599891662598e+01 1.3189299583435059e+01 -2.9452299118041992e+01 2.1639201641082764e+00 1.2706499099731445e+01 -3.0459199905395508e+01 -6.5114102363586426e+00 3.8211998939514160e+00 -3.0459899902343750e+01 -1.4019599914550781e+01 -3.8208501338958740e+00 -3.0458499908447266e+01 1.4018300056457520e+01 8.3117198944091797e+00 -3.0458000183105469e+01 1.1874300003051758e+01 1.4127900123596191e+01 -3.0459999084472656e+01 3.0538599491119385e+00 -1.2706499099731445e+01 -3.0459199905395508e+01 6.5114398002624512e+00 -8.3115901947021484e+00 -3.0458000183105469e+01 -1.1874400138854980e+01 -1.4127199172973633e+01 -3.0459199905395508e+01 -3.0536701679229736e+00 )) mat)))
                  )
                 ))
      (send glv :transform local-cds)
      (send glv :calc-normals)
      (setq qhull
            ;; qhull 3000 -> 81 faces
            (instance faceset :init :faces (list
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.1677901744842529e+01 -8.0274201929569244e+01 2.1873999387025833e+01) (float-vector 1.6532599925994873e+01 -8.0275103449821472e+01 3.4899301826953888e+01) (float-vector 1.5174100175499916e+01 -6.5649501979351044e+01 6.8473696708679199e+01) (float-vector 4.3375499546527863e+01 -6.5742902457714081e+01 5.4680000990629196e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.7057100087404251e+01 -5.4977700114250183e+01 7.3550097644329071e+01) (float-vector 3.0671700835227966e+01 -4.3021898716688156e+01 7.2120100259780884e+01) (float-vector 4.4562898576259613e+01 -4.3020900338888168e+01 6.4476996660232544e+01) (float-vector 5.6477800011634827e+01 -4.8932299017906189e+01 5.5839899927377701e+01) (float-vector 4.2892999947071075e+01 -6.0733798891305923e+01 6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.6477800011634827e+01 -4.8932299017906189e+01 5.5839899927377701e+01) (float-vector 6.6686600446701050e+01 -4.8934601247310638e+01 4.3129801750183105e+01) (float-vector 6.4126297831535339e+01 -6.0734100639820099e+01 3.9661299437284470e+01) (float-vector 4.3375499546527863e+01 -6.5742902457714081e+01 5.4680000990629196e+01) (float-vector 4.2892999947071075e+01 -6.0733798891305923e+01 6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.1731800884008408e+01 -4.9571000039577484e+01 -6.7475102841854095e+01) (float-vector 2.7057100087404251e+01 -4.3022301048040390e+01 -7.3550097644329071e+01) (float-vector 3.4459200105629861e-01 -4.9045100808143616e+01 -7.9383298754692078e+01) (float-vector 1.2114600278437138e+01 -5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector 3.0671700835227966e+01 -5.4978098720312119e+01 -7.2120100259780884e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7341399798169732e+00 -3.8391999900341034e+01 -7.6071098446846008e+01) (float-vector -1.2114600278437138e+01 -3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector 3.4459200105629861e-01 -4.9045100808143616e+01 -7.9383298754692078e+01) (float-vector 2.7057100087404251e+01 -4.3022301048040390e+01 -7.3550097644329071e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.7614699453115463e+01 -8.0275103449821472e+01 9.4110798090696335e+00) (float-vector -6.7285202443599701e+01 -6.5753698348999023e+01 1.7788499593734741e+01) (float-vector -7.0040397346019745e+01 -5.9613000601530075e+01 2.9782500118017197e+01) (float-vector -6.2013100832700729e+01 -6.0733798891305923e+01 4.2892999947071075e+01) (float-vector -4.9207698553800583e+01 -6.5768599510192871e+01 4.9181401729583740e+01) (float-vector -2.5230500847101212e+01 -8.0274902284145355e+01 2.9101999476552010e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3129801750183105e+01 -4.8934601247310638e+01 6.6686600446701050e+01) (float-vector -3.9661299437284470e+01 -6.0734100639820099e+01 6.4126297831535339e+01) (float-vector -4.9207698553800583e+01 -6.5768599510192871e+01 4.9181401729583740e+01) (float-vector -6.2013100832700729e+01 -6.0733798891305923e+01 4.2892999947071075e+01) (float-vector -5.4402600973844528e+01 -4.9551699310541153e+01 5.7758700102567673e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.9661299437284470e+01 -6.0734100639820099e+01 6.4126297831535339e+01) (float-vector -4.3129801750183105e+01 -4.8934601247310638e+01 6.6686600446701050e+01) (float-vector -2.7057100087404251e+01 -4.3022301048040390e+01 7.3550097644329071e+01) (float-vector -1.4203500002622604e+01 -4.8949200659990311e+01 7.8114800155162811e+01) (float-vector -2.6272999122738838e+01 -5.9612501412630081e+01 7.1428798139095306e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.2892999947071075e+01 -3.7266198545694351e+01 6.2013100832700729e+01) (float-vector -5.3850099444389343e+01 -3.6490198224782944e+01 5.2007101476192474e+01) (float-vector -5.6481499224901199e+01 -3.2248001545667648e+01 4.0725000202655792e+01) (float-vector -4.3375499546527863e+01 -3.2257098704576492e+01 5.4680000990629196e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.6819799095392227e+01 -8.0274999141693115e+01 -2.7747999876737595e+01) (float-vector -3.7614699453115463e+01 -8.0275103449821472e+01 9.4110798090696335e+00) (float-vector -2.5230500847101212e+01 -8.0274902284145355e+01 2.9101999476552010e+01) (float-vector -3.4080799669027328e+00 -8.0275103449821472e+01 3.8494799286127090e+01) (float-vector 1.6532599925994873e+01 -8.0275103449821472e+01 3.4899301826953888e+01) (float-vector 3.1677901744842529e+01 -8.0274201929569244e+01 2.1873999387025833e+01) (float-vector 3.7004400044679642e+01 -8.0275103449821472e+01 -1.1183599941432476e+01) (float-vector 2.3136500269174576e+01 -8.0274298787117004e+01 -3.0678000301122665e+01) (float-vector -5.2079102024435997e+00 -8.0275103449821472e+01 -3.8213301450014114e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 2.7057100087404251e+01 -5.4977700114250183e+01 7.3550097644329071e+01) (float-vector 1.7341399798169732e+00 -5.9608001261949539e+01 7.6071098446846008e+01) (float-vector 3.4459200105629861e-01 -4.8954900354146957e+01 7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7341399798169732e+00 -5.9608001261949539e+01 7.6071098446846008e+01) (float-vector 2.7057100087404251e+01 -5.4977700114250183e+01 7.3550097644329071e+01) (float-vector 4.2892999947071075e+01 -6.0733798891305923e+01 6.2013100832700729e+01) (float-vector 4.3375499546527863e+01 -6.5742902457714081e+01 5.4680000990629196e+01) (float-vector 1.5174100175499916e+01 -6.5649501979351044e+01 6.8473696708679199e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.7341399798169732e+00 -5.9608001261949539e+01 7.6071098446846008e+01) (float-vector 1.5174100175499916e+01 -6.5649501979351044e+01 6.8473696708679199e+01) (float-vector 1.6532599925994873e+01 -8.0275103449821472e+01 3.4899301826953888e+01) (float-vector -3.4080799669027328e+00 -8.0275103449821472e+01 3.8494799286127090e+01) (float-vector -2.1015599370002747e+01 -6.5753698348999023e+01 6.6359199583530426e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.9661299437284470e+01 -6.0734100639820099e+01 6.4126297831535339e+01) (float-vector -2.6272999122738838e+01 -5.9612501412630081e+01 7.1428798139095306e+01) (float-vector -2.1015599370002747e+01 -6.5753698348999023e+01 6.6359199583530426e+01) (float-vector -3.4080799669027328e+00 -8.0275103449821472e+01 3.8494799286127090e+01) (float-vector -2.5230500847101212e+01 -8.0274902284145355e+01 2.9101999476552010e+01) (float-vector -4.9207698553800583e+01 -6.5768599510192871e+01 4.9181401729583740e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.4459200105629861e-01 -4.8954900354146957e+01 7.9383298754692078e+01) (float-vector 1.7341399798169732e+00 -5.9608001261949539e+01 7.6071098446846008e+01) (float-vector -2.1015599370002747e+01 -6.5753698348999023e+01 6.6359199583530426e+01) (float-vector -2.6272999122738838e+01 -5.9612501412630081e+01 7.1428798139095306e+01) (float-vector -1.4203500002622604e+01 -4.8949200659990311e+01 7.8114800155162811e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.3644801974296570e+01 -4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector 7.4474796652793884e+01 -5.9610601514577866e+01 -1.5645200386643410e+01) (float-vector 7.9383201897144318e+01 -4.8954900354146957e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.2892999947071075e+01 -3.7266198545694351e+01 -6.2013100832700729e+01) (float-vector 5.6185498833656311e+01 -3.2231498509645462e+01 -4.1026100516319275e+01) (float-vector 1.5174100175499916e+01 -3.2350499182939529e+01 -6.8473696708679199e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.2892999947071075e+01 -3.7266198545694351e+01 -6.2013100832700729e+01) (float-vector 2.7057100087404251e+01 -4.3022301048040390e+01 -7.3550097644329071e+01) (float-vector 4.1731800884008408e+01 -4.9571000039577484e+01 -6.7475102841854095e+01) (float-vector 5.3966101258993149e+01 -4.3021600693464279e+01 -5.6843299418687820e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.5174100175499916e+01 -3.2350499182939529e+01 -6.8473696708679199e+01) (float-vector 1.7341399798169732e+00 -3.8391999900341034e+01 -7.6071098446846008e+01) (float-vector 2.7057100087404251e+01 -4.3022301048040390e+01 -7.3550097644329071e+01) (float-vector 4.2892999947071075e+01 -3.7266198545694351e+01 -6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.4459200105629861e-01 -4.8954900354146957e+01 7.9383298754692078e+01) (float-vector 1.7856500344350934e+00 -4.3026499450206757e+01 7.8329898416996002e+01) (float-vector 3.0671700835227966e+01 -4.3021898716688156e+01 7.2120100259780884e+01) (float-vector 2.7057100087404251e+01 -5.4977700114250183e+01 7.3550097644329071e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6686600446701050e+01 -4.8934601247310638e+01 4.3129801750183105e+01) (float-vector 6.2013100832700729e+01 -3.7266198545694351e+01 4.2892999947071075e+01) (float-vector 7.3550097644329071e+01 -4.3022301048040390e+01 2.7057100087404251e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.2013100832700729e+01 -3.7266198545694351e+01 4.2892999947071075e+01) (float-vector 5.9105001389980316e+01 -3.2233700156211853e+01 3.6562200635671616e+01) (float-vector 7.1366399526596069e+01 -3.4439001232385635e+01 1.3268600217998028e+01) (float-vector 7.3550097644329071e+01 -4.3022301048040390e+01 2.7057100087404251e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.2013100832700729e+01 -3.7266198545694351e+01 4.2892999947071075e+01) (float-vector 6.6686600446701050e+01 -4.8934601247310638e+01 4.3129801750183105e+01) (float-vector 5.6477800011634827e+01 -4.8932299017906189e+01 5.5839899927377701e+01) (float-vector 4.4562898576259613e+01 -4.3020900338888168e+01 6.4476996660232544e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.3644801974296570e+01 -4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector 7.9383201897144318e+01 -4.8954900354146957e+01 -3.4461999894119799e-01) (float-vector 7.5355298817157745e+01 -3.7268400192260742e+01 1.7170599894598126e+00) (float-vector 7.1428798139095306e+01 -3.8387499749660492e+01 -2.6272999122738838e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.1366399526596069e+01 -3.4439001232385635e+01 1.3268600217998028e+01) (float-vector 7.5355298817157745e+01 -3.7268400192260742e+01 1.7170599894598126e+00) (float-vector 7.9383201897144318e+01 -4.8954900354146957e+01 -3.4461999894119799e-01) (float-vector 7.3550097644329071e+01 -4.3022301048040390e+01 2.7057100087404251e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.6185498833656311e+01 -6.5768502652645111e+01 -4.1026100516319275e+01) (float-vector -7.1374498307704926e+01 -6.3563100993633270e+01 -1.3211200013756752e+01) (float-vector -6.7285202443599701e+01 -6.5753698348999023e+01 1.7788499593734741e+01) (float-vector -3.7614699453115463e+01 -8.0275103449821472e+01 9.4110798090696335e+00) (float-vector -2.6819799095392227e+01 -8.0274999141693115e+01 -2.7747999876737595e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.3850099444389343e+01 -6.1509799212217331e+01 -5.2007101476192474e+01) (float-vector -5.6185498833656311e+01 -6.5768502652645111e+01 -4.1026100516319275e+01) (float-vector -2.6819799095392227e+01 -8.0274999141693115e+01 -2.7747999876737595e+01) (float-vector -4.1918899863958359e+01 -6.5744303166866302e+01 -5.5662799626588821e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.2079102024435997e+00 -8.0275103449821472e+01 -3.8213301450014114e+01) (float-vector -4.8838402144610882e+00 -6.5753698348999023e+01 -6.9384098052978516e+01) (float-vector -2.9782500118017197e+01 -5.9613000601530075e+01 -7.0040397346019745e+01) (float-vector -4.1918899863958359e+01 -6.5744303166866302e+01 -5.5662799626588821e+01) (float-vector -2.6819799095392227e+01 -8.0274999141693115e+01 -2.7747999876737595e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 1.2114600278437138e+01 -5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector 2.5049600750207901e+01 -6.3557997345924377e+01 -6.8122602999210358e+01) (float-vector 3.0671700835227966e+01 -5.4978098720312119e+01 -7.2120100259780884e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.1731800884008408e+01 -4.9571000039577484e+01 -6.7475102841854095e+01) (float-vector 3.0671700835227966e+01 -5.4978098720312119e+01 -7.2120100259780884e+01) (float-vector 2.5049600750207901e+01 -6.3557997345924377e+01 -6.8122602999210358e+01) (float-vector 4.3921299278736115e+01 -6.5758101642131805e+01 -5.3944598883390427e+01) (float-vector 5.6843299418687820e+01 -5.4978400468826294e+01 -5.3966101258993149e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.3921299278736115e+01 -6.5758101642131805e+01 -5.3944598883390427e+01) (float-vector 2.5049600750207901e+01 -6.3557997345924377e+01 -6.8122602999210358e+01) (float-vector 1.2114600278437138e+01 -5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector -4.8838402144610882e+00 -6.5753698348999023e+01 -6.9384098052978516e+01) (float-vector -5.2079102024435997e+00 -8.0275103449821472e+01 -3.8213301450014114e+01) (float-vector 2.3136500269174576e+01 -8.0274298787117004e+01 -3.0678000301122665e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3375499546527863e+01 -3.2257098704576492e+01 5.4680000990629196e+01) (float-vector -5.6481499224901199e+01 -3.2248001545667648e+01 4.0725000202655792e+01) (float-vector -6.9488696753978729e+01 -3.2240301370620728e+01 1.4109100447967649e+00) (float-vector -5.8180298656225204e+01 -3.2244600355625153e+01 -3.8144998252391815e+01) (float-vector -3.9661098271608353e+01 -3.2244000583887100e+01 -5.7238798588514328e+01) (float-vector 2.7445200830698013e+00 -2.9418099671602249e+01 -1.2800700031220913e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -3.9661098271608353e+01 -3.2244000583887100e+01 -5.7238798588514328e+01) (float-vector -5.8180298656225204e+01 -3.2244600355625153e+01 -3.8144998252391815e+01) (float-vector -6.6670998930931091e+01 -4.3021000921726227e+01 -4.1205700486898422e+01) (float-vector -5.5839899927377701e+01 -4.9067698419094086e+01 -5.6477800011634827e+01) (float-vector -4.3129801750183105e+01 -4.9065399914979935e+01 -6.6686600446701050e+01) (float-vector -3.9661299437284470e+01 -3.7265900522470474e+01 -6.4126297831535339e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.1015599370002747e+01 -3.2246299088001251e+01 -6.6359199583530426e+01) (float-vector 1.5174100175499916e+01 -3.2350499182939529e+01 -6.8473696708679199e+01) (float-vector 5.6185498833656311e+01 -3.2231498509645462e+01 -4.1026100516319275e+01) (float-vector 2.7445200830698013e+00 -2.9418099671602249e+01 -1.2800700031220913e+01) (float-vector -3.9661098271608353e+01 -3.2244000583887100e+01 -5.7238798588514328e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.1015599370002747e+01 -3.2246299088001251e+01 -6.6359199583530426e+01) (float-vector -1.2114600278437138e+01 -3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector 1.7341399798169732e+00 -3.8391999900341034e+01 -7.6071098446846008e+01) (float-vector 1.5174100175499916e+01 -3.2350499182939529e+01 -6.8473696708679199e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.1015599370002747e+01 -3.2246299088001251e+01 -6.6359199583530426e+01) (float-vector -3.9661098271608353e+01 -3.2244000583887100e+01 -5.7238798588514328e+01) (float-vector -3.9661299437284470e+01 -3.7265900522470474e+01 -6.4126297831535339e+01) (float-vector -1.2114600278437138e+01 -3.8389999419450760e+01 -7.5127199292182922e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -6.7285202443599701e+01 -6.5753698348999023e+01 1.7788499593734741e+01) (float-vector -7.5355298817157745e+01 -6.0731600970029831e+01 1.7170599894598126e+00) (float-vector -7.0040397346019745e+01 -5.9613000601530075e+01 2.9782500118017197e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.5355298817157745e+01 -6.0731600970029831e+01 1.7170599894598126e+00) (float-vector -6.7285202443599701e+01 -6.5753698348999023e+01 1.7788499593734741e+01) (float-vector -7.1374498307704926e+01 -6.3563100993633270e+01 -1.3211200013756752e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.5839899927377701e+01 -4.9067698419094086e+01 -5.6477800011634827e+01) (float-vector -6.4476996660232544e+01 -5.4979100823402405e+01 -4.4562898576259613e+01) (float-vector -5.3850099444389343e+01 -6.1509799212217331e+01 -5.2007101476192474e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.3644801974296570e+01 -4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector -6.4476996660232544e+01 -5.4979100823402405e+01 -4.4562898576259613e+01) (float-vector -5.5839899927377701e+01 -4.9067698419094086e+01 -5.6477800011634827e+01) (float-vector -6.6670998930931091e+01 -4.3021000921726227e+01 -4.1205700486898422e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.3951698839664459e+01 -4.9059398472309113e+01 2.8930399566888809e+01) (float-vector -7.0040397346019745e+01 -5.9613000601530075e+01 2.9782500118017197e+01) (float-vector -7.5355298817157745e+01 -6.0731600970029831e+01 1.7170599894598126e+00) (float-vector -7.9383201897144318e+01 -4.9045100808143616e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6686600446701050e+01 -4.8934601247310638e+01 4.3129801750183105e+01) (float-vector 7.2120100259780884e+01 -5.4978098720312119e+01 3.0671700835227966e+01) (float-vector 6.4126297831535339e+01 -6.0734100639820099e+01 3.9661299437284470e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.5127199292182922e+01 -5.9610001742839813e+01 1.2114600278437138e+01) (float-vector 7.2120100259780884e+01 -5.4978098720312119e+01 3.0671700835227966e+01) (float-vector 6.6686600446701050e+01 -4.8934601247310638e+01 4.3129801750183105e+01) (float-vector 7.3550097644329071e+01 -4.3022301048040390e+01 2.7057100087404251e+01) (float-vector 7.9383201897144318e+01 -4.8954900354146957e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.4474796652793884e+01 -5.9610601514577866e+01 -1.5645200386643410e+01) (float-vector 6.9488696753978729e+01 -6.5759703516960144e+01 1.4109000330790877e+00) (float-vector 7.5127199292182922e+01 -5.9610001742839813e+01 1.2114600278437138e+01) (float-vector 7.9383201897144318e+01 -4.8954900354146957e+01 -3.4461999894119799e-01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.4476996660232544e+01 -4.3020900338888168e+01 -4.4562898576259613e+01) (float-vector 6.6202603280544281e+01 -4.8934098333120346e+01 -4.3869800865650177e+01) (float-vector 7.3644801974296570e+01 -4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector 7.1428798139095306e+01 -3.8387499749660492e+01 -2.6272999122738838e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6202603280544281e+01 -4.8934098333120346e+01 -4.3869800865650177e+01) (float-vector 6.4476996660232544e+01 -4.3020900338888168e+01 -4.4562898576259613e+01) (float-vector 5.3966101258993149e+01 -4.3021600693464279e+01 -5.6843299418687820e+01) (float-vector 4.1731800884008408e+01 -4.9571000039577484e+01 -6.7475102841854095e+01) (float-vector 5.6843299418687820e+01 -5.4978400468826294e+01 -5.3966101258993149e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.1428798139095306e+01 -3.8387499749660492e+01 -2.6272999122738838e+01) (float-vector 5.6185498833656311e+01 -3.2231498509645462e+01 -4.1026100516319275e+01) (float-vector 4.2892999947071075e+01 -3.7266198545694351e+01 -6.2013100832700729e+01) (float-vector 5.3966101258993149e+01 -4.3021600693464279e+01 -5.6843299418687820e+01) (float-vector 6.4476996660232544e+01 -4.3020900338888168e+01 -4.4562898576259613e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 -3.2246299088001251e+01 -2.1015599370002747e+01) (float-vector 5.6185498833656311e+01 -3.2231498509645462e+01 -4.1026100516319275e+01) (float-vector 7.1428798139095306e+01 -3.8387499749660492e+01 -2.6272999122738838e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 -3.2246299088001251e+01 -2.1015599370002747e+01) (float-vector 7.1366399526596069e+01 -3.4439001232385635e+01 1.3268600217998028e+01) (float-vector 5.9105001389980316e+01 -3.2233700156211853e+01 3.6562200635671616e+01) (float-vector 2.7445200830698013e+00 -2.9418099671602249e+01 -1.2800700031220913e+01) (float-vector 5.6185498833656311e+01 -3.2231498509645462e+01 -4.1026100516319275e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.1366399526596069e+01 -3.4439001232385635e+01 1.3268600217998028e+01) (float-vector 6.6359199583530426e+01 -3.2246299088001251e+01 -2.1015599370002747e+01) (float-vector 7.1428798139095306e+01 -3.8387499749660492e+01 -2.6272999122738838e+01) (float-vector 7.5355298817157745e+01 -3.7268400192260742e+01 1.7170599894598126e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.5645200386643410e+01 -5.9610601514577866e+01 -7.4474796652793884e+01) (float-vector -2.9782500118017197e+01 -5.9613000601530075e+01 -7.0040397346019745e+01) (float-vector -4.8838402144610882e+00 -6.5753698348999023e+01 -6.9384098052978516e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.5645200386643410e+01 -5.9610601514577866e+01 -7.4474796652793884e+01) (float-vector -4.8838402144610882e+00 -6.5753698348999023e+01 -6.9384098052978516e+01) (float-vector 1.2114600278437138e+01 -5.9610001742839813e+01 -7.5127199292182922e+01) (float-vector 3.4459200105629861e-01 -4.9045100808143616e+01 -7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.4474796652793884e+01 -3.8389399647712708e+01 -1.5645200386643410e+01) (float-vector -5.8180298656225204e+01 -3.2244600355625153e+01 -3.8144998252391815e+01) (float-vector -6.9488696753978729e+01 -3.2240301370620728e+01 1.4109100447967649e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.4474796652793884e+01 -3.8389399647712708e+01 -1.5645200386643410e+01) (float-vector -7.3644801974296570e+01 -4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector -6.6670998930931091e+01 -4.3021000921726227e+01 -4.1205700486898422e+01) (float-vector -5.8180298656225204e+01 -3.2244600355625153e+01 -3.8144998252391815e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.3850099444389343e+01 -6.1509799212217331e+01 -5.2007101476192474e+01) (float-vector -6.4476996660232544e+01 -5.4979100823402405e+01 -4.4562898576259613e+01) (float-vector -7.3644801974296570e+01 -4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector -7.6686702668666840e+01 -5.4976001381874084e+01 -1.6111699864268303e+01) (float-vector -7.1374498307704926e+01 -6.3563100993633270e+01 -1.3211200013756752e+01) (float-vector -5.6185498833656311e+01 -6.5768502652645111e+01 -4.1026100516319275e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.9383201897144318e+01 -4.9045100808143616e+01 -3.4461999894119799e-01) (float-vector -7.6686702668666840e+01 -5.4976001381874084e+01 -1.6111699864268303e+01) (float-vector -7.3644801974296570e+01 -4.9060400575399399e+01 -2.9704099521040916e+01) (float-vector -7.4474796652793884e+01 -3.8389399647712708e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.1374498307704926e+01 -6.3563100993633270e+01 -1.3211200013756752e+01) (float-vector -7.6686702668666840e+01 -5.4976001381874084e+01 -1.6111699864268303e+01) (float-vector -7.9383201897144318e+01 -4.9045100808143616e+01 -3.4461999894119799e-01) (float-vector -7.5355298817157745e+01 -6.0731600970029831e+01 1.7170599894598126e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.0040397346019745e+01 -5.9613000601530075e+01 2.9782500118017197e+01) (float-vector -7.3951698839664459e+01 -4.9059398472309113e+01 2.8930399566888809e+01) (float-vector -6.4476996660232544e+01 -4.3020900338888168e+01 4.4562898576259613e+01) (float-vector -5.4402600973844528e+01 -4.9551699310541153e+01 5.7758700102567673e+01) (float-vector -6.2013100832700729e+01 -6.0733798891305923e+01 4.2892999947071075e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.2892999947071075e+01 -3.7266198545694351e+01 6.2013100832700729e+01) (float-vector -2.7057100087404251e+01 -4.3022301048040390e+01 7.3550097644329071e+01) (float-vector -4.3129801750183105e+01 -4.8934601247310638e+01 6.6686600446701050e+01) (float-vector -5.4402600973844528e+01 -4.9551699310541153e+01 5.7758700102567673e+01) (float-vector -6.4476996660232544e+01 -4.3020900338888168e+01 4.4562898576259613e+01) (float-vector -5.3850099444389343e+01 -3.6490198224782944e+01 5.2007101476192474e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 -6.5753698348999023e+01 -2.1015599370002747e+01) (float-vector 6.9488696753978729e+01 -6.5759703516960144e+01 1.4109000330790877e+00) (float-vector 7.4474796652793884e+01 -5.9610601514577866e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.9488696753978729e+01 -6.5759703516960144e+01 1.4109000330790877e+00) (float-vector 6.7513503134250641e+01 -6.3559398055076599e+01 2.6707200333476067e+01) (float-vector 7.5127199292182922e+01 -5.9610001742839813e+01 1.2114600278437138e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.7513503134250641e+01 -6.3559398055076599e+01 2.6707200333476067e+01) (float-vector 6.9488696753978729e+01 -6.5759703516960144e+01 1.4109000330790877e+00) (float-vector 6.6359199583530426e+01 -6.5753698348999023e+01 -2.1015599370002747e+01) (float-vector 3.7004400044679642e+01 -8.0275103449821472e+01 -1.1183599941432476e+01) (float-vector 3.1677901744842529e+01 -8.0274201929569244e+01 2.1873999387025833e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.7513503134250641e+01 -6.3559398055076599e+01 2.6707200333476067e+01) (float-vector 6.4126297831535339e+01 -6.0734100639820099e+01 3.9661299437284470e+01) (float-vector 7.2120100259780884e+01 -5.4978098720312119e+01 3.0671700835227966e+01) (float-vector 7.5127199292182922e+01 -5.9610001742839813e+01 1.2114600278437138e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.4126297831535339e+01 -6.0734100639820099e+01 3.9661299437284470e+01) (float-vector 6.7513503134250641e+01 -6.3559398055076599e+01 2.6707200333476067e+01) (float-vector 3.1677901744842529e+01 -8.0274201929569244e+01 2.1873999387025833e+01) (float-vector 4.3375499546527863e+01 -6.5742902457714081e+01 5.4680000990629196e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3375499546527863e+01 -3.2257098704576492e+01 5.4680000990629196e+01) (float-vector -1.5174100175499916e+01 -3.2350499182939529e+01 6.8473696708679199e+01) (float-vector -2.7057100087404251e+01 -4.3022301048040390e+01 7.3550097644329071e+01) (float-vector -4.2892999947071075e+01 -3.7266198545694351e+01 6.2013100832700729e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 4.4562898576259613e+01 -4.3020900338888168e+01 6.4476996660232544e+01) (float-vector 3.0671700835227966e+01 -4.3021898716688156e+01 7.2120100259780884e+01) (float-vector 2.1015599370002747e+01 -3.2246299088001251e+01 6.6359199583530426e+01) (float-vector 3.6946401000022888e+01 -3.2240901142358780e+01 5.8903798460960388e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 3.6946401000022888e+01 -3.2240901142358780e+01 5.8903798460960388e+01) (float-vector 5.9105001389980316e+01 -3.2233700156211853e+01 3.6562200635671616e+01) (float-vector 6.2013100832700729e+01 -3.7266198545694351e+01 4.2892999947071075e+01) (float-vector 4.4562898576259613e+01 -4.3020900338888168e+01 6.4476996660232544e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.2114600278437138e+01 -3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector -2.8930399566888809e+01 -4.9059398472309113e+01 -7.3951698839664459e+01) (float-vector 3.4459200105629861e-01 -4.9045100808143616e+01 -7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -4.3129801750183105e+01 -4.9065399914979935e+01 -6.6686600446701050e+01) (float-vector -2.8930399566888809e+01 -4.9059398472309113e+01 -7.3951698839664459e+01) (float-vector -1.2114600278437138e+01 -3.8389999419450760e+01 -7.5127199292182922e+01) (float-vector -3.9661299437284470e+01 -3.7265900522470474e+01 -6.4126297831535339e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -2.8930399566888809e+01 -4.9059398472309113e+01 -7.3951698839664459e+01) (float-vector -2.9782500118017197e+01 -5.9613000601530075e+01 -7.0040397346019745e+01) (float-vector -1.5645200386643410e+01 -5.9610601514577866e+01 -7.4474796652793884e+01) (float-vector 3.4459200105629861e-01 -4.9045100808143616e+01 -7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.3850099444389343e+01 -6.1509799212217331e+01 -5.2007101476192474e+01) (float-vector -4.1918899863958359e+01 -6.5744303166866302e+01 -5.5662799626588821e+01) (float-vector -2.9782500118017197e+01 -5.9613000601530075e+01 -7.0040397346019745e+01) (float-vector -2.8930399566888809e+01 -4.9059398472309113e+01 -7.3951698839664459e+01) (float-vector -4.3129801750183105e+01 -4.9065399914979935e+01 -6.6686600446701050e+01) (float-vector -5.5839899927377701e+01 -4.9067698419094086e+01 -5.6477800011634827e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -5.6481499224901199e+01 -3.2248001545667648e+01 4.0725000202655792e+01) (float-vector -7.1428798139095306e+01 -3.8387499749660492e+01 2.6272999122738838e+01) (float-vector -6.9488696753978729e+01 -3.2240301370620728e+01 1.4109100447967649e+00)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.1428798139095306e+01 -3.8387499749660492e+01 2.6272999122738838e+01) (float-vector -6.4476996660232544e+01 -4.3020900338888168e+01 4.4562898576259613e+01) (float-vector -7.3951698839664459e+01 -4.9059398472309113e+01 2.8930399566888809e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -7.1428798139095306e+01 -3.8387499749660492e+01 2.6272999122738838e+01) (float-vector -5.6481499224901199e+01 -3.2248001545667648e+01 4.0725000202655792e+01) (float-vector -5.3850099444389343e+01 -3.6490198224782944e+01 5.2007101476192474e+01) (float-vector -6.4476996660232544e+01 -4.3020900338888168e+01 4.4562898576259613e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -6.9488696753978729e+01 -3.2240301370620728e+01 1.4109100447967649e+00) (float-vector -7.1428798139095306e+01 -3.8387499749660492e+01 2.6272999122738838e+01) (float-vector -7.3951698839664459e+01 -4.9059398472309113e+01 2.8930399566888809e+01) (float-vector -7.9383201897144318e+01 -4.9045100808143616e+01 -3.4461999894119799e-01) (float-vector -7.4474796652793884e+01 -3.8389399647712708e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.6820500642061234e+01 -6.5761797130107880e+01 -4.0331300348043442e+01) (float-vector 5.6843299418687820e+01 -5.4978400468826294e+01 -5.3966101258993149e+01) (float-vector 4.3921299278736115e+01 -6.5758101642131805e+01 -5.3944598883390427e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 6.6359199583530426e+01 -6.5753698348999023e+01 -2.1015599370002747e+01) (float-vector 5.6820500642061234e+01 -6.5761797130107880e+01 -4.0331300348043442e+01) (float-vector 4.3921299278736115e+01 -6.5758101642131805e+01 -5.3944598883390427e+01) (float-vector 2.3136500269174576e+01 -8.0274298787117004e+01 -3.0678000301122665e+01) (float-vector 3.7004400044679642e+01 -8.0275103449821472e+01 -1.1183599941432476e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 7.3644801974296570e+01 -4.8939600586891174e+01 -2.9704099521040916e+01) (float-vector 6.6202603280544281e+01 -4.8934098333120346e+01 -4.3869800865650177e+01) (float-vector 5.6843299418687820e+01 -5.4978400468826294e+01 -5.3966101258993149e+01) (float-vector 5.6820500642061234e+01 -6.5761797130107880e+01 -4.0331300348043442e+01) (float-vector 6.6359199583530426e+01 -6.5753698348999023e+01 -2.1015599370002747e+01) (float-vector 7.4474796652793884e+01 -5.9610601514577866e+01 -1.5645200386643410e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector -1.4203500002622604e+01 -4.8949200659990311e+01 7.8114800155162811e+01) (float-vector -2.7057100087404251e+01 -4.3022301048040390e+01 7.3550097644329071e+01) (float-vector -1.5174100175499916e+01 -3.2350499182939529e+01 6.8473696708679199e+01) (float-vector 5.1130601204931736e+00 -3.4403301775455475e+01 7.2644703090190887e+01) (float-vector 1.7856500344350934e+00 -4.3026499450206757e+01 7.8329898416996002e+01) (float-vector 3.4459200105629861e-01 -4.8954900354146957e+01 7.9383298754692078e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.1130601204931736e+00 -3.4403301775455475e+01 7.2644703090190887e+01) (float-vector 2.1015599370002747e+01 -3.2246299088001251e+01 6.6359199583530426e+01) (float-vector 3.0671700835227966e+01 -4.3021898716688156e+01 7.2120100259780884e+01) (float-vector 1.7856500344350934e+00 -4.3026499450206757e+01 7.8329898416996002e+01)))))
              (instance face :init :vertices
                (mapcar #'(lambda (v) (send local-cds :transform-vector v))
                  (nreverse (list  (float-vector 5.9105001389980316e+01 -3.2233700156211853e+01 3.6562200635671616e+01) (float-vector 3.6946401000022888e+01 -3.2240901142358780e+01 5.8903798460960388e+01) (float-vector 2.1015599370002747e+01 -3.2246299088001251e+01 6.6359199583530426e+01) (float-vector 5.1130601204931736e+00 -3.4403301775455475e+01 7.2644703090190887e+01) (float-vector -1.5174100175499916e+01 -3.2350499182939529e+01 6.8473696708679199e+01) (float-vector -4.3375499546527863e+01 -3.2257098704576492e+01 5.4680000990629196e+01) (float-vector 2.7445200830698013e+00 -2.9418099671602249e+01 -1.2800700031220913e+01)))))
              ))
             )
      (setq geom (instance collada-body :init :replace-obj qhull :name "fl_caster_l_wheel_link_geom0"))
      (when glv
        (setq (geom . gl::aglvertices) glv)
        (send geom :assoc glv))
      geom))
  (:_make_instance_fl_caster_r_wheel_link_geom0 ()
    (let (geom glv qhull
          (local-cds (make-coords :pos (float-vector 0.0000000000000000e+00 -4.9000000000000000e+01 0.0000000000000000e+00))))
      (setq glv
       (instance gl::glvertices :init
                 (list ;; mesh list
                  (list ;; mesh description
                   (list :type :triangles)
                   (list :material (list
                    (list :ambient (float-vector 0.000100 0.000100 0.000100 1.000000))
                    (list :diffuse (float-vector 0.000000 0.000000 0.000000 1.000000))))
                   (list :indices #i( 0 1 2 0 4 1 2 28 0 30 4 0 28 30 0 21 22 2 22 28 2 2 1 21 28 29 30 22 29 28 30 29 31 30 31 4 404 29 407 408 407 29 31 29 404 22 408 29 20 22 21 22 20 408 18 20 21 17 20 18 412 20 17 408 20 412 17 18 19 21 486 18 18 486 19 17 19 16 412 17 16 412 413 414 412 414 408 412 16 413 413 415 414 409 415 413 413 15 409 413 16 481 413 481 15 14 15 7 409 15 14 481 7 15 481 16 7 6 7 8 8 7 11 14 7 6 16 11 7 14 6 10 409 14 10 9 10 6 6 487 9 8 489 6 6 489 487 8 11 13 8 488 489 13 488 8 12 13 11 11 16 12 13 12 19 19 488 13 486 488 19 486 499 488 488 499 497 488 497 489 16 19 12 489 497 494 489 494 487 497 459 494 499 459 497 486 498 499 499 474 459 499 498 474 493 498 486 474 498 475 498 493 475 40 474 475 475 478 471 40 475 471 475 493 478 37 39 40 41 37 40 41 40 471 39 474 40 41 471 378 471 478 378 478 476 378 478 493 476 69 378 379 37 41 378 37 378 69 378 476 379 476 477 379 476 493 477 69 379 376 379 477 376 376 477 473 493 473 477 492 493 3 1 493 486 3 493 1 492 473 493 491 496 492 491 492 3 492 496 473 3 4 5 4 3 1 491 3 5 21 1 486 4 31 5 482 5 483 33 483 5 33 5 31 482 491 5 33 31 34 31 404 34 34 35 33 35 483 33 36 482 483 35 36 483 34 36 35 34 26 36 406 34 404 27 34 406 26 34 27 404 405 406 407 405 404 27 406 410 434 406 405 410 406 434 434 405 423 407 423 405 407 408 423 423 408 417 440 408 414 417 408 440 416 417 418 417 427 418 417 416 423 417 440 427 414 439 440 427 440 439 451 427 439 398 427 402 427 398 418 451 402 427 419 416 418 418 398 419 423 416 419 419 422 423 401 419 398 419 401 400 400 422 419 422 421 423 421 434 423 420 421 422 425 421 420 425 434 421 420 424 425 424 434 425 426 424 420 426 434 424 420 381 426 422 396 420 381 420 382 382 420 396 434 426 435 426 381 435 380 381 382 260 392 381 381 380 260 392 435 381 393 382 396 380 382 393 258 380 257 380 393 257 260 380 258 235 259 260 260 258 235 259 392 260 392 259 391 430 392 391 430 435 392 231 259 235 229 262 259 229 259 231 259 262 391 231 232 229 235 236 231 231 236 232 232 237 229 232 236 177 183 232 177 183 237 232 235 234 236 236 234 181 177 236 181 177 178 167 168 177 167 177 181 178 168 183 177 179 181 180 178 181 179 181 234 180 166 178 164 164 178 179 167 178 166 167 161 162 166 161 167 162 168 167 161 166 160 160 166 164 160 164 159 164 165 159 164 179 165 180 165 179 358 165 363 159 165 358 363 165 365 180 365 165 118 159 117 160 159 118 117 159 358 161 160 119 119 160 118 105 118 117 104 119 118 104 118 105 117 116 105 116 117 329 329 117 358 104 105 98 105 116 95 98 105 95 97 103 104 98 97 104 103 119 104 92 97 98 92 98 95 95 81 92 95 316 81 316 95 317 95 116 317 92 93 94 81 93 92 94 97 92 99 97 94 97 99 103 93 96 94 96 99 94 93 81 72 61 93 72 61 96 93 101 99 96 59 96 61 59 101 96 100 99 101 100 106 99 99 106 103 101 102 100 101 108 102 59 108 101 100 109 106 102 109 100 121 120 106 106 120 103 109 121 106 120 119 103 120 162 161 120 161 119 121 162 120 109 122 121 163 162 121 122 163 121 102 113 109 113 122 109 123 122 113 122 169 163 123 169 122 163 168 162 163 169 174 174 168 163 170 169 123 170 175 169 169 175 174 124 123 114 114 123 113 124 170 123 124 171 170 176 170 171 175 170 176 175 182 174 176 185 175 185 182 175 171 173 176 173 184 176 176 184 185 152 171 125 125 171 124 152 173 171 172 173 152 173 172 184 172 201 184 201 204 184 184 204 210 184 210 185 186 172 152 186 190 172 190 201 172 148 152 125 148 186 152 187 186 149 149 186 148 187 190 186 190 187 191 191 201 190 150 188 187 150 187 149 188 191 187 149 148 136 150 149 137 137 149 136 131 148 125 136 148 131 89 136 131 132 137 136 132 136 89 133 137 132 133 138 137 138 150 137 130 132 89 133 132 134 134 132 130 89 90 91 91 130 89 90 89 131 90 110 91 90 115 110 131 115 90 112 91 107 107 91 110 91 129 130 91 112 129 110 111 107 110 114 111 110 115 114 125 124 115 115 124 114 131 125 115 111 114 113 107 111 102 111 113 102 107 102 108 108 112 107 58 108 59 58 112 108 58 59 57 59 60 57 59 61 60 60 61 62 62 63 60 63 57 60 61 72 62 63 62 64 62 72 64 72 65 64 72 81 82 72 82 65 64 65 66 66 63 64 66 65 70 65 80 70 65 82 80 82 314 80 81 316 82 82 316 314 80 79 70 305 306 80 314 305 80 80 306 79 317 318 314 317 314 316 314 318 305 305 319 315 318 319 305 305 315 306 306 309 79 306 313 309 306 315 313 315 327 325 319 327 315 315 325 313 320 319 318 328 327 319 320 328 319 317 320 318 317 116 320 329 328 320 116 329 320 360 359 328 328 359 327 329 360 328 327 354 325 327 359 354 325 324 313 325 354 324 354 353 324 354 356 353 354 359 361 361 356 354 360 362 359 359 362 361 362 364 361 361 272 356 361 364 272 356 357 353 356 274 357 356 272 274 269 272 268 272 273 268 274 272 269 272 364 273 362 365 364 364 365 273 268 273 234 234 273 180 273 365 180 264 268 234 264 269 268 233 234 235 264 234 233 256 264 233 256 253 264 253 269 264 256 233 257 235 258 233 258 257 233 253 256 263 257 393 256 256 395 263 393 395 256 254 253 263 263 394 254 263 395 394 393 396 395 395 399 400 395 400 394 396 399 395 254 394 255 400 401 394 394 401 255 250 253 254 255 250 254 250 255 251 255 248 251 255 398 248 255 401 398 248 250 251 247 246 248 248 246 250 398 402 248 248 402 247 245 246 247 402 403 247 247 403 245 448 403 402 402 451 448 245 403 397 403 448 397 244 242 245 245 242 246 245 397 244 243 242 244 244 397 243 243 397 386 397 450 386 448 447 397 450 397 447 242 243 240 386 240 243 386 384 387 387 240 386 384 386 449 449 386 450 441 449 450 450 447 441 443 447 448 441 447 442 442 447 443 414 441 442 438 441 414 441 438 449 384 449 454 449 438 454 414 415 438 415 445 438 454 438 445 443 439 414 414 442 443 439 443 448 448 451 439 444 445 415 444 446 445 454 445 452 446 452 445 384 454 452 385 384 452 452 453 385 452 446 453 453 446 444 385 453 389 455 389 453 453 444 455 383 384 385 385 389 238 385 238 383 383 388 384 384 388 387 249 388 383 383 238 249 228 238 239 226 249 238 226 238 228 238 389 239 226 241 249 241 388 249 387 388 241 240 387 241 240 241 225 225 241 226 225 226 227 217 227 226 228 218 226 217 226 218 227 212 225 211 225 212 242 240 225 225 211 242 212 227 217 208 211 212 205 212 217 208 212 205 211 209 213 209 211 208 213 221 211 211 221 242 242 221 246 220 221 213 220 222 221 222 246 221 213 347 346 213 346 220 209 347 213 220 215 222 220 346 336 337 220 336 220 337 215 214 222 215 214 246 222 214 215 216 348 215 343 343 215 337 215 348 216 333 337 332 332 337 336 343 337 333 333 338 343 338 344 343 344 348 343 216 348 344 339 344 338 344 339 345 345 216 344 301 338 333 339 338 302 302 338 301 333 332 300 301 333 300 291 301 300 302 301 294 294 301 291 303 302 295 295 302 294 303 339 302 285 294 291 293 295 294 293 294 285 283 291 289 285 291 283 291 300 289 284 285 283 290 285 75 284 75 285 290 293 285 292 293 290 292 295 293 83 277 290 290 277 292 290 75 83 74 75 76 75 74 83 75 284 76 283 282 284 284 282 76 88 76 87 76 88 74 87 76 278 76 282 278 282 280 278 280 282 286 283 289 282 282 289 286 278 279 87 278 280 279 279 280 281 280 286 287 281 280 287 299 298 286 289 299 286 286 298 287 300 299 289 299 332 331 299 331 298 300 332 299 287 298 297 331 330 298 298 330 297 287 288 281 287 297 288 288 297 158 297 196 158 330 196 297 330 334 196 331 335 330 330 335 334 336 331 332 335 331 336 335 346 334 336 346 335 196 334 199 334 347 199 334 346 347 193 158 196 196 199 193 193 199 200 200 199 207 199 209 207 209 199 347 157 158 193 157 193 195 193 200 195 195 200 198 200 207 198 198 207 206 207 208 206 207 209 208 195 198 194 194 198 197 198 206 197 195 194 156 157 195 156 154 194 189 156 194 154 189 194 197 197 192 189 205 202 197 197 202 192 197 206 205 208 205 206 205 217 202 191 202 203 192 202 191 202 217 203 189 192 188 188 192 191 189 188 151 154 189 151 151 188 150 151 150 138 154 151 138 127 138 133 127 139 138 139 154 138 126 127 128 127 133 135 126 139 127 127 135 128 134 135 133 130 135 134 135 366 128 130 366 135 73 366 130 129 73 130 128 366 367 366 53 367 370 53 366 73 370 366 367 86 143 128 367 143 53 47 367 86 367 47 140 143 142 142 143 85 140 128 143 143 86 85 140 126 128 144 145 140 144 140 142 140 145 126 141 142 85 142 141 144 85 86 87 141 85 279 87 279 85 141 153 144 279 281 141 288 153 141 281 288 141 144 147 145 144 153 147 147 146 145 145 146 126 157 156 147 153 157 147 147 156 146 153 158 157 158 153 288 126 146 139 156 155 146 146 155 139 155 156 154 139 155 154 87 86 88 86 369 88 47 369 86 369 368 88 88 368 74 369 43 368 43 369 47 46 47 48 46 43 47 48 47 52 52 47 53 45 43 46 46 461 45 48 461 46 44 43 45 45 458 44 45 461 458 458 461 456 456 461 48 456 457 458 44 458 472 458 457 472 42 43 44 44 472 42 472 56 42 472 457 480 472 480 56 456 459 457 457 459 480 459 456 48 48 460 459 459 460 470 470 494 459 459 474 480 56 480 479 474 479 480 39 479 474 56 479 39 37 38 39 39 38 56 68 37 69 38 37 84 68 84 37 67 68 69 67 71 68 71 84 68 70 69 66 67 69 70 69 376 66 67 77 71 70 79 67 67 79 77 71 77 78 78 84 71 83 84 78 78 77 277 78 277 83 83 74 84 74 38 84 74 368 38 56 38 42 38 43 42 43 38 368 275 276 277 276 292 277 277 77 275 77 308 275 275 311 307 308 311 275 276 275 307 276 296 292 307 296 276 292 296 295 304 303 296 296 303 295 307 304 296 307 321 304 311 321 307 321 326 304 326 340 304 304 340 303 303 340 339 345 339 340 326 342 340 340 342 345 341 342 326 321 351 326 351 341 326 322 321 311 322 351 321 352 351 322 352 355 351 351 355 341 342 341 349 355 350 341 341 350 349 342 349 345 345 349 216 271 349 350 216 349 223 223 349 271 357 350 355 350 357 271 355 352 353 357 355 353 271 357 274 224 271 270 271 274 270 224 223 271 223 224 214 223 214 216 224 267 214 224 270 265 224 265 267 265 270 266 266 270 269 270 274 269 265 266 253 253 250 265 267 265 250 246 267 250 214 267 246 266 269 253 323 353 352 324 353 323 323 322 312 324 323 312 323 352 322 313 324 312 308 312 311 309 312 308 309 313 312 312 322 311 309 308 310 310 308 77 310 79 309 79 310 77 66 375 63 66 376 377 377 375 66 63 375 374 375 466 464 374 375 464 377 466 375 63 374 373 63 373 57 374 464 465 465 373 374 464 496 465 464 466 496 377 473 466 496 466 473 376 473 377 490 496 491 495 496 490 496 495 465 467 373 465 465 495 467 494 495 490 495 494 467 468 373 467 467 463 372 467 372 468 467 494 470 467 470 463 487 494 490 9 487 23 23 487 490 23 10 9 23 24 10 32 23 485 24 23 32 23 490 485 409 10 24 32 27 24 24 27 409 27 32 25 485 25 32 485 484 25 485 490 484 484 490 491 26 484 482 25 484 26 482 484 491 25 26 27 409 27 410 409 410 411 409 411 415 428 410 434 428 411 410 437 411 436 436 411 428 411 444 415 411 437 444 436 432 437 437 455 444 455 437 432 436 433 432 433 436 428 431 432 433 431 433 428 455 432 389 391 390 432 389 432 390 431 391 432 431 428 430 431 430 391 390 391 261 391 262 261 389 390 252 261 252 390 239 389 252 239 252 228 228 252 261 228 261 229 229 261 262 228 229 230 219 218 228 230 219 228 229 237 230 237 219 230 204 219 210 204 218 219 210 219 237 203 217 218 203 218 204 203 204 201 203 201 191 210 237 185 185 237 183 182 185 183 182 183 174 174 183 168 428 429 430 430 429 435 428 434 429 429 434 435 36 26 482 462 372 463 469 462 463 463 470 469 51 462 469 50 462 51 50 372 462 371 372 49 372 50 49 468 372 371 49 50 51 54 55 51 51 55 49 469 54 51 470 54 469 460 54 470 52 53 54 54 53 55 460 52 54 55 58 49 55 73 58 370 73 55 55 53 370 57 49 58 73 112 58 129 112 73 57 371 49 57 373 371 371 373 468 48 52 460 399 422 400 422 399 396 363 365 362 358 363 360 360 363 362 329 358 360))
                   (list :vertices (let ((mat (make-matrix 500 3))) (fvector-replace (array-entity mat) #f(5.1378703117370605e+00 6.8265296936035156e+01 -9.3289899826049805e+00 2.7445201873779297e+00 6.8581901550292969e+01 -1.2800700187683105e+01 1.0573199987411499e+00 6.8359207153320312e+01 -1.0600199699401855e+01 1.0544799804687500e+01 6.8569099426269531e+01 -8.4442996978759766e+00 8.2298793792724609e+00 6.8419601440429688e+01 -6.8257398605346680e+00 1.0452800750732422e+01 6.8323402404785156e+01 -2.3365499973297119e+00 -6.6212201118469238e+00 6.8392799377441406e+01 8.3633699417114258e+00 -1.0304100036621094e+01 1.7535499572753906e+01 4.2757096290588379e+00 -9.9000797271728516e+00 6.8434997558593750e+01 4.3990101814270020e+00 -3.0437600612640381e+00 6.8367401123046875e+01 1.0238399505615234e+01 -3.0640001296997070e+00 1.7108699798583984e+01 1.0639900207519531e+01 -1.0523200035095215e+01 6.8192199707031250e+01 2.0460700988769531e+00 -1.0421499252319336e+01 6.8127601623535156e+01 -1.9288499355316162e+00 -1.1160599708557129e+01 6.8441001892089844e+01 -8.0958700180053711e-01 -7.1614899635314941e+00 1.7107900619506836e+01 8.4554700851440430e+00 -1.0192299842834473e+01 1.7057300567626953e+01 5.5663700103759766e+00 -1.0925999641418457e+01 1.7111598968505859e+01 -2.1682801246643066e+00 -8.4008197784423828e+00 1.7088899612426758e+01 -7.2349200248718262e+00 -6.7002696990966797e+00 6.8396400451660156e+01 -8.3113307952880859e+00 -9.4348793029785156e+00 6.8405799865722656e+01 -4.9726400375366211e+00 -5.3217201232910156e+00 1.7143899917602539e+01 -9.7155799865722656e+00 -2.8588600158691406e+00 6.8322502136230469e+01 -1.0273599624633789e+01 -1.0057700872421265e+00 1.7096700668334961e+01 -1.1044600486755371e+01 1.0178999900817871e+00 6.8367797851562500e+01 1.0607999801635742e+01 1.0090099573135376e+00 1.7097700119018555e+01 1.1044500350952148e+01 7.1427397727966309e+00 1.7195999145507812e+01 8.4595899581909180e+00 9.8030099868774414e+00 1.7092800140380859e+01 5.1623497009277344e+00 7.4257197380065918e+00 1.6894800186157227e+01 1.1212299346923828e+01 3.3442101478576660e+00 1.7096099853515625e+01 -1.0557999610900879e+01 6.1998200416564941e+00 1.6903999328613281e+01 -1.1747900009155273e+01 7.2372202873229980e+00 1.7205499649047852e+01 -8.3683700561523438e+00 9.8025293350219727e+00 1.7078998565673828e+01 -5.1738500595092773e+00 4.0853300094604492e+00 1.7077999114990234e+01 1.0249599456787109e+01 1.0831099510192871e+01 1.7257900238037109e+01 -2.0039701461791992e+00 1.2268199920654297e+01 1.6871999740600586e+01 3.9475402832031250e+00 1.1011500358581543e+01 1.7335899353027344e+01 0.0000000000000000e+00 1.0836700439453125e+01 1.7178098678588867e+01 2.0019199848175049e+00 -1.1417300224304199e+01 6.6068595886230469e+01 -6.0313899993896484e+01 -3.8845100402832031e+01 6.6098693847656250e+01 -4.7875999450683594e+01 -3.0698499679565430e+01 6.4885696411132812e+01 -3.9734401702880859e+01 -1.5955299377441406e+01 6.4939201354980469e+01 -4.7729400634765625e+01 -2.3467898368835449e+00 6.4994499206542969e+01 -5.1267002105712891e+01 -4.5538898468017578e+01 6.5077301025390625e+01 -2.5041301727294922e+01 -6.0313198089599609e+01 6.6034599304199219e+01 -7.4321599006652832e+00 -4.9943901062011719e+01 6.5038505554199219e+01 -1.3358200073242188e+01 -5.1267002105712891e+01 6.4994796752929688e+01 2.3467597961425781e+00 -4.8763401031494141e+01 6.5027900695800781e+01 1.6582399368286133e+01 -6.1740497589111328e+01 6.6020698547363281e+01 1.0151400566101074e+01 -4.5477100372314453e+01 6.4954597473144531e+01 2.1893899917602539e+01 1.6372301101684570e+01 6.6058395385742188e+01 5.8962200164794922e+01 2.3468399047851562e+00 6.4992599487304688e+01 5.1267200469970703e+01 -9.9129495620727539e+00 6.4916198730468750e+01 4.9431499481201172e+01 -3.6015296936035156e+01 6.4891899108886719e+01 3.4995300292968750e+01 -4.8726200103759766e+01 6.6080505371093750e+01 3.8182498931884766e+01 -2.5745399475097656e+01 6.4941505432128906e+01 4.3290298461914062e+01 -6.4798698425292969e+00 6.6077705383300781e+01 6.1833000183105469e+01 -3.9104801177978516e+01 6.4893997192382812e+01 -3.1760398864746094e+01 3.8039699554443359e+01 6.6068901062011719e+01 4.8811397552490234e+01 2.0110498428344727e+01 6.5001693725585938e+01 6.3504100799560547e+01 4.7388999938964844e+01 6.4940200805664062e+01 4.7388999938964844e+01 5.0501701354980469e+01 6.5800300598144531e+01 3.8274200439453125e+01 6.3447898864746094e+01 6.4940101623535156e+01 2.0092599868774414e+01 6.0778099060058594e+01 6.5855598449707031e+01 1.7475801467895508e+01 6.0313198089599609e+01 6.6034599304199219e+01 7.4321599006652832e+00 6.3284599304199