/***
 *  Software License Agreement: BSD 3-Clause License
 *
 *  Copyright (c) 2018-2019, qbrobotics®
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the
 *  following conditions are met:
 *
 *  * Redistributions of source code must retain the above copyright notice, this list of conditions and the
 *    following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other materials provided with the distribution.
 *
 *  * Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote
 *    products derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef QB_SOFTHAND_INDUSTRY_CONTROL_H
#define QB_SOFTHAND_INDUSTRY_CONTROL_H

// ROS libraries
#include <ros/ros.h>

// internal libraries
#include <qb_softhand_industry_hardware_interface/qb_softhand_industry_hardware_interface.h>

namespace qb_softhand_industry_control {
/**
 *
 */
class qbSoftHandIndustryControl {
 public:
  /**
   *
   */
  qbSoftHandIndustryControl();

  /**
   *
   */
  virtual ~qbSoftHandIndustryControl();

 private:
  ros::AsyncSpinner spinner_;
  ros::NodeHandle node_handle_;
  ros::WallTimer control_timer_;
  ros::WallDuration control_duration_;

  qb_softhand_industry_hardware_interface::qbSoftHandIndustryHW device_;
  bool init_success_;

  /**
   *
   */
  void controlCallback(const ros::WallTimerEvent &timer_event);

  /**
   *
   */
  void update(const ros::WallTime &time, const ros::WallDuration &period);
};
}  // namespace qb_softhand_industry_control

#endif // QB_SOFTHAND_INDUSTRY_CONTROL_H