(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     33206,        836]
NotebookOptionsPosition[     31514,        803]
NotebookOutlinePosition[     31912,        819]
CellTagsIndexPosition[     31869,        816]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Ruckig Step 1", "Text",
 CellChangeTimes->{{3.8174628076007547`*^9, 3.817462833050323*^9}, {
  3.820307235551709*^9, 
  3.820307236485478*^9}},ExpressionUUID->"f0efc888-777d-4c66-b8e6-\
2db88daacc31"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"jerkProfile", "=", 
   RowBox[{"{", 
    RowBox[{"jMax", ",", "0", ",", 
     RowBox[{"-", "jMax"}], ",", "0", ",", 
     RowBox[{"-", "jMax"}], ",", "0", ",", "jMax"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tVars", "=", 
    RowBox[{"{", 
     RowBox[{
     "t1", ",", "t2", ",", "t3", ",", "t4", ",", "t5", ",", "t6", ",", "t7"}],
      "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a1", "=", 
   RowBox[{"a0", "+", 
    RowBox[{"t1", " ", 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a2", "=", 
   RowBox[{"a1", "+", 
    RowBox[{"t2", " ", 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a3", "=", 
   RowBox[{"a2", "+", 
    RowBox[{"t3", " ", 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "3", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a4", "=", 
   RowBox[{"a3", "+", 
    RowBox[{"t4", " ", 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "4", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a5", "=", 
   RowBox[{"a4", "+", 
    RowBox[{"t5", " ", 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "5", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a6", "=", 
   RowBox[{"a5", "+", 
    RowBox[{"t6", " ", 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "6", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a7", "=", 
    RowBox[{"a6", "+", 
     RowBox[{"t7", " ", 
      RowBox[{"jerkProfile", "[", 
       RowBox[{"[", "7", "]"}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v1", "=", 
   RowBox[{"v0", "+", 
    RowBox[{"t1", " ", "a0"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t1", "2"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{"v1", "+", 
    RowBox[{"t2", " ", "a1"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t2", "2"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v3", "=", 
   RowBox[{"v2", "+", 
    RowBox[{"t3", " ", "a2"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t3", "2"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "3", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v4", "=", 
   RowBox[{"v3", "+", 
    RowBox[{"t4", " ", "a3"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t4", "2"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "4", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v5", "=", 
   RowBox[{"v4", "+", 
    RowBox[{"t5", " ", "a4"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t5", "2"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "5", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v6", "=", 
   RowBox[{"v5", "+", 
    RowBox[{"t6", " ", "a5"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t6", "2"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "6", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"v7", "=", 
    RowBox[{"v6", "+", 
     RowBox[{"t7", " ", "a6"}], "+", 
     RowBox[{
      FractionBox["1", "2"], 
      SuperscriptBox["t7", "2"], 
      RowBox[{"jerkProfile", "[", 
       RowBox[{"[", "7", "]"}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"p0", "+", 
    RowBox[{"t1", " ", "v0"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t1", "2"], " ", "a0"}], "+", 
    RowBox[{
     FractionBox["1", "6"], 
     SuperscriptBox["t1", "3"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"p1", "+", 
    RowBox[{"t2", " ", "v1"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t2", "2"], " ", "a1"}], "+", 
    RowBox[{
     FractionBox["1", "6"], 
     SuperscriptBox["t2", "3"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"p2", "+", 
    RowBox[{"t3", " ", "v2"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t3", "2"], " ", "a2"}], "+", 
    RowBox[{
     FractionBox["1", "6"], 
     SuperscriptBox["t3", "3"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "3", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p4", "=", 
   RowBox[{"p3", "+", 
    RowBox[{"t4", " ", "v3"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t4", "2"], " ", "a3"}], "+", 
    RowBox[{
     FractionBox["1", "6"], 
     SuperscriptBox["t4", "3"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "4", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p5", "=", 
   RowBox[{"p4", "+", 
    RowBox[{"t5", " ", "v4"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t5", "2"], " ", "a4"}], "+", 
    RowBox[{
     FractionBox["1", "6"], 
     SuperscriptBox["t5", "3"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "5", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p6", "=", 
   RowBox[{"p5", "+", 
    RowBox[{"t6", " ", "v5"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t6", "2"], " ", "a5"}], "+", 
    RowBox[{
     FractionBox["1", "6"], 
     SuperscriptBox["t6", "3"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "6", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p7", "=", 
   RowBox[{"p6", "+", 
    RowBox[{"t7", " ", "v6"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t7", "2"], " ", "a6"}], "+", 
    RowBox[{
     FractionBox["1", "6"], 
     SuperscriptBox["t7", "3"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "7", "]"}], "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.817462841378334*^9, 3.817462900269423*^9}, {
   3.8176136118348*^9, 3.8176136203885107`*^9}, 3.817613860612129*^9, 
   3.817615902502871*^9, 3.817628855244062*^9, 3.817628926525811*^9, 
   3.817630327779182*^9, 3.817630856882971*^9, 3.817631232893464*^9, 
   3.817631310598453*^9, 3.817640134759371*^9, 3.818009215253849*^9, {
   3.819365329290554*^9, 3.819365331663157*^9}, 3.820148038073226*^9, {
   3.8205597423263273`*^9, 3.820559744425127*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"d346b209-9dd3-47cf-8f1e-f04bc3bf980a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"resultT", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a3", "\[Equal]", "0"}], ",", 
         RowBox[{"a1", "\[Equal]", "aMax"}], ",", 
         RowBox[{"a5", "\[Equal]", "aMin"}], ",", 
         RowBox[{"v3", "\[Equal]", "vMax"}]}], "}"}], ",", "tVars"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a3", "\[Equal]", "0"}], ",", 
         RowBox[{"a1", "\[Equal]", "aMax"}], ",", 
         RowBox[{"a5", "\[Equal]", "aMin"}], ",", 
         RowBox[{"t4", "\[Equal]", "0"}]}], "}"}], ",", "tVars"}], "]"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a3", "\[Equal]", "0"}], ",", 
         RowBox[{"t2", "\[Equal]", "0"}], ",", 
         RowBox[{"a5", "\[Equal]", "aMin"}], ",", 
         RowBox[{"v3", "\[Equal]", "vMax"}]}], "}"}], ",", "tVars"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a3", "\[Equal]", "0"}], ",", 
         RowBox[{"a1", "\[Equal]", "aMax"}], ",", 
         RowBox[{"t6", "\[Equal]", "0"}], ",", 
         RowBox[{"v3", "\[Equal]", "vMax"}]}], "}"}], ",", "tVars"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a3", "\[Equal]", "0"}], ",", 
         RowBox[{"t2", "\[Equal]", "0"}], ",", 
         RowBox[{"t6", "\[Equal]", "0"}], ",", 
         RowBox[{"v3", "\[Equal]", "vMax"}]}], "}"}], ",", "tVars"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a3", "\[Equal]", "0"}], ",", 
         RowBox[{"t2", "\[Equal]", "0"}], ",", 
         RowBox[{"a5", "\[Equal]", 
          RowBox[{"-", "aMax"}]}], ",", 
         RowBox[{"t4", "\[Equal]", "0"}]}], "}"}], ",", "tVars", ",", 
       RowBox[{"Cubics", "\[Rule]", "False"}], ",", 
       RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a3", "\[Equal]", "0"}], ",", 
         RowBox[{"t2", "\[Equal]", "0"}], ",", 
         RowBox[{"a5", "\[Equal]", "aMax"}], ",", 
         RowBox[{"t4", "\[Equal]", "0"}]}], "}"}], ",", "tVars", ",", 
       RowBox[{"Cubics", "\[Rule]", "False"}], ",", 
       RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a3", "\[Equal]", "0"}], ",", 
         RowBox[{"a1", "\[Equal]", "aMax"}], ",", 
         RowBox[{"t6", "\[Equal]", "0"}], ",", 
         RowBox[{"t4", "\[Equal]", "0"}]}], "}"}], ",", "tVars", ",", 
       RowBox[{"Cubics", "\[Rule]", "False"}], ",", 
       RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a3", "\[Equal]", "0"}], ",", 
         RowBox[{"t2", "\[Equal]", "0"}], ",", 
         RowBox[{"t6", "\[Equal]", "0"}], ",", 
         RowBox[{"t4", "\[Equal]", "0"}]}], "}"}], ",", "tVars", ",", 
       RowBox[{"Cubics", "\[Rule]", "False"}], ",", 
       RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a7", "/.", 
            RowBox[{"{", 
             RowBox[{"a0", "\[Rule]", "0"}], "}"}]}], ")"}], "\[Equal]", 
          "0"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"v7", "/.", 
            RowBox[{"{", 
             RowBox[{"a0", "\[Rule]", "0"}], "}"}]}], ")"}], "\[Equal]", 
          "vf"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p7", "/.", 
            RowBox[{"{", 
             RowBox[{"a0", "\[Rule]", "0"}], "}"}]}], ")"}], "\[Equal]", 
          "pf"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a3", "/.", 
            RowBox[{"{", 
             RowBox[{"a0", "\[Rule]", "0"}], "}"}]}], ")"}], "\[Equal]", 
          "0"}], ",", 
         RowBox[{"t2", "\[Equal]", "0"}], ",", 
         RowBox[{"t6", "\[Equal]", "0"}], ",", 
         RowBox[{"t4", "\[Equal]", "0"}]}], "}"}], ",", "tVars", ",", 
       RowBox[{"Cubics", "\[Rule]", "False"}], ",", 
       RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a1", "\[Equal]", "aMax"}], ",", 
         RowBox[{"t6", "\[Equal]", "0"}], ",", 
         RowBox[{"t4", "\[Equal]", "0"}], ",", 
         RowBox[{"t5", "\[Equal]", "0"}]}], "}"}], ",", "tVars", ",", 
       RowBox[{"Cubics", "\[Rule]", "False"}], ",", 
       RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"t2", "\[Equal]", "0"}], ",", 
         RowBox[{"a5", "\[Equal]", 
          RowBox[{"-", "aMax"}]}], ",", 
         RowBox[{"t4", "\[Equal]", "0"}], ",", 
         RowBox[{"t5", "\[Equal]", "0"}]}], "}"}], ",", "tVars", ",", 
       RowBox[{"Cubics", "\[Rule]", "False"}], ",", 
       RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8174629257969522`*^9, 3.817462978356163*^9}, {
   3.817463017710661*^9, 3.817463019150318*^9}, {3.817463125060719*^9, 
   3.817463268801898*^9}, {3.8174633497876797`*^9, 3.817463350013275*^9}, {
   3.8176142815731697`*^9, 3.817614282974786*^9}, 3.817629135081959*^9, 
   3.817629174090706*^9, {3.817629395753993*^9, 3.817629397914218*^9}, {
   3.817629903651003*^9, 3.81762990789653*^9}, 3.817630008980739*^9, {
   3.8176308336239557`*^9, 3.8176308355038147`*^9}, 3.8176412855214357`*^9, {
   3.819480271236746*^9, 3.819480275524906*^9}, {3.820559923457724*^9, 
   3.820559934200976*^9}, {3.820560449143613*^9, 3.820560470192191*^9}, {
   3.821871609794586*^9, 3.821871622909561*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"ccba75f7-892e-4119-93ec-41811b2e330e"],

Cell["\<\
Information Roots are max. 4th Order
- (1) Case 1: Acc0_Acc1_Vel: Solution 1 (Length 1)
- (2) Case 2: Acc0_Acc1: Solution 1/2 (UDDU) (Length 2)
- (3) Case 3: Acc1_Vel: Solution 2 (Length 2)
- (4) Case 4: Acc0_Vel: Solution 1/2 (Length 2)
- (5) Case 5: Vel: Solution 3/4 (Length 4)
- (6) Case 6a: Acc1: Root in t1 (Length 4)
- (7) Case 6b: Acc1: Root in t1 (UDUD for af != 0) (Length 4)
- (8) Case 7: Acc0: Root in t5 (Length 4)
- (9) Case 8: None: Root in t1, (UDDU), (UDUD for af != 0) (Length 4)
- (10) Case 8: None: Root in t1, (UDDU), (UDUD for af != 0) with a0==af==0 \
(Length 4)
- (11) Case 7: Acc0: Root in t3 (Length 4)
- (12) Case 6: Acc1: Root in t1 (Length 4)\
\>", "Text",
 CellChangeTimes->{{3.8174632785384893`*^9, 3.817463379445586*^9}, {
   3.8174635726156178`*^9, 3.817463721259947*^9}, {3.8174665706088743`*^9, 
   3.817466570913156*^9}, {3.817467118701497*^9, 3.8174671190303392`*^9}, {
   3.8174674657907257`*^9, 3.8174674659023438`*^9}, {3.817616051327691*^9, 
   3.817616061734858*^9}, {3.8176181077496033`*^9, 3.817618117117276*^9}, {
   3.81762928092439*^9, 3.817629317932926*^9}, {3.817629348645948*^9, 
   3.817629405422893*^9}, {3.81762991338601*^9, 3.817629922653615*^9}, {
   3.817630011713861*^9, 3.8176300169571753`*^9}, {3.817630830414349*^9, 
   3.81763085334088*^9}, {3.8176412891511297`*^9, 3.8176412957587967`*^9}, 
   3.817700725859343*^9, {3.817700767970825*^9, 3.81770076813795*^9}, {
   3.819480286564745*^9, 3.819480293963434*^9}, {3.819707143963235*^9, 
   3.8197071909725227`*^9}, {3.820559944751623*^9, 3.8205599501398993`*^9}, {
   3.820560944238277*^9, 
   3.820560967704018*^9}},ExpressionUUID->"e82cb2e9-b4f4-4bc2-9a74-\
547157d3c4dc"],

Cell["\<\
Print Cases 1-5
[[Case, Solution, Time Number, 2]]\
\>", "Text",
 CellChangeTimes->{{3.817463738997243*^9, 3.817463742980877*^9}, {
  3.817463775486054*^9, 
  3.817463786446526*^9}},ExpressionUUID->"2bb13fa1-f9ef-4a5d-ac3b-\
101e020ad421"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmpResult", "=", 
   RowBox[{"resultT", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"\"\<Solutions: \>\"", "<>", 
  RowBox[{"ToString", "[", 
   RowBox[{"Length", "[", "tmpResult", "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Refine", "[", 
     RowBox[{"tmpResult", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "6", ",", "2"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"vMax", "\[Element]", "Reals"}], ",", 
      RowBox[{"aMax", "\[Element]", "Reals"}], ",", 
      RowBox[{"jMax", "\[Element]", "Reals"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToString", "[", 
   RowBox[{"tmp", ",", "CForm"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CopyToClipboard", "[", "%", "]"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQAWIQPe+tx03rwjeOdZEuD0B0Ilf/VxBto7f/L4huu+ns
bgOkG7hdPEC01zVjO1sgbWH4zgFE/7i/yQVMs31wA9HLpu8IAdEaN3aC6R/5
ayNBtNbR2kQQXbHdNBNEu21fXQA2R5inHESLRP+oBeuvf9IEonNEUjpA9Jz7
UlNAtFetyCoQPe/u5P0gOi8g9RSIrvm/914PkN7z+gOYvpBw+imI1rqo8QZM
13QtmQSkDbbt2Qqi92733rMeSPf4GxwE0XeE4s4ql79xnOjCcA5EG53kdFpS
+cZRZo6dN4h+1SaVCKL3cTHlguhu1V9FILqwYVoJiAYAKjqh/w==
  "],
 CellLabel->
  "In[161]:=",ExpressionUUID->"f20278fb-5b15-4c9c-bd38-9f1d3931e2f3"],

Cell["Print Cases 6-8: Roots", "Text",
 CellChangeTimes->{{3.817463796484267*^9, 
  3.8174638010307283`*^9}},ExpressionUUID->"8d7af2fe-a47e-4ef4-b28a-\
db0dc764dd0f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tRoot", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmpResult", "=", 
   RowBox[{"resultT", "[", 
    RowBox[{"[", 
     RowBox[{"12", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rootFunction", "=", 
   RowBox[{"tmpResult", "[", 
    RowBox[{"[", 
     RowBox[{"tRoot", ",", "2"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   FractionBox[
    RowBox[{
     RowBox[{"CoefficientList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"rootFunction", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "[", "x", "]"}], ",", "x"}], "]"}], 
     "[", 
     RowBox[{"[", "1", "]"}], "]"}], 
    RowBox[{"Last", "[", 
     RowBox[{"CoefficientList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"rootFunction", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "[", "x", "]"}], ",", "x"}], "]"}], 
     "]"}]], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToString", "[", 
   RowBox[{"tmp", ",", "CForm"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CopyToClipboard", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.81746385324234*^9, 3.8174638588074417`*^9}, {
   3.8174639004090853`*^9, 3.817464146400536*^9}, {3.817464197682095*^9, 
   3.8174642237071457`*^9}, {3.81746467517737*^9, 3.817464733015148*^9}, {
   3.8174647716155567`*^9, 3.817464808121599*^9}, {3.817464958295774*^9, 
   3.817464978456039*^9}, {3.817465392157484*^9, 3.8174654363653917`*^9}, {
   3.8174655875222387`*^9, 3.817465641579135*^9}, {3.8174662104318943`*^9, 
   3.817466215391354*^9}, {3.817466254017514*^9, 3.817466312191326*^9}, 
   3.817473469655705*^9, {3.817616070193791*^9, 3.8176160704001007`*^9}, {
   3.817616106402553*^9, 3.817616138705028*^9}, {3.81761645464653*^9, 
   3.817616521373534*^9}, {3.817618123606201*^9, 3.817618152793016*^9}, {
   3.8180094803954144`*^9, 3.818009506714346*^9}, {3.8180099934634867`*^9, 
   3.818010051334861*^9}, {3.820559959748899*^9, 3.820559975599066*^9}, {
   3.8205600482286043`*^9, 3.820560058937006*^9}, {3.8205609693602257`*^9, 
   3.82056101111698*^9}},
 CellLabel->
  "In[2429]:=",ExpressionUUID->"ca8158ca-2cc6-4c2b-92b0-ae9728cb14cd"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"12", " ", 
    SuperscriptBox["jMax", "4"]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"3", " ", 
     SuperscriptBox["a0", "4"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["af", "4"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a0", "3"], " ", "aMax"}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["af", "3"], " ", "aMax"}], "+", 
    RowBox[{"24", " ", "a0", " ", "aMax", " ", "jMax", " ", "v0"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a0", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["aMax", "2"], "+", 
       RowBox[{"2", " ", "jMax", " ", "v0"}]}], ")"}]}], "+", 
    RowBox[{"24", " ", "af", " ", "aMax", " ", "jMax", " ", "vf"}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["af", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["aMax", "2"], "-", 
       RowBox[{"2", " ", "jMax", " ", "vf"}]}], ")"}]}], "+", 
    RowBox[{"12", " ", "jMax", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "aMax", " ", "jMax", " ", 
        RowBox[{"(", 
         RowBox[{"p0", "-", "pf"}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["aMax", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"v0", "+", "vf"}], ")"}]}], "+", 
       RowBox[{"jMax", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["v0", "2"], "-", 
          SuperscriptBox["vf", "2"]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{
  3.817464224080229*^9, {3.8174646757284613`*^9, 3.817464735056591*^9}, {
   3.817464772067339*^9, 3.817464808446479*^9}, {3.8174649500267267`*^9, 
   3.817464979046924*^9}, {3.8174653964553947`*^9, 3.81746543673561*^9}, {
   3.817465591806774*^9, 3.817465642153749*^9}, 3.817466216455537*^9, {
   3.817466257823419*^9, 3.817466313043701*^9}, {3.8174734582456903`*^9, 
   3.8174734702907677`*^9}, {3.817616067838916*^9, 3.817616070838888*^9}, {
   3.817616106894815*^9, 3.817616139189769*^9}, {3.817616459558393*^9, 
   3.817616521866693*^9}, {3.817618128281868*^9, 3.817618153255725*^9}, {
   3.818009482010332*^9, 3.818009507179964*^9}, {3.8180100256655703`*^9, 
   3.818010051730009*^9}, {3.820559960277973*^9, 3.820559998336207*^9}, {
   3.820560048573118*^9, 3.820560059189855*^9}, {3.8205609713678093`*^9, 
   3.8205610115364027`*^9}},
 CellLabel->
  "Out[2432]=",ExpressionUUID->"0a94f786-574e-4852-9434-e6c9207268ec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmpReplaced", "=", 
   RowBox[{"tmpResult", "//.", 
    RowBox[{"{", 
     RowBox[{"rootFunction", "\[Rule]", "t"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"tmpReplaced", "[", 
    RowBox[{"[", 
     RowBox[{"7", ",", "2"}], "]"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToString", "[", 
   RowBox[{"tmp", ",", "CForm"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CopyToClipboard", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.817464186795458*^9, 3.817464336782579*^9}, {
  3.8174648872943287`*^9, 3.8174649200286627`*^9}, {3.8174649939680443`*^9, 
  3.8174650073602333`*^9}, {3.817465402901187*^9, 3.817465413129187*^9}, {
  3.817465468359084*^9, 3.817465497350111*^9}, {3.8174656551333303`*^9, 
  3.817465701685096*^9}, {3.817473479559062*^9, 3.8174734800856733`*^9}, {
  3.817473533672271*^9, 3.817473533751308*^9}, {3.8174742089250727`*^9, 
  3.817474210971596*^9}, {3.817616151988146*^9, 3.817616183627185*^9}, {
  3.817618162951096*^9, 3.8176181782700644`*^9}, {3.818009517172654*^9, 
  3.818009538091856*^9}, {3.8180100608100224`*^9, 3.81801007299201*^9}, {
  3.82055999962952*^9, 3.820560013274135*^9}, {3.820560085140555*^9, 
  3.820560097165331*^9}, {3.820561025609236*^9, 3.82056106283314*^9}},
 CellLabel->
  "In[2455]:=",ExpressionUUID->"02ddacce-ea40-40b5-bbc9-e4e0e8a8500b"],

Cell[BoxData[
 FractionBox[
  RowBox[{"af", "+", "aMax"}], "jMax"]], "Output",
 CellChangeTimes->{{3.817464289219615*^9, 3.817464337401743*^9}, {
   3.817464881225731*^9, 3.817464920476918*^9}, {3.817464988238978*^9, 
   3.81746500768358*^9}, {3.81746540086765*^9, 3.817465413431589*^9}, {
   3.817465461523279*^9, 3.817465497766103*^9}, {3.817465655693458*^9, 
   3.817465703495722*^9}, 3.817466232751576*^9, 3.817473410326756*^9, {
   3.817473459931615*^9, 3.8174734881471148`*^9}, 3.81747354157975*^9, {
   3.81747420945721*^9, 3.8174742112747707`*^9}, {3.8176161501097183`*^9, 
   3.817616185177759*^9}, {3.817618163459977*^9, 3.817618178516623*^9}, {
   3.818009517630191*^9, 3.8180095385414467`*^9}, {3.8180100612506733`*^9, 
   3.8180100732781763`*^9}, {3.820559999924418*^9, 3.820560013605125*^9}, {
   3.820560081633182*^9, 3.820560097566641*^9}, {3.820561026013336*^9, 
   3.820561063323831*^9}},
 CellLabel->
  "Out[2456]=",ExpressionUUID->"cd5c1068-df37-4f84-8783-2e31418f59b2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmpData", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p0", "\[Rule]", 
      RowBox[{"-", "2.5"}]}], ",", 
     RowBox[{"v0", "\[Rule]", "4.0"}], ",", 
     RowBox[{"a0", "\[Rule]", "0.1"}], ",", 
     RowBox[{"pf", "\[Rule]", "10.0"}], ",", 
     RowBox[{"vf", "\[Rule]", "3.2"}], ",", 
     RowBox[{"af", "\[Rule]", "0.0"}], ",", 
     RowBox[{"vMax", "\[Rule]", 
      RowBox[{"-", "10.0"}]}], ",", 
     RowBox[{"aMax", "\[Rule]", 
      RowBox[{"-", "15.0"}]}], ",", 
     RowBox[{"jMax", "\[Rule]", 
      RowBox[{"-", "1.0"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"tmp", "=", 
  RowBox[{
   RowBox[{"resultT", "[", 
    RowBox[{"[", "10", "]"}], "]"}], "/.", 
   "tmpData"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "t1", "+", "t2", "+", "t3", "+", "t4", "+", "t5", "+", "t6", "+", "t7"}], "/.",
   "tmp"}]}], "Input",
 CellChangeTimes->{{3.817628868625602*^9, 3.817628918025359*^9}, {
  3.817628948475369*^9, 3.817628952074409*^9}, {3.8176291487769613`*^9, 
  3.817629204826724*^9}, {3.817629418857974*^9, 3.817629418944375*^9}, {
  3.817629814321773*^9, 3.817629882142076*^9}, {3.817629937474257*^9, 
  3.81762995982032*^9}, {3.817630093056933*^9, 3.8176302846866693`*^9}, {
  3.8176303368336554`*^9, 3.817630500333248*^9}, {3.817630532955221*^9, 
  3.817630534820991*^9}, {3.817630866367572*^9, 3.817630892543679*^9}, {
  3.8176401628006353`*^9, 3.817640175272009*^9}, {3.817640319973881*^9, 
  3.817640321634637*^9}, {3.817640356332087*^9, 3.817640413113693*^9}, {
  3.8176407987176323`*^9, 3.817640897721925*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"bbf1a9de-0221-4992-b9c6-d1f769287d62"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t1", "\[Rule]", 
      RowBox[{"-", "3.000078051472521`"}]}], ",", 
     RowBox[{"t2", "\[Rule]", "0"}], ",", 
     RowBox[{"t3", "\[Rule]", 
      RowBox[{"-", "3.1000780514725212`"}]}], ",", 
     RowBox[{"t4", "\[Rule]", "0"}], ",", 
     RowBox[{"t5", "\[Rule]", 
      RowBox[{"-", "2.967403566288493`"}]}], ",", 
     RowBox[{"t6", "\[Rule]", "0"}], ",", 
     RowBox[{"t7", "\[Rule]", 
      RowBox[{"-", "2.9674035662884917`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t1", "\[Rule]", "1.2653161258674266`"}], ",", 
     RowBox[{"t2", "\[Rule]", "0"}], ",", 
     RowBox[{"t3", "\[Rule]", "1.1653161258674265`"}], ",", 
     RowBox[{"t4", "\[Rule]", "0"}], ",", 
     RowBox[{"t5", "\[Rule]", "0.7436139275233279`"}], ",", 
     RowBox[{"t6", "\[Rule]", "0"}], ",", 
     RowBox[{"t7", "\[Rule]", "0.7436139275233278`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t1", "\[Rule]", "2.269630566608486`"}], ",", 
     RowBox[{"t2", "\[Rule]", "0"}], ",", 
     RowBox[{"t3", "\[Rule]", "2.169630566608486`"}], ",", 
     RowBox[{"t4", "\[Rule]", "0"}], ",", 
     RowBox[{"t5", "\[Rule]", "1.9754231940427`"}], ",", 
     RowBox[{"t6", "\[Rule]", "0"}], ",", 
     RowBox[{"t7", "\[Rule]", "1.9754231940427`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t1", "\[Rule]", "29.92641500288895`"}], ",", 
     RowBox[{"t2", "\[Rule]", "0"}], ",", 
     RowBox[{"t3", "\[Rule]", "29.82641500288895`"}], ",", 
     RowBox[{"t4", "\[Rule]", "0"}], ",", 
     RowBox[{"t5", "\[Rule]", 
      RowBox[{"-", "29.812917199169515`"}]}], ",", 
     RowBox[{"t6", "\[Rule]", "0"}], ",", 
     RowBox[{"t7", "\[Rule]", 
      RowBox[{"-", "29.8129171991696`"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.81762887322018*^9, 3.8176289522859573`*^9}, {
   3.817629144469183*^9, 3.8176292052480793`*^9}, 3.817629419378545*^9, {
   3.817629824717011*^9, 3.817629882642803*^9}, {3.817629932753271*^9, 
   3.817629960221161*^9}, {3.817630093843822*^9, 3.8176302850623083`*^9}, {
   3.8176303374042883`*^9, 3.817630535828087*^9}, {3.817630868464644*^9, 
   3.817630892873412*^9}, {3.81764016451027*^9, 3.8176401760537167`*^9}, 
   3.8176403225928097`*^9, {3.817640357057991*^9, 3.817640414142352*^9}, {
   3.817640804181323*^9, 3.8176408985731688`*^9}},
 CellLabel->"Out[75]=",ExpressionUUID->"105051c1-dd97-49a1-a1ea-1856a027794e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "12.034963235522028`"}], ",", "3.9178601067815086`", ",", 
   "8.390107521302372`", ",", "0.12699560743878635`"}], "}"}]], "Output",
 CellChangeTimes->{{3.81762887322018*^9, 3.8176289522859573`*^9}, {
   3.817629144469183*^9, 3.8176292052480793`*^9}, 3.817629419378545*^9, {
   3.817629824717011*^9, 3.817629882642803*^9}, {3.817629932753271*^9, 
   3.817629960221161*^9}, {3.817630093843822*^9, 3.8176302850623083`*^9}, {
   3.8176303374042883`*^9, 3.817630535828087*^9}, {3.817630868464644*^9, 
   3.817630892873412*^9}, {3.81764016451027*^9, 3.8176401760537167`*^9}, 
   3.8176403225928097`*^9, {3.817640357057991*^9, 3.817640414142352*^9}, {
   3.817640804181323*^9, 3.817640898574758*^9}},
 CellLabel->"Out[76]=",ExpressionUUID->"ee561e7d-9711-4560-80d9-d30648c0977e"]
}, Open  ]]
},
WindowSize->{918, 888},
WindowMargins->{{443, Automatic}, {54, Automatic}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"c8b287f8-8b4a-4e98-ab1e-df7dcd999be5"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 206, 4, 35, "Text",ExpressionUUID->"f0efc888-777d-4c66-b8e6-2db88daacc31"],
Cell[767, 26, 6936, 215, 812, "Input",ExpressionUUID->"d346b209-9dd3-47cf-8f1e-f04bc3bf980a"],
Cell[7706, 243, 8130, 195, 430, "Input",ExpressionUUID->"ccba75f7-892e-4119-93ec-41811b2e330e"],
Cell[15839, 440, 1694, 30, 311, "Text",ExpressionUUID->"e82cb2e9-b4f4-4bc2-9a74-547157d3c4dc"],
Cell[17536, 472, 249, 7, 58, "Text",ExpressionUUID->"2bb13fa1-f9ef-4a5d-ac3b-101e020ad421"],
Cell[17788, 481, 1394, 35, 115, "Input",ExpressionUUID->"f20278fb-5b15-4c9c-bd38-9f1d3931e2f3"],
Cell[19185, 518, 166, 3, 35, "Text",ExpressionUUID->"8d7af2fe-a47e-4ef4-b28a-db0dc764dd0f"],
Cell[CellGroupData[{
Cell[19376, 525, 2231, 51, 159, "Input",ExpressionUUID->"ca8158ca-2cc6-4c2b-92b0-ae9728cb14cd"],
Cell[21610, 578, 2428, 59, 79, "Output",ExpressionUUID->"0a94f786-574e-4852-9434-e6c9207268ec"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24075, 642, 1425, 28, 94, "Input",ExpressionUUID->"02ddacce-ea40-40b5-bbc9-e4e0e8a8500b"],
Cell[25503, 672, 990, 16, 54, "Output",ExpressionUUID->"cd5c1068-df37-4f84-8783-2e31418f59b2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26530, 693, 1671, 37, 94, "Input",ExpressionUUID->"bbf1a9de-0221-4992-b9c6-d1f769287d62"],
Cell[28204, 732, 2462, 53, 98, "Output",ExpressionUUID->"105051c1-dd97-49a1-a1ea-1856a027794e"],
Cell[30669, 787, 829, 13, 34, "Output",ExpressionUUID->"ee561e7d-9711-4560-80d9-d30648c0977e"]
}, Open  ]]
}
]
*)

