/** **************************************************************************************
 * @file       adc_dump_save_example.c
 * @ingroup    Toposens Sensor Library
 * @copyright  Copyright (c) Toposens GmbH 2021. All rights reserved.
 ******************************************************************************************/

#include <stdio.h>
#include "example_common.h"
#include "toposens/sensor_lib.h"

static void RequestADCDumpCallback(uint16_t SenderId_u16, uint32_t DataSize_u32);
static void ADCDumpEndCallback(uint16_t SenderId_u16);
static void LogMsgCallback(uint16_t SenderId_u16, uint8_t* ReceivedPayload_pu8);

static void ADCDumpExample(char* filename)
{
  printf("-----------------ADCDumpExample-----------------\n");
  RequestADCDump();
  printf("-----------------SetParameterSystemSensorMode-----------------\n");
  SetParameterSystemSensorMode(SENSOR_MODE_SINGLE_SHOT_TRANSMIT_LISTEN);
  printf("-----------------RequestMeasurement-----------------\n");
  RequestMeasurement();
  printf("-----------------WaitForSessionEnd(adc session)-----------------\n");
  uint16_t sender_u16 = WaitForADCSessionEnd();
  ADCDump_t* DumpData_t = GetADCDumpData(sender_u16);

  if (DumpData_t != NULL)
  {
    SaveADCBlobData(DumpData_t, filename);
  }

  printf("-----------------WaitForSessionEnd (point session)-----------------\n");
  sender_u16 = WaitForSessionEnd();
  Sensor_Session_t* session_data = GetSessionData(sender_u16);
  PrintSessionData(session_data);
  printf("-----------------ADCDumpExample Complete-----------------\n");
}

int main(int argc, char** argv)
{
  if (argc < 2)
  {
    fprintf(stderr, "Pass filename as first argument.\n");
    return -1;
  }
  RegisterADCDumpStartRequestCallback(RequestADCDumpCallback);
  RegisterADCDumpSessionEndCallback(ADCDumpEndCallback);
  RegisterLogMsgCallback(LogMsgCallback);

  InitInterface("can0", 1000000, IF_CAN);
  RequestReboot();
  WaitForReady();

  Sensor_t* Sensors = GetKnownSensors();
  uint8_t NumberOfSensors = GetNumberOfKnownSensors();
  printf("NumberOfSensors:%d\n", NumberOfSensors);
  for (int i = 0; i < NumberOfSensors; i++)
  {
    printf("%d Sensor on Bus: %d\n", i, Sensors[i].InterfaceSensorId_u16);
  }

  ADCDumpExample(argv[1]);
  DeinitInterface(IF_CAN);
  return 0;
}

static void ADCDumpEndCallback(uint16_t SenderId_u16)
{
  printf("Got ADC Dump End Callback from Sender:%d\n", SenderId_u16);
}

static void RequestADCDumpCallback(uint16_t SenderId_u16, uint32_t DataSize_u32)
{
  printf("Got ADC-Dump Request Sender:%d\n", SenderId_u16);
  printf("Got ADC-Dump Request Size:%d\n", DataSize_u32);
}

static void LogMsgCallback(uint16_t SenderId_u16, uint8_t* ReceivedPayload_pu8)
{
  PrintLogMessage(SenderId_u16, ReceivedPayload_pu8);
}
