# Set abort condition
set -e
# Remove old builds
rm -rf ./build/ || echo "unable to delete build-folder" | exit
# Create folder for build
mkdir ./build/ || echo "unable to create build-folder" | exit
# Change directory
cd ./build/ || echo "unable to change directory" | exit
# Run CMake including path for system-wide install instead of /usr/local
cmake ../toposens_sensor_library || echo "cmake failed" | exit
# Run make
make || echo "make failed" | exit
# Install the library
sudo make install || echo "make install failed" | exit
