# toposens_pointcloud

This package provides basic *TF* and *PCL* integrations for Toposens `TsScan` data.
It provides the topic `/ts_cloud` based on data from `/ts_scans`.

It was developed and tested for ROS Melodic on Ubuntu 18.04 (Bionic) and ROS Kinetic on Ubuntu 16.04 (Xenial) using Toposens TS3 ultrasonic sensor.

## Overview

* Maps `TsPoint`s of incoming `TsScan` structure (received on the topic defined by `scans_topic` parameter, typically `/ts_scans`) to the `target_frame` (which is a parameter as well), utilizing subscribed tf
* Publishes converted point cloud as `pcl::PointCloud` on the topic `/ts_cloud`
* Optionally publishes markers to visualize the normal vectors of points, if `lifetime_normals_vis` parameter is set
* Optionally saves point cloud data to file, if `pcd_save_interval` parameter is set
* When using `toposens_online_filtering`, then set parameter `scans_topic` to `ts_scans_filtered`

## Usage

### Build

Find information on how to build the package in the README of the `toposens` metapackage.

### Enable Serial Port Permissions

Find information on how to setup the serial port permissions in the README of the `toposens_driver` package.

### Run

The driver node as well as the pointcloud node are launched from within one launch-file:

```bash
roslaunch toposens_pointcloud pointcloud.launch port:=/dev/ttyUSB0
```

### Configuration

Configuration is done via launch file parameters.

| Parameter Name | Description |
| --- | --- |
| `scans_topic` | Topic name to look for TsScan messages |
| `target_frame` | Target frame for scan transformations |
| `pcd_path` | TODO: not used anymore? Should specify the path to store pcd file |
| `pcd_save_interval` | Interval in which pcd file is stored |
| `lifetime_normals_vis` | Lifetime for visualization of normals |
