#ifndef TOPO_ISOTP_H
#define TOPO_ISOTP_H

#include <stdbool.h>
#include <stdint.h>

#include "toposens/errors.h"

TopoError_t
topo_isotp_init(void* context);

TopoError_t
topo_isotp_send(uint8_t *buffer, uint16_t size);

TopoError_t
topo_isotp_receive(uint8_t *buffer, uint16_t size, uint16_t* actual_size);

TopoError_t
topo_isotp_poll();

bool
topo_isotp_is_cantp_frame(uint8_t *buffer, uint16_t size);

TopoError_t
topo_isotp_frame_received(uint8_t *buffer, uint16_t size);

#endif
