/** **************************************************************************************
 * @file       message_flags.c
 * @ingroup    Toposens Sensor Library
 * @copyright  Copyright (c) Toposens GmbH 2021. All rights reserved.
 * @brief      Contains strings used to identify messages on linux systems
 ******************************************************************************************/

#include <stdint.h>

#ifdef __linux__
// Strings for message_flags.h
const char* const kActionCommands[] = {"Perform Reboot",
                                       "Perform Measurement",
                                       "Perform Factory Reset",
                                       "Store Settings",
                                       "Load Settings",
                                       "Perform ADC Dump"};

const char* const kVersionStrings[] = {"Bootloader Version",
                                       "Application Version",
                                       "Hardware Version",
                                       "Signal Processing Library Version",
                                       "Communication Library Version"};

const char* const kFirmwareUploadActionStrings[] = {"Init FW Upload", "App Packet", "Complete Update"};

const char* const kACKStatusStrings[] = {"successfully acknowledged",
                                         "negatively acknowledged (Parameter out of range)",
                                         "negatively acknowledged (Invalid operation)",
                                         "negatively acknowledged (Falling back to default)"};

// Strings for custom_types.h
const char* const kLogLevelStrings[] = {"DEBUG", "INFO", "WARN", "ERROR"};

const char* const kSensorModelStrings[] = {"MODEL_BRAVO_DEV_PLATFORM", "MODEL_BRAVO_DEV_KIT"};

const char* const kRecordTypeStrings[] = {"RECORD_DATA",
                                          "RECORD_EOF",
                                          "RECORD_EXTEN_SEG_ADD",
                                          "RECORD_START_SEG_ADD",
                                          "RECORD_EXTEN_LIN_ADD",
                                          "RECORD_START_LIN_ADD"};

const char* const kSensorModeStrings[] = {"SENSOR_MODE_CONTINUOUS_TRANSMIT_LISTEN",
                                          "SENSOR_MODE_SINGLE_SHOT_TRANSMIT_LISTEN",
                                          "SENSOR_MODE_SINGLE_SHOT_TRANSMIT",
                                          "SENSOR_MODE_SINGLE_SHOT_LISTEN",
                                          "SENSOR_MODE_IDLE",
                                          "SENSOR_MODE_SIG_PRO_CALIBRATION",
                                          "SENSOR_MODE_SELF_CHECK",
                                          "SENSOR_MODE_CONTINUOUS_TRANSMIT_LISTEN_FIXED",
                                          "SENSOR_MODE_SIG_PRO_CALIB_NEARFIELD"};

const char* const kSensorStateStrings[] = {
    // Bootloader states
    "STATE_BL_WAIT_FOR_INIT",
    "STATE_BL_RX_APP",
    "STATE_BL_PROCESSING_APP",
    "STATE_BL_FLASH_APP",
    "STATE_BL_RDY_TO_LAUNCH",
    "STATE_BL_LAUNCHING_APP",

    // App states
    "STATE_APP_IDLE",
    "STATE_APP_NOISE_SAMPLE",
    "STATE_APP_WAIT_FOR_NOISE_SAMPLING",
    "STATE_APP_TRANSDUCE_AND_SAMPLE",
    "STATE_APP_TRANSMIT",
    "STATE_APP_SAMPLE",
    "STATE_APP_WAIT_FOR_SAMPLING",
    "STATE_APP_CALIBRATION",
    "STATE_APP_CALCULATE_POINTS",
    "STATE_APP_OUTPUT_POINTS",
    "STATE_APP_WAITING_FOR_POINT_SESSION_END",
    "STATE_APP_OUTPUT_ADC_SIGNALS",
    "STATE_APP_WAITING_FOR_ADC_DUMP_SESSION_END",
    "STATE_APP_PROCESS_LONG_SELF_CHECK"};

const char* const kCommsInterfaceStrings[] = {
    "CAN",
    "Service Port",
    "USB",
};

const char* const kResetReasonStrings[] = {
    "RESET_REASON_UNKNOWN",
    "RESET_REASON_LOW_POWER_RESET",
    "RESET_REASON_WINDOW_WATCHDOG_RESET",
    "RESET_REASON_INDEPENDENT_WATCHDOG_RESET",
    "RESET_REASON_SOFTWARE_RESET",
    "RESET_REASON_POWER_ON_POWER_DOWN_RESET",
    "RESET_REASON_EXTERNAL_RESET_PIN_RESET",
    "RESET_REASON_BROWNOUT_RESET",
};

#endif /* __linux__ */
