package STREAMSTYPESHelper;

# ************************************************************
# Description   : Command helper for OSPL idlpp generated 'streams' files. Required
#                 because of our unusual output file naming conventions.
#
#                 The command helper factory get() method converts the define
#                 custom type provided to uppercase, removes the '_FILES' portion
#                 and adds 'Helper' to the end.  If a module is found matching
#                 that name, it will be used to assist the ProjectCreator
#                 in determining which output files will be generated by
#                 the command given the file name and command options.
#                 This therefore is the helper for the OpenSplice
#                 Typesupport_Files entries in .mpc files.
# $Id:$
# ************************************************************

use strict;
use File::Basename;

# RedHat EL 4/5 uses perl 5.8.x/Getopt::Long v2.34/5
# Redhat EL 6 uses perl 5.10/Getopt::Long >= v2.36 which is
# earliest GetOptionsFromString is available...
#use Getopt::Long qw(GetOptionsFromString);
use Getopt::Long;

Getopt::Long::Configure ("bundling_override");
Getopt::Long::Configure ("pass_through");

my %required;
my %notfound;
my $dcps_types_helper;

# ... (see above) so we have to roll our own 'GetOptionsFromString'
sub _GetOptionsFromString(@) {
    my ($string) = shift;
    require Text::ParseWords;
    my @temp=@ARGV;
    @ARGV = Text::ParseWords::shellwords($string);
    my $ret = GetOptions(@_);
    my @args=@ARGV;
    @ARGV=@temp;
    return ( $ret, \@args );
}

sub new {
  my $class = shift;
  return bless {}, $class;
}

sub get_output {
  ## This method is called with the filename and command options and
  ## expects an array reference containing filenames that will be
  ## generated, but can not be described using the normal Define_Custom
  ## syntax.
  my ($self, $types_idl_file, $idlpp_args)  = @_;
  # print "typesupport helper called for $types_idl_file, $idlpp_args\n";
  my $base;
  my @filenames;

  ## Streams IDL produces everything that DCPS does to start with...
  require "TYPESUPPORTHelper.pm";
  $dcps_types_helper = TYPESUPPORTHelper->new() unless defined $dcps_types_helper;
  push @filenames, @{$dcps_types_helper->get_output($types_idl_file, $idlpp_args)};

  ## Remove file name extension
  $types_idl_file =~ s/\.[^\.]+$//;

  ## Correctly deal with pre filename and directories if they exist
  if ($types_idl_file =~ /(.*[\/\\])([^\/\\]+)$/) {
      ## Split the directory and base name of the file.
      $base = $2;
  }
  else {
      $base = $types_idl_file;
  }

  ## ... and some more...
  my $language = '';
  my $standalone = '';
  my $output_dir = '';
  my $is_streams = '';
  my $left_over_args;
  my $ret;
  ($ret, $left_over_args) = _GetOptionsFromString($idlpp_args,
                              'S' => \$standalone,
                              'C' => sub { $standalone = 0 },
                              'd=s' => \$output_dir,
                              'l=s' => \$language);

  if ($output_dir ne '' && $output_dir !~ /\/$/ )
  {
    $output_dir = "$output_dir/";
  }

  if (($language eq 'cpp') || ($language eq 'c++'))
  {
    push @filenames, "$output_dir$base" . 'Streams_impl.cpp';
    push @filenames, "$output_dir$base" . 'Streams_impl.h';
    push @filenames, "$output_dir$base" . 'StreamsApi.h';
    my $streams_idl_file = "$output_dir$base" . 'Streams.idl';
    push @filenames, $streams_idl_file;
    # This is in the post for when we process the Streams.idl under the covers
    # push @filenames, @{$self->get_output($streams_idl_file, "-l $language $psm_arg -d $output_dir")};
  }
  elsif($language eq 'isocpp')
  {
    push @filenames, "$output_dir$base" . 'StreamsApi.h';
    my $streams_idl_file = "$output_dir$base" . 'Streams.idl';
    push @filenames, $streams_idl_file;
    # This is in the post for when we process the Streams.idl under the covers
    # push @filenames, @{$self->get_output($streams_idl_file, "-l $language $psm_arg -d $output_dir")};
  }
  else
  {
    if ($language eq 'c')
    {
       ## @todo as and when required
    }
    else
    {
        if ($language eq 'cs')
        {
          ## @todo as and when required
        }
    }
  }
  return \@filenames;
}

sub get_outputexts {
  ## This method is expected to return an array reference containing the
  ## extensions for files returned by the get_output() method.  They will
  ## be used as regular expressions so regular expression characters
  ## (such as '.', '[', ']', etc.) must be escaped.  This can be done by
  ## calling $self->Parser::escape_regex_special($str);
  my $self = shift;
  my @exts = ($self->Parser::escape_regex_special(".cpp"),
           $self->Parser::escape_regex_special(".h"),
           $self->Parser::escape_regex_special(".hpp"),
           #$self->Parser::escape_regex_special(".cs"),
            $self->Parser::escape_regex_special(".idl"));
  return \@exts;
}

sub get_tied {
  ## This method is called with a file name and an array reference of
  ## files.  The first expected return value is an array reference of those
  ## files listed in the passed array reference that are in some way tied
  ## to the file name passed in.  The second is a component name to help
  ## MPC figure out a way to tie the files together.  The result of "tied"
  ## files is that they may be compiled after the file name passed in.
  return [], undef;
}

1;
