// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file SecurityPluginFactory.cpp
 */

#include "SecurityPluginFactory.h"
#include "../../security/authentication/PKIDH.h"
#include "../../security/cryptography/AESGCMGMAC.h"

using namespace eprosima::fastrtps::rtps;
using namespace ::security;

Authentication* SecurityPluginFactory::create_authentication_plugin(const PropertyPolicy& property_policy)
{
    Authentication* plugin = nullptr;
    const std::string* auth_plugin_property = PropertyPolicyHelper::find_property(property_policy, "dds.sec.auth.plugin");

    if(auth_plugin_property != nullptr)
    {
        if(auth_plugin_property->compare("builtin.PKI-DH") == 0)
        {
            plugin = new PKIDH();
        }
    }

    return plugin;
}

Cryptography* SecurityPluginFactory::create_cryptography_plugin(const PropertyPolicy& property_policy)
{
    Cryptography* plugin = nullptr;
    const std::string* crypto_plugin_property = PropertyPolicyHelper::find_property(property_policy, "dds.sec.crypto.plugin");

    if(crypto_plugin_property != nullptr)
    {
        // Check it is builtin DDS:Auth:PKI-DH.
        if(crypto_plugin_property->compare("builtin.AES-GCM-GMAC") == 0)
        {
            plugin = new AESGCMGMAC();
        }
    }

    return plugin;
}
