// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @file HelloWorldPublisher.h
 *
 */

#ifndef HELLOWORLDPUBLISHER_H_
#define HELLOWORLDPUBLISHER_H_

#include "HelloWorldType.h"

#include "fastrtps/fastrtps_fwd.h"
#include "fastrtps/attributes/PublisherAttributes.h"
#include "fastrtps/publisher/PublisherListener.h"
using namespace eprosima::fastrtps;

#include "HelloWorld.h"

class HelloWorldPublisher {
public:
	HelloWorldPublisher();
	virtual ~HelloWorldPublisher();
	//!Initialize
	bool init();
	//!Publish a sample
	bool publish();
	//!Run for number samples
	void run(uint32_t number);
private:
	HelloWorld m_Hello;
	Participant* mp_participant;
	Publisher* mp_publisher;
	class PubListener:public PublisherListener
	{
	public:
		PubListener():n_matched(0){};
		~PubListener(){};
		void onPublicationMatched(Publisher* pub,MatchingInfo& info);
		int n_matched;
	}m_listener;
	HelloWorldType m_type;
};



#endif /* HELLOWORLDPUBLISHER_H_ */
